#include "cstring"
#include "Python.h"
#include "python3adapt.h"
#include "capsulethunk.h"
#include "llvm_binding/conversion.h"
#include "llvm_binding/binding.h"
#include "llvm_binding/capsule_context.h"
#include "llvm_binding/extra.h"

#include "llvm/Support/raw_ostream.h"
#include "llvm/IR/Argument.h"
#include "llvm/Pass.h"
#include "llvm/IR/IRBuilder.h"
#include "llvm/IR/IntrinsicInst.h"
#include "llvm/CodeGen/MachineCodeInfo.h"
#include "llvm/Target/TargetOptions.h"
#include "llvm/ExecutionEngine/ExecutionEngine.h"
#include "llvm/Assembly/Parser.h"
#include "llvm/Target/TargetLibraryInfo.h"
#include "llvm/IR/Module.h"
#include "llvm/PassManager.h"
#include "llvm/Transforms/Utils/Cloning.h"
#include "llvm/ExecutionEngine/JIT.h"
#include "llvm/Support/Dwarf.h"
#include "llvm/Support/FormattedStream.h"
#include "llvm/Support/TargetRegistry.h"
#include "llvm/IR/Function.h"
#include "llvm/IR/InlineAsm.h"
#include "llvm/Target/TargetMachine.h"
#include "llvm/Transforms/IPO.h"
#include "llvm/Bitcode/ReaderWriter.h"
#include "llvm/IR/Type.h"
#include "llvm/PassSupport.h"
#include "llvm/Support/CommandLine.h"
#include "llvm/IR/GlobalValue.h"
#include "llvm/DIBuilder.h"
#include "llvm/PassRegistry.h"
#include "llvm/Transforms/Utils/BasicBlockUtils.h"
#include "llvm/Analysis/Verifier.h"
#include "llvm/IR/DerivedTypes.h"
#include "llvm/DebugInfo.h"
#include "llvm/Support/SourceMgr.h"
#include "llvm/Analysis/TargetTransformInfo.h"
#include "llvm/Support/DynamicLibrary.h"
#include "llvm/Transforms/IPO/PassManagerBuilder.h"
#include "llvm/IR/ValueSymbolTable.h"
#include "llvm/ADT/Triple.h"
#include "llvm/IR/DataLayout.h"
#include "llvm/ADT/StringRef.h"
#include "llvm/IR/Attributes.h"
#include "llvm/Support/TargetSelect.h"
#include "llvm/Assembly/AssemblyAnnotationWriter.h"
#include "llvm/Support/raw_os_ostream.h"
#include "llvm/Linker.h"
#include "llvm/IR/LLVMContext.h"


static
llvm::Argument* downcast_llvm_Value_to_llvm_Argument(llvm::Value* arg)
{
    return typecast< llvm::Argument >::from(arg);
}

static
PyObject*
__downcast__llvm__Value__to__llvm__Argument(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    llvm::Argument* var_llvm_Argument = downcast_llvm_Value_to_llvm_Argument(var_llvm_Value);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Argument), "llvm::Value", "llvm::Argument");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::MDNode* downcast_llvm_Value_to_llvm_MDNode(llvm::Value* arg)
{
    return typecast< llvm::MDNode >::from(arg);
}

static
PyObject*
__downcast__llvm__Value__to__llvm__MDNode(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    llvm::MDNode* var_llvm_MDNode = downcast_llvm_Value_to_llvm_MDNode(var_llvm_Value);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_MDNode), "llvm::Value", "llvm::MDNode");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::MDString* downcast_llvm_Value_to_llvm_MDString(llvm::Value* arg)
{
    return typecast< llvm::MDString >::from(arg);
}

static
PyObject*
__downcast__llvm__Value__to__llvm__MDString(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    llvm::MDString* var_llvm_MDString = downcast_llvm_Value_to_llvm_MDString(var_llvm_Value);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_MDString), "llvm::Value", "llvm::MDString");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::User* downcast_llvm_Value_to_llvm_User(llvm::Value* arg)
{
    return typecast< llvm::User >::from(arg);
}

static
PyObject*
__downcast__llvm__Value__to__llvm__User(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    llvm::User* var_llvm_User = downcast_llvm_Value_to_llvm_User(var_llvm_Value);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_User), "llvm::Value", "llvm::User");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::BasicBlock* downcast_llvm_Value_to_llvm_BasicBlock(llvm::Value* arg)
{
    return typecast< llvm::BasicBlock >::from(arg);
}

static
PyObject*
__downcast__llvm__Value__to__llvm__BasicBlock(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    llvm::BasicBlock* var_llvm_BasicBlock = downcast_llvm_Value_to_llvm_BasicBlock(var_llvm_Value);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_BasicBlock), "llvm::Value", "llvm::BasicBlock");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::Constant* downcast_llvm_Value_to_llvm_Constant(llvm::Value* arg)
{
    return typecast< llvm::Constant >::from(arg);
}

static
PyObject*
__downcast__llvm__Value__to__llvm__Constant(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    llvm::Constant* var_llvm_Constant = downcast_llvm_Value_to_llvm_Constant(var_llvm_Value);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant), "llvm::Value", "llvm::Constant");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::Constant* downcast_llvm_User_to_llvm_Constant(llvm::User* arg)
{
    return typecast< llvm::Constant >::from(arg);
}

static
PyObject*
__downcast__llvm__User__to__llvm__Constant(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::User* var_llvm_User = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::User* var_llvm_User1 = unwrap_as<llvm::User, llvm::Value >::from(var_void);
        if(!var_llvm_User1)
        {
            return NULL;
        }
        var_llvm_User = var_llvm_User1;
    }
    llvm::Constant* var_llvm_Constant = downcast_llvm_User_to_llvm_Constant(var_llvm_User);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant), "llvm::Value", "llvm::Constant");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::Function* downcast_llvm_Value_to_llvm_Function(llvm::Value* arg)
{
    return typecast< llvm::Function >::from(arg);
}

static
PyObject*
__downcast__llvm__Value__to__llvm__Function(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    llvm::Function* var_llvm_Function = downcast_llvm_Value_to_llvm_Function(var_llvm_Value);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Function), "llvm::Value", "llvm::Function");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::Function* downcast_llvm_GlobalValue_to_llvm_Function(llvm::GlobalValue* arg)
{
    return typecast< llvm::Function >::from(arg);
}

static
PyObject*
__downcast__llvm__GlobalValue__to__llvm__Function(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::GlobalValue* var_llvm_GlobalValue = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::GlobalValue* var_llvm_GlobalValue1 = unwrap_as<llvm::GlobalValue, llvm::Value >::from(var_void);
        if(!var_llvm_GlobalValue1)
        {
            return NULL;
        }
        var_llvm_GlobalValue = var_llvm_GlobalValue1;
    }
    llvm::Function* var_llvm_Function = downcast_llvm_GlobalValue_to_llvm_Function(var_llvm_GlobalValue);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Function), "llvm::Value", "llvm::Function");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::Function* downcast_llvm_Constant_to_llvm_Function(llvm::Constant* arg)
{
    return typecast< llvm::Function >::from(arg);
}

static
PyObject*
__downcast__llvm__Constant__to__llvm__Function(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Constant* var_llvm_Constant = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant1 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void);
        if(!var_llvm_Constant1)
        {
            return NULL;
        }
        var_llvm_Constant = var_llvm_Constant1;
    }
    llvm::Function* var_llvm_Function = downcast_llvm_Constant_to_llvm_Function(var_llvm_Constant);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Function), "llvm::Value", "llvm::Function");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::ConstantInt* downcast_llvm_Value_to_llvm_ConstantInt(llvm::Value* arg)
{
    return typecast< llvm::ConstantInt >::from(arg);
}

static
PyObject*
__downcast__llvm__Value__to__llvm__ConstantInt(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    llvm::ConstantInt* var_llvm_ConstantInt = downcast_llvm_Value_to_llvm_ConstantInt(var_llvm_Value);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_ConstantInt), "llvm::Value", "llvm::ConstantInt");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::ConstantInt* downcast_llvm_Constant_to_llvm_ConstantInt(llvm::Constant* arg)
{
    return typecast< llvm::ConstantInt >::from(arg);
}

static
PyObject*
__downcast__llvm__Constant__to__llvm__ConstantInt(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Constant* var_llvm_Constant = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant1 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void);
        if(!var_llvm_Constant1)
        {
            return NULL;
        }
        var_llvm_Constant = var_llvm_Constant1;
    }
    llvm::ConstantInt* var_llvm_ConstantInt = downcast_llvm_Constant_to_llvm_ConstantInt(var_llvm_Constant);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_ConstantInt), "llvm::Value", "llvm::ConstantInt");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::ConstantInt* downcast_llvm_User_to_llvm_ConstantInt(llvm::User* arg)
{
    return typecast< llvm::ConstantInt >::from(arg);
}

static
PyObject*
__downcast__llvm__User__to__llvm__ConstantInt(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::User* var_llvm_User = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::User* var_llvm_User1 = unwrap_as<llvm::User, llvm::Value >::from(var_void);
        if(!var_llvm_User1)
        {
            return NULL;
        }
        var_llvm_User = var_llvm_User1;
    }
    llvm::ConstantInt* var_llvm_ConstantInt = downcast_llvm_User_to_llvm_ConstantInt(var_llvm_User);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_ConstantInt), "llvm::Value", "llvm::ConstantInt");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::ConstantFP* downcast_llvm_Value_to_llvm_ConstantFP(llvm::Value* arg)
{
    return typecast< llvm::ConstantFP >::from(arg);
}

static
PyObject*
__downcast__llvm__Value__to__llvm__ConstantFP(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    llvm::ConstantFP* var_llvm_ConstantFP = downcast_llvm_Value_to_llvm_ConstantFP(var_llvm_Value);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_ConstantFP), "llvm::Value", "llvm::ConstantFP");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::ConstantFP* downcast_llvm_Constant_to_llvm_ConstantFP(llvm::Constant* arg)
{
    return typecast< llvm::ConstantFP >::from(arg);
}

static
PyObject*
__downcast__llvm__Constant__to__llvm__ConstantFP(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Constant* var_llvm_Constant = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant1 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void);
        if(!var_llvm_Constant1)
        {
            return NULL;
        }
        var_llvm_Constant = var_llvm_Constant1;
    }
    llvm::ConstantFP* var_llvm_ConstantFP = downcast_llvm_Constant_to_llvm_ConstantFP(var_llvm_Constant);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_ConstantFP), "llvm::Value", "llvm::ConstantFP");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::ConstantFP* downcast_llvm_User_to_llvm_ConstantFP(llvm::User* arg)
{
    return typecast< llvm::ConstantFP >::from(arg);
}

static
PyObject*
__downcast__llvm__User__to__llvm__ConstantFP(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::User* var_llvm_User = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::User* var_llvm_User1 = unwrap_as<llvm::User, llvm::Value >::from(var_void);
        if(!var_llvm_User1)
        {
            return NULL;
        }
        var_llvm_User = var_llvm_User1;
    }
    llvm::ConstantFP* var_llvm_ConstantFP = downcast_llvm_User_to_llvm_ConstantFP(var_llvm_User);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_ConstantFP), "llvm::Value", "llvm::ConstantFP");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::ConstantArray* downcast_llvm_Value_to_llvm_ConstantArray(llvm::Value* arg)
{
    return typecast< llvm::ConstantArray >::from(arg);
}

static
PyObject*
__downcast__llvm__Value__to__llvm__ConstantArray(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    llvm::ConstantArray* var_llvm_ConstantArray = downcast_llvm_Value_to_llvm_ConstantArray(var_llvm_Value);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_ConstantArray), "llvm::Value", "llvm::ConstantArray");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::ConstantArray* downcast_llvm_Constant_to_llvm_ConstantArray(llvm::Constant* arg)
{
    return typecast< llvm::ConstantArray >::from(arg);
}

static
PyObject*
__downcast__llvm__Constant__to__llvm__ConstantArray(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Constant* var_llvm_Constant = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant1 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void);
        if(!var_llvm_Constant1)
        {
            return NULL;
        }
        var_llvm_Constant = var_llvm_Constant1;
    }
    llvm::ConstantArray* var_llvm_ConstantArray = downcast_llvm_Constant_to_llvm_ConstantArray(var_llvm_Constant);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_ConstantArray), "llvm::Value", "llvm::ConstantArray");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::ConstantArray* downcast_llvm_User_to_llvm_ConstantArray(llvm::User* arg)
{
    return typecast< llvm::ConstantArray >::from(arg);
}

static
PyObject*
__downcast__llvm__User__to__llvm__ConstantArray(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::User* var_llvm_User = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::User* var_llvm_User1 = unwrap_as<llvm::User, llvm::Value >::from(var_void);
        if(!var_llvm_User1)
        {
            return NULL;
        }
        var_llvm_User = var_llvm_User1;
    }
    llvm::ConstantArray* var_llvm_ConstantArray = downcast_llvm_User_to_llvm_ConstantArray(var_llvm_User);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_ConstantArray), "llvm::Value", "llvm::ConstantArray");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::ConstantStruct* downcast_llvm_Value_to_llvm_ConstantStruct(llvm::Value* arg)
{
    return typecast< llvm::ConstantStruct >::from(arg);
}

static
PyObject*
__downcast__llvm__Value__to__llvm__ConstantStruct(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    llvm::ConstantStruct* var_llvm_ConstantStruct = downcast_llvm_Value_to_llvm_ConstantStruct(var_llvm_Value);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_ConstantStruct), "llvm::Value", "llvm::ConstantStruct");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::ConstantStruct* downcast_llvm_Constant_to_llvm_ConstantStruct(llvm::Constant* arg)
{
    return typecast< llvm::ConstantStruct >::from(arg);
}

static
PyObject*
__downcast__llvm__Constant__to__llvm__ConstantStruct(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Constant* var_llvm_Constant = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant1 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void);
        if(!var_llvm_Constant1)
        {
            return NULL;
        }
        var_llvm_Constant = var_llvm_Constant1;
    }
    llvm::ConstantStruct* var_llvm_ConstantStruct = downcast_llvm_Constant_to_llvm_ConstantStruct(var_llvm_Constant);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_ConstantStruct), "llvm::Value", "llvm::ConstantStruct");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::ConstantStruct* downcast_llvm_User_to_llvm_ConstantStruct(llvm::User* arg)
{
    return typecast< llvm::ConstantStruct >::from(arg);
}

static
PyObject*
__downcast__llvm__User__to__llvm__ConstantStruct(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::User* var_llvm_User = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::User* var_llvm_User1 = unwrap_as<llvm::User, llvm::Value >::from(var_void);
        if(!var_llvm_User1)
        {
            return NULL;
        }
        var_llvm_User = var_llvm_User1;
    }
    llvm::ConstantStruct* var_llvm_ConstantStruct = downcast_llvm_User_to_llvm_ConstantStruct(var_llvm_User);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_ConstantStruct), "llvm::Value", "llvm::ConstantStruct");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::ConstantVector* downcast_llvm_Value_to_llvm_ConstantVector(llvm::Value* arg)
{
    return typecast< llvm::ConstantVector >::from(arg);
}

static
PyObject*
__downcast__llvm__Value__to__llvm__ConstantVector(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    llvm::ConstantVector* var_llvm_ConstantVector = downcast_llvm_Value_to_llvm_ConstantVector(var_llvm_Value);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_ConstantVector), "llvm::Value", "llvm::ConstantVector");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::ConstantVector* downcast_llvm_Constant_to_llvm_ConstantVector(llvm::Constant* arg)
{
    return typecast< llvm::ConstantVector >::from(arg);
}

static
PyObject*
__downcast__llvm__Constant__to__llvm__ConstantVector(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Constant* var_llvm_Constant = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant1 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void);
        if(!var_llvm_Constant1)
        {
            return NULL;
        }
        var_llvm_Constant = var_llvm_Constant1;
    }
    llvm::ConstantVector* var_llvm_ConstantVector = downcast_llvm_Constant_to_llvm_ConstantVector(var_llvm_Constant);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_ConstantVector), "llvm::Value", "llvm::ConstantVector");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::ConstantVector* downcast_llvm_User_to_llvm_ConstantVector(llvm::User* arg)
{
    return typecast< llvm::ConstantVector >::from(arg);
}

static
PyObject*
__downcast__llvm__User__to__llvm__ConstantVector(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::User* var_llvm_User = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::User* var_llvm_User1 = unwrap_as<llvm::User, llvm::Value >::from(var_void);
        if(!var_llvm_User1)
        {
            return NULL;
        }
        var_llvm_User = var_llvm_User1;
    }
    llvm::ConstantVector* var_llvm_ConstantVector = downcast_llvm_User_to_llvm_ConstantVector(var_llvm_User);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_ConstantVector), "llvm::Value", "llvm::ConstantVector");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::ConstantDataSequential* downcast_llvm_Value_to_llvm_ConstantDataSequential(llvm::Value* arg)
{
    return typecast< llvm::ConstantDataSequential >::from(arg);
}

static
PyObject*
__downcast__llvm__Value__to__llvm__ConstantDataSequential(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    llvm::ConstantDataSequential* var_llvm_ConstantDataSequential = downcast_llvm_Value_to_llvm_ConstantDataSequential(var_llvm_Value);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_ConstantDataSequential), "llvm::Value", "llvm::ConstantDataSequential");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::ConstantDataSequential* downcast_llvm_Constant_to_llvm_ConstantDataSequential(llvm::Constant* arg)
{
    return typecast< llvm::ConstantDataSequential >::from(arg);
}

static
PyObject*
__downcast__llvm__Constant__to__llvm__ConstantDataSequential(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Constant* var_llvm_Constant = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant1 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void);
        if(!var_llvm_Constant1)
        {
            return NULL;
        }
        var_llvm_Constant = var_llvm_Constant1;
    }
    llvm::ConstantDataSequential* var_llvm_ConstantDataSequential = downcast_llvm_Constant_to_llvm_ConstantDataSequential(var_llvm_Constant);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_ConstantDataSequential), "llvm::Value", "llvm::ConstantDataSequential");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::ConstantDataSequential* downcast_llvm_User_to_llvm_ConstantDataSequential(llvm::User* arg)
{
    return typecast< llvm::ConstantDataSequential >::from(arg);
}

static
PyObject*
__downcast__llvm__User__to__llvm__ConstantDataSequential(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::User* var_llvm_User = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::User* var_llvm_User1 = unwrap_as<llvm::User, llvm::Value >::from(var_void);
        if(!var_llvm_User1)
        {
            return NULL;
        }
        var_llvm_User = var_llvm_User1;
    }
    llvm::ConstantDataSequential* var_llvm_ConstantDataSequential = downcast_llvm_User_to_llvm_ConstantDataSequential(var_llvm_User);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_ConstantDataSequential), "llvm::Value", "llvm::ConstantDataSequential");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::ConstantDataArray* downcast_llvm_Value_to_llvm_ConstantDataArray(llvm::Value* arg)
{
    return typecast< llvm::ConstantDataArray >::from(arg);
}

static
PyObject*
__downcast__llvm__Value__to__llvm__ConstantDataArray(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    llvm::ConstantDataArray* var_llvm_ConstantDataArray = downcast_llvm_Value_to_llvm_ConstantDataArray(var_llvm_Value);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_ConstantDataArray), "llvm::Value", "llvm::ConstantDataArray");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::ConstantDataArray* downcast_llvm_Constant_to_llvm_ConstantDataArray(llvm::Constant* arg)
{
    return typecast< llvm::ConstantDataArray >::from(arg);
}

static
PyObject*
__downcast__llvm__Constant__to__llvm__ConstantDataArray(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Constant* var_llvm_Constant = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant1 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void);
        if(!var_llvm_Constant1)
        {
            return NULL;
        }
        var_llvm_Constant = var_llvm_Constant1;
    }
    llvm::ConstantDataArray* var_llvm_ConstantDataArray = downcast_llvm_Constant_to_llvm_ConstantDataArray(var_llvm_Constant);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_ConstantDataArray), "llvm::Value", "llvm::ConstantDataArray");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::ConstantDataArray* downcast_llvm_User_to_llvm_ConstantDataArray(llvm::User* arg)
{
    return typecast< llvm::ConstantDataArray >::from(arg);
}

static
PyObject*
__downcast__llvm__User__to__llvm__ConstantDataArray(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::User* var_llvm_User = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::User* var_llvm_User1 = unwrap_as<llvm::User, llvm::Value >::from(var_void);
        if(!var_llvm_User1)
        {
            return NULL;
        }
        var_llvm_User = var_llvm_User1;
    }
    llvm::ConstantDataArray* var_llvm_ConstantDataArray = downcast_llvm_User_to_llvm_ConstantDataArray(var_llvm_User);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_ConstantDataArray), "llvm::Value", "llvm::ConstantDataArray");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::ConstantExpr* downcast_llvm_Value_to_llvm_ConstantExpr(llvm::Value* arg)
{
    return typecast< llvm::ConstantExpr >::from(arg);
}

static
PyObject*
__downcast__llvm__Value__to__llvm__ConstantExpr(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    llvm::ConstantExpr* var_llvm_ConstantExpr = downcast_llvm_Value_to_llvm_ConstantExpr(var_llvm_Value);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_ConstantExpr), "llvm::Value", "llvm::ConstantExpr");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::ConstantExpr* downcast_llvm_Constant_to_llvm_ConstantExpr(llvm::Constant* arg)
{
    return typecast< llvm::ConstantExpr >::from(arg);
}

static
PyObject*
__downcast__llvm__Constant__to__llvm__ConstantExpr(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Constant* var_llvm_Constant = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant1 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void);
        if(!var_llvm_Constant1)
        {
            return NULL;
        }
        var_llvm_Constant = var_llvm_Constant1;
    }
    llvm::ConstantExpr* var_llvm_ConstantExpr = downcast_llvm_Constant_to_llvm_ConstantExpr(var_llvm_Constant);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_ConstantExpr), "llvm::Value", "llvm::ConstantExpr");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::ConstantExpr* downcast_llvm_User_to_llvm_ConstantExpr(llvm::User* arg)
{
    return typecast< llvm::ConstantExpr >::from(arg);
}

static
PyObject*
__downcast__llvm__User__to__llvm__ConstantExpr(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::User* var_llvm_User = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::User* var_llvm_User1 = unwrap_as<llvm::User, llvm::Value >::from(var_void);
        if(!var_llvm_User1)
        {
            return NULL;
        }
        var_llvm_User = var_llvm_User1;
    }
    llvm::ConstantExpr* var_llvm_ConstantExpr = downcast_llvm_User_to_llvm_ConstantExpr(var_llvm_User);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_ConstantExpr), "llvm::Value", "llvm::ConstantExpr");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::IntegerType* downcast_llvm_Type_to_llvm_IntegerType(llvm::Type* arg)
{
    return typecast< llvm::IntegerType >::from(arg);
}

static
PyObject*
__downcast__llvm__Type__to__llvm__IntegerType(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    llvm::IntegerType* var_llvm_IntegerType = downcast_llvm_Type_to_llvm_IntegerType(var_llvm_Type);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Type >::from(var_llvm_IntegerType), "llvm::Type", "llvm::IntegerType");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::CompositeType* downcast_llvm_Type_to_llvm_CompositeType(llvm::Type* arg)
{
    return typecast< llvm::CompositeType >::from(arg);
}

static
PyObject*
__downcast__llvm__Type__to__llvm__CompositeType(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    llvm::CompositeType* var_llvm_CompositeType = downcast_llvm_Type_to_llvm_CompositeType(var_llvm_Type);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Type >::from(var_llvm_CompositeType), "llvm::Type", "llvm::CompositeType");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::StructType* downcast_llvm_Type_to_llvm_StructType(llvm::Type* arg)
{
    return typecast< llvm::StructType >::from(arg);
}

static
PyObject*
__downcast__llvm__Type__to__llvm__StructType(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    llvm::StructType* var_llvm_StructType = downcast_llvm_Type_to_llvm_StructType(var_llvm_Type);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Type >::from(var_llvm_StructType), "llvm::Type", "llvm::StructType");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::SequentialType* downcast_llvm_Type_to_llvm_SequentialType(llvm::Type* arg)
{
    return typecast< llvm::SequentialType >::from(arg);
}

static
PyObject*
__downcast__llvm__Type__to__llvm__SequentialType(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    llvm::SequentialType* var_llvm_SequentialType = downcast_llvm_Type_to_llvm_SequentialType(var_llvm_Type);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Type >::from(var_llvm_SequentialType), "llvm::Type", "llvm::SequentialType");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::ArrayType* downcast_llvm_Type_to_llvm_ArrayType(llvm::Type* arg)
{
    return typecast< llvm::ArrayType >::from(arg);
}

static
PyObject*
__downcast__llvm__Type__to__llvm__ArrayType(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    llvm::ArrayType* var_llvm_ArrayType = downcast_llvm_Type_to_llvm_ArrayType(var_llvm_Type);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Type >::from(var_llvm_ArrayType), "llvm::Type", "llvm::ArrayType");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::PointerType* downcast_llvm_Type_to_llvm_PointerType(llvm::Type* arg)
{
    return typecast< llvm::PointerType >::from(arg);
}

static
PyObject*
__downcast__llvm__Type__to__llvm__PointerType(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    llvm::PointerType* var_llvm_PointerType = downcast_llvm_Type_to_llvm_PointerType(var_llvm_Type);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Type >::from(var_llvm_PointerType), "llvm::Type", "llvm::PointerType");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::VectorType* downcast_llvm_Type_to_llvm_VectorType(llvm::Type* arg)
{
    return typecast< llvm::VectorType >::from(arg);
}

static
PyObject*
__downcast__llvm__Type__to__llvm__VectorType(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    llvm::VectorType* var_llvm_VectorType = downcast_llvm_Type_to_llvm_VectorType(var_llvm_Type);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Type >::from(var_llvm_VectorType), "llvm::Type", "llvm::VectorType");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::GlobalVariable* downcast_llvm_Value_to_llvm_GlobalVariable(llvm::Value* arg)
{
    return typecast< llvm::GlobalVariable >::from(arg);
}

static
PyObject*
__downcast__llvm__Value__to__llvm__GlobalVariable(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    llvm::GlobalVariable* var_llvm_GlobalVariable = downcast_llvm_Value_to_llvm_GlobalVariable(var_llvm_Value);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_GlobalVariable), "llvm::Value", "llvm::GlobalVariable");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::GlobalVariable* downcast_llvm_User_to_llvm_GlobalVariable(llvm::User* arg)
{
    return typecast< llvm::GlobalVariable >::from(arg);
}

static
PyObject*
__downcast__llvm__User__to__llvm__GlobalVariable(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::User* var_llvm_User = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::User* var_llvm_User1 = unwrap_as<llvm::User, llvm::Value >::from(var_void);
        if(!var_llvm_User1)
        {
            return NULL;
        }
        var_llvm_User = var_llvm_User1;
    }
    llvm::GlobalVariable* var_llvm_GlobalVariable = downcast_llvm_User_to_llvm_GlobalVariable(var_llvm_User);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_GlobalVariable), "llvm::Value", "llvm::GlobalVariable");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::GlobalVariable* downcast_llvm_Constant_to_llvm_GlobalVariable(llvm::Constant* arg)
{
    return typecast< llvm::GlobalVariable >::from(arg);
}

static
PyObject*
__downcast__llvm__Constant__to__llvm__GlobalVariable(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Constant* var_llvm_Constant = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant1 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void);
        if(!var_llvm_Constant1)
        {
            return NULL;
        }
        var_llvm_Constant = var_llvm_Constant1;
    }
    llvm::GlobalVariable* var_llvm_GlobalVariable = downcast_llvm_Constant_to_llvm_GlobalVariable(var_llvm_Constant);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_GlobalVariable), "llvm::Value", "llvm::GlobalVariable");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::Instruction* downcast_llvm_Value_to_llvm_Instruction(llvm::Value* arg)
{
    return typecast< llvm::Instruction >::from(arg);
}

static
PyObject*
__downcast__llvm__Value__to__llvm__Instruction(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    llvm::Instruction* var_llvm_Instruction = downcast_llvm_Value_to_llvm_Instruction(var_llvm_Value);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Instruction), "llvm::Value", "llvm::Instruction");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::Instruction* downcast_llvm_User_to_llvm_Instruction(llvm::User* arg)
{
    return typecast< llvm::Instruction >::from(arg);
}

static
PyObject*
__downcast__llvm__User__to__llvm__Instruction(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::User* var_llvm_User = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::User* var_llvm_User1 = unwrap_as<llvm::User, llvm::Value >::from(var_void);
        if(!var_llvm_User1)
        {
            return NULL;
        }
        var_llvm_User = var_llvm_User1;
    }
    llvm::Instruction* var_llvm_Instruction = downcast_llvm_User_to_llvm_Instruction(var_llvm_User);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Instruction), "llvm::Value", "llvm::Instruction");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::AtomicCmpXchgInst* downcast_llvm_Value_to_llvm_AtomicCmpXchgInst(llvm::Value* arg)
{
    return typecast< llvm::AtomicCmpXchgInst >::from(arg);
}

static
PyObject*
__downcast__llvm__Value__to__llvm__AtomicCmpXchgInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    llvm::AtomicCmpXchgInst* var_llvm_AtomicCmpXchgInst = downcast_llvm_Value_to_llvm_AtomicCmpXchgInst(var_llvm_Value);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_AtomicCmpXchgInst), "llvm::Value", "llvm::AtomicCmpXchgInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::AtomicCmpXchgInst* downcast_llvm_User_to_llvm_AtomicCmpXchgInst(llvm::User* arg)
{
    return typecast< llvm::AtomicCmpXchgInst >::from(arg);
}

static
PyObject*
__downcast__llvm__User__to__llvm__AtomicCmpXchgInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::User* var_llvm_User = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::User* var_llvm_User1 = unwrap_as<llvm::User, llvm::Value >::from(var_void);
        if(!var_llvm_User1)
        {
            return NULL;
        }
        var_llvm_User = var_llvm_User1;
    }
    llvm::AtomicCmpXchgInst* var_llvm_AtomicCmpXchgInst = downcast_llvm_User_to_llvm_AtomicCmpXchgInst(var_llvm_User);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_AtomicCmpXchgInst), "llvm::Value", "llvm::AtomicCmpXchgInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::AtomicCmpXchgInst* downcast_llvm_Instruction_to_llvm_AtomicCmpXchgInst(llvm::Instruction* arg)
{
    return typecast< llvm::AtomicCmpXchgInst >::from(arg);
}

static
PyObject*
__downcast__llvm__Instruction__to__llvm__AtomicCmpXchgInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Instruction* var_llvm_Instruction = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void);
        if(!var_llvm_Instruction1)
        {
            return NULL;
        }
        var_llvm_Instruction = var_llvm_Instruction1;
    }
    llvm::AtomicCmpXchgInst* var_llvm_AtomicCmpXchgInst = downcast_llvm_Instruction_to_llvm_AtomicCmpXchgInst(var_llvm_Instruction);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_AtomicCmpXchgInst), "llvm::Value", "llvm::AtomicCmpXchgInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::AtomicRMWInst* downcast_llvm_Value_to_llvm_AtomicRMWInst(llvm::Value* arg)
{
    return typecast< llvm::AtomicRMWInst >::from(arg);
}

static
PyObject*
__downcast__llvm__Value__to__llvm__AtomicRMWInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    llvm::AtomicRMWInst* var_llvm_AtomicRMWInst = downcast_llvm_Value_to_llvm_AtomicRMWInst(var_llvm_Value);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_AtomicRMWInst), "llvm::Value", "llvm::AtomicRMWInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::AtomicRMWInst* downcast_llvm_User_to_llvm_AtomicRMWInst(llvm::User* arg)
{
    return typecast< llvm::AtomicRMWInst >::from(arg);
}

static
PyObject*
__downcast__llvm__User__to__llvm__AtomicRMWInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::User* var_llvm_User = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::User* var_llvm_User1 = unwrap_as<llvm::User, llvm::Value >::from(var_void);
        if(!var_llvm_User1)
        {
            return NULL;
        }
        var_llvm_User = var_llvm_User1;
    }
    llvm::AtomicRMWInst* var_llvm_AtomicRMWInst = downcast_llvm_User_to_llvm_AtomicRMWInst(var_llvm_User);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_AtomicRMWInst), "llvm::Value", "llvm::AtomicRMWInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::AtomicRMWInst* downcast_llvm_Instruction_to_llvm_AtomicRMWInst(llvm::Instruction* arg)
{
    return typecast< llvm::AtomicRMWInst >::from(arg);
}

static
PyObject*
__downcast__llvm__Instruction__to__llvm__AtomicRMWInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Instruction* var_llvm_Instruction = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void);
        if(!var_llvm_Instruction1)
        {
            return NULL;
        }
        var_llvm_Instruction = var_llvm_Instruction1;
    }
    llvm::AtomicRMWInst* var_llvm_AtomicRMWInst = downcast_llvm_Instruction_to_llvm_AtomicRMWInst(var_llvm_Instruction);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_AtomicRMWInst), "llvm::Value", "llvm::AtomicRMWInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::BinaryOperator* downcast_llvm_Value_to_llvm_BinaryOperator(llvm::Value* arg)
{
    return typecast< llvm::BinaryOperator >::from(arg);
}

static
PyObject*
__downcast__llvm__Value__to__llvm__BinaryOperator(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    llvm::BinaryOperator* var_llvm_BinaryOperator = downcast_llvm_Value_to_llvm_BinaryOperator(var_llvm_Value);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_BinaryOperator), "llvm::Value", "llvm::BinaryOperator");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::BinaryOperator* downcast_llvm_User_to_llvm_BinaryOperator(llvm::User* arg)
{
    return typecast< llvm::BinaryOperator >::from(arg);
}

static
PyObject*
__downcast__llvm__User__to__llvm__BinaryOperator(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::User* var_llvm_User = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::User* var_llvm_User1 = unwrap_as<llvm::User, llvm::Value >::from(var_void);
        if(!var_llvm_User1)
        {
            return NULL;
        }
        var_llvm_User = var_llvm_User1;
    }
    llvm::BinaryOperator* var_llvm_BinaryOperator = downcast_llvm_User_to_llvm_BinaryOperator(var_llvm_User);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_BinaryOperator), "llvm::Value", "llvm::BinaryOperator");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::BinaryOperator* downcast_llvm_Instruction_to_llvm_BinaryOperator(llvm::Instruction* arg)
{
    return typecast< llvm::BinaryOperator >::from(arg);
}

static
PyObject*
__downcast__llvm__Instruction__to__llvm__BinaryOperator(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Instruction* var_llvm_Instruction = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void);
        if(!var_llvm_Instruction1)
        {
            return NULL;
        }
        var_llvm_Instruction = var_llvm_Instruction1;
    }
    llvm::BinaryOperator* var_llvm_BinaryOperator = downcast_llvm_Instruction_to_llvm_BinaryOperator(var_llvm_Instruction);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_BinaryOperator), "llvm::Value", "llvm::BinaryOperator");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::CallInst* downcast_llvm_Value_to_llvm_CallInst(llvm::Value* arg)
{
    return typecast< llvm::CallInst >::from(arg);
}

static
PyObject*
__downcast__llvm__Value__to__llvm__CallInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    llvm::CallInst* var_llvm_CallInst = downcast_llvm_Value_to_llvm_CallInst(var_llvm_Value);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_CallInst), "llvm::Value", "llvm::CallInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::CallInst* downcast_llvm_User_to_llvm_CallInst(llvm::User* arg)
{
    return typecast< llvm::CallInst >::from(arg);
}

static
PyObject*
__downcast__llvm__User__to__llvm__CallInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::User* var_llvm_User = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::User* var_llvm_User1 = unwrap_as<llvm::User, llvm::Value >::from(var_void);
        if(!var_llvm_User1)
        {
            return NULL;
        }
        var_llvm_User = var_llvm_User1;
    }
    llvm::CallInst* var_llvm_CallInst = downcast_llvm_User_to_llvm_CallInst(var_llvm_User);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_CallInst), "llvm::Value", "llvm::CallInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::CallInst* downcast_llvm_Instruction_to_llvm_CallInst(llvm::Instruction* arg)
{
    return typecast< llvm::CallInst >::from(arg);
}

static
PyObject*
__downcast__llvm__Instruction__to__llvm__CallInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Instruction* var_llvm_Instruction = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void);
        if(!var_llvm_Instruction1)
        {
            return NULL;
        }
        var_llvm_Instruction = var_llvm_Instruction1;
    }
    llvm::CallInst* var_llvm_CallInst = downcast_llvm_Instruction_to_llvm_CallInst(var_llvm_Instruction);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_CallInst), "llvm::Value", "llvm::CallInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::CmpInst* downcast_llvm_Value_to_llvm_CmpInst(llvm::Value* arg)
{
    return typecast< llvm::CmpInst >::from(arg);
}

static
PyObject*
__downcast__llvm__Value__to__llvm__CmpInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    llvm::CmpInst* var_llvm_CmpInst = downcast_llvm_Value_to_llvm_CmpInst(var_llvm_Value);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_CmpInst), "llvm::Value", "llvm::CmpInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::CmpInst* downcast_llvm_User_to_llvm_CmpInst(llvm::User* arg)
{
    return typecast< llvm::CmpInst >::from(arg);
}

static
PyObject*
__downcast__llvm__User__to__llvm__CmpInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::User* var_llvm_User = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::User* var_llvm_User1 = unwrap_as<llvm::User, llvm::Value >::from(var_void);
        if(!var_llvm_User1)
        {
            return NULL;
        }
        var_llvm_User = var_llvm_User1;
    }
    llvm::CmpInst* var_llvm_CmpInst = downcast_llvm_User_to_llvm_CmpInst(var_llvm_User);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_CmpInst), "llvm::Value", "llvm::CmpInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::CmpInst* downcast_llvm_Instruction_to_llvm_CmpInst(llvm::Instruction* arg)
{
    return typecast< llvm::CmpInst >::from(arg);
}

static
PyObject*
__downcast__llvm__Instruction__to__llvm__CmpInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Instruction* var_llvm_Instruction = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void);
        if(!var_llvm_Instruction1)
        {
            return NULL;
        }
        var_llvm_Instruction = var_llvm_Instruction1;
    }
    llvm::CmpInst* var_llvm_CmpInst = downcast_llvm_Instruction_to_llvm_CmpInst(var_llvm_Instruction);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_CmpInst), "llvm::Value", "llvm::CmpInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::ExtractElementInst* downcast_llvm_Value_to_llvm_ExtractElementInst(llvm::Value* arg)
{
    return typecast< llvm::ExtractElementInst >::from(arg);
}

static
PyObject*
__downcast__llvm__Value__to__llvm__ExtractElementInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    llvm::ExtractElementInst* var_llvm_ExtractElementInst = downcast_llvm_Value_to_llvm_ExtractElementInst(var_llvm_Value);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_ExtractElementInst), "llvm::Value", "llvm::ExtractElementInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::ExtractElementInst* downcast_llvm_User_to_llvm_ExtractElementInst(llvm::User* arg)
{
    return typecast< llvm::ExtractElementInst >::from(arg);
}

static
PyObject*
__downcast__llvm__User__to__llvm__ExtractElementInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::User* var_llvm_User = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::User* var_llvm_User1 = unwrap_as<llvm::User, llvm::Value >::from(var_void);
        if(!var_llvm_User1)
        {
            return NULL;
        }
        var_llvm_User = var_llvm_User1;
    }
    llvm::ExtractElementInst* var_llvm_ExtractElementInst = downcast_llvm_User_to_llvm_ExtractElementInst(var_llvm_User);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_ExtractElementInst), "llvm::Value", "llvm::ExtractElementInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::ExtractElementInst* downcast_llvm_Instruction_to_llvm_ExtractElementInst(llvm::Instruction* arg)
{
    return typecast< llvm::ExtractElementInst >::from(arg);
}

static
PyObject*
__downcast__llvm__Instruction__to__llvm__ExtractElementInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Instruction* var_llvm_Instruction = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void);
        if(!var_llvm_Instruction1)
        {
            return NULL;
        }
        var_llvm_Instruction = var_llvm_Instruction1;
    }
    llvm::ExtractElementInst* var_llvm_ExtractElementInst = downcast_llvm_Instruction_to_llvm_ExtractElementInst(var_llvm_Instruction);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_ExtractElementInst), "llvm::Value", "llvm::ExtractElementInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::FenceInst* downcast_llvm_Value_to_llvm_FenceInst(llvm::Value* arg)
{
    return typecast< llvm::FenceInst >::from(arg);
}

static
PyObject*
__downcast__llvm__Value__to__llvm__FenceInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    llvm::FenceInst* var_llvm_FenceInst = downcast_llvm_Value_to_llvm_FenceInst(var_llvm_Value);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_FenceInst), "llvm::Value", "llvm::FenceInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::FenceInst* downcast_llvm_User_to_llvm_FenceInst(llvm::User* arg)
{
    return typecast< llvm::FenceInst >::from(arg);
}

static
PyObject*
__downcast__llvm__User__to__llvm__FenceInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::User* var_llvm_User = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::User* var_llvm_User1 = unwrap_as<llvm::User, llvm::Value >::from(var_void);
        if(!var_llvm_User1)
        {
            return NULL;
        }
        var_llvm_User = var_llvm_User1;
    }
    llvm::FenceInst* var_llvm_FenceInst = downcast_llvm_User_to_llvm_FenceInst(var_llvm_User);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_FenceInst), "llvm::Value", "llvm::FenceInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::FenceInst* downcast_llvm_Instruction_to_llvm_FenceInst(llvm::Instruction* arg)
{
    return typecast< llvm::FenceInst >::from(arg);
}

static
PyObject*
__downcast__llvm__Instruction__to__llvm__FenceInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Instruction* var_llvm_Instruction = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void);
        if(!var_llvm_Instruction1)
        {
            return NULL;
        }
        var_llvm_Instruction = var_llvm_Instruction1;
    }
    llvm::FenceInst* var_llvm_FenceInst = downcast_llvm_Instruction_to_llvm_FenceInst(var_llvm_Instruction);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_FenceInst), "llvm::Value", "llvm::FenceInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::GetElementPtrInst* downcast_llvm_Value_to_llvm_GetElementPtrInst(llvm::Value* arg)
{
    return typecast< llvm::GetElementPtrInst >::from(arg);
}

static
PyObject*
__downcast__llvm__Value__to__llvm__GetElementPtrInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    llvm::GetElementPtrInst* var_llvm_GetElementPtrInst = downcast_llvm_Value_to_llvm_GetElementPtrInst(var_llvm_Value);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_GetElementPtrInst), "llvm::Value", "llvm::GetElementPtrInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::GetElementPtrInst* downcast_llvm_User_to_llvm_GetElementPtrInst(llvm::User* arg)
{
    return typecast< llvm::GetElementPtrInst >::from(arg);
}

static
PyObject*
__downcast__llvm__User__to__llvm__GetElementPtrInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::User* var_llvm_User = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::User* var_llvm_User1 = unwrap_as<llvm::User, llvm::Value >::from(var_void);
        if(!var_llvm_User1)
        {
            return NULL;
        }
        var_llvm_User = var_llvm_User1;
    }
    llvm::GetElementPtrInst* var_llvm_GetElementPtrInst = downcast_llvm_User_to_llvm_GetElementPtrInst(var_llvm_User);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_GetElementPtrInst), "llvm::Value", "llvm::GetElementPtrInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::GetElementPtrInst* downcast_llvm_Instruction_to_llvm_GetElementPtrInst(llvm::Instruction* arg)
{
    return typecast< llvm::GetElementPtrInst >::from(arg);
}

static
PyObject*
__downcast__llvm__Instruction__to__llvm__GetElementPtrInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Instruction* var_llvm_Instruction = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void);
        if(!var_llvm_Instruction1)
        {
            return NULL;
        }
        var_llvm_Instruction = var_llvm_Instruction1;
    }
    llvm::GetElementPtrInst* var_llvm_GetElementPtrInst = downcast_llvm_Instruction_to_llvm_GetElementPtrInst(var_llvm_Instruction);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_GetElementPtrInst), "llvm::Value", "llvm::GetElementPtrInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::InsertElementInst* downcast_llvm_Value_to_llvm_InsertElementInst(llvm::Value* arg)
{
    return typecast< llvm::InsertElementInst >::from(arg);
}

static
PyObject*
__downcast__llvm__Value__to__llvm__InsertElementInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    llvm::InsertElementInst* var_llvm_InsertElementInst = downcast_llvm_Value_to_llvm_InsertElementInst(var_llvm_Value);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_InsertElementInst), "llvm::Value", "llvm::InsertElementInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::InsertElementInst* downcast_llvm_User_to_llvm_InsertElementInst(llvm::User* arg)
{
    return typecast< llvm::InsertElementInst >::from(arg);
}

static
PyObject*
__downcast__llvm__User__to__llvm__InsertElementInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::User* var_llvm_User = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::User* var_llvm_User1 = unwrap_as<llvm::User, llvm::Value >::from(var_void);
        if(!var_llvm_User1)
        {
            return NULL;
        }
        var_llvm_User = var_llvm_User1;
    }
    llvm::InsertElementInst* var_llvm_InsertElementInst = downcast_llvm_User_to_llvm_InsertElementInst(var_llvm_User);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_InsertElementInst), "llvm::Value", "llvm::InsertElementInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::InsertElementInst* downcast_llvm_Instruction_to_llvm_InsertElementInst(llvm::Instruction* arg)
{
    return typecast< llvm::InsertElementInst >::from(arg);
}

static
PyObject*
__downcast__llvm__Instruction__to__llvm__InsertElementInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Instruction* var_llvm_Instruction = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void);
        if(!var_llvm_Instruction1)
        {
            return NULL;
        }
        var_llvm_Instruction = var_llvm_Instruction1;
    }
    llvm::InsertElementInst* var_llvm_InsertElementInst = downcast_llvm_Instruction_to_llvm_InsertElementInst(var_llvm_Instruction);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_InsertElementInst), "llvm::Value", "llvm::InsertElementInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::InsertValueInst* downcast_llvm_Value_to_llvm_InsertValueInst(llvm::Value* arg)
{
    return typecast< llvm::InsertValueInst >::from(arg);
}

static
PyObject*
__downcast__llvm__Value__to__llvm__InsertValueInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    llvm::InsertValueInst* var_llvm_InsertValueInst = downcast_llvm_Value_to_llvm_InsertValueInst(var_llvm_Value);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_InsertValueInst), "llvm::Value", "llvm::InsertValueInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::InsertValueInst* downcast_llvm_User_to_llvm_InsertValueInst(llvm::User* arg)
{
    return typecast< llvm::InsertValueInst >::from(arg);
}

static
PyObject*
__downcast__llvm__User__to__llvm__InsertValueInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::User* var_llvm_User = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::User* var_llvm_User1 = unwrap_as<llvm::User, llvm::Value >::from(var_void);
        if(!var_llvm_User1)
        {
            return NULL;
        }
        var_llvm_User = var_llvm_User1;
    }
    llvm::InsertValueInst* var_llvm_InsertValueInst = downcast_llvm_User_to_llvm_InsertValueInst(var_llvm_User);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_InsertValueInst), "llvm::Value", "llvm::InsertValueInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::InsertValueInst* downcast_llvm_Instruction_to_llvm_InsertValueInst(llvm::Instruction* arg)
{
    return typecast< llvm::InsertValueInst >::from(arg);
}

static
PyObject*
__downcast__llvm__Instruction__to__llvm__InsertValueInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Instruction* var_llvm_Instruction = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void);
        if(!var_llvm_Instruction1)
        {
            return NULL;
        }
        var_llvm_Instruction = var_llvm_Instruction1;
    }
    llvm::InsertValueInst* var_llvm_InsertValueInst = downcast_llvm_Instruction_to_llvm_InsertValueInst(var_llvm_Instruction);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_InsertValueInst), "llvm::Value", "llvm::InsertValueInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::LandingPadInst* downcast_llvm_Value_to_llvm_LandingPadInst(llvm::Value* arg)
{
    return typecast< llvm::LandingPadInst >::from(arg);
}

static
PyObject*
__downcast__llvm__Value__to__llvm__LandingPadInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    llvm::LandingPadInst* var_llvm_LandingPadInst = downcast_llvm_Value_to_llvm_LandingPadInst(var_llvm_Value);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_LandingPadInst), "llvm::Value", "llvm::LandingPadInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::LandingPadInst* downcast_llvm_User_to_llvm_LandingPadInst(llvm::User* arg)
{
    return typecast< llvm::LandingPadInst >::from(arg);
}

static
PyObject*
__downcast__llvm__User__to__llvm__LandingPadInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::User* var_llvm_User = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::User* var_llvm_User1 = unwrap_as<llvm::User, llvm::Value >::from(var_void);
        if(!var_llvm_User1)
        {
            return NULL;
        }
        var_llvm_User = var_llvm_User1;
    }
    llvm::LandingPadInst* var_llvm_LandingPadInst = downcast_llvm_User_to_llvm_LandingPadInst(var_llvm_User);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_LandingPadInst), "llvm::Value", "llvm::LandingPadInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::LandingPadInst* downcast_llvm_Instruction_to_llvm_LandingPadInst(llvm::Instruction* arg)
{
    return typecast< llvm::LandingPadInst >::from(arg);
}

static
PyObject*
__downcast__llvm__Instruction__to__llvm__LandingPadInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Instruction* var_llvm_Instruction = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void);
        if(!var_llvm_Instruction1)
        {
            return NULL;
        }
        var_llvm_Instruction = var_llvm_Instruction1;
    }
    llvm::LandingPadInst* var_llvm_LandingPadInst = downcast_llvm_Instruction_to_llvm_LandingPadInst(var_llvm_Instruction);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_LandingPadInst), "llvm::Value", "llvm::LandingPadInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::PHINode* downcast_llvm_Value_to_llvm_PHINode(llvm::Value* arg)
{
    return typecast< llvm::PHINode >::from(arg);
}

static
PyObject*
__downcast__llvm__Value__to__llvm__PHINode(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    llvm::PHINode* var_llvm_PHINode = downcast_llvm_Value_to_llvm_PHINode(var_llvm_Value);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_PHINode), "llvm::Value", "llvm::PHINode");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::PHINode* downcast_llvm_User_to_llvm_PHINode(llvm::User* arg)
{
    return typecast< llvm::PHINode >::from(arg);
}

static
PyObject*
__downcast__llvm__User__to__llvm__PHINode(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::User* var_llvm_User = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::User* var_llvm_User1 = unwrap_as<llvm::User, llvm::Value >::from(var_void);
        if(!var_llvm_User1)
        {
            return NULL;
        }
        var_llvm_User = var_llvm_User1;
    }
    llvm::PHINode* var_llvm_PHINode = downcast_llvm_User_to_llvm_PHINode(var_llvm_User);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_PHINode), "llvm::Value", "llvm::PHINode");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::PHINode* downcast_llvm_Instruction_to_llvm_PHINode(llvm::Instruction* arg)
{
    return typecast< llvm::PHINode >::from(arg);
}

static
PyObject*
__downcast__llvm__Instruction__to__llvm__PHINode(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Instruction* var_llvm_Instruction = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void);
        if(!var_llvm_Instruction1)
        {
            return NULL;
        }
        var_llvm_Instruction = var_llvm_Instruction1;
    }
    llvm::PHINode* var_llvm_PHINode = downcast_llvm_Instruction_to_llvm_PHINode(var_llvm_Instruction);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_PHINode), "llvm::Value", "llvm::PHINode");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::SelectInst* downcast_llvm_Value_to_llvm_SelectInst(llvm::Value* arg)
{
    return typecast< llvm::SelectInst >::from(arg);
}

static
PyObject*
__downcast__llvm__Value__to__llvm__SelectInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    llvm::SelectInst* var_llvm_SelectInst = downcast_llvm_Value_to_llvm_SelectInst(var_llvm_Value);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_SelectInst), "llvm::Value", "llvm::SelectInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::SelectInst* downcast_llvm_User_to_llvm_SelectInst(llvm::User* arg)
{
    return typecast< llvm::SelectInst >::from(arg);
}

static
PyObject*
__downcast__llvm__User__to__llvm__SelectInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::User* var_llvm_User = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::User* var_llvm_User1 = unwrap_as<llvm::User, llvm::Value >::from(var_void);
        if(!var_llvm_User1)
        {
            return NULL;
        }
        var_llvm_User = var_llvm_User1;
    }
    llvm::SelectInst* var_llvm_SelectInst = downcast_llvm_User_to_llvm_SelectInst(var_llvm_User);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_SelectInst), "llvm::Value", "llvm::SelectInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::SelectInst* downcast_llvm_Instruction_to_llvm_SelectInst(llvm::Instruction* arg)
{
    return typecast< llvm::SelectInst >::from(arg);
}

static
PyObject*
__downcast__llvm__Instruction__to__llvm__SelectInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Instruction* var_llvm_Instruction = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void);
        if(!var_llvm_Instruction1)
        {
            return NULL;
        }
        var_llvm_Instruction = var_llvm_Instruction1;
    }
    llvm::SelectInst* var_llvm_SelectInst = downcast_llvm_Instruction_to_llvm_SelectInst(var_llvm_Instruction);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_SelectInst), "llvm::Value", "llvm::SelectInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::ShuffleVectorInst* downcast_llvm_Value_to_llvm_ShuffleVectorInst(llvm::Value* arg)
{
    return typecast< llvm::ShuffleVectorInst >::from(arg);
}

static
PyObject*
__downcast__llvm__Value__to__llvm__ShuffleVectorInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    llvm::ShuffleVectorInst* var_llvm_ShuffleVectorInst = downcast_llvm_Value_to_llvm_ShuffleVectorInst(var_llvm_Value);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_ShuffleVectorInst), "llvm::Value", "llvm::ShuffleVectorInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::ShuffleVectorInst* downcast_llvm_User_to_llvm_ShuffleVectorInst(llvm::User* arg)
{
    return typecast< llvm::ShuffleVectorInst >::from(arg);
}

static
PyObject*
__downcast__llvm__User__to__llvm__ShuffleVectorInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::User* var_llvm_User = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::User* var_llvm_User1 = unwrap_as<llvm::User, llvm::Value >::from(var_void);
        if(!var_llvm_User1)
        {
            return NULL;
        }
        var_llvm_User = var_llvm_User1;
    }
    llvm::ShuffleVectorInst* var_llvm_ShuffleVectorInst = downcast_llvm_User_to_llvm_ShuffleVectorInst(var_llvm_User);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_ShuffleVectorInst), "llvm::Value", "llvm::ShuffleVectorInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::ShuffleVectorInst* downcast_llvm_Instruction_to_llvm_ShuffleVectorInst(llvm::Instruction* arg)
{
    return typecast< llvm::ShuffleVectorInst >::from(arg);
}

static
PyObject*
__downcast__llvm__Instruction__to__llvm__ShuffleVectorInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Instruction* var_llvm_Instruction = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void);
        if(!var_llvm_Instruction1)
        {
            return NULL;
        }
        var_llvm_Instruction = var_llvm_Instruction1;
    }
    llvm::ShuffleVectorInst* var_llvm_ShuffleVectorInst = downcast_llvm_Instruction_to_llvm_ShuffleVectorInst(var_llvm_Instruction);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_ShuffleVectorInst), "llvm::Value", "llvm::ShuffleVectorInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::StoreInst* downcast_llvm_Value_to_llvm_StoreInst(llvm::Value* arg)
{
    return typecast< llvm::StoreInst >::from(arg);
}

static
PyObject*
__downcast__llvm__Value__to__llvm__StoreInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    llvm::StoreInst* var_llvm_StoreInst = downcast_llvm_Value_to_llvm_StoreInst(var_llvm_Value);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_StoreInst), "llvm::Value", "llvm::StoreInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::StoreInst* downcast_llvm_User_to_llvm_StoreInst(llvm::User* arg)
{
    return typecast< llvm::StoreInst >::from(arg);
}

static
PyObject*
__downcast__llvm__User__to__llvm__StoreInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::User* var_llvm_User = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::User* var_llvm_User1 = unwrap_as<llvm::User, llvm::Value >::from(var_void);
        if(!var_llvm_User1)
        {
            return NULL;
        }
        var_llvm_User = var_llvm_User1;
    }
    llvm::StoreInst* var_llvm_StoreInst = downcast_llvm_User_to_llvm_StoreInst(var_llvm_User);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_StoreInst), "llvm::Value", "llvm::StoreInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::StoreInst* downcast_llvm_Instruction_to_llvm_StoreInst(llvm::Instruction* arg)
{
    return typecast< llvm::StoreInst >::from(arg);
}

static
PyObject*
__downcast__llvm__Instruction__to__llvm__StoreInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Instruction* var_llvm_Instruction = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void);
        if(!var_llvm_Instruction1)
        {
            return NULL;
        }
        var_llvm_Instruction = var_llvm_Instruction1;
    }
    llvm::StoreInst* var_llvm_StoreInst = downcast_llvm_Instruction_to_llvm_StoreInst(var_llvm_Instruction);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_StoreInst), "llvm::Value", "llvm::StoreInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::TerminatorInst* downcast_llvm_Value_to_llvm_TerminatorInst(llvm::Value* arg)
{
    return typecast< llvm::TerminatorInst >::from(arg);
}

static
PyObject*
__downcast__llvm__Value__to__llvm__TerminatorInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    llvm::TerminatorInst* var_llvm_TerminatorInst = downcast_llvm_Value_to_llvm_TerminatorInst(var_llvm_Value);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_TerminatorInst), "llvm::Value", "llvm::TerminatorInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::TerminatorInst* downcast_llvm_User_to_llvm_TerminatorInst(llvm::User* arg)
{
    return typecast< llvm::TerminatorInst >::from(arg);
}

static
PyObject*
__downcast__llvm__User__to__llvm__TerminatorInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::User* var_llvm_User = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::User* var_llvm_User1 = unwrap_as<llvm::User, llvm::Value >::from(var_void);
        if(!var_llvm_User1)
        {
            return NULL;
        }
        var_llvm_User = var_llvm_User1;
    }
    llvm::TerminatorInst* var_llvm_TerminatorInst = downcast_llvm_User_to_llvm_TerminatorInst(var_llvm_User);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_TerminatorInst), "llvm::Value", "llvm::TerminatorInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::TerminatorInst* downcast_llvm_Instruction_to_llvm_TerminatorInst(llvm::Instruction* arg)
{
    return typecast< llvm::TerminatorInst >::from(arg);
}

static
PyObject*
__downcast__llvm__Instruction__to__llvm__TerminatorInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Instruction* var_llvm_Instruction = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void);
        if(!var_llvm_Instruction1)
        {
            return NULL;
        }
        var_llvm_Instruction = var_llvm_Instruction1;
    }
    llvm::TerminatorInst* var_llvm_TerminatorInst = downcast_llvm_Instruction_to_llvm_TerminatorInst(var_llvm_Instruction);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_TerminatorInst), "llvm::Value", "llvm::TerminatorInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::UnaryInstruction* downcast_llvm_Value_to_llvm_UnaryInstruction(llvm::Value* arg)
{
    return typecast< llvm::UnaryInstruction >::from(arg);
}

static
PyObject*
__downcast__llvm__Value__to__llvm__UnaryInstruction(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    llvm::UnaryInstruction* var_llvm_UnaryInstruction = downcast_llvm_Value_to_llvm_UnaryInstruction(var_llvm_Value);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_UnaryInstruction), "llvm::Value", "llvm::UnaryInstruction");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::UnaryInstruction* downcast_llvm_User_to_llvm_UnaryInstruction(llvm::User* arg)
{
    return typecast< llvm::UnaryInstruction >::from(arg);
}

static
PyObject*
__downcast__llvm__User__to__llvm__UnaryInstruction(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::User* var_llvm_User = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::User* var_llvm_User1 = unwrap_as<llvm::User, llvm::Value >::from(var_void);
        if(!var_llvm_User1)
        {
            return NULL;
        }
        var_llvm_User = var_llvm_User1;
    }
    llvm::UnaryInstruction* var_llvm_UnaryInstruction = downcast_llvm_User_to_llvm_UnaryInstruction(var_llvm_User);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_UnaryInstruction), "llvm::Value", "llvm::UnaryInstruction");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::UnaryInstruction* downcast_llvm_Instruction_to_llvm_UnaryInstruction(llvm::Instruction* arg)
{
    return typecast< llvm::UnaryInstruction >::from(arg);
}

static
PyObject*
__downcast__llvm__Instruction__to__llvm__UnaryInstruction(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Instruction* var_llvm_Instruction = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void);
        if(!var_llvm_Instruction1)
        {
            return NULL;
        }
        var_llvm_Instruction = var_llvm_Instruction1;
    }
    llvm::UnaryInstruction* var_llvm_UnaryInstruction = downcast_llvm_Instruction_to_llvm_UnaryInstruction(var_llvm_Instruction);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_UnaryInstruction), "llvm::Value", "llvm::UnaryInstruction");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::IntrinsicInst* downcast_llvm_Value_to_llvm_IntrinsicInst(llvm::Value* arg)
{
    return typecast< llvm::IntrinsicInst >::from(arg);
}

static
PyObject*
__downcast__llvm__Value__to__llvm__IntrinsicInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    llvm::IntrinsicInst* var_llvm_IntrinsicInst = downcast_llvm_Value_to_llvm_IntrinsicInst(var_llvm_Value);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_IntrinsicInst), "llvm::Value", "llvm::IntrinsicInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::IntrinsicInst* downcast_llvm_User_to_llvm_IntrinsicInst(llvm::User* arg)
{
    return typecast< llvm::IntrinsicInst >::from(arg);
}

static
PyObject*
__downcast__llvm__User__to__llvm__IntrinsicInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::User* var_llvm_User = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::User* var_llvm_User1 = unwrap_as<llvm::User, llvm::Value >::from(var_void);
        if(!var_llvm_User1)
        {
            return NULL;
        }
        var_llvm_User = var_llvm_User1;
    }
    llvm::IntrinsicInst* var_llvm_IntrinsicInst = downcast_llvm_User_to_llvm_IntrinsicInst(var_llvm_User);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_IntrinsicInst), "llvm::Value", "llvm::IntrinsicInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::IntrinsicInst* downcast_llvm_Instruction_to_llvm_IntrinsicInst(llvm::Instruction* arg)
{
    return typecast< llvm::IntrinsicInst >::from(arg);
}

static
PyObject*
__downcast__llvm__Instruction__to__llvm__IntrinsicInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Instruction* var_llvm_Instruction = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void);
        if(!var_llvm_Instruction1)
        {
            return NULL;
        }
        var_llvm_Instruction = var_llvm_Instruction1;
    }
    llvm::IntrinsicInst* var_llvm_IntrinsicInst = downcast_llvm_Instruction_to_llvm_IntrinsicInst(var_llvm_Instruction);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_IntrinsicInst), "llvm::Value", "llvm::IntrinsicInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::FCmpInst* downcast_llvm_Value_to_llvm_FCmpInst(llvm::Value* arg)
{
    return typecast< llvm::FCmpInst >::from(arg);
}

static
PyObject*
__downcast__llvm__Value__to__llvm__FCmpInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    llvm::FCmpInst* var_llvm_FCmpInst = downcast_llvm_Value_to_llvm_FCmpInst(var_llvm_Value);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_FCmpInst), "llvm::Value", "llvm::FCmpInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::FCmpInst* downcast_llvm_User_to_llvm_FCmpInst(llvm::User* arg)
{
    return typecast< llvm::FCmpInst >::from(arg);
}

static
PyObject*
__downcast__llvm__User__to__llvm__FCmpInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::User* var_llvm_User = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::User* var_llvm_User1 = unwrap_as<llvm::User, llvm::Value >::from(var_void);
        if(!var_llvm_User1)
        {
            return NULL;
        }
        var_llvm_User = var_llvm_User1;
    }
    llvm::FCmpInst* var_llvm_FCmpInst = downcast_llvm_User_to_llvm_FCmpInst(var_llvm_User);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_FCmpInst), "llvm::Value", "llvm::FCmpInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::FCmpInst* downcast_llvm_Instruction_to_llvm_FCmpInst(llvm::Instruction* arg)
{
    return typecast< llvm::FCmpInst >::from(arg);
}

static
PyObject*
__downcast__llvm__Instruction__to__llvm__FCmpInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Instruction* var_llvm_Instruction = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void);
        if(!var_llvm_Instruction1)
        {
            return NULL;
        }
        var_llvm_Instruction = var_llvm_Instruction1;
    }
    llvm::FCmpInst* var_llvm_FCmpInst = downcast_llvm_Instruction_to_llvm_FCmpInst(var_llvm_Instruction);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_FCmpInst), "llvm::Value", "llvm::FCmpInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::ICmpInst* downcast_llvm_Value_to_llvm_ICmpInst(llvm::Value* arg)
{
    return typecast< llvm::ICmpInst >::from(arg);
}

static
PyObject*
__downcast__llvm__Value__to__llvm__ICmpInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    llvm::ICmpInst* var_llvm_ICmpInst = downcast_llvm_Value_to_llvm_ICmpInst(var_llvm_Value);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_ICmpInst), "llvm::Value", "llvm::ICmpInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::ICmpInst* downcast_llvm_User_to_llvm_ICmpInst(llvm::User* arg)
{
    return typecast< llvm::ICmpInst >::from(arg);
}

static
PyObject*
__downcast__llvm__User__to__llvm__ICmpInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::User* var_llvm_User = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::User* var_llvm_User1 = unwrap_as<llvm::User, llvm::Value >::from(var_void);
        if(!var_llvm_User1)
        {
            return NULL;
        }
        var_llvm_User = var_llvm_User1;
    }
    llvm::ICmpInst* var_llvm_ICmpInst = downcast_llvm_User_to_llvm_ICmpInst(var_llvm_User);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_ICmpInst), "llvm::Value", "llvm::ICmpInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::ICmpInst* downcast_llvm_Instruction_to_llvm_ICmpInst(llvm::Instruction* arg)
{
    return typecast< llvm::ICmpInst >::from(arg);
}

static
PyObject*
__downcast__llvm__Instruction__to__llvm__ICmpInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Instruction* var_llvm_Instruction = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void);
        if(!var_llvm_Instruction1)
        {
            return NULL;
        }
        var_llvm_Instruction = var_llvm_Instruction1;
    }
    llvm::ICmpInst* var_llvm_ICmpInst = downcast_llvm_Instruction_to_llvm_ICmpInst(var_llvm_Instruction);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_ICmpInst), "llvm::Value", "llvm::ICmpInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::BranchInst* downcast_llvm_Value_to_llvm_BranchInst(llvm::Value* arg)
{
    return typecast< llvm::BranchInst >::from(arg);
}

static
PyObject*
__downcast__llvm__Value__to__llvm__BranchInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    llvm::BranchInst* var_llvm_BranchInst = downcast_llvm_Value_to_llvm_BranchInst(var_llvm_Value);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_BranchInst), "llvm::Value", "llvm::BranchInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::BranchInst* downcast_llvm_User_to_llvm_BranchInst(llvm::User* arg)
{
    return typecast< llvm::BranchInst >::from(arg);
}

static
PyObject*
__downcast__llvm__User__to__llvm__BranchInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::User* var_llvm_User = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::User* var_llvm_User1 = unwrap_as<llvm::User, llvm::Value >::from(var_void);
        if(!var_llvm_User1)
        {
            return NULL;
        }
        var_llvm_User = var_llvm_User1;
    }
    llvm::BranchInst* var_llvm_BranchInst = downcast_llvm_User_to_llvm_BranchInst(var_llvm_User);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_BranchInst), "llvm::Value", "llvm::BranchInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::BranchInst* downcast_llvm_Instruction_to_llvm_BranchInst(llvm::Instruction* arg)
{
    return typecast< llvm::BranchInst >::from(arg);
}

static
PyObject*
__downcast__llvm__Instruction__to__llvm__BranchInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Instruction* var_llvm_Instruction = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void);
        if(!var_llvm_Instruction1)
        {
            return NULL;
        }
        var_llvm_Instruction = var_llvm_Instruction1;
    }
    llvm::BranchInst* var_llvm_BranchInst = downcast_llvm_Instruction_to_llvm_BranchInst(var_llvm_Instruction);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_BranchInst), "llvm::Value", "llvm::BranchInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::IndirectBrInst* downcast_llvm_Value_to_llvm_IndirectBrInst(llvm::Value* arg)
{
    return typecast< llvm::IndirectBrInst >::from(arg);
}

static
PyObject*
__downcast__llvm__Value__to__llvm__IndirectBrInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    llvm::IndirectBrInst* var_llvm_IndirectBrInst = downcast_llvm_Value_to_llvm_IndirectBrInst(var_llvm_Value);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_IndirectBrInst), "llvm::Value", "llvm::IndirectBrInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::IndirectBrInst* downcast_llvm_User_to_llvm_IndirectBrInst(llvm::User* arg)
{
    return typecast< llvm::IndirectBrInst >::from(arg);
}

static
PyObject*
__downcast__llvm__User__to__llvm__IndirectBrInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::User* var_llvm_User = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::User* var_llvm_User1 = unwrap_as<llvm::User, llvm::Value >::from(var_void);
        if(!var_llvm_User1)
        {
            return NULL;
        }
        var_llvm_User = var_llvm_User1;
    }
    llvm::IndirectBrInst* var_llvm_IndirectBrInst = downcast_llvm_User_to_llvm_IndirectBrInst(var_llvm_User);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_IndirectBrInst), "llvm::Value", "llvm::IndirectBrInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::IndirectBrInst* downcast_llvm_Instruction_to_llvm_IndirectBrInst(llvm::Instruction* arg)
{
    return typecast< llvm::IndirectBrInst >::from(arg);
}

static
PyObject*
__downcast__llvm__Instruction__to__llvm__IndirectBrInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Instruction* var_llvm_Instruction = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void);
        if(!var_llvm_Instruction1)
        {
            return NULL;
        }
        var_llvm_Instruction = var_llvm_Instruction1;
    }
    llvm::IndirectBrInst* var_llvm_IndirectBrInst = downcast_llvm_Instruction_to_llvm_IndirectBrInst(var_llvm_Instruction);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_IndirectBrInst), "llvm::Value", "llvm::IndirectBrInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::InvokeInst* downcast_llvm_Value_to_llvm_InvokeInst(llvm::Value* arg)
{
    return typecast< llvm::InvokeInst >::from(arg);
}

static
PyObject*
__downcast__llvm__Value__to__llvm__InvokeInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    llvm::InvokeInst* var_llvm_InvokeInst = downcast_llvm_Value_to_llvm_InvokeInst(var_llvm_Value);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_InvokeInst), "llvm::Value", "llvm::InvokeInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::InvokeInst* downcast_llvm_User_to_llvm_InvokeInst(llvm::User* arg)
{
    return typecast< llvm::InvokeInst >::from(arg);
}

static
PyObject*
__downcast__llvm__User__to__llvm__InvokeInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::User* var_llvm_User = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::User* var_llvm_User1 = unwrap_as<llvm::User, llvm::Value >::from(var_void);
        if(!var_llvm_User1)
        {
            return NULL;
        }
        var_llvm_User = var_llvm_User1;
    }
    llvm::InvokeInst* var_llvm_InvokeInst = downcast_llvm_User_to_llvm_InvokeInst(var_llvm_User);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_InvokeInst), "llvm::Value", "llvm::InvokeInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::InvokeInst* downcast_llvm_Instruction_to_llvm_InvokeInst(llvm::Instruction* arg)
{
    return typecast< llvm::InvokeInst >::from(arg);
}

static
PyObject*
__downcast__llvm__Instruction__to__llvm__InvokeInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Instruction* var_llvm_Instruction = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void);
        if(!var_llvm_Instruction1)
        {
            return NULL;
        }
        var_llvm_Instruction = var_llvm_Instruction1;
    }
    llvm::InvokeInst* var_llvm_InvokeInst = downcast_llvm_Instruction_to_llvm_InvokeInst(var_llvm_Instruction);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_InvokeInst), "llvm::Value", "llvm::InvokeInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::ResumeInst* downcast_llvm_Value_to_llvm_ResumeInst(llvm::Value* arg)
{
    return typecast< llvm::ResumeInst >::from(arg);
}

static
PyObject*
__downcast__llvm__Value__to__llvm__ResumeInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    llvm::ResumeInst* var_llvm_ResumeInst = downcast_llvm_Value_to_llvm_ResumeInst(var_llvm_Value);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_ResumeInst), "llvm::Value", "llvm::ResumeInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::ResumeInst* downcast_llvm_User_to_llvm_ResumeInst(llvm::User* arg)
{
    return typecast< llvm::ResumeInst >::from(arg);
}

static
PyObject*
__downcast__llvm__User__to__llvm__ResumeInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::User* var_llvm_User = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::User* var_llvm_User1 = unwrap_as<llvm::User, llvm::Value >::from(var_void);
        if(!var_llvm_User1)
        {
            return NULL;
        }
        var_llvm_User = var_llvm_User1;
    }
    llvm::ResumeInst* var_llvm_ResumeInst = downcast_llvm_User_to_llvm_ResumeInst(var_llvm_User);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_ResumeInst), "llvm::Value", "llvm::ResumeInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::ResumeInst* downcast_llvm_Instruction_to_llvm_ResumeInst(llvm::Instruction* arg)
{
    return typecast< llvm::ResumeInst >::from(arg);
}

static
PyObject*
__downcast__llvm__Instruction__to__llvm__ResumeInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Instruction* var_llvm_Instruction = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void);
        if(!var_llvm_Instruction1)
        {
            return NULL;
        }
        var_llvm_Instruction = var_llvm_Instruction1;
    }
    llvm::ResumeInst* var_llvm_ResumeInst = downcast_llvm_Instruction_to_llvm_ResumeInst(var_llvm_Instruction);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_ResumeInst), "llvm::Value", "llvm::ResumeInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::ReturnInst* downcast_llvm_Value_to_llvm_ReturnInst(llvm::Value* arg)
{
    return typecast< llvm::ReturnInst >::from(arg);
}

static
PyObject*
__downcast__llvm__Value__to__llvm__ReturnInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    llvm::ReturnInst* var_llvm_ReturnInst = downcast_llvm_Value_to_llvm_ReturnInst(var_llvm_Value);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_ReturnInst), "llvm::Value", "llvm::ReturnInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::ReturnInst* downcast_llvm_TerminatorInst_to_llvm_ReturnInst(llvm::TerminatorInst* arg)
{
    return typecast< llvm::ReturnInst >::from(arg);
}

static
PyObject*
__downcast__llvm__TerminatorInst__to__llvm__ReturnInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::TerminatorInst* var_llvm_TerminatorInst = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::TerminatorInst* var_llvm_TerminatorInst1 = unwrap_as<llvm::TerminatorInst, llvm::Value >::from(var_void);
        if(!var_llvm_TerminatorInst1)
        {
            return NULL;
        }
        var_llvm_TerminatorInst = var_llvm_TerminatorInst1;
    }
    llvm::ReturnInst* var_llvm_ReturnInst = downcast_llvm_TerminatorInst_to_llvm_ReturnInst(var_llvm_TerminatorInst);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_ReturnInst), "llvm::Value", "llvm::ReturnInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::ReturnInst* downcast_llvm_User_to_llvm_ReturnInst(llvm::User* arg)
{
    return typecast< llvm::ReturnInst >::from(arg);
}

static
PyObject*
__downcast__llvm__User__to__llvm__ReturnInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::User* var_llvm_User = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::User* var_llvm_User1 = unwrap_as<llvm::User, llvm::Value >::from(var_void);
        if(!var_llvm_User1)
        {
            return NULL;
        }
        var_llvm_User = var_llvm_User1;
    }
    llvm::ReturnInst* var_llvm_ReturnInst = downcast_llvm_User_to_llvm_ReturnInst(var_llvm_User);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_ReturnInst), "llvm::Value", "llvm::ReturnInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::ReturnInst* downcast_llvm_Instruction_to_llvm_ReturnInst(llvm::Instruction* arg)
{
    return typecast< llvm::ReturnInst >::from(arg);
}

static
PyObject*
__downcast__llvm__Instruction__to__llvm__ReturnInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Instruction* var_llvm_Instruction = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void);
        if(!var_llvm_Instruction1)
        {
            return NULL;
        }
        var_llvm_Instruction = var_llvm_Instruction1;
    }
    llvm::ReturnInst* var_llvm_ReturnInst = downcast_llvm_Instruction_to_llvm_ReturnInst(var_llvm_Instruction);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_ReturnInst), "llvm::Value", "llvm::ReturnInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::SwitchInst* downcast_llvm_Value_to_llvm_SwitchInst(llvm::Value* arg)
{
    return typecast< llvm::SwitchInst >::from(arg);
}

static
PyObject*
__downcast__llvm__Value__to__llvm__SwitchInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    llvm::SwitchInst* var_llvm_SwitchInst = downcast_llvm_Value_to_llvm_SwitchInst(var_llvm_Value);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_SwitchInst), "llvm::Value", "llvm::SwitchInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::SwitchInst* downcast_llvm_User_to_llvm_SwitchInst(llvm::User* arg)
{
    return typecast< llvm::SwitchInst >::from(arg);
}

static
PyObject*
__downcast__llvm__User__to__llvm__SwitchInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::User* var_llvm_User = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::User* var_llvm_User1 = unwrap_as<llvm::User, llvm::Value >::from(var_void);
        if(!var_llvm_User1)
        {
            return NULL;
        }
        var_llvm_User = var_llvm_User1;
    }
    llvm::SwitchInst* var_llvm_SwitchInst = downcast_llvm_User_to_llvm_SwitchInst(var_llvm_User);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_SwitchInst), "llvm::Value", "llvm::SwitchInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::SwitchInst* downcast_llvm_Instruction_to_llvm_SwitchInst(llvm::Instruction* arg)
{
    return typecast< llvm::SwitchInst >::from(arg);
}

static
PyObject*
__downcast__llvm__Instruction__to__llvm__SwitchInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Instruction* var_llvm_Instruction = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void);
        if(!var_llvm_Instruction1)
        {
            return NULL;
        }
        var_llvm_Instruction = var_llvm_Instruction1;
    }
    llvm::SwitchInst* var_llvm_SwitchInst = downcast_llvm_Instruction_to_llvm_SwitchInst(var_llvm_Instruction);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_SwitchInst), "llvm::Value", "llvm::SwitchInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::UnreachableInst* downcast_llvm_Value_to_llvm_UnreachableInst(llvm::Value* arg)
{
    return typecast< llvm::UnreachableInst >::from(arg);
}

static
PyObject*
__downcast__llvm__Value__to__llvm__UnreachableInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    llvm::UnreachableInst* var_llvm_UnreachableInst = downcast_llvm_Value_to_llvm_UnreachableInst(var_llvm_Value);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_UnreachableInst), "llvm::Value", "llvm::UnreachableInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::UnreachableInst* downcast_llvm_User_to_llvm_UnreachableInst(llvm::User* arg)
{
    return typecast< llvm::UnreachableInst >::from(arg);
}

static
PyObject*
__downcast__llvm__User__to__llvm__UnreachableInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::User* var_llvm_User = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::User* var_llvm_User1 = unwrap_as<llvm::User, llvm::Value >::from(var_void);
        if(!var_llvm_User1)
        {
            return NULL;
        }
        var_llvm_User = var_llvm_User1;
    }
    llvm::UnreachableInst* var_llvm_UnreachableInst = downcast_llvm_User_to_llvm_UnreachableInst(var_llvm_User);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_UnreachableInst), "llvm::Value", "llvm::UnreachableInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::UnreachableInst* downcast_llvm_Instruction_to_llvm_UnreachableInst(llvm::Instruction* arg)
{
    return typecast< llvm::UnreachableInst >::from(arg);
}

static
PyObject*
__downcast__llvm__Instruction__to__llvm__UnreachableInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Instruction* var_llvm_Instruction = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void);
        if(!var_llvm_Instruction1)
        {
            return NULL;
        }
        var_llvm_Instruction = var_llvm_Instruction1;
    }
    llvm::UnreachableInst* var_llvm_UnreachableInst = downcast_llvm_Instruction_to_llvm_UnreachableInst(var_llvm_Instruction);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_UnreachableInst), "llvm::Value", "llvm::UnreachableInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::AllocaInst* downcast_llvm_Value_to_llvm_AllocaInst(llvm::Value* arg)
{
    return typecast< llvm::AllocaInst >::from(arg);
}

static
PyObject*
__downcast__llvm__Value__to__llvm__AllocaInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    llvm::AllocaInst* var_llvm_AllocaInst = downcast_llvm_Value_to_llvm_AllocaInst(var_llvm_Value);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_AllocaInst), "llvm::Value", "llvm::AllocaInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::AllocaInst* downcast_llvm_User_to_llvm_AllocaInst(llvm::User* arg)
{
    return typecast< llvm::AllocaInst >::from(arg);
}

static
PyObject*
__downcast__llvm__User__to__llvm__AllocaInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::User* var_llvm_User = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::User* var_llvm_User1 = unwrap_as<llvm::User, llvm::Value >::from(var_void);
        if(!var_llvm_User1)
        {
            return NULL;
        }
        var_llvm_User = var_llvm_User1;
    }
    llvm::AllocaInst* var_llvm_AllocaInst = downcast_llvm_User_to_llvm_AllocaInst(var_llvm_User);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_AllocaInst), "llvm::Value", "llvm::AllocaInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::AllocaInst* downcast_llvm_Instruction_to_llvm_AllocaInst(llvm::Instruction* arg)
{
    return typecast< llvm::AllocaInst >::from(arg);
}

static
PyObject*
__downcast__llvm__Instruction__to__llvm__AllocaInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Instruction* var_llvm_Instruction = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void);
        if(!var_llvm_Instruction1)
        {
            return NULL;
        }
        var_llvm_Instruction = var_llvm_Instruction1;
    }
    llvm::AllocaInst* var_llvm_AllocaInst = downcast_llvm_Instruction_to_llvm_AllocaInst(var_llvm_Instruction);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_AllocaInst), "llvm::Value", "llvm::AllocaInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::CastInst* downcast_llvm_Value_to_llvm_CastInst(llvm::Value* arg)
{
    return typecast< llvm::CastInst >::from(arg);
}

static
PyObject*
__downcast__llvm__Value__to__llvm__CastInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    llvm::CastInst* var_llvm_CastInst = downcast_llvm_Value_to_llvm_CastInst(var_llvm_Value);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_CastInst), "llvm::Value", "llvm::CastInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::CastInst* downcast_llvm_User_to_llvm_CastInst(llvm::User* arg)
{
    return typecast< llvm::CastInst >::from(arg);
}

static
PyObject*
__downcast__llvm__User__to__llvm__CastInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::User* var_llvm_User = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::User* var_llvm_User1 = unwrap_as<llvm::User, llvm::Value >::from(var_void);
        if(!var_llvm_User1)
        {
            return NULL;
        }
        var_llvm_User = var_llvm_User1;
    }
    llvm::CastInst* var_llvm_CastInst = downcast_llvm_User_to_llvm_CastInst(var_llvm_User);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_CastInst), "llvm::Value", "llvm::CastInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::CastInst* downcast_llvm_Instruction_to_llvm_CastInst(llvm::Instruction* arg)
{
    return typecast< llvm::CastInst >::from(arg);
}

static
PyObject*
__downcast__llvm__Instruction__to__llvm__CastInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Instruction* var_llvm_Instruction = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void);
        if(!var_llvm_Instruction1)
        {
            return NULL;
        }
        var_llvm_Instruction = var_llvm_Instruction1;
    }
    llvm::CastInst* var_llvm_CastInst = downcast_llvm_Instruction_to_llvm_CastInst(var_llvm_Instruction);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_CastInst), "llvm::Value", "llvm::CastInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::ExtractValueInst* downcast_llvm_Value_to_llvm_ExtractValueInst(llvm::Value* arg)
{
    return typecast< llvm::ExtractValueInst >::from(arg);
}

static
PyObject*
__downcast__llvm__Value__to__llvm__ExtractValueInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    llvm::ExtractValueInst* var_llvm_ExtractValueInst = downcast_llvm_Value_to_llvm_ExtractValueInst(var_llvm_Value);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_ExtractValueInst), "llvm::Value", "llvm::ExtractValueInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::ExtractValueInst* downcast_llvm_User_to_llvm_ExtractValueInst(llvm::User* arg)
{
    return typecast< llvm::ExtractValueInst >::from(arg);
}

static
PyObject*
__downcast__llvm__User__to__llvm__ExtractValueInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::User* var_llvm_User = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::User* var_llvm_User1 = unwrap_as<llvm::User, llvm::Value >::from(var_void);
        if(!var_llvm_User1)
        {
            return NULL;
        }
        var_llvm_User = var_llvm_User1;
    }
    llvm::ExtractValueInst* var_llvm_ExtractValueInst = downcast_llvm_User_to_llvm_ExtractValueInst(var_llvm_User);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_ExtractValueInst), "llvm::Value", "llvm::ExtractValueInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::ExtractValueInst* downcast_llvm_Instruction_to_llvm_ExtractValueInst(llvm::Instruction* arg)
{
    return typecast< llvm::ExtractValueInst >::from(arg);
}

static
PyObject*
__downcast__llvm__Instruction__to__llvm__ExtractValueInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Instruction* var_llvm_Instruction = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void);
        if(!var_llvm_Instruction1)
        {
            return NULL;
        }
        var_llvm_Instruction = var_llvm_Instruction1;
    }
    llvm::ExtractValueInst* var_llvm_ExtractValueInst = downcast_llvm_Instruction_to_llvm_ExtractValueInst(var_llvm_Instruction);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_ExtractValueInst), "llvm::Value", "llvm::ExtractValueInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::LoadInst* downcast_llvm_Value_to_llvm_LoadInst(llvm::Value* arg)
{
    return typecast< llvm::LoadInst >::from(arg);
}

static
PyObject*
__downcast__llvm__Value__to__llvm__LoadInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    llvm::LoadInst* var_llvm_LoadInst = downcast_llvm_Value_to_llvm_LoadInst(var_llvm_Value);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_LoadInst), "llvm::Value", "llvm::LoadInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::LoadInst* downcast_llvm_User_to_llvm_LoadInst(llvm::User* arg)
{
    return typecast< llvm::LoadInst >::from(arg);
}

static
PyObject*
__downcast__llvm__User__to__llvm__LoadInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::User* var_llvm_User = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::User* var_llvm_User1 = unwrap_as<llvm::User, llvm::Value >::from(var_void);
        if(!var_llvm_User1)
        {
            return NULL;
        }
        var_llvm_User = var_llvm_User1;
    }
    llvm::LoadInst* var_llvm_LoadInst = downcast_llvm_User_to_llvm_LoadInst(var_llvm_User);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_LoadInst), "llvm::Value", "llvm::LoadInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::LoadInst* downcast_llvm_Instruction_to_llvm_LoadInst(llvm::Instruction* arg)
{
    return typecast< llvm::LoadInst >::from(arg);
}

static
PyObject*
__downcast__llvm__Instruction__to__llvm__LoadInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Instruction* var_llvm_Instruction = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void);
        if(!var_llvm_Instruction1)
        {
            return NULL;
        }
        var_llvm_Instruction = var_llvm_Instruction1;
    }
    llvm::LoadInst* var_llvm_LoadInst = downcast_llvm_Instruction_to_llvm_LoadInst(var_llvm_Instruction);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_LoadInst), "llvm::Value", "llvm::LoadInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::VAArgInst* downcast_llvm_Value_to_llvm_VAArgInst(llvm::Value* arg)
{
    return typecast< llvm::VAArgInst >::from(arg);
}

static
PyObject*
__downcast__llvm__Value__to__llvm__VAArgInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    llvm::VAArgInst* var_llvm_VAArgInst = downcast_llvm_Value_to_llvm_VAArgInst(var_llvm_Value);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_VAArgInst), "llvm::Value", "llvm::VAArgInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::VAArgInst* downcast_llvm_User_to_llvm_VAArgInst(llvm::User* arg)
{
    return typecast< llvm::VAArgInst >::from(arg);
}

static
PyObject*
__downcast__llvm__User__to__llvm__VAArgInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::User* var_llvm_User = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::User* var_llvm_User1 = unwrap_as<llvm::User, llvm::Value >::from(var_void);
        if(!var_llvm_User1)
        {
            return NULL;
        }
        var_llvm_User = var_llvm_User1;
    }
    llvm::VAArgInst* var_llvm_VAArgInst = downcast_llvm_User_to_llvm_VAArgInst(var_llvm_User);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_VAArgInst), "llvm::Value", "llvm::VAArgInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::VAArgInst* downcast_llvm_Instruction_to_llvm_VAArgInst(llvm::Instruction* arg)
{
    return typecast< llvm::VAArgInst >::from(arg);
}

static
PyObject*
__downcast__llvm__Instruction__to__llvm__VAArgInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Instruction* var_llvm_Instruction = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void);
        if(!var_llvm_Instruction1)
        {
            return NULL;
        }
        var_llvm_Instruction = var_llvm_Instruction1;
    }
    llvm::VAArgInst* var_llvm_VAArgInst = downcast_llvm_Instruction_to_llvm_VAArgInst(var_llvm_Instruction);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_VAArgInst), "llvm::Value", "llvm::VAArgInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::DbgInfoIntrinsic* downcast_llvm_Value_to_llvm_DbgInfoIntrinsic(llvm::Value* arg)
{
    return typecast< llvm::DbgInfoIntrinsic >::from(arg);
}

static
PyObject*
__downcast__llvm__Value__to__llvm__DbgInfoIntrinsic(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    llvm::DbgInfoIntrinsic* var_llvm_DbgInfoIntrinsic = downcast_llvm_Value_to_llvm_DbgInfoIntrinsic(var_llvm_Value);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_DbgInfoIntrinsic), "llvm::Value", "llvm::DbgInfoIntrinsic");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::DbgInfoIntrinsic* downcast_llvm_User_to_llvm_DbgInfoIntrinsic(llvm::User* arg)
{
    return typecast< llvm::DbgInfoIntrinsic >::from(arg);
}

static
PyObject*
__downcast__llvm__User__to__llvm__DbgInfoIntrinsic(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::User* var_llvm_User = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::User* var_llvm_User1 = unwrap_as<llvm::User, llvm::Value >::from(var_void);
        if(!var_llvm_User1)
        {
            return NULL;
        }
        var_llvm_User = var_llvm_User1;
    }
    llvm::DbgInfoIntrinsic* var_llvm_DbgInfoIntrinsic = downcast_llvm_User_to_llvm_DbgInfoIntrinsic(var_llvm_User);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_DbgInfoIntrinsic), "llvm::Value", "llvm::DbgInfoIntrinsic");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::DbgInfoIntrinsic* downcast_llvm_Instruction_to_llvm_DbgInfoIntrinsic(llvm::Instruction* arg)
{
    return typecast< llvm::DbgInfoIntrinsic >::from(arg);
}

static
PyObject*
__downcast__llvm__Instruction__to__llvm__DbgInfoIntrinsic(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Instruction* var_llvm_Instruction = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void);
        if(!var_llvm_Instruction1)
        {
            return NULL;
        }
        var_llvm_Instruction = var_llvm_Instruction1;
    }
    llvm::DbgInfoIntrinsic* var_llvm_DbgInfoIntrinsic = downcast_llvm_Instruction_to_llvm_DbgInfoIntrinsic(var_llvm_Instruction);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_DbgInfoIntrinsic), "llvm::Value", "llvm::DbgInfoIntrinsic");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::MemIntrinsic* downcast_llvm_Value_to_llvm_MemIntrinsic(llvm::Value* arg)
{
    return typecast< llvm::MemIntrinsic >::from(arg);
}

static
PyObject*
__downcast__llvm__Value__to__llvm__MemIntrinsic(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    llvm::MemIntrinsic* var_llvm_MemIntrinsic = downcast_llvm_Value_to_llvm_MemIntrinsic(var_llvm_Value);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_MemIntrinsic), "llvm::Value", "llvm::MemIntrinsic");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::MemIntrinsic* downcast_llvm_User_to_llvm_MemIntrinsic(llvm::User* arg)
{
    return typecast< llvm::MemIntrinsic >::from(arg);
}

static
PyObject*
__downcast__llvm__User__to__llvm__MemIntrinsic(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::User* var_llvm_User = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::User* var_llvm_User1 = unwrap_as<llvm::User, llvm::Value >::from(var_void);
        if(!var_llvm_User1)
        {
            return NULL;
        }
        var_llvm_User = var_llvm_User1;
    }
    llvm::MemIntrinsic* var_llvm_MemIntrinsic = downcast_llvm_User_to_llvm_MemIntrinsic(var_llvm_User);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_MemIntrinsic), "llvm::Value", "llvm::MemIntrinsic");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::MemIntrinsic* downcast_llvm_Instruction_to_llvm_MemIntrinsic(llvm::Instruction* arg)
{
    return typecast< llvm::MemIntrinsic >::from(arg);
}

static
PyObject*
__downcast__llvm__Instruction__to__llvm__MemIntrinsic(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Instruction* var_llvm_Instruction = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void);
        if(!var_llvm_Instruction1)
        {
            return NULL;
        }
        var_llvm_Instruction = var_llvm_Instruction1;
    }
    llvm::MemIntrinsic* var_llvm_MemIntrinsic = downcast_llvm_Instruction_to_llvm_MemIntrinsic(var_llvm_Instruction);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_MemIntrinsic), "llvm::Value", "llvm::MemIntrinsic");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::VACopyInst* downcast_llvm_Value_to_llvm_VACopyInst(llvm::Value* arg)
{
    return typecast< llvm::VACopyInst >::from(arg);
}

static
PyObject*
__downcast__llvm__Value__to__llvm__VACopyInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    llvm::VACopyInst* var_llvm_VACopyInst = downcast_llvm_Value_to_llvm_VACopyInst(var_llvm_Value);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_VACopyInst), "llvm::Value", "llvm::VACopyInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::VACopyInst* downcast_llvm_User_to_llvm_VACopyInst(llvm::User* arg)
{
    return typecast< llvm::VACopyInst >::from(arg);
}

static
PyObject*
__downcast__llvm__User__to__llvm__VACopyInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::User* var_llvm_User = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::User* var_llvm_User1 = unwrap_as<llvm::User, llvm::Value >::from(var_void);
        if(!var_llvm_User1)
        {
            return NULL;
        }
        var_llvm_User = var_llvm_User1;
    }
    llvm::VACopyInst* var_llvm_VACopyInst = downcast_llvm_User_to_llvm_VACopyInst(var_llvm_User);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_VACopyInst), "llvm::Value", "llvm::VACopyInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::VACopyInst* downcast_llvm_Instruction_to_llvm_VACopyInst(llvm::Instruction* arg)
{
    return typecast< llvm::VACopyInst >::from(arg);
}

static
PyObject*
__downcast__llvm__Instruction__to__llvm__VACopyInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Instruction* var_llvm_Instruction = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void);
        if(!var_llvm_Instruction1)
        {
            return NULL;
        }
        var_llvm_Instruction = var_llvm_Instruction1;
    }
    llvm::VACopyInst* var_llvm_VACopyInst = downcast_llvm_Instruction_to_llvm_VACopyInst(var_llvm_Instruction);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_VACopyInst), "llvm::Value", "llvm::VACopyInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::VAEndInst* downcast_llvm_Value_to_llvm_VAEndInst(llvm::Value* arg)
{
    return typecast< llvm::VAEndInst >::from(arg);
}

static
PyObject*
__downcast__llvm__Value__to__llvm__VAEndInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    llvm::VAEndInst* var_llvm_VAEndInst = downcast_llvm_Value_to_llvm_VAEndInst(var_llvm_Value);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_VAEndInst), "llvm::Value", "llvm::VAEndInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::VAEndInst* downcast_llvm_User_to_llvm_VAEndInst(llvm::User* arg)
{
    return typecast< llvm::VAEndInst >::from(arg);
}

static
PyObject*
__downcast__llvm__User__to__llvm__VAEndInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::User* var_llvm_User = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::User* var_llvm_User1 = unwrap_as<llvm::User, llvm::Value >::from(var_void);
        if(!var_llvm_User1)
        {
            return NULL;
        }
        var_llvm_User = var_llvm_User1;
    }
    llvm::VAEndInst* var_llvm_VAEndInst = downcast_llvm_User_to_llvm_VAEndInst(var_llvm_User);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_VAEndInst), "llvm::Value", "llvm::VAEndInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::VAEndInst* downcast_llvm_Instruction_to_llvm_VAEndInst(llvm::Instruction* arg)
{
    return typecast< llvm::VAEndInst >::from(arg);
}

static
PyObject*
__downcast__llvm__Instruction__to__llvm__VAEndInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Instruction* var_llvm_Instruction = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void);
        if(!var_llvm_Instruction1)
        {
            return NULL;
        }
        var_llvm_Instruction = var_llvm_Instruction1;
    }
    llvm::VAEndInst* var_llvm_VAEndInst = downcast_llvm_Instruction_to_llvm_VAEndInst(var_llvm_Instruction);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_VAEndInst), "llvm::Value", "llvm::VAEndInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::VAStartInst* downcast_llvm_Value_to_llvm_VAStartInst(llvm::Value* arg)
{
    return typecast< llvm::VAStartInst >::from(arg);
}

static
PyObject*
__downcast__llvm__Value__to__llvm__VAStartInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    llvm::VAStartInst* var_llvm_VAStartInst = downcast_llvm_Value_to_llvm_VAStartInst(var_llvm_Value);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_VAStartInst), "llvm::Value", "llvm::VAStartInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::VAStartInst* downcast_llvm_User_to_llvm_VAStartInst(llvm::User* arg)
{
    return typecast< llvm::VAStartInst >::from(arg);
}

static
PyObject*
__downcast__llvm__User__to__llvm__VAStartInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::User* var_llvm_User = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::User* var_llvm_User1 = unwrap_as<llvm::User, llvm::Value >::from(var_void);
        if(!var_llvm_User1)
        {
            return NULL;
        }
        var_llvm_User = var_llvm_User1;
    }
    llvm::VAStartInst* var_llvm_VAStartInst = downcast_llvm_User_to_llvm_VAStartInst(var_llvm_User);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_VAStartInst), "llvm::Value", "llvm::VAStartInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::VAStartInst* downcast_llvm_Instruction_to_llvm_VAStartInst(llvm::Instruction* arg)
{
    return typecast< llvm::VAStartInst >::from(arg);
}

static
PyObject*
__downcast__llvm__Instruction__to__llvm__VAStartInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Instruction* var_llvm_Instruction = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void);
        if(!var_llvm_Instruction1)
        {
            return NULL;
        }
        var_llvm_Instruction = var_llvm_Instruction1;
    }
    llvm::VAStartInst* var_llvm_VAStartInst = downcast_llvm_Instruction_to_llvm_VAStartInst(var_llvm_Instruction);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_VAStartInst), "llvm::Value", "llvm::VAStartInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::BitCastInst* downcast_llvm_Value_to_llvm_BitCastInst(llvm::Value* arg)
{
    return typecast< llvm::BitCastInst >::from(arg);
}

static
PyObject*
__downcast__llvm__Value__to__llvm__BitCastInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    llvm::BitCastInst* var_llvm_BitCastInst = downcast_llvm_Value_to_llvm_BitCastInst(var_llvm_Value);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_BitCastInst), "llvm::Value", "llvm::BitCastInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::BitCastInst* downcast_llvm_User_to_llvm_BitCastInst(llvm::User* arg)
{
    return typecast< llvm::BitCastInst >::from(arg);
}

static
PyObject*
__downcast__llvm__User__to__llvm__BitCastInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::User* var_llvm_User = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::User* var_llvm_User1 = unwrap_as<llvm::User, llvm::Value >::from(var_void);
        if(!var_llvm_User1)
        {
            return NULL;
        }
        var_llvm_User = var_llvm_User1;
    }
    llvm::BitCastInst* var_llvm_BitCastInst = downcast_llvm_User_to_llvm_BitCastInst(var_llvm_User);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_BitCastInst), "llvm::Value", "llvm::BitCastInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::BitCastInst* downcast_llvm_Instruction_to_llvm_BitCastInst(llvm::Instruction* arg)
{
    return typecast< llvm::BitCastInst >::from(arg);
}

static
PyObject*
__downcast__llvm__Instruction__to__llvm__BitCastInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Instruction* var_llvm_Instruction = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void);
        if(!var_llvm_Instruction1)
        {
            return NULL;
        }
        var_llvm_Instruction = var_llvm_Instruction1;
    }
    llvm::BitCastInst* var_llvm_BitCastInst = downcast_llvm_Instruction_to_llvm_BitCastInst(var_llvm_Instruction);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_BitCastInst), "llvm::Value", "llvm::BitCastInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::FPExtInst* downcast_llvm_Value_to_llvm_FPExtInst(llvm::Value* arg)
{
    return typecast< llvm::FPExtInst >::from(arg);
}

static
PyObject*
__downcast__llvm__Value__to__llvm__FPExtInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    llvm::FPExtInst* var_llvm_FPExtInst = downcast_llvm_Value_to_llvm_FPExtInst(var_llvm_Value);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_FPExtInst), "llvm::Value", "llvm::FPExtInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::FPExtInst* downcast_llvm_User_to_llvm_FPExtInst(llvm::User* arg)
{
    return typecast< llvm::FPExtInst >::from(arg);
}

static
PyObject*
__downcast__llvm__User__to__llvm__FPExtInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::User* var_llvm_User = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::User* var_llvm_User1 = unwrap_as<llvm::User, llvm::Value >::from(var_void);
        if(!var_llvm_User1)
        {
            return NULL;
        }
        var_llvm_User = var_llvm_User1;
    }
    llvm::FPExtInst* var_llvm_FPExtInst = downcast_llvm_User_to_llvm_FPExtInst(var_llvm_User);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_FPExtInst), "llvm::Value", "llvm::FPExtInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::FPExtInst* downcast_llvm_Instruction_to_llvm_FPExtInst(llvm::Instruction* arg)
{
    return typecast< llvm::FPExtInst >::from(arg);
}

static
PyObject*
__downcast__llvm__Instruction__to__llvm__FPExtInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Instruction* var_llvm_Instruction = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void);
        if(!var_llvm_Instruction1)
        {
            return NULL;
        }
        var_llvm_Instruction = var_llvm_Instruction1;
    }
    llvm::FPExtInst* var_llvm_FPExtInst = downcast_llvm_Instruction_to_llvm_FPExtInst(var_llvm_Instruction);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_FPExtInst), "llvm::Value", "llvm::FPExtInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::FPToSIInst* downcast_llvm_Value_to_llvm_FPToSIInst(llvm::Value* arg)
{
    return typecast< llvm::FPToSIInst >::from(arg);
}

static
PyObject*
__downcast__llvm__Value__to__llvm__FPToSIInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    llvm::FPToSIInst* var_llvm_FPToSIInst = downcast_llvm_Value_to_llvm_FPToSIInst(var_llvm_Value);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_FPToSIInst), "llvm::Value", "llvm::FPToSIInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::FPToSIInst* downcast_llvm_User_to_llvm_FPToSIInst(llvm::User* arg)
{
    return typecast< llvm::FPToSIInst >::from(arg);
}

static
PyObject*
__downcast__llvm__User__to__llvm__FPToSIInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::User* var_llvm_User = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::User* var_llvm_User1 = unwrap_as<llvm::User, llvm::Value >::from(var_void);
        if(!var_llvm_User1)
        {
            return NULL;
        }
        var_llvm_User = var_llvm_User1;
    }
    llvm::FPToSIInst* var_llvm_FPToSIInst = downcast_llvm_User_to_llvm_FPToSIInst(var_llvm_User);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_FPToSIInst), "llvm::Value", "llvm::FPToSIInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::FPToSIInst* downcast_llvm_Instruction_to_llvm_FPToSIInst(llvm::Instruction* arg)
{
    return typecast< llvm::FPToSIInst >::from(arg);
}

static
PyObject*
__downcast__llvm__Instruction__to__llvm__FPToSIInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Instruction* var_llvm_Instruction = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void);
        if(!var_llvm_Instruction1)
        {
            return NULL;
        }
        var_llvm_Instruction = var_llvm_Instruction1;
    }
    llvm::FPToSIInst* var_llvm_FPToSIInst = downcast_llvm_Instruction_to_llvm_FPToSIInst(var_llvm_Instruction);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_FPToSIInst), "llvm::Value", "llvm::FPToSIInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::FPToUIInst* downcast_llvm_Value_to_llvm_FPToUIInst(llvm::Value* arg)
{
    return typecast< llvm::FPToUIInst >::from(arg);
}

static
PyObject*
__downcast__llvm__Value__to__llvm__FPToUIInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    llvm::FPToUIInst* var_llvm_FPToUIInst = downcast_llvm_Value_to_llvm_FPToUIInst(var_llvm_Value);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_FPToUIInst), "llvm::Value", "llvm::FPToUIInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::FPToUIInst* downcast_llvm_User_to_llvm_FPToUIInst(llvm::User* arg)
{
    return typecast< llvm::FPToUIInst >::from(arg);
}

static
PyObject*
__downcast__llvm__User__to__llvm__FPToUIInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::User* var_llvm_User = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::User* var_llvm_User1 = unwrap_as<llvm::User, llvm::Value >::from(var_void);
        if(!var_llvm_User1)
        {
            return NULL;
        }
        var_llvm_User = var_llvm_User1;
    }
    llvm::FPToUIInst* var_llvm_FPToUIInst = downcast_llvm_User_to_llvm_FPToUIInst(var_llvm_User);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_FPToUIInst), "llvm::Value", "llvm::FPToUIInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::FPToUIInst* downcast_llvm_Instruction_to_llvm_FPToUIInst(llvm::Instruction* arg)
{
    return typecast< llvm::FPToUIInst >::from(arg);
}

static
PyObject*
__downcast__llvm__Instruction__to__llvm__FPToUIInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Instruction* var_llvm_Instruction = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void);
        if(!var_llvm_Instruction1)
        {
            return NULL;
        }
        var_llvm_Instruction = var_llvm_Instruction1;
    }
    llvm::FPToUIInst* var_llvm_FPToUIInst = downcast_llvm_Instruction_to_llvm_FPToUIInst(var_llvm_Instruction);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_FPToUIInst), "llvm::Value", "llvm::FPToUIInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::FPTruncInst* downcast_llvm_Value_to_llvm_FPTruncInst(llvm::Value* arg)
{
    return typecast< llvm::FPTruncInst >::from(arg);
}

static
PyObject*
__downcast__llvm__Value__to__llvm__FPTruncInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    llvm::FPTruncInst* var_llvm_FPTruncInst = downcast_llvm_Value_to_llvm_FPTruncInst(var_llvm_Value);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_FPTruncInst), "llvm::Value", "llvm::FPTruncInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::FPTruncInst* downcast_llvm_User_to_llvm_FPTruncInst(llvm::User* arg)
{
    return typecast< llvm::FPTruncInst >::from(arg);
}

static
PyObject*
__downcast__llvm__User__to__llvm__FPTruncInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::User* var_llvm_User = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::User* var_llvm_User1 = unwrap_as<llvm::User, llvm::Value >::from(var_void);
        if(!var_llvm_User1)
        {
            return NULL;
        }
        var_llvm_User = var_llvm_User1;
    }
    llvm::FPTruncInst* var_llvm_FPTruncInst = downcast_llvm_User_to_llvm_FPTruncInst(var_llvm_User);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_FPTruncInst), "llvm::Value", "llvm::FPTruncInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::FPTruncInst* downcast_llvm_Instruction_to_llvm_FPTruncInst(llvm::Instruction* arg)
{
    return typecast< llvm::FPTruncInst >::from(arg);
}

static
PyObject*
__downcast__llvm__Instruction__to__llvm__FPTruncInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Instruction* var_llvm_Instruction = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void);
        if(!var_llvm_Instruction1)
        {
            return NULL;
        }
        var_llvm_Instruction = var_llvm_Instruction1;
    }
    llvm::FPTruncInst* var_llvm_FPTruncInst = downcast_llvm_Instruction_to_llvm_FPTruncInst(var_llvm_Instruction);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_FPTruncInst), "llvm::Value", "llvm::FPTruncInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}


static
llvm::FunctionType* downcast_llvm_Type_to_llvm_FunctionType(llvm::Type* arg)
{
    return typecast< llvm::FunctionType >::from(arg);
}

static
PyObject*
__downcast__llvm__Type__to__llvm__FunctionType(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    llvm::FunctionType* var_llvm_FunctionType = downcast_llvm_Type_to_llvm_FunctionType(var_llvm_Type);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Type >::from(var_llvm_FunctionType), "llvm::Type", "llvm::FunctionType");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyMethodDef downcast_methodtable[] = {
{ "downcast_llvm_Value_to_llvm_Argument", (PyCFunction)__downcast__llvm__Value__to__llvm__Argument, METH_VARARGS, NULL },
{ "downcast_llvm_Value_to_llvm_MDNode", (PyCFunction)__downcast__llvm__Value__to__llvm__MDNode, METH_VARARGS, NULL },
{ "downcast_llvm_Value_to_llvm_MDString", (PyCFunction)__downcast__llvm__Value__to__llvm__MDString, METH_VARARGS, NULL },
{ "downcast_llvm_Value_to_llvm_User", (PyCFunction)__downcast__llvm__Value__to__llvm__User, METH_VARARGS, NULL },
{ "downcast_llvm_Value_to_llvm_BasicBlock", (PyCFunction)__downcast__llvm__Value__to__llvm__BasicBlock, METH_VARARGS, NULL },
{ "downcast_llvm_Value_to_llvm_Constant", (PyCFunction)__downcast__llvm__Value__to__llvm__Constant, METH_VARARGS, NULL },
{ "downcast_llvm_User_to_llvm_Constant", (PyCFunction)__downcast__llvm__User__to__llvm__Constant, METH_VARARGS, NULL },
{ "downcast_llvm_Value_to_llvm_Function", (PyCFunction)__downcast__llvm__Value__to__llvm__Function, METH_VARARGS, NULL },
{ "downcast_llvm_GlobalValue_to_llvm_Function", (PyCFunction)__downcast__llvm__GlobalValue__to__llvm__Function, METH_VARARGS, NULL },
{ "downcast_llvm_Constant_to_llvm_Function", (PyCFunction)__downcast__llvm__Constant__to__llvm__Function, METH_VARARGS, NULL },
{ "downcast_llvm_Value_to_llvm_ConstantInt", (PyCFunction)__downcast__llvm__Value__to__llvm__ConstantInt, METH_VARARGS, NULL },
{ "downcast_llvm_Constant_to_llvm_ConstantInt", (PyCFunction)__downcast__llvm__Constant__to__llvm__ConstantInt, METH_VARARGS, NULL },
{ "downcast_llvm_User_to_llvm_ConstantInt", (PyCFunction)__downcast__llvm__User__to__llvm__ConstantInt, METH_VARARGS, NULL },
{ "downcast_llvm_Value_to_llvm_ConstantFP", (PyCFunction)__downcast__llvm__Value__to__llvm__ConstantFP, METH_VARARGS, NULL },
{ "downcast_llvm_Constant_to_llvm_ConstantFP", (PyCFunction)__downcast__llvm__Constant__to__llvm__ConstantFP, METH_VARARGS, NULL },
{ "downcast_llvm_User_to_llvm_ConstantFP", (PyCFunction)__downcast__llvm__User__to__llvm__ConstantFP, METH_VARARGS, NULL },
{ "downcast_llvm_Value_to_llvm_ConstantArray", (PyCFunction)__downcast__llvm__Value__to__llvm__ConstantArray, METH_VARARGS, NULL },
{ "downcast_llvm_Constant_to_llvm_ConstantArray", (PyCFunction)__downcast__llvm__Constant__to__llvm__ConstantArray, METH_VARARGS, NULL },
{ "downcast_llvm_User_to_llvm_ConstantArray", (PyCFunction)__downcast__llvm__User__to__llvm__ConstantArray, METH_VARARGS, NULL },
{ "downcast_llvm_Value_to_llvm_ConstantStruct", (PyCFunction)__downcast__llvm__Value__to__llvm__ConstantStruct, METH_VARARGS, NULL },
{ "downcast_llvm_Constant_to_llvm_ConstantStruct", (PyCFunction)__downcast__llvm__Constant__to__llvm__ConstantStruct, METH_VARARGS, NULL },
{ "downcast_llvm_User_to_llvm_ConstantStruct", (PyCFunction)__downcast__llvm__User__to__llvm__ConstantStruct, METH_VARARGS, NULL },
{ "downcast_llvm_Value_to_llvm_ConstantVector", (PyCFunction)__downcast__llvm__Value__to__llvm__ConstantVector, METH_VARARGS, NULL },
{ "downcast_llvm_Constant_to_llvm_ConstantVector", (PyCFunction)__downcast__llvm__Constant__to__llvm__ConstantVector, METH_VARARGS, NULL },
{ "downcast_llvm_User_to_llvm_ConstantVector", (PyCFunction)__downcast__llvm__User__to__llvm__ConstantVector, METH_VARARGS, NULL },
{ "downcast_llvm_Value_to_llvm_ConstantDataSequential", (PyCFunction)__downcast__llvm__Value__to__llvm__ConstantDataSequential, METH_VARARGS, NULL },
{ "downcast_llvm_Constant_to_llvm_ConstantDataSequential", (PyCFunction)__downcast__llvm__Constant__to__llvm__ConstantDataSequential, METH_VARARGS, NULL },
{ "downcast_llvm_User_to_llvm_ConstantDataSequential", (PyCFunction)__downcast__llvm__User__to__llvm__ConstantDataSequential, METH_VARARGS, NULL },
{ "downcast_llvm_Value_to_llvm_ConstantDataArray", (PyCFunction)__downcast__llvm__Value__to__llvm__ConstantDataArray, METH_VARARGS, NULL },
{ "downcast_llvm_Constant_to_llvm_ConstantDataArray", (PyCFunction)__downcast__llvm__Constant__to__llvm__ConstantDataArray, METH_VARARGS, NULL },
{ "downcast_llvm_User_to_llvm_ConstantDataArray", (PyCFunction)__downcast__llvm__User__to__llvm__ConstantDataArray, METH_VARARGS, NULL },
{ "downcast_llvm_Value_to_llvm_ConstantExpr", (PyCFunction)__downcast__llvm__Value__to__llvm__ConstantExpr, METH_VARARGS, NULL },
{ "downcast_llvm_Constant_to_llvm_ConstantExpr", (PyCFunction)__downcast__llvm__Constant__to__llvm__ConstantExpr, METH_VARARGS, NULL },
{ "downcast_llvm_User_to_llvm_ConstantExpr", (PyCFunction)__downcast__llvm__User__to__llvm__ConstantExpr, METH_VARARGS, NULL },
{ "downcast_llvm_Type_to_llvm_IntegerType", (PyCFunction)__downcast__llvm__Type__to__llvm__IntegerType, METH_VARARGS, NULL },
{ "downcast_llvm_Type_to_llvm_CompositeType", (PyCFunction)__downcast__llvm__Type__to__llvm__CompositeType, METH_VARARGS, NULL },
{ "downcast_llvm_Type_to_llvm_StructType", (PyCFunction)__downcast__llvm__Type__to__llvm__StructType, METH_VARARGS, NULL },
{ "downcast_llvm_Type_to_llvm_SequentialType", (PyCFunction)__downcast__llvm__Type__to__llvm__SequentialType, METH_VARARGS, NULL },
{ "downcast_llvm_Type_to_llvm_ArrayType", (PyCFunction)__downcast__llvm__Type__to__llvm__ArrayType, METH_VARARGS, NULL },
{ "downcast_llvm_Type_to_llvm_PointerType", (PyCFunction)__downcast__llvm__Type__to__llvm__PointerType, METH_VARARGS, NULL },
{ "downcast_llvm_Type_to_llvm_VectorType", (PyCFunction)__downcast__llvm__Type__to__llvm__VectorType, METH_VARARGS, NULL },
{ "downcast_llvm_Value_to_llvm_GlobalVariable", (PyCFunction)__downcast__llvm__Value__to__llvm__GlobalVariable, METH_VARARGS, NULL },
{ "downcast_llvm_User_to_llvm_GlobalVariable", (PyCFunction)__downcast__llvm__User__to__llvm__GlobalVariable, METH_VARARGS, NULL },
{ "downcast_llvm_Constant_to_llvm_GlobalVariable", (PyCFunction)__downcast__llvm__Constant__to__llvm__GlobalVariable, METH_VARARGS, NULL },
{ "downcast_llvm_Value_to_llvm_Instruction", (PyCFunction)__downcast__llvm__Value__to__llvm__Instruction, METH_VARARGS, NULL },
{ "downcast_llvm_User_to_llvm_Instruction", (PyCFunction)__downcast__llvm__User__to__llvm__Instruction, METH_VARARGS, NULL },
{ "downcast_llvm_Value_to_llvm_AtomicCmpXchgInst", (PyCFunction)__downcast__llvm__Value__to__llvm__AtomicCmpXchgInst, METH_VARARGS, NULL },
{ "downcast_llvm_User_to_llvm_AtomicCmpXchgInst", (PyCFunction)__downcast__llvm__User__to__llvm__AtomicCmpXchgInst, METH_VARARGS, NULL },
{ "downcast_llvm_Instruction_to_llvm_AtomicCmpXchgInst", (PyCFunction)__downcast__llvm__Instruction__to__llvm__AtomicCmpXchgInst, METH_VARARGS, NULL },
{ "downcast_llvm_Value_to_llvm_AtomicRMWInst", (PyCFunction)__downcast__llvm__Value__to__llvm__AtomicRMWInst, METH_VARARGS, NULL },
{ "downcast_llvm_User_to_llvm_AtomicRMWInst", (PyCFunction)__downcast__llvm__User__to__llvm__AtomicRMWInst, METH_VARARGS, NULL },
{ "downcast_llvm_Instruction_to_llvm_AtomicRMWInst", (PyCFunction)__downcast__llvm__Instruction__to__llvm__AtomicRMWInst, METH_VARARGS, NULL },
{ "downcast_llvm_Value_to_llvm_BinaryOperator", (PyCFunction)__downcast__llvm__Value__to__llvm__BinaryOperator, METH_VARARGS, NULL },
{ "downcast_llvm_User_to_llvm_BinaryOperator", (PyCFunction)__downcast__llvm__User__to__llvm__BinaryOperator, METH_VARARGS, NULL },
{ "downcast_llvm_Instruction_to_llvm_BinaryOperator", (PyCFunction)__downcast__llvm__Instruction__to__llvm__BinaryOperator, METH_VARARGS, NULL },
{ "downcast_llvm_Value_to_llvm_CallInst", (PyCFunction)__downcast__llvm__Value__to__llvm__CallInst, METH_VARARGS, NULL },
{ "downcast_llvm_User_to_llvm_CallInst", (PyCFunction)__downcast__llvm__User__to__llvm__CallInst, METH_VARARGS, NULL },
{ "downcast_llvm_Instruction_to_llvm_CallInst", (PyCFunction)__downcast__llvm__Instruction__to__llvm__CallInst, METH_VARARGS, NULL },
{ "downcast_llvm_Value_to_llvm_CmpInst", (PyCFunction)__downcast__llvm__Value__to__llvm__CmpInst, METH_VARARGS, NULL },
{ "downcast_llvm_User_to_llvm_CmpInst", (PyCFunction)__downcast__llvm__User__to__llvm__CmpInst, METH_VARARGS, NULL },
{ "downcast_llvm_Instruction_to_llvm_CmpInst", (PyCFunction)__downcast__llvm__Instruction__to__llvm__CmpInst, METH_VARARGS, NULL },
{ "downcast_llvm_Value_to_llvm_ExtractElementInst", (PyCFunction)__downcast__llvm__Value__to__llvm__ExtractElementInst, METH_VARARGS, NULL },
{ "downcast_llvm_User_to_llvm_ExtractElementInst", (PyCFunction)__downcast__llvm__User__to__llvm__ExtractElementInst, METH_VARARGS, NULL },
{ "downcast_llvm_Instruction_to_llvm_ExtractElementInst", (PyCFunction)__downcast__llvm__Instruction__to__llvm__ExtractElementInst, METH_VARARGS, NULL },
{ "downcast_llvm_Value_to_llvm_FenceInst", (PyCFunction)__downcast__llvm__Value__to__llvm__FenceInst, METH_VARARGS, NULL },
{ "downcast_llvm_User_to_llvm_FenceInst", (PyCFunction)__downcast__llvm__User__to__llvm__FenceInst, METH_VARARGS, NULL },
{ "downcast_llvm_Instruction_to_llvm_FenceInst", (PyCFunction)__downcast__llvm__Instruction__to__llvm__FenceInst, METH_VARARGS, NULL },
{ "downcast_llvm_Value_to_llvm_GetElementPtrInst", (PyCFunction)__downcast__llvm__Value__to__llvm__GetElementPtrInst, METH_VARARGS, NULL },
{ "downcast_llvm_User_to_llvm_GetElementPtrInst", (PyCFunction)__downcast__llvm__User__to__llvm__GetElementPtrInst, METH_VARARGS, NULL },
{ "downcast_llvm_Instruction_to_llvm_GetElementPtrInst", (PyCFunction)__downcast__llvm__Instruction__to__llvm__GetElementPtrInst, METH_VARARGS, NULL },
{ "downcast_llvm_Value_to_llvm_InsertElementInst", (PyCFunction)__downcast__llvm__Value__to__llvm__InsertElementInst, METH_VARARGS, NULL },
{ "downcast_llvm_User_to_llvm_InsertElementInst", (PyCFunction)__downcast__llvm__User__to__llvm__InsertElementInst, METH_VARARGS, NULL },
{ "downcast_llvm_Instruction_to_llvm_InsertElementInst", (PyCFunction)__downcast__llvm__Instruction__to__llvm__InsertElementInst, METH_VARARGS, NULL },
{ "downcast_llvm_Value_to_llvm_InsertValueInst", (PyCFunction)__downcast__llvm__Value__to__llvm__InsertValueInst, METH_VARARGS, NULL },
{ "downcast_llvm_User_to_llvm_InsertValueInst", (PyCFunction)__downcast__llvm__User__to__llvm__InsertValueInst, METH_VARARGS, NULL },
{ "downcast_llvm_Instruction_to_llvm_InsertValueInst", (PyCFunction)__downcast__llvm__Instruction__to__llvm__InsertValueInst, METH_VARARGS, NULL },
{ "downcast_llvm_Value_to_llvm_LandingPadInst", (PyCFunction)__downcast__llvm__Value__to__llvm__LandingPadInst, METH_VARARGS, NULL },
{ "downcast_llvm_User_to_llvm_LandingPadInst", (PyCFunction)__downcast__llvm__User__to__llvm__LandingPadInst, METH_VARARGS, NULL },
{ "downcast_llvm_Instruction_to_llvm_LandingPadInst", (PyCFunction)__downcast__llvm__Instruction__to__llvm__LandingPadInst, METH_VARARGS, NULL },
{ "downcast_llvm_Value_to_llvm_PHINode", (PyCFunction)__downcast__llvm__Value__to__llvm__PHINode, METH_VARARGS, NULL },
{ "downcast_llvm_User_to_llvm_PHINode", (PyCFunction)__downcast__llvm__User__to__llvm__PHINode, METH_VARARGS, NULL },
{ "downcast_llvm_Instruction_to_llvm_PHINode", (PyCFunction)__downcast__llvm__Instruction__to__llvm__PHINode, METH_VARARGS, NULL },
{ "downcast_llvm_Value_to_llvm_SelectInst", (PyCFunction)__downcast__llvm__Value__to__llvm__SelectInst, METH_VARARGS, NULL },
{ "downcast_llvm_User_to_llvm_SelectInst", (PyCFunction)__downcast__llvm__User__to__llvm__SelectInst, METH_VARARGS, NULL },
{ "downcast_llvm_Instruction_to_llvm_SelectInst", (PyCFunction)__downcast__llvm__Instruction__to__llvm__SelectInst, METH_VARARGS, NULL },
{ "downcast_llvm_Value_to_llvm_ShuffleVectorInst", (PyCFunction)__downcast__llvm__Value__to__llvm__ShuffleVectorInst, METH_VARARGS, NULL },
{ "downcast_llvm_User_to_llvm_ShuffleVectorInst", (PyCFunction)__downcast__llvm__User__to__llvm__ShuffleVectorInst, METH_VARARGS, NULL },
{ "downcast_llvm_Instruction_to_llvm_ShuffleVectorInst", (PyCFunction)__downcast__llvm__Instruction__to__llvm__ShuffleVectorInst, METH_VARARGS, NULL },
{ "downcast_llvm_Value_to_llvm_StoreInst", (PyCFunction)__downcast__llvm__Value__to__llvm__StoreInst, METH_VARARGS, NULL },
{ "downcast_llvm_User_to_llvm_StoreInst", (PyCFunction)__downcast__llvm__User__to__llvm__StoreInst, METH_VARARGS, NULL },
{ "downcast_llvm_Instruction_to_llvm_StoreInst", (PyCFunction)__downcast__llvm__Instruction__to__llvm__StoreInst, METH_VARARGS, NULL },
{ "downcast_llvm_Value_to_llvm_TerminatorInst", (PyCFunction)__downcast__llvm__Value__to__llvm__TerminatorInst, METH_VARARGS, NULL },
{ "downcast_llvm_User_to_llvm_TerminatorInst", (PyCFunction)__downcast__llvm__User__to__llvm__TerminatorInst, METH_VARARGS, NULL },
{ "downcast_llvm_Instruction_to_llvm_TerminatorInst", (PyCFunction)__downcast__llvm__Instruction__to__llvm__TerminatorInst, METH_VARARGS, NULL },
{ "downcast_llvm_Value_to_llvm_UnaryInstruction", (PyCFunction)__downcast__llvm__Value__to__llvm__UnaryInstruction, METH_VARARGS, NULL },
{ "downcast_llvm_User_to_llvm_UnaryInstruction", (PyCFunction)__downcast__llvm__User__to__llvm__UnaryInstruction, METH_VARARGS, NULL },
{ "downcast_llvm_Instruction_to_llvm_UnaryInstruction", (PyCFunction)__downcast__llvm__Instruction__to__llvm__UnaryInstruction, METH_VARARGS, NULL },
{ "downcast_llvm_Value_to_llvm_IntrinsicInst", (PyCFunction)__downcast__llvm__Value__to__llvm__IntrinsicInst, METH_VARARGS, NULL },
{ "downcast_llvm_User_to_llvm_IntrinsicInst", (PyCFunction)__downcast__llvm__User__to__llvm__IntrinsicInst, METH_VARARGS, NULL },
{ "downcast_llvm_Instruction_to_llvm_IntrinsicInst", (PyCFunction)__downcast__llvm__Instruction__to__llvm__IntrinsicInst, METH_VARARGS, NULL },
{ "downcast_llvm_Value_to_llvm_FCmpInst", (PyCFunction)__downcast__llvm__Value__to__llvm__FCmpInst, METH_VARARGS, NULL },
{ "downcast_llvm_User_to_llvm_FCmpInst", (PyCFunction)__downcast__llvm__User__to__llvm__FCmpInst, METH_VARARGS, NULL },
{ "downcast_llvm_Instruction_to_llvm_FCmpInst", (PyCFunction)__downcast__llvm__Instruction__to__llvm__FCmpInst, METH_VARARGS, NULL },
{ "downcast_llvm_Value_to_llvm_ICmpInst", (PyCFunction)__downcast__llvm__Value__to__llvm__ICmpInst, METH_VARARGS, NULL },
{ "downcast_llvm_User_to_llvm_ICmpInst", (PyCFunction)__downcast__llvm__User__to__llvm__ICmpInst, METH_VARARGS, NULL },
{ "downcast_llvm_Instruction_to_llvm_ICmpInst", (PyCFunction)__downcast__llvm__Instruction__to__llvm__ICmpInst, METH_VARARGS, NULL },
{ "downcast_llvm_Value_to_llvm_BranchInst", (PyCFunction)__downcast__llvm__Value__to__llvm__BranchInst, METH_VARARGS, NULL },
{ "downcast_llvm_User_to_llvm_BranchInst", (PyCFunction)__downcast__llvm__User__to__llvm__BranchInst, METH_VARARGS, NULL },
{ "downcast_llvm_Instruction_to_llvm_BranchInst", (PyCFunction)__downcast__llvm__Instruction__to__llvm__BranchInst, METH_VARARGS, NULL },
{ "downcast_llvm_Value_to_llvm_IndirectBrInst", (PyCFunction)__downcast__llvm__Value__to__llvm__IndirectBrInst, METH_VARARGS, NULL },
{ "downcast_llvm_User_to_llvm_IndirectBrInst", (PyCFunction)__downcast__llvm__User__to__llvm__IndirectBrInst, METH_VARARGS, NULL },
{ "downcast_llvm_Instruction_to_llvm_IndirectBrInst", (PyCFunction)__downcast__llvm__Instruction__to__llvm__IndirectBrInst, METH_VARARGS, NULL },
{ "downcast_llvm_Value_to_llvm_InvokeInst", (PyCFunction)__downcast__llvm__Value__to__llvm__InvokeInst, METH_VARARGS, NULL },
{ "downcast_llvm_User_to_llvm_InvokeInst", (PyCFunction)__downcast__llvm__User__to__llvm__InvokeInst, METH_VARARGS, NULL },
{ "downcast_llvm_Instruction_to_llvm_InvokeInst", (PyCFunction)__downcast__llvm__Instruction__to__llvm__InvokeInst, METH_VARARGS, NULL },
{ "downcast_llvm_Value_to_llvm_ResumeInst", (PyCFunction)__downcast__llvm__Value__to__llvm__ResumeInst, METH_VARARGS, NULL },
{ "downcast_llvm_User_to_llvm_ResumeInst", (PyCFunction)__downcast__llvm__User__to__llvm__ResumeInst, METH_VARARGS, NULL },
{ "downcast_llvm_Instruction_to_llvm_ResumeInst", (PyCFunction)__downcast__llvm__Instruction__to__llvm__ResumeInst, METH_VARARGS, NULL },
{ "downcast_llvm_Value_to_llvm_ReturnInst", (PyCFunction)__downcast__llvm__Value__to__llvm__ReturnInst, METH_VARARGS, NULL },
{ "downcast_llvm_TerminatorInst_to_llvm_ReturnInst", (PyCFunction)__downcast__llvm__TerminatorInst__to__llvm__ReturnInst, METH_VARARGS, NULL },
{ "downcast_llvm_User_to_llvm_ReturnInst", (PyCFunction)__downcast__llvm__User__to__llvm__ReturnInst, METH_VARARGS, NULL },
{ "downcast_llvm_Instruction_to_llvm_ReturnInst", (PyCFunction)__downcast__llvm__Instruction__to__llvm__ReturnInst, METH_VARARGS, NULL },
{ "downcast_llvm_Value_to_llvm_SwitchInst", (PyCFunction)__downcast__llvm__Value__to__llvm__SwitchInst, METH_VARARGS, NULL },
{ "downcast_llvm_User_to_llvm_SwitchInst", (PyCFunction)__downcast__llvm__User__to__llvm__SwitchInst, METH_VARARGS, NULL },
{ "downcast_llvm_Instruction_to_llvm_SwitchInst", (PyCFunction)__downcast__llvm__Instruction__to__llvm__SwitchInst, METH_VARARGS, NULL },
{ "downcast_llvm_Value_to_llvm_UnreachableInst", (PyCFunction)__downcast__llvm__Value__to__llvm__UnreachableInst, METH_VARARGS, NULL },
{ "downcast_llvm_User_to_llvm_UnreachableInst", (PyCFunction)__downcast__llvm__User__to__llvm__UnreachableInst, METH_VARARGS, NULL },
{ "downcast_llvm_Instruction_to_llvm_UnreachableInst", (PyCFunction)__downcast__llvm__Instruction__to__llvm__UnreachableInst, METH_VARARGS, NULL },
{ "downcast_llvm_Value_to_llvm_AllocaInst", (PyCFunction)__downcast__llvm__Value__to__llvm__AllocaInst, METH_VARARGS, NULL },
{ "downcast_llvm_User_to_llvm_AllocaInst", (PyCFunction)__downcast__llvm__User__to__llvm__AllocaInst, METH_VARARGS, NULL },
{ "downcast_llvm_Instruction_to_llvm_AllocaInst", (PyCFunction)__downcast__llvm__Instruction__to__llvm__AllocaInst, METH_VARARGS, NULL },
{ "downcast_llvm_Value_to_llvm_CastInst", (PyCFunction)__downcast__llvm__Value__to__llvm__CastInst, METH_VARARGS, NULL },
{ "downcast_llvm_User_to_llvm_CastInst", (PyCFunction)__downcast__llvm__User__to__llvm__CastInst, METH_VARARGS, NULL },
{ "downcast_llvm_Instruction_to_llvm_CastInst", (PyCFunction)__downcast__llvm__Instruction__to__llvm__CastInst, METH_VARARGS, NULL },
{ "downcast_llvm_Value_to_llvm_ExtractValueInst", (PyCFunction)__downcast__llvm__Value__to__llvm__ExtractValueInst, METH_VARARGS, NULL },
{ "downcast_llvm_User_to_llvm_ExtractValueInst", (PyCFunction)__downcast__llvm__User__to__llvm__ExtractValueInst, METH_VARARGS, NULL },
{ "downcast_llvm_Instruction_to_llvm_ExtractValueInst", (PyCFunction)__downcast__llvm__Instruction__to__llvm__ExtractValueInst, METH_VARARGS, NULL },
{ "downcast_llvm_Value_to_llvm_LoadInst", (PyCFunction)__downcast__llvm__Value__to__llvm__LoadInst, METH_VARARGS, NULL },
{ "downcast_llvm_User_to_llvm_LoadInst", (PyCFunction)__downcast__llvm__User__to__llvm__LoadInst, METH_VARARGS, NULL },
{ "downcast_llvm_Instruction_to_llvm_LoadInst", (PyCFunction)__downcast__llvm__Instruction__to__llvm__LoadInst, METH_VARARGS, NULL },
{ "downcast_llvm_Value_to_llvm_VAArgInst", (PyCFunction)__downcast__llvm__Value__to__llvm__VAArgInst, METH_VARARGS, NULL },
{ "downcast_llvm_User_to_llvm_VAArgInst", (PyCFunction)__downcast__llvm__User__to__llvm__VAArgInst, METH_VARARGS, NULL },
{ "downcast_llvm_Instruction_to_llvm_VAArgInst", (PyCFunction)__downcast__llvm__Instruction__to__llvm__VAArgInst, METH_VARARGS, NULL },
{ "downcast_llvm_Value_to_llvm_DbgInfoIntrinsic", (PyCFunction)__downcast__llvm__Value__to__llvm__DbgInfoIntrinsic, METH_VARARGS, NULL },
{ "downcast_llvm_User_to_llvm_DbgInfoIntrinsic", (PyCFunction)__downcast__llvm__User__to__llvm__DbgInfoIntrinsic, METH_VARARGS, NULL },
{ "downcast_llvm_Instruction_to_llvm_DbgInfoIntrinsic", (PyCFunction)__downcast__llvm__Instruction__to__llvm__DbgInfoIntrinsic, METH_VARARGS, NULL },
{ "downcast_llvm_Value_to_llvm_MemIntrinsic", (PyCFunction)__downcast__llvm__Value__to__llvm__MemIntrinsic, METH_VARARGS, NULL },
{ "downcast_llvm_User_to_llvm_MemIntrinsic", (PyCFunction)__downcast__llvm__User__to__llvm__MemIntrinsic, METH_VARARGS, NULL },
{ "downcast_llvm_Instruction_to_llvm_MemIntrinsic", (PyCFunction)__downcast__llvm__Instruction__to__llvm__MemIntrinsic, METH_VARARGS, NULL },
{ "downcast_llvm_Value_to_llvm_VACopyInst", (PyCFunction)__downcast__llvm__Value__to__llvm__VACopyInst, METH_VARARGS, NULL },
{ "downcast_llvm_User_to_llvm_VACopyInst", (PyCFunction)__downcast__llvm__User__to__llvm__VACopyInst, METH_VARARGS, NULL },
{ "downcast_llvm_Instruction_to_llvm_VACopyInst", (PyCFunction)__downcast__llvm__Instruction__to__llvm__VACopyInst, METH_VARARGS, NULL },
{ "downcast_llvm_Value_to_llvm_VAEndInst", (PyCFunction)__downcast__llvm__Value__to__llvm__VAEndInst, METH_VARARGS, NULL },
{ "downcast_llvm_User_to_llvm_VAEndInst", (PyCFunction)__downcast__llvm__User__to__llvm__VAEndInst, METH_VARARGS, NULL },
{ "downcast_llvm_Instruction_to_llvm_VAEndInst", (PyCFunction)__downcast__llvm__Instruction__to__llvm__VAEndInst, METH_VARARGS, NULL },
{ "downcast_llvm_Value_to_llvm_VAStartInst", (PyCFunction)__downcast__llvm__Value__to__llvm__VAStartInst, METH_VARARGS, NULL },
{ "downcast_llvm_User_to_llvm_VAStartInst", (PyCFunction)__downcast__llvm__User__to__llvm__VAStartInst, METH_VARARGS, NULL },
{ "downcast_llvm_Instruction_to_llvm_VAStartInst", (PyCFunction)__downcast__llvm__Instruction__to__llvm__VAStartInst, METH_VARARGS, NULL },
{ "downcast_llvm_Value_to_llvm_BitCastInst", (PyCFunction)__downcast__llvm__Value__to__llvm__BitCastInst, METH_VARARGS, NULL },
{ "downcast_llvm_User_to_llvm_BitCastInst", (PyCFunction)__downcast__llvm__User__to__llvm__BitCastInst, METH_VARARGS, NULL },
{ "downcast_llvm_Instruction_to_llvm_BitCastInst", (PyCFunction)__downcast__llvm__Instruction__to__llvm__BitCastInst, METH_VARARGS, NULL },
{ "downcast_llvm_Value_to_llvm_FPExtInst", (PyCFunction)__downcast__llvm__Value__to__llvm__FPExtInst, METH_VARARGS, NULL },
{ "downcast_llvm_User_to_llvm_FPExtInst", (PyCFunction)__downcast__llvm__User__to__llvm__FPExtInst, METH_VARARGS, NULL },
{ "downcast_llvm_Instruction_to_llvm_FPExtInst", (PyCFunction)__downcast__llvm__Instruction__to__llvm__FPExtInst, METH_VARARGS, NULL },
{ "downcast_llvm_Value_to_llvm_FPToSIInst", (PyCFunction)__downcast__llvm__Value__to__llvm__FPToSIInst, METH_VARARGS, NULL },
{ "downcast_llvm_User_to_llvm_FPToSIInst", (PyCFunction)__downcast__llvm__User__to__llvm__FPToSIInst, METH_VARARGS, NULL },
{ "downcast_llvm_Instruction_to_llvm_FPToSIInst", (PyCFunction)__downcast__llvm__Instruction__to__llvm__FPToSIInst, METH_VARARGS, NULL },
{ "downcast_llvm_Value_to_llvm_FPToUIInst", (PyCFunction)__downcast__llvm__Value__to__llvm__FPToUIInst, METH_VARARGS, NULL },
{ "downcast_llvm_User_to_llvm_FPToUIInst", (PyCFunction)__downcast__llvm__User__to__llvm__FPToUIInst, METH_VARARGS, NULL },
{ "downcast_llvm_Instruction_to_llvm_FPToUIInst", (PyCFunction)__downcast__llvm__Instruction__to__llvm__FPToUIInst, METH_VARARGS, NULL },
{ "downcast_llvm_Value_to_llvm_FPTruncInst", (PyCFunction)__downcast__llvm__Value__to__llvm__FPTruncInst, METH_VARARGS, NULL },
{ "downcast_llvm_User_to_llvm_FPTruncInst", (PyCFunction)__downcast__llvm__User__to__llvm__FPTruncInst, METH_VARARGS, NULL },
{ "downcast_llvm_Instruction_to_llvm_FPTruncInst", (PyCFunction)__downcast__llvm__Instruction__to__llvm__FPTruncInst, METH_VARARGS, NULL },
{ "downcast_llvm_Type_to_llvm_FunctionType", (PyCFunction)__downcast__llvm__Type__to__llvm__FunctionType, METH_VARARGS, NULL },
{ NULL }
};

static
PyObject*
llvm__getGlobalContext(PyObject* self, PyObject* args)
{
    if(!PyArg_ParseTuple(args, ""))
    {
        return NULL;
    }
    llvm::LLVMContext& var_llvm_LLVMContext = llvm::getGlobalContext();
    const llvm::LLVMContext* var_const_llvm_LLVMContext = &var_llvm_LLVMContext;
    PyObject* var_PyObject = pycapsule_new(cast_to_base<llvm::LLVMContext >::from(var_const_llvm_LLVMContext), "llvm::LLVMContext", "llvm::LLVMContext");
    if (!var_PyObject)
    {
        return NULL;
    }
    return var_PyObject;
}

static
PyObject*
llvm__InitializeNativeTarget(PyObject* self, PyObject* args)
{
    if(!PyArg_ParseTuple(args, ""))
    {
        return NULL;
    }
    llvm::InitializeNativeTarget();
    Py_RETURN_NONE;
}

static
PyObject*
llvm__InitializeNativeTargetAsmPrinter(PyObject* self, PyObject* args)
{
    if(!PyArg_ParseTuple(args, ""))
    {
        return NULL;
    }
    bool var_bool = llvm::InitializeNativeTargetAsmPrinter();
    PyObject* var_PyObject = py_bool_from(var_bool);
    return var_PyObject;
}

static
PyObject*
llvm__InitializeNativeTargetAsmParser(PyObject* self, PyObject* args)
{
    if(!PyArg_ParseTuple(args, ""))
    {
        return NULL;
    }
    bool var_bool = llvm::InitializeNativeTargetAsmParser();
    PyObject* var_PyObject = py_bool_from(var_bool);
    return var_PyObject;
}

static
PyObject*
llvm__InitializeNativeTargetDisassembler(PyObject* self, PyObject* args)
{
    if(!PyArg_ParseTuple(args, ""))
    {
        return NULL;
    }
    bool var_bool = llvm::InitializeNativeTargetDisassembler();
    PyObject* var_PyObject = py_bool_from(var_bool);
    return var_PyObject;
}

static
PyObject*
llvm__InitializeAllTargets(PyObject* self, PyObject* args)
{
    if(!PyArg_ParseTuple(args, ""))
    {
        return NULL;
    }
    llvm::InitializeAllTargets();
    Py_RETURN_NONE;
}

static
PyObject*
llvm__InitializeAllTargetInfos(PyObject* self, PyObject* args)
{
    if(!PyArg_ParseTuple(args, ""))
    {
        return NULL;
    }
    llvm::InitializeAllTargetInfos();
    Py_RETURN_NONE;
}

static
PyObject*
llvm__InitializeAllTargetMCs(PyObject* self, PyObject* args)
{
    if(!PyArg_ParseTuple(args, ""))
    {
        return NULL;
    }
    llvm::InitializeAllTargetMCs();
    Py_RETURN_NONE;
}

static
PyObject*
llvm__InitializeAllAsmPrinters(PyObject* self, PyObject* args)
{
    if(!PyArg_ParseTuple(args, ""))
    {
        return NULL;
    }
    llvm::InitializeAllAsmPrinters();
    Py_RETURN_NONE;
}

static
PyObject*
llvm__InitializeAllDisassemblers(PyObject* self, PyObject* args)
{
    if(!PyArg_ParseTuple(args, ""))
    {
        return NULL;
    }
    llvm::InitializeAllDisassemblers();
    Py_RETURN_NONE;
}

static
PyObject*
llvm__InitializeAllAsmParsers(PyObject* self, PyObject* args)
{
    if(!PyArg_ParseTuple(args, ""))
    {
        return NULL;
    }
    llvm::InitializeAllAsmParsers();
    Py_RETURN_NONE;
}

static
PyObject*
llvm__ParseAssemblyString(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    PyObject* var_PyObject2;
    PyObject* var_PyObject3;
    if(!PyArg_ParseTuple(args, "OOOO", &var_PyObject, &var_PyObject1, &var_PyObject2, &var_PyObject3))
    {
        return NULL;
    }
    const char* var_const_char;
    int var_int = py_str_to(var_PyObject, var_const_char);
    if(!var_int)
    {
        return NULL;
    }
    llvm::Module* var_llvm_Module = NULL;
    if (var_PyObject1 != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject1, "llvm::Module");
        if(!var_void)
        {
            puts("Error: llvm::Module");
            return NULL;
        }
        llvm::Module* var_llvm_Module1 = unwrap_as<llvm::Module, llvm::Module >::from(var_void);
        if(!var_llvm_Module1)
        {
            return NULL;
        }
        var_llvm_Module = var_llvm_Module1;
    }
    void* var_void1 = PyCapsule_GetPointer(var_PyObject2, "llvm::SMDiagnostic");
    if(!var_void1)
    {
        puts("Error: llvm::SMDiagnostic");
        return NULL;
    }
    llvm::SMDiagnostic* var_llvm_SMDiagnostic = unwrap_as<llvm::SMDiagnostic, llvm::SMDiagnostic >::from(var_void1);
    if(!var_llvm_SMDiagnostic)
    {
        return NULL;
    }
    llvm::SMDiagnostic& var_llvm_SMDiagnostic1 = *var_llvm_SMDiagnostic;
    void* var_void2 = PyCapsule_GetPointer(var_PyObject3, "llvm::LLVMContext");
    if(!var_void2)
    {
        puts("Error: llvm::LLVMContext");
        return NULL;
    }
    llvm::LLVMContext* var_llvm_LLVMContext = unwrap_as<llvm::LLVMContext, llvm::LLVMContext >::from(var_void2);
    if(!var_llvm_LLVMContext)
    {
        return NULL;
    }
    llvm::LLVMContext& var_llvm_LLVMContext1 = *var_llvm_LLVMContext;
    llvm::Module* var_llvm_Module2 = llvm::ParseAssemblyString(var_const_char, var_llvm_Module, var_llvm_SMDiagnostic1, var_llvm_LLVMContext1);
    PyObject* var_PyObject4 = pycapsule_new(cast_to_base<llvm::Module >::from(var_llvm_Module2), "llvm::Module", "llvm::Module");
    if (!var_PyObject4)
    {
        return NULL;
    }
    return var_PyObject4;
}

static
PyObject*
llvm__verifyModule(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    PyObject* var_PyObject2;
    if(!PyArg_ParseTuple(args, "OOO", &var_PyObject, &var_PyObject1, &var_PyObject2))
    {
        return NULL;
    }
    void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Module");
    if(!var_void)
    {
        puts("Error: llvm::Module");
        return NULL;
    }
    llvm::Module* var_llvm_Module = unwrap_as<llvm::Module, llvm::Module >::from(var_void);
    if(!var_llvm_Module)
    {
        return NULL;
    }
    llvm::Module& var_llvm_Module1 = *var_llvm_Module;
    llvm::VerifierFailureAction var_llvm_VerifierFailureAction = (llvm::VerifierFailureAction)PyInt_AsLong(var_PyObject1);
    PyObject* var_PyObject3 = llvm_verifyModule(var_llvm_Module1, var_llvm_VerifierFailureAction, var_PyObject2);
    return var_PyObject3;
}

static
PyObject*
llvm__verifyFunction(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
    if(!var_void)
    {
        puts("Error: llvm::Value");
        return NULL;
    }
    llvm::Function* var_llvm_Function = unwrap_as<llvm::Function, llvm::Value >::from(var_void);
    if(!var_llvm_Function)
    {
        return NULL;
    }
    llvm::Function& var_llvm_Function1 = *var_llvm_Function;
    llvm::VerifierFailureAction var_llvm_VerifierFailureAction = (llvm::VerifierFailureAction)PyInt_AsLong(var_PyObject1);
    bool var_bool = llvm::verifyFunction(var_llvm_Function1, var_llvm_VerifierFailureAction);
    PyObject* var_PyObject2 = py_bool_from(var_bool);
    return var_PyObject2;
}

static
PyObject*
llvm__ParseBitCodeFile(PyObject* self, PyObject* args)
{
    Py_ssize_t var_Py__ssize__t = PyTuple_Size(args);
    if (3 == var_Py__ssize__t)
    {
        PyObject* var_PyObject;
        PyObject* var_PyObject1;
        PyObject* var_PyObject2;
        if(!PyArg_ParseTuple(args, "OOO", &var_PyObject, &var_PyObject1, &var_PyObject2))
        {
            return NULL;
        }
        llvm::StringRef var_llvm_StringRef;
        int var_int = py_bytes_to(var_PyObject, var_llvm_StringRef);
        if(!var_int)
        {
            return NULL;
        }
        void* var_void = PyCapsule_GetPointer(var_PyObject1, "llvm::LLVMContext");
        if(!var_void)
        {
            puts("Error: llvm::LLVMContext");
            return NULL;
        }
        llvm::LLVMContext* var_llvm_LLVMContext = unwrap_as<llvm::LLVMContext, llvm::LLVMContext >::from(var_void);
        if(!var_llvm_LLVMContext)
        {
            return NULL;
        }
        llvm::LLVMContext& var_llvm_LLVMContext1 = *var_llvm_LLVMContext;
        PyObject* var_PyObject3 = llvm_ParseBitCodeFile(var_llvm_StringRef, var_llvm_LLVMContext1, var_PyObject2);
        return var_PyObject3;
    }
    if (2 == var_Py__ssize__t)
    {
        PyObject* var_PyObject4;
        PyObject* var_PyObject5;
        if(!PyArg_ParseTuple(args, "OO", &var_PyObject4, &var_PyObject5))
        {
            return NULL;
        }
        llvm::StringRef var_llvm_StringRef1;
        int var_int1 = py_bytes_to(var_PyObject4, var_llvm_StringRef1);
        if(!var_int1)
        {
            return NULL;
        }
        void* var_void1 = PyCapsule_GetPointer(var_PyObject5, "llvm::LLVMContext");
        if(!var_void1)
        {
            puts("Error: llvm::LLVMContext");
            return NULL;
        }
        llvm::LLVMContext* var_llvm_LLVMContext2 = unwrap_as<llvm::LLVMContext, llvm::LLVMContext >::from(var_void1);
        if(!var_llvm_LLVMContext2)
        {
            return NULL;
        }
        llvm::LLVMContext& var_llvm_LLVMContext3 = *var_llvm_LLVMContext2;
        PyObject* var_PyObject6 = llvm_ParseBitCodeFile(var_llvm_StringRef1, var_llvm_LLVMContext3);
        return var_PyObject6;
    }
    PyErr_SetString(PyExc_TypeError, "Invalid number of args");
    return NULL;
}

static
PyObject*
llvm__WriteBitcodeToFile(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::Module* var_llvm_Module = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Module");
        if(!var_void)
        {
            puts("Error: llvm::Module");
            return NULL;
        }
        llvm::Module* var_llvm_Module1 = unwrap_as<llvm::Module, llvm::Module >::from(var_void);
        if(!var_llvm_Module1)
        {
            return NULL;
        }
        var_llvm_Module = var_llvm_Module1;
    }
    PyObject* var_PyObject2 = llvm_WriteBitcodeToFile(var_llvm_Module, var_PyObject1);
    return var_PyObject2;
}

static
PyObject*
llvm__getBitcodeTargetTriple(PyObject* self, PyObject* args)
{
    Py_ssize_t var_Py__ssize__t = PyTuple_Size(args);
    if (3 == var_Py__ssize__t)
    {
        PyObject* var_PyObject;
        PyObject* var_PyObject1;
        PyObject* var_PyObject2;
        if(!PyArg_ParseTuple(args, "OOO", &var_PyObject, &var_PyObject1, &var_PyObject2))
        {
            return NULL;
        }
        llvm::StringRef var_llvm_StringRef;
        int var_int = py_str_to(var_PyObject, var_llvm_StringRef);
        if(!var_int)
        {
            return NULL;
        }
        void* var_void = PyCapsule_GetPointer(var_PyObject1, "llvm::LLVMContext");
        if(!var_void)
        {
            puts("Error: llvm::LLVMContext");
            return NULL;
        }
        llvm::LLVMContext* var_llvm_LLVMContext = unwrap_as<llvm::LLVMContext, llvm::LLVMContext >::from(var_void);
        if(!var_llvm_LLVMContext)
        {
            return NULL;
        }
        llvm::LLVMContext& var_llvm_LLVMContext1 = *var_llvm_LLVMContext;
        PyObject* var_PyObject3 = llvm_getBitcodeTargetTriple(var_llvm_StringRef, var_llvm_LLVMContext1, var_PyObject2);
        return var_PyObject3;
    }
    if (2 == var_Py__ssize__t)
    {
        PyObject* var_PyObject4;
        PyObject* var_PyObject5;
        if(!PyArg_ParseTuple(args, "OO", &var_PyObject4, &var_PyObject5))
        {
            return NULL;
        }
        llvm::StringRef var_llvm_StringRef1;
        int var_int1 = py_str_to(var_PyObject4, var_llvm_StringRef1);
        if(!var_int1)
        {
            return NULL;
        }
        void* var_void1 = PyCapsule_GetPointer(var_PyObject5, "llvm::LLVMContext");
        if(!var_void1)
        {
            puts("Error: llvm::LLVMContext");
            return NULL;
        }
        llvm::LLVMContext* var_llvm_LLVMContext2 = unwrap_as<llvm::LLVMContext, llvm::LLVMContext >::from(var_void1);
        if(!var_llvm_LLVMContext2)
        {
            return NULL;
        }
        llvm::LLVMContext& var_llvm_LLVMContext3 = *var_llvm_LLVMContext2;
        PyObject* var_PyObject6 = llvm_getBitcodeTargetTriple(var_llvm_StringRef1, var_llvm_LLVMContext3);
        return var_PyObject6;
    }
    PyErr_SetString(PyExc_TypeError, "Invalid number of args");
    return NULL;
}

static
PyObject*
llvm__initializeCore(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::PassRegistry");
    if(!var_void)
    {
        puts("Error: llvm::PassRegistry");
        return NULL;
    }
    llvm::PassRegistry* var_llvm_PassRegistry = unwrap_as<llvm::PassRegistry, llvm::PassRegistry >::from(var_void);
    if(!var_llvm_PassRegistry)
    {
        return NULL;
    }
    llvm::PassRegistry& var_llvm_PassRegistry1 = *var_llvm_PassRegistry;
    llvm::initializeCore(var_llvm_PassRegistry1);
    Py_RETURN_NONE;
}

static
PyObject*
llvm__initializeScalarOpts(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::PassRegistry");
    if(!var_void)
    {
        puts("Error: llvm::PassRegistry");
        return NULL;
    }
    llvm::PassRegistry* var_llvm_PassRegistry = unwrap_as<llvm::PassRegistry, llvm::PassRegistry >::from(var_void);
    if(!var_llvm_PassRegistry)
    {
        return NULL;
    }
    llvm::PassRegistry& var_llvm_PassRegistry1 = *var_llvm_PassRegistry;
    llvm::initializeScalarOpts(var_llvm_PassRegistry1);
    Py_RETURN_NONE;
}

static
PyObject*
llvm__initializeVectorization(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::PassRegistry");
    if(!var_void)
    {
        puts("Error: llvm::PassRegistry");
        return NULL;
    }
    llvm::PassRegistry* var_llvm_PassRegistry = unwrap_as<llvm::PassRegistry, llvm::PassRegistry >::from(var_void);
    if(!var_llvm_PassRegistry)
    {
        return NULL;
    }
    llvm::PassRegistry& var_llvm_PassRegistry1 = *var_llvm_PassRegistry;
    llvm::initializeVectorization(var_llvm_PassRegistry1);
    Py_RETURN_NONE;
}

static
PyObject*
llvm__initializeIPO(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::PassRegistry");
    if(!var_void)
    {
        puts("Error: llvm::PassRegistry");
        return NULL;
    }
    llvm::PassRegistry* var_llvm_PassRegistry = unwrap_as<llvm::PassRegistry, llvm::PassRegistry >::from(var_void);
    if(!var_llvm_PassRegistry)
    {
        return NULL;
    }
    llvm::PassRegistry& var_llvm_PassRegistry1 = *var_llvm_PassRegistry;
    llvm::initializeIPO(var_llvm_PassRegistry1);
    Py_RETURN_NONE;
}

static
PyObject*
llvm__initializeAnalysis(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::PassRegistry");
    if(!var_void)
    {
        puts("Error: llvm::PassRegistry");
        return NULL;
    }
    llvm::PassRegistry* var_llvm_PassRegistry = unwrap_as<llvm::PassRegistry, llvm::PassRegistry >::from(var_void);
    if(!var_llvm_PassRegistry)
    {
        return NULL;
    }
    llvm::PassRegistry& var_llvm_PassRegistry1 = *var_llvm_PassRegistry;
    llvm::initializeAnalysis(var_llvm_PassRegistry1);
    Py_RETURN_NONE;
}

static
PyObject*
llvm__initializeIPA(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::PassRegistry");
    if(!var_void)
    {
        puts("Error: llvm::PassRegistry");
        return NULL;
    }
    llvm::PassRegistry* var_llvm_PassRegistry = unwrap_as<llvm::PassRegistry, llvm::PassRegistry >::from(var_void);
    if(!var_llvm_PassRegistry)
    {
        return NULL;
    }
    llvm::PassRegistry& var_llvm_PassRegistry1 = *var_llvm_PassRegistry;
    llvm::initializeIPA(var_llvm_PassRegistry1);
    Py_RETURN_NONE;
}

static
PyObject*
llvm__initializeTransformUtils(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::PassRegistry");
    if(!var_void)
    {
        puts("Error: llvm::PassRegistry");
        return NULL;
    }
    llvm::PassRegistry* var_llvm_PassRegistry = unwrap_as<llvm::PassRegistry, llvm::PassRegistry >::from(var_void);
    if(!var_llvm_PassRegistry)
    {
        return NULL;
    }
    llvm::PassRegistry& var_llvm_PassRegistry1 = *var_llvm_PassRegistry;
    llvm::initializeTransformUtils(var_llvm_PassRegistry1);
    Py_RETURN_NONE;
}

static
PyObject*
llvm__initializeInstCombine(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::PassRegistry");
    if(!var_void)
    {
        puts("Error: llvm::PassRegistry");
        return NULL;
    }
    llvm::PassRegistry* var_llvm_PassRegistry = unwrap_as<llvm::PassRegistry, llvm::PassRegistry >::from(var_void);
    if(!var_llvm_PassRegistry)
    {
        return NULL;
    }
    llvm::PassRegistry& var_llvm_PassRegistry1 = *var_llvm_PassRegistry;
    llvm::initializeInstCombine(var_llvm_PassRegistry1);
    Py_RETURN_NONE;
}

static
PyObject*
llvm__initializeInstrumentation(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::PassRegistry");
    if(!var_void)
    {
        puts("Error: llvm::PassRegistry");
        return NULL;
    }
    llvm::PassRegistry* var_llvm_PassRegistry = unwrap_as<llvm::PassRegistry, llvm::PassRegistry >::from(var_void);
    if(!var_llvm_PassRegistry)
    {
        return NULL;
    }
    llvm::PassRegistry& var_llvm_PassRegistry1 = *var_llvm_PassRegistry;
    llvm::initializeInstrumentation(var_llvm_PassRegistry1);
    Py_RETURN_NONE;
}

static
PyObject*
llvm__initializeTarget(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::PassRegistry");
    if(!var_void)
    {
        puts("Error: llvm::PassRegistry");
        return NULL;
    }
    llvm::PassRegistry* var_llvm_PassRegistry = unwrap_as<llvm::PassRegistry, llvm::PassRegistry >::from(var_void);
    if(!var_llvm_PassRegistry)
    {
        return NULL;
    }
    llvm::PassRegistry& var_llvm_PassRegistry1 = *var_llvm_PassRegistry;
    llvm::initializeTarget(var_llvm_PassRegistry1);
    Py_RETURN_NONE;
}

static
PyObject*
llvm__createFunctionInliningPass(PyObject* self, PyObject* args)
{
    Py_ssize_t var_Py__ssize__t = PyTuple_Size(args);
    if (1 == var_Py__ssize__t)
    {
        PyObject* var_PyObject;
        if(!PyArg_ParseTuple(args, "O", &var_PyObject))
        {
            return NULL;
        }
        unsigned var_unsigned;
        int var_int = py_int_to(var_PyObject, var_unsigned);
        if(!var_int)
        {
            return NULL;
        }
        llvm::Pass* var_llvm_Pass = llvm::createFunctionInliningPass(var_unsigned);
        PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Pass >::from(var_llvm_Pass), "llvm::Pass", "llvm::Pass");
        if (!var_PyObject1)
        {
            return NULL;
        }
        return var_PyObject1;
    }
    if (0 == var_Py__ssize__t)
    {
        if(!PyArg_ParseTuple(args, ""))
        {
            return NULL;
        }
        llvm::Pass* var_llvm_Pass1 = llvm::createFunctionInliningPass();
        PyObject* var_PyObject2 = pycapsule_new(cast_to_base<llvm::Pass >::from(var_llvm_Pass1), "llvm::Pass", "llvm::Pass");
        if (!var_PyObject2)
        {
            return NULL;
        }
        return var_PyObject2;
    }
    PyErr_SetString(PyExc_TypeError, "Invalid number of args");
    return NULL;
}

static
PyObject*
llvm__SplitBlockAndInsertIfThen(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    PyObject* var_PyObject2;
    if(!PyArg_ParseTuple(args, "OOO", &var_PyObject, &var_PyObject1, &var_PyObject2))
    {
        return NULL;
    }
    llvm::Instruction* var_llvm_Instruction = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void);
        if(!var_llvm_Instruction1)
        {
            return NULL;
        }
        var_llvm_Instruction = var_llvm_Instruction1;
    }
    bool var_bool;
    int var_int = py_bool_to(var_PyObject1, var_bool);
    if(!var_int)
    {
        return NULL;
    }
    llvm::MDNode* var_llvm_MDNode = NULL;
    if (var_PyObject2 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject2, "llvm::Value");
        if(!var_void1)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::MDNode* var_llvm_MDNode1 = unwrap_as<llvm::MDNode, llvm::Value >::from(var_void1);
        if(!var_llvm_MDNode1)
        {
            return NULL;
        }
        var_llvm_MDNode = var_llvm_MDNode1;
    }
    llvm::TerminatorInst* var_llvm_TerminatorInst = llvm::SplitBlockAndInsertIfThen(var_llvm_Instruction, var_bool, var_llvm_MDNode);
    PyObject* var_PyObject3 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_TerminatorInst), "llvm::Value", "llvm::TerminatorInst");
    if (!var_PyObject3)
    {
        return NULL;
    }
    return var_PyObject3;
}

static
PyObject*
llvm__ReplaceInstWithInst(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::Instruction* var_llvm_Instruction = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void);
        if(!var_llvm_Instruction1)
        {
            return NULL;
        }
        var_llvm_Instruction = var_llvm_Instruction1;
    }
    llvm::Instruction* var_llvm_Instruction2 = NULL;
    if (var_PyObject1 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Value");
        if(!var_void1)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction3 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void1);
        if(!var_llvm_Instruction3)
        {
            return NULL;
        }
        var_llvm_Instruction2 = var_llvm_Instruction3;
    }
    llvm::ReplaceInstWithInst(var_llvm_Instruction, var_llvm_Instruction2);
    Py_RETURN_NONE;
}

static
PyObject*
llvm__CloneModule(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Module* var_llvm_Module = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Module");
        if(!var_void)
        {
            puts("Error: llvm::Module");
            return NULL;
        }
        llvm::Module* var_llvm_Module1 = unwrap_as<llvm::Module, llvm::Module >::from(var_void);
        if(!var_llvm_Module1)
        {
            return NULL;
        }
        var_llvm_Module = var_llvm_Module1;
    }
    llvm::Module* var_llvm_Module2 = llvm::CloneModule(var_llvm_Module);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Module >::from(var_llvm_Module2), "llvm::Module", "llvm::Module");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyObject*
llvm__InlineFunction(PyObject* self, PyObject* args)
{
    Py_ssize_t var_Py__ssize__t = PyTuple_Size(args);
    if (3 == var_Py__ssize__t)
    {
        PyObject* var_PyObject;
        PyObject* var_PyObject1;
        PyObject* var_PyObject2;
        if(!PyArg_ParseTuple(args, "OOO", &var_PyObject, &var_PyObject1, &var_PyObject2))
        {
            return NULL;
        }
        llvm::CallInst* var_llvm_CallInst = NULL;
        if (var_PyObject != Py_None)
        {
            void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
            if(!var_void)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::CallInst* var_llvm_CallInst1 = unwrap_as<llvm::CallInst, llvm::Value >::from(var_void);
            if(!var_llvm_CallInst1)
            {
                return NULL;
            }
            var_llvm_CallInst = var_llvm_CallInst1;
        }
        void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::InlineFunctionInfo");
        if(!var_void1)
        {
            puts("Error: llvm::InlineFunctionInfo");
            return NULL;
        }
        llvm::InlineFunctionInfo* var_llvm_InlineFunctionInfo = unwrap_as<llvm::InlineFunctionInfo, llvm::InlineFunctionInfo >::from(var_void1);
        if(!var_llvm_InlineFunctionInfo)
        {
            return NULL;
        }
        llvm::InlineFunctionInfo& var_llvm_InlineFunctionInfo1 = *var_llvm_InlineFunctionInfo;
        bool var_bool;
        int var_int = py_bool_to(var_PyObject2, var_bool);
        if(!var_int)
        {
            return NULL;
        }
        bool var_bool1 = llvm::InlineFunction(var_llvm_CallInst, var_llvm_InlineFunctionInfo1, var_bool);
        PyObject* var_PyObject3 = py_bool_from(var_bool1);
        return var_PyObject3;
    }
    if (2 == var_Py__ssize__t)
    {
        PyObject* var_PyObject4;
        PyObject* var_PyObject5;
        if(!PyArg_ParseTuple(args, "OO", &var_PyObject4, &var_PyObject5))
        {
            return NULL;
        }
        llvm::CallInst* var_llvm_CallInst2 = NULL;
        if (var_PyObject4 != Py_None)
        {
            void* var_void2 = PyCapsule_GetPointer(var_PyObject4, "llvm::Value");
            if(!var_void2)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::CallInst* var_llvm_CallInst3 = unwrap_as<llvm::CallInst, llvm::Value >::from(var_void2);
            if(!var_llvm_CallInst3)
            {
                return NULL;
            }
            var_llvm_CallInst2 = var_llvm_CallInst3;
        }
        void* var_void3 = PyCapsule_GetPointer(var_PyObject5, "llvm::InlineFunctionInfo");
        if(!var_void3)
        {
            puts("Error: llvm::InlineFunctionInfo");
            return NULL;
        }
        llvm::InlineFunctionInfo* var_llvm_InlineFunctionInfo2 = unwrap_as<llvm::InlineFunctionInfo, llvm::InlineFunctionInfo >::from(var_void3);
        if(!var_llvm_InlineFunctionInfo2)
        {
            return NULL;
        }
        llvm::InlineFunctionInfo& var_llvm_InlineFunctionInfo3 = *var_llvm_InlineFunctionInfo2;
        bool var_bool2 = llvm::InlineFunction(var_llvm_CallInst2, var_llvm_InlineFunctionInfo3);
        PyObject* var_PyObject6 = py_bool_from(var_bool2);
        return var_PyObject6;
    }
    PyErr_SetString(PyExc_TypeError, "Invalid number of args");
    return NULL;
}

static
PyObject*
llvm_SmallVectorllvm_Type_8__delete(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::SmallVector<llvm::Type*,8>* var_llvm_SmallVectorllvm_Type_8 = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::SmallVector<llvm::Type*,8>");
        if(!var_void)
        {
            puts("Error: llvm::SmallVector<llvm::Type*,8>");
            return NULL;
        }
        llvm::SmallVector<llvm::Type*,8>* var_llvm_SmallVectorllvm_Type_81 = unwrap_as<llvm::SmallVector<llvm::Type*,8>, llvm::SmallVector<llvm::Type*,8> >::from(var_void);
        if(!var_llvm_SmallVectorllvm_Type_81)
        {
            return NULL;
        }
        var_llvm_SmallVectorllvm_Type_8 = var_llvm_SmallVectorllvm_Type_81;
    }
    delete var_llvm_SmallVectorllvm_Type_8;
    Py_RETURN_NONE;
}

static
PyMethodDef meth_llvm_SmallVectorllvm_Type_8[] = {
    { "delete", (PyCFunction)llvm_SmallVectorllvm_Type_8__delete, METH_VARARGS, NULL },
    { NULL },
};

static
SubModuleEntry submodule_llvm_SmallVectorllvm_Type_8[] = {
    { NULL }
};

static
PyObject*
llvm_SmallVectorllvm_Value_8__delete(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::SmallVector<llvm::Value*,8>* var_llvm_SmallVectorllvm_Value_8 = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::SmallVector<llvm::Value*,8>");
        if(!var_void)
        {
            puts("Error: llvm::SmallVector<llvm::Value*,8>");
            return NULL;
        }
        llvm::SmallVector<llvm::Value*,8>* var_llvm_SmallVectorllvm_Value_81 = unwrap_as<llvm::SmallVector<llvm::Value*,8>, llvm::SmallVector<llvm::Value*,8> >::from(var_void);
        if(!var_llvm_SmallVectorllvm_Value_81)
        {
            return NULL;
        }
        var_llvm_SmallVectorllvm_Value_8 = var_llvm_SmallVectorllvm_Value_81;
    }
    delete var_llvm_SmallVectorllvm_Value_8;
    Py_RETURN_NONE;
}

static
PyMethodDef meth_llvm_SmallVectorllvm_Value_8[] = {
    { "delete", (PyCFunction)llvm_SmallVectorllvm_Value_8__delete, METH_VARARGS, NULL },
    { NULL },
};

static
SubModuleEntry submodule_llvm_SmallVectorllvm_Value_8[] = {
    { NULL }
};

static
PyObject*
llvm_SmallVectorunsigned_8__delete(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::SmallVector<unsigned,8>* var_llvm_SmallVectorunsigned_8 = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::SmallVector<unsigned,8>");
        if(!var_void)
        {
            puts("Error: llvm::SmallVector<unsigned,8>");
            return NULL;
        }
        llvm::SmallVector<unsigned,8>* var_llvm_SmallVectorunsigned_81 = unwrap_as<llvm::SmallVector<unsigned,8>, llvm::SmallVector<unsigned,8> >::from(var_void);
        if(!var_llvm_SmallVectorunsigned_81)
        {
            return NULL;
        }
        var_llvm_SmallVectorunsigned_8 = var_llvm_SmallVectorunsigned_81;
    }
    delete var_llvm_SmallVectorunsigned_8;
    Py_RETURN_NONE;
}

static
PyMethodDef meth_llvm_SmallVectorunsigned_8[] = {
    { "delete", (PyCFunction)llvm_SmallVectorunsigned_8__delete, METH_VARARGS, NULL },
    { NULL },
};

static
SubModuleEntry submodule_llvm_SmallVectorunsigned_8[] = {
    { NULL }
};

static
PyMethodDef meth_llvm_StringRef[] = {
    { NULL },
};

static
SubModuleEntry submodule_llvm_StringRef[] = {
    { NULL }
};

static
PyObject*
llvm_Triple__isOSBinFormatCOFF(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Triple* var_llvm_Triple = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Triple");
        if(!var_void)
        {
            puts("Error: llvm::Triple");
            return NULL;
        }
        llvm::Triple* var_llvm_Triple1 = unwrap_as<llvm::Triple, llvm::Triple >::from(var_void);
        if(!var_llvm_Triple1)
        {
            return NULL;
        }
        var_llvm_Triple = var_llvm_Triple1;
    }
    bool var_bool = var_llvm_Triple->isOSBinFormatCOFF();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Triple__isArch64Bit(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Triple* var_llvm_Triple = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Triple");
        if(!var_void)
        {
            puts("Error: llvm::Triple");
            return NULL;
        }
        llvm::Triple* var_llvm_Triple1 = unwrap_as<llvm::Triple, llvm::Triple >::from(var_void);
        if(!var_llvm_Triple1)
        {
            return NULL;
        }
        var_llvm_Triple = var_llvm_Triple1;
    }
    bool var_bool = var_llvm_Triple->isArch64Bit();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Triple__isArch16Bit(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Triple* var_llvm_Triple = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Triple");
        if(!var_void)
        {
            puts("Error: llvm::Triple");
            return NULL;
        }
        llvm::Triple* var_llvm_Triple1 = unwrap_as<llvm::Triple, llvm::Triple >::from(var_void);
        if(!var_llvm_Triple1)
        {
            return NULL;
        }
        var_llvm_Triple = var_llvm_Triple1;
    }
    bool var_bool = var_llvm_Triple->isArch16Bit();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Triple__isMacOSX(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Triple* var_llvm_Triple = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Triple");
        if(!var_void)
        {
            puts("Error: llvm::Triple");
            return NULL;
        }
        llvm::Triple* var_llvm_Triple1 = unwrap_as<llvm::Triple, llvm::Triple >::from(var_void);
        if(!var_llvm_Triple1)
        {
            return NULL;
        }
        var_llvm_Triple = var_llvm_Triple1;
    }
    bool var_bool = var_llvm_Triple->isMacOSX();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Triple__new(PyObject* self, PyObject* args)
{
    Py_ssize_t var_Py__ssize__t = PyTuple_Size(args);
    if (0 == var_Py__ssize__t)
    {
        if(!PyArg_ParseTuple(args, ""))
        {
            return NULL;
        }
        llvm::Triple* var_llvm_Triple = new llvm::Triple();
        PyObject* var_PyObject = pycapsule_new(cast_to_base<llvm::Triple >::from(var_llvm_Triple), "llvm::Triple", "llvm::Triple");
        if (!var_PyObject)
        {
            return NULL;
        }
        return var_PyObject;
    }
    if (1 == var_Py__ssize__t)
    {
        PyObject* var_PyObject1;
        if(!PyArg_ParseTuple(args, "O", &var_PyObject1))
        {
            return NULL;
        }
        llvm::StringRef var_llvm_StringRef;
        int var_int = py_str_to(var_PyObject1, var_llvm_StringRef);
        if(!var_int)
        {
            return NULL;
        }
        llvm::Triple* var_llvm_Triple1 = new llvm::Triple(var_llvm_StringRef);
        PyObject* var_PyObject2 = pycapsule_new(cast_to_base<llvm::Triple >::from(var_llvm_Triple1), "llvm::Triple", "llvm::Triple");
        if (!var_PyObject2)
        {
            return NULL;
        }
        return var_PyObject2;
    }
    if (3 == var_Py__ssize__t)
    {
        PyObject* var_PyObject3;
        PyObject* var_PyObject4;
        PyObject* var_PyObject5;
        if(!PyArg_ParseTuple(args, "OOO", &var_PyObject3, &var_PyObject4, &var_PyObject5))
        {
            return NULL;
        }
        llvm::StringRef var_llvm_StringRef1;
        int var_int1 = py_str_to(var_PyObject3, var_llvm_StringRef1);
        if(!var_int1)
        {
            return NULL;
        }
        llvm::StringRef var_llvm_StringRef2;
        int var_int2 = py_str_to(var_PyObject4, var_llvm_StringRef2);
        if(!var_int2)
        {
            return NULL;
        }
        llvm::StringRef var_llvm_StringRef3;
        int var_int3 = py_str_to(var_PyObject5, var_llvm_StringRef3);
        if(!var_int3)
        {
            return NULL;
        }
        llvm::Triple* var_llvm_Triple2 = new llvm::Triple(var_llvm_StringRef1, var_llvm_StringRef2, var_llvm_StringRef3);
        PyObject* var_PyObject6 = pycapsule_new(cast_to_base<llvm::Triple >::from(var_llvm_Triple2), "llvm::Triple", "llvm::Triple");
        if (!var_PyObject6)
        {
            return NULL;
        }
        return var_PyObject6;
    }
    PyErr_SetString(PyExc_TypeError, "Invalid number of args");
    return NULL;
}

static
PyObject*
llvm_Triple__getVendorName(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Triple* var_llvm_Triple = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Triple");
        if(!var_void)
        {
            puts("Error: llvm::Triple");
            return NULL;
        }
        llvm::Triple* var_llvm_Triple1 = unwrap_as<llvm::Triple, llvm::Triple >::from(var_void);
        if(!var_llvm_Triple1)
        {
            return NULL;
        }
        var_llvm_Triple = var_llvm_Triple1;
    }
    llvm::StringRef var_llvm_StringRef = var_llvm_Triple->getVendorName();
    PyObject* var_PyObject1 = py_str_from(var_llvm_StringRef);
    return var_PyObject1;
}

static
PyObject*
llvm_Triple__isOSDarwin(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Triple* var_llvm_Triple = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Triple");
        if(!var_void)
        {
            puts("Error: llvm::Triple");
            return NULL;
        }
        llvm::Triple* var_llvm_Triple1 = unwrap_as<llvm::Triple, llvm::Triple >::from(var_void);
        if(!var_llvm_Triple1)
        {
            return NULL;
        }
        var_llvm_Triple = var_llvm_Triple1;
    }
    bool var_bool = var_llvm_Triple->isOSDarwin();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Triple__isOSCygMing(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Triple* var_llvm_Triple = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Triple");
        if(!var_void)
        {
            puts("Error: llvm::Triple");
            return NULL;
        }
        llvm::Triple* var_llvm_Triple1 = unwrap_as<llvm::Triple, llvm::Triple >::from(var_void);
        if(!var_llvm_Triple1)
        {
            return NULL;
        }
        var_llvm_Triple = var_llvm_Triple1;
    }
    bool var_bool = var_llvm_Triple->isOSCygMing();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Triple__isArch32Bit(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Triple* var_llvm_Triple = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Triple");
        if(!var_void)
        {
            puts("Error: llvm::Triple");
            return NULL;
        }
        llvm::Triple* var_llvm_Triple1 = unwrap_as<llvm::Triple, llvm::Triple >::from(var_void);
        if(!var_llvm_Triple1)
        {
            return NULL;
        }
        var_llvm_Triple = var_llvm_Triple1;
    }
    bool var_bool = var_llvm_Triple->isArch32Bit();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Triple__getTriple(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Triple* var_llvm_Triple = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Triple");
        if(!var_void)
        {
            puts("Error: llvm::Triple");
            return NULL;
        }
        llvm::Triple* var_llvm_Triple1 = unwrap_as<llvm::Triple, llvm::Triple >::from(var_void);
        if(!var_llvm_Triple1)
        {
            return NULL;
        }
        var_llvm_Triple = var_llvm_Triple1;
    }
    llvm::StringRef var_llvm_StringRef = var_llvm_Triple->getTriple();
    PyObject* var_PyObject1 = py_str_from(var_llvm_StringRef);
    return var_PyObject1;
}

static
PyObject*
llvm_Triple__isMacOSXVersionLT(PyObject* self, PyObject* args)
{
    Py_ssize_t var_Py__ssize__t = PyTuple_Size(args);
    if (4 == var_Py__ssize__t)
    {
        PyObject* var_PyObject;
        PyObject* var_PyObject1;
        PyObject* var_PyObject2;
        PyObject* var_PyObject3;
        if(!PyArg_ParseTuple(args, "OOOO", &var_PyObject, &var_PyObject1, &var_PyObject2, &var_PyObject3))
        {
            return NULL;
        }
        llvm::Triple* var_llvm_Triple = NULL;
        if (var_PyObject != Py_None)
        {
            void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Triple");
            if(!var_void)
            {
                puts("Error: llvm::Triple");
                return NULL;
            }
            llvm::Triple* var_llvm_Triple1 = unwrap_as<llvm::Triple, llvm::Triple >::from(var_void);
            if(!var_llvm_Triple1)
            {
                return NULL;
            }
            var_llvm_Triple = var_llvm_Triple1;
        }
        unsigned var_unsigned;
        int var_int = py_int_to(var_PyObject1, var_unsigned);
        if(!var_int)
        {
            return NULL;
        }
        unsigned var_unsigned1;
        int var_int1 = py_int_to(var_PyObject2, var_unsigned1);
        if(!var_int1)
        {
            return NULL;
        }
        unsigned var_unsigned2;
        int var_int2 = py_int_to(var_PyObject3, var_unsigned2);
        if(!var_int2)
        {
            return NULL;
        }
        bool var_bool = var_llvm_Triple->isMacOSXVersionLT(var_unsigned, var_unsigned1, var_unsigned2);
        PyObject* var_PyObject4 = py_bool_from(var_bool);
        return var_PyObject4;
    }
    if (2 == var_Py__ssize__t)
    {
        PyObject* var_PyObject5;
        PyObject* var_PyObject6;
        if(!PyArg_ParseTuple(args, "OO", &var_PyObject5, &var_PyObject6))
        {
            return NULL;
        }
        llvm::Triple* var_llvm_Triple2 = NULL;
        if (var_PyObject5 != Py_None)
        {
            void* var_void1 = PyCapsule_GetPointer(var_PyObject5, "llvm::Triple");
            if(!var_void1)
            {
                puts("Error: llvm::Triple");
                return NULL;
            }
            llvm::Triple* var_llvm_Triple3 = unwrap_as<llvm::Triple, llvm::Triple >::from(var_void1);
            if(!var_llvm_Triple3)
            {
                return NULL;
            }
            var_llvm_Triple2 = var_llvm_Triple3;
        }
        unsigned var_unsigned3;
        int var_int3 = py_int_to(var_PyObject6, var_unsigned3);
        if(!var_int3)
        {
            return NULL;
        }
        bool var_bool1 = var_llvm_Triple2->isMacOSXVersionLT(var_unsigned3);
        PyObject* var_PyObject7 = py_bool_from(var_bool1);
        return var_PyObject7;
    }
    if (3 == var_Py__ssize__t)
    {
        PyObject* var_PyObject8;
        PyObject* var_PyObject9;
        PyObject* var_PyObject10;
        if(!PyArg_ParseTuple(args, "OOO", &var_PyObject8, &var_PyObject9, &var_PyObject10))
        {
            return NULL;
        }
        llvm::Triple* var_llvm_Triple4 = NULL;
        if (var_PyObject8 != Py_None)
        {
            void* var_void2 = PyCapsule_GetPointer(var_PyObject8, "llvm::Triple");
            if(!var_void2)
            {
                puts("Error: llvm::Triple");
                return NULL;
            }
            llvm::Triple* var_llvm_Triple5 = unwrap_as<llvm::Triple, llvm::Triple >::from(var_void2);
            if(!var_llvm_Triple5)
            {
                return NULL;
            }
            var_llvm_Triple4 = var_llvm_Triple5;
        }
        unsigned var_unsigned4;
        int var_int4 = py_int_to(var_PyObject9, var_unsigned4);
        if(!var_int4)
        {
            return NULL;
        }
        unsigned var_unsigned5;
        int var_int5 = py_int_to(var_PyObject10, var_unsigned5);
        if(!var_int5)
        {
            return NULL;
        }
        bool var_bool2 = var_llvm_Triple4->isMacOSXVersionLT(var_unsigned4, var_unsigned5);
        PyObject* var_PyObject11 = py_bool_from(var_bool2);
        return var_PyObject11;
    }
    PyErr_SetString(PyExc_TypeError, "Invalid number of args");
    return NULL;
}

static
PyObject*
llvm_Triple__isOSVersionLT(PyObject* self, PyObject* args)
{
    Py_ssize_t var_Py__ssize__t = PyTuple_Size(args);
    if (4 == var_Py__ssize__t)
    {
        PyObject* var_PyObject;
        PyObject* var_PyObject1;
        PyObject* var_PyObject2;
        PyObject* var_PyObject3;
        if(!PyArg_ParseTuple(args, "OOOO", &var_PyObject, &var_PyObject1, &var_PyObject2, &var_PyObject3))
        {
            return NULL;
        }
        llvm::Triple* var_llvm_Triple = NULL;
        if (var_PyObject != Py_None)
        {
            void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Triple");
            if(!var_void)
            {
                puts("Error: llvm::Triple");
                return NULL;
            }
            llvm::Triple* var_llvm_Triple1 = unwrap_as<llvm::Triple, llvm::Triple >::from(var_void);
            if(!var_llvm_Triple1)
            {
                return NULL;
            }
            var_llvm_Triple = var_llvm_Triple1;
        }
        unsigned var_unsigned;
        int var_int = py_int_to(var_PyObject1, var_unsigned);
        if(!var_int)
        {
            return NULL;
        }
        unsigned var_unsigned1;
        int var_int1 = py_int_to(var_PyObject2, var_unsigned1);
        if(!var_int1)
        {
            return NULL;
        }
        unsigned var_unsigned2;
        int var_int2 = py_int_to(var_PyObject3, var_unsigned2);
        if(!var_int2)
        {
            return NULL;
        }
        bool var_bool = var_llvm_Triple->isOSVersionLT(var_unsigned, var_unsigned1, var_unsigned2);
        PyObject* var_PyObject4 = py_bool_from(var_bool);
        return var_PyObject4;
    }
    if (2 == var_Py__ssize__t)
    {
        PyObject* var_PyObject5;
        PyObject* var_PyObject6;
        if(!PyArg_ParseTuple(args, "OO", &var_PyObject5, &var_PyObject6))
        {
            return NULL;
        }
        llvm::Triple* var_llvm_Triple2 = NULL;
        if (var_PyObject5 != Py_None)
        {
            void* var_void1 = PyCapsule_GetPointer(var_PyObject5, "llvm::Triple");
            if(!var_void1)
            {
                puts("Error: llvm::Triple");
                return NULL;
            }
            llvm::Triple* var_llvm_Triple3 = unwrap_as<llvm::Triple, llvm::Triple >::from(var_void1);
            if(!var_llvm_Triple3)
            {
                return NULL;
            }
            var_llvm_Triple2 = var_llvm_Triple3;
        }
        unsigned var_unsigned3;
        int var_int3 = py_int_to(var_PyObject6, var_unsigned3);
        if(!var_int3)
        {
            return NULL;
        }
        bool var_bool1 = var_llvm_Triple2->isOSVersionLT(var_unsigned3);
        PyObject* var_PyObject7 = py_bool_from(var_bool1);
        return var_PyObject7;
    }
    if (3 == var_Py__ssize__t)
    {
        PyObject* var_PyObject8;
        PyObject* var_PyObject9;
        PyObject* var_PyObject10;
        if(!PyArg_ParseTuple(args, "OOO", &var_PyObject8, &var_PyObject9, &var_PyObject10))
        {
            return NULL;
        }
        llvm::Triple* var_llvm_Triple4 = NULL;
        if (var_PyObject8 != Py_None)
        {
            void* var_void2 = PyCapsule_GetPointer(var_PyObject8, "llvm::Triple");
            if(!var_void2)
            {
                puts("Error: llvm::Triple");
                return NULL;
            }
            llvm::Triple* var_llvm_Triple5 = unwrap_as<llvm::Triple, llvm::Triple >::from(var_void2);
            if(!var_llvm_Triple5)
            {
                return NULL;
            }
            var_llvm_Triple4 = var_llvm_Triple5;
        }
        unsigned var_unsigned4;
        int var_int4 = py_int_to(var_PyObject9, var_unsigned4);
        if(!var_int4)
        {
            return NULL;
        }
        unsigned var_unsigned5;
        int var_int5 = py_int_to(var_PyObject10, var_unsigned5);
        if(!var_int5)
        {
            return NULL;
        }
        bool var_bool2 = var_llvm_Triple4->isOSVersionLT(var_unsigned4, var_unsigned5);
        PyObject* var_PyObject11 = py_bool_from(var_bool2);
        return var_PyObject11;
    }
    PyErr_SetString(PyExc_TypeError, "Invalid number of args");
    return NULL;
}

static
PyObject*
llvm_Triple__getEnvironmentName(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Triple* var_llvm_Triple = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Triple");
        if(!var_void)
        {
            puts("Error: llvm::Triple");
            return NULL;
        }
        llvm::Triple* var_llvm_Triple1 = unwrap_as<llvm::Triple, llvm::Triple >::from(var_void);
        if(!var_llvm_Triple1)
        {
            return NULL;
        }
        var_llvm_Triple = var_llvm_Triple1;
    }
    llvm::StringRef var_llvm_StringRef = var_llvm_Triple->getEnvironmentName();
    PyObject* var_PyObject1 = py_str_from(var_llvm_StringRef);
    return var_PyObject1;
}

static
PyObject*
llvm_Triple__get32BitArchVariant(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Triple* var_llvm_Triple = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Triple");
        if(!var_void)
        {
            puts("Error: llvm::Triple");
            return NULL;
        }
        llvm::Triple* var_llvm_Triple1 = unwrap_as<llvm::Triple, llvm::Triple >::from(var_void);
        if(!var_llvm_Triple1)
        {
            return NULL;
        }
        var_llvm_Triple = var_llvm_Triple1;
    }
    llvm::Triple var_llvm_Triple2 = var_llvm_Triple->get32BitArchVariant();
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Triple >::from(new llvm::Triple(var_llvm_Triple2)), "llvm::Triple", "llvm::Triple");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyObject*
llvm_Triple__getArchName(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Triple* var_llvm_Triple = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Triple");
        if(!var_void)
        {
            puts("Error: llvm::Triple");
            return NULL;
        }
        llvm::Triple* var_llvm_Triple1 = unwrap_as<llvm::Triple, llvm::Triple >::from(var_void);
        if(!var_llvm_Triple1)
        {
            return NULL;
        }
        var_llvm_Triple = var_llvm_Triple1;
    }
    llvm::StringRef var_llvm_StringRef = var_llvm_Triple->getArchName();
    PyObject* var_PyObject1 = py_str_from(var_llvm_StringRef);
    return var_PyObject1;
}

static
PyObject*
llvm_Triple__getOSAndEnvironmentName(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Triple* var_llvm_Triple = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Triple");
        if(!var_void)
        {
            puts("Error: llvm::Triple");
            return NULL;
        }
        llvm::Triple* var_llvm_Triple1 = unwrap_as<llvm::Triple, llvm::Triple >::from(var_void);
        if(!var_llvm_Triple1)
        {
            return NULL;
        }
        var_llvm_Triple = var_llvm_Triple1;
    }
    llvm::StringRef var_llvm_StringRef = var_llvm_Triple->getOSAndEnvironmentName();
    PyObject* var_PyObject1 = py_str_from(var_llvm_StringRef);
    return var_PyObject1;
}

static
PyObject*
llvm_Triple__get64BitArchVariant(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Triple* var_llvm_Triple = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Triple");
        if(!var_void)
        {
            puts("Error: llvm::Triple");
            return NULL;
        }
        llvm::Triple* var_llvm_Triple1 = unwrap_as<llvm::Triple, llvm::Triple >::from(var_void);
        if(!var_llvm_Triple1)
        {
            return NULL;
        }
        var_llvm_Triple = var_llvm_Triple1;
    }
    llvm::Triple var_llvm_Triple2 = var_llvm_Triple->get64BitArchVariant();
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Triple >::from(new llvm::Triple(var_llvm_Triple2)), "llvm::Triple", "llvm::Triple");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyObject*
llvm_Triple__isOSBinFormatELF(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Triple* var_llvm_Triple = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Triple");
        if(!var_void)
        {
            puts("Error: llvm::Triple");
            return NULL;
        }
        llvm::Triple* var_llvm_Triple1 = unwrap_as<llvm::Triple, llvm::Triple >::from(var_void);
        if(!var_llvm_Triple1)
        {
            return NULL;
        }
        var_llvm_Triple = var_llvm_Triple1;
    }
    bool var_bool = var_llvm_Triple->isOSBinFormatELF();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Triple__isEnvironmentMachO(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Triple* var_llvm_Triple = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Triple");
        if(!var_void)
        {
            puts("Error: llvm::Triple");
            return NULL;
        }
        llvm::Triple* var_llvm_Triple1 = unwrap_as<llvm::Triple, llvm::Triple >::from(var_void);
        if(!var_llvm_Triple1)
        {
            return NULL;
        }
        var_llvm_Triple = var_llvm_Triple1;
    }
    bool var_bool = var_llvm_Triple->isEnvironmentMachO();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Triple__isOSWindows(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Triple* var_llvm_Triple = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Triple");
        if(!var_void)
        {
            puts("Error: llvm::Triple");
            return NULL;
        }
        llvm::Triple* var_llvm_Triple1 = unwrap_as<llvm::Triple, llvm::Triple >::from(var_void);
        if(!var_llvm_Triple1)
        {
            return NULL;
        }
        var_llvm_Triple = var_llvm_Triple1;
    }
    bool var_bool = var_llvm_Triple->isOSWindows();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Triple__getOSName(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Triple* var_llvm_Triple = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Triple");
        if(!var_void)
        {
            puts("Error: llvm::Triple");
            return NULL;
        }
        llvm::Triple* var_llvm_Triple1 = unwrap_as<llvm::Triple, llvm::Triple >::from(var_void);
        if(!var_llvm_Triple1)
        {
            return NULL;
        }
        var_llvm_Triple = var_llvm_Triple1;
    }
    llvm::StringRef var_llvm_StringRef = var_llvm_Triple->getOSName();
    PyObject* var_PyObject1 = py_str_from(var_llvm_StringRef);
    return var_PyObject1;
}

static
PyMethodDef meth_llvm_Triple[] = {
    { "isOSBinFormatCOFF", (PyCFunction)llvm_Triple__isOSBinFormatCOFF, METH_VARARGS, NULL },
    { "isArch64Bit", (PyCFunction)llvm_Triple__isArch64Bit, METH_VARARGS, NULL },
    { "isArch16Bit", (PyCFunction)llvm_Triple__isArch16Bit, METH_VARARGS, NULL },
    { "isMacOSX", (PyCFunction)llvm_Triple__isMacOSX, METH_VARARGS, NULL },
    { "new", (PyCFunction)llvm_Triple__new, METH_VARARGS, NULL },
    { "getVendorName", (PyCFunction)llvm_Triple__getVendorName, METH_VARARGS, NULL },
    { "isOSDarwin", (PyCFunction)llvm_Triple__isOSDarwin, METH_VARARGS, NULL },
    { "isOSCygMing", (PyCFunction)llvm_Triple__isOSCygMing, METH_VARARGS, NULL },
    { "isArch32Bit", (PyCFunction)llvm_Triple__isArch32Bit, METH_VARARGS, NULL },
    { "getTriple", (PyCFunction)llvm_Triple__getTriple, METH_VARARGS, NULL },
    { "isMacOSXVersionLT", (PyCFunction)llvm_Triple__isMacOSXVersionLT, METH_VARARGS, NULL },
    { "isOSVersionLT", (PyCFunction)llvm_Triple__isOSVersionLT, METH_VARARGS, NULL },
    { "getEnvironmentName", (PyCFunction)llvm_Triple__getEnvironmentName, METH_VARARGS, NULL },
    { "get32BitArchVariant", (PyCFunction)llvm_Triple__get32BitArchVariant, METH_VARARGS, NULL },
    { "getArchName", (PyCFunction)llvm_Triple__getArchName, METH_VARARGS, NULL },
    { "getOSAndEnvironmentName", (PyCFunction)llvm_Triple__getOSAndEnvironmentName, METH_VARARGS, NULL },
    { "get64BitArchVariant", (PyCFunction)llvm_Triple__get64BitArchVariant, METH_VARARGS, NULL },
    { "isOSBinFormatELF", (PyCFunction)llvm_Triple__isOSBinFormatELF, METH_VARARGS, NULL },
    { "isEnvironmentMachO", (PyCFunction)llvm_Triple__isEnvironmentMachO, METH_VARARGS, NULL },
    { "isOSWindows", (PyCFunction)llvm_Triple__isOSWindows, METH_VARARGS, NULL },
    { "getOSName", (PyCFunction)llvm_Triple__getOSName, METH_VARARGS, NULL },
    { NULL },
};

static
SubModuleEntry submodule_llvm_Triple[] = {
    { NULL }
};

static
PyObject*
llvm_Module__getPointerSize(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Module* var_llvm_Module = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Module");
        if(!var_void)
        {
            puts("Error: llvm::Module");
            return NULL;
        }
        llvm::Module* var_llvm_Module1 = unwrap_as<llvm::Module, llvm::Module >::from(var_void);
        if(!var_llvm_Module1)
        {
            return NULL;
        }
        var_llvm_Module = var_llvm_Module1;
    }
    llvm::Module::PointerSize var_llvm_Module_PointerSize = var_llvm_Module->getPointerSize();
    PyObject* var_PyObject1 = PyInt_FromLong(var_llvm_Module_PointerSize);
    return var_PyObject1;
}

static
PyObject*
llvm_Module__getModuleInlineAsm(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Module* var_llvm_Module = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Module");
        if(!var_void)
        {
            puts("Error: llvm::Module");
            return NULL;
        }
        llvm::Module* var_llvm_Module1 = unwrap_as<llvm::Module, llvm::Module >::from(var_void);
        if(!var_llvm_Module1)
        {
            return NULL;
        }
        var_llvm_Module = var_llvm_Module1;
    }
    const std::string var_const_std_string = var_llvm_Module->getModuleInlineAsm();
    PyObject* var_PyObject1 = py_str_from(var_const_std_string);
    return var_PyObject1;
}

static
PyObject*
llvm_Module__list__named__metadata(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Module* var_llvm_Module = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Module");
        if(!var_void)
        {
            puts("Error: llvm::Module");
            return NULL;
        }
        llvm::Module* var_llvm_Module1 = unwrap_as<llvm::Module, llvm::Module >::from(var_void);
        if(!var_llvm_Module1)
        {
            return NULL;
        }
        var_llvm_Module = var_llvm_Module1;
    }
    PyObject* var_PyObject1 = Module_list_named_metadata(var_llvm_Module);
    return var_PyObject1;
}

static
PyObject*
llvm_Module__setTargetTriple(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::Module* var_llvm_Module = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Module");
        if(!var_void)
        {
            puts("Error: llvm::Module");
            return NULL;
        }
        llvm::Module* var_llvm_Module1 = unwrap_as<llvm::Module, llvm::Module >::from(var_void);
        if(!var_llvm_Module1)
        {
            return NULL;
        }
        var_llvm_Module = var_llvm_Module1;
    }
    llvm::StringRef var_llvm_StringRef;
    int var_int = py_str_to(var_PyObject1, var_llvm_StringRef);
    if(!var_int)
    {
        return NULL;
    }
    var_llvm_Module->setTargetTriple(var_llvm_StringRef);
    Py_RETURN_NONE;
}

static
PyObject*
llvm_Module__new(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::StringRef var_llvm_StringRef;
    int var_int = py_str_to(var_PyObject, var_llvm_StringRef);
    if(!var_int)
    {
        return NULL;
    }
    void* var_void = PyCapsule_GetPointer(var_PyObject1, "llvm::LLVMContext");
    if(!var_void)
    {
        puts("Error: llvm::LLVMContext");
        return NULL;
    }
    llvm::LLVMContext* var_llvm_LLVMContext = unwrap_as<llvm::LLVMContext, llvm::LLVMContext >::from(var_void);
    if(!var_llvm_LLVMContext)
    {
        return NULL;
    }
    llvm::LLVMContext& var_llvm_LLVMContext1 = *var_llvm_LLVMContext;
    llvm::Module* var_llvm_Module = new llvm::Module(var_llvm_StringRef, var_llvm_LLVMContext1);
    PyObject* var_PyObject2 = pycapsule_new(cast_to_base<llvm::Module >::from(var_llvm_Module), "llvm::Module", "llvm::Module");
    if (!var_PyObject2)
    {
        return NULL;
    }
    return var_PyObject2;
}

static
PyObject*
llvm_Module__dropAllReferences(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Module* var_llvm_Module = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Module");
        if(!var_void)
        {
            puts("Error: llvm::Module");
            return NULL;
        }
        llvm::Module* var_llvm_Module1 = unwrap_as<llvm::Module, llvm::Module >::from(var_void);
        if(!var_llvm_Module1)
        {
            return NULL;
        }
        var_llvm_Module = var_llvm_Module1;
    }
    var_llvm_Module->dropAllReferences();
    Py_RETURN_NONE;
}

static
PyObject*
llvm_Module__getOrInsertNamedMetadata(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::Module* var_llvm_Module = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Module");
        if(!var_void)
        {
            puts("Error: llvm::Module");
            return NULL;
        }
        llvm::Module* var_llvm_Module1 = unwrap_as<llvm::Module, llvm::Module >::from(var_void);
        if(!var_llvm_Module1)
        {
            return NULL;
        }
        var_llvm_Module = var_llvm_Module1;
    }
    llvm::StringRef var_llvm_StringRef;
    int var_int = py_str_to(var_PyObject1, var_llvm_StringRef);
    if(!var_int)
    {
        return NULL;
    }
    llvm::NamedMDNode* var_llvm_NamedMDNode = var_llvm_Module->getOrInsertNamedMetadata(var_llvm_StringRef);
    PyObject* var_PyObject2 = pycapsule_new(cast_to_base<llvm::NamedMDNode >::from(var_llvm_NamedMDNode), "llvm::NamedMDNode", "llvm::NamedMDNode");
    if (!var_PyObject2)
    {
        return NULL;
    }
    return var_PyObject2;
}

static
PyObject*
llvm_Module__getContext(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Module* var_llvm_Module = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Module");
        if(!var_void)
        {
            puts("Error: llvm::Module");
            return NULL;
        }
        llvm::Module* var_llvm_Module1 = unwrap_as<llvm::Module, llvm::Module >::from(var_void);
        if(!var_llvm_Module1)
        {
            return NULL;
        }
        var_llvm_Module = var_llvm_Module1;
    }
    llvm::LLVMContext& var_llvm_LLVMContext = var_llvm_Module->getContext();
    const llvm::LLVMContext* var_const_llvm_LLVMContext = &var_llvm_LLVMContext;
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::LLVMContext >::from(var_const_llvm_LLVMContext), "llvm::LLVMContext", "llvm::LLVMContext");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyObject*
llvm_Module__getTypeByName(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::Module* var_llvm_Module = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Module");
        if(!var_void)
        {
            puts("Error: llvm::Module");
            return NULL;
        }
        llvm::Module* var_llvm_Module1 = unwrap_as<llvm::Module, llvm::Module >::from(var_void);
        if(!var_llvm_Module1)
        {
            return NULL;
        }
        var_llvm_Module = var_llvm_Module1;
    }
    llvm::StringRef var_llvm_StringRef;
    int var_int = py_str_to(var_PyObject1, var_llvm_StringRef);
    if(!var_int)
    {
        return NULL;
    }
    llvm::StructType* var_llvm_StructType = var_llvm_Module->getTypeByName(var_llvm_StringRef);
    PyObject* var_PyObject2 = pycapsule_new(cast_to_base<llvm::Type >::from(var_llvm_StructType), "llvm::Type", "llvm::StructType");
    if (!var_PyObject2)
    {
        return NULL;
    }
    return var_PyObject2;
}

static
PyObject*
llvm_Module__print__(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    PyObject* var_PyObject2;
    if(!PyArg_ParseTuple(args, "OOO", &var_PyObject, &var_PyObject1, &var_PyObject2))
    {
        return NULL;
    }
    llvm::Module* var_llvm_Module = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Module");
        if(!var_void)
        {
            puts("Error: llvm::Module");
            return NULL;
        }
        llvm::Module* var_llvm_Module1 = unwrap_as<llvm::Module, llvm::Module >::from(var_void);
        if(!var_llvm_Module1)
        {
            return NULL;
        }
        var_llvm_Module = var_llvm_Module1;
    }
    void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::raw_ostream");
    if(!var_void1)
    {
        puts("Error: llvm::raw_ostream");
        return NULL;
    }
    llvm::raw_ostream* var_llvm_raw__ostream = unwrap_as<llvm::raw_ostream, llvm::raw_ostream >::from(var_void1);
    if(!var_llvm_raw__ostream)
    {
        return NULL;
    }
    llvm::raw_ostream& var_llvm_raw__ostream1 = *var_llvm_raw__ostream;
    llvm::AssemblyAnnotationWriter* var_llvm_AssemblyAnnotationWriter = NULL;
    if (var_PyObject2 != Py_None)
    {
        void* var_void2 = PyCapsule_GetPointer(var_PyObject2, "llvm::AssemblyAnnotationWriter");
        if(!var_void2)
        {
            puts("Error: llvm::AssemblyAnnotationWriter");
            return NULL;
        }
        llvm::AssemblyAnnotationWriter* var_llvm_AssemblyAnnotationWriter1 = unwrap_as<llvm::AssemblyAnnotationWriter, llvm::AssemblyAnnotationWriter >::from(var_void2);
        if(!var_llvm_AssemblyAnnotationWriter1)
        {
            return NULL;
        }
        var_llvm_AssemblyAnnotationWriter = var_llvm_AssemblyAnnotationWriter1;
    }
    var_llvm_Module->print(var_llvm_raw__ostream1, var_llvm_AssemblyAnnotationWriter);
    Py_RETURN_NONE;
}

static
PyObject*
llvm_Module__getOrInsertGlobal(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    PyObject* var_PyObject2;
    if(!PyArg_ParseTuple(args, "OOO", &var_PyObject, &var_PyObject1, &var_PyObject2))
    {
        return NULL;
    }
    llvm::Module* var_llvm_Module = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Module");
        if(!var_void)
        {
            puts("Error: llvm::Module");
            return NULL;
        }
        llvm::Module* var_llvm_Module1 = unwrap_as<llvm::Module, llvm::Module >::from(var_void);
        if(!var_llvm_Module1)
        {
            return NULL;
        }
        var_llvm_Module = var_llvm_Module1;
    }
    llvm::StringRef var_llvm_StringRef;
    int var_int = py_str_to(var_PyObject1, var_llvm_StringRef);
    if(!var_int)
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject2 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject2, "llvm::Type");
        if(!var_void1)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void1);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    llvm::Constant* var_llvm_Constant = var_llvm_Module->getOrInsertGlobal(var_llvm_StringRef, var_llvm_Type);
    PyObject* var_PyObject3 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant), "llvm::Value", "llvm::Constant");
    if (!var_PyObject3)
    {
        return NULL;
    }
    return var_PyObject3;
}

static
PyObject*
llvm_Module__list__globals(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Module* var_llvm_Module = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Module");
        if(!var_void)
        {
            puts("Error: llvm::Module");
            return NULL;
        }
        llvm::Module* var_llvm_Module1 = unwrap_as<llvm::Module, llvm::Module >::from(var_void);
        if(!var_llvm_Module1)
        {
            return NULL;
        }
        var_llvm_Module = var_llvm_Module1;
    }
    PyObject* var_PyObject1 = Module_list_globals(var_llvm_Module);
    return var_PyObject1;
}

static
PyObject*
llvm_Module__getDataLayout(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Module* var_llvm_Module = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Module");
        if(!var_void)
        {
            puts("Error: llvm::Module");
            return NULL;
        }
        llvm::Module* var_llvm_Module1 = unwrap_as<llvm::Module, llvm::Module >::from(var_void);
        if(!var_llvm_Module1)
        {
            return NULL;
        }
        var_llvm_Module = var_llvm_Module1;
    }
    const std::string var_const_std_string = var_llvm_Module->getDataLayout();
    PyObject* var_PyObject1 = py_str_from(var_const_std_string);
    return var_PyObject1;
}

static
PyObject*
llvm_Module__getNamedGlobal(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::Module* var_llvm_Module = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Module");
        if(!var_void)
        {
            puts("Error: llvm::Module");
            return NULL;
        }
        llvm::Module* var_llvm_Module1 = unwrap_as<llvm::Module, llvm::Module >::from(var_void);
        if(!var_llvm_Module1)
        {
            return NULL;
        }
        var_llvm_Module = var_llvm_Module1;
    }
    llvm::StringRef var_llvm_StringRef;
    int var_int = py_str_to(var_PyObject1, var_llvm_StringRef);
    if(!var_int)
    {
        return NULL;
    }
    llvm::GlobalVariable* var_llvm_GlobalVariable = var_llvm_Module->getNamedGlobal(var_llvm_StringRef);
    PyObject* var_PyObject2 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_GlobalVariable), "llvm::Value", "llvm::GlobalVariable");
    if (!var_PyObject2)
    {
        return NULL;
    }
    return var_PyObject2;
}

static
PyObject*
llvm_Module__setModuleInlineAsm(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::Module* var_llvm_Module = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Module");
        if(!var_void)
        {
            puts("Error: llvm::Module");
            return NULL;
        }
        llvm::Module* var_llvm_Module1 = unwrap_as<llvm::Module, llvm::Module >::from(var_void);
        if(!var_llvm_Module1)
        {
            return NULL;
        }
        var_llvm_Module = var_llvm_Module1;
    }
    llvm::StringRef var_llvm_StringRef;
    int var_int = py_str_to(var_PyObject1, var_llvm_StringRef);
    if(!var_int)
    {
        return NULL;
    }
    var_llvm_Module->setModuleInlineAsm(var_llvm_StringRef);
    Py_RETURN_NONE;
}

static
PyObject*
llvm_Module__eraseNamedMetadata(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::Module* var_llvm_Module = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Module");
        if(!var_void)
        {
            puts("Error: llvm::Module");
            return NULL;
        }
        llvm::Module* var_llvm_Module1 = unwrap_as<llvm::Module, llvm::Module >::from(var_void);
        if(!var_llvm_Module1)
        {
            return NULL;
        }
        var_llvm_Module = var_llvm_Module1;
    }
    llvm::NamedMDNode* var_llvm_NamedMDNode = NULL;
    if (var_PyObject1 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::NamedMDNode");
        if(!var_void1)
        {
            puts("Error: llvm::NamedMDNode");
            return NULL;
        }
        llvm::NamedMDNode* var_llvm_NamedMDNode1 = unwrap_as<llvm::NamedMDNode, llvm::NamedMDNode >::from(var_void1);
        if(!var_llvm_NamedMDNode1)
        {
            return NULL;
        }
        var_llvm_NamedMDNode = var_llvm_NamedMDNode1;
    }
    var_llvm_Module->eraseNamedMetadata(var_llvm_NamedMDNode);
    Py_RETURN_NONE;
}

static
PyObject*
llvm_Module__setDataLayout(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::Module* var_llvm_Module = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Module");
        if(!var_void)
        {
            puts("Error: llvm::Module");
            return NULL;
        }
        llvm::Module* var_llvm_Module1 = unwrap_as<llvm::Module, llvm::Module >::from(var_void);
        if(!var_llvm_Module1)
        {
            return NULL;
        }
        var_llvm_Module = var_llvm_Module1;
    }
    llvm::StringRef var_llvm_StringRef;
    int var_int = py_str_to(var_PyObject1, var_llvm_StringRef);
    if(!var_int)
    {
        return NULL;
    }
    var_llvm_Module->setDataLayout(var_llvm_StringRef);
    Py_RETURN_NONE;
}

static
PyObject*
llvm_Module__getFunction(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::Module* var_llvm_Module = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Module");
        if(!var_void)
        {
            puts("Error: llvm::Module");
            return NULL;
        }
        llvm::Module* var_llvm_Module1 = unwrap_as<llvm::Module, llvm::Module >::from(var_void);
        if(!var_llvm_Module1)
        {
            return NULL;
        }
        var_llvm_Module = var_llvm_Module1;
    }
    llvm::StringRef var_llvm_StringRef;
    int var_int = py_str_to(var_PyObject1, var_llvm_StringRef);
    if(!var_int)
    {
        return NULL;
    }
    llvm::Function* var_llvm_Function = var_llvm_Module->getFunction(var_llvm_StringRef);
    PyObject* var_PyObject2 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Function), "llvm::Value", "llvm::Function");
    if (!var_PyObject2)
    {
        return NULL;
    }
    return var_PyObject2;
}

static
PyObject*
llvm_Module__getEndianness(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Module* var_llvm_Module = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Module");
        if(!var_void)
        {
            puts("Error: llvm::Module");
            return NULL;
        }
        llvm::Module* var_llvm_Module1 = unwrap_as<llvm::Module, llvm::Module >::from(var_void);
        if(!var_llvm_Module1)
        {
            return NULL;
        }
        var_llvm_Module = var_llvm_Module1;
    }
    llvm::Module::Endianness var_llvm_Module_Endianness = var_llvm_Module->getEndianness();
    PyObject* var_PyObject1 = PyInt_FromLong(var_llvm_Module_Endianness);
    return var_PyObject1;
}

static
PyObject*
llvm_Module__getGlobalVariable(PyObject* self, PyObject* args)
{
    Py_ssize_t var_Py__ssize__t = PyTuple_Size(args);
    if (3 == var_Py__ssize__t)
    {
        PyObject* var_PyObject;
        PyObject* var_PyObject1;
        PyObject* var_PyObject2;
        if(!PyArg_ParseTuple(args, "OOO", &var_PyObject, &var_PyObject1, &var_PyObject2))
        {
            return NULL;
        }
        llvm::Module* var_llvm_Module = NULL;
        if (var_PyObject != Py_None)
        {
            void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Module");
            if(!var_void)
            {
                puts("Error: llvm::Module");
                return NULL;
            }
            llvm::Module* var_llvm_Module1 = unwrap_as<llvm::Module, llvm::Module >::from(var_void);
            if(!var_llvm_Module1)
            {
                return NULL;
            }
            var_llvm_Module = var_llvm_Module1;
        }
        llvm::StringRef var_llvm_StringRef;
        int var_int = py_str_to(var_PyObject1, var_llvm_StringRef);
        if(!var_int)
        {
            return NULL;
        }
        bool var_bool;
        int var_int1 = py_bool_to(var_PyObject2, var_bool);
        if(!var_int1)
        {
            return NULL;
        }
        llvm::GlobalVariable* var_llvm_GlobalVariable = var_llvm_Module->getGlobalVariable(var_llvm_StringRef, var_bool);
        PyObject* var_PyObject3 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_GlobalVariable), "llvm::Value", "llvm::GlobalVariable");
        if (!var_PyObject3)
        {
            return NULL;
        }
        return var_PyObject3;
    }
    if (2 == var_Py__ssize__t)
    {
        PyObject* var_PyObject4;
        PyObject* var_PyObject5;
        if(!PyArg_ParseTuple(args, "OO", &var_PyObject4, &var_PyObject5))
        {
            return NULL;
        }
        llvm::Module* var_llvm_Module2 = NULL;
        if (var_PyObject4 != Py_None)
        {
            void* var_void1 = PyCapsule_GetPointer(var_PyObject4, "llvm::Module");
            if(!var_void1)
            {
                puts("Error: llvm::Module");
                return NULL;
            }
            llvm::Module* var_llvm_Module3 = unwrap_as<llvm::Module, llvm::Module >::from(var_void1);
            if(!var_llvm_Module3)
            {
                return NULL;
            }
            var_llvm_Module2 = var_llvm_Module3;
        }
        llvm::StringRef var_llvm_StringRef1;
        int var_int2 = py_str_to(var_PyObject5, var_llvm_StringRef1);
        if(!var_int2)
        {
            return NULL;
        }
        llvm::GlobalVariable* var_llvm_GlobalVariable1 = var_llvm_Module2->getGlobalVariable(var_llvm_StringRef1);
        PyObject* var_PyObject6 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_GlobalVariable1), "llvm::Value", "llvm::GlobalVariable");
        if (!var_PyObject6)
        {
            return NULL;
        }
        return var_PyObject6;
    }
    PyErr_SetString(PyExc_TypeError, "Invalid number of args");
    return NULL;
}

static
PyObject*
llvm_Module__getTargetTriple(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Module* var_llvm_Module = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Module");
        if(!var_void)
        {
            puts("Error: llvm::Module");
            return NULL;
        }
        llvm::Module* var_llvm_Module1 = unwrap_as<llvm::Module, llvm::Module >::from(var_void);
        if(!var_llvm_Module1)
        {
            return NULL;
        }
        var_llvm_Module = var_llvm_Module1;
    }
    const std::string var_const_std_string = var_llvm_Module->getTargetTriple();
    PyObject* var_PyObject1 = py_str_from(var_const_std_string);
    return var_PyObject1;
}

static
PyObject*
llvm_Module__delete(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Module* var_llvm_Module = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Module");
        if(!var_void)
        {
            puts("Error: llvm::Module");
            return NULL;
        }
        llvm::Module* var_llvm_Module1 = unwrap_as<llvm::Module, llvm::Module >::from(var_void);
        if(!var_llvm_Module1)
        {
            return NULL;
        }
        var_llvm_Module = var_llvm_Module1;
    }
    delete var_llvm_Module;
    Py_RETURN_NONE;
}

static
PyObject*
llvm_Module__appendModuleInlineAsm(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::Module* var_llvm_Module = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Module");
        if(!var_void)
        {
            puts("Error: llvm::Module");
            return NULL;
        }
        llvm::Module* var_llvm_Module1 = unwrap_as<llvm::Module, llvm::Module >::from(var_void);
        if(!var_llvm_Module1)
        {
            return NULL;
        }
        var_llvm_Module = var_llvm_Module1;
    }
    llvm::StringRef var_llvm_StringRef;
    int var_int = py_str_to(var_PyObject1, var_llvm_StringRef);
    if(!var_int)
    {
        return NULL;
    }
    var_llvm_Module->appendModuleInlineAsm(var_llvm_StringRef);
    Py_RETURN_NONE;
}

static
PyObject*
llvm_Module__dump(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Module* var_llvm_Module = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Module");
        if(!var_void)
        {
            puts("Error: llvm::Module");
            return NULL;
        }
        llvm::Module* var_llvm_Module1 = unwrap_as<llvm::Module, llvm::Module >::from(var_void);
        if(!var_llvm_Module1)
        {
            return NULL;
        }
        var_llvm_Module = var_llvm_Module1;
    }
    var_llvm_Module->dump();
    Py_RETURN_NONE;
}

static
PyObject*
llvm_Module__list__functions(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Module* var_llvm_Module = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Module");
        if(!var_void)
        {
            puts("Error: llvm::Module");
            return NULL;
        }
        llvm::Module* var_llvm_Module1 = unwrap_as<llvm::Module, llvm::Module >::from(var_void);
        if(!var_llvm_Module1)
        {
            return NULL;
        }
        var_llvm_Module = var_llvm_Module1;
    }
    PyObject* var_PyObject1 = Module_list_functions(var_llvm_Module);
    return var_PyObject1;
}

static
PyObject*
llvm_Module__getModuleIdentifier(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Module* var_llvm_Module = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Module");
        if(!var_void)
        {
            puts("Error: llvm::Module");
            return NULL;
        }
        llvm::Module* var_llvm_Module1 = unwrap_as<llvm::Module, llvm::Module >::from(var_void);
        if(!var_llvm_Module1)
        {
            return NULL;
        }
        var_llvm_Module = var_llvm_Module1;
    }
    const std::string var_const_std_string = var_llvm_Module->getModuleIdentifier();
    PyObject* var_PyObject1 = py_str_from(var_const_std_string);
    return var_PyObject1;
}

static
PyObject*
llvm_Module__setModuleIdentifier(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::Module* var_llvm_Module = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Module");
        if(!var_void)
        {
            puts("Error: llvm::Module");
            return NULL;
        }
        llvm::Module* var_llvm_Module1 = unwrap_as<llvm::Module, llvm::Module >::from(var_void);
        if(!var_llvm_Module1)
        {
            return NULL;
        }
        var_llvm_Module = var_llvm_Module1;
    }
    llvm::StringRef var_llvm_StringRef;
    int var_int = py_str_to(var_PyObject1, var_llvm_StringRef);
    if(!var_int)
    {
        return NULL;
    }
    var_llvm_Module->setModuleIdentifier(var_llvm_StringRef);
    Py_RETURN_NONE;
}

static
PyObject*
llvm_Module__getNamedMetadata(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::Module* var_llvm_Module = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Module");
        if(!var_void)
        {
            puts("Error: llvm::Module");
            return NULL;
        }
        llvm::Module* var_llvm_Module1 = unwrap_as<llvm::Module, llvm::Module >::from(var_void);
        if(!var_llvm_Module1)
        {
            return NULL;
        }
        var_llvm_Module = var_llvm_Module1;
    }
    llvm::StringRef var_llvm_StringRef;
    int var_int = py_str_to(var_PyObject1, var_llvm_StringRef);
    if(!var_int)
    {
        return NULL;
    }
    llvm::NamedMDNode* var_llvm_NamedMDNode = var_llvm_Module->getNamedMetadata(var_llvm_StringRef);
    PyObject* var_PyObject2 = pycapsule_new(cast_to_base<llvm::NamedMDNode >::from(var_llvm_NamedMDNode), "llvm::NamedMDNode", "llvm::NamedMDNode");
    if (!var_PyObject2)
    {
        return NULL;
    }
    return var_PyObject2;
}

static
PyObject*
llvm_Module__getOrInsertFunction(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    PyObject* var_PyObject2;
    if(!PyArg_ParseTuple(args, "OOO", &var_PyObject, &var_PyObject1, &var_PyObject2))
    {
        return NULL;
    }
    llvm::Module* var_llvm_Module = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Module");
        if(!var_void)
        {
            puts("Error: llvm::Module");
            return NULL;
        }
        llvm::Module* var_llvm_Module1 = unwrap_as<llvm::Module, llvm::Module >::from(var_void);
        if(!var_llvm_Module1)
        {
            return NULL;
        }
        var_llvm_Module = var_llvm_Module1;
    }
    llvm::StringRef var_llvm_StringRef;
    int var_int = py_str_to(var_PyObject1, var_llvm_StringRef);
    if(!var_int)
    {
        return NULL;
    }
    llvm::FunctionType* var_llvm_FunctionType = NULL;
    if (var_PyObject2 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject2, "llvm::Type");
        if(!var_void1)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::FunctionType* var_llvm_FunctionType1 = unwrap_as<llvm::FunctionType, llvm::Type >::from(var_void1);
        if(!var_llvm_FunctionType1)
        {
            return NULL;
        }
        var_llvm_FunctionType = var_llvm_FunctionType1;
    }
    llvm::Constant* var_llvm_Constant = var_llvm_Module->getOrInsertFunction(var_llvm_StringRef, var_llvm_FunctionType);
    PyObject* var_PyObject3 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant), "llvm::Value", "llvm::Constant");
    if (!var_PyObject3)
    {
        return NULL;
    }
    return var_PyObject3;
}

static
PyObject*
llvm_Module__Endianness__AnyEndianness(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject = PyInt_FromLong(llvm::Module::AnyEndianness);
    return var_PyObject;
}

static
PyObject*
llvm_Module__Endianness__LittleEndian(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject1 = PyInt_FromLong(llvm::Module::LittleEndian);
    return var_PyObject1;
}

static
PyObject*
llvm_Module__Endianness__BigEndian(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject2 = PyInt_FromLong(llvm::Module::BigEndian);
    return var_PyObject2;
}

static
PyObject*
llvm_Module__PointerSize__AnyPointerSize(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject = PyInt_FromLong(llvm::Module::AnyPointerSize);
    return var_PyObject;
}

static
PyObject*
llvm_Module__PointerSize__Pointer32(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject1 = PyInt_FromLong(llvm::Module::Pointer32);
    return var_PyObject1;
}

static
PyObject*
llvm_Module__PointerSize__Pointer64(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject2 = PyInt_FromLong(llvm::Module::Pointer64);
    return var_PyObject2;
}

static
PyMethodDef meth_llvm_Module[] = {
    { "getPointerSize", (PyCFunction)llvm_Module__getPointerSize, METH_VARARGS, NULL },
    { "getModuleInlineAsm", (PyCFunction)llvm_Module__getModuleInlineAsm, METH_VARARGS, NULL },
    { "list_named_metadata", (PyCFunction)llvm_Module__list__named__metadata, METH_VARARGS, NULL },
    { "setTargetTriple", (PyCFunction)llvm_Module__setTargetTriple, METH_VARARGS, NULL },
    { "new", (PyCFunction)llvm_Module__new, METH_VARARGS, NULL },
    { "dropAllReferences", (PyCFunction)llvm_Module__dropAllReferences, METH_VARARGS, NULL },
    { "getOrInsertNamedMetadata", (PyCFunction)llvm_Module__getOrInsertNamedMetadata, METH_VARARGS, NULL },
    { "getContext", (PyCFunction)llvm_Module__getContext, METH_VARARGS, NULL },
    { "getTypeByName", (PyCFunction)llvm_Module__getTypeByName, METH_VARARGS, NULL },
    { "print_", (PyCFunction)llvm_Module__print__, METH_VARARGS, NULL },
    { "getOrInsertGlobal", (PyCFunction)llvm_Module__getOrInsertGlobal, METH_VARARGS, NULL },
    { "list_globals", (PyCFunction)llvm_Module__list__globals, METH_VARARGS, NULL },
    { "getDataLayout", (PyCFunction)llvm_Module__getDataLayout, METH_VARARGS, NULL },
    { "getNamedGlobal", (PyCFunction)llvm_Module__getNamedGlobal, METH_VARARGS, NULL },
    { "setModuleInlineAsm", (PyCFunction)llvm_Module__setModuleInlineAsm, METH_VARARGS, NULL },
    { "eraseNamedMetadata", (PyCFunction)llvm_Module__eraseNamedMetadata, METH_VARARGS, NULL },
    { "setDataLayout", (PyCFunction)llvm_Module__setDataLayout, METH_VARARGS, NULL },
    { "getFunction", (PyCFunction)llvm_Module__getFunction, METH_VARARGS, NULL },
    { "getEndianness", (PyCFunction)llvm_Module__getEndianness, METH_VARARGS, NULL },
    { "getGlobalVariable", (PyCFunction)llvm_Module__getGlobalVariable, METH_VARARGS, NULL },
    { "getTargetTriple", (PyCFunction)llvm_Module__getTargetTriple, METH_VARARGS, NULL },
    { "delete", (PyCFunction)llvm_Module__delete, METH_VARARGS, NULL },
    { "appendModuleInlineAsm", (PyCFunction)llvm_Module__appendModuleInlineAsm, METH_VARARGS, NULL },
    { "dump", (PyCFunction)llvm_Module__dump, METH_VARARGS, NULL },
    { "list_functions", (PyCFunction)llvm_Module__list__functions, METH_VARARGS, NULL },
    { "getModuleIdentifier", (PyCFunction)llvm_Module__getModuleIdentifier, METH_VARARGS, NULL },
    { "setModuleIdentifier", (PyCFunction)llvm_Module__setModuleIdentifier, METH_VARARGS, NULL },
    { "getNamedMetadata", (PyCFunction)llvm_Module__getNamedMetadata, METH_VARARGS, NULL },
    { "getOrInsertFunction", (PyCFunction)llvm_Module__getOrInsertFunction, METH_VARARGS, NULL },
    { "AnyEndianness", (PyCFunction)llvm_Module__Endianness__AnyEndianness, METH_VARARGS, NULL },
    { "LittleEndian", (PyCFunction)llvm_Module__Endianness__LittleEndian, METH_VARARGS, NULL },
    { "BigEndian", (PyCFunction)llvm_Module__Endianness__BigEndian, METH_VARARGS, NULL },
    { "AnyPointerSize", (PyCFunction)llvm_Module__PointerSize__AnyPointerSize, METH_VARARGS, NULL },
    { "Pointer32", (PyCFunction)llvm_Module__PointerSize__Pointer32, METH_VARARGS, NULL },
    { "Pointer64", (PyCFunction)llvm_Module__PointerSize__Pointer64, METH_VARARGS, NULL },
    { NULL },
};

static
SubModuleEntry submodule_llvm_Module[] = {
    { NULL }
};

static
PyMethodDef meth_llvm_LLVMContext[] = {
    { NULL },
};

static
SubModuleEntry submodule_llvm_LLVMContext[] = {
    { NULL }
};

static
PyObject*
llvm_Value__setName(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    llvm::StringRef var_llvm_StringRef;
    int var_int = py_str_to(var_PyObject1, var_llvm_StringRef);
    if(!var_int)
    {
        return NULL;
    }
    var_llvm_Value->setName(var_llvm_StringRef);
    Py_RETURN_NONE;
}

static
PyObject*
llvm_Value__print__(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    PyObject* var_PyObject2;
    if(!PyArg_ParseTuple(args, "OOO", &var_PyObject, &var_PyObject1, &var_PyObject2))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::raw_ostream");
    if(!var_void1)
    {
        puts("Error: llvm::raw_ostream");
        return NULL;
    }
    llvm::raw_ostream* var_llvm_raw__ostream = unwrap_as<llvm::raw_ostream, llvm::raw_ostream >::from(var_void1);
    if(!var_llvm_raw__ostream)
    {
        return NULL;
    }
    llvm::raw_ostream& var_llvm_raw__ostream1 = *var_llvm_raw__ostream;
    llvm::AssemblyAnnotationWriter* var_llvm_AssemblyAnnotationWriter = NULL;
    if (var_PyObject2 != Py_None)
    {
        void* var_void2 = PyCapsule_GetPointer(var_PyObject2, "llvm::AssemblyAnnotationWriter");
        if(!var_void2)
        {
            puts("Error: llvm::AssemblyAnnotationWriter");
            return NULL;
        }
        llvm::AssemblyAnnotationWriter* var_llvm_AssemblyAnnotationWriter1 = unwrap_as<llvm::AssemblyAnnotationWriter, llvm::AssemblyAnnotationWriter >::from(var_void2);
        if(!var_llvm_AssemblyAnnotationWriter1)
        {
            return NULL;
        }
        var_llvm_AssemblyAnnotationWriter = var_llvm_AssemblyAnnotationWriter1;
    }
    var_llvm_Value->print(var_llvm_raw__ostream1, var_llvm_AssemblyAnnotationWriter);
    Py_RETURN_NONE;
}

static
PyObject*
llvm_Value__isUsedInBasicBlock(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Value");
    if(!var_void1)
    {
        puts("Error: llvm::Value");
        return NULL;
    }
    llvm::BasicBlock* var_llvm_BasicBlock = unwrap_as<llvm::BasicBlock, llvm::Value >::from(var_void1);
    if(!var_llvm_BasicBlock)
    {
        return NULL;
    }
    bool var_bool = var_llvm_Value->isUsedInBasicBlock(var_llvm_BasicBlock);
    PyObject* var_PyObject2 = py_bool_from(var_bool);
    return var_PyObject2;
}

static
PyObject*
llvm_Value__replaceAllUsesWith(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    llvm::Value* var_llvm_Value2 = NULL;
    if (var_PyObject1 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Value");
        if(!var_void1)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value3 = unwrap_as<llvm::Value, llvm::Value >::from(var_void1);
        if(!var_llvm_Value3)
        {
            return NULL;
        }
        var_llvm_Value2 = var_llvm_Value3;
    }
    var_llvm_Value->replaceAllUsesWith(var_llvm_Value2);
    Py_RETURN_NONE;
}

static
PyObject*
llvm_Value__hasName(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    bool var_bool = var_llvm_Value->hasName();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Value__getName(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    llvm::StringRef var_llvm_StringRef = var_llvm_Value->getName();
    PyObject* var_PyObject1 = py_str_from(var_llvm_StringRef);
    return var_PyObject1;
}

static
PyObject*
llvm_Value__getNumUses(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    unsigned var_unsigned = var_llvm_Value->getNumUses();
    PyObject* var_PyObject1 = py_int_from_unsigned(var_unsigned);
    return var_PyObject1;
}

static
PyObject*
llvm_Value__hasNUses(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    unsigned var_unsigned;
    int var_int = py_int_to(var_PyObject1, var_unsigned);
    if(!var_int)
    {
        return NULL;
    }
    bool var_bool = var_llvm_Value->hasNUses(var_unsigned);
    PyObject* var_PyObject2 = py_bool_from(var_bool);
    return var_PyObject2;
}

static
PyObject*
llvm_Value__getType(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    llvm::Type* var_llvm_Type = var_llvm_Value->getType();
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Type >::from(var_llvm_Type), "llvm::Type", "llvm::Type");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyObject*
llvm_Value__list__use(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    PyObject* var_PyObject1 = Value_use_iterator_to_list(var_llvm_Value);
    return var_PyObject1;
}

static
PyObject*
llvm_Value__getContext(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    llvm::LLVMContext& var_llvm_LLVMContext = var_llvm_Value->getContext();
    const llvm::LLVMContext* var_const_llvm_LLVMContext = &var_llvm_LLVMContext;
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::LLVMContext >::from(var_const_llvm_LLVMContext), "llvm::LLVMContext", "llvm::LLVMContext");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyObject*
llvm_Value__dump(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    var_llvm_Value->dump();
    Py_RETURN_NONE;
}

static
PyObject*
llvm_Value__mutateType(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject1 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Type");
        if(!var_void1)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void1);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    var_llvm_Value->mutateType(var_llvm_Type);
    Py_RETURN_NONE;
}

static
PyObject*
llvm_Value__hasOneUse(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    bool var_bool = var_llvm_Value->hasOneUse();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Value__getValueID(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    unsigned var_unsigned = var_llvm_Value->getValueID();
    PyObject* var_PyObject1 = py_int_from_unsigned(var_unsigned);
    return var_PyObject1;
}

static
PyObject*
llvm_Value__ValueTy__ArgumentVal(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject = PyInt_FromLong(llvm::Value::ArgumentVal);
    return var_PyObject;
}

static
PyObject*
llvm_Value__ValueTy__BasicBlockVal(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject1 = PyInt_FromLong(llvm::Value::BasicBlockVal);
    return var_PyObject1;
}

static
PyObject*
llvm_Value__ValueTy__FunctionVal(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject2 = PyInt_FromLong(llvm::Value::FunctionVal);
    return var_PyObject2;
}

static
PyObject*
llvm_Value__ValueTy__GlobalAliasVal(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject3 = PyInt_FromLong(llvm::Value::GlobalAliasVal);
    return var_PyObject3;
}

static
PyObject*
llvm_Value__ValueTy__GlobalVariableVal(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject4 = PyInt_FromLong(llvm::Value::GlobalVariableVal);
    return var_PyObject4;
}

static
PyObject*
llvm_Value__ValueTy__UndefValueVal(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject5 = PyInt_FromLong(llvm::Value::UndefValueVal);
    return var_PyObject5;
}

static
PyObject*
llvm_Value__ValueTy__BlockAddressVal(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject6 = PyInt_FromLong(llvm::Value::BlockAddressVal);
    return var_PyObject6;
}

static
PyObject*
llvm_Value__ValueTy__ConstantExprVal(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject7 = PyInt_FromLong(llvm::Value::ConstantExprVal);
    return var_PyObject7;
}

static
PyObject*
llvm_Value__ValueTy__ConstantAggregateZeroVal(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject8 = PyInt_FromLong(llvm::Value::ConstantAggregateZeroVal);
    return var_PyObject8;
}

static
PyObject*
llvm_Value__ValueTy__ConstantDataArrayVal(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject9 = PyInt_FromLong(llvm::Value::ConstantDataArrayVal);
    return var_PyObject9;
}

static
PyObject*
llvm_Value__ValueTy__ConstantDataVectorVal(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject10 = PyInt_FromLong(llvm::Value::ConstantDataVectorVal);
    return var_PyObject10;
}

static
PyObject*
llvm_Value__ValueTy__ConstantIntVal(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject11 = PyInt_FromLong(llvm::Value::ConstantIntVal);
    return var_PyObject11;
}

static
PyObject*
llvm_Value__ValueTy__ConstantFPVal(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject12 = PyInt_FromLong(llvm::Value::ConstantFPVal);
    return var_PyObject12;
}

static
PyObject*
llvm_Value__ValueTy__ConstantArrayVal(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject13 = PyInt_FromLong(llvm::Value::ConstantArrayVal);
    return var_PyObject13;
}

static
PyObject*
llvm_Value__ValueTy__ConstantStructVal(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject14 = PyInt_FromLong(llvm::Value::ConstantStructVal);
    return var_PyObject14;
}

static
PyObject*
llvm_Value__ValueTy__ConstantVectorVal(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject15 = PyInt_FromLong(llvm::Value::ConstantVectorVal);
    return var_PyObject15;
}

static
PyObject*
llvm_Value__ValueTy__ConstantPointerNullVal(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject16 = PyInt_FromLong(llvm::Value::ConstantPointerNullVal);
    return var_PyObject16;
}

static
PyObject*
llvm_Value__ValueTy__MDNodeVal(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject17 = PyInt_FromLong(llvm::Value::MDNodeVal);
    return var_PyObject17;
}

static
PyObject*
llvm_Value__ValueTy__MDStringVal(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject18 = PyInt_FromLong(llvm::Value::MDStringVal);
    return var_PyObject18;
}

static
PyObject*
llvm_Value__ValueTy__InlineAsmVal(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject19 = PyInt_FromLong(llvm::Value::InlineAsmVal);
    return var_PyObject19;
}

static
PyObject*
llvm_Value__ValueTy__PseudoSourceValueVal(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject20 = PyInt_FromLong(llvm::Value::PseudoSourceValueVal);
    return var_PyObject20;
}

static
PyObject*
llvm_Value__ValueTy__FixedStackPseudoSourceValueVal(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject21 = PyInt_FromLong(llvm::Value::FixedStackPseudoSourceValueVal);
    return var_PyObject21;
}

static
PyObject*
llvm_Value__ValueTy__InstructionVal(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject22 = PyInt_FromLong(llvm::Value::InstructionVal);
    return var_PyObject22;
}

static
PyObject*
llvm_Value__ValueTy__ConstantFirstVal(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject23 = PyInt_FromLong(llvm::Value::ConstantFirstVal);
    return var_PyObject23;
}

static
PyObject*
llvm_Value__ValueTy__ConstantLastVal(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject24 = PyInt_FromLong(llvm::Value::ConstantLastVal);
    return var_PyObject24;
}

static
PyMethodDef meth_llvm_Value[] = {
    { "setName", (PyCFunction)llvm_Value__setName, METH_VARARGS, NULL },
    { "print_", (PyCFunction)llvm_Value__print__, METH_VARARGS, NULL },
    { "isUsedInBasicBlock", (PyCFunction)llvm_Value__isUsedInBasicBlock, METH_VARARGS, NULL },
    { "replaceAllUsesWith", (PyCFunction)llvm_Value__replaceAllUsesWith, METH_VARARGS, NULL },
    { "hasName", (PyCFunction)llvm_Value__hasName, METH_VARARGS, NULL },
    { "getName", (PyCFunction)llvm_Value__getName, METH_VARARGS, NULL },
    { "getNumUses", (PyCFunction)llvm_Value__getNumUses, METH_VARARGS, NULL },
    { "hasNUses", (PyCFunction)llvm_Value__hasNUses, METH_VARARGS, NULL },
    { "getType", (PyCFunction)llvm_Value__getType, METH_VARARGS, NULL },
    { "list_use", (PyCFunction)llvm_Value__list__use, METH_VARARGS, NULL },
    { "getContext", (PyCFunction)llvm_Value__getContext, METH_VARARGS, NULL },
    { "dump", (PyCFunction)llvm_Value__dump, METH_VARARGS, NULL },
    { "mutateType", (PyCFunction)llvm_Value__mutateType, METH_VARARGS, NULL },
    { "hasOneUse", (PyCFunction)llvm_Value__hasOneUse, METH_VARARGS, NULL },
    { "getValueID", (PyCFunction)llvm_Value__getValueID, METH_VARARGS, NULL },
    { "ArgumentVal", (PyCFunction)llvm_Value__ValueTy__ArgumentVal, METH_VARARGS, NULL },
    { "BasicBlockVal", (PyCFunction)llvm_Value__ValueTy__BasicBlockVal, METH_VARARGS, NULL },
    { "FunctionVal", (PyCFunction)llvm_Value__ValueTy__FunctionVal, METH_VARARGS, NULL },
    { "GlobalAliasVal", (PyCFunction)llvm_Value__ValueTy__GlobalAliasVal, METH_VARARGS, NULL },
    { "GlobalVariableVal", (PyCFunction)llvm_Value__ValueTy__GlobalVariableVal, METH_VARARGS, NULL },
    { "UndefValueVal", (PyCFunction)llvm_Value__ValueTy__UndefValueVal, METH_VARARGS, NULL },
    { "BlockAddressVal", (PyCFunction)llvm_Value__ValueTy__BlockAddressVal, METH_VARARGS, NULL },
    { "ConstantExprVal", (PyCFunction)llvm_Value__ValueTy__ConstantExprVal, METH_VARARGS, NULL },
    { "ConstantAggregateZeroVal", (PyCFunction)llvm_Value__ValueTy__ConstantAggregateZeroVal, METH_VARARGS, NULL },
    { "ConstantDataArrayVal", (PyCFunction)llvm_Value__ValueTy__ConstantDataArrayVal, METH_VARARGS, NULL },
    { "ConstantDataVectorVal", (PyCFunction)llvm_Value__ValueTy__ConstantDataVectorVal, METH_VARARGS, NULL },
    { "ConstantIntVal", (PyCFunction)llvm_Value__ValueTy__ConstantIntVal, METH_VARARGS, NULL },
    { "ConstantFPVal", (PyCFunction)llvm_Value__ValueTy__ConstantFPVal, METH_VARARGS, NULL },
    { "ConstantArrayVal", (PyCFunction)llvm_Value__ValueTy__ConstantArrayVal, METH_VARARGS, NULL },
    { "ConstantStructVal", (PyCFunction)llvm_Value__ValueTy__ConstantStructVal, METH_VARARGS, NULL },
    { "ConstantVectorVal", (PyCFunction)llvm_Value__ValueTy__ConstantVectorVal, METH_VARARGS, NULL },
    { "ConstantPointerNullVal", (PyCFunction)llvm_Value__ValueTy__ConstantPointerNullVal, METH_VARARGS, NULL },
    { "MDNodeVal", (PyCFunction)llvm_Value__ValueTy__MDNodeVal, METH_VARARGS, NULL },
    { "MDStringVal", (PyCFunction)llvm_Value__ValueTy__MDStringVal, METH_VARARGS, NULL },
    { "InlineAsmVal", (PyCFunction)llvm_Value__ValueTy__InlineAsmVal, METH_VARARGS, NULL },
    { "PseudoSourceValueVal", (PyCFunction)llvm_Value__ValueTy__PseudoSourceValueVal, METH_VARARGS, NULL },
    { "FixedStackPseudoSourceValueVal", (PyCFunction)llvm_Value__ValueTy__FixedStackPseudoSourceValueVal, METH_VARARGS, NULL },
    { "InstructionVal", (PyCFunction)llvm_Value__ValueTy__InstructionVal, METH_VARARGS, NULL },
    { "ConstantFirstVal", (PyCFunction)llvm_Value__ValueTy__ConstantFirstVal, METH_VARARGS, NULL },
    { "ConstantLastVal", (PyCFunction)llvm_Value__ValueTy__ConstantLastVal, METH_VARARGS, NULL },
    { NULL },
};

static
SubModuleEntry submodule_llvm_Value[] = {
    { NULL }
};

static
PyObject*
llvm_Argument__hasNoCaptureAttr(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Argument* var_llvm_Argument = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Argument* var_llvm_Argument1 = unwrap_as<llvm::Argument, llvm::Value >::from(var_void);
        if(!var_llvm_Argument1)
        {
            return NULL;
        }
        var_llvm_Argument = var_llvm_Argument1;
    }
    bool var_bool = var_llvm_Argument->hasNoCaptureAttr();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Argument__hasNoAliasAttr(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Argument* var_llvm_Argument = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Argument* var_llvm_Argument1 = unwrap_as<llvm::Argument, llvm::Value >::from(var_void);
        if(!var_llvm_Argument1)
        {
            return NULL;
        }
        var_llvm_Argument = var_llvm_Argument1;
    }
    bool var_bool = var_llvm_Argument->hasNoAliasAttr();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Argument__hasNestAttr(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Argument* var_llvm_Argument = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Argument* var_llvm_Argument1 = unwrap_as<llvm::Argument, llvm::Value >::from(var_void);
        if(!var_llvm_Argument1)
        {
            return NULL;
        }
        var_llvm_Argument = var_llvm_Argument1;
    }
    bool var_bool = var_llvm_Argument->hasNestAttr();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Argument__getArgNo(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Argument* var_llvm_Argument = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Argument* var_llvm_Argument1 = unwrap_as<llvm::Argument, llvm::Value >::from(var_void);
        if(!var_llvm_Argument1)
        {
            return NULL;
        }
        var_llvm_Argument = var_llvm_Argument1;
    }
    unsigned var_unsigned = var_llvm_Argument->getArgNo();
    PyObject* var_PyObject1 = py_int_from_unsigned(var_unsigned);
    return var_PyObject1;
}

static
PyObject*
llvm_Argument__getParamAlignment(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Argument* var_llvm_Argument = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Argument* var_llvm_Argument1 = unwrap_as<llvm::Argument, llvm::Value >::from(var_void);
        if(!var_llvm_Argument1)
        {
            return NULL;
        }
        var_llvm_Argument = var_llvm_Argument1;
    }
    unsigned var_unsigned = var_llvm_Argument->getParamAlignment();
    PyObject* var_PyObject1 = py_int_from_unsigned(var_unsigned);
    return var_PyObject1;
}

static
PyObject*
llvm_Argument__hasReturnedAttr(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Argument* var_llvm_Argument = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Argument* var_llvm_Argument1 = unwrap_as<llvm::Argument, llvm::Value >::from(var_void);
        if(!var_llvm_Argument1)
        {
            return NULL;
        }
        var_llvm_Argument = var_llvm_Argument1;
    }
    bool var_bool = var_llvm_Argument->hasReturnedAttr();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Argument__removeAttr(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::Argument* var_llvm_Argument = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Argument* var_llvm_Argument1 = unwrap_as<llvm::Argument, llvm::Value >::from(var_void);
        if(!var_llvm_Argument1)
        {
            return NULL;
        }
        var_llvm_Argument = var_llvm_Argument1;
    }
    void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::AttributeSet");
    if(!var_void1)
    {
        puts("Error: llvm::AttributeSet");
        return NULL;
    }
    llvm::AttributeSet* var_llvm_AttributeSet = unwrap_as<llvm::AttributeSet, llvm::AttributeSet >::from(var_void1);
    if(!var_llvm_AttributeSet)
    {
        return NULL;
    }
    llvm::AttributeSet& var_llvm_AttributeSet1 = *var_llvm_AttributeSet;
    var_llvm_Argument->removeAttr(var_llvm_AttributeSet1);
    Py_RETURN_NONE;
}

static
PyObject*
llvm_Argument__hasStructRetAttr(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Argument* var_llvm_Argument = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Argument* var_llvm_Argument1 = unwrap_as<llvm::Argument, llvm::Value >::from(var_void);
        if(!var_llvm_Argument1)
        {
            return NULL;
        }
        var_llvm_Argument = var_llvm_Argument1;
    }
    bool var_bool = var_llvm_Argument->hasStructRetAttr();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Argument__addAttr(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::Argument* var_llvm_Argument = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Argument* var_llvm_Argument1 = unwrap_as<llvm::Argument, llvm::Value >::from(var_void);
        if(!var_llvm_Argument1)
        {
            return NULL;
        }
        var_llvm_Argument = var_llvm_Argument1;
    }
    void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::AttributeSet");
    if(!var_void1)
    {
        puts("Error: llvm::AttributeSet");
        return NULL;
    }
    llvm::AttributeSet* var_llvm_AttributeSet = unwrap_as<llvm::AttributeSet, llvm::AttributeSet >::from(var_void1);
    if(!var_llvm_AttributeSet)
    {
        return NULL;
    }
    llvm::AttributeSet& var_llvm_AttributeSet1 = *var_llvm_AttributeSet;
    var_llvm_Argument->addAttr(var_llvm_AttributeSet1);
    Py_RETURN_NONE;
}

static
PyObject*
llvm_Argument__hasByValAttr(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Argument* var_llvm_Argument = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Argument* var_llvm_Argument1 = unwrap_as<llvm::Argument, llvm::Value >::from(var_void);
        if(!var_llvm_Argument1)
        {
            return NULL;
        }
        var_llvm_Argument = var_llvm_Argument1;
    }
    bool var_bool = var_llvm_Argument->hasByValAttr();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyMethodDef meth_llvm_Argument[] = {
    { "hasNoCaptureAttr", (PyCFunction)llvm_Argument__hasNoCaptureAttr, METH_VARARGS, NULL },
    { "hasNoAliasAttr", (PyCFunction)llvm_Argument__hasNoAliasAttr, METH_VARARGS, NULL },
    { "hasNestAttr", (PyCFunction)llvm_Argument__hasNestAttr, METH_VARARGS, NULL },
    { "getArgNo", (PyCFunction)llvm_Argument__getArgNo, METH_VARARGS, NULL },
    { "getParamAlignment", (PyCFunction)llvm_Argument__getParamAlignment, METH_VARARGS, NULL },
    { "hasReturnedAttr", (PyCFunction)llvm_Argument__hasReturnedAttr, METH_VARARGS, NULL },
    { "removeAttr", (PyCFunction)llvm_Argument__removeAttr, METH_VARARGS, NULL },
    { "hasStructRetAttr", (PyCFunction)llvm_Argument__hasStructRetAttr, METH_VARARGS, NULL },
    { "addAttr", (PyCFunction)llvm_Argument__addAttr, METH_VARARGS, NULL },
    { "hasByValAttr", (PyCFunction)llvm_Argument__hasByValAttr, METH_VARARGS, NULL },
    { NULL },
};

static
SubModuleEntry submodule_llvm_Argument[] = {
    { NULL }
};

static
PyObject*
llvm_MDNode__getFunction(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::MDNode* var_llvm_MDNode = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::MDNode* var_llvm_MDNode1 = unwrap_as<llvm::MDNode, llvm::Value >::from(var_void);
        if(!var_llvm_MDNode1)
        {
            return NULL;
        }
        var_llvm_MDNode = var_llvm_MDNode1;
    }
    const llvm::Function* var_const_llvm_Function = var_llvm_MDNode->getFunction();
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_const_llvm_Function), "llvm::Value", "llvm::Function");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyObject*
llvm_MDNode__replaceOperandWith(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    PyObject* var_PyObject2;
    if(!PyArg_ParseTuple(args, "OOO", &var_PyObject, &var_PyObject1, &var_PyObject2))
    {
        return NULL;
    }
    llvm::MDNode* var_llvm_MDNode = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::MDNode* var_llvm_MDNode1 = unwrap_as<llvm::MDNode, llvm::Value >::from(var_void);
        if(!var_llvm_MDNode1)
        {
            return NULL;
        }
        var_llvm_MDNode = var_llvm_MDNode1;
    }
    unsigned var_unsigned;
    int var_int = py_int_to(var_PyObject1, var_unsigned);
    if(!var_int)
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject2 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject2, "llvm::Value");
        if(!var_void1)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void1);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    var_llvm_MDNode->replaceOperandWith(var_unsigned, var_llvm_Value);
    Py_RETURN_NONE;
}

static
PyObject*
llvm_MDNode__isFunctionLocal(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::MDNode* var_llvm_MDNode = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::MDNode* var_llvm_MDNode1 = unwrap_as<llvm::MDNode, llvm::Value >::from(var_void);
        if(!var_llvm_MDNode1)
        {
            return NULL;
        }
        var_llvm_MDNode = var_llvm_MDNode1;
    }
    bool var_bool = var_llvm_MDNode->isFunctionLocal();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_MDNode__getNumOperands(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::MDNode* var_llvm_MDNode = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::MDNode* var_llvm_MDNode1 = unwrap_as<llvm::MDNode, llvm::Value >::from(var_void);
        if(!var_llvm_MDNode1)
        {
            return NULL;
        }
        var_llvm_MDNode = var_llvm_MDNode1;
    }
    unsigned var_unsigned = var_llvm_MDNode->getNumOperands();
    PyObject* var_PyObject1 = py_int_from_unsigned(var_unsigned);
    return var_PyObject1;
}

static
PyObject*
llvm_MDNode__getOperand(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::MDNode* var_llvm_MDNode = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::MDNode* var_llvm_MDNode1 = unwrap_as<llvm::MDNode, llvm::Value >::from(var_void);
        if(!var_llvm_MDNode1)
        {
            return NULL;
        }
        var_llvm_MDNode = var_llvm_MDNode1;
    }
    unsigned var_unsigned;
    int var_int = py_int_to(var_PyObject1, var_unsigned);
    if(!var_int)
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = var_llvm_MDNode->getOperand(var_unsigned);
    PyObject* var_PyObject2 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Value), "llvm::Value", "llvm::Value");
    if (!var_PyObject2)
    {
        return NULL;
    }
    return var_PyObject2;
}

static
PyObject*
llvm_MDNode__get(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::LLVMContext");
    if(!var_void)
    {
        puts("Error: llvm::LLVMContext");
        return NULL;
    }
    llvm::LLVMContext* var_llvm_LLVMContext = unwrap_as<llvm::LLVMContext, llvm::LLVMContext >::from(var_void);
    if(!var_llvm_LLVMContext)
    {
        return NULL;
    }
    llvm::LLVMContext& var_llvm_LLVMContext1 = *var_llvm_LLVMContext;
    PyObject* var_PyObject2 = MDNode_get(var_llvm_LLVMContext1, var_PyObject1);
    return var_PyObject2;
}

static
PyMethodDef meth_llvm_MDNode[] = {
    { "getFunction", (PyCFunction)llvm_MDNode__getFunction, METH_VARARGS, NULL },
    { "replaceOperandWith", (PyCFunction)llvm_MDNode__replaceOperandWith, METH_VARARGS, NULL },
    { "isFunctionLocal", (PyCFunction)llvm_MDNode__isFunctionLocal, METH_VARARGS, NULL },
    { "getNumOperands", (PyCFunction)llvm_MDNode__getNumOperands, METH_VARARGS, NULL },
    { "getOperand", (PyCFunction)llvm_MDNode__getOperand, METH_VARARGS, NULL },
    { "get", (PyCFunction)llvm_MDNode__get, METH_VARARGS, NULL },
    { NULL },
};

static
SubModuleEntry submodule_llvm_MDNode[] = {
    { NULL }
};

static
PyObject*
llvm_MDString__getLength(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::MDString* var_llvm_MDString = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::MDString* var_llvm_MDString1 = unwrap_as<llvm::MDString, llvm::Value >::from(var_void);
        if(!var_llvm_MDString1)
        {
            return NULL;
        }
        var_llvm_MDString = var_llvm_MDString1;
    }
    unsigned var_unsigned = var_llvm_MDString->getLength();
    PyObject* var_PyObject1 = py_int_from_unsigned(var_unsigned);
    return var_PyObject1;
}

static
PyObject*
llvm_MDString__getString(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::MDString* var_llvm_MDString = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::MDString* var_llvm_MDString1 = unwrap_as<llvm::MDString, llvm::Value >::from(var_void);
        if(!var_llvm_MDString1)
        {
            return NULL;
        }
        var_llvm_MDString = var_llvm_MDString1;
    }
    llvm::StringRef var_llvm_StringRef = var_llvm_MDString->getString();
    PyObject* var_PyObject1 = py_str_from(var_llvm_StringRef);
    return var_PyObject1;
}

static
PyObject*
llvm_MDString__get(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::LLVMContext");
    if(!var_void)
    {
        puts("Error: llvm::LLVMContext");
        return NULL;
    }
    llvm::LLVMContext* var_llvm_LLVMContext = unwrap_as<llvm::LLVMContext, llvm::LLVMContext >::from(var_void);
    if(!var_llvm_LLVMContext)
    {
        return NULL;
    }
    llvm::LLVMContext& var_llvm_LLVMContext1 = *var_llvm_LLVMContext;
    llvm::StringRef var_llvm_StringRef;
    int var_int = py_str_to(var_PyObject1, var_llvm_StringRef);
    if(!var_int)
    {
        return NULL;
    }
    llvm::MDString* var_llvm_MDString = llvm::MDString::get(var_llvm_LLVMContext1, var_llvm_StringRef);
    PyObject* var_PyObject2 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_MDString), "llvm::Value", "llvm::MDString");
    if (!var_PyObject2)
    {
        return NULL;
    }
    return var_PyObject2;
}

static
PyMethodDef meth_llvm_MDString[] = {
    { "getLength", (PyCFunction)llvm_MDString__getLength, METH_VARARGS, NULL },
    { "getString", (PyCFunction)llvm_MDString__getString, METH_VARARGS, NULL },
    { "get", (PyCFunction)llvm_MDString__get, METH_VARARGS, NULL },
    { NULL },
};

static
SubModuleEntry submodule_llvm_MDString[] = {
    { NULL }
};

static
PyObject*
llvm_User__getNumOperands(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::User* var_llvm_User = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::User* var_llvm_User1 = unwrap_as<llvm::User, llvm::Value >::from(var_void);
        if(!var_llvm_User1)
        {
            return NULL;
        }
        var_llvm_User = var_llvm_User1;
    }
    unsigned var_unsigned = var_llvm_User->getNumOperands();
    PyObject* var_PyObject1 = py_int_from_unsigned(var_unsigned);
    return var_PyObject1;
}

static
PyObject*
llvm_User__setOperand(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    PyObject* var_PyObject2;
    if(!PyArg_ParseTuple(args, "OOO", &var_PyObject, &var_PyObject1, &var_PyObject2))
    {
        return NULL;
    }
    llvm::User* var_llvm_User = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::User* var_llvm_User1 = unwrap_as<llvm::User, llvm::Value >::from(var_void);
        if(!var_llvm_User1)
        {
            return NULL;
        }
        var_llvm_User = var_llvm_User1;
    }
    unsigned var_unsigned;
    int var_int = py_int_to(var_PyObject1, var_unsigned);
    if(!var_int)
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject2 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject2, "llvm::Value");
        if(!var_void1)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void1);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    var_llvm_User->setOperand(var_unsigned, var_llvm_Value);
    Py_RETURN_NONE;
}

static
PyObject*
llvm_User__getOperand(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::User* var_llvm_User = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::User* var_llvm_User1 = unwrap_as<llvm::User, llvm::Value >::from(var_void);
        if(!var_llvm_User1)
        {
            return NULL;
        }
        var_llvm_User = var_llvm_User1;
    }
    unsigned var_unsigned;
    int var_int = py_int_to(var_PyObject1, var_unsigned);
    if(!var_int)
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = var_llvm_User->getOperand(var_unsigned);
    PyObject* var_PyObject2 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Value), "llvm::Value", "llvm::Value");
    if (!var_PyObject2)
    {
        return NULL;
    }
    return var_PyObject2;
}

static
PyMethodDef meth_llvm_User[] = {
    { "getNumOperands", (PyCFunction)llvm_User__getNumOperands, METH_VARARGS, NULL },
    { "setOperand", (PyCFunction)llvm_User__setOperand, METH_VARARGS, NULL },
    { "getOperand", (PyCFunction)llvm_User__getOperand, METH_VARARGS, NULL },
    { NULL },
};

static
SubModuleEntry submodule_llvm_User[] = {
    { NULL }
};

static
PyObject*
llvm_BasicBlock__getTerminator(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::BasicBlock* var_llvm_BasicBlock = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::BasicBlock* var_llvm_BasicBlock1 = unwrap_as<llvm::BasicBlock, llvm::Value >::from(var_void);
        if(!var_llvm_BasicBlock1)
        {
            return NULL;
        }
        var_llvm_BasicBlock = var_llvm_BasicBlock1;
    }
    llvm::TerminatorInst* var_llvm_TerminatorInst = var_llvm_BasicBlock->getTerminator();
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_TerminatorInst), "llvm::Value", "llvm::TerminatorInst");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyObject*
llvm_BasicBlock__splitBasicBlock(PyObject* self, PyObject* args)
{
    Py_ssize_t var_Py__ssize__t = PyTuple_Size(args);
    if (3 == var_Py__ssize__t)
    {
        PyObject* var_PyObject;
        PyObject* var_PyObject1;
        PyObject* var_PyObject2;
        if(!PyArg_ParseTuple(args, "OOO", &var_PyObject, &var_PyObject1, &var_PyObject2))
        {
            return NULL;
        }
        llvm::BasicBlock* var_llvm_BasicBlock = NULL;
        if (var_PyObject != Py_None)
        {
            void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
            if(!var_void)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::BasicBlock* var_llvm_BasicBlock1 = unwrap_as<llvm::BasicBlock, llvm::Value >::from(var_void);
            if(!var_llvm_BasicBlock1)
            {
                return NULL;
            }
            var_llvm_BasicBlock = var_llvm_BasicBlock1;
        }
        llvm::Instruction* var_llvm_Instruction = NULL;
        if (var_PyObject1 != Py_None)
        {
            void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Value");
            if(!var_void1)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void1);
            if(!var_llvm_Instruction1)
            {
                return NULL;
            }
            var_llvm_Instruction = var_llvm_Instruction1;
        }
        llvm::StringRef var_llvm_StringRef;
        int var_int = py_str_to(var_PyObject2, var_llvm_StringRef);
        if(!var_int)
        {
            return NULL;
        }
        llvm::BasicBlock* var_llvm_BasicBlock2 = var_llvm_BasicBlock->splitBasicBlock(var_llvm_Instruction, var_llvm_StringRef);
        PyObject* var_PyObject3 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_BasicBlock2), "llvm::Value", "llvm::BasicBlock");
        if (!var_PyObject3)
        {
            return NULL;
        }
        return var_PyObject3;
    }
    if (2 == var_Py__ssize__t)
    {
        PyObject* var_PyObject4;
        PyObject* var_PyObject5;
        if(!PyArg_ParseTuple(args, "OO", &var_PyObject4, &var_PyObject5))
        {
            return NULL;
        }
        llvm::BasicBlock* var_llvm_BasicBlock3 = NULL;
        if (var_PyObject4 != Py_None)
        {
            void* var_void2 = PyCapsule_GetPointer(var_PyObject4, "llvm::Value");
            if(!var_void2)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::BasicBlock* var_llvm_BasicBlock4 = unwrap_as<llvm::BasicBlock, llvm::Value >::from(var_void2);
            if(!var_llvm_BasicBlock4)
            {
                return NULL;
            }
            var_llvm_BasicBlock3 = var_llvm_BasicBlock4;
        }
        llvm::Instruction* var_llvm_Instruction2 = NULL;
        if (var_PyObject5 != Py_None)
        {
            void* var_void3 = PyCapsule_GetPointer(var_PyObject5, "llvm::Value");
            if(!var_void3)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::Instruction* var_llvm_Instruction3 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void3);
            if(!var_llvm_Instruction3)
            {
                return NULL;
            }
            var_llvm_Instruction2 = var_llvm_Instruction3;
        }
        llvm::BasicBlock* var_llvm_BasicBlock5 = var_llvm_BasicBlock3->splitBasicBlock(var_llvm_Instruction2);
        PyObject* var_PyObject6 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_BasicBlock5), "llvm::Value", "llvm::BasicBlock");
        if (!var_PyObject6)
        {
            return NULL;
        }
        return var_PyObject6;
    }
    PyErr_SetString(PyExc_TypeError, "Invalid number of args");
    return NULL;
}

static
PyObject*
llvm_BasicBlock__removePredecessor(PyObject* self, PyObject* args)
{
    Py_ssize_t var_Py__ssize__t = PyTuple_Size(args);
    if (3 == var_Py__ssize__t)
    {
        PyObject* var_PyObject;
        PyObject* var_PyObject1;
        PyObject* var_PyObject2;
        if(!PyArg_ParseTuple(args, "OOO", &var_PyObject, &var_PyObject1, &var_PyObject2))
        {
            return NULL;
        }
        llvm::BasicBlock* var_llvm_BasicBlock = NULL;
        if (var_PyObject != Py_None)
        {
            void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
            if(!var_void)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::BasicBlock* var_llvm_BasicBlock1 = unwrap_as<llvm::BasicBlock, llvm::Value >::from(var_void);
            if(!var_llvm_BasicBlock1)
            {
                return NULL;
            }
            var_llvm_BasicBlock = var_llvm_BasicBlock1;
        }
        llvm::BasicBlock* var_llvm_BasicBlock2 = NULL;
        if (var_PyObject1 != Py_None)
        {
            void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Value");
            if(!var_void1)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::BasicBlock* var_llvm_BasicBlock3 = unwrap_as<llvm::BasicBlock, llvm::Value >::from(var_void1);
            if(!var_llvm_BasicBlock3)
            {
                return NULL;
            }
            var_llvm_BasicBlock2 = var_llvm_BasicBlock3;
        }
        bool var_bool;
        int var_int = py_bool_to(var_PyObject2, var_bool);
        if(!var_int)
        {
            return NULL;
        }
        var_llvm_BasicBlock->removePredecessor(var_llvm_BasicBlock2, var_bool);
        Py_RETURN_NONE;
    }
    if (2 == var_Py__ssize__t)
    {
        PyObject* var_PyObject3;
        PyObject* var_PyObject4;
        if(!PyArg_ParseTuple(args, "OO", &var_PyObject3, &var_PyObject4))
        {
            return NULL;
        }
        llvm::BasicBlock* var_llvm_BasicBlock4 = NULL;
        if (var_PyObject3 != Py_None)
        {
            void* var_void2 = PyCapsule_GetPointer(var_PyObject3, "llvm::Value");
            if(!var_void2)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::BasicBlock* var_llvm_BasicBlock5 = unwrap_as<llvm::BasicBlock, llvm::Value >::from(var_void2);
            if(!var_llvm_BasicBlock5)
            {
                return NULL;
            }
            var_llvm_BasicBlock4 = var_llvm_BasicBlock5;
        }
        llvm::BasicBlock* var_llvm_BasicBlock6 = NULL;
        if (var_PyObject4 != Py_None)
        {
            void* var_void3 = PyCapsule_GetPointer(var_PyObject4, "llvm::Value");
            if(!var_void3)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::BasicBlock* var_llvm_BasicBlock7 = unwrap_as<llvm::BasicBlock, llvm::Value >::from(var_void3);
            if(!var_llvm_BasicBlock7)
            {
                return NULL;
            }
            var_llvm_BasicBlock6 = var_llvm_BasicBlock7;
        }
        var_llvm_BasicBlock4->removePredecessor(var_llvm_BasicBlock6);
        Py_RETURN_NONE;
    }
    PyErr_SetString(PyExc_TypeError, "Invalid number of args");
    return NULL;
}

static
PyObject*
llvm_BasicBlock__dropAllReferences(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::BasicBlock* var_llvm_BasicBlock = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::BasicBlock* var_llvm_BasicBlock1 = unwrap_as<llvm::BasicBlock, llvm::Value >::from(var_void);
        if(!var_llvm_BasicBlock1)
        {
            return NULL;
        }
        var_llvm_BasicBlock = var_llvm_BasicBlock1;
    }
    var_llvm_BasicBlock->dropAllReferences();
    Py_RETURN_NONE;
}

static
PyObject*
llvm_BasicBlock__isLandingPad(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::BasicBlock* var_llvm_BasicBlock = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::BasicBlock* var_llvm_BasicBlock1 = unwrap_as<llvm::BasicBlock, llvm::Value >::from(var_void);
        if(!var_llvm_BasicBlock1)
        {
            return NULL;
        }
        var_llvm_BasicBlock = var_llvm_BasicBlock1;
    }
    bool var_bool = var_llvm_BasicBlock->isLandingPad();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_BasicBlock__eraseFromParent(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::BasicBlock* var_llvm_BasicBlock = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::BasicBlock* var_llvm_BasicBlock1 = unwrap_as<llvm::BasicBlock, llvm::Value >::from(var_void);
        if(!var_llvm_BasicBlock1)
        {
            return NULL;
        }
        var_llvm_BasicBlock = var_llvm_BasicBlock1;
    }
    var_llvm_BasicBlock->eraseFromParent();
    Py_RETURN_NONE;
}

static
PyObject*
llvm_BasicBlock__getInstList(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::BasicBlock* var_llvm_BasicBlock = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::BasicBlock* var_llvm_BasicBlock1 = unwrap_as<llvm::BasicBlock, llvm::Value >::from(var_void);
        if(!var_llvm_BasicBlock1)
        {
            return NULL;
        }
        var_llvm_BasicBlock = var_llvm_BasicBlock1;
    }
    PyObject* var_PyObject1 = BasicBlock_getInstList(var_llvm_BasicBlock);
    return var_PyObject1;
}

static
PyObject*
llvm_BasicBlock__empty(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::BasicBlock* var_llvm_BasicBlock = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::BasicBlock* var_llvm_BasicBlock1 = unwrap_as<llvm::BasicBlock, llvm::Value >::from(var_void);
        if(!var_llvm_BasicBlock1)
        {
            return NULL;
        }
        var_llvm_BasicBlock = var_llvm_BasicBlock1;
    }
    bool var_bool = var_llvm_BasicBlock->empty();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_BasicBlock__Create(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    PyObject* var_PyObject2;
    PyObject* var_PyObject3;
    if(!PyArg_ParseTuple(args, "OOOO", &var_PyObject, &var_PyObject1, &var_PyObject2, &var_PyObject3))
    {
        return NULL;
    }
    void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::LLVMContext");
    if(!var_void)
    {
        puts("Error: llvm::LLVMContext");
        return NULL;
    }
    llvm::LLVMContext* var_llvm_LLVMContext = unwrap_as<llvm::LLVMContext, llvm::LLVMContext >::from(var_void);
    if(!var_llvm_LLVMContext)
    {
        return NULL;
    }
    llvm::LLVMContext& var_llvm_LLVMContext1 = *var_llvm_LLVMContext;
    llvm::StringRef var_llvm_StringRef;
    int var_int = py_str_to(var_PyObject1, var_llvm_StringRef);
    if(!var_int)
    {
        return NULL;
    }
    llvm::Function* var_llvm_Function = NULL;
    if (var_PyObject2 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject2, "llvm::Value");
        if(!var_void1)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Function* var_llvm_Function1 = unwrap_as<llvm::Function, llvm::Value >::from(var_void1);
        if(!var_llvm_Function1)
        {
            return NULL;
        }
        var_llvm_Function = var_llvm_Function1;
    }
    llvm::BasicBlock* var_llvm_BasicBlock = NULL;
    if (var_PyObject3 != Py_None)
    {
        void* var_void2 = PyCapsule_GetPointer(var_PyObject3, "llvm::Value");
        if(!var_void2)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::BasicBlock* var_llvm_BasicBlock1 = unwrap_as<llvm::BasicBlock, llvm::Value >::from(var_void2);
        if(!var_llvm_BasicBlock1)
        {
            return NULL;
        }
        var_llvm_BasicBlock = var_llvm_BasicBlock1;
    }
    llvm::BasicBlock* var_llvm_BasicBlock2 = llvm::BasicBlock::Create(var_llvm_LLVMContext1, var_llvm_StringRef, var_llvm_Function, var_llvm_BasicBlock);
    PyObject* var_PyObject4 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_BasicBlock2), "llvm::Value", "llvm::BasicBlock");
    if (!var_PyObject4)
    {
        return NULL;
    }
    return var_PyObject4;
}

static
PyObject*
llvm_BasicBlock__getParent(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::BasicBlock* var_llvm_BasicBlock = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::BasicBlock* var_llvm_BasicBlock1 = unwrap_as<llvm::BasicBlock, llvm::Value >::from(var_void);
        if(!var_llvm_BasicBlock1)
        {
            return NULL;
        }
        var_llvm_BasicBlock = var_llvm_BasicBlock1;
    }
    llvm::Function* var_llvm_Function = var_llvm_BasicBlock->getParent();
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Function), "llvm::Value", "llvm::Function");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyMethodDef meth_llvm_BasicBlock[] = {
    { "getTerminator", (PyCFunction)llvm_BasicBlock__getTerminator, METH_VARARGS, NULL },
    { "splitBasicBlock", (PyCFunction)llvm_BasicBlock__splitBasicBlock, METH_VARARGS, NULL },
    { "removePredecessor", (PyCFunction)llvm_BasicBlock__removePredecessor, METH_VARARGS, NULL },
    { "dropAllReferences", (PyCFunction)llvm_BasicBlock__dropAllReferences, METH_VARARGS, NULL },
    { "isLandingPad", (PyCFunction)llvm_BasicBlock__isLandingPad, METH_VARARGS, NULL },
    { "eraseFromParent", (PyCFunction)llvm_BasicBlock__eraseFromParent, METH_VARARGS, NULL },
    { "getInstList", (PyCFunction)llvm_BasicBlock__getInstList, METH_VARARGS, NULL },
    { "empty", (PyCFunction)llvm_BasicBlock__empty, METH_VARARGS, NULL },
    { "Create", (PyCFunction)llvm_BasicBlock__Create, METH_VARARGS, NULL },
    { "getParent", (PyCFunction)llvm_BasicBlock__getParent, METH_VARARGS, NULL },
    { NULL },
};

static
SubModuleEntry submodule_llvm_BasicBlock[] = {
    { NULL }
};

static
PyObject*
llvm_ValueSymbolTable__dump(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::ValueSymbolTable* var_llvm_ValueSymbolTable = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::ValueSymbolTable");
        if(!var_void)
        {
            puts("Error: llvm::ValueSymbolTable");
            return NULL;
        }
        llvm::ValueSymbolTable* var_llvm_ValueSymbolTable1 = unwrap_as<llvm::ValueSymbolTable, llvm::ValueSymbolTable >::from(var_void);
        if(!var_llvm_ValueSymbolTable1)
        {
            return NULL;
        }
        var_llvm_ValueSymbolTable = var_llvm_ValueSymbolTable1;
    }
    var_llvm_ValueSymbolTable->dump();
    Py_RETURN_NONE;
}

static
PyObject*
llvm_ValueSymbolTable__new(PyObject* self, PyObject* args)
{
    if(!PyArg_ParseTuple(args, ""))
    {
        return NULL;
    }
    llvm::ValueSymbolTable* var_llvm_ValueSymbolTable = new llvm::ValueSymbolTable();
    PyObject* var_PyObject = pycapsule_new(cast_to_base<llvm::ValueSymbolTable >::from(var_llvm_ValueSymbolTable), "llvm::ValueSymbolTable", "llvm::ValueSymbolTable");
    if (!var_PyObject)
    {
        return NULL;
    }
    return var_PyObject;
}

static
PyObject*
llvm_ValueSymbolTable__size(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::ValueSymbolTable* var_llvm_ValueSymbolTable = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::ValueSymbolTable");
        if(!var_void)
        {
            puts("Error: llvm::ValueSymbolTable");
            return NULL;
        }
        llvm::ValueSymbolTable* var_llvm_ValueSymbolTable1 = unwrap_as<llvm::ValueSymbolTable, llvm::ValueSymbolTable >::from(var_void);
        if(!var_llvm_ValueSymbolTable1)
        {
            return NULL;
        }
        var_llvm_ValueSymbolTable = var_llvm_ValueSymbolTable1;
    }
    unsigned var_unsigned = var_llvm_ValueSymbolTable->size();
    PyObject* var_PyObject1 = py_int_from_unsigned(var_unsigned);
    return var_PyObject1;
}

static
PyObject*
llvm_ValueSymbolTable__empty(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::ValueSymbolTable* var_llvm_ValueSymbolTable = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::ValueSymbolTable");
        if(!var_void)
        {
            puts("Error: llvm::ValueSymbolTable");
            return NULL;
        }
        llvm::ValueSymbolTable* var_llvm_ValueSymbolTable1 = unwrap_as<llvm::ValueSymbolTable, llvm::ValueSymbolTable >::from(var_void);
        if(!var_llvm_ValueSymbolTable1)
        {
            return NULL;
        }
        var_llvm_ValueSymbolTable = var_llvm_ValueSymbolTable1;
    }
    bool var_bool = var_llvm_ValueSymbolTable->empty();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_ValueSymbolTable__delete(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::ValueSymbolTable* var_llvm_ValueSymbolTable = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::ValueSymbolTable");
        if(!var_void)
        {
            puts("Error: llvm::ValueSymbolTable");
            return NULL;
        }
        llvm::ValueSymbolTable* var_llvm_ValueSymbolTable1 = unwrap_as<llvm::ValueSymbolTable, llvm::ValueSymbolTable >::from(var_void);
        if(!var_llvm_ValueSymbolTable1)
        {
            return NULL;
        }
        var_llvm_ValueSymbolTable = var_llvm_ValueSymbolTable1;
    }
    delete var_llvm_ValueSymbolTable;
    Py_RETURN_NONE;
}

static
PyObject*
llvm_ValueSymbolTable__lookup(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::ValueSymbolTable* var_llvm_ValueSymbolTable = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::ValueSymbolTable");
        if(!var_void)
        {
            puts("Error: llvm::ValueSymbolTable");
            return NULL;
        }
        llvm::ValueSymbolTable* var_llvm_ValueSymbolTable1 = unwrap_as<llvm::ValueSymbolTable, llvm::ValueSymbolTable >::from(var_void);
        if(!var_llvm_ValueSymbolTable1)
        {
            return NULL;
        }
        var_llvm_ValueSymbolTable = var_llvm_ValueSymbolTable1;
    }
    llvm::StringRef var_llvm_StringRef;
    int var_int = py_str_to(var_PyObject1, var_llvm_StringRef);
    if(!var_int)
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = var_llvm_ValueSymbolTable->lookup(var_llvm_StringRef);
    PyObject* var_PyObject2 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Value), "llvm::Value", "llvm::Value");
    if (!var_PyObject2)
    {
        return NULL;
    }
    return var_PyObject2;
}

static
PyMethodDef meth_llvm_ValueSymbolTable[] = {
    { "dump", (PyCFunction)llvm_ValueSymbolTable__dump, METH_VARARGS, NULL },
    { "new", (PyCFunction)llvm_ValueSymbolTable__new, METH_VARARGS, NULL },
    { "size", (PyCFunction)llvm_ValueSymbolTable__size, METH_VARARGS, NULL },
    { "empty", (PyCFunction)llvm_ValueSymbolTable__empty, METH_VARARGS, NULL },
    { "delete", (PyCFunction)llvm_ValueSymbolTable__delete, METH_VARARGS, NULL },
    { "lookup", (PyCFunction)llvm_ValueSymbolTable__lookup, METH_VARARGS, NULL },
    { NULL },
};

static
SubModuleEntry submodule_llvm_ValueSymbolTable[] = {
    { NULL }
};

static
PyObject*
llvm_Constant__getIntegerValue(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    PyObject* var_PyObject2 = Constant_getIntegerValue(var_llvm_Type, var_PyObject1);
    return var_PyObject2;
}

static
PyObject*
llvm_Constant__getAllOnesValue(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    llvm::Constant* var_llvm_Constant = llvm::Constant::getAllOnesValue(var_llvm_Type);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant), "llvm::Value", "llvm::Constant");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyObject*
llvm_Constant____getAggregateElement__by__const(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::Constant* var_llvm_Constant = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant1 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void);
        if(!var_llvm_Constant1)
        {
            return NULL;
        }
        var_llvm_Constant = var_llvm_Constant1;
    }
    llvm::Constant* var_llvm_Constant2 = NULL;
    if (var_PyObject1 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Value");
        if(!var_void1)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant3 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void1);
        if(!var_llvm_Constant3)
        {
            return NULL;
        }
        var_llvm_Constant2 = var_llvm_Constant3;
    }
    llvm::Constant* var_llvm_Constant4 = var_llvm_Constant->getAggregateElement(var_llvm_Constant2);
    PyObject* var_PyObject2 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant4), "llvm::Value", "llvm::Constant");
    if (!var_PyObject2)
    {
        return NULL;
    }
    return var_PyObject2;
}

static
PyObject*
llvm_Constant__isConstantUsed(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Constant* var_llvm_Constant = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant1 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void);
        if(!var_llvm_Constant1)
        {
            return NULL;
        }
        var_llvm_Constant = var_llvm_Constant1;
    }
    bool var_bool = var_llvm_Constant->isConstantUsed();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Constant__isNegativeZeroValue(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Constant* var_llvm_Constant = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant1 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void);
        if(!var_llvm_Constant1)
        {
            return NULL;
        }
        var_llvm_Constant = var_llvm_Constant1;
    }
    bool var_bool = var_llvm_Constant->isNegativeZeroValue();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Constant__isNullValue(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Constant* var_llvm_Constant = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant1 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void);
        if(!var_llvm_Constant1)
        {
            return NULL;
        }
        var_llvm_Constant = var_llvm_Constant1;
    }
    bool var_bool = var_llvm_Constant->isNullValue();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Constant__canTrap(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Constant* var_llvm_Constant = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant1 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void);
        if(!var_llvm_Constant1)
        {
            return NULL;
        }
        var_llvm_Constant = var_llvm_Constant1;
    }
    bool var_bool = var_llvm_Constant->canTrap();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Constant__getNullValue(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    llvm::Constant* var_llvm_Constant = llvm::Constant::getNullValue(var_llvm_Type);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant), "llvm::Value", "llvm::Constant");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyObject*
llvm_Constant__isAllOnesValue(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Constant* var_llvm_Constant = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant1 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void);
        if(!var_llvm_Constant1)
        {
            return NULL;
        }
        var_llvm_Constant = var_llvm_Constant1;
    }
    bool var_bool = var_llvm_Constant->isAllOnesValue();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Constant____getAggregateElement__by__int(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::Constant* var_llvm_Constant = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant1 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void);
        if(!var_llvm_Constant1)
        {
            return NULL;
        }
        var_llvm_Constant = var_llvm_Constant1;
    }
    unsigned var_unsigned;
    int var_int = py_int_to(var_PyObject1, var_unsigned);
    if(!var_int)
    {
        return NULL;
    }
    llvm::Constant* var_llvm_Constant2 = var_llvm_Constant->getAggregateElement(var_unsigned);
    PyObject* var_PyObject2 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant2), "llvm::Value", "llvm::Constant");
    if (!var_PyObject2)
    {
        return NULL;
    }
    return var_PyObject2;
}

static
PyObject*
llvm_Constant__isThreadDependent(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Constant* var_llvm_Constant = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant1 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void);
        if(!var_llvm_Constant1)
        {
            return NULL;
        }
        var_llvm_Constant = var_llvm_Constant1;
    }
    bool var_bool = var_llvm_Constant->isThreadDependent();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Constant__removeDeadConstantUsers(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Constant* var_llvm_Constant = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant1 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void);
        if(!var_llvm_Constant1)
        {
            return NULL;
        }
        var_llvm_Constant = var_llvm_Constant1;
    }
    var_llvm_Constant->removeDeadConstantUsers();
    Py_RETURN_NONE;
}

static
PyMethodDef meth_llvm_Constant[] = {
    { "getIntegerValue", (PyCFunction)llvm_Constant__getIntegerValue, METH_VARARGS, NULL },
    { "getAllOnesValue", (PyCFunction)llvm_Constant__getAllOnesValue, METH_VARARGS, NULL },
    { "_getAggregateElement_by_const", (PyCFunction)llvm_Constant____getAggregateElement__by__const, METH_VARARGS, NULL },
    { "isConstantUsed", (PyCFunction)llvm_Constant__isConstantUsed, METH_VARARGS, NULL },
    { "isNegativeZeroValue", (PyCFunction)llvm_Constant__isNegativeZeroValue, METH_VARARGS, NULL },
    { "isNullValue", (PyCFunction)llvm_Constant__isNullValue, METH_VARARGS, NULL },
    { "canTrap", (PyCFunction)llvm_Constant__canTrap, METH_VARARGS, NULL },
    { "getNullValue", (PyCFunction)llvm_Constant__getNullValue, METH_VARARGS, NULL },
    { "isAllOnesValue", (PyCFunction)llvm_Constant__isAllOnesValue, METH_VARARGS, NULL },
    { "_getAggregateElement_by_int", (PyCFunction)llvm_Constant____getAggregateElement__by__int, METH_VARARGS, NULL },
    { "isThreadDependent", (PyCFunction)llvm_Constant__isThreadDependent, METH_VARARGS, NULL },
    { "removeDeadConstantUsers", (PyCFunction)llvm_Constant__removeDeadConstantUsers, METH_VARARGS, NULL },
    { NULL },
};

static
SubModuleEntry submodule_llvm_Constant[] = {
    { NULL }
};

static
PyObject*
llvm_GlobalValue__hasSection(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::GlobalValue* var_llvm_GlobalValue = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::GlobalValue* var_llvm_GlobalValue1 = unwrap_as<llvm::GlobalValue, llvm::Value >::from(var_void);
        if(!var_llvm_GlobalValue1)
        {
            return NULL;
        }
        var_llvm_GlobalValue = var_llvm_GlobalValue1;
    }
    bool var_bool = var_llvm_GlobalValue->hasSection();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_GlobalValue__isDiscardableIfUnused(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::GlobalValue* var_llvm_GlobalValue = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::GlobalValue* var_llvm_GlobalValue1 = unwrap_as<llvm::GlobalValue, llvm::Value >::from(var_void);
        if(!var_llvm_GlobalValue1)
        {
            return NULL;
        }
        var_llvm_GlobalValue = var_llvm_GlobalValue1;
    }
    bool var_bool = var_llvm_GlobalValue->isDiscardableIfUnused();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_GlobalValue__copyAttributesFrom(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::GlobalValue* var_llvm_GlobalValue = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::GlobalValue* var_llvm_GlobalValue1 = unwrap_as<llvm::GlobalValue, llvm::Value >::from(var_void);
        if(!var_llvm_GlobalValue1)
        {
            return NULL;
        }
        var_llvm_GlobalValue = var_llvm_GlobalValue1;
    }
    llvm::GlobalValue* var_llvm_GlobalValue2 = NULL;
    if (var_PyObject1 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Value");
        if(!var_void1)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::GlobalValue* var_llvm_GlobalValue3 = unwrap_as<llvm::GlobalValue, llvm::Value >::from(var_void1);
        if(!var_llvm_GlobalValue3)
        {
            return NULL;
        }
        var_llvm_GlobalValue2 = var_llvm_GlobalValue3;
    }
    var_llvm_GlobalValue->copyAttributesFrom(var_llvm_GlobalValue2);
    Py_RETURN_NONE;
}

static
PyObject*
llvm_GlobalValue__removeFromParent(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::GlobalValue* var_llvm_GlobalValue = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::GlobalValue* var_llvm_GlobalValue1 = unwrap_as<llvm::GlobalValue, llvm::Value >::from(var_void);
        if(!var_llvm_GlobalValue1)
        {
            return NULL;
        }
        var_llvm_GlobalValue = var_llvm_GlobalValue1;
    }
    var_llvm_GlobalValue->removeFromParent();
    Py_RETURN_NONE;
}

static
PyObject*
llvm_GlobalValue__getVisibility(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::GlobalValue* var_llvm_GlobalValue = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::GlobalValue* var_llvm_GlobalValue1 = unwrap_as<llvm::GlobalValue, llvm::Value >::from(var_void);
        if(!var_llvm_GlobalValue1)
        {
            return NULL;
        }
        var_llvm_GlobalValue = var_llvm_GlobalValue1;
    }
    llvm::GlobalValue::VisibilityTypes var_llvm_GlobalValue_VisibilityTypes = var_llvm_GlobalValue->getVisibility();
    PyObject* var_PyObject1 = PyInt_FromLong(var_llvm_GlobalValue_VisibilityTypes);
    return var_PyObject1;
}

static
PyObject*
llvm_GlobalValue__isWeakForLinker(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::GlobalValue* var_llvm_GlobalValue = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::GlobalValue* var_llvm_GlobalValue1 = unwrap_as<llvm::GlobalValue, llvm::Value >::from(var_void);
        if(!var_llvm_GlobalValue1)
        {
            return NULL;
        }
        var_llvm_GlobalValue = var_llvm_GlobalValue1;
    }
    bool var_bool = var_llvm_GlobalValue->isWeakForLinker();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_GlobalValue__getLinkage(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::GlobalValue* var_llvm_GlobalValue = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::GlobalValue* var_llvm_GlobalValue1 = unwrap_as<llvm::GlobalValue, llvm::Value >::from(var_void);
        if(!var_llvm_GlobalValue1)
        {
            return NULL;
        }
        var_llvm_GlobalValue = var_llvm_GlobalValue1;
    }
    llvm::GlobalValue::LinkageTypes var_llvm_GlobalValue_LinkageTypes = var_llvm_GlobalValue->getLinkage();
    PyObject* var_PyObject1 = PyInt_FromLong(var_llvm_GlobalValue_LinkageTypes);
    return var_PyObject1;
}

static
PyObject*
llvm_GlobalValue__setLinkage(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::GlobalValue* var_llvm_GlobalValue = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::GlobalValue* var_llvm_GlobalValue1 = unwrap_as<llvm::GlobalValue, llvm::Value >::from(var_void);
        if(!var_llvm_GlobalValue1)
        {
            return NULL;
        }
        var_llvm_GlobalValue = var_llvm_GlobalValue1;
    }
    llvm::GlobalValue::LinkageTypes var_llvm_GlobalValue_LinkageTypes = (llvm::GlobalValue::LinkageTypes)PyInt_AsLong(var_PyObject1);
    var_llvm_GlobalValue->setLinkage(var_llvm_GlobalValue_LinkageTypes);
    Py_RETURN_NONE;
}

static
PyObject*
llvm_GlobalValue__setAlignment(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::GlobalValue* var_llvm_GlobalValue = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::GlobalValue* var_llvm_GlobalValue1 = unwrap_as<llvm::GlobalValue, llvm::Value >::from(var_void);
        if(!var_llvm_GlobalValue1)
        {
            return NULL;
        }
        var_llvm_GlobalValue = var_llvm_GlobalValue1;
    }
    unsigned var_unsigned;
    int var_int = py_int_to(var_PyObject1, var_unsigned);
    if(!var_int)
    {
        return NULL;
    }
    var_llvm_GlobalValue->setAlignment(var_unsigned);
    Py_RETURN_NONE;
}

static
PyObject*
llvm_GlobalValue__isDeclaration(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::GlobalValue* var_llvm_GlobalValue = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::GlobalValue* var_llvm_GlobalValue1 = unwrap_as<llvm::GlobalValue, llvm::Value >::from(var_void);
        if(!var_llvm_GlobalValue1)
        {
            return NULL;
        }
        var_llvm_GlobalValue = var_llvm_GlobalValue1;
    }
    bool var_bool = var_llvm_GlobalValue->isDeclaration();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_GlobalValue__setVisibility(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::GlobalValue* var_llvm_GlobalValue = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::GlobalValue* var_llvm_GlobalValue1 = unwrap_as<llvm::GlobalValue, llvm::Value >::from(var_void);
        if(!var_llvm_GlobalValue1)
        {
            return NULL;
        }
        var_llvm_GlobalValue = var_llvm_GlobalValue1;
    }
    llvm::GlobalValue::VisibilityTypes var_llvm_GlobalValue_VisibilityTypes = (llvm::GlobalValue::VisibilityTypes)PyInt_AsLong(var_PyObject1);
    var_llvm_GlobalValue->setVisibility(var_llvm_GlobalValue_VisibilityTypes);
    Py_RETURN_NONE;
}

static
PyObject*
llvm_GlobalValue__destroyConstant(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::GlobalValue* var_llvm_GlobalValue = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::GlobalValue* var_llvm_GlobalValue1 = unwrap_as<llvm::GlobalValue, llvm::Value >::from(var_void);
        if(!var_llvm_GlobalValue1)
        {
            return NULL;
        }
        var_llvm_GlobalValue = var_llvm_GlobalValue1;
    }
    var_llvm_GlobalValue->destroyConstant();
    Py_RETURN_NONE;
}

static
PyObject*
llvm_GlobalValue__setSection(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::GlobalValue* var_llvm_GlobalValue = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::GlobalValue* var_llvm_GlobalValue1 = unwrap_as<llvm::GlobalValue, llvm::Value >::from(var_void);
        if(!var_llvm_GlobalValue1)
        {
            return NULL;
        }
        var_llvm_GlobalValue = var_llvm_GlobalValue1;
    }
    llvm::StringRef var_llvm_StringRef;
    int var_int = py_str_to(var_PyObject1, var_llvm_StringRef);
    if(!var_int)
    {
        return NULL;
    }
    var_llvm_GlobalValue->setSection(var_llvm_StringRef);
    Py_RETURN_NONE;
}

static
PyObject*
llvm_GlobalValue__eraseFromParent(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::GlobalValue* var_llvm_GlobalValue = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::GlobalValue* var_llvm_GlobalValue1 = unwrap_as<llvm::GlobalValue, llvm::Value >::from(var_void);
        if(!var_llvm_GlobalValue1)
        {
            return NULL;
        }
        var_llvm_GlobalValue = var_llvm_GlobalValue1;
    }
    var_llvm_GlobalValue->eraseFromParent();
    Py_RETURN_NONE;
}

static
PyObject*
llvm_GlobalValue__mayBeOverridden(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::GlobalValue* var_llvm_GlobalValue = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::GlobalValue* var_llvm_GlobalValue1 = unwrap_as<llvm::GlobalValue, llvm::Value >::from(var_void);
        if(!var_llvm_GlobalValue1)
        {
            return NULL;
        }
        var_llvm_GlobalValue = var_llvm_GlobalValue1;
    }
    bool var_bool = var_llvm_GlobalValue->mayBeOverridden();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_GlobalValue__getAlignment(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::GlobalValue* var_llvm_GlobalValue = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::GlobalValue* var_llvm_GlobalValue1 = unwrap_as<llvm::GlobalValue, llvm::Value >::from(var_void);
        if(!var_llvm_GlobalValue1)
        {
            return NULL;
        }
        var_llvm_GlobalValue = var_llvm_GlobalValue1;
    }
    unsigned var_unsigned = var_llvm_GlobalValue->getAlignment();
    PyObject* var_PyObject1 = py_int_from_unsigned(var_unsigned);
    return var_PyObject1;
}

static
PyObject*
llvm_GlobalValue__getSection(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::GlobalValue* var_llvm_GlobalValue = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::GlobalValue* var_llvm_GlobalValue1 = unwrap_as<llvm::GlobalValue, llvm::Value >::from(var_void);
        if(!var_llvm_GlobalValue1)
        {
            return NULL;
        }
        var_llvm_GlobalValue = var_llvm_GlobalValue1;
    }
    const std::string var_const_std_string = var_llvm_GlobalValue->getSection();
    PyObject* var_PyObject1 = py_str_from(var_const_std_string);
    return var_PyObject1;
}

static
PyObject*
llvm_GlobalValue__getParent(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::GlobalValue* var_llvm_GlobalValue = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::GlobalValue* var_llvm_GlobalValue1 = unwrap_as<llvm::GlobalValue, llvm::Value >::from(var_void);
        if(!var_llvm_GlobalValue1)
        {
            return NULL;
        }
        var_llvm_GlobalValue = var_llvm_GlobalValue1;
    }
    llvm::Module* var_llvm_Module = var_llvm_GlobalValue->getParent();
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Module >::from(var_llvm_Module), "llvm::Module", "llvm::Module");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyObject*
llvm_GlobalValue__VisibilityTypes__DefaultVisibility(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject = PyInt_FromLong(llvm::GlobalValue::DefaultVisibility);
    return var_PyObject;
}

static
PyObject*
llvm_GlobalValue__VisibilityTypes__HiddenVisibility(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject1 = PyInt_FromLong(llvm::GlobalValue::HiddenVisibility);
    return var_PyObject1;
}

static
PyObject*
llvm_GlobalValue__VisibilityTypes__ProtectedVisibility(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject2 = PyInt_FromLong(llvm::GlobalValue::ProtectedVisibility);
    return var_PyObject2;
}

static
PyObject*
llvm_GlobalValue__LinkageTypes__ExternalLinkage(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject = PyInt_FromLong(llvm::GlobalValue::ExternalLinkage);
    return var_PyObject;
}

static
PyObject*
llvm_GlobalValue__LinkageTypes__AvailableExternallyLinkage(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject1 = PyInt_FromLong(llvm::GlobalValue::AvailableExternallyLinkage);
    return var_PyObject1;
}

static
PyObject*
llvm_GlobalValue__LinkageTypes__LinkOnceAnyLinkage(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject2 = PyInt_FromLong(llvm::GlobalValue::LinkOnceAnyLinkage);
    return var_PyObject2;
}

static
PyObject*
llvm_GlobalValue__LinkageTypes__LinkOnceODRLinkage(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject3 = PyInt_FromLong(llvm::GlobalValue::LinkOnceODRLinkage);
    return var_PyObject3;
}

static
PyObject*
llvm_GlobalValue__LinkageTypes__LinkOnceODRAutoHideLinkage(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject4 = PyInt_FromLong(llvm::GlobalValue::LinkOnceODRAutoHideLinkage);
    return var_PyObject4;
}

static
PyObject*
llvm_GlobalValue__LinkageTypes__WeakAnyLinkage(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject5 = PyInt_FromLong(llvm::GlobalValue::WeakAnyLinkage);
    return var_PyObject5;
}

static
PyObject*
llvm_GlobalValue__LinkageTypes__WeakODRLinkage(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject6 = PyInt_FromLong(llvm::GlobalValue::WeakODRLinkage);
    return var_PyObject6;
}

static
PyObject*
llvm_GlobalValue__LinkageTypes__AppendingLinkage(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject7 = PyInt_FromLong(llvm::GlobalValue::AppendingLinkage);
    return var_PyObject7;
}

static
PyObject*
llvm_GlobalValue__LinkageTypes__InternalLinkage(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject8 = PyInt_FromLong(llvm::GlobalValue::InternalLinkage);
    return var_PyObject8;
}

static
PyObject*
llvm_GlobalValue__LinkageTypes__PrivateLinkage(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject9 = PyInt_FromLong(llvm::GlobalValue::PrivateLinkage);
    return var_PyObject9;
}

static
PyObject*
llvm_GlobalValue__LinkageTypes__LinkerPrivateLinkage(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject10 = PyInt_FromLong(llvm::GlobalValue::LinkerPrivateLinkage);
    return var_PyObject10;
}

static
PyObject*
llvm_GlobalValue__LinkageTypes__LinkerPrivateWeakLinkage(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject11 = PyInt_FromLong(llvm::GlobalValue::LinkerPrivateWeakLinkage);
    return var_PyObject11;
}

static
PyObject*
llvm_GlobalValue__LinkageTypes__DLLImportLinkage(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject12 = PyInt_FromLong(llvm::GlobalValue::DLLImportLinkage);
    return var_PyObject12;
}

static
PyObject*
llvm_GlobalValue__LinkageTypes__DLLExportLinkage(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject13 = PyInt_FromLong(llvm::GlobalValue::DLLExportLinkage);
    return var_PyObject13;
}

static
PyObject*
llvm_GlobalValue__LinkageTypes__ExternalWeakLinkage(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject14 = PyInt_FromLong(llvm::GlobalValue::ExternalWeakLinkage);
    return var_PyObject14;
}

static
PyObject*
llvm_GlobalValue__LinkageTypes__CommonLinkage(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject15 = PyInt_FromLong(llvm::GlobalValue::CommonLinkage);
    return var_PyObject15;
}

static
PyMethodDef meth_llvm_GlobalValue[] = {
    { "hasSection", (PyCFunction)llvm_GlobalValue__hasSection, METH_VARARGS, NULL },
    { "isDiscardableIfUnused", (PyCFunction)llvm_GlobalValue__isDiscardableIfUnused, METH_VARARGS, NULL },
    { "copyAttributesFrom", (PyCFunction)llvm_GlobalValue__copyAttributesFrom, METH_VARARGS, NULL },
    { "removeFromParent", (PyCFunction)llvm_GlobalValue__removeFromParent, METH_VARARGS, NULL },
    { "getVisibility", (PyCFunction)llvm_GlobalValue__getVisibility, METH_VARARGS, NULL },
    { "isWeakForLinker", (PyCFunction)llvm_GlobalValue__isWeakForLinker, METH_VARARGS, NULL },
    { "getLinkage", (PyCFunction)llvm_GlobalValue__getLinkage, METH_VARARGS, NULL },
    { "setLinkage", (PyCFunction)llvm_GlobalValue__setLinkage, METH_VARARGS, NULL },
    { "setAlignment", (PyCFunction)llvm_GlobalValue__setAlignment, METH_VARARGS, NULL },
    { "isDeclaration", (PyCFunction)llvm_GlobalValue__isDeclaration, METH_VARARGS, NULL },
    { "setVisibility", (PyCFunction)llvm_GlobalValue__setVisibility, METH_VARARGS, NULL },
    { "destroyConstant", (PyCFunction)llvm_GlobalValue__destroyConstant, METH_VARARGS, NULL },
    { "setSection", (PyCFunction)llvm_GlobalValue__setSection, METH_VARARGS, NULL },
    { "eraseFromParent", (PyCFunction)llvm_GlobalValue__eraseFromParent, METH_VARARGS, NULL },
    { "mayBeOverridden", (PyCFunction)llvm_GlobalValue__mayBeOverridden, METH_VARARGS, NULL },
    { "getAlignment", (PyCFunction)llvm_GlobalValue__getAlignment, METH_VARARGS, NULL },
    { "getSection", (PyCFunction)llvm_GlobalValue__getSection, METH_VARARGS, NULL },
    { "getParent", (PyCFunction)llvm_GlobalValue__getParent, METH_VARARGS, NULL },
    { "DefaultVisibility", (PyCFunction)llvm_GlobalValue__VisibilityTypes__DefaultVisibility, METH_VARARGS, NULL },
    { "HiddenVisibility", (PyCFunction)llvm_GlobalValue__VisibilityTypes__HiddenVisibility, METH_VARARGS, NULL },
    { "ProtectedVisibility", (PyCFunction)llvm_GlobalValue__VisibilityTypes__ProtectedVisibility, METH_VARARGS, NULL },
    { "ExternalLinkage", (PyCFunction)llvm_GlobalValue__LinkageTypes__ExternalLinkage, METH_VARARGS, NULL },
    { "AvailableExternallyLinkage", (PyCFunction)llvm_GlobalValue__LinkageTypes__AvailableExternallyLinkage, METH_VARARGS, NULL },
    { "LinkOnceAnyLinkage", (PyCFunction)llvm_GlobalValue__LinkageTypes__LinkOnceAnyLinkage, METH_VARARGS, NULL },
    { "LinkOnceODRLinkage", (PyCFunction)llvm_GlobalValue__LinkageTypes__LinkOnceODRLinkage, METH_VARARGS, NULL },
    { "LinkOnceODRAutoHideLinkage", (PyCFunction)llvm_GlobalValue__LinkageTypes__LinkOnceODRAutoHideLinkage, METH_VARARGS, NULL },
    { "WeakAnyLinkage", (PyCFunction)llvm_GlobalValue__LinkageTypes__WeakAnyLinkage, METH_VARARGS, NULL },
    { "WeakODRLinkage", (PyCFunction)llvm_GlobalValue__LinkageTypes__WeakODRLinkage, METH_VARARGS, NULL },
    { "AppendingLinkage", (PyCFunction)llvm_GlobalValue__LinkageTypes__AppendingLinkage, METH_VARARGS, NULL },
    { "InternalLinkage", (PyCFunction)llvm_GlobalValue__LinkageTypes__InternalLinkage, METH_VARARGS, NULL },
    { "PrivateLinkage", (PyCFunction)llvm_GlobalValue__LinkageTypes__PrivateLinkage, METH_VARARGS, NULL },
    { "LinkerPrivateLinkage", (PyCFunction)llvm_GlobalValue__LinkageTypes__LinkerPrivateLinkage, METH_VARARGS, NULL },
    { "LinkerPrivateWeakLinkage", (PyCFunction)llvm_GlobalValue__LinkageTypes__LinkerPrivateWeakLinkage, METH_VARARGS, NULL },
    { "DLLImportLinkage", (PyCFunction)llvm_GlobalValue__LinkageTypes__DLLImportLinkage, METH_VARARGS, NULL },
    { "DLLExportLinkage", (PyCFunction)llvm_GlobalValue__LinkageTypes__DLLExportLinkage, METH_VARARGS, NULL },
    { "ExternalWeakLinkage", (PyCFunction)llvm_GlobalValue__LinkageTypes__ExternalWeakLinkage, METH_VARARGS, NULL },
    { "CommonLinkage", (PyCFunction)llvm_GlobalValue__LinkageTypes__CommonLinkage, METH_VARARGS, NULL },
    { NULL },
};

static
SubModuleEntry submodule_llvm_GlobalValue[] = {
    { NULL }
};

static
PyObject*
llvm_Function__getFunctionType(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Function* var_llvm_Function = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Function* var_llvm_Function1 = unwrap_as<llvm::Function, llvm::Value >::from(var_void);
        if(!var_llvm_Function1)
        {
            return NULL;
        }
        var_llvm_Function = var_llvm_Function1;
    }
    llvm::FunctionType* var_llvm_FunctionType = var_llvm_Function->getFunctionType();
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Type >::from(var_llvm_FunctionType), "llvm::Type", "llvm::FunctionType");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyObject*
llvm_Function__getCallingConv(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Function* var_llvm_Function = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Function* var_llvm_Function1 = unwrap_as<llvm::Function, llvm::Value >::from(var_void);
        if(!var_llvm_Function1)
        {
            return NULL;
        }
        var_llvm_Function = var_llvm_Function1;
    }
    llvm::CallingConv::ID var_llvm_CallingConv_ID = var_llvm_Function->getCallingConv();
    PyObject* var_PyObject1 = PyInt_FromLong(var_llvm_CallingConv_ID);
    return var_PyObject1;
}

static
PyObject*
llvm_Function__deleteBody(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Function* var_llvm_Function = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Function* var_llvm_Function1 = unwrap_as<llvm::Function, llvm::Value >::from(var_void);
        if(!var_llvm_Function1)
        {
            return NULL;
        }
        var_llvm_Function = var_llvm_Function1;
    }
    var_llvm_Function->deleteBody();
    Py_RETURN_NONE;
}

static
PyObject*
llvm_Function__setDoesNotAccessMemory(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Function* var_llvm_Function = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Function* var_llvm_Function1 = unwrap_as<llvm::Function, llvm::Value >::from(var_void);
        if(!var_llvm_Function1)
        {
            return NULL;
        }
        var_llvm_Function = var_llvm_Function1;
    }
    var_llvm_Function->setDoesNotAccessMemory();
    Py_RETURN_NONE;
}

static
PyObject*
llvm_Function__getBasicBlockList(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Function* var_llvm_Function = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Function* var_llvm_Function1 = unwrap_as<llvm::Function, llvm::Value >::from(var_void);
        if(!var_llvm_Function1)
        {
            return NULL;
        }
        var_llvm_Function = var_llvm_Function1;
    }
    PyObject* var_PyObject1 = Function_getBasicBlockList(var_llvm_Function);
    return var_PyObject1;
}

static
PyObject*
llvm_Function__getGC(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Function* var_llvm_Function = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Function* var_llvm_Function1 = unwrap_as<llvm::Function, llvm::Value >::from(var_void);
        if(!var_llvm_Function1)
        {
            return NULL;
        }
        var_llvm_Function = var_llvm_Function1;
    }
    const char* var_const_char = var_llvm_Function->getGC();
    PyObject* var_PyObject1 = py_str_from(var_const_char);
    return var_PyObject1;
}

static
PyObject*
llvm_Function__viewCFG(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Function* var_llvm_Function = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Function* var_llvm_Function1 = unwrap_as<llvm::Function, llvm::Value >::from(var_void);
        if(!var_llvm_Function1)
        {
            return NULL;
        }
        var_llvm_Function = var_llvm_Function1;
    }
    var_llvm_Function->viewCFG();
    Py_RETURN_NONE;
}

static
PyObject*
llvm_Function__addFnAttr(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::Function* var_llvm_Function = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Function* var_llvm_Function1 = unwrap_as<llvm::Function, llvm::Value >::from(var_void);
        if(!var_llvm_Function1)
        {
            return NULL;
        }
        var_llvm_Function = var_llvm_Function1;
    }
    llvm::Attribute::AttrKind var_llvm_Attribute_AttrKind = (llvm::Attribute::AttrKind)PyInt_AsLong(var_PyObject1);
    var_llvm_Function->addFnAttr(var_llvm_Attribute_AttrKind);
    Py_RETURN_NONE;
}

static
PyObject*
llvm_Function__doesNotThrow(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Function* var_llvm_Function = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Function* var_llvm_Function1 = unwrap_as<llvm::Function, llvm::Value >::from(var_void);
        if(!var_llvm_Function1)
        {
            return NULL;
        }
        var_llvm_Function = var_llvm_Function1;
    }
    bool var_bool = var_llvm_Function->doesNotThrow();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Function__addAttributes(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    PyObject* var_PyObject2;
    if(!PyArg_ParseTuple(args, "OOO", &var_PyObject, &var_PyObject1, &var_PyObject2))
    {
        return NULL;
    }
    llvm::Function* var_llvm_Function = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Function* var_llvm_Function1 = unwrap_as<llvm::Function, llvm::Value >::from(var_void);
        if(!var_llvm_Function1)
        {
            return NULL;
        }
        var_llvm_Function = var_llvm_Function1;
    }
    unsigned var_unsigned;
    int var_int = py_int_to(var_PyObject1, var_unsigned);
    if(!var_int)
    {
        return NULL;
    }
    void* var_void1 = PyCapsule_GetPointer(var_PyObject2, "llvm::AttributeSet");
    if(!var_void1)
    {
        puts("Error: llvm::AttributeSet");
        return NULL;
    }
    llvm::AttributeSet* var_llvm_AttributeSet = unwrap_as<llvm::AttributeSet, llvm::AttributeSet >::from(var_void1);
    if(!var_llvm_AttributeSet)
    {
        return NULL;
    }
    llvm::AttributeSet& var_llvm_AttributeSet1 = *var_llvm_AttributeSet;
    var_llvm_Function->addAttributes(var_unsigned, var_llvm_AttributeSet1);
    Py_RETURN_NONE;
}

static
PyObject*
llvm_Function__getContext(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Function* var_llvm_Function = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Function* var_llvm_Function1 = unwrap_as<llvm::Function, llvm::Value >::from(var_void);
        if(!var_llvm_Function1)
        {
            return NULL;
        }
        var_llvm_Function = var_llvm_Function1;
    }
    llvm::LLVMContext& var_llvm_LLVMContext = var_llvm_Function->getContext();
    const llvm::LLVMContext* var_const_llvm_LLVMContext = &var_llvm_LLVMContext;
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::LLVMContext >::from(var_const_llvm_LLVMContext), "llvm::LLVMContext", "llvm::LLVMContext");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyObject*
llvm_Function__getArgumentList(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Function* var_llvm_Function = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Function* var_llvm_Function1 = unwrap_as<llvm::Function, llvm::Value >::from(var_void);
        if(!var_llvm_Function1)
        {
            return NULL;
        }
        var_llvm_Function = var_llvm_Function1;
    }
    PyObject* var_PyObject1 = Function_getArgumentList(var_llvm_Function);
    return var_PyObject1;
}

static
PyObject*
llvm_Function__setDoesNotReturn(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Function* var_llvm_Function = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Function* var_llvm_Function1 = unwrap_as<llvm::Function, llvm::Value >::from(var_void);
        if(!var_llvm_Function1)
        {
            return NULL;
        }
        var_llvm_Function = var_llvm_Function1;
    }
    var_llvm_Function->setDoesNotReturn();
    Py_RETURN_NONE;
}

static
PyObject*
llvm_Function__setOnlyReadsMemory(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Function* var_llvm_Function = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Function* var_llvm_Function1 = unwrap_as<llvm::Function, llvm::Value >::from(var_void);
        if(!var_llvm_Function1)
        {
            return NULL;
        }
        var_llvm_Function = var_llvm_Function1;
    }
    var_llvm_Function->setOnlyReadsMemory();
    Py_RETURN_NONE;
}

static
PyObject*
llvm_Function__eraseFromParent(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Function* var_llvm_Function = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Function* var_llvm_Function1 = unwrap_as<llvm::Function, llvm::Value >::from(var_void);
        if(!var_llvm_Function1)
        {
            return NULL;
        }
        var_llvm_Function = var_llvm_Function1;
    }
    var_llvm_Function->eraseFromParent();
    Py_RETURN_NONE;
}

static
PyObject*
llvm_Function__doesNotReturn(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Function* var_llvm_Function = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Function* var_llvm_Function1 = unwrap_as<llvm::Function, llvm::Value >::from(var_void);
        if(!var_llvm_Function1)
        {
            return NULL;
        }
        var_llvm_Function = var_llvm_Function1;
    }
    bool var_bool = var_llvm_Function->doesNotReturn();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Function__setGC(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::Function* var_llvm_Function = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Function* var_llvm_Function1 = unwrap_as<llvm::Function, llvm::Value >::from(var_void);
        if(!var_llvm_Function1)
        {
            return NULL;
        }
        var_llvm_Function = var_llvm_Function1;
    }
    const char* var_const_char;
    int var_int = py_str_to(var_PyObject1, var_const_char);
    if(!var_int)
    {
        return NULL;
    }
    var_llvm_Function->setGC(var_const_char);
    Py_RETURN_NONE;
}

static
PyObject*
llvm_Function__Create(PyObject* self, PyObject* args)
{
    Py_ssize_t var_Py__ssize__t = PyTuple_Size(args);
    if (4 == var_Py__ssize__t)
    {
        PyObject* var_PyObject;
        PyObject* var_PyObject1;
        PyObject* var_PyObject2;
        PyObject* var_PyObject3;
        if(!PyArg_ParseTuple(args, "OOOO", &var_PyObject, &var_PyObject1, &var_PyObject2, &var_PyObject3))
        {
            return NULL;
        }
        llvm::FunctionType* var_llvm_FunctionType = NULL;
        if (var_PyObject != Py_None)
        {
            void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
            if(!var_void)
            {
                puts("Error: llvm::Type");
                return NULL;
            }
            llvm::FunctionType* var_llvm_FunctionType1 = unwrap_as<llvm::FunctionType, llvm::Type >::from(var_void);
            if(!var_llvm_FunctionType1)
            {
                return NULL;
            }
            var_llvm_FunctionType = var_llvm_FunctionType1;
        }
        llvm::GlobalValue::LinkageTypes var_llvm_GlobalValue_LinkageTypes = (llvm::GlobalValue::LinkageTypes)PyInt_AsLong(var_PyObject1);
        const char* var_const_char;
        int var_int = py_str_to(var_PyObject2, var_const_char);
        if(!var_int)
        {
            return NULL;
        }
        llvm::Module* var_llvm_Module = NULL;
        if (var_PyObject3 != Py_None)
        {
            void* var_void1 = PyCapsule_GetPointer(var_PyObject3, "llvm::Module");
            if(!var_void1)
            {
                puts("Error: llvm::Module");
                return NULL;
            }
            llvm::Module* var_llvm_Module1 = unwrap_as<llvm::Module, llvm::Module >::from(var_void1);
            if(!var_llvm_Module1)
            {
                return NULL;
            }
            var_llvm_Module = var_llvm_Module1;
        }
        llvm::Function* var_llvm_Function = llvm::Function::Create(var_llvm_FunctionType, var_llvm_GlobalValue_LinkageTypes, var_const_char, var_llvm_Module);
        PyObject* var_PyObject4 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Function), "llvm::Value", "llvm::Function");
        if (!var_PyObject4)
        {
            return NULL;
        }
        return var_PyObject4;
    }
    if (2 == var_Py__ssize__t)
    {
        PyObject* var_PyObject5;
        PyObject* var_PyObject6;
        if(!PyArg_ParseTuple(args, "OO", &var_PyObject5, &var_PyObject6))
        {
            return NULL;
        }
        llvm::FunctionType* var_llvm_FunctionType2 = NULL;
        if (var_PyObject5 != Py_None)
        {
            void* var_void2 = PyCapsule_GetPointer(var_PyObject5, "llvm::Type");
            if(!var_void2)
            {
                puts("Error: llvm::Type");
                return NULL;
            }
            llvm::FunctionType* var_llvm_FunctionType3 = unwrap_as<llvm::FunctionType, llvm::Type >::from(var_void2);
            if(!var_llvm_FunctionType3)
            {
                return NULL;
            }
            var_llvm_FunctionType2 = var_llvm_FunctionType3;
        }
        llvm::GlobalValue::LinkageTypes var_llvm_GlobalValue_LinkageTypes1 = (llvm::GlobalValue::LinkageTypes)PyInt_AsLong(var_PyObject6);
        llvm::Function* var_llvm_Function1 = llvm::Function::Create(var_llvm_FunctionType2, var_llvm_GlobalValue_LinkageTypes1);
        PyObject* var_PyObject7 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Function1), "llvm::Value", "llvm::Function");
        if (!var_PyObject7)
        {
            return NULL;
        }
        return var_PyObject7;
    }
    if (3 == var_Py__ssize__t)
    {
        PyObject* var_PyObject8;
        PyObject* var_PyObject9;
        PyObject* var_PyObject10;
        if(!PyArg_ParseTuple(args, "OOO", &var_PyObject8, &var_PyObject9, &var_PyObject10))
        {
            return NULL;
        }
        llvm::FunctionType* var_llvm_FunctionType4 = NULL;
        if (var_PyObject8 != Py_None)
        {
            void* var_void3 = PyCapsule_GetPointer(var_PyObject8, "llvm::Type");
            if(!var_void3)
            {
                puts("Error: llvm::Type");
                return NULL;
            }
            llvm::FunctionType* var_llvm_FunctionType5 = unwrap_as<llvm::FunctionType, llvm::Type >::from(var_void3);
            if(!var_llvm_FunctionType5)
            {
                return NULL;
            }
            var_llvm_FunctionType4 = var_llvm_FunctionType5;
        }
        llvm::GlobalValue::LinkageTypes var_llvm_GlobalValue_LinkageTypes2 = (llvm::GlobalValue::LinkageTypes)PyInt_AsLong(var_PyObject9);
        const char* var_const_char1;
        int var_int1 = py_str_to(var_PyObject10, var_const_char1);
        if(!var_int1)
        {
            return NULL;
        }
        llvm::Function* var_llvm_Function2 = llvm::Function::Create(var_llvm_FunctionType4, var_llvm_GlobalValue_LinkageTypes2, var_const_char1);
        PyObject* var_PyObject11 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Function2), "llvm::Value", "llvm::Function");
        if (!var_PyObject11)
        {
            return NULL;
        }
        return var_PyObject11;
    }
    PyErr_SetString(PyExc_TypeError, "Invalid number of args");
    return NULL;
}

static
PyObject*
llvm_Function__hasGC(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Function* var_llvm_Function = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Function* var_llvm_Function1 = unwrap_as<llvm::Function, llvm::Value >::from(var_void);
        if(!var_llvm_Function1)
        {
            return NULL;
        }
        var_llvm_Function = var_llvm_Function1;
    }
    bool var_bool = var_llvm_Function->hasGC();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Function__doesNotAccessMemory(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Function* var_llvm_Function = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Function* var_llvm_Function1 = unwrap_as<llvm::Function, llvm::Value >::from(var_void);
        if(!var_llvm_Function1)
        {
            return NULL;
        }
        var_llvm_Function = var_llvm_Function1;
    }
    bool var_bool = var_llvm_Function->doesNotAccessMemory();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Function__getIntrinsicID(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Function* var_llvm_Function = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Function* var_llvm_Function1 = unwrap_as<llvm::Function, llvm::Value >::from(var_void);
        if(!var_llvm_Function1)
        {
            return NULL;
        }
        var_llvm_Function = var_llvm_Function1;
    }
    unsigned var_unsigned = var_llvm_Function->getIntrinsicID();
    PyObject* var_PyObject1 = py_int_from_unsigned(var_unsigned);
    return var_PyObject1;
}

static
PyObject*
llvm_Function__onlyReadsMemory(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Function* var_llvm_Function = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Function* var_llvm_Function1 = unwrap_as<llvm::Function, llvm::Value >::from(var_void);
        if(!var_llvm_Function1)
        {
            return NULL;
        }
        var_llvm_Function = var_llvm_Function1;
    }
    bool var_bool = var_llvm_Function->onlyReadsMemory();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Function__getEntryBlock(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Function* var_llvm_Function = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Function* var_llvm_Function1 = unwrap_as<llvm::Function, llvm::Value >::from(var_void);
        if(!var_llvm_Function1)
        {
            return NULL;
        }
        var_llvm_Function = var_llvm_Function1;
    }
    llvm::BasicBlock& var_llvm_BasicBlock = var_llvm_Function->getEntryBlock();
    const llvm::BasicBlock* var_const_llvm_BasicBlock = &var_llvm_BasicBlock;
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_const_llvm_BasicBlock), "llvm::Value", "llvm::BasicBlock");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyObject*
llvm_Function__getValueSymbolTable(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Function* var_llvm_Function = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Function* var_llvm_Function1 = unwrap_as<llvm::Function, llvm::Value >::from(var_void);
        if(!var_llvm_Function1)
        {
            return NULL;
        }
        var_llvm_Function = var_llvm_Function1;
    }
    llvm::ValueSymbolTable& var_llvm_ValueSymbolTable = var_llvm_Function->getValueSymbolTable();
    const llvm::ValueSymbolTable* var_const_llvm_ValueSymbolTable = &var_llvm_ValueSymbolTable;
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::ValueSymbolTable >::from(var_const_llvm_ValueSymbolTable), "llvm::ValueSymbolTable", "llvm::ValueSymbolTable");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyObject*
llvm_Function__copyAttributesFrom(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::Function* var_llvm_Function = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Function* var_llvm_Function1 = unwrap_as<llvm::Function, llvm::Value >::from(var_void);
        if(!var_llvm_Function1)
        {
            return NULL;
        }
        var_llvm_Function = var_llvm_Function1;
    }
    llvm::GlobalValue* var_llvm_GlobalValue = NULL;
    if (var_PyObject1 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Value");
        if(!var_void1)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::GlobalValue* var_llvm_GlobalValue1 = unwrap_as<llvm::GlobalValue, llvm::Value >::from(var_void1);
        if(!var_llvm_GlobalValue1)
        {
            return NULL;
        }
        var_llvm_GlobalValue = var_llvm_GlobalValue1;
    }
    var_llvm_Function->copyAttributesFrom(var_llvm_GlobalValue);
    Py_RETURN_NONE;
}

static
PyObject*
llvm_Function__isIntrinsic(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Function* var_llvm_Function = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Function* var_llvm_Function1 = unwrap_as<llvm::Function, llvm::Value >::from(var_void);
        if(!var_llvm_Function1)
        {
            return NULL;
        }
        var_llvm_Function = var_llvm_Function1;
    }
    bool var_bool = var_llvm_Function->isIntrinsic();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Function__setCallingConv(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::Function* var_llvm_Function = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Function* var_llvm_Function1 = unwrap_as<llvm::Function, llvm::Value >::from(var_void);
        if(!var_llvm_Function1)
        {
            return NULL;
        }
        var_llvm_Function = var_llvm_Function1;
    }
    llvm::CallingConv::ID var_llvm_CallingConv_ID = (llvm::CallingConv::ID)PyInt_AsLong(var_PyObject1);
    var_llvm_Function->setCallingConv(var_llvm_CallingConv_ID);
    Py_RETURN_NONE;
}

static
PyObject*
llvm_Function__setDoesNotThrow(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Function* var_llvm_Function = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Function* var_llvm_Function1 = unwrap_as<llvm::Function, llvm::Value >::from(var_void);
        if(!var_llvm_Function1)
        {
            return NULL;
        }
        var_llvm_Function = var_llvm_Function1;
    }
    var_llvm_Function->setDoesNotThrow();
    Py_RETURN_NONE;
}

static
PyObject*
llvm_Function__isVarArg(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Function* var_llvm_Function = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Function* var_llvm_Function1 = unwrap_as<llvm::Function, llvm::Value >::from(var_void);
        if(!var_llvm_Function1)
        {
            return NULL;
        }
        var_llvm_Function = var_llvm_Function1;
    }
    bool var_bool = var_llvm_Function->isVarArg();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Function__viewCFGOnly(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Function* var_llvm_Function = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Function* var_llvm_Function1 = unwrap_as<llvm::Function, llvm::Value >::from(var_void);
        if(!var_llvm_Function1)
        {
            return NULL;
        }
        var_llvm_Function = var_llvm_Function1;
    }
    var_llvm_Function->viewCFGOnly();
    Py_RETURN_NONE;
}

static
PyObject*
llvm_Function__getReturnType(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Function* var_llvm_Function = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Function* var_llvm_Function1 = unwrap_as<llvm::Function, llvm::Value >::from(var_void);
        if(!var_llvm_Function1)
        {
            return NULL;
        }
        var_llvm_Function = var_llvm_Function1;
    }
    llvm::Type* var_llvm_Type = var_llvm_Function->getReturnType();
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Type >::from(var_llvm_Type), "llvm::Type", "llvm::Type");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyObject*
llvm_Function__removeAttributes(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    PyObject* var_PyObject2;
    if(!PyArg_ParseTuple(args, "OOO", &var_PyObject, &var_PyObject1, &var_PyObject2))
    {
        return NULL;
    }
    llvm::Function* var_llvm_Function = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Function* var_llvm_Function1 = unwrap_as<llvm::Function, llvm::Value >::from(var_void);
        if(!var_llvm_Function1)
        {
            return NULL;
        }
        var_llvm_Function = var_llvm_Function1;
    }
    unsigned var_unsigned;
    int var_int = py_int_to(var_PyObject1, var_unsigned);
    if(!var_int)
    {
        return NULL;
    }
    void* var_void1 = PyCapsule_GetPointer(var_PyObject2, "llvm::AttributeSet");
    if(!var_void1)
    {
        puts("Error: llvm::AttributeSet");
        return NULL;
    }
    llvm::AttributeSet* var_llvm_AttributeSet = unwrap_as<llvm::AttributeSet, llvm::AttributeSet >::from(var_void1);
    if(!var_llvm_AttributeSet)
    {
        return NULL;
    }
    llvm::AttributeSet& var_llvm_AttributeSet1 = *var_llvm_AttributeSet;
    var_llvm_Function->removeAttributes(var_unsigned, var_llvm_AttributeSet1);
    Py_RETURN_NONE;
}

static
PyMethodDef meth_llvm_Function[] = {
    { "getFunctionType", (PyCFunction)llvm_Function__getFunctionType, METH_VARARGS, NULL },
    { "getCallingConv", (PyCFunction)llvm_Function__getCallingConv, METH_VARARGS, NULL },
    { "deleteBody", (PyCFunction)llvm_Function__deleteBody, METH_VARARGS, NULL },
    { "setDoesNotAccessMemory", (PyCFunction)llvm_Function__setDoesNotAccessMemory, METH_VARARGS, NULL },
    { "getBasicBlockList", (PyCFunction)llvm_Function__getBasicBlockList, METH_VARARGS, NULL },
    { "getGC", (PyCFunction)llvm_Function__getGC, METH_VARARGS, NULL },
    { "viewCFG", (PyCFunction)llvm_Function__viewCFG, METH_VARARGS, NULL },
    { "addFnAttr", (PyCFunction)llvm_Function__addFnAttr, METH_VARARGS, NULL },
    { "doesNotThrow", (PyCFunction)llvm_Function__doesNotThrow, METH_VARARGS, NULL },
    { "addAttributes", (PyCFunction)llvm_Function__addAttributes, METH_VARARGS, NULL },
    { "getContext", (PyCFunction)llvm_Function__getContext, METH_VARARGS, NULL },
    { "getArgumentList", (PyCFunction)llvm_Function__getArgumentList, METH_VARARGS, NULL },
    { "setDoesNotReturn", (PyCFunction)llvm_Function__setDoesNotReturn, METH_VARARGS, NULL },
    { "setOnlyReadsMemory", (PyCFunction)llvm_Function__setOnlyReadsMemory, METH_VARARGS, NULL },
    { "eraseFromParent", (PyCFunction)llvm_Function__eraseFromParent, METH_VARARGS, NULL },
    { "doesNotReturn", (PyCFunction)llvm_Function__doesNotReturn, METH_VARARGS, NULL },
    { "setGC", (PyCFunction)llvm_Function__setGC, METH_VARARGS, NULL },
    { "Create", (PyCFunction)llvm_Function__Create, METH_VARARGS, NULL },
    { "hasGC", (PyCFunction)llvm_Function__hasGC, METH_VARARGS, NULL },
    { "doesNotAccessMemory", (PyCFunction)llvm_Function__doesNotAccessMemory, METH_VARARGS, NULL },
    { "getIntrinsicID", (PyCFunction)llvm_Function__getIntrinsicID, METH_VARARGS, NULL },
    { "onlyReadsMemory", (PyCFunction)llvm_Function__onlyReadsMemory, METH_VARARGS, NULL },
    { "getEntryBlock", (PyCFunction)llvm_Function__getEntryBlock, METH_VARARGS, NULL },
    { "getValueSymbolTable", (PyCFunction)llvm_Function__getValueSymbolTable, METH_VARARGS, NULL },
    { "copyAttributesFrom", (PyCFunction)llvm_Function__copyAttributesFrom, METH_VARARGS, NULL },
    { "isIntrinsic", (PyCFunction)llvm_Function__isIntrinsic, METH_VARARGS, NULL },
    { "setCallingConv", (PyCFunction)llvm_Function__setCallingConv, METH_VARARGS, NULL },
    { "setDoesNotThrow", (PyCFunction)llvm_Function__setDoesNotThrow, METH_VARARGS, NULL },
    { "isVarArg", (PyCFunction)llvm_Function__isVarArg, METH_VARARGS, NULL },
    { "viewCFGOnly", (PyCFunction)llvm_Function__viewCFGOnly, METH_VARARGS, NULL },
    { "getReturnType", (PyCFunction)llvm_Function__getReturnType, METH_VARARGS, NULL },
    { "removeAttributes", (PyCFunction)llvm_Function__removeAttributes, METH_VARARGS, NULL },
    { NULL },
};

static
SubModuleEntry submodule_llvm_Function[] = {
    { NULL }
};

static
PyObject*
llvm_UndefValue__destroyConstant(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::UndefValue* var_llvm_UndefValue = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::UndefValue* var_llvm_UndefValue1 = unwrap_as<llvm::UndefValue, llvm::Value >::from(var_void);
        if(!var_llvm_UndefValue1)
        {
            return NULL;
        }
        var_llvm_UndefValue = var_llvm_UndefValue1;
    }
    var_llvm_UndefValue->destroyConstant();
    Py_RETURN_NONE;
}

static
PyObject*
llvm_UndefValue____getElementValue__by__int(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::UndefValue* var_llvm_UndefValue = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::UndefValue* var_llvm_UndefValue1 = unwrap_as<llvm::UndefValue, llvm::Value >::from(var_void);
        if(!var_llvm_UndefValue1)
        {
            return NULL;
        }
        var_llvm_UndefValue = var_llvm_UndefValue1;
    }
    unsigned var_unsigned;
    int var_int = py_int_to(var_PyObject1, var_unsigned);
    if(!var_int)
    {
        return NULL;
    }
    llvm::UndefValue* var_llvm_UndefValue2 = var_llvm_UndefValue->getElementValue(var_unsigned);
    PyObject* var_PyObject2 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_UndefValue2), "llvm::Value", "llvm::UndefValue");
    if (!var_PyObject2)
    {
        return NULL;
    }
    return var_PyObject2;
}

static
PyObject*
llvm_UndefValue__getSequentialElement(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::UndefValue* var_llvm_UndefValue = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::UndefValue* var_llvm_UndefValue1 = unwrap_as<llvm::UndefValue, llvm::Value >::from(var_void);
        if(!var_llvm_UndefValue1)
        {
            return NULL;
        }
        var_llvm_UndefValue = var_llvm_UndefValue1;
    }
    llvm::UndefValue* var_llvm_UndefValue2 = var_llvm_UndefValue->getSequentialElement();
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_UndefValue2), "llvm::Value", "llvm::UndefValue");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyObject*
llvm_UndefValue__getStructElement(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::UndefValue* var_llvm_UndefValue = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::UndefValue* var_llvm_UndefValue1 = unwrap_as<llvm::UndefValue, llvm::Value >::from(var_void);
        if(!var_llvm_UndefValue1)
        {
            return NULL;
        }
        var_llvm_UndefValue = var_llvm_UndefValue1;
    }
    unsigned var_unsigned;
    int var_int = py_int_to(var_PyObject1, var_unsigned);
    if(!var_int)
    {
        return NULL;
    }
    llvm::UndefValue* var_llvm_UndefValue2 = var_llvm_UndefValue->getStructElement(var_unsigned);
    PyObject* var_PyObject2 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_UndefValue2), "llvm::Value", "llvm::UndefValue");
    if (!var_PyObject2)
    {
        return NULL;
    }
    return var_PyObject2;
}

static
PyObject*
llvm_UndefValue____getElementValue__by__const(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::UndefValue* var_llvm_UndefValue = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::UndefValue* var_llvm_UndefValue1 = unwrap_as<llvm::UndefValue, llvm::Value >::from(var_void);
        if(!var_llvm_UndefValue1)
        {
            return NULL;
        }
        var_llvm_UndefValue = var_llvm_UndefValue1;
    }
    llvm::Constant* var_llvm_Constant = NULL;
    if (var_PyObject1 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Value");
        if(!var_void1)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant1 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void1);
        if(!var_llvm_Constant1)
        {
            return NULL;
        }
        var_llvm_Constant = var_llvm_Constant1;
    }
    llvm::UndefValue* var_llvm_UndefValue2 = var_llvm_UndefValue->getElementValue(var_llvm_Constant);
    PyObject* var_PyObject2 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_UndefValue2), "llvm::Value", "llvm::UndefValue");
    if (!var_PyObject2)
    {
        return NULL;
    }
    return var_PyObject2;
}

static
PyObject*
llvm_UndefValue__get(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    llvm::UndefValue* var_llvm_UndefValue = llvm::UndefValue::get(var_llvm_Type);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_UndefValue), "llvm::Value", "llvm::UndefValue");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyMethodDef meth_llvm_UndefValue[] = {
    { "destroyConstant", (PyCFunction)llvm_UndefValue__destroyConstant, METH_VARARGS, NULL },
    { "_getElementValue_by_int", (PyCFunction)llvm_UndefValue____getElementValue__by__int, METH_VARARGS, NULL },
    { "getSequentialElement", (PyCFunction)llvm_UndefValue__getSequentialElement, METH_VARARGS, NULL },
    { "getStructElement", (PyCFunction)llvm_UndefValue__getStructElement, METH_VARARGS, NULL },
    { "_getElementValue_by_const", (PyCFunction)llvm_UndefValue____getElementValue__by__const, METH_VARARGS, NULL },
    { "get", (PyCFunction)llvm_UndefValue__get, METH_VARARGS, NULL },
    { NULL },
};

static
SubModuleEntry submodule_llvm_UndefValue[] = {
    { NULL }
};

static
PyObject*
llvm_ConstantInt__getSExtValue(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::ConstantInt* var_llvm_ConstantInt = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::ConstantInt* var_llvm_ConstantInt1 = unwrap_as<llvm::ConstantInt, llvm::Value >::from(var_void);
        if(!var_llvm_ConstantInt1)
        {
            return NULL;
        }
        var_llvm_ConstantInt = var_llvm_ConstantInt1;
    }
    int64_t var_int64__t = var_llvm_ConstantInt->getSExtValue();
    PyObject* var_PyObject1 = py_int_from_signed(var_int64__t);
    return var_PyObject1;
}

static
PyObject*
llvm_ConstantInt__isValueValidForType(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    int64_t var_int64__t;
    int var_int = py_int_to(var_PyObject1, var_int64__t);
    if(!var_int)
    {
        return NULL;
    }
    bool var_bool = llvm::ConstantInt::isValueValidForType(var_llvm_Type, var_int64__t);
    PyObject* var_PyObject2 = py_bool_from(var_bool);
    return var_PyObject2;
}

static
PyObject*
llvm_ConstantInt__getZExtValue(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::ConstantInt* var_llvm_ConstantInt = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::ConstantInt* var_llvm_ConstantInt1 = unwrap_as<llvm::ConstantInt, llvm::Value >::from(var_void);
        if(!var_llvm_ConstantInt1)
        {
            return NULL;
        }
        var_llvm_ConstantInt = var_llvm_ConstantInt1;
    }
    uint64_t var_uint64__t = var_llvm_ConstantInt->getZExtValue();
    PyObject* var_PyObject1 = py_int_from_unsigned(var_uint64__t);
    return var_PyObject1;
}

static
PyObject*
llvm_ConstantInt__get(PyObject* self, PyObject* args)
{
    Py_ssize_t var_Py__ssize__t = PyTuple_Size(args);
    if (3 == var_Py__ssize__t)
    {
        PyObject* var_PyObject;
        PyObject* var_PyObject1;
        PyObject* var_PyObject2;
        if(!PyArg_ParseTuple(args, "OOO", &var_PyObject, &var_PyObject1, &var_PyObject2))
        {
            return NULL;
        }
        llvm::IntegerType* var_llvm_IntegerType = NULL;
        if (var_PyObject != Py_None)
        {
            void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
            if(!var_void)
            {
                puts("Error: llvm::Type");
                return NULL;
            }
            llvm::IntegerType* var_llvm_IntegerType1 = unwrap_as<llvm::IntegerType, llvm::Type >::from(var_void);
            if(!var_llvm_IntegerType1)
            {
                return NULL;
            }
            var_llvm_IntegerType = var_llvm_IntegerType1;
        }
        uint64_t var_uint64__t;
        int var_int = py_int_to(var_PyObject1, var_uint64__t);
        if(!var_int)
        {
            return NULL;
        }
        bool var_bool;
        int var_int1 = py_bool_to(var_PyObject2, var_bool);
        if(!var_int1)
        {
            return NULL;
        }
        llvm::ConstantInt* var_llvm_ConstantInt = llvm::ConstantInt::get(var_llvm_IntegerType, var_uint64__t, var_bool);
        PyObject* var_PyObject3 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_ConstantInt), "llvm::Value", "llvm::ConstantInt");
        if (!var_PyObject3)
        {
            return NULL;
        }
        return var_PyObject3;
    }
    if (2 == var_Py__ssize__t)
    {
        PyObject* var_PyObject4;
        PyObject* var_PyObject5;
        if(!PyArg_ParseTuple(args, "OO", &var_PyObject4, &var_PyObject5))
        {
            return NULL;
        }
        llvm::IntegerType* var_llvm_IntegerType2 = NULL;
        if (var_PyObject4 != Py_None)
        {
            void* var_void1 = PyCapsule_GetPointer(var_PyObject4, "llvm::Type");
            if(!var_void1)
            {
                puts("Error: llvm::Type");
                return NULL;
            }
            llvm::IntegerType* var_llvm_IntegerType3 = unwrap_as<llvm::IntegerType, llvm::Type >::from(var_void1);
            if(!var_llvm_IntegerType3)
            {
                return NULL;
            }
            var_llvm_IntegerType2 = var_llvm_IntegerType3;
        }
        uint64_t var_uint64__t1;
        int var_int2 = py_int_to(var_PyObject5, var_uint64__t1);
        if(!var_int2)
        {
            return NULL;
        }
        llvm::ConstantInt* var_llvm_ConstantInt1 = llvm::ConstantInt::get(var_llvm_IntegerType2, var_uint64__t1);
        PyObject* var_PyObject6 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_ConstantInt1), "llvm::Value", "llvm::ConstantInt");
        if (!var_PyObject6)
        {
            return NULL;
        }
        return var_PyObject6;
    }
    PyErr_SetString(PyExc_TypeError, "Invalid number of args");
    return NULL;
}

static
PyMethodDef meth_llvm_ConstantInt[] = {
    { "getSExtValue", (PyCFunction)llvm_ConstantInt__getSExtValue, METH_VARARGS, NULL },
    { "isValueValidForType", (PyCFunction)llvm_ConstantInt__isValueValidForType, METH_VARARGS, NULL },
    { "getZExtValue", (PyCFunction)llvm_ConstantInt__getZExtValue, METH_VARARGS, NULL },
    { "get", (PyCFunction)llvm_ConstantInt__get, METH_VARARGS, NULL },
    { NULL },
};

static
SubModuleEntry submodule_llvm_ConstantInt[] = {
    { NULL }
};

static
PyObject*
llvm_ConstantFP__isNaN(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::ConstantFP* var_llvm_ConstantFP = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::ConstantFP* var_llvm_ConstantFP1 = unwrap_as<llvm::ConstantFP, llvm::Value >::from(var_void);
        if(!var_llvm_ConstantFP1)
        {
            return NULL;
        }
        var_llvm_ConstantFP = var_llvm_ConstantFP1;
    }
    bool var_bool = var_llvm_ConstantFP->isNaN();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_ConstantFP__isZero(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::ConstantFP* var_llvm_ConstantFP = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::ConstantFP* var_llvm_ConstantFP1 = unwrap_as<llvm::ConstantFP, llvm::Value >::from(var_void);
        if(!var_llvm_ConstantFP1)
        {
            return NULL;
        }
        var_llvm_ConstantFP = var_llvm_ConstantFP1;
    }
    bool var_bool = var_llvm_ConstantFP->isZero();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_ConstantFP__getNegativeZero(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    llvm::ConstantFP* var_llvm_ConstantFP = llvm::ConstantFP::getNegativeZero(var_llvm_Type);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_ConstantFP), "llvm::Value", "llvm::ConstantFP");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyObject*
llvm_ConstantFP__get(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    double var_double;
    int var_int = py_float_to(var_PyObject1, var_double);
    if(!var_int)
    {
        return NULL;
    }
    llvm::Constant* var_llvm_Constant = llvm::ConstantFP::get(var_llvm_Type, var_double);
    PyObject* var_PyObject2 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant), "llvm::Value", "llvm::Constant");
    if (!var_PyObject2)
    {
        return NULL;
    }
    return var_PyObject2;
}

static
PyObject*
llvm_ConstantFP__isNegative(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::ConstantFP* var_llvm_ConstantFP = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::ConstantFP* var_llvm_ConstantFP1 = unwrap_as<llvm::ConstantFP, llvm::Value >::from(var_void);
        if(!var_llvm_ConstantFP1)
        {
            return NULL;
        }
        var_llvm_ConstantFP = var_llvm_ConstantFP1;
    }
    bool var_bool = var_llvm_ConstantFP->isNegative();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_ConstantFP__getInfinity(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    bool var_bool;
    int var_int = py_bool_to(var_PyObject1, var_bool);
    if(!var_int)
    {
        return NULL;
    }
    llvm::ConstantFP* var_llvm_ConstantFP = llvm::ConstantFP::getInfinity(var_llvm_Type, var_bool);
    PyObject* var_PyObject2 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_ConstantFP), "llvm::Value", "llvm::ConstantFP");
    if (!var_PyObject2)
    {
        return NULL;
    }
    return var_PyObject2;
}

static
PyMethodDef meth_llvm_ConstantFP[] = {
    { "isNaN", (PyCFunction)llvm_ConstantFP__isNaN, METH_VARARGS, NULL },
    { "isZero", (PyCFunction)llvm_ConstantFP__isZero, METH_VARARGS, NULL },
    { "getNegativeZero", (PyCFunction)llvm_ConstantFP__getNegativeZero, METH_VARARGS, NULL },
    { "get", (PyCFunction)llvm_ConstantFP__get, METH_VARARGS, NULL },
    { "isNegative", (PyCFunction)llvm_ConstantFP__isNegative, METH_VARARGS, NULL },
    { "getInfinity", (PyCFunction)llvm_ConstantFP__getInfinity, METH_VARARGS, NULL },
    { NULL },
};

static
SubModuleEntry submodule_llvm_ConstantFP[] = {
    { NULL }
};

static
PyObject*
llvm_ConstantArray__get(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::ArrayType* var_llvm_ArrayType = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::ArrayType* var_llvm_ArrayType1 = unwrap_as<llvm::ArrayType, llvm::Type >::from(var_void);
        if(!var_llvm_ArrayType1)
        {
            return NULL;
        }
        var_llvm_ArrayType = var_llvm_ArrayType1;
    }
    PyObject* var_PyObject2 = ConstantArray_get(var_llvm_ArrayType, var_PyObject1);
    return var_PyObject2;
}

static
PyMethodDef meth_llvm_ConstantArray[] = {
    { "get", (PyCFunction)llvm_ConstantArray__get, METH_VARARGS, NULL },
    { NULL },
};

static
SubModuleEntry submodule_llvm_ConstantArray[] = {
    { NULL }
};

static
PyObject*
llvm_ConstantStruct__get(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::StructType* var_llvm_StructType = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::StructType* var_llvm_StructType1 = unwrap_as<llvm::StructType, llvm::Type >::from(var_void);
        if(!var_llvm_StructType1)
        {
            return NULL;
        }
        var_llvm_StructType = var_llvm_StructType1;
    }
    PyObject* var_PyObject2 = ConstantStruct_get(var_llvm_StructType, var_PyObject1);
    return var_PyObject2;
}

static
PyObject*
llvm_ConstantStruct__getAnon(PyObject* self, PyObject* args)
{
    Py_ssize_t var_Py__ssize__t = PyTuple_Size(args);
    if (2 == var_Py__ssize__t)
    {
        PyObject* var_PyObject;
        PyObject* var_PyObject1;
        if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
        {
            return NULL;
        }
        bool var_bool;
        int var_int = py_bool_to(var_PyObject1, var_bool);
        if(!var_int)
        {
            return NULL;
        }
        PyObject* var_PyObject2 = ConstantStruct_getAnon(var_PyObject, var_bool);
        return var_PyObject2;
    }
    if (1 == var_Py__ssize__t)
    {
        PyObject* var_PyObject3;
        if(!PyArg_ParseTuple(args, "O", &var_PyObject3))
        {
            return NULL;
        }
        PyObject* var_PyObject4 = ConstantStruct_getAnon(var_PyObject3);
        return var_PyObject4;
    }
    PyErr_SetString(PyExc_TypeError, "Invalid number of args");
    return NULL;
}

static
PyMethodDef meth_llvm_ConstantStruct[] = {
    { "get", (PyCFunction)llvm_ConstantStruct__get, METH_VARARGS, NULL },
    { "getAnon", (PyCFunction)llvm_ConstantStruct__getAnon, METH_VARARGS, NULL },
    { NULL },
};

static
SubModuleEntry submodule_llvm_ConstantStruct[] = {
    { NULL }
};

static
PyObject*
llvm_ConstantVector__get(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    PyObject* var_PyObject1 = ConstantVector_get(var_PyObject);
    return var_PyObject1;
}

static
PyMethodDef meth_llvm_ConstantVector[] = {
    { "get", (PyCFunction)llvm_ConstantVector__get, METH_VARARGS, NULL },
    { NULL },
};

static
SubModuleEntry submodule_llvm_ConstantVector[] = {
    { NULL }
};

static
PyMethodDef meth_llvm_ConstantDataSequential[] = {
    { NULL },
};

static
SubModuleEntry submodule_llvm_ConstantDataSequential[] = {
    { NULL }
};

static
PyObject*
llvm_ConstantDataArray__getString(PyObject* self, PyObject* args)
{
    Py_ssize_t var_Py__ssize__t = PyTuple_Size(args);
    if (3 == var_Py__ssize__t)
    {
        PyObject* var_PyObject;
        PyObject* var_PyObject1;
        PyObject* var_PyObject2;
        if(!PyArg_ParseTuple(args, "OOO", &var_PyObject, &var_PyObject1, &var_PyObject2))
        {
            return NULL;
        }
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::LLVMContext");
        if(!var_void)
        {
            puts("Error: llvm::LLVMContext");
            return NULL;
        }
        llvm::LLVMContext* var_llvm_LLVMContext = unwrap_as<llvm::LLVMContext, llvm::LLVMContext >::from(var_void);
        if(!var_llvm_LLVMContext)
        {
            return NULL;
        }
        llvm::LLVMContext& var_llvm_LLVMContext1 = *var_llvm_LLVMContext;
        llvm::StringRef var_llvm_StringRef;
        int var_int = py_str_to(var_PyObject1, var_llvm_StringRef);
        if(!var_int)
        {
            return NULL;
        }
        bool var_bool;
        int var_int1 = py_bool_to(var_PyObject2, var_bool);
        if(!var_int1)
        {
            return NULL;
        }
        llvm::Constant* var_llvm_Constant = llvm::ConstantDataArray::getString(var_llvm_LLVMContext1, var_llvm_StringRef, var_bool);
        PyObject* var_PyObject3 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant), "llvm::Value", "llvm::Constant");
        if (!var_PyObject3)
        {
            return NULL;
        }
        return var_PyObject3;
    }
    if (2 == var_Py__ssize__t)
    {
        PyObject* var_PyObject4;
        PyObject* var_PyObject5;
        if(!PyArg_ParseTuple(args, "OO", &var_PyObject4, &var_PyObject5))
        {
            return NULL;
        }
        void* var_void1 = PyCapsule_GetPointer(var_PyObject4, "llvm::LLVMContext");
        if(!var_void1)
        {
            puts("Error: llvm::LLVMContext");
            return NULL;
        }
        llvm::LLVMContext* var_llvm_LLVMContext2 = unwrap_as<llvm::LLVMContext, llvm::LLVMContext >::from(var_void1);
        if(!var_llvm_LLVMContext2)
        {
            return NULL;
        }
        llvm::LLVMContext& var_llvm_LLVMContext3 = *var_llvm_LLVMContext2;
        llvm::StringRef var_llvm_StringRef1;
        int var_int2 = py_str_to(var_PyObject5, var_llvm_StringRef1);
        if(!var_int2)
        {
            return NULL;
        }
        llvm::Constant* var_llvm_Constant1 = llvm::ConstantDataArray::getString(var_llvm_LLVMContext3, var_llvm_StringRef1);
        PyObject* var_PyObject6 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant1), "llvm::Value", "llvm::Constant");
        if (!var_PyObject6)
        {
            return NULL;
        }
        return var_PyObject6;
    }
    PyErr_SetString(PyExc_TypeError, "Invalid number of args");
    return NULL;
}

static
PyMethodDef meth_llvm_ConstantDataArray[] = {
    { "getString", (PyCFunction)llvm_ConstantDataArray__getString, METH_VARARGS, NULL },
    { NULL },
};

static
SubModuleEntry submodule_llvm_ConstantDataArray[] = {
    { NULL }
};

static
PyObject*
llvm_ConstantExpr__getTrunc(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::Constant* var_llvm_Constant = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant1 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void);
        if(!var_llvm_Constant1)
        {
            return NULL;
        }
        var_llvm_Constant = var_llvm_Constant1;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject1 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Type");
        if(!var_void1)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void1);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    llvm::Constant* var_llvm_Constant2 = llvm::ConstantExpr::getTrunc(var_llvm_Constant, var_llvm_Type);
    PyObject* var_PyObject2 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant2), "llvm::Value", "llvm::Constant");
    if (!var_PyObject2)
    {
        return NULL;
    }
    return var_PyObject2;
}

static
PyObject*
llvm_ConstantExpr__getFNeg(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Constant* var_llvm_Constant = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant1 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void);
        if(!var_llvm_Constant1)
        {
            return NULL;
        }
        var_llvm_Constant = var_llvm_Constant1;
    }
    llvm::Constant* var_llvm_Constant2 = llvm::ConstantExpr::getFNeg(var_llvm_Constant);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant2), "llvm::Value", "llvm::Constant");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyObject*
llvm_ConstantExpr__getURem(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::Constant* var_llvm_Constant = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant1 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void);
        if(!var_llvm_Constant1)
        {
            return NULL;
        }
        var_llvm_Constant = var_llvm_Constant1;
    }
    llvm::Constant* var_llvm_Constant2 = NULL;
    if (var_PyObject1 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Value");
        if(!var_void1)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant3 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void1);
        if(!var_llvm_Constant3)
        {
            return NULL;
        }
        var_llvm_Constant2 = var_llvm_Constant3;
    }
    llvm::Constant* var_llvm_Constant4 = llvm::ConstantExpr::getURem(var_llvm_Constant, var_llvm_Constant2);
    PyObject* var_PyObject2 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant4), "llvm::Value", "llvm::Constant");
    if (!var_PyObject2)
    {
        return NULL;
    }
    return var_PyObject2;
}

static
PyObject*
llvm_ConstantExpr__getFPExtend(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::Constant* var_llvm_Constant = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant1 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void);
        if(!var_llvm_Constant1)
        {
            return NULL;
        }
        var_llvm_Constant = var_llvm_Constant1;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject1 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Type");
        if(!var_void1)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void1);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    llvm::Constant* var_llvm_Constant2 = llvm::ConstantExpr::getFPExtend(var_llvm_Constant, var_llvm_Type);
    PyObject* var_PyObject2 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant2), "llvm::Value", "llvm::Constant");
    if (!var_PyObject2)
    {
        return NULL;
    }
    return var_PyObject2;
}

static
PyObject*
llvm_ConstantExpr__getOr(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::Constant* var_llvm_Constant = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant1 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void);
        if(!var_llvm_Constant1)
        {
            return NULL;
        }
        var_llvm_Constant = var_llvm_Constant1;
    }
    llvm::Constant* var_llvm_Constant2 = NULL;
    if (var_PyObject1 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Value");
        if(!var_void1)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant3 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void1);
        if(!var_llvm_Constant3)
        {
            return NULL;
        }
        var_llvm_Constant2 = var_llvm_Constant3;
    }
    llvm::Constant* var_llvm_Constant4 = llvm::ConstantExpr::getOr(var_llvm_Constant, var_llvm_Constant2);
    PyObject* var_PyObject2 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant4), "llvm::Value", "llvm::Constant");
    if (!var_PyObject2)
    {
        return NULL;
    }
    return var_PyObject2;
}

static
PyObject*
llvm_ConstantExpr__getExtractElement(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::Constant* var_llvm_Constant = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant1 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void);
        if(!var_llvm_Constant1)
        {
            return NULL;
        }
        var_llvm_Constant = var_llvm_Constant1;
    }
    llvm::Constant* var_llvm_Constant2 = NULL;
    if (var_PyObject1 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Value");
        if(!var_void1)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant3 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void1);
        if(!var_llvm_Constant3)
        {
            return NULL;
        }
        var_llvm_Constant2 = var_llvm_Constant3;
    }
    llvm::Constant* var_llvm_Constant4 = llvm::ConstantExpr::getExtractElement(var_llvm_Constant, var_llvm_Constant2);
    PyObject* var_PyObject2 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant4), "llvm::Value", "llvm::Constant");
    if (!var_PyObject2)
    {
        return NULL;
    }
    return var_PyObject2;
}

static
PyObject*
llvm_ConstantExpr__getSDiv(PyObject* self, PyObject* args)
{
    Py_ssize_t var_Py__ssize__t = PyTuple_Size(args);
    if (3 == var_Py__ssize__t)
    {
        PyObject* var_PyObject;
        PyObject* var_PyObject1;
        PyObject* var_PyObject2;
        if(!PyArg_ParseTuple(args, "OOO", &var_PyObject, &var_PyObject1, &var_PyObject2))
        {
            return NULL;
        }
        llvm::Constant* var_llvm_Constant = NULL;
        if (var_PyObject != Py_None)
        {
            void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
            if(!var_void)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::Constant* var_llvm_Constant1 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void);
            if(!var_llvm_Constant1)
            {
                return NULL;
            }
            var_llvm_Constant = var_llvm_Constant1;
        }
        llvm::Constant* var_llvm_Constant2 = NULL;
        if (var_PyObject1 != Py_None)
        {
            void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Value");
            if(!var_void1)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::Constant* var_llvm_Constant3 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void1);
            if(!var_llvm_Constant3)
            {
                return NULL;
            }
            var_llvm_Constant2 = var_llvm_Constant3;
        }
        bool var_bool;
        int var_int = py_bool_to(var_PyObject2, var_bool);
        if(!var_int)
        {
            return NULL;
        }
        llvm::Constant* var_llvm_Constant4 = llvm::ConstantExpr::getSDiv(var_llvm_Constant, var_llvm_Constant2, var_bool);
        PyObject* var_PyObject3 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant4), "llvm::Value", "llvm::Constant");
        if (!var_PyObject3)
        {
            return NULL;
        }
        return var_PyObject3;
    }
    if (2 == var_Py__ssize__t)
    {
        PyObject* var_PyObject4;
        PyObject* var_PyObject5;
        if(!PyArg_ParseTuple(args, "OO", &var_PyObject4, &var_PyObject5))
        {
            return NULL;
        }
        llvm::Constant* var_llvm_Constant5 = NULL;
        if (var_PyObject4 != Py_None)
        {
            void* var_void2 = PyCapsule_GetPointer(var_PyObject4, "llvm::Value");
            if(!var_void2)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::Constant* var_llvm_Constant6 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void2);
            if(!var_llvm_Constant6)
            {
                return NULL;
            }
            var_llvm_Constant5 = var_llvm_Constant6;
        }
        llvm::Constant* var_llvm_Constant7 = NULL;
        if (var_PyObject5 != Py_None)
        {
            void* var_void3 = PyCapsule_GetPointer(var_PyObject5, "llvm::Value");
            if(!var_void3)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::Constant* var_llvm_Constant8 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void3);
            if(!var_llvm_Constant8)
            {
                return NULL;
            }
            var_llvm_Constant7 = var_llvm_Constant8;
        }
        llvm::Constant* var_llvm_Constant9 = llvm::ConstantExpr::getSDiv(var_llvm_Constant5, var_llvm_Constant7);
        PyObject* var_PyObject6 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant9), "llvm::Value", "llvm::Constant");
        if (!var_PyObject6)
        {
            return NULL;
        }
        return var_PyObject6;
    }
    PyErr_SetString(PyExc_TypeError, "Invalid number of args");
    return NULL;
}

static
PyObject*
llvm_ConstantExpr__getSIToFP(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::Constant* var_llvm_Constant = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant1 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void);
        if(!var_llvm_Constant1)
        {
            return NULL;
        }
        var_llvm_Constant = var_llvm_Constant1;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject1 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Type");
        if(!var_void1)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void1);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    llvm::Constant* var_llvm_Constant2 = llvm::ConstantExpr::getSIToFP(var_llvm_Constant, var_llvm_Type);
    PyObject* var_PyObject2 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant2), "llvm::Value", "llvm::Constant");
    if (!var_PyObject2)
    {
        return NULL;
    }
    return var_PyObject2;
}

static
PyObject*
llvm_ConstantExpr__getXor(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::Constant* var_llvm_Constant = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant1 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void);
        if(!var_llvm_Constant1)
        {
            return NULL;
        }
        var_llvm_Constant = var_llvm_Constant1;
    }
    llvm::Constant* var_llvm_Constant2 = NULL;
    if (var_PyObject1 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Value");
        if(!var_void1)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant3 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void1);
        if(!var_llvm_Constant3)
        {
            return NULL;
        }
        var_llvm_Constant2 = var_llvm_Constant3;
    }
    llvm::Constant* var_llvm_Constant4 = llvm::ConstantExpr::getXor(var_llvm_Constant, var_llvm_Constant2);
    PyObject* var_PyObject2 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant4), "llvm::Value", "llvm::Constant");
    if (!var_PyObject2)
    {
        return NULL;
    }
    return var_PyObject2;
}

static
PyObject*
llvm_ConstantExpr__getFPToSI(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::Constant* var_llvm_Constant = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant1 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void);
        if(!var_llvm_Constant1)
        {
            return NULL;
        }
        var_llvm_Constant = var_llvm_Constant1;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject1 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Type");
        if(!var_void1)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void1);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    llvm::Constant* var_llvm_Constant2 = llvm::ConstantExpr::getFPToSI(var_llvm_Constant, var_llvm_Type);
    PyObject* var_PyObject2 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant2), "llvm::Value", "llvm::Constant");
    if (!var_PyObject2)
    {
        return NULL;
    }
    return var_PyObject2;
}

static
PyObject*
llvm_ConstantExpr__getFPCast(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::Constant* var_llvm_Constant = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant1 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void);
        if(!var_llvm_Constant1)
        {
            return NULL;
        }
        var_llvm_Constant = var_llvm_Constant1;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject1 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Type");
        if(!var_void1)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void1);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    llvm::Constant* var_llvm_Constant2 = llvm::ConstantExpr::getFPCast(var_llvm_Constant, var_llvm_Type);
    PyObject* var_PyObject2 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant2), "llvm::Value", "llvm::Constant");
    if (!var_PyObject2)
    {
        return NULL;
    }
    return var_PyObject2;
}

static
PyObject*
llvm_ConstantExpr__getUIToFP(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::Constant* var_llvm_Constant = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant1 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void);
        if(!var_llvm_Constant1)
        {
            return NULL;
        }
        var_llvm_Constant = var_llvm_Constant1;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject1 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Type");
        if(!var_void1)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void1);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    llvm::Constant* var_llvm_Constant2 = llvm::ConstantExpr::getUIToFP(var_llvm_Constant, var_llvm_Type);
    PyObject* var_PyObject2 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant2), "llvm::Value", "llvm::Constant");
    if (!var_PyObject2)
    {
        return NULL;
    }
    return var_PyObject2;
}

static
PyObject*
llvm_ConstantExpr__getAdd(PyObject* self, PyObject* args)
{
    Py_ssize_t var_Py__ssize__t = PyTuple_Size(args);
    if (4 == var_Py__ssize__t)
    {
        PyObject* var_PyObject;
        PyObject* var_PyObject1;
        PyObject* var_PyObject2;
        PyObject* var_PyObject3;
        if(!PyArg_ParseTuple(args, "OOOO", &var_PyObject, &var_PyObject1, &var_PyObject2, &var_PyObject3))
        {
            return NULL;
        }
        llvm::Constant* var_llvm_Constant = NULL;
        if (var_PyObject != Py_None)
        {
            void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
            if(!var_void)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::Constant* var_llvm_Constant1 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void);
            if(!var_llvm_Constant1)
            {
                return NULL;
            }
            var_llvm_Constant = var_llvm_Constant1;
        }
        llvm::Constant* var_llvm_Constant2 = NULL;
        if (var_PyObject1 != Py_None)
        {
            void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Value");
            if(!var_void1)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::Constant* var_llvm_Constant3 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void1);
            if(!var_llvm_Constant3)
            {
                return NULL;
            }
            var_llvm_Constant2 = var_llvm_Constant3;
        }
        bool var_bool;
        int var_int = py_bool_to(var_PyObject2, var_bool);
        if(!var_int)
        {
            return NULL;
        }
        bool var_bool1;
        int var_int1 = py_bool_to(var_PyObject3, var_bool1);
        if(!var_int1)
        {
            return NULL;
        }
        llvm::Constant* var_llvm_Constant4 = llvm::ConstantExpr::getAdd(var_llvm_Constant, var_llvm_Constant2, var_bool, var_bool1);
        PyObject* var_PyObject4 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant4), "llvm::Value", "llvm::Constant");
        if (!var_PyObject4)
        {
            return NULL;
        }
        return var_PyObject4;
    }
    if (2 == var_Py__ssize__t)
    {
        PyObject* var_PyObject5;
        PyObject* var_PyObject6;
        if(!PyArg_ParseTuple(args, "OO", &var_PyObject5, &var_PyObject6))
        {
            return NULL;
        }
        llvm::Constant* var_llvm_Constant5 = NULL;
        if (var_PyObject5 != Py_None)
        {
            void* var_void2 = PyCapsule_GetPointer(var_PyObject5, "llvm::Value");
            if(!var_void2)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::Constant* var_llvm_Constant6 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void2);
            if(!var_llvm_Constant6)
            {
                return NULL;
            }
            var_llvm_Constant5 = var_llvm_Constant6;
        }
        llvm::Constant* var_llvm_Constant7 = NULL;
        if (var_PyObject6 != Py_None)
        {
            void* var_void3 = PyCapsule_GetPointer(var_PyObject6, "llvm::Value");
            if(!var_void3)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::Constant* var_llvm_Constant8 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void3);
            if(!var_llvm_Constant8)
            {
                return NULL;
            }
            var_llvm_Constant7 = var_llvm_Constant8;
        }
        llvm::Constant* var_llvm_Constant9 = llvm::ConstantExpr::getAdd(var_llvm_Constant5, var_llvm_Constant7);
        PyObject* var_PyObject7 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant9), "llvm::Value", "llvm::Constant");
        if (!var_PyObject7)
        {
            return NULL;
        }
        return var_PyObject7;
    }
    if (3 == var_Py__ssize__t)
    {
        PyObject* var_PyObject8;
        PyObject* var_PyObject9;
        PyObject* var_PyObject10;
        if(!PyArg_ParseTuple(args, "OOO", &var_PyObject8, &var_PyObject9, &var_PyObject10))
        {
            return NULL;
        }
        llvm::Constant* var_llvm_Constant10 = NULL;
        if (var_PyObject8 != Py_None)
        {
            void* var_void4 = PyCapsule_GetPointer(var_PyObject8, "llvm::Value");
            if(!var_void4)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::Constant* var_llvm_Constant11 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void4);
            if(!var_llvm_Constant11)
            {
                return NULL;
            }
            var_llvm_Constant10 = var_llvm_Constant11;
        }
        llvm::Constant* var_llvm_Constant12 = NULL;
        if (var_PyObject9 != Py_None)
        {
            void* var_void5 = PyCapsule_GetPointer(var_PyObject9, "llvm::Value");
            if(!var_void5)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::Constant* var_llvm_Constant13 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void5);
            if(!var_llvm_Constant13)
            {
                return NULL;
            }
            var_llvm_Constant12 = var_llvm_Constant13;
        }
        bool var_bool2;
        int var_int2 = py_bool_to(var_PyObject10, var_bool2);
        if(!var_int2)
        {
            return NULL;
        }
        llvm::Constant* var_llvm_Constant14 = llvm::ConstantExpr::getAdd(var_llvm_Constant10, var_llvm_Constant12, var_bool2);
        PyObject* var_PyObject11 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant14), "llvm::Value", "llvm::Constant");
        if (!var_PyObject11)
        {
            return NULL;
        }
        return var_PyObject11;
    }
    PyErr_SetString(PyExc_TypeError, "Invalid number of args");
    return NULL;
}

static
PyObject*
llvm_ConstantExpr__getBitCast(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::Constant* var_llvm_Constant = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant1 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void);
        if(!var_llvm_Constant1)
        {
            return NULL;
        }
        var_llvm_Constant = var_llvm_Constant1;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject1 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Type");
        if(!var_void1)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void1);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    llvm::Constant* var_llvm_Constant2 = llvm::ConstantExpr::getBitCast(var_llvm_Constant, var_llvm_Type);
    PyObject* var_PyObject2 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant2), "llvm::Value", "llvm::Constant");
    if (!var_PyObject2)
    {
        return NULL;
    }
    return var_PyObject2;
}

static
PyObject*
llvm_ConstantExpr__getFRem(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::Constant* var_llvm_Constant = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant1 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void);
        if(!var_llvm_Constant1)
        {
            return NULL;
        }
        var_llvm_Constant = var_llvm_Constant1;
    }
    llvm::Constant* var_llvm_Constant2 = NULL;
    if (var_PyObject1 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Value");
        if(!var_void1)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant3 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void1);
        if(!var_llvm_Constant3)
        {
            return NULL;
        }
        var_llvm_Constant2 = var_llvm_Constant3;
    }
    llvm::Constant* var_llvm_Constant4 = llvm::ConstantExpr::getFRem(var_llvm_Constant, var_llvm_Constant2);
    PyObject* var_PyObject2 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant4), "llvm::Value", "llvm::Constant");
    if (!var_PyObject2)
    {
        return NULL;
    }
    return var_PyObject2;
}

static
PyObject*
llvm_ConstantExpr__getFSub(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::Constant* var_llvm_Constant = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant1 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void);
        if(!var_llvm_Constant1)
        {
            return NULL;
        }
        var_llvm_Constant = var_llvm_Constant1;
    }
    llvm::Constant* var_llvm_Constant2 = NULL;
    if (var_PyObject1 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Value");
        if(!var_void1)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant3 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void1);
        if(!var_llvm_Constant3)
        {
            return NULL;
        }
        var_llvm_Constant2 = var_llvm_Constant3;
    }
    llvm::Constant* var_llvm_Constant4 = llvm::ConstantExpr::getFSub(var_llvm_Constant, var_llvm_Constant2);
    PyObject* var_PyObject2 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant4), "llvm::Value", "llvm::Constant");
    if (!var_PyObject2)
    {
        return NULL;
    }
    return var_PyObject2;
}

static
PyObject*
llvm_ConstantExpr__getUDiv(PyObject* self, PyObject* args)
{
    Py_ssize_t var_Py__ssize__t = PyTuple_Size(args);
    if (3 == var_Py__ssize__t)
    {
        PyObject* var_PyObject;
        PyObject* var_PyObject1;
        PyObject* var_PyObject2;
        if(!PyArg_ParseTuple(args, "OOO", &var_PyObject, &var_PyObject1, &var_PyObject2))
        {
            return NULL;
        }
        llvm::Constant* var_llvm_Constant = NULL;
        if (var_PyObject != Py_None)
        {
            void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
            if(!var_void)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::Constant* var_llvm_Constant1 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void);
            if(!var_llvm_Constant1)
            {
                return NULL;
            }
            var_llvm_Constant = var_llvm_Constant1;
        }
        llvm::Constant* var_llvm_Constant2 = NULL;
        if (var_PyObject1 != Py_None)
        {
            void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Value");
            if(!var_void1)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::Constant* var_llvm_Constant3 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void1);
            if(!var_llvm_Constant3)
            {
                return NULL;
            }
            var_llvm_Constant2 = var_llvm_Constant3;
        }
        bool var_bool;
        int var_int = py_bool_to(var_PyObject2, var_bool);
        if(!var_int)
        {
            return NULL;
        }
        llvm::Constant* var_llvm_Constant4 = llvm::ConstantExpr::getUDiv(var_llvm_Constant, var_llvm_Constant2, var_bool);
        PyObject* var_PyObject3 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant4), "llvm::Value", "llvm::Constant");
        if (!var_PyObject3)
        {
            return NULL;
        }
        return var_PyObject3;
    }
    if (2 == var_Py__ssize__t)
    {
        PyObject* var_PyObject4;
        PyObject* var_PyObject5;
        if(!PyArg_ParseTuple(args, "OO", &var_PyObject4, &var_PyObject5))
        {
            return NULL;
        }
        llvm::Constant* var_llvm_Constant5 = NULL;
        if (var_PyObject4 != Py_None)
        {
            void* var_void2 = PyCapsule_GetPointer(var_PyObject4, "llvm::Value");
            if(!var_void2)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::Constant* var_llvm_Constant6 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void2);
            if(!var_llvm_Constant6)
            {
                return NULL;
            }
            var_llvm_Constant5 = var_llvm_Constant6;
        }
        llvm::Constant* var_llvm_Constant7 = NULL;
        if (var_PyObject5 != Py_None)
        {
            void* var_void3 = PyCapsule_GetPointer(var_PyObject5, "llvm::Value");
            if(!var_void3)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::Constant* var_llvm_Constant8 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void3);
            if(!var_llvm_Constant8)
            {
                return NULL;
            }
            var_llvm_Constant7 = var_llvm_Constant8;
        }
        llvm::Constant* var_llvm_Constant9 = llvm::ConstantExpr::getUDiv(var_llvm_Constant5, var_llvm_Constant7);
        PyObject* var_PyObject6 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant9), "llvm::Value", "llvm::Constant");
        if (!var_PyObject6)
        {
            return NULL;
        }
        return var_PyObject6;
    }
    PyErr_SetString(PyExc_TypeError, "Invalid number of args");
    return NULL;
}

static
PyObject*
llvm_ConstantExpr__getFPToUI(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::Constant* var_llvm_Constant = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant1 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void);
        if(!var_llvm_Constant1)
        {
            return NULL;
        }
        var_llvm_Constant = var_llvm_Constant1;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject1 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Type");
        if(!var_void1)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void1);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    llvm::Constant* var_llvm_Constant2 = llvm::ConstantExpr::getFPToUI(var_llvm_Constant, var_llvm_Type);
    PyObject* var_PyObject2 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant2), "llvm::Value", "llvm::Constant");
    if (!var_PyObject2)
    {
        return NULL;
    }
    return var_PyObject2;
}

static
PyObject*
llvm_ConstantExpr__getNeg(PyObject* self, PyObject* args)
{
    Py_ssize_t var_Py__ssize__t = PyTuple_Size(args);
    if (3 == var_Py__ssize__t)
    {
        PyObject* var_PyObject;
        PyObject* var_PyObject1;
        PyObject* var_PyObject2;
        if(!PyArg_ParseTuple(args, "OOO", &var_PyObject, &var_PyObject1, &var_PyObject2))
        {
            return NULL;
        }
        llvm::Constant* var_llvm_Constant = NULL;
        if (var_PyObject != Py_None)
        {
            void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
            if(!var_void)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::Constant* var_llvm_Constant1 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void);
            if(!var_llvm_Constant1)
            {
                return NULL;
            }
            var_llvm_Constant = var_llvm_Constant1;
        }
        bool var_bool;
        int var_int = py_bool_to(var_PyObject1, var_bool);
        if(!var_int)
        {
            return NULL;
        }
        bool var_bool1;
        int var_int1 = py_bool_to(var_PyObject2, var_bool1);
        if(!var_int1)
        {
            return NULL;
        }
        llvm::Constant* var_llvm_Constant2 = llvm::ConstantExpr::getNeg(var_llvm_Constant, var_bool, var_bool1);
        PyObject* var_PyObject3 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant2), "llvm::Value", "llvm::Constant");
        if (!var_PyObject3)
        {
            return NULL;
        }
        return var_PyObject3;
    }
    if (1 == var_Py__ssize__t)
    {
        PyObject* var_PyObject4;
        if(!PyArg_ParseTuple(args, "O", &var_PyObject4))
        {
            return NULL;
        }
        llvm::Constant* var_llvm_Constant3 = NULL;
        if (var_PyObject4 != Py_None)
        {
            void* var_void1 = PyCapsule_GetPointer(var_PyObject4, "llvm::Value");
            if(!var_void1)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::Constant* var_llvm_Constant4 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void1);
            if(!var_llvm_Constant4)
            {
                return NULL;
            }
            var_llvm_Constant3 = var_llvm_Constant4;
        }
        llvm::Constant* var_llvm_Constant5 = llvm::ConstantExpr::getNeg(var_llvm_Constant3);
        PyObject* var_PyObject5 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant5), "llvm::Value", "llvm::Constant");
        if (!var_PyObject5)
        {
            return NULL;
        }
        return var_PyObject5;
    }
    if (2 == var_Py__ssize__t)
    {
        PyObject* var_PyObject6;
        PyObject* var_PyObject7;
        if(!PyArg_ParseTuple(args, "OO", &var_PyObject6, &var_PyObject7))
        {
            return NULL;
        }
        llvm::Constant* var_llvm_Constant6 = NULL;
        if (var_PyObject6 != Py_None)
        {
            void* var_void2 = PyCapsule_GetPointer(var_PyObject6, "llvm::Value");
            if(!var_void2)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::Constant* var_llvm_Constant7 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void2);
            if(!var_llvm_Constant7)
            {
                return NULL;
            }
            var_llvm_Constant6 = var_llvm_Constant7;
        }
        bool var_bool2;
        int var_int2 = py_bool_to(var_PyObject7, var_bool2);
        if(!var_int2)
        {
            return NULL;
        }
        llvm::Constant* var_llvm_Constant8 = llvm::ConstantExpr::getNeg(var_llvm_Constant6, var_bool2);
        PyObject* var_PyObject8 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant8), "llvm::Value", "llvm::Constant");
        if (!var_PyObject8)
        {
            return NULL;
        }
        return var_PyObject8;
    }
    PyErr_SetString(PyExc_TypeError, "Invalid number of args");
    return NULL;
}

static
PyObject*
llvm_ConstantExpr__getNot(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Constant* var_llvm_Constant = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant1 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void);
        if(!var_llvm_Constant1)
        {
            return NULL;
        }
        var_llvm_Constant = var_llvm_Constant1;
    }
    llvm::Constant* var_llvm_Constant2 = llvm::ConstantExpr::getNot(var_llvm_Constant);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant2), "llvm::Value", "llvm::Constant");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyObject*
llvm_ConstantExpr__getOpcode(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::ConstantExpr* var_llvm_ConstantExpr = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::ConstantExpr* var_llvm_ConstantExpr1 = unwrap_as<llvm::ConstantExpr, llvm::Value >::from(var_void);
        if(!var_llvm_ConstantExpr1)
        {
            return NULL;
        }
        var_llvm_ConstantExpr = var_llvm_ConstantExpr1;
    }
    unsigned var_unsigned = var_llvm_ConstantExpr->getOpcode();
    PyObject* var_PyObject1 = py_int_from_unsigned(var_unsigned);
    return var_PyObject1;
}

static
PyObject*
llvm_ConstantExpr__getSub(PyObject* self, PyObject* args)
{
    Py_ssize_t var_Py__ssize__t = PyTuple_Size(args);
    if (4 == var_Py__ssize__t)
    {
        PyObject* var_PyObject;
        PyObject* var_PyObject1;
        PyObject* var_PyObject2;
        PyObject* var_PyObject3;
        if(!PyArg_ParseTuple(args, "OOOO", &var_PyObject, &var_PyObject1, &var_PyObject2, &var_PyObject3))
        {
            return NULL;
        }
        llvm::Constant* var_llvm_Constant = NULL;
        if (var_PyObject != Py_None)
        {
            void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
            if(!var_void)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::Constant* var_llvm_Constant1 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void);
            if(!var_llvm_Constant1)
            {
                return NULL;
            }
            var_llvm_Constant = var_llvm_Constant1;
        }
        llvm::Constant* var_llvm_Constant2 = NULL;
        if (var_PyObject1 != Py_None)
        {
            void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Value");
            if(!var_void1)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::Constant* var_llvm_Constant3 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void1);
            if(!var_llvm_Constant3)
            {
                return NULL;
            }
            var_llvm_Constant2 = var_llvm_Constant3;
        }
        bool var_bool;
        int var_int = py_bool_to(var_PyObject2, var_bool);
        if(!var_int)
        {
            return NULL;
        }
        bool var_bool1;
        int var_int1 = py_bool_to(var_PyObject3, var_bool1);
        if(!var_int1)
        {
            return NULL;
        }
        llvm::Constant* var_llvm_Constant4 = llvm::ConstantExpr::getSub(var_llvm_Constant, var_llvm_Constant2, var_bool, var_bool1);
        PyObject* var_PyObject4 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant4), "llvm::Value", "llvm::Constant");
        if (!var_PyObject4)
        {
            return NULL;
        }
        return var_PyObject4;
    }
    if (2 == var_Py__ssize__t)
    {
        PyObject* var_PyObject5;
        PyObject* var_PyObject6;
        if(!PyArg_ParseTuple(args, "OO", &var_PyObject5, &var_PyObject6))
        {
            return NULL;
        }
        llvm::Constant* var_llvm_Constant5 = NULL;
        if (var_PyObject5 != Py_None)
        {
            void* var_void2 = PyCapsule_GetPointer(var_PyObject5, "llvm::Value");
            if(!var_void2)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::Constant* var_llvm_Constant6 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void2);
            if(!var_llvm_Constant6)
            {
                return NULL;
            }
            var_llvm_Constant5 = var_llvm_Constant6;
        }
        llvm::Constant* var_llvm_Constant7 = NULL;
        if (var_PyObject6 != Py_None)
        {
            void* var_void3 = PyCapsule_GetPointer(var_PyObject6, "llvm::Value");
            if(!var_void3)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::Constant* var_llvm_Constant8 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void3);
            if(!var_llvm_Constant8)
            {
                return NULL;
            }
            var_llvm_Constant7 = var_llvm_Constant8;
        }
        llvm::Constant* var_llvm_Constant9 = llvm::ConstantExpr::getSub(var_llvm_Constant5, var_llvm_Constant7);
        PyObject* var_PyObject7 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant9), "llvm::Value", "llvm::Constant");
        if (!var_PyObject7)
        {
            return NULL;
        }
        return var_PyObject7;
    }
    if (3 == var_Py__ssize__t)
    {
        PyObject* var_PyObject8;
        PyObject* var_PyObject9;
        PyObject* var_PyObject10;
        if(!PyArg_ParseTuple(args, "OOO", &var_PyObject8, &var_PyObject9, &var_PyObject10))
        {
            return NULL;
        }
        llvm::Constant* var_llvm_Constant10 = NULL;
        if (var_PyObject8 != Py_None)
        {
            void* var_void4 = PyCapsule_GetPointer(var_PyObject8, "llvm::Value");
            if(!var_void4)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::Constant* var_llvm_Constant11 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void4);
            if(!var_llvm_Constant11)
            {
                return NULL;
            }
            var_llvm_Constant10 = var_llvm_Constant11;
        }
        llvm::Constant* var_llvm_Constant12 = NULL;
        if (var_PyObject9 != Py_None)
        {
            void* var_void5 = PyCapsule_GetPointer(var_PyObject9, "llvm::Value");
            if(!var_void5)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::Constant* var_llvm_Constant13 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void5);
            if(!var_llvm_Constant13)
            {
                return NULL;
            }
            var_llvm_Constant12 = var_llvm_Constant13;
        }
        bool var_bool2;
        int var_int2 = py_bool_to(var_PyObject10, var_bool2);
        if(!var_int2)
        {
            return NULL;
        }
        llvm::Constant* var_llvm_Constant14 = llvm::ConstantExpr::getSub(var_llvm_Constant10, var_llvm_Constant12, var_bool2);
        PyObject* var_PyObject11 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant14), "llvm::Value", "llvm::Constant");
        if (!var_PyObject11)
        {
            return NULL;
        }
        return var_PyObject11;
    }
    PyErr_SetString(PyExc_TypeError, "Invalid number of args");
    return NULL;
}

static
PyObject*
llvm_ConstantExpr____getExtractValue(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::Constant* var_llvm_Constant = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant1 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void);
        if(!var_llvm_Constant1)
        {
            return NULL;
        }
        var_llvm_Constant = var_llvm_Constant1;
    }
    void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::SmallVector<unsigned,8>");
    if(!var_void1)
    {
        puts("Error: llvm::SmallVector<unsigned,8>");
        return NULL;
    }
    llvm::SmallVector<unsigned,8>* var_llvm_SmallVectorunsigned_8 = unwrap_as<llvm::SmallVector<unsigned,8>, llvm::SmallVector<unsigned,8> >::from(var_void1);
    if(!var_llvm_SmallVectorunsigned_8)
    {
        return NULL;
    }
    llvm::SmallVector<unsigned,8>& var_llvm_SmallVectorunsigned_81 = *var_llvm_SmallVectorunsigned_8;
    llvm::Constant* var_llvm_Constant2 = llvm::ConstantExpr::getExtractValue(var_llvm_Constant, var_llvm_SmallVectorunsigned_81);
    PyObject* var_PyObject2 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant2), "llvm::Value", "llvm::Constant");
    if (!var_PyObject2)
    {
        return NULL;
    }
    return var_PyObject2;
}

static
PyObject*
llvm_ConstantExpr__getFAdd(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::Constant* var_llvm_Constant = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant1 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void);
        if(!var_llvm_Constant1)
        {
            return NULL;
        }
        var_llvm_Constant = var_llvm_Constant1;
    }
    llvm::Constant* var_llvm_Constant2 = NULL;
    if (var_PyObject1 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Value");
        if(!var_void1)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant3 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void1);
        if(!var_llvm_Constant3)
        {
            return NULL;
        }
        var_llvm_Constant2 = var_llvm_Constant3;
    }
    llvm::Constant* var_llvm_Constant4 = llvm::ConstantExpr::getFAdd(var_llvm_Constant, var_llvm_Constant2);
    PyObject* var_PyObject2 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant4), "llvm::Value", "llvm::Constant");
    if (!var_PyObject2)
    {
        return NULL;
    }
    return var_PyObject2;
}

static
PyObject*
llvm_ConstantExpr__getShl(PyObject* self, PyObject* args)
{
    Py_ssize_t var_Py__ssize__t = PyTuple_Size(args);
    if (4 == var_Py__ssize__t)
    {
        PyObject* var_PyObject;
        PyObject* var_PyObject1;
        PyObject* var_PyObject2;
        PyObject* var_PyObject3;
        if(!PyArg_ParseTuple(args, "OOOO", &var_PyObject, &var_PyObject1, &var_PyObject2, &var_PyObject3))
        {
            return NULL;
        }
        llvm::Constant* var_llvm_Constant = NULL;
        if (var_PyObject != Py_None)
        {
            void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
            if(!var_void)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::Constant* var_llvm_Constant1 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void);
            if(!var_llvm_Constant1)
            {
                return NULL;
            }
            var_llvm_Constant = var_llvm_Constant1;
        }
        llvm::Constant* var_llvm_Constant2 = NULL;
        if (var_PyObject1 != Py_None)
        {
            void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Value");
            if(!var_void1)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::Constant* var_llvm_Constant3 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void1);
            if(!var_llvm_Constant3)
            {
                return NULL;
            }
            var_llvm_Constant2 = var_llvm_Constant3;
        }
        bool var_bool;
        int var_int = py_bool_to(var_PyObject2, var_bool);
        if(!var_int)
        {
            return NULL;
        }
        bool var_bool1;
        int var_int1 = py_bool_to(var_PyObject3, var_bool1);
        if(!var_int1)
        {
            return NULL;
        }
        llvm::Constant* var_llvm_Constant4 = llvm::ConstantExpr::getShl(var_llvm_Constant, var_llvm_Constant2, var_bool, var_bool1);
        PyObject* var_PyObject4 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant4), "llvm::Value", "llvm::Constant");
        if (!var_PyObject4)
        {
            return NULL;
        }
        return var_PyObject4;
    }
    if (2 == var_Py__ssize__t)
    {
        PyObject* var_PyObject5;
        PyObject* var_PyObject6;
        if(!PyArg_ParseTuple(args, "OO", &var_PyObject5, &var_PyObject6))
        {
            return NULL;
        }
        llvm::Constant* var_llvm_Constant5 = NULL;
        if (var_PyObject5 != Py_None)
        {
            void* var_void2 = PyCapsule_GetPointer(var_PyObject5, "llvm::Value");
            if(!var_void2)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::Constant* var_llvm_Constant6 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void2);
            if(!var_llvm_Constant6)
            {
                return NULL;
            }
            var_llvm_Constant5 = var_llvm_Constant6;
        }
        llvm::Constant* var_llvm_Constant7 = NULL;
        if (var_PyObject6 != Py_None)
        {
            void* var_void3 = PyCapsule_GetPointer(var_PyObject6, "llvm::Value");
            if(!var_void3)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::Constant* var_llvm_Constant8 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void3);
            if(!var_llvm_Constant8)
            {
                return NULL;
            }
            var_llvm_Constant7 = var_llvm_Constant8;
        }
        llvm::Constant* var_llvm_Constant9 = llvm::ConstantExpr::getShl(var_llvm_Constant5, var_llvm_Constant7);
        PyObject* var_PyObject7 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant9), "llvm::Value", "llvm::Constant");
        if (!var_PyObject7)
        {
            return NULL;
        }
        return var_PyObject7;
    }
    if (3 == var_Py__ssize__t)
    {
        PyObject* var_PyObject8;
        PyObject* var_PyObject9;
        PyObject* var_PyObject10;
        if(!PyArg_ParseTuple(args, "OOO", &var_PyObject8, &var_PyObject9, &var_PyObject10))
        {
            return NULL;
        }
        llvm::Constant* var_llvm_Constant10 = NULL;
        if (var_PyObject8 != Py_None)
        {
            void* var_void4 = PyCapsule_GetPointer(var_PyObject8, "llvm::Value");
            if(!var_void4)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::Constant* var_llvm_Constant11 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void4);
            if(!var_llvm_Constant11)
            {
                return NULL;
            }
            var_llvm_Constant10 = var_llvm_Constant11;
        }
        llvm::Constant* var_llvm_Constant12 = NULL;
        if (var_PyObject9 != Py_None)
        {
            void* var_void5 = PyCapsule_GetPointer(var_PyObject9, "llvm::Value");
            if(!var_void5)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::Constant* var_llvm_Constant13 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void5);
            if(!var_llvm_Constant13)
            {
                return NULL;
            }
            var_llvm_Constant12 = var_llvm_Constant13;
        }
        bool var_bool2;
        int var_int2 = py_bool_to(var_PyObject10, var_bool2);
        if(!var_int2)
        {
            return NULL;
        }
        llvm::Constant* var_llvm_Constant14 = llvm::ConstantExpr::getShl(var_llvm_Constant10, var_llvm_Constant12, var_bool2);
        PyObject* var_PyObject11 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant14), "llvm::Value", "llvm::Constant");
        if (!var_PyObject11)
        {
            return NULL;
        }
        return var_PyObject11;
    }
    PyErr_SetString(PyExc_TypeError, "Invalid number of args");
    return NULL;
}

static
PyObject*
llvm_ConstantExpr__getZExt(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::Constant* var_llvm_Constant = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant1 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void);
        if(!var_llvm_Constant1)
        {
            return NULL;
        }
        var_llvm_Constant = var_llvm_Constant1;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject1 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Type");
        if(!var_void1)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void1);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    llvm::Constant* var_llvm_Constant2 = llvm::ConstantExpr::getZExt(var_llvm_Constant, var_llvm_Type);
    PyObject* var_PyObject2 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant2), "llvm::Value", "llvm::Constant");
    if (!var_PyObject2)
    {
        return NULL;
    }
    return var_PyObject2;
}

static
PyObject*
llvm_ConstantExpr__getMul(PyObject* self, PyObject* args)
{
    Py_ssize_t var_Py__ssize__t = PyTuple_Size(args);
    if (4 == var_Py__ssize__t)
    {
        PyObject* var_PyObject;
        PyObject* var_PyObject1;
        PyObject* var_PyObject2;
        PyObject* var_PyObject3;
        if(!PyArg_ParseTuple(args, "OOOO", &var_PyObject, &var_PyObject1, &var_PyObject2, &var_PyObject3))
        {
            return NULL;
        }
        llvm::Constant* var_llvm_Constant = NULL;
        if (var_PyObject != Py_None)
        {
            void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
            if(!var_void)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::Constant* var_llvm_Constant1 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void);
            if(!var_llvm_Constant1)
            {
                return NULL;
            }
            var_llvm_Constant = var_llvm_Constant1;
        }
        llvm::Constant* var_llvm_Constant2 = NULL;
        if (var_PyObject1 != Py_None)
        {
            void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Value");
            if(!var_void1)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::Constant* var_llvm_Constant3 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void1);
            if(!var_llvm_Constant3)
            {
                return NULL;
            }
            var_llvm_Constant2 = var_llvm_Constant3;
        }
        bool var_bool;
        int var_int = py_bool_to(var_PyObject2, var_bool);
        if(!var_int)
        {
            return NULL;
        }
        bool var_bool1;
        int var_int1 = py_bool_to(var_PyObject3, var_bool1);
        if(!var_int1)
        {
            return NULL;
        }
        llvm::Constant* var_llvm_Constant4 = llvm::ConstantExpr::getMul(var_llvm_Constant, var_llvm_Constant2, var_bool, var_bool1);
        PyObject* var_PyObject4 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant4), "llvm::Value", "llvm::Constant");
        if (!var_PyObject4)
        {
            return NULL;
        }
        return var_PyObject4;
    }
    if (2 == var_Py__ssize__t)
    {
        PyObject* var_PyObject5;
        PyObject* var_PyObject6;
        if(!PyArg_ParseTuple(args, "OO", &var_PyObject5, &var_PyObject6))
        {
            return NULL;
        }
        llvm::Constant* var_llvm_Constant5 = NULL;
        if (var_PyObject5 != Py_None)
        {
            void* var_void2 = PyCapsule_GetPointer(var_PyObject5, "llvm::Value");
            if(!var_void2)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::Constant* var_llvm_Constant6 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void2);
            if(!var_llvm_Constant6)
            {
                return NULL;
            }
            var_llvm_Constant5 = var_llvm_Constant6;
        }
        llvm::Constant* var_llvm_Constant7 = NULL;
        if (var_PyObject6 != Py_None)
        {
            void* var_void3 = PyCapsule_GetPointer(var_PyObject6, "llvm::Value");
            if(!var_void3)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::Constant* var_llvm_Constant8 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void3);
            if(!var_llvm_Constant8)
            {
                return NULL;
            }
            var_llvm_Constant7 = var_llvm_Constant8;
        }
        llvm::Constant* var_llvm_Constant9 = llvm::ConstantExpr::getMul(var_llvm_Constant5, var_llvm_Constant7);
        PyObject* var_PyObject7 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant9), "llvm::Value", "llvm::Constant");
        if (!var_PyObject7)
        {
            return NULL;
        }
        return var_PyObject7;
    }
    if (3 == var_Py__ssize__t)
    {
        PyObject* var_PyObject8;
        PyObject* var_PyObject9;
        PyObject* var_PyObject10;
        if(!PyArg_ParseTuple(args, "OOO", &var_PyObject8, &var_PyObject9, &var_PyObject10))
        {
            return NULL;
        }
        llvm::Constant* var_llvm_Constant10 = NULL;
        if (var_PyObject8 != Py_None)
        {
            void* var_void4 = PyCapsule_GetPointer(var_PyObject8, "llvm::Value");
            if(!var_void4)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::Constant* var_llvm_Constant11 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void4);
            if(!var_llvm_Constant11)
            {
                return NULL;
            }
            var_llvm_Constant10 = var_llvm_Constant11;
        }
        llvm::Constant* var_llvm_Constant12 = NULL;
        if (var_PyObject9 != Py_None)
        {
            void* var_void5 = PyCapsule_GetPointer(var_PyObject9, "llvm::Value");
            if(!var_void5)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::Constant* var_llvm_Constant13 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void5);
            if(!var_llvm_Constant13)
            {
                return NULL;
            }
            var_llvm_Constant12 = var_llvm_Constant13;
        }
        bool var_bool2;
        int var_int2 = py_bool_to(var_PyObject10, var_bool2);
        if(!var_int2)
        {
            return NULL;
        }
        llvm::Constant* var_llvm_Constant14 = llvm::ConstantExpr::getMul(var_llvm_Constant10, var_llvm_Constant12, var_bool2);
        PyObject* var_PyObject11 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant14), "llvm::Value", "llvm::Constant");
        if (!var_PyObject11)
        {
            return NULL;
        }
        return var_PyObject11;
    }
    PyErr_SetString(PyExc_TypeError, "Invalid number of args");
    return NULL;
}

static
PyObject*
llvm_ConstantExpr__isCompare(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::ConstantExpr* var_llvm_ConstantExpr = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::ConstantExpr* var_llvm_ConstantExpr1 = unwrap_as<llvm::ConstantExpr, llvm::Value >::from(var_void);
        if(!var_llvm_ConstantExpr1)
        {
            return NULL;
        }
        var_llvm_ConstantExpr = var_llvm_ConstantExpr1;
    }
    bool var_bool = var_llvm_ConstantExpr->isCompare();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_ConstantExpr__isGEPWithNoNotionalOverIndexing(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::ConstantExpr* var_llvm_ConstantExpr = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::ConstantExpr* var_llvm_ConstantExpr1 = unwrap_as<llvm::ConstantExpr, llvm::Value >::from(var_void);
        if(!var_llvm_ConstantExpr1)
        {
            return NULL;
        }
        var_llvm_ConstantExpr = var_llvm_ConstantExpr1;
    }
    bool var_bool = var_llvm_ConstantExpr->isGEPWithNoNotionalOverIndexing();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_ConstantExpr__getAShr(PyObject* self, PyObject* args)
{
    Py_ssize_t var_Py__ssize__t = PyTuple_Size(args);
    if (3 == var_Py__ssize__t)
    {
        PyObject* var_PyObject;
        PyObject* var_PyObject1;
        PyObject* var_PyObject2;
        if(!PyArg_ParseTuple(args, "OOO", &var_PyObject, &var_PyObject1, &var_PyObject2))
        {
            return NULL;
        }
        llvm::Constant* var_llvm_Constant = NULL;
        if (var_PyObject != Py_None)
        {
            void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
            if(!var_void)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::Constant* var_llvm_Constant1 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void);
            if(!var_llvm_Constant1)
            {
                return NULL;
            }
            var_llvm_Constant = var_llvm_Constant1;
        }
        llvm::Constant* var_llvm_Constant2 = NULL;
        if (var_PyObject1 != Py_None)
        {
            void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Value");
            if(!var_void1)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::Constant* var_llvm_Constant3 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void1);
            if(!var_llvm_Constant3)
            {
                return NULL;
            }
            var_llvm_Constant2 = var_llvm_Constant3;
        }
        bool var_bool;
        int var_int = py_bool_to(var_PyObject2, var_bool);
        if(!var_int)
        {
            return NULL;
        }
        llvm::Constant* var_llvm_Constant4 = llvm::ConstantExpr::getAShr(var_llvm_Constant, var_llvm_Constant2, var_bool);
        PyObject* var_PyObject3 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant4), "llvm::Value", "llvm::Constant");
        if (!var_PyObject3)
        {
            return NULL;
        }
        return var_PyObject3;
    }
    if (2 == var_Py__ssize__t)
    {
        PyObject* var_PyObject4;
        PyObject* var_PyObject5;
        if(!PyArg_ParseTuple(args, "OO", &var_PyObject4, &var_PyObject5))
        {
            return NULL;
        }
        llvm::Constant* var_llvm_Constant5 = NULL;
        if (var_PyObject4 != Py_None)
        {
            void* var_void2 = PyCapsule_GetPointer(var_PyObject4, "llvm::Value");
            if(!var_void2)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::Constant* var_llvm_Constant6 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void2);
            if(!var_llvm_Constant6)
            {
                return NULL;
            }
            var_llvm_Constant5 = var_llvm_Constant6;
        }
        llvm::Constant* var_llvm_Constant7 = NULL;
        if (var_PyObject5 != Py_None)
        {
            void* var_void3 = PyCapsule_GetPointer(var_PyObject5, "llvm::Value");
            if(!var_void3)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::Constant* var_llvm_Constant8 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void3);
            if(!var_llvm_Constant8)
            {
                return NULL;
            }
            var_llvm_Constant7 = var_llvm_Constant8;
        }
        llvm::Constant* var_llvm_Constant9 = llvm::ConstantExpr::getAShr(var_llvm_Constant5, var_llvm_Constant7);
        PyObject* var_PyObject6 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant9), "llvm::Value", "llvm::Constant");
        if (!var_PyObject6)
        {
            return NULL;
        }
        return var_PyObject6;
    }
    PyErr_SetString(PyExc_TypeError, "Invalid number of args");
    return NULL;
}

static
PyObject*
llvm_ConstantExpr__getFCmp(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    PyObject* var_PyObject2;
    if(!PyArg_ParseTuple(args, "OOO", &var_PyObject, &var_PyObject1, &var_PyObject2))
    {
        return NULL;
    }
    llvm::CmpInst::Predicate var_llvm_CmpInst_Predicate = (llvm::CmpInst::Predicate)PyInt_AsLong(var_PyObject);
    llvm::Constant* var_llvm_Constant = NULL;
    if (var_PyObject1 != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject1, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant1 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void);
        if(!var_llvm_Constant1)
        {
            return NULL;
        }
        var_llvm_Constant = var_llvm_Constant1;
    }
    llvm::Constant* var_llvm_Constant2 = NULL;
    if (var_PyObject2 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject2, "llvm::Value");
        if(!var_void1)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant3 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void1);
        if(!var_llvm_Constant3)
        {
            return NULL;
        }
        var_llvm_Constant2 = var_llvm_Constant3;
    }
    llvm::Constant* var_llvm_Constant4 = llvm::ConstantExpr::getFCmp(var_llvm_CmpInst_Predicate, var_llvm_Constant, var_llvm_Constant2);
    PyObject* var_PyObject3 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant4), "llvm::Value", "llvm::Constant");
    if (!var_PyObject3)
    {
        return NULL;
    }
    return var_PyObject3;
}

static
PyObject*
llvm_ConstantExpr__getAlignOf(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    llvm::Constant* var_llvm_Constant = llvm::ConstantExpr::getAlignOf(var_llvm_Type);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant), "llvm::Value", "llvm::Constant");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyObject*
llvm_ConstantExpr__getOpcodeName(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::ConstantExpr* var_llvm_ConstantExpr = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::ConstantExpr* var_llvm_ConstantExpr1 = unwrap_as<llvm::ConstantExpr, llvm::Value >::from(var_void);
        if(!var_llvm_ConstantExpr1)
        {
            return NULL;
        }
        var_llvm_ConstantExpr = var_llvm_ConstantExpr1;
    }
    const char* var_const_char = var_llvm_ConstantExpr->getOpcodeName();
    PyObject* var_PyObject1 = py_str_from(var_const_char);
    return var_PyObject1;
}

static
PyObject*
llvm_ConstantExpr__getLShr(PyObject* self, PyObject* args)
{
    Py_ssize_t var_Py__ssize__t = PyTuple_Size(args);
    if (3 == var_Py__ssize__t)
    {
        PyObject* var_PyObject;
        PyObject* var_PyObject1;
        PyObject* var_PyObject2;
        if(!PyArg_ParseTuple(args, "OOO", &var_PyObject, &var_PyObject1, &var_PyObject2))
        {
            return NULL;
        }
        llvm::Constant* var_llvm_Constant = NULL;
        if (var_PyObject != Py_None)
        {
            void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
            if(!var_void)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::Constant* var_llvm_Constant1 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void);
            if(!var_llvm_Constant1)
            {
                return NULL;
            }
            var_llvm_Constant = var_llvm_Constant1;
        }
        llvm::Constant* var_llvm_Constant2 = NULL;
        if (var_PyObject1 != Py_None)
        {
            void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Value");
            if(!var_void1)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::Constant* var_llvm_Constant3 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void1);
            if(!var_llvm_Constant3)
            {
                return NULL;
            }
            var_llvm_Constant2 = var_llvm_Constant3;
        }
        bool var_bool;
        int var_int = py_bool_to(var_PyObject2, var_bool);
        if(!var_int)
        {
            return NULL;
        }
        llvm::Constant* var_llvm_Constant4 = llvm::ConstantExpr::getLShr(var_llvm_Constant, var_llvm_Constant2, var_bool);
        PyObject* var_PyObject3 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant4), "llvm::Value", "llvm::Constant");
        if (!var_PyObject3)
        {
            return NULL;
        }
        return var_PyObject3;
    }
    if (2 == var_Py__ssize__t)
    {
        PyObject* var_PyObject4;
        PyObject* var_PyObject5;
        if(!PyArg_ParseTuple(args, "OO", &var_PyObject4, &var_PyObject5))
        {
            return NULL;
        }
        llvm::Constant* var_llvm_Constant5 = NULL;
        if (var_PyObject4 != Py_None)
        {
            void* var_void2 = PyCapsule_GetPointer(var_PyObject4, "llvm::Value");
            if(!var_void2)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::Constant* var_llvm_Constant6 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void2);
            if(!var_llvm_Constant6)
            {
                return NULL;
            }
            var_llvm_Constant5 = var_llvm_Constant6;
        }
        llvm::Constant* var_llvm_Constant7 = NULL;
        if (var_PyObject5 != Py_None)
        {
            void* var_void3 = PyCapsule_GetPointer(var_PyObject5, "llvm::Value");
            if(!var_void3)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::Constant* var_llvm_Constant8 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void3);
            if(!var_llvm_Constant8)
            {
                return NULL;
            }
            var_llvm_Constant7 = var_llvm_Constant8;
        }
        llvm::Constant* var_llvm_Constant9 = llvm::ConstantExpr::getLShr(var_llvm_Constant5, var_llvm_Constant7);
        PyObject* var_PyObject6 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant9), "llvm::Value", "llvm::Constant");
        if (!var_PyObject6)
        {
            return NULL;
        }
        return var_PyObject6;
    }
    PyErr_SetString(PyExc_TypeError, "Invalid number of args");
    return NULL;
}

static
PyObject*
llvm_ConstantExpr__getSizeOf(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    llvm::Constant* var_llvm_Constant = llvm::ConstantExpr::getSizeOf(var_llvm_Type);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant), "llvm::Value", "llvm::Constant");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyObject*
llvm_ConstantExpr__isCast(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::ConstantExpr* var_llvm_ConstantExpr = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::ConstantExpr* var_llvm_ConstantExpr1 = unwrap_as<llvm::ConstantExpr, llvm::Value >::from(var_void);
        if(!var_llvm_ConstantExpr1)
        {
            return NULL;
        }
        var_llvm_ConstantExpr = var_llvm_ConstantExpr1;
    }
    bool var_bool = var_llvm_ConstantExpr->isCast();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_ConstantExpr__getSRem(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::Constant* var_llvm_Constant = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant1 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void);
        if(!var_llvm_Constant1)
        {
            return NULL;
        }
        var_llvm_Constant = var_llvm_Constant1;
    }
    llvm::Constant* var_llvm_Constant2 = NULL;
    if (var_PyObject1 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Value");
        if(!var_void1)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant3 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void1);
        if(!var_llvm_Constant3)
        {
            return NULL;
        }
        var_llvm_Constant2 = var_llvm_Constant3;
    }
    llvm::Constant* var_llvm_Constant4 = llvm::ConstantExpr::getSRem(var_llvm_Constant, var_llvm_Constant2);
    PyObject* var_PyObject2 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant4), "llvm::Value", "llvm::Constant");
    if (!var_PyObject2)
    {
        return NULL;
    }
    return var_PyObject2;
}

static
PyObject*
llvm_ConstantExpr__getIntegerCast(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    PyObject* var_PyObject2;
    if(!PyArg_ParseTuple(args, "OOO", &var_PyObject, &var_PyObject1, &var_PyObject2))
    {
        return NULL;
    }
    llvm::Constant* var_llvm_Constant = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant1 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void);
        if(!var_llvm_Constant1)
        {
            return NULL;
        }
        var_llvm_Constant = var_llvm_Constant1;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject1 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Type");
        if(!var_void1)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void1);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    bool var_bool;
    int var_int = py_bool_to(var_PyObject2, var_bool);
    if(!var_int)
    {
        return NULL;
    }
    llvm::Constant* var_llvm_Constant2 = llvm::ConstantExpr::getIntegerCast(var_llvm_Constant, var_llvm_Type, var_bool);
    PyObject* var_PyObject3 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant2), "llvm::Value", "llvm::Constant");
    if (!var_PyObject3)
    {
        return NULL;
    }
    return var_PyObject3;
}

static
PyObject*
llvm_ConstantExpr__getFDiv(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::Constant* var_llvm_Constant = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant1 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void);
        if(!var_llvm_Constant1)
        {
            return NULL;
        }
        var_llvm_Constant = var_llvm_Constant1;
    }
    llvm::Constant* var_llvm_Constant2 = NULL;
    if (var_PyObject1 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Value");
        if(!var_void1)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant3 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void1);
        if(!var_llvm_Constant3)
        {
            return NULL;
        }
        var_llvm_Constant2 = var_llvm_Constant3;
    }
    llvm::Constant* var_llvm_Constant4 = llvm::ConstantExpr::getFDiv(var_llvm_Constant, var_llvm_Constant2);
    PyObject* var_PyObject2 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant4), "llvm::Value", "llvm::Constant");
    if (!var_PyObject2)
    {
        return NULL;
    }
    return var_PyObject2;
}

static
PyObject*
llvm_ConstantExpr__getOffsetOf(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    llvm::Constant* var_llvm_Constant = NULL;
    if (var_PyObject1 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Value");
        if(!var_void1)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant1 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void1);
        if(!var_llvm_Constant1)
        {
            return NULL;
        }
        var_llvm_Constant = var_llvm_Constant1;
    }
    llvm::Constant* var_llvm_Constant2 = llvm::ConstantExpr::getOffsetOf(var_llvm_Type, var_llvm_Constant);
    PyObject* var_PyObject2 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant2), "llvm::Value", "llvm::Constant");
    if (!var_PyObject2)
    {
        return NULL;
    }
    return var_PyObject2;
}

static
PyObject*
llvm_ConstantExpr__getIntToPtr(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::Constant* var_llvm_Constant = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant1 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void);
        if(!var_llvm_Constant1)
        {
            return NULL;
        }
        var_llvm_Constant = var_llvm_Constant1;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject1 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Type");
        if(!var_void1)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void1);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    llvm::Constant* var_llvm_Constant2 = llvm::ConstantExpr::getIntToPtr(var_llvm_Constant, var_llvm_Type);
    PyObject* var_PyObject2 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant2), "llvm::Value", "llvm::Constant");
    if (!var_PyObject2)
    {
        return NULL;
    }
    return var_PyObject2;
}

static
PyObject*
llvm_ConstantExpr__getICmp(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    PyObject* var_PyObject2;
    if(!PyArg_ParseTuple(args, "OOO", &var_PyObject, &var_PyObject1, &var_PyObject2))
    {
        return NULL;
    }
    llvm::CmpInst::Predicate var_llvm_CmpInst_Predicate = (llvm::CmpInst::Predicate)PyInt_AsLong(var_PyObject);
    llvm::Constant* var_llvm_Constant = NULL;
    if (var_PyObject1 != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject1, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant1 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void);
        if(!var_llvm_Constant1)
        {
            return NULL;
        }
        var_llvm_Constant = var_llvm_Constant1;
    }
    llvm::Constant* var_llvm_Constant2 = NULL;
    if (var_PyObject2 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject2, "llvm::Value");
        if(!var_void1)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant3 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void1);
        if(!var_llvm_Constant3)
        {
            return NULL;
        }
        var_llvm_Constant2 = var_llvm_Constant3;
    }
    llvm::Constant* var_llvm_Constant4 = llvm::ConstantExpr::getICmp(var_llvm_CmpInst_Predicate, var_llvm_Constant, var_llvm_Constant2);
    PyObject* var_PyObject3 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant4), "llvm::Value", "llvm::Constant");
    if (!var_PyObject3)
    {
        return NULL;
    }
    return var_PyObject3;
}

static
PyObject*
llvm_ConstantExpr__getShuffleVector(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    PyObject* var_PyObject2;
    if(!PyArg_ParseTuple(args, "OOO", &var_PyObject, &var_PyObject1, &var_PyObject2))
    {
        return NULL;
    }
    llvm::Constant* var_llvm_Constant = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant1 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void);
        if(!var_llvm_Constant1)
        {
            return NULL;
        }
        var_llvm_Constant = var_llvm_Constant1;
    }
    llvm::Constant* var_llvm_Constant2 = NULL;
    if (var_PyObject1 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Value");
        if(!var_void1)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant3 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void1);
        if(!var_llvm_Constant3)
        {
            return NULL;
        }
        var_llvm_Constant2 = var_llvm_Constant3;
    }
    llvm::Constant* var_llvm_Constant4 = NULL;
    if (var_PyObject2 != Py_None)
    {
        void* var_void2 = PyCapsule_GetPointer(var_PyObject2, "llvm::Value");
        if(!var_void2)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant5 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void2);
        if(!var_llvm_Constant5)
        {
            return NULL;
        }
        var_llvm_Constant4 = var_llvm_Constant5;
    }
    llvm::Constant* var_llvm_Constant6 = llvm::ConstantExpr::getShuffleVector(var_llvm_Constant, var_llvm_Constant2, var_llvm_Constant4);
    PyObject* var_PyObject3 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant6), "llvm::Value", "llvm::Constant");
    if (!var_PyObject3)
    {
        return NULL;
    }
    return var_PyObject3;
}

static
PyObject*
llvm_ConstantExpr__getCompare(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    PyObject* var_PyObject2;
    if(!PyArg_ParseTuple(args, "OOO", &var_PyObject, &var_PyObject1, &var_PyObject2))
    {
        return NULL;
    }
    llvm::CmpInst::Predicate var_llvm_CmpInst_Predicate = (llvm::CmpInst::Predicate)PyInt_AsLong(var_PyObject);
    llvm::Constant* var_llvm_Constant = NULL;
    if (var_PyObject1 != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject1, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant1 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void);
        if(!var_llvm_Constant1)
        {
            return NULL;
        }
        var_llvm_Constant = var_llvm_Constant1;
    }
    llvm::Constant* var_llvm_Constant2 = NULL;
    if (var_PyObject2 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject2, "llvm::Value");
        if(!var_void1)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant3 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void1);
        if(!var_llvm_Constant3)
        {
            return NULL;
        }
        var_llvm_Constant2 = var_llvm_Constant3;
    }
    llvm::Constant* var_llvm_Constant4 = llvm::ConstantExpr::getCompare(var_llvm_CmpInst_Predicate, var_llvm_Constant, var_llvm_Constant2);
    PyObject* var_PyObject3 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant4), "llvm::Value", "llvm::Constant");
    if (!var_PyObject3)
    {
        return NULL;
    }
    return var_PyObject3;
}

static
PyObject*
llvm_ConstantExpr____getInsertValue(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    PyObject* var_PyObject2;
    if(!PyArg_ParseTuple(args, "OOO", &var_PyObject, &var_PyObject1, &var_PyObject2))
    {
        return NULL;
    }
    llvm::Constant* var_llvm_Constant = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant1 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void);
        if(!var_llvm_Constant1)
        {
            return NULL;
        }
        var_llvm_Constant = var_llvm_Constant1;
    }
    llvm::Constant* var_llvm_Constant2 = NULL;
    if (var_PyObject1 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Value");
        if(!var_void1)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant3 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void1);
        if(!var_llvm_Constant3)
        {
            return NULL;
        }
        var_llvm_Constant2 = var_llvm_Constant3;
    }
    void* var_void2 = PyCapsule_GetPointer(var_PyObject2, "llvm::SmallVector<unsigned,8>");
    if(!var_void2)
    {
        puts("Error: llvm::SmallVector<unsigned,8>");
        return NULL;
    }
    llvm::SmallVector<unsigned,8>* var_llvm_SmallVectorunsigned_8 = unwrap_as<llvm::SmallVector<unsigned,8>, llvm::SmallVector<unsigned,8> >::from(var_void2);
    if(!var_llvm_SmallVectorunsigned_8)
    {
        return NULL;
    }
    llvm::SmallVector<unsigned,8>& var_llvm_SmallVectorunsigned_81 = *var_llvm_SmallVectorunsigned_8;
    llvm::Constant* var_llvm_Constant4 = llvm::ConstantExpr::getInsertValue(var_llvm_Constant, var_llvm_Constant2, var_llvm_SmallVectorunsigned_81);
    PyObject* var_PyObject3 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant4), "llvm::Value", "llvm::Constant");
    if (!var_PyObject3)
    {
        return NULL;
    }
    return var_PyObject3;
}

static
PyObject*
llvm_ConstantExpr____getGEP(PyObject* self, PyObject* args)
{
    Py_ssize_t var_Py__ssize__t = PyTuple_Size(args);
    if (3 == var_Py__ssize__t)
    {
        PyObject* var_PyObject;
        PyObject* var_PyObject1;
        PyObject* var_PyObject2;
        if(!PyArg_ParseTuple(args, "OOO", &var_PyObject, &var_PyObject1, &var_PyObject2))
        {
            return NULL;
        }
        llvm::Constant* var_llvm_Constant = NULL;
        if (var_PyObject != Py_None)
        {
            void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
            if(!var_void)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::Constant* var_llvm_Constant1 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void);
            if(!var_llvm_Constant1)
            {
                return NULL;
            }
            var_llvm_Constant = var_llvm_Constant1;
        }
        void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::SmallVector<llvm::Value*,8>");
        if(!var_void1)
        {
            puts("Error: llvm::SmallVector<llvm::Value*,8>");
            return NULL;
        }
        llvm::SmallVector<llvm::Value*,8>* var_llvm_SmallVectorllvm_Value_8 = unwrap_as<llvm::SmallVector<llvm::Value*,8>, llvm::SmallVector<llvm::Value*,8> >::from(var_void1);
        if(!var_llvm_SmallVectorllvm_Value_8)
        {
            return NULL;
        }
        llvm::SmallVector<llvm::Value*,8>& var_llvm_SmallVectorllvm_Value_81 = *var_llvm_SmallVectorllvm_Value_8;
        bool var_bool;
        int var_int = py_bool_to(var_PyObject2, var_bool);
        if(!var_int)
        {
            return NULL;
        }
        llvm::Constant* var_llvm_Constant2 = llvm::ConstantExpr::getGetElementPtr(var_llvm_Constant, var_llvm_SmallVectorllvm_Value_81, var_bool);
        PyObject* var_PyObject3 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant2), "llvm::Value", "llvm::Constant");
        if (!var_PyObject3)
        {
            return NULL;
        }
        return var_PyObject3;
    }
    if (2 == var_Py__ssize__t)
    {
        PyObject* var_PyObject4;
        PyObject* var_PyObject5;
        if(!PyArg_ParseTuple(args, "OO", &var_PyObject4, &var_PyObject5))
        {
            return NULL;
        }
        llvm::Constant* var_llvm_Constant3 = NULL;
        if (var_PyObject4 != Py_None)
        {
            void* var_void2 = PyCapsule_GetPointer(var_PyObject4, "llvm::Value");
            if(!var_void2)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::Constant* var_llvm_Constant4 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void2);
            if(!var_llvm_Constant4)
            {
                return NULL;
            }
            var_llvm_Constant3 = var_llvm_Constant4;
        }
        void* var_void3 = PyCapsule_GetPointer(var_PyObject5, "llvm::SmallVector<llvm::Value*,8>");
        if(!var_void3)
        {
            puts("Error: llvm::SmallVector<llvm::Value*,8>");
            return NULL;
        }
        llvm::SmallVector<llvm::Value*,8>* var_llvm_SmallVectorllvm_Value_82 = unwrap_as<llvm::SmallVector<llvm::Value*,8>, llvm::SmallVector<llvm::Value*,8> >::from(var_void3);
        if(!var_llvm_SmallVectorllvm_Value_82)
        {
            return NULL;
        }
        llvm::SmallVector<llvm::Value*,8>& var_llvm_SmallVectorllvm_Value_83 = *var_llvm_SmallVectorllvm_Value_82;
        llvm::Constant* var_llvm_Constant5 = llvm::ConstantExpr::getGetElementPtr(var_llvm_Constant3, var_llvm_SmallVectorllvm_Value_83);
        PyObject* var_PyObject6 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant5), "llvm::Value", "llvm::Constant");
        if (!var_PyObject6)
        {
            return NULL;
        }
        return var_PyObject6;
    }
    PyErr_SetString(PyExc_TypeError, "Invalid number of args");
    return NULL;
}

static
PyObject*
llvm_ConstantExpr__getPtrToInt(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::Constant* var_llvm_Constant = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant1 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void);
        if(!var_llvm_Constant1)
        {
            return NULL;
        }
        var_llvm_Constant = var_llvm_Constant1;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject1 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Type");
        if(!var_void1)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void1);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    llvm::Constant* var_llvm_Constant2 = llvm::ConstantExpr::getPtrToInt(var_llvm_Constant, var_llvm_Type);
    PyObject* var_PyObject2 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant2), "llvm::Value", "llvm::Constant");
    if (!var_PyObject2)
    {
        return NULL;
    }
    return var_PyObject2;
}

static
PyObject*
llvm_ConstantExpr__hasIndices(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::ConstantExpr* var_llvm_ConstantExpr = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::ConstantExpr* var_llvm_ConstantExpr1 = unwrap_as<llvm::ConstantExpr, llvm::Value >::from(var_void);
        if(!var_llvm_ConstantExpr1)
        {
            return NULL;
        }
        var_llvm_ConstantExpr = var_llvm_ConstantExpr1;
    }
    bool var_bool = var_llvm_ConstantExpr->hasIndices();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_ConstantExpr__getFMul(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::Constant* var_llvm_Constant = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant1 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void);
        if(!var_llvm_Constant1)
        {
            return NULL;
        }
        var_llvm_Constant = var_llvm_Constant1;
    }
    llvm::Constant* var_llvm_Constant2 = NULL;
    if (var_PyObject1 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Value");
        if(!var_void1)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant3 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void1);
        if(!var_llvm_Constant3)
        {
            return NULL;
        }
        var_llvm_Constant2 = var_llvm_Constant3;
    }
    llvm::Constant* var_llvm_Constant4 = llvm::ConstantExpr::getFMul(var_llvm_Constant, var_llvm_Constant2);
    PyObject* var_PyObject2 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant4), "llvm::Value", "llvm::Constant");
    if (!var_PyObject2)
    {
        return NULL;
    }
    return var_PyObject2;
}

static
PyObject*
llvm_ConstantExpr__getPointerCast(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::Constant* var_llvm_Constant = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant1 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void);
        if(!var_llvm_Constant1)
        {
            return NULL;
        }
        var_llvm_Constant = var_llvm_Constant1;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject1 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Type");
        if(!var_void1)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void1);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    llvm::Constant* var_llvm_Constant2 = llvm::ConstantExpr::getPointerCast(var_llvm_Constant, var_llvm_Type);
    PyObject* var_PyObject2 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant2), "llvm::Value", "llvm::Constant");
    if (!var_PyObject2)
    {
        return NULL;
    }
    return var_PyObject2;
}

static
PyObject*
llvm_ConstantExpr__getFPTrunc(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::Constant* var_llvm_Constant = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant1 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void);
        if(!var_llvm_Constant1)
        {
            return NULL;
        }
        var_llvm_Constant = var_llvm_Constant1;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject1 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Type");
        if(!var_void1)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void1);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    llvm::Constant* var_llvm_Constant2 = llvm::ConstantExpr::getFPTrunc(var_llvm_Constant, var_llvm_Type);
    PyObject* var_PyObject2 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant2), "llvm::Value", "llvm::Constant");
    if (!var_PyObject2)
    {
        return NULL;
    }
    return var_PyObject2;
}

static
PyObject*
llvm_ConstantExpr__getSExt(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::Constant* var_llvm_Constant = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant1 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void);
        if(!var_llvm_Constant1)
        {
            return NULL;
        }
        var_llvm_Constant = var_llvm_Constant1;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject1 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Type");
        if(!var_void1)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void1);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    llvm::Constant* var_llvm_Constant2 = llvm::ConstantExpr::getSExt(var_llvm_Constant, var_llvm_Type);
    PyObject* var_PyObject2 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant2), "llvm::Value", "llvm::Constant");
    if (!var_PyObject2)
    {
        return NULL;
    }
    return var_PyObject2;
}

static
PyObject*
llvm_ConstantExpr__getInsertElement(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    PyObject* var_PyObject2;
    if(!PyArg_ParseTuple(args, "OOO", &var_PyObject, &var_PyObject1, &var_PyObject2))
    {
        return NULL;
    }
    llvm::Constant* var_llvm_Constant = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant1 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void);
        if(!var_llvm_Constant1)
        {
            return NULL;
        }
        var_llvm_Constant = var_llvm_Constant1;
    }
    llvm::Constant* var_llvm_Constant2 = NULL;
    if (var_PyObject1 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Value");
        if(!var_void1)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant3 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void1);
        if(!var_llvm_Constant3)
        {
            return NULL;
        }
        var_llvm_Constant2 = var_llvm_Constant3;
    }
    llvm::Constant* var_llvm_Constant4 = NULL;
    if (var_PyObject2 != Py_None)
    {
        void* var_void2 = PyCapsule_GetPointer(var_PyObject2, "llvm::Value");
        if(!var_void2)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant5 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void2);
        if(!var_llvm_Constant5)
        {
            return NULL;
        }
        var_llvm_Constant4 = var_llvm_Constant5;
    }
    llvm::Constant* var_llvm_Constant6 = llvm::ConstantExpr::getInsertElement(var_llvm_Constant, var_llvm_Constant2, var_llvm_Constant4);
    PyObject* var_PyObject3 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant6), "llvm::Value", "llvm::Constant");
    if (!var_PyObject3)
    {
        return NULL;
    }
    return var_PyObject3;
}

static
PyObject*
llvm_ConstantExpr__getAnd(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::Constant* var_llvm_Constant = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant1 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void);
        if(!var_llvm_Constant1)
        {
            return NULL;
        }
        var_llvm_Constant = var_llvm_Constant1;
    }
    llvm::Constant* var_llvm_Constant2 = NULL;
    if (var_PyObject1 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Value");
        if(!var_void1)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant3 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void1);
        if(!var_llvm_Constant3)
        {
            return NULL;
        }
        var_llvm_Constant2 = var_llvm_Constant3;
    }
    llvm::Constant* var_llvm_Constant4 = llvm::ConstantExpr::getAnd(var_llvm_Constant, var_llvm_Constant2);
    PyObject* var_PyObject2 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant4), "llvm::Value", "llvm::Constant");
    if (!var_PyObject2)
    {
        return NULL;
    }
    return var_PyObject2;
}

static
PyObject*
llvm_ConstantExpr__getSelect(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    PyObject* var_PyObject2;
    if(!PyArg_ParseTuple(args, "OOO", &var_PyObject, &var_PyObject1, &var_PyObject2))
    {
        return NULL;
    }
    llvm::Constant* var_llvm_Constant = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant1 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void);
        if(!var_llvm_Constant1)
        {
            return NULL;
        }
        var_llvm_Constant = var_llvm_Constant1;
    }
    llvm::Constant* var_llvm_Constant2 = NULL;
    if (var_PyObject1 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Value");
        if(!var_void1)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant3 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void1);
        if(!var_llvm_Constant3)
        {
            return NULL;
        }
        var_llvm_Constant2 = var_llvm_Constant3;
    }
    llvm::Constant* var_llvm_Constant4 = NULL;
    if (var_PyObject2 != Py_None)
    {
        void* var_void2 = PyCapsule_GetPointer(var_PyObject2, "llvm::Value");
        if(!var_void2)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant5 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void2);
        if(!var_llvm_Constant5)
        {
            return NULL;
        }
        var_llvm_Constant4 = var_llvm_Constant5;
    }
    llvm::Constant* var_llvm_Constant6 = llvm::ConstantExpr::getSelect(var_llvm_Constant, var_llvm_Constant2, var_llvm_Constant4);
    PyObject* var_PyObject3 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant6), "llvm::Value", "llvm::Constant");
    if (!var_PyObject3)
    {
        return NULL;
    }
    return var_PyObject3;
}

static
PyMethodDef meth_llvm_ConstantExpr[] = {
    { "getTrunc", (PyCFunction)llvm_ConstantExpr__getTrunc, METH_VARARGS, NULL },
    { "getFNeg", (PyCFunction)llvm_ConstantExpr__getFNeg, METH_VARARGS, NULL },
    { "getURem", (PyCFunction)llvm_ConstantExpr__getURem, METH_VARARGS, NULL },
    { "getFPExtend", (PyCFunction)llvm_ConstantExpr__getFPExtend, METH_VARARGS, NULL },
    { "getOr", (PyCFunction)llvm_ConstantExpr__getOr, METH_VARARGS, NULL },
    { "getExtractElement", (PyCFunction)llvm_ConstantExpr__getExtractElement, METH_VARARGS, NULL },
    { "getSDiv", (PyCFunction)llvm_ConstantExpr__getSDiv, METH_VARARGS, NULL },
    { "getSIToFP", (PyCFunction)llvm_ConstantExpr__getSIToFP, METH_VARARGS, NULL },
    { "getXor", (PyCFunction)llvm_ConstantExpr__getXor, METH_VARARGS, NULL },
    { "getFPToSI", (PyCFunction)llvm_ConstantExpr__getFPToSI, METH_VARARGS, NULL },
    { "getFPCast", (PyCFunction)llvm_ConstantExpr__getFPCast, METH_VARARGS, NULL },
    { "getUIToFP", (PyCFunction)llvm_ConstantExpr__getUIToFP, METH_VARARGS, NULL },
    { "getAdd", (PyCFunction)llvm_ConstantExpr__getAdd, METH_VARARGS, NULL },
    { "getBitCast", (PyCFunction)llvm_ConstantExpr__getBitCast, METH_VARARGS, NULL },
    { "getFRem", (PyCFunction)llvm_ConstantExpr__getFRem, METH_VARARGS, NULL },
    { "getFSub", (PyCFunction)llvm_ConstantExpr__getFSub, METH_VARARGS, NULL },
    { "getUDiv", (PyCFunction)llvm_ConstantExpr__getUDiv, METH_VARARGS, NULL },
    { "getFPToUI", (PyCFunction)llvm_ConstantExpr__getFPToUI, METH_VARARGS, NULL },
    { "getNeg", (PyCFunction)llvm_ConstantExpr__getNeg, METH_VARARGS, NULL },
    { "getNot", (PyCFunction)llvm_ConstantExpr__getNot, METH_VARARGS, NULL },
    { "getOpcode", (PyCFunction)llvm_ConstantExpr__getOpcode, METH_VARARGS, NULL },
    { "getSub", (PyCFunction)llvm_ConstantExpr__getSub, METH_VARARGS, NULL },
    { "_getExtractValue", (PyCFunction)llvm_ConstantExpr____getExtractValue, METH_VARARGS, NULL },
    { "getFAdd", (PyCFunction)llvm_ConstantExpr__getFAdd, METH_VARARGS, NULL },
    { "getShl", (PyCFunction)llvm_ConstantExpr__getShl, METH_VARARGS, NULL },
    { "getZExt", (PyCFunction)llvm_ConstantExpr__getZExt, METH_VARARGS, NULL },
    { "getMul", (PyCFunction)llvm_ConstantExpr__getMul, METH_VARARGS, NULL },
    { "isCompare", (PyCFunction)llvm_ConstantExpr__isCompare, METH_VARARGS, NULL },
    { "isGEPWithNoNotionalOverIndexing", (PyCFunction)llvm_ConstantExpr__isGEPWithNoNotionalOverIndexing, METH_VARARGS, NULL },
    { "getAShr", (PyCFunction)llvm_ConstantExpr__getAShr, METH_VARARGS, NULL },
    { "getFCmp", (PyCFunction)llvm_ConstantExpr__getFCmp, METH_VARARGS, NULL },
    { "getAlignOf", (PyCFunction)llvm_ConstantExpr__getAlignOf, METH_VARARGS, NULL },
    { "getOpcodeName", (PyCFunction)llvm_ConstantExpr__getOpcodeName, METH_VARARGS, NULL },
    { "getLShr", (PyCFunction)llvm_ConstantExpr__getLShr, METH_VARARGS, NULL },
    { "getSizeOf", (PyCFunction)llvm_ConstantExpr__getSizeOf, METH_VARARGS, NULL },
    { "isCast", (PyCFunction)llvm_ConstantExpr__isCast, METH_VARARGS, NULL },
    { "getSRem", (PyCFunction)llvm_ConstantExpr__getSRem, METH_VARARGS, NULL },
    { "getIntegerCast", (PyCFunction)llvm_ConstantExpr__getIntegerCast, METH_VARARGS, NULL },
    { "getFDiv", (PyCFunction)llvm_ConstantExpr__getFDiv, METH_VARARGS, NULL },
    { "getOffsetOf", (PyCFunction)llvm_ConstantExpr__getOffsetOf, METH_VARARGS, NULL },
    { "getIntToPtr", (PyCFunction)llvm_ConstantExpr__getIntToPtr, METH_VARARGS, NULL },
    { "getICmp", (PyCFunction)llvm_ConstantExpr__getICmp, METH_VARARGS, NULL },
    { "getShuffleVector", (PyCFunction)llvm_ConstantExpr__getShuffleVector, METH_VARARGS, NULL },
    { "getCompare", (PyCFunction)llvm_ConstantExpr__getCompare, METH_VARARGS, NULL },
    { "_getInsertValue", (PyCFunction)llvm_ConstantExpr____getInsertValue, METH_VARARGS, NULL },
    { "_getGEP", (PyCFunction)llvm_ConstantExpr____getGEP, METH_VARARGS, NULL },
    { "getPtrToInt", (PyCFunction)llvm_ConstantExpr__getPtrToInt, METH_VARARGS, NULL },
    { "hasIndices", (PyCFunction)llvm_ConstantExpr__hasIndices, METH_VARARGS, NULL },
    { "getFMul", (PyCFunction)llvm_ConstantExpr__getFMul, METH_VARARGS, NULL },
    { "getPointerCast", (PyCFunction)llvm_ConstantExpr__getPointerCast, METH_VARARGS, NULL },
    { "getFPTrunc", (PyCFunction)llvm_ConstantExpr__getFPTrunc, METH_VARARGS, NULL },
    { "getSExt", (PyCFunction)llvm_ConstantExpr__getSExt, METH_VARARGS, NULL },
    { "getInsertElement", (PyCFunction)llvm_ConstantExpr__getInsertElement, METH_VARARGS, NULL },
    { "getAnd", (PyCFunction)llvm_ConstantExpr__getAnd, METH_VARARGS, NULL },
    { "getSelect", (PyCFunction)llvm_ConstantExpr__getSelect, METH_VARARGS, NULL },
    { NULL },
};

static
SubModuleEntry submodule_llvm_ConstantExpr[] = {
    { NULL }
};

static
PyObject*
llvm_raw__ostream__flush(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::raw_ostream* var_llvm_raw__ostream = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::raw_ostream");
        if(!var_void)
        {
            puts("Error: llvm::raw_ostream");
            return NULL;
        }
        llvm::raw_ostream* var_llvm_raw__ostream1 = unwrap_as<llvm::raw_ostream, llvm::raw_ostream >::from(var_void);
        if(!var_llvm_raw__ostream1)
        {
            return NULL;
        }
        var_llvm_raw__ostream = var_llvm_raw__ostream1;
    }
    var_llvm_raw__ostream->flush();
    Py_RETURN_NONE;
}

static
PyObject*
llvm_raw__ostream__delete(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::raw_ostream* var_llvm_raw__ostream = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::raw_ostream");
        if(!var_void)
        {
            puts("Error: llvm::raw_ostream");
            return NULL;
        }
        llvm::raw_ostream* var_llvm_raw__ostream1 = unwrap_as<llvm::raw_ostream, llvm::raw_ostream >::from(var_void);
        if(!var_llvm_raw__ostream1)
        {
            return NULL;
        }
        var_llvm_raw__ostream = var_llvm_raw__ostream1;
    }
    delete var_llvm_raw__ostream;
    Py_RETURN_NONE;
}

static
PyMethodDef meth_llvm_raw__ostream[] = {
    { "flush", (PyCFunction)llvm_raw__ostream__flush, METH_VARARGS, NULL },
    { "delete", (PyCFunction)llvm_raw__ostream__delete, METH_VARARGS, NULL },
    { NULL },
};

static
SubModuleEntry submodule_llvm_raw__ostream[] = {
    { NULL }
};

static
PyObject*
llvm_raw__svector__ostream__bytes(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::raw_svector_ostream* var_llvm_raw__svector__ostream = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::raw_ostream");
        if(!var_void)
        {
            puts("Error: llvm::raw_ostream");
            return NULL;
        }
        llvm::raw_svector_ostream* var_llvm_raw__svector__ostream1 = unwrap_as<llvm::raw_svector_ostream, llvm::raw_ostream >::from(var_void);
        if(!var_llvm_raw__svector__ostream1)
        {
            return NULL;
        }
        var_llvm_raw__svector__ostream = var_llvm_raw__svector__ostream1;
    }
    llvm::StringRef var_llvm_StringRef = var_llvm_raw__svector__ostream->str();
    PyObject* var_PyObject1 = py_bytes_from(var_llvm_StringRef);
    return var_PyObject1;
}

static
PyObject*
llvm_raw__svector__ostream__str(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::raw_svector_ostream* var_llvm_raw__svector__ostream = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::raw_ostream");
        if(!var_void)
        {
            puts("Error: llvm::raw_ostream");
            return NULL;
        }
        llvm::raw_svector_ostream* var_llvm_raw__svector__ostream1 = unwrap_as<llvm::raw_svector_ostream, llvm::raw_ostream >::from(var_void);
        if(!var_llvm_raw__svector__ostream1)
        {
            return NULL;
        }
        var_llvm_raw__svector__ostream = var_llvm_raw__svector__ostream1;
    }
    llvm::StringRef var_llvm_StringRef = var_llvm_raw__svector__ostream->str();
    PyObject* var_PyObject1 = py_str_from(var_llvm_StringRef);
    return var_PyObject1;
}

static
PyMethodDef meth_llvm_raw__svector__ostream[] = {
    { "bytes", (PyCFunction)llvm_raw__svector__ostream__bytes, METH_VARARGS, NULL },
    { "str", (PyCFunction)llvm_raw__svector__ostream__str, METH_VARARGS, NULL },
    { NULL },
};

static
SubModuleEntry submodule_llvm_raw__svector__ostream[] = {
    { NULL }
};

static
PyObject*
llvm_formatted__raw__ostream____new(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::raw_ostream");
    if(!var_void)
    {
        puts("Error: llvm::raw_ostream");
        return NULL;
    }
    llvm::raw_ostream* var_llvm_raw__ostream = unwrap_as<llvm::raw_ostream, llvm::raw_ostream >::from(var_void);
    if(!var_llvm_raw__ostream)
    {
        return NULL;
    }
    llvm::raw_ostream& var_llvm_raw__ostream1 = *var_llvm_raw__ostream;
    bool var_bool;
    int var_int = py_bool_to(var_PyObject1, var_bool);
    if(!var_int)
    {
        return NULL;
    }
    llvm::formatted_raw_ostream* var_llvm_formatted__raw__ostream = new llvm::formatted_raw_ostream(var_llvm_raw__ostream1, var_bool);
    PyObject* var_PyObject2 = pycapsule_new(cast_to_base<llvm::raw_ostream >::from(var_llvm_formatted__raw__ostream), "llvm::raw_ostream", "llvm::formatted_raw_ostream");
    if (!var_PyObject2)
    {
        return NULL;
    }
    return var_PyObject2;
}

static
PyMethodDef meth_llvm_formatted__raw__ostream[] = {
    { "_new", (PyCFunction)llvm_formatted__raw__ostream____new, METH_VARARGS, NULL },
    { NULL },
};

static
SubModuleEntry submodule_llvm_formatted__raw__ostream[] = {
    { NULL }
};

static
PyObject*
llvm_SMDiagnostic__delete(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::SMDiagnostic* var_llvm_SMDiagnostic = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::SMDiagnostic");
        if(!var_void)
        {
            puts("Error: llvm::SMDiagnostic");
            return NULL;
        }
        llvm::SMDiagnostic* var_llvm_SMDiagnostic1 = unwrap_as<llvm::SMDiagnostic, llvm::SMDiagnostic >::from(var_void);
        if(!var_llvm_SMDiagnostic1)
        {
            return NULL;
        }
        var_llvm_SMDiagnostic = var_llvm_SMDiagnostic1;
    }
    delete var_llvm_SMDiagnostic;
    Py_RETURN_NONE;
}

static
PyObject*
llvm_SMDiagnostic__new(PyObject* self, PyObject* args)
{
    if(!PyArg_ParseTuple(args, ""))
    {
        return NULL;
    }
    llvm::SMDiagnostic* var_llvm_SMDiagnostic = new llvm::SMDiagnostic();
    PyObject* var_PyObject = pycapsule_new(cast_to_base<llvm::SMDiagnostic >::from(var_llvm_SMDiagnostic), "llvm::SMDiagnostic", "llvm::SMDiagnostic");
    if (!var_PyObject)
    {
        return NULL;
    }
    return var_PyObject;
}

static
PyMethodDef meth_llvm_SMDiagnostic[] = {
    { "delete", (PyCFunction)llvm_SMDiagnostic__delete, METH_VARARGS, NULL },
    { "new", (PyCFunction)llvm_SMDiagnostic__new, METH_VARARGS, NULL },
    { NULL },
};

static
SubModuleEntry submodule_llvm_SMDiagnostic[] = {
    { NULL }
};

static
PyObject*
llvm_Target__hasMCAsmParser(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Target* var_llvm_Target = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Target");
        if(!var_void)
        {
            puts("Error: llvm::Target");
            return NULL;
        }
        llvm::Target* var_llvm_Target1 = unwrap_as<llvm::Target, llvm::Target >::from(var_void);
        if(!var_llvm_Target1)
        {
            return NULL;
        }
        var_llvm_Target = var_llvm_Target1;
    }
    bool var_bool = var_llvm_Target->hasMCAsmParser();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Target__hasTargetMachine(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Target* var_llvm_Target = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Target");
        if(!var_void)
        {
            puts("Error: llvm::Target");
            return NULL;
        }
        llvm::Target* var_llvm_Target1 = unwrap_as<llvm::Target, llvm::Target >::from(var_void);
        if(!var_llvm_Target1)
        {
            return NULL;
        }
        var_llvm_Target = var_llvm_Target1;
    }
    bool var_bool = var_llvm_Target->hasTargetMachine();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Target__hasMCAsmBackend(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Target* var_llvm_Target = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Target");
        if(!var_void)
        {
            puts("Error: llvm::Target");
            return NULL;
        }
        llvm::Target* var_llvm_Target1 = unwrap_as<llvm::Target, llvm::Target >::from(var_void);
        if(!var_llvm_Target1)
        {
            return NULL;
        }
        var_llvm_Target = var_llvm_Target1;
    }
    bool var_bool = var_llvm_Target->hasMCAsmBackend();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Target__getShortDescription(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Target* var_llvm_Target = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Target");
        if(!var_void)
        {
            puts("Error: llvm::Target");
            return NULL;
        }
        llvm::Target* var_llvm_Target1 = unwrap_as<llvm::Target, llvm::Target >::from(var_void);
        if(!var_llvm_Target1)
        {
            return NULL;
        }
        var_llvm_Target = var_llvm_Target1;
    }
    std::string var_std_string = var_llvm_Target->getShortDescription();
    PyObject* var_PyObject1 = py_str_from(var_std_string);
    return var_PyObject1;
}

static
PyObject*
llvm_Target__hasMCDisassembler(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Target* var_llvm_Target = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Target");
        if(!var_void)
        {
            puts("Error: llvm::Target");
            return NULL;
        }
        llvm::Target* var_llvm_Target1 = unwrap_as<llvm::Target, llvm::Target >::from(var_void);
        if(!var_llvm_Target1)
        {
            return NULL;
        }
        var_llvm_Target = var_llvm_Target1;
    }
    bool var_bool = var_llvm_Target->hasMCDisassembler();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Target__hasMCInstPrinter(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Target* var_llvm_Target = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Target");
        if(!var_void)
        {
            puts("Error: llvm::Target");
            return NULL;
        }
        llvm::Target* var_llvm_Target1 = unwrap_as<llvm::Target, llvm::Target >::from(var_void);
        if(!var_llvm_Target1)
        {
            return NULL;
        }
        var_llvm_Target = var_llvm_Target1;
    }
    bool var_bool = var_llvm_Target->hasMCInstPrinter();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Target__hasMCCodeEmitter(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Target* var_llvm_Target = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Target");
        if(!var_void)
        {
            puts("Error: llvm::Target");
            return NULL;
        }
        llvm::Target* var_llvm_Target1 = unwrap_as<llvm::Target, llvm::Target >::from(var_void);
        if(!var_llvm_Target1)
        {
            return NULL;
        }
        var_llvm_Target = var_llvm_Target1;
    }
    bool var_bool = var_llvm_Target->hasMCCodeEmitter();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Target__getNext(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Target* var_llvm_Target = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Target");
        if(!var_void)
        {
            puts("Error: llvm::Target");
            return NULL;
        }
        llvm::Target* var_llvm_Target1 = unwrap_as<llvm::Target, llvm::Target >::from(var_void);
        if(!var_llvm_Target1)
        {
            return NULL;
        }
        var_llvm_Target = var_llvm_Target1;
    }
    const llvm::Target* var_const_llvm_Target = var_llvm_Target->getNext();
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Target >::from(var_const_llvm_Target), "llvm::Target", "llvm::Target");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyObject*
llvm_Target__getName(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Target* var_llvm_Target = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Target");
        if(!var_void)
        {
            puts("Error: llvm::Target");
            return NULL;
        }
        llvm::Target* var_llvm_Target1 = unwrap_as<llvm::Target, llvm::Target >::from(var_void);
        if(!var_llvm_Target1)
        {
            return NULL;
        }
        var_llvm_Target = var_llvm_Target1;
    }
    std::string var_std_string = var_llvm_Target->getName();
    PyObject* var_PyObject1 = py_str_from(var_std_string);
    return var_PyObject1;
}

static
PyObject*
llvm_Target__hasMCObjectStreamer(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Target* var_llvm_Target = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Target");
        if(!var_void)
        {
            puts("Error: llvm::Target");
            return NULL;
        }
        llvm::Target* var_llvm_Target1 = unwrap_as<llvm::Target, llvm::Target >::from(var_void);
        if(!var_llvm_Target1)
        {
            return NULL;
        }
        var_llvm_Target = var_llvm_Target1;
    }
    bool var_bool = var_llvm_Target->hasMCObjectStreamer();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Target__hasAsmPrinter(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Target* var_llvm_Target = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Target");
        if(!var_void)
        {
            puts("Error: llvm::Target");
            return NULL;
        }
        llvm::Target* var_llvm_Target1 = unwrap_as<llvm::Target, llvm::Target >::from(var_void);
        if(!var_llvm_Target1)
        {
            return NULL;
        }
        var_llvm_Target = var_llvm_Target1;
    }
    bool var_bool = var_llvm_Target->hasAsmPrinter();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Target__createTargetMachine(PyObject* self, PyObject* args)
{
    Py_ssize_t var_Py__ssize__t = PyTuple_Size(args);
    if (8 == var_Py__ssize__t)
    {
        PyObject* var_PyObject;
        PyObject* var_PyObject1;
        PyObject* var_PyObject2;
        PyObject* var_PyObject3;
        PyObject* var_PyObject4;
        PyObject* var_PyObject5;
        PyObject* var_PyObject6;
        PyObject* var_PyObject7;
        if(!PyArg_ParseTuple(args, "OOOOOOOO", &var_PyObject, &var_PyObject1, &var_PyObject2, &var_PyObject3, &var_PyObject4, &var_PyObject5, &var_PyObject6, &var_PyObject7))
        {
            return NULL;
        }
        llvm::Target* var_llvm_Target = NULL;
        if (var_PyObject != Py_None)
        {
            void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Target");
            if(!var_void)
            {
                puts("Error: llvm::Target");
                return NULL;
            }
            llvm::Target* var_llvm_Target1 = unwrap_as<llvm::Target, llvm::Target >::from(var_void);
            if(!var_llvm_Target1)
            {
                return NULL;
            }
            var_llvm_Target = var_llvm_Target1;
        }
        llvm::StringRef var_llvm_StringRef;
        int var_int = py_str_to(var_PyObject1, var_llvm_StringRef);
        if(!var_int)
        {
            return NULL;
        }
        llvm::StringRef var_llvm_StringRef1;
        int var_int1 = py_str_to(var_PyObject2, var_llvm_StringRef1);
        if(!var_int1)
        {
            return NULL;
        }
        llvm::StringRef var_llvm_StringRef2;
        int var_int2 = py_str_to(var_PyObject3, var_llvm_StringRef2);
        if(!var_int2)
        {
            return NULL;
        }
        void* var_void1 = PyCapsule_GetPointer(var_PyObject4, "llvm::TargetOptions");
        if(!var_void1)
        {
            puts("Error: llvm::TargetOptions");
            return NULL;
        }
        llvm::TargetOptions* var_llvm_TargetOptions = unwrap_as<llvm::TargetOptions, llvm::TargetOptions >::from(var_void1);
        if(!var_llvm_TargetOptions)
        {
            return NULL;
        }
        llvm::TargetOptions& var_llvm_TargetOptions1 = *var_llvm_TargetOptions;
        llvm::Reloc::Model var_llvm_Reloc_Model = (llvm::Reloc::Model)PyInt_AsLong(var_PyObject5);
        llvm::CodeModel::Model var_llvm_CodeModel_Model = (llvm::CodeModel::Model)PyInt_AsLong(var_PyObject6);
        llvm::CodeGenOpt::Level var_llvm_CodeGenOpt_Level = (llvm::CodeGenOpt::Level)PyInt_AsLong(var_PyObject7);
        llvm::TargetMachine* var_llvm_TargetMachine = var_llvm_Target->createTargetMachine(var_llvm_StringRef, var_llvm_StringRef1, var_llvm_StringRef2, var_llvm_TargetOptions1, var_llvm_Reloc_Model, var_llvm_CodeModel_Model, var_llvm_CodeGenOpt_Level);
        PyObject* var_PyObject8 = pycapsule_new(cast_to_base<llvm::TargetMachine >::from(var_llvm_TargetMachine), "llvm::TargetMachine", "llvm::TargetMachine");
        if (!var_PyObject8)
        {
            return NULL;
        }
        return var_PyObject8;
    }
    if (5 == var_Py__ssize__t)
    {
        PyObject* var_PyObject9;
        PyObject* var_PyObject10;
        PyObject* var_PyObject11;
        PyObject* var_PyObject12;
        PyObject* var_PyObject13;
        if(!PyArg_ParseTuple(args, "OOOOO", &var_PyObject9, &var_PyObject10, &var_PyObject11, &var_PyObject12, &var_PyObject13))
        {
            return NULL;
        }
        llvm::Target* var_llvm_Target2 = NULL;
        if (var_PyObject9 != Py_None)
        {
            void* var_void2 = PyCapsule_GetPointer(var_PyObject9, "llvm::Target");
            if(!var_void2)
            {
                puts("Error: llvm::Target");
                return NULL;
            }
            llvm::Target* var_llvm_Target3 = unwrap_as<llvm::Target, llvm::Target >::from(var_void2);
            if(!var_llvm_Target3)
            {
                return NULL;
            }
            var_llvm_Target2 = var_llvm_Target3;
        }
        llvm::StringRef var_llvm_StringRef3;
        int var_int3 = py_str_to(var_PyObject10, var_llvm_StringRef3);
        if(!var_int3)
        {
            return NULL;
        }
        llvm::StringRef var_llvm_StringRef4;
        int var_int4 = py_str_to(var_PyObject11, var_llvm_StringRef4);
        if(!var_int4)
        {
            return NULL;
        }
        llvm::StringRef var_llvm_StringRef5;
        int var_int5 = py_str_to(var_PyObject12, var_llvm_StringRef5);
        if(!var_int5)
        {
            return NULL;
        }
        void* var_void3 = PyCapsule_GetPointer(var_PyObject13, "llvm::TargetOptions");
        if(!var_void3)
        {
            puts("Error: llvm::TargetOptions");
            return NULL;
        }
        llvm::TargetOptions* var_llvm_TargetOptions2 = unwrap_as<llvm::TargetOptions, llvm::TargetOptions >::from(var_void3);
        if(!var_llvm_TargetOptions2)
        {
            return NULL;
        }
        llvm::TargetOptions& var_llvm_TargetOptions3 = *var_llvm_TargetOptions2;
        llvm::TargetMachine* var_llvm_TargetMachine1 = var_llvm_Target2->createTargetMachine(var_llvm_StringRef3, var_llvm_StringRef4, var_llvm_StringRef5, var_llvm_TargetOptions3);
        PyObject* var_PyObject14 = pycapsule_new(cast_to_base<llvm::TargetMachine >::from(var_llvm_TargetMachine1), "llvm::TargetMachine", "llvm::TargetMachine");
        if (!var_PyObject14)
        {
            return NULL;
        }
        return var_PyObject14;
    }
    if (6 == var_Py__ssize__t)
    {
        PyObject* var_PyObject15;
        PyObject* var_PyObject16;
        PyObject* var_PyObject17;
        PyObject* var_PyObject18;
        PyObject* var_PyObject19;
        PyObject* var_PyObject20;
        if(!PyArg_ParseTuple(args, "OOOOOO", &var_PyObject15, &var_PyObject16, &var_PyObject17, &var_PyObject18, &var_PyObject19, &var_PyObject20))
        {
            return NULL;
        }
        llvm::Target* var_llvm_Target4 = NULL;
        if (var_PyObject15 != Py_None)
        {
            void* var_void4 = PyCapsule_GetPointer(var_PyObject15, "llvm::Target");
            if(!var_void4)
            {
                puts("Error: llvm::Target");
                return NULL;
            }
            llvm::Target* var_llvm_Target5 = unwrap_as<llvm::Target, llvm::Target >::from(var_void4);
            if(!var_llvm_Target5)
            {
                return NULL;
            }
            var_llvm_Target4 = var_llvm_Target5;
        }
        llvm::StringRef var_llvm_StringRef6;
        int var_int6 = py_str_to(var_PyObject16, var_llvm_StringRef6);
        if(!var_int6)
        {
            return NULL;
        }
        llvm::StringRef var_llvm_StringRef7;
        int var_int7 = py_str_to(var_PyObject17, var_llvm_StringRef7);
        if(!var_int7)
        {
            return NULL;
        }
        llvm::StringRef var_llvm_StringRef8;
        int var_int8 = py_str_to(var_PyObject18, var_llvm_StringRef8);
        if(!var_int8)
        {
            return NULL;
        }
        void* var_void5 = PyCapsule_GetPointer(var_PyObject19, "llvm::TargetOptions");
        if(!var_void5)
        {
            puts("Error: llvm::TargetOptions");
            return NULL;
        }
        llvm::TargetOptions* var_llvm_TargetOptions4 = unwrap_as<llvm::TargetOptions, llvm::TargetOptions >::from(var_void5);
        if(!var_llvm_TargetOptions4)
        {
            return NULL;
        }
        llvm::TargetOptions& var_llvm_TargetOptions5 = *var_llvm_TargetOptions4;
        llvm::Reloc::Model var_llvm_Reloc_Model1 = (llvm::Reloc::Model)PyInt_AsLong(var_PyObject20);
        llvm::TargetMachine* var_llvm_TargetMachine2 = var_llvm_Target4->createTargetMachine(var_llvm_StringRef6, var_llvm_StringRef7, var_llvm_StringRef8, var_llvm_TargetOptions5, var_llvm_Reloc_Model1);
        PyObject* var_PyObject21 = pycapsule_new(cast_to_base<llvm::TargetMachine >::from(var_llvm_TargetMachine2), "llvm::TargetMachine", "llvm::TargetMachine");
        if (!var_PyObject21)
        {
            return NULL;
        }
        return var_PyObject21;
    }
    if (7 == var_Py__ssize__t)
    {
        PyObject* var_PyObject22;
        PyObject* var_PyObject23;
        PyObject* var_PyObject24;
        PyObject* var_PyObject25;
        PyObject* var_PyObject26;
        PyObject* var_PyObject27;
        PyObject* var_PyObject28;
        if(!PyArg_ParseTuple(args, "OOOOOOO", &var_PyObject22, &var_PyObject23, &var_PyObject24, &var_PyObject25, &var_PyObject26, &var_PyObject27, &var_PyObject28))
        {
            return NULL;
        }
        llvm::Target* var_llvm_Target6 = NULL;
        if (var_PyObject22 != Py_None)
        {
            void* var_void6 = PyCapsule_GetPointer(var_PyObject22, "llvm::Target");
            if(!var_void6)
            {
                puts("Error: llvm::Target");
                return NULL;
            }
            llvm::Target* var_llvm_Target7 = unwrap_as<llvm::Target, llvm::Target >::from(var_void6);
            if(!var_llvm_Target7)
            {
                return NULL;
            }
            var_llvm_Target6 = var_llvm_Target7;
        }
        llvm::StringRef var_llvm_StringRef9;
        int var_int9 = py_str_to(var_PyObject23, var_llvm_StringRef9);
        if(!var_int9)
        {
            return NULL;
        }
        llvm::StringRef var_llvm_StringRef10;
        int var_int10 = py_str_to(var_PyObject24, var_llvm_StringRef10);
        if(!var_int10)
        {
            return NULL;
        }
        llvm::StringRef var_llvm_StringRef11;
        int var_int11 = py_str_to(var_PyObject25, var_llvm_StringRef11);
        if(!var_int11)
        {
            return NULL;
        }
        void* var_void7 = PyCapsule_GetPointer(var_PyObject26, "llvm::TargetOptions");
        if(!var_void7)
        {
            puts("Error: llvm::TargetOptions");
            return NULL;
        }
        llvm::TargetOptions* var_llvm_TargetOptions6 = unwrap_as<llvm::TargetOptions, llvm::TargetOptions >::from(var_void7);
        if(!var_llvm_TargetOptions6)
        {
            return NULL;
        }
        llvm::TargetOptions& var_llvm_TargetOptions7 = *var_llvm_TargetOptions6;
        llvm::Reloc::Model var_llvm_Reloc_Model2 = (llvm::Reloc::Model)PyInt_AsLong(var_PyObject27);
        llvm::CodeModel::Model var_llvm_CodeModel_Model1 = (llvm::CodeModel::Model)PyInt_AsLong(var_PyObject28);
        llvm::TargetMachine* var_llvm_TargetMachine3 = var_llvm_Target6->createTargetMachine(var_llvm_StringRef9, var_llvm_StringRef10, var_llvm_StringRef11, var_llvm_TargetOptions7, var_llvm_Reloc_Model2, var_llvm_CodeModel_Model1);
        PyObject* var_PyObject29 = pycapsule_new(cast_to_base<llvm::TargetMachine >::from(var_llvm_TargetMachine3), "llvm::TargetMachine", "llvm::TargetMachine");
        if (!var_PyObject29)
        {
            return NULL;
        }
        return var_PyObject29;
    }
    PyErr_SetString(PyExc_TypeError, "Invalid number of args");
    return NULL;
}

static
PyObject*
llvm_Target__hasAsmStreamer(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Target* var_llvm_Target = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Target");
        if(!var_void)
        {
            puts("Error: llvm::Target");
            return NULL;
        }
        llvm::Target* var_llvm_Target1 = unwrap_as<llvm::Target, llvm::Target >::from(var_void);
        if(!var_llvm_Target1)
        {
            return NULL;
        }
        var_llvm_Target = var_llvm_Target1;
    }
    bool var_bool = var_llvm_Target->hasAsmStreamer();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Target__hasJIT(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Target* var_llvm_Target = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Target");
        if(!var_void)
        {
            puts("Error: llvm::Target");
            return NULL;
        }
        llvm::Target* var_llvm_Target1 = unwrap_as<llvm::Target, llvm::Target >::from(var_void);
        if(!var_llvm_Target1)
        {
            return NULL;
        }
        var_llvm_Target = var_llvm_Target1;
    }
    bool var_bool = var_llvm_Target->hasJIT();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyMethodDef meth_llvm_Target[] = {
    { "hasMCAsmParser", (PyCFunction)llvm_Target__hasMCAsmParser, METH_VARARGS, NULL },
    { "hasTargetMachine", (PyCFunction)llvm_Target__hasTargetMachine, METH_VARARGS, NULL },
    { "hasMCAsmBackend", (PyCFunction)llvm_Target__hasMCAsmBackend, METH_VARARGS, NULL },
    { "getShortDescription", (PyCFunction)llvm_Target__getShortDescription, METH_VARARGS, NULL },
    { "hasMCDisassembler", (PyCFunction)llvm_Target__hasMCDisassembler, METH_VARARGS, NULL },
    { "hasMCInstPrinter", (PyCFunction)llvm_Target__hasMCInstPrinter, METH_VARARGS, NULL },
    { "hasMCCodeEmitter", (PyCFunction)llvm_Target__hasMCCodeEmitter, METH_VARARGS, NULL },
    { "getNext", (PyCFunction)llvm_Target__getNext, METH_VARARGS, NULL },
    { "getName", (PyCFunction)llvm_Target__getName, METH_VARARGS, NULL },
    { "hasMCObjectStreamer", (PyCFunction)llvm_Target__hasMCObjectStreamer, METH_VARARGS, NULL },
    { "hasAsmPrinter", (PyCFunction)llvm_Target__hasAsmPrinter, METH_VARARGS, NULL },
    { "createTargetMachine", (PyCFunction)llvm_Target__createTargetMachine, METH_VARARGS, NULL },
    { "hasAsmStreamer", (PyCFunction)llvm_Target__hasAsmStreamer, METH_VARARGS, NULL },
    { "hasJIT", (PyCFunction)llvm_Target__hasJIT, METH_VARARGS, NULL },
    { NULL },
};

static
SubModuleEntry submodule_llvm_Target[] = {
    { NULL }
};

static
PyObject*
llvm_TargetRegistry__printRegisteredTargetsForVersion(PyObject* self, PyObject* args)
{
    if(!PyArg_ParseTuple(args, ""))
    {
        return NULL;
    }
    llvm::TargetRegistry::printRegisteredTargetsForVersion();
    Py_RETURN_NONE;
}

static
PyObject*
llvm_TargetRegistry__lookupTarget(PyObject* self, PyObject* args)
{
    Py_ssize_t var_Py__ssize__t = PyTuple_Size(args);
    if (2 == var_Py__ssize__t)
    {
        PyObject* var_PyObject;
        PyObject* var_PyObject1;
        if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
        {
            return NULL;
        }
        const char* var_const_char;
        int var_int = py_str_to(var_PyObject, var_const_char);
        if(!var_int)
        {
            return NULL;
        }
        PyObject* var_PyObject2 = TargetRegistry_lookupTarget(var_const_char, var_PyObject1);
        return var_PyObject2;
    }
    if (3 == var_Py__ssize__t)
    {
        PyObject* var_PyObject3;
        PyObject* var_PyObject4;
        PyObject* var_PyObject5;
        if(!PyArg_ParseTuple(args, "OOO", &var_PyObject3, &var_PyObject4, &var_PyObject5))
        {
            return NULL;
        }
        const char* var_const_char1;
        int var_int1 = py_str_to(var_PyObject3, var_const_char1);
        if(!var_int1)
        {
            return NULL;
        }
        void* var_void = PyCapsule_GetPointer(var_PyObject4, "llvm::Triple");
        if(!var_void)
        {
            puts("Error: llvm::Triple");
            return NULL;
        }
        llvm::Triple* var_llvm_Triple = unwrap_as<llvm::Triple, llvm::Triple >::from(var_void);
        if(!var_llvm_Triple)
        {
            return NULL;
        }
        llvm::Triple& var_llvm_Triple1 = *var_llvm_Triple;
        PyObject* var_PyObject6 = TargetRegistry_lookupTarget(var_const_char1, var_llvm_Triple1, var_PyObject5);
        return var_PyObject6;
    }
    PyErr_SetString(PyExc_TypeError, "Invalid number of args");
    return NULL;
}

static
PyObject*
llvm_TargetRegistry__getClosestTargetForJIT(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    PyObject* var_PyObject1 = TargetRegistry_getClosestTargetForJIT(var_PyObject);
    return var_PyObject1;
}

static
PyObject*
llvm_TargetRegistry__targetsList(PyObject* self, PyObject* args)
{
    if(!PyArg_ParseTuple(args, ""))
    {
        return NULL;
    }
    PyObject* var_PyObject = TargetRegistry_targets_list();
    return var_PyObject;
}

static
PyMethodDef meth_llvm_TargetRegistry[] = {
    { "printRegisteredTargetsForVersion", (PyCFunction)llvm_TargetRegistry__printRegisteredTargetsForVersion, METH_VARARGS, NULL },
    { "lookupTarget", (PyCFunction)llvm_TargetRegistry__lookupTarget, METH_VARARGS, NULL },
    { "getClosestTargetForJIT", (PyCFunction)llvm_TargetRegistry__getClosestTargetForJIT, METH_VARARGS, NULL },
    { "targetsList", (PyCFunction)llvm_TargetRegistry__targetsList, METH_VARARGS, NULL },
    { NULL },
};

static
SubModuleEntry submodule_llvm_TargetRegistry[] = {
    { NULL }
};

static
PyObject*
llvm_Pass__dump(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Pass* var_llvm_Pass = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Pass");
        if(!var_void)
        {
            puts("Error: llvm::Pass");
            return NULL;
        }
        llvm::Pass* var_llvm_Pass1 = unwrap_as<llvm::Pass, llvm::Pass >::from(var_void);
        if(!var_llvm_Pass1)
        {
            return NULL;
        }
        var_llvm_Pass = var_llvm_Pass1;
    }
    var_llvm_Pass->dump();
    Py_RETURN_NONE;
}

static
PyObject*
llvm_Pass__delete(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Pass* var_llvm_Pass = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Pass");
        if(!var_void)
        {
            puts("Error: llvm::Pass");
            return NULL;
        }
        llvm::Pass* var_llvm_Pass1 = unwrap_as<llvm::Pass, llvm::Pass >::from(var_void);
        if(!var_llvm_Pass1)
        {
            return NULL;
        }
        var_llvm_Pass = var_llvm_Pass1;
    }
    delete var_llvm_Pass;
    Py_RETURN_NONE;
}

static
PyObject*
llvm_Pass__getPassName(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Pass* var_llvm_Pass = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Pass");
        if(!var_void)
        {
            puts("Error: llvm::Pass");
            return NULL;
        }
        llvm::Pass* var_llvm_Pass1 = unwrap_as<llvm::Pass, llvm::Pass >::from(var_void);
        if(!var_llvm_Pass1)
        {
            return NULL;
        }
        var_llvm_Pass = var_llvm_Pass1;
    }
    std::string var_std_string = var_llvm_Pass->getPassName();
    PyObject* var_PyObject1 = py_str_from(var_std_string);
    return var_PyObject1;
}

static
PyMethodDef meth_llvm_Pass[] = {
    { "dump", (PyCFunction)llvm_Pass__dump, METH_VARARGS, NULL },
    { "delete", (PyCFunction)llvm_Pass__delete, METH_VARARGS, NULL },
    { "getPassName", (PyCFunction)llvm_Pass__getPassName, METH_VARARGS, NULL },
    { NULL },
};

static
SubModuleEntry submodule_llvm_Pass[] = {
    { NULL }
};

static
PyObject*
llvm_ModulePass__runOnModule(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::ModulePass* var_llvm_ModulePass = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Pass");
        if(!var_void)
        {
            puts("Error: llvm::Pass");
            return NULL;
        }
        llvm::ModulePass* var_llvm_ModulePass1 = unwrap_as<llvm::ModulePass, llvm::Pass >::from(var_void);
        if(!var_llvm_ModulePass1)
        {
            return NULL;
        }
        var_llvm_ModulePass = var_llvm_ModulePass1;
    }
    void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Module");
    if(!var_void1)
    {
        puts("Error: llvm::Module");
        return NULL;
    }
    llvm::Module* var_llvm_Module = unwrap_as<llvm::Module, llvm::Module >::from(var_void1);
    if(!var_llvm_Module)
    {
        return NULL;
    }
    llvm::Module& var_llvm_Module1 = *var_llvm_Module;
    bool var_bool = var_llvm_ModulePass->runOnModule(var_llvm_Module1);
    PyObject* var_PyObject2 = py_bool_from(var_bool);
    return var_PyObject2;
}

static
PyMethodDef meth_llvm_ModulePass[] = {
    { "runOnModule", (PyCFunction)llvm_ModulePass__runOnModule, METH_VARARGS, NULL },
    { NULL },
};

static
SubModuleEntry submodule_llvm_ModulePass[] = {
    { NULL }
};

static
PyObject*
llvm_FunctionPass__doFinalization(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::FunctionPass* var_llvm_FunctionPass = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Pass");
        if(!var_void)
        {
            puts("Error: llvm::Pass");
            return NULL;
        }
        llvm::FunctionPass* var_llvm_FunctionPass1 = unwrap_as<llvm::FunctionPass, llvm::Pass >::from(var_void);
        if(!var_llvm_FunctionPass1)
        {
            return NULL;
        }
        var_llvm_FunctionPass = var_llvm_FunctionPass1;
    }
    void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Module");
    if(!var_void1)
    {
        puts("Error: llvm::Module");
        return NULL;
    }
    llvm::Module* var_llvm_Module = unwrap_as<llvm::Module, llvm::Module >::from(var_void1);
    if(!var_llvm_Module)
    {
        return NULL;
    }
    llvm::Module& var_llvm_Module1 = *var_llvm_Module;
    bool var_bool = var_llvm_FunctionPass->doFinalization(var_llvm_Module1);
    PyObject* var_PyObject2 = py_bool_from(var_bool);
    return var_PyObject2;
}

static
PyObject*
llvm_FunctionPass__doInitialization(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::FunctionPass* var_llvm_FunctionPass = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Pass");
        if(!var_void)
        {
            puts("Error: llvm::Pass");
            return NULL;
        }
        llvm::FunctionPass* var_llvm_FunctionPass1 = unwrap_as<llvm::FunctionPass, llvm::Pass >::from(var_void);
        if(!var_llvm_FunctionPass1)
        {
            return NULL;
        }
        var_llvm_FunctionPass = var_llvm_FunctionPass1;
    }
    void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Module");
    if(!var_void1)
    {
        puts("Error: llvm::Module");
        return NULL;
    }
    llvm::Module* var_llvm_Module = unwrap_as<llvm::Module, llvm::Module >::from(var_void1);
    if(!var_llvm_Module)
    {
        return NULL;
    }
    llvm::Module& var_llvm_Module1 = *var_llvm_Module;
    bool var_bool = var_llvm_FunctionPass->doInitialization(var_llvm_Module1);
    PyObject* var_PyObject2 = py_bool_from(var_bool);
    return var_PyObject2;
}

static
PyMethodDef meth_llvm_FunctionPass[] = {
    { "doFinalization", (PyCFunction)llvm_FunctionPass__doFinalization, METH_VARARGS, NULL },
    { "doInitialization", (PyCFunction)llvm_FunctionPass__doInitialization, METH_VARARGS, NULL },
    { NULL },
};

static
SubModuleEntry submodule_llvm_FunctionPass[] = {
    { NULL }
};

static
PyMethodDef meth_llvm_ImmutablePass[] = {
    { NULL },
};

static
SubModuleEntry submodule_llvm_ImmutablePass[] = {
    { NULL }
};

static
PyObject*
llvm_TargetLibraryInfo__has(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::TargetLibraryInfo* var_llvm_TargetLibraryInfo = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Pass");
        if(!var_void)
        {
            puts("Error: llvm::Pass");
            return NULL;
        }
        llvm::TargetLibraryInfo* var_llvm_TargetLibraryInfo1 = unwrap_as<llvm::TargetLibraryInfo, llvm::Pass >::from(var_void);
        if(!var_llvm_TargetLibraryInfo1)
        {
            return NULL;
        }
        var_llvm_TargetLibraryInfo = var_llvm_TargetLibraryInfo1;
    }
    llvm::LibFunc::Func var_llvm_LibFunc_Func = (llvm::LibFunc::Func)PyInt_AsLong(var_PyObject1);
    bool var_bool = var_llvm_TargetLibraryInfo->has(var_llvm_LibFunc_Func);
    PyObject* var_PyObject2 = py_bool_from(var_bool);
    return var_PyObject2;
}

static
PyObject*
llvm_TargetLibraryInfo__hasOptimizedCodeGen(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::TargetLibraryInfo* var_llvm_TargetLibraryInfo = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Pass");
        if(!var_void)
        {
            puts("Error: llvm::Pass");
            return NULL;
        }
        llvm::TargetLibraryInfo* var_llvm_TargetLibraryInfo1 = unwrap_as<llvm::TargetLibraryInfo, llvm::Pass >::from(var_void);
        if(!var_llvm_TargetLibraryInfo1)
        {
            return NULL;
        }
        var_llvm_TargetLibraryInfo = var_llvm_TargetLibraryInfo1;
    }
    llvm::LibFunc::Func var_llvm_LibFunc_Func = (llvm::LibFunc::Func)PyInt_AsLong(var_PyObject1);
    bool var_bool = var_llvm_TargetLibraryInfo->hasOptimizedCodeGen(var_llvm_LibFunc_Func);
    PyObject* var_PyObject2 = py_bool_from(var_bool);
    return var_PyObject2;
}

static
PyObject*
llvm_TargetLibraryInfo__setUnavailable(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::TargetLibraryInfo* var_llvm_TargetLibraryInfo = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Pass");
        if(!var_void)
        {
            puts("Error: llvm::Pass");
            return NULL;
        }
        llvm::TargetLibraryInfo* var_llvm_TargetLibraryInfo1 = unwrap_as<llvm::TargetLibraryInfo, llvm::Pass >::from(var_void);
        if(!var_llvm_TargetLibraryInfo1)
        {
            return NULL;
        }
        var_llvm_TargetLibraryInfo = var_llvm_TargetLibraryInfo1;
    }
    llvm::LibFunc::Func var_llvm_LibFunc_Func = (llvm::LibFunc::Func)PyInt_AsLong(var_PyObject1);
    var_llvm_TargetLibraryInfo->setUnavailable(var_llvm_LibFunc_Func);
    Py_RETURN_NONE;
}

static
PyObject*
llvm_TargetLibraryInfo__new(PyObject* self, PyObject* args)
{
    Py_ssize_t var_Py__ssize__t = PyTuple_Size(args);
    if (0 == var_Py__ssize__t)
    {
        if(!PyArg_ParseTuple(args, ""))
        {
            return NULL;
        }
        llvm::TargetLibraryInfo* var_llvm_TargetLibraryInfo = new llvm::TargetLibraryInfo();
        PyObject* var_PyObject = pycapsule_new(cast_to_base<llvm::Pass >::from(var_llvm_TargetLibraryInfo), "llvm::Pass", "llvm::TargetLibraryInfo");
        if (!var_PyObject)
        {
            return NULL;
        }
        return var_PyObject;
    }
    if (1 == var_Py__ssize__t)
    {
        PyObject* var_PyObject1;
        if(!PyArg_ParseTuple(args, "O", &var_PyObject1))
        {
            return NULL;
        }
        void* var_void = PyCapsule_GetPointer(var_PyObject1, "llvm::Triple");
        if(!var_void)
        {
            puts("Error: llvm::Triple");
            return NULL;
        }
        llvm::Triple* var_llvm_Triple = unwrap_as<llvm::Triple, llvm::Triple >::from(var_void);
        if(!var_llvm_Triple)
        {
            return NULL;
        }
        llvm::Triple& var_llvm_Triple1 = *var_llvm_Triple;
        llvm::TargetLibraryInfo* var_llvm_TargetLibraryInfo1 = new llvm::TargetLibraryInfo(var_llvm_Triple1);
        PyObject* var_PyObject2 = pycapsule_new(cast_to_base<llvm::Pass >::from(var_llvm_TargetLibraryInfo1), "llvm::Pass", "llvm::TargetLibraryInfo");
        if (!var_PyObject2)
        {
            return NULL;
        }
        return var_PyObject2;
    }
    PyErr_SetString(PyExc_TypeError, "Invalid number of args");
    return NULL;
}

static
PyObject*
llvm_TargetLibraryInfo__getName(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::TargetLibraryInfo* var_llvm_TargetLibraryInfo = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Pass");
        if(!var_void)
        {
            puts("Error: llvm::Pass");
            return NULL;
        }
        llvm::TargetLibraryInfo* var_llvm_TargetLibraryInfo1 = unwrap_as<llvm::TargetLibraryInfo, llvm::Pass >::from(var_void);
        if(!var_llvm_TargetLibraryInfo1)
        {
            return NULL;
        }
        var_llvm_TargetLibraryInfo = var_llvm_TargetLibraryInfo1;
    }
    llvm::LibFunc::Func var_llvm_LibFunc_Func = (llvm::LibFunc::Func)PyInt_AsLong(var_PyObject1);
    llvm::StringRef var_llvm_StringRef = var_llvm_TargetLibraryInfo->getName(var_llvm_LibFunc_Func);
    PyObject* var_PyObject2 = py_str_from(var_llvm_StringRef);
    return var_PyObject2;
}

static
PyObject*
llvm_TargetLibraryInfo__setAvailable(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::TargetLibraryInfo* var_llvm_TargetLibraryInfo = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Pass");
        if(!var_void)
        {
            puts("Error: llvm::Pass");
            return NULL;
        }
        llvm::TargetLibraryInfo* var_llvm_TargetLibraryInfo1 = unwrap_as<llvm::TargetLibraryInfo, llvm::Pass >::from(var_void);
        if(!var_llvm_TargetLibraryInfo1)
        {
            return NULL;
        }
        var_llvm_TargetLibraryInfo = var_llvm_TargetLibraryInfo1;
    }
    llvm::LibFunc::Func var_llvm_LibFunc_Func = (llvm::LibFunc::Func)PyInt_AsLong(var_PyObject1);
    var_llvm_TargetLibraryInfo->setAvailable(var_llvm_LibFunc_Func);
    Py_RETURN_NONE;
}

static
PyObject*
llvm_TargetLibraryInfo__delete(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::TargetLibraryInfo* var_llvm_TargetLibraryInfo = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Pass");
        if(!var_void)
        {
            puts("Error: llvm::Pass");
            return NULL;
        }
        llvm::TargetLibraryInfo* var_llvm_TargetLibraryInfo1 = unwrap_as<llvm::TargetLibraryInfo, llvm::Pass >::from(var_void);
        if(!var_llvm_TargetLibraryInfo1)
        {
            return NULL;
        }
        var_llvm_TargetLibraryInfo = var_llvm_TargetLibraryInfo1;
    }
    delete var_llvm_TargetLibraryInfo;
    Py_RETURN_NONE;
}

static
PyObject*
llvm_TargetLibraryInfo__disableAllFunctions(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::TargetLibraryInfo* var_llvm_TargetLibraryInfo = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Pass");
        if(!var_void)
        {
            puts("Error: llvm::Pass");
            return NULL;
        }
        llvm::TargetLibraryInfo* var_llvm_TargetLibraryInfo1 = unwrap_as<llvm::TargetLibraryInfo, llvm::Pass >::from(var_void);
        if(!var_llvm_TargetLibraryInfo1)
        {
            return NULL;
        }
        var_llvm_TargetLibraryInfo = var_llvm_TargetLibraryInfo1;
    }
    var_llvm_TargetLibraryInfo->disableAllFunctions();
    Py_RETURN_NONE;
}

static
PyObject*
llvm_TargetLibraryInfo__setAvailableWithName(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    PyObject* var_PyObject2;
    if(!PyArg_ParseTuple(args, "OOO", &var_PyObject, &var_PyObject1, &var_PyObject2))
    {
        return NULL;
    }
    llvm::TargetLibraryInfo* var_llvm_TargetLibraryInfo = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Pass");
        if(!var_void)
        {
            puts("Error: llvm::Pass");
            return NULL;
        }
        llvm::TargetLibraryInfo* var_llvm_TargetLibraryInfo1 = unwrap_as<llvm::TargetLibraryInfo, llvm::Pass >::from(var_void);
        if(!var_llvm_TargetLibraryInfo1)
        {
            return NULL;
        }
        var_llvm_TargetLibraryInfo = var_llvm_TargetLibraryInfo1;
    }
    llvm::LibFunc::Func var_llvm_LibFunc_Func = (llvm::LibFunc::Func)PyInt_AsLong(var_PyObject1);
    llvm::StringRef var_llvm_StringRef;
    int var_int = py_str_to(var_PyObject2, var_llvm_StringRef);
    if(!var_int)
    {
        return NULL;
    }
    var_llvm_TargetLibraryInfo->setAvailableWithName(var_llvm_LibFunc_Func, var_llvm_StringRef);
    Py_RETURN_NONE;
}

static
PyMethodDef meth_llvm_TargetLibraryInfo[] = {
    { "has", (PyCFunction)llvm_TargetLibraryInfo__has, METH_VARARGS, NULL },
    { "hasOptimizedCodeGen", (PyCFunction)llvm_TargetLibraryInfo__hasOptimizedCodeGen, METH_VARARGS, NULL },
    { "setUnavailable", (PyCFunction)llvm_TargetLibraryInfo__setUnavailable, METH_VARARGS, NULL },
    { "new", (PyCFunction)llvm_TargetLibraryInfo__new, METH_VARARGS, NULL },
    { "getName", (PyCFunction)llvm_TargetLibraryInfo__getName, METH_VARARGS, NULL },
    { "setAvailable", (PyCFunction)llvm_TargetLibraryInfo__setAvailable, METH_VARARGS, NULL },
    { "delete", (PyCFunction)llvm_TargetLibraryInfo__delete, METH_VARARGS, NULL },
    { "disableAllFunctions", (PyCFunction)llvm_TargetLibraryInfo__disableAllFunctions, METH_VARARGS, NULL },
    { "setAvailableWithName", (PyCFunction)llvm_TargetLibraryInfo__setAvailableWithName, METH_VARARGS, NULL },
    { NULL },
};

static
SubModuleEntry submodule_llvm_TargetLibraryInfo[] = {
    { NULL }
};

static
PyObject*
llvm_TargetMachine__getTarget(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::TargetMachine* var_llvm_TargetMachine = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::TargetMachine");
        if(!var_void)
        {
            puts("Error: llvm::TargetMachine");
            return NULL;
        }
        llvm::TargetMachine* var_llvm_TargetMachine1 = unwrap_as<llvm::TargetMachine, llvm::TargetMachine >::from(var_void);
        if(!var_llvm_TargetMachine1)
        {
            return NULL;
        }
        var_llvm_TargetMachine = var_llvm_TargetMachine1;
    }
    const llvm::Target& var_const_llvm_Target = var_llvm_TargetMachine->getTarget();
    const llvm::Target* var_const_llvm_Target1 = &var_const_llvm_Target;
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Target >::from(var_const_llvm_Target1), "llvm::Target", "llvm::Target");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyObject*
llvm_TargetMachine__addAnalysisPasses(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::TargetMachine* var_llvm_TargetMachine = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::TargetMachine");
        if(!var_void)
        {
            puts("Error: llvm::TargetMachine");
            return NULL;
        }
        llvm::TargetMachine* var_llvm_TargetMachine1 = unwrap_as<llvm::TargetMachine, llvm::TargetMachine >::from(var_void);
        if(!var_llvm_TargetMachine1)
        {
            return NULL;
        }
        var_llvm_TargetMachine = var_llvm_TargetMachine1;
    }
    void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::PassManagerBase");
    if(!var_void1)
    {
        puts("Error: llvm::PassManagerBase");
        return NULL;
    }
    llvm::PassManagerBase* var_llvm_PassManagerBase = unwrap_as<llvm::PassManagerBase, llvm::PassManagerBase >::from(var_void1);
    if(!var_llvm_PassManagerBase)
    {
        return NULL;
    }
    llvm::PassManagerBase& var_llvm_PassManagerBase1 = *var_llvm_PassManagerBase;
    var_llvm_TargetMachine->addAnalysisPasses(var_llvm_PassManagerBase1);
    Py_RETURN_NONE;
}

static
PyObject*
llvm_TargetMachine__getTLSModel(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::TargetMachine* var_llvm_TargetMachine = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::TargetMachine");
        if(!var_void)
        {
            puts("Error: llvm::TargetMachine");
            return NULL;
        }
        llvm::TargetMachine* var_llvm_TargetMachine1 = unwrap_as<llvm::TargetMachine, llvm::TargetMachine >::from(var_void);
        if(!var_llvm_TargetMachine1)
        {
            return NULL;
        }
        var_llvm_TargetMachine = var_llvm_TargetMachine1;
    }
    llvm::GlobalValue* var_llvm_GlobalValue = NULL;
    if (var_PyObject1 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Value");
        if(!var_void1)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::GlobalValue* var_llvm_GlobalValue1 = unwrap_as<llvm::GlobalValue, llvm::Value >::from(var_void1);
        if(!var_llvm_GlobalValue1)
        {
            return NULL;
        }
        var_llvm_GlobalValue = var_llvm_GlobalValue1;
    }
    llvm::TLSModel::Model var_llvm_TLSModel_Model = var_llvm_TargetMachine->getTLSModel(var_llvm_GlobalValue);
    PyObject* var_PyObject2 = PyInt_FromLong(var_llvm_TLSModel_Model);
    return var_PyObject2;
}

static
PyObject*
llvm_TargetMachine__setMCUseDwarfDirectory(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::TargetMachine* var_llvm_TargetMachine = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::TargetMachine");
        if(!var_void)
        {
            puts("Error: llvm::TargetMachine");
            return NULL;
        }
        llvm::TargetMachine* var_llvm_TargetMachine1 = unwrap_as<llvm::TargetMachine, llvm::TargetMachine >::from(var_void);
        if(!var_llvm_TargetMachine1)
        {
            return NULL;
        }
        var_llvm_TargetMachine = var_llvm_TargetMachine1;
    }
    bool var_bool;
    int var_int = py_bool_to(var_PyObject1, var_bool);
    if(!var_int)
    {
        return NULL;
    }
    var_llvm_TargetMachine->setMCUseDwarfDirectory(var_bool);
    Py_RETURN_NONE;
}

static
PyObject*
llvm_TargetMachine__getTargetCPU(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::TargetMachine* var_llvm_TargetMachine = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::TargetMachine");
        if(!var_void)
        {
            puts("Error: llvm::TargetMachine");
            return NULL;
        }
        llvm::TargetMachine* var_llvm_TargetMachine1 = unwrap_as<llvm::TargetMachine, llvm::TargetMachine >::from(var_void);
        if(!var_llvm_TargetMachine1)
        {
            return NULL;
        }
        var_llvm_TargetMachine = var_llvm_TargetMachine1;
    }
    llvm::StringRef var_llvm_StringRef = var_llvm_TargetMachine->getTargetCPU();
    PyObject* var_PyObject1 = py_str_from(var_llvm_StringRef);
    return var_PyObject1;
}

static
PyObject*
llvm_TargetMachine__getTargetTriple(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::TargetMachine* var_llvm_TargetMachine = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::TargetMachine");
        if(!var_void)
        {
            puts("Error: llvm::TargetMachine");
            return NULL;
        }
        llvm::TargetMachine* var_llvm_TargetMachine1 = unwrap_as<llvm::TargetMachine, llvm::TargetMachine >::from(var_void);
        if(!var_llvm_TargetMachine1)
        {
            return NULL;
        }
        var_llvm_TargetMachine = var_llvm_TargetMachine1;
    }
    llvm::StringRef var_llvm_StringRef = var_llvm_TargetMachine->getTargetTriple();
    PyObject* var_PyObject1 = py_str_from(var_llvm_StringRef);
    return var_PyObject1;
}

static
PyObject*
llvm_TargetMachine__delete(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::TargetMachine* var_llvm_TargetMachine = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::TargetMachine");
        if(!var_void)
        {
            puts("Error: llvm::TargetMachine");
            return NULL;
        }
        llvm::TargetMachine* var_llvm_TargetMachine1 = unwrap_as<llvm::TargetMachine, llvm::TargetMachine >::from(var_void);
        if(!var_llvm_TargetMachine1)
        {
            return NULL;
        }
        var_llvm_TargetMachine = var_llvm_TargetMachine1;
    }
    delete var_llvm_TargetMachine;
    Py_RETURN_NONE;
}

static
PyObject*
llvm_TargetMachine__getOptLevel(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::TargetMachine* var_llvm_TargetMachine = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::TargetMachine");
        if(!var_void)
        {
            puts("Error: llvm::TargetMachine");
            return NULL;
        }
        llvm::TargetMachine* var_llvm_TargetMachine1 = unwrap_as<llvm::TargetMachine, llvm::TargetMachine >::from(var_void);
        if(!var_llvm_TargetMachine1)
        {
            return NULL;
        }
        var_llvm_TargetMachine = var_llvm_TargetMachine1;
    }
    llvm::CodeGenOpt::Level var_llvm_CodeGenOpt_Level = var_llvm_TargetMachine->getOptLevel();
    PyObject* var_PyObject1 = PyInt_FromLong(var_llvm_CodeGenOpt_Level);
    return var_PyObject1;
}

static
PyObject*
llvm_TargetMachine__hasMCUseDwarfDirectory(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::TargetMachine* var_llvm_TargetMachine = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::TargetMachine");
        if(!var_void)
        {
            puts("Error: llvm::TargetMachine");
            return NULL;
        }
        llvm::TargetMachine* var_llvm_TargetMachine1 = unwrap_as<llvm::TargetMachine, llvm::TargetMachine >::from(var_void);
        if(!var_llvm_TargetMachine1)
        {
            return NULL;
        }
        var_llvm_TargetMachine = var_llvm_TargetMachine1;
    }
    bool var_bool = var_llvm_TargetMachine->hasMCUseDwarfDirectory();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_TargetMachine__getTargetFeatureString(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::TargetMachine* var_llvm_TargetMachine = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::TargetMachine");
        if(!var_void)
        {
            puts("Error: llvm::TargetMachine");
            return NULL;
        }
        llvm::TargetMachine* var_llvm_TargetMachine1 = unwrap_as<llvm::TargetMachine, llvm::TargetMachine >::from(var_void);
        if(!var_llvm_TargetMachine1)
        {
            return NULL;
        }
        var_llvm_TargetMachine = var_llvm_TargetMachine1;
    }
    llvm::StringRef var_llvm_StringRef = var_llvm_TargetMachine->getTargetFeatureString();
    PyObject* var_PyObject1 = py_str_from(var_llvm_StringRef);
    return var_PyObject1;
}

static
PyObject*
llvm_TargetMachine__getCodeModel(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::TargetMachine* var_llvm_TargetMachine = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::TargetMachine");
        if(!var_void)
        {
            puts("Error: llvm::TargetMachine");
            return NULL;
        }
        llvm::TargetMachine* var_llvm_TargetMachine1 = unwrap_as<llvm::TargetMachine, llvm::TargetMachine >::from(var_void);
        if(!var_llvm_TargetMachine1)
        {
            return NULL;
        }
        var_llvm_TargetMachine = var_llvm_TargetMachine1;
    }
    llvm::CodeModel::Model var_llvm_CodeModel_Model = var_llvm_TargetMachine->getCodeModel();
    PyObject* var_PyObject1 = PyInt_FromLong(var_llvm_CodeModel_Model);
    return var_PyObject1;
}

static
PyObject*
llvm_TargetMachine__getDataLayout(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::TargetMachine* var_llvm_TargetMachine = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::TargetMachine");
        if(!var_void)
        {
            puts("Error: llvm::TargetMachine");
            return NULL;
        }
        llvm::TargetMachine* var_llvm_TargetMachine1 = unwrap_as<llvm::TargetMachine, llvm::TargetMachine >::from(var_void);
        if(!var_llvm_TargetMachine1)
        {
            return NULL;
        }
        var_llvm_TargetMachine = var_llvm_TargetMachine1;
    }
    const llvm::DataLayout* var_const_llvm_DataLayout = var_llvm_TargetMachine->getDataLayout();
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Pass >::from(var_const_llvm_DataLayout), "llvm::Pass", "llvm::DataLayout");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyObject*
llvm_TargetMachine__getRelocationModel(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::TargetMachine* var_llvm_TargetMachine = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::TargetMachine");
        if(!var_void)
        {
            puts("Error: llvm::TargetMachine");
            return NULL;
        }
        llvm::TargetMachine* var_llvm_TargetMachine1 = unwrap_as<llvm::TargetMachine, llvm::TargetMachine >::from(var_void);
        if(!var_llvm_TargetMachine1)
        {
            return NULL;
        }
        var_llvm_TargetMachine = var_llvm_TargetMachine1;
    }
    llvm::Reloc::Model var_llvm_Reloc_Model = var_llvm_TargetMachine->getRelocationModel();
    PyObject* var_PyObject1 = PyInt_FromLong(var_llvm_Reloc_Model);
    return var_PyObject1;
}

static
PyObject*
llvm_TargetMachine__addPassesToEmitFile(PyObject* self, PyObject* args)
{
    Py_ssize_t var_Py__ssize__t = PyTuple_Size(args);
    if (5 == var_Py__ssize__t)
    {
        PyObject* var_PyObject;
        PyObject* var_PyObject1;
        PyObject* var_PyObject2;
        PyObject* var_PyObject3;
        PyObject* var_PyObject4;
        if(!PyArg_ParseTuple(args, "OOOOO", &var_PyObject, &var_PyObject1, &var_PyObject2, &var_PyObject3, &var_PyObject4))
        {
            return NULL;
        }
        llvm::TargetMachine* var_llvm_TargetMachine = NULL;
        if (var_PyObject != Py_None)
        {
            void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::TargetMachine");
            if(!var_void)
            {
                puts("Error: llvm::TargetMachine");
                return NULL;
            }
            llvm::TargetMachine* var_llvm_TargetMachine1 = unwrap_as<llvm::TargetMachine, llvm::TargetMachine >::from(var_void);
            if(!var_llvm_TargetMachine1)
            {
                return NULL;
            }
            var_llvm_TargetMachine = var_llvm_TargetMachine1;
        }
        void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::PassManagerBase");
        if(!var_void1)
        {
            puts("Error: llvm::PassManagerBase");
            return NULL;
        }
        llvm::PassManagerBase* var_llvm_PassManagerBase = unwrap_as<llvm::PassManagerBase, llvm::PassManagerBase >::from(var_void1);
        if(!var_llvm_PassManagerBase)
        {
            return NULL;
        }
        llvm::PassManagerBase& var_llvm_PassManagerBase1 = *var_llvm_PassManagerBase;
        void* var_void2 = PyCapsule_GetPointer(var_PyObject2, "llvm::raw_ostream");
        if(!var_void2)
        {
            puts("Error: llvm::raw_ostream");
            return NULL;
        }
        llvm::formatted_raw_ostream* var_llvm_formatted__raw__ostream = unwrap_as<llvm::formatted_raw_ostream, llvm::raw_ostream >::from(var_void2);
        if(!var_llvm_formatted__raw__ostream)
        {
            return NULL;
        }
        llvm::formatted_raw_ostream& var_llvm_formatted__raw__ostream1 = *var_llvm_formatted__raw__ostream;
        llvm::TargetMachine::CodeGenFileType var_llvm_TargetMachine_CodeGenFileType = (llvm::TargetMachine::CodeGenFileType)PyInt_AsLong(var_PyObject3);
        bool var_bool;
        int var_int = py_bool_to(var_PyObject4, var_bool);
        if(!var_int)
        {
            return NULL;
        }
        bool var_bool1 = var_llvm_TargetMachine->addPassesToEmitFile(var_llvm_PassManagerBase1, var_llvm_formatted__raw__ostream1, var_llvm_TargetMachine_CodeGenFileType, var_bool);
        PyObject* var_PyObject5 = py_bool_from(var_bool1);
        return var_PyObject5;
    }
    if (4 == var_Py__ssize__t)
    {
        PyObject* var_PyObject6;
        PyObject* var_PyObject7;
        PyObject* var_PyObject8;
        PyObject* var_PyObject9;
        if(!PyArg_ParseTuple(args, "OOOO", &var_PyObject6, &var_PyObject7, &var_PyObject8, &var_PyObject9))
        {
            return NULL;
        }
        llvm::TargetMachine* var_llvm_TargetMachine2 = NULL;
        if (var_PyObject6 != Py_None)
        {
            void* var_void3 = PyCapsule_GetPointer(var_PyObject6, "llvm::TargetMachine");
            if(!var_void3)
            {
                puts("Error: llvm::TargetMachine");
                return NULL;
            }
            llvm::TargetMachine* var_llvm_TargetMachine3 = unwrap_as<llvm::TargetMachine, llvm::TargetMachine >::from(var_void3);
            if(!var_llvm_TargetMachine3)
            {
                return NULL;
            }
            var_llvm_TargetMachine2 = var_llvm_TargetMachine3;
        }
        void* var_void4 = PyCapsule_GetPointer(var_PyObject7, "llvm::PassManagerBase");
        if(!var_void4)
        {
            puts("Error: llvm::PassManagerBase");
            return NULL;
        }
        llvm::PassManagerBase* var_llvm_PassManagerBase2 = unwrap_as<llvm::PassManagerBase, llvm::PassManagerBase >::from(var_void4);
        if(!var_llvm_PassManagerBase2)
        {
            return NULL;
        }
        llvm::PassManagerBase& var_llvm_PassManagerBase3 = *var_llvm_PassManagerBase2;
        void* var_void5 = PyCapsule_GetPointer(var_PyObject8, "llvm::raw_ostream");
        if(!var_void5)
        {
            puts("Error: llvm::raw_ostream");
            return NULL;
        }
        llvm::formatted_raw_ostream* var_llvm_formatted__raw__ostream2 = unwrap_as<llvm::formatted_raw_ostream, llvm::raw_ostream >::from(var_void5);
        if(!var_llvm_formatted__raw__ostream2)
        {
            return NULL;
        }
        llvm::formatted_raw_ostream& var_llvm_formatted__raw__ostream3 = *var_llvm_formatted__raw__ostream2;
        llvm::TargetMachine::CodeGenFileType var_llvm_TargetMachine_CodeGenFileType1 = (llvm::TargetMachine::CodeGenFileType)PyInt_AsLong(var_PyObject9);
        bool var_bool2 = var_llvm_TargetMachine2->addPassesToEmitFile(var_llvm_PassManagerBase3, var_llvm_formatted__raw__ostream3, var_llvm_TargetMachine_CodeGenFileType1);
        PyObject* var_PyObject10 = py_bool_from(var_bool2);
        return var_PyObject10;
    }
    PyErr_SetString(PyExc_TypeError, "Invalid number of args");
    return NULL;
}

static
PyObject*
llvm_TargetMachine__CodeGenFileType__CGFT__AssemblyFile(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject = PyInt_FromLong(llvm::TargetMachine::CGFT_AssemblyFile);
    return var_PyObject;
}

static
PyObject*
llvm_TargetMachine__CodeGenFileType__CGFT__ObjectFile(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject1 = PyInt_FromLong(llvm::TargetMachine::CGFT_ObjectFile);
    return var_PyObject1;
}

static
PyObject*
llvm_TargetMachine__CodeGenFileType__CGFT__Null(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject2 = PyInt_FromLong(llvm::TargetMachine::CGFT_Null);
    return var_PyObject2;
}

static
PyMethodDef meth_llvm_TargetMachine[] = {
    { "getTarget", (PyCFunction)llvm_TargetMachine__getTarget, METH_VARARGS, NULL },
    { "addAnalysisPasses", (PyCFunction)llvm_TargetMachine__addAnalysisPasses, METH_VARARGS, NULL },
    { "getTLSModel", (PyCFunction)llvm_TargetMachine__getTLSModel, METH_VARARGS, NULL },
    { "setMCUseDwarfDirectory", (PyCFunction)llvm_TargetMachine__setMCUseDwarfDirectory, METH_VARARGS, NULL },
    { "getTargetCPU", (PyCFunction)llvm_TargetMachine__getTargetCPU, METH_VARARGS, NULL },
    { "getTargetTriple", (PyCFunction)llvm_TargetMachine__getTargetTriple, METH_VARARGS, NULL },
    { "delete", (PyCFunction)llvm_TargetMachine__delete, METH_VARARGS, NULL },
    { "getOptLevel", (PyCFunction)llvm_TargetMachine__getOptLevel, METH_VARARGS, NULL },
    { "hasMCUseDwarfDirectory", (PyCFunction)llvm_TargetMachine__hasMCUseDwarfDirectory, METH_VARARGS, NULL },
    { "getTargetFeatureString", (PyCFunction)llvm_TargetMachine__getTargetFeatureString, METH_VARARGS, NULL },
    { "getCodeModel", (PyCFunction)llvm_TargetMachine__getCodeModel, METH_VARARGS, NULL },
    { "getDataLayout", (PyCFunction)llvm_TargetMachine__getDataLayout, METH_VARARGS, NULL },
    { "getRelocationModel", (PyCFunction)llvm_TargetMachine__getRelocationModel, METH_VARARGS, NULL },
    { "addPassesToEmitFile", (PyCFunction)llvm_TargetMachine__addPassesToEmitFile, METH_VARARGS, NULL },
    { "CGFT_AssemblyFile", (PyCFunction)llvm_TargetMachine__CodeGenFileType__CGFT__AssemblyFile, METH_VARARGS, NULL },
    { "CGFT_ObjectFile", (PyCFunction)llvm_TargetMachine__CodeGenFileType__CGFT__ObjectFile, METH_VARARGS, NULL },
    { "CGFT_Null", (PyCFunction)llvm_TargetMachine__CodeGenFileType__CGFT__Null, METH_VARARGS, NULL },
    { NULL },
};

static
SubModuleEntry submodule_llvm_TargetMachine[] = {
    { NULL }
};

static
PyObject*
llvm_DataLayout__getPointerSize(PyObject* self, PyObject* args)
{
    Py_ssize_t var_Py__ssize__t = PyTuple_Size(args);
    if (2 == var_Py__ssize__t)
    {
        PyObject* var_PyObject;
        PyObject* var_PyObject1;
        if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
        {
            return NULL;
        }
        llvm::DataLayout* var_llvm_DataLayout = NULL;
        if (var_PyObject != Py_None)
        {
            void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Pass");
            if(!var_void)
            {
                puts("Error: llvm::Pass");
                return NULL;
            }
            llvm::DataLayout* var_llvm_DataLayout1 = unwrap_as<llvm::DataLayout, llvm::Pass >::from(var_void);
            if(!var_llvm_DataLayout1)
            {
                return NULL;
            }
            var_llvm_DataLayout = var_llvm_DataLayout1;
        }
        unsigned var_unsigned;
        int var_int = py_int_to(var_PyObject1, var_unsigned);
        if(!var_int)
        {
            return NULL;
        }
        unsigned var_unsigned1 = var_llvm_DataLayout->getPointerSize(var_unsigned);
        PyObject* var_PyObject2 = py_int_from_unsigned(var_unsigned1);
        return var_PyObject2;
    }
    if (1 == var_Py__ssize__t)
    {
        PyObject* var_PyObject3;
        if(!PyArg_ParseTuple(args, "O", &var_PyObject3))
        {
            return NULL;
        }
        llvm::DataLayout* var_llvm_DataLayout2 = NULL;
        if (var_PyObject3 != Py_None)
        {
            void* var_void1 = PyCapsule_GetPointer(var_PyObject3, "llvm::Pass");
            if(!var_void1)
            {
                puts("Error: llvm::Pass");
                return NULL;
            }
            llvm::DataLayout* var_llvm_DataLayout3 = unwrap_as<llvm::DataLayout, llvm::Pass >::from(var_void1);
            if(!var_llvm_DataLayout3)
            {
                return NULL;
            }
            var_llvm_DataLayout2 = var_llvm_DataLayout3;
        }
        unsigned var_unsigned2 = var_llvm_DataLayout2->getPointerSize();
        PyObject* var_PyObject4 = py_int_from_unsigned(var_unsigned2);
        return var_PyObject4;
    }
    PyErr_SetString(PyExc_TypeError, "Invalid number of args");
    return NULL;
}

static
PyObject*
llvm_DataLayout__fitsInLegalInteger(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::DataLayout* var_llvm_DataLayout = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Pass");
        if(!var_void)
        {
            puts("Error: llvm::Pass");
            return NULL;
        }
        llvm::DataLayout* var_llvm_DataLayout1 = unwrap_as<llvm::DataLayout, llvm::Pass >::from(var_void);
        if(!var_llvm_DataLayout1)
        {
            return NULL;
        }
        var_llvm_DataLayout = var_llvm_DataLayout1;
    }
    unsigned var_unsigned;
    int var_int = py_int_to(var_PyObject1, var_unsigned);
    if(!var_int)
    {
        return NULL;
    }
    bool var_bool = var_llvm_DataLayout->fitsInLegalInteger(var_unsigned);
    PyObject* var_PyObject2 = py_bool_from(var_bool);
    return var_PyObject2;
}

static
PyObject*
llvm_DataLayout__getStructLayout(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::DataLayout* var_llvm_DataLayout = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Pass");
        if(!var_void)
        {
            puts("Error: llvm::Pass");
            return NULL;
        }
        llvm::DataLayout* var_llvm_DataLayout1 = unwrap_as<llvm::DataLayout, llvm::Pass >::from(var_void);
        if(!var_llvm_DataLayout1)
        {
            return NULL;
        }
        var_llvm_DataLayout = var_llvm_DataLayout1;
    }
    llvm::StructType* var_llvm_StructType = NULL;
    if (var_PyObject1 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Type");
        if(!var_void1)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::StructType* var_llvm_StructType1 = unwrap_as<llvm::StructType, llvm::Type >::from(var_void1);
        if(!var_llvm_StructType1)
        {
            return NULL;
        }
        var_llvm_StructType = var_llvm_StructType1;
    }
    const llvm::StructLayout* var_const_llvm_StructLayout = var_llvm_DataLayout->getStructLayout(var_llvm_StructType);
    PyObject* var_PyObject2 = pycapsule_new(cast_to_base<llvm::StructLayout >::from(var_const_llvm_StructLayout), "llvm::StructLayout", "llvm::StructLayout");
    if (!var_PyObject2)
    {
        return NULL;
    }
    return var_PyObject2;
}

static
PyObject*
llvm_DataLayout__getCallFrameTypeAlignment(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::DataLayout* var_llvm_DataLayout = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Pass");
        if(!var_void)
        {
            puts("Error: llvm::Pass");
            return NULL;
        }
        llvm::DataLayout* var_llvm_DataLayout1 = unwrap_as<llvm::DataLayout, llvm::Pass >::from(var_void);
        if(!var_llvm_DataLayout1)
        {
            return NULL;
        }
        var_llvm_DataLayout = var_llvm_DataLayout1;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject1 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Type");
        if(!var_void1)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void1);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    unsigned var_unsigned = var_llvm_DataLayout->getCallFrameTypeAlignment(var_llvm_Type);
    PyObject* var_PyObject2 = py_int_from_unsigned(var_unsigned);
    return var_PyObject2;
}

static
PyObject*
llvm_DataLayout__isIllegalInteger(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::DataLayout* var_llvm_DataLayout = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Pass");
        if(!var_void)
        {
            puts("Error: llvm::Pass");
            return NULL;
        }
        llvm::DataLayout* var_llvm_DataLayout1 = unwrap_as<llvm::DataLayout, llvm::Pass >::from(var_void);
        if(!var_llvm_DataLayout1)
        {
            return NULL;
        }
        var_llvm_DataLayout = var_llvm_DataLayout1;
    }
    unsigned var_unsigned;
    int var_int = py_int_to(var_PyObject1, var_unsigned);
    if(!var_int)
    {
        return NULL;
    }
    bool var_bool = var_llvm_DataLayout->isIllegalInteger(var_unsigned);
    PyObject* var_PyObject2 = py_bool_from(var_bool);
    return var_PyObject2;
}

static
PyObject*
llvm_DataLayout__getABITypeAlignment(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::DataLayout* var_llvm_DataLayout = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Pass");
        if(!var_void)
        {
            puts("Error: llvm::Pass");
            return NULL;
        }
        llvm::DataLayout* var_llvm_DataLayout1 = unwrap_as<llvm::DataLayout, llvm::Pass >::from(var_void);
        if(!var_llvm_DataLayout1)
        {
            return NULL;
        }
        var_llvm_DataLayout = var_llvm_DataLayout1;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject1 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Type");
        if(!var_void1)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void1);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    unsigned var_unsigned = var_llvm_DataLayout->getABITypeAlignment(var_llvm_Type);
    PyObject* var_PyObject2 = py_int_from_unsigned(var_unsigned);
    return var_PyObject2;
}

static
PyObject*
llvm_DataLayout__getPreferredAlignment(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::DataLayout* var_llvm_DataLayout = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Pass");
        if(!var_void)
        {
            puts("Error: llvm::Pass");
            return NULL;
        }
        llvm::DataLayout* var_llvm_DataLayout1 = unwrap_as<llvm::DataLayout, llvm::Pass >::from(var_void);
        if(!var_llvm_DataLayout1)
        {
            return NULL;
        }
        var_llvm_DataLayout = var_llvm_DataLayout1;
    }
    llvm::GlobalVariable* var_llvm_GlobalVariable = NULL;
    if (var_PyObject1 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Value");
        if(!var_void1)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::GlobalVariable* var_llvm_GlobalVariable1 = unwrap_as<llvm::GlobalVariable, llvm::Value >::from(var_void1);
        if(!var_llvm_GlobalVariable1)
        {
            return NULL;
        }
        var_llvm_GlobalVariable = var_llvm_GlobalVariable1;
    }
    unsigned var_unsigned = var_llvm_DataLayout->getPreferredAlignment(var_llvm_GlobalVariable);
    PyObject* var_PyObject2 = py_int_from_unsigned(var_unsigned);
    return var_PyObject2;
}

static
PyObject*
llvm_DataLayout__isLittleEndian(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::DataLayout* var_llvm_DataLayout = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Pass");
        if(!var_void)
        {
            puts("Error: llvm::Pass");
            return NULL;
        }
        llvm::DataLayout* var_llvm_DataLayout1 = unwrap_as<llvm::DataLayout, llvm::Pass >::from(var_void);
        if(!var_llvm_DataLayout1)
        {
            return NULL;
        }
        var_llvm_DataLayout = var_llvm_DataLayout1;
    }
    bool var_bool = var_llvm_DataLayout->isLittleEndian();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_DataLayout____new__module(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Module* var_llvm_Module = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Module");
        if(!var_void)
        {
            puts("Error: llvm::Module");
            return NULL;
        }
        llvm::Module* var_llvm_Module1 = unwrap_as<llvm::Module, llvm::Module >::from(var_void);
        if(!var_llvm_Module1)
        {
            return NULL;
        }
        var_llvm_Module = var_llvm_Module1;
    }
    llvm::DataLayout* var_llvm_DataLayout = new llvm::DataLayout(var_llvm_Module);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Pass >::from(var_llvm_DataLayout), "llvm::Pass", "llvm::DataLayout");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyObject*
llvm_DataLayout____getIndexedOffset(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    PyObject* var_PyObject2;
    if(!PyArg_ParseTuple(args, "OOO", &var_PyObject, &var_PyObject1, &var_PyObject2))
    {
        return NULL;
    }
    llvm::DataLayout* var_llvm_DataLayout = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Pass");
        if(!var_void)
        {
            puts("Error: llvm::Pass");
            return NULL;
        }
        llvm::DataLayout* var_llvm_DataLayout1 = unwrap_as<llvm::DataLayout, llvm::Pass >::from(var_void);
        if(!var_llvm_DataLayout1)
        {
            return NULL;
        }
        var_llvm_DataLayout = var_llvm_DataLayout1;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject1 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Type");
        if(!var_void1)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void1);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    void* var_void2 = PyCapsule_GetPointer(var_PyObject2, "llvm::SmallVector<llvm::Value*,8>");
    if(!var_void2)
    {
        puts("Error: llvm::SmallVector<llvm::Value*,8>");
        return NULL;
    }
    llvm::SmallVector<llvm::Value*,8>* var_llvm_SmallVectorllvm_Value_8 = unwrap_as<llvm::SmallVector<llvm::Value*,8>, llvm::SmallVector<llvm::Value*,8> >::from(var_void2);
    if(!var_llvm_SmallVectorllvm_Value_8)
    {
        return NULL;
    }
    llvm::SmallVector<llvm::Value*,8>& var_llvm_SmallVectorllvm_Value_81 = *var_llvm_SmallVectorllvm_Value_8;
    uint64_t var_uint64__t = var_llvm_DataLayout->getIndexedOffset(var_llvm_Type, var_llvm_SmallVectorllvm_Value_81);
    PyObject* var_PyObject3 = py_int_from_unsigned(var_uint64__t);
    return var_PyObject3;
}

static
PyObject*
llvm_DataLayout__getPreferredTypeAlignmentShift(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::DataLayout* var_llvm_DataLayout = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Pass");
        if(!var_void)
        {
            puts("Error: llvm::Pass");
            return NULL;
        }
        llvm::DataLayout* var_llvm_DataLayout1 = unwrap_as<llvm::DataLayout, llvm::Pass >::from(var_void);
        if(!var_llvm_DataLayout1)
        {
            return NULL;
        }
        var_llvm_DataLayout = var_llvm_DataLayout1;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject1 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Type");
        if(!var_void1)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void1);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    unsigned var_unsigned = var_llvm_DataLayout->getPreferredTypeAlignmentShift(var_llvm_Type);
    PyObject* var_PyObject2 = py_int_from_unsigned(var_unsigned);
    return var_PyObject2;
}

static
PyObject*
llvm_DataLayout____getIntPtrType2(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::DataLayout* var_llvm_DataLayout = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Pass");
        if(!var_void)
        {
            puts("Error: llvm::Pass");
            return NULL;
        }
        llvm::DataLayout* var_llvm_DataLayout1 = unwrap_as<llvm::DataLayout, llvm::Pass >::from(var_void);
        if(!var_llvm_DataLayout1)
        {
            return NULL;
        }
        var_llvm_DataLayout = var_llvm_DataLayout1;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject1 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Type");
        if(!var_void1)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void1);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    llvm::Type* var_llvm_Type2 = var_llvm_DataLayout->getIntPtrType(var_llvm_Type);
    PyObject* var_PyObject2 = pycapsule_new(cast_to_base<llvm::Type >::from(var_llvm_Type2), "llvm::Type", "llvm::Type");
    if (!var_PyObject2)
    {
        return NULL;
    }
    return var_PyObject2;
}

static
PyObject*
llvm_DataLayout__isBigEndian(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::DataLayout* var_llvm_DataLayout = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Pass");
        if(!var_void)
        {
            puts("Error: llvm::Pass");
            return NULL;
        }
        llvm::DataLayout* var_llvm_DataLayout1 = unwrap_as<llvm::DataLayout, llvm::Pass >::from(var_void);
        if(!var_llvm_DataLayout1)
        {
            return NULL;
        }
        var_llvm_DataLayout = var_llvm_DataLayout1;
    }
    bool var_bool = var_llvm_DataLayout->isBigEndian();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_DataLayout__isLegalInteger(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::DataLayout* var_llvm_DataLayout = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Pass");
        if(!var_void)
        {
            puts("Error: llvm::Pass");
            return NULL;
        }
        llvm::DataLayout* var_llvm_DataLayout1 = unwrap_as<llvm::DataLayout, llvm::Pass >::from(var_void);
        if(!var_llvm_DataLayout1)
        {
            return NULL;
        }
        var_llvm_DataLayout = var_llvm_DataLayout1;
    }
    unsigned var_unsigned;
    int var_int = py_int_to(var_PyObject1, var_unsigned);
    if(!var_int)
    {
        return NULL;
    }
    bool var_bool = var_llvm_DataLayout->isLegalInteger(var_unsigned);
    PyObject* var_PyObject2 = py_bool_from(var_bool);
    return var_PyObject2;
}

static
PyObject*
llvm_DataLayout__getTypeAllocSize(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::DataLayout* var_llvm_DataLayout = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Pass");
        if(!var_void)
        {
            puts("Error: llvm::Pass");
            return NULL;
        }
        llvm::DataLayout* var_llvm_DataLayout1 = unwrap_as<llvm::DataLayout, llvm::Pass >::from(var_void);
        if(!var_llvm_DataLayout1)
        {
            return NULL;
        }
        var_llvm_DataLayout = var_llvm_DataLayout1;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject1 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Type");
        if(!var_void1)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void1);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    uint64_t var_uint64__t = var_llvm_DataLayout->getTypeAllocSize(var_llvm_Type);
    PyObject* var_PyObject2 = py_int_from_unsigned(var_uint64__t);
    return var_PyObject2;
}

static
PyObject*
llvm_DataLayout__getTypeStoreSizeInBits(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::DataLayout* var_llvm_DataLayout = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Pass");
        if(!var_void)
        {
            puts("Error: llvm::Pass");
            return NULL;
        }
        llvm::DataLayout* var_llvm_DataLayout1 = unwrap_as<llvm::DataLayout, llvm::Pass >::from(var_void);
        if(!var_llvm_DataLayout1)
        {
            return NULL;
        }
        var_llvm_DataLayout = var_llvm_DataLayout1;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject1 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Type");
        if(!var_void1)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void1);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    uint64_t var_uint64__t = var_llvm_DataLayout->getTypeStoreSizeInBits(var_llvm_Type);
    PyObject* var_PyObject2 = py_int_from_unsigned(var_uint64__t);
    return var_PyObject2;
}

static
PyObject*
llvm_DataLayout__getPointerSizeInBits(PyObject* self, PyObject* args)
{
    Py_ssize_t var_Py__ssize__t = PyTuple_Size(args);
    if (2 == var_Py__ssize__t)
    {
        PyObject* var_PyObject;
        PyObject* var_PyObject1;
        if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
        {
            return NULL;
        }
        llvm::DataLayout* var_llvm_DataLayout = NULL;
        if (var_PyObject != Py_None)
        {
            void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Pass");
            if(!var_void)
            {
                puts("Error: llvm::Pass");
                return NULL;
            }
            llvm::DataLayout* var_llvm_DataLayout1 = unwrap_as<llvm::DataLayout, llvm::Pass >::from(var_void);
            if(!var_llvm_DataLayout1)
            {
                return NULL;
            }
            var_llvm_DataLayout = var_llvm_DataLayout1;
        }
        unsigned var_unsigned;
        int var_int = py_int_to(var_PyObject1, var_unsigned);
        if(!var_int)
        {
            return NULL;
        }
        unsigned var_unsigned1 = var_llvm_DataLayout->getPointerSizeInBits(var_unsigned);
        PyObject* var_PyObject2 = py_int_from_unsigned(var_unsigned1);
        return var_PyObject2;
    }
    if (1 == var_Py__ssize__t)
    {
        PyObject* var_PyObject3;
        if(!PyArg_ParseTuple(args, "O", &var_PyObject3))
        {
            return NULL;
        }
        llvm::DataLayout* var_llvm_DataLayout2 = NULL;
        if (var_PyObject3 != Py_None)
        {
            void* var_void1 = PyCapsule_GetPointer(var_PyObject3, "llvm::Pass");
            if(!var_void1)
            {
                puts("Error: llvm::Pass");
                return NULL;
            }
            llvm::DataLayout* var_llvm_DataLayout3 = unwrap_as<llvm::DataLayout, llvm::Pass >::from(var_void1);
            if(!var_llvm_DataLayout3)
            {
                return NULL;
            }
            var_llvm_DataLayout2 = var_llvm_DataLayout3;
        }
        unsigned var_unsigned2 = var_llvm_DataLayout2->getPointerSizeInBits();
        PyObject* var_PyObject4 = py_int_from_unsigned(var_unsigned2);
        return var_PyObject4;
    }
    PyErr_SetString(PyExc_TypeError, "Invalid number of args");
    return NULL;
}

static
PyObject*
llvm_DataLayout__getPreferredAlignmentLog(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::DataLayout* var_llvm_DataLayout = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Pass");
        if(!var_void)
        {
            puts("Error: llvm::Pass");
            return NULL;
        }
        llvm::DataLayout* var_llvm_DataLayout1 = unwrap_as<llvm::DataLayout, llvm::Pass >::from(var_void);
        if(!var_llvm_DataLayout1)
        {
            return NULL;
        }
        var_llvm_DataLayout = var_llvm_DataLayout1;
    }
    llvm::GlobalVariable* var_llvm_GlobalVariable = NULL;
    if (var_PyObject1 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Value");
        if(!var_void1)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::GlobalVariable* var_llvm_GlobalVariable1 = unwrap_as<llvm::GlobalVariable, llvm::Value >::from(var_void1);
        if(!var_llvm_GlobalVariable1)
        {
            return NULL;
        }
        var_llvm_GlobalVariable = var_llvm_GlobalVariable1;
    }
    unsigned var_unsigned = var_llvm_DataLayout->getPreferredAlignmentLog(var_llvm_GlobalVariable);
    PyObject* var_PyObject2 = py_int_from_unsigned(var_unsigned);
    return var_PyObject2;
}

static
PyObject*
llvm_DataLayout__getTypeAllocSizeInBits(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::DataLayout* var_llvm_DataLayout = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Pass");
        if(!var_void)
        {
            puts("Error: llvm::Pass");
            return NULL;
        }
        llvm::DataLayout* var_llvm_DataLayout1 = unwrap_as<llvm::DataLayout, llvm::Pass >::from(var_void);
        if(!var_llvm_DataLayout1)
        {
            return NULL;
        }
        var_llvm_DataLayout = var_llvm_DataLayout1;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject1 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Type");
        if(!var_void1)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void1);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    uint64_t var_uint64__t = var_llvm_DataLayout->getTypeAllocSizeInBits(var_llvm_Type);
    PyObject* var_PyObject2 = py_int_from_unsigned(var_uint64__t);
    return var_PyObject2;
}

static
PyObject*
llvm_DataLayout____getIntPtrType(PyObject* self, PyObject* args)
{
    Py_ssize_t var_Py__ssize__t = PyTuple_Size(args);
    if (3 == var_Py__ssize__t)
    {
        PyObject* var_PyObject;
        PyObject* var_PyObject1;
        PyObject* var_PyObject2;
        if(!PyArg_ParseTuple(args, "OOO", &var_PyObject, &var_PyObject1, &var_PyObject2))
        {
            return NULL;
        }
        llvm::DataLayout* var_llvm_DataLayout = NULL;
        if (var_PyObject != Py_None)
        {
            void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Pass");
            if(!var_void)
            {
                puts("Error: llvm::Pass");
                return NULL;
            }
            llvm::DataLayout* var_llvm_DataLayout1 = unwrap_as<llvm::DataLayout, llvm::Pass >::from(var_void);
            if(!var_llvm_DataLayout1)
            {
                return NULL;
            }
            var_llvm_DataLayout = var_llvm_DataLayout1;
        }
        void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::LLVMContext");
        if(!var_void1)
        {
            puts("Error: llvm::LLVMContext");
            return NULL;
        }
        llvm::LLVMContext* var_llvm_LLVMContext = unwrap_as<llvm::LLVMContext, llvm::LLVMContext >::from(var_void1);
        if(!var_llvm_LLVMContext)
        {
            return NULL;
        }
        llvm::LLVMContext& var_llvm_LLVMContext1 = *var_llvm_LLVMContext;
        unsigned var_unsigned;
        int var_int = py_int_to(var_PyObject2, var_unsigned);
        if(!var_int)
        {
            return NULL;
        }
        llvm::IntegerType* var_llvm_IntegerType = var_llvm_DataLayout->getIntPtrType(var_llvm_LLVMContext1, var_unsigned);
        PyObject* var_PyObject3 = pycapsule_new(cast_to_base<llvm::Type >::from(var_llvm_IntegerType), "llvm::Type", "llvm::IntegerType");
        if (!var_PyObject3)
        {
            return NULL;
        }
        return var_PyObject3;
    }
    if (2 == var_Py__ssize__t)
    {
        PyObject* var_PyObject4;
        PyObject* var_PyObject5;
        if(!PyArg_ParseTuple(args, "OO", &var_PyObject4, &var_PyObject5))
        {
            return NULL;
        }
        llvm::DataLayout* var_llvm_DataLayout2 = NULL;
        if (var_PyObject4 != Py_None)
        {
            void* var_void2 = PyCapsule_GetPointer(var_PyObject4, "llvm::Pass");
            if(!var_void2)
            {
                puts("Error: llvm::Pass");
                return NULL;
            }
            llvm::DataLayout* var_llvm_DataLayout3 = unwrap_as<llvm::DataLayout, llvm::Pass >::from(var_void2);
            if(!var_llvm_DataLayout3)
            {
                return NULL;
            }
            var_llvm_DataLayout2 = var_llvm_DataLayout3;
        }
        void* var_void3 = PyCapsule_GetPointer(var_PyObject5, "llvm::LLVMContext");
        if(!var_void3)
        {
            puts("Error: llvm::LLVMContext");
            return NULL;
        }
        llvm::LLVMContext* var_llvm_LLVMContext2 = unwrap_as<llvm::LLVMContext, llvm::LLVMContext >::from(var_void3);
        if(!var_llvm_LLVMContext2)
        {
            return NULL;
        }
        llvm::LLVMContext& var_llvm_LLVMContext3 = *var_llvm_LLVMContext2;
        llvm::IntegerType* var_llvm_IntegerType1 = var_llvm_DataLayout2->getIntPtrType(var_llvm_LLVMContext3);
        PyObject* var_PyObject6 = pycapsule_new(cast_to_base<llvm::Type >::from(var_llvm_IntegerType1), "llvm::Type", "llvm::IntegerType");
        if (!var_PyObject6)
        {
            return NULL;
        }
        return var_PyObject6;
    }
    PyErr_SetString(PyExc_TypeError, "Invalid number of args");
    return NULL;
}

static
PyObject*
llvm_DataLayout__getTypeSizeInBits(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::DataLayout* var_llvm_DataLayout = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Pass");
        if(!var_void)
        {
            puts("Error: llvm::Pass");
            return NULL;
        }
        llvm::DataLayout* var_llvm_DataLayout1 = unwrap_as<llvm::DataLayout, llvm::Pass >::from(var_void);
        if(!var_llvm_DataLayout1)
        {
            return NULL;
        }
        var_llvm_DataLayout = var_llvm_DataLayout1;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject1 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Type");
        if(!var_void1)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void1);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    uint64_t var_uint64__t = var_llvm_DataLayout->getTypeSizeInBits(var_llvm_Type);
    PyObject* var_PyObject2 = py_int_from_unsigned(var_uint64__t);
    return var_PyObject2;
}

static
PyObject*
llvm_DataLayout__getPointerPrefAlignment(PyObject* self, PyObject* args)
{
    Py_ssize_t var_Py__ssize__t = PyTuple_Size(args);
    if (2 == var_Py__ssize__t)
    {
        PyObject* var_PyObject;
        PyObject* var_PyObject1;
        if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
        {
            return NULL;
        }
        llvm::DataLayout* var_llvm_DataLayout = NULL;
        if (var_PyObject != Py_None)
        {
            void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Pass");
            if(!var_void)
            {
                puts("Error: llvm::Pass");
                return NULL;
            }
            llvm::DataLayout* var_llvm_DataLayout1 = unwrap_as<llvm::DataLayout, llvm::Pass >::from(var_void);
            if(!var_llvm_DataLayout1)
            {
                return NULL;
            }
            var_llvm_DataLayout = var_llvm_DataLayout1;
        }
        unsigned var_unsigned;
        int var_int = py_int_to(var_PyObject1, var_unsigned);
        if(!var_int)
        {
            return NULL;
        }
        unsigned var_unsigned1 = var_llvm_DataLayout->getPointerPrefAlignment(var_unsigned);
        PyObject* var_PyObject2 = py_int_from_unsigned(var_unsigned1);
        return var_PyObject2;
    }
    if (1 == var_Py__ssize__t)
    {
        PyObject* var_PyObject3;
        if(!PyArg_ParseTuple(args, "O", &var_PyObject3))
        {
            return NULL;
        }
        llvm::DataLayout* var_llvm_DataLayout2 = NULL;
        if (var_PyObject3 != Py_None)
        {
            void* var_void1 = PyCapsule_GetPointer(var_PyObject3, "llvm::Pass");
            if(!var_void1)
            {
                puts("Error: llvm::Pass");
                return NULL;
            }
            llvm::DataLayout* var_llvm_DataLayout3 = unwrap_as<llvm::DataLayout, llvm::Pass >::from(var_void1);
            if(!var_llvm_DataLayout3)
            {
                return NULL;
            }
            var_llvm_DataLayout2 = var_llvm_DataLayout3;
        }
        unsigned var_unsigned2 = var_llvm_DataLayout2->getPointerPrefAlignment();
        PyObject* var_PyObject4 = py_int_from_unsigned(var_unsigned2);
        return var_PyObject4;
    }
    PyErr_SetString(PyExc_TypeError, "Invalid number of args");
    return NULL;
}

static
PyObject*
llvm_DataLayout__getPointerABIAlignment(PyObject* self, PyObject* args)
{
    Py_ssize_t var_Py__ssize__t = PyTuple_Size(args);
    if (2 == var_Py__ssize__t)
    {
        PyObject* var_PyObject;
        PyObject* var_PyObject1;
        if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
        {
            return NULL;
        }
        llvm::DataLayout* var_llvm_DataLayout = NULL;
        if (var_PyObject != Py_None)
        {
            void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Pass");
            if(!var_void)
            {
                puts("Error: llvm::Pass");
                return NULL;
            }
            llvm::DataLayout* var_llvm_DataLayout1 = unwrap_as<llvm::DataLayout, llvm::Pass >::from(var_void);
            if(!var_llvm_DataLayout1)
            {
                return NULL;
            }
            var_llvm_DataLayout = var_llvm_DataLayout1;
        }
        unsigned var_unsigned;
        int var_int = py_int_to(var_PyObject1, var_unsigned);
        if(!var_int)
        {
            return NULL;
        }
        unsigned var_unsigned1 = var_llvm_DataLayout->getPointerABIAlignment(var_unsigned);
        PyObject* var_PyObject2 = py_int_from_unsigned(var_unsigned1);
        return var_PyObject2;
    }
    if (1 == var_Py__ssize__t)
    {
        PyObject* var_PyObject3;
        if(!PyArg_ParseTuple(args, "O", &var_PyObject3))
        {
            return NULL;
        }
        llvm::DataLayout* var_llvm_DataLayout2 = NULL;
        if (var_PyObject3 != Py_None)
        {
            void* var_void1 = PyCapsule_GetPointer(var_PyObject3, "llvm::Pass");
            if(!var_void1)
            {
                puts("Error: llvm::Pass");
                return NULL;
            }
            llvm::DataLayout* var_llvm_DataLayout3 = unwrap_as<llvm::DataLayout, llvm::Pass >::from(var_void1);
            if(!var_llvm_DataLayout3)
            {
                return NULL;
            }
            var_llvm_DataLayout2 = var_llvm_DataLayout3;
        }
        unsigned var_unsigned2 = var_llvm_DataLayout2->getPointerABIAlignment();
        PyObject* var_PyObject4 = py_int_from_unsigned(var_unsigned2);
        return var_PyObject4;
    }
    PyErr_SetString(PyExc_TypeError, "Invalid number of args");
    return NULL;
}

static
PyObject*
llvm_DataLayout____new__string(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::StringRef var_llvm_StringRef;
    int var_int = py_str_to(var_PyObject, var_llvm_StringRef);
    if(!var_int)
    {
        return NULL;
    }
    llvm::DataLayout* var_llvm_DataLayout = new llvm::DataLayout(var_llvm_StringRef);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Pass >::from(var_llvm_DataLayout), "llvm::Pass", "llvm::DataLayout");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyObject*
llvm_DataLayout__getPrefTypeAlignment(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::DataLayout* var_llvm_DataLayout = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Pass");
        if(!var_void)
        {
            puts("Error: llvm::Pass");
            return NULL;
        }
        llvm::DataLayout* var_llvm_DataLayout1 = unwrap_as<llvm::DataLayout, llvm::Pass >::from(var_void);
        if(!var_llvm_DataLayout1)
        {
            return NULL;
        }
        var_llvm_DataLayout = var_llvm_DataLayout1;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject1 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Type");
        if(!var_void1)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void1);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    unsigned var_unsigned = var_llvm_DataLayout->getPrefTypeAlignment(var_llvm_Type);
    PyObject* var_PyObject2 = py_int_from_unsigned(var_unsigned);
    return var_PyObject2;
}

static
PyObject*
llvm_DataLayout__getStringRepresentation(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::DataLayout* var_llvm_DataLayout = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Pass");
        if(!var_void)
        {
            puts("Error: llvm::Pass");
            return NULL;
        }
        llvm::DataLayout* var_llvm_DataLayout1 = unwrap_as<llvm::DataLayout, llvm::Pass >::from(var_void);
        if(!var_llvm_DataLayout1)
        {
            return NULL;
        }
        var_llvm_DataLayout = var_llvm_DataLayout1;
    }
    std::string var_std_string = var_llvm_DataLayout->getStringRepresentation();
    PyObject* var_PyObject1 = py_str_from(var_std_string);
    return var_PyObject1;
}

static
PyObject*
llvm_DataLayout__exceedsNaturalStackAlignment(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::DataLayout* var_llvm_DataLayout = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Pass");
        if(!var_void)
        {
            puts("Error: llvm::Pass");
            return NULL;
        }
        llvm::DataLayout* var_llvm_DataLayout1 = unwrap_as<llvm::DataLayout, llvm::Pass >::from(var_void);
        if(!var_llvm_DataLayout1)
        {
            return NULL;
        }
        var_llvm_DataLayout = var_llvm_DataLayout1;
    }
    unsigned var_unsigned;
    int var_int = py_int_to(var_PyObject1, var_unsigned);
    if(!var_int)
    {
        return NULL;
    }
    bool var_bool = var_llvm_DataLayout->exceedsNaturalStackAlignment(var_unsigned);
    PyObject* var_PyObject2 = py_bool_from(var_bool);
    return var_PyObject2;
}

static
PyObject*
llvm_DataLayout__getTypeStoreSize(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::DataLayout* var_llvm_DataLayout = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Pass");
        if(!var_void)
        {
            puts("Error: llvm::Pass");
            return NULL;
        }
        llvm::DataLayout* var_llvm_DataLayout1 = unwrap_as<llvm::DataLayout, llvm::Pass >::from(var_void);
        if(!var_llvm_DataLayout1)
        {
            return NULL;
        }
        var_llvm_DataLayout = var_llvm_DataLayout1;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject1 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Type");
        if(!var_void1)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void1);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    uint64_t var_uint64__t = var_llvm_DataLayout->getTypeStoreSize(var_llvm_Type);
    PyObject* var_PyObject2 = py_int_from_unsigned(var_uint64__t);
    return var_PyObject2;
}

static
PyObject*
llvm_DataLayout__getABIIntegerTypeAlignment(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::DataLayout* var_llvm_DataLayout = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Pass");
        if(!var_void)
        {
            puts("Error: llvm::Pass");
            return NULL;
        }
        llvm::DataLayout* var_llvm_DataLayout1 = unwrap_as<llvm::DataLayout, llvm::Pass >::from(var_void);
        if(!var_llvm_DataLayout1)
        {
            return NULL;
        }
        var_llvm_DataLayout = var_llvm_DataLayout1;
    }
    unsigned var_unsigned;
    int var_int = py_int_to(var_PyObject1, var_unsigned);
    if(!var_int)
    {
        return NULL;
    }
    unsigned var_unsigned1 = var_llvm_DataLayout->getABIIntegerTypeAlignment(var_unsigned);
    PyObject* var_PyObject2 = py_int_from_unsigned(var_unsigned1);
    return var_PyObject2;
}

static
PyMethodDef meth_llvm_DataLayout[] = {
    { "getPointerSize", (PyCFunction)llvm_DataLayout__getPointerSize, METH_VARARGS, NULL },
    { "fitsInLegalInteger", (PyCFunction)llvm_DataLayout__fitsInLegalInteger, METH_VARARGS, NULL },
    { "getStructLayout", (PyCFunction)llvm_DataLayout__getStructLayout, METH_VARARGS, NULL },
    { "getCallFrameTypeAlignment", (PyCFunction)llvm_DataLayout__getCallFrameTypeAlignment, METH_VARARGS, NULL },
    { "isIllegalInteger", (PyCFunction)llvm_DataLayout__isIllegalInteger, METH_VARARGS, NULL },
    { "getABITypeAlignment", (PyCFunction)llvm_DataLayout__getABITypeAlignment, METH_VARARGS, NULL },
    { "getPreferredAlignment", (PyCFunction)llvm_DataLayout__getPreferredAlignment, METH_VARARGS, NULL },
    { "isLittleEndian", (PyCFunction)llvm_DataLayout__isLittleEndian, METH_VARARGS, NULL },
    { "_new_module", (PyCFunction)llvm_DataLayout____new__module, METH_VARARGS, NULL },
    { "_getIndexedOffset", (PyCFunction)llvm_DataLayout____getIndexedOffset, METH_VARARGS, NULL },
    { "getPreferredTypeAlignmentShift", (PyCFunction)llvm_DataLayout__getPreferredTypeAlignmentShift, METH_VARARGS, NULL },
    { "_getIntPtrType2", (PyCFunction)llvm_DataLayout____getIntPtrType2, METH_VARARGS, NULL },
    { "isBigEndian", (PyCFunction)llvm_DataLayout__isBigEndian, METH_VARARGS, NULL },
    { "isLegalInteger", (PyCFunction)llvm_DataLayout__isLegalInteger, METH_VARARGS, NULL },
    { "getTypeAllocSize", (PyCFunction)llvm_DataLayout__getTypeAllocSize, METH_VARARGS, NULL },
    { "getTypeStoreSizeInBits", (PyCFunction)llvm_DataLayout__getTypeStoreSizeInBits, METH_VARARGS, NULL },
    { "getPointerSizeInBits", (PyCFunction)llvm_DataLayout__getPointerSizeInBits, METH_VARARGS, NULL },
    { "getPreferredAlignmentLog", (PyCFunction)llvm_DataLayout__getPreferredAlignmentLog, METH_VARARGS, NULL },
    { "getTypeAllocSizeInBits", (PyCFunction)llvm_DataLayout__getTypeAllocSizeInBits, METH_VARARGS, NULL },
    { "_getIntPtrType", (PyCFunction)llvm_DataLayout____getIntPtrType, METH_VARARGS, NULL },
    { "getTypeSizeInBits", (PyCFunction)llvm_DataLayout__getTypeSizeInBits, METH_VARARGS, NULL },
    { "getPointerPrefAlignment", (PyCFunction)llvm_DataLayout__getPointerPrefAlignment, METH_VARARGS, NULL },
    { "getPointerABIAlignment", (PyCFunction)llvm_DataLayout__getPointerABIAlignment, METH_VARARGS, NULL },
    { "_new_string", (PyCFunction)llvm_DataLayout____new__string, METH_VARARGS, NULL },
    { "getPrefTypeAlignment", (PyCFunction)llvm_DataLayout__getPrefTypeAlignment, METH_VARARGS, NULL },
    { "getStringRepresentation", (PyCFunction)llvm_DataLayout__getStringRepresentation, METH_VARARGS, NULL },
    { "exceedsNaturalStackAlignment", (PyCFunction)llvm_DataLayout__exceedsNaturalStackAlignment, METH_VARARGS, NULL },
    { "getTypeStoreSize", (PyCFunction)llvm_DataLayout__getTypeStoreSize, METH_VARARGS, NULL },
    { "getABIIntegerTypeAlignment", (PyCFunction)llvm_DataLayout__getABIIntegerTypeAlignment, METH_VARARGS, NULL },
    { NULL },
};

static
SubModuleEntry submodule_llvm_DataLayout[] = {
    { NULL }
};

static
PyObject*
llvm_StructLayout__getSizeInBits(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::StructLayout* var_llvm_StructLayout = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::StructLayout");
        if(!var_void)
        {
            puts("Error: llvm::StructLayout");
            return NULL;
        }
        llvm::StructLayout* var_llvm_StructLayout1 = unwrap_as<llvm::StructLayout, llvm::StructLayout >::from(var_void);
        if(!var_llvm_StructLayout1)
        {
            return NULL;
        }
        var_llvm_StructLayout = var_llvm_StructLayout1;
    }
    uint64_t var_uint64__t = var_llvm_StructLayout->getSizeInBits();
    PyObject* var_PyObject1 = py_int_from_unsigned(var_uint64__t);
    return var_PyObject1;
}

static
PyObject*
llvm_StructLayout__getElementOffset(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::StructLayout* var_llvm_StructLayout = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::StructLayout");
        if(!var_void)
        {
            puts("Error: llvm::StructLayout");
            return NULL;
        }
        llvm::StructLayout* var_llvm_StructLayout1 = unwrap_as<llvm::StructLayout, llvm::StructLayout >::from(var_void);
        if(!var_llvm_StructLayout1)
        {
            return NULL;
        }
        var_llvm_StructLayout = var_llvm_StructLayout1;
    }
    unsigned var_unsigned;
    int var_int = py_int_to(var_PyObject1, var_unsigned);
    if(!var_int)
    {
        return NULL;
    }
    uint64_t var_uint64__t = var_llvm_StructLayout->getElementOffset(var_unsigned);
    PyObject* var_PyObject2 = py_int_from_unsigned(var_uint64__t);
    return var_PyObject2;
}

static
PyObject*
llvm_StructLayout__getSizeInBytes(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::StructLayout* var_llvm_StructLayout = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::StructLayout");
        if(!var_void)
        {
            puts("Error: llvm::StructLayout");
            return NULL;
        }
        llvm::StructLayout* var_llvm_StructLayout1 = unwrap_as<llvm::StructLayout, llvm::StructLayout >::from(var_void);
        if(!var_llvm_StructLayout1)
        {
            return NULL;
        }
        var_llvm_StructLayout = var_llvm_StructLayout1;
    }
    uint64_t var_uint64__t = var_llvm_StructLayout->getSizeInBytes();
    PyObject* var_PyObject1 = py_int_from_unsigned(var_uint64__t);
    return var_PyObject1;
}

static
PyObject*
llvm_StructLayout__getAlignment(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::StructLayout* var_llvm_StructLayout = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::StructLayout");
        if(!var_void)
        {
            puts("Error: llvm::StructLayout");
            return NULL;
        }
        llvm::StructLayout* var_llvm_StructLayout1 = unwrap_as<llvm::StructLayout, llvm::StructLayout >::from(var_void);
        if(!var_llvm_StructLayout1)
        {
            return NULL;
        }
        var_llvm_StructLayout = var_llvm_StructLayout1;
    }
    unsigned var_unsigned = var_llvm_StructLayout->getAlignment();
    PyObject* var_PyObject1 = py_int_from_unsigned(var_unsigned);
    return var_PyObject1;
}

static
PyObject*
llvm_StructLayout__getElementOffsetInBits(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::StructLayout* var_llvm_StructLayout = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::StructLayout");
        if(!var_void)
        {
            puts("Error: llvm::StructLayout");
            return NULL;
        }
        llvm::StructLayout* var_llvm_StructLayout1 = unwrap_as<llvm::StructLayout, llvm::StructLayout >::from(var_void);
        if(!var_llvm_StructLayout1)
        {
            return NULL;
        }
        var_llvm_StructLayout = var_llvm_StructLayout1;
    }
    unsigned var_unsigned;
    int var_int = py_int_to(var_PyObject1, var_unsigned);
    if(!var_int)
    {
        return NULL;
    }
    uint64_t var_uint64__t = var_llvm_StructLayout->getElementOffsetInBits(var_unsigned);
    PyObject* var_PyObject2 = py_int_from_unsigned(var_uint64__t);
    return var_PyObject2;
}

static
PyObject*
llvm_StructLayout__getElementContainingOffset(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::StructLayout* var_llvm_StructLayout = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::StructLayout");
        if(!var_void)
        {
            puts("Error: llvm::StructLayout");
            return NULL;
        }
        llvm::StructLayout* var_llvm_StructLayout1 = unwrap_as<llvm::StructLayout, llvm::StructLayout >::from(var_void);
        if(!var_llvm_StructLayout1)
        {
            return NULL;
        }
        var_llvm_StructLayout = var_llvm_StructLayout1;
    }
    uint64_t var_uint64__t;
    int var_int = py_int_to(var_PyObject1, var_uint64__t);
    if(!var_int)
    {
        return NULL;
    }
    unsigned var_unsigned = var_llvm_StructLayout->getElementContainingOffset(var_uint64__t);
    PyObject* var_PyObject2 = py_int_from_unsigned(var_unsigned);
    return var_PyObject2;
}

static
PyMethodDef meth_llvm_StructLayout[] = {
    { "getSizeInBits", (PyCFunction)llvm_StructLayout__getSizeInBits, METH_VARARGS, NULL },
    { "getElementOffset", (PyCFunction)llvm_StructLayout__getElementOffset, METH_VARARGS, NULL },
    { "getSizeInBytes", (PyCFunction)llvm_StructLayout__getSizeInBytes, METH_VARARGS, NULL },
    { "getAlignment", (PyCFunction)llvm_StructLayout__getAlignment, METH_VARARGS, NULL },
    { "getElementOffsetInBits", (PyCFunction)llvm_StructLayout__getElementOffsetInBits, METH_VARARGS, NULL },
    { "getElementContainingOffset", (PyCFunction)llvm_StructLayout__getElementContainingOffset, METH_VARARGS, NULL },
    { NULL },
};

static
SubModuleEntry submodule_llvm_StructLayout[] = {
    { NULL }
};

static
PyObject*
llvm_Type__isPrimitiveType(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    bool var_bool = var_llvm_Type->isPrimitiveType();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Type__getInt1Ty(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::LLVMContext");
    if(!var_void)
    {
        puts("Error: llvm::LLVMContext");
        return NULL;
    }
    llvm::LLVMContext* var_llvm_LLVMContext = unwrap_as<llvm::LLVMContext, llvm::LLVMContext >::from(var_void);
    if(!var_llvm_LLVMContext)
    {
        return NULL;
    }
    llvm::LLVMContext& var_llvm_LLVMContext1 = *var_llvm_LLVMContext;
    llvm::IntegerType* var_llvm_IntegerType = llvm::Type::getInt1Ty(var_llvm_LLVMContext1);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Type >::from(var_llvm_IntegerType), "llvm::Type", "llvm::IntegerType");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyObject*
llvm_Type__isFunctionVarArg(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    bool var_bool = var_llvm_Type->isFunctionVarArg();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Type__isFirstClassType(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    bool var_bool = var_llvm_Type->isFirstClassType();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Type__getX86__MMXTy(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::LLVMContext");
    if(!var_void)
    {
        puts("Error: llvm::LLVMContext");
        return NULL;
    }
    llvm::LLVMContext* var_llvm_LLVMContext = unwrap_as<llvm::LLVMContext, llvm::LLVMContext >::from(var_void);
    if(!var_llvm_LLVMContext)
    {
        return NULL;
    }
    llvm::LLVMContext& var_llvm_LLVMContext1 = *var_llvm_LLVMContext;
    llvm::Type* var_llvm_Type = llvm::Type::getX86_MMXTy(var_llvm_LLVMContext1);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Type >::from(var_llvm_Type), "llvm::Type", "llvm::Type");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyObject*
llvm_Type__isFloatingPointTy(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    bool var_bool = var_llvm_Type->isFloatingPointTy();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Type__getContext(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    llvm::LLVMContext& var_llvm_LLVMContext = var_llvm_Type->getContext();
    const llvm::LLVMContext* var_const_llvm_LLVMContext = &var_llvm_LLVMContext;
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::LLVMContext >::from(var_const_llvm_LLVMContext), "llvm::LLVMContext", "llvm::LLVMContext");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyObject*
llvm_Type__getPointerTo(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    unsigned var_unsigned;
    int var_int = py_int_to(var_PyObject1, var_unsigned);
    if(!var_int)
    {
        return NULL;
    }
    llvm::PointerType* var_llvm_PointerType = var_llvm_Type->getPointerTo(var_unsigned);
    PyObject* var_PyObject2 = pycapsule_new(cast_to_base<llvm::Type >::from(var_llvm_PointerType), "llvm::Type", "llvm::PointerType");
    if (!var_PyObject2)
    {
        return NULL;
    }
    return var_PyObject2;
}

static
PyObject*
llvm_Type__isFunctionTy(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    bool var_bool = var_llvm_Type->isFunctionTy();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Type__getX86__FP80PtrTy(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::LLVMContext");
    if(!var_void)
    {
        puts("Error: llvm::LLVMContext");
        return NULL;
    }
    llvm::LLVMContext* var_llvm_LLVMContext = unwrap_as<llvm::LLVMContext, llvm::LLVMContext >::from(var_void);
    if(!var_llvm_LLVMContext)
    {
        return NULL;
    }
    llvm::LLVMContext& var_llvm_LLVMContext1 = *var_llvm_LLVMContext;
    llvm::PointerType* var_llvm_PointerType = llvm::Type::getX86_FP80PtrTy(var_llvm_LLVMContext1);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Type >::from(var_llvm_PointerType), "llvm::Type", "llvm::PointerType");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyObject*
llvm_Type__getNumContainedTypes(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    unsigned var_unsigned = var_llvm_Type->getNumContainedTypes();
    PyObject* var_PyObject1 = py_int_from_unsigned(var_unsigned);
    return var_PyObject1;
}

static
PyObject*
llvm_Type__isEmptyTy(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    bool var_bool = var_llvm_Type->isEmptyTy();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Type__getX86__MMXPtrTy(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::LLVMContext");
    if(!var_void)
    {
        puts("Error: llvm::LLVMContext");
        return NULL;
    }
    llvm::LLVMContext* var_llvm_LLVMContext = unwrap_as<llvm::LLVMContext, llvm::LLVMContext >::from(var_void);
    if(!var_llvm_LLVMContext)
    {
        return NULL;
    }
    llvm::LLVMContext& var_llvm_LLVMContext1 = *var_llvm_LLVMContext;
    llvm::PointerType* var_llvm_PointerType = llvm::Type::getX86_MMXPtrTy(var_llvm_LLVMContext1);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Type >::from(var_llvm_PointerType), "llvm::Type", "llvm::PointerType");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyObject*
llvm_Type__getInt16PtrTy(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::LLVMContext");
    if(!var_void)
    {
        puts("Error: llvm::LLVMContext");
        return NULL;
    }
    llvm::LLVMContext* var_llvm_LLVMContext = unwrap_as<llvm::LLVMContext, llvm::LLVMContext >::from(var_void);
    if(!var_llvm_LLVMContext)
    {
        return NULL;
    }
    llvm::LLVMContext& var_llvm_LLVMContext1 = *var_llvm_LLVMContext;
    llvm::PointerType* var_llvm_PointerType = llvm::Type::getInt16PtrTy(var_llvm_LLVMContext1);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Type >::from(var_llvm_PointerType), "llvm::Type", "llvm::PointerType");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyObject*
llvm_Type__getInt1PtrTy(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::LLVMContext");
    if(!var_void)
    {
        puts("Error: llvm::LLVMContext");
        return NULL;
    }
    llvm::LLVMContext* var_llvm_LLVMContext = unwrap_as<llvm::LLVMContext, llvm::LLVMContext >::from(var_void);
    if(!var_llvm_LLVMContext)
    {
        return NULL;
    }
    llvm::LLVMContext& var_llvm_LLVMContext1 = *var_llvm_LLVMContext;
    llvm::PointerType* var_llvm_PointerType = llvm::Type::getInt1PtrTy(var_llvm_LLVMContext1);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Type >::from(var_llvm_PointerType), "llvm::Type", "llvm::PointerType");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyObject*
llvm_Type__isStructTy(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    bool var_bool = var_llvm_Type->isStructTy();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Type__isFP128Ty(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    bool var_bool = var_llvm_Type->isFP128Ty();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Type__isFloatTy(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    bool var_bool = var_llvm_Type->isFloatTy();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Type__getFP128Ty(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::LLVMContext");
    if(!var_void)
    {
        puts("Error: llvm::LLVMContext");
        return NULL;
    }
    llvm::LLVMContext* var_llvm_LLVMContext = unwrap_as<llvm::LLVMContext, llvm::LLVMContext >::from(var_void);
    if(!var_llvm_LLVMContext)
    {
        return NULL;
    }
    llvm::LLVMContext& var_llvm_LLVMContext1 = *var_llvm_LLVMContext;
    llvm::Type* var_llvm_Type = llvm::Type::getFP128Ty(var_llvm_LLVMContext1);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Type >::from(var_llvm_Type), "llvm::Type", "llvm::Type");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyObject*
llvm_Type__getArrayElementType(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    llvm::Type* var_llvm_Type2 = var_llvm_Type->getArrayElementType();
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Type >::from(var_llvm_Type2), "llvm::Type", "llvm::Type");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyObject*
llvm_Type__isPointerTy(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    bool var_bool = var_llvm_Type->isPointerTy();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Type__getStructName(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    llvm::StringRef var_llvm_StringRef = var_llvm_Type->getStructName();
    PyObject* var_PyObject1 = py_str_from(var_llvm_StringRef);
    return var_PyObject1;
}

static
PyObject*
llvm_Type__getInt32Ty(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::LLVMContext");
    if(!var_void)
    {
        puts("Error: llvm::LLVMContext");
        return NULL;
    }
    llvm::LLVMContext* var_llvm_LLVMContext = unwrap_as<llvm::LLVMContext, llvm::LLVMContext >::from(var_void);
    if(!var_llvm_LLVMContext)
    {
        return NULL;
    }
    llvm::LLVMContext& var_llvm_LLVMContext1 = *var_llvm_LLVMContext;
    llvm::IntegerType* var_llvm_IntegerType = llvm::Type::getInt32Ty(var_llvm_LLVMContext1);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Type >::from(var_llvm_IntegerType), "llvm::Type", "llvm::IntegerType");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyObject*
llvm_Type__isSingleValueType(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    bool var_bool = var_llvm_Type->isSingleValueType();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Type__getIntNTy(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::LLVMContext");
    if(!var_void)
    {
        puts("Error: llvm::LLVMContext");
        return NULL;
    }
    llvm::LLVMContext* var_llvm_LLVMContext = unwrap_as<llvm::LLVMContext, llvm::LLVMContext >::from(var_void);
    if(!var_llvm_LLVMContext)
    {
        return NULL;
    }
    llvm::LLVMContext& var_llvm_LLVMContext1 = *var_llvm_LLVMContext;
    unsigned var_unsigned;
    int var_int = py_int_to(var_PyObject1, var_unsigned);
    if(!var_int)
    {
        return NULL;
    }
    llvm::IntegerType* var_llvm_IntegerType = llvm::Type::getIntNTy(var_llvm_LLVMContext1, var_unsigned);
    PyObject* var_PyObject2 = pycapsule_new(cast_to_base<llvm::Type >::from(var_llvm_IntegerType), "llvm::Type", "llvm::IntegerType");
    if (!var_PyObject2)
    {
        return NULL;
    }
    return var_PyObject2;
}

static
PyObject*
llvm_Type__getHalfPtrTy(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::LLVMContext");
    if(!var_void)
    {
        puts("Error: llvm::LLVMContext");
        return NULL;
    }
    llvm::LLVMContext* var_llvm_LLVMContext = unwrap_as<llvm::LLVMContext, llvm::LLVMContext >::from(var_void);
    if(!var_llvm_LLVMContext)
    {
        return NULL;
    }
    llvm::LLVMContext& var_llvm_LLVMContext1 = *var_llvm_LLVMContext;
    llvm::PointerType* var_llvm_PointerType = llvm::Type::getHalfPtrTy(var_llvm_LLVMContext1);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Type >::from(var_llvm_PointerType), "llvm::Type", "llvm::PointerType");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyObject*
llvm_Type__isHalfTy(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    bool var_bool = var_llvm_Type->isHalfTy();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Type__getInt64PtrTy(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::LLVMContext");
    if(!var_void)
    {
        puts("Error: llvm::LLVMContext");
        return NULL;
    }
    llvm::LLVMContext* var_llvm_LLVMContext = unwrap_as<llvm::LLVMContext, llvm::LLVMContext >::from(var_void);
    if(!var_llvm_LLVMContext)
    {
        return NULL;
    }
    llvm::LLVMContext& var_llvm_LLVMContext1 = *var_llvm_LLVMContext;
    llvm::PointerType* var_llvm_PointerType = llvm::Type::getInt64PtrTy(var_llvm_LLVMContext1);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Type >::from(var_llvm_PointerType), "llvm::Type", "llvm::PointerType");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyObject*
llvm_Type__isDerivedType(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    bool var_bool = var_llvm_Type->isDerivedType();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Type__getFunctionParamType(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    unsigned var_unsigned;
    int var_int = py_int_to(var_PyObject1, var_unsigned);
    if(!var_int)
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type2 = var_llvm_Type->getFunctionParamType(var_unsigned);
    PyObject* var_PyObject2 = pycapsule_new(cast_to_base<llvm::Type >::from(var_llvm_Type2), "llvm::Type", "llvm::Type");
    if (!var_PyObject2)
    {
        return NULL;
    }
    return var_PyObject2;
}

static
PyObject*
llvm_Type__isIntegerTy(PyObject* self, PyObject* args)
{
    Py_ssize_t var_Py__ssize__t = PyTuple_Size(args);
    if (1 == var_Py__ssize__t)
    {
        PyObject* var_PyObject;
        if(!PyArg_ParseTuple(args, "O", &var_PyObject))
        {
            return NULL;
        }
        llvm::Type* var_llvm_Type = NULL;
        if (var_PyObject != Py_None)
        {
            void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
            if(!var_void)
            {
                puts("Error: llvm::Type");
                return NULL;
            }
            llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
            if(!var_llvm_Type1)
            {
                return NULL;
            }
            var_llvm_Type = var_llvm_Type1;
        }
        bool var_bool = var_llvm_Type->isIntegerTy();
        PyObject* var_PyObject1 = py_bool_from(var_bool);
        return var_PyObject1;
    }
    if (2 == var_Py__ssize__t)
    {
        PyObject* var_PyObject2;
        PyObject* var_PyObject3;
        if(!PyArg_ParseTuple(args, "OO", &var_PyObject2, &var_PyObject3))
        {
            return NULL;
        }
        llvm::Type* var_llvm_Type2 = NULL;
        if (var_PyObject2 != Py_None)
        {
            void* var_void1 = PyCapsule_GetPointer(var_PyObject2, "llvm::Type");
            if(!var_void1)
            {
                puts("Error: llvm::Type");
                return NULL;
            }
            llvm::Type* var_llvm_Type3 = unwrap_as<llvm::Type, llvm::Type >::from(var_void1);
            if(!var_llvm_Type3)
            {
                return NULL;
            }
            var_llvm_Type2 = var_llvm_Type3;
        }
        unsigned var_unsigned;
        int var_int = py_int_to(var_PyObject3, var_unsigned);
        if(!var_int)
        {
            return NULL;
        }
        bool var_bool1 = var_llvm_Type2->isIntegerTy(var_unsigned);
        PyObject* var_PyObject4 = py_bool_from(var_bool1);
        return var_PyObject4;
    }
    PyErr_SetString(PyExc_TypeError, "Invalid number of args");
    return NULL;
}

static
PyObject*
llvm_Type__isPtrOrPtrVectorTy(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    bool var_bool = var_llvm_Type->isPtrOrPtrVectorTy();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Type__getHalfTy(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::LLVMContext");
    if(!var_void)
    {
        puts("Error: llvm::LLVMContext");
        return NULL;
    }
    llvm::LLVMContext* var_llvm_LLVMContext = unwrap_as<llvm::LLVMContext, llvm::LLVMContext >::from(var_void);
    if(!var_llvm_LLVMContext)
    {
        return NULL;
    }
    llvm::LLVMContext& var_llvm_LLVMContext1 = *var_llvm_LLVMContext;
    llvm::Type* var_llvm_Type = llvm::Type::getHalfTy(var_llvm_LLVMContext1);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Type >::from(var_llvm_Type), "llvm::Type", "llvm::Type");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyObject*
llvm_Type__getVectorElementType(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    llvm::Type* var_llvm_Type2 = var_llvm_Type->getVectorElementType();
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Type >::from(var_llvm_Type2), "llvm::Type", "llvm::Type");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyObject*
llvm_Type__getIntNPtrTy(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::LLVMContext");
    if(!var_void)
    {
        puts("Error: llvm::LLVMContext");
        return NULL;
    }
    llvm::LLVMContext* var_llvm_LLVMContext = unwrap_as<llvm::LLVMContext, llvm::LLVMContext >::from(var_void);
    if(!var_llvm_LLVMContext)
    {
        return NULL;
    }
    llvm::LLVMContext& var_llvm_LLVMContext1 = *var_llvm_LLVMContext;
    unsigned var_unsigned;
    int var_int = py_int_to(var_PyObject1, var_unsigned);
    if(!var_int)
    {
        return NULL;
    }
    llvm::PointerType* var_llvm_PointerType = llvm::Type::getIntNPtrTy(var_llvm_LLVMContext1, var_unsigned);
    PyObject* var_PyObject2 = pycapsule_new(cast_to_base<llvm::Type >::from(var_llvm_PointerType), "llvm::Type", "llvm::PointerType");
    if (!var_PyObject2)
    {
        return NULL;
    }
    return var_PyObject2;
}

static
PyObject*
llvm_Type__getPPC__FP128Ty(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::LLVMContext");
    if(!var_void)
    {
        puts("Error: llvm::LLVMContext");
        return NULL;
    }
    llvm::LLVMContext* var_llvm_LLVMContext = unwrap_as<llvm::LLVMContext, llvm::LLVMContext >::from(var_void);
    if(!var_llvm_LLVMContext)
    {
        return NULL;
    }
    llvm::LLVMContext& var_llvm_LLVMContext1 = *var_llvm_LLVMContext;
    llvm::Type* var_llvm_Type = llvm::Type::getPPC_FP128Ty(var_llvm_LLVMContext1);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Type >::from(var_llvm_Type), "llvm::Type", "llvm::Type");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyObject*
llvm_Type__getVectorNumElements(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    unsigned var_unsigned = var_llvm_Type->getVectorNumElements();
    PyObject* var_PyObject1 = py_int_from_unsigned(var_unsigned);
    return var_PyObject1;
}

static
PyObject*
llvm_Type__isFPOrFPVectorTy(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    bool var_bool = var_llvm_Type->isFPOrFPVectorTy();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Type__isAggregateType(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    bool var_bool = var_llvm_Type->isAggregateType();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Type__getFunctionNumParams(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    unsigned var_unsigned = var_llvm_Type->getFunctionNumParams();
    PyObject* var_PyObject1 = py_int_from_unsigned(var_unsigned);
    return var_PyObject1;
}

static
PyObject*
llvm_Type__isArrayTy(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    bool var_bool = var_llvm_Type->isArrayTy();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Type__getInt8PtrTy(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::LLVMContext");
    if(!var_void)
    {
        puts("Error: llvm::LLVMContext");
        return NULL;
    }
    llvm::LLVMContext* var_llvm_LLVMContext = unwrap_as<llvm::LLVMContext, llvm::LLVMContext >::from(var_void);
    if(!var_llvm_LLVMContext)
    {
        return NULL;
    }
    llvm::LLVMContext& var_llvm_LLVMContext1 = *var_llvm_LLVMContext;
    llvm::PointerType* var_llvm_PointerType = llvm::Type::getInt8PtrTy(var_llvm_LLVMContext1);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Type >::from(var_llvm_PointerType), "llvm::Type", "llvm::PointerType");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyObject*
llvm_Type__isIntOrIntVectorTy(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    bool var_bool = var_llvm_Type->isIntOrIntVectorTy();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Type__getIntegerBitWidth(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    unsigned var_unsigned = var_llvm_Type->getIntegerBitWidth();
    PyObject* var_PyObject1 = py_int_from_unsigned(var_unsigned);
    return var_PyObject1;
}

static
PyObject*
llvm_Type__getInt8Ty(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::LLVMContext");
    if(!var_void)
    {
        puts("Error: llvm::LLVMContext");
        return NULL;
    }
    llvm::LLVMContext* var_llvm_LLVMContext = unwrap_as<llvm::LLVMContext, llvm::LLVMContext >::from(var_void);
    if(!var_llvm_LLVMContext)
    {
        return NULL;
    }
    llvm::LLVMContext& var_llvm_LLVMContext1 = *var_llvm_LLVMContext;
    llvm::IntegerType* var_llvm_IntegerType = llvm::Type::getInt8Ty(var_llvm_LLVMContext1);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Type >::from(var_llvm_IntegerType), "llvm::Type", "llvm::IntegerType");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyObject*
llvm_Type__isX86__FP80Ty(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    bool var_bool = var_llvm_Type->isX86_FP80Ty();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Type__getSequentialElementType(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    llvm::Type* var_llvm_Type2 = var_llvm_Type->getSequentialElementType();
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Type >::from(var_llvm_Type2), "llvm::Type", "llvm::Type");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyObject*
llvm_Type__print__(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::raw_ostream");
    if(!var_void1)
    {
        puts("Error: llvm::raw_ostream");
        return NULL;
    }
    llvm::raw_ostream* var_llvm_raw__ostream = unwrap_as<llvm::raw_ostream, llvm::raw_ostream >::from(var_void1);
    if(!var_llvm_raw__ostream)
    {
        return NULL;
    }
    llvm::raw_ostream& var_llvm_raw__ostream1 = *var_llvm_raw__ostream;
    var_llvm_Type->print(var_llvm_raw__ostream1);
    Py_RETURN_NONE;
}

static
PyObject*
llvm_Type__getContainedType(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    unsigned var_unsigned;
    int var_int = py_int_to(var_PyObject1, var_unsigned);
    if(!var_int)
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type2 = var_llvm_Type->getContainedType(var_unsigned);
    PyObject* var_PyObject2 = pycapsule_new(cast_to_base<llvm::Type >::from(var_llvm_Type2), "llvm::Type", "llvm::Type");
    if (!var_PyObject2)
    {
        return NULL;
    }
    return var_PyObject2;
}

static
PyObject*
llvm_Type__getStructElementType(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    unsigned var_unsigned;
    int var_int = py_int_to(var_PyObject1, var_unsigned);
    if(!var_int)
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type2 = var_llvm_Type->getStructElementType(var_unsigned);
    PyObject* var_PyObject2 = pycapsule_new(cast_to_base<llvm::Type >::from(var_llvm_Type2), "llvm::Type", "llvm::Type");
    if (!var_PyObject2)
    {
        return NULL;
    }
    return var_PyObject2;
}

static
PyObject*
llvm_Type__isSized(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    bool var_bool = var_llvm_Type->isSized();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Type__isVoidTy(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    bool var_bool = var_llvm_Type->isVoidTy();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Type__getVoidTy(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::LLVMContext");
    if(!var_void)
    {
        puts("Error: llvm::LLVMContext");
        return NULL;
    }
    llvm::LLVMContext* var_llvm_LLVMContext = unwrap_as<llvm::LLVMContext, llvm::LLVMContext >::from(var_void);
    if(!var_llvm_LLVMContext)
    {
        return NULL;
    }
    llvm::LLVMContext& var_llvm_LLVMContext1 = *var_llvm_LLVMContext;
    llvm::Type* var_llvm_Type = llvm::Type::getVoidTy(var_llvm_LLVMContext1);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Type >::from(var_llvm_Type), "llvm::Type", "llvm::Type");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyObject*
llvm_Type__isLabelTy(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    bool var_bool = var_llvm_Type->isLabelTy();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Type__isMetadataTy(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    bool var_bool = var_llvm_Type->isMetadataTy();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Type__getStructNumElements(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    unsigned var_unsigned = var_llvm_Type->getStructNumElements();
    PyObject* var_PyObject1 = py_int_from_unsigned(var_unsigned);
    return var_PyObject1;
}

static
PyObject*
llvm_Type__getTypeID(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    llvm::Type::TypeID var_llvm_Type_TypeID = var_llvm_Type->getTypeID();
    PyObject* var_PyObject1 = PyInt_FromLong(var_llvm_Type_TypeID);
    return var_PyObject1;
}

static
PyObject*
llvm_Type__getPointerAddressSpace(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    unsigned var_unsigned = var_llvm_Type->getPointerAddressSpace();
    PyObject* var_PyObject1 = py_int_from_unsigned(var_unsigned);
    return var_PyObject1;
}

static
PyObject*
llvm_Type__getInt32PtrTy(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::LLVMContext");
    if(!var_void)
    {
        puts("Error: llvm::LLVMContext");
        return NULL;
    }
    llvm::LLVMContext* var_llvm_LLVMContext = unwrap_as<llvm::LLVMContext, llvm::LLVMContext >::from(var_void);
    if(!var_llvm_LLVMContext)
    {
        return NULL;
    }
    llvm::LLVMContext& var_llvm_LLVMContext1 = *var_llvm_LLVMContext;
    llvm::PointerType* var_llvm_PointerType = llvm::Type::getInt32PtrTy(var_llvm_LLVMContext1);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Type >::from(var_llvm_PointerType), "llvm::Type", "llvm::PointerType");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyObject*
llvm_Type__getPointerElementType(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    llvm::Type* var_llvm_Type2 = var_llvm_Type->getPointerElementType();
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Type >::from(var_llvm_Type2), "llvm::Type", "llvm::Type");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyObject*
llvm_Type__getMetadataTy(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::LLVMContext");
    if(!var_void)
    {
        puts("Error: llvm::LLVMContext");
        return NULL;
    }
    llvm::LLVMContext* var_llvm_LLVMContext = unwrap_as<llvm::LLVMContext, llvm::LLVMContext >::from(var_void);
    if(!var_llvm_LLVMContext)
    {
        return NULL;
    }
    llvm::LLVMContext& var_llvm_LLVMContext1 = *var_llvm_LLVMContext;
    llvm::Type* var_llvm_Type = llvm::Type::getMetadataTy(var_llvm_LLVMContext1);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Type >::from(var_llvm_Type), "llvm::Type", "llvm::Type");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyObject*
llvm_Type__getPPC__FP128PtrTy(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::LLVMContext");
    if(!var_void)
    {
        puts("Error: llvm::LLVMContext");
        return NULL;
    }
    llvm::LLVMContext* var_llvm_LLVMContext = unwrap_as<llvm::LLVMContext, llvm::LLVMContext >::from(var_void);
    if(!var_llvm_LLVMContext)
    {
        return NULL;
    }
    llvm::LLVMContext& var_llvm_LLVMContext1 = *var_llvm_LLVMContext;
    llvm::PointerType* var_llvm_PointerType = llvm::Type::getPPC_FP128PtrTy(var_llvm_LLVMContext1);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Type >::from(var_llvm_PointerType), "llvm::Type", "llvm::PointerType");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyObject*
llvm_Type__getArrayNumElements(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    uint64_t var_uint64__t = var_llvm_Type->getArrayNumElements();
    PyObject* var_PyObject1 = py_int_from_unsigned(var_uint64__t);
    return var_PyObject1;
}

static
PyObject*
llvm_Type__getInt16Ty(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::LLVMContext");
    if(!var_void)
    {
        puts("Error: llvm::LLVMContext");
        return NULL;
    }
    llvm::LLVMContext* var_llvm_LLVMContext = unwrap_as<llvm::LLVMContext, llvm::LLVMContext >::from(var_void);
    if(!var_llvm_LLVMContext)
    {
        return NULL;
    }
    llvm::LLVMContext& var_llvm_LLVMContext1 = *var_llvm_LLVMContext;
    llvm::IntegerType* var_llvm_IntegerType = llvm::Type::getInt16Ty(var_llvm_LLVMContext1);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Type >::from(var_llvm_IntegerType), "llvm::Type", "llvm::IntegerType");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyObject*
llvm_Type__dump(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    var_llvm_Type->dump();
    Py_RETURN_NONE;
}

static
PyObject*
llvm_Type__isDoubleTy(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    bool var_bool = var_llvm_Type->isDoubleTy();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Type__getX86__FP80Ty(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::LLVMContext");
    if(!var_void)
    {
        puts("Error: llvm::LLVMContext");
        return NULL;
    }
    llvm::LLVMContext* var_llvm_LLVMContext = unwrap_as<llvm::LLVMContext, llvm::LLVMContext >::from(var_void);
    if(!var_llvm_LLVMContext)
    {
        return NULL;
    }
    llvm::LLVMContext& var_llvm_LLVMContext1 = *var_llvm_LLVMContext;
    llvm::Type* var_llvm_Type = llvm::Type::getX86_FP80Ty(var_llvm_LLVMContext1);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Type >::from(var_llvm_Type), "llvm::Type", "llvm::Type");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyObject*
llvm_Type__isPPC__FP128Ty(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    bool var_bool = var_llvm_Type->isPPC_FP128Ty();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Type__getDoubleTy(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::LLVMContext");
    if(!var_void)
    {
        puts("Error: llvm::LLVMContext");
        return NULL;
    }
    llvm::LLVMContext* var_llvm_LLVMContext = unwrap_as<llvm::LLVMContext, llvm::LLVMContext >::from(var_void);
    if(!var_llvm_LLVMContext)
    {
        return NULL;
    }
    llvm::LLVMContext& var_llvm_LLVMContext1 = *var_llvm_LLVMContext;
    llvm::Type* var_llvm_Type = llvm::Type::getDoubleTy(var_llvm_LLVMContext1);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Type >::from(var_llvm_Type), "llvm::Type", "llvm::Type");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyObject*
llvm_Type__getDoublePtrTy(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::LLVMContext");
    if(!var_void)
    {
        puts("Error: llvm::LLVMContext");
        return NULL;
    }
    llvm::LLVMContext* var_llvm_LLVMContext = unwrap_as<llvm::LLVMContext, llvm::LLVMContext >::from(var_void);
    if(!var_llvm_LLVMContext)
    {
        return NULL;
    }
    llvm::LLVMContext& var_llvm_LLVMContext1 = *var_llvm_LLVMContext;
    llvm::PointerType* var_llvm_PointerType = llvm::Type::getDoublePtrTy(var_llvm_LLVMContext1);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Type >::from(var_llvm_PointerType), "llvm::Type", "llvm::PointerType");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyObject*
llvm_Type__getLabelTy(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::LLVMContext");
    if(!var_void)
    {
        puts("Error: llvm::LLVMContext");
        return NULL;
    }
    llvm::LLVMContext* var_llvm_LLVMContext = unwrap_as<llvm::LLVMContext, llvm::LLVMContext >::from(var_void);
    if(!var_llvm_LLVMContext)
    {
        return NULL;
    }
    llvm::LLVMContext& var_llvm_LLVMContext1 = *var_llvm_LLVMContext;
    llvm::Type* var_llvm_Type = llvm::Type::getLabelTy(var_llvm_LLVMContext1);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Type >::from(var_llvm_Type), "llvm::Type", "llvm::Type");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyObject*
llvm_Type__getFP128PtrTy(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::LLVMContext");
    if(!var_void)
    {
        puts("Error: llvm::LLVMContext");
        return NULL;
    }
    llvm::LLVMContext* var_llvm_LLVMContext = unwrap_as<llvm::LLVMContext, llvm::LLVMContext >::from(var_void);
    if(!var_llvm_LLVMContext)
    {
        return NULL;
    }
    llvm::LLVMContext& var_llvm_LLVMContext1 = *var_llvm_LLVMContext;
    llvm::PointerType* var_llvm_PointerType = llvm::Type::getFP128PtrTy(var_llvm_LLVMContext1);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Type >::from(var_llvm_PointerType), "llvm::Type", "llvm::PointerType");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyObject*
llvm_Type__isVectorTy(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    bool var_bool = var_llvm_Type->isVectorTy();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Type__getFloatPtrTy(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::LLVMContext");
    if(!var_void)
    {
        puts("Error: llvm::LLVMContext");
        return NULL;
    }
    llvm::LLVMContext* var_llvm_LLVMContext = unwrap_as<llvm::LLVMContext, llvm::LLVMContext >::from(var_void);
    if(!var_llvm_LLVMContext)
    {
        return NULL;
    }
    llvm::LLVMContext& var_llvm_LLVMContext1 = *var_llvm_LLVMContext;
    llvm::PointerType* var_llvm_PointerType = llvm::Type::getFloatPtrTy(var_llvm_LLVMContext1);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Type >::from(var_llvm_PointerType), "llvm::Type", "llvm::PointerType");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyObject*
llvm_Type__getFloatTy(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::LLVMContext");
    if(!var_void)
    {
        puts("Error: llvm::LLVMContext");
        return NULL;
    }
    llvm::LLVMContext* var_llvm_LLVMContext = unwrap_as<llvm::LLVMContext, llvm::LLVMContext >::from(var_void);
    if(!var_llvm_LLVMContext)
    {
        return NULL;
    }
    llvm::LLVMContext& var_llvm_LLVMContext1 = *var_llvm_LLVMContext;
    llvm::Type* var_llvm_Type = llvm::Type::getFloatTy(var_llvm_LLVMContext1);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Type >::from(var_llvm_Type), "llvm::Type", "llvm::Type");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyObject*
llvm_Type__getInt64Ty(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::LLVMContext");
    if(!var_void)
    {
        puts("Error: llvm::LLVMContext");
        return NULL;
    }
    llvm::LLVMContext* var_llvm_LLVMContext = unwrap_as<llvm::LLVMContext, llvm::LLVMContext >::from(var_void);
    if(!var_llvm_LLVMContext)
    {
        return NULL;
    }
    llvm::LLVMContext& var_llvm_LLVMContext1 = *var_llvm_LLVMContext;
    llvm::IntegerType* var_llvm_IntegerType = llvm::Type::getInt64Ty(var_llvm_LLVMContext1);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Type >::from(var_llvm_IntegerType), "llvm::Type", "llvm::IntegerType");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyObject*
llvm_Type__isX86__MMXTy(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    bool var_bool = var_llvm_Type->isX86_MMXTy();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Type__TypeID__VoidTyID(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject = PyInt_FromLong(llvm::Type::VoidTyID);
    return var_PyObject;
}

static
PyObject*
llvm_Type__TypeID__HalfTyID(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject1 = PyInt_FromLong(llvm::Type::HalfTyID);
    return var_PyObject1;
}

static
PyObject*
llvm_Type__TypeID__FloatTyID(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject2 = PyInt_FromLong(llvm::Type::FloatTyID);
    return var_PyObject2;
}

static
PyObject*
llvm_Type__TypeID__DoubleTyID(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject3 = PyInt_FromLong(llvm::Type::DoubleTyID);
    return var_PyObject3;
}

static
PyObject*
llvm_Type__TypeID__X86__FP80TyID(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject4 = PyInt_FromLong(llvm::Type::X86_FP80TyID);
    return var_PyObject4;
}

static
PyObject*
llvm_Type__TypeID__FP128TyID(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject5 = PyInt_FromLong(llvm::Type::FP128TyID);
    return var_PyObject5;
}

static
PyObject*
llvm_Type__TypeID__PPC__FP128TyID(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject6 = PyInt_FromLong(llvm::Type::PPC_FP128TyID);
    return var_PyObject6;
}

static
PyObject*
llvm_Type__TypeID__LabelTyID(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject7 = PyInt_FromLong(llvm::Type::LabelTyID);
    return var_PyObject7;
}

static
PyObject*
llvm_Type__TypeID__MetadataTyID(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject8 = PyInt_FromLong(llvm::Type::MetadataTyID);
    return var_PyObject8;
}

static
PyObject*
llvm_Type__TypeID__X86__MMXTyID(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject9 = PyInt_FromLong(llvm::Type::X86_MMXTyID);
    return var_PyObject9;
}

static
PyObject*
llvm_Type__TypeID__IntegerTyID(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject10 = PyInt_FromLong(llvm::Type::IntegerTyID);
    return var_PyObject10;
}

static
PyObject*
llvm_Type__TypeID__FunctionTyID(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject11 = PyInt_FromLong(llvm::Type::FunctionTyID);
    return var_PyObject11;
}

static
PyObject*
llvm_Type__TypeID__StructTyID(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject12 = PyInt_FromLong(llvm::Type::StructTyID);
    return var_PyObject12;
}

static
PyObject*
llvm_Type__TypeID__ArrayTyID(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject13 = PyInt_FromLong(llvm::Type::ArrayTyID);
    return var_PyObject13;
}

static
PyObject*
llvm_Type__TypeID__PointerTyID(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject14 = PyInt_FromLong(llvm::Type::PointerTyID);
    return var_PyObject14;
}

static
PyObject*
llvm_Type__TypeID__VectorTyID(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject15 = PyInt_FromLong(llvm::Type::VectorTyID);
    return var_PyObject15;
}

static
PyObject*
llvm_Type__TypeID__NumTypeIDs(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject16 = PyInt_FromLong(llvm::Type::NumTypeIDs);
    return var_PyObject16;
}

static
PyObject*
llvm_Type__TypeID__LastPrimitiveTyID(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject17 = PyInt_FromLong(llvm::Type::LastPrimitiveTyID);
    return var_PyObject17;
}

static
PyObject*
llvm_Type__TypeID__FirstDerivedTyID(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject18 = PyInt_FromLong(llvm::Type::FirstDerivedTyID);
    return var_PyObject18;
}

static
PyMethodDef meth_llvm_Type[] = {
    { "isPrimitiveType", (PyCFunction)llvm_Type__isPrimitiveType, METH_VARARGS, NULL },
    { "getInt1Ty", (PyCFunction)llvm_Type__getInt1Ty, METH_VARARGS, NULL },
    { "isFunctionVarArg", (PyCFunction)llvm_Type__isFunctionVarArg, METH_VARARGS, NULL },
    { "isFirstClassType", (PyCFunction)llvm_Type__isFirstClassType, METH_VARARGS, NULL },
    { "getX86_MMXTy", (PyCFunction)llvm_Type__getX86__MMXTy, METH_VARARGS, NULL },
    { "isFloatingPointTy", (PyCFunction)llvm_Type__isFloatingPointTy, METH_VARARGS, NULL },
    { "getContext", (PyCFunction)llvm_Type__getContext, METH_VARARGS, NULL },
    { "getPointerTo", (PyCFunction)llvm_Type__getPointerTo, METH_VARARGS, NULL },
    { "isFunctionTy", (PyCFunction)llvm_Type__isFunctionTy, METH_VARARGS, NULL },
    { "getX86_FP80PtrTy", (PyCFunction)llvm_Type__getX86__FP80PtrTy, METH_VARARGS, NULL },
    { "getNumContainedTypes", (PyCFunction)llvm_Type__getNumContainedTypes, METH_VARARGS, NULL },
    { "isEmptyTy", (PyCFunction)llvm_Type__isEmptyTy, METH_VARARGS, NULL },
    { "getX86_MMXPtrTy", (PyCFunction)llvm_Type__getX86__MMXPtrTy, METH_VARARGS, NULL },
    { "getInt16PtrTy", (PyCFunction)llvm_Type__getInt16PtrTy, METH_VARARGS, NULL },
    { "getInt1PtrTy", (PyCFunction)llvm_Type__getInt1PtrTy, METH_VARARGS, NULL },
    { "isStructTy", (PyCFunction)llvm_Type__isStructTy, METH_VARARGS, NULL },
    { "isFP128Ty", (PyCFunction)llvm_Type__isFP128Ty, METH_VARARGS, NULL },
    { "isFloatTy", (PyCFunction)llvm_Type__isFloatTy, METH_VARARGS, NULL },
    { "getFP128Ty", (PyCFunction)llvm_Type__getFP128Ty, METH_VARARGS, NULL },
    { "getArrayElementType", (PyCFunction)llvm_Type__getArrayElementType, METH_VARARGS, NULL },
    { "isPointerTy", (PyCFunction)llvm_Type__isPointerTy, METH_VARARGS, NULL },
    { "getStructName", (PyCFunction)llvm_Type__getStructName, METH_VARARGS, NULL },
    { "getInt32Ty", (PyCFunction)llvm_Type__getInt32Ty, METH_VARARGS, NULL },
    { "isSingleValueType", (PyCFunction)llvm_Type__isSingleValueType, METH_VARARGS, NULL },
    { "getIntNTy", (PyCFunction)llvm_Type__getIntNTy, METH_VARARGS, NULL },
    { "getHalfPtrTy", (PyCFunction)llvm_Type__getHalfPtrTy, METH_VARARGS, NULL },
    { "isHalfTy", (PyCFunction)llvm_Type__isHalfTy, METH_VARARGS, NULL },
    { "getInt64PtrTy", (PyCFunction)llvm_Type__getInt64PtrTy, METH_VARARGS, NULL },
    { "isDerivedType", (PyCFunction)llvm_Type__isDerivedType, METH_VARARGS, NULL },
    { "getFunctionParamType", (PyCFunction)llvm_Type__getFunctionParamType, METH_VARARGS, NULL },
    { "isIntegerTy", (PyCFunction)llvm_Type__isIntegerTy, METH_VARARGS, NULL },
    { "isPtrOrPtrVectorTy", (PyCFunction)llvm_Type__isPtrOrPtrVectorTy, METH_VARARGS, NULL },
    { "getHalfTy", (PyCFunction)llvm_Type__getHalfTy, METH_VARARGS, NULL },
    { "getVectorElementType", (PyCFunction)llvm_Type__getVectorElementType, METH_VARARGS, NULL },
    { "getIntNPtrTy", (PyCFunction)llvm_Type__getIntNPtrTy, METH_VARARGS, NULL },
    { "getPPC_FP128Ty", (PyCFunction)llvm_Type__getPPC__FP128Ty, METH_VARARGS, NULL },
    { "getVectorNumElements", (PyCFunction)llvm_Type__getVectorNumElements, METH_VARARGS, NULL },
    { "isFPOrFPVectorTy", (PyCFunction)llvm_Type__isFPOrFPVectorTy, METH_VARARGS, NULL },
    { "isAggregateType", (PyCFunction)llvm_Type__isAggregateType, METH_VARARGS, NULL },
    { "getFunctionNumParams", (PyCFunction)llvm_Type__getFunctionNumParams, METH_VARARGS, NULL },
    { "isArrayTy", (PyCFunction)llvm_Type__isArrayTy, METH_VARARGS, NULL },
    { "getInt8PtrTy", (PyCFunction)llvm_Type__getInt8PtrTy, METH_VARARGS, NULL },
    { "isIntOrIntVectorTy", (PyCFunction)llvm_Type__isIntOrIntVectorTy, METH_VARARGS, NULL },
    { "getIntegerBitWidth", (PyCFunction)llvm_Type__getIntegerBitWidth, METH_VARARGS, NULL },
    { "getInt8Ty", (PyCFunction)llvm_Type__getInt8Ty, METH_VARARGS, NULL },
    { "isX86_FP80Ty", (PyCFunction)llvm_Type__isX86__FP80Ty, METH_VARARGS, NULL },
    { "getSequentialElementType", (PyCFunction)llvm_Type__getSequentialElementType, METH_VARARGS, NULL },
    { "print_", (PyCFunction)llvm_Type__print__, METH_VARARGS, NULL },
    { "getContainedType", (PyCFunction)llvm_Type__getContainedType, METH_VARARGS, NULL },
    { "getStructElementType", (PyCFunction)llvm_Type__getStructElementType, METH_VARARGS, NULL },
    { "isSized", (PyCFunction)llvm_Type__isSized, METH_VARARGS, NULL },
    { "isVoidTy", (PyCFunction)llvm_Type__isVoidTy, METH_VARARGS, NULL },
    { "getVoidTy", (PyCFunction)llvm_Type__getVoidTy, METH_VARARGS, NULL },
    { "isLabelTy", (PyCFunction)llvm_Type__isLabelTy, METH_VARARGS, NULL },
    { "isMetadataTy", (PyCFunction)llvm_Type__isMetadataTy, METH_VARARGS, NULL },
    { "getStructNumElements", (PyCFunction)llvm_Type__getStructNumElements, METH_VARARGS, NULL },
    { "getTypeID", (PyCFunction)llvm_Type__getTypeID, METH_VARARGS, NULL },
    { "getPointerAddressSpace", (PyCFunction)llvm_Type__getPointerAddressSpace, METH_VARARGS, NULL },
    { "getInt32PtrTy", (PyCFunction)llvm_Type__getInt32PtrTy, METH_VARARGS, NULL },
    { "getPointerElementType", (PyCFunction)llvm_Type__getPointerElementType, METH_VARARGS, NULL },
    { "getMetadataTy", (PyCFunction)llvm_Type__getMetadataTy, METH_VARARGS, NULL },
    { "getPPC_FP128PtrTy", (PyCFunction)llvm_Type__getPPC__FP128PtrTy, METH_VARARGS, NULL },
    { "getArrayNumElements", (PyCFunction)llvm_Type__getArrayNumElements, METH_VARARGS, NULL },
    { "getInt16Ty", (PyCFunction)llvm_Type__getInt16Ty, METH_VARARGS, NULL },
    { "dump", (PyCFunction)llvm_Type__dump, METH_VARARGS, NULL },
    { "isDoubleTy", (PyCFunction)llvm_Type__isDoubleTy, METH_VARARGS, NULL },
    { "getX86_FP80Ty", (PyCFunction)llvm_Type__getX86__FP80Ty, METH_VARARGS, NULL },
    { "isPPC_FP128Ty", (PyCFunction)llvm_Type__isPPC__FP128Ty, METH_VARARGS, NULL },
    { "getDoubleTy", (PyCFunction)llvm_Type__getDoubleTy, METH_VARARGS, NULL },
    { "getDoublePtrTy", (PyCFunction)llvm_Type__getDoublePtrTy, METH_VARARGS, NULL },
    { "getLabelTy", (PyCFunction)llvm_Type__getLabelTy, METH_VARARGS, NULL },
    { "getFP128PtrTy", (PyCFunction)llvm_Type__getFP128PtrTy, METH_VARARGS, NULL },
    { "isVectorTy", (PyCFunction)llvm_Type__isVectorTy, METH_VARARGS, NULL },
    { "getFloatPtrTy", (PyCFunction)llvm_Type__getFloatPtrTy, METH_VARARGS, NULL },
    { "getFloatTy", (PyCFunction)llvm_Type__getFloatTy, METH_VARARGS, NULL },
    { "getInt64Ty", (PyCFunction)llvm_Type__getInt64Ty, METH_VARARGS, NULL },
    { "isX86_MMXTy", (PyCFunction)llvm_Type__isX86__MMXTy, METH_VARARGS, NULL },
    { "VoidTyID", (PyCFunction)llvm_Type__TypeID__VoidTyID, METH_VARARGS, NULL },
    { "HalfTyID", (PyCFunction)llvm_Type__TypeID__HalfTyID, METH_VARARGS, NULL },
    { "FloatTyID", (PyCFunction)llvm_Type__TypeID__FloatTyID, METH_VARARGS, NULL },
    { "DoubleTyID", (PyCFunction)llvm_Type__TypeID__DoubleTyID, METH_VARARGS, NULL },
    { "X86_FP80TyID", (PyCFunction)llvm_Type__TypeID__X86__FP80TyID, METH_VARARGS, NULL },
    { "FP128TyID", (PyCFunction)llvm_Type__TypeID__FP128TyID, METH_VARARGS, NULL },
    { "PPC_FP128TyID", (PyCFunction)llvm_Type__TypeID__PPC__FP128TyID, METH_VARARGS, NULL },
    { "LabelTyID", (PyCFunction)llvm_Type__TypeID__LabelTyID, METH_VARARGS, NULL },
    { "MetadataTyID", (PyCFunction)llvm_Type__TypeID__MetadataTyID, METH_VARARGS, NULL },
    { "X86_MMXTyID", (PyCFunction)llvm_Type__TypeID__X86__MMXTyID, METH_VARARGS, NULL },
    { "IntegerTyID", (PyCFunction)llvm_Type__TypeID__IntegerTyID, METH_VARARGS, NULL },
    { "FunctionTyID", (PyCFunction)llvm_Type__TypeID__FunctionTyID, METH_VARARGS, NULL },
    { "StructTyID", (PyCFunction)llvm_Type__TypeID__StructTyID, METH_VARARGS, NULL },
    { "ArrayTyID", (PyCFunction)llvm_Type__TypeID__ArrayTyID, METH_VARARGS, NULL },
    { "PointerTyID", (PyCFunction)llvm_Type__TypeID__PointerTyID, METH_VARARGS, NULL },
    { "VectorTyID", (PyCFunction)llvm_Type__TypeID__VectorTyID, METH_VARARGS, NULL },
    { "NumTypeIDs", (PyCFunction)llvm_Type__TypeID__NumTypeIDs, METH_VARARGS, NULL },
    { "LastPrimitiveTyID", (PyCFunction)llvm_Type__TypeID__LastPrimitiveTyID, METH_VARARGS, NULL },
    { "FirstDerivedTyID", (PyCFunction)llvm_Type__TypeID__FirstDerivedTyID, METH_VARARGS, NULL },
    { NULL },
};

static
SubModuleEntry submodule_llvm_Type[] = {
    { NULL }
};

static
PyMethodDef meth_llvm_IntegerType[] = {
    { NULL },
};

static
SubModuleEntry submodule_llvm_IntegerType[] = {
    { NULL }
};

static
PyMethodDef meth_llvm_CompositeType[] = {
    { NULL },
};

static
SubModuleEntry submodule_llvm_CompositeType[] = {
    { NULL }
};

static
PyObject*
llvm_StructType__setName(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::StructType* var_llvm_StructType = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::StructType* var_llvm_StructType1 = unwrap_as<llvm::StructType, llvm::Type >::from(var_void);
        if(!var_llvm_StructType1)
        {
            return NULL;
        }
        var_llvm_StructType = var_llvm_StructType1;
    }
    llvm::StringRef var_llvm_StringRef;
    int var_int = py_str_to(var_PyObject1, var_llvm_StringRef);
    if(!var_int)
    {
        return NULL;
    }
    var_llvm_StructType->setName(var_llvm_StringRef);
    Py_RETURN_NONE;
}

static
PyObject*
llvm_StructType__isLiteral(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::StructType* var_llvm_StructType = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::StructType* var_llvm_StructType1 = unwrap_as<llvm::StructType, llvm::Type >::from(var_void);
        if(!var_llvm_StructType1)
        {
            return NULL;
        }
        var_llvm_StructType = var_llvm_StructType1;
    }
    bool var_bool = var_llvm_StructType->isLiteral();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_StructType__isPacked(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::StructType* var_llvm_StructType = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::StructType* var_llvm_StructType1 = unwrap_as<llvm::StructType, llvm::Type >::from(var_void);
        if(!var_llvm_StructType1)
        {
            return NULL;
        }
        var_llvm_StructType = var_llvm_StructType1;
    }
    bool var_bool = var_llvm_StructType->isPacked();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_StructType__hasName(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::StructType* var_llvm_StructType = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::StructType* var_llvm_StructType1 = unwrap_as<llvm::StructType, llvm::Type >::from(var_void);
        if(!var_llvm_StructType1)
        {
            return NULL;
        }
        var_llvm_StructType = var_llvm_StructType1;
    }
    bool var_bool = var_llvm_StructType->hasName();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_StructType__create(PyObject* self, PyObject* args)
{
    Py_ssize_t var_Py__ssize__t = PyTuple_Size(args);
    if (2 == var_Py__ssize__t)
    {
        PyObject* var_PyObject;
        PyObject* var_PyObject1;
        if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
        {
            return NULL;
        }
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::LLVMContext");
        if(!var_void)
        {
            puts("Error: llvm::LLVMContext");
            return NULL;
        }
        llvm::LLVMContext* var_llvm_LLVMContext = unwrap_as<llvm::LLVMContext, llvm::LLVMContext >::from(var_void);
        if(!var_llvm_LLVMContext)
        {
            return NULL;
        }
        llvm::LLVMContext& var_llvm_LLVMContext1 = *var_llvm_LLVMContext;
        llvm::StringRef var_llvm_StringRef;
        int var_int = py_str_to(var_PyObject1, var_llvm_StringRef);
        if(!var_int)
        {
            return NULL;
        }
        llvm::StructType* var_llvm_StructType = llvm::StructType::create(var_llvm_LLVMContext1, var_llvm_StringRef);
        PyObject* var_PyObject2 = pycapsule_new(cast_to_base<llvm::Type >::from(var_llvm_StructType), "llvm::Type", "llvm::StructType");
        if (!var_PyObject2)
        {
            return NULL;
        }
        return var_PyObject2;
    }
    if (1 == var_Py__ssize__t)
    {
        PyObject* var_PyObject3;
        if(!PyArg_ParseTuple(args, "O", &var_PyObject3))
        {
            return NULL;
        }
        void* var_void1 = PyCapsule_GetPointer(var_PyObject3, "llvm::LLVMContext");
        if(!var_void1)
        {
            puts("Error: llvm::LLVMContext");
            return NULL;
        }
        llvm::LLVMContext* var_llvm_LLVMContext2 = unwrap_as<llvm::LLVMContext, llvm::LLVMContext >::from(var_void1);
        if(!var_llvm_LLVMContext2)
        {
            return NULL;
        }
        llvm::LLVMContext& var_llvm_LLVMContext3 = *var_llvm_LLVMContext2;
        llvm::StructType* var_llvm_StructType1 = llvm::StructType::create(var_llvm_LLVMContext3);
        PyObject* var_PyObject4 = pycapsule_new(cast_to_base<llvm::Type >::from(var_llvm_StructType1), "llvm::Type", "llvm::StructType");
        if (!var_PyObject4)
        {
            return NULL;
        }
        return var_PyObject4;
    }
    PyErr_SetString(PyExc_TypeError, "Invalid number of args");
    return NULL;
}

static
PyObject*
llvm_StructType__get(PyObject* self, PyObject* args)
{
    Py_ssize_t var_Py__ssize__t = PyTuple_Size(args);
    if (3 == var_Py__ssize__t)
    {
        PyObject* var_PyObject;
        PyObject* var_PyObject1;
        PyObject* var_PyObject2;
        if(!PyArg_ParseTuple(args, "OOO", &var_PyObject, &var_PyObject1, &var_PyObject2))
        {
            return NULL;
        }
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::LLVMContext");
        if(!var_void)
        {
            puts("Error: llvm::LLVMContext");
            return NULL;
        }
        llvm::LLVMContext* var_llvm_LLVMContext = unwrap_as<llvm::LLVMContext, llvm::LLVMContext >::from(var_void);
        if(!var_llvm_LLVMContext)
        {
            return NULL;
        }
        llvm::LLVMContext& var_llvm_LLVMContext1 = *var_llvm_LLVMContext;
        bool var_bool;
        int var_int = py_bool_to(var_PyObject2, var_bool);
        if(!var_int)
        {
            return NULL;
        }
        PyObject* var_PyObject3 = StructType_get(var_llvm_LLVMContext1, var_PyObject1, var_bool);
        return var_PyObject3;
    }
    if (2 == var_Py__ssize__t)
    {
        PyObject* var_PyObject4;
        PyObject* var_PyObject5;
        if(!PyArg_ParseTuple(args, "OO", &var_PyObject4, &var_PyObject5))
        {
            return NULL;
        }
        void* var_void1 = PyCapsule_GetPointer(var_PyObject4, "llvm::LLVMContext");
        if(!var_void1)
        {
            puts("Error: llvm::LLVMContext");
            return NULL;
        }
        llvm::LLVMContext* var_llvm_LLVMContext2 = unwrap_as<llvm::LLVMContext, llvm::LLVMContext >::from(var_void1);
        if(!var_llvm_LLVMContext2)
        {
            return NULL;
        }
        llvm::LLVMContext& var_llvm_LLVMContext3 = *var_llvm_LLVMContext2;
        PyObject* var_PyObject6 = StructType_get(var_llvm_LLVMContext3, var_PyObject5);
        return var_PyObject6;
    }
    PyErr_SetString(PyExc_TypeError, "Invalid number of args");
    return NULL;
}

static
PyObject*
llvm_StructType__getElementType(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::StructType* var_llvm_StructType = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::StructType* var_llvm_StructType1 = unwrap_as<llvm::StructType, llvm::Type >::from(var_void);
        if(!var_llvm_StructType1)
        {
            return NULL;
        }
        var_llvm_StructType = var_llvm_StructType1;
    }
    unsigned var_unsigned;
    int var_int = py_int_to(var_PyObject1, var_unsigned);
    if(!var_int)
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = var_llvm_StructType->getElementType(var_unsigned);
    PyObject* var_PyObject2 = pycapsule_new(cast_to_base<llvm::Type >::from(var_llvm_Type), "llvm::Type", "llvm::Type");
    if (!var_PyObject2)
    {
        return NULL;
    }
    return var_PyObject2;
}

static
PyObject*
llvm_StructType__setBody(PyObject* self, PyObject* args)
{
    Py_ssize_t var_Py__ssize__t = PyTuple_Size(args);
    if (3 == var_Py__ssize__t)
    {
        PyObject* var_PyObject;
        PyObject* var_PyObject1;
        PyObject* var_PyObject2;
        if(!PyArg_ParseTuple(args, "OOO", &var_PyObject, &var_PyObject1, &var_PyObject2))
        {
            return NULL;
        }
        llvm::StructType* var_llvm_StructType = NULL;
        if (var_PyObject != Py_None)
        {
            void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
            if(!var_void)
            {
                puts("Error: llvm::Type");
                return NULL;
            }
            llvm::StructType* var_llvm_StructType1 = unwrap_as<llvm::StructType, llvm::Type >::from(var_void);
            if(!var_llvm_StructType1)
            {
                return NULL;
            }
            var_llvm_StructType = var_llvm_StructType1;
        }
        bool var_bool;
        int var_int = py_bool_to(var_PyObject2, var_bool);
        if(!var_int)
        {
            return NULL;
        }
        PyObject* var_PyObject3 = StructType_setBody(var_llvm_StructType, var_PyObject1, var_bool);
        return var_PyObject3;
    }
    if (2 == var_Py__ssize__t)
    {
        PyObject* var_PyObject4;
        PyObject* var_PyObject5;
        if(!PyArg_ParseTuple(args, "OO", &var_PyObject4, &var_PyObject5))
        {
            return NULL;
        }
        llvm::StructType* var_llvm_StructType2 = NULL;
        if (var_PyObject4 != Py_None)
        {
            void* var_void1 = PyCapsule_GetPointer(var_PyObject4, "llvm::Type");
            if(!var_void1)
            {
                puts("Error: llvm::Type");
                return NULL;
            }
            llvm::StructType* var_llvm_StructType3 = unwrap_as<llvm::StructType, llvm::Type >::from(var_void1);
            if(!var_llvm_StructType3)
            {
                return NULL;
            }
            var_llvm_StructType2 = var_llvm_StructType3;
        }
        PyObject* var_PyObject6 = StructType_setBody(var_llvm_StructType2, var_PyObject5);
        return var_PyObject6;
    }
    PyErr_SetString(PyExc_TypeError, "Invalid number of args");
    return NULL;
}

static
PyObject*
llvm_StructType__isOpaque(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::StructType* var_llvm_StructType = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::StructType* var_llvm_StructType1 = unwrap_as<llvm::StructType, llvm::Type >::from(var_void);
        if(!var_llvm_StructType1)
        {
            return NULL;
        }
        var_llvm_StructType = var_llvm_StructType1;
    }
    bool var_bool = var_llvm_StructType->isOpaque();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_StructType__getName(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::StructType* var_llvm_StructType = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::StructType* var_llvm_StructType1 = unwrap_as<llvm::StructType, llvm::Type >::from(var_void);
        if(!var_llvm_StructType1)
        {
            return NULL;
        }
        var_llvm_StructType = var_llvm_StructType1;
    }
    llvm::StringRef var_llvm_StringRef = var_llvm_StructType->getName();
    PyObject* var_PyObject1 = py_str_from(var_llvm_StringRef);
    return var_PyObject1;
}

static
PyObject*
llvm_StructType__isValidElementType(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    bool var_bool = llvm::StructType::isValidElementType(var_llvm_Type);
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_StructType__getNumElements(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::StructType* var_llvm_StructType = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::StructType* var_llvm_StructType1 = unwrap_as<llvm::StructType, llvm::Type >::from(var_void);
        if(!var_llvm_StructType1)
        {
            return NULL;
        }
        var_llvm_StructType = var_llvm_StructType1;
    }
    unsigned var_unsigned = var_llvm_StructType->getNumElements();
    PyObject* var_PyObject1 = py_int_from_unsigned(var_unsigned);
    return var_PyObject1;
}

static
PyObject*
llvm_StructType__isLayoutIdentical(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::StructType* var_llvm_StructType = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::StructType* var_llvm_StructType1 = unwrap_as<llvm::StructType, llvm::Type >::from(var_void);
        if(!var_llvm_StructType1)
        {
            return NULL;
        }
        var_llvm_StructType = var_llvm_StructType1;
    }
    llvm::StructType* var_llvm_StructType2 = NULL;
    if (var_PyObject1 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Type");
        if(!var_void1)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::StructType* var_llvm_StructType3 = unwrap_as<llvm::StructType, llvm::Type >::from(var_void1);
        if(!var_llvm_StructType3)
        {
            return NULL;
        }
        var_llvm_StructType2 = var_llvm_StructType3;
    }
    bool var_bool = var_llvm_StructType->isLayoutIdentical(var_llvm_StructType2);
    PyObject* var_PyObject2 = py_bool_from(var_bool);
    return var_PyObject2;
}

static
PyMethodDef meth_llvm_StructType[] = {
    { "setName", (PyCFunction)llvm_StructType__setName, METH_VARARGS, NULL },
    { "isLiteral", (PyCFunction)llvm_StructType__isLiteral, METH_VARARGS, NULL },
    { "isPacked", (PyCFunction)llvm_StructType__isPacked, METH_VARARGS, NULL },
    { "hasName", (PyCFunction)llvm_StructType__hasName, METH_VARARGS, NULL },
    { "create", (PyCFunction)llvm_StructType__create, METH_VARARGS, NULL },
    { "get", (PyCFunction)llvm_StructType__get, METH_VARARGS, NULL },
    { "getElementType", (PyCFunction)llvm_StructType__getElementType, METH_VARARGS, NULL },
    { "setBody", (PyCFunction)llvm_StructType__setBody, METH_VARARGS, NULL },
    { "isOpaque", (PyCFunction)llvm_StructType__isOpaque, METH_VARARGS, NULL },
    { "getName", (PyCFunction)llvm_StructType__getName, METH_VARARGS, NULL },
    { "isValidElementType", (PyCFunction)llvm_StructType__isValidElementType, METH_VARARGS, NULL },
    { "getNumElements", (PyCFunction)llvm_StructType__getNumElements, METH_VARARGS, NULL },
    { "isLayoutIdentical", (PyCFunction)llvm_StructType__isLayoutIdentical, METH_VARARGS, NULL },
    { NULL },
};

static
SubModuleEntry submodule_llvm_StructType[] = {
    { NULL }
};

static
PyMethodDef meth_llvm_SequentialType[] = {
    { NULL },
};

static
SubModuleEntry submodule_llvm_SequentialType[] = {
    { NULL }
};

static
PyObject*
llvm_ArrayType__getNumElements(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::ArrayType* var_llvm_ArrayType = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::ArrayType* var_llvm_ArrayType1 = unwrap_as<llvm::ArrayType, llvm::Type >::from(var_void);
        if(!var_llvm_ArrayType1)
        {
            return NULL;
        }
        var_llvm_ArrayType = var_llvm_ArrayType1;
    }
    uint64_t var_uint64__t = var_llvm_ArrayType->getNumElements();
    PyObject* var_PyObject1 = py_int_from_unsigned(var_uint64__t);
    return var_PyObject1;
}

static
PyObject*
llvm_ArrayType__get(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    uint64_t var_uint64__t;
    int var_int = py_int_to(var_PyObject1, var_uint64__t);
    if(!var_int)
    {
        return NULL;
    }
    llvm::ArrayType* var_llvm_ArrayType = llvm::ArrayType::get(var_llvm_Type, var_uint64__t);
    PyObject* var_PyObject2 = pycapsule_new(cast_to_base<llvm::Type >::from(var_llvm_ArrayType), "llvm::Type", "llvm::ArrayType");
    if (!var_PyObject2)
    {
        return NULL;
    }
    return var_PyObject2;
}

static
PyObject*
llvm_ArrayType__isValidElementType(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    bool var_bool = llvm::ArrayType::isValidElementType(var_llvm_Type);
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyMethodDef meth_llvm_ArrayType[] = {
    { "getNumElements", (PyCFunction)llvm_ArrayType__getNumElements, METH_VARARGS, NULL },
    { "get", (PyCFunction)llvm_ArrayType__get, METH_VARARGS, NULL },
    { "isValidElementType", (PyCFunction)llvm_ArrayType__isValidElementType, METH_VARARGS, NULL },
    { NULL },
};

static
SubModuleEntry submodule_llvm_ArrayType[] = {
    { NULL }
};

static
PyObject*
llvm_PointerType__getUnqual(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    llvm::PointerType* var_llvm_PointerType = llvm::PointerType::getUnqual(var_llvm_Type);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Type >::from(var_llvm_PointerType), "llvm::Type", "llvm::PointerType");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyObject*
llvm_PointerType__getAddressSpace(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::PointerType* var_llvm_PointerType = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::PointerType* var_llvm_PointerType1 = unwrap_as<llvm::PointerType, llvm::Type >::from(var_void);
        if(!var_llvm_PointerType1)
        {
            return NULL;
        }
        var_llvm_PointerType = var_llvm_PointerType1;
    }
    unsigned var_unsigned = var_llvm_PointerType->getAddressSpace();
    PyObject* var_PyObject1 = py_int_from_unsigned(var_unsigned);
    return var_PyObject1;
}

static
PyObject*
llvm_PointerType__get(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    unsigned var_unsigned;
    int var_int = py_int_to(var_PyObject1, var_unsigned);
    if(!var_int)
    {
        return NULL;
    }
    llvm::PointerType* var_llvm_PointerType = llvm::PointerType::get(var_llvm_Type, var_unsigned);
    PyObject* var_PyObject2 = pycapsule_new(cast_to_base<llvm::Type >::from(var_llvm_PointerType), "llvm::Type", "llvm::PointerType");
    if (!var_PyObject2)
    {
        return NULL;
    }
    return var_PyObject2;
}

static
PyObject*
llvm_PointerType__isValidElementType(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    bool var_bool = llvm::PointerType::isValidElementType(var_llvm_Type);
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyMethodDef meth_llvm_PointerType[] = {
    { "getUnqual", (PyCFunction)llvm_PointerType__getUnqual, METH_VARARGS, NULL },
    { "getAddressSpace", (PyCFunction)llvm_PointerType__getAddressSpace, METH_VARARGS, NULL },
    { "get", (PyCFunction)llvm_PointerType__get, METH_VARARGS, NULL },
    { "isValidElementType", (PyCFunction)llvm_PointerType__isValidElementType, METH_VARARGS, NULL },
    { NULL },
};

static
SubModuleEntry submodule_llvm_PointerType[] = {
    { NULL }
};

static
PyObject*
llvm_VectorType__getInteger(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::VectorType* var_llvm_VectorType = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::VectorType* var_llvm_VectorType1 = unwrap_as<llvm::VectorType, llvm::Type >::from(var_void);
        if(!var_llvm_VectorType1)
        {
            return NULL;
        }
        var_llvm_VectorType = var_llvm_VectorType1;
    }
    llvm::VectorType* var_llvm_VectorType2 = llvm::VectorType::getInteger(var_llvm_VectorType);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Type >::from(var_llvm_VectorType2), "llvm::Type", "llvm::VectorType");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyObject*
llvm_VectorType__isValidElementType(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    bool var_bool = llvm::VectorType::isValidElementType(var_llvm_Type);
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_VectorType__getBitWidth(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::VectorType* var_llvm_VectorType = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::VectorType* var_llvm_VectorType1 = unwrap_as<llvm::VectorType, llvm::Type >::from(var_void);
        if(!var_llvm_VectorType1)
        {
            return NULL;
        }
        var_llvm_VectorType = var_llvm_VectorType1;
    }
    unsigned var_unsigned = var_llvm_VectorType->getBitWidth();
    PyObject* var_PyObject1 = py_int_from_unsigned(var_unsigned);
    return var_PyObject1;
}

static
PyObject*
llvm_VectorType__getNumElements(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::VectorType* var_llvm_VectorType = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::VectorType* var_llvm_VectorType1 = unwrap_as<llvm::VectorType, llvm::Type >::from(var_void);
        if(!var_llvm_VectorType1)
        {
            return NULL;
        }
        var_llvm_VectorType = var_llvm_VectorType1;
    }
    unsigned var_unsigned = var_llvm_VectorType->getNumElements();
    PyObject* var_PyObject1 = py_int_from_unsigned(var_unsigned);
    return var_PyObject1;
}

static
PyObject*
llvm_VectorType__getTruncatedElementVectorType(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::VectorType* var_llvm_VectorType = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::VectorType* var_llvm_VectorType1 = unwrap_as<llvm::VectorType, llvm::Type >::from(var_void);
        if(!var_llvm_VectorType1)
        {
            return NULL;
        }
        var_llvm_VectorType = var_llvm_VectorType1;
    }
    llvm::VectorType* var_llvm_VectorType2 = llvm::VectorType::getTruncatedElementVectorType(var_llvm_VectorType);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Type >::from(var_llvm_VectorType2), "llvm::Type", "llvm::VectorType");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyObject*
llvm_VectorType__get(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::Type* var_llvm_Type = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void);
        if(!var_llvm_Type1)
        {
            return NULL;
        }
        var_llvm_Type = var_llvm_Type1;
    }
    unsigned var_unsigned;
    int var_int = py_int_to(var_PyObject1, var_unsigned);
    if(!var_int)
    {
        return NULL;
    }
    llvm::VectorType* var_llvm_VectorType = llvm::VectorType::get(var_llvm_Type, var_unsigned);
    PyObject* var_PyObject2 = pycapsule_new(cast_to_base<llvm::Type >::from(var_llvm_VectorType), "llvm::Type", "llvm::VectorType");
    if (!var_PyObject2)
    {
        return NULL;
    }
    return var_PyObject2;
}

static
PyObject*
llvm_VectorType__getExtendedElementVectorType(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::VectorType* var_llvm_VectorType = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Type");
        if(!var_void)
        {
            puts("Error: llvm::Type");
            return NULL;
        }
        llvm::VectorType* var_llvm_VectorType1 = unwrap_as<llvm::VectorType, llvm::Type >::from(var_void);
        if(!var_llvm_VectorType1)
        {
            return NULL;
        }
        var_llvm_VectorType = var_llvm_VectorType1;
    }
    llvm::VectorType* var_llvm_VectorType2 = llvm::VectorType::getExtendedElementVectorType(var_llvm_VectorType);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Type >::from(var_llvm_VectorType2), "llvm::Type", "llvm::VectorType");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyMethodDef meth_llvm_VectorType[] = {
    { "getInteger", (PyCFunction)llvm_VectorType__getInteger, METH_VARARGS, NULL },
    { "isValidElementType", (PyCFunction)llvm_VectorType__isValidElementType, METH_VARARGS, NULL },
    { "getBitWidth", (PyCFunction)llvm_VectorType__getBitWidth, METH_VARARGS, NULL },
    { "getNumElements", (PyCFunction)llvm_VectorType__getNumElements, METH_VARARGS, NULL },
    { "getTruncatedElementVectorType", (PyCFunction)llvm_VectorType__getTruncatedElementVectorType, METH_VARARGS, NULL },
    { "get", (PyCFunction)llvm_VectorType__get, METH_VARARGS, NULL },
    { "getExtendedElementVectorType", (PyCFunction)llvm_VectorType__getExtendedElementVectorType, METH_VARARGS, NULL },
    { NULL },
};

static
SubModuleEntry submodule_llvm_VectorType[] = {
    { NULL }
};

static
PyObject*
llvm_GlobalVariable__setConstant(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::GlobalVariable* var_llvm_GlobalVariable = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::GlobalVariable* var_llvm_GlobalVariable1 = unwrap_as<llvm::GlobalVariable, llvm::Value >::from(var_void);
        if(!var_llvm_GlobalVariable1)
        {
            return NULL;
        }
        var_llvm_GlobalVariable = var_llvm_GlobalVariable1;
    }
    bool var_bool;
    int var_int = py_bool_to(var_PyObject1, var_bool);
    if(!var_int)
    {
        return NULL;
    }
    var_llvm_GlobalVariable->setConstant(var_bool);
    Py_RETURN_NONE;
}

static
PyObject*
llvm_GlobalVariable__setThreadLocalMode(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::GlobalVariable* var_llvm_GlobalVariable = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::GlobalVariable* var_llvm_GlobalVariable1 = unwrap_as<llvm::GlobalVariable, llvm::Value >::from(var_void);
        if(!var_llvm_GlobalVariable1)
        {
            return NULL;
        }
        var_llvm_GlobalVariable = var_llvm_GlobalVariable1;
    }
    llvm::GlobalVariable::ThreadLocalMode var_llvm_GlobalVariable_ThreadLocalMode = (llvm::GlobalVariable::ThreadLocalMode)PyInt_AsLong(var_PyObject1);
    var_llvm_GlobalVariable->setThreadLocalMode(var_llvm_GlobalVariable_ThreadLocalMode);
    Py_RETURN_NONE;
}

static
PyObject*
llvm_GlobalVariable__hasInitializer(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::GlobalVariable* var_llvm_GlobalVariable = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::GlobalVariable* var_llvm_GlobalVariable1 = unwrap_as<llvm::GlobalVariable, llvm::Value >::from(var_void);
        if(!var_llvm_GlobalVariable1)
        {
            return NULL;
        }
        var_llvm_GlobalVariable = var_llvm_GlobalVariable1;
    }
    bool var_bool = var_llvm_GlobalVariable->hasInitializer();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_GlobalVariable__new(PyObject* self, PyObject* args)
{
    Py_ssize_t var_Py__ssize__t = PyTuple_Size(args);
    if (9 == var_Py__ssize__t)
    {
        PyObject* var_PyObject;
        PyObject* var_PyObject1;
        PyObject* var_PyObject2;
        PyObject* var_PyObject3;
        PyObject* var_PyObject4;
        PyObject* var_PyObject5;
        PyObject* var_PyObject6;
        PyObject* var_PyObject7;
        PyObject* var_PyObject8;
        if(!PyArg_ParseTuple(args, "OOOOOOOOO", &var_PyObject, &var_PyObject1, &var_PyObject2, &var_PyObject3, &var_PyObject4, &var_PyObject5, &var_PyObject6, &var_PyObject7, &var_PyObject8))
        {
            return NULL;
        }
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Module");
        if(!var_void)
        {
            puts("Error: llvm::Module");
            return NULL;
        }
        llvm::Module* var_llvm_Module = unwrap_as<llvm::Module, llvm::Module >::from(var_void);
        if(!var_llvm_Module)
        {
            return NULL;
        }
        llvm::Module& var_llvm_Module1 = *var_llvm_Module;
        llvm::Type* var_llvm_Type = NULL;
        if (var_PyObject1 != Py_None)
        {
            void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Type");
            if(!var_void1)
            {
                puts("Error: llvm::Type");
                return NULL;
            }
            llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void1);
            if(!var_llvm_Type1)
            {
                return NULL;
            }
            var_llvm_Type = var_llvm_Type1;
        }
        bool var_bool;
        int var_int = py_bool_to(var_PyObject2, var_bool);
        if(!var_int)
        {
            return NULL;
        }
        llvm::GlobalValue::LinkageTypes var_llvm_GlobalValue_LinkageTypes = (llvm::GlobalValue::LinkageTypes)PyInt_AsLong(var_PyObject3);
        llvm::Constant* var_llvm_Constant = NULL;
        if (var_PyObject4 != Py_None)
        {
            void* var_void2 = PyCapsule_GetPointer(var_PyObject4, "llvm::Value");
            if(!var_void2)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::Constant* var_llvm_Constant1 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void2);
            if(!var_llvm_Constant1)
            {
                return NULL;
            }
            var_llvm_Constant = var_llvm_Constant1;
        }
        llvm::StringRef var_llvm_StringRef;
        int var_int1 = py_str_to(var_PyObject5, var_llvm_StringRef);
        if(!var_int1)
        {
            return NULL;
        }
        llvm::GlobalVariable* var_llvm_GlobalVariable = NULL;
        if (var_PyObject6 != Py_None)
        {
            void* var_void3 = PyCapsule_GetPointer(var_PyObject6, "llvm::Value");
            if(!var_void3)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::GlobalVariable* var_llvm_GlobalVariable1 = unwrap_as<llvm::GlobalVariable, llvm::Value >::from(var_void3);
            if(!var_llvm_GlobalVariable1)
            {
                return NULL;
            }
            var_llvm_GlobalVariable = var_llvm_GlobalVariable1;
        }
        llvm::GlobalVariable::ThreadLocalMode var_llvm_GlobalVariable_ThreadLocalMode = (llvm::GlobalVariable::ThreadLocalMode)PyInt_AsLong(var_PyObject7);
        unsigned var_unsigned;
        int var_int2 = py_int_to(var_PyObject8, var_unsigned);
        if(!var_int2)
        {
            return NULL;
        }
        llvm::GlobalVariable* var_llvm_GlobalVariable2 = new llvm::GlobalVariable(var_llvm_Module1, var_llvm_Type, var_bool, var_llvm_GlobalValue_LinkageTypes, var_llvm_Constant, var_llvm_StringRef, var_llvm_GlobalVariable, var_llvm_GlobalVariable_ThreadLocalMode, var_unsigned);
        PyObject* var_PyObject9 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_GlobalVariable2), "llvm::Value", "llvm::GlobalVariable");
        if (!var_PyObject9)
        {
            return NULL;
        }
        return var_PyObject9;
    }
    if (5 == var_Py__ssize__t)
    {
        PyObject* var_PyObject10;
        PyObject* var_PyObject11;
        PyObject* var_PyObject12;
        PyObject* var_PyObject13;
        PyObject* var_PyObject14;
        if(!PyArg_ParseTuple(args, "OOOOO", &var_PyObject10, &var_PyObject11, &var_PyObject12, &var_PyObject13, &var_PyObject14))
        {
            return NULL;
        }
        void* var_void4 = PyCapsule_GetPointer(var_PyObject10, "llvm::Module");
        if(!var_void4)
        {
            puts("Error: llvm::Module");
            return NULL;
        }
        llvm::Module* var_llvm_Module2 = unwrap_as<llvm::Module, llvm::Module >::from(var_void4);
        if(!var_llvm_Module2)
        {
            return NULL;
        }
        llvm::Module& var_llvm_Module3 = *var_llvm_Module2;
        llvm::Type* var_llvm_Type2 = NULL;
        if (var_PyObject11 != Py_None)
        {
            void* var_void5 = PyCapsule_GetPointer(var_PyObject11, "llvm::Type");
            if(!var_void5)
            {
                puts("Error: llvm::Type");
                return NULL;
            }
            llvm::Type* var_llvm_Type3 = unwrap_as<llvm::Type, llvm::Type >::from(var_void5);
            if(!var_llvm_Type3)
            {
                return NULL;
            }
            var_llvm_Type2 = var_llvm_Type3;
        }
        bool var_bool1;
        int var_int3 = py_bool_to(var_PyObject12, var_bool1);
        if(!var_int3)
        {
            return NULL;
        }
        llvm::GlobalValue::LinkageTypes var_llvm_GlobalValue_LinkageTypes1 = (llvm::GlobalValue::LinkageTypes)PyInt_AsLong(var_PyObject13);
        llvm::Constant* var_llvm_Constant2 = NULL;
        if (var_PyObject14 != Py_None)
        {
            void* var_void6 = PyCapsule_GetPointer(var_PyObject14, "llvm::Value");
            if(!var_void6)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::Constant* var_llvm_Constant3 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void6);
            if(!var_llvm_Constant3)
            {
                return NULL;
            }
            var_llvm_Constant2 = var_llvm_Constant3;
        }
        llvm::GlobalVariable* var_llvm_GlobalVariable3 = new llvm::GlobalVariable(var_llvm_Module3, var_llvm_Type2, var_bool1, var_llvm_GlobalValue_LinkageTypes1, var_llvm_Constant2);
        PyObject* var_PyObject15 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_GlobalVariable3), "llvm::Value", "llvm::GlobalVariable");
        if (!var_PyObject15)
        {
            return NULL;
        }
        return var_PyObject15;
    }
    if (6 == var_Py__ssize__t)
    {
        PyObject* var_PyObject16;
        PyObject* var_PyObject17;
        PyObject* var_PyObject18;
        PyObject* var_PyObject19;
        PyObject* var_PyObject20;
        PyObject* var_PyObject21;
        if(!PyArg_ParseTuple(args, "OOOOOO", &var_PyObject16, &var_PyObject17, &var_PyObject18, &var_PyObject19, &var_PyObject20, &var_PyObject21))
        {
            return NULL;
        }
        void* var_void7 = PyCapsule_GetPointer(var_PyObject16, "llvm::Module");
        if(!var_void7)
        {
            puts("Error: llvm::Module");
            return NULL;
        }
        llvm::Module* var_llvm_Module4 = unwrap_as<llvm::Module, llvm::Module >::from(var_void7);
        if(!var_llvm_Module4)
        {
            return NULL;
        }
        llvm::Module& var_llvm_Module5 = *var_llvm_Module4;
        llvm::Type* var_llvm_Type4 = NULL;
        if (var_PyObject17 != Py_None)
        {
            void* var_void8 = PyCapsule_GetPointer(var_PyObject17, "llvm::Type");
            if(!var_void8)
            {
                puts("Error: llvm::Type");
                return NULL;
            }
            llvm::Type* var_llvm_Type5 = unwrap_as<llvm::Type, llvm::Type >::from(var_void8);
            if(!var_llvm_Type5)
            {
                return NULL;
            }
            var_llvm_Type4 = var_llvm_Type5;
        }
        bool var_bool2;
        int var_int4 = py_bool_to(var_PyObject18, var_bool2);
        if(!var_int4)
        {
            return NULL;
        }
        llvm::GlobalValue::LinkageTypes var_llvm_GlobalValue_LinkageTypes2 = (llvm::GlobalValue::LinkageTypes)PyInt_AsLong(var_PyObject19);
        llvm::Constant* var_llvm_Constant4 = NULL;
        if (var_PyObject20 != Py_None)
        {
            void* var_void9 = PyCapsule_GetPointer(var_PyObject20, "llvm::Value");
            if(!var_void9)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::Constant* var_llvm_Constant5 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void9);
            if(!var_llvm_Constant5)
            {
                return NULL;
            }
            var_llvm_Constant4 = var_llvm_Constant5;
        }
        llvm::StringRef var_llvm_StringRef1;
        int var_int5 = py_str_to(var_PyObject21, var_llvm_StringRef1);
        if(!var_int5)
        {
            return NULL;
        }
        llvm::GlobalVariable* var_llvm_GlobalVariable4 = new llvm::GlobalVariable(var_llvm_Module5, var_llvm_Type4, var_bool2, var_llvm_GlobalValue_LinkageTypes2, var_llvm_Constant4, var_llvm_StringRef1);
        PyObject* var_PyObject22 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_GlobalVariable4), "llvm::Value", "llvm::GlobalVariable");
        if (!var_PyObject22)
        {
            return NULL;
        }
        return var_PyObject22;
    }
    if (7 == var_Py__ssize__t)
    {
        PyObject* var_PyObject23;
        PyObject* var_PyObject24;
        PyObject* var_PyObject25;
        PyObject* var_PyObject26;
        PyObject* var_PyObject27;
        PyObject* var_PyObject28;
        PyObject* var_PyObject29;
        if(!PyArg_ParseTuple(args, "OOOOOOO", &var_PyObject23, &var_PyObject24, &var_PyObject25, &var_PyObject26, &var_PyObject27, &var_PyObject28, &var_PyObject29))
        {
            return NULL;
        }
        void* var_void10 = PyCapsule_GetPointer(var_PyObject23, "llvm::Module");
        if(!var_void10)
        {
            puts("Error: llvm::Module");
            return NULL;
        }
        llvm::Module* var_llvm_Module6 = unwrap_as<llvm::Module, llvm::Module >::from(var_void10);
        if(!var_llvm_Module6)
        {
            return NULL;
        }
        llvm::Module& var_llvm_Module7 = *var_llvm_Module6;
        llvm::Type* var_llvm_Type6 = NULL;
        if (var_PyObject24 != Py_None)
        {
            void* var_void11 = PyCapsule_GetPointer(var_PyObject24, "llvm::Type");
            if(!var_void11)
            {
                puts("Error: llvm::Type");
                return NULL;
            }
            llvm::Type* var_llvm_Type7 = unwrap_as<llvm::Type, llvm::Type >::from(var_void11);
            if(!var_llvm_Type7)
            {
                return NULL;
            }
            var_llvm_Type6 = var_llvm_Type7;
        }
        bool var_bool3;
        int var_int6 = py_bool_to(var_PyObject25, var_bool3);
        if(!var_int6)
        {
            return NULL;
        }
        llvm::GlobalValue::LinkageTypes var_llvm_GlobalValue_LinkageTypes3 = (llvm::GlobalValue::LinkageTypes)PyInt_AsLong(var_PyObject26);
        llvm::Constant* var_llvm_Constant6 = NULL;
        if (var_PyObject27 != Py_None)
        {
            void* var_void12 = PyCapsule_GetPointer(var_PyObject27, "llvm::Value");
            if(!var_void12)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::Constant* var_llvm_Constant7 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void12);
            if(!var_llvm_Constant7)
            {
                return NULL;
            }
            var_llvm_Constant6 = var_llvm_Constant7;
        }
        llvm::StringRef var_llvm_StringRef2;
        int var_int7 = py_str_to(var_PyObject28, var_llvm_StringRef2);
        if(!var_int7)
        {
            return NULL;
        }
        llvm::GlobalVariable* var_llvm_GlobalVariable5 = NULL;
        if (var_PyObject29 != Py_None)
        {
            void* var_void13 = PyCapsule_GetPointer(var_PyObject29, "llvm::Value");
            if(!var_void13)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::GlobalVariable* var_llvm_GlobalVariable6 = unwrap_as<llvm::GlobalVariable, llvm::Value >::from(var_void13);
            if(!var_llvm_GlobalVariable6)
            {
                return NULL;
            }
            var_llvm_GlobalVariable5 = var_llvm_GlobalVariable6;
        }
        llvm::GlobalVariable* var_llvm_GlobalVariable7 = new llvm::GlobalVariable(var_llvm_Module7, var_llvm_Type6, var_bool3, var_llvm_GlobalValue_LinkageTypes3, var_llvm_Constant6, var_llvm_StringRef2, var_llvm_GlobalVariable5);
        PyObject* var_PyObject30 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_GlobalVariable7), "llvm::Value", "llvm::GlobalVariable");
        if (!var_PyObject30)
        {
            return NULL;
        }
        return var_PyObject30;
    }
    if (8 == var_Py__ssize__t)
    {
        PyObject* var_PyObject31;
        PyObject* var_PyObject32;
        PyObject* var_PyObject33;
        PyObject* var_PyObject34;
        PyObject* var_PyObject35;
        PyObject* var_PyObject36;
        PyObject* var_PyObject37;
        PyObject* var_PyObject38;
        if(!PyArg_ParseTuple(args, "OOOOOOOO", &var_PyObject31, &var_PyObject32, &var_PyObject33, &var_PyObject34, &var_PyObject35, &var_PyObject36, &var_PyObject37, &var_PyObject38))
        {
            return NULL;
        }
        void* var_void14 = PyCapsule_GetPointer(var_PyObject31, "llvm::Module");
        if(!var_void14)
        {
            puts("Error: llvm::Module");
            return NULL;
        }
        llvm::Module* var_llvm_Module8 = unwrap_as<llvm::Module, llvm::Module >::from(var_void14);
        if(!var_llvm_Module8)
        {
            return NULL;
        }
        llvm::Module& var_llvm_Module9 = *var_llvm_Module8;
        llvm::Type* var_llvm_Type8 = NULL;
        if (var_PyObject32 != Py_None)
        {
            void* var_void15 = PyCapsule_GetPointer(var_PyObject32, "llvm::Type");
            if(!var_void15)
            {
                puts("Error: llvm::Type");
                return NULL;
            }
            llvm::Type* var_llvm_Type9 = unwrap_as<llvm::Type, llvm::Type >::from(var_void15);
            if(!var_llvm_Type9)
            {
                return NULL;
            }
            var_llvm_Type8 = var_llvm_Type9;
        }
        bool var_bool4;
        int var_int8 = py_bool_to(var_PyObject33, var_bool4);
        if(!var_int8)
        {
            return NULL;
        }
        llvm::GlobalValue::LinkageTypes var_llvm_GlobalValue_LinkageTypes4 = (llvm::GlobalValue::LinkageTypes)PyInt_AsLong(var_PyObject34);
        llvm::Constant* var_llvm_Constant8 = NULL;
        if (var_PyObject35 != Py_None)
        {
            void* var_void16 = PyCapsule_GetPointer(var_PyObject35, "llvm::Value");
            if(!var_void16)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::Constant* var_llvm_Constant9 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void16);
            if(!var_llvm_Constant9)
            {
                return NULL;
            }
            var_llvm_Constant8 = var_llvm_Constant9;
        }
        llvm::StringRef var_llvm_StringRef3;
        int var_int9 = py_str_to(var_PyObject36, var_llvm_StringRef3);
        if(!var_int9)
        {
            return NULL;
        }
        llvm::GlobalVariable* var_llvm_GlobalVariable8 = NULL;
        if (var_PyObject37 != Py_None)
        {
            void* var_void17 = PyCapsule_GetPointer(var_PyObject37, "llvm::Value");
            if(!var_void17)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::GlobalVariable* var_llvm_GlobalVariable9 = unwrap_as<llvm::GlobalVariable, llvm::Value >::from(var_void17);
            if(!var_llvm_GlobalVariable9)
            {
                return NULL;
            }
            var_llvm_GlobalVariable8 = var_llvm_GlobalVariable9;
        }
        llvm::GlobalVariable::ThreadLocalMode var_llvm_GlobalVariable_ThreadLocalMode1 = (llvm::GlobalVariable::ThreadLocalMode)PyInt_AsLong(var_PyObject38);
        llvm::GlobalVariable* var_llvm_GlobalVariable10 = new llvm::GlobalVariable(var_llvm_Module9, var_llvm_Type8, var_bool4, var_llvm_GlobalValue_LinkageTypes4, var_llvm_Constant8, var_llvm_StringRef3, var_llvm_GlobalVariable8, var_llvm_GlobalVariable_ThreadLocalMode1);
        PyObject* var_PyObject39 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_GlobalVariable10), "llvm::Value", "llvm::GlobalVariable");
        if (!var_PyObject39)
        {
            return NULL;
        }
        return var_PyObject39;
    }
    PyErr_SetString(PyExc_TypeError, "Invalid number of args");
    return NULL;
}

static
PyObject*
llvm_GlobalVariable__getInitializer(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::GlobalVariable* var_llvm_GlobalVariable = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::GlobalVariable* var_llvm_GlobalVariable1 = unwrap_as<llvm::GlobalVariable, llvm::Value >::from(var_void);
        if(!var_llvm_GlobalVariable1)
        {
            return NULL;
        }
        var_llvm_GlobalVariable = var_llvm_GlobalVariable1;
    }
    llvm::Constant* var_llvm_Constant = var_llvm_GlobalVariable->getInitializer();
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Constant), "llvm::Value", "llvm::Constant");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyObject*
llvm_GlobalVariable__setThreadLocal(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::GlobalVariable* var_llvm_GlobalVariable = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::GlobalVariable* var_llvm_GlobalVariable1 = unwrap_as<llvm::GlobalVariable, llvm::Value >::from(var_void);
        if(!var_llvm_GlobalVariable1)
        {
            return NULL;
        }
        var_llvm_GlobalVariable = var_llvm_GlobalVariable1;
    }
    bool var_bool;
    int var_int = py_bool_to(var_PyObject1, var_bool);
    if(!var_int)
    {
        return NULL;
    }
    var_llvm_GlobalVariable->setThreadLocal(var_bool);
    Py_RETURN_NONE;
}

static
PyObject*
llvm_GlobalVariable__setInitializer(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::GlobalVariable* var_llvm_GlobalVariable = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::GlobalVariable* var_llvm_GlobalVariable1 = unwrap_as<llvm::GlobalVariable, llvm::Value >::from(var_void);
        if(!var_llvm_GlobalVariable1)
        {
            return NULL;
        }
        var_llvm_GlobalVariable = var_llvm_GlobalVariable1;
    }
    llvm::Constant* var_llvm_Constant = NULL;
    if (var_PyObject1 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Value");
        if(!var_void1)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Constant* var_llvm_Constant1 = unwrap_as<llvm::Constant, llvm::Value >::from(var_void1);
        if(!var_llvm_Constant1)
        {
            return NULL;
        }
        var_llvm_Constant = var_llvm_Constant1;
    }
    var_llvm_GlobalVariable->setInitializer(var_llvm_Constant);
    Py_RETURN_NONE;
}

static
PyObject*
llvm_GlobalVariable__isThreadLocal(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::GlobalVariable* var_llvm_GlobalVariable = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::GlobalVariable* var_llvm_GlobalVariable1 = unwrap_as<llvm::GlobalVariable, llvm::Value >::from(var_void);
        if(!var_llvm_GlobalVariable1)
        {
            return NULL;
        }
        var_llvm_GlobalVariable = var_llvm_GlobalVariable1;
    }
    bool var_bool = var_llvm_GlobalVariable->isThreadLocal();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_GlobalVariable__isConstant(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::GlobalVariable* var_llvm_GlobalVariable = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::GlobalVariable* var_llvm_GlobalVariable1 = unwrap_as<llvm::GlobalVariable, llvm::Value >::from(var_void);
        if(!var_llvm_GlobalVariable1)
        {
            return NULL;
        }
        var_llvm_GlobalVariable = var_llvm_GlobalVariable1;
    }
    bool var_bool = var_llvm_GlobalVariable->isConstant();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_GlobalVariable__hasDefinitiveInitializer(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::GlobalVariable* var_llvm_GlobalVariable = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::GlobalVariable* var_llvm_GlobalVariable1 = unwrap_as<llvm::GlobalVariable, llvm::Value >::from(var_void);
        if(!var_llvm_GlobalVariable1)
        {
            return NULL;
        }
        var_llvm_GlobalVariable = var_llvm_GlobalVariable1;
    }
    bool var_bool = var_llvm_GlobalVariable->hasDefinitiveInitializer();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_GlobalVariable__hasUniqueInitializer(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::GlobalVariable* var_llvm_GlobalVariable = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::GlobalVariable* var_llvm_GlobalVariable1 = unwrap_as<llvm::GlobalVariable, llvm::Value >::from(var_void);
        if(!var_llvm_GlobalVariable1)
        {
            return NULL;
        }
        var_llvm_GlobalVariable = var_llvm_GlobalVariable1;
    }
    bool var_bool = var_llvm_GlobalVariable->hasUniqueInitializer();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_GlobalVariable__ThreadLocalMode__NotThreadLocal(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject = PyInt_FromLong(llvm::GlobalVariable::NotThreadLocal);
    return var_PyObject;
}

static
PyObject*
llvm_GlobalVariable__ThreadLocalMode__GeneralDynamicTLSModel(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject1 = PyInt_FromLong(llvm::GlobalVariable::GeneralDynamicTLSModel);
    return var_PyObject1;
}

static
PyObject*
llvm_GlobalVariable__ThreadLocalMode__LocalDynamicTLSModel(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject2 = PyInt_FromLong(llvm::GlobalVariable::LocalDynamicTLSModel);
    return var_PyObject2;
}

static
PyObject*
llvm_GlobalVariable__ThreadLocalMode__InitialExecTLSModel(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject3 = PyInt_FromLong(llvm::GlobalVariable::InitialExecTLSModel);
    return var_PyObject3;
}

static
PyObject*
llvm_GlobalVariable__ThreadLocalMode__LocalExecTLSModel(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject4 = PyInt_FromLong(llvm::GlobalVariable::LocalExecTLSModel);
    return var_PyObject4;
}

static
PyMethodDef meth_llvm_GlobalVariable[] = {
    { "setConstant", (PyCFunction)llvm_GlobalVariable__setConstant, METH_VARARGS, NULL },
    { "setThreadLocalMode", (PyCFunction)llvm_GlobalVariable__setThreadLocalMode, METH_VARARGS, NULL },
    { "hasInitializer", (PyCFunction)llvm_GlobalVariable__hasInitializer, METH_VARARGS, NULL },
    { "new", (PyCFunction)llvm_GlobalVariable__new, METH_VARARGS, NULL },
    { "getInitializer", (PyCFunction)llvm_GlobalVariable__getInitializer, METH_VARARGS, NULL },
    { "setThreadLocal", (PyCFunction)llvm_GlobalVariable__setThreadLocal, METH_VARARGS, NULL },
    { "setInitializer", (PyCFunction)llvm_GlobalVariable__setInitializer, METH_VARARGS, NULL },
    { "isThreadLocal", (PyCFunction)llvm_GlobalVariable__isThreadLocal, METH_VARARGS, NULL },
    { "isConstant", (PyCFunction)llvm_GlobalVariable__isConstant, METH_VARARGS, NULL },
    { "hasDefinitiveInitializer", (PyCFunction)llvm_GlobalVariable__hasDefinitiveInitializer, METH_VARARGS, NULL },
    { "hasUniqueInitializer", (PyCFunction)llvm_GlobalVariable__hasUniqueInitializer, METH_VARARGS, NULL },
    { "NotThreadLocal", (PyCFunction)llvm_GlobalVariable__ThreadLocalMode__NotThreadLocal, METH_VARARGS, NULL },
    { "GeneralDynamicTLSModel", (PyCFunction)llvm_GlobalVariable__ThreadLocalMode__GeneralDynamicTLSModel, METH_VARARGS, NULL },
    { "LocalDynamicTLSModel", (PyCFunction)llvm_GlobalVariable__ThreadLocalMode__LocalDynamicTLSModel, METH_VARARGS, NULL },
    { "InitialExecTLSModel", (PyCFunction)llvm_GlobalVariable__ThreadLocalMode__InitialExecTLSModel, METH_VARARGS, NULL },
    { "LocalExecTLSModel", (PyCFunction)llvm_GlobalVariable__ThreadLocalMode__LocalExecTLSModel, METH_VARARGS, NULL },
    { NULL },
};

static
SubModuleEntry submodule_llvm_GlobalVariable[] = {
    { NULL }
};

static
PyObject*
llvm_PassManagerBase__delete(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::PassManagerBase* var_llvm_PassManagerBase = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::PassManagerBase");
        if(!var_void)
        {
            puts("Error: llvm::PassManagerBase");
            return NULL;
        }
        llvm::PassManagerBase* var_llvm_PassManagerBase1 = unwrap_as<llvm::PassManagerBase, llvm::PassManagerBase >::from(var_void);
        if(!var_llvm_PassManagerBase1)
        {
            return NULL;
        }
        var_llvm_PassManagerBase = var_llvm_PassManagerBase1;
    }
    delete var_llvm_PassManagerBase;
    Py_RETURN_NONE;
}

static
PyObject*
llvm_PassManagerBase__add(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::PassManagerBase* var_llvm_PassManagerBase = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::PassManagerBase");
        if(!var_void)
        {
            puts("Error: llvm::PassManagerBase");
            return NULL;
        }
        llvm::PassManagerBase* var_llvm_PassManagerBase1 = unwrap_as<llvm::PassManagerBase, llvm::PassManagerBase >::from(var_void);
        if(!var_llvm_PassManagerBase1)
        {
            return NULL;
        }
        var_llvm_PassManagerBase = var_llvm_PassManagerBase1;
    }
    llvm::Pass* var_llvm_Pass = NULL;
    if (var_PyObject1 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Pass");
        if(!var_void1)
        {
            puts("Error: llvm::Pass");
            return NULL;
        }
        llvm::Pass* var_llvm_Pass1 = unwrap_as<llvm::Pass, llvm::Pass >::from(var_void1);
        if(!var_llvm_Pass1)
        {
            return NULL;
        }
        var_llvm_Pass = var_llvm_Pass1;
    }
    var_llvm_PassManagerBase->add(var_llvm_Pass);
    Py_RETURN_NONE;
}

static
PyMethodDef meth_llvm_PassManagerBase[] = {
    { "delete", (PyCFunction)llvm_PassManagerBase__delete, METH_VARARGS, NULL },
    { "add", (PyCFunction)llvm_PassManagerBase__add, METH_VARARGS, NULL },
    { NULL },
};

static
SubModuleEntry submodule_llvm_PassManagerBase[] = {
    { NULL }
};

static
PyObject*
llvm_PassManager__run(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::PassManager* var_llvm_PassManager = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::PassManagerBase");
        if(!var_void)
        {
            puts("Error: llvm::PassManagerBase");
            return NULL;
        }
        llvm::PassManager* var_llvm_PassManager1 = unwrap_as<llvm::PassManager, llvm::PassManagerBase >::from(var_void);
        if(!var_llvm_PassManager1)
        {
            return NULL;
        }
        var_llvm_PassManager = var_llvm_PassManager1;
    }
    void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Module");
    if(!var_void1)
    {
        puts("Error: llvm::Module");
        return NULL;
    }
    llvm::Module* var_llvm_Module = unwrap_as<llvm::Module, llvm::Module >::from(var_void1);
    if(!var_llvm_Module)
    {
        return NULL;
    }
    llvm::Module& var_llvm_Module1 = *var_llvm_Module;
    bool var_bool = var_llvm_PassManager->run(var_llvm_Module1);
    PyObject* var_PyObject2 = py_bool_from(var_bool);
    return var_PyObject2;
}

static
PyObject*
llvm_PassManager__new(PyObject* self, PyObject* args)
{
    if(!PyArg_ParseTuple(args, ""))
    {
        return NULL;
    }
    llvm::PassManager* var_llvm_PassManager = new llvm::PassManager();
    PyObject* var_PyObject = pycapsule_new(cast_to_base<llvm::PassManagerBase >::from(var_llvm_PassManager), "llvm::PassManagerBase", "llvm::PassManager");
    if (!var_PyObject)
    {
        return NULL;
    }
    return var_PyObject;
}

static
PyMethodDef meth_llvm_PassManager[] = {
    { "run", (PyCFunction)llvm_PassManager__run, METH_VARARGS, NULL },
    { "new", (PyCFunction)llvm_PassManager__new, METH_VARARGS, NULL },
    { NULL },
};

static
SubModuleEntry submodule_llvm_PassManager[] = {
    { NULL }
};

static
PyObject*
llvm_FunctionPassManager__new(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Module* var_llvm_Module = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Module");
        if(!var_void)
        {
            puts("Error: llvm::Module");
            return NULL;
        }
        llvm::Module* var_llvm_Module1 = unwrap_as<llvm::Module, llvm::Module >::from(var_void);
        if(!var_llvm_Module1)
        {
            return NULL;
        }
        var_llvm_Module = var_llvm_Module1;
    }
    llvm::FunctionPassManager* var_llvm_FunctionPassManager = new llvm::FunctionPassManager(var_llvm_Module);
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::PassManagerBase >::from(var_llvm_FunctionPassManager), "llvm::PassManagerBase", "llvm::FunctionPassManager");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyObject*
llvm_FunctionPassManager__doFinalization(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::FunctionPassManager* var_llvm_FunctionPassManager = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::PassManagerBase");
        if(!var_void)
        {
            puts("Error: llvm::PassManagerBase");
            return NULL;
        }
        llvm::FunctionPassManager* var_llvm_FunctionPassManager1 = unwrap_as<llvm::FunctionPassManager, llvm::PassManagerBase >::from(var_void);
        if(!var_llvm_FunctionPassManager1)
        {
            return NULL;
        }
        var_llvm_FunctionPassManager = var_llvm_FunctionPassManager1;
    }
    bool var_bool = var_llvm_FunctionPassManager->doFinalization();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_FunctionPassManager__doInitialization(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::FunctionPassManager* var_llvm_FunctionPassManager = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::PassManagerBase");
        if(!var_void)
        {
            puts("Error: llvm::PassManagerBase");
            return NULL;
        }
        llvm::FunctionPassManager* var_llvm_FunctionPassManager1 = unwrap_as<llvm::FunctionPassManager, llvm::PassManagerBase >::from(var_void);
        if(!var_llvm_FunctionPassManager1)
        {
            return NULL;
        }
        var_llvm_FunctionPassManager = var_llvm_FunctionPassManager1;
    }
    bool var_bool = var_llvm_FunctionPassManager->doInitialization();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_FunctionPassManager__run(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::FunctionPassManager* var_llvm_FunctionPassManager = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::PassManagerBase");
        if(!var_void)
        {
            puts("Error: llvm::PassManagerBase");
            return NULL;
        }
        llvm::FunctionPassManager* var_llvm_FunctionPassManager1 = unwrap_as<llvm::FunctionPassManager, llvm::PassManagerBase >::from(var_void);
        if(!var_llvm_FunctionPassManager1)
        {
            return NULL;
        }
        var_llvm_FunctionPassManager = var_llvm_FunctionPassManager1;
    }
    void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Value");
    if(!var_void1)
    {
        puts("Error: llvm::Value");
        return NULL;
    }
    llvm::Function* var_llvm_Function = unwrap_as<llvm::Function, llvm::Value >::from(var_void1);
    if(!var_llvm_Function)
    {
        return NULL;
    }
    llvm::Function& var_llvm_Function1 = *var_llvm_Function;
    bool var_bool = var_llvm_FunctionPassManager->run(var_llvm_Function1);
    PyObject* var_PyObject2 = py_bool_from(var_bool);
    return var_PyObject2;
}

static
PyMethodDef meth_llvm_FunctionPassManager[] = {
    { "new", (PyCFunction)llvm_FunctionPassManager__new, METH_VARARGS, NULL },
    { "doFinalization", (PyCFunction)llvm_FunctionPassManager__doFinalization, METH_VARARGS, NULL },
    { "doInitialization", (PyCFunction)llvm_FunctionPassManager__doInitialization, METH_VARARGS, NULL },
    { "run", (PyCFunction)llvm_FunctionPassManager__run, METH_VARARGS, NULL },
    { NULL },
};

static
SubModuleEntry submodule_llvm_FunctionPassManager[] = {
    { NULL }
};

static
PyObject*
llvm_TargetOptions__delete(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::TargetOptions* var_llvm_TargetOptions = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::TargetOptions");
        if(!var_void)
        {
            puts("Error: llvm::TargetOptions");
            return NULL;
        }
        llvm::TargetOptions* var_llvm_TargetOptions1 = unwrap_as<llvm::TargetOptions, llvm::TargetOptions >::from(var_void);
        if(!var_llvm_TargetOptions1)
        {
            return NULL;
        }
        var_llvm_TargetOptions = var_llvm_TargetOptions1;
    }
    delete var_llvm_TargetOptions;
    Py_RETURN_NONE;
}

static
PyObject*
llvm_TargetOptions__new(PyObject* self, PyObject* args)
{
    if(!PyArg_ParseTuple(args, ""))
    {
        return NULL;
    }
    llvm::TargetOptions* var_llvm_TargetOptions = new llvm::TargetOptions();
    PyObject* var_PyObject = pycapsule_new(cast_to_base<llvm::TargetOptions >::from(var_llvm_TargetOptions), "llvm::TargetOptions", "llvm::TargetOptions");
    if (!var_PyObject)
    {
        return NULL;
    }
    return var_PyObject;
}

static
PyMethodDef meth_llvm_TargetOptions[] = {
    { "delete", (PyCFunction)llvm_TargetOptions__delete, METH_VARARGS, NULL },
    { "new", (PyCFunction)llvm_TargetOptions__new, METH_VARARGS, NULL },
    { NULL },
};

static
SubModuleEntry submodule_llvm_TargetOptions[] = {
    { NULL }
};

static
PyMethodDef meth_llvm_AssemblyAnnotationWriter[] = {
    { NULL },
};

static
SubModuleEntry submodule_llvm_AssemblyAnnotationWriter[] = {
    { NULL }
};

static
PyObject*
llvm_Instruction__hasMetadata(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Instruction* var_llvm_Instruction = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void);
        if(!var_llvm_Instruction1)
        {
            return NULL;
        }
        var_llvm_Instruction = var_llvm_Instruction1;
    }
    bool var_bool = var_llvm_Instruction->hasMetadata();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Instruction__isArithmeticShift(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Instruction* var_llvm_Instruction = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void);
        if(!var_llvm_Instruction1)
        {
            return NULL;
        }
        var_llvm_Instruction = var_llvm_Instruction1;
    }
    bool var_bool = var_llvm_Instruction->isArithmeticShift();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Instruction__insertBefore(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::Instruction* var_llvm_Instruction = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void);
        if(!var_llvm_Instruction1)
        {
            return NULL;
        }
        var_llvm_Instruction = var_llvm_Instruction1;
    }
    llvm::Instruction* var_llvm_Instruction2 = NULL;
    if (var_PyObject1 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Value");
        if(!var_void1)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction3 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void1);
        if(!var_llvm_Instruction3)
        {
            return NULL;
        }
        var_llvm_Instruction2 = var_llvm_Instruction3;
    }
    var_llvm_Instruction->insertBefore(var_llvm_Instruction2);
    Py_RETURN_NONE;
}

static
PyObject*
llvm_Instruction__isAssociative(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Instruction* var_llvm_Instruction = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void);
        if(!var_llvm_Instruction1)
        {
            return NULL;
        }
        var_llvm_Instruction = var_llvm_Instruction1;
    }
    bool var_bool = var_llvm_Instruction->isAssociative();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Instruction__isTerminator(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Instruction* var_llvm_Instruction = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void);
        if(!var_llvm_Instruction1)
        {
            return NULL;
        }
        var_llvm_Instruction = var_llvm_Instruction1;
    }
    bool var_bool = var_llvm_Instruction->isTerminator();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Instruction__isIdempotent(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Instruction* var_llvm_Instruction = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void);
        if(!var_llvm_Instruction1)
        {
            return NULL;
        }
        var_llvm_Instruction = var_llvm_Instruction1;
    }
    bool var_bool = var_llvm_Instruction->isIdempotent();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Instruction__isCommutative(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Instruction* var_llvm_Instruction = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void);
        if(!var_llvm_Instruction1)
        {
            return NULL;
        }
        var_llvm_Instruction = var_llvm_Instruction1;
    }
    bool var_bool = var_llvm_Instruction->isCommutative();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Instruction__isShift(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Instruction* var_llvm_Instruction = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void);
        if(!var_llvm_Instruction1)
        {
            return NULL;
        }
        var_llvm_Instruction = var_llvm_Instruction1;
    }
    bool var_bool = var_llvm_Instruction->isShift();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Instruction__isBinaryOp(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Instruction* var_llvm_Instruction = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void);
        if(!var_llvm_Instruction1)
        {
            return NULL;
        }
        var_llvm_Instruction = var_llvm_Instruction1;
    }
    bool var_bool = var_llvm_Instruction->isBinaryOp();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Instruction__eraseFromParent(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Instruction* var_llvm_Instruction = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void);
        if(!var_llvm_Instruction1)
        {
            return NULL;
        }
        var_llvm_Instruction = var_llvm_Instruction1;
    }
    var_llvm_Instruction->eraseFromParent();
    Py_RETURN_NONE;
}

static
PyObject*
llvm_Instruction__getOpcode(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Instruction* var_llvm_Instruction = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void);
        if(!var_llvm_Instruction1)
        {
            return NULL;
        }
        var_llvm_Instruction = var_llvm_Instruction1;
    }
    unsigned var_unsigned = var_llvm_Instruction->getOpcode();
    PyObject* var_PyObject1 = py_int_from_unsigned(var_unsigned);
    return var_PyObject1;
}

static
PyObject*
llvm_Instruction__setMetadata(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    PyObject* var_PyObject2;
    if(!PyArg_ParseTuple(args, "OOO", &var_PyObject, &var_PyObject1, &var_PyObject2))
    {
        return NULL;
    }
    llvm::Instruction* var_llvm_Instruction = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void);
        if(!var_llvm_Instruction1)
        {
            return NULL;
        }
        var_llvm_Instruction = var_llvm_Instruction1;
    }
    llvm::StringRef var_llvm_StringRef;
    int var_int = py_str_to(var_PyObject1, var_llvm_StringRef);
    if(!var_int)
    {
        return NULL;
    }
    llvm::MDNode* var_llvm_MDNode = NULL;
    if (var_PyObject2 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject2, "llvm::Value");
        if(!var_void1)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::MDNode* var_llvm_MDNode1 = unwrap_as<llvm::MDNode, llvm::Value >::from(var_void1);
        if(!var_llvm_MDNode1)
        {
            return NULL;
        }
        var_llvm_MDNode = var_llvm_MDNode1;
    }
    var_llvm_Instruction->setMetadata(var_llvm_StringRef, var_llvm_MDNode);
    Py_RETURN_NONE;
}

static
PyObject*
llvm_Instruction__isNilpotent(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Instruction* var_llvm_Instruction = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void);
        if(!var_llvm_Instruction1)
        {
            return NULL;
        }
        var_llvm_Instruction = var_llvm_Instruction1;
    }
    bool var_bool = var_llvm_Instruction->isNilpotent();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Instruction__getPrevNode(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Instruction* var_llvm_Instruction = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void);
        if(!var_llvm_Instruction1)
        {
            return NULL;
        }
        var_llvm_Instruction = var_llvm_Instruction1;
    }
    llvm::Instruction* var_llvm_Instruction2 = var_llvm_Instruction->getPrevNode();
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Instruction2), "llvm::Value", "llvm::Instruction");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyObject*
llvm_Instruction__mayThrow(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Instruction* var_llvm_Instruction = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void);
        if(!var_llvm_Instruction1)
        {
            return NULL;
        }
        var_llvm_Instruction = var_llvm_Instruction1;
    }
    bool var_bool = var_llvm_Instruction->mayThrow();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Instruction__getOpcodeName(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Instruction* var_llvm_Instruction = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void);
        if(!var_llvm_Instruction1)
        {
            return NULL;
        }
        var_llvm_Instruction = var_llvm_Instruction1;
    }
    const char* var_const_char = var_llvm_Instruction->getOpcodeName();
    PyObject* var_PyObject1 = py_str_from(var_const_char);
    return var_PyObject1;
}

static
PyObject*
llvm_Instruction__mayReadOrWriteMemory(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Instruction* var_llvm_Instruction = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void);
        if(!var_llvm_Instruction1)
        {
            return NULL;
        }
        var_llvm_Instruction = var_llvm_Instruction1;
    }
    bool var_bool = var_llvm_Instruction->mayReadOrWriteMemory();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Instruction__moveBefore(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::Instruction* var_llvm_Instruction = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void);
        if(!var_llvm_Instruction1)
        {
            return NULL;
        }
        var_llvm_Instruction = var_llvm_Instruction1;
    }
    llvm::Instruction* var_llvm_Instruction2 = NULL;
    if (var_PyObject1 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Value");
        if(!var_void1)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction3 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void1);
        if(!var_llvm_Instruction3)
        {
            return NULL;
        }
        var_llvm_Instruction2 = var_llvm_Instruction3;
    }
    var_llvm_Instruction->moveBefore(var_llvm_Instruction2);
    Py_RETURN_NONE;
}

static
PyObject*
llvm_Instruction__removeFromParent(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Instruction* var_llvm_Instruction = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void);
        if(!var_llvm_Instruction1)
        {
            return NULL;
        }
        var_llvm_Instruction = var_llvm_Instruction1;
    }
    var_llvm_Instruction->removeFromParent();
    Py_RETURN_NONE;
}

static
PyObject*
llvm_Instruction__isCast(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Instruction* var_llvm_Instruction = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void);
        if(!var_llvm_Instruction1)
        {
            return NULL;
        }
        var_llvm_Instruction = var_llvm_Instruction1;
    }
    bool var_bool = var_llvm_Instruction->isCast();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Instruction__isLogicalShift(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Instruction* var_llvm_Instruction = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void);
        if(!var_llvm_Instruction1)
        {
            return NULL;
        }
        var_llvm_Instruction = var_llvm_Instruction1;
    }
    bool var_bool = var_llvm_Instruction->isLogicalShift();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Instruction__mayReadFromMemory(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Instruction* var_llvm_Instruction = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void);
        if(!var_llvm_Instruction1)
        {
            return NULL;
        }
        var_llvm_Instruction = var_llvm_Instruction1;
    }
    bool var_bool = var_llvm_Instruction->mayReadFromMemory();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Instruction__mayHaveSideEffects(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Instruction* var_llvm_Instruction = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void);
        if(!var_llvm_Instruction1)
        {
            return NULL;
        }
        var_llvm_Instruction = var_llvm_Instruction1;
    }
    bool var_bool = var_llvm_Instruction->mayHaveSideEffects();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Instruction__getNextNode(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Instruction* var_llvm_Instruction = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void);
        if(!var_llvm_Instruction1)
        {
            return NULL;
        }
        var_llvm_Instruction = var_llvm_Instruction1;
    }
    llvm::Instruction* var_llvm_Instruction2 = var_llvm_Instruction->getNextNode();
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Instruction2), "llvm::Value", "llvm::Instruction");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyObject*
llvm_Instruction__mayWriteToMemory(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Instruction* var_llvm_Instruction = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void);
        if(!var_llvm_Instruction1)
        {
            return NULL;
        }
        var_llvm_Instruction = var_llvm_Instruction1;
    }
    bool var_bool = var_llvm_Instruction->mayWriteToMemory();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Instruction__hasMetadataOtherThanDebugLoc(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Instruction* var_llvm_Instruction = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void);
        if(!var_llvm_Instruction1)
        {
            return NULL;
        }
        var_llvm_Instruction = var_llvm_Instruction1;
    }
    bool var_bool = var_llvm_Instruction->hasMetadataOtherThanDebugLoc();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_Instruction__getMetadata(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::Instruction* var_llvm_Instruction = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void);
        if(!var_llvm_Instruction1)
        {
            return NULL;
        }
        var_llvm_Instruction = var_llvm_Instruction1;
    }
    llvm::StringRef var_llvm_StringRef;
    int var_int = py_str_to(var_PyObject1, var_llvm_StringRef);
    if(!var_int)
    {
        return NULL;
    }
    llvm::MDNode* var_llvm_MDNode = var_llvm_Instruction->getMetadata(var_llvm_StringRef);
    PyObject* var_PyObject2 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_MDNode), "llvm::Value", "llvm::MDNode");
    if (!var_PyObject2)
    {
        return NULL;
    }
    return var_PyObject2;
}

static
PyObject*
llvm_Instruction__insertAfter(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::Instruction* var_llvm_Instruction = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void);
        if(!var_llvm_Instruction1)
        {
            return NULL;
        }
        var_llvm_Instruction = var_llvm_Instruction1;
    }
    llvm::Instruction* var_llvm_Instruction2 = NULL;
    if (var_PyObject1 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Value");
        if(!var_void1)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction3 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void1);
        if(!var_llvm_Instruction3)
        {
            return NULL;
        }
        var_llvm_Instruction2 = var_llvm_Instruction3;
    }
    var_llvm_Instruction->insertAfter(var_llvm_Instruction2);
    Py_RETURN_NONE;
}

static
PyObject*
llvm_Instruction__getParent(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Instruction* var_llvm_Instruction = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void);
        if(!var_llvm_Instruction1)
        {
            return NULL;
        }
        var_llvm_Instruction = var_llvm_Instruction1;
    }
    llvm::BasicBlock* var_llvm_BasicBlock = var_llvm_Instruction->getParent();
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_BasicBlock), "llvm::Value", "llvm::BasicBlock");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyObject*
llvm_Instruction__clone(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Instruction* var_llvm_Instruction = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction1 = unwrap_as<llvm::Instruction, llvm::Value >::from(var_void);
        if(!var_llvm_Instruction1)
        {
            return NULL;
        }
        var_llvm_Instruction = var_llvm_Instruction1;
    }
    llvm::Instruction* var_llvm_Instruction2 = var_llvm_Instruction->clone();
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Instruction2), "llvm::Value", "llvm::Instruction");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyMethodDef meth_llvm_Instruction[] = {
    { "hasMetadata", (PyCFunction)llvm_Instruction__hasMetadata, METH_VARARGS, NULL },
    { "isArithmeticShift", (PyCFunction)llvm_Instruction__isArithmeticShift, METH_VARARGS, NULL },
    { "insertBefore", (PyCFunction)llvm_Instruction__insertBefore, METH_VARARGS, NULL },
    { "isAssociative", (PyCFunction)llvm_Instruction__isAssociative, METH_VARARGS, NULL },
    { "isTerminator", (PyCFunction)llvm_Instruction__isTerminator, METH_VARARGS, NULL },
    { "isIdempotent", (PyCFunction)llvm_Instruction__isIdempotent, METH_VARARGS, NULL },
    { "isCommutative", (PyCFunction)llvm_Instruction__isCommutative, METH_VARARGS, NULL },
    { "isShift", (PyCFunction)llvm_Instruction__isShift, METH_VARARGS, NULL },
    { "isBinaryOp", (PyCFunction)llvm_Instruction__isBinaryOp, METH_VARARGS, NULL },
    { "eraseFromParent", (PyCFunction)llvm_Instruction__eraseFromParent, METH_VARARGS, NULL },
    { "getOpcode", (PyCFunction)llvm_Instruction__getOpcode, METH_VARARGS, NULL },
    { "setMetadata", (PyCFunction)llvm_Instruction__setMetadata, METH_VARARGS, NULL },
    { "isNilpotent", (PyCFunction)llvm_Instruction__isNilpotent, METH_VARARGS, NULL },
    { "getPrevNode", (PyCFunction)llvm_Instruction__getPrevNode, METH_VARARGS, NULL },
    { "mayThrow", (PyCFunction)llvm_Instruction__mayThrow, METH_VARARGS, NULL },
    { "getOpcodeName", (PyCFunction)llvm_Instruction__getOpcodeName, METH_VARARGS, NULL },
    { "mayReadOrWriteMemory", (PyCFunction)llvm_Instruction__mayReadOrWriteMemory, METH_VARARGS, NULL },
    { "moveBefore", (PyCFunction)llvm_Instruction__moveBefore, METH_VARARGS, NULL },
    { "removeFromParent", (PyCFunction)llvm_Instruction__removeFromParent, METH_VARARGS, NULL },
    { "isCast", (PyCFunction)llvm_Instruction__isCast, METH_VARARGS, NULL },
    { "isLogicalShift", (PyCFunction)llvm_Instruction__isLogicalShift, METH_VARARGS, NULL },
    { "mayReadFromMemory", (PyCFunction)llvm_Instruction__mayReadFromMemory, METH_VARARGS, NULL },
    { "mayHaveSideEffects", (PyCFunction)llvm_Instruction__mayHaveSideEffects, METH_VARARGS, NULL },
    { "getNextNode", (PyCFunction)llvm_Instruction__getNextNode, METH_VARARGS, NULL },
    { "mayWriteToMemory", (PyCFunction)llvm_Instruction__mayWriteToMemory, METH_VARARGS, NULL },
    { "hasMetadataOtherThanDebugLoc", (PyCFunction)llvm_Instruction__hasMetadataOtherThanDebugLoc, METH_VARARGS, NULL },
    { "getMetadata", (PyCFunction)llvm_Instruction__getMetadata, METH_VARARGS, NULL },
    { "insertAfter", (PyCFunction)llvm_Instruction__insertAfter, METH_VARARGS, NULL },
    { "getParent", (PyCFunction)llvm_Instruction__getParent, METH_VARARGS, NULL },
    { "clone", (PyCFunction)llvm_Instruction__clone, METH_VARARGS, NULL },
    { NULL },
};

static
SubModuleEntry submodule_llvm_Instruction[] = {
    { NULL }
};

static
PyMethodDef meth_llvm_AtomicCmpXchgInst[] = {
    { NULL },
};

static
SubModuleEntry submodule_llvm_AtomicCmpXchgInst[] = {
    { NULL }
};

static
PyObject*
llvm_AtomicRMWInst__BinOp__Xchg(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject = PyInt_FromLong(llvm::AtomicRMWInst::Xchg);
    return var_PyObject;
}

static
PyObject*
llvm_AtomicRMWInst__BinOp__Add(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject1 = PyInt_FromLong(llvm::AtomicRMWInst::Add);
    return var_PyObject1;
}

static
PyObject*
llvm_AtomicRMWInst__BinOp__Sub(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject2 = PyInt_FromLong(llvm::AtomicRMWInst::Sub);
    return var_PyObject2;
}

static
PyObject*
llvm_AtomicRMWInst__BinOp__And(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject3 = PyInt_FromLong(llvm::AtomicRMWInst::And);
    return var_PyObject3;
}

static
PyObject*
llvm_AtomicRMWInst__BinOp__Nand(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject4 = PyInt_FromLong(llvm::AtomicRMWInst::Nand);
    return var_PyObject4;
}

static
PyObject*
llvm_AtomicRMWInst__BinOp__Or(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject5 = PyInt_FromLong(llvm::AtomicRMWInst::Or);
    return var_PyObject5;
}

static
PyObject*
llvm_AtomicRMWInst__BinOp__Xor(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject6 = PyInt_FromLong(llvm::AtomicRMWInst::Xor);
    return var_PyObject6;
}

static
PyObject*
llvm_AtomicRMWInst__BinOp__Max(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject7 = PyInt_FromLong(llvm::AtomicRMWInst::Max);
    return var_PyObject7;
}

static
PyObject*
llvm_AtomicRMWInst__BinOp__Min(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject8 = PyInt_FromLong(llvm::AtomicRMWInst::Min);
    return var_PyObject8;
}

static
PyObject*
llvm_AtomicRMWInst__BinOp__UMax(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject9 = PyInt_FromLong(llvm::AtomicRMWInst::UMax);
    return var_PyObject9;
}

static
PyObject*
llvm_AtomicRMWInst__BinOp__UMin(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject10 = PyInt_FromLong(llvm::AtomicRMWInst::UMin);
    return var_PyObject10;
}

static
PyObject*
llvm_AtomicRMWInst__BinOp__FIRST__BINOP(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject11 = PyInt_FromLong(llvm::AtomicRMWInst::FIRST_BINOP);
    return var_PyObject11;
}

static
PyObject*
llvm_AtomicRMWInst__BinOp__LAST__BINOP(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject12 = PyInt_FromLong(llvm::AtomicRMWInst::LAST_BINOP);
    return var_PyObject12;
}

static
PyObject*
llvm_AtomicRMWInst__BinOp__BAD__BINOP(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject13 = PyInt_FromLong(llvm::AtomicRMWInst::BAD_BINOP);
    return var_PyObject13;
}

static
PyMethodDef meth_llvm_AtomicRMWInst[] = {
    { "Xchg", (PyCFunction)llvm_AtomicRMWInst__BinOp__Xchg, METH_VARARGS, NULL },
    { "Add", (PyCFunction)llvm_AtomicRMWInst__BinOp__Add, METH_VARARGS, NULL },
    { "Sub", (PyCFunction)llvm_AtomicRMWInst__BinOp__Sub, METH_VARARGS, NULL },
    { "And", (PyCFunction)llvm_AtomicRMWInst__BinOp__And, METH_VARARGS, NULL },
    { "Nand", (PyCFunction)llvm_AtomicRMWInst__BinOp__Nand, METH_VARARGS, NULL },
    { "Or", (PyCFunction)llvm_AtomicRMWInst__BinOp__Or, METH_VARARGS, NULL },
    { "Xor", (PyCFunction)llvm_AtomicRMWInst__BinOp__Xor, METH_VARARGS, NULL },
    { "Max", (PyCFunction)llvm_AtomicRMWInst__BinOp__Max, METH_VARARGS, NULL },
    { "Min", (PyCFunction)llvm_AtomicRMWInst__BinOp__Min, METH_VARARGS, NULL },
    { "UMax", (PyCFunction)llvm_AtomicRMWInst__BinOp__UMax, METH_VARARGS, NULL },
    { "UMin", (PyCFunction)llvm_AtomicRMWInst__BinOp__UMin, METH_VARARGS, NULL },
    { "FIRST_BINOP", (PyCFunction)llvm_AtomicRMWInst__BinOp__FIRST__BINOP, METH_VARARGS, NULL },
    { "LAST_BINOP", (PyCFunction)llvm_AtomicRMWInst__BinOp__LAST__BINOP, METH_VARARGS, NULL },
    { "BAD_BINOP", (PyCFunction)llvm_AtomicRMWInst__BinOp__BAD__BINOP, METH_VARARGS, NULL },
    { NULL },
};

static
SubModuleEntry submodule_llvm_AtomicRMWInst[] = {
    { NULL }
};

static
PyMethodDef meth_llvm_BinaryOperator[] = {
    { NULL },
};

static
SubModuleEntry submodule_llvm_BinaryOperator[] = {
    { NULL }
};

static
PyObject*
llvm_CallInst__getArgOperand(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::CallInst* var_llvm_CallInst = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::CallInst* var_llvm_CallInst1 = unwrap_as<llvm::CallInst, llvm::Value >::from(var_void);
        if(!var_llvm_CallInst1)
        {
            return NULL;
        }
        var_llvm_CallInst = var_llvm_CallInst1;
    }
    unsigned var_unsigned;
    int var_int = py_int_to(var_PyObject1, var_unsigned);
    if(!var_int)
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = var_llvm_CallInst->getArgOperand(var_unsigned);
    PyObject* var_PyObject2 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Value), "llvm::Value", "llvm::Value");
    if (!var_PyObject2)
    {
        return NULL;
    }
    return var_PyObject2;
}

static
PyObject*
llvm_CallInst__getCalledValue(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::CallInst* var_llvm_CallInst = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::CallInst* var_llvm_CallInst1 = unwrap_as<llvm::CallInst, llvm::Value >::from(var_void);
        if(!var_llvm_CallInst1)
        {
            return NULL;
        }
        var_llvm_CallInst = var_llvm_CallInst1;
    }
    llvm::Value* var_llvm_Value = var_llvm_CallInst->getCalledValue();
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Value), "llvm::Value", "llvm::Value");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyObject*
llvm_CallInst__getCalledFunction(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::CallInst* var_llvm_CallInst = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::CallInst* var_llvm_CallInst1 = unwrap_as<llvm::CallInst, llvm::Value >::from(var_void);
        if(!var_llvm_CallInst1)
        {
            return NULL;
        }
        var_llvm_CallInst = var_llvm_CallInst1;
    }
    llvm::Function* var_llvm_Function = var_llvm_CallInst->getCalledFunction();
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Function), "llvm::Value", "llvm::Function");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyObject*
llvm_CallInst__getCallingConv(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::CallInst* var_llvm_CallInst = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::CallInst* var_llvm_CallInst1 = unwrap_as<llvm::CallInst, llvm::Value >::from(var_void);
        if(!var_llvm_CallInst1)
        {
            return NULL;
        }
        var_llvm_CallInst = var_llvm_CallInst1;
    }
    llvm::CallingConv::ID var_llvm_CallingConv_ID = var_llvm_CallInst->getCallingConv();
    PyObject* var_PyObject1 = PyInt_FromLong(var_llvm_CallingConv_ID);
    return var_PyObject1;
}

static
PyObject*
llvm_CallInst__CreateFree(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    llvm::BasicBlock* var_llvm_BasicBlock = NULL;
    if (var_PyObject1 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Value");
        if(!var_void1)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::BasicBlock* var_llvm_BasicBlock1 = unwrap_as<llvm::BasicBlock, llvm::Value >::from(var_void1);
        if(!var_llvm_BasicBlock1)
        {
            return NULL;
        }
        var_llvm_BasicBlock = var_llvm_BasicBlock1;
    }
    llvm::Instruction* var_llvm_Instruction = llvm::CallInst::CreateFree(var_llvm_Value, var_llvm_BasicBlock);
    PyObject* var_PyObject2 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Instruction), "llvm::Value", "llvm::Instruction");
    if (!var_PyObject2)
    {
        return NULL;
    }
    return var_PyObject2;
}

static
PyObject*
llvm_CallInst__getParamAlignment(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::CallInst* var_llvm_CallInst = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::CallInst* var_llvm_CallInst1 = unwrap_as<llvm::CallInst, llvm::Value >::from(var_void);
        if(!var_llvm_CallInst1)
        {
            return NULL;
        }
        var_llvm_CallInst = var_llvm_CallInst1;
    }
    unsigned var_unsigned;
    int var_int = py_int_to(var_PyObject1, var_unsigned);
    if(!var_int)
    {
        return NULL;
    }
    unsigned var_unsigned1 = var_llvm_CallInst->getParamAlignment(var_unsigned);
    PyObject* var_PyObject2 = py_int_from_unsigned(var_unsigned1);
    return var_PyObject2;
}

static
PyObject*
llvm_CallInst__getNumArgOperands(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::CallInst* var_llvm_CallInst = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::CallInst* var_llvm_CallInst1 = unwrap_as<llvm::CallInst, llvm::Value >::from(var_void);
        if(!var_llvm_CallInst1)
        {
            return NULL;
        }
        var_llvm_CallInst = var_llvm_CallInst1;
    }
    unsigned var_unsigned = var_llvm_CallInst->getNumArgOperands();
    PyObject* var_PyObject1 = py_int_from_unsigned(var_unsigned);
    return var_PyObject1;
}

static
PyObject*
llvm_CallInst__setArgOperand(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    PyObject* var_PyObject2;
    if(!PyArg_ParseTuple(args, "OOO", &var_PyObject, &var_PyObject1, &var_PyObject2))
    {
        return NULL;
    }
    llvm::CallInst* var_llvm_CallInst = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::CallInst* var_llvm_CallInst1 = unwrap_as<llvm::CallInst, llvm::Value >::from(var_void);
        if(!var_llvm_CallInst1)
        {
            return NULL;
        }
        var_llvm_CallInst = var_llvm_CallInst1;
    }
    unsigned var_unsigned;
    int var_int = py_int_to(var_PyObject1, var_unsigned);
    if(!var_int)
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject2 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject2, "llvm::Value");
        if(!var_void1)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void1);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    var_llvm_CallInst->setArgOperand(var_unsigned, var_llvm_Value);
    Py_RETURN_NONE;
}

static
PyObject*
llvm_CallInst__isInlineAsm(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::CallInst* var_llvm_CallInst = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::CallInst* var_llvm_CallInst1 = unwrap_as<llvm::CallInst, llvm::Value >::from(var_void);
        if(!var_llvm_CallInst1)
        {
            return NULL;
        }
        var_llvm_CallInst = var_llvm_CallInst1;
    }
    bool var_bool = var_llvm_CallInst->isInlineAsm();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_CallInst__addAttribute(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    PyObject* var_PyObject2;
    if(!PyArg_ParseTuple(args, "OOO", &var_PyObject, &var_PyObject1, &var_PyObject2))
    {
        return NULL;
    }
    llvm::CallInst* var_llvm_CallInst = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::CallInst* var_llvm_CallInst1 = unwrap_as<llvm::CallInst, llvm::Value >::from(var_void);
        if(!var_llvm_CallInst1)
        {
            return NULL;
        }
        var_llvm_CallInst = var_llvm_CallInst1;
    }
    unsigned var_unsigned;
    int var_int = py_int_to(var_PyObject1, var_unsigned);
    if(!var_int)
    {
        return NULL;
    }
    llvm::Attribute::AttrKind var_llvm_Attribute_AttrKind = (llvm::Attribute::AttrKind)PyInt_AsLong(var_PyObject2);
    var_llvm_CallInst->addAttribute(var_unsigned, var_llvm_Attribute_AttrKind);
    Py_RETURN_NONE;
}

static
PyObject*
llvm_CallInst__setCallingConv(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::CallInst* var_llvm_CallInst = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::CallInst* var_llvm_CallInst1 = unwrap_as<llvm::CallInst, llvm::Value >::from(var_void);
        if(!var_llvm_CallInst1)
        {
            return NULL;
        }
        var_llvm_CallInst = var_llvm_CallInst1;
    }
    llvm::CallingConv::ID var_llvm_CallingConv_ID = (llvm::CallingConv::ID)PyInt_AsLong(var_PyObject1);
    var_llvm_CallInst->setCallingConv(var_llvm_CallingConv_ID);
    Py_RETURN_NONE;
}

static
PyObject*
llvm_CallInst__setCalledFunction(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::CallInst* var_llvm_CallInst = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::CallInst* var_llvm_CallInst1 = unwrap_as<llvm::CallInst, llvm::Value >::from(var_void);
        if(!var_llvm_CallInst1)
        {
            return NULL;
        }
        var_llvm_CallInst = var_llvm_CallInst1;
    }
    llvm::Function* var_llvm_Function = NULL;
    if (var_PyObject1 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Value");
        if(!var_void1)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Function* var_llvm_Function1 = unwrap_as<llvm::Function, llvm::Value >::from(var_void1);
        if(!var_llvm_Function1)
        {
            return NULL;
        }
        var_llvm_Function = var_llvm_Function1;
    }
    var_llvm_CallInst->setCalledFunction(var_llvm_Function);
    Py_RETURN_NONE;
}

static
PyObject*
llvm_CallInst__CreateMalloc(PyObject* self, PyObject* args)
{
    Py_ssize_t var_Py__ssize__t = PyTuple_Size(args);
    if (7 == var_Py__ssize__t)
    {
        PyObject* var_PyObject;
        PyObject* var_PyObject1;
        PyObject* var_PyObject2;
        PyObject* var_PyObject3;
        PyObject* var_PyObject4;
        PyObject* var_PyObject5;
        PyObject* var_PyObject6;
        if(!PyArg_ParseTuple(args, "OOOOOOO", &var_PyObject, &var_PyObject1, &var_PyObject2, &var_PyObject3, &var_PyObject4, &var_PyObject5, &var_PyObject6))
        {
            return NULL;
        }
        llvm::BasicBlock* var_llvm_BasicBlock = NULL;
        if (var_PyObject != Py_None)
        {
            void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
            if(!var_void)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::BasicBlock* var_llvm_BasicBlock1 = unwrap_as<llvm::BasicBlock, llvm::Value >::from(var_void);
            if(!var_llvm_BasicBlock1)
            {
                return NULL;
            }
            var_llvm_BasicBlock = var_llvm_BasicBlock1;
        }
        llvm::Type* var_llvm_Type = NULL;
        if (var_PyObject1 != Py_None)
        {
            void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Type");
            if(!var_void1)
            {
                puts("Error: llvm::Type");
                return NULL;
            }
            llvm::Type* var_llvm_Type1 = unwrap_as<llvm::Type, llvm::Type >::from(var_void1);
            if(!var_llvm_Type1)
            {
                return NULL;
            }
            var_llvm_Type = var_llvm_Type1;
        }
        llvm::Type* var_llvm_Type2 = NULL;
        if (var_PyObject2 != Py_None)
        {
            void* var_void2 = PyCapsule_GetPointer(var_PyObject2, "llvm::Type");
            if(!var_void2)
            {
                puts("Error: llvm::Type");
                return NULL;
            }
            llvm::Type* var_llvm_Type3 = unwrap_as<llvm::Type, llvm::Type >::from(var_void2);
            if(!var_llvm_Type3)
            {
                return NULL;
            }
            var_llvm_Type2 = var_llvm_Type3;
        }
        llvm::Value* var_llvm_Value = NULL;
        if (var_PyObject3 != Py_None)
        {
            void* var_void3 = PyCapsule_GetPointer(var_PyObject3, "llvm::Value");
            if(!var_void3)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void3);
            if(!var_llvm_Value1)
            {
                return NULL;
            }
            var_llvm_Value = var_llvm_Value1;
        }
        llvm::Value* var_llvm_Value2 = NULL;
        if (var_PyObject4 != Py_None)
        {
            void* var_void4 = PyCapsule_GetPointer(var_PyObject4, "llvm::Value");
            if(!var_void4)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::Value* var_llvm_Value3 = unwrap_as<llvm::Value, llvm::Value >::from(var_void4);
            if(!var_llvm_Value3)
            {
                return NULL;
            }
            var_llvm_Value2 = var_llvm_Value3;
        }
        llvm::Function* var_llvm_Function = NULL;
        if (var_PyObject5 != Py_None)
        {
            void* var_void5 = PyCapsule_GetPointer(var_PyObject5, "llvm::Value");
            if(!var_void5)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::Function* var_llvm_Function1 = unwrap_as<llvm::Function, llvm::Value >::from(var_void5);
            if(!var_llvm_Function1)
            {
                return NULL;
            }
            var_llvm_Function = var_llvm_Function1;
        }
        llvm::StringRef var_llvm_StringRef;
        int var_int = py_str_to(var_PyObject6, var_llvm_StringRef);
        if(!var_int)
        {
            return NULL;
        }
        llvm::Instruction* var_llvm_Instruction = llvm::CallInst::CreateMalloc(var_llvm_BasicBlock, var_llvm_Type, var_llvm_Type2, var_llvm_Value, var_llvm_Value2, var_llvm_Function, var_llvm_StringRef);
        PyObject* var_PyObject7 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Instruction), "llvm::Value", "llvm::Instruction");
        if (!var_PyObject7)
        {
            return NULL;
        }
        return var_PyObject7;
    }
    if (4 == var_Py__ssize__t)
    {
        PyObject* var_PyObject8;
        PyObject* var_PyObject9;
        PyObject* var_PyObject10;
        PyObject* var_PyObject11;
        if(!PyArg_ParseTuple(args, "OOOO", &var_PyObject8, &var_PyObject9, &var_PyObject10, &var_PyObject11))
        {
            return NULL;
        }
        llvm::BasicBlock* var_llvm_BasicBlock2 = NULL;
        if (var_PyObject8 != Py_None)
        {
            void* var_void6 = PyCapsule_GetPointer(var_PyObject8, "llvm::Value");
            if(!var_void6)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::BasicBlock* var_llvm_BasicBlock3 = unwrap_as<llvm::BasicBlock, llvm::Value >::from(var_void6);
            if(!var_llvm_BasicBlock3)
            {
                return NULL;
            }
            var_llvm_BasicBlock2 = var_llvm_BasicBlock3;
        }
        llvm::Type* var_llvm_Type4 = NULL;
        if (var_PyObject9 != Py_None)
        {
            void* var_void7 = PyCapsule_GetPointer(var_PyObject9, "llvm::Type");
            if(!var_void7)
            {
                puts("Error: llvm::Type");
                return NULL;
            }
            llvm::Type* var_llvm_Type5 = unwrap_as<llvm::Type, llvm::Type >::from(var_void7);
            if(!var_llvm_Type5)
            {
                return NULL;
            }
            var_llvm_Type4 = var_llvm_Type5;
        }
        llvm::Type* var_llvm_Type6 = NULL;
        if (var_PyObject10 != Py_None)
        {
            void* var_void8 = PyCapsule_GetPointer(var_PyObject10, "llvm::Type");
            if(!var_void8)
            {
                puts("Error: llvm::Type");
                return NULL;
            }
            llvm::Type* var_llvm_Type7 = unwrap_as<llvm::Type, llvm::Type >::from(var_void8);
            if(!var_llvm_Type7)
            {
                return NULL;
            }
            var_llvm_Type6 = var_llvm_Type7;
        }
        llvm::Value* var_llvm_Value4 = NULL;
        if (var_PyObject11 != Py_None)
        {
            void* var_void9 = PyCapsule_GetPointer(var_PyObject11, "llvm::Value");
            if(!var_void9)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::Value* var_llvm_Value5 = unwrap_as<llvm::Value, llvm::Value >::from(var_void9);
            if(!var_llvm_Value5)
            {
                return NULL;
            }
            var_llvm_Value4 = var_llvm_Value5;
        }
        llvm::Instruction* var_llvm_Instruction1 = llvm::CallInst::CreateMalloc(var_llvm_BasicBlock2, var_llvm_Type4, var_llvm_Type6, var_llvm_Value4);
        PyObject* var_PyObject12 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Instruction1), "llvm::Value", "llvm::Instruction");
        if (!var_PyObject12)
        {
            return NULL;
        }
        return var_PyObject12;
    }
    if (5 == var_Py__ssize__t)
    {
        PyObject* var_PyObject13;
        PyObject* var_PyObject14;
        PyObject* var_PyObject15;
        PyObject* var_PyObject16;
        PyObject* var_PyObject17;
        if(!PyArg_ParseTuple(args, "OOOOO", &var_PyObject13, &var_PyObject14, &var_PyObject15, &var_PyObject16, &var_PyObject17))
        {
            return NULL;
        }
        llvm::BasicBlock* var_llvm_BasicBlock4 = NULL;
        if (var_PyObject13 != Py_None)
        {
            void* var_void10 = PyCapsule_GetPointer(var_PyObject13, "llvm::Value");
            if(!var_void10)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::BasicBlock* var_llvm_BasicBlock5 = unwrap_as<llvm::BasicBlock, llvm::Value >::from(var_void10);
            if(!var_llvm_BasicBlock5)
            {
                return NULL;
            }
            var_llvm_BasicBlock4 = var_llvm_BasicBlock5;
        }
        llvm::Type* var_llvm_Type8 = NULL;
        if (var_PyObject14 != Py_None)
        {
            void* var_void11 = PyCapsule_GetPointer(var_PyObject14, "llvm::Type");
            if(!var_void11)
            {
                puts("Error: llvm::Type");
                return NULL;
            }
            llvm::Type* var_llvm_Type9 = unwrap_as<llvm::Type, llvm::Type >::from(var_void11);
            if(!var_llvm_Type9)
            {
                return NULL;
            }
            var_llvm_Type8 = var_llvm_Type9;
        }
        llvm::Type* var_llvm_Type10 = NULL;
        if (var_PyObject15 != Py_None)
        {
            void* var_void12 = PyCapsule_GetPointer(var_PyObject15, "llvm::Type");
            if(!var_void12)
            {
                puts("Error: llvm::Type");
                return NULL;
            }
            llvm::Type* var_llvm_Type11 = unwrap_as<llvm::Type, llvm::Type >::from(var_void12);
            if(!var_llvm_Type11)
            {
                return NULL;
            }
            var_llvm_Type10 = var_llvm_Type11;
        }
        llvm::Value* var_llvm_Value6 = NULL;
        if (var_PyObject16 != Py_None)
        {
            void* var_void13 = PyCapsule_GetPointer(var_PyObject16, "llvm::Value");
            if(!var_void13)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::Value* var_llvm_Value7 = unwrap_as<llvm::Value, llvm::Value >::from(var_void13);
            if(!var_llvm_Value7)
            {
                return NULL;
            }
            var_llvm_Value6 = var_llvm_Value7;
        }
        llvm::Value* var_llvm_Value8 = NULL;
        if (var_PyObject17 != Py_None)
        {
            void* var_void14 = PyCapsule_GetPointer(var_PyObject17, "llvm::Value");
            if(!var_void14)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::Value* var_llvm_Value9 = unwrap_as<llvm::Value, llvm::Value >::from(var_void14);
            if(!var_llvm_Value9)
            {
                return NULL;
            }
            var_llvm_Value8 = var_llvm_Value9;
        }
        llvm::Instruction* var_llvm_Instruction2 = llvm::CallInst::CreateMalloc(var_llvm_BasicBlock4, var_llvm_Type8, var_llvm_Type10, var_llvm_Value6, var_llvm_Value8);
        PyObject* var_PyObject18 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Instruction2), "llvm::Value", "llvm::Instruction");
        if (!var_PyObject18)
        {
            return NULL;
        }
        return var_PyObject18;
    }
    if (6 == var_Py__ssize__t)
    {
        PyObject* var_PyObject19;
        PyObject* var_PyObject20;
        PyObject* var_PyObject21;
        PyObject* var_PyObject22;
        PyObject* var_PyObject23;
        PyObject* var_PyObject24;
        if(!PyArg_ParseTuple(args, "OOOOOO", &var_PyObject19, &var_PyObject20, &var_PyObject21, &var_PyObject22, &var_PyObject23, &var_PyObject24))
        {
            return NULL;
        }
        llvm::BasicBlock* var_llvm_BasicBlock6 = NULL;
        if (var_PyObject19 != Py_None)
        {
            void* var_void15 = PyCapsule_GetPointer(var_PyObject19, "llvm::Value");
            if(!var_void15)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::BasicBlock* var_llvm_BasicBlock7 = unwrap_as<llvm::BasicBlock, llvm::Value >::from(var_void15);
            if(!var_llvm_BasicBlock7)
            {
                return NULL;
            }
            var_llvm_BasicBlock6 = var_llvm_BasicBlock7;
        }
        llvm::Type* var_llvm_Type12 = NULL;
        if (var_PyObject20 != Py_None)
        {
            void* var_void16 = PyCapsule_GetPointer(var_PyObject20, "llvm::Type");
            if(!var_void16)
            {
                puts("Error: llvm::Type");
                return NULL;
            }
            llvm::Type* var_llvm_Type13 = unwrap_as<llvm::Type, llvm::Type >::from(var_void16);
            if(!var_llvm_Type13)
            {
                return NULL;
            }
            var_llvm_Type12 = var_llvm_Type13;
        }
        llvm::Type* var_llvm_Type14 = NULL;
        if (var_PyObject21 != Py_None)
        {
            void* var_void17 = PyCapsule_GetPointer(var_PyObject21, "llvm::Type");
            if(!var_void17)
            {
                puts("Error: llvm::Type");
                return NULL;
            }
            llvm::Type* var_llvm_Type15 = unwrap_as<llvm::Type, llvm::Type >::from(var_void17);
            if(!var_llvm_Type15)
            {
                return NULL;
            }
            var_llvm_Type14 = var_llvm_Type15;
        }
        llvm::Value* var_llvm_Value10 = NULL;
        if (var_PyObject22 != Py_None)
        {
            void* var_void18 = PyCapsule_GetPointer(var_PyObject22, "llvm::Value");
            if(!var_void18)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::Value* var_llvm_Value11 = unwrap_as<llvm::Value, llvm::Value >::from(var_void18);
            if(!var_llvm_Value11)
            {
                return NULL;
            }
            var_llvm_Value10 = var_llvm_Value11;
        }
        llvm::Value* var_llvm_Value12 = NULL;
        if (var_PyObject23 != Py_None)
        {
            void* var_void19 = PyCapsule_GetPointer(var_PyObject23, "llvm::Value");
            if(!var_void19)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::Value* var_llvm_Value13 = unwrap_as<llvm::Value, llvm::Value >::from(var_void19);
            if(!var_llvm_Value13)
            {
                return NULL;
            }
            var_llvm_Value12 = var_llvm_Value13;
        }
        llvm::Function* var_llvm_Function2 = NULL;
        if (var_PyObject24 != Py_None)
        {
            void* var_void20 = PyCapsule_GetPointer(var_PyObject24, "llvm::Value");
            if(!var_void20)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::Function* var_llvm_Function3 = unwrap_as<llvm::Function, llvm::Value >::from(var_void20);
            if(!var_llvm_Function3)
            {
                return NULL;
            }
            var_llvm_Function2 = var_llvm_Function3;
        }
        llvm::Instruction* var_llvm_Instruction3 = llvm::CallInst::CreateMalloc(var_llvm_BasicBlock6, var_llvm_Type12, var_llvm_Type14, var_llvm_Value10, var_llvm_Value12, var_llvm_Function2);
        PyObject* var_PyObject25 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Instruction3), "llvm::Value", "llvm::Instruction");
        if (!var_PyObject25)
        {
            return NULL;
        }
        return var_PyObject25;
    }
    PyErr_SetString(PyExc_TypeError, "Invalid number of args");
    return NULL;
}

static
PyObject*
llvm_CallInst__removeAttribute(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    PyObject* var_PyObject2;
    if(!PyArg_ParseTuple(args, "OOO", &var_PyObject, &var_PyObject1, &var_PyObject2))
    {
        return NULL;
    }
    llvm::CallInst* var_llvm_CallInst = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::CallInst* var_llvm_CallInst1 = unwrap_as<llvm::CallInst, llvm::Value >::from(var_void);
        if(!var_llvm_CallInst1)
        {
            return NULL;
        }
        var_llvm_CallInst = var_llvm_CallInst1;
    }
    unsigned var_unsigned;
    int var_int = py_int_to(var_PyObject1, var_unsigned);
    if(!var_int)
    {
        return NULL;
    }
    void* var_void1 = PyCapsule_GetPointer(var_PyObject2, "llvm::Attribute");
    if(!var_void1)
    {
        puts("Error: llvm::Attribute");
        return NULL;
    }
    llvm::Attribute* var_llvm_Attribute = unwrap_as<llvm::Attribute, llvm::Attribute >::from(var_void1);
    if(!var_llvm_Attribute)
    {
        return NULL;
    }
    llvm::Attribute& var_llvm_Attribute1 = *var_llvm_Attribute;
    var_llvm_CallInst->removeAttribute(var_unsigned, var_llvm_Attribute1);
    Py_RETURN_NONE;
}

static
PyMethodDef meth_llvm_CallInst[] = {
    { "getArgOperand", (PyCFunction)llvm_CallInst__getArgOperand, METH_VARARGS, NULL },
    { "getCalledValue", (PyCFunction)llvm_CallInst__getCalledValue, METH_VARARGS, NULL },
    { "getCalledFunction", (PyCFunction)llvm_CallInst__getCalledFunction, METH_VARARGS, NULL },
    { "getCallingConv", (PyCFunction)llvm_CallInst__getCallingConv, METH_VARARGS, NULL },
    { "CreateFree", (PyCFunction)llvm_CallInst__CreateFree, METH_VARARGS, NULL },
    { "getParamAlignment", (PyCFunction)llvm_CallInst__getParamAlignment, METH_VARARGS, NULL },
    { "getNumArgOperands", (PyCFunction)llvm_CallInst__getNumArgOperands, METH_VARARGS, NULL },
    { "setArgOperand", (PyCFunction)llvm_CallInst__setArgOperand, METH_VARARGS, NULL },
    { "isInlineAsm", (PyCFunction)llvm_CallInst__isInlineAsm, METH_VARARGS, NULL },
    { "addAttribute", (PyCFunction)llvm_CallInst__addAttribute, METH_VARARGS, NULL },
    { "setCallingConv", (PyCFunction)llvm_CallInst__setCallingConv, METH_VARARGS, NULL },
    { "setCalledFunction", (PyCFunction)llvm_CallInst__setCalledFunction, METH_VARARGS, NULL },
    { "CreateMalloc", (PyCFunction)llvm_CallInst__CreateMalloc, METH_VARARGS, NULL },
    { "removeAttribute", (PyCFunction)llvm_CallInst__removeAttribute, METH_VARARGS, NULL },
    { NULL },
};

static
SubModuleEntry submodule_llvm_CallInst[] = {
    { NULL }
};

static
PyObject*
llvm_CmpInst__getPredicate(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::CmpInst* var_llvm_CmpInst = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::CmpInst* var_llvm_CmpInst1 = unwrap_as<llvm::CmpInst, llvm::Value >::from(var_void);
        if(!var_llvm_CmpInst1)
        {
            return NULL;
        }
        var_llvm_CmpInst = var_llvm_CmpInst1;
    }
    llvm::CmpInst::Predicate var_llvm_CmpInst_Predicate = var_llvm_CmpInst->getPredicate();
    PyObject* var_PyObject1 = PyInt_FromLong(var_llvm_CmpInst_Predicate);
    return var_PyObject1;
}

static
PyObject*
llvm_CmpInst__Predicate__FCMP__FALSE(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject = PyInt_FromLong(llvm::CmpInst::FCMP_FALSE);
    return var_PyObject;
}

static
PyObject*
llvm_CmpInst__Predicate__FCMP__OEQ(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject1 = PyInt_FromLong(llvm::CmpInst::FCMP_OEQ);
    return var_PyObject1;
}

static
PyObject*
llvm_CmpInst__Predicate__FCMP__OGT(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject2 = PyInt_FromLong(llvm::CmpInst::FCMP_OGT);
    return var_PyObject2;
}

static
PyObject*
llvm_CmpInst__Predicate__FCMP__OGE(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject3 = PyInt_FromLong(llvm::CmpInst::FCMP_OGE);
    return var_PyObject3;
}

static
PyObject*
llvm_CmpInst__Predicate__FCMP__OLT(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject4 = PyInt_FromLong(llvm::CmpInst::FCMP_OLT);
    return var_PyObject4;
}

static
PyObject*
llvm_CmpInst__Predicate__FCMP__OLE(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject5 = PyInt_FromLong(llvm::CmpInst::FCMP_OLE);
    return var_PyObject5;
}

static
PyObject*
llvm_CmpInst__Predicate__FCMP__ONE(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject6 = PyInt_FromLong(llvm::CmpInst::FCMP_ONE);
    return var_PyObject6;
}

static
PyObject*
llvm_CmpInst__Predicate__FCMP__ORD(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject7 = PyInt_FromLong(llvm::CmpInst::FCMP_ORD);
    return var_PyObject7;
}

static
PyObject*
llvm_CmpInst__Predicate__FCMP__UNO(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject8 = PyInt_FromLong(llvm::CmpInst::FCMP_UNO);
    return var_PyObject8;
}

static
PyObject*
llvm_CmpInst__Predicate__FCMP__UEQ(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject9 = PyInt_FromLong(llvm::CmpInst::FCMP_UEQ);
    return var_PyObject9;
}

static
PyObject*
llvm_CmpInst__Predicate__FCMP__UGT(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject10 = PyInt_FromLong(llvm::CmpInst::FCMP_UGT);
    return var_PyObject10;
}

static
PyObject*
llvm_CmpInst__Predicate__FCMP__UGE(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject11 = PyInt_FromLong(llvm::CmpInst::FCMP_UGE);
    return var_PyObject11;
}

static
PyObject*
llvm_CmpInst__Predicate__FCMP__ULT(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject12 = PyInt_FromLong(llvm::CmpInst::FCMP_ULT);
    return var_PyObject12;
}

static
PyObject*
llvm_CmpInst__Predicate__FCMP__ULE(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject13 = PyInt_FromLong(llvm::CmpInst::FCMP_ULE);
    return var_PyObject13;
}

static
PyObject*
llvm_CmpInst__Predicate__FCMP__UNE(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject14 = PyInt_FromLong(llvm::CmpInst::FCMP_UNE);
    return var_PyObject14;
}

static
PyObject*
llvm_CmpInst__Predicate__FCMP__TRUE(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject15 = PyInt_FromLong(llvm::CmpInst::FCMP_TRUE);
    return var_PyObject15;
}

static
PyObject*
llvm_CmpInst__Predicate__FIRST__FCMP__PREDICATE(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject16 = PyInt_FromLong(llvm::CmpInst::FIRST_FCMP_PREDICATE);
    return var_PyObject16;
}

static
PyObject*
llvm_CmpInst__Predicate__LAST__FCMP__PREDICATE(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject17 = PyInt_FromLong(llvm::CmpInst::LAST_FCMP_PREDICATE);
    return var_PyObject17;
}

static
PyObject*
llvm_CmpInst__Predicate__BAD__FCMP__PREDICATE(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject18 = PyInt_FromLong(llvm::CmpInst::BAD_FCMP_PREDICATE);
    return var_PyObject18;
}

static
PyObject*
llvm_CmpInst__Predicate__ICMP__EQ(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject19 = PyInt_FromLong(llvm::CmpInst::ICMP_EQ);
    return var_PyObject19;
}

static
PyObject*
llvm_CmpInst__Predicate__ICMP__NE(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject20 = PyInt_FromLong(llvm::CmpInst::ICMP_NE);
    return var_PyObject20;
}

static
PyObject*
llvm_CmpInst__Predicate__ICMP__UGT(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject21 = PyInt_FromLong(llvm::CmpInst::ICMP_UGT);
    return var_PyObject21;
}

static
PyObject*
llvm_CmpInst__Predicate__ICMP__UGE(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject22 = PyInt_FromLong(llvm::CmpInst::ICMP_UGE);
    return var_PyObject22;
}

static
PyObject*
llvm_CmpInst__Predicate__ICMP__ULT(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject23 = PyInt_FromLong(llvm::CmpInst::ICMP_ULT);
    return var_PyObject23;
}

static
PyObject*
llvm_CmpInst__Predicate__ICMP__ULE(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject24 = PyInt_FromLong(llvm::CmpInst::ICMP_ULE);
    return var_PyObject24;
}

static
PyObject*
llvm_CmpInst__Predicate__ICMP__SGT(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject25 = PyInt_FromLong(llvm::CmpInst::ICMP_SGT);
    return var_PyObject25;
}

static
PyObject*
llvm_CmpInst__Predicate__ICMP__SGE(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject26 = PyInt_FromLong(llvm::CmpInst::ICMP_SGE);
    return var_PyObject26;
}

static
PyObject*
llvm_CmpInst__Predicate__ICMP__SLT(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject27 = PyInt_FromLong(llvm::CmpInst::ICMP_SLT);
    return var_PyObject27;
}

static
PyObject*
llvm_CmpInst__Predicate__ICMP__SLE(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject28 = PyInt_FromLong(llvm::CmpInst::ICMP_SLE);
    return var_PyObject28;
}

static
PyObject*
llvm_CmpInst__Predicate__FIRST__ICMP__PREDICATE(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject29 = PyInt_FromLong(llvm::CmpInst::FIRST_ICMP_PREDICATE);
    return var_PyObject29;
}

static
PyObject*
llvm_CmpInst__Predicate__LAST__ICMP__PREDICATE(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject30 = PyInt_FromLong(llvm::CmpInst::LAST_ICMP_PREDICATE);
    return var_PyObject30;
}

static
PyObject*
llvm_CmpInst__Predicate__BAD__ICMP__PREDICATE(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject31 = PyInt_FromLong(llvm::CmpInst::BAD_ICMP_PREDICATE);
    return var_PyObject31;
}

static
PyMethodDef meth_llvm_CmpInst[] = {
    { "getPredicate", (PyCFunction)llvm_CmpInst__getPredicate, METH_VARARGS, NULL },
    { "FCMP_FALSE", (PyCFunction)llvm_CmpInst__Predicate__FCMP__FALSE, METH_VARARGS, NULL },
    { "FCMP_OEQ", (PyCFunction)llvm_CmpInst__Predicate__FCMP__OEQ, METH_VARARGS, NULL },
    { "FCMP_OGT", (PyCFunction)llvm_CmpInst__Predicate__FCMP__OGT, METH_VARARGS, NULL },
    { "FCMP_OGE", (PyCFunction)llvm_CmpInst__Predicate__FCMP__OGE, METH_VARARGS, NULL },
    { "FCMP_OLT", (PyCFunction)llvm_CmpInst__Predicate__FCMP__OLT, METH_VARARGS, NULL },
    { "FCMP_OLE", (PyCFunction)llvm_CmpInst__Predicate__FCMP__OLE, METH_VARARGS, NULL },
    { "FCMP_ONE", (PyCFunction)llvm_CmpInst__Predicate__FCMP__ONE, METH_VARARGS, NULL },
    { "FCMP_ORD", (PyCFunction)llvm_CmpInst__Predicate__FCMP__ORD, METH_VARARGS, NULL },
    { "FCMP_UNO", (PyCFunction)llvm_CmpInst__Predicate__FCMP__UNO, METH_VARARGS, NULL },
    { "FCMP_UEQ", (PyCFunction)llvm_CmpInst__Predicate__FCMP__UEQ, METH_VARARGS, NULL },
    { "FCMP_UGT", (PyCFunction)llvm_CmpInst__Predicate__FCMP__UGT, METH_VARARGS, NULL },
    { "FCMP_UGE", (PyCFunction)llvm_CmpInst__Predicate__FCMP__UGE, METH_VARARGS, NULL },
    { "FCMP_ULT", (PyCFunction)llvm_CmpInst__Predicate__FCMP__ULT, METH_VARARGS, NULL },
    { "FCMP_ULE", (PyCFunction)llvm_CmpInst__Predicate__FCMP__ULE, METH_VARARGS, NULL },
    { "FCMP_UNE", (PyCFunction)llvm_CmpInst__Predicate__FCMP__UNE, METH_VARARGS, NULL },
    { "FCMP_TRUE", (PyCFunction)llvm_CmpInst__Predicate__FCMP__TRUE, METH_VARARGS, NULL },
    { "FIRST_FCMP_PREDICATE", (PyCFunction)llvm_CmpInst__Predicate__FIRST__FCMP__PREDICATE, METH_VARARGS, NULL },
    { "LAST_FCMP_PREDICATE", (PyCFunction)llvm_CmpInst__Predicate__LAST__FCMP__PREDICATE, METH_VARARGS, NULL },
    { "BAD_FCMP_PREDICATE", (PyCFunction)llvm_CmpInst__Predicate__BAD__FCMP__PREDICATE, METH_VARARGS, NULL },
    { "ICMP_EQ", (PyCFunction)llvm_CmpInst__Predicate__ICMP__EQ, METH_VARARGS, NULL },
    { "ICMP_NE", (PyCFunction)llvm_CmpInst__Predicate__ICMP__NE, METH_VARARGS, NULL },
    { "ICMP_UGT", (PyCFunction)llvm_CmpInst__Predicate__ICMP__UGT, METH_VARARGS, NULL },
    { "ICMP_UGE", (PyCFunction)llvm_CmpInst__Predicate__ICMP__UGE, METH_VARARGS, NULL },
    { "ICMP_ULT", (PyCFunction)llvm_CmpInst__Predicate__ICMP__ULT, METH_VARARGS, NULL },
    { "ICMP_ULE", (PyCFunction)llvm_CmpInst__Predicate__ICMP__ULE, METH_VARARGS, NULL },
    { "ICMP_SGT", (PyCFunction)llvm_CmpInst__Predicate__ICMP__SGT, METH_VARARGS, NULL },
    { "ICMP_SGE", (PyCFunction)llvm_CmpInst__Predicate__ICMP__SGE, METH_VARARGS, NULL },
    { "ICMP_SLT", (PyCFunction)llvm_CmpInst__Predicate__ICMP__SLT, METH_VARARGS, NULL },
    { "ICMP_SLE", (PyCFunction)llvm_CmpInst__Predicate__ICMP__SLE, METH_VARARGS, NULL },
    { "FIRST_ICMP_PREDICATE", (PyCFunction)llvm_CmpInst__Predicate__FIRST__ICMP__PREDICATE, METH_VARARGS, NULL },
    { "LAST_ICMP_PREDICATE", (PyCFunction)llvm_CmpInst__Predicate__LAST__ICMP__PREDICATE, METH_VARARGS, NULL },
    { "BAD_ICMP_PREDICATE", (PyCFunction)llvm_CmpInst__Predicate__BAD__ICMP__PREDICATE, METH_VARARGS, NULL },
    { NULL },
};

static
SubModuleEntry submodule_llvm_CmpInst[] = {
    { NULL }
};

static
PyMethodDef meth_llvm_ExtractElementInst[] = {
    { NULL },
};

static
SubModuleEntry submodule_llvm_ExtractElementInst[] = {
    { NULL }
};

static
PyMethodDef meth_llvm_FenceInst[] = {
    { NULL },
};

static
SubModuleEntry submodule_llvm_FenceInst[] = {
    { NULL }
};

static
PyMethodDef meth_llvm_GetElementPtrInst[] = {
    { NULL },
};

static
SubModuleEntry submodule_llvm_GetElementPtrInst[] = {
    { NULL }
};

static
PyMethodDef meth_llvm_InsertElementInst[] = {
    { NULL },
};

static
SubModuleEntry submodule_llvm_InsertElementInst[] = {
    { NULL }
};

static
PyMethodDef meth_llvm_InsertValueInst[] = {
    { NULL },
};

static
SubModuleEntry submodule_llvm_InsertValueInst[] = {
    { NULL }
};

static
PyMethodDef meth_llvm_LandingPadInst[] = {
    { NULL },
};

static
SubModuleEntry submodule_llvm_LandingPadInst[] = {
    { NULL }
};

static
PyObject*
llvm_PHINode__addIncoming(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    PyObject* var_PyObject2;
    if(!PyArg_ParseTuple(args, "OOO", &var_PyObject, &var_PyObject1, &var_PyObject2))
    {
        return NULL;
    }
    llvm::PHINode* var_llvm_PHINode = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::PHINode* var_llvm_PHINode1 = unwrap_as<llvm::PHINode, llvm::Value >::from(var_void);
        if(!var_llvm_PHINode1)
        {
            return NULL;
        }
        var_llvm_PHINode = var_llvm_PHINode1;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject1 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Value");
        if(!var_void1)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void1);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    llvm::BasicBlock* var_llvm_BasicBlock = NULL;
    if (var_PyObject2 != Py_None)
    {
        void* var_void2 = PyCapsule_GetPointer(var_PyObject2, "llvm::Value");
        if(!var_void2)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::BasicBlock* var_llvm_BasicBlock1 = unwrap_as<llvm::BasicBlock, llvm::Value >::from(var_void2);
        if(!var_llvm_BasicBlock1)
        {
            return NULL;
        }
        var_llvm_BasicBlock = var_llvm_BasicBlock1;
    }
    var_llvm_PHINode->addIncoming(var_llvm_Value, var_llvm_BasicBlock);
    Py_RETURN_NONE;
}

static
PyObject*
llvm_PHINode__setIncomingBlock(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    PyObject* var_PyObject2;
    if(!PyArg_ParseTuple(args, "OOO", &var_PyObject, &var_PyObject1, &var_PyObject2))
    {
        return NULL;
    }
    llvm::PHINode* var_llvm_PHINode = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::PHINode* var_llvm_PHINode1 = unwrap_as<llvm::PHINode, llvm::Value >::from(var_void);
        if(!var_llvm_PHINode1)
        {
            return NULL;
        }
        var_llvm_PHINode = var_llvm_PHINode1;
    }
    unsigned var_unsigned;
    int var_int = py_int_to(var_PyObject1, var_unsigned);
    if(!var_int)
    {
        return NULL;
    }
    llvm::BasicBlock* var_llvm_BasicBlock = NULL;
    if (var_PyObject2 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject2, "llvm::Value");
        if(!var_void1)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::BasicBlock* var_llvm_BasicBlock1 = unwrap_as<llvm::BasicBlock, llvm::Value >::from(var_void1);
        if(!var_llvm_BasicBlock1)
        {
            return NULL;
        }
        var_llvm_BasicBlock = var_llvm_BasicBlock1;
    }
    var_llvm_PHINode->setIncomingBlock(var_unsigned, var_llvm_BasicBlock);
    Py_RETURN_NONE;
}

static
PyObject*
llvm_PHINode__getNumIncomingValues(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::PHINode* var_llvm_PHINode = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::PHINode* var_llvm_PHINode1 = unwrap_as<llvm::PHINode, llvm::Value >::from(var_void);
        if(!var_llvm_PHINode1)
        {
            return NULL;
        }
        var_llvm_PHINode = var_llvm_PHINode1;
    }
    unsigned var_unsigned = var_llvm_PHINode->getNumIncomingValues();
    PyObject* var_PyObject1 = py_int_from_unsigned(var_unsigned);
    return var_PyObject1;
}

static
PyObject*
llvm_PHINode__hasConstantValue(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::PHINode* var_llvm_PHINode = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::PHINode* var_llvm_PHINode1 = unwrap_as<llvm::PHINode, llvm::Value >::from(var_void);
        if(!var_llvm_PHINode1)
        {
            return NULL;
        }
        var_llvm_PHINode = var_llvm_PHINode1;
    }
    llvm::Value* var_llvm_Value = var_llvm_PHINode->hasConstantValue();
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Value), "llvm::Value", "llvm::Value");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyObject*
llvm_PHINode__getBasicBlockIndex(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::PHINode* var_llvm_PHINode = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::PHINode* var_llvm_PHINode1 = unwrap_as<llvm::PHINode, llvm::Value >::from(var_void);
        if(!var_llvm_PHINode1)
        {
            return NULL;
        }
        var_llvm_PHINode = var_llvm_PHINode1;
    }
    llvm::BasicBlock* var_llvm_BasicBlock = NULL;
    if (var_PyObject1 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject1, "llvm::Value");
        if(!var_void1)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::BasicBlock* var_llvm_BasicBlock1 = unwrap_as<llvm::BasicBlock, llvm::Value >::from(var_void1);
        if(!var_llvm_BasicBlock1)
        {
            return NULL;
        }
        var_llvm_BasicBlock = var_llvm_BasicBlock1;
    }
    int var_int = var_llvm_PHINode->getBasicBlockIndex(var_llvm_BasicBlock);
    PyObject* var_PyObject2 = py_int_from_signed(var_int);
    return var_PyObject2;
}

static
PyObject*
llvm_PHINode__getIncomingValue(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::PHINode* var_llvm_PHINode = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::PHINode* var_llvm_PHINode1 = unwrap_as<llvm::PHINode, llvm::Value >::from(var_void);
        if(!var_llvm_PHINode1)
        {
            return NULL;
        }
        var_llvm_PHINode = var_llvm_PHINode1;
    }
    unsigned var_unsigned;
    int var_int = py_int_to(var_PyObject1, var_unsigned);
    if(!var_int)
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = var_llvm_PHINode->getIncomingValue(var_unsigned);
    PyObject* var_PyObject2 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Value), "llvm::Value", "llvm::Value");
    if (!var_PyObject2)
    {
        return NULL;
    }
    return var_PyObject2;
}

static
PyObject*
llvm_PHINode__getIncomingBlock(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::PHINode* var_llvm_PHINode = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::PHINode* var_llvm_PHINode1 = unwrap_as<llvm::PHINode, llvm::Value >::from(var_void);
        if(!var_llvm_PHINode1)
        {
            return NULL;
        }
        var_llvm_PHINode = var_llvm_PHINode1;
    }
    unsigned var_unsigned;
    int var_int = py_int_to(var_PyObject1, var_unsigned);
    if(!var_int)
    {
        return NULL;
    }
    llvm::BasicBlock* var_llvm_BasicBlock = var_llvm_PHINode->getIncomingBlock(var_unsigned);
    PyObject* var_PyObject2 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_BasicBlock), "llvm::Value", "llvm::BasicBlock");
    if (!var_PyObject2)
    {
        return NULL;
    }
    return var_PyObject2;
}

static
PyObject*
llvm_PHINode__setIncomingValue(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    PyObject* var_PyObject2;
    if(!PyArg_ParseTuple(args, "OOO", &var_PyObject, &var_PyObject1, &var_PyObject2))
    {
        return NULL;
    }
    llvm::PHINode* var_llvm_PHINode = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::PHINode* var_llvm_PHINode1 = unwrap_as<llvm::PHINode, llvm::Value >::from(var_void);
        if(!var_llvm_PHINode1)
        {
            return NULL;
        }
        var_llvm_PHINode = var_llvm_PHINode1;
    }
    unsigned var_unsigned;
    int var_int = py_int_to(var_PyObject1, var_unsigned);
    if(!var_int)
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject2 != Py_None)
    {
        void* var_void1 = PyCapsule_GetPointer(var_PyObject2, "llvm::Value");
        if(!var_void1)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void1);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    var_llvm_PHINode->setIncomingValue(var_unsigned, var_llvm_Value);
    Py_RETURN_NONE;
}

static
PyMethodDef meth_llvm_PHINode[] = {
    { "addIncoming", (PyCFunction)llvm_PHINode__addIncoming, METH_VARARGS, NULL },
    { "setIncomingBlock", (PyCFunction)llvm_PHINode__setIncomingBlock, METH_VARARGS, NULL },
    { "getNumIncomingValues", (PyCFunction)llvm_PHINode__getNumIncomingValues, METH_VARARGS, NULL },
    { "hasConstantValue", (PyCFunction)llvm_PHINode__hasConstantValue, METH_VARARGS, NULL },
    { "getBasicBlockIndex", (PyCFunction)llvm_PHINode__getBasicBlockIndex, METH_VARARGS, NULL },
    { "getIncomingValue", (PyCFunction)llvm_PHINode__getIncomingValue, METH_VARARGS, NULL },
    { "getIncomingBlock", (PyCFunction)llvm_PHINode__getIncomingBlock, METH_VARARGS, NULL },
    { "setIncomingValue", (PyCFunction)llvm_PHINode__setIncomingValue, METH_VARARGS, NULL },
    { NULL },
};

static
SubModuleEntry submodule_llvm_PHINode[] = {
    { NULL }
};

static
PyMethodDef meth_llvm_SelectInst[] = {
    { NULL },
};

static
SubModuleEntry submodule_llvm_SelectInst[] = {
    { NULL }
};

static
PyMethodDef meth_llvm_ShuffleVectorInst[] = {
    { NULL },
};

static
SubModuleEntry submodule_llvm_ShuffleVectorInst[] = {
    { NULL }
};

static
PyObject*
llvm_StoreInst__isVolatile(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::StoreInst* var_llvm_StoreInst = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::StoreInst* var_llvm_StoreInst1 = unwrap_as<llvm::StoreInst, llvm::Value >::from(var_void);
        if(!var_llvm_StoreInst1)
        {
            return NULL;
        }
        var_llvm_StoreInst = var_llvm_StoreInst1;
    }
    bool var_bool = var_llvm_StoreInst->isVolatile();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_StoreInst__classof(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::Value* var_llvm_Value = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::Value* var_llvm_Value1 = unwrap_as<llvm::Value, llvm::Value >::from(var_void);
        if(!var_llvm_Value1)
        {
            return NULL;
        }
        var_llvm_Value = var_llvm_Value1;
    }
    bool var_bool = llvm::StoreInst::classof(var_llvm_Value);
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_StoreInst__getPointerAddressSpace(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::StoreInst* var_llvm_StoreInst = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::StoreInst* var_llvm_StoreInst1 = unwrap_as<llvm::StoreInst, llvm::Value >::from(var_void);
        if(!var_llvm_StoreInst1)
        {
            return NULL;
        }
        var_llvm_StoreInst = var_llvm_StoreInst1;
    }
    unsigned var_unsigned = var_llvm_StoreInst->getPointerAddressSpace();
    PyObject* var_PyObject1 = py_int_from_unsigned(var_unsigned);
    return var_PyObject1;
}

static
PyObject*
llvm_StoreInst__getValueOperand(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::StoreInst* var_llvm_StoreInst = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::StoreInst* var_llvm_StoreInst1 = unwrap_as<llvm::StoreInst, llvm::Value >::from(var_void);
        if(!var_llvm_StoreInst1)
        {
            return NULL;
        }
        var_llvm_StoreInst = var_llvm_StoreInst1;
    }
    llvm::Value* var_llvm_Value = var_llvm_StoreInst->getValueOperand();
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Value), "llvm::Value", "llvm::Value");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyObject*
llvm_StoreInst__setAtomic(PyObject* self, PyObject* args)
{
    Py_ssize_t var_Py__ssize__t = PyTuple_Size(args);
    if (3 == var_Py__ssize__t)
    {
        PyObject* var_PyObject;
        PyObject* var_PyObject1;
        PyObject* var_PyObject2;
        if(!PyArg_ParseTuple(args, "OOO", &var_PyObject, &var_PyObject1, &var_PyObject2))
        {
            return NULL;
        }
        llvm::StoreInst* var_llvm_StoreInst = NULL;
        if (var_PyObject != Py_None)
        {
            void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
            if(!var_void)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::StoreInst* var_llvm_StoreInst1 = unwrap_as<llvm::StoreInst, llvm::Value >::from(var_void);
            if(!var_llvm_StoreInst1)
            {
                return NULL;
            }
            var_llvm_StoreInst = var_llvm_StoreInst1;
        }
        llvm::AtomicOrdering var_llvm_AtomicOrdering = (llvm::AtomicOrdering)PyInt_AsLong(var_PyObject1);
        llvm::SynchronizationScope var_llvm_SynchronizationScope = (llvm::SynchronizationScope)PyInt_AsLong(var_PyObject2);
        var_llvm_StoreInst->setAtomic(var_llvm_AtomicOrdering, var_llvm_SynchronizationScope);
        Py_RETURN_NONE;
    }
    if (2 == var_Py__ssize__t)
    {
        PyObject* var_PyObject3;
        PyObject* var_PyObject4;
        if(!PyArg_ParseTuple(args, "OO", &var_PyObject3, &var_PyObject4))
        {
            return NULL;
        }
        llvm::StoreInst* var_llvm_StoreInst2 = NULL;
        if (var_PyObject3 != Py_None)
        {
            void* var_void1 = PyCapsule_GetPointer(var_PyObject3, "llvm::Value");
            if(!var_void1)
            {
                puts("Error: llvm::Value");
                return NULL;
            }
            llvm::StoreInst* var_llvm_StoreInst3 = unwrap_as<llvm::StoreInst, llvm::Value >::from(var_void1);
            if(!var_llvm_StoreInst3)
            {
                return NULL;
            }
            var_llvm_StoreInst2 = var_llvm_StoreInst3;
        }
        llvm::AtomicOrdering var_llvm_AtomicOrdering1 = (llvm::AtomicOrdering)PyInt_AsLong(var_PyObject4);
        var_llvm_StoreInst2->setAtomic(var_llvm_AtomicOrdering1);
        Py_RETURN_NONE;
    }
    PyErr_SetString(PyExc_TypeError, "Invalid number of args");
    return NULL;
}

static
PyObject*
llvm_StoreInst__isUnordered(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::StoreInst* var_llvm_StoreInst = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::StoreInst* var_llvm_StoreInst1 = unwrap_as<llvm::StoreInst, llvm::Value >::from(var_void);
        if(!var_llvm_StoreInst1)
        {
            return NULL;
        }
        var_llvm_StoreInst = var_llvm_StoreInst1;
    }
    bool var_bool = var_llvm_StoreInst->isUnordered();
    PyObject* var_PyObject1 = py_bool_from(var_bool);
    return var_PyObject1;
}

static
PyObject*
llvm_StoreInst__getPointerOperand(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::StoreInst* var_llvm_StoreInst = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::StoreInst* var_llvm_StoreInst1 = unwrap_as<llvm::StoreInst, llvm::Value >::from(var_void);
        if(!var_llvm_StoreInst1)
        {
            return NULL;
        }
        var_llvm_StoreInst = var_llvm_StoreInst1;
    }
    llvm::Value* var_llvm_Value = var_llvm_StoreInst->getPointerOperand();
    PyObject* var_PyObject1 = pycapsule_new(cast_to_base<llvm::Value >::from(var_llvm_Value), "llvm::Value", "llvm::Value");
    if (!var_PyObject1)
    {
        return NULL;
    }
    return var_PyObject1;
}

static
PyObject*
llvm_StoreInst__setAlignment(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    PyObject* var_PyObject1;
    if(!PyArg_ParseTuple(args, "OO", &var_PyObject, &var_PyObject1))
    {
        return NULL;
    }
    llvm::StoreInst* var_llvm_StoreInst = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "llvm::Value");
        if(!var_void)
        {
            puts("Error: llvm::Value");
            return NULL;
        }
        llvm::StoreInst* var_llvm_StoreInst1 = unwrap_as<llvm::StoreInst, llvm::Value >::from(var_void);
        if(!var_llvm_StoreInst1)
        {
            return NULL;
        }
        var_llvm_StoreInst = var_llvm_StoreInst1;
    }
    unsigned var_unsigned;
    int var_int = py_int_to(var_PyObject1, var_unsigned);
    if(!var_int)
    {
        return NULL;
    }
    var_llvm_StoreInst->setAlignment(var_unsigned);
    Py_RETURN_NONE;
}

static
PyObject*
llvm_StoreInst__getAlignment(PyObject* self, PyObject* args)
{
    PyObject* var_PyObject;
    if(!PyArg_ParseTuple(args, "O", &var_PyObject))
    {
        return NULL;
    }
    llvm::StoreInst* var_llvm_StoreInst = NULL;
    if (var_PyObject != Py_None)
    {
        void* var_void = PyCapsule_GetPointer(var_PyObject, "ll