# py-plot

A command-line tool for creating plots from data in text files.

## Installation

With `pip`:

    pip install lmj.plot

Or, clone this repository and put the plot script somewhere in your `PATH`:

    git clone http://github.com/lmjohns3/py-grep-plot
    export PATH=$PATH:$(pwd)/py-grep-plot/scripts

## Usage

Let's say you're running an experimental algorithm, and you put accuracy values
in a log file as the experiments run. Here's a snippet from an example log file:

    D 2012-03-19 15:02:35,181 decoded p-a-n-c-r-e-a-t-i-c in 4058ms
    D 2012-03-19 15:02:35,365 tags p-ae2-n-k-r-iy0-ae1-t-ih0-k, best p-ae1-n-k-er0-_-eh1-th-iy0-_
    D 2012-03-19 15:02:35,591 averaged 22932 weights in 786ms
    D 2012-03-19 15:02:35,802 decoded g-y-r in 998ms
    D 2012-03-19 15:02:36,054 tags jh-ay1-r, best g-_-er0
    I 2012-03-19 15:02:36,055 training accuracy: 39.63
    D 2012-03-19 15:02:36,246 averaged 23056 weights in 643ms
    D 2012-03-19 15:02:36,295 decoded s-p-i-t-z-l-e-y in 4090ms
    D 2012-03-19 15:02:36,540 tags s-p-ih1-t-s-l-_-iy0, best s-p-ey1-t-ah0-l-_-iy0

All of those "training accuracy" lines hidden in there will give us a good idea
of how well the algorithm is performing. To get a quick plot of them:

    cat ~/Experiments/tagger-beam1.log | py-grep-plot -r 'training accuracy: ([.\d]+)'

If you have your matplotlib configured with an interactive backend, you should
see a nice little plot appear.

The general usage of the script is

    py-grep-plot [--regex RE] < FILE

Basically, you provide a bunch of data on stdin, and, optionally, a regular
expression that specifies how to extract data from the files. The plotting
script will check the regular expression against each input line, parsing out
numerical values from those that match. Each matched value will be included in
the plot.

### Multiple values

If you just provide one match group in your regular expression, the matched
values will be plotted on the ordinate, in data-file order. If you want explicit
control over the abscissa, just include another match group in your regular
expression:

    nl ~/Experiments/tagger-beam1.log | py-grep-plot -r '^(\d+) .* training accuracy: ([.\d]+)'

(The `nl` utility numbers the lines of the input file.)

If you provide three match groups per line, the first is plotted along the
abscissa, the second along the ordinate, and the third gives the size of an
error bar along the ordinate.

### Multiple series

You can also provide multiple input files, and the script will show multiple
data series on the same plot:

    py-grep-plot [--regex RE] FILE...

Each file will use the same regular expression for matching data.

#### Multiple series from one file

If you're working with a shell like bash, you can do some rad stuff to get
multiple series out of one file. For instance, let's say you have one log file
that contains `training accuracy: XX` and `evaluation accuracy: XX` lines that
you'd like to plot. You can use the nifty subshell redirection operator to sort
these two data sources:

    py-grep-plot -r 'accuracy: (\d+)' <(grep 'training acc' file) <(grep 'evaluation acc' file)

### Smoothing

You can smooth the ordinates by using either the `-s N` (`--smooth N`) or the
`-b N` (`--batch N`) options. The `--smooth` option convolves a rectangular
filter over the data values before plotting, which yields smoother curves but
has edge effects. The `--batch` option groups the input data and plots just the
mean and standard deviation of each group.

### Other options

There are several other command-line options, including some basic controls for
the plot colors and styles, X- and Y-axis limits, ; use `--help` to get an
overview.

## License

(The MIT License)

Copyright (c) 2011-2012 Leif Johnson <leif@leifjohnson.net>

Permission is hereby granted, free of charge, to any person obtaining a copy of
this software and associated documentation files (the 'Software'), to deal in
the Software without restriction, including without limitation the rights to
use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
the Software, and to permit persons to whom the Software is furnished to do so,
subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED 'AS IS', WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
