import os
import setuptools

setuptools.setup(
    name='lmj.plot',
    version='0.2.2',
    install_requires=['numpy', 'matplotlib'],
    scripts=['scripts/py-grep-plot'],
    author='Leif Johnson',
    author_email='leif@leifjohnson.net',
    description='A command line tool for plotting data from text files',
    long_description=open(os.path.join(os.path.dirname(os.path.abspath(__file__)), 'README.md')).read(),
    license='MIT',
    url='http://github.com/lmjohns3/py-grep-plot',
    keywords=('plots '
              'visualization '
              'matplotlib '
              'error-bars '
              ),
    classifiers=[
        'Development Status :: 4 - Beta',
        'Intended Audience :: Science/Research',
        'License :: OSI Approved :: MIT License',
        'Operating System :: OS Independent',
        ],
    )
