# Copyright (c) 2011 Leif Johnson <leif@leifjohnson.net>
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

'''An implementation of multilayer Restricted Boltzmann Machines.'''


class Stack(list):
    '''A stack represents a single vertical stack of RBMs, a "deep" network.
    '''

    def __init__(self, *rbms):
        '''Set up a stack of multiple RBMs.'''
        self.extend(rbms)

        # check that the rbm units will match up.
        prev = rbms[0]
        for rbm in rbms[1:]:
            assert rbm.num_visible == prev.num_hidden

    def iter_passes(self, visible):
        '''
        '''
        while True:
            visibles = [visible]
            for rbm in self:
                visibles.append(bernoulli(rbm.hidden_expectation(visibles[-1])))
            yield visibles

    class Trainer:
        '''
        '''

        def __init__(self, stack, momentum, target_sparsity):
            '''
            '''
            self.trainers = [rbm.Trainer(rbm, momentum, target_sparsity) for rbm in stack]

        def learn(self, visible, l2_reg=0, alpha=0.2):
            '''
            '''
            for i, trainer in enumerate(self.trainers):
                # pass the visible data up through the lower layers.
                for rbm in self[:i]:
                    visible = rbm.hidden_expectation(visible)
                # then learn this "visible" signal for the active layer.
                trainer.learn(visible, l2_reg, alpha)
