#!/usr/bin/env python 


import sys
from jsonschema import validate
import json
from load import run


def loadmodel(scenario_file):
    # to work on the schema use: http://www.jsonschema.net/
    schema = json.loads(open('./load/loadmodel_schema.json').read())

    scenario = json.loads(open(scenario_file).read())
    validate(scenario, schema)
    return scenario
    

if __name__ == '__main__':
    run(loadmodel(sys.argv[1]))
