#!/usr/bin/env python 


import sys
import os
from jsonschema import validate
import json
from load import run

here = lambda x: os.path.abspath(os.path.join(os.path.dirname(__file__), x))

def loadmodel(scenario_file):
    # to work on the schema use: http://www.jsonschema.net/
    schema = json.loads(open(here('./loadmodel_schema.json')).read())

    scenario = json.loads(open(scenario_file).read())
    validate(scenario, schema)
    return scenario
    

if __name__ == '__main__':
    run(loadmodel(sys.argv[1]))
