#!/usr/bin/env python

import os
import sys

import log_metrics

try:
    from setuptools import setup
except ImportError:
    from distutils.core import setup

if sys.argv[-1] == 'publish':
    os.system('python setup.py sdist upload')
    sys.exit()

packages = [
    'log_metrics',
]

requires = []


with open('README.rst') as f:
    readme = f.read()
with open('HISTORY.rst') as f:
    history = f.read()


setup(
    name='log-metrics',
    version=log_metrics.__version__,
    description='Python Metric Logger.',
    long_description=readme + '\n\n' + history,
    author=log_metrics.__author__,
    author_email=log_metrics.__email__,
    url='https://github.com/rhyselsmore/log-metrics',
    packages=packages,
    package_data={'': ['LICENSE']},
    package_dir={'log_metrics': 'log_metrics'},
    include_package_data=True,
    install_requires=requires,
    license='Apache 2.0',
    zip_safe=False,
    classifiers=(
        'Development Status :: 5 - Production/Stable',
        'Intended Audience :: Developers',
        'Natural Language :: English',
        'License :: OSI Approved :: Apache Software License',
        'Programming Language :: Python',
        'Programming Language :: Python :: 2.6',
        'Programming Language :: Python :: 2.7',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.3',

    ),
)
