#!/usr/bin/env python
# Copyright (c) 2008 LOGILAB S.A. (Paris, FRANCE).
# http://www.logilab.fr/ -- mailto:contact@logilab.fr
#
# This program is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free Software
# Foundation; either version 2 of the License, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# this program; if not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

"""
VM Function to save an existing VM
"""

from optparse import OptionParser
from os import system, makedirs, listdir
from datetime import datetime
import os.path as osp
import ConfigParser
from logilabvm.lib import _CONFIGFILE, _execute, _gethooks, HookCall, VMError, show

def run(sysargs, usage=None):
    """
    Function that returns the result of the 'save' command
    """
    parser = OptionParser(usage=usage,
        epilog="Warning: this functionality stops the VM")
    parser.add_option("-p", "--path", action="store", 
        dest="path", help="Path to save the VM")
    parser.add_option("-f", "--filename", action="store", 
        dest="filename", help="Name of the saving file")

    (options, _) = parser.parse_args(sysargs)

    # check arguments
    if len(sysargs) < 1:
        raise AttributeError, usage
    allvm = show.run(["--active", ])
    names = [ el['name'] for el in allvm ]
    if not sysargs[0] in names:
        raise VMError("%s not an active VM" % sysargs[0])
    vm = allvm[names.index(sysargs[0])]

    config = ConfigParser.ConfigParser()
    config.read(_CONFIGFILE)

    open(_CONFIGFILE)

    # options
    if options.path:
        dir = osp.join(options.path, vm['hyper'], vm['name'])
    else:
        dir = osp.join(config.get('MAIN','archivesdir'), vm['hyper'], vm['name'])
    if options.filename:
        file = osp.join(dir, options.filename)
    else:
        # autogenerated filename NAME_YearMonthDayHourMinutesSeconds
        now = datetime.today()
        file = osp.join(dir, "%s_%s" % (vm['name'], now.strftime("%Y%m%d%H%M%S")))

    try:
        listdir(dir)
    except OSError:
        makedirs(dir)

    # retrieve hooks
    hooks = _gethooks("SAVE")
    if hooks[vm['hyper']]:
        hookres = _execute("%s %s" % (hooks[vm['hyper']], ' '.join(sysargs)))
        raise HookCall(hookres)

    if vm['hyper'] == "qemu":
        cmdres = _execute("virsh -c %s:///system save %s %s" % (vm['hyper'], vm['name'], file))
        vm.update(cmdres)
    else:
        raise NotImplementedError

    return vm
