import networkx as nx
import itertools
import heapq
import logging
from ..algorithms.product import ts_times_ts
from optimal_run import optimal_run

# Logger configuration
logger = logging.getLogger(__name__)

def pretty_print(agent_cnt, prefix, suffix):
	import string
	# Pretty print the prefix and suffix_cycle on team_ts
	hdr_line_1 = ''
	hdr_line_2 = ''
	for i in range(0,agent_cnt):
		hdr_line_1 += string.ljust('Robot-%d' % (i+1), 20)
		hdr_line_2 += string.ljust('-------', 20)
	logger.info(hdr_line_1)
	logger.info(hdr_line_2)
	
	logger.info('*** Prefix: ***')
	for s in prefix:
		line = ''
		for ss in s:
			line += string.ljust('%s' % (ss,), 20)
		logger.info(line)
	
	logger.info('*** Suffix: ***')
	for s in suffix:
		line = ''
		for ss in s:
			line += string.ljust('%s' % (ss,), 20)
		logger.info(line)

def multi_agent_optimal_run(ts_tuple, formula, opt_prop):
	# Construct the team_ts
	team_ts = ts_times_ts(ts_tuple)
	# Find the optimal run and shortest prefix on team_ts
	prefix_length, prefix_on_team_ts, suffix_cycle_cost, suffix_cycle_on_team_ts = optimal_run(team_ts, formula, opt_prop)
	# Pretty print the run
	pretty_print(len(ts_tuple), prefix_on_team_ts, suffix_cycle_on_team_ts)
	# Project the run on team_ts down to individual agents
	prefixes = []
	suffix_cycles = []
	for i in range(0, len(ts_tuple)):
		ts = ts_tuple[i]
		prefixes.append(filter(lambda x: x != None, map(lambda x: x[i] if x[i] in ts.g.node else None, prefix_on_team_ts)))
		suffix_cycles.append(filter(lambda x: x!= None, map(lambda x: x[i] if x[i] in ts.g.node else None, suffix_cycle_on_team_ts)))

	return (prefix_length, prefixes, suffix_cycle_cost, suffix_cycles)
