'''
Created on 2010-04-16
@author: Peter Lindblom 
@contact: http://www.plweb.se
'''
from time import localtime, strftime
import re
import urllib2

class LoopiaDnsSync:
    """A simple loopia dns python module"""
    __username = ""
    __password = ""
    __domains = []
    def __init__(self, username, password, domains=[]):
        """Username, Password, optional list of domains"""
        self.__username = username
        self.__password =  password
        self.__domains = domains        
    
    def addDomain(self, domain):
        """Adds a domain to the list of domains and returns current LoopiaDnsSync instance"""
        self.__domains.append(domain);
        return self
        
    def __getIpAddress(self):
        """Gets your current ip-address"""
        
        outputStr = LoopiaDnsSync.MyHttpClient("","","https://dns.loopia.se/checkip/checkip.php").getResponse()
        return re.search('^.*: ([^<]*).*$', outputStr).group(1)
    
    def __syncADomain(self, username, password, currentIP, domain):
        """Syncs a domain at a time"""
        inputStr = "https://dns.loopia.se/XDynDNSServer/XDynDNS.php?hostname=" + domain + "&myip=" + currentIP
        
        return domain + ", " + currentIP + ", " + LoopiaDnsSync.MyHttpClient(username, password, inputStr).getResponse()

    def syncDomains(self):
        """Syncs all domains using __syncADomain"""
        print __name__+": " + strftime("%a, %d %b %Y %H:%M:%S", localtime()) 
        ipAdress = self.__getIpAddress()
        for domain in self.__domains:
            print self.__syncADomain(self.__username, self.__password, ipAdress, domain)

    class MyHttpClient:
        """Helper class for httpcommunication with inspiration from http://www.voidspace.org.uk/python/articles/authentication.shtml""" 
        __username = ""
        __password = ""
        __url = ""
        def __init__(self, username, password, url):
            self.__username = username
            self.__password = password
            self.__url = url
            
        def getResponse(self):

            passwordmgr = urllib2.HTTPPasswordMgrWithDefaultRealm()
            passwordmgr.add_password(None, self.__url, self.__username, self.__password)
            # because we have put None at the start it will always
            # use this username/password combination for  urls
            # for which `theurl` is a super-url
            
            authhandler = urllib2.HTTPBasicAuthHandler(passwordmgr)
            # create the AuthHandler
            
            opener = urllib2.build_opener(authhandler)
            
            urllib2.install_opener(opener)
            # All calls to urllib2.urlopen will now use our handler
            # Make sure not to include the protocol in with the URL, or
            # HTTPPasswordMgrWithDefaultRealm will be very confused.
            # You must (of course) use it when fetching the page though.
            #print self.__url
            pagehandle = urllib2.urlopen(self.__url)
            # authentication is now handled automatically for us 
            
            return pagehandle.read()