
#ifndef TABLE_FM_T_DETAIL_HPP
#define TABLE_FM_T_DETAIL_HPP


//  Table for Fm_T 
#include <math.h>

namespace PInt {

namespace Table_Fm_T {

const double PI=3.14159265358979323846264338327;
const int max_n_Fm_T=17;
const int num_div_Fm_T=7501;
const double dT_Fm_T=0.01;
const int N_value_F=max_n_Fm_T*num_div_Fm_T;

const double valueF[127517]={
     1.000000000000000,     0.333333333333333,     0.200000000000000,     0.142857142857143,     0.111111111111111,     0.090909090909091,     0.076923076923077,     0.066666666666667,     0.058823529411765,     0.052631578947368,
     0.047619047619048,     0.043478260869565,     0.040000000000000,     0.037037037037037,     0.034482758620690,     0.032258064516129,     0.030303030303030,     0.996676642903363,     0.331340457709773,     0.198576969007465,
     0.141750564407793,     0.110205855269221,     0.090143183691162,     0.076259342680756,     0.066081055033071,     0.058299587344931,     0.052157555732958,     0.047186258851853,     0.043080106987706,     0.039631348403819,
     0.036693817315433,     0.034161688376379,     0.031956458290686,     0.030018663105306,     0.993373143595466,     0.329361757217772,     0.197164958664006,     0.140653000331880,     0.109308225410183,     0.089383884622201,
     0.075601438436492,     0.065500659190949,     0.057780363937009,     0.051687840559825,     0.046757433247968,     0.042685622514209,     0.039266113001491,     0.036353793263244,     0.033843620020688,     0.031657682330038,
     0.029736973110956,     0.990089360874526,     0.327397122100291,     0.195763879206090,     0.139564374699014,     0.108418155743138,     0.088631135662233,     0.074949312267586,     0.064925432168454,     0.057265816305133,
     0.051222393979238,     0.046332534283585,     0.042294773446420,     0.038904261985947,     0.036016935002651,     0.033528525384408,     0.031361709988743,     0.029457935041918,     0.986825154631854,     0.325446443494140,
     0.194373641626206,     0.138484612233818,     0.107535581055042,     0.087884879288167,     0.074302912718921,     0.064355327420603,     0.056755901959106,     0.050761176906010,     0.045911525773342,     0.041907526098266,
     0.038545763847489,     0.035683212936200,     0.033216376563523,     0.031068514872938,     0.029181523859428,     0.983580385842959,     0.323509613422449,     0.192994157666346,     0.137413638310181,     0.106660436705514,
     0.087145058489144,     0.073662188798712,     0.063790298825366,     0.056250578797778,     0.050304150615128,     0.045494371867164,     0.041523847097296,     0.038190587371005,     0.035352597744162,     0.032907145916707,
     0.030778070837964,     0.028907714761751,     0.980354916558714,     0.321586524787211,     0.191625339811543,     0.136351378945551,     0.105792658621742,     0.086411616761924,     0.073027089974294,     0.063230300679794,
     0.055749805105462,     0.049851276738416,     0.045081037047146,     0.041143703381749,     0.037838701633203,     0.035025060381918,     0.032600806062847,     0.030490351986003,     0.028636483181932,     0.977148609896611,
     0.319677071361877,     0.190267101283458,     0.135297760795290,     0.104932183293426,     0.085684498106315,     0.072397566167955,     0.062675287696181,     0.055253539548384,     0.049402517261230,     0.044671486124458,
     0.040767062197649,     0.037490075999871,     0.034700572077369,     0.032297329878582,     0.030205332663740,     0.028367804785567,     0.973961330032080,     0.317781147784027,     0.188919356034033,     0.134252711147068,
     0.104078947767771,     0.084963647020644,     0.071773567752797,     0.062125214998268,     0.054761741171159,     0.048957834519181,     0.044265684236285,     0.040393891095928,     0.037144680123167,     0.034379104328369,
     0.031996690495870,     0.029922987460052,     0.028101655468595,     0.970792942189885,     0.315898649548095,     0.187582018739197,     0.133216157915320,     0.103232889644526,     0.084249008497271,     0.071155045548644,
     0.061580038117468,     0.054274369393312,     0.048517191194891,     0.043863596842788,     0.040024157929575,     0.036802483938931,     0.034060628900191,     0.031698861299583,     0.029643291203714,     0.027838011355117,
     0.967643312635592,     0.314029472998161,     0.186255004792621,     0.132188029635739,     0.102393947071065,     0.083540528018141,     0.070541950817984,     0.061039712989142,     0.053791384005819,     0.048080550314778,
     0.043465189724101,     0.039657830850816,     0.036463457664022,     0.033745117822999,     0.031403815925110,     0.029366218961129,     0.027576848795228,     0.964512308667106,     0.312173515320809,     0.184938230299538,
     0.131168255459826,     0.101562058737512,     0.082838151550378,     0.069934235261945,     0.060504195948895,     0.053312745167684,     0.047647875245871,     0.043070428977350,     0.039294878308310,     0.036127571793688,
     0.033432543389365,     0.031111528256001,     0.029091746034076,     0.027318144362872,     0.961399798606286,     0.310330674538034,     0.183631612070607,     0.130156765149488,     0.100737163871913,     0.082141825541916,
     0.069331851016315,     0.059973443728918,     0.052838413402553,     0.047219129692655,     0.042679281013705,     0.038935269044387,     0.035794797098943,     0.033122878151791,     0.030821972421619,     0.028819847957485,
     0.027061874853719,     0.958305651790620,     0.308500849500227,     0.182335067615840,     0.129153489071683,     0.099919202235447,     0.081451496917176,     0.068734750647592,     0.059447413454357,     0.052368349595352,
     0.046794277693946,     0.042291712555455,     0.038578972092296,     0.035465104623993,     0.032816094920267,     0.030535122794822,     0.028550500497231,     0.026808017283066,     0.955229738564983,     0.306683939879202,
     0.181048515138575,     0.128158358193108,     0.099108114117687,     0.080767113072777,     0.068142887149071,     0.058926062639714,     0.051902514988962,     0.046373283619794,     0.041907690633113,     0.038225956773488,
     0.035138465683663,     0.032512166759849,     0.030250953989663,     0.028283679647944,     0.026556548883744,     0.952171930273449,     0.304879846161303,     0.179771873529508,     0.127171304074947,     0.098303840331894,
     0.080088621873286,     0.067556213936973,     0.058409349185289,     0.051440871180917,     0.045956112168412,     0.041527182582549,     0.037876192694927,     0.034814851860861,     0.032211066988252,     0.029969440859114,
     0.028019361630848,     0.026307447104062,     0.949132099251188,     0.303088469640553,     0.178505062360772,     0.126192258867647,     0.097506322210362,     0.079415971647011,     0.066974684846598,     0.057897231373644,
     0.050983380120142,     0.045542728363142,     0.041150156042146,     0.037529649746414,     0.034494235004069,     0.031912769173478,     0.029690558492811,     0.027757522891615,     0.026060689605760,     0.946110118816419,
     0.301309712411869,     0.177248001880068,     0.125221155305759,     0.096715501599800,     0.078749111181826,     0.066398254128528,     0.057389667866110,     0.050530004103717,     0.045133097549441,     0.040776578949985,
     0.037186298097949,     0.034176587224843,     0.031617247131460,     0.029414282214820,     0.027498140098241,     0.025816254261985,     0.943105863262435,     0.299543477364340,     0.176000613004857,     0.124257926702815,
     0.095931320856761,     0.078087989721038,     0.065826876444848,     0.056886617699319,     0.050080705773668,     0.044727185391898,     0.040406419541059,     0.036846108197113,     0.033861880895353,     0.031324474923725,
     0.029140587581424,     0.027241190138941,     0.025574119155283,     0.940119207849693,     0.297789668174555,     0.174762817316587,     0.123302506946249,     0.095153722843099,     0.077432556959293,     0.065260506865418,
     0.056388040281774,     0.049635448113791,     0.044324957871278,     0.040039646344506,     0.036509050766470,     0.033550088645932,     0.031034426855087,     0.028869450378931,     0.026986650120068,     0.025334262575617,
     0.937150028797979,     0.296048189299992,     0.173534537054986,     0.122354830492368,     0.094382650921487,     0.076782763038513,     0.064699100864166,     0.055893895390439,     0.049194194446507,     0.043926381281596,
     0.039676228180875,     0.036175096801002,     0.033241183362661,     0.030747077471355,     0.028600846621503,     0.026734497364043,     0.025096663018395,     0.934198203278622,     0.294318945972464,     0.172315695112393,
     0.121414832361370,     0.093618048950957,     0.076138558543879,     0.064142614315422,     0.055404143167379,     0.048756908429742,     0.043531422227218,     0.039316134159415,     0.035844217565560,     0.032935138184966,
     0.030462401557066,     0.028334752549009,     0.026484709407318,     0.024861299182523,     0.931263609406792,     0.292601844191621,     0.171106215028147,     0.120482448132396,     0.092859861282490,     0.075499894499837,
     0.063591003490285,     0.054918744116411,     0.048323554053839,     0.043140047619981,     0.038959333675386,     0.035516384592344,     0.032631926503244,     0.030180374133238,     0.028071144624888,     0.026237263998342,
     0.024628149968476,     0.928346126233848,     0.290896790718508,     0.169906020983022,     0.119557613938638,     0.092108032754641,     0.074866722366157,     0.063044225053019,     0.054437659099803,     0.047894095638497,
     0.042752224676355,     0.038605796407400,     0.035191569678406,     0.032331521956508,     0.029900970455148,     0.027809999534045,     0.025992139095564,     0.024397194476384,     0.925445633739759,     0.289203693069178,
     0.168715037793709,     0.118640266462482,     0.091362508689209,     0.074238994034013,     0.062502236057488,     0.053960849334989,     0.047468497829739,     0.042367920914613,     0.038255492314785,     0.034869744883173,
     0.032033898430057,     0.029624166010123,     0.027551294180757,     0.025749312865437,     0.024168412004139,     0.922562012825585,     0.287522459508360,     0.167533190907351,     0.117730342930696,     0.090623234886940,
     0.073616661822110,     0.061964993943621,     0.053488276391324,     0.047046725596908,     0.041987104152047,     0.037908391634972,     0.034550882525999,     0.031739030053163,     0.029349936515360,     0.027295005686608,
     0.025508763680457,     0.023941782045520,     0.919695145306021,     0.285852999043183,     0.166360406396119,     0.116827781109667,     0.089890157623271,     0.072999678472836,     0.061432456533903,     0.053019902186867,
     0.046628744229689,     0.041609742502192,     0.037564464880910,     0.034234955183735,     0.031446891196790,     0.029078257915761,     0.027041111388432,     0.025270470117210,     0.023717284288332,     0.916844913902006,
     0.284195221416949,     0.165196610951843,     0.115932519300668,     0.089163223644113,     0.072387997148455,     0.060904582029912,     0.052555688985189,     0.046214519335164,     0.041235804372087,     0.037223682838502,
     0.033921935688320,     0.031157456471321,     0.028809106381794,     0.026789588836285,     0.025034410954440,     0.023494898612570,     0.914011202233388,     0.282549037102970,     0.164041731880685,     0.115044496335180,
     0.088442380161670,     0.071781571427336,     0.060381329008874,     0.052095599392217,     0.045804016834887,     0.040865258459558,     0.036886016564066,     0.033611797124406,     0.030870700724314,     0.028542458307368,
     0.026540415791433,     0.024800565171140,     0.023274605088593,     0.911193894811661,     0.280914357298442,     0.162895697097862,     0.114163651570248,     0.087727574850299,     0.071180355300210,     0.059862656420259,
     0.051639596353101,     0.045397202961992,     0.040498073750527,     0.036551437381820,     0.033304512826990,     0.030586599038282,     0.028278290307729,     0.026293570224361,     0.024568911944653,     0.023056383975320,
     0.908392877032751,     0.279291093918388,     0.161758435122409,     0.113289924883880,     0.087018755842400,     0.070584303166469,     0.059348523582399,     0.051187643149114,     0.044994044258325,     0.040134219516345,
     0.036219916881389,     0.033000056379079,     0.030305126728486,     0.028016579217385,     0.026049030312793,     0.024339430648799,     0.022840215718441,     0.905608035169868,     0.277679159589643,     0.160629875071998,
     0.112423256670484,     0.086315871724355,     0.069993369830487,     0.058838890179148,     0.050739703394579,     0.044594507571600,     0.039773665311147,     0.035891426915338,     0.032698401609372,     0.030026259340755,
     0.027757302088034,     0.025806774439743,     0.024112100852014,     0.022626080948646,     0.902839256366422,     0.276078467644893,     0.159509946657792,     0.111563587836355,     0.085618871532489,     0.069407510497990,
     0.058333716256564,     0.050295741033823,     0.044198560052589,     0.039416380969242,     0.035565939596727,     0.032399522589968,     0.029749972649323,     0.027500436186530,     0.025566781191573,     0.023886902315510,
     0.022413960479871,     0.900086428628991,     0.274488932116766,     0.158398580179350,     0.110710859795189,     0.084927704749082,     0.068826680772443,     0.057832962219624,     0.049855720338164,     0.043806169152329,
     0.039062336602513,     0.035243427296687,     0.032103393634088,     0.029476242654688,     0.027245958992850,     0.025329029356079,     0.023663814991449,     0.022203835307558,     0.897349440820352,     0.272910467731974,
     0.157295706519578,     0.109865014463646,     0.084242321298402,     0.068250836651483,     0.057336588828969,     0.049419605902918,     0.043417302619362,     0.038711502597852,     0.034923862642020,     0.031809989293827,
     0.029205045581493,     0.026993848198097,     0.025093497920586,     0.023442819021140,     0.021995686606938,     0.894628182652567,     0.271342989905505,     0.156201257139716,     0.109025994256952,     0.083562671542786,
     0.067679934523372,     0.056844557197679,     0.048987362644441,     0.043031928496997,     0.038363849614615,     0.034607218512822,     0.031519284357922,     0.028936357876419,     0.026744081702510,     0.024860166070068,
     0.023223894733246,     0.021789495731320,     0.891922544680131,     0.269786414734861,     0.155115164074379,     0.108193742084533,     0.082888706278750,     0.067113931163495,     0.056356828788078,     0.048558955797191,
     0.042650015120597,     0.038019348582101,     0.034293468040129,     0.031231253849540,     0.028670156206110,     0.026496637613498,     0.024629013185286,     0.023007022642017,     0.021585244210408,     0.889232418293177,
     0.268240658994355,     0.154037359926634,     0.107368201345696,     0.082220376733134,     0.066552783730881,     0.055873365408567,     0.048134350910825,     0.042271531114893,     0.037677970697053,     0.033982584603580,
     0.030945873024093,     0.028406417455107,     0.026251494243691,     0.024400018840933,     0.022792183445527,     0.021382913748625,     0.886557695710733,     0.266705640129443,     0.152967777863124,     0.106549315925345,
     0.081557634559286,     0.065996449764757,     0.055394129210486,     0.047713513847317,     0.041896445391321,     0.037339687421183,     0.033674541829111,     0.030663117367063,     0.028145118723808,     0.026008630109009,
     0.024173162803812,     0.022579358023941,     0.021182486223458,     0.883898269974040,     0.265181276251122,     0.151906351609231,     0.105737030189731,     0.080900431833272,     0.065444887181134,     0.054919082685007,
     0.047296410778104,     0.041524727145386,     0.037004470478724,     0.033369313586658,     0.030382962591860,     0.027886237326441,     0.025768023926754,     0.023948425031022,     0.022368527437792,     0.020983943683815,
     0.881254034939925,     0.263667486130357,     0.150853015444288,     0.104931288982249,     0.080248721050131,     0.064898054269425,     0.054448188660050,     0.046883008181259,     0.041156345854049,     0.036672291853998,
     0.033066873987895,     0.030105384637691,     0.027629750789064,     0.025529654613710,     0.023725785668161,     0.022159672926270,     0.020787268348402,     0.878624885274228,     0.262164189192572,     0.149807704196823,
     0.104132037619264,     0.079602455120153,     0.064355909689096,     0.053981410297234,     0.046473272838686,     0.040791271273136,     0.036343123789010,     0.032767197383982,     0.029830359667449,     0.027375636847577,
     0.025293501284271,     0.023505225047547,     0.021952775905538,     0.020592442604110,     0.876010716445286,     0.260671305512178,     0.148770353239855,     0.103339221885975,     0.078961587365198,     0.063818412466336,
     0.053518711088852,     0.046067171833351,     0.040429473434774,     0.036016938781067,     0.032470258363342,     0.029557864065630,     0.027123873445755,     0.025059543248581,     0.023286723686462,     0.021747817967057,
     0.020399449004423,     0.873411424717471,     0.259188755807156,     0.147740898486223,     0.102552788032322,     0.078326071515042,     0.063285521990773,     0.053060054854871,     0.045664672546526,     0.040070922644851,
     0.035693709580413,     0.032176031749452,     0.029287874436259,     0.026874438733301,     0.024827760010695,     0.023070262285400,     0.021544780875924,     0.020208270267837,     0.870826907144776,     0.257716461433675,
     0.146719276383959,     0.101772682768922,     0.077695861703765,     0.062757198012210,     0.052605405739969,     0.045265742655065,     0.039715589480499,     0.035373409187893,     0.031884492598661,     0.029020367600843,
     0.026627311063915,     0.024598131266753,     0.022855821726347,     0.021343646569235,     0.020018889276297,     0.868257061564465,     0.256254344380769,     0.145705423911703,     0.100998853263045,     0.077070912466158,
     0.062233400637391,     0.052154728210585,     0.044870350128707,     0.039363444787597,     0.035056010852631,     0.031595616198023,     0.028755320596340,     0.026382468993385,     0.024370636903175,     0.022643383071061,
     0.021144397154453,     0.019831289073644,     0.865701786590772,     0.254802327265050,     0.144699278574156,     0.100231247134624,     0.076451178734176,     0.061714090326798,     0.051707987052010,     0.044478463227397,
     0.039014459678299,     0.034741488069738,     0.031309378063153,     0.028492710673148,     0.026139891277688,     0.024145256994873,     0.022432927559383,     0.020947014907803,     0.019645452864085,     0.863160981608645,
     0.253360333325473,     0.143700778397573,     0.099469812452301,     0.075836615833410,     0.061199227891479,     0.051265147365494,     0.044090050498638,     0.038668605528591,     0.034429814578034,     0.031025753936106,
     0.028232515293111,     0.025899556871119,     0.023921971803474,     0.022224436607552,     0.020751482272669,     0.019461364010667,     0.860634546767556,     0.251928286418141,     0.142709861925294,     0.098714497729509,
     0.075227179479605,     0.060688774489901,     0.050826174565385,     0.043705080774864,     0.038325853975860,     0.034120964357793,     0.030744719783266,     0.027974712127547,     0.025661444924428,     0.023700761775571,
     0.022017891806546,     0.020557781858018,     0.019279006033776,     0.858122382975349,     0.250506111011156,     0.141726468213318,     0.097965251920587,     0.074622825775195,     0.060182691624835,     0.050391034376295,
     0.043323523170839,     0.037986176916492,     0.033814911628517,     0.030466251793267,     0.027719279055293,     0.025425534782983,     0.023481607540979,     0.021813274920432,     0.020365896436834,     0.019098362609643,
     0.855624391892149,     0.249093732179515,     0.140750536825913,     0.097222024416930,     0.074023511205878,     0.059680941140265,     0.049959692830285,     0.042945347081075,     0.037649546503491,     0.033511630846714,
     0.030190326374924,     0.027466194160764,     0.025191805984946,     0.023264489911013,     0.021610567884731,     0.020175808944565,     0.018919417568867,     0.853140475924318,     0.247691075600051,     0.139782007831261,
     0.096484765043176,     0.073429192637218,     0.059183485218330,     0.049532116264084,     0.042570522177285,     0.037315935144121,     0.033211096703714,     0.029916920155188,     0.027215435732040,     0.024960238259463,
     0.023049389876784,     0.021409752804807,     0.019987502477584,     0.018742154894950,     0.850670538218461,     0.246298067546410,     0.138820821797150,     0.095753424053418,     0.072839827311282,     0.058690286376289,
     0.049108271316329,     0.042199018405844,     0.036985315497566,     0.032913284123495,     0.029646009977120,     0.026966982258960,     0.024730811524880,     0.022836288607505,     0.021210811954260,     0.019800960291676,
     0.018566558722852,     0.848214482655484,     0.244914634884083,     0.137866919786693,     0.095027952127464,     0.072255372843298,     0.058201307463516,     0.048688124924828,     0.041830805985289,     0.036657660472619,
     0.032618168260532,     0.029377572897880,     0.026720812431241,     0.024503505886964,     0.022625167448818,     0.021013727773342,     0.019616165800521,     0.018392613337549,     0.845772213844698,     0.243540705065471,
     0.136920243354095,     0.094308300367116,     0.071675787218355,     0.057716511658523,     0.048271644323856,     0.041465855403827,     0.036332943225381,     0.032325724497667,     0.029111586186740,     0.026476905136614,
     0.024278301637153,     0.022416007921139,     0.020818482867384,     0.019433102574207,     0.018220303172616,     0.843343637117978,     0.242176206124992,     0.135980734540445,     0.093594420292489,     0.071101028788122,
     0.057235862466009,     0.047858797041466,     0.041104137416879,     0.036011137156993,     0.032035928443995,     0.028848027323112,     0.026235239458973,     0.024055179250812,     0.022208791718009,     0.020625060005242,
     0.019251754337748,     0.018049612808818,     0.840928658523963,     0.240821066674239,     0.135048335869556,     0.092886263838361,     0.070531056267602,     0.056759323713933,     0.047449550896831,     0.040745623044638,
     0.035692215911384,     0.031748755932777,     0.028586873994598,     0.025995794676547,     0.023834119385513,     0.022003500704470,     0.020433442117751,     0.019072104969621,     0.017880526972711,     0.838527184822311,
     0.239475215897170,     0.134122990343835,     0.092183783350560,     0.069965828731916,     0.056286859550619,     0.047043873997611,     0.040390283569653,     0.035376153373036,     0.031464183019363,     0.028328104095049,
     0.025758550260086,     0.023615102879326,     0.021800116915452,     0.020243612296203,     0.018894138500314,     0.017713030535263,     0.836139123477998,     0.238138583545341,     0.133204641440191,     0.091486931582373,
     0.069405305613110,     0.055818434441883,     0.046641734737334,     0.040038090534436,     0.035062923664777,     0.031182185979141,     0.028071695722659,     0.025523485871061,     0.023398110749130,     0.021598622554176,
     0.020055553790829,     0.018717839110889,     0.017547108510487,     0.833764382655667,     0.236811099933186,     0.132293233105976,     0.090795661690995,     0.068849446696996,     0.055354013168185,     0.046243101792818,
     0.039689015739087,     0.034752501145588,     0.030902741305506,     0.027817627178056,     0.025290581359889,     0.023183124188935,     0.021398999990573,     0.019869250009302,     0.018543191131559,     0.017382746054079,
     0.831402871214021,     0.235492695933329,     0.131388709754967,     0.090109927234008,     0.068298212120022,     0.054893560821813,     0.045847944121597,     0.039343031238943,     0.034444860408437,     0.030625825707839,
     0.027565876962430,     0.025059816764170,     0.022970124568227,     0.021201231759716,     0.019684684515254,     0.018370179040275,     0.017219928462084,     0.829054498700266,     0.234183302971940,     0.130491016263377,
     0.089429682165889,     0.067751562366165,     0.054437042804087,     0.045456230959388,     0.039000109342254,     0.034139976278124,     0.030351416109516,     0.027316423775665,     0.024831172306934,     0.022759093430321,
     0.021005300560267,     0.019501841026804,     0.018198787461334,     0.017058641169556,     0.826719175344598,     0.232882853024132,     0.129600097965903,     0.088754880834550,     0.067209458263854,     0.053984424822588,
     0.045067931817572,     0.038660222607868,     0.033837823809154,     0.030079489645929,     0.027069246514494,     0.024604628394921,     0.022550012490733,     0.020811189252941,     0.019320703415104,     0.018029001163992,
     0.016898869749248,     0.824396812054733,     0.231591278609394,     0.128715900651813,     0.088085477977911,     0.066671860982922,     0.053535672888416,     0.044683016480694,     0.038323343842951,     0.033538378283628,
     0.029810023662523,     0.026824324270673,     0.024380165616857,     0.022342863635569,     0.020618880858983,     0.019141255702892,     0.017860805061093,     0.016740599910305,     0.822087320410495,     0.230308512787067,
     0.127838370561057,     0.087421428720497,     0.066138732031588,     0.053090753313470,     0.044301455003997,     0.037989446100717,     0.033241615209148,     0.029542995712862,     0.026581636329167,     0.024157764741763,
     0.022137628919925,     0.020428358558658,     0.018963482063066,     0.017694184207715,     0.016583817496969,     0.819790612658428,     0.229034489151855,     0.126967454380422,     0.086762688570073,     0.065610033253455,
     0.052649632707753,     0.043923217710974,     0.037658502678186,     0.032947510316749,     0.029278383556699,     0.026341162166356,     0.023937406717270,     0.021934290566308,     0.020239605689758,     0.018787366817268,
     0.017529123799823,     0.016428508487300,     0.817506601706473,     0.227769141829374,     0.126103099239715,     0.086109213414301,     0.065085726824550,     0.052212277976703,     0.043548275190933,     0.037330487113958,
     0.032656039558844,     0.029016165158074,     0.026102881448257,     0.023719072667954,     0.021732830963063,     0.020052605746119,     0.018612894434482,     0.017365609172936,     0.016274658991909,     0.815235201118682,
     0.226512405471746,     0.125245252707981,     0.085460959517435,     0.064565775250377,     0.051778656318544,     0.043176598296600,     0.037005373186012,     0.032367179107196,     0.028756318683426,     0.025866774028766,
     0.023502743893684,     0.021533232662824,     0.019867342376158,     0.018440049529642,     0.017203625800812,     0.016122255252703,     0.812976325109966,     0.225264215253218,     0.124393862789753,     0.084817883517040,
     0.064050141363006,     0.051348735221668,     0.042808158141734,     0.036683134909520,     0.032080905350895,     0.028498822499723,     0.025632819947907,     0.023288401867987,     0.021335478380973,     0.019683799381417,
     0.018268816862263,     0.017043159294136,     0.015971283641635,     0.810729888540904,     0.224024506865832,     0.123548877921334,     0.084179942420736,     0.063538788318184,     0.050922482462032,     0.042442926098763,
     0.036363746534686,     0.031797194894368,     0.028243655172611,     0.025400999430111,     0.023076028236432,     0.021139550994117,     0.019501960715128,     0.018099181335069,     0.016884195399230,     0.015821730659478,
     0.808495806912584,     0.222793216515124,     0.122710246967117,     0.083547093602981,     0.063031679592470,     0.050499866100585,     0.042080873796450,     0.036047182544598,     0.031516024555401,     0.027990795464574,
     0.025171292882497,     0.022865604815018,     0.020945433538580,     0.019321810480782,     0.017931127992651,     0.016726719996769,     0.015673582934602,     0.806273996361486,     0.221570280915860,     0.121877919215926,
     0.082919294801876,     0.062528778980398,     0.050080854480719,     0.041721973117568,     0.035733417653112,     0.031237371363176,     0.027740222333120,     0.024943680893179,     0.022657113588592,     0.020753109208904,
     0.019143332930724,     0.017764642020127,     0.016570719100512,     0.015526827221764,     0.804064373654418,     0.220355637287810,     0.121051844377401,     0.082296504115997,     0.062030050591670,     0.049665416225735,
     0.041366196196609,     0.035422426802740,     0.030961212556335,     0.027491914928978,     0.024718144229586,     0.022450536709267,     0.020562561356368,     0.018966512464748,     0.017599708741816,     0.016416178856041,
     0.015381450400910,     0.801866856183479,     0.219149223351559,     0.120231972578408,     0.081678680001259,     0.061535458848362,     0.049253520236342,     0.041013515417504,     0.035114185162569,     0.030687525581053,
     0.027245852594312,     0.024494663836796,     0.022245856494869,     0.020373773487525,     0.018791333628715,     0.017436313619928,     0.016263085539521,     0.015237439475991,     0.799681361961078,     0.217950977324354,
     0.119418254359478,     0.081065781267806,     0.061044968482169,     0.048845135688169,     0.040663903411370,     0.034808668126197,     0.030416288089132,     0.027002014860955,     0.024273220835884,     0.022043055427387,
     0.020186729262742,     0.018617781113180,     0.017274442253262,     0.016111425556459,     0.015094781573787,     0.797507809614983,     0.216760837915979,     0.118610640671282,     0.080457767076930,     0.060558544531665,
     0.048440232029311,     0.040317333054272,     0.034505851309679,     0.030147477936118,     0.026760381448656,     0.024053796522294,     0.021842116151442,     0.020001412494763,     0.018445839752033,     0.017114080375922,
     0.015961185440488,     0.014953463942743,     0.795346118383422,     0.215578744324679,     0.117809082871137,     0.079854596938012,     0.060076152339588,     0.048038778977884,     0.039973777465013,     0.034205710549509,
     0.029881073179423,     0.026520932263343,     0.023836372364215,     0.021643021472773,     0.019817807147282,     0.018275494521152,     0.016955213856041,     0.015812351852151,     0.014813473951817,     0.793196208110211,
     0.214404636233106,     0.117013532719538,     0.079256230705496,     0.059597757550159,     0.047640746519613,     0.039633210002935,     0.033908221900600,     0.029617052076480,     0.026283647395407,     0.023620930000981,
     0.021445754356733,     0.019635897333532,     0.018106730537066,     0.016797828694513,     0.015664911577703,     0.014674799089335,     0.791057999239937,     0.213238453804303,     0.116223942376722,     0.078662628575889,
     0.059123326106411,     0.047246104905436,     0.039295604265749,     0.033613361634303,     0.029355393082900,     0.026048507117996,     0.023407451241478,     0.021250297926802,     0.019455667314881,     0.017939533055640,
     0.016641911023751,     0.015518851527927,     0.014537426961866,     0.788931412813170,     0.212080137677730,     0.115440264399263,     0.078073751084784,     0.058652824247553,     0.046854824649128,     0.038960934087378,
     0.033321106236426,     0.029096074850657,     0.025815491885328,     0.023195918062575,     0.021056635463108,     0.019277101499446,     0.017773887470760,     0.016487447106439,     0.015374158736950,     0.014401345293096,
     0.786816370461720,     0.210929628965312,     0.114662451736696,     0.077489559103912,     0.058186218506350,     0.046466876524958,     0.038629173535821,     0.033031432405285,     0.028839076226285,     0.025584582331017,
     0.022986312607561,     0.020864750400973,     0.019100184440724,     0.017609779313041,     0.016334423334309,     0.015230820361083,     0.014266541922722,     0.784712794403933,     0.209786869247526,     0.113890457728171,
     0.076910013838218,     0.057723475706534,     0.046082231565348,     0.038300296911043,     0.032744317049765,     0.028584376249091,     0.025355759266421,     0.022778617184603,     0.020674626329462,     0.018924900836223,
     0.017447194248539,     0.016182826226923,     0.015088823677665,     0.014133004805350,     0.782620607440022,     0.208651800569526,     0.113124236099133,     0.076335076822968,     0.057264562960229,     0.045700861058574,
     0.037974278742872,     0.032459737287399,     0.028331954149386,     0.025129003678997,     0.022572814265215,     0.020486246989950,     0.018751235526123,     0.017286118077480,     0.016032642430470,     0.014948156083917,
     0.014000722009411,     0.780539732947441,     0.207524365437292,     0.112363740958037,     0.075764709920873,     0.056809447665408,     0.045322736546468,     0.037651093788926,     0.032177670442474,     0.028081789346733,
     0.024904296730678,     0.022368886482740,     0.020299596274702,     0.018579173491933,     0.017126536733002,     0.015883858716572,     0.014808805095814,     0.013869681716077,     0.778470094876297,     0.206404506813820,
     0.111608926793083,     0.075198875319248,     0.056358097503368,     0.044947829822161,     0.037330717032556,     0.031898094044138,     0.027833861448211,     0.024681619756258,     0.022166816630851,     0.020114658225468,
     0.018408699855173,     0.016968436279901,     0.015736461981102,     0.014670758346956,     0.013739872218196,     0.776411617744798,     0.205292168115336,     0.110859748468989,     0.074637535527187,     0.055910480436226,
     0.044576112927827,     0.037013123680803,     0.031620985824540,     0.027588150246693,     0.024460954261802,     0.021966587662061,     0.019931417032088,     0.018239799876060,     0.016811802913402,     0.015590439243014,
     0.014534003587465,     0.013611281919237,     0.774364226634738,     0.204187293207552,     0.110116161223783,     0.074080653372770,     0.055466564704442,     0.044207558152459,     0.036698289162381,     0.031346323716978,
     0.027344635719142,     0.024242281923058,     0.021768182686250,     0.019749857031111,     0.018072458952215,     0.016656622957927,     0.015445777643183,     0.014398528682877,     0.013483899332236,     0.772327847187022,
     0.203089826401944,     0.109378120665629,     0.073528192000290,     0.055026318824362,     0.043842138029664,     0.036386189125670,     0.031074085854067,     0.027103298024919,     0.024025584583898,     0.021571584969207,
     0.019569962704429,     0.017906662617371,     0.016502882865885,     0.015302464443254,     0.014264321613054,     0.013357713078761,     0.770302405597228,     0.201999712452072,     0.108645582769679,     0.072980114867508,
     0.054589711585780,     0.043479825335477,     0.036076799436739,     0.030804250565922,     0.026864117504115,     0.023810844254761,     0.021376777931177,     0.019391718677920,     0.017742396540103,     0.016350569216471,
     0.015160487024508,     0.014131370471105,     0.013232711887886,     0.768287828611203,     0.200916896549920,     0.107918503874952,     0.072436385742930,     0.054156712049529,     0.043120593086188,     0.035770096177372,
     0.030536796378362,     0.026627074675890,     0.023598043111117,     0.021183745145435,     0.019215109720109,     0.017579646522564,     0.016199668714472,     0.015019832886733,     0.013999663462314,     0.013108884595170,
     0.766284043520696,     0.199841324322276,     0.107196840681238,     0.071896968703107,     0.053727289545085,     0.042764414536202,     0.035466055643125,     0.030271702011126,     0.026392150236829,     0.023387163491945,
     0.020992470336862,     0.019040120740836,     0.017418398499238,     0.016050168189089,     0.014880489647109,     0.013869188903083,     0.012986220141648,     0.764290978159030,     0.198772941827140,     0.106480550246035,
     0.071361828129965,     0.053301413668199,     0.042411263175907,     0.035164654341396,     0.030008946376106,     0.026159325059318,     0.023178187898222,     0.020802937380539,     0.018866736789939,     0.017258638535699,
     0.015902054592770,     0.014742445039097,     0.013739935219877,     0.012864707572835,     0.762308560896807,     0.197711695550159,     0.105769589981501,     0.070830928708148,     0.052879054278546,     0.042061112729565,
     0.034865868989509,     0.029748508575599,     0.025928580189926,     0.022971098991430,     0.020615130300356,     0.018694943055952,     0.017100352827384,     0.015755315000052,     0.014605686911351,     0.013611890948192,
     0.012744336037733,     0.760336720637647,     0.196657532401100,     0.105063917651451,     0.070304235422395,     0.052460181497399,     0.041713937153222,     0.034569676512820,     0.029490367900569,     0.025699896847815,
     0.022765879592073,     0.020429033267626,     0.018524724864808,     0.016943527698381,     0.015609936606412,     0.014470203226628,     0.013485044731516,     0.012625094787855,     0.758375386813970,     0.195610399710345,
     0.104363491368359,     0.069781713554932,     0.052044765705321,     0.041369710632642,     0.034276054042840,     0.029234503828936,     0.025473256423150,     0.022562512678211,     0.020244630599725,     0.018356067678562,
     0.016788149600221,     0.015465906727136,     0.014335982060714,     0.013359385320318,     0.012506973176247,     0.756424489382800,     0.194570245225421,     0.103668269590400,     0.069263328682895,     0.051632777539874,
     0.041028407581246,     0.033984978915373,     0.028980896023868,     0.025248640475536,     0.022360981384005,     0.020061906758730,     0.018188957094122,     0.016634205110690,     0.015323212796188,     0.014203011601361,
     0.013234901571030,     0.012389960656535,     0.754483958821617,     0.193537017107555,     0.102978211118517,     0.068749046675766,     0.051224187893360,     0.040690002638087,     0.033696428668672,     0.028729524332096,
     0.025026030732459,     0.022161268998277,     0.019880846350083,     0.018023378841991,     0.016481680932644,     0.015181842365103,     0.014071280147228,     0.013111582445048,     0.012274046781967,     0.752553726124232,
     0.192510663928265,     0.102293275093503,     0.068238833692843,     0.050818967910568,     0.040354470665830,     0.033410381041611,     0.028480368782243,     0.024805409087752,     0.021963358963086,     0.019701434121254,
     0.017859318785022,     0.016330563892842,     0.015041783101877,     0.013940776106842,     0.012989417007744,     0.012159221204470,     0.750633722796707,     0.191491134665973,     0.101613420993122,     0.067732656180720,
     0.050417088986551,     0.040021786748753,     0.033126813971878,     0.028233409583169,     0.024586757600066,     0.021767234872308,     0.019523654960433,     0.017696762917188,     0.016180840940782,     0.014903022789875,
     0.013811487997561,     0.012868394427480,     0.012045473673718,     0.748723880853294,     0.190478378702651,     0.100938608629246,     0.067230480870800,     0.050018522764420,     0.039691926190774,     0.032845705594174,
     0.027988627122329,     0.024370058491360,     0.021572880470241,     0.019347493895215,     0.017535697362357,     0.016032499147560,     0.014765549326750,     0.013683404444546,     0.012748503974636,     0.011932794036203,
     0.746824132812427,     0.189472345820492,     0.100268798145017,     0.066732274776822,     0.049623241133157,     0.039364864513484,     0.032567034238442,     0.027746001964150,     0.024155294145404,     0.021380279650214,
     0.019172936091315,     0.017376108373082,     0.015885525704727,     0.014629350723368,     0.013556514179750,     0.012629735020648,     0.011821172234322,     0.744934411692727,     0.188472986198616,     0.099603950012042,
     0.066238005192418,     0.049231216225447,     0.039040577454208,     0.032290778428102,     0.027505514848416,     0.023942447106295,     0.021189416453216,     0.018999966851282,     0.017217982329405,     0.015739907923163,
     0.014494415102747,     0.013430806040909,     0.012512077037050,     0.011710598305464,     0.743054651009055,     0.187480250409792,     0.098944025027597,     0.065747639688681,     0.048842420415532,     0.038719040964075,
     0.032016916878306,     0.027267146688676,     0.023731500076988,     0.021000275066530,     0.018828571613234,     0.017061305737664,     0.015595633231962,     0.014360730699000,     0.013306268970549,     0.012395519594534,
     0.011601062381115,     0.741184784768587,     0.186494089417204,     0.098288984311875,     0.065261146111762,     0.048456826317082,     0.038400231206111,     0.031745428494208,     0.027030878570660,     0.023522435917839,
     0.020812839822385,     0.018658735949598,     0.016906065229323,     0.015452689177325,     0.014228285856298,     0.013182892014996,     0.012280052362008,     0.011492554685966,     0.739324747466931,     0.185514454571226,
     0.097638789305240,     0.064778492580490,     0.048074406781083,     0.038084124553348,     0.031476292369251,     0.026796691750714,     0.023315237645162,     0.020627095196620,     0.018490445565865,     0.016752247559801,
     0.015311063421467,     0.014097069027831,     0.013060664323399,     0.012165665105671,     0.011385065537026,     0.737474474084268,     0.184541297606244,     0.096993401765513,     0.064299647484004,     0.047695134893750,
     0.037770697586949,     0.031209487783468,     0.026564567654249,     0.023109888429800,     0.020443025807358,     0.018323686299358,     0.016599839607320,     0.015170743741529,     0.013967068774791,     0.012939575146764,
     0.012052347688095,     0.011278585342756,     0.735633900081528,     0.183574570637486,     0.096352783765283,     0.063824579479414,     0.047318983974454,     0.037459927094351,     0.030944994201797,     0.026334487874198,
     0.022906371595711,     0.020260616413697,     0.018158444118009,     0.016448828371760,     0.015031718028504,     0.013838273765351,     0.012819613836992,     0.011940090067313,     0.011173104602195,     0.733802961396596,
     0.182614226157892,     0.095716897689238,     0.063353257489479,     0.046945927573666,     0.037151790067425,     0.030682791272417,     0.026106434169495,     0.022704670618561,     0.020079851914404,     0.017994705119145,
     0.016299200973527,     0.014893974286174,     0.013710672773667,     0.012700769845930,     0.011828882295919,     0.011068613904109,     0.731981594440555,     0.181660217035007,     0.095085706231520,     0.062885650700306,
     0.046575939470927,     0.036846263700650,     0.030422858825096,     0.025880388463567,     0.022504769124334,     0.019900717346634,     0.017832455528294,     0.016150944652428,     0.014757500630053,     0.013584254678878,
     0.012583032724432,     0.011718714520174,     0.010965103926134,     0.730169736093951,     0.180712496507898,     0.094459172393101,     0.062421728559070,     0.046208993672824,     0.036543325389304,     0.030165176869547,
     0.025656332842832,     0.022306650887957,     0.019723197884650,     0.017671681697992,     0.016004046766563,     0.014622285286341,     0.013459008464127,     0.012466392121421,     0.011609576979120,     0.010862565433944,
     0.728367323703093,     0.179771018184097,     0.093837259479187,     0.061961460771753,     0.045845064410997,     0.036242952727679,     0.029909725593813,     0.025434249555223,     0.022110299831936,     0.019547278838559,
     0.017512370106608,     0.015858494791219,     0.014488316590894,     0.013334923215579,     0.012350837782974,     0.011501460003709,     0.010760989280409,     0.726574295076388,     0.178835736036576,     0.093219931096639,
     0.061504817300905,     0.045484126140155,     0.035945123507299,     0.029656485362656,     0.025214121008712,     0.021915700024999,     0.019372945653059,     0.017354507357174,     0.015714276317782,     0.014355582988193,
     0.013211988121455,     0.012236359551398,     0.011394354015929,     0.010660366404775,     0.724790588480696,     0.177906604400740,     0.092607151151419,     0.061051768363419,     0.045126153536112,     0.035649815715164,
     0.029405436715964,     0.024995929769863,     0.021722835680761,     0.019200183906201,     0.017198080176237,     0.015571379052651,     0.014224073030330,     0.013090192471079,     0.012122947364332,     0.011288249527947,
     0.010560687831842,     0.723016142637725,     0.176983577971448,     0.091998883846058,     0.060602284428334,     0.044771121493843,     0.035357007532006,     0.029156560367172,     0.024779658562380,     0.021531691156393,
     0.019028979308156,     0.017043075412705,     0.015429790816175,     0.014093775376005,     0.012969525653924,     0.012010591253845,     0.011183137141260,     0.010461944671158,     0.721250896720447,     0.176066611800063,
     0.091395093677142,     0.060156336214652,     0.044419005125554,     0.035066677330561,     0.028909837201698,     0.024565290265686,     0.021342250951312,     0.018859317700001,     0.016889480036720,     0.015289499541583,
     0.013964678789523,     0.012849977158672,     0.011899281345546,     0.011079007545848,     0.010364128116215,     0.719494790349553,     0.175155661291522,     0.090795745432831,     0.059713894689175,     0.044069779758770,
     0.034778803673860,     0.028665248275393,     0.024352807913504,     0.021154499705872,     0.018691185052509,     0.016737281138529,     0.015150493273940,     0.013836772139813,     0.012731536572288,     0.011789007857708,
     0.010975851519337,     0.010267229443653,     0.717747763589927,     0.174250682201432,     0.090200804190384,     0.059274931064359,     0.043723420934443,     0.034493365313526,     0.028422774813007,     0.024142194692452,
     0.020968422200076,     0.018524567464954,     0.016586465927377,     0.015012760169101,     0.013710044399444,     0.012614193579093,     0.011679761100391,     0.010873659926179,     0.010171240012475,     0.716009756947156,
     0.173351630633193,     0.089610235313715,     0.058839416796193,     0.043379904405070,     0.034210341188098,     0.028182398206663,     0.023933433940658,     0.020784003352299,     0.018359451163927,     0.016437021730398,
     0.014876288492681,     0.013584484643662,     0.012497937959852,     0.011571531474581,     0.010772423716824,     0.010076151263267,     0.714280711364067,     0.172458463035142,     0.089024004450973,     0.058407323582090,
     0.043039206132839,     0.033929710421364,     0.027944100014352,     0.023726509146376,     0.020601228218014,     0.018195822502165,     0.016288935991526,     0.014741066619033,     0.013460082049423,     0.012382759590869,
     0.011464309471332,     0.010672133926911,     0.009981954717423,     0.712560568217289,     0.171571136197725,     0.088442077532130,     0.057978623358802,     0.042701302287776,     0.033651452320708,     0.027707861958437,
     0.023521403946630,     0.020420081988546,     0.018033667957384,     0.016142196270413,     0.014607083030239,     0.013336825894451,     0.012268648443092,     0.011358085670921,     0.010572781676468,     0.009888641976386,
     0.710849269313849,     0.170689607250686,     0.087864420766607,     0.057553288300347,     0.042366169245927,     0.033375546375474,     0.027473665924173,     0.023318102125851,     0.020240549989818,     0.017872974131129,
     0.015996790241354,     0.014474326315099,     0.013214705556285,     0.012155594581222,     0.011252850742002,     0.010474358169107,     0.009796204720884,     0.709146756887790,     0.169813833660290,     0.087291000640903,
     0.057131290815961,     0.042033783587536,     0.033101972255348,     0.027241493958238,     0.023116587614548,     0.020062617681127,     0.017713727747636,     0.015852705692229,     0.014342785168147,     0.013093710511358,
     0.012043588162836,     0.011148595440783,     0.010376854691243,     0.009704634710182,     0.707452973596824,     0.168943773226562,     0.086721783916258,     0.056712603548064,     0.041704122095261,     0.032830709808744,
     0.027011328267282,     0.022916844487971,     0.019886270653917,     0.017555915652696,     0.015709930523445,     0.014212448388658,     0.012973830334062,     0.011932619437514,     0.011045310610193,     0.010280262611306,
     0.009613923781340,     0.705767862519003,     0.168079384080546,     0.086156737626333,     0.056297199370246,     0.041377161752384,     0.032561739061219,     0.026783151216483,     0.022718856964804,     0.019711494630571,
     0.017399524812538,     0.015568452746899,     0.014083304879679,     0.012855054695839,     0.011822678745977,     0.010942987179073,     0.010184573378971,     0.009524063848475,     0.704091367149426,     0.167220624681603,
     0.085595829074902,     0.055885051385267,     0.041052879741055,     0.032295040213890,     0.026556945328121,     0.022522609405854,     0.019538275463212,     0.017244542312721,     0.015428260484941,     0.013955343647063,
     0.012737373364270,     0.011713756519231,     0.010841616161363,     0.010089778524390,     0.009435046902033,     0.702423431396967,     0.166367453814711,     0.085039025833577,     0.055476132923078,     0.040731253440541,
     0.032030593641872,     0.026332693280162,     0.022328086312765,     0.019366599132516,     0.017090955357030,     0.015289341969355,     0.013828553798506,     0.012620776202180,     0.011605843277720,     0.010741188655302,
     0.009995869657431,     0.009346865008064,     0.700763999581034,     0.165519830587803,     0.084486295739539,     0.055070417538859,     0.040412260425494,     0.031768379892728,     0.026110377904857,     0.022135272326736,
     0.019196451746534,     0.016938751266391,     0.015151685540340,     0.013702924542607,     0.012505253166744,     0.011498929630489,     0.010641695842635,     0.009902838466926,     0.009259510307510,     0.699113016428352,
     0.164677714429123,     0.083937606893303,     0.054667879011076,     0.040095878464234,     0.031508379684933,     0.025889982187354,     0.021944152227252,     0.019027819539527,     0.016787917477788,     0.015015279645510,
     0.013578445187924,     0.012390794308609,     0.011393006274350,     0.010543128987827,     0.009810676719927,     0.009172975015493,     0.697470427069773,     0.163841065084601,     0.083392927656488,     0.054268491339549,
     0.039782085517050,     0.031250573906350,     0.025671489264317,     0.021754710930831,     0.018860688870811,     0.016638441543198,     0.014880112838896,     0.013455105142043,     0.012277389771017,     0.011288063993061,
     0.010445479437285,     0.009719376260967,     0.009087251420615,     0.695836177037111,     0.163009842615255,     0.082852226649618,     0.053872228743541,     0.039470859734509,     0.030994943612725,     0.025454882422568,
     0.021566933489778,     0.018695046223609,     0.016490311128530,     0.014746173779965,     0.013332893910662,     0.012165029788942,     0.011184093656508,     0.010348738618585,     0.009628929011327,     0.009002331884263,
     0.694210212260006,     0.162184007394613,     0.082315472749933,     0.053479065659867,     0.039162179455790,     0.030741470026192,     0.025240145097729,     0.021380805090948,     0.018530878203924,     0.016343514012572,
     0.014613451232636,     0.013211801096670,     0.012053704688230,     0.011081086219899,     0.010252898039712,     0.009539326968316,     0.008918208839917,     0.692592479062812,     0.161363520106155,     0.081782635089228,
     0.053088976741012,     0.038856023207023,     0.030490134533787,     0.025027260872889,     0.021196311054529,     0.018368171539406,     0.016198038085958,     0.014481934064320,     0.013091816399250,     0.011943404884754,
     0.010979032722964,     0.010157949288297,     0.009450562204547,     0.008834874792473,     0.690982924161507,     0.160548341740779,     0.081253683051699,     0.052701936853275,     0.038552369699650,     0.030240918685986,
     0.024816213477271,     0.021013436832828,     0.018206913078247,     0.016053871350134,     0.014351611244958,     0.012972929612977,     0.011834120883569,     0.010877924289161,     0.010063884030874,     0.009362626867233,
     0.008752322317561,     0.689381494660634,     0.159738433594289,     0.080728586271821,     0.052317921074918,     0.038251197828798,     0.029993804195246,     0.024606986784920,     0.020832168009074,     0.018047089788075,
     0.015911001916335,     0.014222471846070,     0.012855130626936,     0.011725843278082,     0.010777752124893,     0.009970694012135,     0.009275513177476,     0.008670544060881,     0.687788138050264,     0.158933757264902,
     0.080207314632232,     0.051936904694340,     0.037952486671663,     0.029748772934567,     0.024399564813400,     0.020652490296223,     0.017888688754859,     0.015769418004581,     0.014094505039819,     0.012738409423836,
     0.011618562749220,     0.010678507518725,     0.009878371054193,     0.009189213429578,     0.008589532737537,     0.686202802202985,     0.158134274650775,     0.079689838261642,     0.051558863208267,     0.037656215485917,
     0.029505806936059,     0.024193931722502,     0.020474389535789,     0.017731697181829,     0.015629107942668,     0.013967700098076,     0.012622756079147,     0.011512270064622,     0.010580181840619,     0.009786907055856,
     0.009103719990343,     0.008509281131381,     0.684625435370912,     0.157339947947557,     0.079176127532763,     0.051183772319949,     0.037362363708119,     0.029264888389528,     0.023990071812961,     0.020297851696667,
     0.017576102388403,     0.015490060165180,     0.013842046391494,     0.012508160760227,     0.011406956077821,     0.010482766541168,     0.009696293991903,     0.009019025298394,     0.008429782094363,     0.683055986182727,
     0.156550739645959,     0.078666153060247,     0.050811607937384,     0.037070910952150,     0.029025999641076,     0.023787969525194,     0.020122862873986,     0.017421891809121,     0.015352263212503,     0.013717533388600,
     0.012394613725478,     0.011302611727444,     0.010386253150841,     0.009606523912372,     0.008935121863501,     0.008351028545886,     0.681494403640741,     0.155766612529342,     0.078159885698649,     0.050442346171553,
     0.036781837007651,     0.028789123191704,     0.023587609438039,     0.019949409287955,     0.017269052992597,     0.015215705729855,     0.013594150654885,     0.012282105323490,     0.011199228036417,     0.010290633279232,
     0.009517588941850,     0.008852002265901,     0.008273013472169,     0.679940637117977,     0.154987529671334,     0.077657296540408,     0.050075963334666,     0.036495121838487,     0.028554241695941,     0.023388976267513,
     0.019777477282732,     0.017117573600472,     0.015080376466314,     0.013471887851905,     0.012170625992206,     0.011096796111179,     0.010195898614320,     0.009429481278771,     0.008769659155641,     0.008195729925612,
     0.678394636355279,     0.154213454433455,     0.077158356913842,     0.049712435938430,     0.036210745581215,     0.028321337960474,     0.023192054865572,     0.019607053325298,     0.016967441406379,     0.014946264273869,
     0.013350734736394,     0.012060166258092,     0.010995307140899,     0.010102040921734,     0.009342193194723,     0.008688085251913,     0.008119171024173,     0.676856351458449,     0.153444350462770,     0.076663038381161,
     0.049351740692329,     0.035928688543568,     0.028090394942794,     0.022996830218898,     0.019438124004341,     0.016818644294922,     0.014813358106468,     0.013230681159382,     0.011950716735310,     0.010894752396703,
     0.010009052044024,     0.009255717033759,     0.008607273342405,     0.008043329950747,     0.675325732895397,     0.152680181689564,     0.076171312736498,     0.048993854501920,     0.035648931202959,     0.027861395749859,
     0.022803287447680,     0.019270676029154,     0.016671170260660,     0.014681647019082,     0.013111717065322,     0.011842268124906,     0.010795123230914,     0.009916923899937,     0.009170045211716,     0.008527216282654,
     0.007968199952549,     0.673802731493326,     0.151920912325025,     0.075683152003958,     0.048638754467146,     0.035371454204988,     0.027634323636761,     0.022611411804413,     0.019104696228538,     0.016525007407101,
     0.014551120166772,     0.012993832491228,     0.011734811213997,     0.010696411076287,     0.009825648483711,     0.009085170215539,     0.008447906995407,     0.007893774340509,     0.672287298435932,     0.151166506858962,
     0.075198528435682,     0.048286417880656,     0.035096238361968,     0.027409162005413,     0.022421188672716,     0.018940171549717,     0.016380143945705,     0.014421766803772,     0.012877017565812,     0.011628336874977,
     0.010598607445259,     0.009735217864357,     0.009001084602609,     0.008369338469983,     0.007820046488668,     0.670779385260629,     0.150416930057528,     0.074717414509926,     0.047936822226150,     0.034823264651465,
     0.027185894403238,     0.022232603566144,     0.018777089057267,     0.016236568194897,     0.014293576282572,     0.012761262508642,     0.011522836064717,     0.010501703929208,     0.009645624184965,     0.008917781000089,
     0.008291503761651,     0.007747009833582,     0.669278943855796,     0.149672146960971,     0.074239782929163,     0.047589945176731,     0.034552514214850,     0.026964504521879,     0.022045642127026,     0.018615435932047,
     0.016094268579092,     0.014166538053016,     0.012646557629296,     0.011418299823786,     0.010405692197713,     0.009556859662007,     0.008835252104258,     0.008214395991001,     0.007674657873725,     0.667785926458049,
     0.148932122881403,     0.073765606618192,     0.047245764593278,     0.034283968355859,     0.026744976195920,     0.021860290125305,     0.018455199470148,     0.015953233627721,     0.014040641661407,     0.012532893326533,
     0.011314719275666,     0.010310563997824,     0.009468916584649,     0.008753490679866,     0.008138008343333,     0.007602984168913,     0.666300285649535,     0.148196823400582,     0.073294858722275,     0.046904258522824,
     0.034017608539175,     0.026527293401608,     0.021676533457390,     0.018296367081844,     0.015813451974275,     0.013915876749616,     0.012420260087463,     0.011212085625987,     0.010216311153338,     0.009381787314071,
     0.008672489559490,     0.008062334068044,     0.007531982339716,     0.664821974355241,     0.147466214367719,     0.072827512605274,     0.046565405196957,     0.033753416389014,     0.026311440255601,     0.021494358145023,
     0.018138926290559,     0.015674912355351,     0.013792233054206,     0.012308648486737,     0.011110390161757,     0.010122925564086,     0.009295464282788,     0.008592241642895,     0.007987366478024,     0.007461646066884,
     0.663350945840335,     0.146740261897302,     0.072363541847825,     0.046229183030232,     0.033491373687731,     0.026097401013716,     0.021313750334149,     0.017982864731838,     0.015537603609712,     0.013669700405558,
     0.012198049185727,     0.011009624250612,     0.010030399205216,     0.009209939993986,     0.008512739896400,     0.007913098949057,     0.007391969090783,     0.661887153707523,     0.146018932366935,     0.071902920245506,
     0.045895570618593,     0.033231462374429,     0.025885160069696,     0.021134696293802,     0.017828170152332,     0.015401514677350,     0.013548268727011,     0.012088452931731,     0.010909779340061,     0.009938724126495,
     0.009125207020859,     0.008433977352257,     0.007839524919228,     0.007322945210824,     0.660430551894429,     0.145302192415202,     0.071445621807037,     0.045564546737819,     0.032973664543591,     0.025674701953982,
     0.020957182414995,     0.017674830408790,     0.015266634598564,     0.013427928034002,     0.011979850557177,     0.010810846956744,     0.009847892451612,     0.009041258005949,     0.008355947108026,     0.007766637888334,
     0.007254568284912,     0.658981094670994,     0.144590008939538,     0.070991620752486,     0.045236090341969,     0.032717962443717,     0.025466011332498,     0.020781195209632,     0.017522833467060,     0.015132952513039,
     0.013308668433223,     0.011872232978831,     0.010712818705701,     0.009757896377485,     0.008958085660498,     0.008278642325964,     0.007694431417303,     0.007186832228886,     0.657538736636899,     0.143882349094130,
     0.070540891511498,     0.044910180561854,     0.032464338475974,     0.025259073005452,     0.020606721309413,     0.017372167401102,     0.015000457658945,     0.013190480121779,     0.011765591197022,     0.010615686269635,
     0.009668728173580,     0.008875682763808,     0.008202056232415,     0.007622899127619,     0.007119731015974,     0.656103432719009,     0.143179180287828,     0.070093408721529,     0.044586796703517,     0.032212775192863,
     0.025053871906138,     0.020433747464765,     0.017222820392002,     0.014869139372027,     0.013073353386359,     0.011659916294865,     0.010519441408198,     0.009580380181232,     0.008794042162596,     0.008126182117209,
     0.007552034700746,     0.007053258676252,     0.654675138168835,     0.142480470182074,     0.069649147226108,     0.044265918246723,     0.031963255296890,     0.024850393099757,     0.020262260543771,     0.017074780727007,
     0.014738987084722,     0.012957278602408,     0.011555199437498,     0.010424075957271,     0.009492844812972,     0.008713156770367,     0.008051013333061,     0.007481831877568,     0.006987409296103,     0.653253808560020,
     0.141786186688854,     0.069208082073102,     0.043947524843468,     0.031715761639253,     0.024648621782247,     0.020092247531115,     0.016928036798558,     0.014609990325272,     0.012842246233314,     0.011451431871321,
     0.010329581828256,     0.009406114551869,     0.008633019566788,     0.007976543294986,     0.007412284457824,     0.006922177017685,     0.651839399785843,     0.141096297968658,     0.068770188513003,     0.043631596316498,
     0.031470277218544,     0.024448543279119,     0.019923695527034,     0.016782577103341,     0.014482138716848,     0.012728246829597,     0.011348604923247,     0.010235951007375,     0.009320181950864,     0.008553623597065,
     0.007902765479706,     0.007343386299557,     0.006857556038408,     0.650431868056741,     0.140410772428468,     0.068335441997230,     0.043318112657841,     0.031226785179457,     0.024250143044308,     0.019756591746282,
     0.016638390241338,     0.014355421976682,     0.012615271028109,     0.011246709999954,     0.010143175554972,     0.009235039632122,     0.008474961971332,     0.007829673425077,     0.007275131318558,     0.006793540610403,
     0.649031169897862,     0.139729578719752,     0.067903818176438,     0.043007054027354,     0.030985268811507,     0.024053406659034,     0.019590923517100,     0.016495464914889,     0.014229829915213,     0.012503309551238,
     0.011145738587148,     0.010051247604830,     0.009150680286383,     0.008397027864040,     0.007757260729507,     0.007207513487829,     0.006730125040014,     0.647637262146621,     0.139052685736483,     0.067475292898853,
     0.042698400751279,     0.030745711547767,     0.023858319830671,     0.019426678280198,     0.016353789927772,     0.014105352435228,     0.012392353206126,     0.011045682248836,     0.009960159363480,     0.009067096672326,
     0.008319814513357,     0.007685521051393,     0.007140526837038,     0.006667303687278,     0.646250101950292,     0.138380062613172,     0.067049842208612,     0.042392133320816,     0.030508096963610,     0.023664868391628,
     0.019263843587744,     0.016213354184275,     0.013981979531023,     0.012282392883883,     0.010946532626595,     0.009869903109532,     0.008984281615930,     0.008243315220568,     0.007614448108553,     0.007074165451986,
     0.006605070965421,     0.644869646763607,     0.137711678722913,     0.066627442344120,     0.042088232390703,     0.030272408775463,     0.023473038298238,     0.019102407102365,     0.016074146688292,     0.013859701287569,
     0.012173419558821,     0.010848281438862,     0.009780471193001,     0.008902228009849,     0.008167523349486,     0.007544035677669,     0.007008423474079,     0.006543421340354,     0.643495854346384,     0.137047503675455,
     0.066208069736425,     0.041786678777814,     0.030038630839576,     0.023282815629662,     0.018942356596155,     0.015936156542415,     0.013738507879676,     0.012065424287684,     0.010750920480216,     0.009691856034645,
     0.008820928812789,     0.008092432325864,     0.007474277593733,     0.006943295099802,     0.006482349330175,     0.642128682761167,     0.136387507315276,     0.065791701007599,     0.041487453459769,     0.029806747150797,
     0.023094186586794,     0.018783679949692,     0.015799372947044,     0.013618389571183,     0.011958398208895,     0.010654441620680,     0.009604050125308,     0.008740377048890,     0.008018035636818,     0.007405167749497,
     0.006878774580199,     0.006421849504675,     0.640768090370889,     0.135731659719689,     0.065378312969141,     0.041190537573549,     0.029576741841362,     0.022907137491187,     0.018626365151065,     0.015663785199497,
     0.013499336714135,     0.011852332541799,     0.010558836805019,     0.009517046025267,     0.008660565807118,     0.007944326830248,     0.007336700094935,     0.006814856220362,     0.006361916484850,     0.639414035836555,
     0.135079931196949,     0.064967882620389,     0.040895912414131,     0.029348599179692,     0.022721654783977,     0.018470400294909,     0.015529382693134,     0.013381339747985,     0.011747218585927,     0.010464098052054,
     0.009430836363589,     0.008581488240657,     0.007871299514271,     0.007268868636701,     0.006751534378917,     0.006302544942416,     0.638066478114941,     0.134432292284384,     0.064560387146947,     0.040603559433133,
     0.029122303569202,     0.022537725024825,     0.018315773581447,     0.015396154916490,     0.013264389198791,     0.011643047720250,     0.010370217453970,     0.009345413837488,     0.008503137566311,     0.007798947356657,
     0.007201667437596,     0.006688803467521,     0.006243729599331,     0.636725376456310,     0.133788713746545,     0.064155803919126,     0.040313460237467,     0.028897839547125,     0.022355334890867,     0.018162473315548,
     0.015264091452405,     0.013148475678429,     0.011539811402456,     0.010277187175644,     0.009260771211696,     0.008425507063912,     0.007727264084267,     0.007135090616042,     0.006626657950365,     0.006185465227318,
     0.635390690402153,     0.133149166573358,     0.063754110490394,     0.040025596588011,     0.028675191783335,     0.022174471175672,     0.018010487905780,     0.015133181977178,     0.013033589883805,     0.011437501168223,
     0.010184999453970,     0.009176901317836,     0.008348590075730,     0.007656243482505,     0.007069132345559,     0.006565092343673,     0.006127746647395,     0.634062379782941,     0.132513621978310,     0.063355284595850,
     0.039739950398283,     0.028454345079198,     0.021995120788205,     0.017859805863488,     0.015003416259715,     0.012919722596085,     0.011336108630502,     0.010093646597195,     0.009093797053794,     0.008272380005889,
     0.007585879394765,     0.007003786854247,     0.006504101215216,     0.006070568729410,     0.632740404715900,     0.131882051396630,     0.062959304150697,     0.039456503733137,     0.028235284366414,     0.021817270751811,
     0.017710415801868,     0.014874784160694,     0.012806864679917,     0.011235625478807,     0.010003120984257,     0.009011451383112,     0.008196870319792,     0.007516165721888,     0.006939048424271,     0.006443679183823,
     0.006013926391579,     0.631424725602804,     0.131254426483505,     0.062566147248739,     0.039175238807461,     0.028017994705882,     0.021640908203196,     0.017562306435051,     0.014747275631730,     0.012695007082679,
     0.011136043478515,     0.009913415064134,     0.008929857334372,     0.008122054543548,     0.007447096421628,     0.006874911391354,     0.006383820918902,     0.005957814600028,     0.630115303127781,     0.130630719112294,
     0.062175792160887,     0.038896137984896,     0.027802461286573,     0.021466020391424,     0.017415466577204,     0.014620880714555,     0.012584140833715,     0.011037354470162,     0.009824521355194,     0.008849008000594,
     0.008047926263409,     0.007378665508114,     0.006811370144278,     0.006324521139962,     0.005902228368339,     0.628812098255143,     0.130010901372771,     0.061788217333676,     0.038619183776553,     0.027588669424408,
     0.021292594676922,     0.017269885141627,     0.014495589540202,     0.012474257043594,     0.010939550368757,     0.009736432444556,     0.008768896538637,     0.007974479125203,     0.007310867051325,     0.006748419124377,
     0.006265774616139,     0.005847162757106,     0.627515072227229,     0.129394945569369,     0.061403401387800,     0.038344358839758,     0.027376604561153,     0.021120618530490,     0.017125551139868,     0.014371392328192,
     0.012365346903362,     0.010842623163100,     0.009649140987455,     0.008689516168607,     0.007901706833782,     0.007243695176564,     0.006686052825049,     0.006207576165733,     0.005792612873485,     0.626224186562267,
     0.128782824219451,     0.061021323116651,     0.038071645976793,     0.027166252263316,     0.020950079532326,     0.016982453680841,     0.014248279385741,     0.012257401683814,     0.010746564915095,     0.009562639706608,
     0.008610860173268,     0.007829603152471,     0.007177144063944,     0.006624265791266,     0.006149920655738,     0.005738573870757,     0.624939403052256,     0.128174510051590,     0.060641961484881,     0.037801028133654,
     0.026957598221062,     0.020780965371056,     0.016840581969951,     0.014126241106957,     0.012150412734762,     0.010651367759089,     0.009476921391598,     0.008532921897460,     0.007758161902521,     0.007111207947872,
     0.006563052619088,     0.006092803001390,     0.005685040947890,     0.623660683760858,     0.127569976003860,     0.060265295626966,     0.037532488398824,     0.026750628247130,     0.020613263842774,     0.016699925308232,
     0.014005267972059,     0.012044371484314,     0.010557023901198,     0.009391978898246,     0.008455694747524,     0.007687376962570,     0.007045881116540,     0.006502407955182,     0.006036218165705,     0.005632009349112,
     0.622387991021315,     0.126969195222147,     0.059891304845793,     0.037266010002049,     0.026545328275766,     0.020446962850086,     0.016560473091488,     0.013885350546598,     0.011939269438161,     0.010463525618654,
     0.009307805148010,     0.008379172190729,     0.007617242268108,     0.006981157911424,     0.006442326496349,     0.005980161159035,     0.005579474363475,     0.621121287434378,     0.126372141058473,     0.059519968611248,
     0.037001576313131,     0.026341684361661,     0.020282050401172,     0.016422214809444,     0.013766479480681,     0.011835098178871,     0.010370865259146,     0.009224393127369,     0.008303347754710,     0.007547751810946,
     0.006917032726780,     0.006382802989052,     0.005924627038619,     0.005527431324440,     0.619860535866253,     0.125778787069333,     0.059151266558824,     0.036739170840725,     0.026139682678899,     0.020118514608849,
     0.016285140044905,     0.013648645508210,     0.011731849365184,     0.010279035240179,     0.009141735887228,     0.008228215026900,     0.007478899638689,     0.006853500009158,     0.006323832228948,     0.005869610908138,
     0.005475875609450,     0.618605699446567,     0.125189107014042,     0.058785178488239,     0.036478777231153,     0.025939309519918,     0.019956343689642,     0.016149238472921,     0.013531839446120,     0.011629514731318,
     0.010188028048425,     0.009059826542321,     0.008153767653983,     0.007410679854217,     0.006790554256902,     0.006265409060429,     0.005815107917284,     0.005424802639518,     0.617356741566346,     0.124603074853105,
     0.058421684362064,     0.036220379267227,     0.025740551294476,     0.019795525962870,     0.016014499859960,     0.013416052193629,     0.011528086086282,     0.010097836239095,     0.008978658270621,     0.008079999341337,
     0.007343086615173,     0.006728190019673,     0.006207528376158,     0.005761113261322,     0.005374207878817,     0.616113625876012,     0.124020664746590,     0.058060764304363,     0.035963960867078,     0.025543394528626,
     0.019636049849733,     0.015880914063089,     0.013301274731496,     0.011427555313192,     0.010008452435306,     0.008898224312755,     0.008006903852494,     0.007276114133444,     0.006666401897968,     0.006150185116623,
     0.005707622180659,     0.005324086834268,     0.614876316283395,     0.123441851052526,     0.057702398599350,     0.035709506082998,     0.025347825863706,     0.019477903872409,     0.015748471029166,     0.013187498121278,
     0.011327914368597,     0.009919869327458,     0.008818517971428,     0.007934475008598,     0.007209756674664,     0.006605184542638,     0.006093374269682,     0.005654629960423,     0.005274435055137,     0.613644776951761,
     0.122866608325302,     0.057346567690047,     0.035456999100295,     0.025153832055329,     0.019321076653163,     0.015617160794027,     0.013074713504606,     0.011229155281807,     0.009832079672615,     0.008739532610846,
     0.007862706687868,     0.007144008557707,     0.006544532654421,     0.006037090870120,     0.005602131930038,     0.005225248132637,     0.612418972297857,     0.122294911314089,     0.056993252176963,     0.035206424236152,
     0.024961399972389,     0.019165556913462,     0.015486973481701,     0.012962912102453,     0.011131270154231,     0.009745076293895,     0.008661261656150,     0.007791592825071,     0.007078864154190,     0.006484440983478,
     0.005981329999209,     0.005550123462810,     0.005176521699528,     0.611198866989972,     0.121726734961270,     0.056642432816783,     0.034957765938504,     0.024770516596073,     0.019011333473091,     0.015357899303607,
     0.012852085214422,     0.011034251158720,     0.009658852079861,     0.008583698592855,     0.007721127410998,     0.007014317887988,     0.006424904328922,     0.005926086784269,     0.005498599975508,     0.005128251429730,
     0.609984425946011,     0.121162054400889,     0.056294090521061,     0.034711008784913,     0.024581169018882,     0.018858395249291,     0.015229928557782,     0.012742224218034,     0.010938090538914,     0.009573399983922,
     0.008506836966286,     0.007651304491941,     0.006950364234737,     0.006365917538368,     0.005871356398237,     0.005447556927960,     0.005080433037927,     0.608775614331587,     0.120600844957101,     0.055948206354932,
     0.034466137481465,     0.024393344443663,     0.018706731255891,     0.015103051628100,     0.012633320568020,     0.010842780608596,     0.009488713023738,     0.008430670381034,     0.007582118169176,     0.006886997721360,
     0.006307475507473,     0.005817134059240,     0.005396989822644,     0.005033062279187,     0.607572397558126,     0.120043082142650,     0.055604761535833,     0.034223136861671,     0.024207030182642,     0.018556330602455,
     0.014977258983504,     0.012525365795627,     0.010748313751056,     0.009404784280626,     0.008355192500402,     0.007513562598460,     0.006824212925583,     0.006249573179488,     0.005763415030166,     0.005346894204287,
     0.004986134948578,     0.606374741280990,     0.119488741657349,     0.055263737432234,     0.033981991885375,     0.024022213656476,     0.018407182493436,     0.014852541177247,     0.012418351507923,     0.010654682418453,
     0.009321606898982,     0.008280397045865,     0.007445631989518,     0.006762004475465,     0.006192205544817,     0.005710194618247,     0.005297265659467,     0.004939646880792,     0.605182611397617,     0.118937799386576,
     0.054925115562378,     0.033742687637676,     0.023838882393307,     0.018259276227336,     0.014728888846131,     0.012312269387114,     0.010561879131189,     0.009239174085698,     0.008206277796534,     0.007378320605545,
     0.006700367048924,     0.006135367640567,     0.005657468174643,     0.005248099816219,     0.004893593949768,     0.603995974045666,     0.118390231399783,     0.054588877593034,     0.033505209327861,     0.023657024027824,
     0.018112601195873,     0.014606292709767,     0.012207111189863,     0.010469896477288,     0.009157479109586,     0.008132828588623,     0.007311622762709,     0.006639295373279,     0.006079054550119,     0.005605231094025,
     0.005199392343644,     0.004847972068322,     0.602814795601189,     0.117846013949016,     0.054255005338266,     0.033269542288338,     0.023476626300337,     0.017967146883161,     0.014484743569829,     0.012102868746615,
     0.010378727111779,     0.009076515300817,     0.008060043314920,     0.007245532829661,     0.006578784224783,     0.006023261402689,     0.005553478814173,     0.005151138951521,     0.004802777187781,     0.601639042676809,
     0.117305123467451,     0.053923480758199,     0.033035671973589,     0.023297677055856,     0.017822902864888,     0.014364232309318,     0.011999533960935,     0.010288363756084,     0.008996276050351,     0.007987915924267,
     0.007180045227046,     0.006518828428172,     0.005967983372903,     0.005502206815564,     0.005103335389925,     0.004758005297619,     0.600468682119919,     0.116767536567936,     0.053594285957807,     0.032803583959127,
     0.023120164243180,     0.017679858807507,     0.014244749891839,     0.011897098808843,     0.010198799197414,     0.008916754809380,     0.007916440421043,     0.007115154427020,     0.006459422856206,     0.005913215680369,
     0.005451410620977,     0.005055977448847,     0.004713652425093,     0.599303681010892,     0.116233230041550,     0.053267403185710,     0.032573263940459,     0.022944075913992,     0.017538004467438,     0.014126287360878,
     0.011795555338162,     0.010110026288169,     0.008837945088780,     0.007845610864646,     0.007050854952777,     0.006400562429231,     0.005858953589259,     0.005401085795091,     0.005009060957819,     0.004669714634893,
     0.598144006661304,     0.115702180856173,     0.052942814832976,     0.032344697732067,     0.022769400221965,     0.017397329690268,     0.014008835839083,     0.011694895667866,     0.010022037945344,     0.008759840458557,
     0.007775421368994,     0.006987141378066,     0.006342242114727,     0.005805192407889,     0.005351227944096,     0.004962581785540,     0.004626188028780,     0.596989626612174,     0.115174366155067,     0.052620503431939,
     0.032117871266391,     0.022596125421873,     0.017257824409964,     0.013892386527562,     0.011595111987438,     0.009934827149941,     0.008682434547310,     0.007705866102013,     0.006924008326732,     0.006284456926872,
     0.005751927488307,     0.005301832715297,     0.004916535839506,     0.004583068745243,     0.595840508632217,     0.114649763255469,     0.052300451655021,     0.031892770592818,     0.022424239868714,     0.017119478648094,
     0.013776930705178,     0.011496196556234,     0.009848386946385,     0.008605721041689,     0.007636939285142,     0.006861450472243,     0.006227201926108,     0.005699154225886,     0.005252895796736,     0.004870919065647,
     0.004540352959146,     0.594696620716112,     0.114128349647197,     0.051982642313571,     0.031669381876690,     0.022253732016832,     0.016982282513052,     0.013662459727852,     0.011398141702853,     0.009762710441947,
     0.008529693685865,     0.007568635192842,     0.006799462537237,     0.006170472218708,     0.005646868058915,     0.005204412916801,     0.004825727447966,     0.004498036881390,     0.593557931082784,     0.113610102991264,
     0.051667058356708,     0.031447691398312,     0.022084590419058,     0.016846226199288,     0.013548965027878,     0.011300939824507,     0.009677790806171,     0.008454346281000,     0.007500948152100,     0.006738039293057,
     0.006114262956347,     0.005595064468198,     0.005156379843854,     0.004780957008174,     0.004456116758569,     0.592424408173696,     0.113095001118510,     0.051353682870177,     0.031227685551971,     0.021916803725852,
     0.016711299986552,     0.013436438113235,     0.011204583386404,     0.009593621270305,     0.008379672684726,     0.007433872541951,     0.006677175559309,     0.006058569335684,     0.005543738976659,     0.005108792385852,
     0.004736603805342,     0.004414588872633,     0.591296020651157,     0.112583022028237,     0.051042499075216,     0.031009350844966,     0.021750360684452,     0.016577494239137,     0.013324870566915,     0.011109064921133,
     0.009510195126742,     0.008305666810629,     0.007367402792993,     0.006616866203406,     0.006003386597939,     0.005492887148945,     0.005061646389975,     0.004692663935545,     0.004373449540556,     0.590172737396653,
     0.112074143886863,     0.050733490327428,     0.030792673896643,     0.021585250138034,     0.016444799405136,     0.013214254046246,     0.011014377028058,     0.009427505728461,     0.008232322627729,     0.007301533386913,
     0.006557106140128,     0.005948710028477,     0.005442504591037,     0.005014937742259,     0.004649133531516,     0.004332695114001,     0.589054527509168,     0.111568345026583,     0.050426640115665,     0.030577641437438,
     0.021421461024876,     0.016313206015698,     0.013104580282235,     0.010920512372710,     0.009345546488476,     0.008159634159979,     0.007236258856014,     0.006497890331183,     0.005894534956400,     0.005392586949862,
     0.004968662367232,     0.004606008762297,     0.004292321978999,     0.587941360303546,     0.111065603944041,     0.050121932060925,     0.030364240307936,     0.021258982377535,     0.016182704684297,     0.012995841078903,
     0.010827463686192,     0.009264310879289,     0.008087595485756,     0.007171573782752,     0.006439213784772,     0.005840856754137,     0.005343129912912,     0.004922816227551,     0.004563285832901,     0.004252326555618,
     0.586833205308847,     0.110565899299016,     0.049819349915253,     0.030152457457925,     0.021097803322022,     0.016053286106005,     0.012888028312635,     0.010735223764589,     0.009183792432348,     0.008016200737364,
     0.007107472799268,     0.006381071555154,     0.005787670837040,     0.005294129207862,     0.004877395323643,     0.004520960983971,     0.004212705297645,     0.585730032266720,     0.110069209913113,     0.049518877560654,
     0.029942279945471,     0.020937913076994,     0.015924941056768,     0.012781133931534,     0.010643785468378,     0.009103984737509,     0.007945444100539,     0.007043950586932,     0.006323458742225,     0.005734972662986,
     0.005245580602198,     0.004832395693354,     0.004479030491443,     0.004173454692266,     0.584631811129798,     0.109575514768477,     0.049220499008013,     0.029733694935992,     0.020779300952945,     0.015797660392701,
     0.012675149954776,     0.010553141721846,     0.009024881442508,     0.007875319813959,     0.006981001875889,     0.006266370491089,     0.005682757731980,     0.005197479902838,     0.004787813411594,     0.004437490666219,
     0.004134571259752,     0.583538512060093,     0.109084793006498,     0.048924198396029,     0.029526689701347,     0.020621956351413,     0.015671435049368,     0.012570068471980,     0.010463285512518,     0.008946476252431,
     0.007805822168760,     0.006918621444610,     0.006209801991641,     0.005631021585759,     0.005149822955769,     0.004743644589991,     0.004396337853832,     0.004096051553143,     0.582450105427412,     0.108597023926550,
     0.048629959990157,     0.029321251618926,     0.020465868764183,     0.015546256041091,     0.012465881642574,     0.010374209890581,     0.008868762929191,     0.007736945508052,     0.006856804119441,     0.006153748478152,
     0.005579759807412,     0.005102605645681,     0.004699885376546,     0.004355568434122,     0.004057892157946,     0.581366561807785,     0.108112186984718,     0.048337768181548,     0.029117368170755,     0.020311027772508,
     0.015422114460250,     0.012362581695176,     0.010285907968323,     0.008791735291012,     0.007668684226444,     0.006795544774171,     0.006098205228858,     0.005528968020983,     0.005055823895602,     0.004656531955290,
     0.004315178820913,     0.004020089691818,     0.580287851981903,     0.107630261792556,     0.048047607486020,     0.028915026942601,     0.020157423046329,     0.015299001476597,     0.012260160926970,     0.010198372919570,
     0.008715387211918,     0.007601032769572,     0.006734838329582,     0.006043167565549,     0.005478641891101,     0.005009473666540,     0.004613580545951,     0.004275165461694,     0.003982640804271,     0.579213946933566,
     0.107151228115836,     0.047759462543012,     0.028714215623093,     0.020005044343506,     0.015176908336571,     0.012158611703097,     0.010111597979130,     0.008639712621223,     0.007533985633630,     0.006674679753028,
     0.005988630853169,     0.005428777122591,     0.004963550957130,     0.004571027403611,     0.004235524837299,     0.003945542176369,     0.578144817848155,     0.106675065873327,     0.047473318114571,     0.028514922002846,
     0.019853881509053,     0.015055826362620,     0.012057926456048,     0.010025576442243,     0.008564705503027,     0.007467537364911,     0.006615064057995,     0.005934590499414,     0.005379369460110,     0.004918051803281,
     0.004528868818380,     0.004196253461597,     0.003908790520425,     0.577080436111101,     0.106201755135564,     0.047189159084330,     0.028317133973589,     0.019703924474382,     0.014935746952537,     0.011958097685063,
     0.009940301664039,     0.008490359895720,     0.007401682559340,     0.006555986303682,     0.005881041954337,     0.005330414687768,     0.004872972277826,     0.004487101115065,     0.004157347881177,     0.003872382579714,
     0.576020773306375,     0.105731276123646,     0.046906970456501,     0.028120839527311,     0.019555163256556,     0.014816661578788,     0.011859117955530,     0.009855767058991,     0.008416669891485,     0.007336415862025,
     0.006497441594577,     0.005827980709952,     0.005281908628765,     0.004828308490180,     0.004445720652845,     0.004118804675042,     0.003836315128175,     0.574965801214990,     0.105263609208027,     0.046626737354880,
     0.027926026755405,     0.019407587957539,     0.014698561787859,     0.011760979898401,     0.009771966100386,     0.008343629635811,     0.007271731966805,     0.006439425080040,     0.005775402299849,     0.005233847145024,
     0.004784056585992,     0.004404723824950,     0.004080620454305,     0.003800584970122,     0.573915491813514,     0.104798734907332,     0.046348445021856,     0.027732683847820,     0.019261188763464,     0.014581439199599,
     0.011663676209602,     0.009688892319791,     0.008271233327007,     0.007207625615801,     0.006381931953888,     0.005723302298804,     0.005186226136832,     0.004740212746814,     0.004364107058335,     0.004042791861883,
     0.003765188939960,     0.572869817272591,     0.104336633887174,     0.046072078817428,     0.027540799092229,     0.019115955943904,     0.014465285506578,     0.011567199649454,     0.009606539306527,     0.008199475215720,
     0.007144091598978,     0.006324957453986,     0.005671676322403,     0.005139041542484,     0.004696773189757,     0.004323866813373,     0.004005315572202,     0.003730123901898,     0.571828749955480,     0.103877286958979,
     0.045797624218233,     0.027350360873195,     0.018971879851141,     0.014350092473441,     0.011471543042099,     0.009524900707149,     0.008128349604461,     0.007081124753700,     0.006268496861842,     0.005620520026659,
     0.005092289337926,     0.004653734167166,     0.004283999583533,     0.003968188290896,     0.003695386749669,     0.570792262416601,     0.103420675078830,     0.045525066816584,     0.027161357671345,     0.018828950919456,
     0.014235851936276,     0.011376699274927,     0.009443970224930,     0.008057850847131,     0.007018719964304,     0.006212545502202,     0.005569829107639,     0.005045965536406,     0.004611091966285,     0.004244501895075,
     0.003931406754516,     0.003660974406250,     0.569760327400094,     0.102966779346312,     0.045254392319507,     0.026973778062559,     0.018687159664414,     0.014122555801982,     0.011282661298017,     0.009363741619350,
     0.007987973348557,     0.006956872161661,     0.006157098742652,     0.005519599301091,     0.005000066188126,     0.004568842908934,     0.004205370306739,     0.003894967730238,     0.003626883823588,     0.568732917838391,
     0.102515581003368,     0.044985586547798,     0.026787610717157,     0.018546496682158,     0.014010196047648,     0.011189422123573,     0.009284208705585,     0.007918711564024,     0.006895576322755,     0.006102151993226,
     0.005469826382080,     0.004954587379899,     0.004526983351184,     0.004166601409442,     0.003858868015576,     0.003593111982324,     0.567710006850800,     0.102067061433171,     0.044718635435083,     0.026602844399096,
     0.018406952648713,     0.013898764719930,     0.011096974825371,     0.009205365354010,     0.007850059998819,     0.006834827470260,     0.006047700706010,     0.005420506164620,     0.004909525234807,     0.004485509683036,
     0.004128191825974,     0.003823104438093,     0.003559655891525,     0.566691567742090,     0.101621202158997,     0.044453525026879,     0.026419467965178,     0.018268518319293,     0.013788253934443,     0.011005312538208,
     0.009127205489700,     0.007782013207776,     0.006774620672120,     0.005993740374757,     0.005371634501314,     0.004864875911865,     0.004444418328107,     0.004090138210702,     0.003787673855123,     0.003526512588412,
     0.565677574001107,     0.101177984843109,     0.044190241479679,     0.026237470364259,     0.018131184527611,     0.013678655875151,     0.010914428457361,     0.009049723091933,     0.007714565794824,     0.006714951041133,
     0.005940266534504,     0.005323207282997,     0.004820635605682,     0.004403705743313,     0.004052437249270,     0.003752573153485,     0.003493679138097,     0.564667999299382,     0.100737391285657,     0.043928771060027,
     0.026056840636470,     0.017994942185204,     0.013569962793764,     0.010824315838044,     0.008972912193706,     0.007647712412544,     0.006655813734544,     0.005887274761189,     0.005275220438382,     0.004776800546135,
     0.004363368418557,     0.004015085658311,     0.003717799249212,     0.003461152633319,     0.563662817489758,     0.100299403423577,     0.043669100143614,     0.025877567912437,     0.017859782280754,     0.013462167009143,
     0.010734967994874,     0.008896766881249,     0.007581447761719,     0.006597203953636,     0.005834760671274,     0.005227669933707,     0.004733366998039,     0.004323402876424,     0.003978080185148,     0.003683349087270,
     0.003428930194182,     0.562662002605032,     0.099864003329506,     0.043411215214375,     0.025699641412519,     0.017725695879421,     0.013355260906708,     0.010646378301342,     0.008821281293544,     0.007515766590907,
     0.006539116943323,     0.005782719921375,     0.005180551772389,     0.004690331260818,     0.004283805671872,     0.003941417607515,     0.003649219641289,     0.003397008967900,     0.561665528856598,     0.099431173210706,
     0.043155102863595,     0.025523050446043,     0.017592674122182,     0.013249236937851,     0.010558540189289,     0.008746449621850,     0.007450663695995,     0.006481547991758,     0.005731148207885,     0.005133861994679,
     0.004647689668189,     0.004244573391932,     0.003905094733265,     0.003615407913292,     0.003365386128537,     0.560673370633112,     0.099000895407992,     0.042900749789027,     0.025347784410550,     0.017460708225170,
     0.013144087619358,     0.010471447148381,     0.008672266109234,     0.007386133919777,     0.006424492429929,     0.005680041266617,     0.005087596677321,     0.004605438587838,     0.004205702655407,     0.003869108400092,
     0.003581910933429,     0.003334058876755,     0.559685502499155,     0.098573152394672,     0.042648142794007,     0.025173832791045,     0.017329789479029,     0.013039805532830,     0.010385092725598,     0.008598725050100,
     0.007322172151524,     0.006367945631273,     0.005629394872432,     0.005041751933214,     0.004563574421106,     0.004167190112573,     0.003833455475246,     0.003548725759711,     0.003303024439563,     0.558701899193919,
     0.098147926775498,     0.042397268786590,     0.025001185159260,     0.017199909248261,     0.012936383324113,     0.010299470524722,     0.008525820789731,     0.007258773326561,     0.006311903011282,     0.005579204838884,
     0.004996323911075,     0.004522093602673,     0.004129032444889,     0.003798132855262,     0.003515849477748,     0.003272280070071,     0.557722535629895,     0.097725201285620,     0.042148114778680,     0.024829831172911,
     0.017071058970596,     0.012833813702735,     0.010214574205827,     0.008453547723826,     0.007195932425850,     0.006256360027124,     0.005529467017861,     0.004951308795111,     0.004480992600253,     0.004091226364703,
     0.003763137465679,     0.003483279200490,     0.003241823047238,     0.556747386891575,     0.097304958789554,     0.041900667885180,     0.024659760574978,     0.016943230156347,     0.012732089441343,     0.010130397484784,
     0.008381900298050,     0.007133644475575,     0.006201312177255,     0.005480177299233,     0.004906702804686,     0.004440267914281,     0.004053768614963,     0.003728466260772,     0.003451012067969,     0.003211650675634,
     0.555776428234163,     0.096887182280156,     0.041654915323137,     0.024490963192973,     0.016816414387792,     0.012631203375148,     0.010046934132754,     0.008310873007581,     0.007071904546731,     0.006146755001044,
     0.005431331610505,     0.004862502193998,     0.004399916077612,     0.004016655968932,     0.003694116223283,     0.003419045247043,     0.003181760285193,     0.554809635082297,     0.096471854877603,     0.041410844410905,
     0.024323428938232,     0.016690603318543,     0.012531148401377,     0.009964177975705,     0.008240460396665,     0.007010707754714,     0.006092684078400,     0.005382925916462,     0.004818703251756,     0.004359933655216,
     0.003979885229906,     0.003660084364151,     0.003387375931147,     0.003152149230977,     0.553846983028780,     0.096058959828387,     0.041168442567309,     0.024157147805198,     0.016565788672934,     0.012431917478723,
     0.009882122893918,     0.008170657058171,     0.006950049258922,     0.006039095029397,     0.005334956218836,     0.004775302300860,     0.004320317243883,     0.003943453230928,     0.003626367722247,     0.003356001340039,
     0.003122814892939,     0.552888447833326,     0.095648480504311,     0.040927697310815,     0.023992109870721,     0.016441962245406,     0.012333503626807,     0.009800762821502,     0.008101457633160,     0.006889924262352,
     0.005985983513911,     0.005287418555955,     0.004732295698084,     0.004281063471925,     0.003907356834518,     0.003592963364118,     0.003324918719555,     0.003093754675686,     0.551934005421304,     0.095240400401501,
     0.040688596258713,     0.023828305293357,     0.016319115899902,     0.012235899925642,     0.009720091745919,     0.008032856810444,     0.006830328011205,     0.005933345231251,     0.005240309002416,     0.004689679833762,
     0.004242168998882,     0.003871592932390,     0.003559868383718,     0.003294125341362,     0.003064966008246,     0.550983631882507,     0.094834703139416,     0.040451127126301,     0.023665724312681,     0.016197241569264,
     0.012139099515104,     0.009640103707504,     0.007964849326159,     0.006771255794494,     0.005881175919801,     0.005193623668744,     0.004647451131478,     0.004203630515231,     0.003836158445184,     0.003527079902161,
     0.003263618502716,     0.003036446343841,     0.550037303469920,     0.094431372459878,     0.040215277726080,     0.023504357248593,     0.016076331254640,     0.012043095594398,     0.009560792798996,     0.007897429963339,
     0.006712702943652,     0.005829471356660,     0.005147358701062,     0.004605606047759,     0.004165444742101,     0.003801050322193,     0.003494595067460,     0.003233395526220,     0.003008193159657,     0.549094996598503,
     0.094030392226101,     0.039981035966951,     0.023344194500646,     0.015956377024890,     0.011947881421547,     0.009482153165072,     0.007830593551493,     0.006654664832152,     0.005778227357292,     0.005101510280766,
     0.004564141071766,     0.004127608430984,     0.003766265541099,     0.003462411054273,     0.003203453759588,     0.002980203956614,     0.548156687843980,     0.093631746421731,     0.039748389853427,     0.023185226547366,
     0.015837371016002,     0.011853450312867,     0.009404179001883,     0.007764334966186,     0.006597136875120,     0.005727439775170,     0.005056074624199,     0.004523052724997,     0.004090118363456,     0.003731801107702,
     0.003430525063662,     0.003173790575405,     0.002952476259148,     0.547222353941640,     0.093235419149893,     0.039517327484841,     0.023027443945588,     0.015719305430511,     0.011759795642456,     0.009326864556595,
     0.007698649128626,     0.006540114528958,     0.005677104501430,     0.005011047982327,     0.004482337560984,     0.004052971350895,     0.003697654055663,     0.003398934322836,     0.003144403370897,     0.002925007614986,
     0.546291971785148,     0.092841394632250,     0.039287837054570,     0.022870837329790,     0.015602172536927,     0.011666910841688,     0.009250204126935,     0.007633531005251,     0.006483593290973,     0.005627217464527,
     0.004966426640423,     0.004441992164996,     0.004016164234204,     0.003663821446239,     0.003367636084909,     0.003115289567695,     0.002897795594927,     0.545365518425363,     0.092449657208062,     0.039059906849262,
     0.022715397411438,     0.015485964669158,     0.011574789398711,     0.009174192060743,     0.007568975607324,     0.006427568698998,     0.005577774629894,     0.004922206917748,     0.004402013153750,     0.003979693883536,
     0.003630300368028,     0.003336627628661,     0.003086446611608,     0.002870837792623,     0.544442971069168,     0.092060191333261,     0.038833525248066,     0.022561114978332,     0.015370674225951,     0.011483424857942,
     0.009098822755523,     0.007504977990529,     0.006372036331031,     0.005528771999602,     0.004878385167243,     0.004362397175112,     0.003943557198023,     0.003597087936715,     0.003305906258290,     0.003057871972398,
     0.002844131824365,     0.543524307078307,     0.091672981579528,     0.038608680721874,     0.022407980893967,     0.015256293670330,     0.011392810819580,     0.009024090658001,     0.007441533254568,     0.006316991804867,
     0.005480205612025,     0.004834957775212,     0.004323140907816,     0.003907751105506,     0.003564181294815,     0.003275469303181,     0.003029563143548,     0.002817675328869,     0.542609503968232,     0.091288012633377,
     0.038385361832570,     0.022255986096885,     0.015142815529040,     0.011302940939110,     0.008949990263689,     0.007378636542772,     0.006262430777738,     0.005432071541508,     0.004791921161021,     0.004284241061174,
     0.003872272562268,     0.003531577611423,     0.003245314117664,     0.003001517642044,     0.002791465967064,     0.541698539406959,     0.090905269295256,     0.038163557232277,     0.022105121600046,     0.015030232391994,
     0.011213808926822,     0.008876516116448,     0.007316283041700,     0.006208348945951,     0.005384365898041,     0.004749271776791,     0.004245694374794,     0.003837118552768,     0.003499274081969,     0.003215438080784,
     0.002973733008153,     0.002765501421882,     0.540791391213934,     0.090524736478640,     0.037943255662621,     0.021955378490196,     0.014918536911733,     0.011125408547324,     0.008803662808059,     0.007254467980756,
     0.006154742044539,     0.005337084826928,     0.004707006107095,     0.004207497618301,     0.003802286089380,     0.003467267927969,     0.003185838596067,     0.002946206805204,     0.002739779398053,     0.539888037358908,
     0.090146399209143,     0.037724445953992,     0.021806747927247,     0.014807721802882,     0.011037733619072,     0.008731424977798,     0.007193186631801,     0.006101605846907,     0.005290224508465,     0.004665120668664,
     0.004169647591056,     0.003767772212135,     0.003435556396783,     0.003156513091292,     0.002918936619369,     0.002714297621893,     0.538988455960817,     0.089770242623638,     0.037507117024819,     0.021659221143653,
     0.014697779841614,     0.010950778013892,     0.008659797312008,     0.007132434308771,     0.006048936164482,     0.005243781157625,     0.004623612010084,     0.004132141121883,     0.003733573988461,     0.003404136761373,
     0.003127459018262,     0.002891920059451,     0.002689053841110,     0.538092625286677,     0.089396251969373,     0.037291257880848,     0.021512789443805,     0.014588703865118,     0.010864535656512,     0.008588774543688,
     0.007072206367301,     0.005996728846369,     0.005197751023734,     0.004582476711509,     0.004094975068796,     0.003699688512930,     0.003373006320063,     0.003098673852582,     0.002865154756668,     0.002664045824593,
     0.537200523750482,     0.089024412603105,     0.037076857614420,     0.021367444203416,     0.014480486771073,     0.010779000524101,     0.008518351452072,     0.007012498204346,     0.005944979779010,     0.005152130390160,
     0.004541711384368,     0.004058146318729,     0.003666112907004,     0.003342162396303,     0.003070155093430,     0.002838638364447,     0.002639271362218,     0.536312129912115,     0.088654709990241,     0.036863905403767,
     0.021223176868923,     0.014373121517128,     0.010694166645803,     0.008448522862218,     0.006953305257811,     0.005893684885845,     0.005106915574004,     0.004501312671076,     0.004021651787266,     0.003632844318787,
     0.003311602338433,     0.003041900263342,     0.002812368558210,     0.002614728264648,     0.535427422476267,     0.088287129703975,     0.036652390512307,     0.021079978956890,     0.014266601120380,     0.010610028102287,
     0.008379283644604,     0.006894623006185,     0.005842840126974,     0.005062102925786,     0.004461277244750,     0.003985488418382,     0.003599879922775,     0.003281323519456,     0.003013906907991,     0.002786343035170,
     0.002590414363135,     0.534546380291358,     0.087921657424447,     0.036442302287942,     0.020937842053411,     0.014160918656866,     0.010526579025290,     0.008310628714720,     0.006836446968173,     0.005792441498827,
     0.005017688829144,     0.004421601808929,     0.003949653184171,     0.003567216919613,     0.003251323336798,     0.002986172595968,     0.002760559514124,     0.002566327509331,     0.533668982348479,     0.087558278937896,
     0.036233630162368,     0.020796757813533,     0.014056067261050,     0.010443813597171,     0.008242553032671,     0.006778772702335,     0.005742485033834,     0.004973669700530,     0.004382283097288,     0.003914143084594,
     0.003534852535849,     0.003221599212090,     0.002958694918570,     0.002735015735254,     0.002542465575090,     0.532795207780330,     0.087196980135830,     0.036026363650389,     0.020656717960663,     0.013952040125323,
     0.010361726050468,     0.008175051602777,     0.006721595806730,     0.005692966800097,     0.004930041988909,     0.004343317873366,     0.003878955147218,     0.003502784023695,     0.003192148590935,     0.002931471489586,
     0.002709709459920,     0.002518826452280,     0.531925035860173,     0.086837747014195,     0.035820492349235,     0.020517714286000,     0.013848830499501,     0.010280310667453,     0.008108119473182,     0.006664911918555,
     0.005643882901066,     0.004886802175463,     0.004304702930289,     0.003844086426959,     0.003471008660790,     0.003162968942686,     0.002904499945087,     0.002684638470466,     0.002495408052594,     0.531058446000791,
     0.086480565672555,     0.035616005937888,     0.020379738647957,     0.013746431690329,     0.010199561779703,     0.008041751735465,     0.006608716713801,     0.005595229475220,     0.004843946773295,     0.004266435090499,
     0.003809534005831,     0.003439523749958,     0.003134057760227,     0.002877777943216,     0.002659800570022,     0.002472208307365,     0.530195417753459,     0.086125422313280,     0.035412894176411,     0.020242782971600,
     0.013644837060993,     0.010119473767660,     0.007975943524251,     0.006553005906900,     0.005547002695750,     0.004801472327140,     0.004228511205482,     0.003775294992696,     0.003408326618981,     0.003105412559749,
     0.002851303163980,     0.002635193582304,     0.002449225167377,     0.529335930806915,     0.085772303240735,     0.035211146905287,     0.020106839248080,     0.013544040030632,     0.010040041060210,     0.007910690016830,
     0.006497775250377,     0.005499198770241,     0.004759375413072,     0.004190928155503,     0.003741366523013,     0.003377414620362,     0.003077030880535,     0.002825073309049,     0.002610815351425,     0.002426456602682,
     0.528479964986347,     0.085421194860481,     0.035010754044758,     0.019971899534082,     0.013444034073856,     0.009961258134250,     0.007845986432779,     0.006443020534513,     0.005451813940361,     0.004717652638221,
     0.004153682849341,     0.003707745758594,     0.003346785131095,     0.003048910284745,     0.002799086101550,     0.002586663741704,     0.002403900602422,     0.527627500252388,     0.085072083678482,     0.034811705594175,
     0.019837955951265,     0.013344812720266,     0.009883119514276,     0.007781828033583,     0.006388737587003,     0.005404844481556,     0.004676300640486,     0.004116772224024,     0.003674429887359,     0.003316435552442,
     0.003021048357200,     0.002773339285866,     0.002562736637471,     0.002381555174645,     0.526778516700109,     0.084724956300314,     0.034613991631349,     0.019705000685725,     0.013246369553983,     0.009805619771957,
     0.007718210122266,     0.006334922272619,     0.005358286702737,     0.004635316088257,     0.004080193244573,     0.003641416123095,     0.003286363309702,     0.002993442705173,     0.002747830627437,     0.002539031942882,
     0.002359418346131,     0.525932994558032,     0.084379799430385,     0.034417602311910,     0.019573025987440,     0.013148698213178,     0.009728753525728,     0.007655128043019,     0.006281570492879,     0.005312136945980,
     0.004594695680135,     0.004043942903744,     0.003608701705217,     0.003256565851991,     0.002966090958175,     0.002722557912566,     0.002515547581735,     0.002337488162208,     0.525090914187143,     0.084036599871163,
     0.034222527868672,     0.019442024169743,     0.013051792389604,     0.009652515440378,     0.007592577180837,     0.006228678185713,     0.005266391586228,     0.004554436144656,     0.004008018221768,     0.003576283898532,
     0.003227040652019,     0.002938990767755,     0.002697518948216,     0.002492281497279,     0.002315762686585,     0.524252256079918,     0.083695344522402,     0.034028758611000,     0.019311987608780,     0.012955645828137,
     0.009576900226641,     0.007530552961153,     0.006176241325143,     0.005221047030988,     0.004514534240015,     0.003972416246105,     0.003544159993000,     0.003197785205871,     0.002912139807287,     0.002672711561825,
     0.002469231652038,     0.002294240001176,     0.523417000859350,     0.083356020380382,     0.033836284924186,     0.019182908742987,     0.012860252326317,     0.009501902640799,     0.007469050849483,     0.006124255920949,
     0.005176099720036,     0.004474986753801,     0.003937134051190,     0.003512327303507,     0.003168797032792,     0.002885535771769,     0.002648133601108,     0.002446396027624,     0.002272918205924,     0.522585129277992,
     0.083018614537155,     0.033645097268829,     0.019054780072562,     0.012765605733895,     0.009427517484278,     0.007408066351066,     0.006072718018359,     0.005131546125131,     0.004435790502721,     0.003902168738186,
     0.003480783169629,     0.003140073674967,     0.002859176377622,     0.002623782933870,     0.002423772624561,     0.002251795418638,     0.521756622216998,     0.082683114179791,     0.033455186180219,     0.018927594158945,
     0.012671699952384,     0.009353739603256,     0.007347595010513,     0.006021623697719,     0.005087382749716,     0.004396942332341,     0.003867517434735,     0.003449524955409,     0.003111612697312,     0.002833059362490,
     0.002599657447817,     0.002401359462108,     0.002230869774819,     0.520931460685182,     0.082349506589638,     0.033266542267727,     0.018801343624307,     0.012578528934615,     0.009280563888267,     0.007287632411459,
     0.005970969074187,     0.005043606128638,     0.004358439116818,     0.003833177294720,     0.003418550049127,     0.003083411687261,     0.002807182485039,     0.002575755050368,     0.002379154578079,     0.002210139427498,
     0.520109625818075,     0.082017779141582,     0.033079156214201,     0.018676021151034,     0.012486086684289,     0.009207985273818,     0.007228174176211,     0.005920750297415,     0.005000212827859,     0.004320277758639,
     0.003799145498021,     0.003387855863075,     0.003055468254556,     0.002781543524766,     0.002552073668475,     0.002357156028670,     0.002189602547066,     0.519291098876994,     0.081687919303313,     0.032893018775368,
     0.018551619481222,     0.012394367255548,     0.009135998737999,     0.007169215965412,     0.005870963551243,     0.004957199444175,     0.004282455188364,     0.003765419250274,     0.003357439833341,     0.003027780031043,
     0.002756140281799,     0.002528611248433,     0.002335361888291,     0.002169257321112,     0.518475861248121,     0.081359914634607,     0.032708120779234,     0.018428131416176,     0.012303364752534,     0.009064599302104,
     0.007110753477695,     0.005821605053387,     0.004914562604940,     0.004244968364369,     0.003731995782637,     0.003327299419580,     0.003000344670463,     0.002730970576708,     0.002505365755706,     0.002313770249386,
     0.002149101954262,     0.517663894441577,     0.081033752786595,     0.032524453125501,     0.018305549815912,     0.012213073328963,     0.008993782030251,     0.007052782449349,     0.005772671055140,     0.004872298967783,
     0.004207814272592,     0.003698872351555,     0.003297432104806,     0.002973159848249,     0.002706032250314,     0.002482335174742,     0.002292379222272,     0.002129134668020,     0.516855180090524,     0.080709421501060,
     0.032342006784979,     0.018183867598661,     0.012123487187698,     0.008923542029011,     0.006995298653982,     0.005724157841069,     0.004830405220340,     0.004170989926280,     0.003666046238526,     0.003267835395167,
     0.002946223261327,     0.002681323163499,     0.002459517508797,     0.002271186934965,     0.002109353700602,     0.516049699950252,     0.080386908609722,     0.032160772799005,     0.018063077740383,     0.012034600580324,
     0.008853874447031,     0.006938297902193,     0.005676061728713,     0.004788878079975,     0.004134492365743,     0.003633514749873,     0.003238506819737,     0.002919532627914,     0.002656841197017,     0.002436910779760,
     0.002250191533017,     0.002089757306786,     0.515247435897289,     0.080066202033535,     0.031980742278870,     0.017943173274280,     0.011946407806730,     0.008784774474668,     0.006881776041239,     0.005628379068293,
     0.004747714293518,     0.004098318658101,     0.003601275216514,     0.003209443930302,     0.002893085687320,     0.002632584251315,     0.002414513027977,     0.002229391179349,     0.002070343757752,     0.514448369928509,
     0.079747289781997,     0.031801906405251,     0.017824147290315,     0.011858903214697,     0.008716237343628,     0.006825728954715,     0.005581106242413,     0.004706910636994,     0.004062465897047,     0.003569324993735,
     0.003180644301149,     0.002866880199754,     0.002608550246340,     0.002392322312080,     0.002208784054089,     0.002051111340928,     0.513652484160252,     0.079430159952451,     0.031624256427642,     0.017705992934736,
     0.011772081199482,     0.008648258326598,     0.006770152562230,     0.005534239665773,     0.004666463915358,     0.004026931202596,     0.003537661460970,     0.003152105528862,     0.002840913946128,     0.002584737121366,
     0.002370336708812,     0.002188368354413,     0.002032058359837,     0.512859760827448,     0.079114800729406,     0.031447783663795,     0.017588703409600,     0.011685936203412,     0.008580832736890,     0.006715042819084,
     0.005487775784880,     0.004626370962236,     0.003991711720852,     0.003506282021575,     0.003123825232111,     0.002815184727867,     0.002561142834808,     0.002348554312861,     0.002168142294377,     0.002013183133946,
     0.512070182282748,     0.078801200383852,     0.031272479499164,     0.017472271972312,     0.011600462715479,     0.008513955928087,     0.006660395715956,     0.005441711077763,     0.004586628639662,     0.003956804623766,
     0.003475184102610,     0.003095801051450,     0.002789690366715,     0.002537765364045,     0.002326973236692,     0.002148104104767,     0.001994483998514,     0.511283730995666,     0.078489347272590,     0.031098335386354,
     0.017356691935151,     0.011515655270940,     0.008447623293689,     0.006606207278589,     0.005396042053688,     0.004547233837823,     0.003922207108899,     0.003444365154621,     0.003068030649116,     0.002764428704548,
     0.002514602705243,     0.002305591610375,     0.002128252032937,     0.001975959304445,     0.510500389551718,     0.078179229837562,     0.030925342844577,     0.017241956664817,     0.011431508450918,     0.008381830266765,
     0.006552473567475,     0.005350765252880,     0.004508183474803,     0.003887916399193,     0.003413822651424,     0.003040511708825,     0.002739397603189,     0.002491652873182,     0.002284407581430,     0.002108584342654,
     0.001957607418138,     0.509720140651582,     0.077870836605185,     0.030753493459105,     0.017128059581968,     0.011348016882010,     0.008316572319606,     0.006499190677554,     0.005305877246246,     0.004469474496331,
     0.003853929742734,     0.003383554089890,     0.003013241935579,     0.002714594944220,     0.002468913901076,     0.002263419314652,     0.002089099313945,     0.001939426721345,     0.508942967110247,     0.077564156185697,
     0.030582778880738,     0.017014994160772,     0.011265175235894,     0.008251844963383,     0.006446354737902,     0.005261374635098,     0.004431103875530,     0.003820244412527,     0.003353556989737,     0.002986219055465,
     0.002690018628798,     0.002446383840410,     0.002242624991960,     0.002069795242941,     0.001921415611023,     0.508168851856189,     0.077259177272501,     0.030413190825266,     0.016902753928457,     0.011182978228944,
     0.008187643747807,     0.006393961911432,     0.005217254050879,     0.004393068612670,     0.003786857706263,     0.003323828893316,     0.002959440815459,     0.002665666577477,     0.002424060760762,     0.002222022812229,
     0.002050670441731,     0.001903572499190,     0.507397777930533,     0.076955888641521,     0.030244721072946,     0.016791332464865,     0.011101420621846,     0.008123964260793,     0.006342008394594,     0.005173512154897,
     0.004355365734920,     0.003753766946101,     0.003294367365404,     0.002932904983238,     0.002641536730023,     0.002401942749639,     0.002201610991135,     0.002031723238207,     0.001885895812787,     0.506629728486234,
     0.076654279150558,     0.030077361467972,     0.016680723402010,     0.011020497219218,     0.008060802128122,     0.006290490417074,     0.005130145638054,     0.004317992296109,     0.003720969478439,     0.003265169993000,
     0.002906609346985,     0.002617627045240,     0.002380027912305,     0.002181387760996,     0.002012951975920,     0.001868383993533,     0.505864686787267,     0.076354337738652,     0.029911103917963,     0.016570920423644,
     0.010940202869229,     0.007998153013115,     0.006239404241504,     0.005087151220580,     0.004280945376478,     0.003688462673695,     0.003236234385119,     0.002880551715200,     0.002593935500790,     0.002358314371621,
     0.002161351370617,     0.001994355013926,     0.001851035497789,     0.505102636207808,     0.076056053425454,     0.029745940393440,     0.016461917264817,     0.010860532463232,     0.007936012616304,     0.006188746163170,
     0.005044525651775,     0.004244222082447,     0.003656243926088,     0.003207558172588,     0.002854729916515,     0.002570460093020,     0.002336800267878,     0.002141500085137,     0.001975930726651,     0.001833848796418,
     0.504343560231439,     0.075759415310596,     0.029581862927321,     0.016353707711456,     0.010781480935389,     0.007874376675106,     0.006138512509716,     0.005002265709741,     0.004207819546375,     0.003624310653420,
     0.003179139007852,     0.002829141799504,     0.002547198836786,     0.002315483758633,     0.002121832185871,     0.001957677503734,     0.001816822374650,     0.503587442450347,     0.075464412573071,     0.029418863614410,
     0.016246285599932,     0.010703043262302,     0.007813240963498,     0.006088699640867,     0.004960368201130,     0.004171734926327,     0.003592660296861,     0.003150974564767,     0.002803785232499,     0.002524149765285,
     0.002294363018551,     0.002102345970167,     0.001939593749896,     0.001799954731945,     0.502834266564536,     0.075171034470616,     0.029256934610900,     0.016139644816637,     0.010625214462657,     0.007752601291705,
     0.006039303948135,     0.004918829960885,     0.004135965405839,     0.003561290320738,     0.003123062538411,     0.002778658103413,     0.002501310929881,     0.002273436239242,     0.002083039751246,     0.001921677884788,
     0.001783244381858,     0.502084016381040,     0.074879270339104,     0.029096068133869,     0.016033779297570,     0.010547989596852,     0.007692453505875,     0.005990321854547,     0.004877647851988,     0.004100508193689,
     0.003530198212319,     0.003095400644883,     0.002753758319552,     0.002478680399939,     0.002252701629108,     0.002063911858062,     0.001903928342860,     0.001766689851911,     0.501336675813148,     0.074589109591932,
     0.028936256460789,     0.015928683027919,     0.010471363766651,     0.007632793487772,     0.005941749814358,     0.004836818765207,     0.004065360523670,     0.003499381481610,     0.003067986621116,     0.002729083807441,
     0.002456256262654,     0.002232157413182,     0.002044960635149,     0.001886343573213,     0.001750289683456,     0.500592228879628,     0.074300541719424,     0.028777491929038,     0.015824350041647,     0.010395332114818,
     0.007573617154463,     0.005893584312778,     0.004796339618849,     0.004030519654359,     0.003468837661141,     0.003040818224679,     0.002704632512642,     0.002434036622891,     0.002211801832973,     0.002026184442480,
     0.001868922039470,     0.001734042431547,     0.499850659703963,     0.074013556288231,     0.028619766935409,     0.015720774421088,     0.010319889824776,     0.007514920458005,     0.005845821865698,     0.004756207358510,
     0.003995982868899,     0.003438564305767,     0.003013893233593,     0.002680402399585,     0.002412019603018,     0.002191633146315,     0.002007581655315,     0.001851662219633,     0.001717946664811,     0.499111952513592,
     0.073728142940743,     0.028463073935635,     0.015617950296538,     0.010245032120250,     0.007456699385149,     0.005798459019416,     0.004716418956836,     0.003961747474772,     0.003408558992459,     0.002987209446140,
     0.002656391451385,     0.002390203342741,     0.002171649627215,     0.001989150664068,     0.001834562605951,     0.001702000965319,     0.498376091639153,     0.073444291394498,     0.028307405443904,     0.015515871845857,
     0.010170754264927,     0.007398949957030,     0.005751492350370,     0.004676971413274,     0.003927810803582,     0.003378819320107,     0.002960764680679,     0.002632597669677,     0.002368585998950,     0.002151849565698,
     0.001970889874156,     0.001817621704786,     0.001686203928462,     0.497643061513733,     0.073161991441604,     0.028152754032393,     0.015414533294069,     0.010097051562113,     0.007341668228867,     0.005704918464873,
     0.004637861753838,     0.003894170210834,     0.003349342909314,     0.002934556775460,     0.002609019074440,     0.002347165745551,     0.002132231267662,     0.001952797705864,     0.001800838036480,     0.001670554162823,
     0.496912846672130,     0.072881232948157,     0.027999112330792,     0.015313928912968,     0.010023919354391,     0.007284850289670,     0.005658733998841,     0.004599087030868,     0.003860823075720,     0.003320127402206,
     0.002908583588443,     0.002585653703831,     0.002325940773315,     0.002112793054727,     0.001934872594205,     0.001784210135222,     0.001655050290050,     0.496185431750115,     0.072602005853672,     0.027846473025843,
     0.015214053020730,     0.009951353023285,     0.007228492261944,     0.005612935617542,     0.004560644322792,     0.003827766800902,     0.003291170462228,     0.002882842997116,     0.002562499614014,     0.002304909289717,
     0.002093533264092,     0.001917112988778,     0.001767736548922,     0.001639690944742,     0.495460801483694,     0.072324300170513,     0.027694828860873,     0.015114899981518,     0.009879347988931,     0.007172590301393,
     0.005567520015325,     0.004522530733898,     0.003794998812305,     0.003262469773957,     0.002857332898316,     0.002539554878996,     0.002284069518785,     0.002074450248385,     0.001899517353639,     0.001751415839079,
     0.001624474774318,     0.494738940708392,     0.072048105983329,     0.027544172635341,     0.015016464205105,     0.009807899709742,     0.007117140596633,     0.005522483915370,     0.004484743394098,     0.003762516558901,
     0.003234023042902,     0.002832051208050,     0.002516817590463,     0.002263419700941,     0.002055542375525,     0.001882084167160,     0.001735246580653,     0.001609400438898,     0.494019834358527,     0.071773413448497,
     0.027394497204383,     0.014918740146489,     0.009737003682079,     0.007062139368908,     0.005477824069431,     0.004447279458700,     0.003730317512504,     0.003205827995320,     0.002806995861323,     0.002494285857613,
     0.002242958092856,     0.002036808028573,     0.001864811921895,     0.001719227361943,     0.001594466611189,     0.493303467466497,     0.071500212793565,     0.027245795478358,     0.014821722305516,     0.009666655439932,
     0.007007582871801,     0.005433537257582,     0.004410136108179,     0.003698399167563,     0.003177882378020,     0.002782164811959,     0.002471957806999,     0.002222682967292,     0.002018245605596,     0.001847699124452,
     0.001703356784455,     0.001579671976358,     0.492589825162070,     0.071228494316702,     0.027098060422404,     0.014725405226505,     0.009596850554592,     0.006953467390952,     0.005389620287969,     0.004373310547956,
     0.003666759040955,     0.003150183958183,     0.002757556032431,     0.002449831582365,     0.002202592612956,     0.001999853519524,     0.001830744295355,     0.001687633462783,     0.001565015231922,     0.491878892671683,
     0.070958248386157,     0.026951285055998,     0.014629783497878,     0.009527584634337,     0.006899789243784,     0.005346069996558,     0.004336800008171,     0.003635394671785,     0.003122730523171,     0.002733167513691,
     0.002427905344489,     0.002182685334354,     0.001981630198015,     0.001813945968920,     0.001672056024484,     0.001550495087627,     0.491170655317741,     0.070689465439712,     0.026805462452510,     0.014534851751789,
     0.009458853324111,     0.006846544779218,     0.005302883246891,     0.004300601743461,     0.003604303621186,     0.003095519880344,     0.002708997264995,     0.002406177271027,     0.002162959451641,     0.001963574083312,
     0.001797302693121,     0.001656623109958,     0.001536110265334,     0.490465098517927,     0.070422135984147,     0.026660585738773,     0.014440604663762,     0.009390652305214,     0.006793730377407,     0.005260056929844,
     0.004264713032745,     0.003573483472116,     0.003068549856881,     0.002685043313743,     0.002384645556353,     0.002143413300478,     0.001945683632113,     0.001780813029466,     0.001641333372326,     0.001521859498907,
     0.489762207784512,     0.070156250594710,     0.026516648094651,     0.014347036952326,     0.009322977294987,     0.006741342449456,     0.005217587963382,     0.004229131179001,     0.003542931829163,     0.003041818299595,
     0.002661303705304,     0.002363308411410,     0.002124045231886,     0.001927957315434,     0.001764475552867,     0.001626185477309,     0.001507741534096,     0.489061968723676,     0.069891799914586,     0.026373642752606,
     0.014254143378660,     0.009255824046509,     0.006689377437157,     0.005175473292321,     0.004193853509056,     0.003512646318351,     0.003015323074757,     0.002637776502859,     0.002342164063554,     0.002104853612105,
     0.001910393618473,     0.001748288851518,     0.001611178103114,     0.001493755128430,     0.488364367034828,     0.069628774654375,     0.026231562997278,     0.014161918746232,     0.009189188348288,     0.006637831812723,
     0.005133709888090,     0.004158877373371,     0.003482624586944,     0.002989062067918,     0.002614459787233,     0.002321210756403,     0.002085836822455,     0.001892991040483,     0.001732251526768,     0.001596309940314,
     0.001479899051099,     0.487669388509938,     0.069367165591570,     0.026090402165063,     0.014070357900452,     0.009123066023957,     0.006586702078516,     0.005092294748496,     0.004124200145828,     0.003452864303253,
     0.002963033183731,     0.002591351656732,     0.002300446749685,     0.002066993259190,     0.001875748094636,     0.001716362192999,     0.001581579691730,     0.001466172082854,     0.486977019032866,     0.069106963570043,
     0.025950153643695,     0.013979455728316,     0.009057452931979,     0.006535984766794,     0.005051224897492,     0.004089819223519,     0.003423363156450,     0.002937234345782,     0.002568450226987,     0.002279870319096,
     0.002048321333366,     0.001858663307897,     0.001700619477504,     0.001566986072321,     0.001452573015888,     0.486287244578708,     0.068848159499536,     0.025810810871829,     0.013889207158065,     0.008992344965343,
     0.006485676439441,     0.005010497384943,     0.004055732026545,     0.003394118856377,     0.002911663496414,     0.002545753630793,     0.002259479756143,     0.002029819470701,     0.001841735220893,     0.001685022020367,
     0.001552527809064,     0.001439100653734,     0.485600051213129,     0.068590744355150,     0.025672367338635,     0.013799607158838,     0.008927738051275,     0.006435773687718,     0.004970109286402,     0.004021935997804,
     0.003365129133359,     0.002886318596557,     0.002523260017950,     0.002239273368005,     0.002011486111437,     0.001824962387787,     0.001669568474341,     0.001538203640849,     0.001425753811158,     0.484915425091725,
     0.068334709176843,     0.025534816583387,     0.013710650740331,     0.008863628150939,     0.006386273131999,     0.004930057702877,     0.003988428602788,     0.003336391738019,     0.002861197625557,     0.002500967555109,
     0.002219249477389,     0.001993319710209,     0.001808343376153,     0.001654257504732,     0.001524012318357,     0.001412531314053,     0.484233352459365,     0.068080045068931,     0.025398152195064,     0.013622332952461,
     0.008800011259154,     0.006337171421525,     0.004890339760610,     0.003955207329384,     0.003307904441095,     0.002836298581012,     0.002478874425618,     0.002199406422380,     0.001975318735908,     0.001791876766847,
     0.001639087789281,     0.001509952603961,     0.001399431999330,     0.483553819649558,     0.067826743199596,     0.025262367811941,     0.013534648885029,     0.008736883404101,     0.006288465234148,     0.004850952610853,
     0.003922269687671,     0.003279665033260,     0.002811619478603,     0.002456978829367,     0.002179742556306,     0.001957481671552,     0.001775561153888,     0.001624058018047,     0.001496023271605,     0.001386454714822,
     0.482876813083813,     0.067574794800390,     0.025127457121201,     0.013447593667389,     0.008674240647043,     0.006240151276083,     0.004811893429647,     0.003889613209723,     0.003251671324939,     0.002787158351928,
     0.002435278982636,     0.002160256247594,     0.001939807014153,     0.001759395144332,     0.001609166893292,     0.001482223106703,     0.001373598319173,     0.482202319271008,     0.067324191165750,     0.024993413858536,
     0.013361162468118,     0.008612079082037,     0.006192226281661,     0.004773159417602,     0.003857235449409,     0.003223921146133,     0.002762913252345,     0.002413773117948,     0.002140945879631,     0.001922293274589,
     0.001743377358154,     0.001594413129367,     0.001468550906028,     0.001360861681743,     0.481530324806767,     0.067074923652518,     0.024860231807757,     0.013275350494690,     0.008550394835660,     0.006144687013086,
     0.004734747799684,     0.003825133982206,     0.003196412346241,     0.002738882248802,     0.002392459483915,     0.002121809850628,     0.001904938977471,     0.001727506428122,     0.001579795452599,     0.001455005477608,
     0.001348243682502,     0.480860816372831,     0.066826983679456,     0.024727904800407,     0.013190152993150,     0.008489184066726,     0.006097530260192,     0.004696655824994,     0.003793306404995,     0.003169142793884,
     0.002715063427684,     0.002371336345097,     0.002102846573481,     0.001887742661022,     0.001711780999685,     0.001565312601178,     0.001441585640617,     0.001335743211933,     0.480193780736450,     0.066580362726774,
     0.024596426715378,     0.013105565247798,     0.008428442966016,     0.006050752840201,     0.004658880766559,     0.003761750335879,     0.003142110376735,     0.002691454892650,     0.002350401981850,     0.002084054475635,
     0.001870702876947,     0.001696199730849,     0.001550963325049,     0.001428290225272,     0.001323359170934,     0.479529204749764,     0.066335052335660,     0.024465791478527,     0.013021582580864,     0.008368167756001,
     0.006004351597487,     0.004621419921121,     0.003730463413990,     0.003115313001344,     0.002668054764477,     0.002329654690182,     0.002065431998952,     0.001853818190307,     0.001680761292063,     0.001536746385798,
     0.001415118072730,     0.001311090470716,     0.478867075349199,     0.066091044107807,     0.024335993062304,     0.012938200352199,     0.008308354690574,     0.005958323403337,     0.004584270608925,     0.003699443299298,
     0.003088748592966,     0.002644861180905,     0.002309092781614,     0.002046977599578,     0.001837087179398,     0.001665464366101,     0.001522660556546,     0.001402068034985,     0.001298936032708,     0.478207379554864,
     0.065848329704954,     0.024207025485369,     0.012855413958958,     0.008249000054782,     0.005912665155722,     0.004547430173512,     0.003668687672430,     0.003062415095397,     0.002621872296480,     0.002288714583033,
     0.002028689747809,     0.001820508435627,     0.001650307647951,     0.001508704621841,     0.001389138974765,     0.001286894788462,     0.477550104469952,     0.065606900848425,     0.024078882812230,     0.012773218835289,
     0.008190100164559,     0.005867373779058,     0.004510895981515,     0.003638194234482,     0.003036310470803,     0.002599086282405,     0.002268518436553,     0.002010566927962,     0.001804080563390,     0.001635289844697,
     0.001494877377549,     0.001376329765432,     0.001274965679557,     0.476895237280146,     0.065366749318669,     0.023951559152866,     0.012691610452029,     0.008131651366465,     0.005822446223984,     0.004474665422456,
     0.003607960706838,     0.003010432699557,     0.002576501326386,     0.002248502699375,     0.001992607638246,     0.001787802179954,     0.001620409675410,     0.001481177630751,     0.001363639290885,     0.001263147657503,
     0.476242765253032,     0.065127866954810,     0.023825048662368,     0.012610584316399,     0.008073650037422,     0.005777879467128,     0.004438735908541,     0.003577984830987,     0.002984779780070,     0.002554115632481,
     0.002228665743650,     0.001974810390635,     0.001771671915334,     0.001605665871031,     0.001467604199635,     0.001351066445456,     0.001251439683649,     0.475592675737512,     0.064890245654197,     0.023699345540573,
     0.012530135971697,     0.008016092584457,     0.005733670510883,     0.004403104874462,     0.003548264368345,     0.002959349728635,     0.002531927420953,     0.002209005956338,     0.001957173710736,     0.001755688412176,
     0.001591057174269,     0.001454155913397,     0.001338610133816,     0.001239840729091,     0.474944956163227,     0.064653877371960,     0.023574444031705,     0.012450260997003,     0.007958975444445,     0.005689816383185,
     0.004367769777195,     0.003518797100076,     0.002934140579258,     0.002509934928123,     0.002189521739080,     0.001939696137670,     0.001739850325643,     0.001576582339481,     0.001440831612131,     0.001326269270875,
     0.001228349774578,     0.474299594039977,     0.064418754120564,     0.023450338424021,     0.012370955006880,     0.007902295083856,     0.005646314137289,     0.004332728095812,     0.003489580826916,     0.002909150383504,
     0.002488136406219,     0.002170211508055,     0.001922376223944,     0.001724156323295,     0.001562240132574,     0.001427630146735,     0.001314042781691,     0.001216965810423,     0.473656576957154,     0.064184867969374,
     0.023327023049457,     0.012292213651079,     0.007846047998502,     0.005603160851548,     0.004297977331275,     0.003460613368999,     0.002884377210338,     0.002466530123240,     0.002151073693852,     0.001905212535326,
     0.001708605084975,     0.001548029330890,     0.001414550378802,     0.001301929601367,     0.001205687836414,     0.473015892583175,     0.063952211044218,     0.023204492283274,     0.012214032614246,     0.007790230713284,
     0.005560353629201,     0.004263515006252,     0.003431892565682,     0.002859819145966,     0.002445114362805,     0.002132106741337,     0.001888203650726,     0.001693195302698,     0.001533948723101,     0.001401591180529,
     0.001289928674966,     0.001194514861720,     0.472377528664917,     0.063720775526958,     0.023082740543715,     0.012136407615637,     0.007734839781949,     0.005517889598147,     0.004229338664920,     0.003403416275375,
     0.002835474293679,     0.002423887424013,     0.002113309109520,     0.001871348162073,     0.001677925680535,     0.001519997109106,     0.001388751434608,     0.001278038957408,     0.001183445904809,     0.471741473027158,
     0.063490553655057,     0.022961762291659,     0.012059334408823,     0.007679871786844,     0.005475765910741,     0.004195445872779,     0.003375182375369,     0.002811340773700,     0.002402847621304,     0.002094679271428,
     0.001854644674196,     0.001662794934502,     0.001506173299925,     0.001376030034136,     0.001266259413386,     0.001172479993356,     0.471107713572028,     0.063261537721160,     0.022841552030277,     0.011982808781413,
     0.007625323338670,     0.005433979743574,     0.004161834216460,     0.003347188761672,     0.002787416723035,     0.002381993284317,     0.002076215713976,     0.001838091804704,     0.001647801792448,     0.001492476117595,
     0.001363425882515,     0.001254589017268,     0.001161616164159,     0.470476238278456,     0.063033720072670,     0.022722104304698,     0.011906826554767,     0.007571191076239,     0.005392528297269,     0.004128501303545,
     0.003319433348834,     0.002763700295314,     0.002361322757755,     0.002057916937839,     0.001821688183870,     0.001632944993952,     0.001478904395067,     0.001350937893353,     0.001243026753010,     0.001150853463050,
     0.469847035201624,     0.062807093111329,     0.022603413701667,     0.011831383583717,     0.007517471666243,     0.005351408796266,     0.004095444762373,     0.003291914069790,     0.002740189660648,     0.002340834401243,
     0.002039781457328,     0.001805432454510,     0.001618223290203,     0.001465456976108,     0.001338564990371,     0.001231571614065,     0.001140190944813,     0.469220092472426,     0.062581649292806,     0.022485474849215,
     0.011756475756289,     0.007464161803006,     0.005310618488622,     0.004062662241868,     0.003264628875691,     0.002716883005476,     0.002320526589198,     0.002021807800261,     0.001789323271875,     0.001603635443904,
     0.001452132715195,     0.001326306107312,     0.001220222603293,     0.001129627673098,     0.468595398296933,     0.062357381126284,     0.022368282416330,     0.011682098993431,     0.007411258208257,     0.005270154645798,
     0.004030151411347,     0.003237575735742,     0.002693778532421,     0.002300397710690,     0.002003994507844,     0.001773359303528,     0.001589180229156,     0.001438930477418,     0.001314160187839,     0.001208978732874,
     0.001119162720341,     0.467972940955858,     0.062134281174053,     0.022251831112623,     0.011608249248736,     0.007358757630894,     0.005230014562465,     0.003997909960351,     0.003210752637042,     0.002670874460140,
     0.002280446169312,     0.001986340134545,     0.001757539229237,     0.001574856431361,     0.001425849138382,     0.001302126185449,     0.001197839024220,     0.001108795167674,     0.467352708804027,     0.061912342051106,
     0.022136115688011,     0.011534922508172,     0.007306656846753,     0.005190195556296,     0.003965935598455,     0.003184157584423,     0.002648169023186,     0.002260670383045,     0.001968843247975,     0.001741861740857,
     0.001560662847107,     0.001412887584109,     0.001290203063381,     0.001186802507889,     0.001098524104851,     0.466734690269854,     0.061691556424734,     0.022021130932389,     0.011462114789818,     0.007254952658378,
     0.005150694967770,     0.003934226055102,     0.003157788600295,     0.002625660471856,     0.002241068784130,     0.001951502428764,     0.001726325542225,     0.001546598284076,     0.001400044710938,     0.001278389794520,
     0.001175868223497,     0.001088348630163,     0.466118873854819,     0.061471917014134,     0.021906871675311,     0.011389822143592,     0.007203641894797,     0.005111510159971,     0.003902779079423,     0.003131643724483,
     0.002603347072059,     0.002221639818935,     0.001934316270447,     0.001710929349044,     0.001532661560931,     0.001387319425434,     0.001266685361310,     0.001165035219637,     0.001078267850358,     0.465505248132955,
     0.061253416590008,     0.021793332785675,     0.011318040650991,     0.007152721411294,     0.005072638518396,     0.003871592440063,     0.003105721014079,     0.002581227105166,     0.002202381947831,     0.001917283379341,
     0.001695671888776,     0.001518851507221,     0.001374710644288,     0.001255088755668,     0.001154302553791,     0.001068280880561,     0.464893801750330,     0.061036047974174,     0.021680509171407,     0.011246766424831,
     0.007102188089185,     0.005034077450757,     0.003840663925012,     0.003080018543283,     0.002559298867876,     0.002183293645062,     0.001900402374432,     0.001680551900535,     0.001505166963276,     0.001362217294225,
     0.001243598978888,     0.001143669292248,     0.001058386844196,     0.464284523424541,     0.060819804039177,     0.021568395779148,     0.011175995608982,     0.007052038835602,     0.004995824386793,     0.003809991341430,
     0.003054534403251,     0.002537560672078,     0.002164373398618,     0.001883671887256,     0.001665568134976,     0.001491606780111,     0.001349838311913,     0.001232215041559,     0.001133134510024,     0.001048584872910,
     0.463677401944206,     0.060604677707905,     0.021456987593947,     0.011105724378117,     0.007002270583268,     0.004957876778072,     0.003779572515486,     0.003029266701948,     0.002516010844712,     0.002145619710113,
     0.001867090561785,     0.001650719354193,     0.001478169819325,     0.001337572643864,     0.001220935963478,     0.001122697290775,     0.001038874106489,     0.463072426168466,     0.060390661953202,     0.021346279638955,
     0.011035948937455,     0.006952880290282,     0.004920232097810,     0.003749405292182,     0.003004213563991,     0.002494647727634,     0.002127031094657,     0.001850657054313,     0.001636004331609,     0.001464854953000,
     0.001325419246350,     0.001209760773561,     0.001112356726719,     0.001029253692790,     0.462469585026484,     0.060177749797493,     0.021236266975116,     0.010966665522506,     0.006903864939904,     0.004882887840676,
     0.003719487535193,     0.002979373130507,     0.002473469677482,     0.002108606080740,     0.001834370033344,     0.001621421851877,     0.001451661063610,     0.001313377085307,     0.001198688509759,     0.001102111918558,
     0.001019722787660,     0.461868867516953,     0.059965934312405,     0.021126944700871,     0.010897870398824,     0.006855221540340,     0.004845841522613,     0.003689817126700,     0.002954743558982,     0.002452475065543,
     0.002090343210101,     0.001818228179481,     0.001606970710772,     0.001438587043922,     0.001301445136246,     0.001187718218974,     0.001091961975393,     0.001010280554859,     0.461270262707605,     0.059755208618395,
     0.021018307951854,     0.010829559861756,     0.006806947124533,     0.004809090680647,     0.003660391967230,     0.002930323023118,     0.002431662277621,     0.002072241037619,     0.001802230185312,     0.001592649715091,
     0.001425631796897,     0.001289622384166,     0.001176848956977,     0.001081906014648,     0.001000926165991,     0.460673759734724,     0.059545565884379,     0.020910351900600,     0.010761730236198,     0.006759038749950,
     0.004772632872711,     0.003631209975488,     0.002906109712684,     0.002411029713905,     0.002054298131183,     0.001786374755303,     0.001578457682550,     0.001412794235601,     0.001277907823463,     0.001166079788322,
     0.001071943161996,     0.000991658800427,     0.460079347802666,     0.059336999327364,     0.020803071756248,     0.010694377876349,     0.006711493498372,     0.004736465677458,     0.003602269088207,     0.002882101833379,
     0.002390575788842,     0.002036513071579,     0.001770660605690,     0.001564393441684,     0.001400073283111,     0.001266300457845,     0.001155409786265,     0.001062072551273,     0.000982477645232,     0.459487016183376,
     0.059129502212084,     0.020696462764247,     0.010627499165470,     0.006664308475696,     0.004700586694085,     0.003573567259981,     0.002858297606685,     0.002370298931007,     0.002018884452376,     0.001755086464368,
     0.001550455831749,     0.001387467872419,     0.001254799300244,     0.001144838032684,     0.001052293324409,     0.000973381895093,     0.458896754215917,     0.058923067850637,     0.020590520206071,     0.010561090515643,
     0.006617480811722,     0.004664993542156,     0.003545102463110,     0.002834695269728,     0.002350197582974,     0.002001410879801,     0.001739651070787,     0.001536643702621,     0.001374976946341,     0.001243403372729,
     0.001134363617998,     0.001042604631347,     0.000964370752248,     0.458308551305992,     0.058717689602130,     0.020485239398931,     0.010495148367531,     0.006571007659951,     0.004629683861421,     0.003516872687447,
     0.002811293075139,     0.002330270201194,     0.001984090972633,     0.001724353175846,     0.001522955914700,     0.001362599457428,     0.001232111706426,     0.001123985641086,     0.001033005629974,     0.000955443426413,
     0.457722396925483,     0.058513360872317,     0.020380615695488,     0.010429669190149,     0.006524886197392,     0.004594655311647,     0.003488875940241,     0.002788089290917,     0.002310515255868,     0.001966923362082,
     0.001709191541787,     0.001509391338809,     0.001350334367875,     0.001220923341425,     0.001113703209208,     0.001023495486040,     0.000946599134715,     0.457138280611981,     0.058310075113252,     0.020276644483572,
     0.010364649480621,     0.006479113624352,     0.004559905572442,     0.003461110245985,     0.002765082200289,     0.002290931230820,     0.001949906691683,     0.001694164942093,     0.001495948856106,     0.001338180649433,
     0.001209837326707,     0.001103515437929,     0.001014073373086,     0.000937837101617,     0.456556191968328,     0.058107825822935,     0.020173321185902,     0.010300085763954,     0.006433687164246,     0.004525432343081,
     0.003433573646263,     0.002742270101577,     0.002271516623382,     0.001933039617178,     0.001679272161384,     0.001482627357981,     0.001326137283315,     0.001198852720053,     0.001093421451040,     0.001004738472374,
     0.000929156558856,     0.455976120662154,     0.057906606544966,     0.020070641259811,     0.010235974592808,     0.006388604063397,     0.004491233342341,     0.003406264199604,     0.002719651308062,     0.002252269944266,
     0.001916320806408,     0.001664511995315,     0.001469425745965,     0.001314203260117,     0.001187968587966,     0.001083420380479,     0.000995489972812,     0.000920556745369,     0.455398056425429,     0.057706410868198,
     0.019968600196964,     0.010172312547261,     0.006343861590845,     0.004457306308329,     0.003379179981326,     0.002697224147852,     0.002233189717444,     0.001899748939203,     0.001649883250474,     0.001456342931637,
     0.001302377579725,     0.001177184005590,     0.001073511366259,     0.000986327070883,     0.000912036907226,     0.454821989054011,     0.057507232426400,     0.019867193523092,     0.010109096234594,     0.006299457038153,
     0.004423648998316,     0.003352319083395,     0.002674986963750,     0.002214274480032,     0.001883322707271,     0.001635384744285,     0.001443377836531,     0.001290659251229,     0.001166498056627,     0.001063693556390,
     0.000977248970573,     0.000903596297567,     0.454247908407195,     0.057309064897912,     0.019766416797718,     0.010046322289055,     0.006255387719214,     0.004390259188567,     0.003325679614274,     0.002652938113121,
     0.002195522782170,     0.001867040814095,     0.001621015304909,     0.001430529392046,     0.001279047292841,     0.001155909833262,     0.001053966106805,     0.000968254883303,     0.000895234176530,     0.453675804407272,
     0.057111902005311,     0.019666265613887,     0.009983987371646,     0.006211650970066,     0.004357134674186,     0.003299259698783,     0.002631075967766,     0.002176933186905,     0.001850901974822,     0.001606773771140,
     0.001417796539351,     0.001267540731810,     0.001145418436078,     0.001044328181285,     0.000959344027857,     0.000886949811188,     0.453105667039086,     0.056915737515078,     0.019566735597902,     0.009922088169897,
     0.006168244148702,     0.004324273268945,     0.003273057477949,     0.002609398913790,     0.002158504270073,     0.001834904916157,     0.001592658992314,     0.001405178229299,     0.001256138604337,     0.001135022973985,
     0.001034778951389,     0.000950515630315,     0.000878742475485,     0.452537486349600,     0.056720565237266,     0.019467822409060,     0.009860621397649,     0.006125164634884,     0.004291672805123,     0.003247071108870,
     0.002587905351476,     0.002140234620187,     0.001819048376261,     0.001578669828211,     0.001392673422337,     0.001244839955491,     0.001124722564135,     0.001025317596376,     0.000941768923981,     0.000870611450168,
     0.451971252447460,     0.056526379025170,     0.019369521739388,     0.009799583794838,     0.006082409829961,     0.004259331133353,     0.003221298764568,     0.002566593695161,     0.002122122838321,     0.001803331104645,
     0.001564805148958,     0.001380281088415,     0.001233643839130,     0.001114516331852,     0.001015943303138,     0.000933103149319,     0.000862556022728,     0.451406955502562,     0.056333172775003,     0.019271829313382,
     0.009738972127280,     0.006039977156683,     0.004227246122455,     0.003195738633854,     0.002545462373106,     0.002104167537999,     0.001787751862066,     0.001551063834936,     0.001368000206905,     0.001222549317818,
     0.001104403410552,     0.001006655266126,     0.000924517553887,     0.000854575487329,     0.450844585745629,     0.056140940425572,     0.019174740887756,     0.009678783186455,     0.005997864059021,     0.004195415659284,
     0.003170388921186,     0.002524509827377,     0.002086367345078,     0.001772309420428,     0.001537444776684,     0.001355829766506,     0.001211555462745,     0.001094382941670,     0.000997452687281,     0.000916011392264,
     0.000846669144754,     0.450284133467782,     0.055949675957955,     0.019078252251177,     0.009619013789300,     0.005956068001991,     0.004163837648573,     0.003145247846535,     0.002503734513721,     0.002068720897645,
     0.001757002562679,     0.001523946874810,     0.001343768765164,     0.001200661353646,     0.001084454074583,     0.000988334775964,     0.000907583925992,     0.000838836302336,     0.449725589020125,     0.055759373395187,
     0.018982359224020,     0.009559660777996,     0.005914586471469,     0.004132510012777,     0.003120313645242,     0.002483134901440,     0.002051226845900,     0.001741830082709,     0.001510569039895,     0.001331816209986,
     0.001189866078724,     0.001074615966537,     0.000979300748883,     0.000899234423505,     0.000831076273900,     0.449168942813318,     0.055570026801940,     0.018887057658110,     0.009500721019762,     0.005873416974021,
     0.004101430691923,     0.003095584567893,     0.002462709473278,     0.002033883852050,     0.001726790785257,     0.001497310192403,     0.001319971117155,     0.001179168734569,     0.001064867782578,     0.000970349830031,
     0.000890962160067,     0.000823388379701,     0.448614185317172,     0.055381630284214,     0.018792343436477,     0.009442191406651,     0.005832557036724,     0.004070597643456,     0.003071058880178,     0.002442456725294,
     0.002016690590203,     0.001711883485804,     0.001484169262594,     0.001308232511844,     0.001168568426084,     0.001055208695473,     0.000961481250612,     0.000882766417708,     0.000815771946363,     0.448061307060230,
     0.055194177989020,     0.018698212473107,     0.009384068855338,     0.005792004206997,     0.004040008842087,     0.003046734862758,     0.002422375166749,     0.001999645746255,     0.001697107010481,     0.001471145190429,
     0.001296599428138,     0.001158064266403,     0.001045637885641,     0.000952694248978,     0.000874646485161,     0.000808226306819,     0.447510298629362,     0.055007664104079,     0.018604660712696,     0.009326350306929,
     0.005751756052421,     0.004009662279650,     0.003022610811138,     0.002402463319985,     0.001982748017791,     0.001682460195972,     0.001458236925484,     0.001285070908950,     0.001147655376821,     0.001036154541083,
     0.000943988070559,     0.000866601657796,     0.000800750800254,     0.446961150669358,     0.054822082857509,     0.018511684130410,     0.009269032726750,     0.005711810160580,     0.003979555964946,     0.002998685035536,
     0.002382719720312,     0.001965996113977,     0.001667941889418,     0.001445443426863,     0.001273646005938,     0.001137340886713,     0.001026757857312,     0.000935361967799,     0.000858631237562,     0.000793344772042,
     0.446413853882528,     0.054637428517529,     0.018419278731639,     0.009212113104152,     0.005672164138880,     0.003949687923604,     0.002974955860749,     0.002363142915889,     0.001949388755453,     0.001653550948320,
     0.001432763663111,     0.001262323779427,     0.001127119933463,     0.001017447037278,     0.000926815200090,     0.000850734532923,     0.000786007573694,     0.445868399028297,     0.054453695392150,     0.018327440551760,
     0.009155588452317,     0.005632815614391,     0.003920056197932,     0.002951421626032,     0.002343731467613,     0.001932924674234,     0.001639286240447,     0.001420196612124,     0.001251103298329,     0.001116991662388,
     0.001008221291306,     0.000918347033706,     0.000842910858797,     0.000778738562793,     0.445324776922815,     0.054270877828883,     0.018236165655903,     0.009099455808054,     0.005593762233675,     0.003890658846773,
     0.002928080684966,     0.002324483949004,     0.001916602613608,     0.001625146643745,     0.001407741261069,     0.001239983640062,     0.001106955226665,     0.000999079837023,     0.000909956741742,     0.000835159536498,
     0.000771537102941,     0.444782978438561,     0.054088970214440,     0.018145450138709,     0.009043712231613,     0.005555001662624,     0.003861493945363,     0.002904931405334,     0.002305398946092,     0.001900421328030,
     0.001611131046239,     0.001395396606295,     0.001228963890475,     0.001097009787260,     0.000990021899291,     0.000901643604045,     0.000827479893671,     0.000764402563705,     0.444242994503949,     0.053907966974437,
     0.018055290124102,     0.008988354806488,     0.005516531586298,     0.003832559585190,     0.002881972168998,     0.002286475057309,     0.001884379583027,     0.001597238345948,     0.001383161653251,     0.001218043143768,
     0.001087154512852,     0.000981046710140,     0.000893406907158,     0.000819871264237,     0.000757334320555,     0.443704816102947,     0.053727862573109,     0.017965681765056,     0.008933380639227,     0.005478349708760,
     0.003803853873854,     0.002859201371773,     0.002267710893376,     0.001868476155095,     0.001583467450788,     0.001371035416403,     0.001207220502414,     0.001077388579765,     0.000972153508702,     0.000885245944250,
     0.000812332988335,     0.000750331754812,     0.443168434274687,     0.053548651513015,     0.017876621243363,     0.008878786859243,     0.005440453752915,     0.003775374934927,     0.002836617423306,     0.002249105077194,
     0.001852709831602,     0.001569817278489,     0.001359016919150,     0.001196495077089,     0.001067711171899,     0.000963341541144,     0.000877160015059,     0.000804864412260,     0.000743394253592,     0.442633840113085,
     0.053370328334752,     0.017788104769409,     0.008824570618626,     0.005402841460357,     0.003747120907816,     0.002814218746955,     0.002230656243736,     0.001837079410692,     0.001556286756500,     0.001347105193746,
     0.001185865986589,     0.001058121480653,     0.000954610060602,     0.000869148425831,     0.000797464888406,     0.000736521209754,     0.442101024766462,     0.053192887616675,     0.017700128581946,     0.008770729091960,
     0.005365510591204,     0.003719089947626,     0.002792003779668,     0.002212363039943,     0.001821583701182,     0.001542874821905,     0.001335299281214,     0.001175332357759,     0.001048618704864,     0.000945958327119,
     0.000861210489256,     0.000790133775212,     0.000729712021841,     0.441569979437169,     0.053016323974605,     0.017612688947869,     0.008717259476131,     0.005328458923947,     0.003691280225026,     0.002769970971863,
     0.002194224124611,     0.001806221522475,     0.001529580421334,     0.001323598231270,     0.001164893325420,     0.001039202050732,     0.000937385607578,     0.000853345524410,     0.000782870437103,     0.000722966094032,
     0.441040695381211,     0.052840632061560,     0.017525782161993,     0.008664158990154,     0.005291684255293,     0.003663689926113,     0.002748118787313,     0.002176238168292,     0.001790991704456,     0.001516402510878,
     0.001312001102242,     0.001154548032294,     0.001029870731754,     0.000928891175641,     0.000845552856696,     0.000775674244433,     0.000716282836086,     0.440513163907879,     0.052665806567466,     0.017439404546833,
     0.008611424874983,     0.005255184400010,     0.003636317252280,     0.002726445703027,     0.002158403853187,     0.001775893087406,     0.001503340055998,     0.001300506960992,     0.001144295628933,     0.001020623968660,
     0.000920474311682,     0.000837831817784,     0.000768544573431,     0.000709661663289,     0.439987376379380,     0.052491842218890,     0.017353552452384,     0.008559054393336,     0.005218957190777,     0.003609160420086,
     0.002704950209134,     0.002140719873040,     0.001760924521903,     0.001490392031448,     0.001289114882838,     0.001134135273643,     0.001011460989338,     0.000912134302730,     0.000830181745549,     0.000761480806148,
     0.000703101996404,     0.439463324210477,     0.052318733778761,     0.017268222255909,     0.008507044829514,     0.005183000478032,     0.003582217661120,     0.002683630808767,     0.002123184933042,     0.001746084868731,
     0.001477557421186,     0.001277823951474,     0.001124066132418,     0.001002381028777,     0.000903870442403,     0.000822601984023,     0.000754482330397,     0.000696603261619,     0.438940998868118,     0.052146476046101,
     0.017183410361718,     0.008455393489228,     0.005147312129824,     0.003555487221880,     0.002662486017952,     0.002105797749722,     0.001731372998789,     0.001464835218290,     0.001266633258898,     0.001114087378865,
     0.000993383328995,     0.000895682030848,     0.000815091883325,     0.000747548539704,     0.000690164890495,     0.438420391871084,     0.051975063855752,     0.017099113200958,     0.008404097699420,     0.005111890031660,
     0.003528967363635,     0.002641514365493,     0.002088557050853,     0.001716787793001,     0.001452224424879,     0.001255541905334,     0.001104198194139,     0.000984467138976,     0.000887568374681,     0.000807650799615,
     0.000740678833253,     0.000683786319918,     0.437901494789631,     0.051804492078114,     0.017015327231403,     0.008353154808088,     0.005076732086363,     0.003502656362305,     0.002620714392859,     0.002071461575347,
     0.001702328142224,     0.001439724052027,     0.001244548999158,     0.001094397766868,     0.000975631714607,     0.000879528786926,     0.000800278095031,     0.000733872615831,     0.000677466992045,     0.437384299245131,
     0.051634755618875,     0.016932048937241,     0.008302562184118,     0.005041836213924,     0.003476552508333,     0.002600084654076,     0.002054510073158,     0.001687992947160,     0.001427333119684,     0.001233653656819,
     0.001084685293087,     0.000966876318612,     0.000871562586957,     0.000792973137635,     0.000727129297779,     0.000671206354257,     0.436868796909727,     0.051465849418753,     0.016849274828867,     0.008252317217111,
     0.005007200351357,     0.003450654106557,     0.002579623715616,     0.002037701305184,     0.001673781118267,     0.001415050656597,     0.001222855002774,     0.001075059976170,     0.000958200220491,     0.000863669100437,
     0.000785735301358,     0.000720448294937,     0.000665003859111,     0.436354979505978,     0.051297768453227,     0.016767001442677,     0.008202417317213,     0.004972822452557,     0.003424959476092,     0.002559330156287,
     0.002021034043172,     0.001659691575673,     0.001402875700227,     0.001212152169405,     0.001065521026764,     0.000949602696453,     0.000855847659261,     0.000778563965948,     0.000713829028596,     0.000658858964290,
     0.435842838806517,     0.051130507732287,     0.016685225340866,     0.008152859914947,     0.004938700488155,     0.003399466950199,     0.002539202567126,     0.002004507069618,     0.001645723249087,     0.001390807296673,
     0.001201544296955,     0.001056067662719,     0.000941083029361,     0.000848097601497,     0.000771458516910,     0.000707270925442,     0.000652771132553,     0.435332366633707,     0.050964062300172,     0.016603943111219,
     0.008103642461047,     0.004904832445381,     0.003374174876173,     0.002519239551290,     0.001988119177674,     0.001631875077715,     0.001378844500592,     0.001191030533450,     0.001046699109023,     0.000932640508665,
     0.000840418271331,     0.000764418345456,     0.000700773417509,     0.000646739831690,     0.434823554859294,     0.050798427235115,     0.016523151366917,     0.008054762426291,     0.004871216327923,     0.003349081615213,
     0.002499439723955,     0.001971869171052,     0.001618146010174,     0.001366986375123,     0.001180610034634,     0.001037414597738,     0.000924274430343,     0.000832809019007,     0.000757442848452,     0.000694335942130,
     0.000640764534474,     0.434316395404078,     0.050633597649091,     0.016442846746330,     0.008006217301339,     0.004837850155785,     0.003324185542310,     0.002479801712205,     0.001955755863933,     0.001604535004407,
     0.001355231991807,     0.001170281963892,     0.001028213367934,     0.000915984096839,     0.000825269200773,     0.000750531428363,     0.000687957941882,     0.000634844718615,     0.433810880237568,     0.050469568687567,
     0.016363025912825,     0.007958004596572,     0.004804731965156,     0.003299485046122,     0.002460324154931,     0.001939778080869,     0.001591041027599,     0.001343580430516,     0.001160045492184,     0.001019094665623,
     0.000907768817007,     0.000817798178824,     0.000743683493205,     0.000681638864545,     0.000628979866712,     0.433307001377653,     0.050306335529253,     0.016283685554567,     0.007910121841925,     0.004771859808268,
     0.003274978528862,     0.002441005702726,     0.001923934656697,     0.001577663056097,     0.001332030779372,     0.001149899797979,     0.001010057743698,     0.000899627906049,     0.000810395321248,     0.000736898456487,
     0.000675378163044,     0.000623169466206,     0.432804750890270,     0.050143893385852,     0.016204822384324,     0.007862566586735,     0.004739231753265,     0.003250664406178,     0.002421845017785,     0.001908224436445,
     0.001564400075324,     0.001320582134679,     0.001139844067177,     0.001001101861868,     0.000891560685455,     0.000803060001970,     0.000730175737165,     0.000669175295409,     0.000617413009338,     0.432304120889075,
     0.049982237501818,     0.016126433139274,     0.007815336399576,     0.004706845884067,     0.003226541107038,     0.002402840773802,     0.001892646275241,     0.001551251079701,     0.001309233600841,     0.001129877493053,
     0.000992226286596,     0.000883566482950,     0.000795791600699,     0.000723514759589,     0.000663029724722,     0.000611709993103,     0.431805103535116,     0.049821363154114,     0.016048514580815,     0.007768428868104,
     0.004674700300240,     0.003202607073616,     0.002383991655868,     0.001877199038224,     0.001538215072564,     0.001297984290294,     0.001119999276181,     0.000983430291037,     0.000875644632430,     0.000788589502874,
     0.000716914953454,     0.000656940919073,     0.000606059919203,     0.431307691036511,     0.049661265651965,     0.015971063494373,     0.007721841598904,     0.004642793116860,     0.003178860761180,     0.002365296360374,
     0.001861881600455,     0.001525291066084,     0.001286833323434,     0.001110208624368,     0.000974713154975,     0.000867794473911,     0.000781453099610,     0.000710375753748,     0.000650908351510,     0.000600462294004,
     0.430811875648124,     0.049501940336625,     0.015894076689214,     0.007675572217332,     0.004611122464387,     0.003155300637977,     0.002346753594912,     0.001846692846831,     0.001512478081190,     0.001275779828541,
     0.001100504752596,     0.000966074164765,     0.000860015353468,     0.000774381787644,     0.000703896600705,     0.000644931499994,     0.000594916628494,     0.430317649671249,     0.049343382581136,     0.015817550998257,
     0.007629618367363,     0.004579686488534,     0.003131925185121,     0.002328362078176,     0.001831631671995,     0.001499775147487,     0.001264822941710,     0.001090886882945,     0.000957512613272,     0.000852306623180,
     0.000767374969289,     0.000697476939753,     0.000639009847356,     0.000589422438237,     0.429825005453290,     0.049185587790093,     0.015741483277888,     0.007583977711438,     0.004548483350138,     0.003108732896486,
     0.002310120539863,     0.001816696980251,     0.001487181303183,     0.001253961806779,     0.001081354244537,     0.000949027799809,     0.000844667641078,     0.000760432052374,     0.000691116221469,     0.000633142881246,
     0.000583979243331,     0.429333935387449,     0.049028551399413,     0.015665870407780,     0.007538647930318,     0.004517511225036,     0.003085722278595,     0.002292027720582,     0.001801887685479,     0.001474695595008,
     0.001243195575262,     0.001071906073470,     0.000940619030078,     0.000837097771084,     0.000753552450199,     0.000684813901532,     0.000627330094090,     0.000578586568367,     0.428844431912414,     0.048872268876097,
     0.015590709290705,     0.007493626722926,     0.004486768303935,     0.003062891850508,     0.002274082371754,     0.001787202711048,     0.001462317078137,     0.001232523406276,     0.001062541612751,     0.000932285616115,
     0.000829596382963,     0.000746735581481,     0.000678569440668,     0.000621570983049,     0.000573243942383,     0.428356487512047,     0.048716735718006,     0.015515996852355,     0.007448911806209,     0.004456252792290,
     0.003040240143719,     0.002256283255518,     0.001772640989734,     0.001450044816119,     0.001221944466474,     0.001053260112235,     0.000924026876228,     0.000822162852263,     0.000739980870304,     0.000672382304611,
     0.000615865049968,     0.000567950898826,     0.427870094715078,     0.048561947453628,     0.015441730041164,     0.007404500914983,     0.004425962910178,     0.003017765702047,     0.002238629144643,     0.001758201463637,
     0.001437877880797,     0.001211457929976,     0.001044060828565,     0.000915842134941,     0.000814796560267,     0.000733287746071,     0.000666251964054,     0.000610211801339,     0.000562706975509,     0.427385246094802,
     0.048407899641858,     0.015367905828131,     0.007360391801793,     0.004395896892180,     0.002995467081531,     0.002221118822425,     0.001743883084097,     0.001425815352238,     0.001201062978302,     0.001034943025106,
     0.000907730722937,     0.000807496893937,     0.000726655643453,     0.000660177894600,     0.000604610748251,     0.000557511714571,     0.426901934268772,     0.048254587871763,     0.015294521206637,     0.007316582236764,
     0.004366052987251,     0.002973342850325,     0.002203751082605,     0.001729684811610,     0.001413856318653,     0.001190758800307,     0.001025905971887,     0.000899691977002,     0.000800263245861,     0.000720084002341,
     0.000654159576719,     0.000599061406352,     0.000552364662433,     0.426420151898501,     0.048102007762370,     0.015221573192278,     0.007273070007462,     0.004336429458610,     0.002951391588592,     0.002186524729272,
     0.001715605615753,     0.001401999876333,     0.001180544592109,     0.001016948945537,     0.000891725239966,     0.000793095014202,     0.000713572267796,     0.000648196495702,     0.000593563295804,     0.000547265369763,
     0.425939891689163,     0.047950154962437,     0.015149058822687,     0.007229852918748,     0.004307024583609,     0.002929611888405,     0.002169438576773,     0.001701644475099,     0.001390245129568,     0.001170419557030,
     0.001008071229229,     0.000883829860652,     0.000785991602649,     0.000707119890004,     0.000642288141617,     0.000588115941243,     0.000542213391432,     0.425461146389297,     0.047799025150238,     0.015076975157363,
     0.007186928792641,     0.004277836653625,     0.002908002353640,     0.002152491449628,     0.001687800377137,     0.001378591190581,     0.001160382905526,     0.000999272112616,     0.000876005193816,     0.000778952420363,
     0.000700726324225,     0.000636434009261,     0.000582718871731,     0.000537208286477,     0.424983908790511,     0.047648614033341,     0.015005319277498,     0.007144295468176,     0.004248863973934,     0.002886561599880,
     0.002135682182435,     0.001674072318195,     0.001367037179455,     0.001150433855126,     0.000990550891776,     0.000868250600099,     0.000771976881924,     0.000694391030748,     0.000630633598121,     0.000577371620725,
     0.000532249618059,     0.424508171727193,     0.047498917348396,     0.014934088285809,     0.007101950801266,     0.004220104863601,     0.002865288254311,     0.002119009619785,     0.001660459303363,     0.001355582224061,
     0.001140571630364,     0.000981906869150,     0.000860565445966,     0.000765064407290,     0.000688113474845,     0.000624886412326,     0.000572073726025,     0.000527336953428,     0.424033928076221,     0.047349930860920,
     0.014863279306373,     0.007059892664566,     0.004191557655360,     0.002844180955622,     0.002102472616176,     0.001646960346411,     0.001344225459991,     0.001130795462720,     0.000973339353485,     0.000852949103657,
     0.000758214421735,     0.000681893126722,     0.000619191960606,     0.000566824729740,     0.000522469863882,     0.423561170756673,     0.047201650365080,     0.014792889484455,     0.007018118947333,     0.004163220695500,
     0.002823238353910,     0.002086070035923,     0.001633574469715,     0.001332966030489,     0.001121104590555,     0.000964847659778,     0.000845400951133,     0.000751426355813,     0.000675729461476,     0.000613549756249,
     0.000561624178246,     0.000517647924730,     0.423089892729542,     0.047054071683487,     0.014722915986345,     0.006976627555297,     0.004135092343755,     0.002802459110580,     0.002069800753078,     0.001620300704184,
     0.001321803086379,     0.001111498259048,     0.000956431109218,     0.000837920372023,     0.000744699645297,     0.000669621959047,     0.000607959317057,     0.000556471622147,     0.000512870715254,     0.422620086997456,
     0.046907190666985,     0.014653355999193,     0.006935416410522,     0.004107170973186,     0.002781841898246,     0.002053663651339,     0.001607138089176,     0.001310735786000,     0.001101975720137,     0.000948089029129,
     0.000830506755573,     0.000738033731140,     0.000663570104177,     0.000602420165306,     0.000551366616232,     0.000508137818671,     0.422151746604392,     0.046761003194443,     0.014584206730851,     0.006894483451276,
     0.004079454970075,     0.002761385400640,     0.002037657623968,     0.001594085672433,     0.001299763295139,     0.001092536232453,     0.000939820752915,     0.000823159496593,     0.000731428059424,     0.000657573386361,
     0.000596931827703,     0.000546308719440,     0.000503448822098,     0.421684864635401,     0.046615505172546,     0.014515465409703,     0.006853826631899,     0.004051942733810,     0.002741088312511,     0.002021781573710,
     0.001581142509999,     0.001288884786963,     0.001083179061268,     0.000931625620005,     0.000815877995406,     0.000724882081310,     0.000651631299806,     0.000591493835344,     0.000541297494820,     0.000498803316514,
     0.421219434216328,     0.046470692535598,     0.014447129284514,     0.006813443922671,     0.004024632676776,     0.002720949339536,     0.002006034412707,     0.001568307666151,     0.001278099441953,     0.001073903478425,
     0.000923502975796,     0.000808661657801,     0.000718395252994,     0.000645743343386,     0.000586105723676,     0.000536332509491,     0.000494200896723,     0.420755448513537,     0.046326561245309,     0.014379195624264,
     0.006773333309683,     0.003997523224248,     0.002700967198222,     0.001990415062418,     0.001555580213324,     0.001267406447840,     0.001064708762286,     0.000915452171601,     0.000801509894977,     0.000711967035664,
     0.000639909020598,     0.000580767032453,     0.000531413334605,     0.000489641161320,     0.420292900733639,     0.046183107290601,     0.014311661717995,     0.006733492794712,     0.003970612814283,     0.002681140615817,
     0.001974922453536,     0.001542959232042,     0.001256804999537,     0.001055594197670,     0.000907472564593,     0.000794422123498,     0.000705596895444,     0.000634127839522,     0.000575477305699,     0.000526539545310,
     0.000485123712655,     0.419831784123223,     0.046040326687408,     0.014244524874654,     0.006693920395088,     0.003943899897610,     0.002661468330215,     0.001959555525911,     0.001530443810841,     0.001246294299078,
     0.001046559075794,     0.000899563517754,     0.000787397765241,     0.000699284303359,     0.000628399312776,     0.000570236091665,     0.000521710720710,     0.000480648156796,     0.419372091968580,     0.045898215478472,
     0.014177782422935,     0.006654614143572,     0.003917382937529,     0.002641949089866,     0.001944313228465,     0.001518033046205,     0.001235873555554,     0.001037602694219,     0.000891724399820,     0.000780436247351,
     0.000693028735284,     0.000622722957472,     0.000565042942792,     0.000516926443832,     0.000476214103496,     0.418913817595444,     0.045756769733152,     0.014111431711130,     0.006615572088231,     0.003891060409800,
     0.002622581653686,     0.001929194519118,     0.001505726042488,     0.001225541985047,     0.001028724356787,     0.000883954585232,     0.000773537002187,     0.000686829671900,     0.000617098295181,     0.000559897415673,
     0.000512186301587,     0.000471821166158,     0.418456954368722,     0.045615985547226,     0.014045470106974,     0.006576792292310,     0.003864930802545,     0.002603364790968,     0.001914198364706,     0.001493521911851,
     0.001215298810571,     0.001019923373570,     0.000876253454076,     0.000766699467280,     0.000680686598651,     0.000611524851884,     0.000554799071010,     0.000507489884733,     0.000467468961799,     0.418001495692231,
     0.045475859042699,     0.013979894997493,     0.006538272834112,     0.003838992616138,     0.002584297281291,     0.001899323740905,     0.001481419774191,     0.001205143262008,     0.001011199060809,     0.000868620392043,
     0.000759923085280,     0.000674599005699,     0.000606002157937,     0.000549747473579,     0.000502836787840,     0.000463157111020,     0.417547435008439,     0.045336386367608,     0.013914703788857,     0.006500011806877,
     0.003813244363111,     0.002565377914434,     0.001884569632155,     0.001469418757070,     0.001195074576046,     0.001002550740862,     0.000861054790369,     0.000753207303916,     0.000668566387879,     0.000600529748026,
     0.000544742192192,     0.000498226609254,     0.000458885237968,     0.417094765798204,     0.045197563695837,     0.013849893906227,     0.006462007318658,     0.003787684568042,     0.002546605490288,     0.001869935031579,
     0.001457517995650,     0.001185091996121,     0.000993977742145,     0.000853556045788,     0.000746551575941,     0.000662588244662,     0.000595107161131,     0.000539782799660,     0.000493658951063,     0.000454652970306,
     0.416643481580516,     0.045059387226919,     0.013785462793613,     0.006424257492202,     0.003762311767464,     0.002527978818770,     0.001855418940915,     0.001445716632627,     0.001175194772352,     0.000985479399082,
     0.000846123560481,     0.000739955359094,     0.000656664080103,     0.000589733940482,     0.000534868872751,     0.000489133419059,     0.000450459939178,     0.416193575912242,     0.044921853185858,     0.013721407913721,
     0.006386760464834,     0.003737124509759,     0.002509496719737,     0.001841020370432,     0.001434013818161,     0.001165382161486,     0.000977055052047,     0.000838756742027,     0.000733418116049,     0.000650793402807,
     0.000584409633522,     0.000529999992160,     0.000484649622709,     0.000446305779176,     0.415745042387874,     0.044784957822934,     0.013657726747815,     0.006349514388332,     0.003712121355063,     0.002491158022900,
     0.001826738338865,     0.001422408709811,     0.001155653426837,     0.000968704047310,     0.000831455003356,     0.000726939314371,     0.000644975725882,     0.000579133791869,     0.000525175742468,     0.000480207175113,
     0.000442190128311,     0.415297874639275,     0.044648697413524,     0.013594416795566,     0.006312517428818,     0.003687300875163,     0.002472961567740,     0.001812571873333,     0.001410900472471,     0.001146007838226,
     0.000960425736987,     0.000824217762694,     0.000720518426472,     0.000639210566900,     0.000573905971275,     0.000520395712107,     0.000475805692975,     0.000438112627977,     0.414852066335427,     0.044513068257919,
     0.013531475574916,     0.006275767766636,     0.003662661653406,     0.002454906203429,     0.001798520009273,     0.001399488278306,     0.001136444671924,     0.000952219478985,     0.000817044443523,     0.000714154929567,
     0.000633497447854,     0.000568725731589,     0.000515659493323,     0.000471444796569,     0.000434072922921,     0.414407611182189,     0.044378066681136,     0.013468900621929,     0.006239263596241,     0.003638202284597,
     0.002436990788739,     0.001784581790360,     0.001388171306684,     0.001126963210594,     0.000944084636950,     0.000809934474527,     0.000707848305628,     0.000627835895119,     0.000563592636717,     0.000510966682144,
     0.000467124109705,     0.000430070661211,     0.413964502922046,     0.044243689032743,     0.013406689490658,     0.006203003126082,     0.003613921374906,     0.002419214191966,     0.001770756268443,     0.001376948744115,
     0.001117562743235,     0.000936020580215,     0.000802887289546,     0.000701598041341,     0.000622225439411,     0.000558506254588,     0.000506316878340,     0.000462843259696,     0.000426105494206,     0.413522735333863,
     0.044109931686679,     0.013344839753000,     0.006166984578489,     0.003589817541773,     0.002401575290848,     0.001757042503469,     0.001365819784189,     0.001108242565123,     0.000928026683750,     0.000795902327531,
     0.000695403628066,     0.000616665615746,     0.000553466157115,     0.000501709685392,     0.000458601877324,     0.000422177076524,     0.413082302232647,     0.043976791041075,     0.013283348998561,     0.006131206189563,
     0.003565889413814,     0.002384072972481,     0.001743439563416,     0.001354783627511,     0.001099001977757,     0.000920102328108,     0.000788979032495,     0.000689264561789,     0.000611155963401,     0.000548471920154,
     0.000497144710454,     0.000454399596809,     0.000418285066012,     0.412643197469302,     0.043844263518075,     0.013222214834516,     0.006095666209064,     0.003542135630728,     0.002366706133244,     0.001729946524217,
     0.001343839481640,     0.001089840288805,     0.000912246899380,     0.000782116853470,     0.000683180343083,     0.000605696025875,     0.000543523123476,     0.000492621564324,     0.000450236055777,     0.000414429123715,
     0.412205414930392,     0.043712345563669,     0.013161434885476,     0.006060362900298,     0.003518554843202,     0.002349473678715,     0.001716562469699,     0.001332986561028,     0.001080756812042,     0.000904459789139,
     0.000775315244458,     0.000677150477064,     0.000600285350852,     0.000538619350724,     0.000488139861404,     0.000446110895227,     0.000410608913848,     0.411768948537904,     0.043581033647511,     0.013101006793350,
     0.006025294540011,     0.003495145712823,     0.002332374523596,     0.001703286491509,     0.001322224086960,     0.001071750867304,     0.000896740394395,     0.000768573664388,     0.000671174473352,     0.000594923490157,
     0.000533760189378,     0.000483699219671,     0.000442023759501,     0.000406824103761,     0.411333792249007,     0.043450324262751,     0.013040928217215,     0.005990459418278,     0.003471906911987,     0.002315407591634,
     0.001690117689046,     0.001311551287490,     0.001062821780429,     0.000889088117543,     0.000761891577070,     0.000665251846027,     0.000589609999722,     0.000528945230722,     0.000479299260640,     0.000437974296251,
     0.000403074363918,     0.410899940055825,     0.043320213925862,     0.012981196833180,     0.005955855838397,     0.003448837123805,     0.002298571815540,     0.001677055169395,     0.001300967397386,     0.001053968883202,
     0.000881502366316,     0.000755268451152,     0.000659382113590,     0.000584344439550,     0.000524174069807,     0.000474939609335,     0.000433962156410,     0.000399359367859,     0.410467385985201,     0.043190699176472,
     0.012921810334254,     0.005921482116782,     0.003425935042019,     0.002281866136921,     0.001664098047263,     0.001290471658069,     0.001045191513307,     0.000873982553738,     0.000748703760073,     0.000653564798922,
     0.000579126373672,     0.000519446305415,     0.000470619894253,     0.000429986994160,     0.000395678792178,     0.410036124098464,     0.043061776577196,     0.012862766430220,     0.005887336582855,     0.003403199370908,
     0.002265289506197,     0.001651245444905,     0.001280063317551,     0.001036489014271,     0.000866528098072,     0.000742196982024,     0.000647799429243,     0.000573955370112,     0.000514761540028,     0.000466339747335,
     0.000426048466900,     0.000392032316491,     0.409606148491207,     0.042933442713465,     0.012804062847498,     0.005853417578947,     0.003380628825206,     0.002248840882526,     0.001638496492068,     0.001269741630383,
     0.001027860735412,     0.000859138422778,     0.000735747599900,     0.000642085536073,     0.000568831000854,     0.000510119379790,     0.000462098803930,     0.000422146235222,     0.000388419623407,     0.409177453293052,
     0.042805694193367,     0.012745697329025,     0.005819723460184,     0.003358222130009,     0.002232519233734,     0.001625850325917,     0.001259505857593,     0.001019306031786,     0.000851812956463,     0.000729355101262,
     0.000636422655192,     0.000563752841800,     0.000505519434476,     0.000457896702767,     0.000418279962872,     0.000384840398504,     0.408750032667429,     0.042678527647475,     0.012687667634120,     0.005786252594395,
     0.003335978020694,     0.002216323536237,     0.001613306090977,     0.001249355266628,     0.001010824264141,     0.000844551132834,     0.000723018978289,     0.000630810326604,     0.000558720472737,     0.000500961317454,
     0.000453733085919,     0.000414449316729,     0.000381294330294,     0.408323880811348,     0.042551939728689,     0.012629971538361,     0.005753003362000,     0.003313895242831,     0.002200252774972,     0.001600862939066,
     0.001239289131303,     0.001002414798859,     0.000837352390656,     0.000716738727742,     0.000625248094492,     0.000553733477301,     0.000496444645659,     0.000449607598778,     0.000410653966773,     0.000377781110203,
     0.407898991955183,     0.042425927112073,     0.012572606833460,     0.005719974155915,     0.003291972552097,     0.002184305943317,     0.001588520029233,     0.001229306731737,     0.000994077007911,     0.000830216173701,
     0.000710513850917,     0.000619735507188,     0.000548791442939,     0.000491969039551,     0.000445519890020,     0.000406893586051,     0.000374300432541,     0.407475360362445,     0.042300486494693,     0.012515571327138,
     0.005687163381450,     0.003270208714194,     0.002168482043027,     0.001576276527692,     0.001219407354306,     0.000985810268805,     0.000823141930707,     0.000704343853608,     0.000614272117126,     0.000543893960878,
     0.000487534123091,     0.000441469611573,     0.000403167850657,     0.000370851994472,     0.407052980329565,     0.042175614595458,     0.012458862843002,     0.005654569456204,     0.003248602504766,     0.002152780084158,
     0.001564131607765,     0.001209590291579,     0.000977613964539,     0.000816129115330,     0.000698228246063,     0.000608857480813,     0.000539040626087,     0.000483139523702,     0.000437456418592,     0.000399476439697,
     0.000367435495991,     0.406631846185676,     0.042051308154963,     0.012402479220419,     0.005622190809975,     0.003227152709313,     0.002137199084999,     0.001552084449816,     0.001199854842271,     0.000969487483546,
     0.000809177186104,     0.000692166542945,     0.000603491158785,     0.000534231037245,     0.000478784872240,     0.000433479969425,     0.000395819035263,     0.000364050639896,     0.406211952292398,     0.041927563935330,
     0.012346418314400,     0.005590025884655,     0.003205858123113,     0.002121738071998,     0.001540134241193,     0.001190200311185,     0.000961430219652,     0.000802285606393,     0.000686158263291,     0.000598172715574,
     0.000529464796702,     0.000474469802963,     0.000429539925582,     0.000392195322406,     0.000360697131762,     0.405793293043624,     0.041804378720053,     0.012290677995478,     0.005558073134133,     0.003184717551138,
     0.002106396079697,     0.001528280176163,     0.001180626009158,     0.000953441572026,     0.000795453844350,     0.000680202930476,     0.000592901719671,     0.000524741510453,     0.000470193953496,     0.000425635951712,
     0.000388604989107,     0.000357374679915,     0.405375862865303,     0.041681749313845,     0.012235256149584,     0.005526331024204,     0.003163729807976,     0.002091172150660,     0.001516521455857,     0.001171131253009,
     0.000945520945130,     0.000788681372869,     0.000674300072166,     0.000587677743486,     0.000520060788097,     0.000465956964803,     0.000421767715565,     0.000385047726250,     0.000354082995404,     0.404959656215233,
     0.041559672542482,     0.012180150677934,     0.005494798032465,     0.003142893717747,     0.002076065335405,     0.001504857288208,     0.001161715365488,     0.000937667748675,     0.000781967669552,     0.000668449220286,
     0.000582500363319,     0.000515422242807,     0.000461758481156,     0.000417934887973,     0.000381523227595,     0.000350821791981,     0.404544667582850,     0.041438145252653,     0.012125359496911,     0.005463472648228,
     0.003122208114028,     0.002061074692339,     0.001493286887891,     0.001152377675218,     0.000929881397572,     0.000775312216656,     0.000662649910979,     0.000577369159318,     0.000510825491299,     0.000457598150102,
     0.000414137142811,     0.000378031189752,     0.000347590786070,     0.404130891489019,     0.041317164311805,     0.012070880537943,     0.005432353372421,     0.003101671839773,     0.002046199287686,     0.001481809476265,
     0.001143117516652,     0.000922161311885,     0.000768714501056,     0.000656901684567,     0.000572283715447,     0.000506270153794,     0.000453475622436,     0.000410374156977,     0.000374571312152,     0.000344389696743,
     0.403718322485826,     0.041196726608001,     0.012016711747394,     0.005401438717495,     0.003081283747234,     0.002031438195425,     0.001470424281319,     0.001133934230013,     0.000914506916789,     0.000762174014207,
     0.000651204085511,     0.000567243619450,     0.000501755853992,     0.000449390552166,     0.000406645610360,     0.000371143297023,     0.000341218245698,     0.403306955156376,     0.041076829049760,     0.011962851086445,
     0.005370727207333,     0.003061042697885,     0.002016790497223,     0.001459130537606,     0.001124827161247,     0.000906917642519,     0.000755690252094,     0.000645556662380,     0.000562248462818,     0.000497282219036,
     0.000445342596489,     0.000402951185812,     0.000367746849363,     0.000338076157233,     0.402896784114585,     0.040957468565922,     0.011909296530982,     0.005340217377159,     0.003040947562346,     0.002002255282366,
     0.001447927486196,     0.001115795661976,     0.000899392924330,     0.000749262715198,     0.000639958967807,     0.000557297840752,     0.000492848879480,     0.000441331415757,     0.000399290569122,     0.000364381676914,
     0.000334963158220,     0.402487804004982,     0.040838642105489,     0.011856046071482,     0.005309907773442,     0.003020997220304,     0.001987831647700,     0.001436814374611,     0.001106839089440,     0.000891932202448,
     0.000742890908454,     0.000634410558454,     0.000552391352131,     0.000488455469260,     0.000437356673451,     0.000395663448989,     0.000361047490136,     0.000331878978082,     0.402080009502503,     0.040720346637491,
     0.011803097712901,     0.005279796953813,     0.003001190560444,     0.001973518697562,     0.001425790456776,     0.001097956806456,     0.000884534922030,     0.000736574341210,     0.000628910994978,     0.000547528599478,
     0.000484101625661,     0.000433418036150,     0.000392069516991,     0.000357744002183,     0.000328823348770,     0.401673395312296,     0.040602579150832,     0.011750449474564,     0.005249883486968,     0.002981526480366,
     0.001959315543719,     0.001414854992957,     0.001089148181362,     0.000877200533114,     0.000730312527186,     0.000623459841991,     0.000542709188927,     0.000479786989288,     0.000429515173503,     0.000388508467563,
     0.000354470928877,     0.000325796004738,     0.401267956169522,     0.040485336654155,     0.011698099390054,     0.005220165952586,     0.002962003886519,     0.001945221305302,     0.001404007249710,     0.001080412587973,
     0.000869928490582,     0.000724104984440,     0.000618056668027,     0.000537932730189,     0.000475511204034,     0.000425647758200,     0.000384979997970,     0.000351227988682,     0.000322796682921,     0.400863686839155,
     0.040368616175694,     0.011646045507103,     0.005190642941234,     0.002942621694122,     0.001931235108747,     0.001393246499828,     0.001071749405531,     0.000862718254113,     0.000717951235321,     0.000612701045504,
     0.000533198836519,     0.000471273917048,     0.000421815465945,     0.000381483808276,     0.000348014902680,     0.000319825122709,     0.400460582115790,     0.040252414763137,     0.011594285887483,     0.005161313054287,
     0.002923378827093,     0.001917356087732,     0.001382572022282,     0.001063158018656,     0.000855569288142,     0.000711850806438,     0.000607392550691,     0.000528507124686,     0.000467074778709,     0.000418017975426,
     0.000378019601323,     0.000344831394550,     0.000316881065928,     0.400058636823451,     0.040136729483482,     0.011542818606897,     0.005132174903834,     0.002904274217980,     0.001903583383111,     0.001371983102170,
     0.001054637817303,     0.000848481061815,     0.000705803228615,     0.000602130763671,     0.000523857214938,     0.000462913442595,     0.000414254968291,     0.000374587082705,     0.000341677190536,     0.000313964256813,
     0.399657845815393,     0.040021557422905,     0.011491641754877,     0.005103227112598,     0.002885306807884,     0.001889916142860,     0.001361479030667,     0.001046188196709,     0.000841453048950,     0.000699808036860,
     0.000596915268307,     0.000519248730971,     0.000458789565451,     0.000410526129116,     0.000371185960737,     0.000338552019433,     0.000311074441988,     0.399258203973914,     0.039906895686614,     0.011440753434671,
     0.005074468313848,     0.002866475546392,     0.001876353522012,     0.001351059104966,     0.001037808557351,     0.000834484727994,     0.000693864770319,     0.000591745652209,     0.000514681299900,     0.000454702807162,
     0.000406831145384,     0.000367815946436,     0.000335455612552,     0.000308211370444,     0.398859706210168,     0.039792741398717,     0.011390151763147,     0.005045897151316,     0.002847779391506,     0.001862894682598,
     0.001340722628231,     0.001029498304900,     0.000827575581982,     0.000687972972247,     0.000586621506698,     0.000510154552222,     0.000450652830724,     0.000403169707450,     0.000364476753492,     0.000332387703709,
     0.000305374793514,     0.398462347463971,     0.039679091702089,     0.011339834870678,     0.005017512279109,     0.002829217309573,     0.001849538793588,     0.001330468909543,     0.001021256850170,     0.000820725098497,
     0.000682132189967,     0.000581542426774,     0.000505668121793,     0.000446639302216,     0.000399541508522,     0.000361168098247,     0.000329348029188,     0.000302564464854,     0.398066122703619,     0.039565943758229,
     0.011289800901050,     0.004989312361633,     0.002810788275214,     0.001836285030831,     0.001320297263849,     0.001013083609082,     0.000813932769626,     0.000676341974831,     0.000576508011081,     0.000501221645788,
     0.000442661890770,     0.000395946244630,     0.000357889699665,     0.000326336327731,     0.000299780140420,     0.397671026925699,     0.039453294747136,     0.011240048011349,     0.004961296073504,     0.002792491271260,
     0.001823132576999,     0.001310207011913,     0.001004978002608,     0.000807198091926,     0.000670601882190,     0.000571517861875,     0.000496814764680,     0.000438720268544,     0.000392383614602,     0.000354641279312,
     0.000323352340505,     0.000297021578445,     0.397277055154908,     0.039341141867170,     0.011190574371867,     0.004933462099471,     0.002774325288681,     0.001810080621526,     0.001300197480262,     0.000996939456736,
     0.000800520566377,     0.000664911471353,     0.000566571584992,     0.000492447122203,     0.000434814110694,     0.000388853320036,     0.000351422561330,     0.000320395811086,     0.000294288539423,     0.396884202443866,
     0.039229482334921,     0.011141378165998,     0.004905809134330,     0.002756289326516,     0.001797128360553,     0.001290268001140,     0.000988967402422,     0.000793899698349,     0.000659270305552,     0.000561668789813,
     0.000488118365325,     0.000430943095345,     0.000385355065278,     0.000348233272412,     0.000317466485431,     0.000291580786079,     0.396492463872937,     0.039118313385084,     0.011092457590136,     0.004878335882850,
     0.002738382391813,     0.001784274996869,     0.001280417912456,     0.000981061275546,     0.000787334997559,     0.000653677951909,     0.000556809089234,     0.000483828144218,     0.000427106903566,     0.000381888557394,
     0.000345073141781,     0.000314564111862,     0.000288898083357,     0.396101834550049,     0.039007632270322,     0.011043810853581,     0.004851041059687,     0.002720603499557,     0.001771519739858,     0.001270646557736,
     0.000973220516867,     0.000780825978034,     0.000648133981398,     0.000551992099632,     0.000479576112229,     0.000423305219342,     0.000378453506143,     0.000341941901165,     0.000311688441039,     0.000286240198394,
     0.395712309610513,     0.038897436261143,     0.010995436178434,     0.004823923389309,     0.002702951672607,     0.001758861805438,     0.001260953286073,     0.000965444571987,     0.000774372158072,     0.000642637968814,
     0.000547217440837,     0.000475361925850,     0.000419537729546,     0.000375049623957,     0.000338839284775,     0.000308839225938,     0.000283606900499,     0.395323884216848,     0.038787722645768,     0.010947331799506,
     0.004796981605916,     0.002685425941632,     0.001746300416011,     0.001251337452083,     0.000957732891299,     0.000767973060203,     0.000637189492735,     0.000542484736098,     0.000471185244691,     0.000415804123916,
     0.000371676625911,     0.000335765029277,     0.000306016221834,     0.000280997961137,     0.394936553558601,     0.038678488730009,     0.010899495964214,     0.004770214453362,     0.002668025345042,     0.001733834800405,
     0.001241798415850,     0.000950084929954,     0.000761628211155,     0.000631788135490,     0.000537793612051,     0.000467045731449,     0.000412104095022,     0.000368334229705,     0.000332718873776,     0.000303219186275,
     0.000278413153905,     0.394550312852174,     0.038569731837140,     0.010851926932492,     0.004743620685081,     0.002650748928928,     0.001721464193817,     0.001232335542887,     0.000942500147811,     0.000755337141811,
     0.000626433483125,     0.000533143698690,     0.000462943051884,     0.000408437338248,     0.000365022155631,     0.000329700559790,     0.000300447879063,     0.000275852254514,     0.394165157340649,     0.038461449307774,
     0.010804622976690,     0.004717199064004,     0.002633595746998,     0.001709187837767,     0.001222948204082,     0.000934978009402,     0.000749099387177,     0.000621125125370,     0.000528534629339,     0.000458876874784,
     0.000404803551760,     0.000361740126558,     0.000326709831227,     0.000297702062233,     0.000273315040766,     0.393781082293616,     0.038353638499739,     0.010757582381481,     0.004690948362490,     0.002616564860512,
     0.001697004980035,     0.001213635775656,     0.000927517983889,     0.000742914486344,     0.000615862655603,     0.000523966040614,     0.000454846871945,     0.000401202436482,     0.000358487867901,     0.000323746434364,
     0.000294981500030,     0.000270801292541,     0.393398083007002,     0.038246296787954,     0.010710803443770,     0.004664867362247,     0.002599655338223,     0.001684914874615,     0.001204397639116,     0.000920119545020,
     0.000736781982449,     0.000610645670823,     0.000519437572403,     0.000450852718138,     0.000397633696074,     0.000355265107603,     0.000320810117824,     0.000292285958891,     0.000268310791769,     0.393016154802898,
     0.038139421564309,     0.010664284472596,     0.004638954854258,     0.002582866256312,     0.001672916781658,     0.001195233181207,     0.000912782171093,     0.000730701422643,     0.000605473771610,     0.000514948867829,
     0.000446894091086,     0.000394097036901,     0.000352071576107,     0.000317900632554,     0.000289615207423,     0.000265843322418,     0.392635293029394,     0.038033010237544,     0.010618023789044,     0.004613209638709,
     0.002566196698329,     0.001661009967423,     0.001186141793869,     0.000905505344916,     0.000724672358052,     0.000600346562100,     0.000510499573224,     0.000442970671433,     0.000390592168013,     0.000348907006337,
     0.000315017731807,     0.000286969016384,     0.000263398670470,     0.392255493060408,     0.037927060233128,     0.010572019726151,     0.004587630524910,     0.002549645755128,     0.001649193704222,     0.001177122874192,
     0.000898288553765,     0.000718694343743,     0.000595263649948,     0.000506089338098,     0.000439082142719,     0.000387118801118,     0.000345771133671,     0.000312161171116,     0.000284347158663,     0.000260976623907,
     0.391876750295519,     0.037821568993138,     0.010526270628813,     0.004562216331231,     0.002533212524814,     0.001637467270373,     0.001168175824371,     0.000891131289344,     0.000712766938691,     0.000590224646298,
     0.000501717815112,     0.000435228191356,     0.000383676650557,     0.000342663695922,     0.000309330708273,     0.000281749409255,     0.000258576972687,     0.391499060159804,     0.037716533976145,     0.010480774853702,
     0.004536965885021,     0.002516896112676,     0.001625829950145,     0.001159300051663,     0.000884033047751,     0.000706889705741,     0.000585229165753,     0.000497384660049,     0.000431408506598,     0.000380265433282,
     0.000339584433313,     0.000306526103313,     0.000279175545252,     0.000256199508728,     0.391122418103671,     0.037611952657096,     0.010435530769168,     0.004511878022543,     0.002500695631132,     0.001614281033709,
     0.001150494968339,     0.000876993329434,     0.000701062211573,     0.000580276826341,     0.000493089531785,     0.000427622780515,     0.000376884868832,     0.000336533088456,     0.000303747118486,     0.000276625345811,
     0.000253844025891,     0.390746819602700,     0.037507822527195,     0.010390536755156,     0.004486951588899,     0.002484610199669,     0.001602819817090,     0.001141759991648,     0.000870011639156,     0.000695284026672,
     0.000575367249488,     0.000488832092260,     0.000423870707972,     0.000373534679304,     0.000333509406328,     0.000300993518244,     0.000274098592144,     0.000251510319960,     0.390372260157474,     0.037404141093788,
     0.010345791203116,     0.004462185437961,     0.002468638944785,     0.001591445602114,     0.001133094543766,     0.000863087485956,     0.000689554725292,     0.000570500059984,     0.000484612006455,     0.000420151986597,
     0.000370214589339,     0.000330513134254,     0.000298265069214,     0.000271595067496,     0.000249198188624,     0.389998735293426,     0.037300905880251,     0.010301292515914,     0.004437578432304,     0.002452780999930,
     0.001580157696362,     0.001124498051761,     0.000856220383112,     0.000683873885421,     0.000565674885954,     0.000480428942357,     0.000416466316763,     0.000366924326087,     0.000327544021878,     0.000295561540180,
     0.000269114557125,     0.000246907431459,     0.389626240560674,     0.037198114425874,     0.010257039107749,     0.004413129443129,     0.002437035505450,     0.001568955413120,     0.001115969947545,     0.000849409848104,
     0.000678241088751,     0.000560891358828,     0.000476282570938,     0.000412813401555,     0.000363663619196,     0.000324601821147,     0.000292882702066,     0.000266656848282,     0.000244637849912,     0.389254771533863,
     0.037095764285749,     0.010213029404065,     0.004388837350203,     0.002421401608530,     0.001557838071330,     0.001107509667835,     0.000842655402576,     0.000672655920640,     0.000556149113313,     0.000472172566125,
     0.000409192946751,     0.000360432200778,     0.000321686286290,     0.000290228327912,     0.000264221730197,     0.000242389247281,     0.388884323812011,     0.036993853030657,     0.010169261841464,     0.004364701041787,
     0.002405878463138,     0.001546804995544,     0.001099116654110,     0.000835956572300,     0.000667117970086,     0.000551447787361,     0.000468098604774,     0.000405604660796,     0.000357229805396,     0.000318797173792,
     0.000287598192856,     0.000261808994056,     0.000240161428701,     0.388514893018347,     0.036892378246958,     0.010125734867626,     0.004340719414567,     0.002390465229966,     0.001535855515875,     0.001090790352572,
     0.000829312887141,     0.000661626829691,     0.000546787022141,     0.000464060366643,     0.000402048254776,     0.000354056170032,     0.000315934242379,     0.000284992074114,     0.000259418432987,     0.000237954201123,
     0.388146474800162,     0.036791337536481,     0.010082446941219,     0.004316891373590,     0.002375161076382,     0.001524988967949,     0.001082530214104,     0.000822723881019,     0.000656182095627,     0.000542166462009,
     0.000460057534366,     0.000398523442397,     0.000350911034075,     0.000313097252992,     0.000282409750963,     0.000257049842035,     0.000235767373300,     0.387779064828651,     0.036690728516412,     0.010039396531823,
     0.004293215832195,     0.002359965176365,     0.001514204692864,     0.001074335694229,     0.000816189091875,     0.000650783367609,     0.000537585754483,     0.000456089793429,     0.000395029939958,     0.000347794139289,
     0.000310285968770,     0.000279851004717,     0.000254703018153,     0.000233600755768,     0.387412658798760,     0.036590548819188,     0.009996582119839,     0.004269691711950,     0.002344876710460,     0.001503502037136,
     0.001066206253071,     0.000809708061636,     0.000645430248860,     0.000533044550209,     0.000452156832138,     0.000391567466328,     0.000344705229798,     0.000307500155030,     0.000277315618714,     0.000252377760178,
     0.000231454160831,     0.387047252429034,     0.036490796092388,     0.009954002196415,     0.004246317942583,     0.002329894865719,     0.001492880352659,     0.001058141355314,     0.000803280336178,     0.000640122346082,
     0.000528542502938,     0.000448258341602,     0.000388135742923,     0.000341644052062,     0.000304739579244,     0.000274803378292,     0.000250073868814,     0.000229327402542,     0.386682841461470,     0.036391467998626,
     0.009911655263359,     0.004223093461921,     0.002315018835646,     0.001482338996655,     0.001050140470166,     0.000796905465294,     0.000634859269422,     0.000524079269495,     0.000444394015699,     0.000384734493685,
     0.000338610354855,     0.000302004011021,     0.000272314070774,     0.000247791146619,     0.000227220296691,     0.386319421661361,     0.036292562215446,     0.009869539833062,     0.004200017215822,     0.002300247820150,
     0.001471877331635,     0.001042203071315,     0.000790583002658,     0.000629640632446,     0.000519654509753,     0.000440563551060,     0.000381363445054,     0.000335603889244,     0.000299293222088,     0.000269847485448,
     0.000245529397981,     0.000225132660784,     0.385956988817153,     0.036194076435214,     0.009827654428416,     0.004177088158115,     0.002285581025485,     0.001461494725348,     0.001034328636894,     0.000784312505790,
     0.000624466052105,     0.000515267886605,     0.000436766647033,     0.000378022325950,     0.000332624408570,     0.000296606986268,     0.000267403413548,     0.000243288429106,     0.000223064314030,     0.385595538740292,
     0.036096008365015,     0.009785997582734,     0.004154305250535,     0.002271017664204,     0.001451190550741,     0.001026516649442,     0.000778093536026,     0.000619335148706,     0.000510919065937,     0.000433003005671,
     0.000374710867748,     0.000329671668422,     0.000293945079462,     0.000264981648240,     0.000241068048000,     0.000221015077323,     0.385235067265082,     0.035998355726551,     0.009744567839674,     0.004131667462658,
     0.002256556955105,     0.001440964185913,     0.001018766595866,     0.000771925658481,     0.000614247545883,     0.000506607716601,     0.000429272331696,     0.000371428804254,     0.000326745426624,     0.000291307279631,
     0.000262581984597,     0.000238868064451,     0.000218984773229,     0.384875570248536,     0.035901116256035,     0.009703363753158,     0.004109173771843,     0.002242198123177,     0.001430815014074,     0.001011077967403,
     0.000765808442017,     0.000609202870564,     0.000502333510388,     0.000425574332483,     0.000368175871688,     0.000323845443207,     0.000288693366775,     0.000260204219587,     0.000236688290013,     0.000216973225966,
     0.384517043570234,     0.035804287704087,     0.009662383887297,     0.004086823163168,     0.002227940399553,     0.001420742423497,     0.001003450259581,     0.000759741459211,     0.000604200752949,     0.000498096122002,
     0.000421908718031,     0.000364951808655,     0.000320971480392,     0.000286103122915,     0.000257848152055,     0.000234528537990,     0.000214980261394,     0.384159483132178,     0.035707867835640,     0.009621626816313,
     0.004064614629368,     0.002213783021459,     0.001410745807481,     0.000995882972186,     0.000753724286322,     0.000599240826473,     0.000493895229036,     0.000418275200942,     0.000361756356130,     0.000318123302572,
     0.000283536332073,     0.000255513582703,     0.000232388623418,     0.000213005706995,     0.383802884858648,     0.035611854429832,     0.009581091124460,     0.004042547170776,     0.002199725232161,     0.001400824564306,
     0.000988375609222,     0.000747756503256,     0.000594322727782,     0.000489730511942,     0.000414673496396,     0.000358589257432,     0.000315300676288,     0.000280992780258,     0.000253200314073,     0.000230268363053,
     0.000211049391860,     0.383447244696063,     0.035516245279908,     0.009540775405954,     0.004020619795265,     0.002185766280920,     0.001390978097188,     0.000980927678877,     0.000741837693541,     0.000589446096704,
     0.000485601654007,     0.000411103322129,     0.000355450258204,     0.000312503370210,     0.000278472255442,     0.000250908150533,     0.000228167575348,     0.000209111146674,     0.383092558612840,     0.035421038193122,
     0.009500678264894,     0.003998831518181,     0.002171905422937,     0.001381205814245,     0.000973538693483,     0.000735967444287,     0.000584610576218,     0.000481508341331,     0.000407564398408,     0.000352339106392,
     0.000309731155123,     0.000275974547544,     0.000248636898257,     0.000226086080445,     0.000207190803699,     0.382738822599254,     0.035326230990640,     0.009460798315188,     0.003977181362292,     0.002158141919312,
     0.001371507128448,     0.000966208169487,     0.000730145346161,     0.000579815812431,     0.000477450262795,     0.000404056448009,     0.000349255552222,     0.000306983803897,     0.000273499448413,     0.000246386365209,
     0.000224023700154,     0.000205288196763,     0.382386032667298,     0.035231821507436,     0.009421134180478,     0.003955668357725,     0.002144475036986,     0.001361881457583,     0.000958935627409,     0.000724370993353,
     0.000575061454543,     0.000473427110042,     0.000400579196196,     0.000346199348184,     0.000304261091479,     0.000271046751810,     0.000244156361127,     0.000221980257939,     0.000203403161243,     0.382034184850547,
     0.035137807592203,     0.009381684494071,     0.003934291541906,     0.002130904048702,     0.001352328224212,     0.000951720591811,     0.000718643983543,     0.000570347154829,     0.000469438577450,     0.000397132370696,
     0.000343170249007,     0.000301562794867,     0.000268616253389,     0.000241946697506,     0.000219955578902,     0.000201535534048,     0.381683275204021,     0.035044187107252,     0.009342447898863,     0.003913049959509,
     0.002117428232953,     0.001342846855630,     0.000944562591259,     0.000712963917878,     0.000565672568604,     0.000465484362107,     0.000393715701677,     0.000340168011638,     0.000298888693093,     0.000266207750681,
     0.000239757187583,     0.000217949489769,     0.000199685153610,     0.381333299804050,     0.034950957928415,     0.009303423047264,     0.003891942662392,     0.002104046873934,     0.001333436783829,     0.000937461158291,
     0.000707330400932,     0.000561037354198,     0.000461564163787,     0.000390328921727,     0.000337192395226,     0.000296238567203,     0.000263821043075,     0.000237587646317,     0.000215961818874,     0.000197851859867,
     0.380984254748136,     0.034858117944956,     0.009264608601135,     0.003870968709543,     0.002090759261499,     0.001324097445451,     0.000930415829385,     0.000701743040684,     0.000556441172930,     0.000457677684926,
     0.000386971765832,     0.000334243161098,     0.000293612200244,     0.000261455931804,     0.000235437890378,     0.000213992396145,     0.000196035494247,     0.380636136154826,     0.034765665059471,     0.009226003231707,
     0.003850127167023,     0.002077564691110,     0.001314828281760,     0.000923426144918,     0.000696201448483,     0.000551883689084,     0.000453824630599,     0.000383643971353,     0.000331320072741,     0.000291009377236,
     0.000259112219922,     0.000233307738129,     0.000212041053086,     0.000194235899659,     0.380288940163569,     0.034673597187799,     0.009187605619517,     0.003829417107911,     0.002064462463796,     0.001305628738591,
     0.000916491649139,     0.000690705239020,     0.000547364569878,     0.000450004708496,     0.000380345278006,     0.000328422895783,     0.000288429885165,     0.000256789712296,     0.000231197009608,     0.000210107622767,
     0.000192452920474,     0.379942662934595,     0.034581912258925,     0.009149414454338,     0.003808837612249,     0.002051451886102,     0.001296498266322,     0.000909611890135,     0.000685254030303,     0.000542883485440,
     0.000446217628895,     0.000377075427840,     0.000325551397972,     0.000285873512954,     0.000254488215579,     0.000229105526516,     0.000208191939806,     0.000190686402515,     0.379597300648776,     0.034490608214893,
     0.009111428435105,     0.003788387766984,     0.002038532270050,     0.001287436319827,     0.000902786419794,     0.000679847443619,     0.000538440108782,     0.000442463104647,     0.000373834165217,     0.000322705349155,
     0.000283340051455,     0.000252207538203,     0.000227033112200,     0.000206293840355,     0.000188936193040,     0.379252849507499,     0.034399683010711,     0.009073646269851,     0.003768066665918,     0.002025702933089,
     0.001278442358445,     0.000896014793775,     0.000674485103515,     0.000534034115778,     0.000438740851144,     0.000370621236787,     0.000319884521265,     0.000280829293425,     0.000249947490356,     0.000224979591638,
     0.000204413162088,     0.000187202140732,     0.378909305732538,     0.034309134614260,     0.009036066675638,     0.003747873409650,     0.002012963198052,     0.001269515845939,     0.000889296571476,     0.000669166637763,
     0.000529665185131,     0.000435050586301,     0.000367436391475,     0.000317088688293,     0.000278341033510,     0.000247707883969,     0.000222944791424,     0.000202549744183,     0.000185484095683,     0.378566665565921,
     0.034218961006209,     0.008998688378485,     0.003727807105524,     0.002000312393114,     0.001260656250460,     0.000882631316002,     0.000663891677333,     0.000525332998355,     0.000431392030534,     0.000364279380452,
     0.000314317626279,     0.000275875068229,     0.000245488532699,     0.000220928539751,     0.000200703427312,     0.000183781909385,     0.378224925269809,     0.034129160179918,     0.008961510113308,     0.003707866867576,
     0.001987749851745,     0.001251863044508,     0.000876018594131,     0.000658659856369,     0.000521037239747,     0.000427764906734,     0.000361149957120,     0.000311571113286,     0.000273431195955,     0.000243289251913,
     0.000218930666401,     0.000198874053624,     0.000182095434710,     0.377884081126365,     0.034039730141358,     0.008924530623845,     0.003688051816482,     0.001975274912670,     0.001243135704898,     0.000869457976286,
     0.000653470812155,     0.000516777596363,     0.000424168940247,     0.000358047877090,     0.000308848929383,     0.000271009216899,     0.000241109858672,     0.000216951002723,     0.000197061466732,     0.000180424525904,
     0.377544129437629,     0.033950668909015,     0.008887748662598,     0.003668361079502,     0.001962886919823,     0.001234473712722,     0.000862949036498,     0.000648324185092,     0.000512553757992,     0.000420603858855,
     0.000354972898162,     0.000306150856630,     0.000268608933094,     0.000238950171717,     0.000214989381627,     0.000195265511701,     0.000178769038569,     0.377205066525395,     0.033861974513809,     0.008851162990763,
     0.003648793790435,     0.001950585222307,     0.001225876553316,     0.000856491352382,     0.000643219618670,     0.000508365417135,     0.000417069392747,     0.000351924780307,     0.000303476679058,     0.000266230148376,
     0.000236810011450,     0.000213045637561,     0.000193486035032,     0.000177128829653,     0.376866888731086,     0.033773644999003,     0.008814772378163,     0.003629349089558,     0.001938369174349,     0.001217343716219,
     0.000850084505101,     0.000638156759441,     0.000504212268978,     0.000413565274505,     0.000348903285644,     0.000300826182647,     0.000263872668369,     0.000234689199922,     0.000211119606505,     0.000191722884652,
     0.000175503757439,     0.376529592415630,     0.033685678420121,     0.008778575603189,     0.003610026123585,     0.001926238135263,     0.001208874695142,     0.000843728079338,     0.000633135256989,     0.000500094011369,
     0.000410091239077,     0.000345908178424,     0.000298199155317,     0.000261536300470,     0.000232587560818,     0.000209211125950,     0.000189975909896,     0.000173893681527,     0.376193173959340,     0.033598072844859,
     0.008742571452732,     0.003590824045610,     0.001914191469401,     0.001200468987933,     0.000837421663264,     0.000628154763910,     0.000496010344796,     0.000406647023757,     0.000342939225008,     0.000295595386901,
     0.000259220853827,     0.000230504919439,     0.000207320034886,     0.000188244961498,     0.000172298462827,     0.375857629761790,     0.033510826353001,     0.008706758722120,     0.003571742015056,     0.001902228546119,
     0.001192126096540,     0.000831164848510,     0.000623214935780,     0.000491960972362,     0.000403232368169,     0.000339996193850,     0.000293014669133,     0.000256926139332,     0.000228441102688,     0.000205446173792,
     0.000186529891575,     0.000170717963545,     0.375522956241697,     0.033423937036339,     0.008671136215054,     0.003552779197631,     0.001890348739731,     0.001183845526976,     0.000824957230137,     0.000618315431130,
     0.000487945599761,     0.000399847014238,     0.000337078855478,     0.000290456795632,     0.000254651969597,     0.000226395939057,     0.000203589384615,     0.000184830553617,     0.000169152047169,     0.375189149836801,
     0.033337402998583,     0.008635702743551,     0.003533934765275,     0.001878551429473,     0.001175626789288,     0.000818798406605,     0.000613455911424,     0.000483963935258,     0.000396490706175,     0.000334186982472,
     0.000287921561878,     0.000252398158941,     0.000224369258611,     0.000201749510763,     0.000183146802473,     0.000167600578462,     0.374856207003745,     0.033251222355283,     0.008600457127872,     0.003515207896108,
     0.001866835999459,     0.001167469397522,     0.000812687979744,     0.000608636041029,     0.000480015689663,     0.000393163190456,     0.000331320349450,     0.000285408765203,     0.000250164523375,     0.000222360892974,
     0.000199926397089,     0.000181478494336,     0.000166063423443,     0.374524124217958,     0.033165393233745,     0.008565398196471,     0.003496597774389,     0.001855201838643,     0.001159372869687,     0.000806625554729,
     0.000603855487191,     0.000476100576312,     0.000389864215798,     0.000328478733047,     0.000282918204768,     0.000247950880588,     0.000220370675314,     0.000198119889875,     0.000179825486734,     0.000164540449380,
     0.374192897973536,     0.033079913772951,     0.008530524785926,     0.003478103590460,     0.001843648340780,     0.001151336727726,     0.000800610740045,     0.000599113920009,     0.000472218311041,     0.000386593533144,
     0.000325661911898,     0.000280449681551,     0.000245757049927,     0.000218398440330,     0.000196329836823,     0.000178187638517,     0.000163031524780,     0.373862524783129,     0.032994782123476,     0.008495835740882,
     0.003459724540702,     0.001832174904384,     0.001143360497480,     0.000794643147464,     0.000594411012415,     0.000468368612166,     0.000383350895640,     0.000322869666617,     0.000278002998326,     0.000243582852385,
     0.000216444024234,     0.000194556087040,     0.000176564809841,     0.000161536519372,     0.373533001177823,     0.032909996447407,     0.008461329913991,     0.003441459827490,     0.001820780932693,     0.001135443708654,
     0.000788722392013,     0.000589746440142,     0.000464551200460,     0.000380136058617,     0.000320101779783,     0.000275577959651,     0.000241428110587,     0.000214507264743,     0.000192798491023,     0.000174956862162,
     0.000160055304099,     0.373204323707026,     0.032825554918268,     0.008427006165850,     0.003423308659140,     0.001809465833628,     0.001127585894788,     0.000782848091949,     0.000585119881705,     0.000460765799134,
     0.000376948779568,     0.000317358035921,     0.000273174371848,     0.000239292648771,     0.000212588001061,     0.000191056900651,     0.000173363658219,     0.000158587751105,     0.372876488938353,     0.032741455720934,
     0.008392863364945,     0.003405270249867,     0.001798229019756,     0.001119786593226,     0.000777019868729,     0.000580531018373,     0.000457012133810,     0.000373788818134,     0.000314638221483,     0.000270792042989,
     0.000237176292778,     0.000210686073867,     0.000189331169166,     0.000171785062022,     0.000157133733728,     0.372549493457515,     0.032657697051558,     0.008358900387589,     0.003387343819738,     0.001787069908252,
     0.001112045345076,     0.000771237346984,     0.000575979534149,     0.000453289932507,     0.000370655936080,     0.000311942124832,     0.000268430782882,     0.000235078870032,     0.000208801325300,     0.000187621151167,
     0.000170220938844,     0.000155693126482,     0.372223333868205,     0.032574277117491,     0.008325116117867,     0.003369528594622,     0.001775987920861,     0.001104361695189,     0.000765500154493,     0.000571465115742,
     0.000449598925611,     0.000367549897278,     0.000309269536225,     0.000266090403048,     0.000233000209531,     0.000206933598946,     0.000185926702591,     0.000168671155206,     0.000154265805051,     0.371898006791987,
     0.032491194137203,     0.008291509447576,     0.003351823806153,     0.001764982483860,     0.001096735192119,     0.000759807922152,     0.000566987452547,     0.000445938845864,     0.000364470467688,     0.000306620247793,
     0.000263770716715,     0.000230940141829,     0.000205082739826,     0.000184247680705,     0.000167135578867,     0.000152851646277,     0.371573508868185,     0.032408446340210,     0.008258079276165,     0.003334228691675,
     0.001754053028022,     0.001089165388099,     0.000754160283952,     0.000562546236618,     0.000442309428334,     0.000361417415341,     0.000303994053529,     0.000261471538795,     0.000228898499023,     0.000203248594381,
     0.000182583944093,     0.000165614078812,     0.000151450528149,     0.371249836753771,     0.032326031966994,     0.008224824510686,     0.003316742494205,     0.001743198988582,     0.001081651839003,     0.000748556876947,
     0.000558141162648,     0.000438710410400,     0.000358390510318,     0.000301390749267,     0.000259192685873,     0.000226875114737,     0.000201431010460,     0.000180935352641,     0.000164106525239,     0.000150062329791,
     0.370926987123262,     0.032243949268929,     0.008191744065729,     0.003299364462384,     0.001732419805194,     0.001074194104323,     0.000742997341235,     0.000553771927946,     0.000435141531729,     0.000355389524731,
     0.000298810132668,     0.000256933976189,     0.000224869824111,     0.000199629837307,     0.000179301767529,     0.000162612789549,     0.000148686931453,     0.370604956668603,     0.032162196508205,     0.008158836863373,
     0.003282093850435,     0.001721714921904,     0.001066791747131,     0.000737481319925,     0.000549438232410,     0.000431602534260,     0.000352414232708,     0.000296252003200,     0.000254695229623,     0.000222882463786,
     0.000197844925547,     0.000177683051215,     0.000161132744338,     0.000147324214500,     0.370283742099065,     0.032080771957755,     0.008126101833123,     0.003264929918118,     0.001711083787105,     0.001059444334056,
     0.000732008459115,     0.000545139778510,     0.000428093162177,     0.000349464410372,     0.000293716162127,     0.000252476267685,     0.000220912871889,     0.000196076127175,     0.000176079067428,     0.000159666263380,
     0.000145974061402,     0.369963340141136,     0.031999673901180,     0.008093537911861,     0.003247871930689,     0.001700525853509,     0.001052151435250,     0.000726578407866,     0.000540876271261,     0.000424613161893,
     0.000346539835827,     0.000291202412487,     0.000250276913492,     0.000218960888020,     0.000194323295541,     0.000174489681151,     0.000158213221619,     0.000144636355723,     0.369643747538416,     0.031918900632675,
     0.008061144043791,     0.003230919158854,     0.001690040578107,     0.001044912624361,     0.000721190818176,     0.000536647418204,     0.000421162282034,     0.000343640289135,     0.000288710559082,     0.000248096991761,
     0.000217026353240,     0.000192586285339,     0.000172914758611,     0.000156773495159,     0.000143310982110,     0.369324961051508,     0.031838450456956,     0.008028919180379,     0.003214070878729,     0.001679627422139,
     0.001037727478499,     0.000715845344955,     0.000532452929383,     0.000417740273411,     0.000340765552303,     0.000286240408456,     0.000245936328789,     0.000215109110055,     0.000190864952598,     0.000171354167272,
     0.000155346961251,     0.000141997826285,     0.369006977457918,     0.031758321689190,     0.007996862280306,     0.003197326371796,     0.001669285851053,     0.001030595578214,     0.000710541645999,     0.000528292517322,
     0.000414346889009,     0.000337915409263,     0.000283791768884,     0.000243794752442,     0.000213209002406,     0.000189159154661,     0.000169807775817,     0.000153933498285,     0.000140696775033,     0.368689793551947,
     0.031678512654920,     0.007964972309410,     0.003180684924860,     0.001659015334476,     0.001023516507463,     0.000705279381969,     0.000524165897005,     0.000410981883961,     0.000335089645855,     0.000281364450354,
     0.000241672092138,     0.000211325875651,     0.000187468750182,     0.000168275454139,     0.000152532985776,     0.000139407716195,     0.368373406144589,     0.031599021689996,     0.007933248240636,     0.003164145830012,
     0.001648815346181,     0.001016489853580,     0.000700058216362,     0.000520072785854,     0.000407645015534,     0.000332288049813,     0.000278958264552,     0.000239568178837,     0.000209459576557,     0.000185793599109,
     0.000166757073331,     0.000151145304357,     0.000138130538652,     0.368057812063430,     0.031519847140501,     0.007901689053979,     0.003147708384583,     0.001638685364047,     0.001009515207254,     0.000694877815489,
     0.000516012903708,     0.000404336043108,     0.000329510410744,     0.000276573024846,     0.000237482845021,     0.000207609953287,     0.000184133562672,     0.000165252505675,     0.000149770335765,     0.000136865132324,
     0.367743008152542,     0.031440987362687,     0.007870293736438,     0.003131371891105,     0.001628624870031,     0.001002592162492,     0.000689737848451,     0.000511985972801,     0.000401054728158,     0.000326756520113,
     0.000274208546273,     0.000235415924686,     0.000205776855380,     0.000182488503374,     0.000163761624630,     0.000148407962836,     0.000135611388151,     0.367428991272384,     0.031362440722897,     0.007839061281959,
     0.003115135657269,     0.001618633350134,     0.000995720316599,     0.000684637987114,     0.000507991717741,     0.000397800834234,     0.000324026171226,     0.000271864645523,     0.000233367253326,     0.000203960133750,
     0.000180858284975,     0.000162284304820,     0.000147058069489,     0.000134369198092,     0.367115758299703,     0.031284205597502,     0.007807990691385,     0.003098998995889,     0.001608710294368,     0.000988899270149,
     0.000679577906087,     0.000504029865494,     0.000394574126944,     0.000321319159215,     0.000269541140920,     0.000231336667916,     0.000202159640661,     0.000179242772487,     0.000160820422025,     0.000145720540718,
     0.000133138455109,     0.366803306127433,     0.031206280372831,     0.007777080972407,     0.003082961224855,     0.001598855196721,     0.000982128626952,     0.000674557282697,     0.000500100145355,     0.000391374373937,
     0.000318635281021,     0.000267237852416,     0.000229324006906,     0.000200375229726,     0.000177641832155,     0.000159369853171,     0.000144395262583,     0.000131919053161,     0.366491631664591,     0.031128663445101,
     0.007746331139511,     0.003067021667101,     0.001589067555128,     0.000975407994036,     0.000669575796968,     0.000496202288936,     0.000388201344882,     0.000315974335375,     0.000264954601568,     0.000227329110198,
     0.000198606755886,     0.000176055331451,     0.000157932476315,     0.000143082122201,     0.000130710887194,     0.366180731836188,     0.031051353220350,     0.007715740213928,     0.003051179650560,     0.001579346871439,
     0.000968736981612,     0.000664633131593,     0.000492336030139,     0.000385054811453,     0.000313336122787,     0.000262691211527,     0.000225351819144,     0.000196854075403,     0.000174483139058,     0.000156508170640,
     0.000141781007733,     0.000129513853132,     0.365870603583123,     0.030974348114372,     0.007685307223587,     0.003035434508128,     0.001569692651383,     0.000962115203052,     0.000659728971919,     0.000488501105143,
     0.000381934547309,     0.000310720445526,     0.000260447507024,     0.000223391976521,     0.000195117045845,     0.000172925124866,     0.000155096816443,     0.000140491808376,     0.000128327847865,     0.365561243862088,
     0.030897646552647,     0.007655031203060,     0.003019785577622,     0.001560104404543,     0.000955542274862,     0.000654863005917,     0.000484697252377,     0.000378840328078,     0.000308127107607,     0.000258223314355,
     0.000221449426528,     0.000193395526075,     0.000171381159953,     0.000153698295122,     0.000139214414354,     0.000127152769247,     0.365252649645473,     0.030821246970275,     0.007624911193519,     0.003004232201748,
     0.001550581644320,     0.000949017816653,     0.000650034924162,     0.000480924212506,     0.000375771931340,     0.000305555914774,     0.000256018461366,     0.000219524014766,     0.000191689376240,     0.000169851116580,
     0.000152312489168,     0.000137948716907,     0.000125988516077,     0.364944817921270,     0.030745147811915,     0.007594946242685,     0.002988773728057,     0.001541123887902,     0.000942541451121,     0.000645244419814,
     0.000477181728410,     0.000372729136608,     0.000303006674483,     0.000253832777442,     0.000217615588232,     0.000189998457760,     0.000168334868174,     0.000150939282154,     0.000136694608282,     0.000124834988100,
     0.364637745692975,     0.030669347531712,     0.007565135404777,     0.002973409508908,     0.001531730656236,     0.000936112804013,     0.000640491188592,     0.000473469545163,     0.000369711725311,     0.000300479195892,
     0.000251666093490,     0.000215723995298,     0.000188322633312,     0.000166832289325,     0.000149578558728,     0.000135451981725,     0.000123692085992,     0.364331429979498,     0.030593844593241,     0.007535477740468,
     0.002958138901434,     0.001522401473998,     0.000929731504111,     0.000635774928751,     0.000469787410015,     0.000366719480781,     0.000297973289839,     0.000249518241925,     0.000213849085706,     0.000186661766823,
     0.000165343255768,     0.000148230204599,     0.000134220731470,     0.000122559711353,     0.364025867815063,     0.030518637469435,     0.007505972316837,     0.002942961267503,     0.001513135869558,     0.000923397183198,
     0.000631095341066,     0.000466135072374,     0.000363752188231,     0.000295488768833,     0.000247389056661,     0.000211990710551,     0.000185015723456,     0.000163867644379,     0.000146894106527,     0.000133000752731,
     0.000121437766699,     0.363721056249120,     0.030443724642525,     0.007476618207319,     0.002927875973678,     0.001503933374955,     0.000917109476039,     0.000626452128807,     0.000462512283787,     0.000360809634741,
     0.000293025447034,     0.000245278373091,     0.000210148722272,     0.000183384369601,     0.000162405333158,     0.000145570152319,     0.000131791941692,     0.000120326155453,     0.363416992346252,     0.030369104603976,
     0.007447414491660,     0.002912882391186,     0.001494793525866,     0.000910868020352,     0.000621844997715,     0.000458918797920,     0.000357891609241,     0.000290583140242,     0.000243186028080,     0.000208322974635,
     0.000181767572862,     0.000160956201224,     0.000144258230811,     0.000130594195497,     0.000119224781935,     0.363113673186078,     0.030294775854426,     0.007418360255871,     0.002897979895878,     0.001485715861575,
     0.000904672456787,     0.000617273655987,     0.000455354370540,     0.000354997902495,     0.000288161665883,     0.000241111859946,     0.000206513322728,     0.000180165202045,     0.000159520128800,     0.000142958231866,
     0.000129407412243,     0.000118133551356,     0.362811095863169,     0.030220736903619,     0.007389454592184,     0.002883167868196,     0.001476699924945,     0.000898522428899,     0.000612737814250,     0.000451818759499,
     0.000352128307085,     0.000285760842988,     0.000239055708452,     0.000204719622942,     0.000178577127150,     0.000158096997209,     0.000141670046359,     0.000128231490973,     0.000117052369810,     0.362509257486948,
     0.030146986270348,     0.007360696598999,     0.002868445693133,     0.001467745262390,     0.000892417583125,     0.000608237185543,     0.000448311724713,     0.000349282617395,     0.000283380492188,     0.000237017414788,
     0.000202941732962,     0.000177003219357,     0.000156686688856,     0.000140393566173,     0.000127066331661,     0.000115981144262,     0.362208155181612,     0.030073522482390,     0.007332085380848,     0.002853812760202,
     0.001458851423845,     0.000886357568760,     0.000603771485295,     0.000444833028145,     0.000346460629594,     0.000281020435691,     0.000234996821564,     0.000201179511756,     0.000175443351017,     0.000155289087225,
     0.000139128684183,     0.000125911835208,     0.000114919782544,     0.361907786086029,     0.030000344076446,     0.007303620048342,     0.002839268463398,     0.001450017962737,     0.000880342037932,     0.000599340431306,
     0.000441382433788,     0.000343662141621,     0.000278680497275,     0.000232993772790,     0.000199432819565,     0.000173897395642,     0.000153904076865,     0.000137875294254,     0.000124767903435,     0.000113868193345,
     0.361608147353658,     0.029927449598083,     0.007275299718132,     0.002824812201166,     0.001441244435958,     0.000874370645580,     0.000594943743726,     0.000437959707647,     0.000340886953170,     0.000276360502269,
     0.000231008113871,     0.000197701517885,     0.000172365227891,     0.000152531543383,     0.000136633291224,     0.000123634439068,     0.000112826286204,     0.361309236152461,     0.029854837601668,     0.007247123512861,
     0.002810443376364,     0.001432530403838,     0.000868443049428,     0.000590581145033,     0.000434564617722,     0.000338134865675,     0.000274060277542,     0.000229039691588,     0.000195985469462,     0.000170846723563,
     0.000151171373432,     0.000135402570902,     0.000122511345736,     0.000111793971498,     0.361011049664809,     0.029782506650314,     0.007219090561123,     0.002796161396228,     0.001423875430114,     0.000862558909967,
     0.000586252360018,     0.000431196933987,     0.000335405682291,     0.000271779651488,     0.000227088354091,     0.000194284538279,     0.000169341759585,     0.000149823454700,     0.000134183030057,     0.000121398527959,
     0.000110771160441,     0.360713585087400,     0.029710455315819,     0.007191199997416,     0.002781965672343,     0.001415279081906,     0.000856717890426,     0.000581957115760,     0.000427856428379,     0.000332699207883,
     0.000269518454013,     0.000225153950881,     0.000192598589543,     0.000167850214002,     0.000148487675907,     0.000132974566407,     0.000120295891142,     0.000109757765073,     0.360416839631169,     0.029638682178605,
     0.007163450962103,     0.002767855620604,     0.001406740929686,     0.000850919656752,     0.000577695141610,     0.000424542874778,     0.000330015249011,     0.000267276516520,     0.000223236332804,     0.000190927489674,
     0.000166371965968,     0.000147163926786,     0.000131777078610,     0.000119203341563,     0.000108753698248,     0.360120810521208,     0.029567185827663,     0.007135842601363,     0.002753830661184,     0.001398260547256,
     0.000845163877588,     0.000573466169172,     0.000421256048987,     0.000327353613910,     0.000265053671899,     0.000221335352033,     0.000189271106298,     0.000164906895732,     0.000145852098083,     0.000130590466261,
     0.000118120786370,     0.000107758873633,     0.359825494996671,     0.029495964860490,     0.007108374067157,     0.002739890218503,     0.001389837511715,     0.000839450224250,     0.000569269932279,     0.000417995728721,
     0.000324714112482,     0.000262849754511,     0.000219450862060,     0.000187629308229,     0.000163454884632,     0.000144552081541,     0.000129414629875,     0.000117048133568,     0.000106773205700,     0.359530890310700,
     0.029425017883039,     0.007081044517176,     0.002726033721193,     0.001381471403439,     0.000833778370704,     0.000565106166980,     0.000414761693587,     0.000322096556277,     0.000260664600173,     0.000217582717684,
     0.000186001965467,     0.000162015815085,     0.000143263769894,     0.000128249470885,     0.000115985292016,     0.000105796609711,     0.359236993730331,     0.029354343509655,     0.007053853114806,     0.002712260602065,
     0.001373161806047,     0.000828147993545,     0.000560974611519,     0.000411553725068,     0.000319500758478,     0.000258498046151,     0.000215730774996,     0.000184388949178,     0.000160589570573,     0.000141987056858,
     0.000127094891632,     0.000114932171414,     0.000104829001719,     0.358943802536419,     0.029283940363022,     0.007026799029085,     0.002698570298080,     0.001364908306383,     0.000822558771973,     0.000556875006313,
     0.000408371606507,     0.000316926533890,     0.000256349931143,     0.000213894891371,     0.000182790131690,     0.000159176035637,     0.000140721837119,     0.000125950795352,     0.000113888682299,     0.000103870298559,
     0.358651314023546,     0.029213807074103,     0.006999881434658,     0.002684962250312,     0.001356710494483,     0.000817010387776,     0.000552807093938,     0.000405215123091,     0.000314373698925,     0.000254220095265,
     0.000212074925455,     0.000181205386481,     0.000157775095867,     0.000139468006327,     0.000124817086176,     0.000112854736035,     0.000102920417835,     0.358359525499948,     0.029143942282091,     0.006973099511741,
     0.002671435903920,     0.001348567963555,     0.000811502525303,     0.000548770619111,     0.000402084061836,     0.000311842071583,     0.000252108380042,     0.000210270737152,     0.000179634588167,     0.000156386637892,
     0.000138225461088,     0.000123693669115,     0.000111830244806,     0.000101979277921,     0.358068434287424,     0.029074344634345,     0.006946452446078,     0.002657990708117,     0.001340480309949,     0.000806034871446,
     0.000544765328665,     0.000398978211569,     0.000309331471445,     0.000250014628393,     0.000208482187616,     0.000178077612492,     0.000155010549368,     0.000136994098952,     0.000122580450053,     0.000110815121610,
     0.000101046797946,     0.357778037721263,     0.029005012786342,     0.006919939428900,     0.002644626116132,     0.001332447133133,     0.000800607115618,     0.000540790971541,     0.000395897362913,     0.000306841719656,
     0.000247938684619,     0.000206709139238,     0.000176534336319,     0.000153646718974,     0.000135773818405,     0.000121477335743,     0.000109809280248,     0.000100122897795,     0.357488333150154,     0.028935945401617,
     0.006893559656885,     0.002631341585190,     0.001324468035670,     0.000795218949734,     0.000536847298760,     0.000392841308273,     0.000304372638908,     0.000245880394392,     0.000204951455632,     0.000175004637620,
     0.000152295036397,     0.000134564518862,     0.000120384233794,     0.000108812635319,     0.000099207498094,     0.357199317936115,     0.028867141151714,     0.006867312332122,     0.002618136576469,     0.001316542623191,
     0.000789870068185,     0.000532934063415,     0.000389809841817,     0.000301924053433,     0.000243839604741,     0.000203209001630,     0.000173488395463,     0.000150955392326,     0.000133366100660,     0.000119301052664,
     0.000107825102213,     0.000098300520209,     0.356910989454406,     0.028798598716126,     0.006841196662065,     0.002605010555081,     0.001308670504369,     0.000784560167824,     0.000529051020644,     0.000386802759467,
     0.000299495788984,     0.000241816164041,     0.000201481643267,     0.000171985490006,     0.000149627678442,     0.000132178465042,     0.000118227701656,     0.000106846597102,     0.000097401886236,     0.356623345093454,
     0.028730316782248,     0.006815211859500,     0.002591962990031,     0.001300851290900,     0.000779288947940,     0.000525197927620,     0.000383819858877,     0.000297087672823,     0.000239809922000,     0.000199769247770,
     0.000170495802485,     0.000148311787409,     0.000131001514159,     0.000117164090906,     0.000105877036933,     0.000096511518995,     0.356336382254772,     0.028662294045318,     0.006789357142501,     0.002578993354196,
     0.001293084597470,     0.000774056110242,     0.000521374543529,     0.000380860939421,     0.000294699533711,     0.000237820729648,     0.000198071683550,     0.000169019215203,     0.000147007612866,     0.000129835151053,
     0.000116110131375,     0.000104916339421,     0.000095629342024,     0.356050098352882,     0.028594529208369,     0.006763631734397,     0.002566101124290,     0.001285370041741,     0.000768861358836,     0.000517580629557,
     0.000377925802179,     0.000292331201890,     0.000235848439326,     0.000196388820188,     0.000167555611524,     0.000145715049416,     0.000128679279655,     0.000115065734847,     0.000103964423044,     0.000094755279571,
     0.355764490815237,     0.028527020982173,     0.006738034863728,     0.002553285780834,     0.001277707244318,     0.000763704400207,     0.000513815948869,     0.000375014249920,     0.000289982509073,     0.000233892904673,
     0.000194720528426,     0.000166104875859,     0.000144433992618,     0.000127533804771,     0.000114030813913,     0.000103021207032,     0.000093889256588,     0.355479557082142,     0.028459768085191,     0.006712565764211,
     0.002540546808131,     0.001270095828732,     0.000758584943198,     0.000510080266594,     0.000372126087090,     0.000287653288428,     0.000231953980613,     0.000193066680159,     0.000164666893661,     0.000143164338980,
     0.000126398632080,     0.000113005281972,     0.000102086611362,     0.000093031198724,     0.355195294606683,     0.028392769243522,     0.006687223674703,     0.002527883694232,     0.001262535421412,     0.000753502698990,
     0.000506373349809,     0.000369261119795,     0.000285343374571,     0.000230031523348,     0.000191427148420,     0.000163241551411,     0.000141905985948,     0.000125273668121,     0.000111989053216,     0.000101160556752,
     0.000092181032320,     0.354911700854643,     0.028326023190851,     0.006662007839158,     0.002515295930911,     0.001255025651664,     0.000748457381087,     0.000502694967521,     0.000366419155789,     0.000283052603547,
     0.000228125390342,     0.000189801807373,     0.000161828736612,     0.000140658831897,     0.000124158820289,     0.000110982042629,     0.000100242964654,     0.000091338684401,     0.354628773304432,     0.028259528668396,
     0.006636917506598,     0.002502783013633,     0.001247566151650,     0.000743448705289,     0.000499044890651,     0.000363600004457,     0.000280780812821,     0.000226235440314,     0.000188190532301,     0.000160428337779,
     0.000139422776127,     0.000123053996822,     0.000109984165974,     0.000099333757244,     0.000090504082670,     0.354346509447012,     0.028193284424863,     0.006611951931069,     0.002490344441529,     0.001240156556358,
     0.000738476389680,     0.000495422892020,     0.000360803476802,     0.000278527841265,     0.000224361533222,     0.000186593199599,     0.000159040244428,     0.000138197718850,     0.000121959106801,     0.000108995339792,
     0.000098432857419,     0.000089677155501,     0.354064906785819,     0.028127289216389,     0.006587110371608,     0.002477979717365,     0.001232796503588,     0.000733540154605,     0.000491828746328,     0.000358029385434,
     0.000276293529143,     0.000222503530256,     0.000185009686760,     0.000157664347070,     0.000136983561180,     0.000120874060134,     0.000108015481388,     0.000097540188789,     0.000088857831934,     0.353783962836690,
     0.028061541806498,     0.006562392092208,     0.002465688347514,     0.001225485633923,     0.000728639722655,     0.000488262230143,     0.000355277544550,     0.000274077718105,     0.000220661293825,     0.000183439872366,
     0.000156300537199,     0.000135780205133,     0.000119798767554,     0.000107044508831,     0.000096655675669,     0.000088046041670,     0.353503675127792,     0.027996040966049,     0.006537796361777,     0.002453469841932,
     0.001218223590709,     0.000723774818643,     0.000484723121883,     0.000352547769925,     0.000271880251166,     0.000218834687548,     0.000181883636082,     0.000154948707286,     0.000134587553611,     0.000118733140609,
     0.000106082340940,     0.000095779243076,     0.000087241715060,     0.353224041199545,     0.027930785473187,     0.006513322454110,     0.002441323714125,     0.001211010020033,     0.000718945169590,     0.000481211201799,
     0.000349839878898,     0.000269700972704,     0.000217023576241,     0.000180340858643,     0.000153608750766,     0.000133405510395,     0.000117677091654,     0.000105128897282,     0.000094910816719,     0.000086444783104,
     0.352945058604552,     0.027865774113295,     0.006488969647846,     0.002429249481127,     0.001203844570703,     0.000714150504706,     0.000477726251964,     0.000347153690357,     0.000267539728438,     0.000215227825907,
     0.000178811421841,     0.000152280562035,     0.000132233980140,     0.000116630533848,     0.000104184098164,     0.000094050322993,     0.000085655177442,     0.352666724907528,     0.027801005678948,     0.006464737226437,
     0.002417246663469,     0.001196726894221,     0.000709390555371,     0.000474268056249,     0.000344489024725,     0.000265396365425,     0.000213447303726,     0.000177295208525,     0.000150964036435,     0.000131072868367,
     0.000115593381139,     0.000103247864623,     0.000093197688975,     0.000084872830350,     0.352389037685223,     0.027736478969857,     0.006440624478112,     0.002405314785153,     0.001189656644766,     0.000704665055116,
     0.000470836400320,     0.000341845703950,     0.000263270732042,     0.000211681878045,     0.000175792102581,     0.000149659070251,     0.000129922081452,     0.000114565548264,     0.000102320118426,     0.000092352842415,
     0.000084097674734,     0.352111994526358,     0.027672192792832,     0.006416630695845,     0.002393453373627,     0.001182633479170,     0.000699973739607,     0.000467431071610,     0.000339223551487,     0.000261162677978,
     0.000209931418367,     0.000174301988931,     0.000148365560699,     0.000128781526618,     0.000113546950738,     0.000101400782056,     0.000091515711731,     0.000083329644119,     0.351835593031548,     0.027608145961728,
     0.006392755177315,     0.002381661959759,     0.001175657056899,     0.000695316346629,     0.000464051859313,     0.000336622392289,     0.000259072054220,     0.000208195795339,     0.000172824753518,     0.000147083405919,
     0.000127651111932,     0.000112537504847,     0.000100489778708,     0.000090686226002,     0.000082568672652,     0.351559830813235,     0.027544337297399,     0.006368997224877,     0.002369940077805,     0.001168727040029,
     0.000690692616063,     0.000460698554365,     0.000334042052794,     0.000256998713043,     0.000206474880746,     0.000171360283300,     0.000145812504964,     0.000126530746292,     0.000111537127641,     0.000099587032287,
     0.000089864314965,     0.000081814695090,     0.351284705495618,     0.027480765627654,     0.006345356145527,     0.002358287265391,     0.001161843093230,     0.000686102289875,     0.000457370949431,     0.000331482360908,
     0.000254942508000,     0.000204768547496,     0.000169908466240,     0.000144552757797,     0.000125420339424,     0.000110545736929,     0.000098692467392,     0.000089049909003,     0.000081067646795,     0.351010214714585,
     0.027417429787207,     0.006321831250868,     0.002346703063483,     0.001155004883737,     0.000681545112094,     0.000454068838890,     0.000328943145998,     0.000252903293909,     0.000203076669614,     0.000168469191295,
     0.000143304065278,     0.000124319801870,     0.000109563251270,     0.000097806009320,     0.000088242939145,     0.000080327463730,     0.350736356117639,     0.027354328617634,     0.006298421857075,     0.002335187016360,
     0.001148212081340,     0.000677020828796,     0.000450792018819,     0.000326424238873,     0.000250880926840,     0.000201399122230,     0.000167042348413,     0.000142066329157,     0.000123229044984,     0.000108589589967,
     0.000096927584050,     0.000087443337056,     0.000079594082453,     0.350463127363835,     0.027291460967328,     0.006275127284866,     0.002323738671592,     0.001141464358353,     0.000672529188090,     0.000447540286980,
     0.000323925471780,     0.000248875264109,     0.000199735781569,     0.000165627828516,     0.000140839452069,     0.000122147980923,     0.000107624673058,     0.000096057118245,     0.000086651035033,     0.000078867440111,
     0.350190526123711,     0.027228825691448,     0.006251946859466,     0.002312357580012,     0.001134761389603,     0.000668069940098,     0.000444313442805,     0.000321446678382,     0.000246886164262,     0.000198086524944,
     0.000164225523496,     0.000139623337520,     0.000121076522639,     0.000106668421313,     0.000095194539240,     0.000085865965998,     0.000078147474435,     0.349918550079219,     0.027166421651884,     0.006228879910576,
     0.002301043295695,     0.001128102852402,     0.000663642836938,     0.000441111287383,     0.000318987693753,     0.000244913487068,     0.000196451230740,     0.000162835326209,     0.000138417889884,     0.000120014583874,
     0.000105720756224,     0.000094339775037,     0.000085088063494,     0.000077434123732,     0.349647196923658,     0.027104247717202,     0.006205925772338,     0.002289795375927,     0.001121488426534,     0.000659247632712,
     0.000437933623446,     0.000316548354362,     0.000242957093508,     0.000194829778414,     0.000161457130458,     0.000137223014396,     0.000118962079152,     0.000104781600000,     0.000093492754301,     0.000084317261677,
     0.000076727326885,     0.349376464361609,     0.027042302762607,     0.006183083783307,     0.002278613381186,     0.001114917794231,     0.000654884083483,     0.000434780255352,     0.000314128498063,     0.000241016845759,
     0.000193222048477,     0.000160090830994,     0.000136038617137,     0.000117918923768,     0.000103850875562,     0.000092653406352,     0.000083553495312,     0.000076027023343,     0.349106350108867,     0.026980585669896,
     0.006160353286419,     0.002267496875115,     0.001108390640155,     0.000650551947266,     0.000431650989077,     0.000311727964083,     0.000239092607192,     0.000191627922488,     0.000158736323499,     0.000134864605036,
     0.000116885033789,     0.000102928506531,     0.000091821661159,     0.000082796699766,     0.000075333153116,     0.348836851892378,     0.026919095327414,     0.006137733628954,     0.002256445424499,     0.001101906651376,
     0.000646250984004,     0.000428545632194,     0.000309346593007,     0.000237184242354,     0.000190047283045,     0.000157393504583,     0.000133700885854,     0.000115860326039,     0.000102014417228,     0.000090997449334,
     0.000082046811004,     0.000074645656773,     0.348567967450170,     0.026857830630014,     0.006115224162511,     0.002245458599239,     0.001095465517359,     0.000641980955560,     0.000425463993867,     0.000306984226771,
     0.000235291616964,     0.000188480013776,     0.000156062271777,     0.000132547368182,     0.000114844718096,     0.000101108532662,     0.000090180702127,     0.000081303765581,     0.000073964475434,     0.348299694531290,
     0.026796790479008,     0.006092824242975,     0.002234535972330,     0.001089066929937,     0.000637741625696,     0.000422405884832,     0.000304640708647,     0.000233414597896,     0.000186925999328,     0.000154742523517,
     0.000131403961432,     0.000113838128284,     0.000100210778530,     0.000089371351421,     0.000080567500639,     0.000073289550765,     0.348032030895743,     0.026735973782131,     0.006070533230484,     0.002223677119838,
     0.001082710583298,     0.000633532760058,     0.000419371117386,     0.000302315883232,     0.000231553053176,     0.000185385125360,     0.000153434159144,     0.000130270575826,     0.000112840475669,     0.000099321081204,
     0.000088569329721,     0.000079837953902,     0.000072620824973,     0.347764974314421,     0.026675379453494,     0.006048350489400,     0.002212881620873,     0.001076396173963,     0.000629354126163,     0.000416359505372,
     0.000300009596438,     0.000229706851965,     0.000183857278532,     0.000152137078893,     0.000129147122395,     0.000111851680047,     0.000098439367729,     0.000087774570154,     0.000079115063668,     0.000071958240804,
     0.347498522569045,     0.026615006413544,     0.006026275388281,     0.002202149057571,     0.001070123400771,     0.000625205493382,     0.000413370864171,     0.000297721695480,     0.000227875864556,     0.000182342346498,
     0.000150851183883,     0.000128033512967,     0.000110871661943,     0.000097565565815,     0.000086987006463,     0.000078398768803,     0.000071301741533,     0.347232673452099,     0.026554853589020,     0.006004307299846,
     0.002191479015067,     0.001063891964855,     0.000621086632921,     0.000410405010682,     0.000295452028863,     0.000226059962357,     0.000180840217897,     0.000149576376112,     0.000126929660160,     0.000109900342598,
     0.000096699603832,     0.000086206572996,     0.000077689008742,     0.000070651270962,     0.346967424766770,     0.026494919912915,     0.005982445600950,     0.002180871081472,     0.001057701569628,     0.000616997317814,
     0.000407461763313,     0.000293200446374,     0.000224259017888,     0.000179350782342,     0.000148312558447,     0.000125835477379,     0.000108937643970,     0.000095841410804,     0.000085433204705,     0.000076985723474,
     0.000070006773416,     0.346702774326883,     0.026435204324433,     0.005960689672551,     0.002170324847854,     0.001051551920765,     0.000612937322902,     0.000404540941970,     0.000290966799068,     0.000222472904765,
     0.000177873930415,     0.000147059634617,     0.000124750878803,     0.000107983488720,     0.000094990916402,     0.000084666837142,     0.000076288853547,     0.000069368193735,     0.346438719956839,     0.026375705768946,
     0.005939038899680,     0.002159839908210,     0.001045442726181,     0.000608906424817,     0.000401642368040,     0.000288750939259,     0.000220701497696,     0.000176409553655,     0.000145817509207,     0.000123675779382,
     0.000107037800212,     0.000094148050939,     0.000083907406446,     0.000075598340055,     0.000068735477271,     0.346175259491556,     0.026316423197958,     0.005917492671417,     0.002149415859449,     0.001039373696018,
     0.000604904401973,     0.000398765864382,     0.000286552720508,     0.000218944672467,     0.000174957544551,     0.000144586087646,     0.000122610094830,     0.000106100502502,     0.000093312745361,     0.000083154849347,
     0.000074914124638,     0.000068108569884,     0.345912390776407,     0.026257355569059,     0.005896050380856,     0.002139052301367,     0.001033344542624,     0.000600931034548,     0.000395911255311,     0.000284371997614,
     0.000217202305935,     0.000173517796535,     0.000143365276206,     0.000121553741614,     0.000105171520333,     0.000092484931249,     0.000082409103153,     0.000074236149473,     0.000067487417936,     0.345650111667157,
     0.026198501845892,     0.005874711425079,     0.002128748836625,     0.001027354980536,     0.000596986104466,     0.000393078366590,     0.000282208626601,     0.000215474276018,     0.000172090203970,     0.000142154981986,
     0.000120506636953,     0.000104250779131,     0.000091664540802,     0.000081670105748,     0.000073564357272,     0.000066871968287,     0.345388420029905,     0.026139860998106,     0.005853475205128,     0.002118505070730,
     0.001021404726464,     0.000593069395391,     0.000390267025415,     0.000280062464708,     0.000213760461686,     0.000170674662145,     0.000140955112912,     0.000119468698808,     0.000103338204996,     0.000090851506843,
     0.000080937795587,     0.000072898691275,     0.000066262168290,     0.345127313741025,     0.026081432001321,     0.005832341125974,     0.002108320612007,     0.001015493499274,     0.000589180692704,     0.000387477060404,
     0.000277933370382,     0.000212060742952,     0.000169271067266,     0.000139765577726,     0.000118439845874,     0.000102433724695,     0.000090045762803,     0.000080212111689,     0.000072239095248,     0.000065657965786,
     0.344866790687104,     0.026023213837088,     0.005811308596494,     0.002098195071585,     0.001009621019966,     0.000585319783496,     0.000384708301584,     0.000275821203261,     0.000210375000861,     0.000167879316446,
     0.000138586285979,     0.000117419997576,     0.000101537265660,     0.000089247242723,     0.000079492993634,     0.000071585513473,     0.000065059309101,     0.344606848764884,     0.025965205492850,     0.005790377029435,
     0.002088128063371,     0.001003787011663,     0.000581486456547,     0.000381960580379,     0.000273725824169,     0.000208703117483,     0.000166499307700,     0.000137417148025,     0.000116409074063,     0.000100648755978,
     0.000088455881244,     0.000078780381556,     0.000070937890750,     0.000064466147039,     0.344347485881204,     0.025907405961903,     0.005769545841397,     0.002078119204031,     0.000997991199592,     0.000577680502320,
     0.000379233729600,     0.000271647095105,     0.000207044975903,     0.000165130939935,     0.000136258075012,     0.000115406996197,     0.000099768124389,     0.000087671613603,     0.000078074216138,     0.000070296172386,
     0.000063878428880,     0.344088699952939,     0.025849814243357,     0.005748814452794,     0.002068168112968,     0.000992233311067,     0.000573901712940,     0.000376527583433,     0.000269584879231,     0.000205400460215,
     0.000163774112944,     0.000135108978877,     0.000114413685550,     0.000098895300274,     0.000086894375628,     0.000077374438608,     0.000069660304194,     0.000063296104374,     0.343830488906946,     0.025792429342102,
     0.005728182287836,     0.002058274412300,     0.000986513075472,     0.000570149882184,     0.000373841977424,     0.000267539040864,     0.000203769455507,     0.000162428727393,     0.000133969772336,     0.000113429064399,
     0.000098030213656,     0.000086124103732,     0.000076680990733,     0.000069030232486,     0.000062719123737,     0.343572850680004,     0.025735250268762,     0.005707648774498,     0.002048437726844,     0.000980830224244,
     0.000566424805468,     0.000371176748473,     0.000265509445464,     0.000202151847857,     0.000161094684820,     0.000132840368881,     0.000112453055717,     0.000097172795189,     0.000085360734907,     0.000075993814814,
     0.000068405904071,     0.000062147437649,     0.343315783218757,     0.025678276039668,     0.005687213344491,     0.002038657684089,     0.000975184490859,     0.000562726279831,     0.000368531734816,     0.000263495959627,
     0.000200547524326,     0.000159771887624,     0.000131720682768,     0.000111485583164,     0.000096322976156,     0.000084604206720,     0.000075312853683,     0.000067787266248,     0.000061580997244,     0.343059284479658,
     0.025621505676810,     0.005666875433240,     0.002028933914182,     0.000969575610815,     0.000559054103923,     0.000365906776023,     0.000261498451071,     0.000198956372943,     0.000158460239057,     0.000130610629016,
     0.000110526571089,     0.000095480688459,     0.000083854457306,     0.000074638050695,     0.000067174266802,     0.000061019754112,     0.342803352428909,     0.025564938207810,     0.005646634479855,     0.002019266049904,
     0.000964003321614,     0.000555408077991,     0.000363301712975,     0.000259516788631,     0.000197378282702,     0.000157159643217,     0.000129510123395,     0.000109575944516,     0.000094645864618,     0.000083111425366,
     0.000073969349725,     0.000066566854001,     0.000060463660290,     0.342547985042412,     0.025508572665878,     0.005626489927106,     0.002009653726649,     0.000958467362749,     0.000551788003870,     0.000360716387863,
     0.000257550842247,     0.000195813143553,     0.000155870005040,     0.000128419082422,     0.000108633629140,     0.000093818437763,     0.000082375050157,     0.000073306695163,     0.000065964976590,     0.000059912668261,
     0.342293180305706,     0.025452408089779,     0.005606441221393,     0.002000096582410,     0.000952967475686,     0.000548193684963,     0.000358150644173,     0.000255600482953,     0.000194260846390,     0.000154591230295,
     0.000127337423354,     0.000107699551325,     0.000092998341627,     0.000081645271492,     0.000072650031911,     0.000065368583787,     0.000059366730949,     0.342038936213916,     0.025396443523794,     0.005586487812726,
     0.001990594257752,     0.000947503403849,     0.000544624926233,     0.000355604326674,     0.000253665582873,     0.000192721283047,     0.000153323225574,     0.000126265064180,     0.000106773638091,     0.000092185510543,
     0.000080922029730,     0.000071999305373,     0.000064777625278,     0.000058825801714,     0.341785250771698,     0.025340678017689,     0.005566629154696,     0.001981146395798,     0.000942074892606,     0.000541081534189,
     0.000353077281408,     0.000251746015204,     0.000191194346287,     0.000152065898283,     0.000125201923618,     0.000105855817114,     0.000091379879439,     0.000080205265776,     0.000071354461457,     0.000064192051213,
     0.000058289834349,     0.341532121993179,     0.025285110626674,     0.005546864704449,     0.001971752642207,     0.000936681689250,     0.000537563316873,     0.000350569355681,     0.000249841654213,     0.000189679929796,
     0.000150819156641,     0.000124147921103,     0.000104946016717,     0.000090581383830,     0.000079494921071,     0.000070715446566,     0.000063611812204,     0.000057758783074,     0.341279547901912,     0.025229740411372,
     0.005527193922663,     0.001962412645156,     0.000931323542988,     0.000534070083848,     0.000348080398050,     0.000247952375225,     0.000188177928172,     0.000149582909667,     0.000123102976785,     0.000104044165866,
     0.000089789959814,     0.000078790937591,     0.000070082207593,     0.000063036859316,     0.000057232602535,     0.341027526530814,     0.025174566437779,     0.005507616273522,     0.001953126055320,     0.000926000204922,
     0.000530601646186,     0.000345610258315,     0.000246078054615,     0.000186688236921,     0.000148357067175,     0.000122067011522,     0.000103150194160,     0.000089005544066,     0.000078093257841,     0.000069454691921,
     0.000062467144067,     0.000056711247799,     0.340776055922114,     0.025119587777234,     0.005488131224689,     0.001943892525854,     0.000920711428038,     0.000527157816452,     0.000343158787505,     0.000244218569798,
     0.000185210752445,     0.000147141539768,     0.000121039946870,     0.000102264031833,     0.000088228073835,     0.000077401824849,     0.000068832847413,     0.000061902618422,     0.000056194674348,     0.340525134127304,
     0.025064803506381,     0.005468738247285,     0.001934711712373,     0.000915456967187,     0.000523738408699,     0.000340725837872,     0.000242373799219,     0.000183745372038,     0.000145936238828,     0.000120021705084,
     0.000101385609739,     0.000087457486935,     0.000076716582162,     0.000068216622412,     0.000061343234789,     0.000055682838078,     0.340274759207082,     0.025010212707136,     0.005449436815862,     0.001925583272934,
     0.000910236579072,     0.000520343238446,     0.000338311262875,     0.000240543622349,     0.000182291993873,     0.000144741076514,     0.000119012209103,     0.000100514859355,     0.000086693721744,     0.000076037473840,
     0.000067605965734,     0.000060788946016,     0.000055175695293,     0.340024929231299,     0.024955814466651,     0.005430226408378,     0.001916506868020,     0.000905050022236,     0.000516972122677,     0.000335914917177,
     0.000238727919671,     0.000180850517002,     0.000143555965748,     0.000118011382551,     0.000099651712769,     0.000085936717195,     0.000075364444455,     0.000067000826665,     0.000060239705383,     0.000054673202702,
     0.339775642278912,     0.024901607877284,     0.005411106506177,     0.001907482160518,     0.000899897057043,     0.000513624879819,     0.000333536656630,     0.000236926572672,     0.000179420841341,     0.000142380820217,
     0.000117019149726,     0.000098796102677,     0.000085186412774,     0.000074697439082,     0.000066401154954,     0.000059695466604,     0.000054175317418,     0.339526896437925,     0.024847592036561,     0.005392076593959,
     0.001898508815700,     0.000894777445664,     0.000510301329737,     0.000331176338264,     0.000235139463838,     0.000178002867666,     0.000141215554358,     0.000116035435598,     0.000097947962379,     0.000084442748515,
     0.000074036403297,     0.000065806900813,     0.000059156183819,     0.000053681996947,     0.339278689805343,     0.024793766047145,     0.005373136159762,     0.001889586501212,     0.000889690952068,     0.000507001293719,
     0.000328833820281,     0.000233366476640,     0.000176596497604,     0.000140060083357,     0.000115060165800,     0.000097107225771,     0.000083705664990,     0.000073381283172,     0.000065218014909,     0.000058621811589,
     0.000053193199193,     0.339031020487119,     0.024740129016802,     0.005354284694934,     0.001880714887047,     0.000884637342001,     0.000503724594466,     0.000326508962044,     0.000231607495532,     0.000175201633629,
     0.000138914323140,     0.000114093266622,     0.000096273827340,     0.000082975103311,     0.000072732025268,     0.000064634448362,     0.000058092304898,     0.000052708882448,     0.338783886598102,     0.024686680058367,
     0.005335521694113,     0.001871893645535,     0.000879616382976,     0.000500471056078,     0.000324201624065,     0.000229862405936,     0.000173818179050,     0.000137778190367,     0.000113134665009,     0.000095447702160,
     0.000082251005120,     0.000072088576635,     0.000064056152741,     0.000057567619142,     0.000052229005391,     0.338537286261987,     0.024633418289714,     0.005316846655200,     0.001863122451320,     0.000874627844258,
     0.000497240504045,     0.000321911667999,     0.000228131094239,     0.000172446038006,     0.000136651602423,     0.000112184288550,     0.000094628785886,     0.000081533312589,     0.000071450884803,     0.000063483080057,
     0.000057047710128,     0.000051753527084,     0.338291217611266,     0.024580342833720,     0.005298259079339,     0.001854400981346,     0.000869671496851,     0.000494032765235,     0.000319638956630,     0.000226413447781,
     0.000171085115459,     0.000135534477418,     0.000111242065474,     0.000093817014747,     0.000080821968408,     0.000070818897782,     0.000062915182762,     0.000056532534073,     0.000051282406970,     0.338045678787178,
     0.024527452818236,     0.005279758470895,     0.001845728914837,     0.000864747113482,     0.000490847667884,     0.000317383353865,     0.000224709354849,     0.000169735317185,     0.000134426734173,     0.000110307924648,
     0.000093012325546,     0.000080116915789,     0.000070192564054,     0.000062352413744,     0.000056022047595,     0.000050815604864,     0.337800667939657,     0.024474747376053,     0.005261344337426,     0.001837105933282,
     0.000859854468590,     0.000487685041580,     0.000315144724724,     0.000223018704668,     0.000168396549771,     0.000133328292219,     0.000109381795566,     0.000092214655647,     0.000079418098453,     0.000069571832569,
     0.000061794726322,     0.000055516207715,     0.000050353080958,     0.337556183227287,     0.024422225644869,     0.005243016189667,     0.001828531720417,     0.000854993338311,     0.000484544717257,     0.000312922935329,
     0.000221341387393,     0.000167068720603,     0.000132239071789,     0.000108463608345,     0.000091423942978,     0.000078725460632,     0.000068956652743,     0.000061242074243,     0.000055014971847,     0.000049894795810,
     0.337312222817249,     0.024369886767261,     0.005224773541502,     0.001820005962208,     0.000850163500464,     0.000481426527183,     0.000310717852896,     0.000219677294102,     0.000165751737860,     0.000131158993810,
     0.000107553293721,     0.000090640126021,     0.000078038947060,     0.000068346974452,     0.000060694411679,     0.000054518297800,     0.000049440710343,     0.337068784885273,     0.024317729890650,     0.005206615909947,
     0.001811528346834,     0.000845364734541,     0.000478330304948,     0.000308529345727,     0.000218026316785,     0.000164445510513,     0.000130087979901,     0.000106650783042,     0.000089863143806,     0.000077358502970,
     0.000067742748029,     0.000060151693220,     0.000054026143770,     0.000048990785846,     0.336825867615592,     0.024265754167273,     0.005188542815122,     0.001803098564673,     0.000840596821689,     0.000475255885453,
     0.000306357283198,     0.000216388348341,     0.000163149948308,     0.000129025952363,     0.000105756008263,     0.000089092935910,     0.000076684074090,     0.000067143924258,     0.000059613873875,     0.000053538468341,
     0.000048544983962,     0.336583469200893,     0.024213958754148,     0.005170553780234,     0.001794716308281,     0.000835859544702,     0.000472203104901,     0.000304201535751,     0.000214763282566,     0.000161864961768,
     0.000127972834174,     0.000104868901942,     0.000088329442452,     0.000076015606639,     0.000066550454370,     0.000059080909062,     0.000053055230476,     0.000048103266692,     0.336341587842269,     0.024162342813048,
     0.005152648331555,     0.001786381272378,     0.000831152688003,     0.000469171800783,     0.000302061974889,     0.000213151014149,     0.000160590462181,     0.000126928548986,     0.000103989397231,     0.000087572604084,
     0.000075353047318,     0.000065962290042,     0.000058552754609,     0.000052576389517,     0.000047665596388,     0.336100221749171,     0.024110905510466,     0.005134825998396,     0.001778093153834,     0.000826476037636,
     0.000466161811873,     0.000299938473159,     0.000211551438660,     0.000159326361597,     0.000125893021112,     0.000103117427873,     0.000086822361988,     0.000074696343312,     0.000065379383389,     0.000058029366749,
     0.000052101905182,     0.000047231935752,     0.335859369139362,     0.024059646017588,     0.005117086313091,     0.001769851651646,     0.000821829381249,     0.000463172978211,     0.000297830904151,     0.000209964452545,
     0.000158072572818,     0.000124866175529,     0.000102252928198,     0.000086078657875,     0.000074045442283,     0.000064801686963,     0.000057510702116,     0.000051631737560,     0.000046802247831,     0.335619028238868,
     0.024008563510261,     0.005099428810972,     0.001761656466931,     0.000817212508083,     0.000460205141099,     0.000295739142486,     0.000208389953119,     0.000156829009394,     0.000123847937866,     0.000101395833115,
     0.000085341433972,     0.000073400292362,     0.000064229153746,     0.000056996717741,     0.000051165847105,     0.000046376496014,     0.335379197281937,     0.023957657168964,     0.005081853030350,     0.001753507302904,
     0.000812625208963,     0.000457258143085,     0.000293663063806,     0.000206827838558,     0.000155595585614,     0.000122838234400,     0.000100546078109,     0.000084610633028,     0.000072760842152,     0.000063661737149,
     0.000056487371048,     0.000050704194640,     0.000045954644028,     0.335139874510986,     0.023906926178778,     0.005064358512494,     0.001745403864864,     0.000808067276279,     0.000454331827957,     0.000291602544768,
     0.000205278007891,     0.000154372216502,     0.000121836992050,     0.000099703599234,     0.000083886198300,     0.000072127040718,     0.000063099391007,     0.000055982619851,     0.000050246741345,     0.000045536655939,
     0.334901058176559,     0.023856369729357,     0.005046944801608,     0.001737345860178,     0.000803538503978,     0.000451426040732,     0.000289557463035,     0.000203740360993,     0.000153158817810,     0.000120844138373,
     0.000098868333109,     0.000083168073553,     0.000071498837583,     0.000062542069573,     0.000055482422352,     0.000049793448760,     0.000045122496144,     0.334662746537283,     0.023805987014899,     0.005029611444815,
     0.001729332998265,     0.000799038687551,     0.000448540627643,     0.000287527697267,     0.000202214798579,     0.000151955306012,     0.000119859601555,     0.000098040216915,     0.000082456203054,     0.000070876182728,
     0.000061989727519,     0.000054986737134,     0.000049344278779,     0.000044712129369,     0.334424937859816,     0.023755777234114,     0.005012357992129,     0.001721364990584,     0.000794567624020,     0.000445675436135,
     0.000285513127110,     0.000200701222193,     0.000150761598294,     0.000118883310409,     0.000097219188385,     0.000081750531569,     0.000070259026585,     0.000061442319926,     0.000054495523160,     0.000048899193646,
     0.000044305520668,     0.334187630418811,     0.023705739590200,     0.004995183996444,     0.001713441550613,     0.000790125111927,     0.000442830314847,     0.000283513633195,     0.000199199534206,     0.000149577612553,
     0.000117915194368,     0.000096405185803,     0.000081051004357,     0.000069647320030,     0.000060899802287,     0.000054008739769,     0.000048458155954,     0.000043902635418,     0.333950822496864,     0.023655873290810,
     0.004978089013507,     0.001705562393841,     0.000785710951323,     0.000440005113611,     0.000281529097121,     0.000197709637807,     0.000148403267389,     0.000116955183477,     0.000095598147998,     0.000080357567166,
     0.000069041014386,     0.000060362130497,     0.000053526346673,     0.000048021128640,     0.000043503439318,     0.333714512384473,     0.023606177548026,     0.004961072601899,     0.001697727237744,     0.000781324943752,
     0.000437199683437,     0.000279559401454,     0.000196231436992,     0.000147238482098,     0.000116003208394,     0.000094798014339,     0.000079670166227,     0.000068440061413,     0.000059829260852,     0.000053048303951,
     0.000047588074984,     0.000043107898382,     0.333478698379994,     0.023556651578330,     0.004944134323018,     0.001689935801779,     0.000776966892243,     0.000434413876503,     0.000277604429713,     0.000194764836565,
     0.000146083176665,     0.000115059200377,     0.000094004724730,     0.000078988748255,     0.000067844413306,     0.000059301150048,     0.000052574572049,     0.000047158958601,     0.000042715978942,     0.333243378789594,
     0.023507294602576,     0.004927273741058,     0.001682187807364,     0.000772636601300,     0.000431647546148,     0.000275664066369,     0.000193309742124,     0.000144937271760,     0.000114123091284,     0.000093218219607,
     0.000078313260436,     0.000067254022692,     0.000058777755173,     0.000052105111775,     0.000046733743445,     0.000042327647639,     0.333008551927212,     0.023458105845963,     0.004910490422988,     0.001674482977865,
     0.000768333876884,     0.000428900546863,     0.000273738196830,     0.000191866060057,     0.000143800688734,     0.000113194813567,     0.000092438439929,     0.000077643650432,     0.000066668842625,     0.000058259033704,
     0.000051639884295,     0.000046312393798,     0.000041942871424,     0.332774216114513,     0.023409084538005,     0.004893783938534,     0.001666821038580,     0.000764058526407,     0.000426172734278,     0.000271826707436,
     0.000190433697536,     0.000142673349608,     0.000112274300263,     0.000091665327178,     0.000076979866371,     0.000066088826581,     0.000057744943506,     0.000051178851132,     0.000045894874275,     0.000041561617554,
     0.332540369680845,     0.023360229912506,     0.004877153860159,     0.001659201716727,     0.000759810358720,     0.000423463965156,     0.000269929485454,     0.000189012562510,     0.000141555177069,     0.000111361484994,
     0.000090898823353,     0.000076321856841,     0.000065513928456,     0.000057235442827,     0.000050721974160,     0.000045481149814,     0.000041183853590,     0.332307010963195,     0.023311541207531,     0.004860599763044,
     0.001651624741429,     0.000755589184100,     0.000420774097383,     0.000268046419066,     0.000187602563695,     0.000140446094467,     0.000110456301958,     0.000090138870963,     0.000075669570894,     0.000064944102564,
     0.000056730490295,     0.000050269215601,     0.000045071185677,     0.000040809547391,     0.332074138306152,     0.023263017665381,     0.004844121225072,     0.001644089843696,     0.000751394814238,     0.000418102989959,
     0.000266177397361,     0.000186203610574,     0.000139346025807,     0.000109558685926,     0.000089385413025,     0.000075022958033,     0.000064379303627,     0.000056230044912,     0.000049820538026,     0.000044664947447,
     0.000040438667115,     0.331841750061857,     0.023214658532564,     0.004827717826802,     0.001636596756418,     0.000747227062232,     0.000415450502987,     0.000264322310334,     0.000184815613384,     0.000138254895741,
     0.000108668572237,     0.000088638393059,     0.000074381968215,     0.000063819486777,     0.000055734066054,     0.000049375904346,     0.000044262401021,     0.000040071181216,     0.331609844589968,     0.023166463059769,
     0.004811389151459,     0.001629145214344,     0.000743085742573,     0.000412816497667,     0.000262481048871,     0.000183438483113,     0.000137172629568,     0.000107785896792,     0.000087897755082,     0.000073746551839,
     0.000063264607551,     0.000055242513468,     0.000048935277813,     0.000043863512612,     0.000039707058439,     0.331378420257612,     0.023118430501839,     0.004795134784910,     0.001621734954073,     0.000738970671133,
     0.000410200836286,     0.000260653504743,     0.000182072131493,     0.000136099153223,     0.000106910596047,     0.000087163443608,     0.000073116659752,     0.000062714621887,     0.000054755347263,     0.000048498622012,
     0.000043468248745,     0.000039346267816,     0.331147475439352,     0.023070560117747,     0.004778954315644,     0.001614365714036,     0.000734881665156,     0.000407603382206,     0.000258839570604,     0.000180716470994,
     0.000135034393275,     0.000106042607015,     0.000086435403635,     0.000072492243235,     0.000062169486117,     0.000054272527912,     0.000048065900866,     0.000043076576251,     0.000038988778670,     0.330917008517135,
     0.023022851170565,     0.004762847334761,     0.001607037234489,     0.000730818543250,     0.000405023999862,     0.000257039139976,     0.000179371414816,     0.000133978276918,     0.000105181867251,     0.000085713580652,
     0.000071873254007,     0.000061629156969,     0.000053794016249,     0.000047637078626,     0.000042688462268,     0.000038634560605,     0.330687017880261,     0.022975302927445,     0.004746813435946,     0.001599749257492,
     0.000726781125368,     0.000402462554747,     0.000255252107247,     0.000178036876884,     0.000132930731972,     0.000104328314858,     0.000084997920624,     0.000071259644217,     0.000061093591562,     0.000053319773461,
     0.000047212119868,     0.000042303874235,     0.000038283583506,     0.330457501925336,     0.022927914659586,     0.004730852215456,     0.001592501526898,     0.000722769232809,     0.000399918913406,     0.000253478367662,
     0.000176712771844,     0.000131891686868,     0.000103481888474,     0.000084288369994,     0.000070651366439,     0.000060562747399,     0.000052849761090,     0.000046790989495,     0.000041922779894,     0.000037935817539,
     0.330228459056234,     0.022880685642212,     0.004714963272101,     0.001585293788342,     0.000718782688196,     0.000397392943430,     0.000251717817316,     0.000175399015051,     0.000130861070652,     0.000102642527271,
     0.000083584875679,     0.000070048373672,     0.000060036582366,     0.000052383941026,     0.000046373652731,     0.000041545147279,     0.000037591233145,     0.329999887684059,     0.022833615154549,     0.004699146207225,
     0.001578125789228,     0.000714821315474,     0.000394884513440,     0.000249970353147,     0.000174095522569,     0.000129838812973,     0.000101810170948,     0.000082887385060,     0.000069450619333,     0.000059515054730,
     0.000051922275505,     0.000045960075116,     0.000041170944723,     0.000037249801037,     0.329771786227101,     0.022786702479794,     0.004683400624688,     0.001570997278709,     0.000710884939895,     0.000392393493087,
     0.000248235872928,     0.000172802211162,     0.000128824844082,     0.000100984759731,     0.000082195845984,     0.000068858057257,     0.000058998123132,     0.000051464727107,     0.000045550222508,     0.000040800140848,
     0.000036911492202,     0.329544153110797,     0.022739946905093,     0.004667726130853,     0.001563908007684,     0.000706973388011,     0.000389919753039,     0.000246514275262,     0.000171518998288,     0.000127819094826,
     0.000100166234363,     0.000081510206759,     0.000068270641687,     0.000058485746588,     0.000051011258751,     0.000045144061074,     0.000040432704564,     0.000036576277893,     0.329316986767696,     0.022693347721518,
     0.004652122334561,     0.001556857728777,     0.000703086487661,     0.000387463164975,     0.000244805459573,     0.000170245802095,     0.000126821496638,     0.000099354536101,     0.000080830416147,     0.000067688327277,
     0.000057977884480,     0.000050561833693,     0.000044741557294,     0.000040068605070,     0.000036244129631,     0.329090285637414,     0.022646904224039,     0.004636588847122,     0.001549846196329,     0.000699224067963,
     0.000385023601574,     0.000243109326101,     0.000168982541412,     0.000125831981541,     0.000098549606714,     0.000080156423360,     0.000067111069084,     0.000057474496558,     0.000050116415524,     0.000044342677952,
     0.000039707811845,     0.000035915019198,     0.328864048166599,     0.022600615711501,     0.004621125282293,     0.001542873166381,     0.000695385959302,     0.000382600936509,     0.000241425775895,     0.000167729135746,
     0.000124850482133,     0.000097751388475,     0.000079488178060,     0.000066538822565,     0.000056975542933,     0.000049674968163,     0.000043947390137,     0.000039350294653,     0.000035588918639,     0.328638272808892,
     0.022554481486598,     0.004605731256261,     0.001535938396667,     0.000691571993323,     0.000380195044439,     0.000239754710803,     0.000166485505273,     0.000123876931591,     0.000096959824161,     0.000078825630350,
     0.000065971543576,     0.000056480984077,     0.000049237455858,     0.000043555661239,     0.000038996023532,     0.000035265800257,     0.328412958024887,     0.022508500855851,     0.004590406387628,     0.001529041646597,
     0.000687782002918,     0.000377805801001,     0.000238096033469,     0.000165251570838,     0.000122911263660,     0.000096174857041,     0.000078168730775,     0.000065409188365,     0.000055990780817,     0.000048803843183,
     0.000043167458945,     0.000038644968799,     0.000034945636612,     0.328188102282094,     0.022462673129584,     0.004575150297393,     0.001522182677244,     0.000684015822219,     0.000375433082799,     0.000236449647327,
     0.000164027253944,     0.000121953412648,     0.000095396430881,     0.000077517430315,     0.000064851713570,     0.000055504894332,     0.000048374095031,     0.000042782751239,     0.000038297101041,     0.000034628400516,
     0.327963704054900,     0.022416997621898,     0.004559962608938,     0.001515361251335,     0.000680273286586,     0.000373076767403,     0.000234815456591,     0.000162812476746,     0.000121003313425,     0.000094624489933,
     0.000076871680379,     0.000064299076217,     0.000055023286151,     0.000047948176615,     0.000042401506398,     0.000037952391120,     0.000034314065035,     0.327739761824535,     0.022371473650647,     0.004544842948008,
     0.001508577133240,     0.000676554232600,     0.000370736733333,     0.000233193366251,     0.000161607162051,     0.000120060901416,     0.000093858978933,     0.000076231432808,     0.000063751233713,     0.000054545918149,
     0.000047526053465,     0.000042023692987,     0.000037610810161,     0.000034002603483,     0.327516274079028,     0.022326100537419,     0.004529790942694,     0.001501830088952,     0.000672858498050,     0.000368412860057,
     0.000231583282064,     0.000160411233307,     0.000119126112596,     0.000093099843095,     0.000075596639863,     0.000063208143846,     0.000054072752545,     0.000047107691421,     0.000041649279860,     0.000037272329558,
     0.000033693989419,     0.327293239313176,     0.022280877607507,     0.004514806223424,     0.001495119886084,     0.000669185921928,     0.000366105027983,     0.000229985110551,     0.000159224614600,     0.000118198883484,
     0.000092347028111,     0.000074967254228,     0.000062669764779,     0.000053603751896,     0.000046693056636,     0.000041278236156,     0.000036936920968,     0.000033388196650,     0.327070656028504,     0.022235804189888,
     0.004499888422937,     0.001488446293852,     0.000665536344415,     0.000363813118446,     0.000228398758990,     0.000158047230649,     0.000117279151143,     0.000091600480143,     0.000074343229003,     0.000062136055049,
     0.000053138879100,     0.000046282115568,     0.000040910531294,     0.000036604556308,     0.000033085199223,     0.326848522733228,     0.022190879617202,     0.004485037176276,     0.001481809083063,     0.000661909606876,
     0.000361537013710,     0.000226824135405,     0.000156879006796,     0.000116366853169,     0.000090860145818,     0.000073724517700,     0.000061606973561,     0.000052678097383,     0.000045874834982,     0.000040546134976,
     0.000036275207752,     0.000032784971425,     0.326626837942223,     0.022146103225726,     0.004470252120764,     0.001475208026106,     0.000658305551848,     0.000359276596949,     0.000225261148567,     0.000155719869010,
     0.000115461927691,     0.000090125972229,     0.000073111074240,     0.000061082479586,     0.000052221370308,     0.000045471181941,     0.000040185017178,     0.000035948847732,     0.000032487487782,     0.326405600176978,
     0.022101474355351,     0.004455532895994,     0.001468642896939,     0.000654724023031,     0.000357031752251,     0.000223709707983,     0.000154569743872,     0.000114564313364,     0.000089397906926,     0.000072502852951,
     0.000060562532759,     0.000051768661762,     0.000045071123809,     0.000039827148151,     0.000035625448933,     0.000032192723055,     0.326184807965567,     0.022056992349564,     0.004440879143814,     0.001462113471075,
     0.000651164865280,     0.000354802364601,     0.000222169723890,     0.000153428558575,     0.000113673949365,     0.000088675897914,     0.000071899808561,     0.000060047093075,     0.000051319935957,     0.000044674628247,
     0.000039472498419,     0.000035304984291,     0.000031900652238,     0.325964459842614,     0.022012656555420,     0.004426290508305,     0.001455619525576,     0.000647627924596,     0.000352588319882,     0.000220641107252,
     0.000152296240918,     0.000112790775390,     0.000087959893648,     0.000071301896198,     0.000059536120883,     0.000050875157428,     0.000044281663207,     0.000039121038774,     0.000034987426991,     0.000031611250556,
     0.325744554349252,     0.021968466323522,     0.004411766635773,     0.001449160839036,     0.000644113048116,     0.000350389504859,     0.000219123769752,     0.000151172719300,     0.000111914731647,     0.000087249843031,
     0.000070709071383,     0.000059029576886,     0.000050434291030,     0.000043892196934,     0.000038772740276,     0.000034672750465,     0.000031324493465,     0.325525090033090,     0.021924421008000,     0.004397307174728,
     0.001442737191572,     0.000640620084107,     0.000348205807182,     0.000217617623783,     0.000150057922715,     0.000111045758853,     0.000086545695409,     0.000070121290029,     0.000058527422138,     0.000049997301932,
     0.000043506197960,     0.000038427574250,     0.000034360928388,     0.000031040356645,     0.325306065448179,     0.021880519966487,     0.004382911775872,     0.001436348364815,     0.000637148881953,     0.000346037115368,
     0.000216122582449,     0.000148951780749,     0.000110183798229,     0.000085847400565,     0.000069538508438,     0.000058029618038,     0.000049564155617,     0.000043123635102,     0.000038085512281,     0.000034051934678,
     0.000030758816004,     0.325087479154977,     0.021836762560099,     0.004368580092085,     0.001429994141892,     0.000633699292149,     0.000343883318805,     0.000214638559552,     0.000147854223571,     0.000109328791498,
     0.000085154908719,     0.000068960683294,     0.000057536126330,     0.000049134817879,     0.000042744477461,     0.000037746526214,     0.000033745743493,     0.000030479847671,     0.324869329720312,     0.021793148153412,
     0.004354311778407,     0.001423674307425,     0.000630271166292,     0.000341744307734,     0.000213165469592,     0.000146765181932,     0.000108480680876,     0.000084468170521,     0.000068387771663,     0.000057046909098,
     0.000048709254819,     0.000042368694418,     0.000037410588154,     0.000033442329229,     0.000030203427994,     0.324651615717350,     0.021749676114440,     0.004340106492022,     0.001417388647511,     0.000626864357073,
     0.000339619973252,     0.000211703227757,     0.000145684587158,     0.000107639409072,     0.000083787137049,     0.000067819730989,     0.000056561928764,     0.000048287432843,     0.000041996255630,     0.000037077670458,
     0.000033141666516,     0.000029929533544,     0.324434335725559,     0.021706345814616,     0.004325963892249,     0.001411136949716,     0.000623478718266,     0.000337510207299,     0.000210251749920,     0.000144612371144,
     0.000106804919281,     0.000083111759805,     0.000067256519089,     0.000056081148082,     0.000047869318659,     0.000041627131032,     0.000036747745736,     0.000032843730218,     0.000029658141104,     0.324217488330678,
     0.021663156628768,     0.004311883640524,     0.001404919003062,     0.000620114104723,     0.000335414902652,     0.000208810952630,     0.000143548466353,     0.000105977155182,     0.000082441990711,     0.000066698094152,
     0.000055604530141,     0.000047454879275,     0.000041261290830,     0.000036420786849,     0.000032548495431,     0.000029389227675,     0.324001072124677,     0.021620107935101,     0.004297865400383,     0.001398734598018,
     0.000616770372363,     0.000333333952921,     0.000207380753112,     0.000142492805808,     0.000105156060932,     0.000081777782104,     0.000066144414732,     0.000055132038356,     0.000047044081993,     0.000040898705499,
     0.000036096766905,     0.000032255937477,     0.000029122770470,     0.323785085705730,     0.021577199115170,     0.004283908837452,     0.001392583526487,     0.000613447378166,     0.000331267252538,     0.000205961069255,
     0.000141445323086,     0.000104341581163,     0.000081119086735,     0.000065595439752,     0.000054663636469,     0.000046636894413,     0.000040539345784,     0.000035775659258,     0.000031966031909,     0.000028858746909,
     0.323569527678179,     0.021534429553869,     0.004270013619431,     0.001386465581800,     0.000610144980164,     0.000329214696755,     0.000204551819610,     0.000140405952319,     0.000103533660976,     0.000080465857763,
     0.000065051128490,     0.000054199288543,     0.000046233284422,     0.000040183182694,     0.000035457437506,     0.000031678754502,     0.000028597134627,     0.323354396652497,     0.021491798639400,     0.004256179416078,
     0.001380380558700,     0.000606863037429,     0.000327176181634,     0.000203152923386,     0.000139374628183,     0.000102732245941,     0.000079818048754,     0.000064511440586,     0.000053738958961,     0.000045833220199,
     0.000039830187501,     0.000035142075487,     0.000031394081253,     0.000028337911460,     0.323139691245263,     0.021449305763259,     0.004242405899198,     0.001374328253334,     0.000603601410073,     0.000325151604043,
     0.000201764300441,     0.000138351285897,     0.000101937282088,     0.000079175613673,     0.000063976336034,     0.000053282612425,     0.000045436670208,     0.000039480331738,     0.000034829547280,     0.000031111988382,
     0.000028081055452,     0.322925410079122,     0.021406950320215,     0.004228692742627,     0.001368308463244,     0.000600359959231,     0.000323140861646,     0.000200385871277,     0.000137335861216,     0.000101148715906,
     0.000078538506887,     0.000063445775178,     0.000052830213947,     0.000045043603194,     0.000039133587195,     0.000034519827197,     0.000030832452326,     0.000027826544848,     0.322711551782756,     0.021364731708286,
     0.004215039622219,     0.001362320987354,     0.000597138547061,     0.000321143852901,     0.000199017557037,     0.000136328290430,     0.000100366494340,     0.000077906683155,     0.000062919718710,     0.000052381728854,
     0.000044653988186,     0.000038789925919,     0.000034212889788,     0.000030555449739,     0.000027574358097,     0.322498114990849,     0.021322649328724,     0.004201446215832,     0.001356365625963,     0.000593937036730,
     0.000319160477050,     0.000197659279499,     0.000135328510356,     0.000099590564783,     0.000077280097628,     0.000062398127670,     0.000051937122779,     0.000044267794490,     0.000038449320208,     0.000033908709834,
     0.000030280957489,     0.000027324473844,     0.322285098344059,     0.021280702585990,     0.004187912203313,     0.001350442180733,     0.000590755292410,     0.000317190634114,     0.000196310961070,     0.000134336458335,
     0.000098820875075,     0.000076658705846,     0.000061880963438,     0.000051496361661,     0.000043884991688,     0.000038111742614,     0.000033607262347,     0.000030008952657,     0.000027076870932,     0.322072500488981,
     0.021238890887739,     0.004174437266486,     0.001344550454678,     0.000587593179269,     0.000315234224888,     0.000194972524779,     0.000133352072227,     0.000098057373500,     0.000076042463731,     0.000061368187733,
     0.000051059411743,     0.000043505549635,     0.000037777165935,     0.000033308522566,     0.000029739412536,     0.000026831528401,     0.321860320078120,     0.021197213644796,     0.004161021089141,     0.001338690252156,
     0.000584450563462,     0.000313291150933,     0.000193643894277,     0.000132375290408,     0.000097300008781,     0.000075431327589,     0.000060859762611,     0.000050626239566,     0.000043129438456,     0.000037445563219,
     0.000033012465956,     0.000029472314624,     0.000026588425484,     0.321648555769855,     0.021155670271139,     0.004147663357013,     0.001332861378860,     0.000581327312125,     0.000311361314569,     0.000192324993827,
     0.000131406051765,     0.000096548730073,     0.000074825254103,     0.000060355650460,     0.000050196811970,     0.000042756628546,     0.000037116907753,     0.000032719068207,     0.000029207636629,     0.000026347541604,
     0.321437206228409,     0.021114260183880,     0.004134363757776,     0.001327063641805,     0.000578223293368,     0.000309444618873,     0.000191015748300,     0.000130444295688,     0.000095803486966,     0.000074224200328,
     0.000059855813999,     0.000049771096088,     0.000042387090565,     0.000036791173072,     0.000032428305230,     0.000028945356463,     0.000026108856376,     0.321226270123822,     0.021072982803242,     0.004121121981028,
     0.001321296849321,     0.000575138376266,     0.000307540967669,     0.000189716083172,     0.000129489962073,     0.000095064229476,     0.000073628123693,     0.000059360216275,     0.000049349059349,     0.000042020795437,
     0.000036468332946,     0.000032140153158,     0.000028685452240,     0.000025872349604,     0.321015746131912,     0.021031837552546,     0.004107937718276,     0.001315560811041,     0.000572072430851,     0.000305650265522,
     0.000188425924516,     0.000128542991312,     0.000094330908043,     0.000073036981995,     0.000058868820656,     0.000048930669466,     0.000041657714345,     0.000036148361385,     0.000031854588338,     0.000028427902276,
     0.000025638001276,     0.320805632934250,     0.020990823858185,     0.004094810662924,     0.001309855337895,     0.000569025328108,     0.000303772417735,     0.000187145199000,     0.000127603324290,     0.000093603473526,
     0.000072450733394,     0.000058381590836,     0.000048515894444,     0.000041297818733,     0.000035831232633,     0.000031571587336,     0.000028172685086,     0.000025405791568,     0.320595929218129,     0.020949941149612,
     0.004081740510260,     0.001304180242097,     0.000565996939962,     0.000301907330340,     0.000185873833880,     0.000126670902381,     0.000092881877203,     0.000071869336413,     0.000057898490823,     0.000048104702568,
     0.000040941080301,     0.000035516921169,     0.000031291126931,     0.000027919779382,     0.000025175700836,     0.320386633676531,     0.020909188859314,     0.004068726957446,     0.001298535337138,     0.000562987139277,
     0.000300054910096,     0.000184611756996,     0.000125745667446,     0.000092166070763,     0.000071292749931,     0.000057419484945,     0.000047697062407,     0.000040587471003,     0.000035205401702,     0.000031013184114,
     0.000027669164071,     0.000024947709619,     0.320177745008097,     0.020868566422800,     0.004055769703499,     0.001292920437774,     0.000559995799845,     0.000298215064478,     0.000183358896767,     0.000124827561826,
     0.000091456006305,     0.000070720933185,     0.000056944537840,     0.000047292942810,     0.000040236963044,     0.000034896649171,     0.000030737736085,     0.000027420818255,     0.000024721798637,     0.319969261917101,
     0.020828073278579,     0.004042868449285,     0.001287335360021,     0.000557022796378,     0.000296387701675,     0.000182115182186,     0.000123916528338,     0.000090751636335,     0.000070153845762,     0.000056473614457,
     0.000046892312900,     0.000039889528879,     0.000034590638740,     0.000030464760253,     0.000027174721228,     0.000024497948785,     0.319761183113413,     0.020787708868140,     0.004030022897503,     0.001281779921141,
     0.000554068004506,     0.000294572730584,     0.000180880542815,     0.000123012510275,     0.000090052913759,     0.000069591447599,     0.000056006680052,     0.000046495142077,     0.000039545141211,     0.000034287345800,
     0.000030194234233,     0.000026930852472,     0.000024276141136,     0.319553507312477,     0.020747472635939,     0.004017232752671,     0.001276253939637,     0.000551131300762,     0.000292770060801,     0.000179654908783,
     0.000122115451394,     0.000089359791884,     0.000069033698979,     0.000055543700186,     0.000046101400011,     0.000039203772986,     0.000033986745963,     0.000029926135844,     0.000026689191660,     0.000024056356940,
     0.319346233235276,     0.020707364029376,     0.004004497721120,     0.001270757235241,     0.000548212562584,     0.000290979602622,     0.000178438210776,     0.000121225295922,     0.000088672224412,     0.000068480560527,
     0.000055084640723,     0.000045711056642,     0.000038865397395,     0.000033688815064,     0.000029660443107,     0.000026449718650,     0.000023838577615,     0.319139359608304,     0.020667382498779,     0.003991817510973,
     0.001265289628906,     0.000545311668301,     0.000289201267028,     0.000177230380038,     0.000120341988544,     0.000087990165437,     0.000067931993209,     0.000054629467824,     0.000045324082177,     0.000038529987868,
     0.000033393529155,     0.000029397134245,     0.000026212413486,     0.000023622784756,     0.318932885163537,     0.020627527497386,     0.003979191832141,     0.001259850942798,     0.000542428497130,     0.000287434965691,
     0.000176031348361,     0.000119465474404,     0.000087313569440,     0.000067387958327,     0.000054178147948,     0.000044940447086,     0.000038197518074,     0.000033100864505,     0.000029136187677,     0.000025977256395,
     0.000023408960125,     0.318726808638405,     0.020587798481326,     0.003966620396305,     0.001254441000286,     0.000539562929166,     0.000285680610957,     0.000174841048087,     0.000118595699096,     0.000086642391290,
     0.000066848417518,     0.000053730647848,     0.000044560122103,     0.000037867961919,     0.000032810797598,     0.000028877582022,     0.000025744227783,     0.000023197085652,     0.318521128775763,     0.020548194909605,
     0.003954102916908,     0.001249059625934,     0.000536714845379,     0.000283938115848,     0.000173659412096,     0.000117732608667,     0.000085976586236,     0.000066313332748,     0.000053286934569,     0.000044183078221,
     0.000037541293541,     0.000032523305132,     0.000028621296091,     0.000025513308241,     0.000022987143436,     0.318315844323860,     0.020508716244083,     0.003941639109140,     0.001243706645492,     0.000533884127604,
     0.000282207394056,     0.000172486373809,     0.000116876149609,     0.000085316109907,     0.000065782666313,     0.000052846975443,     0.000043809286692,     0.000037217487312,     0.000032238364014,     0.000028367308891,
     0.000025284478533,     0.000022779115738,     0.318110954036312,     0.020469361949460,     0.003929228689929,     0.001238381885887,     0.000531070658539,     0.000280488359933,     0.000171321867176,     0.000116026268854,
     0.000084660918307,     0.000065256380833,     0.000052410738089,     0.000043438719019,     0.000036896517833,     0.000031955951361,     0.000028115599618,     0.000025057719603,     0.000022572984987,     0.317906456672076,
     0.020430131493260,     0.003916871377926,     0.001233085175214,     0.000528274321730,     0.000278780928492,     0.000170165826680,     0.000115182913773,     0.000084010967811,     0.000064734439252,     0.000051978190410,
     0.000043071346963,     0.000036578359932,     0.000031676044498,     0.000027866147659,     0.000024833012568,     0.000022368733771,     0.317702350995418,     0.020391024345810,     0.003904566893497,     0.001227816342730,
     0.000525495001574,     0.000277085015396,     0.000169018187323,     0.000114346032171,     0.000083366215164,     0.000064216804832,     0.000051549300591,     0.000042707142532,     0.000036262988665,     0.000031398620952,
     0.000027618932589,     0.000024610338720,     0.000022166344840,     0.317498635775887,     0.020352039980225,     0.003892314958710,     0.001222575218843,     0.000522732583307,     0.000275400536957,     0.000167878884630,
     0.000113515572286,     0.000082726617478,     0.000063703441152,     0.000051124037093,     0.000042346077984,     0.000035950379310,     0.000031123658457,     0.000027373934169,     0.000024389679521,     0.000021965801102,
     0.317295309788288,     0.020313177872392,     0.003880115297320,     0.001217361635104,     0.000519986952997,     0.000273727410128,     0.000166747854643,     0.000112691482780,     0.000082092132226,     0.000063194312107,
     0.000050702368657,     0.000041988125821,     0.000035640507366,     0.000030851134947,     0.000027131132345,     0.000024171016604,     0.000021767085624,     0.317092371812652,     0.020274437500950,     0.003867967634765,
     0.001212175424200,     0.000517257997540,     0.000272065552500,     0.000165625033910,     0.000111873712741,     0.000081462717240,     0.000062689381899,     0.000050284264293,     0.000041633258792,     0.000035333348554,
     0.000030581028554,     0.000026890507244,     0.000023954331770,     0.000021570181629,     0.316889820634210,     0.020235818347277,     0.003855871698147,     0.001207016419945,     0.000514545604655,     0.000270414882295,
     0.000164510359491,     0.000111062211674,     0.000080838330710,     0.000062188615043,     0.000049869693287,     0.000041281449887,     0.000035028878810,     0.000030313317612,     0.000026652039176,     0.000023739606988,
     0.000021375072496,     0.316687655043367,     0.020197319895471,     0.003843827216228,     0.001201884457270,     0.000511849662874,     0.000268775318364,     0.000163403768947,     0.000110256929503,     0.000080218931179,
     0.000061691976357,     0.000049458625191,     0.000040932672332,     0.000034727074288,     0.000030047980646,     0.000026415708630,     0.000023526824392,     0.000021181741754,     0.316485873835672,     0.020158941632335,
     0.003831833919410,     0.001196779372219,     0.000509170061536,     0.000267146780176,     0.000162305200337,     0.000109457816564,     0.000079604477539,     0.000061199430963,     0.000049051029824,     0.000040586899596,
     0.000034427911355,     0.000029784996378,     0.000026181496273,     0.000023315966280,     0.000020990173087,     0.316284475811793,     0.020120683047359,     0.003819891539734,     0.001191701001937,     0.000506506690784,
     0.000265529187822,     0.000161214592216,     0.000108664823602,     0.000078994929030,     0.000060710944284,     0.000048646877271,     0.000040244105378,     0.000034131366588,     0.000029524343724,     0.000025949382948,
     0.000023107015111,     0.000020800350330,     0.316083459777490,     0.020082543632705,     0.003807999810861,     0.001186649184665,     0.000503859441557,     0.000263922462000,     0.000160131883628,     0.000107877901768,
     0.000078390245238,     0.000060226482041,     0.000048246137875,     0.000039904263614,     0.000033837416778,     0.000029266001786,     0.000025719349672,     0.000022899953507,     0.000020612257464,     0.315882824543589,
     0.020044522883189,     0.003796158468066,     0.001181623759729,     0.000501228205585,     0.000262326524019,     0.000159057014105,     0.000107097002615,     0.000077790386088,     0.000059746010248,     0.000047848782243,
     0.000039567348469,     0.000033546038919,     0.000029009949859,     0.000025491377637,     0.000022694764248,     0.000020425878621,     0.315682568925952,     0.020006620296267,     0.003784367248225,     0.001176624567534,
     0.000498612875378,     0.000260741295788,     0.000157989923660,     0.000106322078096,     0.000077195311844,     0.000059269495214,     0.000047454781236,     0.000039233334338,     0.000033257210216,     0.000028756167425,
     0.000025265448203,     0.000022491430273,     0.000020241198077,     0.315482691745455,     0.019968835372020,     0.003772625889802,     0.001171651449558,     0.000496013344228,     0.000259166699814,     0.000156930552786,
     0.000105553080560,     0.000076604983106,     0.000058796903537,     0.000047064105971,     0.000038902195843,     0.000032970908074,     0.000028504634148,     0.000025041542903,     0.000022289934677,     0.000020058200254,
     0.315283191827960,     0.019931167613133,     0.003760934132844,     0.001166704248339,     0.000493429506197,     0.000257602659197,     0.000155878842450,     0.000104789962746,     0.000076019360806,     0.000058328202104,
     0.000046676727818,     0.000038573907830,     0.000032687110103,     0.000028255329880,     0.000024819643437,     0.000022090260711,     0.000019876869719,     0.315084068004290,     0.019893616524886,     0.003749291718967,
     0.001161782807474,     0.000490861256114,     0.000256049097625,     0.000154834734089,     0.000104032677785,     0.000075438406206,     0.000057863358085,     0.000046292618396,     0.000038248445368,     0.000032405794113,
     0.000028008234654,     0.000024599731672,     0.000021892391776,     0.000019697191180,     0.314885319110201,     0.019856181615133,     0.003737698391345,     0.001156886971605,     0.000488308489567,     0.000254505939369,
     0.000153798169606,     0.000103281179191,     0.000074862080895,     0.000057402338934,     0.000045911749574,     0.000037925783747,     0.000032126938112,     0.000027763328681,     0.000024381789640,     0.000021696311431,
     0.000019519149486,     0.314686943986358,     0.019818862394289,     0.003726153894700,     0.001152016586417,     0.000485771102899,     0.000252973109279,     0.000152769091371,     0.000102535420863,     0.000074290346785,
     0.000056945112385,     0.000045534093466,     0.000037605898478,     0.000031850520307,     0.000027520592355,     0.000024165799536,     0.000021502003381,     0.000019342729626,     0.314488941478310,     0.019781658375315,
     0.003714657975292,     0.001147171498624,     0.000483248993203,     0.000251450532778,     0.000151747442207,     0.000101795357077,     0.000073723166112,     0.000056491646448,     0.000045159622431,     0.000037288765286,
     0.000031576519098,     0.000027280006243,     0.000023951743719,     0.000021309451482,     0.000019167916727,     0.314291310436461,     0.019744569073700,     0.003703210380910,     0.001142351555970,     0.000480742058312,
     0.000249938135860,     0.000150733165398,     0.000101060942488,     0.000073160501427,     0.000056041909410,     0.000044788309067,     0.000036974360112,     0.000031304913079,     0.000027041551091,     0.000023739604706,
     0.000021118639739,     0.000018994696055,     0.314094049716051,     0.019707594007449,     0.003691810860860,     0.001137556607214,     0.000478250196799,     0.000248435845083,     0.000149726204677,     0.000100332132119,
     0.000072602315599,     0.000055595869832,     0.000044420126215,     0.000036662659111,     0.000031035681036,     0.000026805207817,     0.000023529365176,     0.000020929552302,     0.000018823053009,     0.313897158177126,
     0.019670732697066,     0.003680459165954,     0.001132786502125,     0.000475773307966,     0.000246943587566,     0.000148726504224,     0.000099608881369,     0.000072048571809,     0.000055153496541,     0.000044055046950,
     0.000036353638648,     0.000030768801946,     0.000026570957513,     0.000023321007965,     0.000020742173468,     0.000018652973125,     0.313700634684514,     0.019633984665539,     0.003669155048503,     0.001128041091479,
     0.000473311291844,     0.000245461290983,     0.000147734008665,     0.000098891145998,     0.000071499233550,     0.000054714758636,     0.000043693044585,     0.000036047275299,     0.000030504254972,     0.000026338781440,
     0.000023114516063,     0.000020556487677,     0.000018484442072,     0.313504478107801,     0.019597349438325,     0.003657898262304,     0.001123320227043,     0.000470864049183,     0.000243988883560,     0.000146748663066,
     0.000098178882133,     0.000070954264621,     0.000054279625481,     0.000043334092664,     0.000035743545844,     0.000030242019465,     0.000026108661030,     0.000022909872619,     0.000020372479511,     0.000018317445650,
     0.313308687321307,     0.019560826543338,     0.003646688562632,     0.001118623761579,     0.000468431481447,     0.000242526294070,     0.000145770412929,     0.000097472046261,     0.000070413629126,     0.000053848066702,
     0.000042978164965,     0.000035442427273,     0.000029982074961,     0.000025880577882,     0.000022707060932,     0.000020190133695,     0.000018151969790,     0.313113261204060,     0.019524415510929,     0.003635525706230,
     0.001113951548824,     0.000466013490811,     0.000241073451830,     0.000144799204191,     0.000096770595225,     0.000069877291472,     0.000053420052188,     0.000042625235492,     0.000035143896776,     0.000029724401177,
     0.000025654513761,     0.000022506064454,     0.000020009435093,     0.000017988000556,     0.312918198639771,     0.019488115873875,     0.003624409451297,     0.001109303443496,     0.000463609980153,     0.000239630286694,
     0.000143834983218,     0.000096074486223,     0.000069345216367,     0.000052995552084,     0.000042275278478,     0.000034847931747,     0.000029468978015,     0.000025430450597,     0.000022306866789,     0.000019830368708,
     0.000017825524136,     0.312723498516814,     0.019451927167366,     0.003613339557483,     0.001104679301276,     0.000461220853052,     0.000238196729050,     0.000142877696801,     0.000095383676806,     0.000068817368815,
     0.000052574536795,     0.000041928268380,     0.000034554509780,     0.000029215785555,     0.000025208370483,     0.000022109451689,     0.000019652919680,     0.000017664526847,     0.312529159728197,     0.019415848928985,
     0.003602315785873,     0.001100078978809,     0.000458846013778,     0.000236772709818,     0.000141927292157,     0.000094698124871,     0.000068293714113,     0.000052156976978,     0.000041584179880,     0.000034263608666,
     0.000028964804055,     0.000024988255675,     0.000021913803054,     0.000019477073286,     0.000017504995133,     0.312335181171541,     0.019379880698699,     0.003591337898982,     0.001095502333691,     0.000456485367289,
     0.000235358160442,     0.000140983716918,     0.000094017788662,     0.000067774217854,     0.000051742843543,     0.000041242987877,     0.000033975206394,     0.000028716013949,     0.000024770088587,     0.000021719904930,
     0.000019302814937,     0.000017346915563,     0.312141561749055,     0.019344022018843,     0.003580405660746,     0.001090949224468,     0.000454138819229,     0.000233953012888,     0.000140046919136,     0.000093342626766,
     0.000067258845917,     0.000051332107648,     0.000040904667495,     0.000033689281147,     0.000028469395849,     0.000024553851794,     0.000021527741510,     0.000019130130178,     0.000017190274828,     0.311948300367514,
     0.019308272434105,     0.003569518836509,     0.001086419510624,     0.000451806275917,     0.000232557199640,     0.000139116847272,     0.000092672598109,     0.000066747564471,     0.000050924740703,     0.000040569194070,
     0.000033405811301,     0.000028224930537,     0.000024339528027,     0.000021337297129,     0.000018959004688,     0.000017035059744,     0.311755395938233,     0.019272631491511,     0.003558677193014,     0.001081913052578,
     0.000449487644346,     0.000231170653694,     0.000138193450199,     0.000092007661953,     0.000066240339968,     0.000050520714359,     0.000040236543156,     0.000033124775424,     0.000027982598969,     0.000024127100173,
     0.000021148556266,     0.000018789424275,     0.000016881257247,     0.311562847377046,     0.019237098740415,     0.003547880498400,     0.001077429711673,     0.000447182832174,     0.000229793308556,     0.000137276677193,
     0.000091347777897,     0.000065737139142,     0.000050120000512,     0.000039906690519,     0.000032846152272,     0.000027742382270,     0.000023916551274,     0.000020961503540,     0.000018621374878,     0.000016728854393,
     0.311370653604281,     0.019201673732482,     0.003537128522183,     0.001072969350175,     0.000444891747725,     0.000228425098237,     0.000136366477934,     0.000090692905868,     0.000065237929009,     0.000049722571301,
     0.000039579612138,     0.000032569920791,     0.000027504261736,     0.000023707864526,     0.000020776123711,     0.000018454842564,     0.000016577838359,     0.311178813544739,     0.019166356021674,     0.003526421035255,
     0.001068531831263,     0.000442614299978,     0.000227065957251,     0.000135462802501,     0.000090043006124,     0.000064742676860,     0.000049328399101,     0.000039255284201,     0.000032296060112,     0.000027268218828,
     0.000023501023274,     0.000020592401678,     0.000018289813530,     0.000016428196439,     0.310987326127670,     0.019131145164238,     0.003515757809869,     0.001064117019021,     0.000440350398566,     0.000225715820606,
     0.000134565601369,     0.000089398039246,     0.000064251350262,     0.000048937456527,     0.000038933683102,     0.000032024549551,     0.000027034235174,     0.000023296011016,     0.000020410322475,     0.000018126274097,
     0.000016279916045,     0.310796190286748,     0.019096040718693,     0.003505138619635,     0.001059724778436,     0.000438099953767,     0.000224374623807,     0.000133674825404,     0.000088757966140,     0.000063763917054,
     0.000048549716428,     0.000038614785444,     0.000031755368605,     0.000026802292566,     0.000023092811398,     0.000020229871276,     0.000017964210713,     0.000016132984704,     0.310605404960054,     0.019061042245812,
     0.003494563239509,     0.001055354975387,     0.000435862876503,     0.000223042302844,     0.000132790425863,     0.000088122748033,     0.000063280345348,     0.000048165151884,     0.000038298568032,     0.000031488496956,
     0.000026572372958,     0.000022891408213,     0.000020051033386,     0.000017803609947,     0.000015987390058,     0.310414969090047,     0.019026149308615,     0.003484031445780,     0.001051007476642,     0.000433639078336,
     0.000221718794196,     0.000131912354388,     0.000087492346467,     0.000062800603520,     0.000047783736210,     0.000037985007875,     0.000031223914462,     0.000026344458467,     0.000022691785401,     0.000019873794246,
     0.000017644458497,     0.000015843119863,     0.310224881623545,     0.018991361472350,     0.003473543016069,     0.001046682149850,     0.000431428471455,     0.000220404034822,     0.000131040563005,     0.000086866723301,
     0.000062324660216,     0.000047405442945,     0.000037674082179,     0.000030961601162,     0.000026118531368,     0.000022493927047,     0.000019698139429,     0.000017486743176,     0.000015700161989,     0.310035141511705,
     0.018956678304484,     0.003463097729315,     0.001042378863533,     0.000429230968683,     0.000219097962161,     0.000130175004120,     0.000086245840705,     0.000061852484341,     0.000047030245860,     0.000037365768353,
     0.000030701537269,     0.000025894574097,     0.000022297817379,     0.000019524054639,     0.000017330450922,     0.000015558504416,     0.309845747709996,     0.018922099374686,     0.003452695365766,     0.001038097487084,
     0.000427046483463,     0.000217800514122,     0.000129315630515,     0.000085629661159,     0.000061384045065,     0.000046658118947,     0.000037060044001,     0.000030443703172,     0.000025672569244,     0.000022103440768,
     0.000019351525710,     0.000017175568793,     0.000015418135235,     0.309656699178179,     0.018887624254819,     0.003442335706973,     0.001033837890758,     0.000424874929858,     0.000216511629089,     0.000128462395344,
     0.000085018147450,     0.000060919311814,     0.000046289036422,     0.000036756886922,     0.000030188079434,     0.000025452499556,     0.000021910781726,     0.000019180538605,     0.000017022083962,     0.000015279042649,
     0.309467994880286,     0.018853252518922,     0.003432018535780,     0.001029599945666,     0.000422716222542,     0.000215231245909,     0.000127615252136,     0.000084411262670,     0.000060458254273,     0.000045922972724,
     0.000036456275109,     0.000029934646787,     0.000025234347935,     0.000021719824903,     0.000019011079415,     0.000016869983724,     0.000015141214967,     0.309279633784600,     0.018818983743198,     0.003421743636316,
     0.001025383523769,     0.000420570276802,     0.000213959303894,     0.000126774154783,     0.000083808970213,     0.000060000842381,     0.000045559902509,     0.000036158186746,     0.000029683386138,     0.000025018097435,
     0.000021530555090,     0.000018843134357,     0.000016719255485,     0.000015004640606,     0.309091614863628,     0.018784817506005,     0.003411510793985,     0.001021188497872,     0.000418437008528,     0.000212695742813,
     0.000125939057545,     0.000083211233770,     0.000059547046329,     0.000045199800650,     0.000035862600209,     0.000029434278558,     0.000024803731260,     0.000021342957214,     0.000018676689774,     0.000016569886772,
     0.000014869308092,     0.308903937094083,     0.018750753387839,     0.003401319795460,     0.001017014741619,     0.000416316334209,     0.000211440502894,     0.000125109915041,     0.000082618017332,     0.000059096836557,
     0.000044842642236,     0.000035569494061,     0.000029187305287,     0.000024591232767,     0.000021157016338,     0.000018511732131,     0.000016421865222,     0.000014735206053,     0.308716599456865,     0.018716790971323,
     0.003391170428672,     0.001012862129485,     0.000414208170931,     0.000210193524813,     0.000124286682251,     0.000082029285182,     0.000058650183755,     0.000044488402571,     0.000035278847051,     0.000028942447732,
     0.000024380585460,     0.000020972717660,     0.000018348248020,     0.000016275178587,     0.000014602323224,     0.308529600937036,     0.018682929841196,     0.003381062482805,     0.001008730536771,     0.000412112436369,
     0.000208954749698,     0.000123469314508,     0.000081445001897,     0.000058207058858,     0.000044137057169,     0.000034990638115,     0.000028699687462,     0.000024171772989,     0.000020790046510,     0.000018186224150,
     0.000016129814731,     0.000014470648445,     0.308342940523798,     0.018649169584296,     0.003370995748285,     0.001004619839601,     0.000410029048788,     0.000207724119121,     0.000122657767500,     0.000080865132342,
     0.000057767433045,     0.000043788581752,     0.000034704846372,     0.000028459006210,     0.000023964779153,     0.000020608988353,     0.000018025647356,     0.000015985761628,     0.000014340170657,     0.308156617210476,
     0.018615509789554,     0.003360970016772,     0.001000529914909,     0.000407957927032,     0.000206501575093,     0.000121851997265,     0.000080289641668,     0.000057331277736,     0.000043442952253,     0.000034421451121,
     0.000028220385870,     0.000023759587893,     0.000020429528783,     0.000017866504588,     0.000015843007364,     0.000014210878901,     0.307970629994496,     0.018581950047975,     0.003350985081153,     0.000996460640443,
     0.000405898990523,     0.000205287060065,     0.000121051960186,     0.000079718495313,     0.000056898564593,     0.000043100144809,     0.000034140431845,     0.000027983808496,     0.000023556183296,     0.000020251653525,
     0.000017708782918,     0.000015701540133,     0.000014082762324,     0.307784977877363,     0.018548489952631,     0.003341040735534,     0.000992411894748,     0.000403852159258,     0.000204080516923,     0.000120257612992,
     0.000079151658996,     0.000056469265512,     0.000042760135764,     0.000033861768201,     0.000027749256301,     0.000023354549589,     0.000020075348431,     0.000017552469534,     0.000015561348236,     0.000013955810168,
     0.307599659864639,     0.018515129098646,     0.003331136775231,     0.000988383557171,     0.000401817353801,     0.000202881888982,     0.000119468912753,     0.000078589098715,     0.000056043352628,     0.000042422901661,
     0.000033585440027,     0.000027516711654,     0.000023154671140,     0.000019900599482,     0.000017397551741,     0.000015422420084,     0.000013830011776,     0.307414674965928,     0.018481867083187,     0.003321272996763,
     0.000984375507849,     0.000399794495282,     0.000201691119986,     0.000118685816877,     0.000078030780748,     0.000055620798307,     0.000042088419245,     0.000033311427334,     0.000027286157079,     0.000022956532458,
     0.000019727392786,     0.000017244016959,     0.000015284744190,     0.000013705356590,     0.307230022194850,     0.018448703505446,     0.003311449197843,     0.000980387627704,     0.000397783505391,     0.000200508154104,
     0.000117908283108,     0.000077476671645,     0.000055201575148,     0.000041756665462,     0.000033039710309,     0.000027057575257,     0.000022760118190,     0.000019555714574,     0.000017091852721,     0.000015148309176,
     0.000013581834148,     0.307045700569023,     0.018415637966635,     0.003301665177373,     0.000976419798438,     0.000395784306374,     0.000199332935924,     0.000117136269525,     0.000076926738232,     0.000054785655978,
     0.000041427617452,     0.000032770269310,     0.000026830949018,     0.000022565413117,     0.000019385551204,     0.000016941046676,     0.000015013103766,     0.000013459434085,     0.306861709110044,     0.018382670069970,
     0.003291920735430,     0.000972471902531,     0.000393796821030,     0.000198165410452,     0.000116369734534,     0.000076380947602,     0.000054373013855,     0.000041101252554,     0.000032503084867,     0.000026606261347,
     0.000022372402161,     0.000019216889154,     0.000016791586584,     0.000014879116787,     0.000013338146131,     0.306678046843466,     0.018349799420661,     0.003282215673267,     0.000968543823228,     0.000391820972705,
     0.000197005523109,     0.000115608636872,     0.000075839267120,     0.000053963622058,     0.000040777548297,     0.000032238137678,     0.000026383495378,     0.000022181070375,     0.000019049715026,     0.000016643460316,
     0.000014746337170,     0.000013217960110,     0.306494712798782,     0.018317025625898,     0.003272549793297,     0.000964635444540,     0.000389856685288,     0.000195853219726,     0.000114852935599,     0.000075301664415,
     0.000053557454094,     0.000040456482406,     0.000031975408610,     0.000026162634392,     0.000021991402945,     0.000018884015542,     0.000016496655853,     0.000014614753946,     0.000013098865941,     0.306311706009403,
     0.018284348294843,     0.003262922899091,     0.000960746651238,     0.000387903883209,     0.000194708446544,     0.000114102590098,     0.000074768107380,     0.000053154483689,     0.000040138032795,     0.000031714878695,
     0.000025943661820,     0.000021803385192,     0.000018719777543,     0.000016351161286,     0.000014484356245,     0.000012980853635,     0.306129025512636,     0.018251767038615,     0.003253334795369,     0.000956877328842,
     0.000385962491434,     0.000193571150206,     0.000113357560072,     0.000074238564170,     0.000052754684791,     0.000039822177565,     0.000031456529133,     0.000025726561238,     0.000021617002566,     0.000018556987989,
     0.000016206964812,     0.000014355133300,     0.000012863913295,     0.305946670349671,     0.018219281470281,     0.003243785287991,     0.000953027363623,     0.000384032435459,     0.000192441277758,     0.000112617805541,
     0.000073713003199,     0.000052358031563,     0.000039508895006,     0.000031200341285,     0.000025511316366,     0.000021432240647,     0.000018395633959,     0.000016064054739,     0.000014227074439,     0.000012748035116,
     0.305764639565555,     0.018186891204844,     0.003234274183950,     0.000949196642593,     0.000382113641308,     0.000191318776642,     0.000111883286839,     0.000073191393138,     0.000051964498387,     0.000039198163595,
     0.000030946296674,     0.000025297911070,     0.000021249085145,     0.000018235702645,     0.000015922419478,     0.000014100169089,     0.000012633209380,     0.305582932209175,     0.018154595859230,     0.003224801291366,
     0.000945385053502,     0.000380206035529,     0.000190203594699,     0.000111153964612,     0.000072673702915,     0.000051574059858,     0.000038889961990,     0.000030694376985,     0.000025086329356,     0.000021067521894,
     0.000018077181358,     0.000015782047547,     0.000013974406775,     0.000012519426463,     0.305401547333241,     0.018122395052281,     0.003215366419478,     0.000941592484831,     0.000378309545189,     0.000189095680159,
     0.000110429799817,     0.000072159901710,     0.000051186690785,     0.000038584269033,     0.000030444564061,     0.000024876555371,     0.000020887536859,     0.000017920057521,     0.000015642927567,     0.000013849777116,
     0.000012406676826,     0.305220483994265,     0.018090288404738,     0.003205969378637,     0.000937818825789,     0.000376424097872,     0.000187994981641,     0.000109710753716,     0.000071649958951,     0.000050802366185,
     0.000038281063746,     0.000030196839904,     0.000024668573404,     0.000020709116127,     0.000017764318671,     0.000015505048264,     0.000013726269826,     0.000012294951020,     0.305039741252540,     0.018058275539233,
     0.003196609980297,     0.000934063966304,     0.000374549621673,     0.000186901448150,     0.000108996787877,     0.000071143844320,     0.000050421061287,     0.000037980325331,     0.000029951186672,     0.000024462367880,
     0.000020532245910,     0.000017609952457,     0.000015368398464,     0.000013603874714,     0.000012184239683,     0.304859318172125,     0.018026356080282,     0.003187288037010,     0.000930327797023,     0.000372686045195,
     0.000185815029076,     0.000108287864170,     0.000070641527742,     0.000050042751524,     0.000037682033168,     0.000029707586676,     0.000024257923363,     0.000020356912544,     0.000017456946640,     0.000015232967096,
     0.000013482581681,     0.000012074533536,     0.304679213820825,     0.017994529654264,     0.003178003362418,     0.000926610209304,     0.000370833297544,     0.000184735674186,     0.000107583944762,     0.000070142979387,
     0.000049667412537,     0.000037386166812,     0.000029466022385,     0.000024055224552,     0.000020183102483,     0.000017305289091,     0.000015098743190,     0.000013362380723,     0.000011965823389,     0.304499427270169,
     0.017962795889422,     0.003168755771246,     0.000922911095210,     0.000368991308330,     0.000183663333625,     0.000106884992120,     0.000069648169669,     0.000049295020170,     0.000037092705993,     0.000029226476417,
     0.000023854256281,     0.000020010802308,     0.000017154967788,     0.000014965715874,     0.000013243261924,     0.000011858100135,     0.304319957595399,     0.017931154415842,     0.003159545079293,     0.000919230347509,
     0.000367160007656,     0.000182597957912,     0.000106190969004,     0.000069157069242,     0.000048925550466,     0.000036801630614,     0.000028988931541,     0.000023655003517,     0.000019839998713,     0.000017005970820,
     0.000014833874377,     0.000013125215461,     0.000011751354750,     0.304140803875442,     0.017899604865449,     0.003150371103429,     0.000915567859660,     0.000365339326119,     0.000181539497936,     0.000105501838468,
     0.000068669648997,     0.000048558979672,     0.000036512920749,     0.000028753370678,     0.000023457451362,     0.000019670678516,     0.000016858286383,     0.000014703208023,     0.000013008231599,     0.000011645578296,
     0.303961965192900,     0.017868146871994,     0.003141233661586,     0.000911923525819,     0.000363529194807,     0.000180487904956,     0.000104817563853,     0.000068185880064,     0.000048195284232,     0.000036226556643,
     0.000028519776895,     0.000023261585046,     0.000019502828650,     0.000016711902778,     0.000014573706235,     0.000012892300695,     0.000011540761913,     0.303783440634028,     0.017836780071041,     0.003132132572750,
     0.000908297240825,     0.000361729545292,     0.000179443130594,     0.000104138108791,     0.000067705733806,     0.000047834440786,     0.000035942518710,     0.000028288133406,     0.000023067389931,     0.000019336436163,
     0.000016566808412,     0.000014445358531,     0.000012777413190,     0.000011436896826,     0.303605229288713,     0.017805504099962,     0.003123067656955,     0.000904688900200,     0.000359940309627,     0.000178405126835,
     0.000103463437196,     0.000067229181819,     0.000047476426169,     0.000035660787530,     0.000028058423574,     0.000022874851507,     0.000019171488222,     0.000016422991795,     0.000014318154525,     0.000012663559616,
     0.000011333974339,     0.303427330250465,     0.017774318597921,     0.003114038735278,     0.000901098400144,     0.000358161420345,     0.000177373846025,     0.000102793513268,     0.000066756195929,     0.000047121217410,
     0.000035381343848,     0.000027830630902,     0.000022683955394,     0.000019007972106,     0.000016280441543,     0.000014192083924,     0.000012550730590,     0.000011231985836,     0.303249742616389,     0.017743223205869,
     0.003105045629828,     0.000897525637529,     0.000356392810454,     0.000176349240863,     0.000102128301484,     0.000066286748193,     0.000046768791730,     0.000035104168575,     0.000027604739039,     0.000022494687335,
     0.000018845875208,     0.000016139146373,     0.000014067136529,     0.000012438916815,     0.000011130922781,     0.303072465487172,     0.017712217566527,     0.003096088163744,     0.000893970509893,     0.000354634413432,
     0.000175331264405,     0.000101467766602,     0.000065820810893,     0.000046419126540,     0.000034829242785,     0.000027380731775,     0.000022307033200,     0.000018685185032,     0.000015999095102,     0.000013943302234,
     0.000012328109078,     0.000011030776716,     0.302895497967068,     0.017681301324382,     0.003087166161186,     0.000890432915438,     0.000352886163226,     0.000174319870058,     0.000100811873656,     0.000065358356536,
     0.000046072199439,     0.000034556547712,     0.000027158593042,     0.000022120978986,     0.000018525889196,     0.000015860276651,     0.000013820571024,     0.000012218298252,     0.000010931539261,     0.302718839163873,
     0.017650474125675,     0.003078279447329,     0.000886912753024,     0.000351147994245,     0.000173315011575,     0.000100160587953,     0.000064899357851,     0.000045727988212,     0.000034286064749,     0.000026938306909,
     0.000021936510810,     0.000018367975426,     0.000015722680038,     0.000013698932976,     0.000012109475291,     0.000010833202113,     0.302542488188916,     0.017619735618386,     0.003069427848354,     0.000883409922166,
     0.000349419841361,     0.000172316643056,     0.000099513875071,     0.000064443787792,     0.000045386470832,     0.000034017775451,     0.000026719857585,     0.000021753614911,     0.000018211431559,     0.000015586294380,
     0.000013578378256,     0.000012001631236,     0.000010735757045,     0.302366444157035,     0.017589085452234,     0.003060611191446,     0.000879924323025,     0.000347701639902,     0.000171324718944,     0.000098871700858,
     0.000063991619528,     0.000045047625452,     0.000033751661527,     0.000026503229415,     0.000021572277652,     0.000018056245538,     0.000015451108894,     0.000013458897118,     0.000011894757204,     0.000010639195906,
     0.302190706186563,     0.017558523278657,     0.003051829304785,     0.000876455856410,     0.000345993325651,     0.000170339194023,     0.000098234031429,     0.000063542826449,     0.000044711430410,     0.000033487704844,
     0.000026288406881,     0.000021392485514,     0.000017902405416,     0.000015317112892,     0.000013340479907,     0.000011788844398,     0.000010543510620,     0.302015273399310,     0.017528048750807,     0.003043082017538,
     0.000873004423768,     0.000344294834841,     0.000169360023412,     0.000097600833166,     0.000063097382157,     0.000044377864224,     0.000033225887422,     0.000026075374599,     0.000021214225097,     0.000017749899351,
     0.000015184295781,     0.000013223117055,     0.000011683884099,     0.000010448693185,     0.301840144920545,     0.017497661523541,     0.003034369159856,     0.000869569927180,     0.000342606104151,     0.000168387162567,
     0.000096972072711,     0.000062655260472,     0.000044046905591,     0.000032966191435,     0.000025864117318,     0.000021037483119,     0.000017598715606,     0.000015052647068,     0.000013106799079,     0.000011579867668,
     0.000010354735673,     0.301665319878982,     0.017467361253408,     0.003025690562865,     0.000866152269361,     0.000340927070704,     0.000167420567275,     0.000096347716968,     0.000062216435424,     0.000043718533383,
     0.000032708599209,     0.000025654619919,     0.000020862246416,     0.000017448842549,     0.000014922156348,     0.000012991516584,     0.000011476786545,     0.000010261630228,     0.301490797406760,     0.017437147598641,
     0.003017046058662,     0.000862751353650,     0.000339257672066,     0.000166460193655,     0.000095727733100,     0.000061780881253,     0.000043392726652,     0.000032453093220,     0.000025446867416,     0.000020688501938,
     0.000017300268653,     0.000014792813315,     0.000012877260259,     0.000011374632249,     0.000010169369067,     0.301316576639425,     0.017407020219148,     0.003008435480306,     0.000859367084010,     0.000337597846238,
     0.000165505998149,     0.000095112088525,     0.000061348572409,     0.000043069464623,     0.000032199656094,     0.000025240844950,     0.000020516236751,     0.000017152982492,     0.000014664607753,     0.000012764020878,
     0.000011273396375,     0.000010077944478,     0.301142656715921,     0.017376978776502,     0.002999858661813,     0.000855999365021,     0.000335947531654,     0.000164557937528,     0.000094500750918,     0.000060919483547,
     0.000042748726692,     0.000031948270604,     0.000025036537792,     0.000020345438033,     0.000017006972740,     0.000014537529539,     0.000012651789298,     0.000011173070596,     0.000009987348821,     0.300969036778562,
     0.017347022933929,     0.002991315438152,     0.000852648101876,     0.000334306667181,     0.000163615968881,     0.000093893688205,     0.000060493589529,     0.000042430492429,     0.000031698919669,     0.000024833931343,
     0.000020176093078,     0.000016862228176,     0.000014411568638,     0.000012540556460,     0.000011073646661,     0.000009897574525,     0.300795715973026,     0.017317152356303,     0.002982805645237,     0.000849313200379,
     0.000332675192112,     0.000162680049620,     0.000093290868561,     0.000060070865420,     0.000042114741573,     0.000031451586356,     0.000024633011127,     0.000020008189290,     0.000016718737676,     0.000014286715110,
     0.000012430313386,     0.000010975116393,     0.000009808614089,     0.300622693448331,     0.017287366710133,     0.002974329119918,     0.000845994566937,     0.000331053046164,     0.000161750137472,     0.000092692260412,
     0.000059651286487,     0.000041801454032,     0.000031206253874,     0.000024433762795,     0.000019841714181,     0.000016576490216,     0.000014162959101,     0.000012321051180,     0.000010877471691,     0.000009720460081,
     0.300449968356825,     0.017257665663554,     0.002965885699981,     0.000842692108559,     0.000329440169478,     0.000160826190478,     0.000092097832429,     0.000059234828195,     0.000041490609881,     0.000030962905575,
     0.000024236172122,     0.000019676655378,     0.000016435474869,     0.000014040290846,     0.000012212761027,     0.000010780704528,     0.000009633105137,     0.300277539854162,     0.017228048886320,     0.002957475224138,
     0.000839405732848,     0.000327836502610,     0.000159908166993,     0.000091507553527,     0.000058821466210,     0.000041182189362,     0.000030721524953,     0.000024040225007,     0.000019513000613,     0.000016295680805,
     0.000013918700669,     0.000012105434191,     0.000010684806949,     0.000009546541960,     0.300105407099296,     0.017198516049792,     0.002949097532021,     0.000836135348004,     0.000326241986531,     0.000158996025680,
     0.000090921392865,     0.000058411176394,     0.000040876172878,     0.000030482095643,     0.000023845907471,     0.000019350737727,     0.000016157097294,     0.000013798178980,     0.000011999062015,     0.000010589771074,
     0.000009460763323,     0.299933569254455,     0.017169066826932,     0.002940752464179,     0.000832880862810,     0.000324656562626,     0.000158089725510,     0.000090339319839,     0.000058003934804,     0.000040572540999,
     0.000030244601418,     0.000023653205653,     0.000019189854668,     0.000016019713696,     0.000013678716275,     0.000011893635923,     0.000010495589091,     0.000009375762062,     0.299762025485130,     0.017139700892290,
     0.002932439862069,     0.000829642186638,     0.000323080172686,     0.000157189225759,     0.000089761304087,     0.000057599717690,     0.000040271274453,     0.000030009026190,     0.000023462105818,     0.000019030339489,
     0.000015883519470,     0.000013560303137,     0.000011789147413,     0.000010402253265,     0.000009291531081,     0.299590774960061,     0.017110417921997,     0.002924159568050,     0.000826419229436,     0.000321512758911,
     0.000156294486005,     0.000089187315482,     0.000057198501494,     0.000039972354131,     0.000029775354007,     0.000023272594344,     0.000018872180348,     0.000015748504166,     0.000013442930230,     0.000011685588063,
     0.000010309755926,     0.000009208063347,     0.299419816851217,     0.017081217593757,     0.002915911425382,     0.000823211901731,     0.000319954263900,     0.000155405466125,     0.000088617324132,     0.000056800262850,
     0.000039675761082,     0.000029543569053,     0.000023084657730,     0.000018715365510,     0.000015614657428,     0.000013326588306,     0.000011582949525,     0.000010218089477,     0.000009125351895,     0.299249150333782,
     0.017052099586838,     0.002907695278213,     0.000820020114619,     0.000318404630655,     0.000154522126297,     0.000088051300377,     0.000056404978578,     0.000039381476512,     0.000029313655647,     0.000022898282591,
     0.000018559883339,     0.000015481968994,     0.000013211268198,     0.000011481223529,     0.000010127246390,     0.000009043389820,     0.299078774586140,     0.017023063582058,     0.002899510971582,     0.000816843779767,
     0.000316863802572,     0.000153644426990,     0.000087489214789,     0.000056012625687,     0.000039089481783,     0.000029085598241,     0.000022713455659,     0.000018405722303,     0.000015350428689,     0.000013096960821,
     0.000011380401877,     0.000010037219205,     0.000008962170283,     0.298908688789859,     0.016994109261785,     0.002891358351403,     0.000813682809404,     0.000315331723444,     0.000152772328971,     0.000086931038168,
     0.000055623181371,     0.000038799758412,     0.000028859381417,     0.000022530163779,     0.000018252870972,     0.000015220026431,     0.000012983657173,     0.000011280476449,     0.000009948000532,     0.000008881686507,
     0.298738892129676,     0.016965236309919,     0.002883237264469,     0.000810537116321,     0.000313808337452,     0.000151905793294,     0.000086376741542,     0.000055236623008,     0.000038512288070,     0.000028634989892,
     0.000022348393912,     0.000018101318014,     0.000015090752229,     0.000012871348331,     0.000011181439196,     0.000009859583045,     0.000008801931778,     0.298569383793481,     0.016936444411892,     0.002875147558441,
     0.000807406613863,     0.000312293589166,     0.000151044781303,     0.000085826296163,     0.000054852928160,     0.000038227052580,     0.000028412408509,     0.000022168133129,     0.000017951052200,     0.000014962596178,
     0.000012760025455,     0.000011083282142,     0.000009771959488,     0.000008722899443,     0.298400162972303,     0.016907733254653,     0.002867089081844,     0.000804291215929,     0.000310787423541,     0.000150189254628,
     0.000085279673508,     0.000054472074567,     0.000037944033916,     0.000028191622242,     0.000021989368614,     0.000017802062396,     0.000014835548463,     0.000012649679781,     0.000010985997384,     0.000009685122670,
     0.000008644582911,     0.298231228860291,     0.016879102526659,     0.002859061684060,     0.000801190836966,     0.000309289785916,     0.000149339175185,     0.000084736845274,     0.000054094040152,     0.000037663214201,
     0.000027972616191,     0.000021812087664,     0.000017654337569,     0.000014709599354,     0.000012540302626,     0.000010889577090,     0.000009599065466,     0.000008566975649,     0.298062580654706,     0.016850551917875,
     0.002851065215325,     0.000798105391965,     0.000307800622006,     0.000148494505168,     0.000084197783381,     0.000053718803013,     0.000037384575707,     0.000027755375585,     0.000021636277683,     0.000017507866779,
     0.000014584739210,     0.000012431885383,     0.000010794013499,     0.000009513780815,     0.000008490071186,     0.297894217555898,     0.016822081119753,     0.002843099526722,     0.000795034796460,     0.000306319877906,
     0.000147655207055,     0.000083662459962,     0.000053346341426,     0.000037108100854,     0.000027539885776,     0.000021461926185,     0.000017362639186,     0.000014460958475,     0.000012324419526,     0.000010699298922,
     0.000009429261721,     0.000008413863111,     0.297726138767299,     0.016793689825233,     0.002835164470177,     0.000791978966519,     0.000304847500083,     0.000146821243600,     0.000083130847372,     0.000052976633842,
     0.000036833772204,     0.000027326132241,     0.000021289020791,     0.000017218644043,     0.000014338247677,     0.000012217896600,     0.000010605425736,     0.000009345501252,     0.000008338345071,     0.297558343495400,
     0.016765377728733,     0.002827259898451,     0.000788937818748,     0.000303383435375,     0.000145992577830,     0.000082602918177,     0.000052609658885,     0.000036561572469,     0.000027114100581,     0.000021117549231,
     0.000017075870698,     0.000014216597428,     0.000012112308231,     0.000010512386391,     0.000009262492540,     0.000008263510771,     0.297390830949744,     0.016737144526136,     0.002819385665138,     0.000785911270277,
     0.000301927630990,     0.000145169173049,     0.000082078645156,     0.000052245395353,     0.000036291484501,     0.000026903776518,     0.000020947499340,     0.000016934308591,     0.000014095998425,     0.000012007646118,
     0.000010420173402,     0.000009180228778,     0.000008189353974,     0.297223600342907,     0.016708989914788,     0.002811541624656,     0.000782899238768,     0.000300480034499,     0.000144350992830,     0.000081558001302,
     0.000051883822213,     0.000036023491294,     0.000026695145895,     0.000020778859057,     0.000016793947256,     0.000013976441446,     0.000011903902034,     0.000010328779355,     0.000009098703223,     0.000008115868500,
     0.297056650890482,     0.016680913593483,     0.002803727632245,     0.000779901642401,     0.000299040593839,     0.000143538001015,     0.000081040959814,     0.000051524918601,     0.000035757575985,     0.000026488194678,
     0.000020611616426,     0.000016654776319,     0.000013857917351,     0.000011801067826,     0.000010238196899,     0.000009017909191,     0.000008043048227,     0.296889981811070,     0.016652915262462,     0.002795943543962,
     0.000776918399878,     0.000297609257304,     0.000142730161714,     0.000080527494100,     0.000051168663822,     0.000035493721849,     0.000026282908947,     0.000020445759597,     0.000016516785496,     0.000013740417083,
     0.000011699135415,     0.000010148418755,     0.000008937840061,     0.000007970887088,     0.296723592326260,     0.016624994623401,     0.002788189216671,     0.000773949430413,     0.000296185973548,     0.000141927439302,
     0.000080017577776,     0.000050815037349,     0.000035231912300,     0.000026079274905,     0.000020281276817,     0.000016379964594,     0.000013623931664,     0.000011598096794,     0.000010059437704,     0.000008858489272,
     0.000007899379072,     0.296557481660618,     0.016597151379400,     0.002780464508044,     0.000770994653734,     0.000294770691579,     0.000141129798415,     0.000079511184660,     0.000050464018816,     0.000034972130891,
     0.000025877278870,     0.000020118156439,     0.000016244303510,     0.000013508452194,     0.000011497944027,     0.000009971246596,     0.000008779850323,     0.000007828518224,     0.296391649041673,     0.016569385234983,
     0.002772769276553,     0.000768053990077,     0.000293363360758,     0.000140337203951,     0.000079008288774,     0.000050115588025,     0.000034714361308,     0.000025676907274,     0.000019956386914,     0.000016109792227,
     0.000013393969856,     0.000011398669252,     0.000009883838346,     0.000008701916770,     0.000007758298641,     0.296226093699900,     0.016541695896081,     0.002765103381464,     0.000765127360183,     0.000291963930795,
     0.000139549621068,     0.000078508864341,     0.000049769724938,     0.000034458587375,     0.000025478146667,     0.000019795956795,     0.000015976420818,     0.000013280475909,     0.000011300264674,     0.000009797205931,
     0.000008624682232,     0.000007688714477,     0.296060814868709,     0.016514083070032,     0.002757466682833,     0.000762214685292,     0.000290572351747,     0.000138767015178,     0.000078012885783,     0.000049426409679,
     0.000034204793049,     0.000025280983711,     0.000019636854731,     0.000015844179443,     0.000013167961688,     0.000011202722571,     0.000009711342392,     0.000008548140382,     0.000007619759939,     0.295895811784428,
     0.016486546465567,     0.002749859041502,     0.000759315887144,     0.000289188574016,     0.000137989351950,     0.000077520327720,     0.000049085622531,     0.000033952962420,     0.000025085405183,     0.000019479069471,
     0.000015713058347,     0.000013056418608,     0.000011106035287,     0.000009626240835,     0.000008472284953,     0.000007551429286,     0.295731083686292,     0.016459085792806,     0.002742280319093,     0.000756430887971,
     0.000287812548346,     0.000137216597306,     0.000077031164970,     0.000048747343937,     0.000033703079708,     0.000024891397970,     0.000019322589862,     0.000015583047862,     0.000012945838158,     0.000011010195237,
     0.000009541894426,     0.000008397109736,     0.000007483716832,     0.295566629816428,     0.016431700763248,     0.002734730378004,     0.000753559610499,     0.000286444225821,     0.000136448717417,     0.000076545372544,
     0.000048411554496,     0.000033455129266,     0.000024698949070,     0.000019167404844,     0.000015454138403,     0.000012836211904,     0.000010915194903,     0.000009458296394,     0.000008322608575,     0.000007416616940,
     0.295402449419840,     0.016404391089764,     0.002727209081400,     0.000750701977940,     0.000285083557861,     0.000135685678703,     0.000076062925647,     0.000048078234963,     0.000033209095575,     0.000024508045594,
     0.000019013503455,     0.000015326320471,     0.000012727531486,     0.000010821026837,     0.000009375440028,     0.000008248775374,     0.000007350124027,     0.295238541744399,     0.016377156486592,     0.002719716293216,
     0.000747857913988,     0.000283730496221,     0.000134927447834,     0.000075583799676,     0.000047747366247,     0.000032964963245,     0.000024318674759,     0.000018860874828,     0.000015199584648,     0.000012619788618,
     0.000010727683653,     0.000009293318680,     0.000008175604090,     0.000007284232561,     0.295074906040822,     0.016349996669323,     0.002712251878145,     0.000745027342821,     0.000282384992988,     0.000134173991721,
     0.000075107970216,     0.000047418929411,     0.000032722717013,     0.000024130823891,     0.000018709508187,     0.000015073921601,     0.000012512975088,     0.000010635158035,     0.000009211925760,     0.000008103088736,
     0.000007218937060,     0.294911541562669,     0.016322911354900,     0.002704815701635,     0.000742210189092,     0.000281047000580,     0.000133425277522,     0.000074635413044,     0.000047092905670,     0.000032482341743,
     0.000023944480424,     0.000018559392851,     0.000014949322076,     0.000012407082756,     0.000010543442731,     0.000009131254738,     0.000008031223380,     0.000007154232093,     0.294748447566321,     0.016295900261608,
     0.002697407629888,     0.000739406377931,     0.000279716471740,     0.000132681272633,     0.000074166104121,     0.000046769276389,     0.000032243822422,     0.000023759631898,     0.000018410518231,     0.000014825776902,
     0.000012302103556,     0.000010452530555,     0.000009051299145,     0.000007960002143,     0.000007090112278,     0.294585623310968,     0.016268963109063,     0.002690027529849,     0.000736615834935,     0.000278393359537,
     0.000131941944692,     0.000073700019596,     0.000046448023084,     0.000032007144163,     0.000023576265959,     0.000018262873828,     0.000014703276988,     0.000012198029492,     0.000010362414385,     0.000008972052568,
     0.000007889419202,     0.000007026572283,     0.294423068058601,     0.016242099618213,     0.002682675269208,     0.000733838486173,     0.000277077617363,     0.000131207261572,     0.000073237135801,     0.000046129127418,
     0.000031772292202,     0.000023394370355,     0.000018116449237,     0.000014581813321,     0.000012094852638,     0.000010273087162,     0.000008893508653,     0.000007819468783,     0.000006963606825,     0.294260781073991,
     0.016215309511320,     0.002675350716390,     0.000731074258175,     0.000275769198930,     0.000130477191385,     0.000072777429250,     0.000045812571202,     0.000031539251895,     0.000023213932942,     0.000017971234138,
     0.000014461376970,     0.000011992565142,     0.000010184541891,     0.000008815661103,     0.000007750145167,     0.000006901210669,     0.294098761624683,     0.016188592511962,     0.002668053740552,     0.000728323077935,
     0.000274468058265,     0.000129751702474,     0.000072320876639,     0.000045498336390,     0.000031308008722,     0.000023034941675,     0.000017827218302,     0.000014341959080,     0.000011891159217,     0.000010096771639,
     0.000008738503679,     0.000007681442689,     0.000006839378629,     0.293937008980977,     0.016161948345019,     0.002660784211581,     0.000725584872903,     0.000273174149714,     0.000129030763416,     0.000071867454843,
     0.000045186405085,     0.000031078548281,     0.000022857384612,     0.000017684391590,     0.000014223550873,     0.000011790627149,     0.000010009769537,     0.000008662030197,     0.000007613355732,     0.000006778105564,
     0.293775522415920,     0.016135376736672,     0.002653542000084,     0.000722859570985,     0.000271887427934,     0.000128314343018,     0.000071417140918,     0.000044876759530,     0.000030850856289,     0.000022681249913,
     0.000017542743948,     0.000014106143650,     0.000011690961289,     0.000009923528776,     0.000008586234531,     0.000007545878731,     0.000006717386384,     0.293614301205290,     0.016108877414389,     0.002646326977389,
     0.000720147100539,     0.000270607847895,     0.000127602410314,     0.000070969912092,     0.000044569382111,     0.000030624918581,     0.000022506525836,     0.000017402265410,     0.000013989728785,     0.000011592154058,
     0.000009838042608,     0.000008511110608,     0.000007479006174,     0.000006657216042,     0.293453344627583,     0.016082450106921,     0.002639139015539,     0.000717447390371,     0.000269335364872,     0.000126894934567,
     0.000070525745773,     0.000044264255357,     0.000030400721109,     0.000022333200741,     0.000017262946093,     0.000013874297731,     0.000011494197943,     0.000009753304345,     0.000008436652411,     0.000007412732598,
     0.000006597589539,     0.293292651964003,     0.016056094544299,     0.002631977987284,     0.000714760369733,     0.000268069934448,     0.000126191885265,     0.000070084619541,     0.000043961361935,     0.000030178249941,
     0.000022161263083,     0.000017124776204,     0.000013759842014,     0.000011397085500,     0.000009669307360,     0.000008362853977,     0.000007347052587,     0.000006538501923,     0.293132222498444,     0.016029810457819,
     0.002624843766080,     0.000712085968320,     0.000266811512512,     0.000125493232117,     0.000069646511148,     0.000043660684650,     0.000029957491260,     0.000021990701418,     0.000016987746030,     0.000013646353234,
     0.000011300809347,     0.000009586045086,     0.000008289709399,     0.000007281960779,     0.000006479948285,     0.292972055517484,     0.016003597580040,     0.002617736226086,     0.000709424116267,     0.000265560055253,
     0.000124798945056,     0.000069211398518,     0.000043362206447,     0.000029738431364,     0.000021821504396,     0.000016851845944,     0.000013533823064,     0.000011205362171,     0.000009503511012,     0.000008217212819,
     0.000007217451858,     0.000006421923762,     0.292812150310368,     0.015977455644777,     0.002610655242155,     0.000706774744144,     0.000264315519157,     0.000124108994234,     0.000068779259745,     0.000043065910406,
     0.000029521056661,     0.000021653660764,     0.000016717066401,     0.000013422243251,     0.000011110736721,     0.000009421698689,     0.000008145358436,     0.000007153520556,     0.000006364423537,     0.292652506168997,
     0.015951384387092,     0.002603600689833,     0.000704137782957,     0.000263077861013,     0.000123423350021,     0.000068350073091,     0.000042771779741,     0.000029305353675,     0.000021487159364,     0.000016583397938,
     0.000013311605614,     0.000011016925813,     0.000009340601722,     0.000008074140500,     0.000007090161655,     0.000006307442835,     0.292493122387913,     0.015925383543288,     0.002596572445355,     0.000701513164141,
     0.000261847037900,     0.000122741983004,     0.000067923816987,     0.000042479797804,     0.000029091309037,     0.000021321989133,     0.000016450831175,     0.000013201902044,     0.000010923922323,     0.000009260213776,
     0.000008003553312,     0.000007027369984,     0.000006250976925,     0.292333998264293,     0.015899452850902,     0.002589570385637,     0.000698900819558,     0.000260623007192,     0.000122064863984,     0.000067500470028,
     0.000042189948077,     0.000028878909491,     0.000021158139099,     0.000016319356811,     0.000013093124500,     0.000010831719195,     0.000009180528572,     0.000007933591226,     0.000006965140417,     0.000006195021121,
     0.292175133097928,     0.015873592048701,     0.002582594388275,     0.000696300681497,     0.000259405726557,     0.000121391963977,     0.000067080010973,     0.000041902214175,     0.000028668141890,     0.000020995598386,
     0.000016188965625,     0.000012985265015,     0.000010740309430,     0.000009101539887,     0.000007864248647,     0.000006903467876,     0.000006139570779,     0.292016526191218,     0.015847800876668,     0.002575644331543,
     0.000693712682667,     0.000258195153946,     0.000120723254208,     0.000066662418746,     0.000041616579843,     0.000028458993195,     0.000020834356207,     0.000016059648476,     0.000012878315690,     0.000010649686096,
     0.000009023241553,     0.000007795520029,     0.000006842347332,     0.000006084621297,     0.291858176849157,     0.015822079076005,     0.002568720094381,     0.000691136756197,     0.000256991247600,     0.000120058706115,
     0.000066247672432,     0.000041333028958,     0.000028251450473,     0.000020674401866,     0.000015931396303,     0.000012772268695,     0.000010559842318,     0.000008945627458,     0.000007727399877,     0.000006781773796,
     0.000006030168115,     0.291700084379319,     0.015796426389117,     0.002561821556399,     0.000688572835632,     0.000255793966045,     0.000119398291343,     0.000065835751275,     0.000041051545523,     0.000028045500900,
     0.000020515724761,     0.000015804200121,     0.000012667116268,     0.000010470771286,     0.000008868691545,     0.000007659882746,     0.000006721742330,     0.000005976206717,     0.291542248091850,     0.015770842559612,
     0.002554948597869,     0.000686020854931,     0.000254603268089,     0.000118741981741,     0.000065426634682,     0.000040772113671,     0.000027841131756,     0.000020358314374,     0.000015678051022,     0.000012562850716,
     0.000010382466247,     0.000008792427811,     0.000007592963240,     0.000006662248037,     0.000005922732627,     0.291384667299453,     0.015745327332291,     0.002548101099720,     0.000683480748461,     0.000253419112820,
     0.000118089749369,     0.000065020302216,     0.000040494717662,     0.000027638330425,     0.000020202160279,     0.000015552940175,     0.000012459464412,     0.000010294920509,     0.000008716830306,     0.000007526636011,
     0.000006603286068,     0.000005869741408,     0.291227341317377,     0.015719880453144,     0.002541278943536,     0.000680952451001,     0.000252241459604,     0.000117441566484,     0.000064616733595,     0.000040219341879,
     0.000027437084397,     0.000020047252139,     0.000015428858828,     0.000012356949797,     0.000010208127440,     0.000008641893134,     0.000007460895760,     0.000006544851614,     0.000005817228666,     0.291070269463406,
     0.015694501669340,     0.002534482011552,     0.000678435897730,     0.000251070268084,     0.000116797405551,     0.000064215908696,     0.000039945970831,     0.000027237381263,     0.000019893579700,     0.000015305798299,
     0.000012255299376,     0.000010122080465,     0.000008567610452,     0.000007395737236,     0.000006486939914,     0.000005765190048,     0.290913451057845,     0.015669190729223,     0.002527710186649,     0.000675931024234,
     0.000249905498177,     0.000116157239231,     0.000063817807547,     0.000039674589151,     0.000027039208718,     0.000019741132799,     0.000015183749984,     0.000012154505722,     0.000010036773068,     0.000008493976468,
     0.000007331155235,     0.000006429546247,     0.000005713621239,     0.290756885423511,     0.015643947382305,     0.002520963352349,     0.000673437766494,     0.000248747110074,     0.000115521040387,     0.000063422410332,
     0.000039405181595,     0.000026842554556,     0.000019589901355,     0.000015062705353,     0.000012054561471,     0.000009952198792,     0.000008420985443,     0.000007267144600,     0.000006372665938,     0.000005662517965,
     0.290600571885719,     0.015618771379260,     0.002514241392812,     0.000670956060891,     0.000247595064235,     0.000114888782077,     0.000063029697385,     0.000039137733039,     0.000026647406673,     0.000019439875374,
     0.000014942655948,     0.000011955459324,     0.000009868351235,     0.000008348631688,     0.000007203700221,     0.000006316294350,     0.000005611875988,     0.290444509772274,     0.015593662471917,     0.002507544192834,
     0.000668485844200,     0.000246449321387,     0.000114260437557,     0.000062639649192,     0.000038872228481,     0.000026453753063,     0.000019291044946,     0.000014823593384,     0.000011857192045,     0.000009785224053,
     0.000008276909567,     0.000007140817033,     0.000006260426894,     0.000005561691114,     0.290288698413452,     0.015568620413254,     0.002500871637841,     0.000666027053584,     0.000245309842526,     0.000113635980275,
     0.000062252246385,     0.000038608653037,     0.000026261581821,     0.000019143400245,     0.000014705509348,     0.000011759752463,     0.000009702810957,     0.000008205813494,     0.000007078490017,     0.000006205059018,
     0.000005511959183,     0.290133137141999,     0.015543644957390,     0.002494223613884,     0.000663579626598,     0.000244176588912,     0.000113015383875,     0.000061867469750,     0.000038346991943,     0.000026070881138,
     0.000018996931525,     0.000014588395599,     0.000011663133467,     0.000009621105715,     0.000008135337930,     0.000007016714202,     0.000006150186214,     0.000005462676074,     0.289977825293111,     0.015518735859584,
     0.002487600007637,     0.000661143501183,     0.000243049522066,     0.000112398622190,     0.000061485300214,     0.000038087230551,     0.000025881639303,     0.000018851629126,     0.000014472243967,     0.000011567328009,
     0.000009540102148,     0.000008065477389,     0.000006955484658,     0.000006095804014,     0.000005413837707,     0.289822762204426,     0.015493892876221,     0.002481000706394,     0.000658718615662,     0.000241928603772,
     0.000111785669244,     0.000061105718855,     0.000037829354333,     0.000025693844700,     0.000018707483466,     0.000014357046350,     0.000011472329105,     0.000009459794135,     0.000007996226432,     0.000006894796501,
     0.000006041907991,     0.000005365440034,     0.289667947216014,     0.015469115764813,     0.002474425598062,     0.000656304908739,     0.000240813796071,     0.000111176499248,     0.000060728706892,     0.000037573348872,
     0.000025507485810,     0.000018564485045,     0.000014242794719,     0.000011378129828,     0.000009380175606,     0.000007927579670,     0.000006834644892,     0.000005988493758,     0.000005317479048,     0.289513379670361,
     0.015444404283988,     0.002467874571160,     0.000653902319497,     0.000239705061263,     0.000110571086603,     0.000060354245689,     0.000037319199869,     0.000025322551207,     0.000018422624445,     0.000014129481111,
     0.000011284723315,     0.000009301240545,     0.000007859531762,     0.000006775025034,     0.000005935556968,     0.000005269950778,     0.289359058912366,     0.015419758193488,     0.002461347514815,     0.000651510787396,
     0.000238602361900,     0.000109969405894,     0.000059982316753,     0.000037066893138,     0.000025139029559,     0.000018281892323,     0.000014017097633,     0.000011192102759,     0.000009222982992,     0.000007792077413,
     0.000006715932176,     0.000005883093313,     0.000005222851289,     0.289204984289321,     0.015395177254158,     0.002454844318756,     0.000649130252265,     0.000237505660789,     0.000109371431888,     0.000059612901732,
     0.000036816414605,     0.000024956909629,     0.000018142279418,     0.000013905636459,     0.000011100261416,     0.000009145397036,     0.000007725211377,     0.000006657361605,     0.000005831098526,     0.000005176176681,
     0.289051155150906,     0.015370661227944,     0.002448364873313,     0.000646760654309,     0.000236414920990,     0.000108777139540,     0.000059245982414,     0.000036567750310,     0.000024776180271,     0.000018003776545,
     0.000013795089830,     0.000011009192599,     0.000009068476821,     0.000007658928455,     0.000006599308656,     0.000005779568376,     0.000005129923091,     0.288897570849175,     0.015346209877887,     0.002441909069411,
     0.000644401934097,     0.000235330105809,     0.000108186503981,     0.000058881540725,     0.000036320886401,     0.000024596830429,     0.000017866374598,     0.000013685450054,     0.000010918889680,     0.000008992216540,
     0.000007593223494,     0.000006541768703,     0.000005728498673,     0.000005084086691,     0.288744230738548,     0.015321822968112,     0.002435476798568,     0.000642054032565,     0.000234251178803,     0.000107599500526,
     0.000058519558730,     0.000036075809139,     0.000024418849139,     0.000017730064547,     0.000013576709505,     0.000010829346088,     0.000008916610441,     0.000007528091387,     0.000006484737162,     0.000005677885264,
     0.000005038663688,     0.288591134175795,     0.015297500263831,     0.002429067952893,     0.000639716891014,     0.000233178103773,     0.000107016104667,     0.000058160018632,     0.000035832504893,     0.000024242225528,
     0.000017594837436,     0.000013468860623,     0.000010740555310,     0.000008841652820,     0.000007463527071,     0.000006428209490,     0.000005627724034,     0.000004993650325,     0.288438280520032,     0.015273241531328,
     0.002422682425076,     0.000637390451103,     0.000232110844765,     0.000106436292073,     0.000057802902768,     0.000035590960139,     0.000024066948810,     0.000017460684387,     0.000013361895911,     0.000010652510889,
     0.000008767338024,     0.000007399525532,     0.000006372181187,     0.000005578010905,     0.000004949042876,     0.288285669132705,     0.015249046537959,     0.002416320108392,     0.000635074654851,     0.000231049366068,
     0.000105860038589,     0.000057448193609,     0.000035351161463,     0.000023893008289,     0.000017327596595,     0.000013255807938,     0.000010565206425,     0.000008693660450,     0.000007336081798,     0.000006316647792,
     0.000005528741836,     0.000004904837653,     0.288133299377581,     0.015224915052144,     0.002409980896692,     0.000632769444632,     0.000229993632210,     0.000105287320236,     0.000057095873762,     0.000035113095555,
     0.000023720393357,     0.000017195565330,     0.000013150589337,     0.000010478635574,     0.000008620614545,     0.000007273190941,     0.000006261604884,     0.000005479912823,     0.000004861030999,     0.287981170620738,
     0.015200846843361,     0.002403664684403,     0.000630474763175,     0.000228943607959,     0.000104718113207,     0.000056745925966,     0.000034876749212,     0.000023549093490,     0.000017064581935,     0.000013046232803,
     0.000010392792047,     0.000008548194805,     0.000007210848080,     0.000006207048082,     0.000005431519899,     0.000004817619293,     0.287829282230555,     0.015176841682141,     0.002397371366523,     0.000628190553558,
     0.000227899258320,     0.000104152393867,     0.000056398333090,     0.000034642109336,     0.000023379098254,     0.000016934637825,     0.000012942731093,     0.000010307669609,     0.000008476395773,     0.000007149048374,
     0.000006152973045,     0.000005383559133,     0.000004774598943,     0.287677633577699,     0.015152899340064,     0.002391100838615,     0.000625916759209,     0.000226860548534,     0.000103590138753,     0.000056053078135,
     0.000034409162933,     0.000023210397298,     0.000016805724488,     0.000012840077027,     0.000010223262081,     0.000008405212043,     0.000007087787027,     0.000006099375472,     0.000005336026628,     0.000004731966395,
     0.287526224035115,     0.015129019589749,     0.002384852996808,     0.000623653323903,     0.000225827444075,     0.000103031324568,     0.000055710144229,     0.000034177897110,     0.000023042980356,     0.000016677833482,
     0.000012738263488,     0.000010139563335,     0.000008334638254,     0.000007027059287,     0.000006046251098,     0.000005288918524,     0.000004689718124,     0.287375052978019,     0.015105202204852,     0.002378627737793,
     0.000621400191758,     0.000224799910650,     0.000102475928187,     0.000055369514633,     0.000033948299080,     0.000022876837248,     0.000016550956440,     0.000012637283418,     0.000010056567300,     0.000008264669094,
     0.000006966860442,     0.000005993595699,     0.000005242230996,     0.000004647850639,     0.287224119783884,     0.015081446960060,     0.002372424958815,     0.000619157307233,     0.000223777914196,     0.000101923926650,
     0.000055031172731,     0.000033720356153,     0.000022711957875,     0.000016425085059,     0.000012537129820,     0.000009974267955,     0.000008195299297,     0.000006907185824,     0.000005941405089,     0.000005195960254,
     0.000004606360478,     0.287073423832432,     0.015057753631083,     0.002366244557673,     0.000616924615130,     0.000222761420877,     0.000101375297162,     0.000054695102035,     0.000033494055743,     0.000022548332222,
     0.000016300211111,     0.000012437795757,     0.000009892659334,     0.000008126523645,     0.000006848030805,     0.000005889675118,     0.000005150102540,     0.000004565244216,     0.286922964505621,     0.015034121994652,
     0.002360086432720,     0.000614702060584,     0.000221750397088,     0.000100830017093,     0.000054361286183,     0.000033269385362,     0.000022385950355,     0.000016176326435,     0.000012339274351,     0.000009811735519,
     0.000008058336965,     0.000006789390800,     0.000005838401674,     0.000005104654134,     0.000004524498454,     0.286772741187638,     0.015010551828512,     0.002353950482852,     0.000612489589068,     0.000220744809445,
     0.000100288063976,     0.000054029708936,     0.000033046332623,     0.000022224802423,     0.000016053422938,     0.000012241558783,     0.000009731490648,     0.000007990734128,     0.000006731261263,     0.000005787580683,
     0.000005059611347,     0.000004484119827,     0.286622753264887,     0.014987042911413,     0.002347836607509,     0.000610287146385,     0.000219744624793,     0.000099749415506,     0.000053700354179,     0.000032824885233,
     0.000022064878653,     0.000015931492596,     0.000012144642294,     0.000009651918907,     0.000007923710053,     0.000006673637691,     0.000005737208107,     0.000005014970525,     0.000004444105001,     0.286473000125980,
     0.014963595023113,     0.002341744706674,     0.000608094678672,     0.000218749810194,     0.000099214049537,     0.000053373205920,     0.000032605031002,     0.000021906169354,     0.000015810527451,     0.000012048518181,
     0.000009573014535,     0.000007857259702,     0.000006616515620,     0.000005687279945,     0.000004970728046,     0.000004404450670,     0.286323481161727,     0.014940207944363,     0.002335674680864,     0.000605912132390,
     0.000217760332933,     0.000098681944085,     0.000053048248289,     0.000032386757830,     0.000021748664913,     0.000015690519613,     0.000011953179798,     0.000009494771818,     0.000007791378084,     0.000006559890624,
     0.000005637792230,     0.000004926880321,     0.000004365153561,     0.286174195765122,     0.014916881456909,     0.002329626431132,     0.000603739454330,     0.000216776160516,     0.000098153077322,     0.000052725465534,
     0.000032170053719,     0.000021592355796,     0.000015571461258,     0.000011858620558,     0.000009417185094,     0.000007726060248,     0.000006503758320,     0.000005588741034,     0.000004883423795,     0.000004326210429,
     0.286025143331342,     0.014893615343482,     0.002323599859060,     0.000601576591605,     0.000215797260664,     0.000097627427577,     0.000052404842024,     0.000031954906761,     0.000021437232548,     0.000015453344627,
     0.000011764833928,     0.000009340248750,     0.000007661301289,     0.000006448114362,     0.000005540122462,     0.000004840354943,     0.000004287618060,     0.285876323257727,     0.014870409387795,     0.002317594866758,
     0.000599423491649,     0.000214823601313,     0.000097104973336,     0.000052086362247,     0.000031741305146,     0.000021283285790,     0.000015336162026,     0.000011671813433,     0.000009263957221,     0.000007597096347,
     0.000006392954442,     0.000005491932655,     0.000004797670275,     0.000004249373268,     0.285727734943778,     0.014847263374539,     0.002311611356859,     0.000597280102216,     0.000213855150616,     0.000096585693238,
     0.000051770010809,     0.000031529237155,     0.000021130506220,     0.000015219905826,     0.000011579552653,     0.000009188304992,     0.000007533440601,     0.000006338274292,     0.000005444167787,     0.000004755366330,
     0.000004211472899,     0.285579377791143,     0.014824177089373,     0.002305649232518,     0.000595146371380,     0.000212891876939,     0.000096069566076,     0.000051455772431,     0.000031318691162,     0.000020978884611,
     0.000015104568461,     0.000011488045221,     0.000009113286595,     0.000007470329276,     0.000006284069682,     0.000005396824070,     0.000004713439679,     0.000004173913823,     0.285431251203608,     0.014801150318924,
     0.002299708397408,     0.000593022247526,     0.000211933748855,     0.000095556570796,     0.000051143631951,     0.000031109655633,     0.000020828411813,     0.000014990142431,     0.000011397284826,     0.000009038896608,
     0.000007407757636,     0.000006230336419,     0.000005349897748,     0.000004671886926,     0.000004136692944,     0.285283354587090,     0.014778182850780,     0.002293788755715,     0.000590907679355,     0.000210980735153,
     0.000095046686494,     0.000050833574321,     0.000030902119127,     0.000020679078749,     0.000014876620296,     0.000011307265212,     0.000008965129659,     0.000007345720990,     0.000006177070348,     0.000005303385097,
     0.000004630704703,     0.000004099807190,     0.285135687349623,     0.014755274473483,     0.002287890212139,     0.000588802615878,     0.000210032804825,     0.000094539892417,     0.000050525584609,     0.000030696070289,
     0.000020530876419,     0.000014763994678,     0.000011217980174,     0.000008891980420,     0.000007284214686,     0.000006124267351,     0.000005257282430,     0.000004589889675,     0.000004063253520,     0.284988248901352,
     0.014732424976526,     0.002282012671884,     0.000586707006416,     0.000209089927072,     0.000094036167958,     0.000050219647994,     0.000030491497859,     0.000020383795892,     0.000014652258264,     0.000011129423562,
     0.000008819443612,     0.000007223234113,     0.000006071923345,     0.000005211586090,     0.000004549438536,     0.000004027028918,     0.284841038654524,     0.014709634150349,     0.002276156040665,     0.000584620800597,
     0.000208152071302,     0.000093535492662,     0.000049915749768,     0.000030288390662,     0.000020237828314,     0.000014541403799,     0.000011041589278,     0.000008747514001,     0.000007162774703,     0.000006020034287,
     0.000005166292457,     0.000004509348010,     0.000003991130399,     0.284694056023472,     0.014686901786329,     0.002270320224694,     0.000582543948351,     0.000207219207123,     0.000093037846217,     0.000049613875334,
     0.000030086737612,     0.000020092964900,     0.000014431424091,     0.000010954471275,     0.000008676186396,     0.000007102831924,     0.000005968596166,     0.000005121397939,     0.000004469614851,     0.000003955555003,
     0.284547300424615,     0.014664227676782,     0.002264505130685,     0.000580476399916,     0.000206291304348,     0.000092543208458,     0.000049314010205,     0.000029886527712,     0.000019949196940,     0.000014322312006,
     0.000010868063560,     0.000008605455655,     0.000007043401289,     0.000005917605009,     0.000005076898979,     0.000004430235843,     0.000003920299797,     0.284400771276444,     0.014641611614951,     0.002258710665848,
     0.000578418105826,     0.000205368332992,     0.000092051559363,     0.000049016140006,     0.000029687750051,     0.000019806515791,     0.000014214060472,     0.000010782360189,     0.000008535316678,     0.000006984478347,
     0.000005867056879,     0.000005032792052,     0.000004391207797,     0.000003885361876,     0.284254467999510,     0.014619053395008,     0.002252936737885,     0.000576369016918,     0.000204450263265,     0.000091562879056,
     0.000048720250466,     0.000029490393802,     0.000019664912885,     0.000014106662474,     0.000010697355271,     0.000008465764411,     0.000006926058688,     0.000005816947873,     0.000004989073664,     0.000004352527557,
     0.000003850738360,     0.284108390016421,     0.014596552812043,     0.002247183254988,     0.000574329084321,     0.000203537065580,     0.000091077147799,     0.000048426327427,     0.000029294448227,     0.000019524379720,
     0.000014000111058,     0.000010613042962,     0.000008396793841,     0.000006868137939,     0.000005767274122,     0.000004945740352,     0.000004314191992,     0.000003816426397,     0.283962536751826,     0.014574109662063,
     0.002241450125839,     0.000572298259464,     0.000202628710544,     0.000090594345999,     0.000048134356835,     0.000029099902670,     0.000019384907865,     0.000013894399326,     0.000010529417472,     0.000008328400003,
     0.000006810711767,     0.000005718031794,     0.000004902788686,     0.000004276198000,     0.000003782423160,     0.283816907632413,     0.014551723741984,     0.002235737259601,     0.000570276494065,     0.000201725168960,
     0.000090114454201,     0.000047844324742,     0.000028906746560,     0.000019246488957,     0.000013789520438,     0.000010446473056,     0.000008260577972,     0.000006753775878,     0.000005669217088,     0.000004860215264,
     0.000004238542509,     0.000003748725848,     0.283671502086894,     0.014529394849629,     0.002230044565920,     0.000568263740136,     0.000200826411825,     0.000089637453089,     0.000047556217307,     0.000028714969409,
     0.000019109114703,     0.000013685467613,     0.000010364204022,     0.000008193322865,     0.000006697326013,     0.000005620826239,     0.000004818016717,     0.000004201222473,     0.000003715331686,     0.283526319545999,
     0.014507122783723,     0.002224371954919,     0.000566259949977,     0.000199932410327,     0.000089163323485,     0.000047270020792,     0.000028524560811,     0.000018972776874,     0.000013582234125,     0.000010282604725,
     0.000008126629845,     0.000006641357953,     0.000005572855515,     0.000004776189706,     0.000004164234874,     0.000003682237924,     0.283381359442466,     0.014484907343886,     0.002218719337199,     0.000564265076173,
     0.000199043135847,     0.000088692046348,     0.000046985721564,     0.000028335510444,     0.000018837467311,     0.000013479813305,     0.000010201669568,     0.000008060494114,     0.000006585867514,     0.000005525301218,
     0.000004734730922,     0.000004127576722,     0.000003649441837,     0.283236621211033,     0.014462748330631,     0.002213086623832,     0.000562279071598,     0.000198158559955,     0.000088223602774,     0.000046703306090,
     0.000028147808064,     0.000018703177921,     0.000013378198539,     0.000010121393001,     0.000007994910917,     0.000006530850552,     0.000005478159680,     0.000004693637084,     0.000004091245054,     0.000003616940725,
     0.283092104288427,     0.014440645545357,     0.002207473726359,     0.000560301889406,     0.000197278654409,     0.000087757973992,     0.000046422760943,     0.000027961443512,     0.000018569900676,     0.000013277383268,
     0.000010041769523,     0.000007929875539,     0.000006476302957,     0.000005431427270,     0.000004652904942,     0.000004055236933,     0.000003584731913,     0.282947808113358,     0.014418598790345,     0.002201880556791,
     0.000558333483035,     0.000196403391154,     0.000087295141365,     0.000046144072794,     0.000027776406704,     0.000018437627612,     0.000013177360989,     0.000009962793680,     0.000007865383307,     0.000006422220655,
     0.000005385100387,     0.000004612531276,     0.000004019549450,     0.000003552812750,     0.282803732126509,     0.014396607868753,     0.002196307027600,     0.000556373806202,     0.000195532742323,     0.000086835086390,
     0.000045867228416,     0.000027592687638,     0.000018306350834,     0.000013078125254,     0.000009884460062,     0.000007801429588,     0.000006368599610,     0.000005339175460,     0.000004572512894,     0.000003984179721,
     0.000003521180609,     0.282659875770525,     0.014374672584615,     0.002190753051722,     0.000554422812900,     0.000194666680229,     0.000086377790695,     0.000045592214682,     0.000027410276392,     0.000018176062507,
     0.000012979669665,     0.000009806763308,     0.000007738009790,     0.000006315435818,     0.000005293648955,     0.000004532846632,     0.000003949124890,     0.000003489832888,     0.282516238490009,     0.014352792742830,
     0.002185218542549,     0.000552480457400,     0.000193805177372,     0.000085923236038,     0.000045319018562,     0.000027229163119,     0.000018046754861,     0.000012881987882,     0.000009729698102,     0.000007675119361,
     0.000006262725314,     0.000005248517364,     0.000004493529356,     0.000003914382124,     0.000003458767008,     0.282372819731509,     0.014330968149162,     0.002179703413933,     0.000550546694246,     0.000192948206432,
     0.000085471404308,     0.000045047627126,     0.000027049338052,     0.000017918420191,     0.000012785073616,     0.000009653259172,     0.000007612753786,     0.000006210464166,     0.000005203777215,     0.000004454557959,
     0.000003879948619,     0.000003427980414,     0.282229618943510,     0.014309198610235,     0.002174207580174,     0.000548621478255,     0.000192095740269,     0.000085022277523,     0.000044778027539,     0.000026870791498,
     0.000017791050851,     0.000012688920629,     0.000009577441292,     0.000007550908593,     0.000006158648476,     0.000005159425063,     0.000004415929362,     0.000003845821593,     0.000003397470574,     0.282086635576430,
     0.014287483933527,     0.002168730956027,     0.000546704764515,     0.000191247751924,     0.000084575837827,     0.000044510207066,     0.000026693513842,     0.000017664639261,     0.000012593522737,     0.000009502239280,
     0.000007489579345,     0.000006107274383,     0.000005115457495,     0.000004377640514,     0.000003811998293,     0.000003367234978,     0.281943869082604,     0.014265823927365,     0.002163273456692,     0.000544796508380,
     0.000190404214615,     0.000084132067493,     0.000044244153065,     0.000026517495545,     0.000017539177900,     0.000012498873807,     0.000009427648000,     0.000007428761646,     0.000006056338056,     0.000005071871130,
     0.000004339688393,     0.000003778475988,     0.000003337271141,     0.281801318916283,     0.014244218400925,     0.002157834997815,     0.000542896665474,     0.000189565101735,     0.000083690948919,     0.000043979852989,
     0.000026342727142,     0.000017414659309,     0.000012404967758,     0.000009353662356,     0.000007368451137,     0.000006005835701,     0.000005028662615,     0.000004302070000,     0.000003745251972,     0.000003307576600,
     0.281658984533620,     0.014222667164220,     0.002152415495485,     0.000541005191685,     0.000188730386856,     0.000083252464629,     0.000043717294387,     0.000026169199241,     0.000017291076089,     0.000012311798558,
     0.000009280277301,     0.000007308643498,     0.000005955763555,     0.000004985828627,     0.000004264782368,     0.000003712323566,     0.000003278148914,     0.281516865392664,     0.014201170028105,     0.002147014866230,
     0.000539122043165,     0.000187900043720,     0.000082816597268,     0.000043456464900,     0.000025996902526,     0.000017168420901,     0.000012219360227,     0.000009207487825,     0.000007249334444,     0.000005906117891,
     0.000004943365875,     0.000004227822552,     0.000003679688113,     0.000003248985664,     0.281374960953351,     0.014179726804262,     0.002141633027016,     0.000537247176325,     0.000187074046245,     0.000082383329608,
     0.000043197352263,     0.000025825827754,     0.000017046686468,     0.000012127646833,     0.000009135288964,     0.000007190519731,     0.000005856895011,     0.000004901271093,     0.000004191187638,     0.000003647342980,
     0.000003220084455,     0.281233270677496,     0.014158337305206,     0.002136269895243,     0.000535380547841,     0.000186252368519,     0.000081952644540,     0.000042939944302,     0.000025655965752,     0.000016925865568,
     0.000012036652495,     0.000009063675796,     0.000007132195147,     0.000005808091253,     0.000004859541049,     0.000004154874734,     0.000003615285558,     0.000003191442910,     0.281091794028786,     0.014137001344273,
     0.002130925388742,     0.000533522114642,     0.000185434984802,     0.000081524525080,     0.000042684228936,     0.000025487307421,     0.000016805951041,     0.000011946371381,     0.000008992643441,     0.000007074356521,
     0.000005759702985,     0.000004818172535,     0.000004118880976,     0.000003583513264,     0.000003163058679,     0.280950530472770,     0.014115718735620,     0.002125599425775,     0.000531671833916,     0.000184621869522,
     0.000081098954360,     0.000042430194172,     0.000025319843734,     0.000016686935782,     0.000011856797707,     0.000008922187060,     0.000007016999714,     0.000005711726608,     0.000004777162375,     0.000004083203527,
     0.000003552023535,     0.000003134929429,     0.280809479476850,     0.014094489294217,     0.002120291925030,     0.000529829663108,     0.000183812997275,     0.000080675915634,     0.000042177828109,     0.000025153565731,
     0.000016568812747,     0.000011767925736,     0.000008852301854,     0.000006960120627,     0.000005664158554,     0.000004736507419,     0.000004047839572,     0.000003520813833,     0.000003107052850,     0.280668640510275,
     0.014073312835848,     0.002115002805621,     0.000527995559912,     0.000183008342824,     0.000080255392275,     0.000041927118935,     0.000024988464528,     0.000016451574947,     0.000011679749781,     0.000008782983068,
     0.000006903715194,     0.000005616995286,     0.000004696204548,     0.000004012786325,     0.000003489881643,     0.000003079426653,     0.280528013044134,     0.014052189177102,     0.002109731987080,     0.000526169482276,
     0.000182207881100,     0.000079837367771,     0.000041678054925,     0.000024824531305,     0.000016335215450,     0.000011592264202,     0.000008714225985,     0.000006847779384,     0.000005570233299,     0.000004656250666,
     0.000003978041023,     0.000003459224473,     0.000003052048571,     0.280387596551343,     0.014031118135370,     0.002104479389363,     0.000524351388397,     0.000181411587194,     0.000079421825731,     0.000041430624444,
     0.000024661757314,     0.000016219727381,     0.000011505463405,     0.000008646025929,     0.000006792309202,     0.000005523869119,     0.000004616642710,     0.000003943600927,     0.000003428839852,     0.000003024916355,
     0.280247390506643,     0.014010099528844,     0.002099244932838,     0.000522541236721,     0.000180619436364,     0.000079008749876,     0.000041184815944,     0.000024500133875,     0.000016105103918,     0.000011419341842,
     0.000008578378262,     0.000006737300687,     0.000005477899302,     0.000004577377640,     0.000003909463325,     0.000003398725333,     0.000002998027779,     0.280107394386586,     0.013989133176507,     0.002094028538292,
     0.000520738985941,     0.000179831404030,     0.000078598124044,     0.000040940617960,     0.000024339652376,     0.000015991338298,     0.000011333894014,     0.000008511278389,     0.000006682749913,     0.000005432320434,
     0.000004538452444,     0.000003875625528,     0.000003368878492,     0.000002971380636,     0.279967607669533,     0.013968218898134,     0.002088830126920,     0.000518944594994,     0.000179047465770,     0.000078189932186,
     0.000040698019118,     0.000024180304272,     0.000015878423810,     0.000011249114464,     0.000008444721751,     0.000006628652987,     0.000005387129130,     0.000004499864138,     0.000003842084871,     0.000003339296923,
     0.000002944972739,     0.279828029835642,     0.013947356514286,     0.002083649620329,     0.000517158023060,     0.000178267597326,     0.000077784158368,     0.000040457008125,     0.000024022081085,     0.000015766353799,
     0.000011164997783,     0.000008378703829,     0.000006575006050,     0.000005342322038,     0.000004461609765,     0.000003808838713,     0.000003309978247,     0.000002918801923,     0.279688660366861,     0.013926545846305,
     0.002078486940531,     0.000515379229562,     0.000177491774596,     0.000077380786768,     0.000040217573775,     0.000023864974403,     0.000015655121663,     0.000011081538606,     0.000008313220143,     0.000006521805276,
     0.000005297895832,     0.000004423686391,     0.000003775884438,     0.000003280920102,     0.000002892866041,     0.279549498746922,     0.013905786716312,     0.002073342009944,     0.000513608174162,     0.000176719973636,
     0.000076979801675,     0.000039979704943,     0.000023708975881,     0.000015544720853,     0.000010998731614,     0.000008248266249,     0.000006469046874,     0.000005253847216,     0.000004386091112,     0.000003743219451,
     0.000003252120150,     0.000002867162964,     0.279410544461332,     0.013885078947200,     0.002068214751388,     0.000511844816762,     0.000175952170659,     0.000076581187488,     0.000039743390591,     0.000023554077237,
     0.000015435144874,     0.000010916571530,     0.000008183837743,     0.000006416727084,     0.000005210172925,     0.000004348821047,     0.000003710841182,     0.000003223576073,     0.000002841690586,     0.279271796997363,
     0.013864422362633,     0.002063105088082,     0.000510089117501,     0.000175188342034,     0.000076184928718,     0.000039508619760,     0.000023400270255,     0.000015326387284,     0.000010835053123,     0.000008119930258,
     0.000006364842179,     0.000005166869721,     0.000004311873341,     0.000003678747084,     0.000003195285576,     0.000002816446818,     0.279133255844049,     0.013843816787042,     0.002058012943643,     0.000508341036752,
     0.000174428464285,     0.000075791009984,     0.000039275381574,     0.000023247546784,     0.000015218441690,     0.000010754171203,     0.000008056539462,     0.000006313388463,     0.000005123934393,     0.000004275245166,
     0.000003646934633,     0.000003167246382,     0.000002791429591,     0.278994920492175,     0.013823262045617,     0.002052938242083,     0.000506600535124,     0.000173672514086,     0.000075399416013,     0.000039043665239,
     0.000023095898736,     0.000015111301755,     0.000010673920625,     0.000007993661064,     0.000006262362275,     0.000005081363762,     0.000004238933718,     0.000003615401326,     0.000003139456236,     0.000002766636853,
     0.278856790434270,     0.013802757964309,     0.002047880907807,     0.000504867573456,     0.000172920468266,     0.000075010131642,     0.000038813460041,     0.000022945318085,     0.000015004961190,     0.000010594296288,
     0.000007931290804,     0.000006211759983,     0.000005039154673,     0.000004202936217,     0.000003584144685,     0.000003111912903,     0.000002742066573,     0.278718865164600,     0.013782304369821,     0.002042840865610,
     0.000503142112820,     0.000172172303804,     0.000074623141811,     0.000038584755346,     0.000022795796868,     0.000014899413759,     0.000010515293130,     0.000007869424463,     0.000006161577987,     0.000004997304000,
     0.000004167249910,     0.000003553162253,     0.000003084614170,     0.000002717716738,     0.278581144179159,     0.013761901089606,     0.002037818040676,     0.000501424114518,     0.000171427997831,     0.000074238431568,
     0.000038357540599,     0.000022647327186,     0.000014794653274,     0.000010436906133,     0.000007808057855,     0.000006111812719,     0.000004955808646,     0.000004131872066,     0.000003522451594,     0.000003057557840,
     0.000002693585352,     0.278443626975666,     0.013741547951865,     0.002032812358574,     0.000499713540078,     0.000170687527624,     0.000073855986067,     0.000038131805323,     0.000022499901200,     0.000014690673599,
     0.000010359130321,     0.000007747186831,     0.000006062460640,     0.000004914665540,     0.000004096799980,     0.000003492010295,     0.000003030741741,     0.000002669670438,     0.278306313053551,     0.013721244785539,
     0.002027823745256,     0.000498010351255,     0.000169950870609,     0.000073475790565,     0.000037907539122,     0.000022353511132,     0.000014587468647,     0.000010281960758,     0.000007686807277,     0.000006013518244,
     0.000004873871636,     0.000004062030971,     0.000003461835965,     0.000003004163717,     0.000002645970039,     0.278169201913952,     0.013700991420309,     0.002022852127057,     0.000496314510030,     0.000169218004361,
     0.000073097830422,     0.000037684731673,     0.000022208149265,     0.000014485032379,     0.000010205392550,     0.000007626915112,     0.000005964982053,     0.000004833423919,     0.000004027562379,     0.000003431926234,
     0.000002977821632,     0.000002622482212,     0.278032293059706,     0.013680787686592,     0.002017897430689,     0.000494625978606,     0.000168488906598,     0.000072722091103,     0.000037463372735,     0.000022063807942,
     0.000014383358807,     0.000010129420844,     0.000007567506293,     0.000005916848622,     0.000004793319396,     0.000003993391572,     0.000003402278753,     0.000002951713370,     0.000002599205035,     0.277895585995345,
     0.013660633415532,     0.002012959583244,     0.000492944719410,     0.000167763555185,     0.000072348558173,     0.000037243452138,     0.000021920479566,     0.000014282441990,     0.000010054040827,     0.000007508576809,
     0.000005869114531,     0.000004753555103,     0.000003959515938,     0.000003372891195,     0.000002925836835,     0.000002576136601,     0.277759080227081,     0.013640528439005,     0.002008038512185,     0.000491270695088,
     0.000167041928128,     0.000071977217300,     0.000037024959792,     0.000021778156599,     0.000014182276034,     0.000009979247724,     0.000007450122683,     0.000005821776395,     0.000004714128102,     0.000003925932889,
     0.000003343761251,     0.000002900189949,     0.000002553275023,     0.277622775262807,     0.013620472589608,     0.002003134145350,     0.000489603868506,     0.000166324003579,     0.000071608054250,     0.000036807885680,
     0.000021636831562,     0.000014082855095,     0.000009905036802,     0.000007392139972,     0.000005774830855,     0.000004675035479,     0.000003892639861,     0.000003314886637,     0.000002874770651,     0.000002530618430,
     0.277486670612087,     0.013600465700657,     0.001998246410945,     0.000487944202747,     0.000165609759831,     0.000071241054892,     0.000036592219859,     0.000021496497034,     0.000013984173373,     0.000009831403366,
     0.000007334624768,     0.000005728274581,     0.000004636274347,     0.000003859634313,     0.000003286265086,     0.000002849576903,     0.000002508164966,     0.277350765786146,     0.013580507606186,     0.001993375237548,
     0.000486291661112,     0.000164899175316,     0.000070876205191,     0.000036377952462,     0.000021357145650,     0.000013886225118,     0.000009758342761,     0.000007277573194,     0.000005682104272,     0.000004597841843,
     0.000003826913724,     0.000003257894354,     0.000002824606681,     0.000002485912795,     0.277215060297866,     0.013560598140940,     0.001988520554098,     0.000484646207115,     0.000164192228608,     0.000070513491214,
     0.000036165073693,     0.000021218770105,     0.000013789004624,     0.000009685850369,     0.000007220981407,     0.000005636316658,     0.000004559735131,     0.000003794475597,     0.000003229772214,     0.000002799857982,
     0.000002463860097,     0.277079553661778,     0.013540737140373,     0.001983682289901,     0.000483007804485,     0.000163488898419,     0.000070152899121,     0.000035953573831,     0.000021081363150,     0.000013692506232,
     0.000009613921613,     0.000007164845596,     0.000005590908493,     0.000004521951398,     0.000003762317458,     0.000003201896462,     0.000002775328820,     0.000002442005067,     0.276944245394056,     0.013520924440645,
     0.001978860374624,     0.000481376417162,     0.000162789163598,     0.000069794415173,     0.000035743443226,     0.000020944917592,     0.000013596724328,     0.000009542551950,     0.000007109161983,     0.000005545876563,
     0.000004484487856,     0.000003730436854,     0.000003174264913,     0.000002751017228,     0.000002420345919,     0.276809135012507,     0.013501159878617,     0.001974054738293,     0.000479752009298,     0.000162093003134,
     0.000069438025724,     0.000035534672298,     0.000020809426294,     0.000013501653344,     0.000009471736878,     0.000007053926821,     0.000005501217678,     0.000004447341744,     0.000003698831353,     0.000003146875399,
     0.000002726921255,     0.000002398880880,     0.276674222036566,     0.013481443291848,     0.001969265311292,     0.000478134545254,     0.000161400396147,     0.000069083717226,     0.000035327251543,     0.000020674882174,
     0.000013407287757,     0.000009401471931,     0.000006999136396,     0.000005456928679,     0.000004410510320,     0.000003667498546,     0.000003119725775,     0.000002703038969,     0.000002377608197,     0.276539505987291,
     0.013461774518591,     0.001964492024360,     0.000476523989599,     0.000160711321897,     0.000068731476224,     0.000035121171521,     0.000020541278206,     0.000013313622087,     0.000009331752680,     0.000006944787025,
     0.000005413006432,     0.000004373990872,     0.000003636436045,     0.000003092813914,     0.000002679368456,     0.000002356526129,     0.276404986387353,     0.013442153397791,     0.001959734808589,     0.000474920307109,
     0.000160025759776,     0.000068381289358,     0.000034916422868,     0.000020408607417,     0.000013220650899,     0.000009262574733,     0.000006890875056,     0.000005369447830,     0.000004337780706,     0.000003605641482,
     0.000003066137707,     0.000002655907817,     0.000002335632954,     0.276270662761029,     0.013422579769078,     0.001954993595424,     0.000473323462765,     0.000159343689307,     0.000068033143360,     0.000034712996285,
     0.000020276862891,     0.000013128368802,     0.000009193933733,     0.000006837396867,     0.000005326249795,     0.000004301877157,     0.000003575112512,     0.000003039695064,     0.000002632655172,     0.000002314926965,
     0.276136534634197,     0.013403053472768,     0.001950268316656,     0.000471733421752,     0.000158665090149,     0.000067687025056,     0.000034510882545,     0.000020146037762,     0.000013036770449,     0.000009125825361,
     0.000006784348868,     0.000005283409274,     0.000004266277578,     0.000003544846809,     0.000003013483916,     0.000002609608659,     0.000002294406468,     0.276002601534329,     0.013383574349856,     0.001945558904426,
     0.000470150149459,     0.000157989942091,     0.000067342921364,     0.000034310072488,     0.000020016125221,     0.000012945850534,     0.000009058245334,     0.000006731727500,     0.000005240923239,     0.000004230979351,
     0.000003514842069,     0.000002987502210,     0.000002586766430,     0.000002274069789,     0.275868862990483,     0.013364142242016,     0.001940865291219,     0.000468573611474,     0.000157318225050,     0.000067000819291,
     0.000034110557021,     0.000019887118508,     0.000012855603795,     0.000008991189401,     0.000006679529232,     0.000005198788691,     0.000004195979875,     0.000003485096007,     0.000002961747913,     0.000002564126656,
     0.000002253915265,     0.275735318533297,     0.013344756991592,     0.001936187409863,     0.000467003773587,     0.000156649919076,     0.000066660705938,     0.000033912327121,     0.000019759010918,     0.000012766025013,
     0.000008924653350,     0.000006627750564,     0.000005157002655,     0.000004161276576,     0.000003455606360,     0.000002936219008,     0.000002541687523,     0.000002233941250,     0.275601967694983,     0.013325418441602,
     0.001931525193527,     0.000465440601788,     0.000155985004345,     0.000066322568493,     0.000033715373828,     0.000019631795798,     0.000012677109009,     0.000008858633003,     0.000006576388027,     0.000005115562181,
     0.000004126866900,     0.000003426370882,     0.000002910913499,     0.000002519447235,     0.000002214146113,     0.275468810009318,     0.013306126435727,     0.001926878575720,     0.000463884062262,     0.000155323461162,
     0.000065986394236,     0.000033519688252,     0.000019505466546,     0.000012588850648,     0.000008793124214,     0.000006525438178,     0.000005074464346,     0.000004092748318,     0.000003397387352,     0.000002885829407,
     0.000002497404010,     0.000002194528239,     0.275335845011640,     0.013286880818313,     0.001922247490287,     0.000462334121392,     0.000154665269958,     0.000065652170532,     0.000033325261566,     0.000019380016610,
     0.000012501244834,     0.000008728122875,     0.000006474897607,     0.000005033706253,     0.000004058918321,     0.000003368653563,     0.000002860964768,     0.000002475556085,     0.000002175086024,     0.275203072238840,
     0.013267681434366,     0.001917631871408,     0.000460790745754,     0.000154010411291,     0.000065319884837,     0.000033132085010,     0.000019255439491,     0.000012414286512,     0.000008663624909,     0.000006424762930,
     0.000004993285026,     0.000004025374422,     0.000003340167331,     0.000002836317640,     0.000002453901710,     0.000002155817883,     0.275070491229356,     0.013248528129548,     0.001913031653598,     0.000459253902122,
     0.000153358865843,     0.000064989524694,     0.000032940149889,     0.000019131728738,     0.000012327970671,     0.000008599626275,     0.000006375030793,     0.000004953197819,     0.000003992114156,     0.000003311926491,
     0.000002811886095,     0.000002432439152,     0.000002136722243,     0.274938101523165,     0.013229420750174,     0.001908446771702,     0.000457723557457,     0.000152710614420,     0.000064661077730,     0.000032749447569,
     0.000019008877952,     0.000012242292336,     0.000008536122963,     0.000006325697870,     0.000004913441806,     0.000003959135081,     0.000003283928897,     0.000002787668223,     0.000002411166695,     0.000002117797545,
     0.274805902661778,     0.013210359143210,     0.001903877160895,     0.000456199678917,     0.000152065637952,     0.000064334531662,     0.000032559969484,     0.000018886880783,     0.000012157246574,     0.000008473110997,
     0.000006276760863,     0.000004874014188,     0.000003926434775,     0.000003256172421,     0.000002763662133,     0.000002390082636,     0.000002099042246,     0.274673894188234,     0.013191343156268,     0.001899322756679,
     0.000454682233845,     0.000151423917491,     0.000064009874288,     0.000032371707129,     0.000018765730929,     0.000012072828491,     0.000008410586436,     0.000006228216501,     0.000004834912189,     0.000003894010836,
     0.000003228654955,     0.000002739865948,     0.000002369185290,     0.000002080454816,     0.274542075647091,     0.013172372637602,     0.001894783494882,     0.000453171189776,     0.000150785434211,     0.000063687093495,
     0.000032184652062,     0.000018645422137,     0.000011989033233,     0.000008348545369,     0.000006180061543,     0.000004796133058,     0.000003861860886,     0.000003201374409,     0.000002716277810,     0.000002348472986,
     0.000002062033737,     0.274410446584424,     0.013153447436108,     0.001890259311655,     0.000451666514433,     0.000150150169406,     0.000063366177251,     0.000031998795903,     0.000018525948204,     0.000011905855985,
     0.000008286983918,     0.000006132292773,     0.000004757674066,     0.000003829982565,     0.000003174328711,     0.000002692895877,     0.000002327944066,     0.000002043777509,     0.274279006547814,     0.013134567401319,
     0.001885750143471,     0.000450168175722,     0.000149518104491,     0.000063047113608,     0.000031814130336,     0.000018407302973,     0.000011823291969,     0.000008225898237,     0.000006084907003,     0.000004719532509,
     0.000003798373536,     0.000003147515810,     0.000002669718323,     0.000002307596891,     0.000002025684643,     0.274147755086342,     0.013115732383399,     0.001881255927124,     0.000448676141738,     0.000148889220998,
     0.000062729890703,     0.000031630647102,     0.000018289480336,     0.000011741336447,     0.000008165284512,     0.000006037901073,     0.000004681705705,     0.000003767031480,     0.000003120933670,     0.000002646743339,
     0.000002287429834,     0.000002007753662,     0.274016691750587,     0.013096942233146,     0.001876776599726,     0.000447190380758,     0.000148263500580,     0.000062414496752,     0.000031448338007,     0.000018172474232,
     0.000011659984718,     0.000008105138960,     0.000005991271849,     0.000004644190997,     0.000003735954100,     0.000003094580274,     0.000002623969131,     0.000002267441283,     0.000001989983107,     0.273885816092616,
     0.013078196801983,     0.001872312098704,     0.000445710861244,     0.000147640925006,     0.000062100920056,     0.000031267194916,     0.000018056278645,     0.000011579232120,     0.000008045457830,     0.000005945016222,
     0.000004606985749,     0.000003705139118,     0.000003068453624,     0.000002601393923,     0.000002247629642,     0.000001972371529,     0.273755127665977,     0.013059495941959,     0.001867862361801,     0.000444237551836,
     0.000147021476161,     0.000061789148994,     0.000031087209752,     0.000017940887608,     0.000011499074026,     0.000007986237401,     0.000005899131111,     0.000004570087348,     0.000003674584278,     0.000003042551738,
     0.000002579015954,     0.000002227993327,     0.000001954917491,     0.273624626025697,     0.013040839505740,     0.001863427327071,     0.000442770421358,     0.000146405136046,     0.000061479172028,     0.000030908374501,
     0.000017826295198,     0.000011419505849,     0.000007927473983,     0.000005853613461,     0.000004533493203,     0.000003644287341,     0.000003016872653,     0.000002556833478,     0.000002208530771,     0.000001937619573,
     0.273494310728272,     0.013022227346615,     0.001859006932881,     0.000441309438812,     0.000145791886778,     0.000061170977698,     0.000030730681206,     0.000017712495539,     0.000011340523035,     0.000007869163917,
     0.000005808460241,     0.000004497200748,     0.000003614246089,     0.000002991414422,     0.000002534844765,     0.000002189240420,     0.000001920476365,     0.273364181331662,     0.013003659318485,     0.001854601117905,
     0.000439854573379,     0.000145181710588,     0.000060864554624,     0.000030554121968,     0.000017599482801,     0.000011262121071,     0.000007811303573,     0.000005763668449,     0.000004461207437,     0.000003584458323,
     0.000002966175117,     0.000002513048100,     0.000002170120733,     0.000001903486471,     0.273234237395284,     0.012985135275863,     0.001850209821125,     0.000438405794416,     0.000144574589819,     0.000060559891504,
     0.000030378688946,     0.000017487251197,     0.000011184295477,     0.000007753889353,     0.000005719235104,     0.000004425510744,     0.000003554921863,     0.000002941152826,     0.000002491441786,     0.000002151170184,
     0.000001886648507,     0.273104478480009,     0.012966655073871,     0.001845832981830,     0.000436963071456,     0.000143970506928,     0.000060256977117,     0.000030204374359,     0.000017375794985,     0.000011107041809,
     0.000007696917686,     0.000005675157253,     0.000004390108169,     0.000003525634549,     0.000002916345653,     0.000002470024138,     0.000002132387261,     0.000001869961102,     0.272974904148152,     0.012948218568236,
     0.001841470539610,     0.000435526374209,     0.000143369444485,     0.000059955800315,     0.000030031170481,     0.000017265108469,     0.000011030355660,     0.000007640385033,     0.000005631431968,     0.000004354997230,
     0.000003496594239,     0.000002891751720,     0.000002448793487,     0.000002113770465,     0.000001853422898,     0.272845513963469,     0.012929825615289,     0.001837122434360,     0.000434095672556,     0.000142771385167,
     0.000059656350030,     0.000029859069643,     0.000017155185995,     0.000010954232657,     0.000007584287881,     0.000005588056345,     0.000004320175468,     0.000003467798810,     0.000002867369165,     0.000002427748180,
     0.000002095318310,     0.000001837032547,     0.272716307491148,     0.012911476071959,     0.001832788606274,     0.000432670936553,     0.000142176311766,     0.000059358615270,     0.000029688064233,     0.000017046021953,
     0.000010878668462,     0.000007528622750,     0.000005545027503,     0.000004285640445,     0.000003439246157,     0.000002843196144,     0.000002406886577,     0.000002077029325,     0.000001820788717,     0.272587284297806,
     0.012893169795772,     0.001828468995843,     0.000431252136425,     0.000141584207180,     0.000059062585119,     0.000029518146694,     0.000016937610777,     0.000010803658773,     0.000007473386185,     0.000005502342588,
     0.000004251389742,     0.000003410934195,     0.000002819230827,     0.000002386207054,     0.000002058902052,     0.000001804690086,     0.272458443951481,     0.012874906644847,     0.001824163543858,     0.000429839242570,
     0.000140995054417,     0.000058768248735,     0.000029349309526,     0.000016829946943,     0.000010729199321,     0.000007418574761,     0.000005459998769,     0.000004217420965,     0.000003382860855,     0.000002795471401,
     0.000002365708002,     0.000002040935044,     0.000001788735343,     0.272329786021629,     0.012856686477896,     0.001819872191402,     0.000428432225553,     0.000140408836595,     0.000058475595352,     0.000029181545282,
     0.000016723024971,     0.000010655285872,     0.000007364185082,     0.000005417993237,     0.000004183731737,     0.000003355024087,     0.000002771916070,     0.000002345387824,     0.000002023126870,     0.000001772923190,
     0.272201310079112,     0.012838509154216,     0.001815594879855,     0.000427031056110,     0.000139825536936,     0.000058184614278,     0.000029014846572,     0.000016616839420,     0.000010581914225,     0.000007310213778,
     0.000005376323210,     0.000004150319702,     0.000003327421859,     0.000002748563054,     0.000002325244940,     0.000002005476109,     0.000001757252342,     0.272073015696201,     0.012820374533690,     0.001811331550885,
     0.000425635705143,     0.000139245138770,     0.000057895294894,     0.000028849206057,     0.000016511384894,     0.000010509080213,     0.000007256657508,     0.000005334985927,     0.000004117182525,     0.000003300052157,
     0.000002725410586,     0.000002305277782,     0.000001987981356,     0.000001741721524,     0.271944902446560,     0.012802282476783,     0.001807082146453,     0.000424246143719,     0.000138667625534,     0.000057607626654,
     0.000028684616455,     0.000016406656037,     0.000010436779702,     0.000007203512959,     0.000005293978651,     0.000004084317890,     0.000003272912984,     0.000002702456918,     0.000002285484797,     0.000001970641216,
     0.000001726329474,     0.271816969905249,     0.012784232844539,     0.001802846608808,     0.000422862343071,     0.000138092980768,     0.000057321599086,     0.000028521070535,     0.000016302647535,     0.000010365008592,
     0.000007150776844,     0.000005253298668,     0.000004051723503,     0.000003246002362,     0.000002679700315,     0.000002265864447,     0.000001953454308,     0.000001711074939,     0.271689217648715,     0.012766225498576,
     0.001798624880485,     0.000421484274596,     0.000137521188118,     0.000057037201788,     0.000028358561121,     0.000016199354114,     0.000010293762815,     0.000007098445904,     0.000005212943288,     0.000004019397088,
     0.000003219318327,     0.000002657139058,     0.000002246415205,     0.000001936419263,     0.000001695956680,     0.271561645254783,     0.012748260301089,     0.001794416904304,     0.000420111909855,     0.000136952231333,
     0.000056754424432,     0.000028197081087,     0.000016096770541,     0.000010223038334,     0.000007046516906,     0.000005172909841,     0.000003987336388,     0.000003192858935,     0.000002634771445,     0.000002227135560,
     0.000001919534725,     0.000001680973468,     0.271434252302656,     0.012730337114839,     0.001790222623369,     0.000418745220571,     0.000136386094264,     0.000056473256759,     0.000028036623361,     0.000015994891623,
     0.000010152831148,     0.000006994986643,     0.000005133195682,     0.000003955539167,     0.000003166622258,     0.000002612595787,     0.000002208024013,     0.000001902799348,     0.000001666124085,     0.271307038372905,
     0.012712455803159,     0.001786041981068,     0.000417384178625,     0.000135822760866,     0.000056193688580,     0.000027877180923,     0.000015893712207,     0.000010083137283,     0.000006943851936,     0.000005093798187,
     0.000003924003207,     0.000003140606385,     0.000002590610409,     0.000002189079080,     0.000001886211801,     0.000001651407326,     0.271180003047465,     0.012694616229944,     0.001781874921066,     0.000416028756061,
     0.000135262215195,     0.000055915709779,     0.000027718746802,     0.000015793227180,     0.000010013952801,     0.000006893109632,     0.000005054714754,     0.000003892726309,     0.000003114809421,     0.000002568813655,
     0.000002170299289,     0.000001869770763,     0.000001636821994,     0.271053145909629,     0.012676818259650,     0.001777721387308,     0.000414678925081,     0.000134704441406,     0.000055639310306,     0.000027561314082,
     0.000015693431466,     0.000009945273793,     0.000006842756603,     0.000005015942804,     0.000003861706295,     0.000003089229489,     0.000002547203878,     0.000002151683181,     0.000001853474927,     0.000001622366905,
     0.270926466544045,     0.012659061757296,     0.001773581324017,     0.000413334658046,     0.000134149423757,     0.000055364480182,     0.000027404875892,     0.000015594320032,     0.000009877096382,     0.000006792789746,
     0.000004977479779,     0.000003830941002,     0.000003063864726,     0.000002525779450,     0.000002133229310,     0.000001837322995,     0.000001608040884,     0.270799964536705,     0.012641346588453,     0.001769454675692,
     0.000411995927471,     0.000133597146604,     0.000055091209496,     0.000027249425417,     0.000015495887880,     0.000009809416721,     0.000006743205986,     0.000004939323142,     0.000003800428289,     0.000003038713287,
     0.000002504538756,     0.000002114936245,     0.000001821313683,     0.000001593842770,     0.270673639474944,     0.012623672619250,     0.001765341387104,     0.000410662706030,     0.000133047594402,     0.000054819488404,
     0.000027094955887,     0.000015398130051,     0.000009742230995,     0.000006694002271,     0.000004901470378,     0.000003770166031,     0.000003013773344,     0.000002483480194,     0.000002096802566,     0.000001805445717,
     0.000001579771408,     0.270547490947432,     0.012606039716362,     0.001761241403298,     0.000409334966551,     0.000132500751703,     0.000054549307131,     0.000026941460584,     0.000015301041626,     0.000009675535419,
     0.000006645175574,     0.000004863918994,     0.000003740152123,     0.000002989043082,     0.000002462602178,     0.000002078826864,     0.000001789717836,     0.000001565825657,     0.270421518544172,     0.012588447747017,
     0.001757154669590,     0.000408012682016,     0.000131956603159,     0.000054280655967,     0.000026788932839,     0.000015204617721,     0.000009609326237,     0.000006596722895,     0.000004826666515,     0.000003710384477,
     0.000002964520704,     0.000002441903135,     0.000002061007746,     0.000001774128789,     0.000001552004386,     0.270295721856488,     0.012570896578985,     0.001753081131565,     0.000406695825558,     0.000131415133516,
     0.000054013525271,     0.000026637366031,     0.000015108853492,     0.000009543599724,     0.000006548641256,     0.000004789710490,     0.000003680861022,     0.000002940204428,     0.000002421381506,     0.000002043343830,
     0.000001758677337,     0.000001538306471,     0.270170100477027,     0.012553386080580,     0.001749020735074,     0.000405384370466,     0.000130876327617,     0.000053747905466,     0.000026486753587,     0.000015013744130,
     0.000009478352185,     0.000006500927705,     0.000004753048487,     0.000003651579707,     0.000002916092487,     0.000002401035745,     0.000002025833745,     0.000001743362252,     0.000001524730803,     0.270044653999748,
     0.012535916120658,     0.001744973426239,     0.000404078290177,     0.000130340170402,     0.000053483787040,     0.000026337088981,     0.000014919284864,     0.000009413579953,     0.000006453579314,     0.000004716678096,
     0.000003622538497,     0.000002892183132,     0.000002380864323,     0.000002008476134,     0.000001728182317,     0.000001511276279,     0.269919382019921,     0.012518486568609,     0.001740939151443,     0.000402777558279,
     0.000129806646903,     0.000053221160548,     0.000026188365738,     0.000014825470959,     0.000009349279391,     0.000006406593179,     0.000004680596924,     0.000003593735375,     0.000002868474625,     0.000002360865719,
     0.000001991269652,     0.000001713136326,     0.000001497941809,     0.269794284134116,     0.012501097294360,     0.001736917857333,     0.000401482148510,     0.000129275742249,     0.000052960016609,     0.000026040577427,
     0.000014732297716,     0.000009285446891,     0.000006359966419,     0.000004644802601,     0.000003565168341,     0.000002844965246,     0.000002341038430,     0.000001974212965,     0.000001698223084,     0.000001484726311,
     0.269669359940206,     0.012483748168370,     0.001732909490819,     0.000400192034754,     0.000128747441660,     0.000052700345904,     0.000025893717664,     0.000014639760473,     0.000009222078874,     0.000006313696178,
     0.000004609292777,     0.000003536835412,     0.000002821653290,     0.000002321380965,     0.000001957304752,     0.000001683441407,     0.000001471628713,     0.269544609037352,     0.012466439061628,     0.001728913999071,
     0.000398907191045,     0.000128221730451,     0.000052442139181,     0.000025747780113,     0.000014547854602,     0.000009159171789,     0.000006267779623,     0.000004574065119,     0.000003508734623,     0.000002798537066,
     0.000002301891845,     0.000001940543702,     0.000001668790121,     0.000001458647955,     0.269420031026004,     0.012449169845648,     0.001724931329518,     0.000397627591562,     0.000127698594028,     0.000052185387249,
     0.000025602758482,     0.000014456575513,     0.000009096722112,     0.000006222213943,     0.000004539117317,     0.000003480864024,     0.000002775614897,     0.000002282569605,     0.000001923928519,     0.000001654268062,
     0.000001445782982,     0.269295625507896,     0.012431940392471,     0.001720961429845,     0.000396353210630,     0.000127178017887,     0.000051930080979,     0.000025458646528,     0.000014365918647,     0.000009034726350,
     0.000006176996351,     0.000004504447078,     0.000003453221683,     0.000002752885122,     0.000002263412792,     0.000001907457914,     0.000001639874078,     0.000001433032754,     0.269171392086037,     0.012414750574658,
     0.001717004247995,     0.000395084022718,     0.000126659987619,     0.000051676211307,     0.000025315438050,     0.000014275879484,     0.000008973181034,     0.000006132124084,     0.000004470052129,     0.000003425805686,
     0.000002730346094,     0.000002244419969,     0.000001891130614,     0.000001625607028,     0.000001420396237,     0.269047330364708,     0.012397600265291,     0.001713059732165,     0.000393820002439,     0.000126144488903,
     0.000051423769227,     0.000025173126895,     0.000014186453536,     0.000008912082726,     0.000006087594399,     0.000004435930216,     0.000003398614131,     0.000002707996181,     0.000002225589707,     0.000001874945354,
     0.000001611465778,     0.000001407872407,     0.268923439949458,     0.012380489337967,     0.001709127830805,     0.000392561124549,     0.000125631507506,     0.000051172745798,     0.000025031706951,     0.000014097636351,
     0.000008851428013,     0.000006043404577,     0.000004402079104,     0.000003371645137,     0.000002685833763,     0.000002206920592,     0.000001858900883,     0.000001597449207,     0.000001395460249,     0.268799720447095,
     0.012363417666798,     0.001705208492617,     0.000391307363945,     0.000125121029287,     0.000050923132138,     0.000024891172153,     0.000014009423509,     0.000008791213511,     0.000005999551921,     0.000004368496578,
     0.000003344896836,     0.000002663857237,     0.000002188411224,     0.000001842995958,     0.000001583556204,     0.000001383158759,     0.268676171465686,     0.012346385126408,     0.001701301666552,     0.000390058695666,
     0.000124613040193,     0.000050674919425,     0.000024751516480,     0.000013921810625,     0.000008731435860,     0.000005956033757,     0.000004335180438,     0.000003318367378,     0.000002642065011,     0.000002170060212,
     0.000001827229350,     0.000001569785667,     0.000001370966940,     0.268552792614547,     0.012329391591929,     0.001697407301812,     0.000388815094891,     0.000124107526258,     0.000050428098898,     0.000024612733955,
     0.000013834793346,     0.000008672091729,     0.000005912847432,     0.000004302128507,     0.000003292054927,     0.000002620455509,     0.000002151866180,     0.000001811599840,     0.000001556136503,     0.000001358883805,
     0.268429583504242,     0.012312436939002,     0.001693525347845,     0.000387576536937,     0.000123604473604,     0.000050182661855,     0.000024474818643,     0.000013748367356,     0.000008613177814,     0.000005869990314,
     0.000004269338622,     0.000003265957664,     0.000002599027168,     0.000002133827762,     0.000001796106219,     0.000001542607632,     0.000001346908375,     0.268306543746575,     0.012295521043771,     0.001689655754345,
     0.000386342997261,     0.000123103868438,     0.000049938599654,     0.000024337764651,     0.000013662528367,     0.000008554690834,     0.000005827459793,     0.000004236808642,     0.000003240073785,     0.000002577778440,
     0.000002115943606,     0.000001780747290,     0.000001529197980,     0.000001335039683,     0.268183672954586,     0.012278643782881,     0.001685798471253,     0.000385114451456,     0.000122605697057,     0.000049695903710,
     0.000024201566133,     0.000013577272127,     0.000008496627538,     0.000005785253282,     0.000004204536441,     0.000003214401501,     0.000002556707787,     0.000002098212371,     0.000001765521866,     0.000001515906485,
     0.000001323276766,     0.268060970742546,     0.012261805033477,     0.001681953448751,     0.000383890875252,     0.000122109945838,     0.000049454565499,     0.000024066217280,     0.000013492594415,     0.000008438984697,
     0.000005743368212,     0.000004172519913,     0.000003188939041,     0.000002535813687,     0.000002080632728,     0.000001750428770,     0.000001502732095,     0.000001311618674,     0.267938436725952,     0.012245004673202,
     0.001678120637263,     0.000382672244517,     0.000121616601249,     0.000049214576552,     0.000023931712330,     0.000013408491042,     0.000008381759111,     0.000005701802038,     0.000004140756967,     0.000003163684644,
     0.000002515094631,     0.000002063203359,     0.000001735466837,     0.000001489673766,     0.000001300064463,     0.267816070521524,     0.012228242580193,     0.001674299987456,     0.000381458535250,     0.000121125649838,
     0.000048975928458,     0.000023798045559,     0.000013324957852,     0.000008324947602,     0.000005660552234,     0.000004109245532,     0.000003138636569,     0.000002494549123,     0.000002045922958,     0.000001720634912,
     0.000001476730463,     0.000001288613198,     0.267693871747196,     0.012211518633078,     0.001670491450233,     0.000380249723587,     0.000120637078238,     0.000048738612866,     0.000023665211286,     0.000013241990720,
     0.000008268547020,     0.000005619616296,     0.000004077983554,     0.000003113793088,     0.000002474175680,     0.000002028790231,     0.000001705931848,     0.000001463901162,     0.000001277263954,     0.267571840022113,
     0.012194832710976,     0.001666694976738,     0.000379045785797,     0.000120150873167,     0.000048502621477,     0.000023533203871,     0.000013159585553,     0.000008212554238,     0.000005578991739,     0.000004046968994,
     0.000003089152487,     0.000002453972831,     0.000002011803895,     0.000001691356512,     0.000001451184847,     0.000001266015813,     0.267449974966628,     0.012178184693493,     0.001662910518349,     0.000377846698280,
     0.000119667021422,     0.000048267946051,     0.000023402017715,     0.000013077738287,     0.000008156966155,     0.000005538676098,     0.000004016199833,     0.000003064713068,     0.000002433939118,     0.000001994962679,
     0.000001676907778,     0.000001438580511,     0.000001254867865,     0.267328276202294,     0.012161574460720,     0.001659138026683,     0.000376652437568,     0.000119185509886,     0.000048034578403,     0.000023271647259,
     0.000012996444891,     0.000008101779695,     0.000005498666931,     0.000003985674068,     0.000003040473146,     0.000002414073097,     0.000001978265321,     0.000001662584532,     0.000001426087158,     0.000001243819210,
     0.267206743351862,     0.012145001893231,     0.001655377453586,     0.000375462980325,     0.000118706325522,     0.000047802510405,     0.000023142086985,     0.000012915701364,     0.000008046991803,     0.000005458961812,
     0.000003955389711,     0.000003016431052,     0.000002394373336,     0.000001961710574,     0.000001648385668,     0.000001413703799,     0.000001232868954,     0.267085376039275,     0.012128466872079,     0.001651628751142,
     0.000374278303343,     0.000118229455373,     0.000047571733981,     0.000023013331412,     0.000012835503736,     0.000007992599453,     0.000005419558338,     0.000003925344793,     0.000002992585130,     0.000002374838415,
     0.000001945297197,     0.000001634310092,     0.000001401429454,     0.000001222016212,     0.266964173889661,     0.012111969278798,     0.001647891871662,     0.000373098383546,     0.000117754886564,     0.000047342241112,
     0.000022885375103,     0.000012755848067,     0.000007938599639,     0.000005380454125,     0.000003895537360,     0.000002968933739,     0.000002355466925,     0.000001929023964,     0.000001620356719,     0.000001389263153,
     0.000001211260108,     0.266843136529333,     0.012095508995394,     0.001644166767690,     0.000371923197984,     0.000117282606299,     0.000047114023833,     0.000022758212658,     0.000012676730445,     0.000007884989381,
     0.000005341646806,     0.000003865965475,     0.000002945475251,     0.000002336257472,     0.000001912889659,     0.000001606524472,     0.000001377203933,     0.000001200599773,     0.266722263585779,     0.012079085904350,
     0.001640453391998,     0.000370752723834,     0.000116812601862,     0.000046887074231,     0.000022631838714,     0.000012598146990,     0.000007831765721,     0.000005303134036,     0.000003836627217,     0.000002922208054,
     0.000002317208673,     0.000001896893075,     0.000001592812286,     0.000001365250841,     0.000001190034345,     0.266601554687661,     0.012062699888617,     0.001636751697585,     0.000369586938402,     0.000116344860615,
     0.000046661384448,     0.000022506247950,     0.000012520093852,     0.000007778925726,     0.000005264913489,     0.000003807520682,     0.000002899130547,     0.000002298319156,     0.000001881033016,     0.000001579219105,
     0.000001353402932,     0.000001179562972,     0.266481009464811,     0.012046350831616,     0.001633061637676,     0.000368425819120,     0.000115879369999,     0.000046436946679,     0.000022381435082,     0.000012442567207,
     0.000007726466485,     0.000005226982857,     0.000003778643979,     0.000002876241144,     0.000002279587562,     0.000001865308299,     0.000001565743880,     0.000001341659271,     0.000001169184807,     0.266360627548220,
     0.012030038617237,     0.001629383165723,     0.000367269343542,     0.000115416117534,     0.000046213753171,     0.000022257394864,     0.000012365563262,     0.000007674385110,     0.000005189339850,     0.000003749995237,
     0.000002853538274,     0.000002261012543,     0.000001849717749,     0.000001552385575,     0.000001330018928,     0.000001158899014,     0.266240408570043,     0.012013763129830,     0.001625716235401,     0.000366117489350,
     0.000114955090814,     0.000045991796224,     0.000022134122087,     0.000012289078254,     0.000007622678737,     0.000005151982198,     0.000003721572597,     0.000002831020376,     0.000002242592763,     0.000001834260202,
     0.000001539143160,     0.000001318480985,     0.000001148704762,     0.266120352163585,     0.011997524254210,     0.001622060800606,     0.000364970234348,     0.000114496277513,     0.000045771068188,     0.000022011611581,
     0.000012213108447,     0.000007571344522,     0.000005114907650,     0.000003693374218,     0.000002808685905,     0.000002224326899,     0.000001818934503,     0.000001526015617,     0.000001307044531,     0.000001138601229,
     0.266000457963302,     0.011981321875652,     0.001618416815457,     0.000363827556462,     0.000114039665379,     0.000045551561468,     0.000021889858213,     0.000012137650133,     0.000007520379647,     0.000005078113972,
     0.000003665398273,     0.000002786533329,     0.000002206213637,     0.000001803739510,     0.000001513001934,     0.000001295708661,     0.000001128587598,     0.265880725604796,     0.011965155879888,     0.001614784234292,
     0.000362689433743,     0.000113585242238,     0.000045333268517,     0.000021768856886,     0.000012062699632,     0.000007469781314,     0.000005041598949,     0.000003637642950,     0.000002764561128,     0.000002188251677,
     0.000001788674088,     0.000001500101111,     0.000001284472482,     0.000001118663063,     0.265761154724808,     0.011949026153105,     0.001611163011671,     0.000361555844361,     0.000113132995988,     0.000045116181840,
     0.000021648602540,     0.000011988253294,     0.000007419546747,     0.000005005360384,     0.000003610106454,     0.000002742767796,     0.000002170439728,     0.000001773737115,     0.000001487312155,     0.000001273335106,
     0.000001108826822,     0.265641744961215,     0.011932932581943,     0.001607553102366,     0.000360426766607,     0.000112682914605,     0.000044900293993,     0.000021529090152,     0.000011914307494,     0.000007369673192,
     0.000004969396097,     0.000003582787003,     0.000002721151838,     0.000002152776510,     0.000001758927475,     0.000001474634083,     0.000001262295654,     0.000001099078082,     0.265522495953026,     0.011916875053496,
     0.001603954461372,     0.000359302178893,     0.000112234986137,     0.000044685597581,     0.000021410314734,     0.000011840858636,     0.000007320157918,     0.000004933703926,     0.000003555682831,     0.000002699711774,
     0.000002135260757,     0.000001744244067,     0.000001462065919,     0.000001251353255,     0.000001089416058,     0.265403407340377,     0.011900853455304,     0.001600367043893,     0.000358182059748,     0.000111789198706,
     0.000044472085258,     0.000021292271334,     0.000011767903150,     0.000007270998214,     0.000004898281728,     0.000003528792186,     0.000002678446135,     0.000002117891212,     0.000001729685794,     0.000001449606697,
     0.000001240507046,     0.000001079839970,     0.265284478764526,     0.011884867675355,     0.001596790805353,     0.000357066387821,     0.000111345540509,     0.000044259749731,     0.000021174955038,     0.000011695437495,
     0.000007222191391,     0.000004863127377,     0.000003502113332,     0.000002657353466,     0.000002100666628,     0.000001715251573,     0.000001437255460,     0.000001229756172,     0.000001070349047,     0.265165709867848,
     0.011868917602082,     0.001593225701384,     0.000355955141879,     0.000110903999813,     0.000044048583750,     0.000021058360963,     0.000011623458155,     0.000007173734780,     0.000004828238762,     0.000003475644545,
     0.000002636432324,     0.000002083585770,     0.000001700940328,     0.000001425011259,     0.000001219099784,     0.000001060942523,     0.265047100293833,     0.011853003124360,     0.001589671687832,     0.000354848300806,
     0.000110464564959,     0.000043838580120,     0.000020942484265,     0.000011551961641,     0.000007125625737,     0.000004793613791,     0.000003449384118,     0.000002615681276,     0.000002066647415,     0.000001686750994,
     0.000001412873152,     0.000001208537042,     0.000001051619641,     0.264928649687078,     0.011837124131504,     0.001586128720755,     0.000353745843599,     0.000110027224360,     0.000043629731690,     0.000020827320133,
     0.000011480944491,     0.000007077861633,     0.000004759250390,     0.000003423330357,     0.000002595098904,     0.000002049850348,     0.000001672682514,     0.000001400840209,     0.000001198067115,     0.000001042379649,
     0.264810357693287,     0.011821280513269,     0.001582596756417,     0.000352647749376,     0.000109591966498,     0.000043422031358,     0.000020712863789,     0.000011410403267,     0.000007030439864,     0.000004725146501,
     0.000003397481583,     0.000002574683802,     0.000002033193365,     0.000001658733842,     0.000001388911503,     0.000001187689176,     0.000001033221803,     0.264692223959263,     0.011805472159845,     0.001579075751293,
     0.000351553997365,     0.000109158779929,     0.000043215472071,     0.000020599110492,     0.000011340334561,     0.000006983357844,     0.000004691300081,     0.000003371836128,     0.000002554434574,     0.000002016675275,
     0.000001644903940,     0.000001377086121,     0.000001177402407,     0.000001024145365,     0.264574248132906,     0.011789698961857,     0.001575565662065,     0.000350464566911,     0.000108727653277,     0.000043010046820,
     0.000020486055534,     0.000011270734987,     0.000006936613011,     0.000004657709106,     0.000003346392343,     0.000002534349838,     0.000002000294894,     0.000001631191778,     0.000001365363154,     0.000001167205999,
     0.000001015149605,     0.264456429863205,     0.011773960810361,     0.001572066445618,     0.000349379437471,     0.000108298575236,     0.000042805748648,     0.000020373694240,     0.000011201601185,     0.000006890202818,
     0.000004624371567,     0.000003321148588,     0.000002514428221,     0.000001984051050,     0.000001617596338,     0.000001353741703,     0.000001157099149,     0.000001006233798,     0.264338768800238,     0.011758257596845,
     0.001568578059047,     0.000348298588615,     0.000107871534570,     0.000042602570639,     0.000020262021969,     0.000011132929823,     0.000006844124741,     0.000004591285473,     0.000003296103239,     0.000002494668365,
     0.000001967942582,     0.000001604116609,     0.000001342220875,     0.000001147081059,     0.000000997397227,     0.264221264595168,     0.011742589213223,     0.001565100459645,     0.000347222000025,     0.000107446520112,
     0.000042400505927,     0.000020151034113,     0.000011064717592,     0.000006798376277,     0.000004558448847,     0.000003271254686,     0.000002475068922,     0.000001951968336,     0.000001590751588,     0.000001330799788,
     0.000001137150942,     0.000000988639180,     0.264103916900233,     0.011726955551836,     0.001561633604912,     0.000346149651496,     0.000107023520763,     0.000042199547690,     0.000020040726097,     0.000010996961207,
     0.000006752954939,     0.000004525859728,     0.000003246601330,     0.000002455628555,     0.000001936127171,     0.000001577500284,     0.000001319477566,     0.000001127308016,     0.000000979958953,     0.263986725368748,
     0.011711356505450,     0.001558177452549,     0.000345081522930,     0.000106602525493,     0.000041999689154,     0.000019931093380,     0.000010929657411,     0.000006707858263,     0.000004493516175,     0.000003222141589,
     0.000002436345939,     0.000001920417954,     0.000001564361710,     0.000001308253340,     0.000001117551506,     0.000000971355847,     0.263869689655097,     0.011695791967251,     0.001554731960454,     0.000344017594342,
     0.000106183523337,     0.000041800923587,     0.000019822131451,     0.000010862802968,     0.000006663083804,     0.000004461416257,     0.000003197873890,     0.000002417219760,     0.000001904839564,     0.000001551334893,
     0.000001297126250,     0.000001107880645,     0.000000962829170,     0.263752809414731,     0.011680261830846,     0.001551297086728,     0.000342957845856,     0.000105766503400,     0.000041603244304,     0.000019713835834,
     0.000010796394669,     0.000006618629133,     0.000004429558062,     0.000003173796677,     0.000002398248715,     0.000001889390887,     0.000001538418865,     0.000001286095444,     0.000001098294670,     0.000000954378236,
     0.263636084304161,     0.011664765990261,     0.001547872789669,     0.000341902257703,     0.000105351454852,     0.000041406644664,     0.000019606202082,     0.000010730429327,     0.000006574491843,     0.000004397939693,
     0.000003149908403,     0.000002379431513,     0.000001874070821,     0.000001525612666,     0.000001275160076,     0.000001088792830,     0.000000946002365,     0.263519513980958,     0.011649304339936,     0.001544459027772,
     0.000340850810223,     0.000104938366930,     0.000041211118071,     0.000019499225781,     0.000010664903782,     0.000006530669546,     0.000004366559269,     0.000003126207538,     0.000002360766874,     0.000001858878271,
     0.000001512915348,     0.000001264319309,     0.000001079374375,     0.000000937700885,     0.263403098103745,     0.011633876774726,     0.001541055759728,     0.000339803483864,     0.000104527228936,     0.000041016657972,
     0.000019392902550,     0.000010599814894,     0.000006487159871,     0.000004335414923,     0.000003102692561,     0.000002342253527,     0.000001843812154,     0.000001500325967,     0.000001253572313,     0.000001070038566,
     0.000000929473127,     0.263286836332195,     0.011618483189899,     0.001537662944422,     0.000338760259180,     0.000104118030237,     0.000040823257857,     0.000019287228038,     0.000010535159550,     0.000006443960466,
     0.000004304504803,     0.000003079361967,     0.000002323890213,     0.000001828871395,     0.000001487843592,     0.000001242918265,     0.000001060784669,     0.000000921318431,     0.263170728327027,     0.011603123481132,
     0.001534280540936,     0.000337721116831,     0.000103710760267,     0.000040630911263,     0.000019182197925,     0.000010470934659,     0.000006401069000,     0.000004273827074,     0.000003056214261,     0.000002305675684,
     0.000001814054928,     0.000001475467295,     0.000001232356349,     0.000001051611956,     0.000000913236141,     0.263054773749999,     0.011587797544510,     0.001530908508542,     0.000336686037581,     0.000103305408522,
     0.000040439611765,     0.000019077807920,     0.000010407137152,     0.000006358483156,     0.000004243379913,     0.000003033247962,     0.000002287608703,     0.000001799361698,     0.000001463196160,     0.000001221885758,
     0.000001042519707,     0.000000905225608,     0.262938972263908,     0.011572505276526,     0.001527546806705,     0.000335655002301,     0.000102901964562,     0.000040249352985,     0.000018974053767,     0.000010343763984,
     0.000006316200639,     0.000004213161515,     0.000003010461599,     0.000002269688043,     0.000001784790658,     0.000001451029278,     0.000001211505689,     0.000001033507207,     0.000000897286187,     0.262823323532583,
     0.011557246574075,     0.001524195395080,     0.000334627991965,     0.000102500418014,     0.000040060128584,     0.000018870931236,     0.000010280812135,     0.000006274219169,     0.000004183170086,     0.000002987853717,
     0.000002251912486,     0.000001770340768,     0.000001438965747,     0.000001201215350,     0.000001024573748,     0.000000889417242,     0.262707827220884,     0.011542021334457,     0.001520854233512,     0.000333604987650,
     0.000102100758564,     0.000039871932269,     0.000018768436130,     0.000010218278605,     0.000006232536487,     0.000004153403850,     0.000002965422870,     0.000002234280827,     0.000001756011001,     0.000001427004675,
     0.000001191013953,     0.000001015718629,     0.000000881618140,     0.262592482994692,     0.011526829455371,     0.001517523282036,     0.000332585970537,     0.000101702975963,     0.000039684757784,     0.000018666564280,
     0.000010156160417,     0.000006191150348,     0.000004123861044,     0.000002943167625,     0.000002216791869,     0.000001741800336,     0.000001415145174,     0.000001180900719,     0.000001006941155,     0.000000873888256,
     0.262477290520914,     0.011511670834915,     0.001514202500873,     0.000331570921909,     0.000101307060023,     0.000039498598919,     0.000018565311547,     0.000010094454617,     0.000006150058527,     0.000004094539917,
     0.000002921086561,     0.000002199444427,     0.000001727707762,     0.000001403386369,     0.000001170874874,     0.000000998240636,     0.000000866226968,     0.262362249467470,     0.011496545371585,     0.001510891850432,
     0.000330559823149,     0.000100913000619,     0.000039313449503,     0.000018464673823,     0.000010033158273,     0.000006109258816,     0.000004065438737,     0.000002899178268,     0.000002182237324,     0.000001713732276,
     0.000001391727388,     0.000001160935652,     0.000000989616389,     0.000000858633661,     0.262247359503296,     0.011481452964269,     0.001507591291305,     0.000329552655742,     0.000100520787688,     0.000039129303407,
     0.000018364647026,     0.000009972268474,     0.000006068749025,     0.000004036555781,     0.000002877441350,     0.000002165169394,     0.000001699872885,     0.000001380167370,     0.000001151082294,     0.000000981067738,
     0.000000851107727,     0.262132620298334,     0.011466393512252,     0.001504300784274,     0.000328549401273,     0.000100130411227,     0.000038946154540,     0.000018265227108,     0.000009911782333,     0.000006028526979,
     0.000004007889343,     0.000002855874421,     0.000002148239483,     0.000001686128602,     0.000001368705459,     0.000001141314047,     0.000000972594012,     0.000000843648561,     0.262018031523534,     0.011451366915207,
     0.001501020290298,     0.000327550041429,     0.000099741861294,     0.000038763996855,     0.000018166410044,     0.000009851696983,     0.000005988590522,     0.000003979437730,     0.000002834476105,     0.000002131446442,
     0.000001672498451,     0.000001357340807,     0.000001131630166,     0.000000964194546,     0.000000836255565,     0.261903592850847,     0.011436373073198,     0.001497749770524,     0.000326554557992,     0.000099355128006,
     0.000038582824343,     0.000018068191841,     0.000009792009578,     0.000005948937514,     0.000003951199263,     0.000002813245039,     0.000002114789136,     0.000001658981464,     0.000001346072576,     0.000001122029911,
     0.000000955868682,     0.000000828928146,     0.261789303953219,     0.011421411886678,     0.001494489186277,     0.000325562932846,     0.000098970201543,     0.000038402631035,     0.000017970568535,     0.000009732717295,
     0.000005909565832,     0.000003923172276,     0.000002792179873,     0.000002098266439,     0.000001645576681,     0.000001334899933,     0.000001112512549,     0.000000947615766,     0.000000821665715,     0.261675164504592,
     0.011406483256483,     0.001491238499066,     0.000324575147971,     0.000098587072141,     0.000038223411002,     0.000017873536188,     0.000009673817331,     0.000005870473369,     0.000003895355117,     0.000002771279266,
     0.000002081877232,     0.000001632283150,     0.000001323822052,     0.000001103077355,     0.000000939435153,     0.000000814467692,     0.261561174179897,     0.011391587083834,     0.001487997670577,     0.000323591185445,
     0.000098205730098,     0.000038045158354,     0.000017777090890,     0.000009615306904,     0.000005831658035,     0.000003867746147,     0.000002750541887,     0.000002065620408,     0.000001619099927,     0.000001312838114,
     0.000001093723607,     0.000000931326200,     0.000000807333499,     0.261447332655052,     0.011376723270336,     0.001484766662675,     0.000322611027443,     0.000097826165769,     0.000037867867241,     0.000017681228760,
     0.000009557183253,     0.000005793117757,     0.000003840343740,     0.000002729966420,     0.000002049494869,     0.000001606026077,     0.000001301947310,     0.000001084450594,     0.000000923288272,     0.000000800262563,
     0.261333639606954,     0.011361891717972,     0.001481545437405,     0.000321634656236,     0.000097448369568,     0.000037691531848,     0.000017585945945,     0.000009499443638,     0.000005754850477,     0.000003813146283,
     0.000002709551556,     0.000002033499525,     0.000001593060673,     0.000001291148836,     0.000001075257607,     0.000000915320740,     0.000000793254319,     0.261220094713480,     0.011347092329105,     0.001478333956987,
     0.000320662054190,     0.000097072331965,     0.000037516146403,     0.000017491238617,     0.000009442085340,     0.000005716854154,     0.000003786152178,     0.000002689295999,     0.000002017633297,     0.000001580202795,
     0.000001280441894,     0.000001066143947,     0.000000907422979,     0.000000786308204,     0.261106697653484,     0.011332325006475,     0.001475132183816,     0.000319693203766,     0.000096698043492,     0.000037341705170,
     0.000017397102976,     0.000009385105659,     0.000005679126761,     0.000003759359837,     0.000002669198463,     0.000002001895114,     0.000001567451532,     0.000001269825695,     0.000001057108917,     0.000000899594370,
     0.000000779423662,     0.260993448106787,     0.011317589653196,     0.001471940080464,     0.000318728087521,     0.000096325494734,     0.000037168202451,     0.000017303535250,     0.000009328501915,     0.000005641666290,
     0.000003732767686,     0.000002649257673,     0.000001986283914,     0.000001554805981,     0.000001259299456,     0.000001048151831,     0.000000891834302,     0.000000772600142,     0.260880345754177,     0.011302886172757,
     0.001468757609676,     0.000317766688104,     0.000095954676334,     0.000036995632585,     0.000017210531693,     0.000009272271450,     0.000005604470745,     0.000003706374165,     0.000002629472365,     0.000001970798645,
     0.000001542265246,     0.000001248862401,     0.000001039272005,     0.000000884142166,     0.000000765837097,     0.260767390277409,     0.011288214469018,     0.001465584734370,     0.000316808988257,     0.000095585578991,
     0.000036823989949,     0.000017118088586,     0.000009216411624,     0.000005567538150,     0.000003680177725,     0.000002609841284,     0.000001955438262,     0.000001529828439,     0.000001238513760,     0.000001030468763,
     0.000000876517360,     0.000000759133985,     0.260654581359194,     0.011273574446208,     0.001462421417636,     0.000315854970818,     0.000095218193462,     0.000036653268957,     0.000017026202234,     0.000009160919817,
     0.000005530866539,     0.000003654176829,     0.000002590363187,     0.000001940201732,     0.000001517494679,     0.000001228252772,     0.000001021741435,     0.000000868959288,     0.000000752490271,     0.260541918683200,
     0.011258966008925,     0.001459267622736,     0.000314904618713,     0.000094852510558,     0.000036483464060,     0.000016934868971,     0.000009105793430,     0.000005494453966,     0.000003628369955,     0.000002571036840,
     0.000001925088028,     0.000001505263094,     0.000001218078681,     0.000001013089357,     0.000000861467359,     0.000000745905421,     0.260429401934047,     0.011244389062135,     0.001456123313101,     0.000313957914962,
     0.000094488521146,     0.000036314569746,     0.000016844085156,     0.000009051029881,     0.000005458298498,     0.000003602755591,     0.000002551861020,     0.000001910096133,     0.000001493132818,     0.000001207990736,
     0.000001004511869,     0.000000854040985,     0.000000739378910,     0.260317030797304,     0.011229843511167,     0.001452988452332,     0.000313014842675,     0.000094126216147,     0.000036146580538,     0.000016753847173,
     0.000008996626609,     0.000005422398218,     0.000003577332237,     0.000002532834515,     0.000001895225037,     0.000001481102994,     0.000001197988197,     0.000000996008320,     0.000000846679588,     0.000000732910214,
     0.260204804959486,     0.011215329261713,     0.001449863004198,     0.000312075385054,     0.000093765586536,     0.000035979490995,     0.000016664151432,     0.000008942581072,     0.000005386751222,     0.000003552098407,
     0.000002513956120,     0.000001880473741,     0.000001469172772,     0.000001188070326,     0.000000987578063,     0.000000839382590,     0.000000726498817,     0.260092724108045,     0.011200846219828,     0.001446746932638,
     0.000311139525390,     0.000093406623346,     0.000035813295714,     0.000016574994367,     0.000008888890747,     0.000005351355623,     0.000003527052625,     0.000002495224644,     0.000001865841252,     0.000001457341308,
     0.000001178236393,     0.000000979220456,     0.000000832149422,     0.000000720144205,     0.259980787931376,     0.011186394291925,     0.001443640201753,     0.000310207247062,     0.000093049317659,     0.000035647989324,
     0.000016486372441,     0.000008835553128,     0.000005316209547,     0.000003502193428,     0.000002476638902,     0.000001851326588,     0.000001445607767,     0.000001168485677,     0.000000970934864,     0.000000824979518,
     0.000000713845870,     0.259868996118804,     0.011171973384776,     0.001440542775814,     0.000309278533541,     0.000092693660614,     0.000035483566493,     0.000016398282137,     0.000008782565730,     0.000005281311137,
     0.000003477519365,     0.000002458197723,     0.000001836928773,     0.000001433971319,     0.000001158817458,     0.000000962720656,     0.000000817872319,     0.000000707603309,     0.259757348360587,     0.011157583405511,
     0.001437454619254,     0.000308353368384,     0.000092339643402,     0.000035320021921,     0.000016310719967,     0.000008729926086,     0.000005246658548,     0.000003453028996,     0.000002439899941,     0.000001822646841,
     0.000001422431145,     0.000001149231028,     0.000000954577210,     0.000000810827268,     0.000000701416023,     0.259645844347909,     0.011143224261611,     0.001434375696673,     0.000307431735236,     0.000091987257266,
     0.000035157350345,     0.000016223682465,     0.000008677631746,     0.000005212249950,     0.000003428720892,     0.000002421744403,     0.000001808479832,     0.000001410986428,     0.000001139725680,     0.000000946503906,
     0.000000803843816,     0.000000695283516,     0.259534483772878,     0.011128895860915,     0.001431305972830,     0.000306513617831,     0.000091636493502,     0.000034995546534,     0.000016137166189,     0.000008625680280,
     0.000005178083527,     0.000003404593637,     0.000002403729964,     0.000001794426797,     0.000001399636363,     0.000001130300718,     0.000000938500130,     0.000000796921417,     0.000000689205299,     0.259423266328520,
     0.011114598111609,     0.001428245412651,     0.000305598999987,     0.000091287343460,     0.000034834605295,     0.000016051167724,     0.000008574069274,     0.000005144157479,     0.000003380645826,     0.000002385855490,
     0.000001780486792,     0.000001388380148,     0.000001120955448,     0.000000930565276,     0.000000790059530,     0.000000683180886,     0.259312191708779,     0.011100330922233,     0.001425193981219,     0.000304687865611,
     0.000090939798538,     0.000034674521465,     0.000015965683677,     0.000008522796335,     0.000005110470017,     0.000003356876065,     0.000002368119855,     0.000001766658884,     0.000001377216991,     0.000001111689184,
     0.000000922698740,     0.000000783257621,     0.000000677209796,     0.259201259608512,     0.011086094201672,     0.001422151643780,     0.000303780198694,     0.000090593850190,     0.000034515289918,     0.000015880710679,
     0.000008471859084,     0.000005077019369,     0.000003333282970,     0.000002350521942,     0.000001752942145,     0.000001366146104,     0.000001102501247,     0.000000914899925,     0.000000776515158,     0.000000671291552,
     0.259090469723486,     0.011071887859159,     0.001419118365740,     0.000302875983314,     0.000090249489916,     0.000034356905559,     0.000015796245384,     0.000008421255164,     0.000005043803773,     0.000003309865170,
     0.000002333060644,     0.000001739335657,     0.000001355166707,     0.000001093390962,     0.000000907168240,     0.000000769831616,     0.000000665425680,     0.258979821750370,     0.011057711804274,     0.001416094112662,
     0.000301975203631,     0.000089906709271,     0.000034199363329,     0.000015712284472,     0.000008370982231,     0.000005010821485,     0.000003286621305,     0.000002315734864,     0.000001725838508,     0.000001344278028,
     0.000001084357661,     0.000000899503098,     0.000000763206472,     0.000000659611714,     0.258869315386742,     0.011043565946937,     0.001413078850268,     0.000301077843891,     0.000089565499859,     0.000034042658199,
     0.000015628824644,     0.000008321037962,     0.000004978070772,     0.000003263550025,     0.000002298543513,     0.000001712449796,     0.000001333479299,     0.000001075400680,     0.000000891903918,     0.000000756639210,
     0.000000653849188,     0.258758950331072,     0.011029450197413,     0.001410072544436,     0.000300183888424,     0.000089225853334,     0.000033886785177,     0.000015545862625,     0.000008271420050,     0.000004945549914,
     0.000003240649991,     0.000002281485510,     0.000001699168625,     0.000001322769762,     0.000001066519364,     0.000000884370123,     0.000000750129318,     0.000000648137643,     0.258648726282732,     0.011015364466306,
     0.001407075161204,     0.000299293321642,     0.000088887761398,     0.000033731739298,     0.000015463395163,     0.000008222126203,     0.000004913257206,     0.000003217919874,     0.000002264559785,     0.000001685994106,
     0.000001312148662,     0.000001057713062,     0.000000876901142,     0.000000743676289,     0.000000642476622,     0.258538642941982,     0.011001308664560,     0.001404086666760,     0.000298406128041,     0.000088551215807,
     0.000033577515636,     0.000015381419028,     0.000008173154151,     0.000004881190955,     0.000003195358357,     0.000002247765275,     0.000001672925360,     0.000001301615253,     0.000001048981127,     0.000000869496409,
     0.000000737279619,     0.000000636865674,     0.258428700009972,     0.010987282703454,     0.001401107027450,     0.000297522292199,     0.000088216208361,     0.000033424109291,     0.000015299931015,     0.000008124501635,
     0.000004849349481,     0.000003172964134,     0.000002231100928,     0.000001659961511,     0.000001291168794,     0.000001040322921,     0.000000862155363,     0.000000730938810,     0.000000631304352,     0.258318897188739,
     0.010973286494605,     0.001398136209774,     0.000296641798774,     0.000087882730913,     0.000033271515399,     0.000015218927938,     0.000008076166417,     0.000004817731119,     0.000003150735909,     0.000002214565698,
     0.000001647101696,     0.000001280808551,     0.000001031737810,     0.000000854877448,     0.000000724653368,     0.000000625792212,     0.258209234181199,     0.010959319949964,     0.001395174180384,     0.000295764632508,
     0.000087550775361,     0.000033119729126,     0.000015138406636,     0.000008028146275,     0.000004786334214,     0.000003128672394,     0.000002198158550,     0.000001634345056,     0.000001270533796,     0.000001023225164,
     0.000000847662113,     0.000000718422803,     0.000000620328814,     0.258099710691151,     0.010945382981814,     0.001392220906084,     0.000294890778221,     0.000087220333654,     0.000032968745671,     0.000015058363969,
     0.000007980439000,     0.000004755157126,     0.000003106772314,     0.000002181878456,     0.000001621690738,     0.000001260343808,     0.000001014784361,     0.000000840508811,     0.000000712246630,     0.000000614913722,
     0.257990326423266,     0.010931475502769,     0.001389276353830,     0.000294020220815,     0.000086891397788,     0.000032818560262,     0.000014978796820,     0.000007933042405,     0.000004724198227,     0.000003085034404,
     0.000002165724397,     0.000001609137899,     0.000001250237871,     0.000001006414783,     0.000000833417001,     0.000000706124369,     0.000000609546505,     0.257881081083089,     0.010917597425774,     0.001386340490728,
     0.000293152945272,     0.000086563959805,     0.000032669168159,     0.000014899702093,     0.000007885954314,     0.000004693455901,     0.000003063457409,     0.000002149695362,     0.000001596685703,     0.000001240215277,
     0.000000998115818,     0.000000826386145,     0.000000700055542,     0.000000604226735,     0.257771974377033,     0.010903748664100,     0.001383413284035,     0.000292288936652,     0.000086238011796,     0.000032520564655,
     0.000014821076713,     0.000007839172570,     0.000004662928547,     0.000003042040084,     0.000002133790350,     0.000001584333318,     0.000001230275322,     0.000000989886858,     0.000000819415713,     0.000000694039677,
     0.000000598953989,     0.257663006012377,     0.010889929131347,     0.001380494701155,     0.000291428180096,     0.000085913545899,     0.000032372745071,     0.000014742917628,     0.000007792695032,     0.000004632614572,
     0.000003020781192,     0.000002118008366,     0.000001572079923,     0.000001220417309,     0.000000981727304,     0.000000812505177,     0.000000688076307,     0.000000593727845,     0.257554175697263,     0.010876138741439,
     0.001377584709642,     0.000290570660820,     0.000085590554297,     0.000032225704759,     0.000014665221805,     0.000007746519573,     0.000004602512399,     0.000002999679510,     0.000002102348424,     0.000001559924701,
     0.000001210640546,     0.000000973636557,     0.000000805654014,     0.000000682164967,     0.000000588547887,     0.257445483140692,     0.010862377408624,     0.001374683277197,     0.000289716364121,     0.000085269029221,
     0.000032079439101,     0.000014587986236,     0.000007700644083,     0.000004572620461,     0.000002978733820,     0.000002086809548,     0.000001547866844,     0.000001200944350,     0.000000965614027,     0.000000798861706,
     0.000000676305197,     0.000000583413704,     0.257336928052519,     0.010848645047472,     0.001371790371667,     0.000288865275373,     0.000084948962948,     0.000031933943510,     0.000014511207931,     0.000007655066468,
     0.000004542937206,     0.000002957942918,     0.000002071390766,     0.000001535905548,     0.000001191328040,     0.000000957659128,     0.000000792127739,     0.000000670496541,     0.000000578324886,     0.257228510143454,
     0.010834941572874,     0.001368905961045,     0.000288017380025,     0.000084630347799,     0.000031789213428,     0.000014434883921,     0.000007609784648,     0.000004513461091,     0.000002937305608,     0.000002056091117,
     0.000001524040019,     0.000001181790944,     0.000000949771280,     0.000000785451606,     0.000000664738549,     0.000000573281028,     0.257120229125055,     0.010821266900041,     0.001366030013470,     0.000287172663605,
     0.000084313176143,     0.000031645244327,     0.000014359011259,     0.000007564796561,     0.000004484190586,     0.000002916820702,     0.000002040909649,     0.000001512269467,     0.000001172332393,     0.000000941949905,
     0.000000778832801,     0.000000659030772,     0.000000568281728,     0.257012084709728,     0.010807620944500,     0.001363162497224,     0.000286331111716,     0.000083997440391,     0.000031502031708,     0.000014283587017,
     0.000007520100156,     0.000004455124173,     0.000002896487024,     0.000002025845414,     0.000001500593111,     0.000001162951726,     0.000000934194434,     0.000000772270825,     0.000000653372767,     0.000000563326589,
     0.256904076610722,     0.010794003622097,     0.001360303380735,     0.000285492710036,     0.000083683133002,     0.000031359571101,     0.000014208608290,     0.000007475693402,     0.000004426260345,     0.000002876303406,
     0.000002010897475,     0.000001489010175,     0.000001153648287,     0.000000926504301,     0.000000765765181,     0.000000647764095,     0.000000558415215,     0.256796204542122,     0.010780414848991,     0.001357452632570,
     0.000284657444320,     0.000083370246477,     0.000031217858067,     0.000014134072191,     0.000007431574279,     0.000004397597609,     0.000002856268690,     0.000001996064902,     0.000001477519890,     0.000001144421424,
     0.000000918878944,     0.000000759315380,     0.000000642204318,     0.000000553547217,     0.256688468218856,     0.010766854541656,     0.001354610221442,     0.000283825300395,     0.000083058773363,     0.000031076888192,
     0.000014059975853,     0.000007387740784,     0.000004369134479,     0.000002836381727,     0.000001981346771,     0.000001466121494,     0.000001135270494,     0.000000911317809,     0.000000752920933,     0.000000636693007,
     0.000000548722208,     0.256580867356681,     0.010753322616876,     0.001351776116203,     0.000282996264166,     0.000082748706251,     0.000030936657093,     0.000013986316429,     0.000007344190929,     0.000004340869485,
     0.000002816641376,     0.000001966742168,     0.000001454814229,     0.000001126194856,     0.000000903820343,     0.000000746581360,     0.000000631229732,     0.000000543939802,     0.256473401672186,     0.010739818991749,
     0.001348950285847,     0.000282170321608,     0.000082440037774,     0.000030797160416,     0.000013913091095,     0.000007300922739,     0.000004312801167,     0.000002797046508,     0.000001952250185,     0.000001443597348,
     0.000001117193876,     0.000000896386000,     0.000000740296180,     0.000000625814070,     0.000000539199621,     0.256366070882789,     0.010726343583679,     0.001346132699505,     0.000281347458773,     0.000082132760609,
     0.000030658393834,     0.000013840297042,     0.000007257934255,     0.000004284928074,     0.000002777596000,     0.000001937869922,     0.000001432470105,     0.000001108266927,     0.000000889014239,     0.000000734064921,
     0.000000620445600,     0.000000534501287,     0.256258874706730,     0.010712896310381,     0.001343323326452,     0.000280527661783,     0.000081826867478,     0.000030520353047,     0.000013767931484,     0.000007215223532,
     0.000004257248769,     0.000002758288740,     0.000001923600487,     0.000001421431764,     0.000001099413385,     0.000000881704524,     0.000000727887112,     0.000000615123906,     0.000000529844426,     0.256151812863072,
     0.010699477089874,     0.001340522136096,     0.000279710916834,     0.000081522351143,     0.000030383033785,     0.000013695991652,     0.000007172788638,     0.000004229761825,     0.000002739123624,     0.000001909440993,
     0.000001410481595,     0.000001090632632,     0.000000874456321,     0.000000721762288,     0.000000609848575,     0.000000525228669,     0.256044885071695,     0.010686085840485,     0.001337729097987,     0.000278897210195,
     0.000081219204411,     0.000030246431804,     0.000013624474798,     0.000007130627659,     0.000004202465827,     0.000002720099557,     0.000001895390563,     0.000001399618871,     0.000001081924055,     0.000000867269103,
     0.000000715689987,     0.000000604619197,     0.000000520653649,     0.255938091053296,     0.010672722480842,     0.001334944181810,     0.000278086528204,     0.000080917420130,     0.000030110542888,     0.000013553378192,
     0.000007088738690,     0.000004175359368,     0.000002701215452,     0.000001881448327,     0.000001388842875,     0.000001073287048,     0.000000860142347,     0.000000709669752,     0.000000599435367,     0.000000516119002,
     0.255831430529383,     0.010659386929876,     0.001332167357386,     0.000277278857274,     0.000080616991190,     0.000029975362848,     0.000013482699124,     0.000007047119844,     0.000004148441055,     0.000002682470232,
     0.000001867613419,     0.000001378152894,     0.000001064721008,     0.000000853075536,     0.000000703701130,     0.000000594296684,     0.000000511624368,     0.255724903222273,     0.010646079106822,     0.001329398594673,
     0.000276474183886,     0.000080317910524,     0.000029840887523,     0.000013412434901,     0.000007005769246,     0.000004121709504,     0.000002663862829,     0.000001853884984,     0.000001367548220,     0.000001056225339,
     0.000000846068154,     0.000000697783670,     0.000000589202748,     0.000000507169390,     0.255618508855089,     0.010632798931210,     0.001326637863762,     0.000275672494593,     0.000080020171105,     0.000029707112776,
     0.000013342582851,     0.000006964685036,     0.000004095163342,     0.000002645392180,     0.000001840262173,     0.000001357028154,     0.000001047799449,     0.000000839119693,     0.000000691916927,     0.000000584153165,
     0.000000502753715,     0.255512247151758,     0.010619546322873,     0.001323885134879,     0.000274873776017,     0.000079723765947,     0.000029574034501,     0.000013273140319,     0.000006923865366,     0.000004068801208,
     0.000002627057236,     0.000001826744142,     0.000001346592001,     0.000001039442751,     0.000000832229648,     0.000000686100460,     0.000000579147544,     0.000000498376991,     0.255406117837006,     0.010606321201938,
     0.001321140378383,     0.000274078014850,     0.000079428688107,     0.000029441648614,     0.000013204104668,     0.000006883308403,     0.000004042621749,     0.000002608856951,     0.000001813330055,     0.000001336239071,
     0.000001031154663,     0.000000825397518,     0.000000680333831,     0.000000574185496,     0.000000494038872,     0.255300120636359,     0.010593123488829,     0.001318403564768,     0.000273285197853,     0.000079134930680,
     0.000029309951060,     0.000013135473281,     0.000006843012327,     0.000004016623623,     0.000002590790291,     0.000001800019085,     0.000001325968681,     0.000001022934609,     0.000000818622807,     0.000000674616606,
     0.000000569266639,     0.000000489739013,     0.255194255276135,     0.010579953104264,     0.001315674664656,     0.000272495311857,     0.000078842486804,     0.000029178937809,     0.000013067243558,     0.000006802975331,
     0.000003990805501,     0.000002572856228,     0.000001786810409,     0.000001315780154,     0.000001014782017,     0.000000811905023,     0.000000668948355,     0.000000564390590,     0.000000485477073,     0.255088521483442,
     0.010566809969255,     0.001312953648804,     0.000271708343761,     0.000078551349656,     0.000029048604858,     0.000012999412917,     0.000006763195621,     0.000003965166060,     0.000002555053745,     0.000001773703211,
     0.000001305672817,     0.000001006696320,     0.000000805243678,     0.000000663328653,     0.000000559556972,     0.000000481252713,     0.254982918986180,     0.010553694005104,     0.001310240488098,     0.000270924280531,
     0.000078261512453,     0.000028918948229,     0.000012931978794,     0.000006723671418,     0.000003939703991,     0.000002537381829,     0.000001760696684,     0.000001295646006,     0.000000998676957,     0.000000798638289,
     0.000000657757076,     0.000000554765411,     0.000000477065600,     0.254877447513032,     0.010540605133406,     0.001307535153554,     0.000270143109201,     0.000077972968450,     0.000028789963969,     0.000012864938643,
     0.000006684400954,     0.000003914417992,     0.000002519839478,     0.000001747790025,     0.000001285699059,     0.000000990723370,     0.000000792088377,     0.000000652233205,     0.000000550015537,     0.000000472915400,
     0.254772106793464,     0.010527543276042,     0.001304837616318,     0.000269364816874,     0.000077685710945,     0.000028661648151,     0.000012798289935,     0.000006645382476,     0.000003889306772,     0.000002502425698,
     0.000001734982439,     0.000001275831321,     0.000000982835006,     0.000000785593467,     0.000000646756627,     0.000000545306981,     0.000000468801784,     0.254666896557723,     0.010514508355184,     0.001302147847663,
     0.000268589390716,     0.000077399733272,     0.000028533996874,     0.000012732030159,     0.000006606614241,     0.000003864369052,     0.000002485139502,     0.000001722273137,     0.000001266042143,     0.000000975011319,
     0.000000779153088,     0.000000641326929,     0.000000540639380,     0.000000464724427,     0.254561816536831,     0.010501500293289,     0.001299465818992,     0.000267816817964,     0.000077115028806,     0.000028407006260,
     0.000012666156822,     0.000006568094521,     0.000003839603560,     0.000002467979910,     0.000001709661336,     0.000001256330881,     0.000000967251764,     0.000000772766774,     0.000000635943704,     0.000000536012373,
     0.000000460683006,     0.254456866462585,     0.010488519013099,     0.001296791501834,     0.000267047085918,     0.000076831590958,     0.000028280672458,     0.000012600667446,     0.000006529821600,     0.000003815009035,
     0.000002450945953,     0.000001697146261,     0.000001246696896,     0.000000959555804,     0.000000766434061,     0.000000630606548,     0.000000531425601,     0.000000456677199,     0.254352046067553,     0.010475564437642,
     0.001294124867847,     0.000266280181945,     0.000076549413180,     0.000028154991640,     0.000012535559573,     0.000006491793774,     0.000003790584226,     0.000002434036665,     0.000001684727143,     0.000001237139555,
     0.000000951922906,     0.000000760154491,     0.000000625315059,     0.000000526878711,     0.000000452706690,     0.254247355085072,     0.010462636490226,     0.001291465888811,     0.000265516093476,     0.000076268488961,
     0.000028029960003,     0.000012470830759,     0.000006454009353,     0.000003766327890,     0.000002417251092,     0.000001672403217,     0.000001227658229,     0.000000944352539,     0.000000753927609,     0.000000620068842,
     0.000000522371351,     0.000000448771165,     0.254142793249243,     0.010449735094443,     0.001288814536634,     0.000264754808009,     0.000075988811828,     0.000027905573769,     0.000012406478580,     0.000006416466659,
     0.000003742238795,     0.000002400588286,     0.000001660173727,     0.000001218252297,     0.000000936844179,     0.000000747752964,     0.000000614867502,     0.000000517903172,     0.000000444870310,     0.254038360294931,
     0.010436860174164,     0.001286170783349,     0.000263996313104,     0.000075710375347,     0.000027781829184,     0.000012342500626,     0.000006379164024,     0.000003718315718,     0.000002384047306,     0.000001648037922,
     0.000001208921141,     0.000000929397307,     0.000000741630110,     0.000000609710649,     0.000000513473830,     0.000000441003819,     0.253934055957761,     0.010424011653539,     0.001283534601111,     0.000263240596388,
     0.000075433173118,     0.000027658722517,     0.000012278894505,     0.000006342099795,     0.000003694557446,     0.000002367627218,     0.000001635995057,     0.000001199664148,     0.000000922011406,     0.000000735558604,
     0.000000604597897,     0.000000509082982,     0.000000437171384,     0.253829879974114,     0.010411189456997,     0.001280905962201,     0.000262487645549,     0.000075157198782,     0.000027536250062,     0.000012215657841,
     0.000006305272330,     0.000003670962774,     0.000002351327097,     0.000001624044394,     0.000001190480711,     0.000000914685965,     0.000000729538007,     0.000000599528862,     0.000000504730290,     0.000000433372702,
     0.253725832081125,     0.010398393509243,     0.001278284839021,     0.000261737448340,     0.000074882446015,     0.000027414408137,     0.000012152788274,     0.000006268679998,     0.000003647530507,     0.000002335146025,
     0.000001612185200,     0.000001181370229,     0.000000907420478,     0.000000723567883,     0.000000594503165,     0.000000500415417,     0.000000429607472,     0.253621912016683,     0.010385623735256,     0.001275671204096,
     0.000260989992578,     0.000074608908530,     0.000027293193081,     0.000012090283462,     0.000006232321182,     0.000003624259459,     0.000002319083091,     0.000001600416748,     0.000001172332104,     0.000000900214441,
     0.000000717647800,     0.000000589520429,     0.000000496138030,     0.000000425875397,     0.253518119519423,     0.010372880060291,     0.001273065030072,     0.000260245266139,     0.000074336580076,     0.000027172601259,
     0.000012028141078,     0.000006196194276,     0.000003601148454,     0.000002303137390,     0.000001588738318,     0.000001163365743,     0.000000893067356,     0.000000711777332,     0.000000584580280,     0.000000491897799,
     0.000000422176181,     0.253414454328729,     0.010360162409875,     0.001270466289716,     0.000259503256967,     0.000074065454440,     0.000027052629059,     0.000011966358809,     0.000006160297684,     0.000003578196324,
     0.000002287308027,     0.000001577149196,     0.000001154470562,     0.000000885978730,     0.000000705956054,     0.000000579682350,     0.000000487694398,     0.000000418509532,     0.253310916184725,     0.010347470709808,
     0.001267874955915,     0.000258763953062,     0.000073795525442,     0.000026933272890,     0.000011904934362,     0.000006124629823,     0.000003555401909,     0.000002271594111,     0.000001565648672,     0.000001145645976,
     0.000000878948073,     0.000000700183546,     0.000000574826271,     0.000000483527501,     0.000000414875160,     0.253207504828278,     0.010334804886159,     0.001265291001677,     0.000258027342489,     0.000073526786940,
     0.000026814529187,     0.000011843865455,     0.000006089189124,     0.000003532764060,     0.000002255994760,     0.000001554236043,     0.000001136891408,     0.000000871974898,     0.000000694459390,     0.000000570011679,
     0.000000479396788,     0.000000411272777,     0.253104220000992,     0.010322164865266,     0.001262714400127,     0.000257293413375,     0.000073259232828,     0.000026696394404,     0.000011783149827,     0.000006053974024,
     0.000003510281635,     0.000002240509099,     0.000001542910612,     0.000001128206288,     0.000000865058725,     0.000000688783175,     0.000000565238215,     0.000000475301940,     0.000000407702099,     0.253001061445208,
     0.010309550573736,     0.001260145124511,     0.000256562153905,     0.000072992857034,     0.000026578865020,     0.000011722785228,     0.000006018982977,     0.000003487953502,     0.000002225136260,     0.000001531671688,
     0.000001119590046,     0.000000858199076,     0.000000683154490,     0.000000560505522,     0.000000471242641,     0.000000404162843,     0.252898028903997,     0.010296961938444,     0.001257583148189,     0.000255833552327,
     0.000072727653521,     0.000026461937536,     0.000011662769426,     0.000005984214444,     0.000003465778536,     0.000002209875379,     0.000001520518583,     0.000001111042119,     0.000000851395478,     0.000000677572930,
     0.000000555813245,     0.000000467218579,     0.000000400654730,     0.252795122121161,     0.010284398886530,     0.001255028444643,     0.000255107596947,     0.000072463616289,     0.000026345608476,     0.000011603100203,
     0.000005949666899,     0.000003443755624,     0.000002194725604,     0.000001509450619,     0.000001102561951,     0.000000844647462,     0.000000672038092,     0.000000551161034,     0.000000463229444,     0.000000397177482,
     0.252692340841230,     0.010271861345397,     0.001252480987469,     0.000254384276133,     0.000072200739369,     0.000026229874384,     0.000011543775356,     0.000005915338828,     0.000003421883657,     0.000002179686085,
     0.000001498467120,     0.000001094148986,     0.000000837954562,     0.000000666549577,     0.000000546548541,     0.000000459274928,     0.000000393730825,     0.252589684809458,     0.010259349242714,     0.001249940750377,
     0.000253663578312,     0.000071939016829,     0.000026114731828,     0.000011484792700,     0.000005881228726,     0.000003400161537,     0.000002164755982,     0.000001487567417,     0.000001085802677,     0.000000831316317,
     0.000000661106989,     0.000000541975421,     0.000000455354726,     0.000000390314487,     0.252487153771821,     0.010246862506410,     0.001247407707197,     0.000252945491968,     0.000071678442772,     0.000026000177397,
     0.000011426150060,     0.000005847335101,     0.000003378588175,     0.000002149934460,     0.000001476750846,     0.000001077522479,     0.000000824732270,     0.000000655709938,     0.000000537441333,     0.000000451468538,
     0.000000386928198,     0.252384747475015,     0.010234401064677,     0.001244881831871,     0.000252230005648,     0.000071419011332,     0.000025886207701,     0.000011367845281,     0.000005813656471,     0.000003357162489,
     0.000002135220690,     0.000001466016749,     0.000001069307853,     0.000000818201968,     0.000000650358034,     0.000000532945938,     0.000000447616063,     0.000000383571690,     0.252282465666451,     0.010221964845966,
     0.001242363098456,     0.000251517107953,     0.000071160716680,     0.000025772819372,     0.000011309876219,     0.000005780191363,     0.000003335883405,     0.000002120613852,     0.000001455364473,     0.000001061158262,
     0.000000811724960,     0.000000645050891,     0.000000528488900,     0.000000443797006,     0.000000380244699,     0.252180308094257,     0.010209553778987,     0.001239851481121,     0.000250806787544,     0.000070903553018,
     0.000025660009065,     0.000011252240747,     0.000005746938317,     0.000003314749858,     0.000002106113130,     0.000001444793369,     0.000001053073177,     0.000000805300802,     0.000000639788129,     0.000000524069887,
     0.000000440011072,     0.000000376946962,     0.252078274507269,     0.010197167792709,     0.001237346954152,     0.000250099033141,     0.000070647514583,     0.000025547773452,     0.000011194936751,     0.000005713895884,
     0.000003293760791,     0.000002091717716,     0.000001434302796,     0.000001045052072,     0.000000798929051,     0.000000634569368,     0.000000519688569,     0.000000436257970,     0.000000373678219,     0.251976364655036,
     0.010184806816355,     0.001234849491943,     0.000249393833521,     0.000070392595644,     0.000025436109232,     0.000011137962132,     0.000005681062624,     0.000003272915155,     0.000002077426808,     0.000001423892116,
     0.000001037094423,     0.000000792609269,     0.000000629394233,     0.000000515344620,     0.000000432537411,     0.000000370438211,     0.251874578287811,     0.010172470779406,     0.001232359069002,     0.000248691177516,
     0.000070138790505,     0.000025325013119,     0.000011081314806,     0.000005648437106,     0.000003252211909,     0.000002063239610,     0.000001413560698,     0.000001029199714,     0.000000786341022,     0.000000624262352,
     0.000000511037714,     0.000000428849111,     0.000000367226685,     0.251772915156551,     0.010160159611596,     0.001229875659951,     0.000247991054017,     0.000069886093499,     0.000025214481851,     0.000011024992702,
     0.000005616017914,     0.000003231650020,     0.000002049155332,     0.000001403307914,     0.000001021367432,     0.000000780123879,     0.000000619173356,     0.000000506767531,     0.000000425192784,     0.000000364043385,
     0.251671375012915,     0.010147873242912,     0.001227399239517,     0.000247293451971,     0.000069634498996,     0.000025104512188,     0.000010968993764,     0.000005583803638,     0.000003211228462,     0.000002035173192,
     0.000001393133142,     0.000001013597068,     0.000000773957413,     0.000000614126880,     0.000000502533752,     0.000000421568150,     0.000000360888062,     0.251569957609261,     0.010135611603594,     0.001224929782543,
     0.000246598360381,     0.000069384001394,     0.000024995100906,     0.000010913315951,     0.000005551792881,     0.000003190946218,     0.000002021292411,     0.000001383035768,     0.000001005888117,     0.000000767841201,
     0.000000609122561,     0.000000498336063,     0.000000417974930,     0.000000357760466,     0.251468662698644,     0.010123374624133,     0.001222467263978,     0.000245905768305,     0.000069134595127,     0.000024886244805,
     0.000010857957233,     0.000005519984253,     0.000003170802279,     0.000002007512220,     0.000001373015177,     0.000000998240078,     0.000000761774823,     0.000000604160040,     0.000000494174150,     0.000000414412849,
     0.000000354660351,     0.251367490034810,     0.010111162235269,     0.001220011658881,     0.000245215664859,     0.000068886274658,     0.000024777940704,     0.000010802915597,     0.000005488376377,     0.000003150795641,
     0.000001993831854,     0.000001363070765,     0.000000990652455,     0.000000755757862,     0.000000599238960,     0.000000490047703,     0.000000410881632,     0.000000351587473,     0.251266439372200,     0.010098974367993,
     0.001217562942421,     0.000244528039211,     0.000068639034483,     0.000024670185443,     0.000010748189041,     0.000005456967886,     0.000003130925312,     0.000001980250553,     0.000001353201928,     0.000000983124757,
     0.000000749789907,     0.000000594358968,     0.000000485956415,     0.000000407381009,     0.000000348541590,     0.251165510465941,     0.010086810953541,     0.001215121089874,     0.000243842880586,     0.000068392869130,
     0.000024562975880,     0.000010693775579,     0.000005425757420,     0.000003111190303,     0.000001966767565,     0.000001343408071,     0.000000975656495,     0.000000743870547,     0.000000589519715,     0.000000481899982,
     0.000000403910711,     0.000000345522461,     0.251064703071848,     0.010074671923398,     0.001212686076622,     0.000243160178264,     0.000068147773157,     0.000024456308894,     0.000010639673237,     0.000005394743632,
     0.000003091589635,     0.000001953382144,     0.000001333688602,     0.000000968247186,     0.000000737999378,     0.000000584720854,     0.000000477878101,     0.000000400470472,     0.000000342529849,     0.250964016946419,
     0.010062557209293,     0.001210257878156,     0.000242479921577,     0.000067903741154,     0.000024350181384,     0.000010585880055,     0.000005363925183,     0.000003072122337,     0.000001940093547,     0.000001324042933,
     0.000000960896348,     0.000000732175997,     0.000000579962039,     0.000000473890473,     0.000000397060027,     0.000000339563519,     0.250863451846835,     0.010050466743200,     0.001207836470074,     0.000241802099912,
     0.000067660767741,     0.000024244590269,     0.000010532394086,     0.000005333300744,     0.000003052787444,     0.000001926901041,     0.000001314470482,     0.000000953603508,     0.000000726400005,     0.000000575242931,
     0.000000469936802,     0.000000393679114,     0.000000336623237,     0.250763007530955,     0.010038400457338,     0.001205421828077,     0.000241126702711,     0.000067418847571,     0.000024139532485,     0.000010479213398,
     0.000005302868996,     0.000003033583998,     0.000001913803896,     0.000001304970671,     0.000000946368192,     0.000000720671007,     0.000000570563191,     0.000000466016793,     0.000000390327476,     0.000000333708771,
     0.250662683757313,     0.010026358284166,     0.001203013927973,     0.000240453719468,     0.000067177975324,     0.000024035004990,     0.000010426336069,     0.000005272628629,     0.000003014511050,     0.000001900801387,
     0.000001295542928,     0.000000939189932,     0.000000714988611,     0.000000565922484,     0.000000462130156,     0.000000387004854,     0.000000330819892,     0.250562480285120,     0.010014340156386,     0.001200612745676,
     0.000239783139729,     0.000066938145713,     0.000023931004759,     0.000010373760192,     0.000005242578343,     0.000002995567657,     0.000001887892799,     0.000001286186684,     0.000000932068265,     0.000000709352428,
     0.000000561320478,     0.000000458276600,     0.000000383710993,     0.000000327956373,     0.250462396874258,     0.010002346006939,     0.001198218257201,     0.000239114953096,     0.000066699353481,     0.000023827528787,
     0.000010321483872,     0.000005212716847,     0.000002976752884,     0.000001875077417,     0.000001276901375,     0.000000925002731,     0.000000703762073,     0.000000556756843,     0.000000454455841,     0.000000380445643,
     0.000000325117988,     0.250362433285277,     0.009990375769008,     0.001195830438671,     0.000238449149219,     0.000066461593400,     0.000023724574089,     0.000010269505230,     0.000005183042860,     0.000002958065801,
     0.000001862354537,     0.000001267686443,     0.000000917992872,     0.000000698217164,     0.000000552231252,     0.000000450667593,     0.000000377208551,     0.000000322304515,     0.250262589279394,     0.009978429376012,
     0.001193449266309,     0.000237785717804,     0.000066224860272,     0.000023622137697,     0.000010217822394,     0.000005153555108,     0.000002939505487,     0.000001849723456,     0.000001258541334,     0.000000911038237,
     0.000000692717323,     0.000000547743383,     0.000000446911576,     0.000000373999470,     0.000000319515732,     0.250162864618494,     0.009966506761607,     0.001191074716441,     0.000237124648608,     0.000065989148928,
     0.000023520216661,     0.000010166433511,     0.000005124252330,     0.000002921071028,     0.000001837183479,     0.000001249465496,     0.000000904138377,     0.000000687262172,     0.000000543292914,     0.000000443187511,
     0.000000370818154,     0.000000316751420,     0.250063259065121,     0.009954607859687,     0.001188706765497,     0.000236465931437,     0.000065754454231,     0.000023418808053,     0.000010115336735,     0.000005095133271,
     0.000002902761516,     0.000001824733917,     0.000001240458385,     0.000000897292846,     0.000000681851341,     0.000000538879527,     0.000000439495122,     0.000000367664361,     0.000000314011361,     0.249963772382478,
     0.009942732604379,     0.001186345390006,     0.000235809556151,     0.000065520771069,     0.000023317908959,     0.000010064530237,     0.000005066196686,     0.000002884576051,     0.000001812374084,     0.000001231519459,
     0.000000890501204,     0.000000676484459,     0.000000534502907,     0.000000435834133,     0.000000364537847,     0.000000311295341,     0.249864404334430,     0.009930880930046,     0.001183990566601,     0.000235155512661,
     0.000065288094363,     0.000023217516487,     0.000010014012198,     0.000005037441340,     0.000002866513738,     0.000001800103302,     0.000001222648183,     0.000000883763012,     0.000000671161161,     0.000000530162741,
     0.000000432204275,     0.000000361438374,     0.000000308603146,     0.249765154685492,     0.009919052771284,     0.001181642272014,     0.000234503790926,     0.000065056419060,     0.000023117627760,     0.000009963780810,
     0.000005008866004,     0.000002848573690,     0.000001787920897,     0.000001213844022,     0.000000877077836,     0.000000665881084,     0.000000525858719,     0.000000428605276,     0.000000358365705,     0.000000305934564,
     0.249666023200836,     0.009907248062921,     0.001179300483077,     0.000233854380958,     0.000064825740138,     0.000023018239921,     0.000009913834282,     0.000004980469461,     0.000002830755027,     0.000001775826200,
     0.000001205106451,     0.000000870445247,     0.000000660643867,     0.000000521590534,     0.000000425036872,     0.000000355319605,     0.000000303289386,     0.249567009646282,     0.009895466740014,     0.001176965176722,
     0.000233207272819,     0.000064596052601,     0.000022919350130,     0.000009864170829,     0.000004952250502,     0.000002813056876,     0.000001763818547,     0.000001196434944,     0.000000863864817,     0.000000655449155,
     0.000000517357880,     0.000000421498796,     0.000000352299840,     0.000000300667404,     0.249468113788300,     0.009883708737854,     0.001174636329980,     0.000232562456618,     0.000064367351484,     0.000022820955567,
     0.000009814788684,     0.000004924207925,     0.000002795478368,     0.000001751897282,     0.000001187828982,     0.000000857336124,     0.000000650296592,     0.000000513160457,     0.000000417990788,     0.000000349306180,
     0.000000298068413,     0.249369335394005,     0.009871973991959,     0.001172313919982,     0.000231919922517,     0.000064139631849,     0.000022723053425,     0.000009765686087,     0.000004896340539,     0.000002778018644,
     0.000001740061751,     0.000001179288050,     0.000000850858746,     0.000000645185829,     0.000000508997965,     0.000000414512587,     0.000000346338396,     0.000000295492207,     0.249270674231154,     0.009860262438075,
     0.001169997923956,     0.000231279660726,     0.000063912888784,     0.000022625640919,     0.000009716861293,     0.000004868647159,     0.000002760676850,     0.000001728311306,     0.000001170811637,     0.000000844432269,
     0.000000640116517,     0.000000504870107,     0.000000411063935,     0.000000343396261,     0.000000292938586,     0.249172130068150,     0.009848574012175,     0.001167688319226,     0.000230641661503,     0.000063687117407,
     0.000022528715279,     0.000009668312567,     0.000004841126611,     0.000002743452137,     0.000001716645305,     0.000001162399236,     0.000000838056279,     0.000000635088312,     0.000000500776589,     0.000000407644577,
     0.000000340479550,     0.000000290407349,     0.249073702674030,     0.009836908650461,     0.001165385083216,     0.000230005915155,     0.000063462312865,     0.000022432273753,     0.000009620038188,     0.000004813777729,
     0.000002726343664,     0.000001705063110,     0.000001154050345,     0.000000831730367,     0.000000630100872,     0.000000496717119,     0.000000404254260,     0.000000337588040,     0.000000287898297,     0.248975391818472,
     0.009825266289357,     0.001163088193445,     0.000229372412039,     0.000063238470328,     0.000022336313606,     0.000009572036445,     0.000004786599353,     0.000002709350597,     0.000001693564088,     0.000001145764464,
     0.000000825454127,     0.000000625153857,     0.000000492691408,     0.000000400892733,     0.000000334721511,     0.000000285411234,     0.248877197271785,     0.009813646865513,     0.001160797627530,     0.000228741142558,
     0.000063015584997,     0.000022240832121,     0.000009524305637,     0.000004759590335,     0.000002692472107,     0.000001682147612,     0.000001137541098,     0.000000819227156,     0.000000620246932,     0.000000488699169,
     0.000000397559747,     0.000000331879743,     0.000000282945964,     0.248779118804914,     0.009802050315801,     0.001158513363181,     0.000228112097164,     0.000062793652099,     0.000022145826596,     0.000009476844077,
     0.000004732749532,     0.000002675707372,     0.000001670813059,     0.000001129379758,     0.000000813049055,     0.000000615379763,     0.000000484740118,     0.000000394255056,     0.000000329062519,     0.000000280502294,
     0.248681156189432,     0.009790476577318,     0.001156235378205,     0.000227485266357,     0.000062572666887,     0.000022051294348,     0.000009429650089,     0.000004706075811,     0.000002659055575,     0.000001659559812,
     0.000001121279955,     0.000000806919429,     0.000000610552020,     0.000000480813974,     0.000000390978415,     0.000000326269626,     0.000000278080033,     0.248583309197539,     0.009778925587380,     0.001153963650503,
     0.000226860640683,     0.000062352624643,     0.000021957232708,     0.000009382722008,     0.000004679568047,     0.000002642515907,     0.000001648387257,     0.000001113241209,     0.000000800837885,     0.000000605763375,
     0.000000476920457,     0.000000387729583,     0.000000323500848,     0.000000275678990,     0.248485577602064,     0.009767397283524,     0.001151698158072,     0.000226238210736,     0.000062133520673,     0.000021863639027,
     0.000009336058179,     0.000004653225122,     0.000002626087563,     0.000001637294786,     0.000001105263039,     0.000000794804033,     0.000000601013503,     0.000000473059291,     0.000000384508319,     0.000000320755976,
     0.000000273298979,     0.248387961176456,     0.009755891603507,     0.001149438879000,     0.000225617967158,     0.000061915350312,     0.000021770510669,     0.000009289656960,     0.000004627045927,     0.000002609769746,
     0.000001626281796,     0.000001097344970,     0.000000788817487,     0.000000596302082,     0.000000469230200,     0.000000381314385,     0.000000318034799,     0.000000270939811,     0.248290459694788,     0.009744408485305,
     0.001147185791472,     0.000224999900634,     0.000061698108918,     0.000021677845017,     0.000009243516718,     0.000004601029361,     0.000002593561664,     0.000001615347688,     0.000001089486533,     0.000000782877864,
     0.000000591628793,     0.000000465432913,     0.000000378147544,     0.000000315337111,     0.000000268601303,     0.248193072931750,     0.009732947867111,     0.001144938873762,     0.000224384001898,     0.000061481791878,
     0.000021585639470,     0.000009197635834,     0.000004575174331,     0.000002577462531,     0.000001604491868,     0.000001081687258,     0.000000776984785,     0.000000586993319,     0.000000461667160,     0.000000375007565,
     0.000000312662705,     0.000000266283272,     0.248095800662651,     0.009721509687336,     0.001142698104239,     0.000223770261730,     0.000061266394603,     0.000021493891442,     0.000009152012697,     0.000004549479750,
     0.000002561471568,     0.000001593713747,     0.000001073946683,     0.000000771137872,     0.000000582395346,     0.000000457932673,     0.000000371894213,     0.000000310011377,     0.000000263985535,     0.247998642663413,
     0.009710093884605,     0.001140463461363,     0.000223158670955,     0.000061051912532,     0.000021402598362,     0.000009106645708,     0.000004523944541,     0.000002545587999,     0.000001583012740,     0.000001066264348,
     0.000000765336754,     0.000000577834562,     0.000000454229187,     0.000000368807261,     0.000000307382927,     0.000000261707914,     0.247901598710573,     0.009698700397758,     0.001138234923685,     0.000222549220444,
     0.000060838341128,     0.000021311757679,     0.000009061533278,     0.000004498567635,     0.000002529811058,     0.000001572388267,     0.000001058639796,     0.000000759581058,     0.000000573310660,     0.000000450556440,
     0.000000365746479,     0.000000304777153,     0.000000259450229,     0.247804668581275,     0.009687329165851,     0.001136012469850,     0.000221941901112,     0.000060625675879,     0.000021221366854,     0.000009016673831,
     0.000004473347967,     0.000002514139981,     0.000001561839753,     0.000001051072576,     0.000000753870419,     0.000000568823332,     0.000000446914171,     0.000000362711643,     0.000000302193856,     0.000000257212305,
     0.247707852053275,     0.009675980128152,     0.001133796078589,     0.000221336703921,     0.000060413912300,     0.000021131423364,     0.000008972065798,     0.000004448284485,     0.000002498574012,     0.000001551366626,
     0.000001043562239,     0.000000748204471,     0.000000564372276,     0.000000443302122,     0.000000359702528,     0.000000299632841,     0.000000254993965,     0.247611148904933,     0.009664653224142,     0.001131585728728,
     0.000220733619876,     0.000060203045929,     0.000021041924705,     0.000008927707624,     0.000004423376139,     0.000002483112399,     0.000001540968320,     0.000001036108339,     0.000000742582853,     0.000000559957190,
     0.000000439720036,     0.000000356718912,     0.000000297093912,     0.000000252795037,     0.247514558915214,     0.009653348393510,     0.001129381399178,     0.000220132640026,     0.000059993072331,     0.000020952868384,
     0.000008883597762,     0.000004398621891,     0.000002467754398,     0.000001530644273,     0.000001028710435,     0.000000737005208,     0.000000555577776,     0.000000436167659,     0.000000353760577,     0.000000294576876,
     0.000000250615349,     0.247418081863685,     0.009642065576160,     0.001127183068943,     0.000219533755468,     0.000059783987095,     0.000020864251927,     0.000008839734676,     0.000004374020708,     0.000002452499268,
     0.000001520393926,     0.000001021368090,     0.000000731471180,     0.000000551233738,     0.000000432644741,     0.000000350827303,     0.000000292081542,     0.000000248454731,     0.247321717530513,     0.009630804712203,
     0.001124990717114,     0.000218936957338,     0.000059575785835,     0.000020776072873,     0.000008796116841,     0.000004349571565,     0.000002437346275,     0.000001510216727,     0.000001014080868,     0.000000725980416,
     0.000000546924784,     0.000000429151030,     0.000000347918874,     0.000000289607719,     0.000000246313012,     0.247225465696462,     0.009619565741959,     0.001122804322871,     0.000218342236819,     0.000059368464188,
     0.000020688328778,     0.000008752742741,     0.000004325273445,     0.000002422294691,     0.000001500112126,     0.000001006848338,     0.000000720532568,     0.000000542650621,     0.000000425686281,     0.000000345035077,
     0.000000287155219,     0.000000244190027,     0.247129326142893,     0.009608348605956,     0.001120623865481,     0.000217749585137,     0.000059162017817,     0.000020601017211,     0.000008709610872,     0.000004301125336,
     0.000002407343793,     0.000001490079579,     0.000000999670074,     0.000000715127289,     0.000000538410962,     0.000000422250247,     0.000000342175699,     0.000000284723856,     0.000000242085609,     0.247033298651760,
     0.009597153244929,     0.001118449324301,     0.000217158993559,     0.000058956442410,     0.000020514135758,     0.000008666719738,     0.000004277126236,     0.000002392492861,     0.000001480118545,     0.000000992545652,
     0.000000709764235,     0.000000534205521,     0.000000418842686,     0.000000339340530,     0.000000282313446,     0.000000239999593,     0.246937383005608,     0.009585979599818,     0.001116280678772,     0.000216570453399,
     0.000058751733676,     0.000020427682019,     0.000008624067854,     0.000004253275148,     0.000002377741185,     0.000001470228488,     0.000000985474650,     0.000000704443065,     0.000000530034014,     0.000000415463357,
     0.000000336529361,     0.000000279923804,     0.000000237931818,     0.246841578987573,     0.009574827611770,     0.001114117908424,     0.000215983956011,     0.000058547887352,     0.000020341653608,     0.000008581653745,
     0.000004229571084,     0.000002363088057,     0.000001460408876,     0.000000978456652,     0.000000699163442,     0.000000525896161,     0.000000412112020,     0.000000333741985,     0.000000277554749,     0.000000235882121,
     0.246745886381378,     0.009563697222134,     0.001111960992871,     0.000215399492792,     0.000058344899194,     0.000020256048156,     0.000008539475945,     0.000004206013061,     0.000002348532775,     0.000001450659180,
     0.000000971491244,     0.000000693925031,     0.000000521791682,     0.000000408788438,     0.000000330978198,     0.000000275206102,     0.000000233850342,     0.246650304971331,     0.009552588372464,     0.001109809911816,
     0.000214817055181,     0.000058142764987,     0.000020170863306,     0.000008497533000,     0.000004182600104,     0.000002334074642,     0.000001440978877,     0.000000964578015,     0.000000688727498,     0.000000517720300,
     0.000000405492378,     0.000000328237796,     0.000000272877683,     0.000000231836323,     0.246554834542323,     0.009541501004517,     0.001107664645044,     0.000214236634660,     0.000057941480534,     0.000020086096718,
     0.000008455823463,     0.000004159331246,     0.000002319712967,     0.000001431367447,     0.000000957716559,     0.000000683570515,     0.000000513681743,     0.000000402223605,     0.000000325520578,     0.000000270569316,
     0.000000229839907,     0.246459474879828,     0.009530435060249,     0.001105525172427,     0.000213658222752,     0.000057741041666,     0.000020001746064,     0.000008414345898,     0.000004136205526,     0.000002305447065,
     0.000001421824375,     0.000000950906471,     0.000000678453755,     0.000000509675738,     0.000000398981890,     0.000000322826343,     0.000000268280827,     0.000000227860938,     0.246364225769899,     0.009519390481821,
     0.001103391473922,     0.000213081811022,     0.000057541444234,     0.000019917809032,     0.000008373098878,     0.000004113221988,     0.000002291276254,     0.000001412349148,     0.000000944147351,     0.000000673376893,
     0.000000505702016,     0.000000395767002,     0.000000320154895,     0.000000266012040,     0.000000225899261,     0.246269086999164,     0.009508367211590,     0.001101263529567,     0.000212507391076,     0.000057342684114,
     0.000019834283323,     0.000008332080987,     0.000004090379686,     0.000002277199858,     0.000001402941259,     0.000000937438801,     0.000000668339608,     0.000000501760309,     0.000000392578717,     0.000000317506038,
     0.000000263762784,     0.000000223954724,     0.246174058354831,     0.009497365192115,     0.001099141319489,     0.000211934954562,     0.000057144757204,     0.000019751166653,     0.000008291290817,     0.000004067677678,
     0.000002263217206,     0.000001393600204,     0.000000930780428,     0.000000663341581,     0.000000497850354,     0.000000389416807,     0.000000314879575,     0.000000261532889,     0.000000222027174,     0.246079139624677,
     0.009486384366152,     0.001097024823892,     0.000211364493168,     0.000056947659425,     0.000019668456752,     0.000008250726969,     0.000004045115031,     0.000002249327632,     0.000001384325484,     0.000000924171840,
     0.000000658382496,     0.000000493971886,     0.000000386281051,     0.000000312275316,     0.000000259322185,     0.000000220116463,     0.245984330597053,     0.009475424676655,     0.001094914023069,     0.000210795998623,
     0.000056751386721,     0.000019586151364,     0.000008210388055,     0.000004022690818,     0.000002235530477,     0.000001375116603,     0.000000917612649,     0.000000653462039,     0.000000490124646,     0.000000383171227,
     0.000000309693068,     0.000000257130504,     0.000000218222440,     0.245889631060879,     0.009464486066774,     0.001092808897391,     0.000210229462697,     0.000056555935057,     0.000019504248246,     0.000008170272695,
     0.000004000404116,     0.000002221825083,     0.000001365973068,     0.000000911102471,     0.000000648579900,     0.000000486308376,     0.000000380087117,     0.000000307132643,     0.000000254957681,     0.000000216344958,
     0.245795040805641,     0.009453568479855,     0.001090709427314,     0.000209664877199,     0.000056361300422,     0.000019422745169,     0.000008130379517,     0.000003978254012,     0.000002208210799,     0.000001356894391,
     0.000000904640924,     0.000000643735769,     0.000000482522819,     0.000000377028502,     0.000000304593852,     0.000000252803550,     0.000000214483871,     0.245700559621393,     0.009442671859440,     0.001088615593373,
     0.000209102233978,     0.000056167478828,     0.000019341639919,     0.000008090707162,     0.000003956239598,     0.000002194686980,     0.000001347880089,     0.000000898227630,     0.000000638929342,     0.000000478767721,
     0.000000373995168,     0.000000302076510,     0.000000250667949,     0.000000212639034,     0.245606187298752,     0.009431796149265,     0.001086527376187,     0.000208541524925,     0.000055974466305,     0.000019260930294,
     0.000008051254276,     0.000003934359973,     0.000002181252984,     0.000001338929679,     0.000000891862213,     0.000000634160314,     0.000000475042832,     0.000000370986901,     0.000000299580432,     0.000000248550716,
     0.000000210810304,     0.245511923628894,     0.009420941293259,     0.001084444756454,     0.000207982741968,     0.000055782258910,     0.000019180614106,     0.000008012019516,     0.000003912614242,     0.000002167908175,
     0.000001330042686,     0.000000885544300,     0.000000629428385,     0.000000471347901,     0.000000368003489,     0.000000297105435,     0.000000246451690,     0.000000208997537,     0.245417768403559,     0.009410107235542,
     0.001082367714954,     0.000207425877076,     0.000055590852719,     0.000019100689181,     0.000007973001548,     0.000003891001515,     0.000002154651921,     0.000001321218636,     0.000000879273522,     0.000000624733257,
     0.000000467682680,     0.000000365044723,     0.000000294651338,     0.000000244370712,     0.000000207200593,     0.245323721415041,     0.009399293920429,     0.001080296232546,     0.000206870922256,     0.000055400243830,
     0.000019021153357,     0.000007934199046,     0.000003869520910,     0.000002141483594,     0.000001312457060,     0.000000873049513,     0.000000620074634,     0.000000464046925,     0.000000362110394,     0.000000292217961,
     0.000000242307626,     0.000000205419332,     0.245229782456193,     0.009388501292424,     0.001078230290169,     0.000206317869555,     0.000055210428362,     0.000018942004487,     0.000007895610692,     0.000003848171552,
     0.000002128402573,     0.000001303757491,     0.000000866871909,     0.000000615452221,     0.000000460440391,     0.000000359200295,     0.000000289805126,     0.000000240262274,     0.000000203653615,     0.245135951320420,
     0.009377729296222,     0.001076169868841,     0.000205766711057,     0.000055021402457,     0.000018863240434,     0.000007857235180,     0.000003826952570,     0.000002115408239,     0.000001295119468,     0.000000860740349,
     0.000000610865729,     0.000000456862839,     0.000000356314223,     0.000000287412657,     0.000000238234502,     0.000000201903305,     0.245042227801680,     0.009366977876707,     0.001074114949660,     0.000205217438887,
     0.000054833162278,     0.000018784859078,     0.000007819071209,     0.000003805863100,     0.000002102499980,     0.000001286542532,     0.000000854654476,     0.000000606314869,     0.000000453314027,     0.000000353451975,
     0.000000285040378,     0.000000236224157,     0.000000200168266,     0.244948611694480,     0.009356246978951,     0.001072065513801,     0.000204670045205,     0.000054645704007,     0.000018706858309,     0.000007781117489,
     0.000003784902285,     0.000002089677187,     0.000001278026228,     0.000000848613934,     0.000000601799354,     0.000000449793720,     0.000000350613349,     0.000000282688116,     0.000000234231086,     0.000000198448363,
     0.244855102793877,     0.009345536548216,     0.001070021542520,     0.000204124522213,     0.000054459023850,     0.000018629236031,     0.000007743372737,     0.000003764069273,     0.000002076939255,     0.000001269570103,
     0.000000842618372,     0.000000597318900,     0.000000446301682,     0.000000347798146,     0.000000280355699,     0.000000232255140,     0.000000196743462,     0.244761700895474,     0.009334846529948,     0.001067983017147,
     0.000203580862147,     0.000054273118032,     0.000018551990162,     0.000007705835680,     0.000003743363219,     0.000002064285585,     0.000001261173711,     0.000000836667440,     0.000000592873227,     0.000000442837680,
     0.000000345006169,     0.000000278042957,     0.000000230296168,     0.000000195053431,     0.244668405795418,     0.009324176869782,     0.001065949919093,     0.000203039057284,     0.000054087982799,     0.000018475118630,
     0.000007668505053,     0.000003722783283,     0.000002051715583,     0.000001252836607,     0.000000830760792,     0.000000588462054,     0.000000439401482,     0.000000342237222,     0.000000275749720,     0.000000228354022,
     0.000000193378138,     0.244575217290399,     0.009313527513537,     0.001063922229843,     0.000202499099935,     0.000053903614418,     0.000018398619377,     0.000007631379597,     0.000003702328631,     0.000002039228657,
     0.000001244558349,     0.000000824898085,     0.000000584085105,     0.000000435992859,     0.000000339491110,     0.000000273475821,     0.000000226428556,     0.000000191717453,     0.244482135177648,     0.009302898407217,
     0.001061899930961,     0.000201960982451,     0.000053720009177,     0.000018322490358,     0.000007594458065,     0.000003681998435,     0.000002026824221,     0.000001236338500,     0.000000819078977,     0.000000579742105,
     0.000000432611584,     0.000000336767642,     0.000000271221094,     0.000000224519625,     0.000000190071247,     0.244389159254934,     0.009292289497011,     0.001059883004087,     0.000201424697220,     0.000053537163384,
     0.000018246729540,     0.000007557739216,     0.000003661791873,     0.000002014501694,     0.000001228176625,     0.000000813303130,     0.000000575432783,     0.000000429257432,     0.000000334066625,     0.000000268985374,
     0.000000222627083,     0.000000188439393,     0.244296289320566,     0.009281700729290,     0.001057871430935,     0.000200890236664,     0.000053355073366,     0.000018171334902,     0.000007521221818,     0.000003641708130,
     0.000002002260497,     0.000001220072294,     0.000000807570210,     0.000000571156867,     0.000000425930178,     0.000000331387872,     0.000000266768498,     0.000000220750789,     0.000000186821763,     0.244203525173385,
     0.009271132050607,     0.001055865193296,     0.000200357593246,     0.000053173735472,     0.000018096304436,     0.000007484904647,     0.000003621746394,     0.000001990100058,     0.000001212025079,     0.000000801879883,
     0.000000566914090,     0.000000422629601,     0.000000328731193,     0.000000264570304,     0.000000218890601,     0.000000185218232,     0.244110866612768,     0.009260583407699,     0.001053864273038,     0.000199826759460,
     0.000052993146070,     0.000018021636146,     0.000007448786486,     0.000003601905861,     0.000001978019806,     0.000001204034556,     0.000000796231819,     0.000000562704187,     0.000000419355481,     0.000000326096404,
     0.000000262390633,     0.000000217046378,     0.000000183628676,     0.244018313438622,     0.009250054747482,     0.001051868652100,     0.000199297727841,     0.000052813301548,     0.000017947328047,     0.000007412866129,
     0.000003582185732,     0.000001966019179,     0.000001196100303,     0.000000790625690,     0.000000558526893,     0.000000416107600,     0.000000323483319,     0.000000260229324,     0.000000215217981,     0.000000182052971,
     0.243925865451385,     0.009239546017053,     0.001049878312498,     0.000198770490958,     0.000052634198315,     0.000017873378168,     0.000007377142373,     0.000003562585214,     0.000001954097614,     0.000001188221903,
     0.000000785061173,     0.000000554381948,     0.000000412885743,     0.000000320891757,     0.000000258086221,     0.000000213405273,     0.000000180490995,     0.243833522452024,     0.009229057163687,     0.001047893236323,
     0.000198245041416,     0.000052455832797,     0.000017799784548,     0.000007341614028,     0.000003543103518,     0.000001942254556,     0.000001180398942,     0.000000779537944,     0.000000550269092,     0.000000409689694,
     0.000000318321535,     0.000000255961167,     0.000000211608116,     0.000000178942626,     0.243741284242030,     0.009218588134841,     0.001045913405737,     0.000197721371855,     0.000052278201443,     0.000017726545240,
     0.000007306279909,     0.000003523739863,     0.000001930489452,     0.000001172631008,     0.000000774055685,     0.000000546188069,     0.000000406519242,     0.000000315772474,     0.000000253854007,     0.000000209826375,
     0.000000177407746,     0.243649150623420,     0.009208138878146,     0.001043938802977,     0.000197199474952,     0.000052101300718,     0.000017653658307,     0.000007271138840,     0.000003504493471,     0.000001918801754,
     0.000001164917693,     0.000000768614078,     0.000000542138623,     0.000000403374175,     0.000000313244395,     0.000000251764588,     0.000000208059917,     0.000000175886234,     0.243557121398734,     0.009197709341414,
     0.001041969410353,     0.000196679343417,     0.000051925127108,     0.000017581121824,     0.000007236189652,     0.000003485363572,     0.000001907190917,     0.000001157258592,     0.000000763212808,     0.000000538120502,
     0.000000400254284,     0.000000310737123,     0.000000249692758,     0.000000206308607,     0.000000174377973,     0.243465196371032,     0.009187299472631,     0.001040005210248,     0.000196160969997,     0.000051749677120,
     0.000017508933878,     0.000007201431183,     0.000003466349399,     0.000001895656403,     0.000001149653303,     0.000000757851564,     0.000000534133454,     0.000000397159363,     0.000000308250482,     0.000000247638366,
     0.000000204572313,     0.000000172882845,     0.243373375343895,     0.009176909219959,     0.001038046185117,     0.000195644347474,     0.000051574947275,     0.000017437092568,     0.000007166862280,     0.000003447450191,
     0.000001884197673,     0.000001142101428,     0.000000752530036,     0.000000530177232,     0.000000394089206,     0.000000305784298,     0.000000245601262,     0.000000202850906,     0.000000171400736,     0.243281658121418,
     0.009166538531737,     0.001036092317486,     0.000195129468663,     0.000051400934119,     0.000017365596004,     0.000007132481798,     0.000003428665194,     0.000001872814197,     0.000001134602571,     0.000000747247917,
     0.000000526251588,     0.000000391043610,     0.000000303338400,     0.000000243581299,     0.000000201144256,     0.000000169931530,     0.243190044508216,     0.009156187356476,     0.001034143589955,     0.000194616326414,
     0.000051227634212,     0.000017294442308,     0.000007098288598,     0.000003409993658,     0.000001861505446,     0.000001127156339,     0.000000742004903,     0.000000522356278,     0.000000388022371,     0.000000300912616,
     0.000000241578329,     0.000000199452233,     0.000000168475113,     0.243098534309416,     0.009145855642862,     0.001032199985193,     0.000194104913613,     0.000051055044136,     0.000017223629612,     0.000007064281549,
     0.000003391434838,     0.000001850270896,     0.000001119762344,     0.000000736800692,     0.000000518491060,     0.000000385025291,     0.000000298506777,     0.000000239592206,     0.000000197774711,     0.000000167031373,
     0.243007127330657,     0.009135543339754,     0.001030261485942,     0.000193595223177,     0.000050883160490,     0.000017153156060,     0.000007030459528,     0.000003372987995,     0.000001839110027,     0.000001112420197,
     0.000000731634983,     0.000000514655693,     0.000000382052170,     0.000000296120716,     0.000000237622786,     0.000000196111564,     0.000000165600198,     0.242915823378090,     0.009125250396182,     0.001028328075012,
     0.000193087248059,     0.000050711979891,     0.000017083019808,     0.000006996821419,     0.000003354652394,     0.000001828022321,     0.000001105129517,     0.000000726507479,     0.000000510849937,     0.000000379102811,
     0.000000293754266,     0.000000235669927,     0.000000194462666,     0.000000164181477,     0.242824622258372,     0.009114976761349,     0.001026399735286,     0.000192580981247,     0.000050541498975,     0.000017013219022,
     0.000006963366112,     0.000003336427306,     0.000001817007266,     0.000001097889921,     0.000000721417886,     0.000000507073558,     0.000000376177020,     0.000000291407263,     0.000000233733486,     0.000000192827893,
     0.000000162775100,     0.242733523778669,     0.009104722384629,     0.001024476449716,     0.000192076415759,     0.000050371714398,     0.000016943751880,     0.000006930092507,     0.000003318312008,     0.000001806064353,
     0.000001090701033,     0.000000716365911,     0.000000503326319,     0.000000373274602,     0.000000289079542,     0.000000231813323,     0.000000191207123,     0.000000161380959,     0.242642527746653,     0.009094487215565,
     0.001022558201323,     0.000191573544649,     0.000050202622832,     0.000016874616570,     0.000006896999508,     0.000003300305780,     0.000001795193078,     0.000001083562479,     0.000000711351263,     0.000000499607989,
     0.000000370395365,     0.000000286770942,     0.000000229909297,     0.000000189600233,     0.000000159998945,     0.242551633970500,     0.009084271203868,     0.001020644973198,     0.000191072361003,     0.000050034220967,
     0.000016805811292,     0.000006864086030,     0.000003282407909,     0.000001784392937,     0.000001076473885,     0.000000706373655,     0.000000495918335,     0.000000367539120,     0.000000284481303,     0.000000228021272,
     0.000000188007104,     0.000000158628952,     0.242460842258885,     0.009074074299422,     0.001018736748501,     0.000190572857941,     0.000049866505512,     0.000016737334255,     0.000006831350991,     0.000003264617686,
     0.000001773663435,     0.000001069434883,     0.000000701432802,     0.000000492257130,     0.000000364705677,     0.000000282210464,     0.000000226149110,     0.000000186427615,     0.000000157270873,     0.242370152420987,
     0.009063896452276,     0.001016833510460,     0.000190075028616,     0.000049699473193,     0.000016669183681,     0.000006798793320,     0.000003246934407,     0.000001763004076,     0.000001062445107,     0.000000696528419,
     0.000000488624146,     0.000000361894848,     0.000000279958268,     0.000000224292675,     0.000000184861647,     0.000000155924605,     0.242279564266481,     0.009053737612647,     0.001014935242372,     0.000189578866211,
     0.000049533120756,     0.000016601357801,     0.000006766411949,     0.000003229357372,     0.000001752414370,     0.000001055504194,     0.000000691660225,     0.000000485019158,     0.000000359106450,     0.000000277724559,
     0.000000222451832,     0.000000183309084,     0.000000154590042,     0.242189077605541,     0.009043597730918,     0.001013041927602,     0.000189084363945,     0.000049367444961,     0.000016533854858,     0.000006734205820,
     0.000003211885889,     0.000001741893830,     0.000001048611783,     0.000000686827943,     0.000000481441943,     0.000000356340296,     0.000000275509180,     0.000000220626449,     0.000000181769808,     0.000000153267083,
     0.242098692248835,     0.009033476757639,     0.001011153549582,     0.000188591515067,     0.000049202442588,     0.000016466673104,     0.000006702173882,     0.000003194519267,     0.000001731441973,     0.000001041767516,
     0.000000682031295,     0.000000477892279,     0.000000353596205,     0.000000273311978,     0.000000218816392,     0.000000180243704,     0.000000151955623,     0.242008408007524,     0.009023374643525,     0.001009270091812,
     0.000188100312859,     0.000049038110434,     0.000016399810803,     0.000006670315088,     0.000003177256822,     0.000001721058320,     0.000001034971039,     0.000000677270006,     0.000000474369946,     0.000000350873996,
     0.000000271132801,     0.000000217021531,     0.000000178730657,     0.000000150655563,     0.241918224693264,     0.009013291339457,     0.001007391537858,     0.000187610750635,     0.000048874445313,     0.000016333266228,
     0.000006638628400,     0.000003160097875,     0.000001710742395,     0.000001028221999,     0.000000672543805,     0.000000470874727,     0.000000348173490,     0.000000268971498,     0.000000215241736,     0.000000177230555,
     0.000000149366801,     0.241828142118198,     0.009003226796477,     0.001005517871355,     0.000187122821740,     0.000048711444056,     0.000016267037664,     0.000006607112788,     0.000003143041750,     0.000001700493723,
     0.000001021520047,     0.000000667852422,     0.000000467406405,     0.000000345494507,     0.000000266827917,     0.000000213476877,     0.000000175743284,     0.000000148089239,     0.241738160094960,     0.008993180965792,
     0.001003649076001,     0.000186636519552,     0.000048549103512,     0.000016201123406,     0.000006575767225,     0.000003126087778,     0.000001690311838,     0.000001014864836,     0.000000663195588,     0.000000463964765,
     0.000000342836873,     0.000000264701911,     0.000000211726828,     0.000000174268733,     0.000000146822777,     0.241648278436670,     0.008983153798774,     0.001001785135564,     0.000186151837478,     0.000048387420546,
     0.000016135521757,     0.000006544590694,     0.000003109235292,     0.000001680196272,     0.000001008256021,     0.000000658573039,     0.000000460549597,     0.000000340200411,     0.000000262593331,     0.000000209991460,
     0.000000172806792,     0.000000145567319,     0.241558496956934,     0.008973145246952,     0.000999926033873,     0.000185668768959,     0.000048226392040,     0.000016070231032,     0.000006513582183,     0.000003092483633,
     0.000001670146564,     0.000001001693261,     0.000000653984509,     0.000000457160687,     0.000000337584949,     0.000000260502033,     0.000000208270650,     0.000000171357350,     0.000000144322766,     0.241468815469842,
     0.008963155262021,     0.000998071754828,     0.000185187307466,     0.000048066014894,     0.000016005249556,     0.000006482740687,     0.000003075832143,     0.000001660162254,     0.000000995176218,     0.000000649429738,
     0.000000453797828,     0.000000334990313,     0.000000258427870,     0.000000206564272,     0.000000169920300,     0.000000143089024,     0.241379233789965,     0.008953183795833,     0.000996222282389,     0.000184707446500,
     0.000047906286024,     0.000015940575665,     0.000006452065208,     0.000003059280171,     0.000001650242888,     0.000000988704555,     0.000000644908466,     0.000000450460812,     0.000000332416335,     0.000000256370700,
     0.000000204872203,     0.000000168495534,     0.000000141865996,     0.241289751732356,     0.008943230800404,     0.000994377600584,     0.000184229179595,     0.000047747202361,     0.000015876207702,     0.000006421554754,
     0.000003042827070,     0.000001640388013,     0.000000982277938,     0.000000640420436,     0.000000447149433,     0.000000329862843,     0.000000254330379,     0.000000203194321,     0.000000167082945,     0.000000140653589,
     0.241200369112547,     0.008933296227906,     0.000992537693505,     0.000183752500313,     0.000047588760856,     0.000015812144023,     0.000006391208339,     0.000003026472197,     0.000001630597180,     0.000000975896036,
     0.000000635965393,     0.000000443863487,     0.000000327329671,     0.000000252306767,     0.000000201530504,     0.000000165682427,     0.000000139451709,     0.241111085746547,     0.008923380030671,     0.000990702545307,
     0.000183277402247,     0.000047430958472,     0.000015748382992,     0.000006361024985,     0.000003010214914,     0.000001620869945,     0.000000969558521,     0.000000631543082,     0.000000440602773,     0.000000324816653,
     0.000000250299722,     0.000000199880632,     0.000000164293876,     0.000000138260264,     0.241021901450841,     0.008913482161189,     0.000988872140210,     0.000182803879023,     0.000047273792192,     0.000015684922983,
     0.000006331003718,     0.000002994054588,     0.000001611205863,     0.000000963265066,     0.000000627153254,     0.000000437367088,     0.000000322323622,     0.000000248309108,     0.000000198244587,     0.000000162917187,
     0.000000137079162,     0.240932816042388,     0.008903602572109,     0.000987046462498,     0.000182331924293,     0.000047117259014,     0.000015621762380,     0.000006301143572,     0.000002977990588,     0.000001601604497,
     0.000000957015349,     0.000000622795658,     0.000000434156234,     0.000000319850416,     0.000000246334785,     0.000000196622250,     0.000000161552258,     0.000000135908311,     0.240843829338621,     0.008893741216234,
     0.000985225496517,     0.000181861531742,     0.000046961355952,     0.000015558899577,     0.000006271443587,     0.000002962022290,     0.000001592065411,     0.000000950809047,     0.000000618470047,     0.000000430970014,
     0.000000317396873,     0.000000244376617,     0.000000195013503,     0.000000160198987,     0.000000134747622,     0.240754941157443,     0.008883898046525,     0.000983409226677,     0.000181392695084,     0.000046806080035,
     0.000015496332978,     0.000006241902809,     0.000002946149074,     0.000001582588173,     0.000000944645842,     0.000000614176176,     0.000000427808232,     0.000000314962830,     0.000000242434470,     0.000000193418231,
     0.000000158857272,     0.000000133597005,     0.240666151317227,     0.008874073016098,     0.000981597637450,     0.000180925408061,     0.000046651428310,     0.000015434060994,     0.000006212520291,     0.000002930370322,
     0.000001573172352,     0.000000938525418,     0.000000609913802,     0.000000424670693,     0.000000312548130,     0.000000240508208,     0.000000191836319,     0.000000157527014,     0.000000132456371,     0.240577459636813,
     0.008864266078225,     0.000979790713371,     0.000180459664446,     0.000046497397839,     0.000015372082048,     0.000006183295090,     0.000002914685423,     0.000001563817523,     0.000000932447462,     0.000000605682682,
     0.000000421557205,     0.000000310152614,     0.000000238597699,     0.000000190267653,     0.000000156208112,     0.000000131325634,     0.240488865935509,     0.008854477186332,     0.000977988439037,     0.000179995458043,
     0.000046343985698,     0.000015310394571,     0.000006154226272,     0.000002899093770,     0.000001554523262,     0.000000926411661,     0.000000601482578,     0.000000418467577,     0.000000307776124,     0.000000236702811,
     0.000000188712120,     0.000000154900469,     0.000000130204705,     0.240400370033088,     0.008844706293996,     0.000976190799107,     0.000179532782681,     0.000046191188981,     0.000015248997004,     0.000006125312906,
     0.000002883594758,     0.000001545289150,     0.000000920417708,     0.000000597313252,     0.000000415401620,     0.000000305418506,     0.000000234823414,     0.000000187169607,     0.000000153603986,     0.000000129093499,
     0.240311971749785,     0.008834953354952,     0.000974397778301,     0.000179071632221,     0.000046039004797,     0.000015187887797,     0.000006096554070,     0.000002868187788,     0.000001536114770,     0.000000914465294,
     0.000000593174467,     0.000000412359145,     0.000000303079605,     0.000000232959376,     0.000000185640003,     0.000000152318566,     0.000000127991929,     0.240223670906298,     0.008825218323084,     0.000972609361400,
     0.000178612000553,     0.000045887430269,     0.000015127065410,     0.000006067948845,     0.000002852872265,     0.000001526999707,     0.000000908554117,     0.000000589065991,     0.000000409339966,     0.000000300759268,
     0.000000231110571,     0.000000184123199,     0.000000151044115,     0.000000126899913,     0.240135467323786,     0.008815501152429,     0.000970825533247,     0.000178153881593,     0.000045736462538,     0.000015066528312,
     0.000006039496321,     0.000002837647597,     0.000001517943551,     0.000000902683874,     0.000000584987591,     0.000000406343898,     0.000000298457343,     0.000000229276870,     0.000000182619084,     0.000000149780537,
     0.000000125817364,     0.240047360823865,     0.008805801797174,     0.000969046278746,     0.000177697269289,     0.000045586098757,     0.000015006274978,     0.000006011195592,     0.000002822513199,     0.000001508945894,
     0.000000896854266,     0.000000580939037,     0.000000403370758,     0.000000296173680,     0.000000227458147,     0.000000181127552,     0.000000148527737,     0.000000124744201,     0.239959351228610,     0.008796120211658,
     0.000967271582859,     0.000177242157615,     0.000045436336097,     0.000014946303897,     0.000005983045758,     0.000002807468486,     0.000001500006331,     0.000000891064995,     0.000000576920100,     0.000000400420364,
     0.000000293908130,     0.000000225654277,     0.000000179648494,     0.000000147285622,     0.000000123680341,     0.239871438360551,     0.008786456350371,     0.000965501430611,     0.000176788540573,     0.000045287171743,
     0.000014886613563,     0.000005955045926,     0.000002792512880,     0.000001491124461,     0.000000885315766,     0.000000572930554,     0.000000397492535,     0.000000291660546,     0.000000223865136,     0.000000178181804,
     0.000000146054099,     0.000000122625701,     0.239783622042673,     0.008776810167950,     0.000963735807086,     0.000176336412195,     0.000045138602895,     0.000014827202481,     0.000005927195206,     0.000002777645805,
     0.000001482299883,     0.000000879606286,     0.000000568970175,     0.000000394587094,     0.000000289430779,     0.000000222090600,     0.000000176727377,     0.000000144833077,     0.000000121580202,     0.239695902098413,
     0.008767181619183,     0.000961974697425,     0.000175885766539,     0.000044990626768,     0.000014768069165,     0.000005899492716,     0.000002762866692,     0.000001473532203,     0.000000873936266,     0.000000565038738,
     0.000000391703861,     0.000000287218685,     0.000000220330548,     0.000000175285108,     0.000000143622465,     0.000000120543762,     0.239608278351660,     0.008757570659005,     0.000960218086832,     0.000175436597693,
     0.000044843240591,     0.000014709212136,     0.000005871937581,     0.000002748174973,     0.000001464821027,     0.000000868305416,     0.000000561136024,     0.000000388842661,     0.000000285024120,     0.000000218584858,
     0.000000173854893,     0.000000142422172,     0.000000119516303,     0.239520750626754,     0.008747977242499,     0.000958465960568,     0.000174988899770,     0.000044696441609,     0.000014650629925,     0.000005844528927,
     0.000002733570085,     0.000001456165965,     0.000000862713450,     0.000000557261812,     0.000000386003321,     0.000000282846941,     0.000000216853410,     0.000000172436630,     0.000000141232109,     0.000000118497744,
     0.239433318748481,     0.008738401324895,     0.000956718303953,     0.000174542666912,     0.000044550227081,     0.000014592321072,     0.000005817265891,     0.000002719051468,     0.000001447566630,     0.000000857160085,
     0.000000553415885,     0.000000383185665,     0.000000280687005,     0.000000215136086,     0.000000171030217,     0.000000140052188,     0.000000117488009,     0.239345982542075,     0.008728842861570,     0.000954975102366,
     0.000174097893289,     0.000044404594281,     0.000014534284124,     0.000005790147612,     0.000002704618568,     0.000001439022636,     0.000000851645039,     0.000000549598027,     0.000000380389523,     0.000000278544172,
     0.000000213432767,     0.000000169635553,     0.000000138882320,     0.000000116487019,     0.239258741833217,     0.008719301808046,     0.000953236341243,     0.000173654573097,     0.000044259540497,     0.000014476517640,
     0.000005763173236,     0.000002690270832,     0.000001430533602,     0.000000846168032,     0.000000545808024,     0.000000377614725,     0.000000276418303,     0.000000211743336,     0.000000168252538,     0.000000137722418,
     0.000000115494699,     0.239171596448029,     0.008709778119992,     0.000951502006078,     0.000173212700558,     0.000044115063032,     0.000014419020183,     0.000005736341914,     0.000002676007714,     0.000001422099149,
     0.000000840728787,     0.000000542045662,     0.000000374861101,     0.000000274309260,     0.000000210067678,     0.000000166881072,     0.000000136572397,     0.000000114510970,     0.239084546213079,     0.008700271753219,
     0.000949772082425,     0.000172772269924,     0.000043971159201,     0.000014361790327,     0.000005709652802,     0.000002661828668,     0.000001413718901,     0.000000835327027,     0.000000538310732,     0.000000372128484,
     0.000000272216904,     0.000000208405677,     0.000000165521057,     0.000000135432171,     0.000000113535760,     0.238997590955374,     0.008690782663686,     0.000948046555893,     0.000172333275471,     0.000043827826338,
     0.000014304826656,     0.000005683105062,     0.000002647733156,     0.000001405392485,     0.000000829962481,     0.000000534603023,     0.000000369416708,     0.000000270141101,     0.000000206757219,     0.000000164172396,
     0.000000134301654,     0.000000112568991,     0.238910730502361,     0.008681310807492,     0.000946325412147,     0.000171895711503,     0.000043685061786,     0.000014248127758,     0.000005656697862,     0.000002633720640,
     0.000001397119529,     0.000000824634877,     0.000000530922329,     0.000000366725608,     0.000000268081715,     0.000000205122191,     0.000000162834992,     0.000000133180763,     0.000000111610591,     0.238823964681926,
     0.008671856140881,     0.000944608636913,     0.000171459572350,     0.000043542862905,     0.000014191692233,     0.000005630430374,     0.000002619790589,     0.000001388899665,     0.000000819343945,     0.000000527268442,
     0.000000364055020,     0.000000266038613,     0.000000203500482,     0.000000161508749,     0.000000132069414,     0.000000110660486,     0.238737293322390,     0.008662418620240,     0.000942896215970,     0.000171024852368,
     0.000043401227068,     0.000014135518687,     0.000005604301777,     0.000002605942471,     0.000001380732528,     0.000000814089419,     0.000000523641160,     0.000000361404782,     0.000000264011661,     0.000000201891979,
     0.000000160193572,     0.000000130967526,     0.000000109718603,     0.238650716252513,     0.008652998202095,     0.000941188135154,     0.000170591545940,     0.000043260151662,     0.000014079605737,     0.000005578311253,
     0.000002592175763,     0.000001372617756,     0.000000808871034,     0.000000520040280,     0.000000358774733,     0.000000262000729,     0.000000200296574,     0.000000158889367,     0.000000129875015,     0.000000108784871,
     0.238564233301485,     0.008643594843116,     0.000939484380358,     0.000170159647475,     0.000043119634089,     0.000014023952005,     0.000005552457992,     0.000002578489943,     0.000001364554988,     0.000000803688526,
     0.000000516465599,     0.000000356164714,     0.000000260005687,     0.000000198714156,     0.000000157596041,     0.000000128791801,     0.000000107859216,     0.238477844298931,     0.008634208500114,     0.000937784937530,
     0.000169729151408,     0.000042979671763,     0.000013968556122,     0.000005526741187,     0.000002564884492,     0.000001356543867,     0.000000798541635,     0.000000512916919,     0.000000353574567,     0.000000258026403,
     0.000000197144617,     0.000000156313501,     0.000000127717804,     0.000000106941570,     0.238391549074906,     0.008624839130039,     0.000936089792674,     0.000169300052198,     0.000042840262112,     0.000013913416729,
     0.000005501160036,     0.000002551358895,     0.000001348584038,     0.000000793430102,     0.000000509394042,     0.000000351004134,     0.000000256062752,     0.000000195587850,     0.000000155041654,     0.000000126652943,
     0.000000106031861,     0.238305347459896,     0.008615486689981,     0.000934398931848,     0.000168872344332,     0.000042701402578,     0.000013858532472,     0.000005475713744,     0.000002537912641,     0.000001340675148,
     0.000000788353669,     0.000000505896771,     0.000000348453260,     0.000000254114604,     0.000000194043748,     0.000000153780412,     0.000000125597141,     0.000000105130019,     0.238219239284815,     0.008606151137169,
     0.000932712341167,     0.000168446022321,     0.000042563090616,     0.000013803902007,     0.000005450401520,     0.000002524545223,     0.000001332816848,     0.000000783312082,     0.000000502424912,     0.000000345921790,
     0.000000252181835,     0.000000192512207,     0.000000152529682,     0.000000124550317,     0.000000104235977,     0.238133224381004,     0.008596832428970,     0.000931030006800,     0.000168021080703,     0.000042425323696,
     0.000013749523997,     0.000005425222579,     0.000002511256137,     0.000001325008791,     0.000000778305087,     0.000000498978271,     0.000000343409572,     0.000000250264319,     0.000000190993120,     0.000000151289375,
     0.000000123512395,     0.000000103349665,     0.238047302580229,     0.008587530522891,     0.000929351914970,     0.000167597514039,     0.000042288099299,     0.000013695397114,     0.000005400176138,     0.000002498044881,
     0.000001317250632,     0.000000773332433,     0.000000495556657,     0.000000340916454,     0.000000248361931,     0.000000189486385,     0.000000150059404,     0.000000122483298,     0.000000102471015,     0.237961473714681,
     0.008578245376574,     0.000927678051954,     0.000167175316917,     0.000042151414921,     0.000013641520035,     0.000005375261423,     0.000002484910959,     0.000001309542029,     0.000000768393871,     0.000000492159879,
     0.000000338442284,     0.000000246474550,     0.000000187991898,     0.000000148839680,     0.000000121462950,     0.000000101599962,     0.237875737616973,     0.008568976947801,     0.000926008404085,     0.000166754483949,
     0.000042015268070,     0.000013587891449,     0.000005350477663,     0.000002471853876,     0.000001301882642,     0.000000763489153,     0.000000488787749,     0.000000335986913,     0.000000244602053,     0.000000186509557,
     0.000000147630116,     0.000000120451274,     0.000000100736437,     0.237790094120140,     0.008559725194488,     0.000924342957746,     0.000166335009772,     0.000041879656268,     0.000013534510048,     0.000005325824091,
     0.000002458873143,     0.000001294272134,     0.000000758618034,     0.000000485440078,     0.000000333550193,     0.000000242744319,     0.000000185039262,     0.000000146430626,     0.000000119448196,     0.000000099880375,
     0.237704543057638,     0.008550490074686,     0.000922681699378,     0.000165916889048,     0.000041744577050,     0.000013481374536,     0.000005301299947,     0.000002445968272,     0.000001286710170,     0.000000753780271,
     0.000000482116683,     0.000000331131978,     0.000000240901228,     0.000000183580911,     0.000000145241124,     0.000000118453642,     0.000000099031710,     0.237619084263340,     0.008541271546585,     0.000921024615471,
     0.000165500116464,     0.000041610027962,     0.000013428483620,     0.000005276904475,     0.000002433138779,     0.000001279196418,     0.000000748975620,     0.000000478817378,     0.000000328732120,     0.000000239072661,
     0.000000182134406,     0.000000144061525,     0.000000117467537,     0.000000098190378,     0.237533717571539,     0.008532069568507,     0.000919371692572,     0.000165084686730,     0.000041476006566,     0.000013375836020,
     0.000005252636922,     0.000002420384184,     0.000001271730548,     0.000000744203844,     0.000000475541980,     0.000000326350477,     0.000000237258501,     0.000000180699648,     0.000000142891745,     0.000000116489810,
     0.000000097356315,     0.237448442816942,     0.008522884098908,     0.000917722917278,     0.000164670594581,     0.000041342510435,     0.000013323430458,     0.000005228496543,     0.000002407704009,     0.000001264312232,
     0.000000739464702,     0.000000472290308,     0.000000323986903,     0.000000235458629,     0.000000179276539,     0.000000141731701,     0.000000115520387,     0.000000096529456,     0.237363259834671,     0.008513715096380,
     0.000916078276240,     0.000164257834778,     0.000041209537154,     0.000013271265667,     0.000005204482595,     0.000002395097782,     0.000001256941146,     0.000000734757959,     0.000000469062182,     0.000000321641257,
     0.000000233672931,     0.000000177864982,     0.000000140581310,     0.000000114559197,     0.000000095709739,     0.237278168460262,     0.008504562519647,     0.000914437756159,     0.000163846402103,     0.000041077084323,
     0.000013219340387,     0.000005180594342,     0.000002382565030,     0.000001249616966,     0.000000730083380,     0.000000465857424,     0.000000319313397,     0.000000231901291,     0.000000176464881,     0.000000139440490,
     0.000000113606169,     0.000000094897101,     0.237193168529662,     0.008495426327565,     0.000912801343791,     0.000163436291365,     0.000040945149552,     0.000013167653364,     0.000005156831051,     0.000002370105287,
     0.000001242339372,     0.000000725440733,     0.000000462675855,     0.000000317003184,     0.000000230143596,     0.000000175076141,     0.000000138309160,     0.000000112661232,     0.000000094091480,     0.237108259879232,
     0.008486306479123,     0.000911169025942,     0.000163027497393,     0.000040813730466,     0.000013116203352,     0.000005133191995,     0.000002357718089,     0.000001235108045,     0.000000720829786,     0.000000459517301,
     0.000000314710479,     0.000000228399731,     0.000000173698666,     0.000000137187239,     0.000000111724316,     0.000000093292815,     0.237023442345737,     0.008477202933441,     0.000909540789471,     0.000162620015044,
     0.000040682824699,     0.000013064989112,     0.000005109676449,     0.000002345402973,     0.000001227922671,     0.000000716250311,     0.000000456381588,     0.000000312435144,     0.000000226669585,     0.000000172332365,
     0.000000136074647,     0.000000110795352,     0.000000092501045,     0.236938715766356,     0.008468115649772,     0.000907916621286,     0.000162213839196,     0.000040552429902,     0.000013014009414,     0.000005086283697,
     0.000002333159483,     0.000001220782935,     0.000000711702079,     0.000000453268541,     0.000000310177042,     0.000000224953047,     0.000000170977143,     0.000000134971306,     0.000000109874272,     0.000000091716109,
     0.236854079978671,     0.008459044587498,     0.000906296508349,     0.000161808964751,     0.000040422543733,     0.000012963263032,     0.000005063013022,     0.000002320987163,     0.000001213688526,     0.000000707184865,
     0.000000450177990,     0.000000307936038,     0.000000223250006,     0.000000169632908,     0.000000133877136,     0.000000108961008,     0.000000090937947,     0.236769534820670,     0.008449989706131,     0.000904680437670,
     0.000161405386634,     0.000040293163867,     0.000012912748749,     0.000005039863718,     0.000002308885562,     0.000001206639135,     0.000000702698445,     0.000000447109764,     0.000000305711998,     0.000000221560352,
     0.000000168299570,     0.000000132792060,     0.000000108055491,     0.000000090166501,     0.236685080130746,     0.008440950965314,     0.000903068396312,     0.000161003099794,     0.000040164287989,     0.000012862465355,
     0.000005016835077,     0.000002296854232,     0.000001199634455,     0.000000698242596,     0.000000444063694,     0.000000303504787,     0.000000219883978,     0.000000166977037,     0.000000131716000,     0.000000107157655,
     0.000000089401711,     0.236600715747696,     0.008431928324817,     0.000901460371387,     0.000160602099202,     0.000040035913795,     0.000012812411647,     0.000004993926400,     0.000002284892725,     0.000001192674182,
     0.000000693817098,     0.000000441039612,     0.000000301314274,     0.000000218220776,     0.000000165665220,     0.000000130648881,     0.000000106267435,     0.000000088643519,     0.236516441510716,     0.008422921744541,
     0.000899856350057,     0.000160202379853,     0.000039908038994,     0.000012762586429,     0.000004971136991,     0.000002273000601,     0.000001185758013,     0.000000689421731,     0.000000438037353,     0.000000299140328,
     0.000000216570638,     0.000000164364030,     0.000000129590626,     0.000000105384763,     0.000000087891868,     0.236432257259404,     0.008413931184513,     0.000898256319536,     0.000159803936765,     0.000039780661309,
     0.000012712988512,     0.000004948466158,     0.000002261177419,     0.000001178885648,     0.000000685056278,     0.000000435056751,     0.000000296982818,     0.000000214933460,     0.000000163073378,     0.000000128541161,
     0.000000104509576,     0.000000087146700,     0.236348162833757,     0.008404956604890,     0.000896660267084,     0.000159406764977,     0.000039653778470,     0.000012663616713,     0.000004925913214,     0.000002249422743,
     0.000001172056788,     0.000000680720524,     0.000000432097642,     0.000000294841616,     0.000000213309136,     0.000000161793177,     0.000000127500410,     0.000000103641808,     0.000000086407958,     0.236264158074171,
     0.008395997965954,     0.000895068180015,     0.000159010859554,     0.000039527388224,     0.000012614469857,     0.000004903477477,     0.000002237736139,     0.000001165271139,     0.000000676414255,     0.000000429159865,
     0.000000292716593,     0.000000211697562,     0.000000160523341,     0.000000126468300,     0.000000102781395,     0.000000085675587,     0.236180242821435,     0.008387055228114,     0.000893480045688,     0.000158616215578,
     0.000039401488327,     0.000012565546775,     0.000004881158266,     0.000002226117177,     0.000001158528406,     0.000000672137257,     0.000000426243257,     0.000000290607622,     0.000000210098635,     0.000000159263783,
     0.000000125444758,     0.000000101928275,     0.000000084949530,     0.236096416916736,     0.008378128351906,     0.000891895851515,     0.000158222828160,     0.000039276076547,     0.000012516846306,     0.000004858954909,
     0.000002214565429,     0.000001151828297,     0.000000667889319,     0.000000423347659,     0.000000288514578,     0.000000208512252,     0.000000158014417,     0.000000124429711,     0.000000101082384,     0.000000084229733,
     0.236012680201656,     0.008369217297991,     0.000890315584953,     0.000157830692428,     0.000039151150663,     0.000012468367293,     0.000004836866735,     0.000002203080470,     0.000001145170523,     0.000000663670234,
     0.000000420472913,     0.000000286437336,     0.000000206938313,     0.000000156775160,     0.000000123423086,     0.000000100243660,     0.000000083516140,     0.235929032518166,     0.008360322027156,     0.000888739233510,
     0.000157439803534,     0.000039026708467,     0.000012420108589,     0.000004814893078,     0.000002191661878,     0.000001138554797,     0.000000659479792,     0.000000417618860,     0.000000284375771,     0.000000205376716,
     0.000000155545928,     0.000000122424814,     0.000000099412041,     0.000000082808698,     0.235845473708633,     0.008351442500312,     0.000887166784742,     0.000157050156654,     0.000038902747761,     0.000012372069052,
     0.000004793033278,     0.000002180309235,     0.000001131980832,     0.000000655317788,     0.000000414785346,     0.000000282329761,     0.000000203827361,     0.000000154326637,     0.000000121434822,     0.000000098587465,
     0.000000082107352,     0.235762003615810,     0.008342578678494,     0.000885598226253,     0.000156661746981,     0.000038779266359,     0.000012324247546,     0.000004771286675,     0.000002169022123,     0.000001125448347,
     0.000000651184017,     0.000000411972214,     0.000000280299183,     0.000000202290150,     0.000000153117204,     0.000000120453041,     0.000000097769873,     0.000000081412049,     0.235678622082842,     0.008333730522861,
     0.000884033545695,     0.000156274569736,     0.000038656262087,     0.000012276642943,     0.000004749652618,     0.000002157800131,     0.000001118957059,     0.000000647078276,     0.000000409179311,     0.000000278283918,
     0.000000200764985,     0.000000151917549,     0.000000119479401,     0.000000096959204,     0.000000080722737,     0.235595328953261,     0.008324897994695,     0.000882472730766,     0.000155888620157,     0.000038533732781,
     0.000012229254121,     0.000004728130457,     0.000002146642846,     0.000001112506689,     0.000000643000364,     0.000000406406485,     0.000000276283844,     0.000000199251767,     0.000000150727589,     0.000000118513834,
     0.000000096155399,     0.000000080039363,     0.235512124070985,     0.008316081055401,     0.000880915769215,     0.000155503893504,     0.000038411676289,     0.000012182079963,     0.000004706719547,     0.000002135549861,
     0.000001106096959,     0.000000638950080,     0.000000403653584,     0.000000274298843,     0.000000197750401,     0.000000149547245,     0.000000117556271,     0.000000095358398,     0.000000079361875,     0.235429007280318,
     0.008307279666507,     0.000879362648835,     0.000155120385062,     0.000038290090470,     0.000012135119361,     0.000004685419247,     0.000002124520772,     0.000001099727596,     0.000000634927227,     0.000000400920458,
     0.000000272328797,     0.000000196260790,     0.000000148376437,     0.000000116606644,     0.000000094568142,     0.000000078690221,     0.235345978425948,     0.008298493789661,     0.000877813357469,     0.000154738090133,
     0.000038168973193,     0.000012088371212,     0.000004664228920,     0.000002113555176,     0.000001093398324,     0.000000630931606,     0.000000398206958,     0.000000270373588,     0.000000194782840,     0.000000147215086,
     0.000000115664886,     0.000000093784574,     0.000000078024352,     0.235263037352946,     0.008289723386634,     0.000876267883003,     0.000154357004043,     0.000038048322341,     0.000012041834419,     0.000004643147933,
     0.000002102652673,     0.000001087108873,     0.000000626963022,     0.000000395512937,     0.000000268433101,     0.000000193316457,     0.000000146063114,     0.000000114730930,     0.000000093007636,     0.000000077364216,
     0.235180183906763,     0.008280968419318,     0.000874726213374,     0.000153977122139,     0.000037928135804,     0.000011995507891,     0.000004622175657,     0.000002091812867,     0.000001080858974,     0.000000623021283,
     0.000000392838248,     0.000000266507221,     0.000000191861547,     0.000000144920442,     0.000000113804711,     0.000000092237271,     0.000000076709762,     0.235097417933234,     0.008272228849724,     0.000873188336562,
     0.000153598439786,     0.000037808411486,     0.000011949390545,     0.000004601311468,     0.000002081035363,     0.000001074648359,     0.000000619106194,     0.000000390182744,     0.000000264595832,     0.000000190418018,
     0.000000143786994,     0.000000112886163,     0.000000091473422,     0.000000076060943,     0.235014739278569,     0.008263504639984,     0.000871654240595,     0.000153220952375,     0.000037689147299,     0.000011903481303,
     0.000004580554744,     0.000002070319769,     0.000001068476762,     0.000000615217564,     0.000000387546283,     0.000000262698823,     0.000000188985777,     0.000000142662693,     0.000000111975221,     0.000000090716033,
     0.000000075417707,     0.234932147789360,     0.008254795752349,     0.000870123913547,     0.000152844655314,     0.000037570341170,     0.000011857779094,     0.000004559904867,     0.000002059665698,     0.000001062343920,
     0.000000611355205,     0.000000384928720,     0.000000260816079,     0.000000187564734,     0.000000141547464,     0.000000111071821,     0.000000089965049,     0.000000074780008,     0.234849643312574,     0.008246102149189,
     0.000868597343536,     0.000152469544032,     0.000037451991031,     0.000011812282852,     0.000004539361226,     0.000002049072763,     0.000001056249571,     0.000000607518927,     0.000000382329914,     0.000000258947491,
     0.000000186154798,     0.000000140441232,     0.000000110175899,     0.000000089220415,     0.000000074147795,     0.234767225695554,     0.008237423792994,     0.000867074518729,     0.000152095613980,     0.000037334094830,
     0.000011766991517,     0.000004518923210,     0.000002038540579,     0.000001050193455,     0.000000603708545,     0.000000379749724,     0.000000257092947,     0.000000184755879,     0.000000139343922,     0.000000109287392,
     0.000000088482075,     0.000000073521021,     0.234684894786016,     0.008228760646370,     0.000865555427334,     0.000151722860629,     0.000037216650521,     0.000011721904038,     0.000004498590213,     0.000002028068767,
     0.000001044175314,     0.000000599923871,     0.000000377188009,     0.000000255252337,     0.000000183367890,     0.000000138255459,     0.000000108406237,     0.000000087749976,     0.000000072899640,     0.234602650432052,
     0.008220112672042,     0.000864040057609,     0.000151351279470,     0.000037099656073,     0.000011677019365,     0.000004478361634,     0.000002017656947,     0.000001038194893,     0.000000596164723,     0.000000374644631,
     0.000000253425553,     0.000000181990741,     0.000000137175772,     0.000000107532372,     0.000000087024065,     0.000000072283603,     0.234520492482124,     0.008211479832851,     0.000862528397853,     0.000150980866015,
     0.000036983109461,     0.000011632336459,     0.000004458236875,     0.000002007304744,     0.000001032251935,     0.000000592430918,     0.000000372119452,     0.000000251612486,     0.000000180624345,     0.000000136104788,
     0.000000106665735,     0.000000086304287,     0.000000071672864,     0.234438420785068,     0.008202862091757,     0.000861020436411,     0.000150611615795,     0.000036867008674,     0.000011587854284,     0.000004438215342,
     0.000001997011784,     0.000001026346190,     0.000000588722274,     0.000000369612336,     0.000000249813030,     0.000000179268616,     0.000000135042434,     0.000000105806266,     0.000000085590590,     0.000000071067377,
     0.234356435190086,     0.008194259411834,     0.000859516161674,     0.000150243524362,     0.000036751351710,     0.000011543571810,     0.000004418296443,     0.000001986777697,     0.000001020477407,     0.000000585038611,
     0.000000367123147,     0.000000248027079,     0.000000177923468,     0.000000133988639,     0.000000104953903,     0.000000084882922,     0.000000070467096,     0.234274535546750,     0.008185671756273,     0.000858015562076,
     0.000149876587288,     0.000036636136576,     0.000011499488015,     0.000004398479593,     0.000001976602114,     0.000001014645335,     0.000000581379752,     0.000000364651750,     0.000000246254526,     0.000000176588815,
     0.000000132943332,     0.000000104108587,     0.000000084181231,     0.000000069871976,     0.234192721705001,     0.008177099088381,     0.000856518626095,     0.000149510800164,     0.000036521361291,     0.000011455601880,
     0.000004378764207,     0.000001966484669,     0.000001008849730,     0.000000577745518,     0.000000362198012,     0.000000244495268,     0.000000175264573,     0.000000131906444,     0.000000103270259,     0.000000083485465,
     0.000000069281971,     0.234110993515145,     0.008168541371578,     0.000855025342254,     0.000149146158602,     0.000036407023883,     0.000011411912394,     0.000004359149707,     0.000001956424999,     0.000001003090344,
     0.000000574135733,     0.000000359761800,     0.000000242749200,     0.000000173950658,     0.000000130877904,     0.000000102438858,     0.000000082795574,     0.000000068697037,     0.234029350827854,     0.008159998569400,
     0.000853535699119,     0.000148782658233,     0.000036293122391,     0.000011368418551,     0.000004339635516,     0.000001946422742,     0.000000997366934,     0.000000570550224,     0.000000357342984,     0.000000241016220,
     0.000000172646988,     0.000000129857644,     0.000000101614328,     0.000000082111508,     0.000000068117129,     0.233947793494163,     0.008151470645498,     0.000852049685300,     0.000148420294708,     0.000036179654863,
     0.000011325119351,     0.000004320221062,     0.000001936477541,     0.000000991679259,     0.000000566988816,     0.000000354941433,     0.000000239296227,     0.000000171353478,     0.000000128845595,     0.000000100796609,
     0.000000081433215,     0.000000067542205,     0.233866321365471,     0.008142957563634,     0.000850567289450,     0.000148059063696,     0.000036066619358,     0.000011282013800,     0.000004300905776,     0.000001926589039,
     0.000000986027078,     0.000000563451338,     0.000000352557017,     0.000000237589117,     0.000000170070049,     0.000000127841689,     0.000000099985644,     0.000000080760647,     0.000000066972220,     0.233784934293537,
     0.008134459287686,     0.000849088500265,     0.000147698960887,     0.000035954013945,     0.000011239100907,     0.000004281689093,     0.000001916756882,     0.000000980410153,     0.000000559937619,     0.000000350189608,
     0.000000235894792,     0.000000168796618,     0.000000126845860,     0.000000099181377,     0.000000080093754,     0.000000066407131,     0.233703632130484,     0.008125975781644,     0.000847613306486,     0.000147339981990,
     0.000035841836701,     0.000011196379691,     0.000004262570452,     0.000001906980719,     0.000000974828247,     0.000000556447489,     0.000000347839078,     0.000000234213152,     0.000000167533105,     0.000000125858039,
     0.000000098383750,     0.000000079432488,     0.000000065846896,     0.233622414728791,     0.008117507009609,     0.000846141696893,     0.000146982122732,     0.000035730085715,     0.000011153849173,     0.000004243549294,
     0.000001897260201,     0.000000969281125,     0.000000552980781,     0.000000345505303,     0.000000232544097,     0.000000166279430,     0.000000124878163,     0.000000097592709,     0.000000078776800,     0.000000065291472,
     0.233541281941298,     0.008109052935796,     0.000844673660313,     0.000146625378861,     0.000035618759085,     0.000011111508382,     0.000004224625064,     0.000001887594981,     0.000000963768554,     0.000000549537328,
     0.000000343188155,     0.000000230887531,     0.000000165035515,     0.000000123906164,     0.000000096808196,     0.000000078126643,     0.000000064740818,     0.233460233621200,     0.008100613524530,     0.000843209185612,
     0.000146269746142,     0.000035507854919,     0.000011069356351,     0.000004205797211,     0.000001877984715,     0.000000958290301,     0.000000546116963,     0.000000340887511,     0.000000229243355,     0.000000163801281,
     0.000000122941977,     0.000000096030158,     0.000000077481968,     0.000000064194892,     0.233379269622051,     0.008092188740248,     0.000841748261701,     0.000145915220361,     0.000035397371332,     0.000011027392118,
     0.000004187065187,     0.000001868429062,     0.000000952846138,     0.000000542719523,     0.000000338603247,     0.000000227611473,     0.000000162576650,     0.000000121985539,     0.000000095258539,     0.000000076842729,
     0.000000063653652,     0.233298389797757,     0.008083778547497,     0.000840290877529,     0.000145561797320,     0.000035287306453,     0.000010985614729,     0.000004168428449,     0.000001858927680,     0.000000947435835,
     0.000000539344844,     0.000000336335241,     0.000000225991790,     0.000000161361545,     0.000000121036785,     0.000000094493285,     0.000000076208880,     0.000000063117057,     0.233217594002580,     0.008075382910935,
     0.000838837022092,     0.000145209472842,     0.000035177658418,     0.000010944023233,     0.000004149886454,     0.000001849480233,     0.000000942059166,     0.000000535992765,     0.000000334083371,     0.000000224384211,
     0.000000160155889,     0.000000120095652,     0.000000093734343,     0.000000075580373,     0.000000062585069,     0.233136882091135,     0.008067001795329,     0.000837386684424,     0.000144858242768,     0.000035068425372,
     0.000010902616686,     0.000004131438665,     0.000001840086385,     0.000000936715905,     0.000000532663123,     0.000000331847516,     0.000000222788641,     0.000000158959606,     0.000000119162077,     0.000000092981660,
     0.000000074957163,     0.000000062057645,     0.233056253918387,     0.008058635165557,     0.000835939853603,     0.000144508102958,     0.000034959605471,     0.000010861394148,     0.000004113084549,     0.000001830745804,
     0.000000931405829,     0.000000529355761,     0.000000329627558,     0.000000221204988,     0.000000157772622,     0.000000118235998,     0.000000092235182,     0.000000074339205,     0.000000061534747,     0.232975709339654,
     0.008050282986604,     0.000834496518745,     0.000144159049288,     0.000034851196879,     0.000010820354685,     0.000004094823573,     0.000001821458159,     0.000000926128716,     0.000000526070520,     0.000000327423377,
     0.000000219633158,     0.000000156594862,     0.000000117317353,     0.000000091494858,     0.000000073726453,     0.000000061016334,     0.232895248210602,     0.008041945223565,     0.000833056669010,     0.000143811077655,
     0.000034743197770,     0.000010779497368,     0.000004076655210,     0.000001812223121,     0.000000920884346,     0.000000522807241,     0.000000325234856,     0.000000218073060,     0.000000155426251,     0.000000116406081,
     0.000000090760636,     0.000000073118863,     0.000000060502369,     0.232814870387246,     0.008033621841643,     0.000831620293599,     0.000143464183974,     0.000034635606328,     0.000010738821274,     0.000004058578936,
     0.000001803040363,     0.000000915672499,     0.000000519565771,     0.000000323061877,     0.000000216524603,     0.000000154266716,     0.000000115502120,     0.000000090032464,     0.000000072516391,     0.000000059992812,
     0.232734575725948,     0.008025312806148,     0.000830187381751,     0.000143118364176,     0.000034528420744,     0.000010698325484,     0.000004040594230,     0.000001793909563,     0.000000910492958,     0.000000516345952,
     0.000000320904325,     0.000000214987696,     0.000000153116184,     0.000000114605412,     0.000000089310291,     0.000000071918993,     0.000000059487624,     0.232654364083417,     0.008017018082498,     0.000828757922749,
     0.000142773614212,     0.000034421639220,     0.000010658009085,     0.000004022700573,     0.000001784830397,     0.000000905345508,     0.000000513147633,     0.000000318762085,     0.000000213462249,     0.000000151974583,
     0.000000113715895,     0.000000088594067,     0.000000071326624,     0.000000058986769,     0.232574235316707,     0.008008737636219,     0.000827331905914,     0.000142429930050,     0.000034315259967,     0.000010617871171,
     0.000004004897451,     0.000001775802546,     0.000000900229934,     0.000000509970660,     0.000000316635042,     0.000000211948174,     0.000000150841842,     0.000000112833511,     0.000000087883742,     0.000000070739243,
     0.000000058490207,     0.232494189283216,     0.008000471432941,     0.000825909320609,     0.000142087307677,     0.000034209281205,     0.000010577910836,     0.000003987184352,     0.000001766825693,     0.000000895146024,
     0.000000506814882,     0.000000314523084,     0.000000210445383,     0.000000149717890,     0.000000111958200,     0.000000087179266,     0.000000070156806,     0.000000057997903,     0.232414225840686,     0.007992219438404,
     0.000824490156235,     0.000141745743097,     0.000034103701161,     0.000010538127185,     0.000003969560768,     0.000001757899521,     0.000000890093566,     0.000000503680149,     0.000000312426097,     0.000000208953787,
     0.000000148602655,     0.000000111089906,     0.000000086480590,     0.000000069579271,     0.000000057509817,     0.232334344847199,     0.007983981618449,     0.000823074402234,     0.000141405232331,     0.000033998518075,
     0.000010498519324,     0.000003952026193,     0.000001749023717,     0.000000885072351,     0.000000500566311,     0.000000310343971,     0.000000207473301,     0.000000147496068,     0.000000110228569,     0.000000085787665,
     0.000000069006596,     0.000000057025915,     0.232254546161181,     0.007975757939026,     0.000821662048089,     0.000141065771418,     0.000033893730192,     0.000010459086366,     0.000003934580127,     0.000001740197971,
     0.000000880082171,     0.000000497473220,     0.000000308276595,     0.000000206003837,     0.000000146398060,     0.000000109374134,     0.000000085100442,     0.000000068438739,     0.000000056546159,     0.232174829641397,
     0.007967548366189,     0.000820253083319,     0.000140727356416,     0.000033789335768,     0.000010419827428,     0.000003917222068,     0.000001731421971,     0.000000875122818,     0.000000494400730,     0.000000306223858,
     0.000000204545311,     0.000000145308563,     0.000000108526542,     0.000000084418874,     0.000000067875659,     0.000000056070514,     0.232095195146949,     0.007959352866097,     0.000818847497487,     0.000140389983397,
     0.000033685333066,     0.000010380741633,     0.000003899951522,     0.000001722695412,     0.000000870194088,     0.000000491348694,     0.000000304185652,     0.000000203097638,     0.000000144227507,     0.000000107685737,
     0.000000083742913,     0.000000067317315,     0.000000055598943,     0.232015642537278,     0.007951171405011,     0.000817445280191,     0.000140053648454,     0.000033581720361,     0.000010341828108,     0.000003882767996,
     0.000001714017988,     0.000000865295777,     0.000000488316969,     0.000000302161869,     0.000000201660733,     0.000000143154826,     0.000000106851665,     0.000000083072512,     0.000000066763666,     0.000000055131412,
     0.231936171672164,     0.007943003949299,     0.000816046421071,     0.000139718347696,     0.000033478495933,     0.000010303085985,     0.000003865671000,     0.000001705389396,     0.000000860427682,     0.000000485305409,
     0.000000300152402,     0.000000200234514,     0.000000142090451,     0.000000106024269,     0.000000082407624,     0.000000066214673,     0.000000054667885,     0.231856782411719,     0.007934850465430,     0.000814650909803,
     0.000139384077247,     0.000033375658072,     0.000010264514401,     0.000003848660047,     0.000001696809334,     0.000000855589602,     0.000000482313873,     0.000000298157144,     0.000000198818897,     0.000000141034318,
     0.000000105203494,     0.000000081748203,     0.000000065670296,     0.000000054208327,     0.231777474616394,     0.007926710919978,     0.000813258736104,     0.000139050833251,     0.000033273205079,     0.000010226112499,
     0.000003831734652,     0.000001688277505,     0.000000850781338,     0.000000479342219,     0.000000296175989,     0.000000197413800,     0.000000139986360,     0.000000104389287,     0.000000081094203,     0.000000065130494,
     0.000000053752704,     0.231698248146969,     0.007918585279617,     0.000811869889729,     0.000138718611868,     0.000033171135260,     0.000010187879424,     0.000003814894337,     0.000001679793609,     0.000000846002692,
     0.000000476390307,     0.000000294208833,     0.000000196019143,     0.000000138946511,     0.000000103581592,     0.000000080445578,     0.000000064595228,     0.000000053300981,     0.231619102864562,     0.007910473511126,
     0.000810484360471,     0.000138387409275,     0.000033069446931,     0.000010149814330,     0.000003798138621,     0.000001671357353,     0.000000841253466,     0.000000473457996,     0.000000292255572,     0.000000194634843,
     0.000000137914706,     0.000000102780357,     0.000000079802283,     0.000000064064461,     0.000000052853125,     0.231540038630618,     0.007902375581384,     0.000809102138160,     0.000138057221664,     0.000032968138416,
     0.000010111916372,     0.000003781467032,     0.000001662968442,     0.000000836533467,     0.000000470545149,     0.000000290316102,     0.000000193260822,     0.000000136890882,     0.000000101985529,     0.000000079164274,
     0.000000063538153,     0.000000052409102,     0.231461055306915,     0.007894291457373,     0.000807723212667,     0.000137728045246,     0.000032867208049,     0.000010074184710,     0.000003764879096,     0.000001654626587,
     0.000000831842499,     0.000000467651629,     0.000000288390321,     0.000000191896999,     0.000000135874975,     0.000000101197054,     0.000000078531506,     0.000000063016266,     0.000000051968879,     0.231382152755561,
     0.007886221106175,     0.000806347573897,     0.000137399876248,     0.000032766654170,     0.000010036618512,     0.000003748374344,     0.000001646331496,     0.000000827180370,     0.000000464777298,     0.000000286478128,
     0.000000190543296,     0.000000134866920,     0.000000100414882,     0.000000077903934,     0.000000062498763,     0.000000051532422,     0.231303330838992,     0.007878164494973,     0.000804975211796,     0.000137072710913,
     0.000032666475130,     0.000009999216948,     0.000003731952311,     0.000001638082884,     0.000000822546889,     0.000000461922021,     0.000000284579422,     0.000000189199635,     0.000000133866656,     0.000000099638959,
     0.000000077281516,     0.000000061985606,     0.000000051099700,     0.231224589419971,     0.007870121591051,     0.000803606116346,     0.000136746545501,     0.000032566669285,     0.000009961979192,     0.000003715612533,
     0.000001629880463,     0.000000817941867,     0.000000459085665,     0.000000282694102,     0.000000187865937,     0.000000132874120,     0.000000098869234,     0.000000076664208,     0.000000061476757,     0.000000050670679,
     0.231145928361588,     0.007862092361791,     0.000802240277566,     0.000136421376289,     0.000032467235003,     0.000009924904425,     0.000003699354549,     0.000001621723952,     0.000000813365114,     0.000000456268095,
     0.000000280822070,     0.000000186542127,     0.000000131889251,     0.000000098105658,     0.000000076051966,     0.000000060972180,     0.000000050245328,     0.231067347527261,     0.007854076774677,     0.000800877685512,
     0.000136097199568,     0.000032368170656,     0.000009887991830,     0.000003683177901,     0.000001613613068,     0.000000808816443,     0.000000453469179,     0.000000278963227,     0.000000185228127,     0.000000130911987,
     0.000000097348178,     0.000000075444750,     0.000000060471838,     0.000000049823613,     0.230988846780729,     0.007846074797291,     0.000799518330278,     0.000135774011648,     0.000032269474628,     0.000009851240597,
     0.000003667082136,     0.000001605547530,     0.000000804295668,     0.000000450688787,     0.000000277117475,     0.000000183923862,     0.000000129942267,     0.000000096596746,     0.000000074842516,     0.000000059975695,
     0.000000049405505,     0.230910425986057,     0.007838086397315,     0.000798162201995,     0.000135451808853,     0.000032171145309,     0.000009814649919,     0.000003651066801,     0.000001597527062,     0.000000799802606,
     0.000000447926787,     0.000000275284718,     0.000000182629257,     0.000000128980032,     0.000000095851311,     0.000000074245222,     0.000000059483716,     0.000000048990972,     0.230832085007632,     0.007830111542527,
     0.000796809290830,     0.000135130587525,     0.000032073181097,     0.000009778218994,     0.000003635131446,     0.000001589551386,     0.000000795337072,     0.000000445183049,     0.000000273464858,     0.000000181344237,
     0.000000128025221,     0.000000095111825,     0.000000073652828,     0.000000058995864,     0.000000048579982,     0.230753823710163,     0.007822150200807,     0.000795459586985,     0.000134810344019,     0.000031975580399,
     0.000009741947025,     0.000003619275624,     0.000001581620229,     0.000000790898884,     0.000000442457447,     0.000000271657801,     0.000000180068728,     0.000000127077776,     0.000000094378239,     0.000000073065291,
     0.000000058512105,     0.000000048172505,     0.230675641958679,     0.007814202340129,     0.000794113080702,     0.000134491074710,     0.000031878341630,     0.000009705833218,     0.000003603498893,     0.000001573733318,
     0.000000786487863,     0.000000439749851,     0.000000269863452,     0.000000178802657,     0.000000126137637,     0.000000093650503,     0.000000072482572,     0.000000058032402,     0.000000047768510,     0.230597539618530,
     0.007806267928567,     0.000792769762256,     0.000134172775986,     0.000031781463210,     0.000009669876785,     0.000003587800812,     0.000001565890382,     0.000000782103828,     0.000000437060136,     0.000000268081717,
     0.000000177545951,     0.000000125204746,     0.000000092928571,     0.000000071904630,     0.000000057556723,     0.000000047367967,     0.230519516555383,     0.007798346934290,     0.000791429621959,     0.000133855444250,
     0.000031684943572,     0.000009634076941,     0.000003572180940,     0.000001558091152,     0.000000777746601,     0.000000434388175,     0.000000266312502,     0.000000176298538,     0.000000124279046,     0.000000092212395,
     0.000000071331424,     0.000000057085032,     0.000000046970846,     0.230441572635226,     0.007790439325566,     0.000790092650159,     0.000133539075923,     0.000031588781152,     0.000009598432907,     0.000003556638844,
     0.000001550335361,     0.000000773416005,     0.000000431733844,     0.000000264555715,     0.000000175060346,     0.000000123360479,     0.000000091501927,     0.000000070762916,     0.000000056617295,     0.000000046577118,
     0.230363707724359,     0.007782545070757,     0.000788758837241,     0.000133223667441,     0.000031492974397,     0.000009562943907,     0.000003541174089,     0.000001542622744,     0.000000769111866,     0.000000429097019,
     0.000000262811265,     0.000000173831305,     0.000000122448989,     0.000000090797121,     0.000000070199065,     0.000000056153478,     0.000000046186753,     0.230285921689403,     0.007774664138324,     0.000787428173623,
     0.000132909215255,     0.000031397521760,     0.000009527609169,     0.000003525786246,     0.000001534953036,     0.000000764834007,     0.000000426477578,     0.000000261079059,     0.000000172611343,     0.000000121544518,
     0.000000090097930,     0.000000069639833,     0.000000055693549,     0.000000045799721,     0.230208214397290,     0.007766796496819,     0.000786100649760,     0.000132595715831,     0.000031302421702,     0.000009492427927,
     0.000003510474886,     0.000001527325977,     0.000000760582256,     0.000000423875398,     0.000000259359008,     0.000000171400391,     0.000000120647012,     0.000000089404309,     0.000000069085181,     0.000000055237473,
     0.000000045415995,     0.230130585715268,     0.007758942114894,     0.000784776256142,     0.000132283165651,     0.000031207672692,     0.000009457399418,     0.000003495239585,     0.000001519741305,     0.000000756356442,
     0.000000421290358,     0.000000257651021,     0.000000170198380,     0.000000119756414,     0.000000088716212,     0.000000068535071,     0.000000054785218,     0.000000045035544,     0.230053035510898,     0.007751100961294,
     0.000783454983295,     0.000131971561212,     0.000031113273207,     0.000009422522883,     0.000003480079920,     0.000001512198762,     0.000000752156393,     0.000000418722337,     0.000000255955011,     0.000000169005240,
     0.000000118872669,     0.000000088033593,     0.000000067989464,     0.000000054336751,     0.000000044658342,     0.229975563652051,     0.007743273004857,     0.000782136821777,     0.000131660899027,     0.000031019221731,
     0.000009387797568,     0.000003464995470,     0.000001504698092,     0.000000747981939,     0.000000416171218,     0.000000254270887,     0.000000167820904,     0.000000117995724,     0.000000087356407,     0.000000067448324,
     0.000000053892040,     0.000000044284359,     0.229898170006913,     0.007735458214518,     0.000780821762185,     0.000131351175622,     0.000030925516754,     0.000009353222724,     0.000003449985819,     0.000001497239038,
     0.000000743832912,     0.000000413636880,     0.000000252598563,     0.000000166645303,     0.000000117125523,     0.000000086684611,     0.000000066911611,     0.000000053451053,     0.000000043913567,     0.229820854443977,
     0.007727656559305,     0.000779509795147,     0.000131042387542,     0.000030832156777,     0.000009318797604,     0.000003435050551,     0.000001489821349,     0.000000739709146,     0.000000411119208,     0.000000250937952,
     0.000000165478371,     0.000000116262014,     0.000000086018161,     0.000000066379290,     0.000000053013758,     0.000000043545940,     0.229743616832046,     0.007719868008338,     0.000778200911328,     0.000130734531342,
     0.000030739140305,     0.000009284521467,     0.000003420189255,     0.000001482444772,     0.000000735610473,     0.000000408618083,     0.000000249288967,     0.000000164320041,     0.000000115405142,     0.000000085357011,
     0.000000065851324,     0.000000052580124,     0.000000043181450,     0.229666457040232,     0.007712092530832,     0.000776895101425,     0.000130427603596,     0.000030646465853,     0.000009250393574,     0.000003405401520,
     0.000001475109057,     0.000000731536729,     0.000000406133390,     0.000000247651523,     0.000000163170246,     0.000000114554856,     0.000000084701120,     0.000000065327676,     0.000000052150119,     0.000000042820068,
     0.229589374937954,     0.007704330096094,     0.000775592356172,     0.000130121600890,     0.000030554131942,     0.000009216413192,     0.000003390686939,     0.000001467813955,     0.000000727487751,     0.000000403665014,
     0.000000246025534,     0.000000162028922,     0.000000113711102,     0.000000084050443,     0.000000064808309,     0.000000051723712,     0.000000042461770,     0.229512370394936,     0.007696580673524,     0.000774292666335,
     0.000129816519826,     0.000030462137100,     0.000009182579593,     0.000003376045106,     0.000001460559220,     0.000000723463375,     0.000000401212841,     0.000000244410916,     0.000000160896002,     0.000000112873830,
     0.000000083404939,     0.000000064293189,     0.000000051300873,     0.000000042106527,     0.229435443281211,     0.007688844232613,     0.000772996022715,     0.000129512357022,     0.000030370479864,     0.000009148892049,
     0.000003361475620,     0.000001453344606,     0.000000719463440,     0.000000398776758,     0.000000242807586,     0.000000159771424,     0.000000112042987,     0.000000082764566,     0.000000063782280,     0.000000050881572,
     0.000000041754313,     0.229358593467113,     0.007681120742946,     0.000771702416145,     0.000129209109109,     0.000030279158775,     0.000009115349840,     0.000003346978081,     0.000001446169870,     0.000000715487787,
     0.000000396356652,     0.000000241215460,     0.000000158655121,     0.000000111218522,     0.000000082129280,     0.000000063275546,     0.000000050465777,     0.000000041405102,     0.229281820823283,     0.007673410174197,
     0.000770411837494,     0.000128906772731,     0.000030188172385,     0.000009081952249,     0.000003332552091,     0.000001439034770,     0.000000711536254,     0.000000393952412,     0.000000239634456,     0.000000157547032,
     0.000000110400384,     0.000000081499041,     0.000000062772953,     0.000000050053460,     0.000000041058868,     0.229205125220661,     0.007665712496134,     0.000769124277663,     0.000128605344550,     0.000030097519250,
     0.000009048698561,     0.000003318197254,     0.000001431939065,     0.000000707608686,     0.000000391563926,     0.000000238064493,     0.000000156447093,     0.000000109588524,     0.000000080873807,     0.000000062274466,
     0.000000049644590,     0.000000040715586,     0.229128506530491,     0.007658027678612,     0.000767839727587,     0.000128304821240,     0.000030007197936,     0.000009015588068,     0.000003303913179,     0.000001424882517,
     0.000000703704924,     0.000000389191085,     0.000000236505488,     0.000000155355241,     0.000000108782891,     0.000000080253538,     0.000000061780050,     0.000000049239138,     0.000000040375229,     0.229051964624320,
     0.007650355691579,     0.000766558178233,     0.000128005199490,     0.000029917207014,     0.000008982620063,     0.000003289699474,     0.000001417864888,     0.000000699824812,     0.000000386833780,     0.000000234957361,
     0.000000154271414,     0.000000107983437,     0.000000079638193,     0.000000061289672,     0.000000048837076,     0.000000040037773,     0.228975499373992,     0.007642696505075,     0.000765279620603,     0.000127706476003,
     0.000029827545062,     0.000008949793845,     0.000003275555752,     0.000001410885942,     0.000000695968197,     0.000000384491902,     0.000000233420033,     0.000000153195552,     0.000000107190111,     0.000000079027731,
     0.000000060803297,     0.000000048438373,     0.000000039703191,     0.228899110651650,     0.007635050089225,     0.000764004045730,     0.000127408647497,     0.000029738210667,     0.000008917108716,     0.000003261481627,
     0.000001403945446,     0.000000692134923,     0.000000382165344,     0.000000231893424,     0.000000152127592,     0.000000106402866,     0.000000078422113,     0.000000060320893,     0.000000048043002,     0.000000039371460,
     0.228822798329737,     0.007627416414247,     0.000762731444681,     0.000127111710703,     0.000029649202420,     0.000008884563982,     0.000003247476716,     0.000001397043166,     0.000000688324839,     0.000000379853998,
     0.000000230377455,     0.000000151067474,     0.000000105621653,     0.000000077821300,     0.000000059842426,     0.000000047650935,     0.000000039042555,     0.228746562280994,     0.007619795450448,     0.000761461808554,
     0.000126815662366,     0.000029560518921,     0.000008852158952,     0.000003233540637,     0.000001390178872,     0.000000684537793,     0.000000377557759,     0.000000228872048,     0.000000150015139,     0.000000104846424,
     0.000000077225252,     0.000000059367863,     0.000000047262142,     0.000000038716451,     0.228670402378456,     0.007612187168223,     0.000760195128483,     0.000126520499246,     0.000029472158778,     0.000008819892941,
     0.000003219673013,     0.000001383352334,     0.000000680773634,     0.000000375276522,     0.000000227377126,     0.000000148970526,     0.000000104077132,     0.000000076633930,     0.000000058897172,     0.000000046876596,
     0.000000038393124,     0.228594318495456,     0.007604591538054,     0.000758931395629,     0.000126226218117,     0.000029384120601,     0.000008787765265,     0.000003205873466,     0.000001376563324,     0.000000677032213,
     0.000000373010182,     0.000000225892612,     0.000000147933577,     0.000000103313730,     0.000000076047296,     0.000000058430321,     0.000000046494270,     0.000000038072549,     0.228518310505620,     0.007597008530515,
     0.000757670601191,     0.000125932815766,     0.000029296403013,     0.000008755775246,     0.000003192141622,     0.000001369811615,     0.000000673313381,     0.000000370758636,     0.000000224418429,     0.000000146904232,
     0.000000102556171,     0.000000075465311,     0.000000057967276,     0.000000046115136,     0.000000037754704,     0.228442378282868,     0.007589438116265,     0.000756412736396,     0.000125640288993,     0.000029209004640,
     0.000008723922208,     0.000003178477110,     0.000001363096981,     0.000000669616991,     0.000000368521779,     0.000000222954502,     0.000000145882434,     0.000000101804408,     0.000000074887938,     0.000000057508008,
     0.000000045739167,     0.000000037439565,     0.228366521701415,     0.007581880266051,     0.000755157792503,     0.000125348634614,     0.000029121924115,     0.000008692205481,     0.000003164879559,     0.000001356419200,
     0.000000665942897,     0.000000366299512,     0.000000221500756,     0.000000144868125,     0.000000101058397,     0.000000074315138,     0.000000057052483,     0.000000045366336,     0.000000037127107,     0.228290740635764,
     0.007574334950708,     0.000753905760806,     0.000125057849456,     0.000029035160078,     0.000008660624395,     0.000003151348604,     0.000001349778050,     0.000000662290953,     0.000000364091731,     0.000000220057115,
     0.000000143861247,     0.000000100318090,     0.000000073746876,     0.000000056600670,     0.000000044996616,     0.000000036817308,     0.228215034960714,     0.007566802141157,     0.000752656632627,     0.000124767930362,
     0.000028948711177,     0.000008629178288,     0.000003137883877,     0.000001343173308,     0.000000658661014,     0.000000361898336,     0.000000218623506,     0.000000142861744,     0.000000099583444,     0.000000073183113,
     0.000000056152540,     0.000000044629981,     0.000000036510145,     0.228139404551352,     0.007559281808406,     0.000751410399322,     0.000124478874186,     0.000028862576065,     0.000008597866498,     0.000003124485017,
     0.000001336604756,     0.000000655052938,     0.000000359719227,     0.000000217199856,     0.000000141869559,     0.000000098854413,     0.000000072623813,     0.000000055708061,     0.000000044266404,     0.000000036205595,
     0.228063849283053,     0.007551773923549,     0.000750167052278,     0.000124190677799,     0.000028776753402,     0.000008566688369,     0.000003111151662,     0.000001330072177,     0.000000651466582,     0.000000357554306,
     0.000000215786091,     0.000000140884637,     0.000000098130953,     0.000000072068939,     0.000000055267202,     0.000000043905860,     0.000000035903636,     0.227988369031484,     0.007544278457768,     0.000748926582911,
     0.000123903338081,     0.000028691241854,     0.000008535643248,     0.000003097883454,     0.000001323575353,     0.000000647901805,     0.000000355403473,     0.000000214382139,     0.000000139906922,     0.000000097413020,
     0.000000071518457,     0.000000054829933,     0.000000043548323,     0.000000035604245,     0.227912963672597,     0.007536795382327,     0.000747688982671,     0.000123616851929,     0.000028606040095,     0.000008504730484,
     0.000003084680037,     0.000001317114069,     0.000000644358466,     0.000000353266631,     0.000000212987929,     0.000000138936358,     0.000000096700570,     0.000000070972329,     0.000000054396225,     0.000000043193767,
     0.000000035307399,     0.227837633082632,     0.007529324668579,     0.000746454243037,     0.000123331216251,     0.000028521146805,     0.000008473949432,     0.000003071541055,     0.000001310688113,     0.000000640836426,
     0.000000351143682,     0.000000211603388,     0.000000137972892,     0.000000095993559,     0.000000070430520,     0.000000053966048,     0.000000042842167,     0.000000035013078,     0.227762377138115,     0.007521866287959,
     0.000745222355521,     0.000123046427969,     0.000028436560670,     0.000008443299449,     0.000003058466157,     0.000001304297270,     0.000000637335547,     0.000000349034531,     0.000000210228447,     0.000000137016469,
     0.000000095291945,     0.000000069892996,     0.000000053539372,     0.000000042493497,     0.000000034721259,     0.227687195715857,     0.007514420211990,     0.000743993311663,     0.000122762484018,     0.000028352280382,
     0.000008412779897,     0.000003045454993,     0.000001297941332,     0.000000633855690,     0.000000346939081,     0.000000208863036,     0.000000136067036,     0.000000094595685,     0.000000069359721,     0.000000053116169,
     0.000000042147733,     0.000000034431920,     0.227612088692954,     0.007506986412275,     0.000742767103036,     0.000122479381346,     0.000028268304639,     0.000008382390138,     0.000003032507215,     0.000001291620087,
     0.000000630396720,     0.000000344857239,     0.000000207507083,     0.000000135124538,     0.000000093904736,     0.000000068830661,     0.000000052696408,     0.000000041804851,     0.000000034145040,     0.227537055946785,
     0.007499564860506,     0.000741543721242,     0.000122197116915,     0.000028184632148,     0.000008352129542,     0.000003019622477,     0.000001285333328,     0.000000626958500,     0.000000342788908,     0.000000206160522,
     0.000000134188923,     0.000000093219058,     0.000000068305782,     0.000000052280062,     0.000000041464824,     0.000000033860598,     0.227462097355012,     0.007492155528456,     0.000740323157914,     0.000121915687697,
     0.000028101261620,     0.000008321997480,     0.000003006800434,     0.000001279080848,     0.000000623540897,     0.000000340733997,     0.000000204823282,     0.000000133260139,     0.000000092538607,     0.000000067785049,
     0.000000051867102,     0.000000041127631,     0.000000033578572,     0.227387212795578,     0.007484758387981,     0.000739105404714,     0.000121635090680,     0.000028018191772,     0.000008291993326,     0.000002994040746,
     0.000001272862442,     0.000000620143776,     0.000000338692412,     0.000000203495296,     0.000000132338134,     0.000000091863343,     0.000000067268428,     0.000000051457500,     0.000000040793245,     0.000000033298943,
     0.227312402146707,     0.007477373411022,     0.000737890453336,     0.000121355322863,     0.000027935421329,     0.000008262116458,     0.000002981343072,     0.000001266677905,     0.000000616767004,     0.000000336664060,
     0.000000202176497,     0.000000131422855,     0.000000091193225,     0.000000066755888,     0.000000051051228,     0.000000040461644,     0.000000033021688,     0.227237665286905,     0.007470000569602,     0.000736678295503,
     0.000121076381259,     0.000027852949021,     0.000008232366259,     0.000002968707076,     0.000001260527034,     0.000000613410451,     0.000000334648851,     0.000000200866817,     0.000000130514252,     0.000000090528212,
     0.000000066247393,     0.000000050648258,     0.000000040132803,     0.000000032746788,     0.227163002094956,     0.007462639835828,     0.000735468922967,     0.000120798262893,     0.000027770773584,     0.000008202742112,
     0.000002956132420,     0.000001254409629,     0.000000610073984,     0.000000332646694,     0.000000199566190,     0.000000129612274,     0.000000089868264,     0.000000065742912,     0.000000050248563,     0.000000039806700,
     0.000000032474223,     0.227088412449923,     0.007455291181886,     0.000734262327511,     0.000120520964802,     0.000027688893760,     0.000008173243407,     0.000002943618772,     0.000001248325488,     0.000000606757474,
     0.000000330657498,     0.000000198274550,     0.000000128716870,     0.000000089213340,     0.000000065242411,     0.000000049852115,     0.000000039483311,     0.000000032203972,     0.227013896231145,     0.007447954580048,
     0.000733058500947,     0.000120244484037,     0.000027607308300,     0.000008143869534,     0.000002931165800,     0.000001242274413,     0.000000603460791,     0.000000328681173,     0.000000196991831,     0.000000127827991,
     0.000000088563402,     0.000000064745859,     0.000000049458888,     0.000000039162613,     0.000000031936014,     0.226939453318240,     0.007440630002665,     0.000731857435116,     0.000119968817659,     0.000027526015956,
     0.000008114619890,     0.000002918773174,     0.000001236256207,     0.000000600183808,     0.000000326717632,     0.000000195717968,     0.000000126945586,     0.000000087918410,     0.000000064253222,     0.000000049068854,
     0.000000038844583,     0.000000031670332,     0.226865083591102,     0.007433317422170,     0.000730659121889,     0.000119693962745,     0.000027445015490,     0.000008085493871,     0.000002906440567,     0.000001230270672,
     0.000000596926396,     0.000000324766785,     0.000000194452898,     0.000000126069606,     0.000000087278325,     0.000000063764471,     0.000000048681987,     0.000000038529199,     0.000000031406904,     0.226790786929899,
     0.007426016811079,     0.000729463553166,     0.000119419916381,     0.000027364305668,     0.000008056490879,     0.000002894167653,     0.000001224317614,     0.000000593688430,     0.000000322828545,     0.000000193196555,
     0.000000125200003,     0.000000086643108,     0.000000063279572,     0.000000048298261,     0.000000038216438,     0.000000031145711,     0.226716563215074,     0.007418728141985,     0.000728270720876,     0.000119146675667,
     0.000027283885264,     0.000008027610320,     0.000002881954107,     0.000001218396839,     0.000000590469783,     0.000000320902825,     0.000000191948877,     0.000000124336728,     0.000000086012721,     0.000000062798495,
     0.000000047917650,     0.000000037906277,     0.000000030886734,     0.226642412327343,     0.007411451387566,     0.000727080616976,     0.000118874237715,     0.000027203753056,     0.000007998851600,     0.000002869799609,
     0.000001212508154,     0.000000587270332,     0.000000318989538,     0.000000190709799,     0.000000123479733,     0.000000085387125,     0.000000062321209,     0.000000047540127,     0.000000037598696,     0.000000030629954,
     0.226568334147698,     0.007404186520578,     0.000725893233455,     0.000118602599649,     0.000027123907828,     0.000007970214132,     0.000002857703838,     0.000001206651369,     0.000000584089952,     0.000000317088600,
     0.000000189479261,     0.000000122628970,     0.000000084766284,     0.000000061847683,     0.000000047165667,     0.000000037293671,     0.000000030375353,     0.226494328557398,     0.007396933513856,     0.000724708562327,
     0.000118331758606,     0.000027044348371,     0.000007941697329,     0.000002845666476,     0.000001200826292,     0.000000580928519,     0.000000315199925,     0.000000188257199,     0.000000121784391,     0.000000084150159,
     0.000000061377885,     0.000000046794245,     0.000000036991182,     0.000000030122910,     0.226420395437976,     0.007389692340317,     0.000723526595636,     0.000118061711733,     0.000026965073481,     0.000007913300609,
     0.000002833687207,     0.000001195032735,     0.000000577785912,     0.000000313323428,     0.000000187043553,     0.000000120945951,     0.000000083538714,     0.000000060911788,     0.000000046425835,     0.000000036691206,
     0.000000029872608,     0.226346534671237,     0.007382462972955,     0.000722347325454,     0.000117792456192,     0.000026886081960,     0.000007885023392,     0.000002821765717,     0.000001189270511,     0.000000574662010,
     0.000000311459026,     0.000000185838260,     0.000000120113602,     0.000000082931911,     0.000000060449359,     0.000000046060413,     0.000000036393722,     0.000000029624428,     0.226272746139253,     0.007375245384845,
     0.000721170743883,     0.000117523989153,     0.000026807372617,     0.000007856865103,     0.000002809901693,     0.000001183539433,     0.000000571556692,     0.000000309606635,     0.000000184641261,     0.000000119287297,
     0.000000082329715,     0.000000059990569,     0.000000045697952,     0.000000036098710,     0.000000029378351,     0.226199029724366,     0.007368039549142,     0.000719996843052,     0.000117256307803,     0.000026728944264,
     0.000007828825168,     0.000002798094825,     0.000001177839316,     0.000000568469838,     0.000000307766173,     0.000000183452494,     0.000000118466992,     0.000000081732088,     0.000000059535390,     0.000000045338430,
     0.000000035806148,     0.000000029134361,     0.226125385309185,     0.007360845439075,     0.000718825615118,     0.000116989409335,     0.000026650795721,     0.000007800903017,     0.000002786344804,     0.000001172169975,
     0.000000565401329,     0.000000305937558,     0.000000182271901,     0.000000117652640,     0.000000081138995,     0.000000059083791,     0.000000044981821,     0.000000035516016,     0.000000028892438,     0.226051812776588,
     0.007353663027956,     0.000717657052265,     0.000116723290959,     0.000026572925813,     0.000007773098083,     0.000002774651323,     0.000001166531229,     0.000000562351047,     0.000000304120708,     0.000000181099422,
     0.000000116844197,     0.000000080550400,     0.000000058635744,     0.000000044628102,     0.000000035228293,     0.000000028652565,     0.225978312009718,     0.007346492289172,     0.000716491146708,     0.000116457949894,
     0.000026495333370,     0.000007745409803,     0.000002763014078,     0.000001160922894,     0.000000559318876,     0.000000302315543,     0.000000179934997,     0.000000116041617,     0.000000079966268,     0.000000058191220,
     0.000000044277248,     0.000000034942958,     0.000000028414724,     0.225904882891985,     0.007339333196190,     0.000715327890686,     0.000116193383371,     0.000026418017230,     0.000007717837615,     0.000002751432765,
     0.000001155344791,     0.000000556304698,     0.000000300521982,     0.000000178778570,     0.000000115244857,     0.000000079386564,     0.000000057750190,     0.000000043929235,     0.000000034659992,     0.000000028178898,
     0.225831525307063,     0.007332185722552,     0.000714167276467,     0.000115929588632,     0.000026340976233,     0.000007690380962,     0.000002739907082,     0.000001149796741,     0.000000553308398,     0.000000298739945,
     0.000000177630081,     0.000000114453872,     0.000000078811253,     0.000000057312625,     0.000000043584040,     0.000000034379373,     0.000000027945069,     0.225758239138891,     0.007325049841880,     0.000713009296349,
     0.000115666562933,     0.000026264209227,     0.000007663039289,     0.000002728436730,     0.000001144278564,     0.000000550329861,     0.000000296969354,     0.000000176489473,     0.000000113668617,     0.000000078240300,
     0.000000056878499,     0.000000043241640,     0.000000034101084,     0.000000027713220,     0.225685024271670,     0.007317925527870,     0.000711853942654,     0.000115404303538,     0.000026187715066,     0.000007635812044,
     0.000002717021412,     0.000001138790085,     0.000000547368973,     0.000000295210129,     0.000000175356690,     0.000000112889051,     0.000000077673672,     0.000000056447783,     0.000000042902011,     0.000000033825102,
     0.000000027483334,     0.225611880589865,     0.007310812754298,     0.000710701207733,     0.000115142807726,     0.000026111492607,     0.000007608698678,     0.000002705660830,     0.000001133331126,     0.000000544425621,
     0.000000293462194,     0.000000174231674,     0.000000112115130,     0.000000077111333,     0.000000056020450,     0.000000042565130,     0.000000033551410,     0.000000027255395,     0.225538807978203,     0.007303711495012,
     0.000709551083964,     0.000114882072784,     0.000026035540714,     0.000007581698646,     0.000002694354691,     0.000001127901514,     0.000000541499692,     0.000000291725470,     0.000000173114368,     0.000000111346810,
     0.000000076553251,     0.000000055596472,     0.000000042230975,     0.000000033279988,     0.000000027029385,     0.225465806321671,     0.007296621723940,     0.000708403563750,     0.000114622096014,     0.000025959858258,
     0.000007554811404,     0.000002683102703,     0.000001122501075,     0.000000538591074,     0.000000289999881,     0.000000172004719,     0.000000110584051,     0.000000075999393,     0.000000055175822,     0.000000041899523,
     0.000000033010816,     0.000000026805287,     0.225392875505517,     0.007289543415084,     0.000707258639525,     0.000114362874725,     0.000025884444112,     0.000007528036413,     0.000002671904573,     0.000001117129635,
     0.000000535699657,     0.000000288285351,     0.000000170902669,     0.000000109826808,     0.000000075449724,     0.000000054758472,     0.000000041570751,     0.000000032743876,     0.000000026583086,     0.225320015415248,
     0.007282476542521,     0.000706116303747,     0.000114104406241,     0.000025809297157,     0.000007501373134,     0.000002660760014,     0.000001111787024,     0.000000532825330,     0.000000286581803,     0.000000169808164,
     0.000000109075042,     0.000000074904212,     0.000000054344398,     0.000000041244638,     0.000000032479148,     0.000000026362765,     0.225247225936632,     0.007275421080406,     0.000704976548900,     0.000113846687895,
     0.000025734416279,     0.000007474821035,     0.000002649668737,     0.000001106473072,     0.000000529967985,     0.000000284889162,     0.000000168721150,     0.000000108328710,     0.000000074362825,     0.000000053933571,
     0.000000040921161,     0.000000032216615,     0.000000026144308,     0.225174506955691,     0.007268377002965,     0.000703839367497,     0.000113589717032,     0.000025659800368,     0.000007448379583,     0.000002638630458,
     0.000001101187609,     0.000000527127511,     0.000000283207355,     0.000000167641572,     0.000000107587772,     0.000000073825530,     0.000000053525966,     0.000000040600298,     0.000000031956256,     0.000000025927699,
     0.225101858358709,     0.007261344284502,     0.000702704752076,     0.000113333491008,     0.000025585448320,     0.000007422048250,     0.000002627644891,     0.000001095930466,     0.000000524303802,     0.000000281536306,
     0.000000166569377,     0.000000106852186,     0.000000073292295,     0.000000053121556,     0.000000040282028,     0.000000031698054,     0.000000025712921,     0.225029280032224,     0.007254322899395,     0.000701572695203,
     0.000113078007190,     0.000025511359037,     0.000007395826510,     0.000002616711754,     0.000001090701477,     0.000000521496749,     0.000000279875943,     0.000000165504511,     0.000000106121913,     0.000000072763088,
     0.000000052720317,     0.000000039966330,     0.000000031441992,     0.000000025499960,     0.224956771863029,     0.007247312822095,     0.000700443189467,     0.000112823262955,     0.000025437531426,     0.000007369713841,
     0.000002605830768,     0.000001085500476,     0.000000518706247,     0.000000278226192,     0.000000164446921,     0.000000105396911,     0.000000072237878,     0.000000052322221,     0.000000039653182,     0.000000031188049,
     0.000000025288799,     0.224884333738174,     0.007240314027126,     0.000699316227487,     0.000112569255693,     0.000025363964399,     0.000007343709722,     0.000002595001652,     0.000001080327297,     0.000000515932190,
     0.000000276586980,     0.000000163396555,     0.000000104677142,     0.000000071716634,     0.000000051927244,     0.000000039342562,     0.000000030936210,     0.000000025079423,     0.224811965544963,     0.007233326489090,
     0.000698191801906,     0.000112315982802,     0.000025290656872,     0.000007317813636,     0.000002584224130,     0.000001075181777,     0.000000513174473,     0.000000274958237,     0.000000162353361,     0.000000103962565,
     0.000000071199323,     0.000000051535362,     0.000000039034450,     0.000000030686455,     0.000000024871817,     0.224739667170953,     0.007226350182658,     0.000697069905392,     0.000112063441694,     0.000025217607768,
     0.000007292025068,     0.000002573497925,     0.000001070063754,     0.000000510432991,     0.000000273339889,     0.000000161317287,     0.000000103253143,     0.000000070685916,     0.000000051146547,     0.000000038728826,
     0.000000030438767,     0.000000024665965,     0.224667438503955,     0.007219385082576,     0.000695950530641,     0.000111811629789,     0.000025144816014,     0.000007266343507,     0.000002562822764,     0.000001064973064,
     0.000000507707641,     0.000000271731867,     0.000000160288281,     0.000000102548834,     0.000000070176382,     0.000000050760777,     0.000000038425668,     0.000000030193130,     0.000000024461852,     0.224595279432031,
     0.007212431163664,     0.000694833670374,     0.000111560544519,     0.000025072280542,     0.000007240768444,     0.000002552198373,     0.000001059909547,     0.000000504998319,     0.000000270134100,     0.000000159266293,
     0.000000101849602,     0.000000069670691,     0.000000050378026,     0.000000038124957,     0.000000029949525,     0.000000024259464,     0.224523189843495,     0.007205488400811,     0.000693719317337,     0.000111310183327,
     0.000025000000291,     0.000007215299371,     0.000002541624483,     0.000001054873044,     0.000000502304925,     0.000000268546518,     0.000000158251272,     0.000000101155408,     0.000000069168812,     0.000000049998270,
     0.000000037826671,     0.000000029707935,     0.000000024058786,     0.224451169626912,     0.007198556768984,     0.000692607464302,     0.000111060543666,     0.000024927974203,     0.000007189935787,     0.000002531100823,
     0.000001049863396,     0.000000499627355,     0.000000266969052,     0.000000157243168,     0.000000100466213,     0.000000068670715,     0.000000049621484,     0.000000037530791,     0.000000029468343,     0.000000023859802,
     0.224379218671095,     0.007191636243216,     0.000691498104067,     0.000110811622999,     0.000024856201226,     0.000007164677188,     0.000002520627126,     0.000001044880445,     0.000000496965510,     0.000000265401632,
     0.000000156241931,     0.000000099781981,     0.000000068176372,     0.000000049247646,     0.000000037237298,     0.000000029230733,     0.000000023662499,     0.224307336865110,     0.007184726798617,     0.000690391229454,
     0.000110563418801,     0.000024784680311,     0.000007139523078,     0.000002510203125,     0.000001039924034,     0.000000494319289,     0.000000263844191,     0.000000155247512,     0.000000099102673,     0.000000067685753,
     0.000000048876730,     0.000000036946170,     0.000000028995088,     0.000000023466862,     0.224235524098268,     0.007177828410365,     0.000689286833311,     0.000110315928556,     0.000024713410418,     0.000007114472961,
     0.000002499828557,     0.000001034994007,     0.000000491688593,     0.000000262296659,     0.000000154259862,     0.000000098428254,     0.000000067198828,     0.000000048508715,     0.000000036657389,     0.000000028761390,
     0.000000023272876,     0.224163780260131,     0.007170941053713,     0.000688184908512,     0.000110069149760,     0.000024642390507,     0.000007089526343,     0.000002489503158,     0.000001030090211,     0.000000489073323,
     0.000000260758971,     0.000000153278931,     0.000000097758685,     0.000000066715569,     0.000000048143575,     0.000000036370936,     0.000000028529625,     0.000000023080528,     0.224092105240505,     0.007164064703981,
     0.000687085447953,     0.000109823079917,     0.000024571619547,     0.000007064682735,     0.000002479226666,     0.000001025212490,     0.000000486473381,     0.000000259231058,     0.000000152304672,     0.000000097093930,
     0.000000066235947,     0.000000047781288,     0.000000036086790,     0.000000028299774,     0.000000022889803,     0.224020498929444,     0.007157199336563,     0.000685988444558,     0.000109577716542,     0.000024501096511,
     0.000007039941648,     0.000002468998822,     0.000001020360692,     0.000000483888670,     0.000000257712855,     0.000000151337036,     0.000000096433954,     0.000000065759934,     0.000000047421831,     0.000000035804934,
     0.000000028071823,     0.000000022700687,     0.223948961217247,     0.007150344926923,     0.000684893891275,     0.000109333057163,     0.000024430820374,     0.000007015302597,     0.000002458819366,     0.000001015534666,
     0.000000481319092,     0.000000256204296,     0.000000150375977,     0.000000095778719,     0.000000065287501,     0.000000047065182,     0.000000035525348,     0.000000027845755,     0.000000022513167,     0.223877491994461,
     0.007143501450594,     0.000683801781077,     0.000109089099315,     0.000024360790120,     0.000006990765100,     0.000002448688043,     0.000001010734260,     0.000000478764552,     0.000000254705314,     0.000000149421446,
     0.000000095128192,     0.000000064818621,     0.000000046711317,     0.000000035248013,     0.000000027621555,     0.000000022327229,     0.223806091151872,     0.007136668883181,     0.000682712106959,     0.000108845840545,
     0.000024291004735,     0.000006966328677,     0.000002438604596,     0.000001005959325,     0.000000476224954,     0.000000253215845,     0.000000148473398,     0.000000094482335,     0.000000064353265,     0.000000046360214,
     0.000000034972910,     0.000000027399206,     0.000000022142859,     0.223734758580515,     0.007129847200358,     0.000681624861944,     0.000108603278408,     0.000024221463211,     0.000006941992850,     0.000002428568772,
     0.000001001209712,     0.000000473700204,     0.000000251735825,     0.000000147531784,     0.000000093841115,     0.000000063891407,     0.000000046011851,     0.000000034700022,     0.000000027178692,     0.000000021960044,
     0.223663494171664,     0.007123036377868,     0.000680540039077,     0.000108361410471,     0.000024152164545,     0.000006917757143,     0.000002418580318,     0.000000996485272,     0.000000471190206,     0.000000250265188,
     0.000000146596560,     0.000000093204496,     0.000000063433019,     0.000000045666206,     0.000000034429330,     0.000000026960000,     0.000000021778770,     0.223592297816837,     0.007116236391526,     0.000679457631428,
     0.000108120234311,     0.000024083107736,     0.000006893621086,     0.000002408638983,     0.000000991785859,     0.000000468694869,     0.000000248803872,     0.000000145667679,     0.000000092572443,     0.000000062978074,
     0.000000045323258,     0.000000034160816,     0.000000026743112,     0.000000021599025,     0.223521169407793,     0.007109447217212,     0.000678377632093,     0.000107879747513,     0.000024014291792,     0.000006869584208,
     0.000002398744518,     0.000000987111326,     0.000000466214098,     0.000000247351814,     0.000000144745096,     0.000000091944923,     0.000000062526545,     0.000000044982983,     0.000000033894462,     0.000000026528014,
     0.000000021420795,     0.223450108836533,     0.007102668830879,     0.000677300034188,     0.000107639947675,     0.000023945715723,     0.000006845646040,     0.000002388896674,     0.000000982461528,     0.000000463747802,
     0.000000245908950,     0.000000143828766,     0.000000091321901,     0.000000062078406,     0.000000044645361,     0.000000033630250,     0.000000026314691,     0.000000021244067,     0.223379115995296,     0.007095901208546,
     0.000676224830857,     0.000107400832403,     0.000023877378544,     0.000006821806119,     0.000002379095205,     0.000000977836322,     0.000000461295889,     0.000000244475218,     0.000000142918643,     0.000000090703343,
     0.000000061633629,     0.000000044310371,     0.000000033368163,     0.000000026103128,     0.000000021068828,     0.223308190776562,     0.007089144326303,     0.000675152015266,     0.000107162399311,     0.000023809279275,
     0.000006798063982,     0.000002369339866,     0.000000973235563,     0.000000458858267,     0.000000243050556,     0.000000142014684,     0.000000090089217,     0.000000061192189,     0.000000043977991,     0.000000033108182,
     0.000000025893309,     0.000000020895066,     0.223237333073049,     0.007082398160305,     0.000674081580605,     0.000106924646027,     0.000023741416940,     0.000006774419169,     0.000002359630413,     0.000000968659109,
     0.000000456434848,     0.000000241634904,     0.000000141116844,     0.000000089479489,     0.000000060754061,     0.000000043648200,     0.000000032850291,     0.000000025685222,     0.000000020722767,     0.223166542777714,
     0.007075662686777,     0.000673013520087,     0.000106687570186,     0.000023673790568,     0.000006750871222,     0.000002349966603,     0.000000964106819,     0.000000454025539,     0.000000240228199,     0.000000140225080,
     0.000000088874125,     0.000000060319217,     0.000000043320978,     0.000000032594472,     0.000000025478849,     0.000000020551920,     0.223095819783751,     0.007068937882012,     0.000671947826951,     0.000106451169433,
     0.000023606399194,     0.000006727419686,     0.000002340348196,     0.000000959578552,     0.000000451630254,     0.000000238830382,     0.000000139339347,     0.000000088273093,     0.000000059887633,     0.000000042996304,
     0.000000032340708,     0.000000025274178,     0.000000020382512,     0.223025163984590,     0.007062223722369,     0.000670884494456,     0.000106215441422,     0.000023539241855,     0.000006704064108,     0.000002330774953,
     0.000000955074167,     0.000000449248902,     0.000000237441392,     0.000000138459603,     0.000000087676361,     0.000000059459282,     0.000000042674157,     0.000000032088983,     0.000000025071194,     0.000000020214530,
     0.222954575273899,     0.007055520184276,     0.000669823515888,     0.000105980383819,     0.000023472317594,     0.000006680804037,     0.000002321246634,     0.000000950593528,     0.000000446881397,     0.000000236061170,
     0.000000137585806,     0.000000087083897,     0.000000059034141,     0.000000042354518,     0.000000031839279,     0.000000024869883,     0.000000020047962,     0.222884053545578,     0.007048827244227,     0.000668764884553,
     0.000105745994296,     0.000023405625457,     0.000006657639026,     0.000002311763004,     0.000000946136494,     0.000000444527650,     0.000000234689656,     0.000000136717911,     0.000000086495668,     0.000000058612184,
     0.000000042037365,     0.000000031591579,     0.000000024670230,     0.000000019882797,     0.222813598693765,     0.007042144878783,     0.000667708593783,     0.000105512270539,     0.000023339164498,     0.000006634568629,
     0.000002302323826,     0.000000941702929,     0.000000442187575,     0.000000233326792,     0.000000135855878,     0.000000085911643,     0.000000058193386,     0.000000041722679,     0.000000031345868,     0.000000024472222,
     0.000000019719021,     0.222743210612831,     0.007035473064572,     0.000666654636931,     0.000105279210239,     0.000023272933771,     0.000006611592402,     0.000002292928867,     0.000000937292697,     0.000000439861085,
     0.000000231972519,     0.000000134999665,     0.000000085331790,     0.000000057777722,     0.000000041410441,     0.000000031102129,     0.000000024275845,     0.000000019556624,     0.222672889197381,     0.007028811778287,
     0.000665603007374,     0.000105046811099,     0.000023206932337,     0.000006588709905,     0.000002283577895,     0.000000932905662,     0.000000437548096,     0.000000230626780,     0.000000134149229,     0.000000084756078,
     0.000000057365169,     0.000000041100630,     0.000000030860346,     0.000000024081085,     0.000000019395593,     0.222602634342250,     0.007022160996689,     0.000664553698513,     0.000104815070831,     0.000023141159262,
     0.000006565920698,     0.000002274270677,     0.000000928541690,     0.000000435248522,     0.000000229289516,     0.000000133304529,     0.000000084184476,     0.000000056955701,     0.000000040793228,     0.000000030620502,
     0.000000023887929,     0.000000019235917,     0.222532445942509,     0.007015520696603,     0.000663506703769,     0.000104583987156,     0.000023075613614,     0.000006543224346,     0.000002265006984,     0.000000924200647,
     0.000000432962278,     0.000000227960670,     0.000000132465526,     0.000000083616954,     0.000000056549296,     0.000000040488214,     0.000000030382582,     0.000000023696363,     0.000000019077584,     0.222462323893457,
     0.007008890854921,     0.000662462016588,     0.000104353557804,     0.000023010294467,     0.000006520620414,     0.000002255786588,     0.000000919882401,     0.000000430689280,     0.000000226640186,     0.000000131632177,
     0.000000083053480,     0.000000056145929,     0.000000040185570,     0.000000030146570,     0.000000023506373,     0.000000018920583,     0.222392268090626,     0.007002271448601,     0.000661419630439,     0.000104123780515,
     0.000022945200899,     0.000006498108471,     0.000002246609261,     0.000000915586818,     0.000000428429446,     0.000000225328008,     0.000000130804443,     0.000000082494025,     0.000000055745577,     0.000000039885276,
     0.000000029912450,     0.000000023317947,     0.000000018764902,     0.222322278429777,     0.006995662454664,     0.000660379538812,     0.000103894653037,     0.000022880331992,     0.000006475688086,     0.000002237474777,
     0.000000911313768,     0.000000426182693,     0.000000224024079,     0.000000129982283,     0.000000081938559,     0.000000055348216,     0.000000039587314,     0.000000029680206,     0.000000023131070,     0.000000018610530,
     0.222252354806901,     0.006989063850198,     0.000659341735220,     0.000103666173129,     0.000022815686833,     0.000006453358833,     0.000002228382911,     0.000000907063121,     0.000000423948937,     0.000000222728344,
     0.000000129165658,     0.000000081387051,     0.000000054953823,     0.000000039291666,     0.000000029449823,     0.000000022945732,     0.000000018457455,     0.222182497118217,     0.006982475612355,     0.000658306213198,
     0.000103438338557,     0.000022751264513,     0.000006431120287,     0.000002219333440,     0.000000902834746,     0.000000421728099,     0.000000221440747,     0.000000128354529,     0.000000080839472,     0.000000054562375,
     0.000000038998312,     0.000000029221286,     0.000000022761917,     0.000000018305667,     0.222112705260174,     0.006975897718350,     0.000657272966305,     0.000103211147099,     0.000022687064127,     0.000006408972024,
     0.000002210326142,     0.000000898628516,     0.000000419520095,     0.000000220161235,     0.000000127548856,     0.000000080295794,     0.000000054173849,     0.000000038707234,     0.000000028994580,     0.000000022579614,
     0.000000018155155,     0.222042979129447,     0.006969330145466,     0.000656241988120,     0.000102984596538,     0.000022623084773,     0.000006386913624,     0.000002201360796,     0.000000894444302,     0.000000417324847,
     0.000000218889752,     0.000000126748600,     0.000000079755986,     0.000000053788223,     0.000000038418414,     0.000000028769689,     0.000000022398810,     0.000000018005907,     0.221973318622937,     0.006962772871047,
     0.000655213272245,     0.000102758684670,     0.000022559325556,     0.000006364944669,     0.000002192437183,     0.000000890281977,     0.000000415142274,     0.000000217626245,     0.000000125953723,     0.000000079220020,
     0.000000053405473,     0.000000038131834,     0.000000028546599,     0.000000022219492,     0.000000017857913,     0.221903723637773,     0.006956225872501,     0.000654186812305,     0.000102533409296,     0.000022495785583,
     0.000006343064742,     0.000002183555084,     0.000000886141414,     0.000000412972296,     0.000000216370660,     0.000000125164187,     0.000000078687867,     0.000000053025579,     0.000000037847476,     0.000000028325294,
     0.000000022041647,     0.000000017711163,     0.221834194071309,     0.006949689127302,     0.000653162601945,     0.000102308768230,     0.000022432463966,     0.000006321273430,     0.000002174714283,     0.000000882022489,
     0.000000410814834,     0.000000215122944,     0.000000124379953,     0.000000078159499,     0.000000052648516,     0.000000037565322,     0.000000028105761,     0.000000021865264,     0.000000017565644,     0.221764729821124,
     0.006943162612985,     0.000652140634833,     0.000102084759292,     0.000022369359820,     0.000006299570319,     0.000002165914563,     0.000000877925076,     0.000000408669811,     0.000000213883043,     0.000000123600984,
     0.000000077634887,     0.000000052274265,     0.000000037285355,     0.000000027887984,     0.000000021690330,     0.000000017421348,     0.221695330785021,     0.006936646307149,     0.000651120904659,     0.000101861380312,
     0.000022306472267,     0.000006277955002,     0.000002157155710,     0.000000873849052,     0.000000406537148,     0.000000212650907,     0.000000122827243,     0.000000077114004,     0.000000051902802,     0.000000037007557,
     0.000000027671949,     0.000000021516833,     0.000000017278263,     0.221625996861027,     0.006930140187456,     0.000650103405134,     0.000101638629128,     0.000022243800429,     0.000006256427070,     0.000002148437511,
     0.000000869794292,     0.000000404416767,     0.000000211426481,     0.000000122058692,     0.000000076596822,     0.000000051534107,     0.000000036731910,     0.000000027457643,     0.000000021344761,     0.000000017136380,
     0.221556727947392,     0.006923644231632,     0.000649088129991,     0.000101416503587,     0.000022181343435,     0.000006234986117,     0.000002139759754,     0.000000865760676,     0.000000402308593,     0.000000210209716,
     0.000000121295294,     0.000000076083313,     0.000000051168157,     0.000000036458398,     0.000000027245049,     0.000000021174102,     0.000000016995687,     0.221487523942589,     0.006917158417463,     0.000648075072984,
     0.000101195001546,     0.000022119100418,     0.000006213631741,     0.000002131122227,     0.000000861748080,     0.000000400212547,     0.000000209000558,     0.000000120537014,     0.000000075573450,     0.000000050804932,
     0.000000036187004,     0.000000027034156,     0.000000021004843,     0.000000016856175,     0.221418384745311,     0.006910682722799,     0.000647064227889,     0.000100974120868,     0.000022057070513,     0.000006192363539,
     0.000002122524722,     0.000000857756385,     0.000000398128556,     0.000000207798958,     0.000000119783813,     0.000000075067205,     0.000000050444410,     0.000000035917710,     0.000000026824948,     0.000000020836974,
     0.000000016717833,     0.221349310254475,     0.006904217125553,     0.000646055588503,     0.000100753859428,     0.000021995252861,     0.000006171181113,     0.000002113967030,     0.000000853785469,     0.000000396056543,
     0.000000206604865,     0.000000119035658,     0.000000074564552,     0.000000050086570,     0.000000035650499,     0.000000026617412,     0.000000020670483,     0.000000016580652,     0.221280300369216,     0.006897761603697,
     0.000645049148644,     0.000100534215106,     0.000021933646607,     0.000006150084066,     0.000002105448944,     0.000000849835214,     0.000000393996434,     0.000000205418229,     0.000000118292510,     0.000000074065465,
     0.000000049731393,     0.000000035385356,     0.000000026411534,     0.000000020505357,     0.000000016444622,     0.221211354988889,     0.006891316135269,     0.000644044902151,     0.000100315185794,     0.000021872250897,
     0.000006129072003,     0.000002096970257,     0.000000845905501,     0.000000391948154,     0.000000204238998,     0.000000117554336,     0.000000073569916,     0.000000049378856,     0.000000035122263,     0.000000026207300,
     0.000000020341587,     0.000000016309733,     0.221142474013072,     0.006884880698364,     0.000643042842885,     0.000100096769389,     0.000021811064884,     0.000006108144531,     0.000002088530766,     0.000000841996212,
     0.000000389911629,     0.000000203067125,     0.000000116821100,     0.000000073077879,     0.000000049028941,     0.000000034861204,     0.000000026004697,     0.000000020179159,     0.000000016175974,     0.221073657341557,
     0.006878455271140,     0.000642042964727,     0.000099878963800,     0.000021750087726,     0.000006087301258,     0.000002080130266,     0.000000838107229,     0.000000387886787,     0.000000201902560,     0.000000116092767,
     0.000000072589328,     0.000000048681626,     0.000000034602164,     0.000000025803712,     0.000000020018063,     0.000000016043337,     0.221004904874356,     0.006872039831819,     0.000641045261580,     0.000099661766941,
     0.000021689318580,     0.000006066541796,     0.000002071768554,     0.000000834238437,     0.000000385873554,     0.000000200745254,     0.000000115369302,     0.000000072104238,     0.000000048336891,     0.000000034345125,
     0.000000025604332,     0.000000019858289,     0.000000015911812,     0.220936216511700,     0.006865634358679,     0.000640049727366,     0.000099445176738,     0.000021628756612,     0.000006045865758,     0.000002063445430,
     0.000000830389720,     0.000000383871858,     0.000000199595158,     0.000000114650671,     0.000000071622582,     0.000000047994717,     0.000000034090072,     0.000000025406542,     0.000000019699824,     0.000000015781390,
     0.220867592154034,     0.006859238830062,     0.000639056356029,     0.000099229191121,     0.000021568400988,     0.000006025272759,     0.000002055160693,     0.000000826560962,     0.000000381881627,     0.000000198452224,
     0.000000113936839,     0.000000071144335,     0.000000047655083,     0.000000033836989,     0.000000025210331,     0.000000019542657,     0.000000015652060,     0.220799031702022,     0.006852853224369,     0.000638065141535,
     0.000099013808033,     0.000021508250881,     0.000006004762417,     0.000002046914145,     0.000000822752049,     0.000000379902790,     0.000000197316405,     0.000000113227773,     0.000000070669472,     0.000000047317970,
     0.000000033585860,     0.000000025015685,     0.000000019386779,     0.000000015523814,     0.220730535056542,     0.006846477520062,     0.000637076077867,     0.000098799025422,     0.000021448305465,     0.000005984334350,
     0.000002038705586,     0.000000818962868,     0.000000377935275,     0.000000196187653,     0.000000112523439,     0.000000070197967,     0.000000046983359,     0.000000033336670,     0.000000024822591,     0.000000019232177,
     0.000000015396642,     0.220662102118688,     0.006840111695662,     0.000636089159032,     0.000098584841244,     0.000021388563921,     0.000005963988179,     0.000002030534822,     0.000000815193306,     0.000000375979013,
     0.000000195065921,     0.000000111823803,     0.000000069729796,     0.000000046651230,     0.000000033089403,     0.000000024631037,     0.000000019078842,     0.000000015270536,     0.220593732789767,     0.006833755729752,
     0.000635104379054,     0.000098371253466,     0.000021329025430,     0.000005943723528,     0.000002022401655,     0.000000811443251,     0.000000374033934,     0.000000193951161,     0.000000111128832,     0.000000069264934,
     0.000000046321565,     0.000000032844044,     0.000000024441010,     0.000000018926763,     0.000000015145486,     0.220525426971302,     0.006827409600972,     0.000634121731981,     0.000098158260061,     0.000021269689180,
     0.000005923540022,     0.000002014305892,     0.000000807712591,     0.000000372099967,     0.000000192843329,     0.000000110438493,     0.000000068803357,     0.000000045994343,     0.000000032600578,     0.000000024252498,
     0.000000018775929,     0.000000015021482,     0.220457184565028,     0.006821073288022,     0.000633141211879,     0.000097945859011,     0.000021210554360,     0.000005903437286,     0.000002006247339,     0.000000804001215,
     0.000000370177044,     0.000000191742376,     0.000000109752754,     0.000000068345040,     0.000000045669547,     0.000000032358989,     0.000000024065487,     0.000000018626330,     0.000000014898517,     0.220389005472893,
     0.006814746769664,     0.000632162812833,     0.000097734048305,     0.000021151620166,     0.000005883414951,     0.000001998225804,     0.000000800309013,     0.000000368265097,     0.000000190648258,     0.000000109071581,
     0.000000067889958,     0.000000045347157,     0.000000032119263,     0.000000023879967,     0.000000018477955,     0.000000014776582,     0.220320889597057,     0.006808430024715,     0.000631186528951,     0.000097522825942,
     0.000021092885795,     0.000005863472647,     0.000001990241095,     0.000000796635876,     0.000000366364056,     0.000000189560930,     0.000000108394944,     0.000000067438088,     0.000000045027156,     0.000000031881385,
     0.000000023695924,     0.000000018330795,     0.000000014655666,     0.220252836839891,     0.006802123032054,     0.000630212354360,     0.000097312189926,     0.000021034350448,     0.000005843610007,     0.000001982293023,
     0.000000792981696,     0.000000364473856,     0.000000188480345,     0.000000107722809,     0.000000066989407,     0.000000044709523,     0.000000031645340,     0.000000023513347,     0.000000018184839,     0.000000014535763,
     0.220184847103978,     0.006795825770616,     0.000629240283205,     0.000097102138272,     0.000020976013330,     0.000005823826666,     0.000001974381399,     0.000000789346363,     0.000000362594427,     0.000000187406458,
     0.000000107055145,     0.000000066543890,     0.000000044394243,     0.000000031411113,     0.000000023332224,     0.000000018040076,     0.000000014416863,     0.220116920292112,     0.006789538219398,     0.000628270309653,
     0.000096892669001,     0.000020917873651,     0.000005804122258,     0.000001966506033,     0.000000785729772,     0.000000360725704,     0.000000186339227,     0.000000106391921,     0.000000066101514,     0.000000044081295,
     0.000000031178690,     0.000000023152542,     0.000000017896498,     0.000000014298957,     0.220049056307293,     0.006783260357451,     0.000627302427890,     0.000096683780144,     0.000020859930623,     0.000005784496425,
     0.000001958666741,     0.000000782131814,     0.000000358867621,     0.000000185278605,     0.000000105733104,     0.000000065662256,     0.000000043770663,     0.000000030948057,     0.000000022974290,     0.000000017754094,
     0.000000014182038,     0.219981255052735,     0.006776992163887,     0.000626336632122,     0.000096475469736,     0.000020802183462,     0.000005764948804,     0.000001950863335,     0.000000778552384,     0.000000357020110,
     0.000000184224550,     0.000000105078665,     0.000000065226093,     0.000000043462328,     0.000000030719200,     0.000000022797456,     0.000000017612854,     0.000000014066097,     0.219913516431857,     0.006770733617874,
     0.000625372916574,     0.000096267735824,     0.000020744631387,     0.000005745479039,     0.000001943095632,     0.000000774991377,     0.000000355183108,     0.000000183177018,     0.000000104428572,     0.000000064793002,
     0.000000043156273,     0.000000030492104,     0.000000022622029,     0.000000017472769,     0.000000013951125,     0.219845840348288,     0.006764484698640,     0.000624411275490,     0.000096060576461,     0.000020687273623,
     0.000005726086773,     0.000001935363447,     0.000000771448687,     0.000000353356548,     0.000000182135964,     0.000000103782795,     0.000000064362960,     0.000000042852480,     0.000000030266755,     0.000000022447997,
     0.000000017333828,     0.000000013837114,     0.219778226705864,     0.006758245385469,     0.000623451703136,     0.000095853989706,     0.000020630109395,     0.000005706771652,     0.000001927666597,     0.000000767924211,
     0.000000351540367,     0.000000181101347,     0.000000103141303,     0.000000063935945,     0.000000042550932,     0.000000030043139,     0.000000022275348,     0.000000017196023,     0.000000013724056,     0.219710675408627,
     0.006752015657701,     0.000622494193794,     0.000095647973630,     0.000020573137934,     0.000005687533324,     0.000001920004902,     0.000000764417845,     0.000000349734500,     0.000000180073124,     0.000000102504066,
     0.000000063511934,     0.000000042251612,     0.000000029821243,     0.000000022104072,     0.000000017059344,     0.000000013611943,     0.219643186360827,     0.006745795494735,     0.000621538741767,     0.000095442526308,
     0.000020516358474,     0.000005668371438,     0.000001912378181,     0.000000760929487,     0.000000347938884,     0.000000179051252,     0.000000101871054,     0.000000063090906,     0.000000041954502,     0.000000029601053,
     0.000000021934158,     0.000000016923781,     0.000000013500767,     0.219575759466918,     0.006739584876027,     0.000620585341378,     0.000095237645823,     0.000020459770251,     0.000005649285644,     0.000001904786253,
     0.000000757459034,     0.000000346153454,     0.000000178035689,     0.000000101242238,     0.000000062672837,     0.000000041659585,     0.000000029382555,     0.000000021765593,     0.000000016789326,     0.000000013390519,
     0.219508394631561,     0.006733383781088,     0.000619633986968,     0.000095033330268,     0.000020403372508,     0.000005630275597,     0.000001897228941,     0.000000754006384,     0.000000344378149,     0.000000177026393,
     0.000000100617588,     0.000000062257707,     0.000000041366845,     0.000000029165737,     0.000000021598368,     0.000000016655968,     0.000000013281193,     0.219441091759619,     0.006727192189486,     0.000618684672896,
     0.000094829577741,     0.000020347164488,     0.000005611340951,     0.000001889706066,     0.000000750571437,     0.000000342612905,     0.000000176023323,     0.000000099997074,     0.000000061845493,     0.000000041076265,
     0.000000028950584,     0.000000021432470,     0.000000016523699,     0.000000013172780,     0.219373850756161,     0.006721010080847,     0.000617737393543,     0.000094626386348,     0.000020291145439,     0.000005592481362,
     0.000001882217453,     0.000000747154093,     0.000000340857662,     0.000000175026438,     0.000000099380668,     0.000000061436174,     0.000000040787828,     0.000000028737083,     0.000000021267890,     0.000000016392509,
     0.000000013065272,     0.219306671526460,     0.006714837434852,     0.000616792143305,     0.000094423754204,     0.000020235314612,     0.000005573696488,     0.000001874762926,     0.000000743754251,     0.000000339112356,
     0.000000174035696,     0.000000098768341,     0.000000061029729,     0.000000040501518,     0.000000028525221,     0.000000021104616,     0.000000016262390,     0.000000012958662,     0.219239553975990,     0.006708674231236,
     0.000615848916601,     0.000094221679431,     0.000020179671261,     0.000005554985990,     0.000001867342310,     0.000000740371813,     0.000000337376927,     0.000000173051058,     0.000000098160064,     0.000000060626137,
     0.000000040217318,     0.000000028314986,     0.000000020942639,     0.000000016133333,     0.000000012852941,     0.219172498010428,     0.006702520449793,     0.000614907707865,     0.000094020160157,     0.000020124214645,
     0.000005536349529,     0.000001859955432,     0.000000737006679,     0.000000335651315,     0.000000172072482,     0.000000097555809,     0.000000060225376,     0.000000039935213,     0.000000028106364,     0.000000020781946,
     0.000000016005329,     0.000000012748104,     0.219105503535654,     0.006696376070371,     0.000613968511552,     0.000093819194518,     0.000020068944025,     0.000005517786770,     0.000001852602119,     0.000000733658754,
     0.000000333935458,     0.000000171099928,     0.000000096955547,     0.000000059827426,     0.000000039655185,     0.000000027899343,     0.000000020622529,     0.000000015878368,     0.000000012644141,     0.219038570457747,
     0.006690241072872,     0.000613031322135,     0.000093618780659,     0.000020013858665,     0.000005499297376,     0.000001845282200,     0.000000730327938,     0.000000332229296,     0.000000170133358,     0.000000096359251,
     0.000000059432265,     0.000000039377220,     0.000000027693910,     0.000000020464375,     0.000000015752443,     0.000000012541045,     0.218971698682990,     0.006684115437257,     0.000612096134106,     0.000093418916730,
     0.000019958957834,     0.000005480881015,     0.000001837995504,     0.000000727014136,     0.000000330532771,     0.000000169172730,     0.000000095766893,     0.000000059039874,     0.000000039101302,     0.000000027490051,
     0.000000020307476,     0.000000015627544,     0.000000012438810,     0.218904888117862,     0.006677999143537,     0.000611162941974,     0.000093219600889,     0.000019904240803,     0.000005462537355,     0.000001830741861,
     0.000000723717251,     0.000000328845822,     0.000000168218007,     0.000000095178445,     0.000000058650233,     0.000000038827414,     0.000000027287756,     0.000000020151821,     0.000000015503664,     0.000000012337427,
     0.218838138669046,     0.006671892171782,     0.000610231740267,     0.000093020831303,     0.000019849706846,     0.000005444266068,     0.000001823521103,     0.000000720437187,     0.000000327168391,     0.000000167269148,
     0.000000094593879,     0.000000058263319,     0.000000038555542,     0.000000027087011,     0.000000019997400,     0.000000015380793,     0.000000012236890,     0.218771450243420,     0.006665794502115,     0.000609302523533,
     0.000092822606145,     0.000019795355241,     0.000005426066824,     0.000001816333061,     0.000000717173851,     0.000000325500420,     0.000000166326116,     0.000000094013169,     0.000000057879115,     0.000000038285669,
     0.000000026887804,     0.000000019844202,     0.000000015258923,     0.000000012137191,     0.218704822748063,     0.006659706114713,     0.000608375286336,     0.000092624923593,     0.000019741185270,     0.000005407939298,
     0.000001809177570,     0.000000713927148,     0.000000323841850,     0.000000165388872,     0.000000093436288,     0.000000057497599,     0.000000038017780,     0.000000026690123,     0.000000019692218,     0.000000015138046,
     0.000000012038324,     0.218638256090251,     0.006653626989808,     0.000607450023258,     0.000092427781836,     0.000019687196217,     0.000005389883165,     0.000001802054463,     0.000000710696983,     0.000000322192623,
     0.000000164457378,     0.000000092863208,     0.000000057118753,     0.000000037751861,     0.000000026493955,     0.000000019541438,     0.000000015018154,     0.000000011940281,     0.218571750177457,     0.006647557107686,
     0.000606526728902,     0.000092231179068,     0.000019633387370,     0.000005371898102,     0.000001794963576,     0.000000707483264,     0.000000320552683,     0.000000163531595,     0.000000092293904,     0.000000056742556,
     0.000000037487896,     0.000000026299290,     0.000000019391852,     0.000000014899238,     0.000000011843054,     0.218505304917353,     0.006641496448686,     0.000605605397886,     0.000092035113490,     0.000019579758019,
     0.000005353983787,     0.000001787904743,     0.000000704285899,     0.000000318921972,     0.000000162611487,     0.000000091728348,     0.000000056368988,     0.000000037225871,     0.000000026106115,     0.000000019243450,
     0.000000014781290,     0.000000011746638,     0.218438920217805,     0.006635444993201,     0.000604686024848,     0.000091839583312,     0.000019526307460,     0.000005336139900,     0.000001780877803,     0.000000701104794,
     0.000000317300434,     0.000000161697016,     0.000000091166515,     0.000000055998032,     0.000000036965769,     0.000000025914417,     0.000000019096223,     0.000000014664303,     0.000000011651026,     0.218372595986876,
     0.006629402721680,     0.000603768604441,     0.000091644586748,     0.000019473034988,     0.000005318366125,     0.000001773882594,     0.000000697939860,     0.000000315688013,     0.000000160788145,     0.000000090608379,
     0.000000055629667,     0.000000036707577,     0.000000025724186,     0.000000018950161,     0.000000014548267,     0.000000011556209,     0.218306332132823,     0.006623369614622,     0.000602853131340,     0.000091450122021,
     0.000019419939904,     0.000005300662143,     0.000001766918953,     0.000000694791004,     0.000000314084653,     0.000000159884836,     0.000000090053914,     0.000000055263874,     0.000000036451281,     0.000000025535410,
     0.000000018805254,     0.000000014433176,     0.000000011462183,     0.218240128564100,     0.006617345652580,     0.000601939600234,     0.000091256187361,     0.000019367021513,     0.000005283027641,     0.000001759986720,
     0.000000691658137,     0.000000312490298,     0.000000158987054,     0.000000089503093,     0.000000054900635,     0.000000036196864,     0.000000025348077,     0.000000018661494,     0.000000014319021,     0.000000011368940,
     0.218173985189353,     0.006611330816161,     0.000601028005832,     0.000091062781004,     0.000019314279121,     0.000005265462305,     0.000001753085737,     0.000000688541168,     0.000000310904894,     0.000000158094762,
     0.000000088955892,     0.000000054539931,     0.000000035944314,     0.000000025162176,     0.000000018518871,     0.000000014205794,     0.000000011276472,     0.218107901917422,     0.006605325086025,     0.000600118342859,
     0.000090869901194,     0.000019261712038,     0.000005247965823,     0.000001746215844,     0.000000685440009,     0.000000309328385,     0.000000157207924,     0.000000088412286,     0.000000054181742,     0.000000035693616,
     0.000000024977696,     0.000000018377375,     0.000000014093489,     0.000000011184775,     0.218041878657343,     0.006599328442883,     0.000599210606059,     0.000090677546181,     0.000019209319576,     0.000005230537885,
     0.000001739376884,     0.000000682354571,     0.000000307760717,     0.000000156326505,     0.000000087872249,     0.000000053826052,     0.000000035444756,     0.000000024794625,     0.000000018236998,     0.000000013982096,
     0.000000011093841,     0.217975915318339,     0.006593340867501,     0.000598304790192,     0.000090485714222,     0.000019157101052,     0.000005213178182,     0.000001732568701,     0.000000679284765,     0.000000306201837,
     0.000000155450468,     0.000000087335757,     0.000000053472841,     0.000000035197719,     0.000000024612952,     0.000000018097730,     0.000000013871609,     0.000000011003664,     0.217910011809831,     0.006587362340694,
     0.000597400890036,     0.000090294403582,     0.000019105055786,     0.000005195886409,     0.000001725791137,     0.000000676230505,     0.000000304651690,     0.000000154579778,     0.000000086802784,     0.000000053122092,
     0.000000034952492,     0.000000024432667,     0.000000017959563,     0.000000013762021,     0.000000010914237,     0.217844168041427,     0.006581392843332,     0.000596498900388,     0.000090103612532,     0.000019053183099,
     0.000005178662258,     0.000001719044039,     0.000000673191703,     0.000000303110223,     0.000000153714400,     0.000000086273307,     0.000000052773785,     0.000000034709061,     0.000000024253758,     0.000000017822487,
     0.000000013653322,     0.000000010825554,     0.217778383922929,     0.006575432356335,     0.000595598816060,     0.000089913339347,     0.000019001482316,     0.000005161505427,     0.000001712327252,     0.000000670168272,
     0.000000301577384,     0.000000152854300,     0.000000085747300,     0.000000052427905,     0.000000034467412,     0.000000024076214,     0.000000017686493,     0.000000013545507,     0.000000010737609,     0.217712659364329,
     0.006569480860677,     0.000594700631881,     0.000089723582314,     0.000018949952767,     0.000005144415613,     0.000001705640623,     0.000000667160126,     0.000000300053120,     0.000000151999443,     0.000000085224741,
     0.000000052084431,     0.000000034227532,     0.000000023900024,     0.000000017551574,     0.000000013438568,     0.000000010650395,     0.217646994275808,     0.006563538337381,     0.000593804342698,     0.000089534339724,
     0.000018898593782,     0.000005127392514,     0.000001698983999,     0.000000664167181,     0.000000298537378,     0.000000151149794,     0.000000084705604,     0.000000051743348,     0.000000033989407,     0.000000023725179,
     0.000000017417719,     0.000000013332497,     0.000000010563906,     0.217581388567737,     0.006557604767523,     0.000592909943377,     0.000089345609872,     0.000018847404695,     0.000005110435833,     0.000001692357229,
     0.000000661189351,     0.000000297030107,     0.000000150305319,     0.000000084189866,     0.000000051404637,     0.000000033753024,     0.000000023551666,     0.000000017284921,     0.000000013227287,     0.000000010478137,
     0.217515842150676,     0.006551680132231,     0.000592017428798,     0.000089157391065,     0.000018796384845,     0.000005093545271,     0.000001685760162,     0.000000658226551,     0.000000295531254,     0.000000149465985,
     0.000000083677503,     0.000000051068282,     0.000000033518370,     0.000000023379477,     0.000000017153170,     0.000000013122932,     0.000000010393080,     0.217450354935373,     0.006545764412682,     0.000591126793858,
     0.000088969681614,     0.000018745533570,     0.000005076720531,     0.000001679192648,     0.000000655278698,     0.000000294040770,     0.000000148631758,     0.000000083168492,     0.000000050734264,     0.000000033285430,
     0.000000023208599,     0.000000017022459,     0.000000013019423,     0.000000010308731,     0.217384926832766,     0.006539857590105,     0.000590238033473,     0.000088782479834,     0.000018694850216,     0.000005059961320,
     0.000001672654538,     0.000000652345708,     0.000000292558602,     0.000000147802604,     0.000000082662810,     0.000000050402567,     0.000000033054193,     0.000000023039024,     0.000000016892779,     0.000000012916755,
     0.000000010225082,     0.217319557753977,     0.006533959645781,     0.000589351142575,     0.000088595784052,     0.000018644334127,     0.000005043267343,     0.000001666145684,     0.000000649427498,     0.000000291084701,
     0.000000146978491,     0.000000082160433,     0.000000050073175,     0.000000032824645,     0.000000022870740,     0.000000016764121,     0.000000012814919,     0.000000010142128,     0.217254247610318,     0.006528070561039,
     0.000588466116111,     0.000088409592596,     0.000018593984652,     0.000005026638309,     0.000001659665939,     0.000000646523986,     0.000000289619016,     0.000000146159385,     0.000000081661339,     0.000000049746069,
     0.000000032596774,     0.000000022703738,     0.000000016636478,     0.000000012713910,     0.000000010059863,     0.217188996313286,     0.006522190317260,     0.000587582949047,     0.000088223903805,     0.000018543801145,
     0.000005010073928,     0.000001653215156,     0.000000643635091,     0.000000288161497,     0.000000145345253,     0.000000081165504,     0.000000049421234,     0.000000032370566,     0.000000022538007,     0.000000016509840,
     0.000000012613720,     0.000000009978282,     0.217123803774565,     0.006516318895877,     0.000586701636365,     0.000088038716022,     0.000018493782959,     0.000004993573910,     0.000001646793189,     0.000000640760729,
     0.000000286712094,     0.000000144536064,     0.000000080672907,     0.000000049098652,     0.000000032146010,     0.000000022373538,     0.000000016384201,     0.000000012514342,     0.000000009897378,     0.217058669906022,
     0.006510456278369,     0.000585822173062,     0.000087854027597,     0.000018443929453,     0.000004977137968,     0.000001640399893,     0.000000637900822,     0.000000285270759,     0.000000143731784,     0.000000080183524,
     0.000000048778308,     0.000000031923091,     0.000000022210320,     0.000000016259551,     0.000000012415770,     0.000000009817146,     0.216993594619713,     0.006504602446267,     0.000584944554154,     0.000087669836887,
     0.000018394239987,     0.000004960765817,     0.000001634035125,     0.000000635055287,     0.000000283837442,     0.000000142932383,     0.000000079697333,     0.000000048460185,     0.000000031701799,     0.000000022048344,
     0.000000016135883,     0.000000012317997,     0.000000009737580,     0.216928577827874,     0.006498757381154,     0.000584068774671,     0.000087486142253,     0.000018344713925,     0.000004944457171,     0.000001627698740,
     0.000000632224046,     0.000000282412095,     0.000000142137827,     0.000000079214313,     0.000000048144267,     0.000000031482121,     0.000000021887599,     0.000000016013188,     0.000000012221016,     0.000000009658674,
     0.216863619442928,     0.006492921064659,     0.000583194829661,     0.000087302942066,     0.000018295350633,     0.000004928211748,     0.000001621390596,     0.000000629407019,     0.000000280994670,     0.000000141348086,
     0.000000078734441,     0.000000047830537,     0.000000031264043,     0.000000021728077,     0.000000015891460,     0.000000012124821,     0.000000009580423,     0.216798719377480,     0.006487093478462,     0.000582322714187,
     0.000087120234700,     0.000018246149480,     0.000004912029266,     0.000001615110552,     0.000000626604127,     0.000000279585118,     0.000000140563128,     0.000000078257695,     0.000000047518980,     0.000000031047555,
     0.000000021569767,     0.000000015770689,     0.000000012029405,     0.000000009502822,     0.216733877544318,     0.006481274604293,     0.000581452423329,     0.000086938018538,     0.000018197109839,     0.000004895909444,
     0.000001608858467,     0.000000623815291,     0.000000278183391,     0.000000139782922,     0.000000077784054,     0.000000047209581,     0.000000030832644,     0.000000021412660,     0.000000015650869,     0.000000011934762,
     0.000000009425864,     0.216669093856414,     0.006475464423930,     0.000580583952184,     0.000086756291967,     0.000018148231084,     0.000004879852004,     0.000001602634200,     0.000000621040433,     0.000000276789444,
     0.000000139007437,     0.000000077313496,     0.000000046902322,     0.000000030619298,     0.000000021256746,     0.000000015531992,     0.000000011840886,     0.000000009349544,     0.216604368226921,     0.006469662919200,
     0.000579717295863,     0.000086575053382,     0.000018099512592,     0.000004863856668,     0.000001596437612,     0.000000618279476,     0.000000275403227,     0.000000138236642,     0.000000076846000,     0.000000046597190,
     0.000000030407505,     0.000000021102017,     0.000000015414049,     0.000000011747769,     0.000000009273858,     0.216539700569172,     0.006463870071980,     0.000578852449495,     0.000086394301183,     0.000018050953744,
     0.000004847923160,     0.000001590268564,     0.000000615532343,     0.000000274024695,     0.000000137470506,     0.000000076381545,     0.000000046294167,     0.000000030197254,     0.000000020948462,     0.000000015297034,
     0.000000011655407,     0.000000009198799,     0.216475090796683,     0.006458085864193,     0.000577989408224,     0.000086214033777,     0.000018002553923,     0.000004832051205,     0.000001584126919,     0.000000612798957,
     0.000000272653802,     0.000000136709001,     0.000000075920110,     0.000000045993240,     0.000000029988532,     0.000000020796073,     0.000000015180938,     0.000000011563791,     0.000000009124362,     0.216410538823150,
     0.006452310277814,     0.000577128167209,     0.000086034249576,     0.000017954312516,     0.000004816240530,     0.000001578012540,     0.000000610079241,     0.000000271290500,     0.000000135952094,     0.000000075461674,
     0.000000045694391,     0.000000029781328,     0.000000020644840,     0.000000015065755,     0.000000011472917,     0.000000009050542,     0.216346044562449,     0.006446543294864,     0.000576268721627,     0.000085854947000,
     0.000017906228909,     0.000004800490864,     0.000001571925289,     0.000000607373121,     0.000000269934744,     0.000000135199757,     0.000000075006215,     0.000000045397608,     0.000000029575631,     0.000000020494755,
     0.000000014951478,     0.000000011382779,     0.000000008977334,     0.216281607928635,     0.006440784897413,     0.000575411066669,     0.000085676124474,     0.000017858302496,     0.000004784801935,     0.000001565865032,
     0.000000604680522,     0.000000268586490,     0.000000134451960,     0.000000074553715,     0.000000045102874,     0.000000029371429,     0.000000020345808,     0.000000014838097,     0.000000011293369,     0.000000008904733,
     0.216217228835942,     0.006435035067578,     0.000574555197542,     0.000085497780429,     0.000017810532669,     0.000004769173473,     0.000001559831634,     0.000000602001367,     0.000000267245690,     0.000000133708673,
     0.000000074104151,     0.000000044810174,     0.000000029168711,     0.000000020197990,     0.000000014725608,     0.000000011204682,     0.000000008832733,     0.216152907198784,     0.006429293787525,     0.000573701109470,
     0.000085319913301,     0.000017762918826,     0.000004753605213,     0.000001553824960,     0.000000599335583,     0.000000265912301,     0.000000132969867,     0.000000073657504,     0.000000044519495,     0.000000028967466,
     0.000000020051293,     0.000000014614001,     0.000000011116712,     0.000000008761329,     0.216088642931751,     0.006423561039468,     0.000572848797692,     0.000085142521534,     0.000017715460365,     0.000004738096886,
     0.000001547844878,     0.000000596683096,     0.000000264586278,     0.000000132235513,     0.000000073213755,     0.000000044230820,     0.000000028767682,     0.000000019905707,     0.000000014503271,     0.000000011029453,
     0.000000008690517,     0.216024435949614,     0.006417836805666,     0.000571998257460,     0.000084965603578,     0.000017668156689,     0.000004722648227,     0.000001541891254,     0.000000594043833,     0.000000263267576,
     0.000000131505583,     0.000000072772881,     0.000000043944136,     0.000000028569348,     0.000000019761224,     0.000000014393410,     0.000000010942900,     0.000000008620291,     0.215960286167316,     0.006412121068429,
     0.000571149484046,     0.000084789157886,     0.000017621007203,     0.000004707258973,     0.000001535963957,     0.000000591417720,     0.000000261956152,     0.000000130780046,     0.000000072334865,     0.000000043659428,
     0.000000028372454,     0.000000019617836,     0.000000014284411,     0.000000010857046,     0.000000008550647,     0.215896193499982,     0.006406413810112,     0.000570302472734,     0.000084613182921,     0.000017574011313,
     0.000004691928861,     0.000001530062856,     0.000000588804686,     0.000000260651961,     0.000000130058876,     0.000000071899686,     0.000000043376682,     0.000000028176988,     0.000000019475533,     0.000000014176267,
     0.000000010771885,     0.000000008481579,     0.215832157862909,     0.006400715013117,     0.000569457218824,     0.000084437677150,     0.000017527168429,     0.000004676657629,     0.000001524187820,     0.000000586204657,
     0.000000259354960,     0.000000129342043,     0.000000071467325,     0.000000043095884,     0.000000027982939,     0.000000019334308,     0.000000014068971,     0.000000010687412,     0.000000008413083,     0.215768179171573,
     0.006395024659893,     0.000568613717632,     0.000084262639045,     0.000017480477965,     0.000004661445018,     0.000001518338720,     0.000000583617563,     0.000000258065105,     0.000000128629520,     0.000000071037762,
     0.000000042817019,     0.000000027790298,     0.000000019194151,     0.000000013962516,     0.000000010603621,     0.000000008345153,     0.215704257341624,     0.006389342732937,     0.000567771964489,     0.000084088067085,
     0.000017433939334,     0.000004646290768,     0.000001512515426,     0.000000581043332,     0.000000256782355,     0.000000127921279,     0.000000070610978,     0.000000042540073,     0.000000027599053,     0.000000019055055,
     0.000000013856896,     0.000000010520507,     0.000000008277786,     0.215640392288885,     0.006383669214792,     0.000566931954741,     0.000083913959754,     0.000017387551956,     0.000004631194624,     0.000001506717811,
     0.000000578481892,     0.000000255506666,     0.000000127217291,     0.000000070186954,     0.000000042265033,     0.000000027409193,     0.000000018917011,     0.000000013752104,     0.000000010438064,     0.000000008210976,
     0.215576583929357,     0.006378004088046,     0.000566093683750,     0.000083740315543,     0.000017341315249,     0.000004616156327,     0.000001500945746,     0.000000575933175,     0.000000254237995,     0.000000126517530,
     0.000000069765671,     0.000000041991885,     0.000000027220709,     0.000000018780010,     0.000000013648133,     0.000000010356286,     0.000000008144718,     0.215512832179211,     0.006372347335336,     0.000565257146892,
     0.000083567132949,     0.000017295228637,     0.000004601175624,     0.000001495199105,     0.000000573397109,     0.000000252976301,     0.000000125821969,     0.000000069347110,     0.000000041720615,     0.000000027033590,
     0.000000018644045,     0.000000013544976,     0.000000010275168,     0.000000008079008,     0.215449136954794,     0.006366698939344,     0.000564422339557,     0.000083394410472,     0.000017249291545,     0.000004586252261,
     0.000001489477762,     0.000000570873626,     0.000000251721542,     0.000000125130579,     0.000000068931253,     0.000000041451209,     0.000000026847825,     0.000000018509108,     0.000000013442627,     0.000000010194704,
     0.000000008013842,     0.215385498172626,     0.006361058882795,     0.000563589257153,     0.000083222146621,     0.000017203503402,     0.000004571385985,     0.000001483781591,     0.000000568362655,     0.000000250473676,
     0.000000124443335,     0.000000068518080,     0.000000041183654,     0.000000026663404,     0.000000018375190,     0.000000013341080,     0.000000010114889,     0.000000007949214,     0.215321915749398,     0.006355427148466,
     0.000562757895101,     0.000083050339910,     0.000017157863636,     0.000004556576545,     0.000001478110467,     0.000000565864129,     0.000000249232661,     0.000000123760209,     0.000000068107574,     0.000000040917936,
     0.000000026480318,     0.000000018242284,     0.000000013240327,     0.000000010035718,     0.000000007885120,     0.215258389601973,     0.006349803719174,     0.000561928248836,     0.000082878988856,     0.000017112371682,
     0.000004541823692,     0.000001472464267,     0.000000563377979,     0.000000247998458,     0.000000123081174,     0.000000067699715,     0.000000040654043,     0.000000026298555,     0.000000018110381,     0.000000013140363,
     0.000000009957185,     0.000000007821556,     0.215194919647388,     0.006344188577785,     0.000561100313810,     0.000082708091985,     0.000017067026975,     0.000004527127177,     0.000001466842867,     0.000000560904138,
     0.000000246771024,     0.000000122406206,     0.000000067294487,     0.000000040391961,     0.000000026118107,     0.000000017979474,     0.000000013041181,     0.000000009879285,     0.000000007758517,     0.215131505802848,
     0.006338581707209,     0.000560274085488,     0.000082537647827,     0.000017021828952,     0.000004512486753,     0.000001461246143,     0.000000558442536,     0.000000245550320,     0.000000121735276,     0.000000066891870,
     0.000000040131676,     0.000000025938962,     0.000000017849555,     0.000000012942775,     0.000000009802013,     0.000000007695999,     0.215068147985731,     0.006332983090401,     0.000559449559349,     0.000082367654919,
     0.000016976777053,     0.000004497902173,     0.000001455673975,     0.000000555993109,     0.000000244336305,     0.000000121068360,     0.000000066491847,     0.000000039873177,     0.000000025761112,     0.000000017720616,
     0.000000012845139,     0.000000009725363,     0.000000007633998,     0.215004846113584,     0.006327392710363,     0.000558626730890,     0.000082198111801,     0.000016931870723,     0.000004483373192,     0.000001450126241,
     0.000000553555788,     0.000000243128940,     0.000000120405431,     0.000000066094401,     0.000000039616450,     0.000000025584547,     0.000000017592649,     0.000000012748266,     0.000000009649331,     0.000000007572508,
     0.214941600104125,     0.006321810550140,     0.000557805595619,     0.000082029017021,     0.000016887109405,     0.000004468899567,     0.000001444602819,     0.000000551130508,     0.000000241928184,     0.000000119746463,
     0.000000065699512,     0.000000039361482,     0.000000025409256,     0.000000017465648,     0.000000012652150,     0.000000009573911,     0.000000007511526,     0.214878409875239,     0.006316236592822,     0.000556986149060,
     0.000081860369131,     0.000016842492548,     0.000004454481055,     0.000001439103591,     0.000000548717203,     0.000000240733997,     0.000000119091432,     0.000000065307165,     0.000000039108260,     0.000000025235231,
     0.000000017339604,     0.000000012556786,     0.000000009499099,     0.000000007451047,     0.214815275344981,     0.006310670821544,     0.000556168386751,     0.000081692166690,     0.000016798019601,     0.000004440117415,
     0.000001433628436,     0.000000546315806,     0.000000239546342,     0.000000118440311,     0.000000064917341,     0.000000038856773,     0.000000025062461,     0.000000017214510,     0.000000012462166,     0.000000009424889,
     0.000000007391067,     0.214752196431577,     0.006305113219487,     0.000555352304246,     0.000081524408262,     0.000016753690017,     0.000004425808406,     0.000001428177235,     0.000000543926254,     0.000000238365178,
     0.000000117793077,     0.000000064530024,     0.000000038607007,     0.000000024890937,     0.000000017090358,     0.000000012368286,     0.000000009351276,     0.000000007331583,     0.214689173053417,     0.006299563769875,
     0.000554537897111,     0.000081357092414,     0.000016709503252,     0.000004411553790,     0.000001422749871,     0.000000541548481,     0.000000237190468,     0.000000117149703,     0.000000064145196,     0.000000038358950,
     0.000000024720651,     0.000000016967141,     0.000000012275139,     0.000000009278255,     0.000000007272589,     0.214626205129060,     0.006294022455975,     0.000553725160927,     0.000081190217722,     0.000016665458761,
     0.000004397353330,     0.000001417346226,     0.000000539182423,     0.000000236022171,     0.000000116510164,     0.000000063762839,     0.000000038112590,     0.000000024551591,     0.000000016844853,     0.000000012182719,
     0.000000009205822,     0.000000007214082,     0.214563292577234,     0.006288489261101,     0.000552914091291,     0.000081023782766,     0.000016621556005,     0.000004383206787,     0.000001411966184,     0.000000536828017,
     0.000000234860252,     0.000000115874438,     0.000000063382938,     0.000000037867914,     0.000000024383750,     0.000000016723485,     0.000000012091020,     0.000000009133972,     0.000000007156057,     0.214500435316830,
     0.006282964168609,     0.000552104683811,     0.000080857786132,     0.000016577794446,     0.000004369113928,     0.000001406609627,     0.000000534485197,     0.000000233704670,     0.000000115242498,     0.000000063005475,
     0.000000037624911,     0.000000024217119,     0.000000016603030,     0.000000012000038,     0.000000009062700,     0.000000007098511,     0.214437633266909,     0.006277447161899,     0.000551296934112,     0.000080692226409,
     0.000016534173549,     0.000004355074517,     0.000001401276442,     0.000000532153902,     0.000000232555389,     0.000000114614320,     0.000000062630434,     0.000000037383568,     0.000000024051687,     0.000000016483481,
     0.000000011909765,     0.000000008992000,     0.000000007041439,     0.214374886346695,     0.006271938224415,     0.000550490837831,     0.000080527102193,     0.000016490692779,     0.000004341088321,     0.000001395966511,
     0.000000529834069,     0.000000231412371,     0.000000113989881,     0.000000062257799,     0.000000037143873,     0.000000023887446,     0.000000016364832,     0.000000011820196,     0.000000008921869,     0.000000006984838,
     0.214312194475578,     0.006266437339645,     0.000549686390621,     0.000080362412088,     0.000016447351606,     0.000004327155109,     0.000001390679722,     0.000000527525634,     0.000000230275579,     0.000000113369156,
     0.000000061887551,     0.000000036905815,     0.000000023724387,     0.000000016247075,     0.000000011731325,     0.000000008852302,     0.000000006928703,     0.214249557573115,     0.006260944491120,     0.000548883588147,
     0.000080198154698,     0.000016404149501,     0.000004313274650,     0.000001385415961,     0.000000525228536,     0.000000229144976,     0.000000112752122,     0.000000061519677,     0.000000036669382,     0.000000023562502,
     0.000000016130203,     0.000000011643148,     0.000000008783294,     0.000000006873031,     0.214186975559023,     0.006255459662414,     0.000548082426089,     0.000080034328636,     0.000016361085937,     0.000004299446714,
     0.000001380175114,     0.000000522942714,     0.000000228020524,     0.000000112138755,     0.000000061154158,     0.000000036434561,     0.000000023401780,     0.000000016014210,     0.000000011555658,     0.000000008714840,
     0.000000006817818,     0.214124448353188,     0.006249982837145,     0.000547282900141,     0.000079870932519,     0.000016318160392,     0.000004285671072,     0.000001374957069,     0.000000520668105,     0.000000226902189,
     0.000000111529031,     0.000000060790980,     0.000000036201342,     0.000000023242214,     0.000000015899088,     0.000000011468849,     0.000000008646936,     0.000000006763059,     0.214061975875657,     0.006244513998972,
     0.000546485006010,     0.000079707964970,     0.000016275372342,     0.000004271947497,     0.000001369761715,     0.000000518404650,     0.000000225789932,     0.000000110922927,     0.000000060430126,     0.000000035969713,
     0.000000023083796,     0.000000015784831,     0.000000011382717,     0.000000008579577,     0.000000006708752,     0.213999558046639,     0.006239053131600,     0.000545688739418,     0.000079545424616,     0.000016232721269,
     0.000004258275762,     0.000001364588939,     0.000000516152287,     0.000000224683718,     0.000000110320421,     0.000000060071581,     0.000000035739662,     0.000000022926515,     0.000000015671431,     0.000000011297256,
     0.000000008512759,     0.000000006654891,     0.213937194786510,     0.006233600218773,     0.000544894096098,     0.000079383310089,     0.000016190206655,     0.000004244655643,     0.000001359438632,     0.000000513910956,
     0.000000223583511,     0.000000109721488,     0.000000059715328,     0.000000035511179,     0.000000022770364,     0.000000015558883,     0.000000011212460,     0.000000008446478,     0.000000006601474,     0.213874886015803,
     0.006228155244281,     0.000544101071801,     0.000079221620029,     0.000016147827985,     0.000004231086915,     0.000001354310683,     0.000000511680597,     0.000000222489276,     0.000000109126107,     0.000000059361352,
     0.000000035284251,     0.000000022615334,     0.000000015447180,     0.000000011128325,     0.000000008380728,     0.000000006548497,     0.213812631655217,     0.006222718191954,     0.000543309662287,     0.000079060353078,
     0.000016105584746,     0.000004217569355,     0.000001349204984,     0.000000509461150,     0.000000221400978,     0.000000108534254,     0.000000059009638,     0.000000035058869,     0.000000022461418,     0.000000015336315,
     0.000000011044844,     0.000000008315506,     0.000000006495956,     0.213750431625610,     0.006217289045667,     0.000542519863334,     0.000078899507885,     0.000016063476428,     0.000004204102742,     0.000001344121424,
     0.000000507252557,     0.000000220318580,     0.000000107945906,     0.000000058660170,     0.000000034835019,     0.000000022308605,     0.000000015226281,     0.000000010962013,     0.000000008250808,     0.000000006443847,
     0.213688285848004,     0.006211867789333,     0.000541731670728,     0.000078739083102,     0.000016021502522,     0.000004190686853,     0.000001339059897,     0.000000505054759,     0.000000219242048,     0.000000107361043,
     0.000000058312932,     0.000000034612693,     0.000000022156889,     0.000000015117072,     0.000000010879826,     0.000000008186628,     0.000000006392167,     0.213626194243577,     0.006206454406912,     0.000540945080275,
     0.000078579077388,     0.000015979662523,     0.000004177321471,     0.000001334020293,     0.000000502867697,     0.000000218171347,     0.000000106779640,     0.000000057967911,     0.000000034391878,     0.000000022006261,
     0.000000015008682,     0.000000010798278,     0.000000008122963,     0.000000006340911,     0.213564156733672,     0.006201048882401,     0.000540160087788,     0.000078419489407,     0.000015937955925,     0.000004164006375,
     0.000001329002507,     0.000000500691313,     0.000000217106443,     0.000000106201677,     0.000000057625090,     0.000000034172564,     0.000000021856713,     0.000000014901105,     0.000000010717365,     0.000000008059808,
     0.000000006290078,     0.213502173239790,     0.006195651199843,     0.000539376689098,     0.000078260317826,     0.000015896382228,     0.000004150741348,     0.000001324006432,     0.000000498525549,     0.000000216047302,
     0.000000105627131,     0.000000057284454,     0.000000033954740,     0.000000021708236,     0.000000014794333,     0.000000010637080,     0.000000007997160,     0.000000006239662,     0.213440243683589,     0.006190261343320,
     0.000538594880048,     0.000078101561321,     0.000015854940932,     0.000004137526174,     0.000001319031961,     0.000000496370348,     0.000000214993890,     0.000000105055981,     0.000000056945990,     0.000000033738396,
     0.000000021560824,     0.000000014688361,     0.000000010557420,     0.000000007935014,     0.000000006189661,     0.213378367986889,     0.006184879296957,     0.000537814656493,     0.000077943218568,     0.000015813631539,
     0.000004124360637,     0.000001314078990,     0.000000494225652,     0.000000213946171,     0.000000104488204,     0.000000056609682,     0.000000033523520,     0.000000021414467,     0.000000014583183,     0.000000010478379,
     0.000000007873366,     0.000000006140071,     0.213316546071669,     0.006179505044919,     0.000537036014302,     0.000077785288252,     0.000015772453555,     0.000004111244523,     0.000001309147413,     0.000000492091405,
     0.000000212904114,     0.000000103923780,     0.000000056275515,     0.000000033310103,     0.000000021269157,     0.000000014478791,     0.000000010399951,     0.000000007812211,     0.000000006090889,     0.213254777860062,
     0.006174138571414,     0.000536258949357,     0.000077627769061,     0.000015731406485,     0.000004098177618,     0.000001304237127,     0.000000489967551,     0.000000211867685,     0.000000103362687,     0.000000055943475,
     0.000000033098134,     0.000000021124888,     0.000000014375181,     0.000000010322133,     0.000000007751546,     0.000000006042111,     0.213193063274364,     0.006168779860688,     0.000535483457555,     0.000077470659687,
     0.000015690489839,     0.000004085159710,     0.000001299348028,     0.000000487854033,     0.000000210836850,     0.000000102804904,     0.000000055613547,     0.000000032887602,     0.000000020981651,     0.000000014272347,
     0.000000010244919,     0.000000007691368,     0.000000005993733,     0.213131402237025,     0.006163428897032,     0.000534709534802,     0.000077313958831,     0.000015649703128,     0.000004072190587,     0.000001294480012,
     0.000000485750796,     0.000000209811576,     0.000000102250409,     0.000000055285718,     0.000000032678497,     0.000000020839439,     0.000000014170281,     0.000000010168304,     0.000000007631670,     0.000000005945753,
     0.213069794670652,     0.006158085664776,     0.000533937177021,     0.000077157665193,     0.000015609045865,     0.000004059270040,     0.000001289632978,     0.000000483657783,     0.000000208791830,     0.000000101699182,
     0.000000054959973,     0.000000032470810,     0.000000020698243,     0.000000014068979,     0.000000010092284,     0.000000007572451,     0.000000005898167,     0.213008240498010,     0.006152750148289,     0.000533166380145,
     0.000077001777483,     0.000015568517566,     0.000004046397858,     0.000001284806822,     0.000000481574941,     0.000000207777581,     0.000000101151203,     0.000000054636297,     0.000000032264529,     0.000000020558057,
     0.000000013968433,     0.000000010016853,     0.000000007513706,     0.000000005850971,     0.212946739642019,     0.006147422331983,     0.000532397140122,     0.000076846294414,     0.000015528117748,     0.000004033573834,
     0.000001280001445,     0.000000479502213,     0.000000206768796,     0.000000100606449,     0.000000054314677,     0.000000032059645,     0.000000020418872,     0.000000013868640,     0.000000009942008,     0.000000007455430,
     0.000000005804164,     0.212885292025755,     0.006142102200310,     0.000531629452912,     0.000076691214702,     0.000015487845930,     0.000004020797760,     0.000001275216745,     0.000000477439547,     0.000000205765442,
     0.000000100064902,     0.000000053995099,     0.000000031856148,     0.000000020280681,     0.000000013769591,     0.000000009867743,     0.000000007397621,     0.000000005757740,     0.212823897572449,     0.006136789737762,
     0.000530863314488,     0.000076536537070,     0.000015447701633,     0.000004008069431,     0.000001270452621,     0.000000475386886,     0.000000204767487,     0.000000099526541,     0.000000053677550,     0.000000031654028,
     0.000000020143477,     0.000000013671283,     0.000000009794054,     0.000000007340274,     0.000000005711697,     0.212762556205488,     0.006131484928871,     0.000530098720835,     0.000076382260246,     0.000015407684382,
     0.000003995388640,     0.000001265708974,     0.000000473344179,     0.000000203774900,     0.000000098991345,     0.000000053362014,     0.000000031453275,     0.000000020007253,     0.000000013573708,     0.000000009720936,
     0.000000007283386,     0.000000005666032,     0.212701267848411,     0.006126187758210,     0.000529335667951,     0.000076228382961,     0.000015367793703,     0.000003982755183,     0.000001260985704,     0.000000471311371,
     0.000000202787650,     0.000000098459294,     0.000000053048480,     0.000000031253880,     0.000000019872001,     0.000000013476862,     0.000000009648385,     0.000000007226952,     0.000000005620742,     0.212640032424914,
     0.006120898210390,     0.000528574151848,     0.000076074903951,     0.000015328029122,     0.000003970168858,     0.000001256282713,     0.000000469288408,     0.000000201805704,     0.000000097930368,     0.000000052736932,
     0.000000031055832,     0.000000019737713,     0.000000013380739,     0.000000009576395,     0.000000007170970,     0.000000005575823,     0.212578849858845,     0.006115616270064,     0.000527814168549,     0.000075921821959,
     0.000015288390169,     0.000003957629462,     0.000001251599903,     0.000000467275239,     0.000000200829032,     0.000000097404548,     0.000000052427359,     0.000000030859122,     0.000000019604384,     0.000000013285332,
     0.000000009504964,     0.000000007115435,     0.000000005531273,     0.212517720074205,     0.006110341921923,     0.000527055714090,     0.000075769135731,     0.000015248876377,     0.000003945136793,     0.000001246937176,
     0.000000465271810,     0.000000199857603,     0.000000096881815,     0.000000052119745,     0.000000030663741,     0.000000019472004,     0.000000013190638,     0.000000009434085,     0.000000007060343,     0.000000005487088,
     0.212456642995150,     0.006105075150699,     0.000526298784519,     0.000075616844016,     0.000015209487278,     0.000003932690651,     0.000001242294435,     0.000000463278070,     0.000000198891385,     0.000000096362147,
     0.000000051814079,     0.000000030469679,     0.000000019340569,     0.000000013096649,     0.000000009363755,     0.000000007005692,     0.000000005443265,     0.212395618545986,     0.006099815941163,     0.000525543375898,
     0.000075464945571,     0.000015170222409,     0.000003920290838,     0.000001237671583,     0.000000461293965,     0.000000197930350,     0.000000095845527,     0.000000051510347,     0.000000030276927,     0.000000019210069,
     0.000000013003361,     0.000000009293970,     0.000000006951477,     0.000000005399801,     0.212334646651172,     0.006094564278124,     0.000524789484301,     0.000075313439155,     0.000015131081308,     0.000003907937154,
     0.000001233068524,     0.000000459319445,     0.000000196974465,     0.000000095331934,     0.000000051208537,     0.000000030085475,     0.000000019080499,     0.000000012910768,     0.000000009224724,     0.000000006897695,
     0.000000005356694,     0.212273727235319,     0.006089320146433,     0.000524037105813,     0.000075162323534,     0.000015092063513,     0.000003895629402,     0.000001228485162,     0.000000457354459,     0.000000196023701,
     0.000000094821349,     0.000000050908634,     0.000000029895314,     0.000000018951852,     0.000000012818864,     0.000000009156015,     0.000000006844342,     0.000000005313939,     0.212212860223189,     0.006084083530977,
     0.000523286236532,     0.000075011597476,     0.000015053168567,     0.000003883367385,     0.000001223921403,     0.000000455398954,     0.000000195078028,     0.000000094313755,     0.000000050610626,     0.000000029706435,
     0.000000018824120,     0.000000012727646,     0.000000009087836,     0.000000006791415,     0.000000005271535,     0.212152045539696,     0.006078854416684,     0.000522536872569,     0.000074861259755,     0.000015014396014,
     0.000003871150909,     0.000001219377152,     0.000000453452881,     0.000000194137416,     0.000000093809131,     0.000000050314501,     0.000000029518828,     0.000000018697296,     0.000000012637106,     0.000000009020185,
     0.000000006738910,     0.000000005229478,     0.212091283109902,     0.006073632788521,     0.000521789010046,     0.000074711309149,     0.000014975745398,     0.000003858979778,     0.000001214852314,     0.000000451516189,
     0.000000193201835,     0.000000093307459,     0.000000050020245,     0.000000029332486,     0.000000018571375,     0.000000012547240,     0.000000008953057,     0.000000006686824,     0.000000005187766,     0.212030572859021,
     0.006068418631492,     0.000521042645099,     0.000074561744442,     0.000014937216268,     0.000003846853798,     0.000001210346797,     0.000000449588828,     0.000000192271257,     0.000000092808720,     0.000000049727847,
     0.000000029147398,     0.000000018446349,     0.000000012458043,     0.000000008886447,     0.000000006635153,     0.000000005146395,     0.211969914712418,     0.006063211930640,     0.000520297773875,     0.000074412564420,
     0.000014898808172,     0.000003834772777,     0.000001205860506,     0.000000447670748,     0.000000191345651,     0.000000092312895,     0.000000049437293,     0.000000028963556,     0.000000018322212,     0.000000012369510,
     0.000000008820352,     0.000000006583895,     0.000000005105363,     0.211909308595604,     0.006058012671048,     0.000519554392533,     0.000074263767876,     0.000014860520663,     0.000003822736524,     0.000001201393351,
     0.000000445761899,     0.000000190424989,     0.000000091819968,     0.000000049148572,     0.000000028780951,     0.000000018198957,     0.000000012281634,     0.000000008754768,     0.000000006533045,     0.000000005064667,
     0.211848754434242,     0.006052820837836,     0.000518812497243,     0.000074115353606,     0.000014822353293,     0.000003810744847,     0.000001196945238,     0.000000443862231,     0.000000189509242,     0.000000091329918,
     0.000000048861670,     0.000000028599574,     0.000000018076577,     0.000000012194413,     0.000000008689690,     0.000000006482600,     0.000000005024304,     0.211788252154143,     0.006047636416162,     0.000518072084190,
     0.000073967320411,     0.000014784305618,     0.000003798797556,     0.000001192516076,     0.000000441971697,     0.000000188598381,     0.000000090842728,     0.000000048576576,     0.000000028419416,     0.000000017955066,
     0.000000012107839,     0.000000008625114,     0.000000006432558,     0.000000004984270,     0.211727801681263,     0.006042459391224,     0.000517333149569,     0.000073819667097,     0.000014746377195,     0.000003786894463,
     0.000001188105774,     0.000000440090248,     0.000000187692378,     0.000000090358380,     0.000000048293278,     0.000000028240469,     0.000000017834418,     0.000000012021909,     0.000000008561037,     0.000000006382914,
     0.000000004944565,     0.211667402941712,     0.006037289748255,     0.000516595689586,     0.000073672392472,     0.000014708567582,     0.000003775035378,     0.000001183714241,     0.000000438217834,     0.000000186791204,
     0.000000089876857,     0.000000048011763,     0.000000028062725,     0.000000017714626,     0.000000011936617,     0.000000008497455,     0.000000006333665,     0.000000004905184,     0.211607055861741,     0.006032127472529,
     0.000515859700461,     0.000073525495350,     0.000014670876341,     0.000003763220116,     0.000001179341387,     0.000000436354408,     0.000000185894832,     0.000000089398139,     0.000000047732019,     0.000000027886174,
     0.000000017595684,     0.000000011851958,     0.000000008434363,     0.000000006284809,     0.000000004866125,     0.211546760367752,     0.006026972549356,     0.000515125178425,     0.000073378974552,     0.000014633303034,
     0.000003751448488,     0.000001174987123,     0.000000434499921,     0.000000185003232,     0.000000088922210,     0.000000047454035,     0.000000027710808,     0.000000017477585,     0.000000011767928,     0.000000008371757,
     0.000000006236342,     0.000000004827386,     0.211486516386294,     0.006021824964083,     0.000514392119720,     0.000073232828898,     0.000014595847226,     0.000003739720311,     0.000001170651359,     0.000000432654327,
     0.000000184116378,     0.000000088449053,     0.000000047177799,     0.000000027536620,     0.000000017360323,     0.000000011684521,     0.000000008309635,     0.000000006188260,     0.000000004788963,     0.211426323844060,
     0.006016684702096,     0.000513660520600,     0.000073087057217,     0.000014558508484,     0.000003728035400,     0.000001166334007,     0.000000430817578,     0.000000183234242,     0.000000087978649,     0.000000046903299,
     0.000000027363599,     0.000000017243892,     0.000000011601733,     0.000000008247991,     0.000000006140562,     0.000000004750854,     0.211366182667890,     0.006011551748818,     0.000512930377333,     0.000072941658340,
     0.000014521286375,     0.000003716393570,     0.000001162034978,     0.000000428989627,     0.000000182356796,     0.000000087510981,     0.000000046630523,     0.000000027191739,     0.000000017128287,     0.000000011519560,
     0.000000008186822,     0.000000006093242,     0.000000004713057,     0.211306092784769,     0.006006426089709,     0.000512201686195,     0.000072796631102,     0.000014484180469,     0.000003704794640,     0.000001157754185,
     0.000000427170426,     0.000000181484013,     0.000000087046033,     0.000000046359460,     0.000000027021031,     0.000000017013499,     0.000000011437995,     0.000000008126125,     0.000000006046299,     0.000000004675568,
     0.211246054121830,     0.006001307710266,     0.000511474443476,     0.000072651974344,     0.000014447190339,     0.000003693238426,     0.000001153491541,     0.000000425359931,     0.000000180615867,     0.000000086583786,
     0.000000046090099,     0.000000026851466,     0.000000016899525,     0.000000011357036,     0.000000008065895,     0.000000005999730,     0.000000004638385,     0.211186066606347,     0.005996196596024,     0.000510748645477,
     0.000072507686911,     0.000014410315559,     0.000003681724749,     0.000001149246958,     0.000000423558094,     0.000000179752329,     0.000000086124225,     0.000000045822427,     0.000000026683038,     0.000000016786357,
     0.000000011276676,     0.000000008006129,     0.000000005953531,     0.000000004601507,     0.211126130165741,     0.005991092732553,     0.000510024288510,     0.000072363767650,     0.000014373555703,     0.000003670253427,
     0.000001145020350,     0.000000421764869,     0.000000178893373,     0.000000085667332,     0.000000045556434,     0.000000026515737,     0.000000016673989,     0.000000011196912,     0.000000007946823,     0.000000005907699,
     0.000000004564929,     0.211066244727575,     0.005985996105462,     0.000509301368900,     0.000072220215415,     0.000014336910350,     0.000003658824282,     0.000001140811632,     0.000000419980211,     0.000000178038973,
     0.000000085213091,     0.000000045292109,     0.000000026349555,     0.000000016562416,     0.000000011117738,     0.000000007887974,     0.000000005862231,     0.000000004528650,     0.211006410219558,     0.005980906700396,
     0.000508579882982,     0.000072077029063,     0.000014300379078,     0.000003647437135,     0.000001136620717,     0.000000418204074,     0.000000177189103,     0.000000084761484,     0.000000045029439,     0.000000026184486,
     0.000000016451632,     0.000000011039151,     0.000000007829577,     0.000000005817125,     0.000000004492667,     0.210946626569541,     0.005975824503036,     0.000507859827103,     0.000071934207455,     0.000014263961468,
     0.000003636091808,     0.000001132447522,     0.000000416436414,     0.000000176343735,     0.000000084312496,     0.000000044768415,     0.000000026020520,     0.000000016341631,     0.000000010961145,     0.000000007771630,
     0.000000005772377,     0.000000004456978,     0.210886893705519,     0.005970749499100,     0.000507141197621,     0.000071791749456,     0.000014227657103,     0.000003624788126,     0.000001128291961,     0.000000414677185,
     0.000000175502844,     0.000000083866111,     0.000000044509025,     0.000000025857650,     0.000000016232408,     0.000000010883716,     0.000000007714129,     0.000000005727984,     0.000000004421580,     0.210827211555628,
     0.005965681674341,     0.000506423990906,     0.000071649653936,     0.000014191465567,     0.000003613525911,     0.000001124153950,     0.000000412926342,     0.000000174666404,     0.000000083422310,     0.000000044251259,
     0.000000025695869,     0.000000016123955,     0.000000010806861,     0.000000007657069,     0.000000005683944,     0.000000004386470,     0.210767580048149,     0.005960621014551,     0.000505708203338,     0.000071507919770,
     0.000014155386447,     0.000003602304989,     0.000001120033406,     0.000000411183842,     0.000000173834389,     0.000000082981080,     0.000000043995104,     0.000000025535169,     0.000000016016268,     0.000000010730574,
     0.000000007600449,     0.000000005640254,     0.000000004351647,     0.210707999111502,     0.005955567505556,     0.000504993831310,     0.000071366545834,     0.000014119419330,     0.000003591125185,     0.000001115930246,
     0.000000409449640,     0.000000173006774,     0.000000082542403,     0.000000043740552,     0.000000025375541,     0.000000015909342,     0.000000010654850,     0.000000007544263,     0.000000005596910,     0.000000004317108,
     0.210648468674249,     0.005950521133218,     0.000504280871224,     0.000071225531011,     0.000014083563807,     0.000003579986326,     0.000001111844386,     0.000000407723692,     0.000000172183533,     0.000000082106264,
     0.000000043487590,     0.000000025216979,     0.000000015803170,     0.000000010579687,     0.000000007488509,     0.000000005553911,     0.000000004282851,     0.210588988665095,     0.005945481883437,     0.000503569319496,
     0.000071084874187,     0.000014047819468,     0.000003568888240,     0.000001107775745,     0.000000406005955,     0.000000171364640,     0.000000081672646,     0.000000043236209,     0.000000025059475,     0.000000015697746,
     0.000000010505079,     0.000000007433184,     0.000000005511252,     0.000000004248872,     0.210529559012885,     0.005940449742146,     0.000502859172551,     0.000070944574253,     0.000014012185907,     0.000003557830754,
     0.000001103724240,     0.000000404296385,     0.000000170550071,     0.000000081241534,     0.000000042986397,     0.000000024903022,     0.000000015593066,     0.000000010431022,     0.000000007378283,     0.000000005468932,
     0.000000004215171,     0.210470179646604,     0.005935424695315,     0.000502150426825,     0.000070804630101,     0.000013976662718,     0.000003546813698,     0.000001099689790,     0.000000402594939,     0.000000169739801,
     0.000000080812913,     0.000000042738145,     0.000000024747612,     0.000000015489124,     0.000000010357512,     0.000000007323804,     0.000000005426948,     0.000000004181744,     0.210410850495377,     0.005930406728950,
     0.000501443078766,     0.000070665040632,     0.000013941249498,     0.000003535836902,     0.000001095672314,     0.000000400901574,     0.000000168933805,     0.000000080386766,     0.000000042491441,     0.000000024593237,
     0.000000015385914,     0.000000010284544,     0.000000007269743,     0.000000005385297,     0.000000004148590,     0.210351571488470,     0.005925395829093,     0.000500737124834,     0.000070525804746,     0.000013905945846,
     0.000003524900195,     0.000001091671731,     0.000000399216249,     0.000000168132058,     0.000000079963079,     0.000000042246277,     0.000000024439891,     0.000000015283431,     0.000000010212115,     0.000000007216097,
     0.000000005343975,     0.000000004115706,     0.210292342555287,     0.005920391981818,     0.000500032561497,     0.000070386921351,     0.000013870751361,     0.000003514003411,     0.000001087687962,     0.000000397538919,
     0.000000167334535,     0.000000079541836,     0.000000042002640,     0.000000024287566,     0.000000015181670,     0.000000010140221,     0.000000007162862,     0.000000005302982,     0.000000004083089,     0.210233163625371,
     0.005915395173239,     0.000499329385235,     0.000070248389356,     0.000013835665646,     0.000003503146380,     0.000001083720927,     0.000000395869544,     0.000000166541213,     0.000000079123021,     0.000000041760522,
     0.000000024136255,     0.000000015080625,     0.000000010068857,     0.000000007110036,     0.000000005262313,     0.000000004050738,     0.210174034628406,     0.005910405389502,     0.000498627592542,     0.000070110207677,
     0.000013800688302,     0.000003492328937,     0.000001079770545,     0.000000394208081,     0.000000165752067,     0.000000078706620,     0.000000041519912,     0.000000023985951,     0.000000014980291,     0.000000009998019,
     0.000000007057615,     0.000000005221966,     0.000000004018651,     0.210114955494211,     0.005905422616788,     0.000497927179918,     0.000069972375230,     0.000013765818935,     0.000003481550914,     0.000001075836739,
     0.000000392554489,     0.000000164967073,     0.000000078292618,     0.000000041280799,     0.000000023836647,     0.000000014880663,     0.000000009927703,     0.000000007005596,     0.000000005181939,     0.000000003986824,
     0.210055926152746,     0.005900446841315,     0.000497228143877,     0.000069834890939,     0.000013731057153,     0.000003470812147,     0.000001071919429,     0.000000390908726,     0.000000164186206,     0.000000077880999,
     0.000000041043175,     0.000000023688336,     0.000000014781735,     0.000000009857906,     0.000000006953975,     0.000000005142229,     0.000000003955257,     0.209996946534107,     0.005895478049334,     0.000496530480942,
     0.000069697753730,     0.000013696402562,     0.000003460112471,     0.000001068018538,     0.000000389270751,     0.000000163409445,     0.000000077471749,     0.000000040807030,     0.000000023541010,     0.000000014683503,
     0.000000009788622,     0.000000006902750,     0.000000005102833,     0.000000003923946,     0.209938016568527,     0.005890516227130,     0.000495834187649,     0.000069560962532,     0.000013661854774,     0.000003449451722,
     0.000001064133988,     0.000000387640523,     0.000000162636764,     0.000000077064854,     0.000000040572352,     0.000000023394663,     0.000000014585961,     0.000000009719849,     0.000000006851917,     0.000000005063749,
     0.000000003892891,     0.209879136186377,     0.005885561361027,     0.000495139260542,     0.000069424516280,     0.000013627413398,     0.000003438829737,     0.000001060265702,     0.000000386018002,     0.000000161868140,
     0.000000076660297,     0.000000040339133,     0.000000023249288,     0.000000014489104,     0.000000009651583,     0.000000006801474,     0.000000005024974,     0.000000003862087,     0.209820305318165,     0.005880613437377,
     0.000494445696177,     0.000069288413911,     0.000013593078050,     0.000003428246354,     0.000001056413603,     0.000000384403147,     0.000000161103550,     0.000000076258066,     0.000000040107363,     0.000000023104879,
     0.000000014392928,     0.000000009583819,     0.000000006751417,     0.000000004986506,     0.000000003831534,     0.209761523894533,     0.005875672442572,     0.000493753491121,     0.000069152654367,     0.000013558848343,
     0.000003417701411,     0.000001052577614,     0.000000382795918,     0.000000160342971,     0.000000075858145,     0.000000039877032,     0.000000022961428,     0.000000014297426,     0.000000009516553,     0.000000006701743,
     0.000000004948343,     0.000000003801230,     0.209702791846262,     0.005870738363035,     0.000493062641950,     0.000069017236593,     0.000013524723894,     0.000003407194748,     0.000001048757659,     0.000000381196274,
     0.000000159586379,     0.000000075460521,     0.000000039648131,     0.000000022818928,     0.000000014202595,     0.000000009449783,     0.000000006652449,     0.000000004910481,     0.000000003771172,     0.209644109104267,
     0.005865811185225,     0.000492373145253,     0.000068882159539,     0.000013490704321,     0.000003396726205,     0.000001044953663,     0.000000379604177,     0.000000158833753,     0.000000075065178,     0.000000039420651,
     0.000000022677373,     0.000000014108429,     0.000000009383503,     0.000000006603532,     0.000000004872918,     0.000000003741358,     0.209585475599597,     0.005860890895633,     0.000491684997627,     0.000068747422158,
     0.000013456789244,     0.000003386295622,     0.000001041165551,     0.000000378019586,     0.000000158085068,     0.000000074672103,     0.000000039194581,     0.000000022536757,     0.000000014014923,     0.000000009317711,
     0.000000006554990,     0.000000004835653,     0.000000003711787,     0.209526891263438,     0.005855977480787,     0.000490998195681,     0.000068613023407,     0.000013422978283,     0.000003375902841,     0.000001037393246,
     0.000000376442463,     0.000000157340303,     0.000000074281282,     0.000000038969912,     0.000000022397073,     0.000000013922073,     0.000000009252402,     0.000000006506818,     0.000000004798682,     0.000000003682455,
     0.209468356027110,     0.005851070927245,     0.000490312736034,     0.000068478962247,     0.000013389271061,     0.000003365547705,     0.000001033636677,     0.000000374872767,     0.000000156599435,     0.000000073892700,
     0.000000038746636,     0.000000022258314,     0.000000013829874,     0.000000009187573,     0.000000006459015,     0.000000004762003,     0.000000003653362,     0.209409869822067,     0.005846171221603,     0.000489628615314,
     0.000068345237642,     0.000013355667204,     0.000003355230055,     0.000001029895767,     0.000000373310461,     0.000000155862442,     0.000000073506344,     0.000000038524743,     0.000000022120473,     0.000000013738320,
     0.000000009123220,     0.000000006411577,     0.000000004725614,     0.000000003624505,     0.209351432579897,     0.005841278350487,     0.000488945830162,     0.000068211848559,     0.000013322166336,     0.000003344949737,
     0.000001026170443,     0.000000371755505,     0.000000155129301,     0.000000073122201,     0.000000038304224,     0.000000021983545,     0.000000013647408,     0.000000009059340,     0.000000006364502,     0.000000004689512,
     0.000000003595883,     0.209293044232320,     0.005836392300559,     0.000488264377228,     0.000068078793973,     0.000013288768085,     0.000003334706595,     0.000001022460632,     0.000000370207862,     0.000000154399990,
     0.000000072740255,     0.000000038085069,     0.000000021847523,     0.000000013557132,     0.000000008995929,     0.000000006317786,     0.000000004653695,     0.000000003567492,     0.209234704711192,     0.005831513058513,
     0.000487584253171,     0.000067946072857,     0.000013255472081,     0.000003324500473,     0.000001018766261,     0.000000368667493,     0.000000153674488,     0.000000072360495,     0.000000037867270,     0.000000021712400,
     0.000000013467488,     0.000000008932983,     0.000000006271427,     0.000000004618162,     0.000000003539333,     0.209176413948501,     0.005826640611077,     0.000486905454663,     0.000067813684192,     0.000013222277953,
     0.000003314331218,     0.000001015087258,     0.000000367134360,     0.000000152952773,     0.000000071982906,     0.000000037650818,     0.000000021578171,     0.000000013378471,     0.000000008870499,     0.000000006225422,
     0.000000004582908,     0.000000003511401,     0.209118171876366,     0.005821774945012,     0.000486227978383,     0.000067681626960,     0.000013189185334,     0.000003304198677,     0.000001011423550,     0.000000365608425,
     0.000000152234823,     0.000000071607474,     0.000000037435704,     0.000000021444829,     0.000000013290076,     0.000000008808474,     0.000000006179768,     0.000000004547933,     0.000000003483697,     0.209059978427040,
     0.005816916047113,     0.000485551821022,     0.000067549900148,     0.000013156193857,     0.000003294102697,     0.000001007775066,     0.000000364089651,     0.000000151520617,     0.000000071234187,     0.000000037221919,
     0.000000021312367,     0.000000013202300,     0.000000008746903,     0.000000006134462,     0.000000004513233,     0.000000003456217,     0.209001833532907,     0.005812063904206,     0.000484876979282,     0.000067418502746,
     0.000013123303158,     0.000003284043125,     0.000001004141733,     0.000000362578000,     0.000000150810132,     0.000000070863031,     0.000000037009453,     0.000000021180781,     0.000000013115137,     0.000000008685783,
     0.000000006089502,     0.000000004478808,     0.000000003428960,     0.208943737126483,     0.005807218503153,     0.000484203449873,     0.000067287433750,     0.000013090512874,     0.000003274019812,     0.000001000523482,
     0.000000361073436,     0.000000150103349,     0.000000070493994,     0.000000036798300,     0.000000021050063,     0.000000013028583,     0.000000008625112,     0.000000006044885,     0.000000004444653,     0.000000003401924,
     0.208885689140415,     0.005802379830845,     0.000483531229515,     0.000067156692155,     0.000013057822642,     0.000003264032605,     0.000000996920241,     0.000000359575921,     0.000000149400245,     0.000000070127061,
     0.000000036588449,     0.000000020920207,     0.000000012942633,     0.000000008564885,     0.000000006000608,     0.000000004410768,     0.000000003375107,     0.208827689507481,     0.005797547874210,     0.000482860314941,
     0.000067026276965,     0.000013025232102,     0.000003254081357,     0.000000993331940,     0.000000358085419,     0.000000148700801,     0.000000069762220,     0.000000036379893,     0.000000020791208,     0.000000012857283,
     0.000000008505098,     0.000000005956669,     0.000000004377151,     0.000000003348507,     0.208769738160589,     0.005792722620205,     0.000482190702891,     0.000066896187182,     0.000012992740895,     0.000003244165917,
     0.000000989758509,     0.000000356601893,     0.000000148004994,     0.000000069399459,     0.000000036172622,     0.000000020663059,     0.000000012772529,     0.000000008445750,     0.000000005913065,     0.000000004343798,
     0.000000003322123,     0.208711835032778,     0.005787904055821,     0.000481522390116,     0.000066766421817,     0.000012960348665,     0.000003234286137,     0.000000986199879,     0.000000355125307,     0.000000147312805,
     0.000000069038764,     0.000000035966629,     0.000000020535755,     0.000000012688367,     0.000000008386836,     0.000000005869792,     0.000000004310707,     0.000000003295953,     0.208653980057217,     0.005783092168082,
     0.000480855373377,     0.000066636979880,     0.000012928055054,     0.000003224441870,     0.000000982655980,     0.000000353655625,     0.000000146624212,     0.000000068680122,     0.000000035761904,     0.000000020409290,
     0.000000012604791,     0.000000008328353,     0.000000005826849,     0.000000004277878,     0.000000003269995,     0.208596173167204,     0.005778286944044,     0.000480189649444,     0.000066507860388,     0.000012895859709,
     0.000003214632969,     0.000000979126744,     0.000000352192811,     0.000000145939195,     0.000000068323521,     0.000000035558440,     0.000000020283658,     0.000000012521798,     0.000000008270298,     0.000000005784234,
     0.000000004245307,     0.000000003244247,     0.208538414296167,     0.005773488370795,     0.000479525215098,     0.000066379062360,     0.000012863762278,     0.000003204859287,     0.000000975612101,     0.000000350736829,
     0.000000145257735,     0.000000067968949,     0.000000035356229,     0.000000020158852,     0.000000012439384,     0.000000008212667,     0.000000005741942,     0.000000004212992,     0.000000003218707,     0.208480703377662,
     0.005768696435454,     0.000478862067129,     0.000066250584817,     0.000012831762407,     0.000003195120679,     0.000000972111985,     0.000000349287644,     0.000000144579810,     0.000000067616393,     0.000000035155261,
     0.000000020034868,     0.000000012357544,     0.000000008155458,     0.000000005699973,     0.000000004180932,     0.000000003193374,     0.208423040345374,     0.005763911125175,     0.000478200202336,     0.000066122426788,
     0.000012799859748,     0.000003185416999,     0.000000968626326,     0.000000347845221,     0.000000143905400,     0.000000067265840,     0.000000034955528,     0.000000019911700,     0.000000012276273,     0.000000008098667,
     0.000000005658323,     0.000000004149124,     0.000000003168247,     0.208365425133118,     0.005759132427141,     0.000477539617531,     0.000065994587300,     0.000012768053951,     0.000003175748104,     0.000000965155058,
     0.000000346409525,     0.000000143234486,     0.000000066917278,     0.000000034757024,     0.000000019789341,     0.000000012195569,     0.000000008042290,     0.000000005616990,     0.000000004117566,     0.000000003143322,
     0.208307857674833,     0.005754360328568,     0.000476880309532,     0.000065867065387,     0.000012736344670,     0.000003166113850,     0.000000961698113,     0.000000344980520,     0.000000142567048,     0.000000066570695,
     0.000000034559739,     0.000000019667786,     0.000000012115426,     0.000000007986326,     0.000000005575971,     0.000000004086257,     0.000000003118600,     0.208250337904591,     0.005749594816705,     0.000476222275168,
     0.000065739860086,     0.000012704731559,     0.000003156514094,     0.000000958255425,     0.000000343558172,     0.000000141903066,     0.000000066226079,     0.000000034363666,     0.000000019547030,     0.000000012035841,
     0.000000007930770,     0.000000005535264,     0.000000004055194,     0.000000003094077,     0.208192865756586,     0.005744835878830,     0.000475565511278,     0.000065612970436,     0.000012673214274,     0.000003146948694,
     0.000000954826928,     0.000000342142447,     0.000000141242520,     0.000000065883418,     0.000000034168796,     0.000000019427068,     0.000000011956809,     0.000000007875620,     0.000000005494866,     0.000000004024375,
     0.000000003069753,     0.208135441165143,     0.005740083502255,     0.000474910014710,     0.000065486395482,     0.000012641792471,     0.000003137417509,     0.000000951412554,     0.000000340733310,     0.000000140585391,
     0.000000065542699,     0.000000033975122,     0.000000019307892,     0.000000011878327,     0.000000007820872,     0.000000005454776,     0.000000003993798,     0.000000003045625,     0.208078064064712,     0.005735337674322,
     0.000474255782322,     0.000065360134270,     0.000012610465810,     0.000003127920396,     0.000000948012240,     0.000000339330728,     0.000000139931660,     0.000000065203911,     0.000000033782635,     0.000000019189499,
     0.000000011800391,     0.000000007766523,     0.000000005414989,     0.000000003963462,     0.000000003021692,     0.208020734389870,     0.005730598382405,     0.000473602810982,     0.000065234185850,     0.000012579233950,
     0.000003118457217,     0.000000944625918,     0.000000337934666,     0.000000139281306,     0.000000064867043,     0.000000033591329,     0.000000019071883,     0.000000011722996,     0.000000007712571,     0.000000005375505,
     0.000000003933363,     0.000000002997953,     0.207963452075319,     0.005725865613909,     0.000472951097566,     0.000065108549276,     0.000012548096553,     0.000003109027832,     0.000000941253525,     0.000000336545091,
     0.000000138634312,     0.000000064532081,     0.000000033401195,     0.000000018955038,     0.000000011646138,     0.000000007659012,     0.000000005336321,     0.000000003903502,     0.000000002974406,     0.207906217055889,
     0.005721139356271,     0.000472300638960,     0.000064983223605,     0.000012517053281,     0.000003099632100,     0.000000937894995,     0.000000335161968,     0.000000137990658,     0.000000064199015,     0.000000033212226,
     0.000000018838958,     0.000000011569814,     0.000000007605843,     0.000000005297435,     0.000000003873875,     0.000000002951049,     0.207849029266533,     0.005716419596958,     0.000471651432061,     0.000064858207898,
     0.000012486103799,     0.000003090269886,     0.000000934550264,     0.000000333785266,     0.000000137350326,     0.000000063867833,     0.000000033024413,     0.000000018723639,     0.000000011494020,     0.000000007553062,
     0.000000005258843,     0.000000003844480,     0.000000002927881,     0.207791888642330,     0.005711706323468,     0.000471003473772,     0.000064733501217,     0.000012455247772,     0.000003080941049,     0.000000931219268,
     0.000000332414951,     0.000000136713296,     0.000000063538523,     0.000000032837750,     0.000000018609076,     0.000000011418751,     0.000000007500666,     0.000000005220544,     0.000000003815316,     0.000000002904899,
     0.207734795118485,     0.005706999523331,     0.000470356761009,     0.000064609102632,     0.000012424484867,     0.000003071645455,     0.000000927901944,     0.000000331050989,     0.000000136079549,     0.000000063211074,
     0.000000032652229,     0.000000018495263,     0.000000011344005,     0.000000007448650,     0.000000005182536,     0.000000003786382,     0.000000002882104,     0.207677748630327,     0.005702299184106,     0.000469711290696,
     0.000064485011211,     0.000012393814753,     0.000003062382965,     0.000000924598227,     0.000000329693349,     0.000000135449068,     0.000000062885474,     0.000000032467843,     0.000000018382194,     0.000000011269777,
     0.000000007397014,     0.000000005144816,     0.000000003757674,     0.000000002859492,     0.207620749113308,     0.005697605293385,     0.000469067059764,     0.000064361226028,     0.000012363237098,     0.000003053153445,
     0.000000921308056,     0.000000328341997,     0.000000134821834,     0.000000062561713,     0.000000032284583,     0.000000018269865,     0.000000011196064,     0.000000007345753,     0.000000005107382,     0.000000003729191,
     0.000000002837063,     0.207563796503006,     0.005692917838790,     0.000468424065157,     0.000064237746162,     0.000012332751574,     0.000003043956759,     0.000000918031366,     0.000000326996902,     0.000000134197828,
     0.000000062239779,     0.000000032102443,     0.000000018158271,     0.000000011122861,     0.000000007294865,     0.000000005070231,     0.000000003700932,     0.000000002814815,     0.207506890735120,     0.005688236807971,
     0.000467782303826,     0.000064114570691,     0.000012302357854,     0.000003034792773,     0.000000914768097,     0.000000325658030,     0.000000133577032,     0.000000061919661,     0.000000031921415,     0.000000018047407,
     0.000000011050165,     0.000000007244348,     0.000000005033362,     0.000000003672894,     0.000000002792747,     0.207450031745475,     0.005683562188612,     0.000467141772732,     0.000063991698700,     0.000012272055610,
     0.000003025661353,     0.000000911518185,     0.000000324325350,     0.000000132959428,     0.000000061601347,     0.000000031741492,     0.000000017937266,     0.000000010977973,     0.000000007194197,     0.000000004996773,
     0.000000003645076,     0.000000002770856,     0.207393219470017,     0.005678893968426,     0.000466502468844,     0.000063869129275,     0.000012241844519,     0.000003016562365,     0.000000908281569,     0.000000322998831,
     0.000000132344999,     0.000000061284827,     0.000000031562667,     0.000000017827845,     0.000000010906280,     0.000000007144411,     0.000000004960460,     0.000000003617477,     0.000000002749142,     0.207336453844816,
     0.005674232135155,     0.000465864389141,     0.000063746861507,     0.000012211724255,     0.000003007495677,     0.000000905058188,     0.000000321678440,     0.000000131733726,     0.000000060970090,     0.000000031384933,
     0.000000017719139,     0.000000010835083,     0.000000007094987,     0.000000004924422,     0.000000003590093,     0.000000002727603,     0.207279734806065,     0.005669576676573,     0.000465227530611,     0.000063624894488,
     0.000012181694498,     0.000002998461157,     0.000000901847980,     0.000000320364146,     0.000000131125591,     0.000000060657125,     0.000000031208282,     0.000000017611142,     0.000000010764379,     0.000000007045922,
     0.000000004888658,     0.000000003562924,     0.000000002706238,     0.207223062290077,     0.005664927580482,     0.000464591890252,     0.000063503227316,     0.000012151754925,     0.000002989458674,     0.000000898650885,
     0.000000319055918,     0.000000130520578,     0.000000060345921,     0.000000031032708,     0.000000017503850,     0.000000010694164,     0.000000006997213,     0.000000004853163,     0.000000003535968,     0.000000002685045,
     0.207166436233288,     0.005660284834717,     0.000463957465068,     0.000063381859090,     0.000012121905218,     0.000002980488096,     0.000000895466842,     0.000000317753724,     0.000000129918667,     0.000000060036467,
     0.000000030858203,     0.000000017397257,     0.000000010624434,     0.000000006948858,     0.000000004817938,     0.000000003509222,     0.000000002664023,     0.207109856572255,     0.005655648427140,     0.000463324252076,
     0.000063260788913,     0.000012092145058,     0.000002971549294,     0.000000892295791,     0.000000316457534,     0.000000129319842,     0.000000059728753,     0.000000030684760,     0.000000017291360,     0.000000010555185,
     0.000000006900853,     0.000000004782978,     0.000000003482687,     0.000000002643170,     0.207053323243658,     0.005651018345645,     0.000462692248300,     0.000063140015891,     0.000012062474127,     0.000002962642137,
     0.000000889137671,     0.000000315167317,     0.000000128724086,     0.000000059422768,     0.000000030512373,     0.000000017186152,     0.000000010486415,     0.000000006853197,     0.000000004748283,     0.000000003456358,
     0.000000002622486,     0.206996836184296,     0.005646394578153,     0.000462061450771,     0.000063019539134,     0.000012032892110,     0.000002953766497,     0.000000885992424,     0.000000313883042,     0.000000128131381,
     0.000000059118502,     0.000000030341035,     0.000000017081630,     0.000000010418120,     0.000000006805887,     0.000000004713850,     0.000000003430236,     0.000000002601968,     0.206940395331088,     0.005641777112618,
     0.000461431856532,     0.000062899357754,     0.000012003398692,     0.000002944922246,     0.000000882859991,     0.000000312604679,     0.000000127541710,     0.000000058815944,     0.000000030170739,     0.000000016977788,
     0.000000010350296,     0.000000006758919,     0.000000004679678,     0.000000003404319,     0.000000002581615,     0.206884000621077,     0.005637165937022,     0.000460803462634,     0.000062779470866,     0.000011973993561,
     0.000002936109255,     0.000000879740311,     0.000000311332198,     0.000000126955057,     0.000000058515084,     0.000000030001477,     0.000000016874622,     0.000000010282941,     0.000000006712292,     0.000000004645763,
     0.000000003378603,     0.000000002561426,     0.206827651991421,     0.005632561039374,     0.000460176266136,     0.000062659877589,     0.000011944676403,     0.000002927327397,     0.000000876633327,     0.000000310065568,
     0.000000126371403,     0.000000058215911,     0.000000029833244,     0.000000016772128,     0.000000010216050,     0.000000006666003,     0.000000004612105,     0.000000003353090,     0.000000002541399,     0.206771349379403,
     0.005627962407717,     0.000459550264107,     0.000062540577046,     0.000011915446909,     0.000002918576546,     0.000000873538980,     0.000000308804760,     0.000000125790733,     0.000000057918416,     0.000000029666032,
     0.000000016670300,     0.000000010149620,     0.000000006620049,     0.000000004578701,     0.000000003327775,     0.000000002521534,     0.206715092722420,     0.005623370030120,     0.000458925453623,     0.000062421568360,
     0.000011886304769,     0.000002909856576,     0.000000870457213,     0.000000307549743,     0.000000125213029,     0.000000057622587,     0.000000029499836,     0.000000016569134,     0.000000010083647,     0.000000006574428,
     0.000000004545549,     0.000000003302658,     0.000000002501828,     0.206658881957993,     0.005618783894683,     0.000458301831770,     0.000062302850660,     0.000011857249675,     0.000002901167360,     0.000000867387966,
     0.000000306300489,     0.000000124638276,     0.000000057328416,     0.000000029334647,     0.000000016468625,     0.000000010018130,     0.000000006529138,     0.000000004512647,     0.000000003277738,     0.000000002482281,
     0.206602717023759,     0.005614203989533,     0.000457679395642,     0.000062184423077,     0.000011828281320,     0.000002892508775,     0.000000864331184,     0.000000305056968,     0.000000124066455,     0.000000057035891,
     0.000000029170461,     0.000000016368770,     0.000000009953064,     0.000000006484175,     0.000000004479993,     0.000000003253012,     0.000000002462892,     0.206546597857474,     0.005609630302827,     0.000457058142344,
     0.000062066284746,     0.000011799399398,     0.000002883880695,     0.000000861286808,     0.000000303819151,     0.000000123497552,     0.000000056745003,     0.000000029007270,     0.000000016269562,     0.000000009888445,
     0.000000006439537,     0.000000004447586,     0.000000003228480,     0.000000002443658,     0.206490524397014,     0.005605062822753,     0.000456438068986,     0.000061948434802,     0.000011770603605,     0.000002875282998,
     0.000000858254782,     0.000000302587007,     0.000000122931550,     0.000000056455742,     0.000000028845068,     0.000000016170999,     0.000000009824272,     0.000000006395222,     0.000000004415423,     0.000000003204138,
     0.000000002424579,     0.206434496580370,     0.005600501537524,     0.000455819172689,     0.000061830872388,     0.000011741893637,     0.000002866715559,     0.000000855235049,     0.000000301360510,     0.000000122368432,
     0.000000056168098,     0.000000028683848,     0.000000016073075,     0.000000009760540,     0.000000006351228,     0.000000004383503,     0.000000003179987,     0.000000002405653,     0.206378514345653,     0.005595946435385,
     0.000455201450583,     0.000061713596645,     0.000011713269193,     0.000002858178256,     0.000000852227553,     0.000000300139629,     0.000000121808183,     0.000000055882062,     0.000000028523604,     0.000000015975787,
     0.000000009697246,     0.000000006307551,     0.000000004351823,     0.000000003156025,     0.000000002386879,     0.206322577631091,     0.005591397504608,     0.000454584899804,     0.000061596606720,     0.000011684729972,
     0.000002849670967,     0.000000849232238,     0.000000298924337,     0.000000121250786,     0.000000055597623,     0.000000028364330,     0.000000015879129,     0.000000009634388,     0.000000006264190,     0.000000004320382,
     0.000000003132249,     0.000000002368257,     0.206266686375028,     0.005586854733494,     0.000453969517498,     0.000061479901762,     0.000011656275674,     0.000002841193571,     0.000000846249048,     0.000000297714604,
     0.000000120696225,     0.000000055314772,     0.000000028206019,     0.000000015783098,     0.000000009571961,     0.000000006221143,     0.000000004289177,     0.000000003108659,     0.000000002349783,     0.206210840515928,
     0.005582318110372,     0.000453355300821,     0.000061363480924,     0.000011627906002,     0.000002832745946,     0.000000843277927,     0.000000296510403,     0.000000120144485,     0.000000055033499,     0.000000028048666,
     0.000000015687688,     0.000000009509964,     0.000000006178406,     0.000000004258208,     0.000000003085253,     0.000000002331458,     0.206155039992367,     0.005577787623601,     0.000452742246936,     0.000061247343361,
     0.000011599620657,     0.000002824327972,     0.000000840318821,     0.000000295311705,     0.000000119595550,     0.000000054753796,     0.000000027892263,     0.000000015592897,     0.000000009448392,     0.000000006135978,
     0.000000004227471,     0.000000003062030,     0.000000002313281,     0.206099284743040,     0.005573263261567,     0.000452130353013,     0.000061131488231,     0.000011571419344,     0.000002815939530,     0.000000837371675,
     0.000000294118483,     0.000000119049404,     0.000000054475651,     0.000000027736806,     0.000000015498719,     0.000000009387243,     0.000000006093856,     0.000000004196967,     0.000000003038987,     0.000000002295249,
     0.206043574706758,     0.005568745012684,     0.000451519616232,     0.000061015914695,     0.000011543301768,     0.000002807580499,     0.000000834436433,     0.000000292930708,     0.000000118506032,     0.000000054199056,
     0.000000027582287,     0.000000015405151,     0.000000009326514,     0.000000006052038,     0.000000004166691,     0.000000003016124,     0.000000002277362,     0.205987909822447,     0.005564232865395,     0.000450910033783,
     0.000060900621917,     0.000011515267636,     0.000002799250761,     0.000000831513043,     0.000000291748353,     0.000000117965418,     0.000000053924002,     0.000000027428701,     0.000000015312188,     0.000000009266201,
     0.000000006010521,     0.000000004136643,     0.000000002993439,     0.000000002259619,     0.205932290029150,     0.005559726808170,     0.000450301602861,     0.000060785609065,     0.000011487316655,     0.000002790950199,
     0.000000828601448,     0.000000290571390,     0.000000117427546,     0.000000053650479,     0.000000027276041,     0.000000015219825,     0.000000009206303,     0.000000005969304,     0.000000004106822,     0.000000002970931,
     0.000000002242018,     0.205876715266022,     0.005555226829508,     0.000449694320671,     0.000060670875308,     0.000011459448535,     0.000002782678693,     0.000000825701597,     0.000000289399793,     0.000000116892403,
     0.000000053378478,     0.000000027124302,     0.000000015128060,     0.000000009146814,     0.000000005928384,     0.000000004077224,     0.000000002948599,     0.000000002224558,     0.205821185472336,     0.005550732917937,
     0.000449088184427,     0.000060556419819,     0.000011431662985,     0.000002774436128,     0.000000822813435,     0.000000288233533,     0.000000116359972,     0.000000053107990,     0.000000026973478,     0.000000015036888,
     0.000000009087734,     0.000000005887759,     0.000000004047849,     0.000000002926440,     0.000000002207238,     0.205765700587478,     0.005546245062009,     0.000448483191350,     0.000060442241774,     0.000011403959717,
     0.000002766222386,     0.000000819936909,     0.000000287072584,     0.000000115830238,     0.000000052839006,     0.000000026823563,     0.000000014946304,     0.000000009029058,     0.000000005847426,     0.000000004018695,
     0.000000002904453,     0.000000002190057,     0.205710260550948,     0.005541763250308,     0.000447879338670,     0.000060328340351,     0.000011376338442,     0.000002758037351,     0.000000817071966,     0.000000285916919,
     0.000000115303187,     0.000000052571516,     0.000000026674550,     0.000000014856305,     0.000000008970784,     0.000000005807384,     0.000000003989760,     0.000000002882638,     0.000000002173014,     0.205654865302362,
     0.005537287471444,     0.000447276623624,     0.000060214714733,     0.000011348798874,     0.000002749880908,     0.000000814218553,     0.000000284766512,     0.000000114778803,     0.000000052305512,     0.000000026526435,
     0.000000014766887,     0.000000008912910,     0.000000005767631,     0.000000003961042,     0.000000002860993,     0.000000002156107,     0.205599514781448,     0.005532817714053,     0.000446675043459,     0.000060101364103,
     0.000011321340729,     0.000002741752942,     0.000000811376618,     0.000000283621335,     0.000000114257072,     0.000000052040984,     0.000000026379210,     0.000000014678046,     0.000000008855431,     0.000000005728163,
     0.000000003932539,     0.000000002839515,     0.000000002139336,     0.205544208928048,     0.005528353966801,     0.000446074595428,     0.000059988287648,     0.000011293963721,     0.000002733653338,     0.000000808546109,
     0.000000282481361,     0.000000113737978,     0.000000051777925,     0.000000026232872,     0.000000014589777,     0.000000008798345,     0.000000005688979,     0.000000003904251,     0.000000002818205,     0.000000002122700,
     0.205488947682116,     0.005523896218380,     0.000445475276794,     0.000059875484559,     0.000011266667568,     0.000002725581982,     0.000000805726973,     0.000000281346566,     0.000000113221508,     0.000000051516324,
     0.000000026087413,     0.000000014502077,     0.000000008741650,     0.000000005650077,     0.000000003876175,     0.000000002797061,     0.000000002106196,     0.205433730983721,     0.005519444457509,     0.000444877084828,
     0.000059762954028,     0.000011239451987,     0.000002717538760,     0.000000802919160,     0.000000280216923,     0.000000112707647,     0.000000051256173,     0.000000025942828,     0.000000014414943,     0.000000008685343,
     0.000000005611455,     0.000000003848309,     0.000000002776081,     0.000000002089825,     0.205378558773045,     0.005514998672937,     0.000444280016808,     0.000059650695251,     0.000011212316699,     0.000002709523561,
     0.000000800122618,     0.000000279092405,     0.000000112196380,     0.000000050997464,     0.000000025799112,     0.000000014328369,     0.000000008629420,     0.000000005573110,     0.000000003820652,     0.000000002755264,
     0.000000002073585,     0.205323430990379,     0.005510558853436,     0.000443684070020,     0.000059538707427,     0.000011185261423,     0.000002701536271,     0.000000797337295,     0.000000277972986,     0.000000111687693,
     0.000000050740188,     0.000000025656259,     0.000000014242353,     0.000000008573880,     0.000000005535041,     0.000000003793203,     0.000000002734609,     0.000000002057475,     0.205268347576130,     0.005506124987808,
     0.000443089241759,     0.000059426989757,     0.000011158285881,     0.000002693576778,     0.000000794563141,     0.000000276858642,     0.000000111181571,     0.000000050484336,     0.000000025514263,     0.000000014156890,
     0.000000008518719,     0.000000005497245,     0.000000003765960,     0.000000002714114,     0.000000002041494,     0.205213308470814,     0.005501697064881,     0.000442495529327,     0.000059315541445,     0.000011131389795,
     0.000002685644971,     0.000000791800105,     0.000000275749346,     0.000000110678001,     0.000000050229900,     0.000000025373119,     0.000000014071978,     0.000000008463934,     0.000000005459721,     0.000000003738920,
     0.000000002693779,     0.000000002025640,     0.205158313615060,     0.005497275073511,     0.000441902930035,     0.000059204361697,     0.000011104572890,     0.000002677740739,     0.000000789048138,     0.000000274645074,
     0.000000110176969,     0.000000049976871,     0.000000025232822,     0.000000013987611,     0.000000008409523,     0.000000005422466,     0.000000003712084,     0.000000002673601,     0.000000002009914,     0.205103362949609,
     0.005492859002579,     0.000441311441200,     0.000059093449724,     0.000011077834889,     0.000002669863971,     0.000000786307187,     0.000000273545799,     0.000000109678459,     0.000000049725241,     0.000000025093365,
     0.000000013903786,     0.000000008355484,     0.000000005385479,     0.000000003685448,     0.000000002653580,     0.000000001994313,     0.205048456415311,     0.005488448840994,     0.000440721060150,     0.000058982804737,
     0.000011051175519,     0.000002662014559,     0.000000783577205,     0.000000272451496,     0.000000109182459,     0.000000049475001,     0.000000024954744,     0.000000013820500,     0.000000008301813,     0.000000005348757,
     0.000000003659011,     0.000000002633714,     0.000000001978838,     0.204993593953128,     0.005484044577692,     0.000440131784218,     0.000058872425952,     0.000011024594507,     0.000002654192391,     0.000000780858141,
     0.000000271362141,     0.000000108688955,     0.000000049226143,     0.000000024816954,     0.000000013737748,     0.000000008248508,     0.000000005312298,     0.000000003632773,     0.000000002614003,     0.000000001963486,
     0.204938775504133,     0.005479646201635,     0.000439543610747,     0.000058762312587,     0.000010998091581,     0.000002646397359,     0.000000778149946,     0.000000270277709,     0.000000108197932,     0.000000048978659,
     0.000000024679988,     0.000000013655528,     0.000000008195566,     0.000000005276101,     0.000000003606731,     0.000000002594444,     0.000000001948256,     0.204884001009508,     0.005475253701811,     0.000438956537085,
     0.000058652463861,     0.000010971666470,     0.000002638629356,     0.000000775452570,     0.000000269198174,     0.000000107709377,     0.000000048732541,     0.000000024543841,     0.000000013573836,     0.000000008142985,
     0.000000005240163,     0.000000003580884,     0.000000002575037,     0.000000001933149,     0.204829270410546,     0.005470867067236,     0.000438370560590,     0.000058542878999,     0.000010945318904,     0.000002630888272,
     0.000000772765966,     0.000000268123513,     0.000000107223276,     0.000000048487780,     0.000000024408509,     0.000000013492667,     0.000000008090762,     0.000000005204482,     0.000000003555230,     0.000000002555781,
     0.000000001918162,     0.204774583648649,     0.005466486286951,     0.000437785678628,     0.000058433557226,     0.000010919048615,     0.000002623174001,     0.000000770090084,     0.000000267053701,     0.000000106739617,
     0.000000048244368,     0.000000024273986,     0.000000013412019,     0.000000008038894,     0.000000005169058,     0.000000003529767,     0.000000002536674,     0.000000001903295,     0.204719940665329,     0.005462111350024,
     0.000437201888571,     0.000058324497770,     0.000010892855335,     0.000002615486435,     0.000000767424876,     0.000000265988713,     0.000000106258385,     0.000000048002297,     0.000000024140267,     0.000000013331888,
     0.000000007987380,     0.000000005133886,     0.000000003504496,     0.000000002517714,     0.000000001888546,     0.204665341402207,     0.005457742245549,     0.000436619187800,     0.000058215699863,     0.000010866738798,
     0.000002607825468,     0.000000764770294,     0.000000264928525,     0.000000105779566,     0.000000047761560,     0.000000024007347,     0.000000013252271,     0.000000007936216,     0.000000005098967,     0.000000003479413,
     0.000000002498902,     0.000000001873916,     0.204610785801013,     0.005453378962646,     0.000436037573704,     0.000058107162739,     0.000010840698737,     0.000002600190994,     0.000000762126289,     0.000000263873113,
     0.000000105303149,     0.000000047522148,     0.000000023875220,     0.000000013173163,     0.000000007885400,     0.000000005064297,     0.000000003454517,     0.000000002480236,     0.000000001859402,     0.204556273803585,
     0.005449021490461,     0.000435457043679,     0.000057998885634,     0.000010814734890,     0.000002592582907,     0.000000759492816,     0.000000262822454,     0.000000104829119,     0.000000047284053,     0.000000023743882,
     0.000000013094562,     0.000000007834929,     0.000000005029876,     0.000000003429807,     0.000000002461714,     0.000000001845004,     0.204501805351871,     0.005444669818167,     0.000434877595127,     0.000057890867788,
     0.000010788846992,     0.000002585001102,     0.000000756869825,     0.000000261776523,     0.000000104357464,     0.000000047047267,     0.000000023613327,     0.000000013016463,     0.000000007784801,     0.000000004995701,
     0.000000003405282,     0.000000002443335,     0.000000001830721,     0.204447380387925,     0.005440323934962,     0.000434299225461,     0.000057783108442,     0.000010763034780,     0.000002577445476,     0.000000754257269,
     0.000000260735297,     0.000000103888169,     0.000000046811784,     0.000000023483551,     0.000000012938864,     0.000000007735014,     0.000000004961770,     0.000000003380940,     0.000000002425099,     0.000000001816552,
     0.204392998853910,     0.005435983830070,     0.000433721932099,     0.000057675606841,     0.000010737297995,     0.000002569915922,     0.000000751655103,     0.000000259698752,     0.000000103421224,     0.000000046577594,
     0.000000023354548,     0.000000012861762,     0.000000007685565,     0.000000004928081,     0.000000003356780,     0.000000002407004,     0.000000001802496,     0.204338660692098,     0.005431649492741,     0.000433145712468,
     0.000057568362232,     0.000010711636375,     0.000002562412339,     0.000000749063279,     0.000000258666865,     0.000000102956613,     0.000000046344690,     0.000000023226314,     0.000000012785152,     0.000000007636452,
     0.000000004894634,     0.000000003332800,     0.000000002389049,     0.000000001788552,     0.204284365844866,     0.005427320912250,     0.000432570564001,     0.000057461373864,     0.000010686049662,     0.000002554934623,
     0.000000746481750,     0.000000257639612,     0.000000102494326,     0.000000046113065,     0.000000023098844,     0.000000012709032,     0.000000007587672,     0.000000004861425,     0.000000003308998,     0.000000002371232,
     0.000000001774719,     0.204230114254699,     0.005422998077899,     0.000431996484139,     0.000057354640990,     0.000010660537597,     0.000002547482670,     0.000000743910471,     0.000000256616970,     0.000000102034348,
     0.000000045882711,     0.000000022972132,     0.000000012633397,     0.000000007539222,     0.000000004828453,     0.000000003285375,     0.000000002353554,     0.000000001760997,     0.204175905864190,     0.005418680979014,
     0.000431423470332,     0.000057248162864,     0.000010635099923,     0.000002540056379,     0.000000741349396,     0.000000255598917,     0.000000101576667,     0.000000045653620,     0.000000022846174,     0.000000012558246,
     0.000000007491102,     0.000000004795717,     0.000000003261927,     0.000000002336012,     0.000000001747384,     0.204121740616036,     0.005414369604947,     0.000430851520035,     0.000057141938744,     0.000010609736384,
     0.000002532655648,     0.000000738798478,     0.000000254585429,     0.000000101121271,     0.000000045425785,     0.000000022720965,     0.000000012483574,     0.000000007443307,     0.000000004763214,     0.000000003238654,
     0.000000002318606,     0.000000001733880,     0.204067618453044,     0.005410063945077,     0.000430280630713,     0.000057035967890,     0.000010584446725,     0.000002525280376,     0.000000736257672,     0.000000253576484,
     0.000000100668147,     0.000000045199198,     0.000000022596501,     0.000000012409379,     0.000000007395837,     0.000000004730943,     0.000000003215554,     0.000000002301334,     0.000000001720483,     0.204013539318123,
     0.005405763988805,     0.000429710799835,     0.000056930249564,     0.000010559230692,     0.000002517930461,     0.000000733726933,     0.000000252572059,     0.000000100217283,     0.000000044973852,     0.000000022472776,
     0.000000012335656,     0.000000007348688,     0.000000004698902,     0.000000003192627,     0.000000002284196,     0.000000001707193,     0.203959503154291,     0.005401469725560,     0.000429142024882,     0.000056824783032,
     0.000010534088032,     0.000002510605804,     0.000000731206216,     0.000000251572131,     0.000000099768666,     0.000000044749740,     0.000000022349786,     0.000000012262404,     0.000000007301858,     0.000000004667090,
     0.000000003169870,     0.000000002267190,     0.000000001694008,     0.203905509904670,     0.005397181144796,     0.000428574303338,     0.000056719567560,     0.000010509018492,     0.000002503306304,     0.000000728695475,
     0.000000250576678,     0.000000099322284,     0.000000044526854,     0.000000022227526,     0.000000012189618,     0.000000007255345,     0.000000004635504,     0.000000003147283,     0.000000002250315,     0.000000001680929,
     0.203851559512488,     0.005392898235990,     0.000428007632696,     0.000056614602419,     0.000010484021822,     0.000002496031861,     0.000000726194667,     0.000000249585678,     0.000000098878125,     0.000000044305187,
     0.000000022105992,     0.000000012117296,     0.000000007209147,     0.000000004604144,     0.000000003124863,     0.000000002233571,     0.000000001667954,     0.203797651921079,     0.005388620988647,     0.000427442010458,
     0.000056509886881,     0.000010459097772,     0.000002488782377,     0.000000723703747,     0.000000248599108,     0.000000098436176,     0.000000044084732,     0.000000021985179,     0.000000012045434,     0.000000007163262,
     0.000000004573006,     0.000000003102611,     0.000000002216956,     0.000000001655082,     0.203743787073879,     0.005384349392295,     0.000426877434129,     0.000056405420222,     0.000010434246092,     0.000002481557753,
     0.000000721222670,     0.000000247616947,     0.000000097996426,     0.000000043865481,     0.000000021865082,     0.000000011974030,     0.000000007117686,     0.000000004542091,     0.000000003080524,     0.000000002200469,
     0.000000001642313,     0.203689964914431,     0.005380083436487,     0.000426313901226,     0.000056301201719,     0.000010409466534,     0.000002474357891,     0.000000718751394,     0.000000246639173,     0.000000097558863,
     0.000000043647428,     0.000000021745697,     0.000000011903080,     0.000000007072419,     0.000000004511395,     0.000000003058601,     0.000000002184109,     0.000000001629645,     0.203636185386382,     0.005375823110801,
     0.000425751409270,     0.000056197230652,     0.000010384758852,     0.000002467182693,     0.000000716289872,     0.000000245665763,     0.000000097123474,     0.000000043430565,     0.000000021627019,     0.000000011832580,
     0.000000007027458,     0.000000004480918,     0.000000003036841,     0.000000002167876,     0.000000001617078,     0.203582448433482,     0.005371568404840,     0.000425189955791,     0.000056093506303,     0.000010360122799,
     0.000002460032061,     0.000000713838064,     0.000000244696696,     0.000000096690247,     0.000000043214885,     0.000000021509044,     0.000000011762529,     0.000000006982800,     0.000000004450658,     0.000000003015243,
     0.000000002151768,     0.000000001604610,     0.203528753999587,     0.005367319308231,     0.000424629538324,     0.000055990027958,     0.000010335558129,     0.000002452905900,     0.000000711395924,     0.000000243731951,
     0.000000096259172,     0.000000043000382,     0.000000021391767,     0.000000011692923,     0.000000006938444,     0.000000004420613,     0.000000002993805,     0.000000002135783,     0.000000001592242,     0.203475102028654,
     0.005363075810628,     0.000424070154414,     0.000055886794904,     0.000010311064599,     0.000002445804111,     0.000000708963410,     0.000000242771505,     0.000000095830236,     0.000000042787048,     0.000000021275184,
     0.000000011623759,     0.000000006894387,     0.000000004390781,     0.000000002972527,     0.000000002119922,     0.000000001579973,     0.203421492464746,     0.005358837901706,     0.000423511801611,     0.000055783806430,
     0.000010286641966,     0.000002438726599,     0.000000706540480,     0.000000241815339,     0.000000095403427,     0.000000042574876,     0.000000021159290,     0.000000011555035,     0.000000006850627,     0.000000004361162,
     0.000000002951406,     0.000000002104184,     0.000000001567801,     0.203367925252026,     0.005354605571167,     0.000422954477472,     0.000055681061829,     0.000010262289987,     0.000002431673269,     0.000000704127089,
     0.000000240863430,     0.000000094978735,     0.000000042363859,     0.000000021044082,     0.000000011486746,     0.000000006807163,     0.000000004331753,     0.000000002930443,     0.000000002088566,     0.000000001555725,
     0.203314400334762,     0.005350378808736,     0.000422398179563,     0.000055578560395,     0.000010238008420,     0.000002424644026,     0.000000701723197,     0.000000239915757,     0.000000094556146,     0.000000042153992,
     0.000000020929554,     0.000000011418890,     0.000000006763992,     0.000000004302553,     0.000000002909635,     0.000000002073069,     0.000000001543746,     0.203260917657325,     0.005346157604163,     0.000421842905456,
     0.000055476301426,     0.000010213797026,     0.000002417638774,     0.000000699328760,     0.000000238972300,     0.000000094135651,     0.000000041945266,     0.000000020815702,     0.000000011351465,     0.000000006721111,
     0.000000004273560,     0.000000002888981,     0.000000002057691,     0.000000001531861,     0.203207477164187,     0.005341941947222,     0.000421288652729,     0.000055374284222,     0.000010189655565,     0.000002410657419,
     0.000000696943737,     0.000000238033037,     0.000000093717237,     0.000000041737676,     0.000000020702523,     0.000000011284467,     0.000000006678520,     0.000000004244772,     0.000000002868481,     0.000000002042431,
     0.000000001520071,     0.203154078799922,     0.005337731827712,     0.000420735418968,     0.000055272508083,     0.000010165583798,     0.000002403699868,     0.000000694568086,     0.000000237097948,     0.000000093300894,
     0.000000041531213,     0.000000020590012,     0.000000011217894,     0.000000006636215,     0.000000004216189,     0.000000002848132,     0.000000002027289,     0.000000001508375,     0.203100722509208,     0.005333527235454,
     0.000420183201766,     0.000055170972314,     0.000010141581489,     0.000002396766027,     0.000000692201764,     0.000000236167012,     0.000000092886609,     0.000000041325873,     0.000000020478164,     0.000000011151742,
     0.000000006594195,     0.000000004187809,     0.000000002827934,     0.000000002012263,     0.000000001496771,     0.203047408236823,     0.005329328160296,     0.000419631998723,     0.000055069676222,     0.000010117648399,
     0.000002389855802,     0.000000689844732,     0.000000235240209,     0.000000092474372,     0.000000041121648,     0.000000020366975,     0.000000011086009,     0.000000006552458,     0.000000004159630,     0.000000002807886,
     0.000000001997353,     0.000000001485260,     0.202994135927646,     0.005325134592107,     0.000419081807445,     0.000054968619116,     0.000010093784294,     0.000002382969101,     0.000000687496946,     0.000000234317518,
     0.000000092064173,     0.000000040918531,     0.000000020256442,     0.000000011020692,     0.000000006511002,     0.000000004131651,     0.000000002787987,     0.000000001982558,     0.000000001473840,     0.202940905526658,
     0.005320946520783,     0.000418532625546,     0.000054867800307,     0.000010069988939,     0.000002376105832,     0.000000685158368,     0.000000233398919,     0.000000091655998,     0.000000040716517,     0.000000020146560,
     0.000000010955788,     0.000000006469825,     0.000000004103870,     0.000000002768235,     0.000000001967876,     0.000000001462510,     0.202887716978941,     0.005316763936240,     0.000417984450647,     0.000054767219109,
     0.000010046262100,     0.000002369265903,     0.000000682828954,     0.000000232484391,     0.000000091249839,     0.000000040515598,     0.000000020037325,     0.000000010891294,     0.000000006428924,     0.000000004076286,
     0.000000002748629,     0.000000001953307,     0.000000001451271,     0.202834570229677,     0.005312586828421,     0.000417437280374,     0.000054666874838,     0.000010022603544,     0.000002362449223,     0.000000680508666,
     0.000000231573915,     0.000000090845683,     0.000000040315768,     0.000000019928733,     0.000000010827209,     0.000000006388298,     0.000000004048897,     0.000000002729168,     0.000000001938850,     0.000000001440120,
     0.202781465224150,     0.005308415187291,     0.000416891112363,     0.000054566766811,     0.000009999013038,     0.000002355655700,     0.000000678197463,     0.000000230667471,     0.000000090443520,     0.000000040117021,
     0.000000019820780,     0.000000010763528,     0.000000006347945,     0.000000004021702,     0.000000002709852,     0.000000001924505,     0.000000001429058,     0.202728401907743,     0.005304249002841,     0.000416345944253,
     0.000054466894351,     0.000009975490353,     0.000002348885243,     0.000000675895303,     0.000000229765038,     0.000000090043339,     0.000000039919351,     0.000000019713461,     0.000000010700249,     0.000000006307864,
     0.000000003994699,     0.000000002690678,     0.000000001910269,     0.000000001418084,     0.202675380225938,     0.005300088265081,     0.000415801773693,     0.000054367256779,     0.000009952035257,     0.000002342137763,
     0.000000673602149,     0.000000228866598,     0.000000089645129,     0.000000039722750,     0.000000019606773,     0.000000010637369,     0.000000006268051,     0.000000003967888,     0.000000002671646,     0.000000001896143,
     0.000000001407196,     0.202622400124319,     0.005295932964049,     0.000415258598337,     0.000054267853421,     0.000009928647521,     0.000002335413170,     0.000000671317958,     0.000000227972129,     0.000000089248880,
     0.000000039527213,     0.000000019500712,     0.000000010574887,     0.000000006228505,     0.000000003941266,     0.000000002652755,     0.000000001882125,     0.000000001396395,     0.202569461548567,     0.005291783089805,
     0.000414716415846,     0.000054168683605,     0.000009905326917,     0.000002328711375,     0.000000669042693,     0.000000227081614,     0.000000088854581,     0.000000039332734,     0.000000019395274,     0.000000010512798,
     0.000000006189225,     0.000000003914832,     0.000000002634003,     0.000000001868215,     0.000000001385680,     0.202516564444466,     0.005287638632431,     0.000414175223888,     0.000054069746660,     0.000009882073218,
     0.000002322032287,     0.000000666776313,     0.000000226195031,     0.000000088462222,     0.000000039139305,     0.000000019290455,     0.000000010451101,     0.000000006150208,     0.000000003888586,     0.000000002615390,
     0.000000001854411,     0.000000001375049,     0.202463708757896,     0.005283499582033,     0.000413635020139,     0.000053971041918,     0.000009858886196,     0.000002315375819,     0.000000664518779,     0.000000225312363,
     0.000000088071792,     0.000000038946922,     0.000000019186251,     0.000000010389793,     0.000000006111453,     0.000000003862524,     0.000000002596914,     0.000000001840713,     0.000000001364502,     0.202410894434835,
     0.005279365928742,     0.000413095802278,     0.000053872568714,     0.000009835765626,     0.000002308741882,     0.000000662270053,     0.000000224433589,     0.000000087683280,     0.000000038755578,     0.000000019082658,
     0.000000010328872,     0.000000006072957,     0.000000003836647,     0.000000002578575,     0.000000001827121,     0.000000001354039,     0.202358121421363,     0.005275237662709,     0.000412557567995,     0.000053774326385,
     0.000009812711284,     0.000002302130389,     0.000000660030095,     0.000000223558691,     0.000000087296677,     0.000000038565267,     0.000000018979672,     0.000000010268333,     0.000000006034719,     0.000000003810952,
     0.000000002560372,     0.000000001813632,     0.000000001343659,     0.202305389663656,     0.005271114774111,     0.000412020314983,     0.000053676314269,     0.000009789722944,     0.000002295541251,     0.000000657798866,
     0.000000222687649,     0.000000086911971,     0.000000038375983,     0.000000018877290,     0.000000010208176,     0.000000005996737,     0.000000003785439,     0.000000002542302,     0.000000001800247,     0.000000001333361,
     0.202252699107989,     0.005266997253146,     0.000411484040944,     0.000053578531707,     0.000009766800385,     0.000002288974382,     0.000000655576329,     0.000000221820445,     0.000000086529154,     0.000000038187719,
     0.000000018775508,     0.000000010148398,     0.000000005959010,     0.000000003760106,     0.000000002524366,     0.000000001786965,     0.000000001323144,     0.202200049700734,     0.005262885090036,     0.000410948743586,
     0.000053480978042,     0.000009743943383,     0.000002282429696,     0.000000653362444,     0.000000220957060,     0.000000086148213,     0.000000038000471,     0.000000018674321,     0.000000010088995,     0.000000005921534,
     0.000000003734951,     0.000000002506563,     0.000000001773784,     0.000000001313008,     0.202147441388361,     0.005258778275026,     0.000410414420623,     0.000053383652621,     0.000009721151717,     0.000002275907105,
     0.000000651157175,     0.000000220097475,     0.000000085769141,     0.000000037814231,     0.000000018573726,     0.000000010029966,     0.000000005884310,     0.000000003709974,     0.000000002488890,     0.000000001760704,
     0.000000001302952,     0.202094874117439,     0.005254676798383,     0.000409881069775,     0.000053286554791,     0.000009698425167,     0.000002269406524,     0.000000648960482,     0.000000219241671,     0.000000085391925,
     0.000000037628994,     0.000000018473720,     0.000000009971308,     0.000000005847334,     0.000000003685173,     0.000000002471348,     0.000000001747725,     0.000000001292976,     0.202042347834631,     0.005250580650398,
     0.000409348688770,     0.000053189683902,     0.000009675763513,     0.000002262927867,     0.000000646772329,     0.000000218389630,     0.000000085016558,     0.000000037444755,     0.000000018374299,     0.000000009913019,
     0.000000005810606,     0.000000003660547,     0.000000002453936,     0.000000001734845,     0.000000001283079,     0.201989862486701,     0.005246489821383,     0.000408817275342,     0.000053093039305,     0.000009653166537,
     0.000002256471049,     0.000000644592677,     0.000000217541334,     0.000000084643027,     0.000000037261506,     0.000000018275459,     0.000000009855095,     0.000000005774123,     0.000000003636094,     0.000000002436651,
     0.000000001722063,     0.000000001273259,     0.201937418020506,     0.005242404301673,     0.000408286827232,     0.000052996620356,     0.000009630634020,     0.000002250035985,     0.000000642421490,     0.000000216696763,
     0.000000084271324,     0.000000037079244,     0.000000018177196,     0.000000009797536,     0.000000005737883,     0.000000003611813,     0.000000002419494,     0.000000001709379,     0.000000001263518,     0.201885014383002,
     0.005238324081628,     0.000407757342185,     0.000052900426411,     0.000009608165745,     0.000002243622591,     0.000000640258730,     0.000000215855901,     0.000000083901439,     0.000000036897961,     0.000000018079507,
     0.000000009740337,     0.000000005701886,     0.000000003587703,     0.000000002402463,     0.000000001696792,     0.000000001253853,     0.201832651521240,     0.005234249151627,     0.000407228817956,     0.000052804456828,
     0.000009585761496,     0.000002237230782,     0.000000638104359,     0.000000215018729,     0.000000083533362,     0.000000036717652,     0.000000017982388,     0.000000009683497,     0.000000005666129,     0.000000003563763,
     0.000000002385558,     0.000000001684302,     0.000000001244265,     0.201780329382368,     0.005230179502074,     0.000406701252303,     0.000052708710968,     0.000009563421058,     0.000002230860476,     0.000000635958343,
     0.000000214185228,     0.000000083167083,     0.000000036538311,     0.000000017885836,     0.000000009627013,     0.000000005630610,     0.000000003539992,     0.000000002368777,     0.000000001671907,     0.000000001234752,
     0.201728047913629,     0.005226115123393,     0.000406174642993,     0.000052613188195,     0.000009541144215,     0.000002224511588,     0.000000633820643,     0.000000213355381,     0.000000082802592,     0.000000036359933,
     0.000000017789846,     0.000000009570884,     0.000000005595328,     0.000000003516388,     0.000000002352119,     0.000000001659606,     0.000000001225315,     0.201675807062362,     0.005222056006033,     0.000405648987798,
     0.000052517887872,     0.000009518930755,     0.000002218184035,     0.000000631691223,     0.000000212529170,     0.000000082439881,     0.000000036182512,     0.000000017694417,     0.000000009515106,     0.000000005560282,
     0.000000003492949,     0.000000002335584,     0.000000001647400,     0.000000001215952,     0.201623606776002,     0.005218002140464,     0.000405124284496,     0.000052422809369,     0.000009496780464,     0.000002211877736,
     0.000000629570047,     0.000000211706577,     0.000000082078939,     0.000000036006043,     0.000000017599543,     0.000000009459678,     0.000000005525469,     0.000000003469675,     0.000000002319171,     0.000000001635287,
     0.000000001206662,     0.201571447002079,     0.005213953517178,     0.000404600530873,     0.000052327952053,     0.000009474693130,     0.000002205592607,     0.000000627457079,     0.000000210887585,     0.000000081719757,
     0.000000035830519,     0.000000017505222,     0.000000009404596,     0.000000005490888,     0.000000003446565,     0.000000002302878,     0.000000001623267,     0.000000001197447,     0.201519327688216,     0.005209910126689,
     0.000404077724720,     0.000052233315297,     0.000009452668541,     0.000002199328567,     0.000000625352284,     0.000000210072176,     0.000000081362325,     0.000000035655937,     0.000000017411450,     0.000000009349859,
     0.000000005456537,     0.000000003423617,     0.000000002286705,     0.000000001611338,     0.000000001188303,     0.201467248782134,     0.005205871959533,     0.000403555863834,     0.000052138898474,     0.000009430706488,
     0.000002193085534,     0.000000623255624,     0.000000209260333,     0.000000081006635,     0.000000035482289,     0.000000017318224,     0.000000009295464,     0.000000005422415,     0.000000003400831,     0.000000002270651,
     0.000000001599500,     0.000000001179232,     0.201415210231646,     0.005201839006268,     0.000403034946019,     0.000052044700960,     0.000009408806761,     0.000002186863427,     0.000000621167065,     0.000000208452038,
     0.000000080652676,     0.000000035309570,     0.000000017225540,     0.000000009241410,     0.000000005388520,     0.000000003378204,     0.000000002254715,     0.000000001587753,     0.000000001170233,     0.201363211984660,
     0.005197811257476,     0.000402514969086,     0.000051950722132,     0.000009386969150,     0.000002180662166,     0.000000619086572,     0.000000207647274,     0.000000080300440,     0.000000035137776,     0.000000017133394,
     0.000000009187693,     0.000000005354850,     0.000000003355736,     0.000000002238896,     0.000000001576095,     0.000000001161304,     0.201311253989179,     0.005193788703758,     0.000401995930850,     0.000051856961370,
     0.000009365193448,     0.000002174481669,     0.000000617014108,     0.000000206846023,     0.000000079949918,     0.000000034966901,     0.000000017041785,     0.000000009134312,     0.000000005321405,     0.000000003333426,
     0.000000002223193,     0.000000001564527,     0.000000001152446,     0.201259336193299,     0.005189771335737,     0.000401477829134,     0.000051763418057,     0.000009343479448,     0.000002168321857,     0.000000614949639,
     0.000000206048270,     0.000000079601099,     0.000000034796939,     0.000000016950707,     0.000000009081264,     0.000000005288181,     0.000000003311272,     0.000000002207605,     0.000000001553046,     0.000000001143657,
     0.201207458545210,     0.005185759144060,     0.000400960661766,     0.000051670091576,     0.000009321826942,     0.000002162182650,     0.000000612893131,     0.000000205253996,     0.000000079253976,     0.000000034627885,
     0.000000016860158,     0.000000009028548,     0.000000005255179,     0.000000003289273,     0.000000002192132,     0.000000001541653,     0.000000001134938,     0.201155620993195,     0.005181752119395,     0.000400444426581,
     0.000051576981314,     0.000009300235726,     0.000002156063968,     0.000000610844548,     0.000000204463185,     0.000000078908539,     0.000000034459734,     0.000000016770135,     0.000000008976160,     0.000000005222395,
     0.000000003267429,     0.000000002176772,     0.000000001530347,     0.000000001126287,     0.201103823485630,     0.005177750252429,     0.000399929121421,     0.000051484086658,     0.000009278705595,     0.000002149965733,
     0.000000608803856,     0.000000203675819,     0.000000078564778,     0.000000034292480,     0.000000016680634,     0.000000008924099,     0.000000005189830,     0.000000003245737,     0.000000002161524,     0.000000001519127,
     0.000000001117705,     0.201052065970985,     0.005173753533873,     0.000399414744131,     0.000051391406999,     0.000009257236344,     0.000002143887865,     0.000000606771020,     0.000000202891883,     0.000000078222686,
     0.000000034126119,     0.000000016591652,     0.000000008872363,     0.000000005157480,     0.000000003224198,     0.000000002146389,     0.000000001507993,     0.000000001109190,     0.201000348397822,     0.005169761954460,
     0.000398901292566,     0.000051298941729,     0.000009235827770,     0.000002137830286,     0.000000604746007,     0.000000202111360,     0.000000077882253,     0.000000033960645,     0.000000016503186,     0.000000008820949,
     0.000000005125345,     0.000000003202809,     0.000000002131364,     0.000000001496943,     0.000000001100742,     0.200948670714796,     0.005165775504943,     0.000398388764584,     0.000051206690242,     0.000009214479671,
     0.000002131792919,     0.000000602728782,     0.000000201334233,     0.000000077543470,     0.000000033796054,     0.000000016415232,     0.000000008769855,     0.000000005093423,     0.000000003181570,     0.000000002116450,
     0.000000001485978,     0.000000001092360,     0.200897032870654,     0.005161794176097,     0.000397877158051,     0.000051114651935,     0.000009193191845,     0.000002125775685,     0.000000600719311,     0.000000200560485,
     0.000000077206329,     0.000000033632339,     0.000000016327788,     0.000000008719080,     0.000000005061713,     0.000000003160480,     0.000000002101644,     0.000000001475096,     0.000000001084045,     0.200845434814236,
     0.005157817958718,     0.000397366470837,     0.000051022826205,     0.000009171964090,     0.000002119778507,     0.000000598717561,     0.000000199790101,     0.000000076870821,     0.000000033469496,     0.000000016240849,
     0.000000008668620,     0.000000005030213,     0.000000003139537,     0.000000002086948,     0.000000001464297,     0.000000001075795,     0.200793876494472,     0.005153846843623,     0.000396856700820,     0.000050931212453,
     0.000009150796208,     0.000002113801308,     0.000000596723498,     0.000000199023063,     0.000000076536936,     0.000000033307520,     0.000000016154414,     0.000000008618475,     0.000000004998922,     0.000000003118741,
     0.000000002072358,     0.000000001453580,     0.000000001067609,     0.200742357860386,     0.005149880821651,     0.000396347845883,     0.000050839810082,     0.000009129687998,     0.000002107844011,     0.000000594737088,
     0.000000198259357,     0.000000076204667,     0.000000033146406,     0.000000016068479,     0.000000008568641,     0.000000004967838,     0.000000003098090,     0.000000002057876,     0.000000001442944,     0.000000001059488,
     0.200690878861093,     0.005145919883662,     0.000395839903916,     0.000050748618495,     0.000009108639261,     0.000002101906541,     0.000000592758299,     0.000000197498965,     0.000000075874005,     0.000000032986149,
     0.000000015983040,     0.000000008519117,     0.000000004936960,     0.000000003077583,     0.000000002043499,     0.000000001432390,     0.000000001051431,     0.200639439445797,     0.005141964020537,     0.000395332872813,
     0.000050657637099,     0.000009087649801,     0.000002095988820,     0.000000590787098,     0.000000196741871,     0.000000075544941,     0.000000032826744,     0.000000015898095,     0.000000008469901,     0.000000004906286,
     0.000000003057219,     0.000000002029228,     0.000000001421916,     0.000000001043437,     0.200588039563796,     0.005138013223177,     0.000394826750475,     0.000050566865302,     0.000009066719420,     0.000002090090774,
     0.000000588823451,     0.000000195988061,     0.000000075217468,     0.000000032668186,     0.000000015813641,     0.000000008420991,     0.000000004875815,     0.000000003036998,     0.000000002015061,     0.000000001411521,
     0.000000001035506,     0.200536679164478,     0.005134067482505,     0.000394321534810,     0.000050476302515,     0.000009045847920,     0.000002084212326,     0.000000586867326,     0.000000195237517,     0.000000074891575,
     0.000000032510470,     0.000000015729675,     0.000000008372384,     0.000000004845545,     0.000000003016918,     0.000000002000997,     0.000000001401205,     0.000000001027638,     0.200485358197320,     0.005130126789465,
     0.000393817223730,     0.000050385948148,     0.000009025035108,     0.000002078353402,     0.000000584918690,     0.000000194490224,     0.000000074567255,     0.000000032353591,     0.000000015646192,     0.000000008324079,
     0.000000004815476,     0.000000002996978,     0.000000001987036,     0.000000001390968,     0.000000001019831,     0.200434076611893,     0.005126191135022,     0.000393313815154,     0.000050295801617,     0.000009004280787,
     0.000002072513927,     0.000000582977511,     0.000000193746166,     0.000000074244500,     0.000000032197544,     0.000000015563192,     0.000000008276074,     0.000000004785605,     0.000000002977177,     0.000000001973177,
     0.000000001380808,     0.000000001012085,     0.200382834357855,     0.005122260510161,     0.000392811307007,     0.000050205862338,     0.000008983584765,     0.000002066693827,     0.000000581043756,     0.000000193005329,
     0.000000073923302,     0.000000032042325,     0.000000015480670,     0.000000008228367,     0.000000004755932,     0.000000002957514,     0.000000001959420,     0.000000001370726,     0.000000001004400,     0.200331631384955,
     0.005118334905887,     0.000392309697219,     0.000050116129728,     0.000008962946847,     0.000002060893027,     0.000000579117393,     0.000000192267695,     0.000000073603651,     0.000000031887929,     0.000000015398624,
     0.000000008180955,     0.000000004726455,     0.000000002937988,     0.000000001945763,     0.000000001360720,     0.000000000996776,     0.200280467643032,     0.005114414313229,     0.000391808983725,     0.000050026603208,
     0.000008942366840,     0.000002055111455,     0.000000577198391,     0.000000191533251,     0.000000073285540,     0.000000031734351,     0.000000015317050,     0.000000008133837,     0.000000004697172,     0.000000002918598,
     0.000000001932205,     0.000000001350790,     0.000000000989211,     0.200229343082015,     0.005110498723232,     0.000391309164469,     0.000049937282199,     0.000008921844554,     0.000002049349035,     0.000000575286718,
     0.000000190801979,     0.000000072968961,     0.000000031581587,     0.000000015235946,     0.000000008087011,     0.000000004668082,     0.000000002899343,     0.000000001918747,     0.000000001340936,     0.000000000981706,
     0.200178257651921,     0.005106588126965,     0.000390810237398,     0.000049848166125,     0.000008901379796,     0.000002043605696,     0.000000573382341,     0.000000190073866,     0.000000072653906,     0.000000031429631,
     0.000000015155309,     0.000000008040475,     0.000000004639185,     0.000000002880223,     0.000000001905386,     0.000000001331156,     0.000000000974259,     0.200127211302859,     0.005102682515517,     0.000390312200466,
     0.000049759254412,     0.000008880972376,     0.000002037881364,     0.000000571485230,     0.000000189348896,     0.000000072340366,     0.000000031278479,     0.000000015075135,     0.000000007994226,     0.000000004610477,
     0.000000002861235,     0.000000001892123,     0.000000001321450,     0.000000000966871,     0.200076203985024,     0.005098781879996,     0.000389815051631,     0.000049670546487,     0.000008860622105,     0.000002032175967,
     0.000000569595353,     0.000000188627054,     0.000000072028334,     0.000000031128126,     0.000000014995423,     0.000000007948264,     0.000000004581959,     0.000000002842380,     0.000000001878957,     0.000000001311818,
     0.000000000959541,     0.200025235648702,     0.005094886211531,     0.000389318788859,     0.000049582041780,     0.000008840328794,     0.000002026489433,     0.000000567712679,     0.000000187908324,     0.000000071717801,
     0.000000030978569,     0.000000014916169,     0.000000007902587,     0.000000004553629,     0.000000002823656,     0.000000001865887,     0.000000001302259,     0.000000000952268,     0.199974306244266,     0.005090995501272,
     0.000388823410120,     0.000049493739722,     0.000008820092254,     0.000002020821690,     0.000000565837176,     0.000000187192693,     0.000000071408760,     0.000000030829801,     0.000000014837371,     0.000000007857191,
     0.000000004525486,     0.000000002805062,     0.000000001852911,     0.000000001292773,     0.000000000945052,     0.199923415722179,     0.005087109740388,     0.000388328913391,     0.000049405639746,     0.000008799912298,
     0.000002015172666,     0.000000563968814,     0.000000186480144,     0.000000071101202,     0.000000030681820,     0.000000014759024,     0.000000007812076,     0.000000004497528,     0.000000002786597,     0.000000001840031,
     0.000000001283358,     0.000000000937893,     0.199872564032990,     0.005083228920071,     0.000387835296653,     0.000049317741288,     0.000008779788739,     0.000002009542290,     0.000000562107563,     0.000000185770664,
     0.000000070795121,     0.000000030534620,     0.000000014681128,     0.000000007767240,     0.000000004469754,     0.000000002768261,     0.000000001827244,     0.000000001274015,     0.000000000930790,     0.199821751127338,
     0.005079353031529,     0.000387342557895,     0.000049230043784,     0.000008759721390,     0.000002003930491,     0.000000560253391,     0.000000185064237,     0.000000070490507,     0.000000030388196,     0.000000014603679,
     0.000000007722681,     0.000000004442162,     0.000000002750052,     0.000000001814550,     0.000000001264742,     0.000000000923742,     0.199770976955950,     0.005075482065993,     0.000386850695109,     0.000049142546674,
     0.000008739710067,     0.000001998337198,     0.000000558406268,     0.000000184360849,     0.000000070187354,     0.000000030242544,     0.000000014526674,     0.000000007678396,     0.000000004414752,     0.000000002731970,
     0.000000001801949,     0.000000001255540,     0.000000000916750,     0.199720241469638,     0.005071616014713,     0.000386359706295,     0.000049055249397,     0.000008719754585,     0.000001992762342,     0.000000556566164,
     0.000000183660485,     0.000000069885654,     0.000000030097661,     0.000000014450110,     0.000000007634385,     0.000000004387522,     0.000000002714013,     0.000000001789439,     0.000000001246407,     0.000000000909812,
     0.199669544619304,     0.005067754868960,     0.000385869589457,     0.000048968151396,     0.000008699854759,     0.000001987205852,     0.000000554733048,     0.000000182963131,     0.000000069585398,     0.000000029953541,
     0.000000014373985,     0.000000007590645,     0.000000004360471,     0.000000002696181,     0.000000001777021,     0.000000001237343,     0.000000000902928,     0.199618886355936,     0.005063898620024,     0.000385380342605,
     0.000048881252117,     0.000008680010407,     0.000001981667658,     0.000000552906891,     0.000000182268772,     0.000000069286580,     0.000000029810180,     0.000000014298296,     0.000000007547175,     0.000000004333598,
     0.000000002678472,     0.000000001764692,     0.000000001228348,     0.000000000896099,     0.199568266630609,     0.005060047259215,     0.000384891963754,     0.000048794551004,     0.000008660221345,     0.000001976147691,
     0.000000551087663,     0.000000181577395,     0.000000068989192,     0.000000029667573,     0.000000014223041,     0.000000007503973,     0.000000004306902,     0.000000002660887,     0.000000001752453,     0.000000001219421,
     0.000000000889323,     0.199517685394486,     0.005056200777862,     0.000384404450926,     0.000048708047506,     0.000008640487392,     0.000001970645882,     0.000000549275334,     0.000000180888984,     0.000000068693227,
     0.000000029525718,     0.000000014148216,     0.000000007461036,     0.000000004280380,     0.000000002643423,     0.000000001740304,     0.000000001210562,     0.000000000882599,     0.199467142598816,     0.005052359167316,
     0.000383917802147,     0.000048621741073,     0.000008620808367,     0.000001965162161,     0.000000547469873,     0.000000180203525,     0.000000068398676,     0.000000029384608,     0.000000014073819,     0.000000007418364,
     0.000000004254033,     0.000000002626080,     0.000000001728242,     0.000000001201769,     0.000000000875929,     0.199416638194933,     0.005048522418946,     0.000383432015450,     0.000048535631156,     0.000008601184089,
     0.000001959696461,     0.000000545671253,     0.000000179521006,     0.000000068105532,     0.000000029244240,     0.000000013999848,     0.000000007375955,     0.000000004227858,     0.000000002608858,     0.000000001716268,
     0.000000001193043,     0.000000000869310,     0.199366172134259,     0.005044690524140,     0.000382947088871,     0.000048449717209,     0.000008581614378,     0.000001954248714,     0.000000543879444,     0.000000178841410,
     0.000000067813788,     0.000000029104609,     0.000000013926299,     0.000000007333807,     0.000000004201855,     0.000000002591754,     0.000000001704381,     0.000000001184383,     0.000000000862744,     0.199315744368300,
     0.005040863474308,     0.000382463020454,     0.000048363998687,     0.000008562099055,     0.000001948818850,     0.000000542094415,     0.000000178164725,     0.000000067523437,     0.000000028965712,     0.000000013853171,
     0.000000007291917,     0.000000004176023,     0.000000002574770,     0.000000001692580,     0.000000001175788,     0.000000000856228,     0.199265354848651,     0.005037041260877,     0.000381979808248,     0.000048278475048,
     0.000008542637942,     0.000001943406803,     0.000000540316139,     0.000000177490937,     0.000000067234472,     0.000000028827545,     0.000000013780460,     0.000000007250286,     0.000000004150359,     0.000000002557903,
     0.000000001680865,     0.000000001167258,     0.000000000849763,     0.199215003526990,     0.005033223875295,     0.000381497450305,     0.000048193145749,     0.000008523230860,     0.000001938012505,     0.000000538544587,
     0.000000176820031,     0.000000066946884,     0.000000028690102,     0.000000013708164,     0.000000007208910,     0.000000004124864,     0.000000002541152,     0.000000001669235,     0.000000001158792,     0.000000000843349,
     0.199164690355081,     0.005029411309030,     0.000381015944687,     0.000048108010251,     0.000008503877633,     0.000001932635889,     0.000000536779729,     0.000000176151994,     0.000000066660667,     0.000000028553380,
     0.000000013636281,     0.000000007167788,     0.000000004099536,     0.000000002524518,     0.000000001657689,     0.000000001150391,     0.000000000836985,     0.199114415284773,     0.005025603553567,     0.000380535289456,
     0.000048023068017,     0.000008484578084,     0.000001927276888,     0.000000535021538,     0.000000175486813,     0.000000066375814,     0.000000028417375,     0.000000013564807,     0.000000007126918,     0.000000004074373,
     0.000000002507998,     0.000000001646227,     0.000000001142053,     0.000000000830671,     0.199064178268002,     0.005021800600413,     0.000380055482684,     0.000047938318511,     0.000008465332037,     0.000001921935436,
     0.000000533269984,     0.000000174824474,     0.000000066092317,     0.000000028282082,     0.000000013493742,     0.000000007086300,     0.000000004049376,     0.000000002491593,     0.000000001634848,     0.000000001133777,
     0.000000000824406,     0.199013979256785,     0.005018002441092,     0.000379576522445,     0.000047853761198,     0.000008446139317,     0.000001916611466,     0.000000531525039,     0.000000174164962,     0.000000065810170,
     0.000000028147499,     0.000000013423081,     0.000000007045930,     0.000000004024541,     0.000000002475301,     0.000000001623551,     0.000000001125564,     0.000000000818190,     0.198963818203229,     0.005014209067148,
     0.000379098406821,     0.000047769395547,     0.000008426999749,     0.000001911304913,     0.000000529786675,     0.000000173508266,     0.000000065529365,     0.000000028013619,     0.000000013352822,     0.000000007005808,
     0.000000003999869,     0.000000002459122,     0.000000001612336,     0.000000001117413,     0.000000000812022,     0.198913695059520,     0.005010420470146,     0.000378621133897,     0.000047685221027,     0.000008407913160,
     0.000001906015711,     0.000000528054864,     0.000000172854371,     0.000000065249895,     0.000000027880441,     0.000000013282964,     0.000000006965932,     0.000000003975358,     0.000000002443054,     0.000000001601202,
     0.000000001109324,     0.000000000805902,     0.198863609777931,     0.005006636641668,     0.000378144701765,     0.000047601237108,     0.000008388879377,     0.000001900743794,     0.000000526329578,     0.000000172203263,
     0.000000064971754,     0.000000027747959,     0.000000013213503,     0.000000006926301,     0.000000003951008,     0.000000002427097,     0.000000001590149,     0.000000001101295,     0.000000000799830,     0.198813562310819,
     0.005002857573315,     0.000377669108521,     0.000047517443264,     0.000008369898227,     0.000001895489098,     0.000000524610790,     0.000000171554931,     0.000000064694934,     0.000000027616169,     0.000000013144437,
     0.000000006886912,     0.000000003926816,     0.000000002411251,     0.000000001579176,     0.000000001093327,     0.000000000793806,     0.198763552610625,     0.004999083256707,     0.000377194352268,     0.000047433838969,
     0.000008350969538,     0.000001890251557,     0.000000522898470,     0.000000170909360,     0.000000064419428,     0.000000027485069,     0.000000013075764,     0.000000006847764,     0.000000003902782,     0.000000002395513,
     0.000000001568283,     0.000000001085419,     0.000000000787828,     0.198713580629874,     0.004995313683485,     0.000376720431112,     0.000047350423699,     0.000008332093139,     0.000001885031107,     0.000000521192593,
     0.000000170266538,     0.000000064145230,     0.000000027354653,     0.000000013007481,     0.000000006808856,     0.000000003878905,     0.000000002379885,     0.000000001557468,     0.000000001077570,     0.000000000781897,
     0.198663646321172,     0.004991548845308,     0.000376247343166,     0.000047267196932,     0.000008313268859,     0.000001879827684,     0.000000519493130,     0.000000169626451,     0.000000063872333,     0.000000027224918,
     0.000000012939586,     0.000000006770185,     0.000000003855184,     0.000000002364364,     0.000000001546731,     0.000000001069781,     0.000000000776012,     0.198613749637212,     0.004987788733851,     0.000375775086547,
     0.000047184158148,     0.000008294496529,     0.000001874641223,     0.000000517800055,     0.000000168989087,     0.000000063600729,     0.000000027095860,     0.000000012872076,     0.000000006731751,     0.000000003831618,
     0.000000002348950,     0.000000001536072,     0.000000001062050,     0.000000000770173,     0.198563890530767,     0.004984033340812,     0.000375303659378,     0.000047101306829,     0.000008275775978,     0.000001869471661,
     0.000000516113340,     0.000000168354433,     0.000000063330413,     0.000000026967475,     0.000000012804950,     0.000000006693552,     0.000000003808205,     0.000000002333642,     0.000000001525490,     0.000000001054377,
     0.000000000764379,     0.198514068954695,     0.004980282657905,     0.000374833059787,     0.000047018642457,     0.000008257107039,     0.000001864318935,     0.000000514432957,     0.000000167722475,     0.000000063061378,
     0.000000026839760,     0.000000012738204,     0.000000006655587,     0.000000003784945,     0.000000002318440,     0.000000001514984,     0.000000001046762,     0.000000000758631,     0.198464284861936,     0.004976536676864,
     0.000374363285907,     0.000046936164517,     0.000008238489544,     0.000001859182981,     0.000000512758881,     0.000000167093201,     0.000000062793616,     0.000000026712710,     0.000000012671837,     0.000000006617853,
     0.000000003761836,     0.000000002303342,     0.000000001504554,     0.000000001039204,     0.000000000752927,     0.198414538205512,     0.004972795389441,     0.000373894335877,     0.000046853872495,     0.000008219923324,
     0.000001854063736,     0.000000511091084,     0.000000166466598,     0.000000062527121,     0.000000026586322,     0.000000012605847,     0.000000006580350,     0.000000003738877,     0.000000002288348,     0.000000001494200,
     0.000000001031703,     0.000000000747268,     0.198364828938529,     0.004969058787406,     0.000373426207839,     0.000046771765880,     0.000008201408214,     0.000001848961139,     0.000000509429540,     0.000000165842654,
     0.000000062261887,     0.000000026460592,     0.000000012540230,     0.000000006543075,     0.000000003716068,     0.000000002273458,     0.000000001483920,     0.000000001024259,     0.000000000741652,     0.198315157014174,
     0.004965326862550,     0.000372958899943,     0.000046689844161,     0.000008182944046,     0.000001843875125,     0.000000507774223,     0.000000165221356,     0.000000061997907,     0.000000026335516,     0.000000012474984,
     0.000000006506028,     0.000000003693408,     0.000000002258670,     0.000000001473715,     0.000000001016870,     0.000000000736080,     0.198265522385715,     0.004961599606680,     0.000372492410342,     0.000046608106830,
     0.000008164530656,     0.000001838805633,     0.000000506125105,     0.000000164602692,     0.000000061735175,     0.000000026211091,     0.000000012410108,     0.000000006469206,     0.000000003670895,     0.000000002243983,
     0.000000001463583,     0.000000001009537,     0.000000000730552,     0.198215925006504,     0.004957877011622,     0.000372026737194,     0.000046526553379,     0.000008146167879,     0.000001833752602,     0.000000504482160,
     0.000000163986649,     0.000000061473683,     0.000000026087312,     0.000000012345599,     0.000000006432609,     0.000000003648528,     0.000000002229398,     0.000000001453524,     0.000000001002259,     0.000000000725067,
     0.198166364829974,     0.004954159069221,     0.000371561878663,     0.000046445183304,     0.000008127855549,     0.000001828715970,     0.000000502845363,     0.000000163373214,     0.000000061213426,     0.000000025964177,
     0.000000012281455,     0.000000006396235,     0.000000003626306,     0.000000002214913,     0.000000001443537,     0.000000000995036,     0.000000000719624,     0.198116841809638,     0.004950445771339,     0.000371097832918,
     0.000046363996101,     0.000008109593505,     0.000001823695675,     0.000000501214687,     0.000000162762376,     0.000000060954398,     0.000000025841682,     0.000000012217674,     0.000000006360083,     0.000000003604229,
     0.000000002200527,     0.000000001433623,     0.000000000987866,     0.000000000714223,     0.198067355899092,     0.004946737109859,     0.000370634598133,     0.000046282991267,     0.000008091381582,     0.000001818691656,
     0.000000499590107,     0.000000162154122,     0.000000060696591,     0.000000025719823,     0.000000012154253,     0.000000006324150,     0.000000003582296,     0.000000002186240,     0.000000001423780,     0.000000000980751,
     0.000000000708865,     0.198017907052013,     0.004943033076679,     0.000370172172486,     0.000046202168302,     0.000008073219618,     0.000001813703852,     0.000000497971596,     0.000000161548440,     0.000000060439999,
     0.000000025598596,     0.000000012091190,     0.000000006288436,     0.000000003560504,     0.000000002172051,     0.000000001414008,     0.000000000973689,     0.000000000703548,     0.197968495222158,     0.004939333663718,
     0.000369710554162,     0.000046121526708,     0.000008055107451,     0.000001808732204,     0.000000496359129,     0.000000160945318,     0.000000060184617,     0.000000025477998,     0.000000012028484,     0.000000006252940,
     0.000000003538854,     0.000000002157960,     0.000000001404306,     0.000000000966680,     0.000000000698272,     0.197919120363365,     0.004935638862911,     0.000369249741349,     0.000046041065988,     0.000008037044920,
     0.000001803776650,     0.000000494752681,     0.000000160344744,     0.000000059930437,     0.000000025358025,     0.000000011966131,     0.000000006217659,     0.000000003517345,     0.000000002143965,     0.000000001394674,
     0.000000000959723,     0.000000000693037,     0.197869782429553,     0.004931948666212,     0.000368789732241,     0.000045960785645,     0.000008019031864,     0.000001798837130,     0.000000493152226,     0.000000159746705,
     0.000000059677454,     0.000000025238674,     0.000000011904130,     0.000000006182592,     0.000000003495975,     0.000000002130066,     0.000000001385111,     0.000000000952819,     0.000000000687843,     0.197820481374720,
     0.004928263065593,     0.000368330525037,     0.000045880685186,     0.000008001068124,     0.000001793913585,     0.000000491557739,     0.000000159151191,     0.000000059425662,     0.000000025119941,     0.000000011842478,
     0.000000006147739,     0.000000003474743,     0.000000002116262,     0.000000001375617,     0.000000000945966,     0.000000000682689,     0.197771217152947,     0.004924582053044,     0.000367872117939,     0.000045800764119,
     0.000007983153540,     0.000001789005955,     0.000000489969194,     0.000000158558188,     0.000000059175053,     0.000000025001823,     0.000000011781174,     0.000000006113097,     0.000000003453649,     0.000000002102553,
     0.000000001366192,     0.000000000939165,     0.000000000677576,     0.197721989718392,     0.004920905620573,     0.000367414509158,     0.000045721021952,     0.000007965287952,     0.000001784114182,     0.000000488386567,
     0.000000157967686,     0.000000058925623,     0.000000024884317,     0.000000011720216,     0.000000006078665,     0.000000003432692,     0.000000002088938,     0.000000001356834,     0.000000000932415,     0.000000000672501,
     0.197672799025295,     0.004917233760206,     0.000366957696906,     0.000045641458197,     0.000007947471203,     0.000001779238204,     0.000000486809832,     0.000000157379672,     0.000000058677365,     0.000000024767418,
     0.000000011659600,     0.000000006044443,     0.000000003411870,     0.000000002075416,     0.000000001347543,     0.000000000925715,     0.000000000667467,     0.197623645027975,     0.004913566463986,     0.000366501679401,
     0.000045562072366,     0.000007929703135,     0.000001774377965,     0.000000485238965,     0.000000156794135,     0.000000058430273,     0.000000024651123,     0.000000011599326,     0.000000006010428,     0.000000003391183,
     0.000000002061987,     0.000000001338319,     0.000000000919065,     0.000000000662471,     0.197574527680828,     0.004909903723975,     0.000366046454867,     0.000045482863973,     0.000007911983592,     0.000001769533406,
     0.000000483673941,     0.000000156211062,     0.000000058184340,     0.000000024535430,     0.000000011539391,     0.000000005976619,     0.000000003370630,     0.000000002048650,     0.000000001329162,     0.000000000912465,
     0.000000000657514,     0.197525446938334,     0.004906245532251,     0.000365592021532,     0.000045403832533,     0.000007894312415,     0.000001764704467,     0.000000482114735,     0.000000155630444,     0.000000057939562,
     0.000000024420334,     0.000000011479793,     0.000000005943014,     0.000000003350210,     0.000000002035404,     0.000000001320070,     0.000000000905915,     0.000000000652595,     0.197476402755049,     0.004902591880913,
     0.000365138377628,     0.000045324977564,     0.000007876689450,     0.000001759891092,     0.000000480561324,     0.000000155052267,     0.000000057695932,     0.000000024305833,     0.000000011420530,     0.000000005909614,
     0.000000003329922,     0.000000002022248,     0.000000001311043,     0.000000000899413,     0.000000000647714,     0.197427395085607,     0.004898942762073,     0.000364685521394,     0.000045246298584,     0.000007859114542,
     0.000001755093221,     0.000000479013682,     0.000000154476521,     0.000000057453443,     0.000000024191923,     0.000000011361600,     0.000000005876416,     0.000000003309764,     0.000000002009183,     0.000000001302081,
     0.000000000892961,     0.000000000642872,     0.197378423884725,     0.004895298167865,     0.000364233451071,     0.000045167795113,     0.000007841587535,     0.000001750310799,     0.000000477471785,     0.000000153903195,
     0.000000057212091,     0.000000024078600,     0.000000011303001,     0.000000005843418,     0.000000003289738,     0.000000001996206,     0.000000001293184,     0.000000000886556,     0.000000000638066,     0.197329489107194,
     0.004891658090438,     0.000363782164908,     0.000045089466674,     0.000007824108274,     0.000001745543767,     0.000000475935610,     0.000000153332276,     0.000000056971869,     0.000000023965862,     0.000000011244731,
     0.000000005810620,     0.000000003269840,     0.000000001983319,     0.000000001284350,     0.000000000880199,     0.000000000633298,     0.197280590707887,     0.004888022521959,     0.000363331661156,     0.000045011312789,
     0.000007806676608,     0.000001740792068,     0.000000474405132,     0.000000152763754,     0.000000056732772,     0.000000023853704,     0.000000011186788,     0.000000005778021,     0.000000003250071,     0.000000001970519,
     0.000000001275580,     0.000000000873890,     0.000000000628567,     0.197231728641751,     0.004884391454613,     0.000362881938072,     0.000044933332983,     0.000007789292382,     0.000001736055645,     0.000000472880327,
     0.000000152197617,     0.000000056494793,     0.000000023742125,     0.000000011129170,     0.000000005745619,     0.000000003230429,     0.000000001957807,     0.000000001266872,     0.000000000867628,     0.000000000623872,
     0.197182902863816,     0.004880764880601,     0.000362432993918,     0.000044855526784,     0.000007771955444,     0.000001731334442,     0.000000471361172,     0.000000151633854,     0.000000056257928,     0.000000023631120,
     0.000000011071875,     0.000000005713412,     0.000000003210914,     0.000000001945181,     0.000000001258227,     0.000000000861412,     0.000000000619214,     0.197134113329188,     0.004877142792144,     0.000361984826959,
     0.000044777893717,     0.000007754665643,     0.000001726628403,     0.000000469847642,     0.000000151072454,     0.000000056022169,     0.000000023520686,     0.000000011014901,     0.000000005681400,     0.000000003191525,
     0.000000001932642,     0.000000001249644,     0.000000000855243,     0.000000000614592,     0.197085359993048,     0.004873525181477,     0.000361537435468,     0.000044700433314,     0.000007737422826,     0.000001721937471,
     0.000000468339715,     0.000000150513407,     0.000000055787512,     0.000000023410821,     0.000000010958246,     0.000000005649581,     0.000000003172261,     0.000000001920188,     0.000000001241122,     0.000000000849120,
     0.000000000610005,     0.197036642810658,     0.004869912040855,     0.000361090817719,     0.000044623145105,     0.000007720226843,     0.000001717261590,     0.000000466837366,     0.000000149956701,     0.000000055553951,
     0.000000023301520,     0.000000010901909,     0.000000005617954,     0.000000003153121,     0.000000001907820,     0.000000001232661,     0.000000000843043,     0.000000000605454,     0.196987961737356,     0.004866303362549,
     0.000360644971993,     0.000044546028622,     0.000007703077544,     0.000001712600705,     0.000000465340573,     0.000000149402324,     0.000000055321480,     0.000000023192782,     0.000000010845887,     0.000000005586518,
     0.000000003134105,     0.000000001895535,     0.000000001224261,     0.000000000837011,     0.000000000600938,     0.196939316728558,     0.004862699138848,     0.000360199896576,     0.000044469083399,     0.000007685974779,
     0.000001707954760,     0.000000463849312,     0.000000148850267,     0.000000055090093,     0.000000023084601,     0.000000010790178,     0.000000005555272,     0.000000003115210,     0.000000001883334,     0.000000001215921,
     0.000000000831024,     0.000000000596457,     0.196890707739756,     0.004859099362056,     0.000359755589756,     0.000044392308971,     0.000007668918399,     0.000001703323700,     0.000000462363560,     0.000000148300519,
     0.000000054859786,     0.000000022976977,     0.000000010734781,     0.000000005524214,     0.000000003096438,     0.000000001871216,     0.000000001207640,     0.000000000825082,     0.000000000592011,     0.196842134726520,
     0.004855504024496,     0.000359312049828,     0.000044315704877,     0.000007651908256,     0.000001698707471,     0.000000460883294,     0.000000147753068,     0.000000054630552,     0.000000022869905,     0.000000010679693,
     0.000000005493343,     0.000000003077786,     0.000000001859181,     0.000000001199419,     0.000000000819184,     0.000000000587599,     0.196793597644494,     0.004851913118509,     0.000358869275092,     0.000044239270653,
     0.000007634944201,     0.000001694106016,     0.000000459408491,     0.000000147207904,     0.000000054402386,     0.000000022763382,     0.000000010624913,     0.000000005462657,     0.000000003059254,     0.000000001847228,
     0.000000001191257,     0.000000000813330,     0.000000000583221,     0.196745096449403,     0.004848326636449,     0.000358427263851,     0.000044163005840,     0.000007618026087,     0.000001689519283,     0.000000457939128,
     0.000000146665017,     0.000000054175283,     0.000000022657406,     0.000000010570439,     0.000000005432157,     0.000000003040841,     0.000000001835356,     0.000000001183152,     0.000000000807519,     0.000000000578877,
     0.196696631097044,     0.004844744570692,     0.000357986014412,     0.000044086909978,     0.000007601153766,     0.000001684947216,     0.000000456475183,     0.000000146124395,     0.000000053949236,     0.000000022551972,
     0.000000010516269,     0.000000005401840,     0.000000003022546,     0.000000001823565,     0.000000001175106,     0.000000000801752,     0.000000000574566,     0.196648201543293,     0.004841166913627,     0.000357545525089,
     0.000044010982612,     0.000007584327093,     0.000001680389761,     0.000000455016633,     0.000000145586029,     0.000000053724241,     0.000000022447079,     0.000000010462402,     0.000000005371706,     0.000000003004369,
     0.000000001811853,     0.000000001167117,     0.000000000796028,     0.000000000570288,     0.196599807744101,     0.004837593657662,     0.000357105794200,     0.000043935223285,     0.000007567545922,     0.000001675846865,
     0.000000453563455,     0.000000145049907,     0.000000053500293,     0.000000022342723,     0.000000010408835,     0.000000005341752,     0.000000002986309,     0.000000001800222,     0.000000001159185,     0.000000000790346,
     0.000000000566044,     0.196551449655495,     0.004834024795221,     0.000356666820065,     0.000043859631542,     0.000007550810108,     0.000001671318474,     0.000000452115627,     0.000000144516019,     0.000000053277385,
     0.000000022238901,     0.000000010355566,     0.000000005311979,     0.000000002968365,     0.000000001788670,     0.000000001151310,     0.000000000784707,     0.000000000561832,     0.196503127233577,     0.004830460318744,
     0.000356228601012,     0.000043784206932,     0.000007534119505,     0.000001666804535,     0.000000450673127,     0.000000143984356,     0.000000053055513,     0.000000022135611,     0.000000010302594,     0.000000005282385,
     0.000000002950535,     0.000000001777196,     0.000000001143491,     0.000000000779109,     0.000000000557653,     0.196454840434526,     0.004826900220689,     0.000355791135371,     0.000043708949002,     0.000007517473969,
     0.000001662304994,     0.000000449235933,     0.000000143454906,     0.000000052834671,     0.000000022032849,     0.000000010249918,     0.000000005252968,     0.000000002932821,     0.000000001765800,     0.000000001135728,
     0.000000000773554,     0.000000000553506,     0.196406589214594,     0.004823344493531,     0.000355354421478,     0.000043633857303,     0.000007500873357,     0.000001657819799,     0.000000447804022,     0.000000142927659,
     0.000000052614854,     0.000000021930612,     0.000000010197534,     0.000000005223728,     0.000000002915219,     0.000000001754481,     0.000000001128020,     0.000000000768039,     0.000000000549391,     0.196358373530110,
     0.004819793129759,     0.000354918457672,     0.000043558931386,     0.000007484317526,     0.000001653348896,     0.000000446377372,     0.000000142402605,     0.000000052396057,     0.000000021828897,     0.000000010145443,
     0.000000005194663,     0.000000002897731,     0.000000001743239,     0.000000001120367,     0.000000000762566,     0.000000000545308,     0.196310193337479,     0.004816246121883,     0.000354483242299,     0.000043484170804,
     0.000007467806332,     0.000001648892234,     0.000000444955962,     0.000000141879734,     0.000000052178275,     0.000000021727702,     0.000000010093641,     0.000000005165773,     0.000000002880354,     0.000000001732073,
     0.000000001112768,     0.000000000757133,     0.000000000541256,     0.196262048593178,     0.004812703462424,     0.000354048773707,     0.000043409575111,     0.000007451339634,     0.000001644449759,     0.000000443539770,
     0.000000141359036,     0.000000051961501,     0.000000021627023,     0.000000010042127,     0.000000005137056,     0.000000002863089,     0.000000001720983,     0.000000001105224,     0.000000000751741,     0.000000000537235,
     0.196213939253761,     0.004809165143925,     0.000353615050249,     0.000043335143863,     0.000007434917289,     0.000001640021421,     0.000000442128774,     0.000000140840501,     0.000000051745732,     0.000000021526858,
     0.000000009990899,     0.000000005108511,     0.000000002845934,     0.000000001709969,     0.000000001097733,     0.000000000746388,     0.000000000533245,     0.196165865275854,     0.004805631158941,     0.000353182070283,
     0.000043260876618,     0.000007418539158,     0.000001635607167,     0.000000440722953,     0.000000140324118,     0.000000051530962,     0.000000021427204,     0.000000009939956,     0.000000005080137,     0.000000002828889,
     0.000000001699029,     0.000000001090296,     0.000000000741076,     0.000000000529286,     0.196117826616161,     0.004802101500046,     0.000352749832171,     0.000043186772933,     0.000007402205099,     0.000001631206945,
     0.000000439322285,     0.000000139809878,     0.000000051317187,     0.000000021328058,     0.000000009889296,     0.000000005051933,     0.000000002811953,     0.000000001688163,     0.000000001082912,     0.000000000735802,
     0.000000000525357,     0.196069823231458,     0.004798576159830,     0.000352318334280,     0.000043112832369,     0.000007385914973,     0.000001626820704,     0.000000437926748,     0.000000139297771,     0.000000051104400,
     0.000000021229417,     0.000000009838917,     0.000000005023897,     0.000000002795126,     0.000000001677370,     0.000000001075580,     0.000000000730568,     0.000000000521459,     0.196021855078594,     0.004795055130899,
     0.000351887574981,     0.000043039054487,     0.000007369668639,     0.000001622448393,     0.000000436536322,     0.000000138787787,     0.000000050892597,     0.000000021131279,     0.000000009788817,     0.000000004996030,
     0.000000002778406,     0.000000001666651,     0.000000001068300,     0.000000000725373,     0.000000000517591,     0.195973922114494,     0.004791538405874,     0.000351457552650,     0.000042965438851,     0.000007353465959,
     0.000001618089960,     0.000000435150986,     0.000000138279916,     0.000000050681772,     0.000000021033640,     0.000000009738995,     0.000000004968329,     0.000000002761793,     0.000000001656004,     0.000000001061072,
     0.000000000720216,     0.000000000513752,     0.195926024296155,     0.004788025977394,     0.000351028265665,     0.000042891985023,     0.000007337306794,     0.000001613745356,     0.000000433770717,     0.000000137774148,
     0.000000050471922,     0.000000020936498,     0.000000009689450,     0.000000004940794,     0.000000002745285,     0.000000001645429,     0.000000001053896,     0.000000000715098,     0.000000000509943,     0.195878161580648,
     0.004784517838115,     0.000350599712411,     0.000042818692570,     0.000007321191006,     0.000001609414529,     0.000000432395496,     0.000000137270474,     0.000000050263041,     0.000000020839850,     0.000000009640179,
     0.000000004913423,     0.000000002728884,     0.000000001634926,     0.000000001046770,     0.000000000710017,     0.000000000506163,     0.195830333925119,     0.004781013980706,     0.000350171891277,     0.000042745561059,
     0.000007305118457,     0.000001605097429,     0.000000431025301,     0.000000136768884,     0.000000050055123,     0.000000020743694,     0.000000009591181,     0.000000004886216,     0.000000002712587,     0.000000001624494,
     0.000000001039695,     0.000000000704975,     0.000000000502412,     0.195782541286786,     0.004777514397854,     0.000349744800655,     0.000042672590058,     0.000007289089011,     0.000001600794006,     0.000000429660111,
     0.000000136269369,     0.000000049848165,     0.000000020648026,     0.000000009542454,     0.000000004859171,     0.000000002696394,     0.000000001614132,     0.000000001032671,     0.000000000699969,     0.000000000498690,
     0.195734783622938,     0.004774019082263,     0.000349318438942,     0.000042599779136,     0.000007273102532,     0.000001596504211,     0.000000428299906,     0.000000135771918,     0.000000049642161,     0.000000020552844,
     0.000000009493997,     0.000000004832287,     0.000000002680304,     0.000000001603840,     0.000000001025696,     0.000000000695001,     0.000000000494997,     0.195687060890940,     0.004770528026651,     0.000348892804540,
     0.000042527127864,     0.000007257158882,     0.000001592227992,     0.000000426944666,     0.000000135276522,     0.000000049437107,     0.000000020458145,     0.000000009445808,     0.000000004805564,     0.000000002664317,
     0.000000001593618,     0.000000001018771,     0.000000000690069,     0.000000000491332,     0.195639373048229,     0.004767041223753,     0.000348467895854,     0.000042454635816,     0.000007241257927,     0.000001587965301,
     0.000000425594369,     0.000000134783173,     0.000000049232997,     0.000000020363927,     0.000000009397885,     0.000000004779001,     0.000000002648431,     0.000000001583465,     0.000000001011894,     0.000000000685174,
     0.000000000487695,     0.195591720052314,     0.004763558666320,     0.000348043711295,     0.000042382302564,     0.000007225399531,     0.000001583716088,     0.000000424248996,     0.000000134291859,     0.000000049029827,
     0.000000020270186,     0.000000009350227,     0.000000004752595,     0.000000002632647,     0.000000001573380,     0.000000001005067,     0.000000000680315,     0.000000000484086,     0.195544101860776,     0.004760080347119,
     0.000347620249275,     0.000042310127684,     0.000007209583560,     0.000001579480304,     0.000000422908525,     0.000000133802573,     0.000000048827592,     0.000000020176921,     0.000000009302833,     0.000000004726347,
     0.000000002616963,     0.000000001563363,     0.000000000998288,     0.000000000675492,     0.000000000480504,     0.195496518431268,     0.004756606258932,     0.000347197508214,     0.000042238110752,     0.000007193809880,
     0.000001575257901,     0.000000421572937,     0.000000133315304,     0.000000048626287,     0.000000020084129,     0.000000009255700,     0.000000004700256,     0.000000002601380,     0.000000001553414,     0.000000000991557,
     0.000000000670705,     0.000000000476951,     0.195448969721518,     0.004753136394557,     0.000346775486535,     0.000042166251345,     0.000007178078358,     0.000001571048830,     0.000000420242212,     0.000000132830044,
     0.000000048425907,     0.000000019991806,     0.000000009208827,     0.000000004674320,     0.000000002585895,     0.000000001543532,     0.000000000984874,     0.000000000665953,     0.000000000473424,     0.195401455689321,
     0.004749670746808,     0.000346354182664,     0.000042094549044,     0.000007162388859,     0.000001566853041,     0.000000418916330,     0.000000132346783,     0.000000048226449,     0.000000019899951,     0.000000009162213,
     0.000000004648538,     0.000000002570509,     0.000000001533716,     0.000000000978238,     0.000000000661236,     0.000000000469924,     0.195353976292550,     0.004746209308516,     0.000345933595032,     0.000042023003429,
     0.000007146741253,     0.000001562670487,     0.000000417595270,     0.000000131865512,     0.000000048027907,     0.000000019808561,     0.000000009115856,     0.000000004622909,     0.000000002555220,     0.000000001523967,
     0.000000000971649,     0.000000000656554,     0.000000000466452,     0.195306531489144,     0.004742752072525,     0.000345513722074,     0.000041951614080,     0.000007131135406,     0.000001558501119,     0.000000416279013,
     0.000000131386222,     0.000000047830276,     0.000000019717633,     0.000000009069754,     0.000000004597433,     0.000000002540029,     0.000000001514283,     0.000000000965107,     0.000000000651907,     0.000000000463006,
     0.195259121237115,     0.004739299031697,     0.000345094562231,     0.000041880380582,     0.000007115571187,     0.000001554344891,     0.000000414967539,     0.000000130908903,     0.000000047633553,     0.000000019627165,
     0.000000009023907,     0.000000004572108,     0.000000002524935,     0.000000001504665,     0.000000000958611,     0.000000000647294,     0.000000000459586,     0.195211745494550,     0.004735850178909,     0.000344676113945,
     0.000041809302518,     0.000007100048464,     0.000001550201753,     0.000000413660828,     0.000000130433548,     0.000000047437731,     0.000000019537154,     0.000000008978312,     0.000000004546934,     0.000000002509936,
     0.000000001495111,     0.000000000952161,     0.000000000642715,     0.000000000456192,     0.195164404219601,     0.004732405507052,     0.000344258375664,     0.000041738379475,     0.000007084567108,     0.000001546071658,
     0.000000412358862,     0.000000129960146,     0.000000047242808,     0.000000019447598,     0.000000008932968,     0.000000004521909,     0.000000002495032,     0.000000001485621,     0.000000000945756,     0.000000000638170,
     0.000000000452825,     0.195117097370496,     0.004728965009034,     0.000343841345840,     0.000041667611038,     0.000007069126988,     0.000001541954560,     0.000000411061619,     0.000000129488689,     0.000000047048778,
     0.000000019358494,     0.000000008887873,     0.000000004497033,     0.000000002480223,     0.000000001476195,     0.000000000939397,     0.000000000633659,     0.000000000449483,     0.195069824905531,     0.004725528677779,
     0.000343425022929,     0.000041596996798,     0.000007053727974,     0.000001537850410,     0.000000409769081,     0.000000129019167,     0.000000046855637,     0.000000019269840,     0.000000008843026,     0.000000004472304,
     0.000000002465508,     0.000000001466833,     0.000000000933083,     0.000000000629181,     0.000000000446167,     0.195022586783074,     0.004722096506224,     0.000343009405391,     0.000041526536342,     0.000007038369937,
     0.000001533759163,     0.000000408481229,     0.000000128551573,     0.000000046663380,     0.000000019181633,     0.000000008798426,     0.000000004447722,     0.000000002450886,     0.000000001457534,     0.000000000926813,
     0.000000000624735,     0.000000000442876,     0.194975382961564,     0.004718668487325,     0.000342594491691,     0.000041456229263,     0.000007023052748,     0.000001529680770,     0.000000407198044,     0.000000128085897,
     0.000000046472002,     0.000000019093871,     0.000000008754071,     0.000000004423286,     0.000000002436357,     0.000000001448297,     0.000000000920588,     0.000000000620323,     0.000000000439610,     0.194928213399509,
     0.004715244614049,     0.000342180280296,     0.000041386075152,     0.000007007776278,     0.000001525615186,     0.000000405919505,     0.000000127622130,     0.000000046281501,     0.000000019006551,     0.000000008709960,
     0.000000004398995,     0.000000002421920,     0.000000001439122,     0.000000000914407,     0.000000000615943,     0.000000000436370,     0.194881078055488,     0.004711824879383,     0.000341766769679,     0.000041316073602,
     0.000006992540401,     0.000001521562365,     0.000000404645595,     0.000000127160264,     0.000000046091870,     0.000000018919671,     0.000000008666091,     0.000000004374848,     0.000000002407574,     0.000000001430008,
     0.000000000908269,     0.000000000611595,     0.000000000433154,     0.194833976888150,     0.004708409276325,     0.000341353958317,     0.000041246224209,     0.000006977344989,     0.000001517522259,     0.000000403376293,
     0.000000126700290,     0.000000045903106,     0.000000018833228,     0.000000008622463,     0.000000004350843,     0.000000002393320,     0.000000001420956,     0.000000000902175,     0.000000000607280,     0.000000000429963,
     0.194786909856213,     0.004704997797891,     0.000340941844689,     0.000041176526568,     0.000006962189914,     0.000001513494823,     0.000000402111583,     0.000000126242199,     0.000000045715204,     0.000000018747221,
     0.000000008579074,     0.000000004326981,     0.000000002379155,     0.000000001411965,     0.000000000896123,     0.000000000602996,     0.000000000426796,     0.194739876918466,     0.004701590437110,     0.000340530427281,
     0.000041106980276,     0.000006947075050,     0.000001509480012,     0.000000400851443,     0.000000125785983,     0.000000045528160,     0.000000018661646,     0.000000008535923,     0.000000004303260,     0.000000002365080,
     0.000000001403034,     0.000000000890115,     0.000000000598744,     0.000000000423653,     0.194692878033768,     0.004698187187029,     0.000340119704581,     0.000041037584933,     0.000006932000272,     0.000001505477779,
     0.000000399595857,     0.000000125331633,     0.000000045341970,     0.000000018576501,     0.000000008493008,     0.000000004279679,     0.000000002351094,     0.000000001394162,     0.000000000884148,     0.000000000594523,
     0.000000000420534,     0.194645913161046,     0.004694788040708,     0.000339709675080,     0.000040968340138,     0.000006916965453,     0.000001501488080,     0.000000398344804,     0.000000124879141,     0.000000045156629,
     0.000000018491785,     0.000000008450329,     0.000000004256238,     0.000000002337197,     0.000000001385350,     0.000000000878224,     0.000000000590333,     0.000000000417439,     0.194598982259298,     0.004691392991222,
     0.000339300337277,     0.000040899245491,     0.000006901970469,     0.000001497510868,     0.000000397098268,     0.000000124428497,     0.000000044972133,     0.000000018407494,     0.000000008407883,     0.000000004232935,
     0.000000002323387,     0.000000001376598,     0.000000000872342,     0.000000000586174,     0.000000000414368,     0.194552085287589,     0.004688002031662,     0.000338891689671,     0.000040830300596,     0.000006887015194,
     0.000001493546099,     0.000000395856228,     0.000000123979695,     0.000000044788477,     0.000000018323626,     0.000000008365669,     0.000000004209770,     0.000000002309665,     0.000000001367903,     0.000000000866501,
     0.000000000582046,     0.000000000411320,     0.194505222205055,     0.004684615155133,     0.000338483730768,     0.000040761505056,     0.000006872099505,     0.000001489593729,     0.000000394618668,     0.000000123532725,
     0.000000044605659,     0.000000018240180,     0.000000008323687,     0.000000004186741,     0.000000002296029,     0.000000001359268,     0.000000000860701,     0.000000000577948,     0.000000000408296,     0.194458392970899,
     0.004681232354756,     0.000338076459074,     0.000040692858474,     0.000006857223278,     0.000001485653711,     0.000000393385568,     0.000000123087579,     0.000000044423672,     0.000000018157152,     0.000000008281934,
     0.000000004163849,     0.000000002282479,     0.000000001350689,     0.000000000854942,     0.000000000573880,     0.000000000405294,     0.194411597544395,     0.004677853623666,     0.000337669873103,     0.000040624360459,
     0.000006842386390,     0.000001481726003,     0.000000392156910,     0.000000122644249,     0.000000044242514,     0.000000018074540,     0.000000008240410,     0.000000004141091,     0.000000002269015,     0.000000001342169,
     0.000000000849223,     0.000000000569842,     0.000000000402316,     0.194364835884884,     0.004674478955013,     0.000337263971371,     0.000040556010616,     0.000006827588717,     0.000001477810558,     0.000000390932677,
     0.000000122202726,     0.000000044062180,     0.000000017992343,     0.000000008199112,     0.000000004118468,     0.000000002255635,     0.000000001333705,     0.000000000843545,     0.000000000565833,     0.000000000399360,
     0.194318107951776,     0.004671108341963,     0.000336858752398,     0.000040487808554,     0.000006812830138,     0.000001473907334,     0.000000389712850,     0.000000121763003,     0.000000043882666,     0.000000017910557,
     0.000000008158040,     0.000000004095978,     0.000000002242341,     0.000000001325298,     0.000000000837906,     0.000000000561854,     0.000000000396427,     0.194271413704549,     0.004667741777694,     0.000336454214708,
     0.000040419753883,     0.000006798110530,     0.000001470016287,     0.000000388497411,     0.000000121325070,     0.000000043703968,     0.000000017829181,     0.000000008117192,     0.000000004073621,     0.000000002229129,
     0.000000001316946,     0.000000000832307,     0.000000000557905,     0.000000000393516,     0.194224753102749,     0.004664379255402,     0.000336050356830,     0.000040351846214,     0.000006783429772,     0.000001466137372,
     0.000000387286342,     0.000000120888921,     0.000000043526081,     0.000000017748213,     0.000000008076567,     0.000000004051395,     0.000000002216001,     0.000000001308651,     0.000000000826748,     0.000000000553984,
     0.000000000390627,     0.194178126105990,     0.004661020768296,     0.000335647177295,     0.000040284085159,     0.000006768787742,     0.000001462270545,     0.000000386079626,     0.000000120454546,     0.000000043349002,
     0.000000017667649,     0.000000008036164,     0.000000004029301,     0.000000002202956,     0.000000001300411,     0.000000000821228,     0.000000000550092,     0.000000000387760,     0.194131532673955,     0.004657666309600,
     0.000335244674640,     0.000040216470331,     0.000006754184321,     0.000001458415765,     0.000000384877245,     0.000000120021938,     0.000000043172727,     0.000000017587489,     0.000000007995980,     0.000000004007336,
     0.000000002189993,     0.000000001292227,     0.000000000815746,     0.000000000546229,     0.000000000384915,     0.194084972766393,     0.004654315872552,     0.000334842847403,     0.000040149001344,     0.000006739619387,
     0.000001454572986,     0.000000383679182,     0.000000119591089,     0.000000042997251,     0.000000017507729,     0.000000007956016,     0.000000003985501,     0.000000002177111,     0.000000001284096,     0.000000000810303,
     0.000000000542394,     0.000000000382092,     0.194038446343121,     0.004650969450406,     0.000334441694128,     0.000040081677815,     0.000006725092821,     0.000001450742167,     0.000000382485418,     0.000000119161990,
     0.000000042822571,     0.000000017428368,     0.000000007916270,     0.000000003963794,     0.000000002164311,     0.000000001276020,     0.000000000804898,     0.000000000538587,     0.000000000379290,     0.193991953364024,
     0.004647627036428,     0.000334041213363,     0.000040014499360,     0.000006710604504,     0.000001446923263,     0.000000381295936,     0.000000118734635,     0.000000042648682,     0.000000017349403,     0.000000007876740,
     0.000000003942214,     0.000000002151591,     0.000000001267998,     0.000000000799531,     0.000000000534808,     0.000000000376510,     0.193945493789054,     0.004644288623901,     0.000333641403658,     0.000039947465598,
     0.000006696154316,     0.000001443116234,     0.000000380110719,     0.000000118309014,     0.000000042475581,     0.000000017270832,     0.000000007837425,     0.000000003920761,     0.000000002138951,     0.000000001260030,
     0.000000000794202,     0.000000000531057,     0.000000000373751,     0.193899067578230,     0.004640954206123,     0.000333242263570,     0.000039880576147,     0.000006681742140,     0.000001439321035,     0.000000378929750,
     0.000000117885120,     0.000000042303264,     0.000000017192654,     0.000000007798324,     0.000000003899435,     0.000000002126390,     0.000000001252114,     0.000000000788910,     0.000000000527333,     0.000000000371012,
     0.193852674691638,     0.004637623776403,     0.000332843791656,     0.000039813830629,     0.000006667367856,     0.000001435537625,     0.000000377753011,     0.000000117462946,     0.000000042131727,     0.000000017114865,
     0.000000007759436,     0.000000003878233,     0.000000002113908,     0.000000001244251,     0.000000000783655,     0.000000000523636,     0.000000000368295,     0.193806315089431,     0.004634297328067,     0.000332445986479,
     0.000039747228664,     0.000006653031348,     0.000001431765961,     0.000000376580485,     0.000000117042483,     0.000000041960966,     0.000000017037464,     0.000000007720759,     0.000000003857156,     0.000000002101505,
     0.000000001236441,     0.000000000778437,     0.000000000519967,     0.000000000365598,     0.193759988731828,     0.004630974854456,     0.000332048846605,     0.000039680769876,     0.000006638732498,     0.000001428006001,
     0.000000375412156,     0.000000116623724,     0.000000041790976,     0.000000016960449,     0.000000007682293,     0.000000003836203,     0.000000002089179,     0.000000001228682,     0.000000000773256,     0.000000000516324,
     0.000000000362922,     0.193713695579115,     0.004627656348922,     0.000331652370605,     0.000039614453889,     0.000006624471189,     0.000001424257703,     0.000000374248005,     0.000000116206661,     0.000000041621755,
     0.000000016883818,     0.000000007644035,     0.000000003815373,     0.000000002076931,     0.000000001220976,     0.000000000768111,     0.000000000512708,     0.000000000360266,     0.193667435591645,     0.004624341804835,
     0.000331256557053,     0.000039548280328,     0.000006610247305,     0.000001420521027,     0.000000373088017,     0.000000115791286,     0.000000041453299,     0.000000016807568,     0.000000007605985,     0.000000003794664,
     0.000000002064760,     0.000000001213320,     0.000000000763001,     0.000000000509119,     0.000000000357630,     0.193621208729836,     0.004621031215578,     0.000330861404525,     0.000039482248818,     0.000006596060730,
     0.000001416795929,     0.000000371932174,     0.000000115377593,     0.000000041285603,     0.000000016731697,     0.000000007568141,     0.000000003774077,     0.000000002052664,     0.000000001205715,     0.000000000757928,
     0.000000000505556,     0.000000000355014,     0.193575014954172,     0.004617724574546,     0.000330466911604,     0.000039416358989,     0.000006581911348,     0.000001413082370,     0.000000370780460,     0.000000114965572,
     0.000000041118664,     0.000000016656204,     0.000000007530503,     0.000000003753611,     0.000000002040645,     0.000000001198161,     0.000000000752890,     0.000000000502018,     0.000000000352418,     0.193528854225206,
     0.004614421875152,     0.000330073076874,     0.000039350610468,     0.000006567799045,     0.000001409380306,     0.000000369632857,     0.000000114555217,     0.000000040952477,     0.000000016581087,     0.000000007493069,
     0.000000003733264,     0.000000002028701,     0.000000001190658,     0.000000000747888,     0.000000000498507,     0.000000000349842,     0.193482726503552,     0.004611123110819,     0.000329679898925,     0.000039285002885,
     0.000006553723704,     0.000001405689699,     0.000000368489350,     0.000000114146520,     0.000000040787041,     0.000000016506342,     0.000000007455837,     0.000000003713036,     0.000000002016832,     0.000000001183204,
     0.000000000742920,     0.000000000495022,     0.000000000347285,     0.193436631749895,     0.004607828274989,     0.000329287376348,     0.000039219535871,     0.000006539685212,     0.000001402010506,     0.000000367349921,
     0.000000113739474,     0.000000040622349,     0.000000016431969,     0.000000007418807,     0.000000003692927,     0.000000002005037,     0.000000001175799,     0.000000000737987,     0.000000000491561,     0.000000000344748,
     0.193390569924980,     0.004604537361112,     0.000328895507740,     0.000039154209058,     0.000006525683456,     0.000001398342687,     0.000000366214555,     0.000000113334070,     0.000000040458400,     0.000000016357965,
     0.000000007381978,     0.000000003672935,     0.000000001993316,     0.000000001168444,     0.000000000733089,     0.000000000488127,     0.000000000342230,     0.193344540989621,     0.004601250362658,     0.000328504291701,
     0.000039089022080,     0.000006511718321,     0.000001394686201,     0.000000365083234,     0.000000112930303,     0.000000040295189,     0.000000016284329,     0.000000007345348,     0.000000003653061,     0.000000001981668,
     0.000000001161137,     0.000000000728224,     0.000000000484717,     0.000000000339731,     0.193298544904697,     0.004597967273108,     0.000328113726834,     0.000039023974570,     0.000006497789694,     0.000001391041009,
     0.000000363955943,     0.000000112528164,     0.000000040132712,     0.000000016211058,     0.000000007308917,     0.000000003633302,     0.000000001970093,     0.000000001153879,     0.000000000723394,     0.000000000481332,
     0.000000000337251,     0.193252581631151,     0.004594688085956,     0.000327723811746,     0.000038959066165,     0.000006483897463,     0.000001387407069,     0.000000362832666,     0.000000112127646,     0.000000039970966,
     0.000000016138150,     0.000000007272682,     0.000000003613658,     0.000000001958590,     0.000000001146669,     0.000000000718598,     0.000000000477972,     0.000000000334790,     0.193206651129991,     0.004591412794712,
     0.000327334545048,     0.000038894296500,     0.000006470041516,     0.000001383784342,     0.000000361713385,     0.000000111728742,     0.000000039809948,     0.000000016065603,     0.000000007236643,     0.000000003594130,
     0.000000001947159,     0.000000001139507,     0.000000000713835,     0.000000000474636,     0.000000000332348,     0.193160753362292,     0.004588141392898,     0.000326945925354,     0.000038829665214,     0.000006456221739,
     0.000001380172788,     0.000000360598085,     0.000000111331445,     0.000000039649653,     0.000000015993416,     0.000000007200799,     0.000000003574715,     0.000000001935800,     0.000000001132392,     0.000000000709105,
     0.000000000471325,     0.000000000329924,     0.193114888289190,     0.004584873874053,     0.000326557951283,     0.000038765171945,     0.000006442438023,     0.000001376572367,     0.000000359486751,     0.000000110935747,
     0.000000039490078,     0.000000015921587,     0.000000007165148,     0.000000003555414,     0.000000001924511,     0.000000001125325,     0.000000000704408,     0.000000000468037,     0.000000000327518,     0.193069055871889,
     0.004581610231725,     0.000326170621457,     0.000038700816333,     0.000006428690255,     0.000001372983040,     0.000000358379365,     0.000000110541641,     0.000000039331220,     0.000000015850113,     0.000000007129690,
     0.000000003536225,     0.000000001913293,     0.000000001118304,     0.000000000699744,     0.000000000464774,     0.000000000325131,     0.193023256071655,     0.004578350459480,     0.000325783934499,     0.000038636598020,
     0.000006414978325,     0.000001369404767,     0.000000357275913,     0.000000110149120,     0.000000039173075,     0.000000015778992,     0.000000007094424,     0.000000003517147,     0.000000001902145,     0.000000001111330,
     0.000000000695113,     0.000000000461535,     0.000000000322761,     0.192977488849820,     0.004575094550897,     0.000325397889040,     0.000038572516648,     0.000006401302123,     0.000001365837509,     0.000000356176377,
     0.000000109758177,     0.000000039015639,     0.000000015708224,     0.000000007059347,     0.000000003498181,     0.000000001891066,     0.000000001104402,     0.000000000690513,     0.000000000458319,     0.000000000320410,
     0.192931754167780,     0.004571842499566,     0.000325012483711,     0.000038508571859,     0.000006387661538,     0.000001362281226,     0.000000355080744,     0.000000109368805,     0.000000038858909,     0.000000015637805,
     0.000000007024460,     0.000000003479326,     0.000000001880057,     0.000000001097519,     0.000000000685946,     0.000000000455127,     0.000000000318076,     0.192886051986993,     0.004568594299093,     0.000324627717148,
     0.000038444763299,     0.000006374056462,     0.000001358735881,     0.000000353988996,     0.000000108980997,     0.000000038702882,     0.000000015567734,     0.000000006989760,     0.000000003460580,     0.000000001869116,
     0.000000001090683,     0.000000000681411,     0.000000000451957,     0.000000000315760,     0.192840382268983,     0.004565349943098,     0.000324243587992,     0.000038381090612,     0.000006360486784,     0.000001355201433,
     0.000000352901119,     0.000000108594745,     0.000000038547554,     0.000000015498009,     0.000000006955248,     0.000000003441943,     0.000000001858243,     0.000000001083891,     0.000000000676907,     0.000000000448811,
     0.000000000313462,     0.192794744975337,     0.004562109425213,     0.000323860094884,     0.000038317553445,     0.000006346952397,     0.000001351677846,     0.000000351817096,     0.000000108210043,     0.000000038392921,
     0.000000015428628,     0.000000006920921,     0.000000003423415,     0.000000001847438,     0.000000001077144,     0.000000000672434,     0.000000000445688,     0.000000000311181,     0.192749140067706,     0.004558872739085,
     0.000323477236473,     0.000038254151447,     0.000006333453191,     0.000001348165079,     0.000000350736913,     0.000000107826884,     0.000000038238980,     0.000000015359590,     0.000000006886779,     0.000000003404994,
     0.000000001836700,     0.000000001070442,     0.000000000667993,     0.000000000442588,     0.000000000308917,     0.192703567507804,     0.004555639878373,     0.000323095011406,     0.000038190884265,     0.000006319989059,
     0.000001344663095,     0.000000349660553,     0.000000107445261,     0.000000038085728,     0.000000015290892,     0.000000006852821,     0.000000003386681,     0.000000001826029,     0.000000001063784,     0.000000000663583,
     0.000000000439510,     0.000000000306671,     0.192658027257408,     0.004552410836750,     0.000322713418339,     0.000038127751549,     0.000006306559894,     0.000001341171855,     0.000000348588002,     0.000000107065167,
     0.000000037933161,     0.000000015222533,     0.000000006819045,     0.000000003368474,     0.000000001815424,     0.000000001057171,     0.000000000659203,     0.000000000436454,     0.000000000304441,     0.192612519278360,
     0.004549185607904,     0.000322332455928,     0.000038064752951,     0.000006293165587,     0.000001337691322,     0.000000347519245,     0.000000106686596,     0.000000037781276,     0.000000015154511,     0.000000006785451,
     0.000000003350372,     0.000000001804885,     0.000000001050600,     0.000000000654853,     0.000000000433421,     0.000000000302228,     0.192567043532562,     0.004545964185534,     0.000321952122834,     0.000038001888121,
     0.000006279806032,     0.000001334221457,     0.000000346454265,     0.000000106309540,     0.000000037630070,     0.000000015086823,     0.000000006752037,     0.000000003332376,     0.000000001794412,     0.000000001044073,
     0.000000000650534,     0.000000000430410,     0.000000000300032,     0.192521599981982,     0.004542746563354,     0.000321572417721,     0.000037939156714,     0.000006266481122,     0.000001330762224,     0.000000345393049,
     0.000000105933992,     0.000000037479538,     0.000000015019469,     0.000000006718803,     0.000000003314484,     0.000000001784004,     0.000000001037590,     0.000000000646245,     0.000000000427420,     0.000000000297852,
     0.192476188588649,     0.004539532735091,     0.000321193339256,     0.000037876558384,     0.000006253190752,     0.000001327313584,     0.000000344335581,     0.000000105559947,     0.000000037329679,     0.000000014952447,
     0.000000006685747,     0.000000003296695,     0.000000001773660,     0.000000001031148,     0.000000000641986,     0.000000000424452,     0.000000000295689,     0.192430809314655,     0.004536322694484,     0.000320814886111,
     0.000037814092785,     0.000006239934815,     0.000001323875500,     0.000000343281845,     0.000000105187396,     0.000000037180488,     0.000000014885754,     0.000000006652869,     0.000000003279010,     0.000000001763381,
     0.000000001024750,     0.000000000637756,     0.000000000421506,     0.000000000293542,     0.192385462122154,     0.004533116435288,     0.000320437056959,     0.000037751759573,     0.000006226713207,     0.000001320447935,
     0.000000342231828,     0.000000104816335,     0.000000037031963,     0.000000014819389,     0.000000006620167,     0.000000003261428,     0.000000001753165,     0.000000001018393,     0.000000000633556,     0.000000000418582,
     0.000000000291412,     0.192340146973365,     0.004529913951270,     0.000320059850479,     0.000037689558406,     0.000006213525822,     0.000001317030851,     0.000000341185513,     0.000000104446755,     0.000000036884099,
     0.000000014753350,     0.000000006587640,     0.000000003243947,     0.000000001743013,     0.000000001012079,     0.000000000629384,     0.000000000415678,     0.000000000289297,     0.192294863830566,     0.004526715236208,
     0.000319683265352,     0.000037627488943,     0.000006200372555,     0.000001313624212,     0.000000340142888,     0.000000104078651,     0.000000036736895,     0.000000014687635,     0.000000006555287,     0.000000003226567,
     0.000000001732923,     0.000000001005805,     0.000000000625242,     0.000000000412796,     0.000000000287199,     0.192249612656098,     0.004523520283896,     0.000319307300263,     0.000037565550842,     0.000006187253303,
     0.000001310227981,     0.000000339103936,     0.000000103712015,     0.000000036590346,     0.000000014622243,     0.000000006523108,     0.000000003209288,     0.000000001722896,     0.000000000999574,     0.000000000621128,
     0.000000000409934,     0.000000000285116,     0.192204393412366,     0.004520329088140,     0.000318931953899,     0.000037503743764,     0.000006174167961,     0.000001306842121,     0.000000338068642,     0.000000103346841,
     0.000000036444449,     0.000000014557173,     0.000000006491101,     0.000000003192109,     0.000000001712932,     0.000000000993383,     0.000000000617043,     0.000000000407093,     0.000000000283049,     0.192159206061834,
     0.004517141642760,     0.000318557224952,     0.000037442067370,     0.000006161116426,     0.000001303466596,     0.000000337036994,     0.000000102983124,     0.000000036299201,     0.000000014492421,     0.000000006459266,
     0.000000003175029,     0.000000001703029,     0.000000000987233,     0.000000000612986,     0.000000000404273,     0.000000000280997,     0.192114050567030,     0.004513957941587,     0.000318183112117,     0.000037380521323,
     0.000006148098595,     0.000001300101369,     0.000000336008975,     0.000000102620855,     0.000000036154599,     0.000000014427987,     0.000000006427600,     0.000000003158048,     0.000000001693187,     0.000000000981123,
     0.000000000608958,     0.000000000401473,     0.000000000278961,     0.192068926890542,     0.004510777978468,     0.000317809614092,     0.000037319105286,     0.000006135114364,     0.000001296746404,     0.000000334984572,
     0.000000102260030,     0.000000036010640,     0.000000014363868,     0.000000006396104,     0.000000003141165,     0.000000001683406,     0.000000000975053,     0.000000000604957,     0.000000000398694,     0.000000000276941,
     0.192023834995021,     0.004507601747260,     0.000317436729579,     0.000037257818924,     0.000006122163632,     0.000001293401666,     0.000000333963770,     0.000000101900640,     0.000000035867321,     0.000000014300064,
     0.000000006364777,     0.000000003124380,     0.000000001673686,     0.000000000969024,     0.000000000600984,     0.000000000395934,     0.000000000274935,     0.191978774843178,     0.004504429241836,     0.000317064457282,
     0.000037196661902,     0.000006109246297,     0.000001290067117,     0.000000332946554,     0.000000101542681,     0.000000035724638,     0.000000014236572,     0.000000006333616,     0.000000003107691,     0.000000001664025,
     0.000000000963034,     0.000000000597038,     0.000000000393195,     0.000000000272945,     0.191933746397785,     0.004501260456078,     0.000316692795911,     0.000037135633887,     0.000006096362256,     0.000001286742723,
     0.000000331932911,     0.000000101186145,     0.000000035582589,     0.000000014173391,     0.000000006302623,     0.000000003091099,     0.000000001654425,     0.000000000957083,     0.000000000593120,     0.000000000390475,
     0.000000000270969,     0.191888749621678,     0.004498095383885,     0.000316321744176,     0.000037074734546,     0.000006083511409,     0.000001283428447,     0.000000330922827,     0.000000100831027,     0.000000035441169,
     0.000000014110519,     0.000000006271794,     0.000000003074603,     0.000000001644884,     0.000000000951171,     0.000000000589229,     0.000000000387775,     0.000000000269009,     0.191843784477749,     0.004494934019167,
     0.000315951300792,     0.000037013963549,     0.000006070693654,     0.000001280124254,     0.000000329916286,     0.000000100477320,     0.000000035300377,     0.000000014047955,     0.000000006241130,     0.000000003058201,
     0.000000001635401,     0.000000000945298,     0.000000000585364,     0.000000000385095,     0.000000000267063,     0.191798850928956,     0.004491776355846,     0.000315581464478,     0.000036953320563,     0.000006057908890,
     0.000001276830110,     0.000000328913276,     0.000000100125018,     0.000000035160209,     0.000000013985696,     0.000000006210630,     0.000000003041894,     0.000000001625977,     0.000000000939464,     0.000000000581527,
     0.000000000382434,     0.000000000265132,     0.191753948938315,     0.004488622387858,     0.000315212233955,     0.000036892805261,     0.000006045157018,     0.000001273545977,     0.000000327913781,     0.000000099774114,
     0.000000035020662,     0.000000013923742,     0.000000006180292,     0.000000003025682,     0.000000001616612,     0.000000000933668,     0.000000000577716,     0.000000000379792,     0.000000000263215,     0.191709078468902,
     0.004485472109152,     0.000314843607948,     0.000036832417314,     0.000006032437937,     0.000001270271822,     0.000000326917789,     0.000000099424602,     0.000000034881733,     0.000000013862090,     0.000000006150116,
     0.000000003009562,     0.000000001607304,     0.000000000927909,     0.000000000573931,     0.000000000377170,     0.000000000261313,     0.191664239483854,     0.004482325513688,     0.000314475585185,     0.000036772156393,
     0.000006019751548,     0.000001267007610,     0.000000325925285,     0.000000099076477,     0.000000034743419,     0.000000013800739,     0.000000006120100,     0.000000002993535,     0.000000001598054,     0.000000000922189,
     0.000000000570172,     0.000000000374566,     0.000000000259425,     0.191619431946370,     0.004479182595442,     0.000314108164398,     0.000036712022174,     0.000006007097752,     0.000001263753305,     0.000000324936255,
     0.000000098729732,     0.000000034605718,     0.000000013739687,     0.000000006090245,     0.000000002977601,     0.000000001588860,     0.000000000916506,     0.000000000566439,     0.000000000371981,     0.000000000257551,
     0.191574655819708,     0.004476043348398,     0.000313741344321,     0.000036652014330,     0.000005994476449,     0.000001260508873,     0.000000323950685,     0.000000098384361,     0.000000034468625,     0.000000013678933,
     0.000000006060548,     0.000000002961758,     0.000000001579723,     0.000000000910860,     0.000000000562732,     0.000000000369415,     0.000000000255691,     0.191529911067185,     0.004472907766557,     0.000313375123691,
     0.000036592132537,     0.000005981887542,     0.000001257274280,     0.000000322968563,     0.000000098040357,     0.000000034332138,     0.000000013618476,     0.000000006031009,     0.000000002946006,     0.000000001570643,
     0.000000000905251,     0.000000000559051,     0.000000000366867,     0.000000000253846,     0.191485197652180,     0.004469775843930,     0.000313009501251,     0.000036532376472,     0.000005969330931,     0.000001254049490,
     0.000000321989874,     0.000000097697716,     0.000000034196254,     0.000000013558313,     0.000000006001628,     0.000000002930345,     0.000000001561618,     0.000000000899679,     0.000000000555395,     0.000000000364338,
     0.000000000252014,     0.191440515538129,     0.004466647574542,     0.000312644475744,     0.000036472745811,     0.000005956806519,     0.000001250834471,     0.000000321014604,     0.000000097356430,     0.000000034060971,
     0.000000013498443,     0.000000005972402,     0.000000002914774,     0.000000001552649,     0.000000000894143,     0.000000000551764,     0.000000000361827,     0.000000000250196,     0.191395864688531,     0.004463522952430,
     0.000312280045918,     0.000036413240234,     0.000005944314209,     0.000001247629187,     0.000000320042741,     0.000000097016494,     0.000000033926284,     0.000000013438864,     0.000000005943332,     0.000000002899292,
     0.000000001543735,     0.000000000888644,     0.000000000548158,     0.000000000359334,     0.000000000248391,     0.191351245066943,     0.004460401971642,     0.000311916210523,     0.000036353859420,     0.000005931853903,
     0.000001244433605,     0.000000319074270,     0.000000096677903,     0.000000033792192,     0.000000013379575,     0.000000005914416,     0.000000002883899,     0.000000001534876,     0.000000000883180,     0.000000000544577,
     0.000000000356859,     0.000000000246600,     0.191306656636980,     0.004457284626242,     0.000311552968314,     0.000036294603050,     0.000005919425505,     0.000001241247690,     0.000000318109178,     0.000000096340649,
     0.000000033658692,     0.000000013320575,     0.000000005885654,     0.000000002868594,     0.000000001526071,     0.000000000877752,     0.000000000541021,     0.000000000354402,     0.000000000244823,     0.191262099362320,
     0.004454170910303,     0.000311190318048,     0.000036235470804,     0.000005907028917,     0.000001238071410,     0.000000317147452,     0.000000096004727,     0.000000033525780,     0.000000013261862,     0.000000005857044,
     0.000000002853377,     0.000000001517321,     0.000000000872359,     0.000000000537489,     0.000000000351963,     0.000000000243058,     0.191217573206696,     0.004451060817912,     0.000310828258486,     0.000036176462366,
     0.000005894664045,     0.000001234904730,     0.000000316189079,     0.000000095670131,     0.000000033393454,     0.000000013203434,     0.000000005828586,     0.000000002838247,     0.000000001508624,     0.000000000867002,
     0.000000000533982,     0.000000000349541,     0.000000000241308,     0.191173078133903,     0.004447954343168,     0.000310466788389,     0.000036117577418,     0.000005882330791,     0.000001231747617,     0.000000315234045,
     0.000000095336856,     0.000000033261710,     0.000000013145290,     0.000000005800279,     0.000000002823204,     0.000000001499981,     0.000000000861680,     0.000000000530498,     0.000000000347137,     0.000000000239570,
     0.191128614107793,     0.004444851480183,     0.000310105906527,     0.000036058815645,     0.000005870029061,     0.000001228600038,     0.000000314282338,     0.000000095004895,     0.000000033130547,     0.000000013087428,
     0.000000005772121,     0.000000002808248,     0.000000001491390,     0.000000000856392,     0.000000000527039,     0.000000000344749,     0.000000000237845,     0.191084181092279,     0.004441752223081,     0.000309745611667,
     0.000036000176732,     0.000005857758759,     0.000001225461960,     0.000000313333943,     0.000000094674243,     0.000000032999961,     0.000000013029847,     0.000000005744113,     0.000000002793376,     0.000000001482853,
     0.000000000851139,     0.000000000523603,     0.000000000342380,     0.000000000236133,     0.191039779051331,     0.004438656565998,     0.000309385902583,     0.000035941660365,     0.000005845519790,     0.000001222333348,
     0.000000312388848,     0.000000094344894,     0.000000032869949,     0.000000012972545,     0.000000005716254,     0.000000002778590,     0.000000001474368,     0.000000000845920,     0.000000000520191,     0.000000000340027,
     0.000000000234434,     0.190995407948979,     0.004435564503081,     0.000309026778052,     0.000035883266232,     0.000005833312060,     0.000001219214172,     0.000000311447041,     0.000000094016842,     0.000000032740509,
     0.000000012915521,     0.000000005688541,     0.000000002763889,     0.000000001465934,     0.000000000840735,     0.000000000516803,     0.000000000337691,     0.000000000232747,     0.190951067749309,     0.004432476028492,
     0.000308668236852,     0.000035824994020,     0.000005821135475,     0.000001216104397,     0.000000310508507,     0.000000093690082,     0.000000032611638,     0.000000012858774,     0.000000005660976,     0.000000002749271,
     0.000000001457553,     0.000000000835584,     0.000000000513437,     0.000000000335372,     0.000000000231074,     0.190906758416467,     0.004429391136404,     0.000308310277766,     0.000035766843419,     0.000005808989941,
     0.000001213003991,     0.000000309573235,     0.000000093364607,     0.000000032483333,     0.000000012802301,     0.000000005633556,     0.000000002734738,     0.000000001449222,     0.000000000830466,     0.000000000510095,
     0.000000000333069,     0.000000000229412,     0.190862479914658,     0.004426309821000,     0.000307952899580,     0.000035708814118,     0.000005796875364,     0.000001209912921,     0.000000308641211,     0.000000093040413,
     0.000000032355591,     0.000000012746102,     0.000000005606281,     0.000000002720287,     0.000000001440943,     0.000000000825382,     0.000000000506776,     0.000000000330783,     0.000000000227764,     0.190818232208144,
     0.004423232076480,     0.000307596101081,     0.000035650905809,     0.000005784791652,     0.000001206831156,     0.000000307712422,     0.000000092717494,     0.000000032228410,     0.000000012690175,     0.000000005579150,
     0.000000002705919,     0.000000001432715,     0.000000000820330,     0.000000000503480,     0.000000000328514,     0.000000000226127,     0.190774015261245,     0.004420157897050,     0.000307239881061,     0.000035593118183,
     0.000005772738710,     0.000001203758662,     0.000000306786857,     0.000000092395843,     0.000000032101786,     0.000000012634519,     0.000000005552162,     0.000000002691632,     0.000000001424537,     0.000000000815312,
     0.000000000500206,     0.000000000326261,     0.000000000224503,     0.190729829038339,     0.004417087276934,     0.000306884238316,     0.000035535450932,     0.000005760716448,     0.000001200695408,     0.000000305864501,
     0.000000092075456,     0.000000031975718,     0.000000012579131,     0.000000005525317,     0.000000002677428,     0.000000001416408,     0.000000000810326,     0.000000000496954,     0.000000000324024,     0.000000000222891,
     0.190685673503861,     0.004414020210364,     0.000306529171642,     0.000035477903752,     0.000005748724771,     0.000001197641361,     0.000000304945343,     0.000000091756327,     0.000000031850203,     0.000000012524012,
     0.000000005498613,     0.000000002663304,     0.000000001408330,     0.000000000805373,     0.000000000493725,     0.000000000321803,     0.000000000221291,     0.190641548622306,     0.004410956691585,     0.000306174679842,
     0.000035420476335,     0.000005736763590,     0.000001194596490,     0.000000304029371,     0.000000091438450,     0.000000031725237,     0.000000012469159,     0.000000005472050,     0.000000002649261,     0.000000001400301,
     0.000000000800452,     0.000000000490518,     0.000000000319598,     0.000000000219702,     0.190597454358223,     0.004407896714855,     0.000305820761718,     0.000035363168379,     0.000005724832811,     0.000001191560763,
     0.000000303116570,     0.000000091121820,     0.000000031600819,     0.000000012414570,     0.000000005445628,     0.000000002635298,     0.000000001392321,     0.000000000795562,     0.000000000487333,     0.000000000317409,
     0.000000000218126,     0.190553390676221,     0.004404840274442,     0.000305467416077,     0.000035305979578,     0.000005712932344,     0.000001188534148,     0.000000302206930,     0.000000090806432,     0.000000031476945,
     0.000000012360246,     0.000000005419344,     0.000000002621414,     0.000000001384389,     0.000000000790705,     0.000000000484170,     0.000000000315236,     0.000000000216562,     0.190509357540965,     0.004401787364629,
     0.000305114641730,     0.000035248909631,     0.000005701062098,     0.000001185516614,     0.000000301300437,     0.000000090492280,     0.000000031353613,     0.000000012306183,     0.000000005393199,     0.000000002607610,
     0.000000001376507,     0.000000000785879,     0.000000000481028,     0.000000000313078,     0.000000000215009,     0.190465354917179,     0.004398737979707,     0.000304762437489,     0.000035191958236,     0.000005689221982,
     0.000001182508129,     0.000000300397080,     0.000000090179358,     0.000000031230820,     0.000000012252381,     0.000000005367192,     0.000000002593884,     0.000000001368672,     0.000000000781084,     0.000000000477908,
     0.000000000310935,     0.000000000213468,     0.190421382769640,     0.004395692113983,     0.000304410802171,     0.000035135125091,     0.000005677411905,     0.000001179508662,     0.000000299496846,     0.000000089867661,
     0.000000031108565,     0.000000012198839,     0.000000005341321,     0.000000002580236,     0.000000001360885,     0.000000000776321,     0.000000000474810,     0.000000000308808,     0.000000000211938,     0.190377441063187,
     0.004392649761772,     0.000304059734594,     0.000035078409898,     0.000005665631778,     0.000001176518182,     0.000000298599723,     0.000000089557185,     0.000000030986843,     0.000000012145554,     0.000000005315587,
     0.000000002566666,     0.000000001353145,     0.000000000771588,     0.000000000471732,     0.000000000306696,     0.000000000210420,     0.190333529762712,     0.004389610917402,     0.000303709233581,     0.000035021812356,
     0.000005653881512,     0.000001173536657,     0.000000297705698,     0.000000089247923,     0.000000030865653,     0.000000012092526,     0.000000005289988,     0.000000002553173,     0.000000001345453,     0.000000000766886,
     0.000000000468676,     0.000000000304600,     0.000000000208913,     0.190289648833165,     0.004386575575215,     0.000303359297956,     0.000034965332168,     0.000005642161016,     0.000001170564058,     0.000000296814760,
     0.000000088939870,     0.000000030744991,     0.000000012039754,     0.000000005264523,     0.000000002539757,     0.000000001337807,     0.000000000762214,     0.000000000465640,     0.000000000302518,     0.000000000207417,
     0.190245798239553,     0.004383543729563,     0.000303009926547,     0.000034908969037,     0.000005630470201,     0.000001167600352,     0.000000295926897,     0.000000088633021,     0.000000030624857,     0.000000011987236,
     0.000000005239192,     0.000000002526417,     0.000000001330209,     0.000000000757573,     0.000000000462625,     0.000000000300451,     0.000000000205932,     0.190201977946938,     0.004380515374808,     0.000302661118186,
     0.000034852722666,     0.000005618808979,     0.000001164645509,     0.000000295042096,     0.000000088327371,     0.000000030505246,     0.000000011934970,     0.000000005213994,     0.000000002513153,     0.000000001322656,
     0.000000000752962,     0.000000000459631,     0.000000000298400,     0.000000000204459,     0.190158187920439,     0.004377490505326,     0.000302312871706,     0.000034796592759,     0.000005607177261,     0.000001161699500,
     0.000000294160346,     0.000000088022915,     0.000000030386156,     0.000000011882955,     0.000000005188929,     0.000000002499964,     0.000000001315149,     0.000000000748380,     0.000000000456657,     0.000000000296362,
     0.000000000202996,     0.190114428125232,     0.004374469115504,     0.000301965185943,     0.000034740579022,     0.000005595574960,     0.000001158762292,     0.000000293281634,     0.000000087719646,     0.000000030267586,
     0.000000011831191,     0.000000005163995,     0.000000002486850,     0.000000001307688,     0.000000000743829,     0.000000000453704,     0.000000000294340,     0.000000000201544,     0.190070698526549,     0.004371451199742,
     0.000301618059739,     0.000034684681162,     0.000005584001986,     0.000001155833857,     0.000000292405949,     0.000000087417561,     0.000000030149532,     0.000000011779675,     0.000000005139192,     0.000000002473810,
     0.000000001300273,     0.000000000739306,     0.000000000450770,     0.000000000292331,     0.000000000200103,     0.190026999089676,     0.004368436752448,     0.000301271491935,     0.000034628898885,     0.000005572458253,
     0.000001152914163,     0.000000291533279,     0.000000087116654,     0.000000030031992,     0.000000011728406,     0.000000005114518,     0.000000002460844,     0.000000001292902,     0.000000000734813,     0.000000000447857,
     0.000000000290337,     0.000000000198673,     0.189983329779957,     0.004365425768046,     0.000300925481377,     0.000034573231900,     0.000005560943674,     0.000001150003181,     0.000000290663612,     0.000000086816920,
     0.000000029914963,     0.000000011677384,     0.000000005089974,     0.000000002447952,     0.000000001285576,     0.000000000730349,     0.000000000444964,     0.000000000288358,     0.000000000197254,     0.189939690562791,
     0.004362418240967,     0.000300580026914,     0.000034517679915,     0.000005549458161,     0.000001147100881,     0.000000289796936,     0.000000086518353,     0.000000029798443,     0.000000011626607,     0.000000005065559,
     0.000000002435132,     0.000000001278295,     0.000000000725914,     0.000000000442090,     0.000000000286392,     0.000000000195845,     0.189896081403632,     0.004359414165658,     0.000300235127396,     0.000034462242640,
     0.000005538001627,     0.000001144207233,     0.000000288933241,     0.000000086220949,     0.000000029682430,     0.000000011576073,     0.000000005041272,     0.000000002422386,     0.000000001271058,     0.000000000721507,
     0.000000000439236,     0.000000000284441,     0.000000000194446,     0.189852502267990,     0.004356413536573,     0.000299890781679,     0.000034406919786,     0.000005526573987,     0.000001141322206,     0.000000288072514,
     0.000000085924703,     0.000000029566921,     0.000000011525781,     0.000000005017111,     0.000000002409711,     0.000000001263865,     0.000000000717129,     0.000000000436401,     0.000000000282503,     0.000000000193058,
     0.189808953121431,     0.004353416348182,     0.000299546988620,     0.000034351711064,     0.000005515175155,     0.000001138445773,     0.000000287214743,     0.000000085629609,     0.000000029451913,     0.000000011475730,
     0.000000004993077,     0.000000002397108,     0.000000001256715,     0.000000000712779,     0.000000000433586,     0.000000000280580,     0.000000000191680,     0.189765433929576,     0.004350422594962,     0.000299203747079,
     0.000034296616187,     0.000005503805043,     0.000001135577902,     0.000000286359918,     0.000000085335663,     0.000000029337405,     0.000000011425919,     0.000000004969169,     0.000000002384577,     0.000000001249609,
     0.000000000708457,     0.000000000430789,     0.000000000278670,     0.000000000190313,     0.189721944658100,     0.004347432271406,     0.000298861055918,     0.000034241634868,     0.000005492463568,     0.000001132718564,
     0.000000285508026,     0.000000085042859,     0.000000029223394,     0.000000011376346,     0.000000004945385,     0.000000002372116,     0.000000001242546,     0.000000000704163,     0.000000000428012,     0.000000000276773,
     0.000000000188955,     0.189678485272734,     0.004344445372013,     0.000298518914004,     0.000034186766820,     0.000005481150644,     0.000001129867731,     0.000000284659057,     0.000000084751193,     0.000000029109878,
     0.000000011327011,     0.000000004921726,     0.000000002359725,     0.000000001235526,     0.000000000699897,     0.000000000425254,     0.000000000274891,     0.000000000187608,     0.189635055739264,     0.004341461891298,
     0.000298177320205,     0.000034132011760,     0.000005469866185,     0.000001127025374,     0.000000283812998,     0.000000084460660,     0.000000028996853,     0.000000011277911,     0.000000004898191,     0.000000002347405,
     0.000000001228548,     0.000000000695658,     0.000000000422514,     0.000000000273021,     0.000000000186271,     0.189591656023531,     0.004338481823786,     0.000297836273393,     0.000034077369402,     0.000005458610108,
     0.000001124191462,     0.000000282969840,     0.000000084171255,     0.000000028884319,     0.000000011229046,     0.000000004874778,     0.000000002335154,     0.000000001221612,     0.000000000691447,     0.000000000419793,
     0.000000000271165,     0.000000000184943,     0.189548286091429,     0.004335505164011,     0.000297495772442,     0.000034022839464,     0.000005447382328,     0.000001121365967,     0.000000282129569,     0.000000083882972,
     0.000000028772272,     0.000000011180415,     0.000000004851487,     0.000000002322973,     0.000000001214719,     0.000000000687262,     0.000000000417091,     0.000000000269322,     0.000000000183626,     0.189504945908909,
     0.004332531906521,     0.000297155816230,     0.000033968421662,     0.000005436182761,     0.000001118548861,     0.000000281292176,     0.000000083595808,     0.000000028660710,     0.000000011132016,     0.000000004828318,
     0.000000002310860,     0.000000001207867,     0.000000000683105,     0.000000000414407,     0.000000000267493,     0.000000000182318,     0.189461635441976,     0.004329562045874,     0.000296816403636,     0.000033914115715,
     0.000005425011323,     0.000001115740114,     0.000000280457650,     0.000000083309756,     0.000000028549631,     0.000000011083848,     0.000000004805270,     0.000000002298815,     0.000000001201057,     0.000000000678974,
     0.000000000411741,     0.000000000265676,     0.000000000181020,     0.189418354656687,     0.004326595576640,     0.000296477533544,     0.000033859921342,     0.000005413867931,     0.000001112939698,     0.000000279625978,
     0.000000083024813,     0.000000028439032,     0.000000011035910,     0.000000004782342,     0.000000002286839,     0.000000001194287,     0.000000000674870,     0.000000000409093,     0.000000000263872,     0.000000000179732,
     0.189375103519156,     0.004323632493399,     0.000296139204838,     0.000033805838263,     0.000005402752501,     0.000001110147585,     0.000000278797150,     0.000000082740974,     0.000000028328912,     0.000000010988201,
     0.000000004759533,     0.000000002274929,     0.000000001187559,     0.000000000670792,     0.000000000406464,     0.000000000262081,     0.000000000178453,     0.189331881995551,     0.004320672790742,     0.000295801416408,
     0.000033751866199,     0.000005391664951,     0.000001107363746,     0.000000277971154,     0.000000082458233,     0.000000028219267,     0.000000010940719,     0.000000004736843,     0.000000002263087,     0.000000001180872,
     0.000000000666741,     0.000000000403852,     0.000000000260303,     0.000000000177183,     0.189288690052091,     0.004317716463274,     0.000295464167145,     0.000033698004871,     0.000005380605199,     0.000001104588153,
     0.000000277147981,     0.000000082176587,     0.000000028110096,     0.000000010893464,     0.000000004714271,     0.000000002251312,     0.000000001174224,     0.000000000662715,     0.000000000401257,     0.000000000258538,
     0.000000000175923,     0.189245527655053,     0.004314763505606,     0.000295127455943,     0.000033644254002,     0.000005369573161,     0.000001101820777,     0.000000276327619,     0.000000081896030,     0.000000028001397,
     0.000000010846434,     0.000000004691816,     0.000000002239603,     0.000000001167617,     0.000000000658715,     0.000000000398681,     0.000000000256785,     0.000000000174673,     0.189202394770764,     0.004311813912365,
     0.000294791281698,     0.000033590613316,     0.000005358568756,     0.000001099061591,     0.000000275510057,     0.000000081616558,     0.000000027893167,     0.000000010799627,     0.000000004669479,     0.000000002227959,
     0.000000001161050,     0.000000000654741,     0.000000000396122,     0.000000000255044,     0.000000000173431,     0.189159291365608,     0.004308867678186,     0.000294455643310,     0.000033537082535,     0.000005347591902,
     0.000001096310567,     0.000000274695284,     0.000000081338165,     0.000000027785404,     0.000000010753044,     0.000000004647257,     0.000000002216381,     0.000000001154522,     0.000000000650793,     0.000000000393580,
     0.000000000253316,     0.000000000172199,     0.189116217406021,     0.004305924797716,     0.000294120539682,     0.000033483661386,     0.000005336642518,     0.000001093567676,     0.000000273883290,     0.000000081060848,
     0.000000027678105,     0.000000010706682,     0.000000004625151,     0.000000002204869,     0.000000001148034,     0.000000000646870,     0.000000000391055,     0.000000000251600,     0.000000000170976,     0.189073172858493,
     0.004302985265613,     0.000293785969718,     0.000033430349594,     0.000005325720521,     0.000001090832891,     0.000000273074064,     0.000000080784601,     0.000000027571269,     0.000000010660540,     0.000000004603159,
     0.000000002193421,     0.000000001141585,     0.000000000642972,     0.000000000388548,     0.000000000249896,     0.000000000169762,     0.189030157689566,     0.004300049076546,     0.000293451932326,     0.000033377146885,
     0.000005314825833,     0.000001088106185,     0.000000272267595,     0.000000080509421,     0.000000027464894,     0.000000010614618,     0.000000004581282,     0.000000002182037,     0.000000001135174,     0.000000000639099,
     0.000000000386057,     0.000000000248205,     0.000000000168557,     0.188987171865836,     0.004297116225195,     0.000293118426417,     0.000033324052986,     0.000005303958371,     0.000001085387530,     0.000000271463872,
     0.000000080235302,     0.000000027358976,     0.000000010568914,     0.000000004559518,     0.000000002170717,     0.000000001128803,     0.000000000635250,     0.000000000383584,     0.000000000246525,     0.000000000167361,
     0.188944215353954,     0.004294186706250,     0.000292785450905,     0.000033271067627,     0.000005293118055,     0.000001082676899,     0.000000270662885,     0.000000079962240,     0.000000027253515,     0.000000010523427,
     0.000000004537868,     0.000000002159461,     0.000000001122469,     0.000000000631427,     0.000000000381127,     0.000000000244858,     0.000000000166174,     0.188901288120621,     0.004291260514413,     0.000292453004704,
     0.000033218190535,     0.000005282304806,     0.000001079974264,     0.000000269864624,     0.000000079690230,     0.000000027148507,     0.000000010478157,     0.000000004516329,     0.000000002148268,     0.000000001116174,
     0.000000000627628,     0.000000000378687,     0.000000000243202,     0.000000000164995,     0.188858390132593,     0.004288337644395,     0.000292121086734,     0.000033165421441,     0.000005271518544,     0.000001077279597,
     0.000000269069077,     0.000000079419268,     0.000000027043951,     0.000000010433100,     0.000000004494902,     0.000000002137137,     0.000000001109917,     0.000000000623853,     0.000000000376263,     0.000000000241558,
     0.000000000163825,     0.188815521356678,     0.004285418090921,     0.000291789695916,     0.000033112760074,     0.000005260759188,     0.000001074592873,     0.000000268276235,     0.000000079149350,     0.000000026939844,
     0.000000010388258,     0.000000004473586,     0.000000002126069,     0.000000001103697,     0.000000000620103,     0.000000000373855,     0.000000000239925,     0.000000000162664,     0.188772681759737,     0.004282501848723,
     0.000291458831174,     0.000033060206167,     0.000005250026660,     0.000001071914064,     0.000000267486086,     0.000000078880470,     0.000000026836185,     0.000000010343628,     0.000000004452380,     0.000000002115063,
     0.000000001097515,     0.000000000616376,     0.000000000371464,     0.000000000238304,     0.000000000161511,     0.188729871308683,     0.004279588912547,     0.000291128491435,     0.000033007759452,     0.000005239320880,
     0.000001069243142,     0.000000266698622,     0.000000078612625,     0.000000026732971,     0.000000010299210,     0.000000004431285,     0.000000002104119,     0.000000001091369,     0.000000000612673,     0.000000000369089,
     0.000000000236695,     0.000000000160367,     0.188687089970483,     0.004276679277148,     0.000290798675629,     0.000032955419661,     0.000005228641771,     0.000001066580082,     0.000000265913831,     0.000000078345809,
     0.000000026630200,     0.000000010255002,     0.000000004410298,     0.000000002093236,     0.000000001085261,     0.000000000608994,     0.000000000366730,     0.000000000235097,     0.000000000159232,     0.188644337712155,
     0.004273772937292,     0.000290469382687,     0.000032903186528,     0.000005217989253,     0.000001063924857,     0.000000265131702,     0.000000078080019,     0.000000026527870,     0.000000010211004,     0.000000004389420,
     0.000000002082413,     0.000000001079189,     0.000000000605339,     0.000000000364387,     0.000000000233510,     0.000000000158104,     0.188601614500770,     0.004270869887755,     0.000290140611544,     0.000032851059788,
     0.000005207363248,     0.000001061277439,     0.000000264352227,     0.000000077815250,     0.000000026425979,     0.000000010167214,     0.000000004368649,     0.000000002071652,     0.000000001073154,     0.000000000601706,
     0.000000000362060,     0.000000000231935,     0.000000000156985,     0.188558920303450,     0.004267970123325,     0.000289812361137,     0.000032799039175,     0.000005196763678,     0.000001058637804,     0.000000263575394,
     0.000000077551498,     0.000000026324525,     0.000000010123630,     0.000000004347986,     0.000000002060950,     0.000000001067155,     0.000000000598097,     0.000000000359749,     0.000000000230371,     0.000000000155875,
     0.188516255087370,     0.004265073638800,     0.000289484630407,     0.000032747124426,     0.000005186190466,     0.000001056005923,     0.000000262801193,     0.000000077288758,     0.000000026223506,     0.000000010080253,
     0.000000004327430,     0.000000002050308,     0.000000001061192,     0.000000000594511,     0.000000000357453,     0.000000000228817,     0.000000000154772,     0.188473618819758,     0.004262180428988,     0.000289157418297,
     0.000032695315278,     0.000005175643534,     0.000001053381771,     0.000000262029615,     0.000000077027026,     0.000000026122920,     0.000000010037081,     0.000000004306980,     0.000000002039726,     0.000000001055265,
     0.000000000590948,     0.000000000355172,     0.000000000227275,     0.000000000153678,     0.188431011467892,     0.004259290488709,     0.000288830723751,     0.000032643611468,     0.000005165122805,     0.000001050765322,
     0.000000261260650,     0.000000076766298,     0.000000026022764,     0.000000009994114,     0.000000004286635,     0.000000002029203,     0.000000001049373,     0.000000000587408,     0.000000000352907,     0.000000000225744,
     0.000000000152592,     0.188388432999102,     0.004256403812792,     0.000288504545717,     0.000032592012735,     0.000005154628202,     0.000001048156549,     0.000000260494286,     0.000000076506570,     0.000000025923037,
     0.000000009951348,     0.000000004266396,     0.000000002018739,     0.000000001043517,     0.000000000583890,     0.000000000350657,     0.000000000224223,     0.000000000151513,     0.188345883380772,     0.004253520396076,
     0.000288178883146,     0.000032540518817,     0.000005144159648,     0.000001045555427,     0.000000259730515,     0.000000076247836,     0.000000025823736,     0.000000009908785,     0.000000004246260,     0.000000002008333,
     0.000000001037695,     0.000000000580395,     0.000000000348423,     0.000000000222713,     0.000000000150443,     0.188303362580334,     0.004250640233414,     0.000287853734992,     0.000032489129455,     0.000005133717068,
     0.000001042961930,     0.000000258969326,     0.000000075990094,     0.000000025724860,     0.000000009866423,     0.000000004226229,     0.000000001997985,     0.000000001031909,     0.000000000576922,     0.000000000346203,
     0.000000000221214,     0.000000000149380,     0.188260870565274,     0.004247763319665,     0.000287529100210,     0.000032437844390,     0.000005123300384,     0.000001040376032,     0.000000258210710,     0.000000075733338,
     0.000000025626407,     0.000000009824260,     0.000000004206301,     0.000000001987694,     0.000000001026157,     0.000000000573471,     0.000000000343998,     0.000000000219726,     0.000000000148326,     0.188218407303128,
     0.004244889649702,     0.000287204977758,     0.000032386663362,     0.000005112909522,     0.000001037797708,     0.000000257454656,     0.000000075477564,     0.000000025528374,     0.000000009782297,     0.000000004186475,
     0.000000001977461,     0.000000001020439,     0.000000000570042,     0.000000000341808,     0.000000000218248,     0.000000000147279,     0.188175972761484,     0.004242019218406,     0.000286881366597,     0.000032335586113,
     0.000005102544405,     0.000001035226931,     0.000000256701155,     0.000000075222769,     0.000000025430760,     0.000000009740530,     0.000000004166751,     0.000000001967285,     0.000000001014756,     0.000000000566634,
     0.000000000339633,     0.000000000216780,     0.000000000146240,     0.188133566907981,     0.004239152020669,     0.000286558265690,     0.000032284612388,     0.000005092204958,     0.000001032663676,     0.000000255950197,
     0.000000074968947,     0.000000025333563,     0.000000009698961,     0.000000004147129,     0.000000001957166,     0.000000001009106,     0.000000000563249,     0.000000000337473,     0.000000000215323,     0.000000000145208,
     0.188091189710310,     0.004236288051395,     0.000286235674005,     0.000032233741929,     0.000005081891106,     0.000001030107918,     0.000000255201773,     0.000000074716096,     0.000000025236781,     0.000000009657588,
     0.000000004127608,     0.000000001947103,     0.000000001003491,     0.000000000559885,     0.000000000335327,     0.000000000213876,     0.000000000144184,     0.188048841136209,     0.004233427305495,     0.000285913590508,
     0.000032182974481,     0.000005071602775,     0.000001027559632,     0.000000254455872,     0.000000074464210,     0.000000025140411,     0.000000009616409,     0.000000004108187,     0.000000001937096,     0.000000000997909,
     0.000000000556542,     0.000000000333195,     0.000000000212439,     0.000000000143168,     0.188006521153472,     0.004230569777894,     0.000285592014172,     0.000032132309789,     0.000005061339889,     0.000001025018793,
     0.000000253712486,     0.000000074213286,     0.000000025044452,     0.000000009575423,     0.000000004088866,     0.000000001927145,     0.000000000992360,     0.000000000553221,     0.000000000331078,     0.000000000211013,
     0.000000000142159,     0.187964229729940,     0.004227715463525,     0.000285270943971,     0.000032081747598,     0.000005051102374,     0.000001022485374,     0.000000252971603,     0.000000073963320,     0.000000024948902,
     0.000000009534631,     0.000000004069644,     0.000000001917249,     0.000000000986844,     0.000000000549921,     0.000000000328975,     0.000000000209596,     0.000000000141157,     0.187921966833507,     0.004224864357331,
     0.000284950378880,     0.000032031287657,     0.000005040890157,     0.000001019959352,     0.000000252233216,     0.000000073714307,     0.000000024853759,     0.000000009494030,     0.000000004050520,     0.000000001907408,
     0.000000000981361,     0.000000000546641,     0.000000000326886,     0.000000000208189,     0.000000000140163,     0.187879732432117,     0.004222016454267,     0.000284630317878,     0.000031980929711,     0.000005030703163,
     0.000001017440702,     0.000000251497314,     0.000000073466244,     0.000000024759020,     0.000000009453620,     0.000000004031495,     0.000000001897622,     0.000000000975911,     0.000000000543383,     0.000000000324811,
     0.000000000206793,     0.000000000139176,     0.187837526493762,     0.004219171749296,     0.000284310759946,     0.000031930673510,     0.000005020541318,     0.000001014929398,     0.000000250763888,     0.000000073219125,
     0.000000024664685,     0.000000009413400,     0.000000004012568,     0.000000001887890,     0.000000000970494,     0.000000000540145,     0.000000000322750,     0.000000000205406,     0.000000000138196,     0.187795348986487,
     0.004216330237394,     0.000283991704069,     0.000031880518801,     0.000005010404550,     0.000001012425416,     0.000000250032928,     0.000000072972949,     0.000000024570752,     0.000000009373369,     0.000000003993737,
     0.000000001878212,     0.000000000965108,     0.000000000536928,     0.000000000320703,     0.000000000204029,     0.000000000137224,     0.187753199878387,     0.004213491913545,     0.000283673149233,     0.000031830465335,
     0.000005000292786,     0.000001009928731,     0.000000249304426,     0.000000072727709,     0.000000024477217,     0.000000009333525,     0.000000003975003,     0.000000001868587,     0.000000000959755,     0.000000000533731,
     0.000000000318669,     0.000000000202661,     0.000000000136259,     0.187711079137606,     0.004210656772743,     0.000283355094426,     0.000031780512862,     0.000004990205951,     0.000001007439319,     0.000000248578371,
     0.000000072483403,     0.000000024384081,     0.000000009293868,     0.000000003956365,     0.000000001859016,     0.000000000954434,     0.000000000530554,     0.000000000316650,     0.000000000201304,     0.000000000135300,
     0.187668986732339,     0.004207824809993,     0.000283037538640,     0.000031730661133,     0.000004980143975,     0.000001004957155,     0.000000247854755,     0.000000072240026,     0.000000024291340,     0.000000009254397,
     0.000000003937823,     0.000000001849498,     0.000000000949144,     0.000000000527398,     0.000000000314643,     0.000000000199955,     0.000000000134349,     0.187626922630829,     0.004204996020310,     0.000282720480868,
     0.000031680909900,     0.000004970106784,     0.000001002482216,     0.000000247133567,     0.000000071997575,     0.000000024198992,     0.000000009215111,     0.000000003919375,     0.000000001840033,     0.000000000943886,
     0.000000000524261,     0.000000000312651,     0.000000000198617,     0.000000000133405,     0.187584886801372,     0.004202170398719,     0.000282403920108,     0.000031631258915,     0.000004960094307,     0.000001000014476,
     0.000000246414800,     0.000000071756045,     0.000000024107037,     0.000000009176010,     0.000000003901022,     0.000000001830621,     0.000000000938659,     0.000000000521145,     0.000000000310671,     0.000000000197287,
     0.000000000132467,     0.187542879212311,     0.004199347940255,     0.000282087855357,     0.000031581707932,     0.000004950106471,     0.000000997553912,     0.000000245698444,     0.000000071515433,     0.000000024015471,
     0.000000009137091,     0.000000003882763,     0.000000001821260,     0.000000000933463,     0.000000000518048,     0.000000000308705,     0.000000000195967,     0.000000000131537,     0.187500899832040,     0.004196528639962,
     0.000281772285616,     0.000031532256704,     0.000004940143205,     0.000000995100499,     0.000000244984488,     0.000000071275734,     0.000000023924294,     0.000000009098354,     0.000000003864597,     0.000000001811951,
     0.000000000928298,     0.000000000514971,     0.000000000306752,     0.000000000194656,     0.000000000130613,     0.187458948629001,     0.004193712492896,     0.000281457209891,     0.000031482904986,     0.000004930204437,
     0.000000992654214,     0.000000244272926,     0.000000071036946,     0.000000023833504,     0.000000009059798,     0.000000003846523,     0.000000001802694,     0.000000000923163,     0.000000000511913,     0.000000000304812,
     0.000000000193355,     0.000000000129696,     0.187417025571688,     0.004190899494121,     0.000281142627186,     0.000031433652534,     0.000004920290097,     0.000000990215033,     0.000000243563746,     0.000000070799063,
     0.000000023743098,     0.000000009021423,     0.000000003828543,     0.000000001793488,     0.000000000918059,     0.000000000508874,     0.000000000302885,     0.000000000192063,     0.000000000128786,     0.187375130628641,
     0.004188089638712,     0.000280828536510,     0.000031384499103,     0.000004910400113,     0.000000987782931,     0.000000242856942,     0.000000070562082,     0.000000023653075,     0.000000008983227,     0.000000003810654,
     0.000000001784333,     0.000000000912986,     0.000000000505855,     0.000000000300970,     0.000000000190779,     0.000000000127883,     0.187333263768452,     0.004185282921754,     0.000280514936874,     0.000031335444451,
     0.000004900534415,     0.000000985357886,     0.000000242152502,     0.000000070326000,     0.000000023563433,     0.000000008945210,     0.000000003792856,     0.000000001775228,     0.000000000907942,     0.000000000502855,
     0.000000000299069,     0.000000000189505,     0.000000000126986,     0.187291424959761,     0.004182479338341,     0.000280201827293,     0.000031286488334,     0.000004890692932,     0.000000982939873,     0.000000241450419,
     0.000000070090812,     0.000000023474170,     0.000000008907370,     0.000000003775149,     0.000000001766174,     0.000000000902928,     0.000000000499874,     0.000000000297180,     0.000000000188239,     0.000000000126096,
     0.187249614171256,     0.004179678883578,     0.000279889206780,     0.000031237630512,     0.000004880875594,     0.000000980528870,     0.000000240750683,     0.000000069856515,     0.000000023385285,     0.000000008869707,
     0.000000003757532,     0.000000001757169,     0.000000000897945,     0.000000000496911,     0.000000000295304,     0.000000000186983,     0.000000000125212,     0.187207831371677,     0.004176881552578,     0.000279577074355,
     0.000031188870742,     0.000004871082331,     0.000000978124852,     0.000000240053285,     0.000000069623105,     0.000000023296775,     0.000000008832219,     0.000000003740005,     0.000000001748215,     0.000000000892990,
     0.000000000493968,     0.000000000293441,     0.000000000185735,     0.000000000124334,     0.187166076529809,     0.004174087340467,     0.000279265429039,     0.000031140208785,     0.000004861313073,     0.000000975727796,
     0.000000239358218,     0.000000069390579,     0.000000023208640,     0.000000008794906,     0.000000003722568,     0.000000001739310,     0.000000000888065,     0.000000000491043,     0.000000000291589,     0.000000000184496,
     0.000000000123463,     0.187124349614487,     0.004171296242377,     0.000278954269855,     0.000031091644401,     0.000004851567752,     0.000000973337680,     0.000000238665471,     0.000000069158931,     0.000000023120876,
     0.000000008757767,     0.000000003705219,     0.000000001730453,     0.000000000883169,     0.000000000488136,     0.000000000289751,     0.000000000183266,     0.000000000122599,     0.187082650594597,     0.004168508253452,
     0.000278643595827,     0.000031043177350,     0.000004841846297,     0.000000970954479,     0.000000237975036,     0.000000068928160,     0.000000023033484,     0.000000008720801,     0.000000003687958,     0.000000001721646,
     0.000000000878302,     0.000000000485247,     0.000000000287924,     0.000000000182044,     0.000000000121741,     0.187040979439070,     0.004165723368846,     0.000278333405984,     0.000030994807395,     0.000004832148639,
     0.000000968578171,     0.000000237286905,     0.000000068698260,     0.000000022946460,     0.000000008684008,     0.000000003670786,     0.000000001712887,     0.000000000873464,     0.000000000482377,     0.000000000286110,
     0.000000000180831,     0.000000000120889,     0.186999336116889,     0.004162941583722,     0.000278023699356,     0.000030946534298,     0.000004822474710,     0.000000966208733,     0.000000236601068,     0.000000068469229,
     0.000000022859803,     0.000000008647385,     0.000000003653701,     0.000000001704177,     0.000000000868655,     0.000000000479525,     0.000000000284307,     0.000000000179626,     0.000000000120043,     0.186957720597081,
     0.004160162893252,     0.000277714474976,     0.000030898357822,     0.000004812824442,     0.000000963846142,     0.000000235917517,     0.000000068241063,     0.000000022773511,     0.000000008610934,     0.000000003636702,
     0.000000001695514,     0.000000000863874,     0.000000000476691,     0.000000000282517,     0.000000000178430,     0.000000000119203,     0.186916132848724,     0.004157387292618,     0.000277405731878,     0.000030850277731,
     0.000004803197765,     0.000000961490375,     0.000000235236244,     0.000000068013758,     0.000000022687584,     0.000000008574651,     0.000000003619790,     0.000000001686899,     0.000000000859121,     0.000000000473875,
     0.000000000280739,     0.000000000177242,     0.000000000118370,     0.186874572840945,     0.004154614777013,     0.000277097469101,     0.000030802293789,     0.000004793594612,     0.000000959141410,     0.000000234557239,
     0.000000067787310,     0.000000022602018,     0.000000008538537,     0.000000003602964,     0.000000001678332,     0.000000000854396,     0.000000000471076,     0.000000000278972,     0.000000000176063,     0.000000000117542,
     0.186833040542916,     0.004151845341638,     0.000276789685683,     0.000030754405761,     0.000004784014914,     0.000000956799223,     0.000000233880495,     0.000000067561716,     0.000000022516812,     0.000000008502592,
     0.000000003586223,     0.000000001669811,     0.000000000849699,     0.000000000468295,     0.000000000277217,     0.000000000174891,     0.000000000116721,     0.186791535923860,     0.004149078981705,     0.000276482380667,
     0.000030706613412,     0.000004774458605,     0.000000954463792,     0.000000233206002,     0.000000067336973,     0.000000022431966,     0.000000008466813,     0.000000003569568,     0.000000001661337,     0.000000000845030,
     0.000000000465532,     0.000000000275474,     0.000000000173728,     0.000000000115906,     0.186750058953047,     0.004146315692434,     0.000276175553096,     0.000030658916511,     0.000004764925616,     0.000000952135096,
     0.000000232533752,     0.000000067113076,     0.000000022347476,     0.000000008431200,     0.000000003552996,     0.000000001652910,     0.000000000840389,     0.000000000462786,     0.000000000273743,     0.000000000172573,
     0.000000000115096,     0.186708609599792,     0.004143555469055,     0.000275869202019,     0.000030611314823,     0.000004755415880,     0.000000949813110,     0.000000231863738,     0.000000066890022,     0.000000022263341,
     0.000000008395752,     0.000000003536509,     0.000000001644530,     0.000000000835774,     0.000000000460057,     0.000000000272023,     0.000000000171426,     0.000000000114293,     0.186667187833462,     0.004140798306808,
     0.000275563326483,     0.000030563808116,     0.000004745929331,     0.000000947497813,     0.000000231195949,     0.000000066667808,     0.000000022179560,     0.000000008360469,     0.000000003520106,     0.000000001636195,
     0.000000000831187,     0.000000000457345,     0.000000000270314,     0.000000000170287,     0.000000000113495,     0.186625793623468,     0.004138044200943,     0.000275257925541,     0.000030516396159,     0.000004736465902,
     0.000000945189184,     0.000000230530379,     0.000000066446430,     0.000000022096131,     0.000000008325350,     0.000000003503785,     0.000000001627906,     0.000000000826627,     0.000000000454651,     0.000000000268617,
     0.000000000169156,     0.000000000112703,     0.186584426939271,     0.004135293146718,     0.000274952998245,     0.000030469078721,     0.000004727025525,     0.000000942887198,     0.000000229867018,     0.000000066225884,
     0.000000022013052,     0.000000008290393,     0.000000003487547,     0.000000001619662,     0.000000000822094,     0.000000000451973,     0.000000000266931,     0.000000000168033,     0.000000000111917,     0.186543087750377,
     0.004132545139402,     0.000274648543652,     0.000030421855572,     0.000004717608136,     0.000000940591836,     0.000000229205858,     0.000000066006168,     0.000000021930323,     0.000000008255599,     0.000000003471392,
     0.000000001611464,     0.000000000817588,     0.000000000449312,     0.000000000265256,     0.000000000166918,     0.000000000111137,     0.186501776026342,     0.004129800174273,     0.000274344560820,     0.000030374726482,
     0.000004708213667,     0.000000938303074,     0.000000228546892,     0.000000065787277,     0.000000021847940,     0.000000008220965,     0.000000003455318,     0.000000001603310,     0.000000000813108,     0.000000000446668,
     0.000000000263593,     0.000000000165811,     0.000000000110362,     0.186460491736767,     0.004127058246617,     0.000274041048810,     0.000030327691222,     0.000004698842052,     0.000000936020891,     0.000000227890110,
     0.000000065569208,     0.000000021765903,     0.000000008186492,     0.000000003439325,     0.000000001595202,     0.000000000808654,     0.000000000444040,     0.000000000261940,     0.000000000164711,     0.000000000109593,
     0.186419234851301,     0.004124319351730,     0.000273738006684,     0.000030280749565,     0.000004689493227,     0.000000933745264,     0.000000227235505,     0.000000065351957,     0.000000021684210,     0.000000008152179,
     0.000000003423414,     0.000000001587137,     0.000000000804227,     0.000000000441429,     0.000000000260299,     0.000000000163619,     0.000000000108829,     0.186378005339639,     0.004121583484920,     0.000273435433507,
     0.000030233901282,     0.000004680167125,     0.000000931476173,     0.000000226583068,     0.000000065135522,     0.000000021602859,     0.000000008118024,     0.000000003407583,     0.000000001579117,     0.000000000799826,
     0.000000000438834,     0.000000000258668,     0.000000000162534,     0.000000000108072,     0.186336803171524,     0.004118850641500,     0.000273133328348,     0.000030187146147,     0.000004670863682,     0.000000929213596,
     0.000000225932792,     0.000000064919899,     0.000000021521849,     0.000000008084027,     0.000000003391831,     0.000000001571141,     0.000000000795450,     0.000000000436256,     0.000000000257048,     0.000000000161457,
     0.000000000107319,     0.186295628316746,     0.004116120816796,     0.000272831690274,     0.000030140483933,     0.000004661582832,     0.000000926957510,     0.000000225284667,     0.000000064705084,     0.000000021441178,
     0.000000008050187,     0.000000003376160,     0.000000001563208,     0.000000000791101,     0.000000000433693,     0.000000000255439,     0.000000000160388,     0.000000000106572,     0.186254480745141,     0.004113394006141,
     0.000272530518360,     0.000030093914415,     0.000004652324510,     0.000000924707895,     0.000000224638687,     0.000000064491074,     0.000000021360844,     0.000000008016503,     0.000000003360567,     0.000000001555318,
     0.000000000786776,     0.000000000431147,     0.000000000253840,     0.000000000159326,     0.000000000105831,     0.186213360426592,     0.004110670204878,     0.000272229811678,     0.000030047437368,     0.000004643088652,
     0.000000922464730,     0.000000223994843,     0.000000064277866,     0.000000021280847,     0.000000007982975,     0.000000003345053,     0.000000001547472,     0.000000000782478,     0.000000000428616,     0.000000000252252,
     0.000000000158271,     0.000000000105095,     0.186172267331028,     0.004107949408360,     0.000271929569305,     0.000030001052567,     0.000004633875194,     0.000000920227991,     0.000000223353127,     0.000000064065456,
     0.000000021201184,     0.000000007949602,     0.000000003329617,     0.000000001539669,     0.000000000778204,     0.000000000426102,     0.000000000250675,     0.000000000157224,     0.000000000104364,     0.186131201428425,
     0.004105231611947,     0.000271629790320,     0.000029954759790,     0.000004624684071,     0.000000917997660,     0.000000222713532,     0.000000063853841,     0.000000021121854,     0.000000007916383,     0.000000003314260,
     0.000000001531908,     0.000000000773956,     0.000000000423603,     0.000000000249108,     0.000000000156184,     0.000000000103638,     0.186090162688804,     0.004102516811012,     0.000271330473803,     0.000029908558812,
     0.000004615515220,     0.000000915773714,     0.000000222076048,     0.000000063643018,     0.000000021042856,     0.000000007883316,     0.000000003298979,     0.000000001524190,     0.000000000769732,     0.000000000421119,
     0.000000000247551,     0.000000000155151,     0.000000000102918,     0.186049151082235,     0.004099805000933,     0.000271031618838,     0.000029862449411,     0.000004606368576,     0.000000913556132,     0.000000221440669,
     0.000000063432983,     0.000000020964188,     0.000000007850403,     0.000000003283776,     0.000000001516513,     0.000000000765533,     0.000000000418652,     0.000000000246004,     0.000000000154126,     0.000000000102203,
     0.186008166578831,     0.004097096177099,     0.000270733224511,     0.000029816431366,     0.000004597244076,     0.000000911344893,     0.000000220807386,     0.000000063223733,     0.000000020885848,     0.000000007817641,
     0.000000003268649,     0.000000001508879,     0.000000000761359,     0.000000000416199,     0.000000000244468,     0.000000000153107,     0.000000000101493,     0.185967209148754,     0.004094390334910,     0.000270435289907,
     0.000029770504456,     0.000004588141657,     0.000000909139977,     0.000000220176191,     0.000000063015265,     0.000000020807834,     0.000000007785030,     0.000000003253598,     0.000000001501286,     0.000000000757209,
     0.000000000413762,     0.000000000242942,     0.000000000152096,     0.000000000100789,     0.185926278762210,     0.004091687469772,     0.000270137814118,     0.000029724668460,     0.000004579061255,     0.000000906941363,
     0.000000219547078,     0.000000062807576,     0.000000020730146,     0.000000007752568,     0.000000003238623,     0.000000001493735,     0.000000000753084,     0.000000000411340,     0.000000000241426,     0.000000000151091,
     0.000000000100089,     0.185885375389451,     0.004088987577101,     0.000269840796236,     0.000029678923158,     0.000004570002809,     0.000000904749029,     0.000000218920037,     0.000000062600661,     0.000000020652782,
     0.000000007720257,     0.000000003223723,     0.000000001486224,     0.000000000748982,     0.000000000408934,     0.000000000239920,     0.000000000150094,     0.000000000099395,     0.185844499000775,     0.004086290652324,
     0.000269544235354,     0.000029633268331,     0.000004560966254,     0.000000902562955,     0.000000218295062,     0.000000062394519,     0.000000020575741,     0.000000007688094,     0.000000003208898,     0.000000001478755,
     0.000000000744905,     0.000000000406542,     0.000000000238424,     0.000000000149103,     0.000000000098705,     0.185803649566526,     0.004083596690874,     0.000269248130568,     0.000029587703760,     0.000004551951529,
     0.000000900383121,     0.000000217672144,     0.000000062189145,     0.000000020499020,     0.000000007656079,     0.000000003194148,     0.000000001471326,     0.000000000740851,     0.000000000404165,     0.000000000236938,
     0.000000000148120,     0.000000000098021,     0.185762827057095,     0.004080905688195,     0.000268952480978,     0.000029542229228,     0.000004542958571,     0.000000898209505,     0.000000217051276,     0.000000061984537,
     0.000000020422619,     0.000000007624211,     0.000000003179472,     0.000000001463938,     0.000000000736822,     0.000000000401803,     0.000000000235462,     0.000000000147143,     0.000000000097341,     0.185722031442915,
     0.004078217639740,     0.000268657285684,     0.000029496844516,     0.000004533987318,     0.000000896042088,     0.000000216432451,     0.000000061780692,     0.000000020346535,     0.000000007592489,     0.000000003164869,
     0.000000001456590,     0.000000000732815,     0.000000000399456,     0.000000000233996,     0.000000000146173,     0.000000000096667,     0.185681262694468,     0.004075532540970,     0.000268362543789,     0.000029451549409,
     0.000004525037708,     0.000000893880850,     0.000000215815660,     0.000000061577606,     0.000000020270768,     0.000000007560913,     0.000000003150340,     0.000000001449281,     0.000000000728832,     0.000000000397123,
     0.000000000232539,     0.000000000145210,     0.000000000095997,     0.185640520782278,     0.004072850387356,     0.000268068254398,     0.000029406343690,     0.000004516109680,     0.000000891725768,     0.000000215200896,
     0.000000061375275,     0.000000020195317,     0.000000007529482,     0.000000003135883,     0.000000001442013,     0.000000000724873,     0.000000000394805,     0.000000000231091,     0.000000000144253,     0.000000000095332,
     0.185599805676918,     0.004070171174377,     0.000267774416618,     0.000029361227144,     0.000004507203173,     0.000000889576825,     0.000000214588152,     0.000000061173698,     0.000000020120178,     0.000000007498195,
     0.000000003121499,     0.000000001434784,     0.000000000720936,     0.000000000392501,     0.000000000229654,     0.000000000143303,     0.000000000094672,     0.185559117349004,     0.004067494897521,     0.000267481029559,
     0.000029316199555,     0.000004498318123,     0.000000887433999,     0.000000213977420,     0.000000060972871,     0.000000020045352,     0.000000007467052,     0.000000003107187,     0.000000001427594,     0.000000000717023,
     0.000000000390212,     0.000000000228225,     0.000000000142359,     0.000000000094017,     0.185518455769196,     0.004064821552286,     0.000267188092331,     0.000029271260710,     0.000004489454472,     0.000000885297270,
     0.000000213368692,     0.000000060772790,     0.000000019970837,     0.000000007436051,     0.000000003092947,     0.000000001420443,     0.000000000713132,     0.000000000387937,     0.000000000226806,     0.000000000141423,
     0.000000000093366,     0.185477820908201,     0.004062151134178,     0.000266895604049,     0.000029226410394,     0.000004480612158,     0.000000883166618,     0.000000212761962,     0.000000060573453,     0.000000019896631,
     0.000000007405192,     0.000000003078778,     0.000000001413331,     0.000000000709264,     0.000000000385676,     0.000000000225397,     0.000000000140492,     0.000000000092721,     0.185437212736770,     0.004059483638712,
     0.000266603563829,     0.000029181648396,     0.000004471791120,     0.000000881042024,     0.000000212157221,     0.000000060374856,     0.000000019822733,     0.000000007374475,     0.000000003064681,     0.000000001406258,
     0.000000000705418,     0.000000000383429,     0.000000000223996,     0.000000000139568,     0.000000000092079,     0.185396631225699,     0.004056819061411,     0.000266311970788,     0.000029136974501,     0.000004462991297,
     0.000000878923467,     0.000000211554462,     0.000000060176997,     0.000000019749141,     0.000000007343899,     0.000000003050653,     0.000000001399223,     0.000000000701595,     0.000000000381196,     0.000000000222605,
     0.000000000138651,     0.000000000091443,     0.185356076345830,     0.004054157397808,     0.000266020824046,     0.000029092388499,     0.000004454212630,     0.000000876810928,     0.000000210953678,     0.000000059979873,
     0.000000019675854,     0.000000007313462,     0.000000003036696,     0.000000001392226,     0.000000000697794,     0.000000000378977,     0.000000000221223,     0.000000000137739,     0.000000000090811,     0.185315548068046,
     0.004051498643445,     0.000265730122726,     0.000029047890178,     0.000004445455059,     0.000000874704387,     0.000000210354862,     0.000000059783479,     0.000000019602871,     0.000000007283164,     0.000000003022808,
     0.000000001385267,     0.000000000694016,     0.000000000376771,     0.000000000219851,     0.000000000136834,     0.000000000090184,     0.185275046363278,     0.004048842793872,     0.000265439865951,     0.000029003479328,
     0.000004436718523,     0.000000872603824,     0.000000209758006,     0.000000059587814,     0.000000019530190,     0.000000007253006,     0.000000003008990,     0.000000001378346,     0.000000000690259,     0.000000000374580,
     0.000000000218487,     0.000000000135936,     0.000000000089561,     0.185234571202501,     0.004046189844647,     0.000265150052848,     0.000028959155738,     0.000004428002962,     0.000000870509220,     0.000000209163103,
     0.000000059392874,     0.000000019457811,     0.000000007222984,     0.000000002995241,     0.000000001371462,     0.000000000686524,     0.000000000372402,     0.000000000217132,     0.000000000135043,     0.000000000088942,
     0.185194122556732,     0.004043539791339,     0.000264860682546,     0.000028914919199,     0.000004419308318,     0.000000868420556,     0.000000208570146,     0.000000059198657,     0.000000019385730,     0.000000007193100,
     0.000000002981561,     0.000000001364615,     0.000000000682811,     0.000000000370237,     0.000000000215786,     0.000000000134157,     0.000000000088329,     0.185153700397036,     0.004040892629523,     0.000264571754175,
     0.000028870769502,     0.000004410634531,     0.000000866337811,     0.000000207979128,     0.000000059005159,     0.000000019313948,     0.000000007163353,     0.000000002967949,     0.000000001357805,     0.000000000679119,
     0.000000000368086,     0.000000000214449,     0.000000000133276,     0.000000000087719,     0.185113304694518,     0.004038248354785,     0.000264283266867,     0.000028826706439,     0.000004401981543,     0.000000864260967,
     0.000000207390041,     0.000000058812377,     0.000000019242463,     0.000000007133741,     0.000000002954405,     0.000000001351033,     0.000000000675449,     0.000000000365948,     0.000000000213120,     0.000000000132402,
     0.000000000087114,     0.185072935420331,     0.004035606962719,     0.000263995219758,     0.000028782729802,     0.000004393349293,     0.000000862190004,     0.000000206802878,     0.000000058620309,     0.000000019171273,
     0.000000007104265,     0.000000002940928,     0.000000001344296,     0.000000000671800,     0.000000000363824,     0.000000000211801,     0.000000000131534,     0.000000000086513,     0.185032592545669,     0.004032968448926,
     0.000263707611984,     0.000028738839384,     0.000004384737723,     0.000000860124903,     0.000000206217632,     0.000000058428951,     0.000000019100377,     0.000000007074922,     0.000000002927519,     0.000000001337597,
     0.000000000668173,     0.000000000361712,     0.000000000210490,     0.000000000130672,     0.000000000085917,     0.184992276041773,     0.004030332809017,     0.000263420442683,     0.000028695034979,     0.000004376146775,
     0.000000858065645,     0.000000205634297,     0.000000058238300,     0.000000019029774,     0.000000007045714,     0.000000002914176,     0.000000001330933,     0.000000000664566,     0.000000000359614,     0.000000000209187,
     0.000000000129816,     0.000000000085325,     0.184951985879924,     0.004027700038613,     0.000263133710998,     0.000028651316380,     0.000004367576391,     0.000000856012211,     0.000000205052864,     0.000000058048354,
     0.000000018959462,     0.000000007016639,     0.000000002900900,     0.000000001324305,     0.000000000660980,     0.000000000357528,     0.000000000207893,     0.000000000128966,     0.000000000084737,     0.184911722031450,
     0.004025070133341,     0.000262847416071,     0.000028607683383,     0.000004359026511,     0.000000853964581,     0.000000204473327,     0.000000057859110,     0.000000018889441,     0.000000006987696,     0.000000002887690,
     0.000000001317713,     0.000000000657415,     0.000000000355456,     0.000000000206608,     0.000000000128121,     0.000000000084153,     0.184871484467721,     0.004022443088839,     0.000262561557046,     0.000028564135782,
     0.000004350497080,     0.000000851922738,     0.000000203895679,     0.000000057670564,     0.000000018819708,     0.000000006958885,     0.000000002874546,     0.000000001311157,     0.000000000653871,     0.000000000353396,
     0.000000000205331,     0.000000000127282,     0.000000000083574,     0.184831273160152,     0.004019818900750,     0.000262276133071,     0.000028520673373,     0.000004341988037,     0.000000849886661,     0.000000203319914,
     0.000000057482715,     0.000000018750263,     0.000000006930205,     0.000000002861467,     0.000000001304636,     0.000000000650347,     0.000000000351349,     0.000000000204062,     0.000000000126450,     0.000000000082999,
     0.184791088080199,     0.004017197564730,     0.000261991143295,     0.000028477295953,     0.000004333499327,     0.000000847856333,     0.000000202746023,     0.000000057295558,     0.000000018681103,     0.000000006901655,
     0.000000002848453,     0.000000001298150,     0.000000000646844,     0.000000000349315,     0.000000000202802,     0.000000000125622,     0.000000000082428,     0.184750929199365,     0.004014579076440,     0.000261706586869,
     0.000028434003319,     0.000004325030892,     0.000000845831735,     0.000000202174000,     0.000000057109092,     0.000000018612229,     0.000000006873235,     0.000000002835504,     0.000000001291699,     0.000000000643361,
     0.000000000347293,     0.000000000201550,     0.000000000124801,     0.000000000081861,     0.184710796489193,     0.004011963431551,     0.000261422462947,     0.000028390795268,     0.000004316582674,     0.000000843812847,
     0.000000201603839,     0.000000056923313,     0.000000018543638,     0.000000006844945,     0.000000002822619,     0.000000001285283,     0.000000000639898,     0.000000000345284,     0.000000000200306,     0.000000000123985,
     0.000000000081298,     0.184670689921270,     0.004009350625742,     0.000261138770683,     0.000028347671599,     0.000004308154616,     0.000000841799652,     0.000000201035532,     0.000000056738218,     0.000000018475330,
     0.000000006816783,     0.000000002809798,     0.000000001278901,     0.000000000636455,     0.000000000343287,     0.000000000199070,     0.000000000123175,     0.000000000080739,     0.184630609467229,     0.004006740654701,
     0.000260855509234,     0.000028304632109,     0.000004299746662,     0.000000839792130,     0.000000200469072,     0.000000056553805,     0.000000018407302,     0.000000006788749,     0.000000002797041,     0.000000001272553,
     0.000000000633032,     0.000000000341302,     0.000000000197842,     0.000000000122370,     0.000000000080184,     0.184590555098741,     0.004004133514124,     0.000260572677760,     0.000028261676598,     0.000004291358754,
     0.000000837790264,     0.000000199904453,     0.000000056370071,     0.000000018339554,     0.000000006760842,     0.000000002784347,     0.000000001266240,     0.000000000629629,     0.000000000339330,     0.000000000196623,
     0.000000000121571,     0.000000000079633,     0.184550526787526,     0.004001529199716,     0.000260290275423,     0.000028218804867,     0.000004282990838,     0.000000835794035,     0.000000199341668,     0.000000056187013,
     0.000000018272085,     0.000000006733062,     0.000000002771716,     0.000000001259961,     0.000000000626246,     0.000000000337370,     0.000000000195411,     0.000000000120778,     0.000000000079086,     0.184510524505341,
     0.003998927707188,     0.000260008301385,     0.000028176016715,     0.000004274642855,     0.000000833803425,     0.000000198780711,     0.000000056004628,     0.000000018204893,     0.000000006705407,     0.000000002759147,
     0.000000001253715,     0.000000000622882,     0.000000000335422,     0.000000000194207,     0.000000000119990,     0.000000000078543,     0.184470548223990,     0.003996329032263,     0.000259726754811,     0.000028133311944,
     0.000004266314750,     0.000000831818415,     0.000000198221574,     0.000000055822914,     0.000000018137976,     0.000000006677878,     0.000000002746641,     0.000000001247503,     0.000000000619537,     0.000000000333486,
     0.000000000193011,     0.000000000119207,     0.000000000078004,     0.184430597915318,     0.003993733170670,     0.000259445634868,     0.000028090690354,     0.000004258006468,     0.000000829838987,     0.000000197664250,
     0.000000055641868,     0.000000018071335,     0.000000006650474,     0.000000002734197,     0.000000001241324,     0.000000000616212,     0.000000000331562,     0.000000000191823,     0.000000000118430,     0.000000000077469,
     0.184390673551213,     0.003991140118146,     0.000259164940727,     0.000028048151749,     0.000004249717952,     0.000000827865124,     0.000000197108734,     0.000000055461487,     0.000000018004966,     0.000000006623194,
     0.000000002721815,     0.000000001235179,     0.000000000612906,     0.000000000329649,     0.000000000190642,     0.000000000117657,     0.000000000076938,     0.184350775103606,     0.003988549870439,     0.000258884671557,
     0.000028005695929,     0.000004241449147,     0.000000825896806,     0.000000196555018,     0.000000055281768,     0.000000017938870,     0.000000006596038,     0.000000002709493,     0.000000001229066,     0.000000000609619,
     0.000000000327749,     0.000000000189470,     0.000000000116891,     0.000000000076410,     0.184310902544469,     0.003985962423301,     0.000258604826533,     0.000027963322700,     0.000004233199998,     0.000000823934017,
     0.000000196003096,     0.000000055102708,     0.000000017873045,     0.000000006569004,     0.000000002697233,     0.000000001222986,     0.000000000606351,     0.000000000325860,     0.000000000188305,     0.000000000116129,
     0.000000000075887,     0.184271055845818,     0.003983377772497,     0.000258325404829,     0.000027921031864,     0.000004224970448,     0.000000821976739,     0.000000195452962,     0.000000054924306,     0.000000017807490,
     0.000000006542093,     0.000000002685034,     0.000000001216939,     0.000000000603102,     0.000000000323983,     0.000000000187147,     0.000000000115373,     0.000000000075366,     0.184231234979712,     0.003980795913796,
     0.000258046405622,     0.000027878823226,     0.000004216760444,     0.000000820024952,     0.000000194904608,     0.000000054746558,     0.000000017742203,     0.000000006515303,     0.000000002672894,     0.000000001210924,
     0.000000000599871,     0.000000000322117,     0.000000000185997,     0.000000000114622,     0.000000000074850,     0.184191439918249,     0.003978216842979,     0.000257767828091,     0.000027836696590,     0.000004208569931,
     0.000000818078640,     0.000000194358029,     0.000000054569461,     0.000000017677183,     0.000000006488635,     0.000000002660815,     0.000000001204941,     0.000000000596659,     0.000000000320263,     0.000000000184855,
     0.000000000113876,     0.000000000074338,     0.184151670633573,     0.003975640555832,     0.000257489671417,     0.000027794651763,     0.000004200398853,     0.000000816137786,     0.000000193813217,     0.000000054393013,
     0.000000017612430,     0.000000006462087,     0.000000002648795,     0.000000001198991,     0.000000000593466,     0.000000000318420,     0.000000000183720,     0.000000000113135,     0.000000000073829,     0.184111927097868,
     0.003973067048150,     0.000257211934784,     0.000027752688549,     0.000004192247157,     0.000000814202370,     0.000000193270166,     0.000000054217212,     0.000000017547941,     0.000000006435659,     0.000000002636835,
     0.000000001193072,     0.000000000590291,     0.000000000316588,     0.000000000182592,     0.000000000112399,     0.000000000073323,     0.184072209283359,     0.003970496315739,     0.000256934617375,     0.000027710806755,
     0.000004184114788,     0.000000812272377,     0.000000192728870,     0.000000054042053,     0.000000017483716,     0.000000006409350,     0.000000002624934,     0.000000001187185,     0.000000000587134,     0.000000000314768,
     0.000000000181472,     0.000000000111669,     0.000000000072822,     0.184032517162316,     0.003967928354408,     0.000256657718378,     0.000027669006189,     0.000004176001692,     0.000000810347787,     0.000000192189323,
     0.000000053867536,     0.000000017419754,     0.000000006383160,     0.000000002613091,     0.000000001181329,     0.000000000583996,     0.000000000312959,     0.000000000180358,     0.000000000110943,     0.000000000072324,
     0.183992850707048,     0.003965363159979,     0.000256381236981,     0.000027627286657,     0.000004167907814,     0.000000808428584,     0.000000191651517,     0.000000053693658,     0.000000017356053,     0.000000006357088,
     0.000000002601307,     0.000000001175505,     0.000000000580875,     0.000000000311161,     0.000000000179253,     0.000000000110222,     0.000000000071829,     0.183953209889907,     0.003962800728279,     0.000256105172375,
     0.000027585647968,     0.000004159833102,     0.000000806514751,     0.000000191115448,     0.000000053520414,     0.000000017292612,     0.000000006331134,     0.000000002589581,     0.000000001169712,     0.000000000577772,
     0.000000000309374,     0.000000000178154,     0.000000000109506,     0.000000000071338,     0.183913594683288,     0.003960241055145,     0.000255829523753,     0.000027544089931,     0.000004151777501,     0.000000804606270,
     0.000000190581107,     0.000000053347804,     0.000000017229430,     0.000000006305296,     0.000000002577913,     0.000000001163950,     0.000000000574687,     0.000000000307598,     0.000000000177062,     0.000000000108795,
     0.000000000070851,     0.183874005059623,     0.003957684136420,     0.000255554290308,     0.000027502612355,     0.000004143740959,     0.000000802703123,     0.000000190048489,     0.000000053175825,     0.000000017166505,
     0.000000006279575,     0.000000002566302,     0.000000001158218,     0.000000000571620,     0.000000000305832,     0.000000000175978,     0.000000000108089,     0.000000000070367,     0.183834440991392,     0.003955129967958,
     0.000255279471238,     0.000027461215049,     0.000004135723421,     0.000000800805294,     0.000000189517588,     0.000000053004473,     0.000000017103838,     0.000000006253970,     0.000000002554748,     0.000000001152517,
     0.000000000568571,     0.000000000304078,     0.000000000174901,     0.000000000107388,     0.000000000069886,     0.183794902451110,     0.003952578545617,     0.000255005065740,     0.000027419897823,     0.000004127724835,
     0.000000798912766,     0.000000188988398,     0.000000052833747,     0.000000017041426,     0.000000006228480,     0.000000002543252,     0.000000001146847,     0.000000000565539,     0.000000000302334,     0.000000000173830,
     0.000000000106692,     0.000000000069409,     0.183755389411339,     0.003950029865267,     0.000254731073015,     0.000027378660489,     0.000004119745148,     0.000000797025520,     0.000000188460911,     0.000000052663644,
     0.000000016979268,     0.000000006203105,     0.000000002531811,     0.000000001141206,     0.000000000562524,     0.000000000300601,     0.000000000172767,     0.000000000106000,     0.000000000068935,     0.183715901844679,
     0.003947483922783,     0.000254457492265,     0.000027337502857,     0.000004111784307,     0.000000795143542,     0.000000187935123,     0.000000052494161,     0.000000016917363,     0.000000006177843,     0.000000002520427,
     0.000000001135596,     0.000000000559527,     0.000000000298879,     0.000000000171710,     0.000000000105313,     0.000000000068465,     0.183676439723771,     0.003944940714051,     0.000254184322693,     0.000027296424740,
     0.000004103842260,     0.000000793266812,     0.000000187411026,     0.000000052325296,     0.000000016855711,     0.000000006152696,     0.000000002509099,     0.000000001130016,     0.000000000556546,     0.000000000297167,
     0.000000000170661,     0.000000000104631,     0.000000000067998,     0.183637003021299,     0.003942400234962,     0.000253911563506,     0.000027255425950,     0.000004095918954,     0.000000791395316,     0.000000186888615,
     0.000000052157046,     0.000000016794309,     0.000000006127661,     0.000000002497827,     0.000000001124465,     0.000000000553583,     0.000000000295466,     0.000000000169618,     0.000000000103953,     0.000000000067534,
     0.183597591709987,     0.003939862481416,     0.000253639213910,     0.000027214506299,     0.000004088014336,     0.000000789529034,     0.000000186367883,     0.000000051989409,     0.000000016733157,     0.000000006102739,
     0.000000002486610,     0.000000001118944,     0.000000000550637,     0.000000000293775,     0.000000000168581,     0.000000000103280,     0.000000000067074,     0.183558205762599,     0.003937327449321,     0.000253367273117,
     0.000027173665601,     0.000004080128356,     0.000000787667952,     0.000000185848825,     0.000000051822382,     0.000000016672254,     0.000000006077929,     0.000000002475448,     0.000000001113452,     0.000000000547708,
     0.000000000292094,     0.000000000167552,     0.000000000102611,     0.000000000066617,     0.183518845151942,     0.003934795134593,     0.000253095740336,     0.000027132903670,     0.000004072260960,     0.000000785812052,
     0.000000185331434,     0.000000051655963,     0.000000016611598,     0.000000006053230,     0.000000002464341,     0.000000001107990,     0.000000000544795,     0.000000000290424,     0.000000000166529,     0.000000000101948,
     0.000000000066163,     0.183479509850863,     0.003932265533157,     0.000252824614781,     0.000027092220320,     0.000004064412097,     0.000000783961318,     0.000000184815703,     0.000000051490149,     0.000000016551189,
     0.000000006028642,     0.000000002453288,     0.000000001102556,     0.000000000541899,     0.000000000288764,     0.000000000165513,     0.000000000101288,     0.000000000065713,     0.183440199832249,     0.003929738640943,
     0.000252553895668,     0.000027051615366,     0.000004056581716,     0.000000782115733,     0.000000184301629,     0.000000051324939,     0.000000016491025,     0.000000006004164,     0.000000002442290,     0.000000001097152,
     0.000000000539020,     0.000000000287113,     0.000000000164503,     0.000000000100633,     0.000000000065265,     0.183400915069027,     0.003927214453891,     0.000252283582213,     0.000027011088624,     0.000004048769766,
     0.000000780275280,     0.000000183789203,     0.000000051160328,     0.000000016431105,     0.000000005979796,     0.000000002431345,     0.000000001091776,     0.000000000536157,     0.000000000285473,     0.000000000163500,
     0.000000000099983,     0.000000000064821,     0.183361655534167,     0.003924692967949,     0.000252013673636,     0.000026970639910,     0.000004040976194,     0.000000778439943,     0.000000183278420,     0.000000050996316,
     0.000000016371428,     0.000000005955537,     0.000000002420454,     0.000000001086428,     0.000000000533310,     0.000000000283843,     0.000000000162504,     0.000000000099337,     0.000000000064380,     0.183322421200678,
     0.003922174179071,     0.000251744169156,     0.000026930269039,     0.000004033200950,     0.000000776609706,     0.000000182769274,     0.000000050832899,     0.000000016311994,     0.000000005931387,     0.000000002409616,
     0.000000001081110,     0.000000000530480,     0.000000000282223,     0.000000000161514,     0.000000000098695,     0.000000000063942,     0.183283212041609,     0.003919658083221,     0.000251475067996,     0.000026889975830,
     0.000004025443983,     0.000000774784552,     0.000000182261760,     0.000000050670075,     0.000000016252800,     0.000000005907345,     0.000000002398832,     0.000000001075819,     0.000000000527666,     0.000000000280613,
     0.000000000160530,     0.000000000098058,     0.000000000063508,     0.183244028030050,     0.003917144676370,     0.000251206369381,     0.000026849760099,     0.000004017705242,     0.000000772964466,     0.000000181755871,
     0.000000050507842,     0.000000016193847,     0.000000005883410,     0.000000002388100,     0.000000001070556,     0.000000000524868,     0.000000000279013,     0.000000000159552,     0.000000000097425,     0.000000000063076,
     0.183204869139132,     0.003914633954495,     0.000250938072536,     0.000026809621664,     0.000004009984677,     0.000000771149430,     0.000000181251601,     0.000000050346197,     0.000000016135132,     0.000000005859582,
     0.000000002377420,     0.000000001065321,     0.000000000522086,     0.000000000277422,     0.000000000158581,     0.000000000096796,     0.000000000062647,     0.183165735342023,     0.003912125913582,     0.000250670176690,
     0.000026769560345,     0.000004002282236,     0.000000769339428,     0.000000180748945,     0.000000050185138,     0.000000016076655,     0.000000005835861,     0.000000002366793,     0.000000001060114,     0.000000000519319,
     0.000000000275841,     0.000000000157617,     0.000000000096172,     0.000000000062222,     0.183126626611937,     0.003909620549627,     0.000250402681073,     0.000026729575959,     0.000003994597871,     0.000000767534445,
     0.000000180247897,     0.000000050024663,     0.000000016018414,     0.000000005812246,     0.000000002356218,     0.000000001054935,     0.000000000516569,     0.000000000274270,     0.000000000156658,     0.000000000095552,
     0.000000000061799,     0.183087542922121,     0.003907117858629,     0.000250135584915,     0.000026689668327,     0.000003986931531,     0.000000765734465,     0.000000179748450,     0.000000049864769,     0.000000015960409,
     0.000000005788737,     0.000000002345695,     0.000000001049783,     0.000000000513834,     0.000000000272708,     0.000000000155705,     0.000000000094936,     0.000000000061380,     0.183048484245868,     0.003904617836599,
     0.000249868887451,     0.000026649837269,     0.000003979283165,     0.000000763939471,     0.000000179250599,     0.000000049705454,     0.000000015902639,     0.000000005765332,     0.000000002335222,     0.000000001044658,
     0.000000000511115,     0.000000000271156,     0.000000000154759,     0.000000000094324,     0.000000000060963,     0.183009450556506,     0.003902120479554,     0.000249602587915,     0.000026610082604,     0.000003971652725,
     0.000000762149448,     0.000000178754339,     0.000000049546716,     0.000000015845102,     0.000000005742032,     0.000000002324801,     0.000000001039561,     0.000000000508411,     0.000000000269613,     0.000000000153819,
     0.000000000093717,     0.000000000060550,     0.182970441827406,     0.003899625783517,     0.000249336685545,     0.000026570404155,     0.000003964040160,     0.000000760364379,     0.000000178259663,     0.000000049388552,
     0.000000015787798,     0.000000005718836,     0.000000002314431,     0.000000001034490,     0.000000000505722,     0.000000000268079,     0.000000000152885,     0.000000000093113,     0.000000000060139,     0.182931458031979,
     0.003897133744522,     0.000249071179579,     0.000026530801742,     0.000003956445421,     0.000000758584249,     0.000000177766566,     0.000000049230959,     0.000000015730725,     0.000000005695743,     0.000000002304111,
     0.000000001029446,     0.000000000503049,     0.000000000266555,     0.000000000151957,     0.000000000092514,     0.000000000059732,     0.182892499143672,     0.003894644358607,     0.000248806069257,     0.000026491275187,
     0.000003948868458,     0.000000756809042,     0.000000177275042,     0.000000049073936,     0.000000015673883,     0.000000005672754,     0.000000002293842,     0.000000001024429,     0.000000000500391,     0.000000000265040,
     0.000000000151035,     0.000000000091919,     0.000000000059327,     0.182853565135976,     0.003892157621820,     0.000248541353823,     0.000026451824313,     0.000003941309224,     0.000000755038743,     0.000000176785085,
     0.000000048917481,     0.000000015617270,     0.000000005649866,     0.000000002283623,     0.000000001019438,     0.000000000497748,     0.000000000263534,     0.000000000150118,     0.000000000091327,     0.000000000058925,
     0.182814655982419,     0.003889673530217,     0.000248277032519,     0.000026412448944,     0.000003933767667,     0.000000753273335,     0.000000176296690,     0.000000048761590,     0.000000015560885,     0.000000005627081,
     0.000000002273453,     0.000000001014474,     0.000000000495120,     0.000000000262038,     0.000000000149208,     0.000000000090740,     0.000000000058526,     0.182775771656568,     0.003887192079858,     0.000248013104593,
     0.000026373148901,     0.000003926243741,     0.000000751512804,     0.000000175809852,     0.000000048606262,     0.000000015504728,     0.000000005604397,     0.000000002263333,     0.000000001009536,     0.000000000492507,
     0.000000000260550,     0.000000000148303,     0.000000000090157,     0.000000000058129,     0.182736912132031,     0.003884713266816,     0.000247749569291,     0.000026333924010,     0.000003918737395,     0.000000749757133,
     0.000000175324563,     0.000000048451495,     0.000000015448797,     0.000000005581814,     0.000000002253262,     0.000000001004624,     0.000000000489909,     0.000000000259072,     0.000000000147405,     0.000000000089578,
     0.000000000057736,     0.182698077382454,     0.003882237087166,     0.000247486425863,     0.000026294774095,     0.000003911248582,     0.000000748006308,     0.000000174840820,     0.000000048297286,     0.000000015393091,
     0.000000005559332,     0.000000002243241,     0.000000000999738,     0.000000000487326,     0.000000000257602,     0.000000000146512,     0.000000000089002,     0.000000000057345,     0.182659267381522,     0.003879763536995,
     0.000247223673560,     0.000026255698980,     0.000003903777253,     0.000000746260312,     0.000000174358616,     0.000000048143632,     0.000000015337610,     0.000000005536949,     0.000000002233268,     0.000000000994877,
     0.000000000484757,     0.000000000256141,     0.000000000145625,     0.000000000088431,     0.000000000056957,     0.182620482102962,     0.003877292612394,     0.000246961311634,     0.000026216698492,     0.000003896323360,
     0.000000744519130,     0.000000173877945,     0.000000047990533,     0.000000015282352,     0.000000005514666,     0.000000002223343,     0.000000000990042,     0.000000000482203,     0.000000000254689,     0.000000000144743,
     0.000000000087863,     0.000000000056572,     0.182581721520535,     0.003874824309463,     0.000246699339342,     0.000026177772455,     0.000003888886854,     0.000000742782748,     0.000000173398803,     0.000000047837984,
     0.000000015227316,     0.000000005492482,     0.000000002213467,     0.000000000985233,     0.000000000479663,     0.000000000253246,     0.000000000143867,     0.000000000087299,     0.000000000056190,     0.182542985608046,
     0.003872358624311,     0.000246437755938,     0.000026138920697,     0.000003881467689,     0.000000741051149,     0.000000172921184,     0.000000047685985,     0.000000015172502,     0.000000005470397,     0.000000002203638,
     0.000000000980449,     0.000000000477138,     0.000000000251812,     0.000000000142997,     0.000000000086739,     0.000000000055810,     0.182504274339336,     0.003869895553051,     0.000246176560681,     0.000026100143044,
     0.000003874065815,     0.000000739324319,     0.000000172445082,     0.000000047534534,     0.000000015117908,     0.000000005448409,     0.000000002193858,     0.000000000975690,     0.000000000474627,     0.000000000250386,
     0.000000000142133,     0.000000000086183,     0.000000000055433,     0.182465587688285,     0.003867435091806,     0.000245915752830,     0.000026061439323,     0.000003866681186,     0.000000737602242,     0.000000171970491,
     0.000000047383627,     0.000000015063534,     0.000000005426519,     0.000000002184124,     0.000000000970956,     0.000000000472130,     0.000000000248969,     0.000000000141274,     0.000000000085631,     0.000000000055059,
     0.182426925628813,     0.003864977236705,     0.000245655331648,     0.000026022809363,     0.000003859313755,     0.000000735884904,     0.000000171497407,     0.000000047233262,     0.000000015009377,     0.000000005404727,
     0.000000002174438,     0.000000000966248,     0.000000000469648,     0.000000000247561,     0.000000000140420,     0.000000000085082,     0.000000000054687,     0.182388288134877,     0.003862521983886,     0.000245395296398,
     0.000025984252991,     0.000003851963473,     0.000000734172289,     0.000000171025824,     0.000000047083438,     0.000000014955439,     0.000000005383031,     0.000000002164799,     0.000000000961563,     0.000000000467179,
     0.000000000246161,     0.000000000139572,     0.000000000084537,     0.000000000054318,     0.182349675180474,     0.003860069329493,     0.000245135646344,     0.000025945770036,     0.000003844630293,     0.000000732464383,
     0.000000170555737,     0.000000046934153,     0.000000014901717,     0.000000005361431,     0.000000002155207,     0.000000000956904,     0.000000000464725,     0.000000000244769,     0.000000000138729,     0.000000000083995,
     0.000000000053951,     0.182311086739639,     0.003857619269678,     0.000244876380753,     0.000025907360328,     0.000003837314169,     0.000000730761169,     0.000000170087139,     0.000000046785403,     0.000000014848210,
     0.000000005339926,     0.000000002145661,     0.000000000952269,     0.000000000462284,     0.000000000243386,     0.000000000137892,     0.000000000083458,     0.000000000053587,     0.182272522786444,     0.003855171800599,
     0.000244617498894,     0.000025869023696,     0.000003830015054,     0.000000729062635,     0.000000169620027,     0.000000046637188,     0.000000014794918,     0.000000005318517,     0.000000002136161,     0.000000000947658,
     0.000000000459857,     0.000000000242012,     0.000000000137060,     0.000000000082924,     0.000000000053226,     0.182233983295004,     0.003852726918424,     0.000244359000036,     0.000025830759971,     0.000003822732901,
     0.000000727368764,     0.000000169154394,     0.000000046489504,     0.000000014741839,     0.000000005297203,     0.000000002126708,     0.000000000943072,     0.000000000457444,     0.000000000240645,     0.000000000136234,
     0.000000000082393,     0.000000000052867,     0.182195468239466,     0.003850284619324,     0.000244100883452,     0.000025792568982,     0.000003815467663,     0.000000725679542,     0.000000168690235,     0.000000046342350,
     0.000000014688973,     0.000000005275983,     0.000000002117300,     0.000000000938509,     0.000000000455044,     0.000000000239287,     0.000000000135412,     0.000000000081866,     0.000000000052511,     0.182156977594020,
     0.003847844899483,     0.000243843148414,     0.000025754450561,     0.000003808219295,     0.000000723994954,     0.000000168227545,     0.000000046195724,     0.000000014636319,     0.000000005254857,     0.000000002107938,
     0.000000000933971,     0.000000000452658,     0.000000000237937,     0.000000000134596,     0.000000000081343,     0.000000000052157,     0.182118511332891,     0.003845407755087,     0.000243585794199,     0.000025716404540,
     0.000003800987749,     0.000000722314986,     0.000000167766319,     0.000000046049623,     0.000000014583876,     0.000000005233824,     0.000000002098620,     0.000000000929456,     0.000000000450285,     0.000000000236595,
     0.000000000133785,     0.000000000080823,     0.000000000051806,     0.182080069430346,     0.003842973182332,     0.000243328820083,     0.000025678430750,     0.000003793772980,     0.000000720639623,     0.000000167306551,
     0.000000045904046,     0.000000014531642,     0.000000005212884,     0.000000002089348,     0.000000000924965,     0.000000000447926,     0.000000000235261,     0.000000000132980,     0.000000000080307,     0.000000000051457,
     0.182041651860685,     0.003840541177420,     0.000243072225344,     0.000025640529024,     0.000003786574941,     0.000000718968850,     0.000000166848236,     0.000000045758990,     0.000000014479618,     0.000000005192037,
     0.000000002080121,     0.000000000920498,     0.000000000445580,     0.000000000233935,     0.000000000132179,     0.000000000079794,     0.000000000051111,     0.182003258598250,     0.003838111736563,     0.000242816009263,
     0.000025602699196,     0.000003779393587,     0.000000717302654,     0.000000166391369,     0.000000045614453,     0.000000014427801,     0.000000005171282,     0.000000002070938,     0.000000000916053,     0.000000000443247,
     0.000000000232618,     0.000000000131384,     0.000000000079285,     0.000000000050767,     0.181964889617420,     0.003835684855975,     0.000242560171121,     0.000025564941097,     0.000003772228873,     0.000000715641018,
     0.000000165935945,     0.000000045470433,     0.000000014376192,     0.000000005150618,     0.000000002061800,     0.000000000911633,     0.000000000440927,     0.000000000231308,     0.000000000130594,     0.000000000078779,
     0.000000000050426,     0.181926544892609,     0.003833260531883,     0.000242304710202,     0.000025527254563,     0.000003765080752,     0.000000713983930,     0.000000165481959,     0.000000045326928,     0.000000014324789,
     0.000000005130045,     0.000000002052706,     0.000000000907235,     0.000000000438621,     0.000000000230006,     0.000000000129808,     0.000000000078276,     0.000000000050087,     0.181888224398273,     0.003830838760516,
     0.000242049625792,     0.000025489639427,     0.000003757949179,     0.000000712331374,     0.000000165029405,     0.000000045183937,     0.000000014273591,     0.000000005109564,     0.000000002043655,     0.000000000902860,
     0.000000000436327,     0.000000000228712,     0.000000000129028,     0.000000000077777,     0.000000000049750,     0.181849928108902,     0.003828419538114,     0.000241794917176,     0.000025452095524,     0.000003750834109,
     0.000000710683337,     0.000000164578279,     0.000000045041456,     0.000000014222597,     0.000000005089172,     0.000000002034648,     0.000000000898508,     0.000000000434047,     0.000000000227425,     0.000000000128253,
     0.000000000077281,     0.000000000049416,     0.181811655999027,     0.003826002860922,     0.000241540583644,     0.000025414622690,     0.000003743735497,     0.000000709039804,     0.000000164128574,     0.000000044899484,
     0.000000014171807,     0.000000005068871,     0.000000002025685,     0.000000000894179,     0.000000000431779,     0.000000000226146,     0.000000000127482,     0.000000000076789,     0.000000000049084,     0.181773408043212,
     0.003823588725193,     0.000241286624486,     0.000025377220760,     0.000003736653298,     0.000000707400761,     0.000000163680287,     0.000000044758019,     0.000000014121219,     0.000000005048658,     0.000000002016765,
     0.000000000889873,     0.000000000429524,     0.000000000224875,     0.000000000126717,     0.000000000076299,     0.000000000048754,     0.181735184216064,     0.003821177127187,     0.000241033038993,     0.000025339889569,
     0.000003729587467,     0.000000705766194,     0.000000163233412,     0.000000044617059,     0.000000014070834,     0.000000005028535,     0.000000002007887,     0.000000000885589,     0.000000000427281,     0.000000000223612,
     0.000000000125956,     0.000000000075814,     0.000000000048427,     0.181696984492222,     0.003818768063170,     0.000240779826459,     0.000025302628956,     0.000003722537960,     0.000000704136088,     0.000000162787944,
     0.000000044476602,     0.000000014020648,     0.000000005008500,     0.000000001999053,     0.000000000881327,     0.000000000425051,     0.000000000222356,     0.000000000125201,     0.000000000075331,     0.000000000048102,
     0.181658808846366,     0.003816361529417,     0.000240526986179,     0.000025265438756,     0.000003715504731,     0.000000702510430,     0.000000162343879,     0.000000044336645,     0.000000013970663,     0.000000004988554,
     0.000000001990261,     0.000000000877088,     0.000000000422834,     0.000000000221108,     0.000000000124450,     0.000000000074852,     0.000000000047779,     0.181620657253212,     0.003813957522208,     0.000240274517450,
     0.000025228318807,     0.000003708487736,     0.000000700889206,     0.000000161901210,     0.000000044197188,     0.000000013920877,     0.000000004968695,     0.000000001981511,     0.000000000872870,     0.000000000420629,
     0.000000000219867,     0.000000000123704,     0.000000000074375,     0.000000000047459,     0.181582529687513,     0.003811556037832,     0.000240022419570,     0.000025191268947,     0.000003701486932,     0.000000699272401,
     0.000000161459933,     0.000000044058227,     0.000000013871289,     0.000000004948924,     0.000000001972803,     0.000000000868675,     0.000000000418437,     0.000000000218634,     0.000000000122962,     0.000000000073902,
     0.000000000047141,     0.181544426124058,     0.003809157072583,     0.000239770691838,     0.000025154289015,     0.000003694502274,     0.000000697660002,     0.000000161020044,     0.000000043919761,     0.000000013821898,
     0.000000004929239,     0.000000001964137,     0.000000000864501,     0.000000000416257,     0.000000000217408,     0.000000000122226,     0.000000000073433,     0.000000000046825,     0.181506346537676,     0.003806760622764,
     0.000239519333557,     0.000025117378848,     0.000003687533717,     0.000000696051996,     0.000000160581536,     0.000000043781788,     0.000000013772704,     0.000000004909641,     0.000000001955513,     0.000000000860350,
     0.000000000414089,     0.000000000216189,     0.000000000121494,     0.000000000072966,     0.000000000046511,     0.181468290903230,     0.003804366684683,     0.000239268344029,     0.000025080538287,     0.000003680581219,
     0.000000694448367,     0.000000160144406,     0.000000043644307,     0.000000013723705,     0.000000004890128,     0.000000001946930,     0.000000000856220,     0.000000000411933,     0.000000000214978,     0.000000000120766,
     0.000000000072502,     0.000000000046199,     0.181430259195622,     0.003801975254656,     0.000239017722560,     0.000025043767170,     0.000003673644735,     0.000000692849103,     0.000000159708649,     0.000000043507314,
     0.000000013674901,     0.000000004870702,     0.000000001938389,     0.000000000852111,     0.000000000409789,     0.000000000213774,     0.000000000120044,     0.000000000072042,     0.000000000045890,     0.181392251389789,
     0.003799586329007,     0.000238767468455,     0.000025007065339,     0.000003666724222,     0.000000691254190,     0.000000159274258,     0.000000043370808,     0.000000013626291,     0.000000004851361,     0.000000001929888,
     0.000000000848024,     0.000000000407657,     0.000000000212577,     0.000000000119325,     0.000000000071584,     0.000000000045583,     0.181354267460706,     0.003797199904065,     0.000238517581022,     0.000024970432633,
     0.000003659819637,     0.000000689663613,     0.000000158841231,     0.000000043234787,     0.000000013577874,     0.000000004832104,     0.000000001921428,     0.000000000843958,     0.000000000405537,     0.000000000211388,
     0.000000000118612,     0.000000000071130,     0.000000000045278,     0.181316307383385,     0.003794815976167,     0.000238268059572,     0.000024933868893,     0.000003652930936,     0.000000688077360,     0.000000158409561,
     0.000000043099250,     0.000000013529648,     0.000000004812932,     0.000000001913009,     0.000000000839913,     0.000000000403429,     0.000000000210205,     0.000000000117903,     0.000000000070679,     0.000000000044975,
     0.181278371132872,     0.003792434541656,     0.000238018903415,     0.000024897373961,     0.000003646058075,     0.000000686495418,     0.000000157979244,     0.000000042964194,     0.000000013481615,     0.000000004793844,
     0.000000001904630,     0.000000000835889,     0.000000000401333,     0.000000000209030,     0.000000000117198,     0.000000000070231,     0.000000000044674,     0.181240458684252,     0.003790055596883,     0.000237770111864,
     0.000024860947679,     0.000003639201013,     0.000000684917771,     0.000000157550276,     0.000000042829617,     0.000000013433771,     0.000000004774839,     0.000000001896291,     0.000000000831886,     0.000000000399249,
     0.000000000207861,     0.000000000116498,     0.000000000069785,     0.000000000044376,     0.181202570012647,     0.003787679138206,     0.000237521684233,     0.000024824589889,     0.000003632359706,     0.000000683344408,
     0.000000157122650,     0.000000042695518,     0.000000013386118,     0.000000004755918,     0.000000001887992,     0.000000000827904,     0.000000000397176,     0.000000000206700,     0.000000000115803,     0.000000000069343,
     0.000000000044079,     0.181164705093213,     0.003785305161988,     0.000237273619839,     0.000024788300433,     0.000003625534111,     0.000000681775314,     0.000000156696364,     0.000000042561894,     0.000000013338653,
     0.000000004737079,     0.000000001879733,     0.000000000823943,     0.000000000395115,     0.000000000205545,     0.000000000115111,     0.000000000068904,     0.000000000043785,     0.181126863901145,     0.003782933664600,
     0.000237025917997,     0.000024752079154,     0.000003618724185,     0.000000680210476,     0.000000156271411,     0.000000042428744,     0.000000013291376,     0.000000004718323,     0.000000001871513,     0.000000000820002,
     0.000000000393065,     0.000000000204397,     0.000000000114424,     0.000000000068467,     0.000000000043492,     0.181089046411671,     0.003780564642421,     0.000236778578029,     0.000024715925897,     0.000003611929887,
     0.000000678649881,     0.000000155847787,     0.000000042296066,     0.000000013244286,     0.000000004699649,     0.000000001863333,     0.000000000816081,     0.000000000391027,     0.000000000203256,     0.000000000113742,
     0.000000000068034,     0.000000000043202,     0.181051252600058,     0.003778198091836,     0.000236531599253,     0.000024679840504,     0.000003605151174,     0.000000677093516,     0.000000155425488,     0.000000042163857,
     0.000000013197383,     0.000000004681056,     0.000000001855191,     0.000000000812181,     0.000000000389000,     0.000000000202122,     0.000000000113064,     0.000000000067603,     0.000000000042913,     0.181013482441608,
     0.003775834009235,     0.000236284980993,     0.000024643822822,     0.000003598388003,     0.000000675541367,     0.000000155004508,     0.000000042032117,     0.000000013150665,     0.000000004662545,     0.000000001847089,
     0.000000000808301,     0.000000000386984,     0.000000000200995,     0.000000000112390,     0.000000000067176,     0.000000000042627,     0.180975735911658,     0.003773472391016,     0.000236038722572,     0.000024607872693,
     0.000003591640332,     0.000000673993421,     0.000000154584844,     0.000000041900844,     0.000000013104131,     0.000000004644114,     0.000000001839025,     0.000000000804442,     0.000000000384980,     0.000000000199875,
     0.000000000111720,     0.000000000066751,     0.000000000042343,     0.180938012985584,     0.003771113233586,     0.000235792823314,     0.000024571989963,     0.000003584908120,     0.000000672449666,     0.000000154166490,
     0.000000041770034,     0.000000013057782,     0.000000004625764,     0.000000001831000,     0.000000000800602,     0.000000000382987,     0.000000000198761,     0.000000000111055,     0.000000000066329,     0.000000000042061,
     0.180900313638796,     0.003768756533355,     0.000235547282548,     0.000024536174479,     0.000003578191325,     0.000000670910087,     0.000000153749442,     0.000000041639687,     0.000000013011616,     0.000000004607494,
     0.000000001823013,     0.000000000796782,     0.000000000381005,     0.000000000197654,     0.000000000110394,     0.000000000065910,     0.000000000041780,     0.180862637846739,     0.003766402286742,     0.000235302099601,
     0.000024500426086,     0.000003571489905,     0.000000669374672,     0.000000153333695,     0.000000041509801,     0.000000012965632,     0.000000004589304,     0.000000001815064,     0.000000000792982,     0.000000000379034,
     0.000000000196553,     0.000000000109737,     0.000000000065493,     0.000000000041502,     0.180824985584894,     0.003764050490173,     0.000235057273803,     0.000024464744630,     0.000003564803818,     0.000000667843409,
     0.000000152919244,     0.000000041380374,     0.000000012919829,     0.000000004571193,     0.000000001807154,     0.000000000789201,     0.000000000377074,     0.000000000195459,     0.000000000109084,     0.000000000065080,
     0.000000000041225,     0.180787356828780,     0.003761701140078,     0.000234812804486,     0.000024429129958,     0.000003558133023,     0.000000666316283,     0.000000152506086,     0.000000041251404,     0.000000012874208,
     0.000000004553161,     0.000000001799280,     0.000000000785440,     0.000000000375125,     0.000000000194371,     0.000000000108435,     0.000000000064669,     0.000000000040951,     0.180749751553950,     0.003759354232897,
     0.000234568690982,     0.000024393581918,     0.000003551477478,     0.000000664793283,     0.000000152094215,     0.000000041122889,     0.000000012828766,     0.000000004535207,     0.000000001791445,     0.000000000781699,
     0.000000000373186,     0.000000000193290,     0.000000000107790,     0.000000000064261,     0.000000000040678,     0.180712169735991,     0.003757009765074,     0.000234324932626,     0.000024358100358,     0.000003544837143,
     0.000000663274395,     0.000000151683626,     0.000000040994828,     0.000000012783503,     0.000000004517332,     0.000000001783646,     0.000000000777976,     0.000000000371259,     0.000000000192215,     0.000000000107150,
     0.000000000063855,     0.000000000040407,     0.180674611350529,     0.003754667733063,     0.000234081528754,     0.000024322685125,     0.000003538211977,     0.000000661759606,     0.000000151274317,     0.000000040867219,
     0.000000012738419,     0.000000004499534,     0.000000001775885,     0.000000000774273,     0.000000000369342,     0.000000000191147,     0.000000000106513,     0.000000000063452,     0.000000000040139,     0.180637076373222,
     0.003752328133320,     0.000233838478703,     0.000024287336068,     0.000003531601938,     0.000000660248904,     0.000000150866281,     0.000000040740059,     0.000000012693512,     0.000000004481814,     0.000000001768161,
     0.000000000770589,     0.000000000367436,     0.000000000190085,     0.000000000105881,     0.000000000063052,     0.000000000039872,     0.180599564779767,     0.003749990962311,     0.000233595781812,     0.000024252053036,
     0.000003525006985,     0.000000658742276,     0.000000150459514,     0.000000040613348,     0.000000012648783,     0.000000004464171,     0.000000001760473,     0.000000000766925,     0.000000000365540,     0.000000000189029,
     0.000000000105252,     0.000000000062655,     0.000000000039607,     0.180562076545892,     0.003747656216509,     0.000233353437423,     0.000024216835878,     0.000003518427079,     0.000000657239710,     0.000000150054012,
     0.000000040487083,     0.000000012604229,     0.000000004446604,     0.000000001752822,     0.000000000763279,     0.000000000363655,     0.000000000187980,     0.000000000104628,     0.000000000062260,     0.000000000039343,
     0.180524611647364,     0.003745323892390,     0.000233111444876,     0.000024181684444,     0.000003511862177,     0.000000655741192,     0.000000149649771,     0.000000040361263,     0.000000012559850,     0.000000004429114,
     0.000000001745208,     0.000000000759651,     0.000000000361781,     0.000000000186937,     0.000000000104007,     0.000000000061868,     0.000000000039082,     0.180487170059984,     0.003742993986441,     0.000232869803515,
     0.000024146598585,     0.000003505312241,     0.000000654246710,     0.000000149246785,     0.000000040235885,     0.000000012515646,     0.000000004411700,     0.000000001737629,     0.000000000756043,     0.000000000359916,
     0.000000000185900,     0.000000000103390,     0.000000000061479,     0.000000000038822,     0.180449751759586,     0.003740666495151,     0.000232628512686,     0.000024111578150,     0.000003498777230,     0.000000652756252,
     0.000000148845052,     0.000000040110949,     0.000000012471616,     0.000000004394361,     0.000000001730087,     0.000000000752453,     0.000000000358063,     0.000000000184869,     0.000000000102777,     0.000000000061092,
     0.000000000038565,     0.180412356722043,     0.003738341415021,     0.000232387571735,     0.000024076622991,     0.000003492257103,     0.000000651269805,     0.000000148444565,     0.000000039986452,     0.000000012427759,
     0.000000004377098,     0.000000001722580,     0.000000000748882,     0.000000000356219,     0.000000000183844,     0.000000000102168,     0.000000000060707,     0.000000000038309,     0.180374984923260,     0.003736018742553,
     0.000232146980009,     0.000024041732958,     0.000003485751820,     0.000000649787356,     0.000000148045321,     0.000000039862393,     0.000000012384074,     0.000000004359910,     0.000000001715109,     0.000000000745329,
     0.000000000354386,     0.000000000182826,     0.000000000101563,     0.000000000060325,     0.000000000038054,     0.180337636339179,     0.003733698474258,     0.000231906736859,     0.000024006907905,     0.000003479261342,
     0.000000648308894,     0.000000147647316,     0.000000039738770,     0.000000012340560,     0.000000004342796,     0.000000001707673,     0.000000000741794,     0.000000000352562,     0.000000000181813,     0.000000000100962,
     0.000000000059946,     0.000000000037802,     0.180300310945773,     0.003731380606656,     0.000231666841635,     0.000023972147682,     0.000003472785629,     0.000000646834406,     0.000000147250544,     0.000000039615582,
     0.000000012297218,     0.000000004325756,     0.000000001700273,     0.000000000738277,     0.000000000350749,     0.000000000180806,     0.000000000100364,     0.000000000059569,     0.000000000037551,     0.180263008719055,
     0.003729065136268,     0.000231427293690,     0.000023937452143,     0.000003466324641,     0.000000645363879,     0.000000146855003,     0.000000039492825,     0.000000012254045,     0.000000004308790,     0.000000001692908,
     0.000000000734779,     0.000000000348946,     0.000000000179806,     0.000000000099770,     0.000000000059195,     0.000000000037302,     0.180225729635068,     0.003726752059626,     0.000231188092377,     0.000023902821140,
     0.000003459878339,     0.000000643897302,     0.000000146460686,     0.000000039370500,     0.000000012211042,     0.000000004291898,     0.000000001685577,     0.000000000731298,     0.000000000347153,     0.000000000178811,
     0.000000000099180,     0.000000000058823,     0.000000000037055,     0.180188473669894,     0.003724441373267,     0.000230949237052,     0.000023868254528,     0.000003453446682,     0.000000642434661,     0.000000146067591,
     0.000000039248604,     0.000000012168207,     0.000000004275078,     0.000000001678282,     0.000000000727836,     0.000000000345370,     0.000000000177822,     0.000000000098594,     0.000000000058454,     0.000000000036810,
     0.180151240799647,     0.003722133073734,     0.000230710727072,     0.000023833752158,     0.000003447029632,     0.000000640975946,     0.000000145675713,     0.000000039127135,     0.000000012125540,     0.000000004258332,
     0.000000001671021,     0.000000000724391,     0.000000000343597,     0.000000000176839,     0.000000000098011,     0.000000000058087,     0.000000000036566,     0.180114031000475,     0.003719827157577,     0.000230472561795,
     0.000023799313886,     0.000003440627150,     0.000000639521143,     0.000000145285047,     0.000000039006093,     0.000000012083040,     0.000000004241658,     0.000000001663794,     0.000000000720964,     0.000000000341833,
     0.000000000175862,     0.000000000097432,     0.000000000057723,     0.000000000036324,     0.180076844248562,     0.003717523621351,     0.000230234740581,     0.000023764939567,     0.000003434239196,     0.000000638070241,
     0.000000144895589,     0.000000038885474,     0.000000012040706,     0.000000004225056,     0.000000001656601,     0.000000000717554,     0.000000000340080,     0.000000000174890,     0.000000000096857,     0.000000000057361,
     0.000000000036084,     0.180039680520127,     0.003715222461621,     0.000229997262791,     0.000023730629054,     0.000003427865732,     0.000000636623227,     0.000000144507336,     0.000000038765278,     0.000000011998539,
     0.000000004208526,     0.000000001649443,     0.000000000714162,     0.000000000338335,     0.000000000173925,     0.000000000096285,     0.000000000057001,     0.000000000035845,     0.180002539791420,     0.003712923674953,
     0.000229760127788,     0.000023696382204,     0.000003421506719,     0.000000635180090,     0.000000144120283,     0.000000038645503,     0.000000011956536,     0.000000004192067,     0.000000001642318,     0.000000000710788,
     0.000000000336601,     0.000000000172965,     0.000000000095717,     0.000000000056644,     0.000000000035608,     0.179965422038729,     0.003710627257924,     0.000229523334936,     0.000023662198872,     0.000003415162118,
     0.000000633740818,     0.000000143734425,     0.000000038526147,     0.000000011914697,     0.000000004175679,     0.000000001635227,     0.000000000707430,     0.000000000334876,     0.000000000172010,     0.000000000095152,
     0.000000000056289,     0.000000000035372,     0.179928327238374,     0.003708333207116,     0.000229286883599,     0.000023628078914,     0.000003408831890,     0.000000632305398,     0.000000143349758,     0.000000038407208,
     0.000000011873022,     0.000000004159362,     0.000000001628169,     0.000000000704090,     0.000000000333161,     0.000000000171062,     0.000000000094591,     0.000000000055936,     0.000000000035138,     0.179891255366710,
     0.003706041519116,     0.000229050773146,     0.000023594022186,     0.000003402515997,     0.000000630873819,     0.000000142966279,     0.000000038288686,     0.000000011831509,     0.000000004143116,     0.000000001621145,
     0.000000000700767,     0.000000000331455,     0.000000000170119,     0.000000000094033,     0.000000000055586,     0.000000000034906,     0.179854206400127,     0.003703752190519,     0.000228815002945,     0.000023560028546,
     0.000003396214401,     0.000000629446068,     0.000000142583983,     0.000000038170578,     0.000000011790159,     0.000000004126939,     0.000000001614154,     0.000000000697461,     0.000000000329758,     0.000000000169181,
     0.000000000093479,     0.000000000055238,     0.000000000034676,     0.179817180315047,     0.003701465217925,     0.000228579572366,     0.000023526097851,     0.000003389927063,     0.000000628022135,     0.000000142202866,
     0.000000038052882,     0.000000011748970,     0.000000004110833,     0.000000001607196,     0.000000000694172,     0.000000000328071,     0.000000000168249,     0.000000000092929,     0.000000000054893,     0.000000000034447,
     0.179780177087926,     0.003699180597942,     0.000228344480779,     0.000023492229957,     0.000003383653945,     0.000000626602007,     0.000000141822924,     0.000000037935598,     0.000000011707942,     0.000000004094795,
     0.000000001600270,     0.000000000690899,     0.000000000326393,     0.000000000167322,     0.000000000092381,     0.000000000054549,     0.000000000034219,     0.179743196695257,     0.003696898327182,     0.000228109727558,
     0.000023458424724,     0.000003377395010,     0.000000625185673,     0.000000141444153,     0.000000037818723,     0.000000011667074,     0.000000004078827,     0.000000001593378,     0.000000000687644,     0.000000000324725,
     0.000000000166401,     0.000000000091838,     0.000000000054208,     0.000000000033994,     0.179706239113563,     0.003694618402265,     0.000227875312076,     0.000023424682010,     0.000003371150219,     0.000000623773120,
     0.000000141066548,     0.000000037702256,     0.000000011626366,     0.000000004062928,     0.000000001586518,     0.000000000684405,     0.000000000323065,     0.000000000165486,     0.000000000091297,     0.000000000053869,
     0.000000000033769,     0.179669304319404,     0.003692340819816,     0.000227641233710,     0.000023391001673,     0.000003364919535,     0.000000622364338,     0.000000140690106,     0.000000037586195,     0.000000011585816,
     0.000000004047097,     0.000000001579690,     0.000000000681183,     0.000000000321415,     0.000000000164575,     0.000000000090760,     0.000000000053533,     0.000000000033547,     0.179632392289370,     0.003690065576469,
     0.000227407491835,     0.000023357383572,     0.000003358702920,     0.000000620959314,     0.000000140314823,     0.000000037470539,     0.000000011545423,     0.000000004031334,     0.000000001572894,     0.000000000677977,
     0.000000000319774,     0.000000000163670,     0.000000000090227,     0.000000000053198,     0.000000000033325,     0.179595503000088,     0.003687792668860,     0.000227174085831,     0.000023323827568,     0.000003352500336,
     0.000000619558037,     0.000000139940694,     0.000000037355286,     0.000000011505189,     0.000000004015639,     0.000000001566130,     0.000000000674787,     0.000000000318142,     0.000000000162771,     0.000000000089696,
     0.000000000052866,     0.000000000033106,     0.179558636428218,     0.003685522093635,     0.000226941015077,     0.000023290333519,     0.000003346311747,     0.000000618160496,     0.000000139567716,     0.000000037240435,
     0.000000011465110,     0.000000004000011,     0.000000001559398,     0.000000000671614,     0.000000000316518,     0.000000000161876,     0.000000000089169,     0.000000000052536,     0.000000000032888,     0.179521792550452,
     0.003683253847443,     0.000226708278955,     0.000023256901286,     0.000003340137114,     0.000000616766679,     0.000000139195884,     0.000000037125983,     0.000000011425188,     0.000000003984451,     0.000000001552698,
     0.000000000668457,     0.000000000314904,     0.000000000160987,     0.000000000088646,     0.000000000052209,     0.000000000032671,     0.179484971343517,     0.003680987926942,     0.000226475876846,     0.000023223530730,
     0.000003333976401,     0.000000615376575,     0.000000138825195,     0.000000037011930,     0.000000011385421,     0.000000003968957,     0.000000001546029,     0.000000000665316,     0.000000000313299,     0.000000000160104,
     0.000000000088125,     0.000000000051883,     0.000000000032456,     0.179448172784172,     0.003678724328795,     0.000226243808135,     0.000023190221712,     0.000003327829570,     0.000000613990172,     0.000000138455644,
     0.000000036898274,     0.000000011345809,     0.000000003953530,     0.000000001539391,     0.000000000662191,     0.000000000311702,     0.000000000159225,     0.000000000087608,     0.000000000051559,     0.000000000032242,
     0.179411396849211,     0.003676463049670,     0.000226012072207,     0.000023156974093,     0.000003321696585,     0.000000612607458,     0.000000138087228,     0.000000036785014,     0.000000011306350,     0.000000003938169,
     0.000000001532785,     0.000000000659082,     0.000000000310114,     0.000000000158351,     0.000000000087094,     0.000000000051238,     0.000000000032030,     0.179374643515460,     0.003674204086243,     0.000225780668449,
     0.000023123787734,     0.000003315577409,     0.000000611228423,     0.000000137719943,     0.000000036672147,     0.000000011267045,     0.000000003922874,     0.000000001526210,     0.000000000655988,     0.000000000308535,
     0.000000000157483,     0.000000000086583,     0.000000000050919,     0.000000000031820,     0.179337912759778,     0.003671947435196,     0.000225549596249,     0.000023090662499,     0.000003309472004,     0.000000609853056,
     0.000000137353784,     0.000000036559672,     0.000000011227893,     0.000000003907645,     0.000000001519665,     0.000000000652911,     0.000000000306964,     0.000000000156620,     0.000000000086076,     0.000000000050602,
     0.000000000031610,     0.179301204559059,     0.003669693093215,     0.000225318854996,     0.000023057598248,     0.000003303380335,     0.000000608481344,     0.000000136988748,     0.000000036447588,     0.000000011188892,
     0.000000003892481,     0.000000001513151,     0.000000000649849,     0.000000000305403,     0.000000000155761,     0.000000000085571,     0.000000000050287,     0.000000000031403,     0.179264518890228,     0.003667441056995,
     0.000225088444081,     0.000023024594846,     0.000003297302365,     0.000000607113277,     0.000000136624831,     0.000000036335894,     0.000000011150043,     0.000000003877382,     0.000000001506668,     0.000000000646803,
     0.000000000303849,     0.000000000154908,     0.000000000085070,     0.000000000049974,     0.000000000031196,     0.179227855730244,     0.003665191323235,     0.000224858362896,     0.000022991652156,     0.000003291238058,
     0.000000605748844,     0.000000136262029,     0.000000036224587,     0.000000011111344,     0.000000003862347,     0.000000001500215,     0.000000000643772,     0.000000000302304,     0.000000000154060,     0.000000000084572,
     0.000000000049663,     0.000000000030991,     0.179191215056100,     0.003662943888640,     0.000224628610836,     0.000022958770040,     0.000003285187376,     0.000000604388033,     0.000000135900338,     0.000000036113666,
     0.000000011072796,     0.000000003847377,     0.000000001493793,     0.000000000640757,     0.000000000300768,     0.000000000153217,     0.000000000084077,     0.000000000049354,     0.000000000030788,     0.179154596844818,
     0.003660698749923,     0.000224399187294,     0.000022925948363,     0.000003279150285,     0.000000603030833,     0.000000135539754,     0.000000036003131,     0.000000011034396,     0.000000003832471,     0.000000001487400,
     0.000000000637757,     0.000000000299240,     0.000000000152379,     0.000000000083585,     0.000000000049047,     0.000000000030586,     0.179118001073459,     0.003658455903801,     0.000224170091668,     0.000022893186989,
     0.000003273126748,     0.000000601677234,     0.000000135180274,     0.000000035892978,     0.000000010996146,     0.000000003817629,     0.000000001481037,     0.000000000634772,     0.000000000297720,     0.000000000151545,
     0.000000000083096,     0.000000000048742,     0.000000000030385,     0.179081427719111,     0.003656215346998,     0.000223941323354,     0.000022860485783,     0.000003267116728,     0.000000600327224,     0.000000134821893,
     0.000000035783207,     0.000000010958044,     0.000000003802850,     0.000000001474705,     0.000000000631802,     0.000000000296209,     0.000000000150717,     0.000000000082610,     0.000000000048439,     0.000000000030186,
     0.179044876758899,     0.003653977076245,     0.000223712881752,     0.000022827844609,     0.000003261120191,     0.000000598980792,     0.000000134464609,     0.000000035673817,     0.000000010920089,     0.000000003788135,
     0.000000001468401,     0.000000000628848,     0.000000000294706,     0.000000000149893,     0.000000000082127,     0.000000000048138,     0.000000000029988,     0.179008348169977,     0.003651741088276,     0.000223484766262,
     0.000022795263334,     0.000003255137101,     0.000000597637928,     0.000000134108416,     0.000000035564805,     0.000000010882281,     0.000000003773482,     0.000000001462128,     0.000000000625908,     0.000000000293211,
     0.000000000149074,     0.000000000081647,     0.000000000047839,     0.000000000029791,     0.178971841929535,     0.003649507379835,     0.000223256976286,     0.000022762741823,     0.000003249167421,     0.000000596298620,
     0.000000133753311,     0.000000035456171,     0.000000010844619,     0.000000003758892,     0.000000001455883,     0.000000000622983,     0.000000000291725,     0.000000000148260,     0.000000000081170,     0.000000000047543,
     0.000000000029596,     0.178935358014793,     0.003647275947668,     0.000223029511227,     0.000022730279941,     0.000003243211116,     0.000000594962858,     0.000000133399291,     0.000000035347912,     0.000000010807103,
     0.000000003744365,     0.000000001449668,     0.000000000620073,     0.000000000290246,     0.000000000147451,     0.000000000080696,     0.000000000047248,     0.000000000029402,     0.178898896403005,     0.003645046788529,
     0.000222802370489,     0.000022697877556,     0.000003237268152,     0.000000593630631,     0.000000133046352,     0.000000035240028,     0.000000010769731,     0.000000003729899,     0.000000001443482,     0.000000000617178,
     0.000000000288776,     0.000000000146646,     0.000000000080225,     0.000000000046954,     0.000000000029209,     0.178862457071456,     0.003642819899179,     0.000222575553478,     0.000022665534534,     0.000003231338492,
     0.000000592301928,     0.000000132694489,     0.000000035132517,     0.000000010732505,     0.000000003715495,     0.000000001437324,     0.000000000614298,     0.000000000287313,     0.000000000145846,     0.000000000079757,
     0.000000000046663,     0.000000000029018,     0.178826039997466,     0.003640595276382,     0.000222349059601,     0.000022633250742,     0.000003225422102,     0.000000590976738,     0.000000132343700,     0.000000035025377,
     0.000000010695421,     0.000000003701152,     0.000000001431196,     0.000000000611432,     0.000000000285859,     0.000000000145051,     0.000000000079292,     0.000000000046374,     0.000000000028828,     0.178789645158384,
     0.003638372916912,     0.000222122888266,     0.000022601026048,     0.000003219518946,     0.000000589655050,     0.000000131993980,     0.000000034918608,     0.000000010658481,     0.000000003686871,     0.000000001425096,
     0.000000000608581,     0.000000000284412,     0.000000000144260,     0.000000000078829,     0.000000000046087,     0.000000000028639,     0.178753272531594,     0.003636152817544,     0.000221897038883,     0.000022568860319,
     0.000003213628989,     0.000000588336854,     0.000000131645327,     0.000000034812207,     0.000000010621684,     0.000000003672650,     0.000000001419024,     0.000000000605744,     0.000000000282973,     0.000000000143474,
     0.000000000078370,     0.000000000045801,     0.000000000028452,     0.178716922094510,     0.003633934975063,     0.000221671510863,     0.000022536753424,     0.000003207752197,     0.000000587022140,     0.000000131297735,
     0.000000034706174,     0.000000010585028,     0.000000003658490,     0.000000001412981,     0.000000000602921,     0.000000000281543,     0.000000000142693,     0.000000000077913,     0.000000000045518,     0.000000000028266,
     0.178680593824581,     0.003631719386257,     0.000221446303619,     0.000022504705231,     0.000003201888535,     0.000000585710896,     0.000000130951202,     0.000000034600506,     0.000000010548514,     0.000000003644391,
     0.000000001406965,     0.000000000600113,     0.000000000280119,     0.000000000141916,     0.000000000077460,     0.000000000045236,     0.000000000028081,     0.178644287699284,     0.003629506047923,     0.000221221416564,
     0.000022472715610,     0.000003196037967,     0.000000584403112,     0.000000130605724,     0.000000034495203,     0.000000010512140,     0.000000003630351,     0.000000001400978,     0.000000000597319,     0.000000000278704,
     0.000000000141144,     0.000000000077009,     0.000000000044956,     0.000000000027898,     0.178608003696131,     0.003627294956861,     0.000220996849112,     0.000022440784428,     0.000003190200461,     0.000000583098778,
     0.000000130261297,     0.000000034390263,     0.000000010475907,     0.000000003616371,     0.000000001395019,     0.000000000594539,     0.000000000277297,     0.000000000140376,     0.000000000076561,     0.000000000044678,
     0.000000000027716,     0.178571741792666,     0.003625086109877,     0.000220772600681,     0.000022408911557,     0.000003184375980,     0.000000581797883,     0.000000129917917,     0.000000034285685,     0.000000010439812,
     0.000000003602450,     0.000000001389088,     0.000000000591773,     0.000000000275897,     0.000000000139612,     0.000000000076115,     0.000000000044402,     0.000000000027535,     0.178535501966464,     0.003622879503786,
     0.000220548670687,     0.000022377096865,     0.000003178564492,     0.000000580500416,     0.000000129575582,     0.000000034181466,     0.000000010403857,     0.000000003588589,     0.000000001383184,     0.000000000589021,
     0.000000000274504,     0.000000000138854,     0.000000000075672,     0.000000000044127,     0.000000000027355,     0.178499284195132,     0.003620675135404,     0.000220325058550,     0.000022345340224,     0.000003172765961,
     0.000000579206368,     0.000000129234287,     0.000000034077607,     0.000000010368040,     0.000000003574787,     0.000000001377307,     0.000000000586283,     0.000000000273120,     0.000000000138099,     0.000000000075233,
     0.000000000043855,     0.000000000027176,     0.178463088456308,     0.003618473001557,     0.000220101763689,     0.000022313641503,     0.000003166980353,     0.000000577915727,     0.000000128894029,     0.000000033974105,
     0.000000010332361,     0.000000003561043,     0.000000001371458,     0.000000000583558,     0.000000000271742,     0.000000000137349,     0.000000000074795,     0.000000000043584,     0.000000000026999,     0.178426914727663,
     0.003616273099075,     0.000219878785527,     0.000022282000574,     0.000003161207635,     0.000000576628484,     0.000000128554804,     0.000000033870959,     0.000000010296819,     0.000000003547357,     0.000000001365636,
     0.000000000580848,     0.000000000270373,     0.000000000136603,     0.000000000074361,     0.000000000043315,     0.000000000026823,     0.178390762986899,     0.003614075424793,     0.000219656123486,     0.000022250417308,
     0.000003155447772,     0.000000575344628,     0.000000128216608,     0.000000033768168,     0.000000010261414,     0.000000003533730,     0.000000001359841,     0.000000000578151,     0.000000000269010,     0.000000000135862,
     0.000000000073929,     0.000000000043047,     0.000000000026648,     0.178354633211750,     0.003611879975553,     0.000219433776989,     0.000022218891576,     0.000003149700731,     0.000000574064148,     0.000000127879439,
     0.000000033665730,     0.000000010226145,     0.000000003520160,     0.000000001354073,     0.000000000575468,     0.000000000267655,     0.000000000135125,     0.000000000073500,     0.000000000042782,     0.000000000026474,
     0.178318525379981,     0.003609686748203,     0.000219211745463,     0.000022187423250,     0.000003143966478,     0.000000572787036,     0.000000127543292,     0.000000033563645,     0.000000010191011,     0.000000003506648,
     0.000000001348331,     0.000000000572798,     0.000000000266308,     0.000000000134392,     0.000000000073073,     0.000000000042518,     0.000000000026302,     0.178282439469390,     0.003607495739596,     0.000218990028333,
     0.000022156012204,     0.000003138244979,     0.000000571513279,     0.000000127208165,     0.000000033461910,     0.000000010156011,     0.000000003493194,     0.000000001342617,     0.000000000570141,     0.000000000264967,
     0.000000000133663,     0.000000000072650,     0.000000000042256,     0.000000000026130,     0.178246375457804,     0.003605306946590,     0.000218768625028,     0.000022124658308,     0.000003132536201,     0.000000570242869,
     0.000000126874053,     0.000000033360524,     0.000000010121147,     0.000000003479796,     0.000000001336929,     0.000000000567498,     0.000000000263634,     0.000000000132939,     0.000000000072228,     0.000000000041995,
     0.000000000025960,     0.178210333323083,     0.003603120366051,     0.000218547534977,     0.000022093361437,     0.000003126840111,     0.000000568975795,     0.000000126540953,     0.000000033259486,     0.000000010086415,
     0.000000003466455,     0.000000001331267,     0.000000000564869,     0.000000000262309,     0.000000000132218,     0.000000000071810,     0.000000000041737,     0.000000000025791,     0.178174313043119,     0.003600935994849,
     0.000218326757610,     0.000022062121464,     0.000003121156674,     0.000000567712046,     0.000000126208862,     0.000000033158795,     0.000000010051817,     0.000000003453171,     0.000000001325631,     0.000000000562252,
     0.000000000260990,     0.000000000131502,     0.000000000071394,     0.000000000041479,     0.000000000025623,     0.178138314595832,     0.003598753829859,     0.000218106292358,     0.000022030938262,     0.000003115485859,
     0.000000566451614,     0.000000125877776,     0.000000033058450,     0.000000010017352,     0.000000003439942,     0.000000001320022,     0.000000000559649,     0.000000000259679,     0.000000000130791,     0.000000000070980,
     0.000000000041224,     0.000000000025457,     0.178102337959178,     0.003596573867963,     0.000217886138656,     0.000021999811705,     0.000003109827631,     0.000000565194488,     0.000000125547692,     0.000000032958448,
     0.000000009983018,     0.000000003426770,     0.000000001314438,     0.000000000557059,     0.000000000258374,     0.000000000130083,     0.000000000070569,     0.000000000040970,     0.000000000025291,     0.178066383111140,
     0.003594396106049,     0.000217666295936,     0.000021968741667,     0.000003104181958,     0.000000563940657,     0.000000125218606,     0.000000032858789,     0.000000009948816,     0.000000003413654,     0.000000001308880,
     0.000000000554481,     0.000000000257077,     0.000000000129379,     0.000000000070161,     0.000000000040718,     0.000000000025127,     0.178030450029734,     0.003592220541009,     0.000217446763634,     0.000021937728024,
     0.000003098548807,     0.000000562690112,     0.000000124890515,     0.000000032759471,     0.000000009914745,     0.000000003400592,     0.000000001303348,     0.000000000551917,     0.000000000255787,     0.000000000128680,
     0.000000000069755,     0.000000000040468,     0.000000000024964,     0.177994538693007,     0.003590047169743,     0.000217227541188,     0.000021906770650,     0.000003092928145,     0.000000561442843,     0.000000124563416,
     0.000000032660494,     0.000000009880804,     0.000000003387586,     0.000000001297842,     0.000000000549366,     0.000000000254503,     0.000000000127984,     0.000000000069351,     0.000000000040219,     0.000000000024801,
     0.177958649079037,     0.003587875989155,     0.000217008628034,     0.000021875869420,     0.000003087319939,     0.000000560198840,     0.000000124237304,     0.000000032561855,     0.000000009846993,     0.000000003374635,
     0.000000001292361,     0.000000000546827,     0.000000000253227,     0.000000000127293,     0.000000000068950,     0.000000000039972,     0.000000000024640,     0.177922781165932,     0.003585706996154,     0.000216790023613,
     0.000021845024209,     0.000003081724157,     0.000000558958094,     0.000000123912177,     0.000000032463553,     0.000000009813311,     0.000000003361739,     0.000000001286905,     0.000000000544301,     0.000000000251958,
     0.000000000126605,     0.000000000068552,     0.000000000039726,     0.000000000024480,     0.177886934931832,     0.003583540187655,     0.000216571727364,     0.000021814234895,     0.000003076140766,     0.000000557720594,
     0.000000123588032,     0.000000032365588,     0.000000009779758,     0.000000003348897,     0.000000001281475,     0.000000000541788,     0.000000000250695,     0.000000000125922,     0.000000000068156,     0.000000000039482,
     0.000000000024321,     0.177851110354907,     0.003581375560581,     0.000216353738729,     0.000021783501353,     0.000003070569734,     0.000000556486330,     0.000000123264864,     0.000000032267958,     0.000000009746333,
     0.000000003336110,     0.000000001276070,     0.000000000539287,     0.000000000249439,     0.000000000125242,     0.000000000067762,     0.000000000039240,     0.000000000024164,     0.177815307413359,     0.003579213111857,
     0.000216136057151,     0.000021752823459,     0.000003065011029,     0.000000555255293,     0.000000122942672,     0.000000032170661,     0.000000009713036,     0.000000003323376,     0.000000001270689,     0.000000000536799,
     0.000000000248190,     0.000000000124566,     0.000000000067371,     0.000000000038999,     0.000000000024007,     0.177779526085419,     0.003577052838416,     0.000215918682075,     0.000021722201091,     0.000003059464618,
     0.000000554027473,     0.000000122621450,     0.000000032073697,     0.000000009679865,     0.000000003310696,     0.000000001265334,     0.000000000534323,     0.000000000246948,     0.000000000123895,     0.000000000066982,
     0.000000000038760,     0.000000000023851,     0.177743766349350,     0.003574894737196,     0.000215701612945,     0.000021691634126,     0.000003053930469,     0.000000552802861,     0.000000122301197,     0.000000031977063,
     0.000000009646822,     0.000000003298069,     0.000000001260003,     0.000000000531860,     0.000000000245712,     0.000000000123227,     0.000000000066596,     0.000000000038522,     0.000000000023697,     0.177708028183445,
     0.003572738805139,     0.000215484849208,     0.000021661122441,     0.000003048408550,     0.000000551581446,     0.000000121981908,     0.000000031880760,     0.000000009613904,     0.000000003285496,     0.000000001254696,
     0.000000000529409,     0.000000000244483,     0.000000000122563,     0.000000000066212,     0.000000000038286,     0.000000000023543,     0.177672311566027,     0.003570585039196,     0.000215268390312,     0.000021630665914,
     0.000003042898829,     0.000000550363220,     0.000000121663580,     0.000000031784785,     0.000000009581112,     0.000000003272975,     0.000000001249415,     0.000000000526970,     0.000000000243261,     0.000000000121902,
     0.000000000065830,     0.000000000038051,     0.000000000023391,     0.177636616475451,     0.003568433436319,     0.000215052235706,     0.000021600264424,     0.000003037401275,     0.000000549148171,     0.000000121346211,
     0.000000031689137,     0.000000009548444,     0.000000003260507,     0.000000001244157,     0.000000000524544,     0.000000000242045,     0.000000000121246,     0.000000000065451,     0.000000000037818,     0.000000000023239,
     0.177600942890101,     0.003566283993469,     0.000214836384841,     0.000021569917848,     0.000003031915855,     0.000000547936292,     0.000000121029796,     0.000000031593815,     0.000000009515901,     0.000000003248092,
     0.000000001238924,     0.000000000522129,     0.000000000240836,     0.000000000120593,     0.000000000065074,     0.000000000037586,     0.000000000023089,     0.177565290788391,     0.003564136707611,     0.000214620837167,
     0.000021539626067,     0.000003026442539,     0.000000546727572,     0.000000120714334,     0.000000031498819,     0.000000009483482,     0.000000003235729,     0.000000001233714,     0.000000000519727,     0.000000000239633,
     0.000000000119945,     0.000000000064699,     0.000000000037356,     0.000000000022939,     0.177529660148768,     0.003561991575717,     0.000214405592137,     0.000021509388957,     0.000003020981293,     0.000000545522002,
     0.000000120399819,     0.000000031404145,     0.000000009451187,     0.000000003223417,     0.000000001228529,     0.000000000517337,     0.000000000238437,     0.000000000119299,     0.000000000064327,     0.000000000037127,
     0.000000000022791,     0.177494050949707,     0.003559848594762,     0.000214190649206,     0.000021479206401,     0.000003015532088,     0.000000544319573,     0.000000120086250,     0.000000031309794,     0.000000009419014,
     0.000000003211158,     0.000000001223368,     0.000000000514958,     0.000000000237247,     0.000000000118658,     0.000000000063956,     0.000000000036900,     0.000000000022644,     0.177458463169714,     0.003557707761727,
     0.000213976007828,     0.000021449078276,     0.000003010094891,     0.000000543120274,     0.000000119773622,     0.000000031215765,     0.000000009386963,     0.000000003198950,     0.000000001218230,     0.000000000512592,
     0.000000000236064,     0.000000000118020,     0.000000000063589,     0.000000000036674,     0.000000000022497,     0.177422896787323,     0.003555569073602,     0.000213761667459,     0.000021419004463,     0.000003004669672,
     0.000000541924097,     0.000000119461933,     0.000000031122055,     0.000000009355034,     0.000000003186793,     0.000000001213116,     0.000000000510237,     0.000000000234887,     0.000000000117386,     0.000000000063223,
     0.000000000036450,     0.000000000022352,     0.177387351781102,     0.003553432527377,     0.000213547627558,     0.000021388984842,     0.000002999256399,     0.000000540731032,     0.000000119151180,     0.000000031028664,
     0.000000009323227,     0.000000003174688,     0.000000001208025,     0.000000000507894,     0.000000000233716,     0.000000000116756,     0.000000000062860,     0.000000000036227,     0.000000000022207,     0.177351828129646,
     0.003551298120051,     0.000213333887582,     0.000021359019295,     0.000002993855041,     0.000000539541070,     0.000000118841359,     0.000000030935590,     0.000000009291541,     0.000000003162633,     0.000000001202958,
     0.000000000505563,     0.000000000232552,     0.000000000116129,     0.000000000062498,     0.000000000036006,     0.000000000022064,     0.177316325811581,     0.003549165848627,     0.000213120446992,     0.000021329107702,
     0.000002988465567,     0.000000538354202,     0.000000118532467,     0.000000030842832,     0.000000009259974,     0.000000003150628,     0.000000001197914,     0.000000000503243,     0.000000000231394,     0.000000000115506,
     0.000000000062139,     0.000000000035786,     0.000000000021922,     0.177280844805564,     0.003547035710115,     0.000212907305248,     0.000021299249944,     0.000002983087947,     0.000000537170418,     0.000000118224501,
     0.000000030750390,     0.000000009228528,     0.000000003138674,     0.000000001192893,     0.000000000500935,     0.000000000230242,     0.000000000114886,     0.000000000061783,     0.000000000035568,     0.000000000021780,
     0.177245385090279,     0.003544907701528,     0.000212694461814,     0.000021269445904,     0.000002977722149,     0.000000535989709,     0.000000117917458,     0.000000030658261,     0.000000009197201,     0.000000003126770,
     0.000000001187895,     0.000000000498638,     0.000000000229096,     0.000000000114270,     0.000000000061428,     0.000000000035351,     0.000000000021640,     0.177209946644443,     0.003542781819886,     0.000212481916152,
     0.000021239695462,     0.000002972368142,     0.000000534812066,     0.000000117611335,     0.000000030566446,     0.000000009165992,     0.000000003114916,     0.000000001182920,     0.000000000496353,     0.000000000227956,
     0.000000000113658,     0.000000000061076,     0.000000000035135,     0.000000000021500,     0.177174529446802,     0.003540658062214,     0.000212269667726,     0.000021209998502,     0.000002967025897,     0.000000533637479,
     0.000000117306128,     0.000000030474941,     0.000000009134902,     0.000000003103112,     0.000000001177968,     0.000000000494079,     0.000000000226823,     0.000000000113049,     0.000000000060725,     0.000000000034921,
     0.000000000021361,     0.177139133476129,     0.003538536425542,     0.000212057716004,     0.000021180354905,     0.000002961695383,     0.000000532465940,     0.000000117001835,     0.000000030383747,     0.000000009103930,
     0.000000003091357,     0.000000001173038,     0.000000000491816,     0.000000000225695,     0.000000000112443,     0.000000000060377,     0.000000000034708,     0.000000000021224,     0.177103758711231,     0.003536416906907,
     0.000211846060451,     0.000021150764555,     0.000002956376568,     0.000000531297440,     0.000000116698452,     0.000000030292862,     0.000000009073075,     0.000000003079651,     0.000000001168132,     0.000000000489565,
     0.000000000224574,     0.000000000111841,     0.000000000060031,     0.000000000034496,     0.000000000021087,     0.177068405130941,     0.003534299503348,     0.000211634700536,     0.000021121227335,     0.000002951069424,
     0.000000530131968,     0.000000116395977,     0.000000030202285,     0.000000009042337,     0.000000003067994,     0.000000001163247,     0.000000000487325,     0.000000000223458,     0.000000000111242,     0.000000000059687,
     0.000000000034286,     0.000000000020951,     0.177033072714123,     0.003532184211912,     0.000211423635727,     0.000021091743128,     0.000002945773919,     0.000000528969517,     0.000000116094406,     0.000000030112015,
     0.000000009011715,     0.000000003056386,     0.000000001158385,     0.000000000485096,     0.000000000222349,     0.000000000110647,     0.000000000059346,     0.000000000034077,     0.000000000020816,     0.176997761439672,
     0.003530071029651,     0.000211212865497,     0.000021062311818,     0.000002940490023,     0.000000527810077,     0.000000115793736,     0.000000030022051,     0.000000008981209,     0.000000003044826,     0.000000001153545,
     0.000000000482878,     0.000000000221245,     0.000000000110056,     0.000000000059006,     0.000000000033870,     0.000000000020682,     0.176962471286509,     0.003527959953622,     0.000211002389315,     0.000021032933289,
     0.000002935217707,     0.000000526653639,     0.000000115493964,     0.000000029932390,     0.000000008950818,     0.000000003033315,     0.000000001148727,     0.000000000480671,     0.000000000220148,     0.000000000109467,
     0.000000000058668,     0.000000000033663,     0.000000000020549,     0.176927202233588,     0.003525850980887,     0.000210792206655,     0.000021003607425,     0.000002929956941,     0.000000525500195,     0.000000115195087,
     0.000000029843034,     0.000000008920542,     0.000000003021852,     0.000000001143932,     0.000000000478475,     0.000000000219056,     0.000000000108882,     0.000000000058333,     0.000000000033459,     0.000000000020417,
     0.176891954259890,     0.003523744108512,     0.000210582316991,     0.000020974334111,     0.000002924707693,     0.000000524349735,     0.000000114897102,     0.000000029753979,     0.000000008890381,     0.000000003010436,
     0.000000001139158,     0.000000000476290,     0.000000000217970,     0.000000000108301,     0.000000000057999,     0.000000000033255,     0.000000000020286,     0.176856727344427,     0.003521639333572,     0.000210372719798,
     0.000020945113233,     0.000002919469936,     0.000000523202250,     0.000000114600006,     0.000000029665226,     0.000000008860333,     0.000000002999069,     0.000000001134406,     0.000000000474116,     0.000000000216890,
     0.000000000107722,     0.000000000057667,     0.000000000033053,     0.000000000020155,     0.176821521466237,     0.003519536653143,     0.000210163414552,     0.000020915944674,     0.000002914243639,     0.000000522057731,
     0.000000114303796,     0.000000029576772,     0.000000008830399,     0.000000002987748,     0.000000001129676,     0.000000000471952,     0.000000000215816,     0.000000000107147,     0.000000000057338,     0.000000000032852,
     0.000000000020026,     0.176786336604392,     0.003517436064310,     0.000209954400731,     0.000020886828322,     0.000002909028772,     0.000000520916171,     0.000000114008470,     0.000000029488617,     0.000000008800578,
     0.000000002976475,     0.000000001124967,     0.000000000469799,     0.000000000214747,     0.000000000106575,     0.000000000057010,     0.000000000032652,     0.000000000019897,     0.176751172737989,     0.003515337564159,
     0.000209745677812,     0.000020857764061,     0.000002903825305,     0.000000519777559,     0.000000113714023,     0.000000029400760,     0.000000008770870,     0.000000002965249,     0.000000001120280,     0.000000000467657,
     0.000000000213684,     0.000000000106007,     0.000000000056685,     0.000000000032454,     0.000000000019769,     0.176716029846156,     0.003513241149785,     0.000209537245276,     0.000020828751778,     0.000002898633211,
     0.000000518641888,     0.000000113420453,     0.000000029313200,     0.000000008741273,     0.000000002954069,     0.000000001115614,     0.000000000465525,     0.000000000212627,     0.000000000105442,     0.000000000056361,
     0.000000000032257,     0.000000000019642,     0.176680907908050,     0.003511146818287,     0.000209329102604,     0.000020799791359,     0.000002893452458,     0.000000517509147,     0.000000113127758,     0.000000029225934,
     0.000000008711788,     0.000000002942937,     0.000000001110969,     0.000000000463404,     0.000000000211575,     0.000000000104880,     0.000000000056040,     0.000000000032061,     0.000000000019516,     0.176645806902857,
     0.003509054566769,     0.000209121249277,     0.000020770882691,     0.000002888283018,     0.000000516379329,     0.000000112835934,     0.000000029138963,     0.000000008682414,     0.000000002931850,     0.000000001106345,
     0.000000000461294,     0.000000000210529,     0.000000000104321,     0.000000000055720,     0.000000000031867,     0.000000000019391,     0.176610726809791,     0.003506964392339,     0.000208913684778,     0.000020742025661,
     0.000002883124862,     0.000000515252426,     0.000000112544978,     0.000000029052286,     0.000000008653151,     0.000000002920810,     0.000000001101743,     0.000000000459194,     0.000000000209489,     0.000000000103765,
     0.000000000055402,     0.000000000031673,     0.000000000019267,     0.176575667608096,     0.003504876292112,     0.000208706408592,     0.000020713220156,     0.000002877977960,     0.000000514128427,     0.000000112254887,
     0.000000028965900,     0.000000008623998,     0.000000002909815,     0.000000001097162,     0.000000000457104,     0.000000000208454,     0.000000000103213,     0.000000000055087,     0.000000000031481,     0.000000000019143,
     0.176540629277044,     0.003502790263208,     0.000208499420203,     0.000020684466064,     0.000002872842283,     0.000000513007325,     0.000000111965659,     0.000000028879805,     0.000000008594955,     0.000000002898866,
     0.000000001092601,     0.000000000455025,     0.000000000207425,     0.000000000102664,     0.000000000054773,     0.000000000031290,     0.000000000019021,     0.176505611795937,     0.003500706302750,     0.000208292719099,
     0.000020655763273,     0.000002867717804,     0.000000511889111,     0.000000111677290,     0.000000028794001,     0.000000008566020,     0.000000002887963,     0.000000001088061,     0.000000000452956,     0.000000000206401,
     0.000000000102117,     0.000000000054461,     0.000000000031101,     0.000000000018899,     0.176470615144104,     0.003498624407870,     0.000208086304767,     0.000020627111671,     0.000002862604492,     0.000000510773776,
     0.000000111389778,     0.000000028708485,     0.000000008537195,     0.000000002877105,     0.000000001083542,     0.000000000450897,     0.000000000205382,     0.000000000101574,     0.000000000054151,     0.000000000030912,
     0.000000000018778,     0.176435639300904,     0.003496544575701,     0.000207880176696,     0.000020598511146,     0.000002857502318,     0.000000509661313,     0.000000111103119,     0.000000028623256,     0.000000008508478,
     0.000000002866292,     0.000000001079043,     0.000000000448848,     0.000000000204369,     0.000000000101034,     0.000000000053843,     0.000000000030725,     0.000000000018657,     0.176400684245724,     0.003494466803384,
     0.000207674334375,     0.000020569961588,     0.000002852411256,     0.000000508551711,     0.000000110817312,     0.000000028538315,     0.000000008479869,     0.000000002855524,     0.000000001074565,     0.000000000446809,
     0.000000000203362,     0.000000000100498,     0.000000000053536,     0.000000000030539,     0.000000000018538,     0.176365749957980,     0.003492391088063,     0.000207468777294,     0.000020541462884,     0.000002847331275,
     0.000000507444963,     0.000000110532352,     0.000000028453659,     0.000000008451368,     0.000000002844801,     0.000000001070107,     0.000000000444781,     0.000000000202359,     0.000000000099964,     0.000000000053232,
     0.000000000030355,     0.000000000018419,     0.176330836417116,     0.003490317426889,     0.000207263504948,     0.000020513014925,     0.000002842262347,     0.000000506341061,     0.000000110248238,     0.000000028369287,
     0.000000008422973,     0.000000002834122,     0.000000001065669,     0.000000000442762,     0.000000000201362,     0.000000000099433,     0.000000000052929,     0.000000000030171,     0.000000000018301,     0.176295943602604,
     0.003488245817016,     0.000207058516827,     0.000020484617601,     0.000002837204444,     0.000000505239996,     0.000000109964965,     0.000000028285199,     0.000000008394685,     0.000000002823487,     0.000000001061252,
     0.000000000440753,     0.000000000200371,     0.000000000098905,     0.000000000052628,     0.000000000029989,     0.000000000018184,     0.176261071493947,     0.003486176255606,     0.000206853812427,     0.000020456270800,
     0.000002832157538,     0.000000504141759,     0.000000109682533,     0.000000028201393,     0.000000008366503,     0.000000002812897,     0.000000001056854,     0.000000000438755,     0.000000000199384,     0.000000000098380,
     0.000000000052329,     0.000000000029807,     0.000000000018068,     0.176226220070673,     0.003484108739824,     0.000206649391243,     0.000020427974413,     0.000002827121599,     0.000000503046342,     0.000000109400937,
     0.000000028117868,     0.000000008338427,     0.000000002802350,     0.000000001052476,     0.000000000436766,     0.000000000198403,     0.000000000097858,     0.000000000052032,     0.000000000029627,     0.000000000017953,
     0.176191389312341,     0.003482043266839,     0.000206445252771,     0.000020399728331,     0.000002822096601,     0.000000501953738,     0.000000109120174,     0.000000028034624,     0.000000008310456,     0.000000002791847,
     0.000000001048119,     0.000000000434787,     0.000000000197427,     0.000000000097340,     0.000000000051737,     0.000000000029448,     0.000000000017838,     0.176156579198537,     0.003479979833828,     0.000206241396509,
     0.000020371532445,     0.000002817082515,     0.000000500863936,     0.000000108840243,     0.000000027951659,     0.000000008282590,     0.000000002781388,     0.000000001043781,     0.000000000432817,     0.000000000196456,
     0.000000000096824,     0.000000000051443,     0.000000000029270,     0.000000000017724,     0.176121789708874,     0.003477918437970,     0.000206037821955,     0.000020343386645,     0.000002812079313,     0.000000499776930,
     0.000000108561140,     0.000000027868972,     0.000000008254828,     0.000000002770971,     0.000000001039462,     0.000000000430858,     0.000000000195490,     0.000000000096311,     0.000000000051151,     0.000000000029094,
     0.000000000017611,     0.176087020822996,     0.003475859076451,     0.000205834528610,     0.000020315290822,     0.000002807086967,     0.000000498692711,     0.000000108282863,     0.000000027786562,     0.000000008227170,
     0.000000002760598,     0.000000001035164,     0.000000000428907,     0.000000000194530,     0.000000000095801,     0.000000000050861,     0.000000000028918,     0.000000000017499,     0.176052272520573,     0.003473801746462,
     0.000205631515973,     0.000020287244869,     0.000002802105450,     0.000000497611270,     0.000000108005408,     0.000000027704428,     0.000000008199616,     0.000000002750268,     0.000000001030884,     0.000000000426967,
     0.000000000193574,     0.000000000095294,     0.000000000050573,     0.000000000028744,     0.000000000017387,     0.176017544781305,     0.003471746445198,     0.000205428783546,     0.000020259248677,     0.000002797134733,
     0.000000496532600,     0.000000107728773,     0.000000027622569,     0.000000008172165,     0.000000002739981,     0.000000001026624,     0.000000000425036,     0.000000000192624,     0.000000000094789,     0.000000000050286,
     0.000000000028570,     0.000000000017276,     0.175982837584916,     0.003469693169859,     0.000205226330834,     0.000020231302139,     0.000002792174789,     0.000000495456692,     0.000000107452956,     0.000000027540985,
     0.000000008144816,     0.000000002729736,     0.000000001022383,     0.000000000423114,     0.000000000191679,     0.000000000094288,     0.000000000050002,     0.000000000028398,     0.000000000017166,     0.175948150911164,
     0.003467641917650,     0.000205024157339,     0.000020203405146,     0.000002787225590,     0.000000494383538,     0.000000107177953,     0.000000027459673,     0.000000008117570,     0.000000002719533,     0.000000001018162,
     0.000000000421202,     0.000000000190738,     0.000000000093789,     0.000000000049718,     0.000000000028227,     0.000000000017057,     0.175913484739829,     0.003465592685783,     0.000204822262566,     0.000020175557591,
     0.000002782287109,     0.000000493313130,     0.000000106903761,     0.000000027378633,     0.000000008090425,     0.000000002709372,     0.000000001013959,     0.000000000419300,     0.000000000189803,     0.000000000093293,
     0.000000000049437,     0.000000000028057,     0.000000000016948,     0.175878839050723,     0.003463545471471,     0.000204620646022,     0.000020147759368,     0.000002777359318,     0.000000492245460,     0.000000106630379,
     0.000000027297864,     0.000000008063382,     0.000000002699254,     0.000000001009776,     0.000000000417406,     0.000000000188872,     0.000000000092800,     0.000000000049157,     0.000000000027888,     0.000000000016840,
     0.175844213823684,     0.003461500271936,     0.000204419307215,     0.000020120010369,     0.000002772442190,     0.000000491180520,     0.000000106357803,     0.000000027217365,     0.000000008036440,     0.000000002689177,
     0.000000001005611,     0.000000000415522,     0.000000000187947,     0.000000000092310,     0.000000000048879,     0.000000000027720,     0.000000000016733,     0.175809609038577,     0.003459457084403,     0.000204218245651,
     0.000020092310489,     0.000002767535699,     0.000000490118301,     0.000000106086031,     0.000000027137135,     0.000000008009599,     0.000000002679141,     0.000000001001465,     0.000000000413647,     0.000000000187026,
     0.000000000091823,     0.000000000048603,     0.000000000027553,     0.000000000016626,     0.175775024675298,     0.003457415906101,     0.000204017460841,     0.000020064659620,     0.000002762639815,     0.000000489058796,
     0.000000105815060,     0.000000027057173,     0.000000007982857,     0.000000002669147,     0.000000000997338,     0.000000000411782,     0.000000000186110,     0.000000000091338,     0.000000000048328,     0.000000000027388,
     0.000000000016520,     0.175740460713767,     0.003455376734265,     0.000203816952296,     0.000020037057657,     0.000002757754514,     0.000000488001997,     0.000000105544887,     0.000000026977477,     0.000000007956216,
     0.000000002659194,     0.000000000993230,     0.000000000409925,     0.000000000185199,     0.000000000090856,     0.000000000048055,     0.000000000027223,     0.000000000016415,     0.175705917133934,     0.003453339566136,
     0.000203616719526,     0.000020009504495,     0.000002752879766,     0.000000486947896,     0.000000105275509,     0.000000026898048,     0.000000007929673,     0.000000002649283,     0.000000000989140,     0.000000000408078,
     0.000000000184293,     0.000000000090377,     0.000000000047784,     0.000000000027059,     0.000000000016311,     0.175671393915775,     0.003451304398957,     0.000203416762044,     0.000019982000027,     0.000002748015547,
     0.000000485896485,     0.000000105006925,     0.000000026818883,     0.000000007903230,     0.00000000263941