
#ifndef LOTUS_lapack
#define LOTUS_lapack


typedef int integer;
typedef char *address;
typedef float real_lotus;
typedef double doublereal_lotus;
typedef struct { real_lotus r, i; } complex_lotus;
typedef struct { doublereal_lotus r, i; } doublecomplex_lotus;
typedef int logical;
typedef char logical1;
typedef char integer1;

typedef int flag;
typedef int ftnlen;
typedef int ftnint;
typedef logical (*L_fp)(...);

extern "C" {	

/* Subroutine */ int caxpy_(integer *n, complex_lotus *ca, complex_lotus *cx, integer *
	incx, complex_lotus *cy, integer *incy);

/* Subroutine */ int ccopy_(integer *n, complex_lotus *cx, integer *incx, complex_lotus *
	cy, integer *incy);

/* Complex */ void cdotc_(complex_lotus * ret_val, integer *n, complex_lotus *cx, integer 
	*incx, complex_lotus *cy, integer *incy);

/* Complex */ void cdotu_(complex_lotus * ret_val, integer *n, complex_lotus *cx, integer 
	*incx, complex_lotus *cy, integer *incy);

/* Subroutine */ int cgbmv_(char *trans, integer *m, integer *n, integer *kl, 
	integer *ku, complex_lotus *alpha, complex_lotus *a, integer *lda, complex_lotus *x, 
	integer *incx, complex_lotus *beta, complex_lotus *y, integer *incy);

/* Subroutine */ int cgemm_(char *transa, char *transb, integer *m, integer *
	n, integer *k, complex_lotus *alpha, complex_lotus *a, integer *lda, complex_lotus *b, 
	integer *ldb, complex_lotus *beta, complex_lotus *c__, integer *ldc);

/* Subroutine */ int cgemv_(char *trans, integer *m, integer *n, complex_lotus *
	alpha, complex_lotus *a, integer *lda, complex_lotus *x, integer *incx, complex_lotus *
	beta, complex_lotus *y, integer *incy);

/* Subroutine */ int cgerc_(integer *m, integer *n, complex_lotus *alpha, complex_lotus *
	x, integer *incx, complex_lotus *y, integer *incy, complex_lotus *a, integer *lda);

/* Subroutine */ int cgeru_(integer *m, integer *n, complex_lotus *alpha, complex_lotus *
	x, integer *incx, complex_lotus *y, integer *incy, complex_lotus *a, integer *lda);

/* Subroutine */ int chbmv_(char *uplo, integer *n, integer *k, complex_lotus *
	alpha, complex_lotus *a, integer *lda, complex_lotus *x, integer *incx, complex_lotus *
	beta, complex_lotus *y, integer *incy);

/* Subroutine */ int chemm_(char *side, char *uplo, integer *m, integer *n, 
	complex_lotus *alpha, complex_lotus *a, integer *lda, complex_lotus *b, integer *ldb, 
	complex_lotus *beta, complex_lotus *c__, integer *ldc);

/* Subroutine */ int chemv_(char *uplo, integer *n, complex_lotus *alpha, complex_lotus *
	a, integer *lda, complex_lotus *x, integer *incx, complex_lotus *beta, complex_lotus *y, 
	 integer *incy);

/* Subroutine */ int cher_(char *uplo, integer *n, real_lotus *alpha, complex_lotus *x, 
	integer *incx, complex_lotus *a, integer *lda);

/* Subroutine */ int cher2_(char *uplo, integer *n, complex_lotus *alpha, complex_lotus *
	x, integer *incx, complex_lotus *y, integer *incy, complex_lotus *a, integer *lda);

/* Subroutine */ int cher2k_(char *uplo, char *trans, integer *n, integer *k, 
	complex_lotus *alpha, complex_lotus *a, integer *lda, complex_lotus *b, integer *ldb, 
	real_lotus *beta, complex_lotus *c__, integer *ldc);

/* Subroutine */ int cherk_(char *uplo, char *trans, integer *n, integer *k, 
	real_lotus *alpha, complex_lotus *a, integer *lda, real_lotus *beta, complex_lotus *c__, 
	integer *ldc);

/* Subroutine */ int chpmv_(char *uplo, integer *n, complex_lotus *alpha, complex_lotus *
	ap, complex_lotus *x, integer *incx, complex_lotus *beta, complex_lotus *y, integer *
	incy);

/* Subroutine */ int chpr_(char *uplo, integer *n, real_lotus *alpha, complex_lotus *x, 
	integer *incx, complex_lotus *ap);

/* Subroutine */ int chpr2_(char *uplo, integer *n, complex_lotus *alpha, complex_lotus *
	x, integer *incx, complex_lotus *y, integer *incy, complex_lotus *ap);

/* Subroutine */ int crotg_(complex_lotus *ca, complex_lotus *cb, real_lotus *c__, complex_lotus *s);

/* Subroutine */ int cscal_(integer *n, complex_lotus *ca, complex_lotus *cx, integer *
	incx);

/* Subroutine */ int csrot_(integer *n, complex_lotus *cx, integer *incx, complex_lotus *
	cy, integer *incy, real_lotus *c__, real_lotus *s);

/* Subroutine */ int csscal_(integer *n, real_lotus *sa, complex_lotus *cx, integer *incx);

/* Subroutine */ int cswap_(integer *n, complex_lotus *cx, integer *incx, complex_lotus *
	cy, integer *incy);

/* Subroutine */ int csymm_(char *side, char *uplo, integer *m, integer *n, 
	complex_lotus *alpha, complex_lotus *a, integer *lda, complex_lotus *b, integer *ldb, 
	complex_lotus *beta, complex_lotus *c__, integer *ldc);

/* Subroutine */ int csyr2k_(char *uplo, char *trans, integer *n, integer *k, 
	complex_lotus *alpha, complex_lotus *a, integer *lda, complex_lotus *b, integer *ldb, 
	complex_lotus *beta, complex_lotus *c__, integer *ldc);

/* Subroutine */ int csyrk_(char *uplo, char *trans, integer *n, integer *k, 
	complex_lotus *alpha, complex_lotus *a, integer *lda, complex_lotus *beta, complex_lotus *c__, 
	 integer *ldc);

/* Subroutine */ int ctbmv_(char *uplo, char *trans, char *diag, integer *n, 
	integer *k, complex_lotus *a, integer *lda, complex_lotus *x, integer *incx);

/* Subroutine */ int ctbsv_(char *uplo, char *trans, char *diag, integer *n, 
	integer *k, complex_lotus *a, integer *lda, complex_lotus *x, integer *incx);

/* Subroutine */ int ctpmv_(char *uplo, char *trans, char *diag, integer *n, 
	complex_lotus *ap, complex_lotus *x, integer *incx);

/* Subroutine */ int ctpsv_(char *uplo, char *trans, char *diag, integer *n, 
	complex_lotus *ap, complex_lotus *x, integer *incx);

/* Subroutine */ int ctrmm_(char *side, char *uplo, char *transa, char *diag, 
	integer *m, integer *n, complex_lotus *alpha, complex_lotus *a, integer *lda, 
	complex_lotus *b, integer *ldb);

/* Subroutine */ int ctrmv_(char *uplo, char *trans, char *diag, integer *n, 
	complex_lotus *a, integer *lda, complex_lotus *x, integer *incx);

/* Subroutine */ int ctrsm_(char *side, char *uplo, char *transa, char *diag, 
	integer *m, integer *n, complex_lotus *alpha, complex_lotus *a, integer *lda, 
	complex_lotus *b, integer *ldb);

/* Subroutine */ int ctrsv_(char *uplo, char *trans, char *diag, integer *n, 
	complex_lotus *a, integer *lda, complex_lotus *x, integer *incx);

doublereal_lotus dasum_(integer *n, doublereal_lotus *dx, integer *incx);

/* Subroutine */ int daxpy_(integer *n, doublereal_lotus *da, doublereal_lotus *dx, 
	integer *incx, doublereal_lotus *dy, integer *incy);

doublereal_lotus dcabs1_(doublecomplex_lotus *z__);

/* Subroutine */ int dcopy_(integer *n, doublereal_lotus *dx, integer *incx, 
	doublereal_lotus *dy, integer *incy);

doublereal_lotus ddot_(integer *n, doublereal_lotus *dx, integer *incx, doublereal_lotus *dy, 
	integer *incy);

/* Subroutine */ int dgbmv_(char *trans, integer *m, integer *n, integer *kl, 
	integer *ku, doublereal_lotus *alpha, doublereal_lotus *a, integer *lda, 
	doublereal_lotus *x, integer *incx, doublereal_lotus *beta, doublereal_lotus *y, 
	integer *incy);

/* Subroutine */ int dgemm_(char *transa, char *transb, integer *m, integer *
	n, integer *k, doublereal_lotus *alpha, doublereal_lotus *a, integer *lda, 
	doublereal_lotus *b, integer *ldb, doublereal_lotus *beta, doublereal_lotus *c__, 
	integer *ldc);

/* Subroutine */ int dgemv_(char *trans, integer *m, integer *n, doublereal_lotus *
	alpha, doublereal_lotus *a, integer *lda, doublereal_lotus *x, integer *incx, 
	doublereal_lotus *beta, doublereal_lotus *y, integer *incy);

/* Subroutine */ int dger_(integer *m, integer *n, doublereal_lotus *alpha, 
	doublereal_lotus *x, integer *incx, doublereal_lotus *y, integer *incy, 
	doublereal_lotus *a, integer *lda);

doublereal_lotus dnrm2_(integer *n, doublereal_lotus *x, integer *incx);

/* Subroutine */ int drot_(integer *n, doublereal_lotus *dx, integer *incx, 
	doublereal_lotus *dy, integer *incy, doublereal_lotus *c__, doublereal_lotus *s);

/* Subroutine */ int drotg_(doublereal_lotus *da, doublereal_lotus *db, doublereal_lotus *c__, 
	doublereal_lotus *s);

/* Subroutine */ int drotm_(integer *n, doublereal_lotus *dx, integer *incx, 
	doublereal_lotus *dy, integer *incy, doublereal_lotus *dparam);

/* Subroutine */ int drotmg_(doublereal_lotus *dd1, doublereal_lotus *dd2, doublereal_lotus *
	dx1, doublereal_lotus *dy1, doublereal_lotus *dparam);

/* Subroutine */ int dsbmv_(char *uplo, integer *n, integer *k, doublereal_lotus *
	alpha, doublereal_lotus *a, integer *lda, doublereal_lotus *x, integer *incx, 
	doublereal_lotus *beta, doublereal_lotus *y, integer *incy);

/* Subroutine */ int dscal_(integer *n, doublereal_lotus *da, doublereal_lotus *dx, 
	integer *incx);

doublereal_lotus dsdot_(integer *n, real_lotus *sx, integer *incx, real_lotus *sy, integer *
	incy);

/* Subroutine */ int dspmv_(char *uplo, integer *n, doublereal_lotus *alpha, 
	doublereal_lotus *ap, doublereal_lotus *x, integer *incx, doublereal_lotus *beta, 
	doublereal_lotus *y, integer *incy);

/* Subroutine */ int dspr_(char *uplo, integer *n, doublereal_lotus *alpha, 
	doublereal_lotus *x, integer *incx, doublereal_lotus *ap);

/* Subroutine */ int dspr2_(char *uplo, integer *n, doublereal_lotus *alpha, 
	doublereal_lotus *x, integer *incx, doublereal_lotus *y, integer *incy, 
	doublereal_lotus *ap);

/* Subroutine */ int dswap_(integer *n, doublereal_lotus *dx, integer *incx, 
	doublereal_lotus *dy, integer *incy);

/* Subroutine */ int dsymm_(char *side, char *uplo, integer *m, integer *n, 
	doublereal_lotus *alpha, doublereal_lotus *a, integer *lda, doublereal_lotus *b, 
	integer *ldb, doublereal_lotus *beta, doublereal_lotus *c__, integer *ldc);

/* Subroutine */ int dsymv_(char *uplo, integer *n, doublereal_lotus *alpha, 
	doublereal_lotus *a, integer *lda, doublereal_lotus *x, integer *incx, doublereal_lotus 
	*beta, doublereal_lotus *y, integer *incy);

/* Subroutine */ int dsyr_(char *uplo, integer *n, doublereal_lotus *alpha, 
	doublereal_lotus *x, integer *incx, doublereal_lotus *a, integer *lda);

/* Subroutine */ int dsyr2_(char *uplo, integer *n, doublereal_lotus *alpha, 
	doublereal_lotus *x, integer *incx, doublereal_lotus *y, integer *incy, 
	doublereal_lotus *a, integer *lda);

/* Subroutine */ int dsyr2k_(char *uplo, char *trans, integer *n, integer *k, 
	doublereal_lotus *alpha, doublereal_lotus *a, integer *lda, doublereal_lotus *b, 
	integer *ldb, doublereal_lotus *beta, doublereal_lotus *c__, integer *ldc);

/* Subroutine */ int dsyrk_(char *uplo, char *trans, integer *n, integer *k, 
	doublereal_lotus *alpha, doublereal_lotus *a, integer *lda, doublereal_lotus *beta, 
	doublereal_lotus *c__, integer *ldc);

/* Subroutine */ int dtbmv_(char *uplo, char *trans, char *diag, integer *n, 
	integer *k, doublereal_lotus *a, integer *lda, doublereal_lotus *x, integer *incx);

/* Subroutine */ int dtbsv_(char *uplo, char *trans, char *diag, integer *n, 
	integer *k, doublereal_lotus *a, integer *lda, doublereal_lotus *x, integer *incx);

/* Subroutine */ int dtpmv_(char *uplo, char *trans, char *diag, integer *n, 
	doublereal_lotus *ap, doublereal_lotus *x, integer *incx);

/* Subroutine */ int dtpsv_(char *uplo, char *trans, char *diag, integer *n, 
	doublereal_lotus *ap, doublereal_lotus *x, integer *incx);

/* Subroutine */ int dtrmm_(char *side, char *uplo, char *transa, char *diag, 
	integer *m, integer *n, doublereal_lotus *alpha, doublereal_lotus *a, integer *
	lda, doublereal_lotus *b, integer *ldb);

/* Subroutine */ int dtrmv_(char *uplo, char *trans, char *diag, integer *n, 
	doublereal_lotus *a, integer *lda, doublereal_lotus *x, integer *incx);

/* Subroutine */ int dtrsm_(char *side, char *uplo, char *transa, char *diag, 
	integer *m, integer *n, doublereal_lotus *alpha, doublereal_lotus *a, integer *
	lda, doublereal_lotus *b, integer *ldb);

/* Subroutine */ int dtrsv_(char *uplo, char *trans, char *diag, integer *n, 
	doublereal_lotus *a, integer *lda, doublereal_lotus *x, integer *incx);

doublereal_lotus dzasum_(integer *n, doublecomplex_lotus *zx, integer *incx);

doublereal_lotus dznrm2_(integer *n, doublecomplex_lotus *x, integer *incx);

integer icamax_(integer *n, complex_lotus *cx, integer *incx);

integer idamax_(integer *n, doublereal_lotus *dx, integer *incx);

integer isamax_(integer *n, real_lotus *sx, integer *incx);

integer izamax_(integer *n, doublecomplex_lotus *zx, integer *incx);

logical lsame_(char *ca, char *cb);

doublereal_lotus sasum_(integer *n, real_lotus *sx, integer *incx);

/* Subroutine */ int saxpy_(integer *n, real_lotus *sa, real_lotus *sx, integer *incx, 
	real_lotus *sy, integer *incy);

doublereal_lotus scabs1_(complex_lotus *z__);

doublereal_lotus scasum_(integer *n, complex_lotus *cx, integer *incx);

doublereal_lotus scnrm2_(integer *n, complex_lotus *x, integer *incx);

/* Subroutine */ int scopy_(integer *n, real_lotus *sx, integer *incx, real_lotus *sy, 
	integer *incy);

doublereal_lotus sdot_(integer *n, real_lotus *sx, integer *incx, real_lotus *sy, integer *incy);

doublereal_lotus sdsdot_(integer *n, real_lotus *sb, real_lotus *sx, integer *incx, real_lotus *sy, 
	integer *incy);

/* Subroutine */ int sgbmv_(char *trans, integer *m, integer *n, integer *kl, 
	integer *ku, real_lotus *alpha, real_lotus *a, integer *lda, real_lotus *x, integer *
	incx, real_lotus *beta, real_lotus *y, integer *incy);

/* Subroutine */ int sgemm_(char *transa, char *transb, integer *m, integer *
	n, integer *k, real_lotus *alpha, real_lotus *a, integer *lda, real_lotus *b, integer *
	ldb, real_lotus *beta, real_lotus *c__, integer *ldc);

/* Subroutine */ int sgemv_(char *trans, integer *m, integer *n, real_lotus *alpha, 
	real_lotus *a, integer *lda, real_lotus *x, integer *incx, real_lotus *beta, real_lotus *y, 
	integer *incy);

/* Subroutine */ int sger_(integer *m, integer *n, real_lotus *alpha, real_lotus *x, 
	integer *incx, real_lotus *y, integer *incy, real_lotus *a, integer *lda);

doublereal_lotus snrm2_(integer *n, real_lotus *x, integer *incx);

/* Subroutine */ int srot_(integer *n, real_lotus *sx, integer *incx, real_lotus *sy, 
	integer *incy, real_lotus *c__, real_lotus *s);

/* Subroutine */ int srotg_(real_lotus *sa, real_lotus *sb, real_lotus *c__, real_lotus *s);

/* Subroutine */ int srotm_(integer *n, real_lotus *sx, integer *incx, real_lotus *sy, 
	integer *incy, real_lotus *sparam);

/* Subroutine */ int srotmg_(real_lotus *sd1, real_lotus *sd2, real_lotus *sx1, real_lotus *sy1, real_lotus 
	*sparam);

/* Subroutine */ int ssbmv_(char *uplo, integer *n, integer *k, real_lotus *alpha, 
	real_lotus *a, integer *lda, real_lotus *x, integer *incx, real_lotus *beta, real_lotus *y, 
	integer *incy);

/* Subroutine */ int sscal_(integer *n, real_lotus *sa, real_lotus *sx, integer *incx);

/* Subroutine */ int sspmv_(char *uplo, integer *n, real_lotus *alpha, real_lotus *ap, 
	real_lotus *x, integer *incx, real_lotus *beta, real_lotus *y, integer *incy);

/* Subroutine */ int sspr_(char *uplo, integer *n, real_lotus *alpha, real_lotus *x, 
	integer *incx, real_lotus *ap);

/* Subroutine */ int sspr2_(char *uplo, integer *n, real_lotus *alpha, real_lotus *x, 
	integer *incx, real_lotus *y, integer *incy, real_lotus *ap);

/* Subroutine */ int sswap_(integer *n, real_lotus *sx, integer *incx, real_lotus *sy, 
	integer *incy);

/* Subroutine */ int ssymm_(char *side, char *uplo, integer *m, integer *n, 
	real_lotus *alpha, real_lotus *a, integer *lda, real_lotus *b, integer *ldb, real_lotus *beta, 
	 real_lotus *c__, integer *ldc);

/* Subroutine */ int ssymv_(char *uplo, integer *n, real_lotus *alpha, real_lotus *a, 
	integer *lda, real_lotus *x, integer *incx, real_lotus *beta, real_lotus *y, integer *
	incy);

/* Subroutine */ int ssyr_(char *uplo, integer *n, real_lotus *alpha, real_lotus *x, 
	integer *incx, real_lotus *a, integer *lda);

/* Subroutine */ int ssyr2_(char *uplo, integer *n, real_lotus *alpha, real_lotus *x, 
	integer *incx, real_lotus *y, integer *incy, real_lotus *a, integer *lda);

/* Subroutine */ int ssyr2k_(char *uplo, char *trans, integer *n, integer *k, 
	real_lotus *alpha, real_lotus *a, integer *lda, real_lotus *b, integer *ldb, real_lotus *beta, 
	 real_lotus *c__, integer *ldc);

/* Subroutine */ int ssyrk_(char *uplo, char *trans, integer *n, integer *k, 
	real_lotus *alpha, real_lotus *a, integer *lda, real_lotus *beta, real_lotus *c__, integer *
	ldc);

/* Subroutine */ int stbmv_(char *uplo, char *trans, char *diag, integer *n, 
	integer *k, real_lotus *a, integer *lda, real_lotus *x, integer *incx);

/* Subroutine */ int stbsv_(char *uplo, char *trans, char *diag, integer *n, 
	integer *k, real_lotus *a, integer *lda, real_lotus *x, integer *incx);

/* Subroutine */ int stpmv_(char *uplo, char *trans, char *diag, integer *n, 
	real_lotus *ap, real_lotus *x, integer *incx);

/* Subroutine */ int stpsv_(char *uplo, char *trans, char *diag, integer *n, 
	real_lotus *ap, real_lotus *x, integer *incx);

/* Subroutine */ int strmm_(char *side, char *uplo, char *transa, char *diag, 
	integer *m, integer *n, real_lotus *alpha, real_lotus *a, integer *lda, real_lotus *b, 
	integer *ldb);

/* Subroutine */ int strmv_(char *uplo, char *trans, char *diag, integer *n, 
	real_lotus *a, integer *lda, real_lotus *x, integer *incx);

/* Subroutine */ int strsm_(char *side, char *uplo, char *transa, char *diag, 
	integer *m, integer *n, real_lotus *alpha, real_lotus *a, integer *lda, real_lotus *b, 
	integer *ldb);

/* Subroutine */ int strsv_(char *uplo, char *trans, char *diag, integer *n, 
	real_lotus *a, integer *lda, real_lotus *x, integer *incx);

/* Subroutine */ int xerbla_(char *srname, integer *info);

/* Subroutine */ int xerbla_array__(char *srname_array__, integer *
	srname_len__, integer *info, ftnlen srname_array_len);

/* Subroutine */ int zaxpy_(integer *n, doublecomplex_lotus *za, doublecomplex_lotus *zx, 
	integer *incx, doublecomplex_lotus *zy, integer *incy);

/* Subroutine */ int zcopy_(integer *n, doublecomplex_lotus *zx, integer *incx, 
	doublecomplex_lotus *zy, integer *incy);

/* Double Complex */ void zdotc_(doublecomplex_lotus * ret_val, integer *n, 
	doublecomplex_lotus *zx, integer *incx, doublecomplex_lotus *zy, integer *incy);

/* Double Complex */ void zdotu_(doublecomplex_lotus * ret_val, integer *n, 
	doublecomplex_lotus *zx, integer *incx, doublecomplex_lotus *zy, integer *incy);

/* Subroutine */ int zdrot_(integer *n, doublecomplex_lotus *cx, integer *incx, 
	doublecomplex_lotus *cy, integer *incy, doublereal_lotus *c__, doublereal_lotus *s);

/* Subroutine */ int zdscal_(integer *n, doublereal_lotus *da, doublecomplex_lotus *zx, 
	integer *incx);

/* Subroutine */ int zgbmv_(char *trans, integer *m, integer *n, integer *kl, 
	integer *ku, doublecomplex_lotus *alpha, doublecomplex_lotus *a, integer *lda, 
	doublecomplex_lotus *x, integer *incx, doublecomplex_lotus *beta, doublecomplex_lotus *
	y, integer *incy);

/* Subroutine */ int zgemm_(char *transa, char *transb, integer *m, integer *
	n, integer *k, doublecomplex_lotus *alpha, doublecomplex_lotus *a, integer *lda, 
	doublecomplex_lotus *b, integer *ldb, doublecomplex_lotus *beta, doublecomplex_lotus *
	c__, integer *ldc);

/* Subroutine */ int zgemv_(char *trans, integer *m, integer *n, 
	doublecomplex_lotus *alpha, doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *
	x, integer *incx, doublecomplex_lotus *beta, doublecomplex_lotus *y, integer *
	incy);

/* Subroutine */ int zgerc_(integer *m, integer *n, doublecomplex_lotus *alpha, 
	doublecomplex_lotus *x, integer *incx, doublecomplex_lotus *y, integer *incy, 
	doublecomplex_lotus *a, integer *lda);

/* Subroutine */ int zgeru_(integer *m, integer *n, doublecomplex_lotus *alpha, 
	doublecomplex_lotus *x, integer *incx, doublecomplex_lotus *y, integer *incy, 
	doublecomplex_lotus *a, integer *lda);

/* Subroutine */ int zhbmv_(char *uplo, integer *n, integer *k, doublecomplex_lotus 
	*alpha, doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *x, integer *
	incx, doublecomplex_lotus *beta, doublecomplex_lotus *y, integer *incy);

/* Subroutine */ int zhemm_(char *side, char *uplo, integer *m, integer *n, 
	doublecomplex_lotus *alpha, doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *
	b, integer *ldb, doublecomplex_lotus *beta, doublecomplex_lotus *c__, integer *
	ldc);

/* Subroutine */ int zhemv_(char *uplo, integer *n, doublecomplex_lotus *alpha, 
	doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *x, integer *incx, 
	doublecomplex_lotus *beta, doublecomplex_lotus *y, integer *incy);

/* Subroutine */ int zher_(char *uplo, integer *n, doublereal_lotus *alpha, 
	doublecomplex_lotus *x, integer *incx, doublecomplex_lotus *a, integer *lda);

/* Subroutine */ int zher2_(char *uplo, integer *n, doublecomplex_lotus *alpha, 
	doublecomplex_lotus *x, integer *incx, doublecomplex_lotus *y, integer *incy, 
	doublecomplex_lotus *a, integer *lda);

/* Subroutine */ int zher2k_(char *uplo, char *trans, integer *n, integer *k, 
	doublecomplex_lotus *alpha, doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *
	b, integer *ldb, doublereal_lotus *beta, doublecomplex_lotus *c__, integer *ldc);

/* Subroutine */ int zherk_(char *uplo, char *trans, integer *n, integer *k, 
	doublereal_lotus *alpha, doublecomplex_lotus *a, integer *lda, doublereal_lotus *beta, 
	doublecomplex_lotus *c__, integer *ldc);

/* Subroutine */ int zhpmv_(char *uplo, integer *n, doublecomplex_lotus *alpha, 
	doublecomplex_lotus *ap, doublecomplex_lotus *x, integer *incx, doublecomplex_lotus *
	beta, doublecomplex_lotus *y, integer *incy);

/* Subroutine */ int zhpr_(char *uplo, integer *n, doublereal_lotus *alpha, 
	doublecomplex_lotus *x, integer *incx, doublecomplex_lotus *ap);

/* Subroutine */ int zhpr2_(char *uplo, integer *n, doublecomplex_lotus *alpha, 
	doublecomplex_lotus *x, integer *incx, doublecomplex_lotus *y, integer *incy, 
	doublecomplex_lotus *ap);

/* Subroutine */ int zrotg_(doublecomplex_lotus *ca, doublecomplex_lotus *cb, doublereal_lotus *
	c__, doublecomplex_lotus *s);

/* Subroutine */ int zscal_(integer *n, doublecomplex_lotus *za, doublecomplex_lotus *zx, 
	integer *incx);

/* Subroutine */ int zswap_(integer *n, doublecomplex_lotus *zx, integer *incx, 
	doublecomplex_lotus *zy, integer *incy);

/* Subroutine */ int zsymm_(char *side, char *uplo, integer *m, integer *n, 
	doublecomplex_lotus *alpha, doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *
	b, integer *ldb, doublecomplex_lotus *beta, doublecomplex_lotus *c__, integer *
	ldc);

/* Subroutine */ int zsyr2k_(char *uplo, char *trans, integer *n, integer *k, 
	doublecomplex_lotus *alpha, doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *
	b, integer *ldb, doublecomplex_lotus *beta, doublecomplex_lotus *c__, integer *
	ldc);

/* Subroutine */ int zsyrk_(char *uplo, char *trans, integer *n, integer *k, 
	doublecomplex_lotus *alpha, doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *
	beta, doublecomplex_lotus *c__, integer *ldc);

/* Subroutine */ int ztbmv_(char *uplo, char *trans, char *diag, integer *n, 
	integer *k, doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *x, integer 
	*incx);

/* Subroutine */ int ztbsv_(char *uplo, char *trans, char *diag, integer *n, 
	integer *k, doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *x, integer 
	*incx);

/* Subroutine */ int ztpmv_(char *uplo, char *trans, char *diag, integer *n, 
	doublecomplex_lotus *ap, doublecomplex_lotus *x, integer *incx);

/* Subroutine */ int ztpsv_(char *uplo, char *trans, char *diag, integer *n, 
	doublecomplex_lotus *ap, doublecomplex_lotus *x, integer *incx);

/* Subroutine */ int ztrmm_(char *side, char *uplo, char *transa, char *diag, 
	integer *m, integer *n, doublecomplex_lotus *alpha, doublecomplex_lotus *a, 
	integer *lda, doublecomplex_lotus *b, integer *ldb);

/* Subroutine */ int ztrmv_(char *uplo, char *trans, char *diag, integer *n, 
	doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *x, integer *incx);

/* Subroutine */ int ztrsm_(char *side, char *uplo, char *transa, char *diag, 
	integer *m, integer *n, doublecomplex_lotus *alpha, doublecomplex_lotus *a, 
	integer *lda, doublecomplex_lotus *b, integer *ldb);

/* Subroutine */ int ztrsv_(char *uplo, char *trans, char *diag, integer *n, 
	doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *x, integer *incx);

/* Subroutine */ int cbdsqr_(char *uplo, integer *n, integer *ncvt, integer *
	nru, integer *ncc, real_lotus *d__, real_lotus *e, complex_lotus *vt, integer *ldvt, 
	complex_lotus *u, integer *ldu, complex_lotus *c__, integer *ldc, real_lotus *rwork, 
	integer *info);

/* Subroutine */ int cgbbrd_(char *vect, integer *m, integer *n, integer *ncc, 
	 integer *kl, integer *ku, complex_lotus *ab, integer *ldab, real_lotus *d__, 
	real_lotus *e, complex_lotus *q, integer *ldq, complex_lotus *pt, integer *ldpt, 
	complex_lotus *c__, integer *ldc, complex_lotus *work, real_lotus *rwork, integer *info);

/* Subroutine */ int cgbcon_(char *norm, integer *n, integer *kl, integer *ku, 
	 complex_lotus *ab, integer *ldab, integer *ipiv, real_lotus *anorm, real_lotus *rcond, 
	complex_lotus *work, real_lotus *rwork, integer *info);

/* Subroutine */ int cgbequ_(integer *m, integer *n, integer *kl, integer *ku, 
	 complex_lotus *ab, integer *ldab, real_lotus *r__, real_lotus *c__, real_lotus *rowcnd, real_lotus 
	*colcnd, real_lotus *amax, integer *info);

/* Subroutine */ int cgbequb_(integer *m, integer *n, integer *kl, integer *
	ku, complex_lotus *ab, integer *ldab, real_lotus *r__, real_lotus *c__, real_lotus *rowcnd, 
	real_lotus *colcnd, real_lotus *amax, integer *info);

/* Subroutine */ int cgbrfs_(char *trans, integer *n, integer *kl, integer *
	ku, integer *nrhs, complex_lotus *ab, integer *ldab, complex_lotus *afb, integer *
	ldafb, integer *ipiv, complex_lotus *b, integer *ldb, complex_lotus *x, integer *
	ldx, real_lotus *ferr, real_lotus *berr, complex_lotus *work, real_lotus *rwork, integer *
	info);

/* Subroutine */ int cgbrfsx_(char *trans, char *equed, integer *n, integer *
	kl, integer *ku, integer *nrhs, complex_lotus *ab, integer *ldab, complex_lotus *
	afb, integer *ldafb, integer *ipiv, real_lotus *r__, real_lotus *c__, complex_lotus *b, 
	integer *ldb, complex_lotus *x, integer *ldx, real_lotus *rcond, real_lotus *berr, 
	integer *n_err_bnds__, real_lotus *err_bnds_norm__, real_lotus *err_bnds_comp__, 
	integer *nparams, real_lotus *params, complex_lotus *work, real_lotus *rwork, integer *
	info);

/* Subroutine */ int cgbsv_(integer *n, integer *kl, integer *ku, integer *
	nrhs, complex_lotus *ab, integer *ldab, integer *ipiv, complex_lotus *b, integer *
	ldb, integer *info);

/* Subroutine */ int cgbsvx_(char *fact, char *trans, integer *n, integer *kl, 
	 integer *ku, integer *nrhs, complex_lotus *ab, integer *ldab, complex_lotus *afb, 
	 integer *ldafb, integer *ipiv, char *equed, real_lotus *r__, real_lotus *c__, 
	complex_lotus *b, integer *ldb, complex_lotus *x, integer *ldx, real_lotus *rcond, real_lotus 
	*ferr, real_lotus *berr, complex_lotus *work, real_lotus *rwork, integer *info);

/* Subroutine */ int cgbsvxx_(char *fact, char *trans, integer *n, integer *
	kl, integer *ku, integer *nrhs, complex_lotus *ab, integer *ldab, complex_lotus *
	afb, integer *ldafb, integer *ipiv, char *equed, real_lotus *r__, real_lotus *c__, 
	 complex_lotus *b, integer *ldb, complex_lotus *x, integer *ldx, real_lotus *rcond, 
	real_lotus *rpvgrw, real_lotus *berr, integer *n_err_bnds__, real_lotus *
	err_bnds_norm__, real_lotus *err_bnds_comp__, integer *nparams, real_lotus *
	params, complex_lotus *work, real_lotus *rwork, integer *info);

/* Subroutine */ int cgbtf2_(integer *m, integer *n, integer *kl, integer *ku, 
	 complex_lotus *ab, integer *ldab, integer *ipiv, integer *info);

/* Subroutine */ int cgbtrf_(integer *m, integer *n, integer *kl, integer *ku, 
	 complex_lotus *ab, integer *ldab, integer *ipiv, integer *info);

/* Subroutine */ int cgbtrs_(char *trans, integer *n, integer *kl, integer *
	ku, integer *nrhs, complex_lotus *ab, integer *ldab, integer *ipiv, complex_lotus 
	*b, integer *ldb, integer *info);

/* Subroutine */ int cgebak_(char *job, char *side, integer *n, integer *ilo, 
	integer *ihi, real_lotus *scale, integer *m, complex_lotus *v, integer *ldv, 
	integer *info);

/* Subroutine */ int cgebal_(char *job, integer *n, complex_lotus *a, integer *lda, 
	integer *ilo, integer *ihi, real_lotus *scale, integer *info);

/* Subroutine */ int cgebd2_(integer *m, integer *n, complex_lotus *a, integer *lda, 
	 real_lotus *d__, real_lotus *e, complex_lotus *tauq, complex_lotus *taup, complex_lotus *work, 
	integer *info);

/* Subroutine */ int cgebrd_(integer *m, integer *n, complex_lotus *a, integer *lda, 
	 real_lotus *d__, real_lotus *e, complex_lotus *tauq, complex_lotus *taup, complex_lotus *work, 
	integer *lwork, integer *info);

/* Subroutine */ int cgecon_(char *norm, integer *n, complex_lotus *a, integer *lda, 
	 real_lotus *anorm, real_lotus *rcond, complex_lotus *work, real_lotus *rwork, integer *info);

/* Subroutine */ int cgeequ_(integer *m, integer *n, complex_lotus *a, integer *lda, 
	 real_lotus *r__, real_lotus *c__, real_lotus *rowcnd, real_lotus *colcnd, real_lotus *amax, 
	integer *info);

/* Subroutine */ int cgeequb_(integer *m, integer *n, complex_lotus *a, integer *
	lda, real_lotus *r__, real_lotus *c__, real_lotus *rowcnd, real_lotus *colcnd, real_lotus *amax, 
	integer *info);

/* Subroutine */ int cgees_(char *jobvs, char *sort, L_fp select, integer *n, 
	complex_lotus *a, integer *lda, integer *sdim, complex_lotus *w, complex_lotus *vs, 
	integer *ldvs, complex_lotus *work, integer *lwork, real_lotus *rwork, logical *
	bwork, integer *info);

/* Subroutine */ int cgeesx_(char *jobvs, char *sort, L_fp select, char *
	sense, integer *n, complex_lotus *a, integer *lda, integer *sdim, complex_lotus *
	w, complex_lotus *vs, integer *ldvs, real_lotus *rconde, real_lotus *rcondv, complex_lotus *
	work, integer *lwork, real_lotus *rwork, logical *bwork, integer *info);

/* Subroutine */ int cgeev_(char *jobvl, char *jobvr, integer *n, complex_lotus *a, 
	integer *lda, complex_lotus *w, complex_lotus *vl, integer *ldvl, complex_lotus *vr, 
	integer *ldvr, complex_lotus *work, integer *lwork, real_lotus *rwork, integer *
	info);

/* Subroutine */ int cgeevx_(char *balanc, char *jobvl, char *jobvr, char *
	sense, integer *n, complex_lotus *a, integer *lda, complex_lotus *w, complex_lotus *vl, 
	integer *ldvl, complex_lotus *vr, integer *ldvr, integer *ilo, integer *ihi, 
	 real_lotus *scale, real_lotus *abnrm, real_lotus *rconde, real_lotus *rcondv, complex_lotus *work, 
	integer *lwork, real_lotus *rwork, integer *info);

/* Subroutine */ int cgegs_(char *jobvsl, char *jobvsr, integer *n, complex_lotus *
	a, integer *lda, complex_lotus *b, integer *ldb, complex_lotus *alpha, complex_lotus *
	beta, complex_lotus *vsl, integer *ldvsl, complex_lotus *vsr, integer *ldvsr, 
	complex_lotus *work, integer *lwork, real_lotus *rwork, integer *info);

/* Subroutine */ int cgegv_(char *jobvl, char *jobvr, integer *n, complex_lotus *a, 
	integer *lda, complex_lotus *b, integer *ldb, complex_lotus *alpha, complex_lotus *beta, 
	 complex_lotus *vl, integer *ldvl, complex_lotus *vr, integer *ldvr, complex_lotus *
	work, integer *lwork, real_lotus *rwork, integer *info);

/* Subroutine */ int cgehd2_(integer *n, integer *ilo, integer *ihi, complex_lotus *
	a, integer *lda, complex_lotus *tau, complex_lotus *work, integer *info);

/* Subroutine */ int cgehrd_(integer *n, integer *ilo, integer *ihi, complex_lotus *
	a, integer *lda, complex_lotus *tau, complex_lotus *work, integer *lwork, integer 
	*info);

/* Subroutine */ int cgelq2_(integer *m, integer *n, complex_lotus *a, integer *lda, 
	 complex_lotus *tau, complex_lotus *work, integer *info);

/* Subroutine */ int cgelqf_(integer *m, integer *n, complex_lotus *a, integer *lda, 
	 complex_lotus *tau, complex_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int cgels_(char *trans, integer *m, integer *n, integer *
	nrhs, complex_lotus *a, integer *lda, complex_lotus *b, integer *ldb, complex_lotus *
	work, integer *lwork, integer *info);

/* Subroutine */ int cgelsd_(integer *m, integer *n, integer *nrhs, complex_lotus *
	a, integer *lda, complex_lotus *b, integer *ldb, real_lotus *s, real_lotus *rcond, 
	integer *rank, complex_lotus *work, integer *lwork, real_lotus *rwork, integer *
	iwork, integer *info);

/* Subroutine */ int cgelss_(integer *m, integer *n, integer *nrhs, complex_lotus *
	a, integer *lda, complex_lotus *b, integer *ldb, real_lotus *s, real_lotus *rcond, 
	integer *rank, complex_lotus *work, integer *lwork, real_lotus *rwork, integer *
	info);

/* Subroutine */ int cgelsx_(integer *m, integer *n, integer *nrhs, complex_lotus *
	a, integer *lda, complex_lotus *b, integer *ldb, integer *jpvt, real_lotus *rcond, 
	 integer *rank, complex_lotus *work, real_lotus *rwork, integer *info);

/* Subroutine */ int cgelsy_(integer *m, integer *n, integer *nrhs, complex_lotus *
	a, integer *lda, complex_lotus *b, integer *ldb, integer *jpvt, real_lotus *rcond, 
	 integer *rank, complex_lotus *work, integer *lwork, real_lotus *rwork, integer *
	info);

/* Subroutine */ int cgeql2_(integer *m, integer *n, complex_lotus *a, integer *lda, 
	 complex_lotus *tau, complex_lotus *work, integer *info);

/* Subroutine */ int cgeqlf_(integer *m, integer *n, complex_lotus *a, integer *lda, 
	 complex_lotus *tau, complex_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int cgeqp3_(integer *m, integer *n, complex_lotus *a, integer *lda, 
	 integer *jpvt, complex_lotus *tau, complex_lotus *work, integer *lwork, real_lotus *
	rwork, integer *info);

/* Subroutine */ int cgeqpf_(integer *m, integer *n, complex_lotus *a, integer *lda, 
	 integer *jpvt, complex_lotus *tau, complex_lotus *work, real_lotus *rwork, integer *
	info);

/* Subroutine */ int cgeqr2_(integer *m, integer *n, complex_lotus *a, integer *lda, 
	 complex_lotus *tau, complex_lotus *work, integer *info);

/* Subroutine */ int cgeqrf_(integer *m, integer *n, complex_lotus *a, integer *lda, 
	 complex_lotus *tau, complex_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int cgerfs_(char *trans, integer *n, integer *nrhs, complex_lotus *
	a, integer *lda, complex_lotus *af, integer *ldaf, integer *ipiv, complex_lotus *
	b, integer *ldb, complex_lotus *x, integer *ldx, real_lotus *ferr, real_lotus *berr, 
	complex_lotus *work, real_lotus *rwork, integer *info);

/* Subroutine */ int cgerfsx_(char *trans, char *equed, integer *n, integer *
	nrhs, complex_lotus *a, integer *lda, complex_lotus *af, integer *ldaf, integer *
	ipiv, real_lotus *r__, real_lotus *c__, complex_lotus *b, integer *ldb, complex_lotus *x, 
	integer *ldx, real_lotus *rcond, real_lotus *berr, integer *n_err_bnds__, real_lotus *
	err_bnds_norm__, real_lotus *err_bnds_comp__, integer *nparams, real_lotus *
	params, complex_lotus *work, real_lotus *rwork, integer *info);

/* Subroutine */ int cgerq2_(integer *m, integer *n, complex_lotus *a, integer *lda, 
	 complex_lotus *tau, complex_lotus *work, integer *info);

/* Subroutine */ int cgerqf_(integer *m, integer *n, complex_lotus *a, integer *lda, 
	 complex_lotus *tau, complex_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int cgesc2_(integer *n, complex_lotus *a, integer *lda, complex_lotus *
	rhs, integer *ipiv, integer *jpiv, real_lotus *scale);

/* Subroutine */ int cgesdd_(char *jobz, integer *m, integer *n, complex_lotus *a, 
	integer *lda, real_lotus *s, complex_lotus *u, integer *ldu, complex_lotus *vt, integer 
	*ldvt, complex_lotus *work, integer *lwork, real_lotus *rwork, integer *iwork, 
	integer *info);

/* Subroutine */ int cgesv_(integer *n, integer *nrhs, complex_lotus *a, integer *
	lda, integer *ipiv, complex_lotus *b, integer *ldb, integer *info);

/* Subroutine */ int cgesvd_(char *jobu, char *jobvt, integer *m, integer *n, 
	complex_lotus *a, integer *lda, real_lotus *s, complex_lotus *u, integer *ldu, complex_lotus *
	vt, integer *ldvt, complex_lotus *work, integer *lwork, real_lotus *rwork, 
	integer *info);

/* Subroutine */ int cgesvx_(char *fact, char *trans, integer *n, integer *
	nrhs, complex_lotus *a, integer *lda, complex_lotus *af, integer *ldaf, integer *
	ipiv, char *equed, real_lotus *r__, real_lotus *c__, complex_lotus *b, integer *ldb, 
	complex_lotus *x, integer *ldx, real_lotus *rcond, real_lotus *ferr, real_lotus *berr, 
	complex_lotus *work, real_lotus *rwork, integer *info);

/* Subroutine */ int cgesvxx_(char *fact, char *trans, integer *n, integer *
	nrhs, complex_lotus *a, integer *lda, complex_lotus *af, integer *ldaf, integer *
	ipiv, char *equed, real_lotus *r__, real_lotus *c__, complex_lotus *b, integer *ldb, 
	complex_lotus *x, integer *ldx, real_lotus *rcond, real_lotus *rpvgrw, real_lotus *berr, 
	integer *n_err_bnds__, real_lotus *err_bnds_norm__, real_lotus *err_bnds_comp__, 
	integer *nparams, real_lotus *params, complex_lotus *work, real_lotus *rwork, integer *
	info);

/* Subroutine */ int cgetc2_(integer *n, complex_lotus *a, integer *lda, integer *
	ipiv, integer *jpiv, integer *info);

/* Subroutine */ int cgetf2_(integer *m, integer *n, complex_lotus *a, integer *lda, 
	 integer *ipiv, integer *info);

/* Subroutine */ int cgetrf_(integer *m, integer *n, complex_lotus *a, integer *lda, 
	 integer *ipiv, integer *info);

/* Subroutine */ int cgetri_(integer *n, complex_lotus *a, integer *lda, integer *
	ipiv, complex_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int cgetrs_(char *trans, integer *n, integer *nrhs, complex_lotus *
	a, integer *lda, integer *ipiv, complex_lotus *b, integer *ldb, integer *
	info);

/* Subroutine */ int cggbak_(char *job, char *side, integer *n, integer *ilo, 
	integer *ihi, real_lotus *lscale, real_lotus *rscale, integer *m, complex_lotus *v, 
	integer *ldv, integer *info);

/* Subroutine */ int cggbal_(char *job, integer *n, complex_lotus *a, integer *lda, 
	complex_lotus *b, integer *ldb, integer *ilo, integer *ihi, real_lotus *lscale, 
	real_lotus *rscale, real_lotus *work, integer *info);

/* Subroutine */ int cgges_(char *jobvsl, char *jobvsr, char *sort, L_fp 
	selctg, integer *n, complex_lotus *a, integer *lda, complex_lotus *b, integer *
	ldb, integer *sdim, complex_lotus *alpha, complex_lotus *beta, complex_lotus *vsl, 
	integer *ldvsl, complex_lotus *vsr, integer *ldvsr, complex_lotus *work, integer *
	lwork, real_lotus *rwork, logical *bwork, integer *info);

/* Subroutine */ int cggesx_(char *jobvsl, char *jobvsr, char *sort, L_fp 
	selctg, char *sense, integer *n, complex_lotus *a, integer *lda, complex_lotus *b, 
	 integer *ldb, integer *sdim, complex_lotus *alpha, complex_lotus *beta, complex_lotus *
	vsl, integer *ldvsl, complex_lotus *vsr, integer *ldvsr, real_lotus *rconde, real_lotus 
	*rcondv, complex_lotus *work, integer *lwork, real_lotus *rwork, integer *iwork, 
	integer *liwork, logical *bwork, integer *info);

/* Subroutine */ int cggev_(char *jobvl, char *jobvr, integer *n, complex_lotus *a, 
	integer *lda, complex_lotus *b, integer *ldb, complex_lotus *alpha, complex_lotus *beta, 
	 complex_lotus *vl, integer *ldvl, complex_lotus *vr, integer *ldvr, complex_lotus *
	work, integer *lwork, real_lotus *rwork, integer *info);

/* Subroutine */ int cggevx_(char *balanc, char *jobvl, char *jobvr, char *
	sense, integer *n, complex_lotus *a, integer *lda, complex_lotus *b, integer *ldb, 
	 complex_lotus *alpha, complex_lotus *beta, complex_lotus *vl, integer *ldvl, complex_lotus *
	vr, integer *ldvr, integer *ilo, integer *ihi, real_lotus *lscale, real_lotus *
	rscale, real_lotus *abnrm, real_lotus *bbnrm, real_lotus *rconde, real_lotus *rcondv, complex_lotus 
	*work, integer *lwork, real_lotus *rwork, integer *iwork, logical *bwork, 
	integer *info);

/* Subroutine */ int cggglm_(integer *n, integer *m, integer *p, complex_lotus *a, 
	integer *lda, complex_lotus *b, integer *ldb, complex_lotus *d__, complex_lotus *x, 
	complex_lotus *y, complex_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int cgghrd_(char *compq, char *compz, integer *n, integer *
	ilo, integer *ihi, complex_lotus *a, integer *lda, complex_lotus *b, integer *ldb, 
	 complex_lotus *q, integer *ldq, complex_lotus *z__, integer *ldz, integer *info);

/* Subroutine */ int cgglse_(integer *m, integer *n, integer *p, complex_lotus *a, 
	integer *lda, complex_lotus *b, integer *ldb, complex_lotus *c__, complex_lotus *d__, 
	complex_lotus *x, complex_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int cggqrf_(integer *n, integer *m, integer *p, complex_lotus *a, 
	integer *lda, complex_lotus *taua, complex_lotus *b, integer *ldb, complex_lotus *taub, 
	complex_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int cggrqf_(integer *m, integer *p, integer *n, complex_lotus *a, 
	integer *lda, complex_lotus *taua, complex_lotus *b, integer *ldb, complex_lotus *taub, 
	complex_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int cggsvd_(char *jobu, char *jobv, char *jobq, integer *m, 
	integer *n, integer *p, integer *k, integer *l, complex_lotus *a, integer *
	lda, complex_lotus *b, integer *ldb, real_lotus *alpha, real_lotus *beta, complex_lotus *u, 
	integer *ldu, complex_lotus *v, integer *ldv, complex_lotus *q, integer *ldq, 
	complex_lotus *work, real_lotus *rwork, integer *iwork, integer *info);

/* Subroutine */ int cggsvp_(char *jobu, char *jobv, char *jobq, integer *m, 
	integer *p, integer *n, complex_lotus *a, integer *lda, complex_lotus *b, integer 
	*ldb, real_lotus *tola, real_lotus *tolb, integer *k, integer *l, complex_lotus *u, 
	integer *ldu, complex_lotus *v, integer *ldv, complex_lotus *q, integer *ldq, 
	integer *iwork, real_lotus *rwork, complex_lotus *tau, complex_lotus *work, integer *
	info);

/* Subroutine */ int cgtcon_(char *norm, integer *n, complex_lotus *dl, complex_lotus *
	d__, complex_lotus *du, complex_lotus *du2, integer *ipiv, real_lotus *anorm, real_lotus *
	rcond, complex_lotus *work, integer *info);

/* Subroutine */ int cgtrfs_(char *trans, integer *n, integer *nrhs, complex_lotus *
	dl, complex_lotus *d__, complex_lotus *du, complex_lotus *dlf, complex_lotus *df, complex_lotus *
	duf, complex_lotus *du2, integer *ipiv, complex_lotus *b, integer *ldb, complex_lotus *
	x, integer *ldx, real_lotus *ferr, real_lotus *berr, complex_lotus *work, real_lotus *rwork, 
	integer *info);

/* Subroutine */ int cgtsv_(integer *n, integer *nrhs, complex_lotus *dl, complex_lotus *
	d__, complex_lotus *du, complex_lotus *b, integer *ldb, integer *info);

/* Subroutine */ int cgtsvx_(char *fact, char *trans, integer *n, integer *
	nrhs, complex_lotus *dl, complex_lotus *d__, complex_lotus *du, complex_lotus *dlf, complex_lotus *
	df, complex_lotus *duf, complex_lotus *du2, integer *ipiv, complex_lotus *b, integer *
	ldb, complex_lotus *x, integer *ldx, real_lotus *rcond, real_lotus *ferr, real_lotus *berr, 
	complex_lotus *work, real_lotus *rwork, integer *info);

/* Subroutine */ int cgttrf_(integer *n, complex_lotus *dl, complex_lotus *d__, complex_lotus *
	du, complex_lotus *du2, integer *ipiv, integer *info);

/* Subroutine */ int cgttrs_(char *trans, integer *n, integer *nrhs, complex_lotus *
	dl, complex_lotus *d__, complex_lotus *du, complex_lotus *du2, integer *ipiv, complex_lotus *
	b, integer *ldb, integer *info);

/* Subroutine */ int cgtts2_(integer *itrans, integer *n, integer *nrhs, 
	complex_lotus *dl, complex_lotus *d__, complex_lotus *du, complex_lotus *du2, integer *ipiv, 
	complex_lotus *b, integer *ldb);

/* Subroutine */ int chbev_(char *jobz, char *uplo, integer *n, integer *kd, 
	complex_lotus *ab, integer *ldab, real_lotus *w, complex_lotus *z__, integer *ldz, 
	complex_lotus *work, real_lotus *rwork, integer *info);

/* Subroutine */ int chbevd_(char *jobz, char *uplo, integer *n, integer *kd, 
	complex_lotus *ab, integer *ldab, real_lotus *w, complex_lotus *z__, integer *ldz, 
	complex_lotus *work, integer *lwork, real_lotus *rwork, integer *lrwork, integer *
	iwork, integer *liwork, integer *info);

/* Subroutine */ int chbevx_(char *jobz, char *range, char *uplo, integer *n, 
	integer *kd, complex_lotus *ab, integer *ldab, complex_lotus *q, integer *ldq, 
	real_lotus *vl, real_lotus *vu, integer *il, integer *iu, real_lotus *abstol, integer *
	m, real_lotus *w, complex_lotus *z__, integer *ldz, complex_lotus *work, real_lotus *rwork, 
	integer *iwork, integer *ifail, integer *info);

/* Subroutine */ int chbgst_(char *vect, char *uplo, integer *n, integer *ka, 
	integer *kb, complex_lotus *ab, integer *ldab, complex_lotus *bb, integer *ldbb, 
	complex_lotus *x, integer *ldx, complex_lotus *work, real_lotus *rwork, integer *info);

/* Subroutine */ int chbgv_(char *jobz, char *uplo, integer *n, integer *ka, 
	integer *kb, complex_lotus *ab, integer *ldab, complex_lotus *bb, integer *ldbb, 
	real_lotus *w, complex_lotus *z__, integer *ldz, complex_lotus *work, real_lotus *rwork, 
	integer *info);

/* Subroutine */ int chbgvd_(char *jobz, char *uplo, integer *n, integer *ka, 
	integer *kb, complex_lotus *ab, integer *ldab, complex_lotus *bb, integer *ldbb, 
	real_lotus *w, complex_lotus *z__, integer *ldz, complex_lotus *work, integer *lwork, 
	real_lotus *rwork, integer *lrwork, integer *iwork, integer *liwork, 
	integer *info);

/* Subroutine */ int chbgvx_(char *jobz, char *range, char *uplo, integer *n, 
	integer *ka, integer *kb, complex_lotus *ab, integer *ldab, complex_lotus *bb, 
	integer *ldbb, complex_lotus *q, integer *ldq, real_lotus *vl, real_lotus *vu, integer *
	il, integer *iu, real_lotus *abstol, integer *m, real_lotus *w, complex_lotus *z__, 
	integer *ldz, complex_lotus *work, real_lotus *rwork, integer *iwork, integer *
	ifail, integer *info);

/* Subroutine */ int chbtrd_(char *vect, char *uplo, integer *n, integer *kd, 
	complex_lotus *ab, integer *ldab, real_lotus *d__, real_lotus *e, complex_lotus *q, integer *
	ldq, complex_lotus *work, integer *info);

/* Subroutine */ int checon_(char *uplo, integer *n, complex_lotus *a, integer *lda, 
	 integer *ipiv, real_lotus *anorm, real_lotus *rcond, complex_lotus *work, integer *
	info);

/* Subroutine */ int cheequb_(char *uplo, integer *n, complex_lotus *a, integer *
	lda, real_lotus *s, real_lotus *scond, real_lotus *amax, complex_lotus *work, integer *info);

/* Subroutine */ int cheev_(char *jobz, char *uplo, integer *n, complex_lotus *a, 
	integer *lda, real_lotus *w, complex_lotus *work, integer *lwork, real_lotus *rwork, 
	integer *info);

/* Subroutine */ int cheevd_(char *jobz, char *uplo, integer *n, complex_lotus *a, 
	integer *lda, real_lotus *w, complex_lotus *work, integer *lwork, real_lotus *rwork, 
	integer *lrwork, integer *iwork, integer *liwork, integer *info);

/* Subroutine */ int cheevr_(char *jobz, char *range, char *uplo, integer *n, 
	complex_lotus *a, integer *lda, real_lotus *vl, real_lotus *vu, integer *il, integer *
	iu, real_lotus *abstol, integer *m, real_lotus *w, complex_lotus *z__, integer *ldz, 
	integer *isuppz, complex_lotus *work, integer *lwork, real_lotus *rwork, integer *
	lrwork, integer *iwork, integer *liwork, integer *info);

/* Subroutine */ int cheevx_(char *jobz, char *range, char *uplo, integer *n, 
	complex_lotus *a, integer *lda, real_lotus *vl, real_lotus *vu, integer *il, integer *
	iu, real_lotus *abstol, integer *m, real_lotus *w, complex_lotus *z__, integer *ldz, 
	complex_lotus *work, integer *lwork, real_lotus *rwork, integer *iwork, integer *
	ifail, integer *info);

/* Subroutine */ int chegs2_(integer *itype, char *uplo, integer *n, complex_lotus *
	a, integer *lda, complex_lotus *b, integer *ldb, integer *info);

/* Subroutine */ int chegst_(integer *itype, char *uplo, integer *n, complex_lotus *
	a, integer *lda, complex_lotus *b, integer *ldb, integer *info);

/* Subroutine */ int chegv_(integer *itype, char *jobz, char *uplo, integer *
	n, complex_lotus *a, integer *lda, complex_lotus *b, integer *ldb, real_lotus *w, 
	complex_lotus *work, integer *lwork, real_lotus *rwork, integer *info);

/* Subroutine */ int chegvd_(integer *itype, char *jobz, char *uplo, integer *
	n, complex_lotus *a, integer *lda, complex_lotus *b, integer *ldb, real_lotus *w, 
	complex_lotus *work, integer *lwork, real_lotus *rwork, integer *lrwork, integer *
	iwork, integer *liwork, integer *info);

/* Subroutine */ int chegvx_(integer *itype, char *jobz, char *range, char *
	uplo, integer *n, complex_lotus *a, integer *lda, complex_lotus *b, integer *ldb, 
	real_lotus *vl, real_lotus *vu, integer *il, integer *iu, real_lotus *abstol, integer *
	m, real_lotus *w, complex_lotus *z__, integer *ldz, complex_lotus *work, integer *lwork, 
	 real_lotus *rwork, integer *iwork, integer *ifail, integer *info);

/* Subroutine */ int cherfs_(char *uplo, integer *n, integer *nrhs, complex_lotus *
	a, integer *lda, complex_lotus *af, integer *ldaf, integer *ipiv, complex_lotus *
	b, integer *ldb, complex_lotus *x, integer *ldx, real_lotus *ferr, real_lotus *berr, 
	complex_lotus *work, real_lotus *rwork, integer *info);

/* Subroutine */ int cherfsx_(char *uplo, char *equed, integer *n, integer *
	nrhs, complex_lotus *a, integer *lda, complex_lotus *af, integer *ldaf, integer *
	ipiv, real_lotus *s, complex_lotus *b, integer *ldb, complex_lotus *x, integer *ldx, 
	real_lotus *rcond, real_lotus *berr, integer *n_err_bnds__, real_lotus *err_bnds_norm__, 
	 real_lotus *err_bnds_comp__, integer *nparams, real_lotus *params, complex_lotus *work, 
	 real_lotus *rwork, integer *info);

/* Subroutine */ int chesv_(char *uplo, integer *n, integer *nrhs, complex_lotus *a, 
	 integer *lda, integer *ipiv, complex_lotus *b, integer *ldb, complex_lotus *work, 
	 integer *lwork, integer *info);

/* Subroutine */ int chesvx_(char *fact, char *uplo, integer *n, integer *
	nrhs, complex_lotus *a, integer *lda, complex_lotus *af, integer *ldaf, integer *
	ipiv, complex_lotus *b, integer *ldb, complex_lotus *x, integer *ldx, real_lotus *rcond, 
	 real_lotus *ferr, real_lotus *berr, complex_lotus *work, integer *lwork, real_lotus *rwork, 
	integer *info);

/* Subroutine */ int chesvxx_(char *fact, char *uplo, integer *n, integer *
	nrhs, complex_lotus *a, integer *lda, complex_lotus *af, integer *ldaf, integer *
	ipiv, char *equed, real_lotus *s, complex_lotus *b, integer *ldb, complex_lotus *x, 
	integer *ldx, real_lotus *rcond, real_lotus *rpvgrw, real_lotus *berr, integer *
	n_err_bnds__, real_lotus *err_bnds_norm__, real_lotus *err_bnds_comp__, integer *
	nparams, real_lotus *params, complex_lotus *work, real_lotus *rwork, integer *info);

/* Subroutine */ int chetd2_(char *uplo, integer *n, complex_lotus *a, integer *lda, 
	 real_lotus *d__, real_lotus *e, complex_lotus *tau, integer *info);

/* Subroutine */ int chetf2_(char *uplo, integer *n, complex_lotus *a, integer *lda, 
	 integer *ipiv, integer *info);

/* Subroutine */ int chetrd_(char *uplo, integer *n, complex_lotus *a, integer *lda, 
	 real_lotus *d__, real_lotus *e, complex_lotus *tau, complex_lotus *work, integer *lwork, 
	integer *info);

/* Subroutine */ int chetrf_(char *uplo, integer *n, complex_lotus *a, integer *lda, 
	 integer *ipiv, complex_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int chetri_(char *uplo, integer *n, complex_lotus *a, integer *lda, 
	 integer *ipiv, complex_lotus *work, integer *info);

/* Subroutine */ int chetrs_(char *uplo, integer *n, integer *nrhs, complex_lotus *
	a, integer *lda, integer *ipiv, complex_lotus *b, integer *ldb, integer *
	info);

/* Subroutine */ int chfrk_(char *transr, char *uplo, char *trans, integer *n, 
	 integer *k, real_lotus *alpha, complex_lotus *a, integer *lda, real_lotus *beta, 
	complex_lotus *c__);

/* Subroutine */ int chgeqz_(char *job, char *compq, char *compz, integer *n, 
	integer *ilo, integer *ihi, complex_lotus *h__, integer *ldh, complex_lotus *t, 
	integer *ldt, complex_lotus *alpha, complex_lotus *beta, complex_lotus *q, integer *ldq, 
	 complex_lotus *z__, integer *ldz, complex_lotus *work, integer *lwork, real_lotus *
	rwork, integer *info);

/* Character */ void chla_transtype__(char *ret_val, ftnlen ret_val_len, 
	integer *trans);

/* Subroutine */ int chpcon_(char *uplo, integer *n, complex_lotus *ap, integer *
	ipiv, real_lotus *anorm, real_lotus *rcond, complex_lotus *work, integer *info);

/* Subroutine */ int chpev_(char *jobz, char *uplo, integer *n, complex_lotus *ap, 
	real_lotus *w, complex_lotus *z__, integer *ldz, complex_lotus *work, real_lotus *rwork, 
	integer *info);

/* Subroutine */ int chpevd_(char *jobz, char *uplo, integer *n, complex_lotus *ap, 
	real_lotus *w, complex_lotus *z__, integer *ldz, complex_lotus *work, integer *lwork, 
	real_lotus *rwork, integer *lrwork, integer *iwork, integer *liwork, 
	integer *info);

/* Subroutine */ int chpevx_(char *jobz, char *range, char *uplo, integer *n, 
	complex_lotus *ap, real_lotus *vl, real_lotus *vu, integer *il, integer *iu, real_lotus *
	abstol, integer *m, real_lotus *w, complex_lotus *z__, integer *ldz, complex_lotus *
	work, real_lotus *rwork, integer *iwork, integer *ifail, integer *info);

/* Subroutine */ int chpgst_(integer *itype, char *uplo, integer *n, complex_lotus *
	ap, complex_lotus *bp, integer *info);

/* Subroutine */ int chpgv_(integer *itype, char *jobz, char *uplo, integer *
	n, complex_lotus *ap, complex_lotus *bp, real_lotus *w, complex_lotus *z__, integer *ldz, 
	complex_lotus *work, real_lotus *rwork, integer *info);

/* Subroutine */ int chpgvd_(integer *itype, char *jobz, char *uplo, integer *
	n, complex_lotus *ap, complex_lotus *bp, real_lotus *w, complex_lotus *z__, integer *ldz, 
	complex_lotus *work, integer *lwork, real_lotus *rwork, integer *lrwork, integer *
	iwork, integer *liwork, integer *info);

/* Subroutine */ int chpgvx_(integer *itype, char *jobz, char *range, char *
	uplo, integer *n, complex_lotus *ap, complex_lotus *bp, real_lotus *vl, real_lotus *vu, 
	integer *il, integer *iu, real_lotus *abstol, integer *m, real_lotus *w, complex_lotus *
	z__, integer *ldz, complex_lotus *work, real_lotus *rwork, integer *iwork, 
	integer *ifail, integer *info);

/* Subroutine */ int chprfs_(char *uplo, integer *n, integer *nrhs, complex_lotus *
	ap, complex_lotus *afp, integer *ipiv, complex_lotus *b, integer *ldb, complex_lotus *x, 
	 integer *ldx, real_lotus *ferr, real_lotus *berr, complex_lotus *work, real_lotus *rwork, 
	integer *info);

/* Subroutine */ int chpsv_(char *uplo, integer *n, integer *nrhs, complex_lotus *
	ap, integer *ipiv, complex_lotus *b, integer *ldb, integer *info);

/* Subroutine */ int chpsvx_(char *fact, char *uplo, integer *n, integer *
	nrhs, complex_lotus *ap, complex_lotus *afp, integer *ipiv, complex_lotus *b, integer *
	ldb, complex_lotus *x, integer *ldx, real_lotus *rcond, real_lotus *ferr, real_lotus *berr, 
	complex_lotus *work, real_lotus *rwork, integer *info);

/* Subroutine */ int chptrd_(char *uplo, integer *n, complex_lotus *ap, real_lotus *d__, 
	real_lotus *e, complex_lotus *tau, integer *info);

/* Subroutine */ int chptrf_(char *uplo, integer *n, complex_lotus *ap, integer *
	ipiv, integer *info);

/* Subroutine */ int chptri_(char *uplo, integer *n, complex_lotus *ap, integer *
	ipiv, complex_lotus *work, integer *info);

/* Subroutine */ int chptrs_(char *uplo, integer *n, integer *nrhs, complex_lotus *
	ap, integer *ipiv, complex_lotus *b, integer *ldb, integer *info);

/* Subroutine */ int chsein_(char *side, char *eigsrc, char *initv, logical *
	select, integer *n, complex_lotus *h__, integer *ldh, complex_lotus *w, complex_lotus *
	vl, integer *ldvl, complex_lotus *vr, integer *ldvr, integer *mm, integer *
	m, complex_lotus *work, real_lotus *rwork, integer *ifaill, integer *ifailr, 
	integer *info);

/* Subroutine */ int chseqr_(char *job, char *compz, integer *n, integer *ilo, 
	 integer *ihi, complex_lotus *h__, integer *ldh, complex_lotus *w, complex_lotus *z__, 
	integer *ldz, complex_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int cla_gbamv__(integer *trans, integer *m, integer *n, 
	integer *kl, integer *ku, real_lotus *alpha, complex_lotus *ab, integer *ldab, 
	complex_lotus *x, integer *incx, real_lotus *beta, real_lotus *y, integer *incy);

doublereal_lotus cla_gbrcond_c__(char *trans, integer *n, integer *kl, integer *ku, 
	complex_lotus *ab, integer *ldab, complex_lotus *afb, integer *ldafb, integer *
	ipiv, real_lotus *c__, logical *capply, integer *info, complex_lotus *work, real_lotus *
	rwork, ftnlen trans_len);

doublereal_lotus cla_gbrcond_x__(char *trans, integer *n, integer *kl, integer *ku, 
	complex_lotus *ab, integer *ldab, complex_lotus *afb, integer *ldafb, integer *
	ipiv, complex_lotus *x, integer *info, complex_lotus *work, real_lotus *rwork, ftnlen 
	trans_len);

/* Subroutine */ int cla_gbrfsx_extended__(integer *prec_type__, integer *
	trans_type__, integer *n, integer *kl, integer *ku, integer *nrhs, 
	complex_lotus *ab, integer *ldab, complex_lotus *afb, integer *ldafb, integer *
	ipiv, logical *colequ, real_lotus *c__, complex_lotus *b, integer *ldb, complex_lotus *
	y, integer *ldy, real_lotus *berr_out__, integer *n_norms__, real_lotus *errs_n__,
	 real_lotus *errs_c__, complex_lotus *res, real_lotus *ayb, complex_lotus *dy, complex_lotus *
	y_tail__, real_lotus *rcond, integer *ithresh, real_lotus *rthresh, real_lotus *dz_ub__,
	 logical *ignore_cwise__, integer *info);

doublereal_lotus cla_gbrpvgrw__(integer *n, integer *kl, integer *ku, integer *
	ncols, complex_lotus *ab, integer *ldab, complex_lotus *afb, integer *ldafb);

/* Subroutine */ int cla_geamv__(integer *trans, integer *m, integer *n, real_lotus 
	*alpha, complex_lotus *a, integer *lda, complex_lotus *x, integer *incx, real_lotus *
	beta, real_lotus *y, integer *incy);

doublereal_lotus cla_gercond_c__(char *trans, integer *n, complex_lotus *a, integer *lda, 
	complex_lotus *af, integer *ldaf, integer *ipiv, real_lotus *c__, logical *capply,
	 integer *info, complex_lotus *work, real_lotus *rwork, ftnlen trans_len);

doublereal_lotus cla_gercond_x__(char *trans, integer *n, complex_lotus *a, integer *lda, 
	complex_lotus *af, integer *ldaf, integer *ipiv, complex_lotus *x, integer *info, 
	complex_lotus *work, real_lotus *rwork, ftnlen trans_len);

/* Subroutine */ int cla_gerfsx_extended__(integer *prec_type__, integer *
	trans_type__, integer *n, integer *nrhs, complex_lotus *a, integer *lda, 
	complex_lotus *af, integer *ldaf, integer *ipiv, logical *colequ, real_lotus *c__,
	 complex_lotus *b, integer *ldb, complex_lotus *y, integer *ldy, real_lotus *berr_out__,
	 integer *n_norms__, real_lotus *errs_n__, real_lotus *errs_c__, complex_lotus *res, 
	real_lotus *ayb, complex_lotus *dy, complex_lotus *y_tail__, real_lotus *rcond, integer *
	ithresh, real_lotus *rthresh, real_lotus *dz_ub__, logical *ignore_cwise__, 
	integer *info);

/* Subroutine */ int cla_heamv__(integer *uplo, integer *n, real_lotus *alpha, 
	complex_lotus *a, integer *lda, complex_lotus *x, integer *incx, real_lotus *beta, real_lotus 
	*y, integer *incy);

doublereal_lotus cla_hercond_c__(char *uplo, integer *n, complex_lotus *a, integer *lda, 
	complex_lotus *af, integer *ldaf, integer *ipiv, real_lotus *c__, logical *capply,
	 integer *info, complex_lotus *work, real_lotus *rwork, ftnlen uplo_len);

doublereal_lotus cla_hercond_x__(char *uplo, integer *n, complex_lotus *a, integer *lda, 
	complex_lotus *af, integer *ldaf, integer *ipiv, complex_lotus *x, integer *info, 
	complex_lotus *work, real_lotus *rwork, ftnlen uplo_len);

/* Subroutine */ int cla_herfsx_extended__(integer *prec_type__, char *uplo, 
	integer *n, integer *nrhs, complex_lotus *a, integer *lda, complex_lotus *af, 
	integer *ldaf, integer *ipiv, logical *colequ, real_lotus *c__, complex_lotus *b, 
	integer *ldb, complex_lotus *y, integer *ldy, real_lotus *berr_out__, integer *
	n_norms__, real_lotus *errs_n__, real_lotus *errs_c__, complex_lotus *res, real_lotus *ayb, 
	complex_lotus *dy, complex_lotus *y_tail__, real_lotus *rcond, integer *ithresh, real_lotus *
	rthresh, real_lotus *dz_ub__, logical *ignore_cwise__, integer *info, 
	ftnlen uplo_len);

doublereal_lotus cla_herpvgrw__(char *uplo, integer *n, integer *info, complex_lotus *a, 
	integer *lda, complex_lotus *af, integer *ldaf, integer *ipiv, real_lotus *work, 
	ftnlen uplo_len);

/* Subroutine */ int cla_lin_berr__(integer *n, integer *nz, integer *nrhs, 
	complex_lotus *res, real_lotus *ayb, real_lotus *berr);

doublereal_lotus cla_porcond_c__(char *uplo, integer *n, complex_lotus *a, integer *lda, 
	complex_lotus *af, integer *ldaf, real_lotus *c__, logical *capply, integer *info,
	 complex_lotus *work, real_lotus *rwork, ftnlen uplo_len);

doublereal_lotus cla_porcond_x__(char *uplo, integer *n, complex_lotus *a, integer *lda, 
	complex_lotus *af, integer *ldaf, complex_lotus *x, integer *info, complex_lotus *work, 
	real_lotus *rwork, ftnlen uplo_len);

/* Subroutine */ int cla_porfsx_extended__(integer *prec_type__, char *uplo, 
	integer *n, integer *nrhs, complex_lotus *a, integer *lda, complex_lotus *af, 
	integer *ldaf, logical *colequ, real_lotus *c__, complex_lotus *b, integer *ldb, 
	complex_lotus *y, integer *ldy, real_lotus *berr_out__, integer *n_norms__, real_lotus *
	errs_n__, real_lotus *errs_c__, complex_lotus *res, real_lotus *ayb, complex_lotus *dy, 
	complex_lotus *y_tail__, real_lotus *rcond, integer *ithresh, real_lotus *rthresh, real_lotus 
	*dz_ub__, logical *ignore_cwise__, integer *info, ftnlen uplo_len);

doublereal_lotus cla_porpvgrw__(char *uplo, integer *ncols, complex_lotus *a, integer *
	lda, complex_lotus *af, integer *ldaf, real_lotus *work, ftnlen uplo_len);

doublereal_lotus cla_rpvgrw__(integer *n, integer *ncols, complex_lotus *a, integer *lda, 
	complex_lotus *af, integer *ldaf);

/* Subroutine */ int cla_syamv__(integer *uplo, integer *n, real_lotus *alpha, 
	complex_lotus *a, integer *lda, complex_lotus *x, integer *incx, real_lotus *beta, real_lotus 
	*y, integer *incy);

doublereal_lotus cla_syrcond_c__(char *uplo, integer *n, complex_lotus *a, integer *lda, 
	complex_lotus *af, integer *ldaf, integer *ipiv, real_lotus *c__, logical *capply,
	 integer *info, complex_lotus *work, real_lotus *rwork, ftnlen uplo_len);

doublereal_lotus cla_syrcond_x__(char *uplo, integer *n, complex_lotus *a, integer *lda, 
	complex_lotus *af, integer *ldaf, integer *ipiv, complex_lotus *x, integer *info, 
	complex_lotus *work, real_lotus *rwork, ftnlen uplo_len);

/* Subroutine */ int cla_syrfsx_extended__(integer *prec_type__, char *uplo, 
	integer *n, integer *nrhs, complex_lotus *a, integer *lda, complex_lotus *af, 
	integer *ldaf, integer *ipiv, logical *colequ, real_lotus *c__, complex_lotus *b, 
	integer *ldb, complex_lotus *y, integer *ldy, real_lotus *berr_out__, integer *
	n_norms__, real_lotus *errs_n__, real_lotus *errs_c__, complex_lotus *res, real_lotus *ayb, 
	complex_lotus *dy, complex_lotus *y_tail__, real_lotus *rcond, integer *ithresh, real_lotus *
	rthresh, real_lotus *dz_ub__, logical *ignore_cwise__, integer *info, 
	ftnlen uplo_len);

doublereal_lotus cla_syrpvgrw__(char *uplo, integer *n, integer *info, complex_lotus *a, 
	integer *lda, complex_lotus *af, integer *ldaf, integer *ipiv, real_lotus *work, 
	ftnlen uplo_len);

/* Subroutine */ int cla_wwaddw__(integer *n, complex_lotus *x, complex_lotus *y, complex_lotus 
	*w);

/* Subroutine */ int clabrd_(integer *m, integer *n, integer *nb, complex_lotus *a, 
	integer *lda, real_lotus *d__, real_lotus *e, complex_lotus *tauq, complex_lotus *taup, 
	complex_lotus *x, integer *ldx, complex_lotus *y, integer *ldy);

/* Subroutine */ int clacgv_(integer *n, complex_lotus *x, integer *incx);

/* Subroutine */ int clacn2_(integer *n, complex_lotus *v, complex_lotus *x, real_lotus *est, 
	integer *kase, integer *isave);

/* Subroutine */ int clacon_(integer *n, complex_lotus *v, complex_lotus *x, real_lotus *est, 
	integer *kase);

/* Subroutine */ int clacp2_(char *uplo, integer *m, integer *n, real_lotus *a, 
	integer *lda, complex_lotus *b, integer *ldb);

/* Subroutine */ int clacpy_(char *uplo, integer *m, integer *n, complex_lotus *a, 
	integer *lda, complex_lotus *b, integer *ldb);

/* Subroutine */ int clacrm_(integer *m, integer *n, complex_lotus *a, integer *lda, 
	 real_lotus *b, integer *ldb, complex_lotus *c__, integer *ldc, real_lotus *rwork);

/* Subroutine */ int clacrt_(integer *n, complex_lotus *cx, integer *incx, complex_lotus *
	cy, integer *incy, complex_lotus *c__, complex_lotus *s);

/* Complex */ void cladiv_(complex_lotus * ret_val, complex_lotus *x, complex_lotus *y);

/* Subroutine */ int claed0_(integer *qsiz, integer *n, real_lotus *d__, real_lotus *e, 
	complex_lotus *q, integer *ldq, complex_lotus *qstore, integer *ldqs, real_lotus *rwork, 
	 integer *iwork, integer *info);

/* Subroutine */ int claed7_(integer *n, integer *cutpnt, integer *qsiz, 
	integer *tlvls, integer *curlvl, integer *curpbm, real_lotus *d__, complex_lotus *
	q, integer *ldq, real_lotus *rho, integer *indxq, real_lotus *qstore, integer *
	qptr, integer *prmptr, integer *perm, integer *givptr, integer *
	givcol, real_lotus *givnum, complex_lotus *work, real_lotus *rwork, integer *iwork, 
	integer *info);

/* Subroutine */ int claed8_(integer *k, integer *n, integer *qsiz, complex_lotus *
	q, integer *ldq, real_lotus *d__, real_lotus *rho, integer *cutpnt, real_lotus *z__, 
	real_lotus *dlamda, complex_lotus *q2, integer *ldq2, real_lotus *w, integer *indxp, 
	integer *indx, integer *indxq, integer *perm, integer *givptr, 
	integer *givcol, real_lotus *givnum, integer *info);

/* Subroutine */ int claein_(logical *rightv, logical *noinit, integer *n, 
	complex_lotus *h__, integer *ldh, complex_lotus *w, complex_lotus *v, complex_lotus *b, 
	integer *ldb, real_lotus *rwork, real_lotus *eps3, real_lotus *smlnum, integer *info);

/* Subroutine */ int claesy_(complex_lotus *a, complex_lotus *b, complex_lotus *c__, complex_lotus *
	rt1, complex_lotus *rt2, complex_lotus *evscal, complex_lotus *cs1, complex_lotus *sn1);

/* Subroutine */ int claev2_(complex_lotus *a, complex_lotus *b, complex_lotus *c__, real_lotus *rt1, 
	real_lotus *rt2, real_lotus *cs1, complex_lotus *sn1);

/* Subroutine */ int clag2z_(integer *m, integer *n, complex_lotus *sa, integer *
	ldsa, doublecomplex_lotus *a, integer *lda, integer *info);

/* Subroutine */ int clags2_(logical *upper, real_lotus *a1, complex_lotus *a2, real_lotus *a3, 
	real_lotus *b1, complex_lotus *b2, real_lotus *b3, real_lotus *csu, complex_lotus *snu, real_lotus *csv, 
	complex_lotus *snv, real_lotus *csq, complex_lotus *snq);

/* Subroutine */ int clagtm_(char *trans, integer *n, integer *nrhs, real_lotus *
	alpha, complex_lotus *dl, complex_lotus *d__, complex_lotus *du, complex_lotus *x, integer *
	ldx, real_lotus *beta, complex_lotus *b, integer *ldb);

/* Subroutine */ int clahef_(char *uplo, integer *n, integer *nb, integer *kb, 
	 complex_lotus *a, integer *lda, integer *ipiv, complex_lotus *w, integer *ldw, 
	integer *info);

/* Subroutine */ int clahqr_(logical *wantt, logical *wantz, integer *n, 
	integer *ilo, integer *ihi, complex_lotus *h__, integer *ldh, complex_lotus *w, 
	integer *iloz, integer *ihiz, complex_lotus *z__, integer *ldz, integer *
	info);

/* Subroutine */ int clahr2_(integer *n, integer *k, integer *nb, complex_lotus *a, 
	integer *lda, complex_lotus *tau, complex_lotus *t, integer *ldt, complex_lotus *y, 
	integer *ldy);

/* Subroutine */ int clahrd_(integer *n, integer *k, integer *nb, complex_lotus *a, 
	integer *lda, complex_lotus *tau, complex_lotus *t, integer *ldt, complex_lotus *y, 
	integer *ldy);

/* Subroutine */ int claic1_(integer *job, integer *j, complex_lotus *x, real_lotus *sest, 
	 complex_lotus *w, complex_lotus *gamma, real_lotus *sestpr, complex_lotus *s, complex_lotus *c__);

/* Subroutine */ int clals0_(integer *icompq, integer *nl, integer *nr, 
	integer *sqre, integer *nrhs, complex_lotus *b, integer *ldb, complex_lotus *bx, 
	integer *ldbx, integer *perm, integer *givptr, integer *givcol, 
	integer *ldgcol, real_lotus *givnum, integer *ldgnum, real_lotus *poles, real_lotus *
	difl, real_lotus *difr, real_lotus *z__, integer *k, real_lotus *c__, real_lotus *s, real_lotus *
	rwork, integer *info);

/* Subroutine */ int clalsa_(integer *icompq, integer *smlsiz, integer *n, 
	integer *nrhs, complex_lotus *b, integer *ldb, complex_lotus *bx, integer *ldbx, 
	real_lotus *u, integer *ldu, real_lotus *vt, integer *k, real_lotus *difl, real_lotus *difr, 
	real_lotus *z__, real_lotus *poles, integer *givptr, integer *givcol, integer *
	ldgcol, integer *perm, real_lotus *givnum, real_lotus *c__, real_lotus *s, real_lotus *rwork, 
	integer *iwork, integer *info);

/* Subroutine */ int clalsd_(char *uplo, integer *smlsiz, integer *n, integer 
	*nrhs, real_lotus *d__, real_lotus *e, complex_lotus *b, integer *ldb, real_lotus *rcond, 
	integer *rank, complex_lotus *work, real_lotus *rwork, integer *iwork, integer *
	info);

doublereal_lotus clangb_(char *norm, integer *n, integer *kl, integer *ku, complex_lotus *
	ab, integer *ldab, real_lotus *work);

doublereal_lotus clange_(char *norm, integer *m, integer *n, complex_lotus *a, integer *
	lda, real_lotus *work);

doublereal_lotus clangt_(char *norm, integer *n, complex_lotus *dl, complex_lotus *d__, complex_lotus 
	*du);

doublereal_lotus clanhb_(char *norm, char *uplo, integer *n, integer *k, complex_lotus *
	ab, integer *ldab, real_lotus *work);

doublereal_lotus clanhe_(char *norm, char *uplo, integer *n, complex_lotus *a, integer *
	lda, real_lotus *work);

doublereal_lotus clanhf_(char *norm, char *transr, char *uplo, integer *n, complex_lotus *
	a, real_lotus *work);

doublereal_lotus clanhp_(char *norm, char *uplo, integer *n, complex_lotus *ap, real_lotus *
	work);

doublereal_lotus clanhs_(char *norm, integer *n, complex_lotus *a, integer *lda, real_lotus *
	work);

doublereal_lotus clanht_(char *norm, integer *n, real_lotus *d__, complex_lotus *e);

doublereal_lotus clansb_(char *norm, char *uplo, integer *n, integer *k, complex_lotus *
	ab, integer *ldab, real_lotus *work);

doublereal_lotus clansp_(char *norm, char *uplo, integer *n, complex_lotus *ap, real_lotus *
	work);

doublereal_lotus clansy_(char *norm, char *uplo, integer *n, complex_lotus *a, integer *
	lda, real_lotus *work);

doublereal_lotus clantb_(char *norm, char *uplo, char *diag, integer *n, integer *k, 
	 complex_lotus *ab, integer *ldab, real_lotus *work);

doublereal_lotus clantp_(char *norm, char *uplo, char *diag, integer *n, complex_lotus *
	ap, real_lotus *work);

doublereal_lotus clantr_(char *norm, char *uplo, char *diag, integer *m, integer *n, 
	 complex_lotus *a, integer *lda, real_lotus *work);

/* Subroutine */ int clapll_(integer *n, complex_lotus *x, integer *incx, complex_lotus *
	y, integer *incy, real_lotus *ssmin);

/* Subroutine */ int clapmt_(logical *forwrd, integer *m, integer *n, complex_lotus 
	*x, integer *ldx, integer *k);

/* Subroutine */ int claqgb_(integer *m, integer *n, integer *kl, integer *ku, 
	 complex_lotus *ab, integer *ldab, real_lotus *r__, real_lotus *c__, real_lotus *rowcnd, real_lotus 
	*colcnd, real_lotus *amax, char *equed);

/* Subroutine */ int claqge_(integer *m, integer *n, complex_lotus *a, integer *lda, 
	 real_lotus *r__, real_lotus *c__, real_lotus *rowcnd, real_lotus *colcnd, real_lotus *amax, char *
	equed);

/* Subroutine */ int claqhb_(char *uplo, integer *n, integer *kd, complex_lotus *ab, 
	 integer *ldab, real_lotus *s, real_lotus *scond, real_lotus *amax, char *equed);

/* Subroutine */ int claqhe_(char *uplo, integer *n, complex_lotus *a, integer *lda, 
	 real_lotus *s, real_lotus *scond, real_lotus *amax, char *equed);

/* Subroutine */ int claqhp_(char *uplo, integer *n, complex_lotus *ap, real_lotus *s, 
	real_lotus *scond, real_lotus *amax, char *equed);

/* Subroutine */ int claqp2_(integer *m, integer *n, integer *offset, complex_lotus 
	*a, integer *lda, integer *jpvt, complex_lotus *tau, real_lotus *vn1, real_lotus *vn2, 
	complex_lotus *work);

/* Subroutine */ int claqps_(integer *m, integer *n, integer *offset, integer 
	*nb, integer *kb, complex_lotus *a, integer *lda, integer *jpvt, complex_lotus *
	tau, real_lotus *vn1, real_lotus *vn2, complex_lotus *auxv, complex_lotus *f, integer *ldf);

/* Subroutine */ int claqr0_(logical *wantt, logical *wantz, integer *n, 
	integer *ilo, integer *ihi, complex_lotus *h__, integer *ldh, complex_lotus *w, 
	integer *iloz, integer *ihiz, complex_lotus *z__, integer *ldz, complex_lotus *
	work, integer *lwork, integer *info);

/* Subroutine */ int claqr1_(integer *n, complex_lotus *h__, integer *ldh, complex_lotus *
	s1, complex_lotus *s2, complex_lotus *v);

/* Subroutine */ int claqr2_(logical *wantt, logical *wantz, integer *n, 
	integer *ktop, integer *kbot, integer *nw, complex_lotus *h__, integer *ldh, 
	 integer *iloz, integer *ihiz, complex_lotus *z__, integer *ldz, integer *
	ns, integer *nd, complex_lotus *sh, complex_lotus *v, integer *ldv, integer *nh, 
	complex_lotus *t, integer *ldt, integer *nv, complex_lotus *wv, integer *ldwv, 
	complex_lotus *work, integer *lwork);

/* Subroutine */ int claqr3_(logical *wantt, logical *wantz, integer *n, 
	integer *ktop, integer *kbot, integer *nw, complex_lotus *h__, integer *ldh, 
	 integer *iloz, integer *ihiz, complex_lotus *z__, integer *ldz, integer *
	ns, integer *nd, complex_lotus *sh, complex_lotus *v, integer *ldv, integer *nh, 
	complex_lotus *t, integer *ldt, integer *nv, complex_lotus *wv, integer *ldwv, 
	complex_lotus *work, integer *lwork);

/* Subroutine */ int claqr4_(logical *wantt, logical *wantz, integer *n, 
	integer *ilo, integer *ihi, complex_lotus *h__, integer *ldh, complex_lotus *w, 
	integer *iloz, integer *ihiz, complex_lotus *z__, integer *ldz, complex_lotus *
	work, integer *lwork, integer *info);

/* Subroutine */ int claqr5_(logical *wantt, logical *wantz, integer *kacc22, 
	integer *n, integer *ktop, integer *kbot, integer *nshfts, complex_lotus *s, 
	 complex_lotus *h__, integer *ldh, integer *iloz, integer *ihiz, complex_lotus *
	z__, integer *ldz, complex_lotus *v, integer *ldv, complex_lotus *u, integer *ldu, 
	 integer *nv, complex_lotus *wv, integer *ldwv, integer *nh, complex_lotus *wh, 
	integer *ldwh);

/* Subroutine */ int claqsb_(char *uplo, integer *n, integer *kd, complex_lotus *ab, 
	 integer *ldab, real_lotus *s, real_lotus *scond, real_lotus *amax, char *equed);

/* Subroutine */ int claqsp_(char *uplo, integer *n, complex_lotus *ap, real_lotus *s, 
	real_lotus *scond, real_lotus *amax, char *equed);

/* Subroutine */ int claqsy_(char *uplo, integer *n, complex_lotus *a, integer *lda, 
	 real_lotus *s, real_lotus *scond, real_lotus *amax, char *equed);

/* Subroutine */ int clar1v_(integer *n, integer *b1, integer *bn, real_lotus *
	lambda, real_lotus *d__, real_lotus *l, real_lotus *ld, real_lotus *lld, real_lotus *pivmin, real_lotus *
	gaptol, complex_lotus *z__, logical *wantnc, integer *negcnt, real_lotus *ztz, 
	real_lotus *mingma, integer *r__, integer *isuppz, real_lotus *nrminv, real_lotus *
	resid, real_lotus *rqcorr, real_lotus *work);

/* Subroutine */ int clar2v_(integer *n, complex_lotus *x, complex_lotus *y, complex_lotus *z__, 
	 integer *incx, real_lotus *c__, complex_lotus *s, integer *incc);

/* Subroutine */ int clarcm_(integer *m, integer *n, real_lotus *a, integer *lda, 
	complex_lotus *b, integer *ldb, complex_lotus *c__, integer *ldc, real_lotus *rwork);

/* Subroutine */ int clarf_(char *side, integer *m, integer *n, complex_lotus *v, 
	integer *incv, complex_lotus *tau, complex_lotus *c__, integer *ldc, complex_lotus *
	work);

/* Subroutine */ int clarfb_(char *side, char *trans, char *direct, char *
	storev, integer *m, integer *n, integer *k, complex_lotus *v, integer *ldv, 
	complex_lotus *t, integer *ldt, complex_lotus *c__, integer *ldc, complex_lotus *work, 
	integer *ldwork);

/* Subroutine */ int clarfg_(integer *n, complex_lotus *alpha, complex_lotus *x, integer *
	incx, complex_lotus *tau);

/* Subroutine */ int clarfp_(integer *n, complex_lotus *alpha, complex_lotus *x, integer *
	incx, complex_lotus *tau);

/* Subroutine */ int clarft_(char *direct, char *storev, integer *n, integer *
	k, complex_lotus *v, integer *ldv, complex_lotus *tau, complex_lotus *t, integer *ldt);

/* Subroutine */ int clarfx_(char *side, integer *m, integer *n, complex_lotus *v, 
	complex_lotus *tau, complex_lotus *c__, integer *ldc, complex_lotus *work);

/* Subroutine */ int clargv_(integer *n, complex_lotus *x, integer *incx, complex_lotus *
	y, integer *incy, real_lotus *c__, integer *incc);

/* Subroutine */ int clarnv_(integer *idist, integer *iseed, integer *n, 
	complex_lotus *x);

/* Subroutine */ int clarrv_(integer *n, real_lotus *vl, real_lotus *vu, real_lotus *d__, real_lotus *
	l, real_lotus *pivmin, integer *isplit, integer *m, integer *dol, integer *
	dou, real_lotus *minrgp, real_lotus *rtol1, real_lotus *rtol2, real_lotus *w, real_lotus *werr, 
	real_lotus *wgap, integer *iblock, integer *indexw, real_lotus *gers, complex_lotus *
	z__, integer *ldz, integer *isuppz, real_lotus *work, integer *iwork, 
	integer *info);

/* Subroutine */ int clarscl2_(integer *m, integer *n, real_lotus *d__, complex_lotus *x, 
	integer *ldx);

/* Subroutine */ int clartg_(complex_lotus *f, complex_lotus *g, real_lotus *cs, complex_lotus *sn, 
	complex_lotus *r__);

/* Subroutine */ int clartv_(integer *n, complex_lotus *x, integer *incx, complex_lotus *
	y, integer *incy, real_lotus *c__, complex_lotus *s, integer *incc);

/* Subroutine */ int clarz_(char *side, integer *m, integer *n, integer *l, 
	complex_lotus *v, integer *incv, complex_lotus *tau, complex_lotus *c__, integer *ldc, 
	complex_lotus *work);

/* Subroutine */ int clarzb_(char *side, char *trans, char *direct, char *
	storev, integer *m, integer *n, integer *k, integer *l, complex_lotus *v, 
	integer *ldv, complex_lotus *t, integer *ldt, complex_lotus *c__, integer *ldc, 
	complex_lotus *work, integer *ldwork);

/* Subroutine */ int clarzt_(char *direct, char *storev, integer *n, integer *
	k, complex_lotus *v, integer *ldv, complex_lotus *tau, complex_lotus *t, integer *ldt);

/* Subroutine */ int clascl_(char *type__, integer *kl, integer *ku, real_lotus *
	cfrom, real_lotus *cto, integer *m, integer *n, complex_lotus *a, integer *lda, 
	integer *info);

/* Subroutine */ int clascl2_(integer *m, integer *n, real_lotus *d__, complex_lotus *x, 
	integer *ldx);

/* Subroutine */ int claset_(char *uplo, integer *m, integer *n, complex_lotus *
	alpha, complex_lotus *beta, complex_lotus *a, integer *lda);

/* Subroutine */ int clasr_(char *side, char *pivot, char *direct, integer *m, 
	 integer *n, real_lotus *c__, real_lotus *s, complex_lotus *a, integer *lda);

/* Subroutine */ int classq_(integer *n, complex_lotus *x, integer *incx, real_lotus *
	scale, real_lotus *sumsq);

/* Subroutine */ int claswp_(integer *n, complex_lotus *a, integer *lda, integer *
	k1, integer *k2, integer *ipiv, integer *incx);

/* Subroutine */ int clasyf_(char *uplo, integer *n, integer *nb, integer *kb, 
	 complex_lotus *a, integer *lda, integer *ipiv, complex_lotus *w, integer *ldw, 
	integer *info);

/* Subroutine */ int clatbs_(char *uplo, char *trans, char *diag, char *
	normin, integer *n, integer *kd, complex_lotus *ab, integer *ldab, complex_lotus *
	x, real_lotus *scale, real_lotus *cnorm, integer *info);

/* Subroutine */ int clatdf_(integer *ijob, integer *n, complex_lotus *z__, integer 
	*ldz, complex_lotus *rhs, real_lotus *rdsum, real_lotus *rdscal, integer *ipiv, integer 
	*jpiv);

/* Subroutine */ int clatps_(char *uplo, char *trans, char *diag, char *
	normin, integer *n, complex_lotus *ap, complex_lotus *x, real_lotus *scale, real_lotus *cnorm, 
	 integer *info);

/* Subroutine */ int clatrd_(char *uplo, integer *n, integer *nb, complex_lotus *a, 
	integer *lda, real_lotus *e, complex_lotus *tau, complex_lotus *w, integer *ldw);

/* Subroutine */ int clatrs_(char *uplo, char *trans, char *diag, char *
	normin, integer *n, complex_lotus *a, integer *lda, complex_lotus *x, real_lotus *scale, 
	 real_lotus *cnorm, integer *info);

/* Subroutine */ int clatrz_(integer *m, integer *n, integer *l, complex_lotus *a, 
	integer *lda, complex_lotus *tau, complex_lotus *work);

/* Subroutine */ int clatzm_(char *side, integer *m, integer *n, complex_lotus *v, 
	integer *incv, complex_lotus *tau, complex_lotus *c1, complex_lotus *c2, integer *ldc, 
	complex_lotus *work);

/* Subroutine */ int clauu2_(char *uplo, integer *n, complex_lotus *a, integer *lda, 
	 integer *info);

/* Subroutine */ int clauum_(char *uplo, integer *n, complex_lotus *a, integer *lda, 
	 integer *info);

/* Subroutine */ int cpbcon_(char *uplo, integer *n, integer *kd, complex_lotus *ab, 
	 integer *ldab, real_lotus *anorm, real_lotus *rcond, complex_lotus *work, real_lotus *rwork, 
	integer *info);

/* Subroutine */ int cpbequ_(char *uplo, integer *n, integer *kd, complex_lotus *ab, 
	 integer *ldab, real_lotus *s, real_lotus *scond, real_lotus *amax, integer *info);

/* Subroutine */ int cpbrfs_(char *uplo, integer *n, integer *kd, integer *
	nrhs, complex_lotus *ab, integer *ldab, complex_lotus *afb, integer *ldafb, 
	complex_lotus *b, integer *ldb, complex_lotus *x, integer *ldx, real_lotus *ferr, real_lotus *
	berr, complex_lotus *work, real_lotus *rwork, integer *info);

/* Subroutine */ int cpbstf_(char *uplo, integer *n, integer *kd, complex_lotus *ab, 
	 integer *ldab, integer *info);

/* Subroutine */ int cpbsv_(char *uplo, integer *n, integer *kd, integer *
	nrhs, complex_lotus *ab, integer *ldab, complex_lotus *b, integer *ldb, integer *
	info);

/* Subroutine */ int cpbsvx_(char *fact, char *uplo, integer *n, integer *kd, 
	integer *nrhs, complex_lotus *ab, integer *ldab, complex_lotus *afb, integer *
	ldafb, char *equed, real_lotus *s, complex_lotus *b, integer *ldb, complex_lotus *x, 
	integer *ldx, real_lotus *rcond, real_lotus *ferr, real_lotus *berr, complex_lotus *work, 
	real_lotus *rwork, integer *info);

/* Subroutine */ int cpbtf2_(char *uplo, integer *n, integer *kd, complex_lotus *ab, 
	 integer *ldab, integer *info);

/* Subroutine */ int cpbtrf_(char *uplo, integer *n, integer *kd, complex_lotus *ab, 
	 integer *ldab, integer *info);

/* Subroutine */ int cpbtrs_(char *uplo, integer *n, integer *kd, integer *
	nrhs, complex_lotus *ab, integer *ldab, complex_lotus *b, integer *ldb, integer *
	info);

/* Subroutine */ int cpftrf_(char *transr, char *uplo, integer *n, complex_lotus *a, 
	 integer *info);

/* Subroutine */ int cpftri_(char *transr, char *uplo, integer *n, complex_lotus *a, 
	 integer *info);

/* Subroutine */ int cpftrs_(char *transr, char *uplo, integer *n, integer *
	nrhs, complex_lotus *a, complex_lotus *b, integer *ldb, integer *info);

/* Subroutine */ int cpocon_(char *uplo, integer *n, complex_lotus *a, integer *lda, 
	 real_lotus *anorm, real_lotus *rcond, complex_lotus *work, real_lotus *rwork, integer *info);

/* Subroutine */ int cpoequ_(integer *n, complex_lotus *a, integer *lda, real_lotus *s, 
	real_lotus *scond, real_lotus *amax, integer *info);

/* Subroutine */ int cpoequb_(integer *n, complex_lotus *a, integer *lda, real_lotus *s, 
	real_lotus *scond, real_lotus *amax, integer *info);

/* Subroutine */ int cporfs_(char *uplo, integer *n, integer *nrhs, complex_lotus *
	a, integer *lda, complex_lotus *af, integer *ldaf, complex_lotus *b, integer *ldb, 
	 complex_lotus *x, integer *ldx, real_lotus *ferr, real_lotus *berr, complex_lotus *work, 
	real_lotus *rwork, integer *info);

/* Subroutine */ int cporfsx_(char *uplo, char *equed, integer *n, integer *
	nrhs, complex_lotus *a, integer *lda, complex_lotus *af, integer *ldaf, real_lotus *s, 
	complex_lotus *b, integer *ldb, complex_lotus *x, integer *ldx, real_lotus *rcond, real_lotus 
	*berr, integer *n_err_bnds__, real_lotus *err_bnds_norm__, real_lotus *
	err_bnds_comp__, integer *nparams, real_lotus *params, complex_lotus *work, real_lotus *
	rwork, integer *info);

/* Subroutine */ int cposv_(char *uplo, integer *n, integer *nrhs, complex_lotus *a, 
	 integer *lda, complex_lotus *b, integer *ldb, integer *info);

/* Subroutine */ int cposvx_(char *fact, char *uplo, integer *n, integer *
	nrhs, complex_lotus *a, integer *lda, complex_lotus *af, integer *ldaf, char *
	equed, real_lotus *s, complex_lotus *b, integer *ldb, complex_lotus *x, integer *ldx, 
	real_lotus *rcond, real_lotus *ferr, real_lotus *berr, complex_lotus *work, real_lotus *rwork, 
	integer *info);

/* Subroutine */ int cposvxx_(char *fact, char *uplo, integer *n, integer *
	nrhs, complex_lotus *a, integer *lda, complex_lotus *af, integer *ldaf, char *
	equed, real_lotus *s, complex_lotus *b, integer *ldb, complex_lotus *x, integer *ldx, 
	real_lotus *rcond, real_lotus *rpvgrw, real_lotus *berr, integer *n_err_bnds__, real_lotus *
	err_bnds_norm__, real_lotus *err_bnds_comp__, integer *nparams, real_lotus *
	params, complex_lotus *work, real_lotus *rwork, integer *info);

/* Subroutine */ int cpotf2_(char *uplo, integer *n, complex_lotus *a, integer *lda, 
	 integer *info);

/* Subroutine */ int cpotrf_(char *uplo, integer *n, complex_lotus *a, integer *lda, 
	 integer *info);

/* Subroutine */ int cpotri_(char *uplo, integer *n, complex_lotus *a, integer *lda, 
	 integer *info);

/* Subroutine */ int cpotrs_(char *uplo, integer *n, integer *nrhs, complex_lotus *
	a, integer *lda, complex_lotus *b, integer *ldb, integer *info);

/* Subroutine */ int cppcon_(char *uplo, integer *n, complex_lotus *ap, real_lotus *anorm, 
	 real_lotus *rcond, complex_lotus *work, real_lotus *rwork, integer *info);

/* Subroutine */ int cppequ_(char *uplo, integer *n, complex_lotus *ap, real_lotus *s, 
	real_lotus *scond, real_lotus *amax, integer *info);

/* Subroutine */ int cpprfs_(char *uplo, integer *n, integer *nrhs, complex_lotus *
	ap, complex_lotus *afp, complex_lotus *b, integer *ldb, complex_lotus *x, integer *ldx, 
	real_lotus *ferr, real_lotus *berr, complex_lotus *work, real_lotus *rwork, integer *info);

/* Subroutine */ int cppsv_(char *uplo, integer *n, integer *nrhs, complex_lotus *
	ap, complex_lotus *b, integer *ldb, integer *info);

/* Subroutine */ int cppsvx_(char *fact, char *uplo, integer *n, integer *
	nrhs, complex_lotus *ap, complex_lotus *afp, char *equed, real_lotus *s, complex_lotus *b, 
	integer *ldb, complex_lotus *x, integer *ldx, real_lotus *rcond, real_lotus *ferr, real_lotus 
	*berr, complex_lotus *work, real_lotus *rwork, integer *info);

/* Subroutine */ int cpptrf_(char *uplo, integer *n, complex_lotus *ap, integer *
	info);

/* Subroutine */ int cpptri_(char *uplo, integer *n, complex_lotus *ap, integer *
	info);

/* Subroutine */ int cpptrs_(char *uplo, integer *n, integer *nrhs, complex_lotus *
	ap, complex_lotus *b, integer *ldb, integer *info);

/* Subroutine */ int cpstf2_(char *uplo, integer *n, complex_lotus *a, integer *lda, 
	 integer *piv, integer *rank, real_lotus *tol, real_lotus *work, integer *info);

/* Subroutine */ int cpstrf_(char *uplo, integer *n, complex_lotus *a, integer *lda, 
	 integer *piv, integer *rank, real_lotus *tol, real_lotus *work, integer *info);

/* Subroutine */ int cptcon_(integer *n, real_lotus *d__, complex_lotus *e, real_lotus *anorm, 
	real_lotus *rcond, real_lotus *rwork, integer *info);

/* Subroutine */ int cpteqr_(char *compz, integer *n, real_lotus *d__, real_lotus *e, 
	complex_lotus *z__, integer *ldz, real_lotus *work, integer *info);

/* Subroutine */ int cptrfs_(char *uplo, integer *n, integer *nrhs, real_lotus *d__, 
	 complex_lotus *e, real_lotus *df, complex_lotus *ef, complex_lotus *b, integer *ldb, complex_lotus 
	*x, integer *ldx, real_lotus *ferr, real_lotus *berr, complex_lotus *work, real_lotus *rwork, 
	integer *info);

/* Subroutine */ int cptsv_(integer *n, integer *nrhs, real_lotus *d__, complex_lotus *e, 
	complex_lotus *b, integer *ldb, integer *info);

/* Subroutine */ int cptsvx_(char *fact, integer *n, integer *nrhs, real_lotus *d__, 
	 complex_lotus *e, real_lotus *df, complex_lotus *ef, complex_lotus *b, integer *ldb, complex_lotus 
	*x, integer *ldx, real_lotus *rcond, real_lotus *ferr, real_lotus *berr, complex_lotus *work, 
	real_lotus *rwork, integer *info);

/* Subroutine */ int cpttrf_(integer *n, real_lotus *d__, complex_lotus *e, integer *info);

/* Subroutine */ int cpttrs_(char *uplo, integer *n, integer *nrhs, real_lotus *d__, 
	 complex_lotus *e, complex_lotus *b, integer *ldb, integer *info);

/* Subroutine */ int cptts2_(integer *iuplo, integer *n, integer *nrhs, real_lotus *
	d__, complex_lotus *e, complex_lotus *b, integer *ldb);

/* Subroutine */ int crot_(integer *n, complex_lotus *cx, integer *incx, complex_lotus *
	cy, integer *incy, real_lotus *c__, complex_lotus *s);

/* Subroutine */ int cspcon_(char *uplo, integer *n, complex_lotus *ap, integer *
	ipiv, real_lotus *anorm, real_lotus *rcond, complex_lotus *work, integer *info);

/* Subroutine */ int cspmv_(char *uplo, integer *n, complex_lotus *alpha, complex_lotus *
	ap, complex_lotus *x, integer *incx, complex_lotus *beta, complex_lotus *y, integer *
	incy);

/* Subroutine */ int cspr_(char *uplo, integer *n, complex_lotus *alpha, complex_lotus *x, 
	 integer *incx, complex_lotus *ap);

/* Subroutine */ int csprfs_(char *uplo, integer *n, integer *nrhs, complex_lotus *
	ap, complex_lotus *afp, integer *ipiv, complex_lotus *b, integer *ldb, complex_lotus *x, 
	 integer *ldx, real_lotus *ferr, real_lotus *berr, complex_lotus *work, real_lotus *rwork, 
	integer *info);

/* Subroutine */ int cspsv_(char *uplo, integer *n, integer *nrhs, complex_lotus *
	ap, integer *ipiv, complex_lotus *b, integer *ldb, integer *info);

/* Subroutine */ int cspsvx_(char *fact, char *uplo, integer *n, integer *
	nrhs, complex_lotus *ap, complex_lotus *afp, integer *ipiv, complex_lotus *b, integer *
	ldb, complex_lotus *x, integer *ldx, real_lotus *rcond, real_lotus *ferr, real_lotus *berr, 
	complex_lotus *work, real_lotus *rwork, integer *info);

/* Subroutine */ int csptrf_(char *uplo, integer *n, complex_lotus *ap, integer *
	ipiv, integer *info);

/* Subroutine */ int csptri_(char *uplo, integer *n, complex_lotus *ap, integer *
	ipiv, complex_lotus *work, integer *info);

/* Subroutine */ int csptrs_(char *uplo, integer *n, integer *nrhs, complex_lotus *
	ap, integer *ipiv, complex_lotus *b, integer *ldb, integer *info);

/* Subroutine */ int csrscl_(integer *n, real_lotus *sa, complex_lotus *sx, integer *incx);

/* Subroutine */ int cstedc_(char *compz, integer *n, real_lotus *d__, real_lotus *e, 
	complex_lotus *z__, integer *ldz, complex_lotus *work, integer *lwork, real_lotus *
	rwork, integer *lrwork, integer *iwork, integer *liwork, integer *
	info);

/* Subroutine */ int cstegr_(char *jobz, char *range, integer *n, real_lotus *d__, 
	real_lotus *e, real_lotus *vl, real_lotus *vu, integer *il, integer *iu, real_lotus *abstol, 
	integer *m, real_lotus *w, complex_lotus *z__, integer *ldz, integer *isuppz, 
	real_lotus *work, integer *lwork, integer *iwork, integer *liwork, integer *
	info);

/* Subroutine */ int cstein_(integer *n, real_lotus *d__, real_lotus *e, integer *m, real_lotus 
	*w, integer *iblock, integer *isplit, complex_lotus *z__, integer *ldz, 
	real_lotus *work, integer *iwork, integer *ifail, integer *info);

/* Subroutine */ int cstemr_(char *jobz, char *range, integer *n, real_lotus *d__, 
	real_lotus *e, real_lotus *vl, real_lotus *vu, integer *il, integer *iu, integer *m, 
	real_lotus *w, complex_lotus *z__, integer *ldz, integer *nzc, integer *isuppz, 
	logical *tryrac, real_lotus *work, integer *lwork, integer *iwork, integer *
	liwork, integer *info);

/* Subroutine */ int csteqr_(char *compz, integer *n, real_lotus *d__, real_lotus *e, 
	complex_lotus *z__, integer *ldz, real_lotus *work, integer *info);

/* Subroutine */ int csycon_(char *uplo, integer *n, complex_lotus *a, integer *lda, 
	 integer *ipiv, real_lotus *anorm, real_lotus *rcond, complex_lotus *work, integer *
	info);

/* Subroutine */ int csyequb_(char *uplo, integer *n, complex_lotus *a, integer *
	lda, real_lotus *s, real_lotus *scond, real_lotus *amax, complex_lotus *work, integer *info);

/* Subroutine */ int csymv_(char *uplo, integer *n, complex_lotus *alpha, complex_lotus *
	a, integer *lda, complex_lotus *x, integer *incx, complex_lotus *beta, complex_lotus *y, 
	 integer *incy);

/* Subroutine */ int csyr_(char *uplo, integer *n, complex_lotus *alpha, complex_lotus *x, 
	 integer *incx, complex_lotus *a, integer *lda);

/* Subroutine */ int csyrfs_(char *uplo, integer *n, integer *nrhs, complex_lotus *
	a, integer *lda, complex_lotus *af, integer *ldaf, integer *ipiv, complex_lotus *
	b, integer *ldb, complex_lotus *x, integer *ldx, real_lotus *ferr, real_lotus *berr, 
	complex_lotus *work, real_lotus *rwork, integer *info);

/* Subroutine */ int csyrfsx_(char *uplo, char *equed, integer *n, integer *
	nrhs, complex_lotus *a, integer *lda, complex_lotus *af, integer *ldaf, integer *
	ipiv, real_lotus *s, complex_lotus *b, integer *ldb, complex_lotus *x, integer *ldx, 
	real_lotus *rcond, real_lotus *berr, integer *n_err_bnds__, real_lotus *err_bnds_norm__, 
	 real_lotus *err_bnds_comp__, integer *nparams, real_lotus *params, complex_lotus *work, 
	 real_lotus *rwork, integer *info);

/* Subroutine */ int csysv_(char *uplo, integer *n, integer *nrhs, complex_lotus *a, 
	 integer *lda, integer *ipiv, complex_lotus *b, integer *ldb, complex_lotus *work, 
	 integer *lwork, integer *info);

/* Subroutine */ int csysvx_(char *fact, char *uplo, integer *n, integer *
	nrhs, complex_lotus *a, integer *lda, complex_lotus *af, integer *ldaf, integer *
	ipiv, complex_lotus *b, integer *ldb, complex_lotus *x, integer *ldx, real_lotus *rcond, 
	 real_lotus *ferr, real_lotus *berr, complex_lotus *work, integer *lwork, real_lotus *rwork, 
	integer *info);

/* Subroutine */ int csysvxx_(char *fact, char *uplo, integer *n, integer *
	nrhs, complex_lotus *a, integer *lda, complex_lotus *af, integer *ldaf, integer *
	ipiv, char *equed, real_lotus *s, complex_lotus *b, integer *ldb, complex_lotus *x, 
	integer *ldx, real_lotus *rcond, real_lotus *rpvgrw, real_lotus *berr, integer *
	n_err_bnds__, real_lotus *err_bnds_norm__, real_lotus *err_bnds_comp__, integer *
	nparams, real_lotus *params, complex_lotus *work, real_lotus *rwork, integer *info);

/* Subroutine */ int csytf2_(char *uplo, integer *n, complex_lotus *a, integer *lda, 
	 integer *ipiv, integer *info);

/* Subroutine */ int csytrf_(char *uplo, integer *n, complex_lotus *a, integer *lda, 
	 integer *ipiv, complex_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int csytri_(char *uplo, integer *n, complex_lotus *a, integer *lda, 
	 integer *ipiv, complex_lotus *work, integer *info);

/* Subroutine */ int csytrs_(char *uplo, integer *n, integer *nrhs, complex_lotus *
	a, integer *lda, integer *ipiv, complex_lotus *b, integer *ldb, integer *
	info);

/* Subroutine */ int ctbcon_(char *norm, char *uplo, char *diag, integer *n, 
	integer *kd, complex_lotus *ab, integer *ldab, real_lotus *rcond, complex_lotus *work, 
	real_lotus *rwork, integer *info);

/* Subroutine */ int ctbrfs_(char *uplo, char *trans, char *diag, integer *n, 
	integer *kd, integer *nrhs, complex_lotus *ab, integer *ldab, complex_lotus *b, 
	integer *ldb, complex_lotus *x, integer *ldx, real_lotus *ferr, real_lotus *berr, 
	complex_lotus *work, real_lotus *rwork, integer *info);

/* Subroutine */ int ctbtrs_(char *uplo, char *trans, char *diag, integer *n, 
	integer *kd, integer *nrhs, complex_lotus *ab, integer *ldab, complex_lotus *b, 
	integer *ldb, integer *info);

/* Subroutine */ int ctfsm_(char *transr, char *side, char *uplo, char *trans, 
	 char *diag, integer *m, integer *n, complex_lotus *alpha, complex_lotus *a, 
	complex_lotus *b, integer *ldb);

/* Subroutine */ int ctftri_(char *transr, char *uplo, char *diag, integer *n, 
	 complex_lotus *a, integer *info);

/* Subroutine */ int ctfttp_(char *transr, char *uplo, integer *n, complex_lotus *
	arf, complex_lotus *ap, integer *info);

/* Subroutine */ int ctfttr_(char *transr, char *uplo, integer *n, complex_lotus *
	arf, complex_lotus *a, integer *lda, integer *info);

/* Subroutine */ int ctgevc_(char *side, char *howmny, logical *select, 
	integer *n, complex_lotus *s, integer *lds, complex_lotus *p, integer *ldp, 
	complex_lotus *vl, integer *ldvl, complex_lotus *vr, integer *ldvr, integer *mm, 
	integer *m, complex_lotus *work, real_lotus *rwork, integer *info);

/* Subroutine */ int ctgex2_(logical *wantq, logical *wantz, integer *n, 
	complex_lotus *a, integer *lda, complex_lotus *b, integer *ldb, complex_lotus *q, 
	integer *ldq, complex_lotus *z__, integer *ldz, integer *j1, integer *info);

/* Subroutine */ int ctgexc_(logical *wantq, logical *wantz, integer *n, 
	complex_lotus *a, integer *lda, complex_lotus *b, integer *ldb, complex_lotus *q, 
	integer *ldq, complex_lotus *z__, integer *ldz, integer *ifst, integer *
	ilst, integer *info);

/* Subroutine */ int ctgsen_(integer *ijob, logical *wantq, logical *wantz, 
	logical *select, integer *n, complex_lotus *a, integer *lda, complex_lotus *b, 
	integer *ldb, complex_lotus *alpha, complex_lotus *beta, complex_lotus *q, integer *ldq, 
	 complex_lotus *z__, integer *ldz, integer *m, real_lotus *pl, real_lotus *pr, real_lotus *
	dif, complex_lotus *work, integer *lwork, integer *iwork, integer *liwork, 
	integer *info);

/* Subroutine */ int ctgsja_(char *jobu, char *jobv, char *jobq, integer *m, 
	integer *p, integer *n, integer *k, integer *l, complex_lotus *a, integer *
	lda, complex_lotus *b, integer *ldb, real_lotus *tola, real_lotus *tolb, real_lotus *alpha, 
	real_lotus *beta, complex_lotus *u, integer *ldu, complex_lotus *v, integer *ldv, 
	complex_lotus *q, integer *ldq, complex_lotus *work, integer *ncycle, integer *
	info);

/* Subroutine */ int ctgsna_(char *job, char *howmny, logical *select, 
	integer *n, complex_lotus *a, integer *lda, complex_lotus *b, integer *ldb, 
	complex_lotus *vl, integer *ldvl, complex_lotus *vr, integer *ldvr, real_lotus *s, real_lotus 
	*dif, integer *mm, integer *m, complex_lotus *work, integer *lwork, integer 
	*iwork, integer *info);

/* Subroutine */ int ctgsy2_(char *trans, integer *ijob, integer *m, integer *
	n, complex_lotus *a, integer *lda, complex_lotus *b, integer *ldb, complex_lotus *c__, 
	integer *ldc, complex_lotus *d__, integer *ldd, complex_lotus *e, integer *lde, 
	complex_lotus *f, integer *ldf, real_lotus *scale, real_lotus *rdsum, real_lotus *rdscal, 
	integer *info);

/* Subroutine */ int ctgsyl_(char *trans, integer *ijob, integer *m, integer *
	n, complex_lotus *a, integer *lda, complex_lotus *b, integer *ldb, complex_lotus *c__, 
	integer *ldc, complex_lotus *d__, integer *ldd, complex_lotus *e, integer *lde, 
	complex_lotus *f, integer *ldf, real_lotus *scale, real_lotus *dif, complex_lotus *work, 
	integer *lwork, integer *iwork, integer *info);

/* Subroutine */ int ctpcon_(char *norm, char *uplo, char *diag, integer *n, 
	complex_lotus *ap, real_lotus *rcond, complex_lotus *work, real_lotus *rwork, integer *info);

/* Subroutine */ int ctprfs_(char *uplo, char *trans, char *diag, integer *n, 
	integer *nrhs, complex_lotus *ap, complex_lotus *b, integer *ldb, complex_lotus *x, 
	integer *ldx, real_lotus *ferr, real_lotus *berr, complex_lotus *work, real_lotus *rwork, 
	integer *info);

/* Subroutine */ int ctptri_(char *uplo, char *diag, integer *n, complex_lotus *ap, 
	integer *info);

/* Subroutine */ int ctptrs_(char *uplo, char *trans, char *diag, integer *n, 
	integer *nrhs, complex_lotus *ap, complex_lotus *b, integer *ldb, integer *info);

/* Subroutine */ int ctpttf_(char *transr, char *uplo, integer *n, complex_lotus *
	ap, complex_lotus *arf, integer *info);

/* Subroutine */ int ctpttr_(char *uplo, integer *n, complex_lotus *ap, complex_lotus *a, 
	integer *lda, integer *info);

/* Subroutine */ int ctrcon_(char *norm, char *uplo, char *diag, integer *n, 
	complex_lotus *a, integer *lda, real_lotus *rcond, complex_lotus *work, real_lotus *rwork, 
	integer *info);

/* Subroutine */ int ctrevc_(char *side, char *howmny, logical *select, 
	integer *n, complex_lotus *t, integer *ldt, complex_lotus *vl, integer *ldvl, 
	complex_lotus *vr, integer *ldvr, integer *mm, integer *m, complex_lotus *work, 
	real_lotus *rwork, integer *info);

/* Subroutine */ int ctrexc_(char *compq, integer *n, complex_lotus *t, integer *
	ldt, complex_lotus *q, integer *ldq, integer *ifst, integer *ilst, integer *
	info);

/* Subroutine */ int ctrrfs_(char *uplo, char *trans, char *diag, integer *n, 
	integer *nrhs, complex_lotus *a, integer *lda, complex_lotus *b, integer *ldb, 
	complex_lotus *x, integer *ldx, real_lotus *ferr, real_lotus *berr, complex_lotus *work, real_lotus 
	*rwork, integer *info);

/* Subroutine */ int ctrsen_(char *job, char *compq, logical *select, integer 
	*n, complex_lotus *t, integer *ldt, complex_lotus *q, integer *ldq, complex_lotus *w, 
	integer *m, real_lotus *s, real_lotus *sep, complex_lotus *work, integer *lwork, 
	integer *info);

/* Subroutine */ int ctrsna_(char *job, char *howmny, logical *select, 
	integer *n, complex_lotus *t, integer *ldt, complex_lotus *vl, integer *ldvl, 
	complex_lotus *vr, integer *ldvr, real_lotus *s, real_lotus *sep, integer *mm, integer *
	m, complex_lotus *work, integer *ldwork, real_lotus *rwork, integer *info);

/* Subroutine */ int ctrsyl_(char *trana, char *tranb, integer *isgn, integer 
	*m, integer *n, complex_lotus *a, integer *lda, complex_lotus *b, integer *ldb, 
	complex_lotus *c__, integer *ldc, real_lotus *scale, integer *info);

/* Subroutine */ int ctrti2_(char *uplo, char *diag, integer *n, complex_lotus *a, 
	integer *lda, integer *info);

/* Subroutine */ int ctrtri_(char *uplo, char *diag, integer *n, complex_lotus *a, 
	integer *lda, integer *info);

/* Subroutine */ int ctrtrs_(char *uplo, char *trans, char *diag, integer *n, 
	integer *nrhs, complex_lotus *a, integer *lda, complex_lotus *b, integer *ldb, 
	integer *info);

/* Subroutine */ int ctrttf_(char *transr, char *uplo, integer *n, complex_lotus *a, 
	 integer *lda, complex_lotus *arf, integer *info);

/* Subroutine */ int ctrttp_(char *uplo, integer *n, complex_lotus *a, integer *lda, 
	 complex_lotus *ap, integer *info);

/* Subroutine */ int ctzrqf_(integer *m, integer *n, complex_lotus *a, integer *lda, 
	 complex_lotus *tau, integer *info);

/* Subroutine */ int ctzrzf_(integer *m, integer *n, complex_lotus *a, integer *lda, 
	 complex_lotus *tau, complex_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int cung2l_(integer *m, integer *n, integer *k, complex_lotus *a, 
	integer *lda, complex_lotus *tau, complex_lotus *work, integer *info);

/* Subroutine */ int cung2r_(integer *m, integer *n, integer *k, complex_lotus *a, 
	integer *lda, complex_lotus *tau, complex_lotus *work, integer *info);

/* Subroutine */ int cungbr_(char *vect, integer *m, integer *n, integer *k, 
	complex_lotus *a, integer *lda, complex_lotus *tau, complex_lotus *work, integer *lwork, 
	 integer *info);

/* Subroutine */ int cunghr_(integer *n, integer *ilo, integer *ihi, complex_lotus *
	a, integer *lda, complex_lotus *tau, complex_lotus *work, integer *lwork, integer 
	*info);

/* Subroutine */ int cungl2_(integer *m, integer *n, integer *k, complex_lotus *a, 
	integer *lda, complex_lotus *tau, complex_lotus *work, integer *info);

/* Subroutine */ int cunglq_(integer *m, integer *n, integer *k, complex_lotus *a, 
	integer *lda, complex_lotus *tau, complex_lotus *work, integer *lwork, integer *
	info);

/* Subroutine */ int cungql_(integer *m, integer *n, integer *k, complex_lotus *a, 
	integer *lda, complex_lotus *tau, complex_lotus *work, integer *lwork, integer *
	info);

/* Subroutine */ int cungqr_(integer *m, integer *n, integer *k, complex_lotus *a, 
	integer *lda, complex_lotus *tau, complex_lotus *work, integer *lwork, integer *
	info);

/* Subroutine */ int cungr2_(integer *m, integer *n, integer *k, complex_lotus *a, 
	integer *lda, complex_lotus *tau, complex_lotus *work, integer *info);

/* Subroutine */ int cungrq_(integer *m, integer *n, integer *k, complex_lotus *a, 
	integer *lda, complex_lotus *tau, complex_lotus *work, integer *lwork, integer *
	info);

/* Subroutine */ int cungtr_(char *uplo, integer *n, complex_lotus *a, integer *lda, 
	 complex_lotus *tau, complex_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int cunm2l_(char *side, char *trans, integer *m, integer *n, 
	integer *k, complex_lotus *a, integer *lda, complex_lotus *tau, complex_lotus *c__, 
	integer *ldc, complex_lotus *work, integer *info);

/* Subroutine */ int cunm2r_(char *side, char *trans, integer *m, integer *n, 
	integer *k, complex_lotus *a, integer *lda, complex_lotus *tau, complex_lotus *c__, 
	integer *ldc, complex_lotus *work, integer *info);

/* Subroutine */ int cunmbr_(char *vect, char *side, char *trans, integer *m, 
	integer *n, integer *k, complex_lotus *a, integer *lda, complex_lotus *tau, 
	complex_lotus *c__, integer *ldc, complex_lotus *work, integer *lwork, integer *
	info);

/* Subroutine */ int cunmhr_(char *side, char *trans, integer *m, integer *n, 
	integer *ilo, integer *ihi, complex_lotus *a, integer *lda, complex_lotus *tau, 
	complex_lotus *c__, integer *ldc, complex_lotus *work, integer *lwork, integer *
	info);

/* Subroutine */ int cunml2_(char *side, char *trans, integer *m, integer *n, 
	integer *k, complex_lotus *a, integer *lda, complex_lotus *tau, complex_lotus *c__, 
	integer *ldc, complex_lotus *work, integer *info);

/* Subroutine */ int cunmlq_(char *side, char *trans, integer *m, integer *n, 
	integer *k, complex_lotus *a, integer *lda, complex_lotus *tau, complex_lotus *c__, 
	integer *ldc, complex_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int cunmql_(char *side, char *trans, integer *m, integer *n, 
	integer *k, complex_lotus *a, integer *lda, complex_lotus *tau, complex_lotus *c__, 
	integer *ldc, complex_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int cunmqr_(char *side, char *trans, integer *m, integer *n, 
	integer *k, complex_lotus *a, integer *lda, complex_lotus *tau, complex_lotus *c__, 
	integer *ldc, complex_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int cunmr2_(char *side, char *trans, integer *m, integer *n, 
	integer *k, complex_lotus *a, integer *lda, complex_lotus *tau, complex_lotus *c__, 
	integer *ldc, complex_lotus *work, integer *info);

/* Subroutine */ int cunmr3_(char *side, char *trans, integer *m, integer *n, 
	integer *k, integer *l, complex_lotus *a, integer *lda, complex_lotus *tau, 
	complex_lotus *c__, integer *ldc, complex_lotus *work, integer *info);

/* Subroutine */ int cunmrq_(char *side, char *trans, integer *m, integer *n, 
	integer *k, complex_lotus *a, integer *lda, complex_lotus *tau, complex_lotus *c__, 
	integer *ldc, complex_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int cunmrz_(char *side, char *trans, integer *m, integer *n, 
	integer *k, integer *l, complex_lotus *a, integer *lda, complex_lotus *tau, 
	complex_lotus *c__, integer *ldc, complex_lotus *work, integer *lwork, integer *
	info);

/* Subroutine */ int cunmtr_(char *side, char *uplo, char *trans, integer *m, 
	integer *n, complex_lotus *a, integer *lda, complex_lotus *tau, complex_lotus *c__, 
	integer *ldc, complex_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int cupgtr_(char *uplo, integer *n, complex_lotus *ap, complex_lotus *
	tau, complex_lotus *q, integer *ldq, complex_lotus *work, integer *info);

/* Subroutine */ int cupmtr_(char *side, char *uplo, char *trans, integer *m, 
	integer *n, complex_lotus *ap, complex_lotus *tau, complex_lotus *c__, integer *ldc, 
	complex_lotus *work, integer *info);

/* Subroutine */ int dbdsdc_(char *uplo, char *compq, integer *n, doublereal_lotus *
	d__, doublereal_lotus *e, doublereal_lotus *u, integer *ldu, doublereal_lotus *vt, 
	integer *ldvt, doublereal_lotus *q, integer *iq, doublereal_lotus *work, integer *
	iwork, integer *info);

/* Subroutine */ int dbdsqr_(char *uplo, integer *n, integer *ncvt, integer *
	nru, integer *ncc, doublereal_lotus *d__, doublereal_lotus *e, doublereal_lotus *vt, 
	integer *ldvt, doublereal_lotus *u, integer *ldu, doublereal_lotus *c__, integer *
	ldc, doublereal_lotus *work, integer *info);

/* Subroutine */ int ddisna_(char *job, integer *m, integer *n, doublereal_lotus *
	d__, doublereal_lotus *sep, integer *info);

/* Subroutine */ int dgbbrd_(char *vect, integer *m, integer *n, integer *ncc, 
	 integer *kl, integer *ku, doublereal_lotus *ab, integer *ldab, doublereal_lotus *
	d__, doublereal_lotus *e, doublereal_lotus *q, integer *ldq, doublereal_lotus *pt, 
	integer *ldpt, doublereal_lotus *c__, integer *ldc, doublereal_lotus *work, 
	integer *info);

/* Subroutine */ int dgbcon_(char *norm, integer *n, integer *kl, integer *ku, 
	 doublereal_lotus *ab, integer *ldab, integer *ipiv, doublereal_lotus *anorm, 
	doublereal_lotus *rcond, doublereal_lotus *work, integer *iwork, integer *info);

/* Subroutine */ int dgbequ_(integer *m, integer *n, integer *kl, integer *ku, 
	 doublereal_lotus *ab, integer *ldab, doublereal_lotus *r__, doublereal_lotus *c__, 
	doublereal_lotus *rowcnd, doublereal_lotus *colcnd, doublereal_lotus *amax, integer *
	info);

/* Subroutine */ int dgbequb_(integer *m, integer *n, integer *kl, integer *
	ku, doublereal_lotus *ab, integer *ldab, doublereal_lotus *r__, doublereal_lotus *c__, 
	doublereal_lotus *rowcnd, doublereal_lotus *colcnd, doublereal_lotus *amax, integer *
	info);

/* Subroutine */ int dgbrfs_(char *trans, integer *n, integer *kl, integer *
	ku, integer *nrhs, doublereal_lotus *ab, integer *ldab, doublereal_lotus *afb, 
	integer *ldafb, integer *ipiv, doublereal_lotus *b, integer *ldb, 
	doublereal_lotus *x, integer *ldx, doublereal_lotus *ferr, doublereal_lotus *berr, 
	doublereal_lotus *work, integer *iwork, integer *info);

/* Subroutine */ int dgbrfsx_(char *trans, char *equed, integer *n, integer *
	kl, integer *ku, integer *nrhs, doublereal_lotus *ab, integer *ldab, 
	doublereal_lotus *afb, integer *ldafb, integer *ipiv, doublereal_lotus *r__, 
	doublereal_lotus *c__, doublereal_lotus *b, integer *ldb, doublereal_lotus *x, integer *
	ldx, doublereal_lotus *rcond, doublereal_lotus *berr, integer *n_err_bnds__, 
	doublereal_lotus *err_bnds_norm__, doublereal_lotus *err_bnds_comp__, integer *
	nparams, doublereal_lotus *params, doublereal_lotus *work, integer *iwork, 
	integer *info);

/* Subroutine */ int dgbsv_(integer *n, integer *kl, integer *ku, integer *
	nrhs, doublereal_lotus *ab, integer *ldab, integer *ipiv, doublereal_lotus *b, 
	integer *ldb, integer *info);

/* Subroutine */ int dgbsvx_(char *fact, char *trans, integer *n, integer *kl, 
	 integer *ku, integer *nrhs, doublereal_lotus *ab, integer *ldab, 
	doublereal_lotus *afb, integer *ldafb, integer *ipiv, char *equed, 
	doublereal_lotus *r__, doublereal_lotus *c__, doublereal_lotus *b, integer *ldb, 
	doublereal_lotus *x, integer *ldx, doublereal_lotus *rcond, doublereal_lotus *ferr, 
	doublereal_lotus *berr, doublereal_lotus *work, integer *iwork, integer *info);

/* Subroutine */ int dgbsvxx_(char *fact, char *trans, integer *n, integer *
	kl, integer *ku, integer *nrhs, doublereal_lotus *ab, integer *ldab, 
	doublereal_lotus *afb, integer *ldafb, integer *ipiv, char *equed, 
	doublereal_lotus *r__, doublereal_lotus *c__, doublereal_lotus *b, integer *ldb, 
	doublereal_lotus *x, integer *ldx, doublereal_lotus *rcond, doublereal_lotus *rpvgrw, 
	doublereal_lotus *berr, integer *n_err_bnds__, doublereal_lotus *err_bnds_norm__, 
	doublereal_lotus *err_bnds_comp__, integer *nparams, doublereal_lotus *params, 
	doublereal_lotus *work, integer *iwork, integer *info);

/* Subroutine */ int dgbtf2_(integer *m, integer *n, integer *kl, integer *ku, 
	 doublereal_lotus *ab, integer *ldab, integer *ipiv, integer *info);

/* Subroutine */ int dgbtrf_(integer *m, integer *n, integer *kl, integer *ku, 
	 doublereal_lotus *ab, integer *ldab, integer *ipiv, integer *info);

/* Subroutine */ int dgbtrs_(char *trans, integer *n, integer *kl, integer *
	ku, integer *nrhs, doublereal_lotus *ab, integer *ldab, integer *ipiv, 
	doublereal_lotus *b, integer *ldb, integer *info);

/* Subroutine */ int dgebak_(char *job, char *side, integer *n, integer *ilo, 
	integer *ihi, doublereal_lotus *scale, integer *m, doublereal_lotus *v, integer *
	ldv, integer *info);

/* Subroutine */ int dgebal_(char *job, integer *n, doublereal_lotus *a, integer *
	lda, integer *ilo, integer *ihi, doublereal_lotus *scale, integer *info);

/* Subroutine */ int dgebd2_(integer *m, integer *n, doublereal_lotus *a, integer *
	lda, doublereal_lotus *d__, doublereal_lotus *e, doublereal_lotus *tauq, doublereal_lotus *
	taup, doublereal_lotus *work, integer *info);

/* Subroutine */ int dgebrd_(integer *m, integer *n, doublereal_lotus *a, integer *
	lda, doublereal_lotus *d__, doublereal_lotus *e, doublereal_lotus *tauq, doublereal_lotus *
	taup, doublereal_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int dgecon_(char *norm, integer *n, doublereal_lotus *a, integer *
	lda, doublereal_lotus *anorm, doublereal_lotus *rcond, doublereal_lotus *work, integer *
	iwork, integer *info);

/* Subroutine */ int dgeequ_(integer *m, integer *n, doublereal_lotus *a, integer *
	lda, doublereal_lotus *r__, doublereal_lotus *c__, doublereal_lotus *rowcnd, doublereal_lotus 
	*colcnd, doublereal_lotus *amax, integer *info);

/* Subroutine */ int dgeequb_(integer *m, integer *n, doublereal_lotus *a, integer *
	lda, doublereal_lotus *r__, doublereal_lotus *c__, doublereal_lotus *rowcnd, doublereal_lotus 
	*colcnd, doublereal_lotus *amax, integer *info);

/* Subroutine */ int dgees_(char *jobvs, char *sort, L_fp select, integer *n, 
	doublereal_lotus *a, integer *lda, integer *sdim, doublereal_lotus *wr, 
	doublereal_lotus *wi, doublereal_lotus *vs, integer *ldvs, doublereal_lotus *work, 
	integer *lwork, logical *bwork, integer *info);

/* Subroutine */ int dgeesx_(char *jobvs, char *sort, L_fp select, char *
	sense, integer *n, doublereal_lotus *a, integer *lda, integer *sdim, 
	doublereal_lotus *wr, doublereal_lotus *wi, doublereal_lotus *vs, integer *ldvs, 
	doublereal_lotus *rconde, doublereal_lotus *rcondv, doublereal_lotus *work, integer *
	lwork, integer *iwork, integer *liwork, logical *bwork, integer *info);

/* Subroutine */ int dgeev_(char *jobvl, char *jobvr, integer *n, doublereal_lotus *
	a, integer *lda, doublereal_lotus *wr, doublereal_lotus *wi, doublereal_lotus *vl, 
	integer *ldvl, doublereal_lotus *vr, integer *ldvr, doublereal_lotus *work, 
	integer *lwork, integer *info);

/* Subroutine */ int dgeevx_(char *balanc, char *jobvl, char *jobvr, char *
	sense, integer *n, doublereal_lotus *a, integer *lda, doublereal_lotus *wr, 
	doublereal_lotus *wi, doublereal_lotus *vl, integer *ldvl, doublereal_lotus *vr, 
	integer *ldvr, integer *ilo, integer *ihi, doublereal_lotus *scale, 
	doublereal_lotus *abnrm, doublereal_lotus *rconde, doublereal_lotus *rcondv, doublereal_lotus 
	*work, integer *lwork, integer *iwork, integer *info);

/* Subroutine */ int dgegs_(char *jobvsl, char *jobvsr, integer *n, 
	doublereal_lotus *a, integer *lda, doublereal_lotus *b, integer *ldb, doublereal_lotus *
	alphar, doublereal_lotus *alphai, doublereal_lotus *beta, doublereal_lotus *vsl, 
	integer *ldvsl, doublereal_lotus *vsr, integer *ldvsr, doublereal_lotus *work, 
	integer *lwork, integer *info);

/* Subroutine */ int dgegv_(char *jobvl, char *jobvr, integer *n, doublereal_lotus *
	a, integer *lda, doublereal_lotus *b, integer *ldb, doublereal_lotus *alphar, 
	doublereal_lotus *alphai, doublereal_lotus *beta, doublereal_lotus *vl, integer *ldvl, 
	doublereal_lotus *vr, integer *ldvr, doublereal_lotus *work, integer *lwork, 
	integer *info);

/* Subroutine */ int dgehd2_(integer *n, integer *ilo, integer *ihi, 
	doublereal_lotus *a, integer *lda, doublereal_lotus *tau, doublereal_lotus *work, 
	integer *info);

/* Subroutine */ int dgehrd_(integer *n, integer *ilo, integer *ihi, 
	doublereal_lotus *a, integer *lda, doublereal_lotus *tau, doublereal_lotus *work, 
	integer *lwork, integer *info);

/* Subroutine */ int dgejsv_(char *joba, char *jobu, char *jobv, char *jobr, 
	char *jobt, char *jobp, integer *m, integer *n, doublereal_lotus *a, 
	integer *lda, doublereal_lotus *sva, doublereal_lotus *u, integer *ldu, 
	doublereal_lotus *v, integer *ldv, doublereal_lotus *work, integer *lwork, 
	integer *iwork, integer *info);

/* Subroutine */ int dgelq2_(integer *m, integer *n, doublereal_lotus *a, integer *
	lda, doublereal_lotus *tau, doublereal_lotus *work, integer *info);

/* Subroutine */ int dgelqf_(integer *m, integer *n, doublereal_lotus *a, integer *
	lda, doublereal_lotus *tau, doublereal_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int dgels_(char *trans, integer *m, integer *n, integer *
	nrhs, doublereal_lotus *a, integer *lda, doublereal_lotus *b, integer *ldb, 
	doublereal_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int dgelsd_(integer *m, integer *n, integer *nrhs, 
	doublereal_lotus *a, integer *lda, doublereal_lotus *b, integer *ldb, doublereal_lotus *
	s, doublereal_lotus *rcond, integer *rank, doublereal_lotus *work, integer *lwork, 
	 integer *iwork, integer *info);

/* Subroutine */ int dgelss_(integer *m, integer *n, integer *nrhs, 
	doublereal_lotus *a, integer *lda, doublereal_lotus *b, integer *ldb, doublereal_lotus *
	s, doublereal_lotus *rcond, integer *rank, doublereal_lotus *work, integer *lwork, 
	 integer *info);

/* Subroutine */ int dgelsx_(integer *m, integer *n, integer *nrhs, 
	doublereal_lotus *a, integer *lda, doublereal_lotus *b, integer *ldb, integer *
	jpvt, doublereal_lotus *rcond, integer *rank, doublereal_lotus *work, integer *
	info);

/* Subroutine */ int dgelsy_(integer *m, integer *n, integer *nrhs, 
	doublereal_lotus *a, integer *lda, doublereal_lotus *b, integer *ldb, integer *
	jpvt, doublereal_lotus *rcond, integer *rank, doublereal_lotus *work, integer *
	lwork, integer *info);

/* Subroutine */ int dgeql2_(integer *m, integer *n, doublereal_lotus *a, integer *
	lda, doublereal_lotus *tau, doublereal_lotus *work, integer *info);

/* Subroutine */ int dgeqlf_(integer *m, integer *n, doublereal_lotus *a, integer *
	lda, doublereal_lotus *tau, doublereal_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int dgeqp3_(integer *m, integer *n, doublereal_lotus *a, integer *
	lda, integer *jpvt, doublereal_lotus *tau, doublereal_lotus *work, integer *lwork, 
	 integer *info);

/* Subroutine */ int dgeqpf_(integer *m, integer *n, doublereal_lotus *a, integer *
	lda, integer *jpvt, doublereal_lotus *tau, doublereal_lotus *work, integer *info);

/* Subroutine */ int dgeqr2_(integer *m, integer *n, doublereal_lotus *a, integer *
	lda, doublereal_lotus *tau, doublereal_lotus *work, integer *info);

/* Subroutine */ int dgeqrf_(integer *m, integer *n, doublereal_lotus *a, integer *
	lda, doublereal_lotus *tau, doublereal_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int dgerfs_(char *trans, integer *n, integer *nrhs, 
	doublereal_lotus *a, integer *lda, doublereal_lotus *af, integer *ldaf, integer *
	ipiv, doublereal_lotus *b, integer *ldb, doublereal_lotus *x, integer *ldx, 
	doublereal_lotus *ferr, doublereal_lotus *berr, doublereal_lotus *work, integer *iwork, 
	integer *info);

/* Subroutine */ int dgerfsx_(char *trans, char *equed, integer *n, integer *
	nrhs, doublereal_lotus *a, integer *lda, doublereal_lotus *af, integer *ldaf, 
	integer *ipiv, doublereal_lotus *r__, doublereal_lotus *c__, doublereal_lotus *b, 
	integer *ldb, doublereal_lotus *x, integer *ldx, doublereal_lotus *rcond, 
	doublereal_lotus *berr, integer *n_err_bnds__, doublereal_lotus *err_bnds_norm__, 
	doublereal_lotus *err_bnds_comp__, integer *nparams, doublereal_lotus *params, 
	doublereal_lotus *work, integer *iwork, integer *info);

/* Subroutine */ int dgerq2_(integer *m, integer *n, doublereal_lotus *a, integer *
	lda, doublereal_lotus *tau, doublereal_lotus *work, integer *info);

/* Subroutine */ int dgerqf_(integer *m, integer *n, doublereal_lotus *a, integer *
	lda, doublereal_lotus *tau, doublereal_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int dgesc2_(integer *n, doublereal_lotus *a, integer *lda, 
	doublereal_lotus *rhs, integer *ipiv, integer *jpiv, doublereal_lotus *scale);

/* Subroutine */ int dgesdd_(char *jobz, integer *m, integer *n, doublereal_lotus *
	a, integer *lda, doublereal_lotus *s, doublereal_lotus *u, integer *ldu, 
	doublereal_lotus *vt, integer *ldvt, doublereal_lotus *work, integer *lwork, 
	integer *iwork, integer *info);

/* Subroutine */ int dgesv_(integer *n, integer *nrhs, doublereal_lotus *a, integer 
	*lda, integer *ipiv, doublereal_lotus *b, integer *ldb, integer *info);

/* Subroutine */ int dgesvd_(char *jobu, char *jobvt, integer *m, integer *n, 
	doublereal_lotus *a, integer *lda, doublereal_lotus *s, doublereal_lotus *u, integer *
	ldu, doublereal_lotus *vt, integer *ldvt, doublereal_lotus *work, integer *lwork, 
	integer *info);

/* Subroutine */ int dgesvj_(char *joba, char *jobu, char *jobv, integer *m, 
	integer *n, doublereal_lotus *a, integer *lda, doublereal_lotus *sva, integer *mv, 
	 doublereal_lotus *v, integer *ldv, doublereal_lotus *work, integer *lwork, 
	integer *info);

/* Subroutine */ int dgesvx_(char *fact, char *trans, integer *n, integer *
	nrhs, doublereal_lotus *a, integer *lda, doublereal_lotus *af, integer *ldaf, 
	integer *ipiv, char *equed, doublereal_lotus *r__, doublereal_lotus *c__, 
	doublereal_lotus *b, integer *ldb, doublereal_lotus *x, integer *ldx, doublereal_lotus *
	rcond, doublereal_lotus *ferr, doublereal_lotus *berr, doublereal_lotus *work, integer *
	iwork, integer *info);

/* Subroutine */ int dgesvxx_(char *fact, char *trans, integer *n, integer *
	nrhs, doublereal_lotus *a, integer *lda, doublereal_lotus *af, integer *ldaf, 
	integer *ipiv, char *equed, doublereal_lotus *r__, doublereal_lotus *c__, 
	doublereal_lotus *b, integer *ldb, doublereal_lotus *x, integer *ldx, doublereal_lotus *
	rcond, doublereal_lotus *rpvgrw, doublereal_lotus *berr, integer *n_err_bnds__, 
	doublereal_lotus *err_bnds_norm__, doublereal_lotus *err_bnds_comp__, integer *
	nparams, doublereal_lotus *params, doublereal_lotus *work, integer *iwork, 
	integer *info);

/* Subroutine */ int dgetc2_(integer *n, doublereal_lotus *a, integer *lda, integer 
	*ipiv, integer *jpiv, integer *info);

/* Subroutine */ int dgetf2_(integer *m, integer *n, doublereal_lotus *a, integer *
	lda, integer *ipiv, integer *info);

/* Subroutine */ int dgetrf_(integer *m, integer *n, doublereal_lotus *a, integer *
	lda, integer *ipiv, integer *info);

/* Subroutine */ int dgetri_(integer *n, doublereal_lotus *a, integer *lda, integer 
	*ipiv, doublereal_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int dgetrs_(char *trans, integer *n, integer *nrhs, 
	doublereal_lotus *a, integer *lda, integer *ipiv, doublereal_lotus *b, integer *
	ldb, integer *info);

/* Subroutine */ int dggbak_(char *job, char *side, integer *n, integer *ilo, 
	integer *ihi, doublereal_lotus *lscale, doublereal_lotus *rscale, integer *m, 
	doublereal_lotus *v, integer *ldv, integer *info);

/* Subroutine */ int dggbal_(char *job, integer *n, doublereal_lotus *a, integer *
	lda, doublereal_lotus *b, integer *ldb, integer *ilo, integer *ihi, 
	doublereal_lotus *lscale, doublereal_lotus *rscale, doublereal_lotus *work, integer *
	info);

/* Subroutine */ int dgges_(char *jobvsl, char *jobvsr, char *sort, L_fp 
	selctg, integer *n, doublereal_lotus *a, integer *lda, doublereal_lotus *b, 
	integer *ldb, integer *sdim, doublereal_lotus *alphar, doublereal_lotus *alphai, 
	doublereal_lotus *beta, doublereal_lotus *vsl, integer *ldvsl, doublereal_lotus *vsr, 
	integer *ldvsr, doublereal_lotus *work, integer *lwork, logical *bwork, 
	integer *info);

/* Subroutine */ int dggesx_(char *jobvsl, char *jobvsr, char *sort, L_fp 
	selctg, char *sense, integer *n, doublereal_lotus *a, integer *lda, 
	doublereal_lotus *b, integer *ldb, integer *sdim, doublereal_lotus *alphar, 
	doublereal_lotus *alphai, doublereal_lotus *beta, doublereal_lotus *vsl, integer *ldvsl, 
	 doublereal_lotus *vsr, integer *ldvsr, doublereal_lotus *rconde, doublereal_lotus *
	rcondv, doublereal_lotus *work, integer *lwork, integer *iwork, integer *
	liwork, logical *bwork, integer *info);

/* Subroutine */ int dggev_(char *jobvl, char *jobvr, integer *n, doublereal_lotus *
	a, integer *lda, doublereal_lotus *b, integer *ldb, doublereal_lotus *alphar, 
	doublereal_lotus *alphai, doublereal_lotus *beta, doublereal_lotus *vl, integer *ldvl, 
	doublereal_lotus *vr, integer *ldvr, doublereal_lotus *work, integer *lwork, 
	integer *info);

/* Subroutine */ int dggevx_(char *balanc, char *jobvl, char *jobvr, char *
	sense, integer *n, doublereal_lotus *a, integer *lda, doublereal_lotus *b, 
	integer *ldb, doublereal_lotus *alphar, doublereal_lotus *alphai, doublereal_lotus *
	beta, doublereal_lotus *vl, integer *ldvl, doublereal_lotus *vr, integer *ldvr, 
	integer *ilo, integer *ihi, doublereal_lotus *lscale, doublereal_lotus *rscale, 
	doublereal_lotus *abnrm, doublereal_lotus *bbnrm, doublereal_lotus *rconde, doublereal_lotus *
	rcondv, doublereal_lotus *work, integer *lwork, integer *iwork, logical *
	bwork, integer *info);

/* Subroutine */ int dggglm_(integer *n, integer *m, integer *p, doublereal_lotus *
	a, integer *lda, doublereal_lotus *b, integer *ldb, doublereal_lotus *d__, 
	doublereal_lotus *x, doublereal_lotus *y, doublereal_lotus *work, integer *lwork, 
	integer *info);

/* Subroutine */ int dgghrd_(char *compq, char *compz, integer *n, integer *
	ilo, integer *ihi, doublereal_lotus *a, integer *lda, doublereal_lotus *b, 
	integer *ldb, doublereal_lotus *q, integer *ldq, doublereal_lotus *z__, integer *
	ldz, integer *info);

/* Subroutine */ int dgglse_(integer *m, integer *n, integer *p, doublereal_lotus *
	a, integer *lda, doublereal_lotus *b, integer *ldb, doublereal_lotus *c__, 
	doublereal_lotus *d__, doublereal_lotus *x, doublereal_lotus *work, integer *lwork, 
	integer *info);

/* Subroutine */ int dggqrf_(integer *n, integer *m, integer *p, doublereal_lotus *
	a, integer *lda, doublereal_lotus *taua, doublereal_lotus *b, integer *ldb, 
	doublereal_lotus *taub, doublereal_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int dggrqf_(integer *m, integer *p, integer *n, doublereal_lotus *
	a, integer *lda, doublereal_lotus *taua, doublereal_lotus *b, integer *ldb, 
	doublereal_lotus *taub, doublereal_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int dggsvd_(char *jobu, char *jobv, char *jobq, integer *m, 
	integer *n, integer *p, integer *k, integer *l, doublereal_lotus *a, 
	integer *lda, doublereal_lotus *b, integer *ldb, doublereal_lotus *alpha, 
	doublereal_lotus *beta, doublereal_lotus *u, integer *ldu, doublereal_lotus *v, integer 
	*ldv, doublereal_lotus *q, integer *ldq, doublereal_lotus *work, integer *iwork, 
	integer *info);

/* Subroutine */ int dggsvp_(char *jobu, char *jobv, char *jobq, integer *m, 
	integer *p, integer *n, doublereal_lotus *a, integer *lda, doublereal_lotus *b, 
	integer *ldb, doublereal_lotus *tola, doublereal_lotus *tolb, integer *k, integer 
	*l, doublereal_lotus *u, integer *ldu, doublereal_lotus *v, integer *ldv, 
	doublereal_lotus *q, integer *ldq, integer *iwork, doublereal_lotus *tau, 
	doublereal_lotus *work, integer *info);

/* Subroutine */ int dgsvj0_(char *jobv, integer *m, integer *n, doublereal_lotus *
	a, integer *lda, doublereal_lotus *d__, doublereal_lotus *sva, integer *mv, 
	doublereal_lotus *v, integer *ldv, doublereal_lotus *eps, doublereal_lotus *sfmin, 
	doublereal_lotus *tol, integer *nsweep, doublereal_lotus *work, integer *lwork, 
	integer *info);

/* Subroutine */ int dgsvj1_(char *jobv, integer *m, integer *n, integer *n1, 
	doublereal_lotus *a, integer *lda, doublereal_lotus *d__, doublereal_lotus *sva, 
	integer *mv, doublereal_lotus *v, integer *ldv, doublereal_lotus *eps, doublereal_lotus 
	*sfmin, doublereal_lotus *tol, integer *nsweep, doublereal_lotus *work, integer *
	lwork, integer *info);

/* Subroutine */ int dgtcon_(char *norm, integer *n, doublereal_lotus *dl, 
	doublereal_lotus *d__, doublereal_lotus *du, doublereal_lotus *du2, integer *ipiv, 
	doublereal_lotus *anorm, doublereal_lotus *rcond, doublereal_lotus *work, integer *
	iwork, integer *info);

/* Subroutine */ int dgtrfs_(char *trans, integer *n, integer *nrhs, 
	doublereal_lotus *dl, doublereal_lotus *d__, doublereal_lotus *du, doublereal_lotus *dlf, 
	doublereal_lotus *df, doublereal_lotus *duf, doublereal_lotus *du2, integer *ipiv, 
	doublereal_lotus *b, integer *ldb, doublereal_lotus *x, integer *ldx, doublereal_lotus *
	ferr, doublereal_lotus *berr, doublereal_lotus *work, integer *iwork, integer *
	info);

/* Subroutine */ int dgtsv_(integer *n, integer *nrhs, doublereal_lotus *dl, 
	doublereal_lotus *d__, doublereal_lotus *du, doublereal_lotus *b, integer *ldb, integer 
	*info);

/* Subroutine */ int dgtsvx_(char *fact, char *trans, integer *n, integer *
	nrhs, doublereal_lotus *dl, doublereal_lotus *d__, doublereal_lotus *du, doublereal_lotus *
	dlf, doublereal_lotus *df, doublereal_lotus *duf, doublereal_lotus *du2, integer *ipiv, 
	doublereal_lotus *b, integer *ldb, doublereal_lotus *x, integer *ldx, doublereal_lotus *
	rcond, doublereal_lotus *ferr, doublereal_lotus *berr, doublereal_lotus *work, integer *
	iwork, integer *info);

/* Subroutine */ int dgttrf_(integer *n, doublereal_lotus *dl, doublereal_lotus *d__, 
	doublereal_lotus *du, doublereal_lotus *du2, integer *ipiv, integer *info);

/* Subroutine */ int dgttrs_(char *trans, integer *n, integer *nrhs, 
	doublereal_lotus *dl, doublereal_lotus *d__, doublereal_lotus *du, doublereal_lotus *du2, 
	integer *ipiv, doublereal_lotus *b, integer *ldb, integer *info);

/* Subroutine */ int dgtts2_(integer *itrans, integer *n, integer *nrhs, 
	doublereal_lotus *dl, doublereal_lotus *d__, doublereal_lotus *du, doublereal_lotus *du2, 
	integer *ipiv, doublereal_lotus *b, integer *ldb);

/* Subroutine */ int dhgeqz_(char *job, char *compq, char *compz, integer *n, 
	integer *ilo, integer *ihi, doublereal_lotus *h__, integer *ldh, doublereal_lotus 
	*t, integer *ldt, doublereal_lotus *alphar, doublereal_lotus *alphai, doublereal_lotus *
	beta, doublereal_lotus *q, integer *ldq, doublereal_lotus *z__, integer *ldz, 
	doublereal_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int dhsein_(char *side, char *eigsrc, char *initv, logical *
	select, integer *n, doublereal_lotus *h__, integer *ldh, doublereal_lotus *wr, 
	doublereal_lotus *wi, doublereal_lotus *vl, integer *ldvl, doublereal_lotus *vr, 
	integer *ldvr, integer *mm, integer *m, doublereal_lotus *work, integer *
	ifaill, integer *ifailr, integer *info);

/* Subroutine */ int dhseqr_(char *job, char *compz, integer *n, integer *ilo, 
	 integer *ihi, doublereal_lotus *h__, integer *ldh, doublereal_lotus *wr, 
	doublereal_lotus *wi, doublereal_lotus *z__, integer *ldz, doublereal_lotus *work, 
	integer *lwork, integer *info);

logical disnan_(doublereal_lotus *din);

/* Subroutine */ int dla_gbamv__(integer *trans, integer *m, integer *n, 
	integer *kl, integer *ku, doublereal_lotus *alpha, doublereal_lotus *ab, integer *
	ldab, doublereal_lotus *x, integer *incx, doublereal_lotus *beta, doublereal_lotus *y, 
	integer *incy);

doublereal_lotus dla_gbrcond__(char *trans, integer *n, integer *kl, integer *ku, 
	doublereal_lotus *ab, integer *ldab, doublereal_lotus *afb, integer *ldafb, 
	integer *ipiv, integer *cmode, doublereal_lotus *c__, integer *info, 
	doublereal_lotus *work, integer *iwork, ftnlen trans_len);

/* Subroutine */ int dla_gbrfsx_extended__(integer *prec_type__, integer *
	trans_type__, integer *n, integer *kl, integer *ku, integer *nrhs, 
	doublereal_lotus *ab, integer *ldab, doublereal_lotus *afb, integer *ldafb, 
	integer *ipiv, logical *colequ, doublereal_lotus *c__, doublereal_lotus *b, 
	integer *ldb, doublereal_lotus *y, integer *ldy, doublereal_lotus *berr_out__, 
	integer *n_norms__, doublereal_lotus *errs_n__, doublereal_lotus *errs_c__, 
	doublereal_lotus *res, doublereal_lotus *ayb, doublereal_lotus *dy, doublereal_lotus *
	y_tail__, doublereal_lotus *rcond, integer *ithresh, doublereal_lotus *rthresh, 
	doublereal_lotus *dz_ub__, logical *ignore_cwise__, integer *info);

doublereal_lotus dla_gbrpvgrw__(integer *n, integer *kl, integer *ku, integer *
	ncols, doublereal_lotus *ab, integer *ldab, doublereal_lotus *afb, integer *ldafb);

/* Subroutine */ int dla_geamv__(integer *trans, integer *m, integer *n, 
	doublereal_lotus *alpha, doublereal_lotus *a, integer *lda, doublereal_lotus *x, 
	integer *incx, doublereal_lotus *beta, doublereal_lotus *y, integer *incy);

doublereal_lotus dla_gercond__(char *trans, integer *n, doublereal_lotus *a, integer *lda,
	 doublereal_lotus *af, integer *ldaf, integer *ipiv, integer *cmode, 
	doublereal_lotus *c__, integer *info, doublereal_lotus *work, integer *iwork, 
	ftnlen trans_len);

/* Subroutine */ int dla_gerfsx_extended__(integer *prec_type__, integer *
	trans_type__, integer *n, integer *nrhs, doublereal_lotus *a, integer *lda, 
	doublereal_lotus *af, integer *ldaf, integer *ipiv, logical *colequ, 
	doublereal_lotus *c__, doublereal_lotus *b, integer *ldb, doublereal_lotus *y, integer *
	ldy, doublereal_lotus *berr_out__, integer *n_norms__, doublereal_lotus *errs_n__,
	 doublereal_lotus *errs_c__, doublereal_lotus *res, doublereal_lotus *ayb, doublereal_lotus *
	dy, doublereal_lotus *y_tail__, doublereal_lotus *rcond, integer *ithresh, 
	doublereal_lotus *rthresh, doublereal_lotus *dz_ub__, logical *ignore_cwise__, 
	integer *info);

/* Subroutine */ int dla_lin_berr__(integer *n, integer *nz, integer *nrhs, 
	doublereal_lotus *res, doublereal_lotus *ayb, doublereal_lotus *berr);

doublereal_lotus dla_porcond__(char *uplo, integer *n, doublereal_lotus *a, integer *lda, 
	doublereal_lotus *af, integer *ldaf, integer *cmode, doublereal_lotus *c__, 
	integer *info, doublereal_lotus *work, integer *iwork, ftnlen uplo_len);

/* Subroutine */ int dla_porfsx_extended__(integer *prec_type__, char *uplo, 
	integer *n, integer *nrhs, doublereal_lotus *a, integer *lda, doublereal_lotus *
	af, integer *ldaf, logical *colequ, doublereal_lotus *c__, doublereal_lotus *b, 
	integer *ldb, doublereal_lotus *y, integer *ldy, doublereal_lotus *berr_out__, 
	integer *n_norms__, doublereal_lotus *errs_n__, doublereal_lotus *errs_c__, 
	doublereal_lotus *res, doublereal_lotus *ayb, doublereal_lotus *dy, doublereal_lotus *
	y_tail__, doublereal_lotus *rcond, integer *ithresh, doublereal_lotus *rthresh, 
	doublereal_lotus *dz_ub__, logical *ignore_cwise__, integer *info, ftnlen 
	uplo_len);

doublereal_lotus dla_porpvgrw__(char *uplo, integer *ncols, doublereal_lotus *a, integer *
	lda, doublereal_lotus *af, integer *ldaf, doublereal_lotus *work, ftnlen uplo_len);

doublereal_lotus dla_rpvgrw__(integer *n, integer *ncols, doublereal_lotus *a, integer *
	lda, doublereal_lotus *af, integer *ldaf);

/* Subroutine */ int dla_syamv__(integer *uplo, integer *n, doublereal_lotus *alpha,
	 doublereal_lotus *a, integer *lda, doublereal_lotus *x, integer *incx, 
	doublereal_lotus *beta, doublereal_lotus *y, integer *incy);

doublereal_lotus dla_syrcond__(char *uplo, integer *n, doublereal_lotus *a, integer *lda, 
	doublereal_lotus *af, integer *ldaf, integer *ipiv, integer *cmode, 
	doublereal_lotus *c__, integer *info, doublereal_lotus *work, integer *iwork, 
	ftnlen uplo_len);

/* Subroutine */ int dla_syrfsx_extended__(integer *prec_type__, char *uplo, 
	integer *n, integer *nrhs, doublereal_lotus *a, integer *lda, doublereal_lotus *
	af, integer *ldaf, integer *ipiv, logical *colequ, doublereal_lotus *c__, 
	doublereal_lotus *b, integer *ldb, doublereal_lotus *y, integer *ldy, doublereal_lotus *
	berr_out__, integer *n_norms__, doublereal_lotus *errs_n__, doublereal_lotus *
	errs_c__, doublereal_lotus *res, doublereal_lotus *ayb, doublereal_lotus *dy, 
	doublereal_lotus *y_tail__, doublereal_lotus *rcond, integer *ithresh, doublereal_lotus 
	*rthresh, doublereal_lotus *dz_ub__, logical *ignore_cwise__, integer *info,
	 ftnlen uplo_len);

doublereal_lotus dla_syrpvgrw__(char *uplo, integer *n, integer *info, doublereal_lotus *
	a, integer *lda, doublereal_lotus *af, integer *ldaf, integer *ipiv, 
	doublereal_lotus *work, ftnlen uplo_len);

/* Subroutine */ int dla_wwaddw__(integer *n, doublereal_lotus *x, doublereal_lotus *y, 
	doublereal_lotus *w);

/* Subroutine */ int dlabad_(doublereal_lotus *small, doublereal_lotus *large);

/* Subroutine */ int dlabrd_(integer *m, integer *n, integer *nb, doublereal_lotus *
	a, integer *lda, doublereal_lotus *d__, doublereal_lotus *e, doublereal_lotus *tauq, 
	doublereal_lotus *taup, doublereal_lotus *x, integer *ldx, doublereal_lotus *y, integer 
	*ldy);

/* Subroutine */ int dlacn2_(integer *n, doublereal_lotus *v, doublereal_lotus *x, 
	integer *isgn, doublereal_lotus *est, integer *kase, integer *isave);

/* Subroutine */ int dlacon_(integer *n, doublereal_lotus *v, doublereal_lotus *x, 
	integer *isgn, doublereal_lotus *est, integer *kase);

/* Subroutine */ int dlacpy_(char *uplo, integer *m, integer *n, doublereal_lotus *
	a, integer *lda, doublereal_lotus *b, integer *ldb);

/* Subroutine */ int dladiv_(doublereal_lotus *a, doublereal_lotus *b, doublereal_lotus *c__, 
	doublereal_lotus *d__, doublereal_lotus *p, doublereal_lotus *q);

/* Subroutine */ int dlae2_(doublereal_lotus *a, doublereal_lotus *b, doublereal_lotus *c__, 
	doublereal_lotus *rt1, doublereal_lotus *rt2);

/* Subroutine */ int dlaebz_(integer *ijob, integer *nitmax, integer *n, 
	integer *mmax, integer *minp, integer *nbmin, doublereal_lotus *abstol, 
	doublereal_lotus *reltol, doublereal_lotus *pivmin, doublereal_lotus *d__, doublereal_lotus *
	e, doublereal_lotus *e2, integer *nval, doublereal_lotus *ab, doublereal_lotus *c__, 
	integer *mout, integer *nab, doublereal_lotus *work, integer *iwork, 
	integer *info);

/* Subroutine */ int dlaed0_(integer *icompq, integer *qsiz, integer *n, 
	doublereal_lotus *d__, doublereal_lotus *e, doublereal_lotus *q, integer *ldq, 
	doublereal_lotus *qstore, integer *ldqs, doublereal_lotus *work, integer *iwork, 
	integer *info);

/* Subroutine */ int dlaed1_(integer *n, doublereal_lotus *d__, doublereal_lotus *q, 
	integer *ldq, integer *indxq, doublereal_lotus *rho, integer *cutpnt, 
	doublereal_lotus *work, integer *iwork, integer *info);

/* Subroutine */ int dlaed2_(integer *k, integer *n, integer *n1, doublereal_lotus *
	d__, doublereal_lotus *q, integer *ldq, integer *indxq, doublereal_lotus *rho, 
	doublereal_lotus *z__, doublereal_lotus *dlamda, doublereal_lotus *w, doublereal_lotus *q2, 
	integer *indx, integer *indxc, integer *indxp, integer *coltyp, 
	integer *info);

/* Subroutine */ int dlaed3_(integer *k, integer *n, integer *n1, doublereal_lotus *
	d__, doublereal_lotus *q, integer *ldq, doublereal_lotus *rho, doublereal_lotus *dlamda, 
	 doublereal_lotus *q2, integer *indx, integer *ctot, doublereal_lotus *w, 
	doublereal_lotus *s, integer *info);

/* Subroutine */ int dlaed4_(integer *n, integer *i__, doublereal_lotus *d__, 
	doublereal_lotus *z__, doublereal_lotus *delta, doublereal_lotus *rho, doublereal_lotus *dlam, 
	 integer *info);

/* Subroutine */ int dlaed5_(integer *i__, doublereal_lotus *d__, doublereal_lotus *z__, 
	doublereal_lotus *delta, doublereal_lotus *rho, doublereal_lotus *dlam);

/* Subroutine */ int dlaed6_(integer *kniter, logical *orgati, doublereal_lotus *
	rho, doublereal_lotus *d__, doublereal_lotus *z__, doublereal_lotus *finit, doublereal_lotus *
	tau, integer *info);

/* Subroutine */ int dlaed7_(integer *icompq, integer *n, integer *qsiz, 
	integer *tlvls, integer *curlvl, integer *curpbm, doublereal_lotus *d__, 
	doublereal_lotus *q, integer *ldq, integer *indxq, doublereal_lotus *rho, integer 
	*cutpnt, doublereal_lotus *qstore, integer *qptr, integer *prmptr, integer *
	perm, integer *givptr, integer *givcol, doublereal_lotus *givnum, 
	doublereal_lotus *work, integer *iwork, integer *info);

/* Subroutine */ int dlaed8_(integer *icompq, integer *k, integer *n, integer 
	*qsiz, doublereal_lotus *d__, doublereal_lotus *q, integer *ldq, integer *indxq, 
	doublereal_lotus *rho, integer *cutpnt, doublereal_lotus *z__, doublereal_lotus *dlamda, 
	 doublereal_lotus *q2, integer *ldq2, doublereal_lotus *w, integer *perm, integer 
	*givptr, integer *givcol, doublereal_lotus *givnum, integer *indxp, integer 
	*indx, integer *info);

/* Subroutine */ int dlaed9_(integer *k, integer *kstart, integer *kstop, 
	integer *n, doublereal_lotus *d__, doublereal_lotus *q, integer *ldq, doublereal_lotus *
	rho, doublereal_lotus *dlamda, doublereal_lotus *w, doublereal_lotus *s, integer *lds, 
	integer *info);

/* Subroutine */ int dlaeda_(integer *n, integer *tlvls, integer *curlvl, 
	integer *curpbm, integer *prmptr, integer *perm, integer *givptr, 
	integer *givcol, doublereal_lotus *givnum, doublereal_lotus *q, integer *qptr, 
	doublereal_lotus *z__, doublereal_lotus *ztemp, integer *info);

/* Subroutine */ int dlaein_(logical *rightv, logical *noinit, integer *n, 
	doublereal_lotus *h__, integer *ldh, doublereal_lotus *wr, doublereal_lotus *wi, 
	doublereal_lotus *vr, doublereal_lotus *vi, doublereal_lotus *b, integer *ldb, 
	doublereal_lotus *work, doublereal_lotus *eps3, doublereal_lotus *smlnum, doublereal_lotus *
	bignum, integer *info);

/* Subroutine */ int dlaev2_(doublereal_lotus *a, doublereal_lotus *b, doublereal_lotus *c__, 
	doublereal_lotus *rt1, doublereal_lotus *rt2, doublereal_lotus *cs1, doublereal_lotus *sn1);

/* Subroutine */ int dlaexc_(logical *wantq, integer *n, doublereal_lotus *t, 
	integer *ldt, doublereal_lotus *q, integer *ldq, integer *j1, integer *n1, 
	integer *n2, doublereal_lotus *work, integer *info);

/* Subroutine */ int dlag2_(doublereal_lotus *a, integer *lda, doublereal_lotus *b, 
	integer *ldb, doublereal_lotus *safmin, doublereal_lotus *scale1, doublereal_lotus *
	scale2, doublereal_lotus *wr1, doublereal_lotus *wr2, doublereal_lotus *wi);

/* Subroutine */ int dlag2s_(integer *m, integer *n, doublereal_lotus *a, integer *
	lda, real_lotus *sa, integer *ldsa, integer *info);

/* Subroutine */ int dlags2_(logical *upper, doublereal_lotus *a1, doublereal_lotus *a2, 
	doublereal_lotus *a3, doublereal_lotus *b1, doublereal_lotus *b2, doublereal_lotus *b3, 
	doublereal_lotus *csu, doublereal_lotus *snu, doublereal_lotus *csv, doublereal_lotus *snv, 
	doublereal_lotus *csq, doublereal_lotus *snq);

/* Subroutine */ int dlagtf_(integer *n, doublereal_lotus *a, doublereal_lotus *lambda, 
	doublereal_lotus *b, doublereal_lotus *c__, doublereal_lotus *tol, doublereal_lotus *d__, 
	integer *in, integer *info);

/* Subroutine */ int dlagtm_(char *trans, integer *n, integer *nrhs, 
	doublereal_lotus *alpha, doublereal_lotus *dl, doublereal_lotus *d__, doublereal_lotus *du, 
	doublereal_lotus *x, integer *ldx, doublereal_lotus *beta, doublereal_lotus *b, integer 
	*ldb);

/* Subroutine */ int dlagts_(integer *job, integer *n, doublereal_lotus *a, 
	doublereal_lotus *b, doublereal_lotus *c__, doublereal_lotus *d__, integer *in, 
	doublereal_lotus *y, doublereal_lotus *tol, integer *info);

/* Subroutine */ int dlagv2_(doublereal_lotus *a, integer *lda, doublereal_lotus *b, 
	integer *ldb, doublereal_lotus *alphar, doublereal_lotus *alphai, doublereal_lotus *
	beta, doublereal_lotus *csl, doublereal_lotus *snl, doublereal_lotus *csr, doublereal_lotus *
	snr);

/* Subroutine */ int dlahqr_(logical *wantt, logical *wantz, integer *n, 
	integer *ilo, integer *ihi, doublereal_lotus *h__, integer *ldh, doublereal_lotus 
	*wr, doublereal_lotus *wi, integer *iloz, integer *ihiz, doublereal_lotus *z__, 
	integer *ldz, integer *info);

/* Subroutine */ int dlahr2_(integer *n, integer *k, integer *nb, doublereal_lotus *
	a, integer *lda, doublereal_lotus *tau, doublereal_lotus *t, integer *ldt, 
	doublereal_lotus *y, integer *ldy);

/* Subroutine */ int dlahrd_(integer *n, integer *k, integer *nb, doublereal_lotus *
	a, integer *lda, doublereal_lotus *tau, doublereal_lotus *t, integer *ldt, 
	doublereal_lotus *y, integer *ldy);

/* Subroutine */ int dlaic1_(integer *job, integer *j, doublereal_lotus *x, 
	doublereal_lotus *sest, doublereal_lotus *w, doublereal_lotus *gamma, doublereal_lotus *
	sestpr, doublereal_lotus *s, doublereal_lotus *c__);

logical dlaisnan_(doublereal_lotus *din1, doublereal_lotus *din2);

/* Subroutine */ int dlaln2_(logical *ltrans, integer *na, integer *nw, 
	doublereal_lotus *smin, doublereal_lotus *ca, doublereal_lotus *a, integer *lda, 
	doublereal_lotus *d1, doublereal_lotus *d2, doublereal_lotus *b, integer *ldb, 
	doublereal_lotus *wr, doublereal_lotus *wi, doublereal_lotus *x, integer *ldx, 
	doublereal_lotus *scale, doublereal_lotus *xnorm, integer *info);

/* Subroutine */ int dlals0_(integer *icompq, integer *nl, integer *nr, 
	integer *sqre, integer *nrhs, doublereal_lotus *b, integer *ldb, doublereal_lotus 
	*bx, integer *ldbx, integer *perm, integer *givptr, integer *givcol, 
	integer *ldgcol, doublereal_lotus *givnum, integer *ldgnum, doublereal_lotus *
	poles, doublereal_lotus *difl, doublereal_lotus *difr, doublereal_lotus *z__, integer *
	k, doublereal_lotus *c__, doublereal_lotus *s, doublereal_lotus *work, integer *info);

/* Subroutine */ int dlalsa_(integer *icompq, integer *smlsiz, integer *n, 
	integer *nrhs, doublereal_lotus *b, integer *ldb, doublereal_lotus *bx, integer *
	ldbx, doublereal_lotus *u, integer *ldu, doublereal_lotus *vt, integer *k, 
	doublereal_lotus *difl, doublereal_lotus *difr, doublereal_lotus *z__, doublereal_lotus *
	poles, integer *givptr, integer *givcol, integer *ldgcol, integer *
	perm, doublereal_lotus *givnum, doublereal_lotus *c__, doublereal_lotus *s, doublereal_lotus *
	work, integer *iwork, integer *info);

/* Subroutine */ int dlalsd_(char *uplo, integer *smlsiz, integer *n, integer 
	*nrhs, doublereal_lotus *d__, doublereal_lotus *e, doublereal_lotus *b, integer *ldb, 
	doublereal_lotus *rcond, integer *rank, doublereal_lotus *work, integer *iwork, 
	integer *info);

/* Subroutine */ int dlamrg_(integer *n1, integer *n2, doublereal_lotus *a, integer 
	*dtrd1, integer *dtrd2, integer *index);

integer dlaneg_(integer *n, doublereal_lotus *d__, doublereal_lotus *lld, doublereal_lotus *
	sigma, doublereal_lotus *pivmin, integer *r__);

doublereal_lotus dlangb_(char *norm, integer *n, integer *kl, integer *ku, 
	doublereal_lotus *ab, integer *ldab, doublereal_lotus *work);

doublereal_lotus dlange_(char *norm, integer *m, integer *n, doublereal_lotus *a, integer 
	*lda, doublereal_lotus *work);

doublereal_lotus dlangt_(char *norm, integer *n, doublereal_lotus *dl, doublereal_lotus *d__, 
	doublereal_lotus *du);

doublereal_lotus dlanhs_(char *norm, integer *n, doublereal_lotus *a, integer *lda, 
	doublereal_lotus *work);

doublereal_lotus dlansb_(char *norm, char *uplo, integer *n, integer *k, doublereal_lotus 
	*ab, integer *ldab, doublereal_lotus *work);

doublereal_lotus dlansf_(char *norm, char *transr, char *uplo, integer *n, 
	doublereal_lotus *a, doublereal_lotus *work);

doublereal_lotus dlansp_(char *norm, char *uplo, integer *n, doublereal_lotus *ap, 
	doublereal_lotus *work);

doublereal_lotus dlanst_(char *norm, integer *n, doublereal_lotus *d__, doublereal_lotus *e);

doublereal_lotus dlansy_(char *norm, char *uplo, integer *n, doublereal_lotus *a, integer 
	*lda, doublereal_lotus *work);

doublereal_lotus dlantb_(char *norm, char *uplo, char *diag, integer *n, integer *k, 
	 doublereal_lotus *ab, integer *ldab, doublereal_lotus *work);

doublereal_lotus dlantp_(char *norm, char *uplo, char *diag, integer *n, doublereal_lotus 
	*ap, doublereal_lotus *work);

doublereal_lotus dlantr_(char *norm, char *uplo, char *diag, integer *m, integer *n, 
	 doublereal_lotus *a, integer *lda, doublereal_lotus *work);

/* Subroutine */ int dlanv2_(doublereal_lotus *a, doublereal_lotus *b, doublereal_lotus *c__, 
	doublereal_lotus *d__, doublereal_lotus *rt1r, doublereal_lotus *rt1i, doublereal_lotus *rt2r, 
	 doublereal_lotus *rt2i, doublereal_lotus *cs, doublereal_lotus *sn);

/* Subroutine */ int dlapll_(integer *n, doublereal_lotus *x, integer *incx, 
	doublereal_lotus *y, integer *incy, doublereal_lotus *ssmin);

/* Subroutine */ int dlapmt_(logical *forwrd, integer *m, integer *n, 
	doublereal_lotus *x, integer *ldx, integer *k);

doublereal_lotus dlapy2_(doublereal_lotus *x, doublereal_lotus *y);

doublereal_lotus dlapy3_(doublereal_lotus *x, doublereal_lotus *y, doublereal_lotus *z__);

/* Subroutine */ int dlaqgb_(integer *m, integer *n, integer *kl, integer *ku, 
	 doublereal_lotus *ab, integer *ldab, doublereal_lotus *r__, doublereal_lotus *c__, 
	doublereal_lotus *rowcnd, doublereal_lotus *colcnd, doublereal_lotus *amax, char *equed);

/* Subroutine */ int dlaqge_(integer *m, integer *n, doublereal_lotus *a, integer *
	lda, doublereal_lotus *r__, doublereal_lotus *c__, doublereal_lotus *rowcnd, doublereal_lotus 
	*colcnd, doublereal_lotus *amax, char *equed);

/* Subroutine */ int dlaqp2_(integer *m, integer *n, integer *offset, 
	doublereal_lotus *a, integer *lda, integer *jpvt, doublereal_lotus *tau, 
	doublereal_lotus *vn1, doublereal_lotus *vn2, doublereal_lotus *work);

/* Subroutine */ int dlaqps_(integer *m, integer *n, integer *offset, integer 
	*nb, integer *kb, doublereal_lotus *a, integer *lda, integer *jpvt, 
	doublereal_lotus *tau, doublereal_lotus *vn1, doublereal_lotus *vn2, doublereal_lotus *auxv, 
	doublereal_lotus *f, integer *ldf);

/* Subroutine */ int dlaqr0_(logical *wantt, logical *wantz, integer *n, 
	integer *ilo, integer *ihi, doublereal_lotus *h__, integer *ldh, doublereal_lotus 
	*wr, doublereal_lotus *wi, integer *iloz, integer *ihiz, doublereal_lotus *z__, 
	integer *ldz, doublereal_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int dlaqr1_(integer *n, doublereal_lotus *h__, integer *ldh, 
	doublereal_lotus *sr1, doublereal_lotus *si1, doublereal_lotus *sr2, doublereal_lotus *si2, 
	doublereal_lotus *v);

/* Subroutine */ int dlaqr2_(logical *wantt, logical *wantz, integer *n, 
	integer *ktop, integer *kbot, integer *nw, doublereal_lotus *h__, integer *
	ldh, integer *iloz, integer *ihiz, doublereal_lotus *z__, integer *ldz, 
	integer *ns, integer *nd, doublereal_lotus *sr, doublereal_lotus *si, doublereal_lotus *
	v, integer *ldv, integer *nh, doublereal_lotus *t, integer *ldt, integer *
	nv, doublereal_lotus *wv, integer *ldwv, doublereal_lotus *work, integer *lwork);

/* Subroutine */ int dlaqr3_(logical *wantt, logical *wantz, integer *n, 
	integer *ktop, integer *kbot, integer *nw, doublereal_lotus *h__, integer *
	ldh, integer *iloz, integer *ihiz, doublereal_lotus *z__, integer *ldz, 
	integer *ns, integer *nd, doublereal_lotus *sr, doublereal_lotus *si, doublereal_lotus *
	v, integer *ldv, integer *nh, doublereal_lotus *t, integer *ldt, integer *
	nv, doublereal_lotus *wv, integer *ldwv, doublereal_lotus *work, integer *lwork);

/* Subroutine */ int dlaqr4_(logical *wantt, logical *wantz, integer *n, 
	integer *ilo, integer *ihi, doublereal_lotus *h__, integer *ldh, doublereal_lotus 
	*wr, doublereal_lotus *wi, integer *iloz, integer *ihiz, doublereal_lotus *z__, 
	integer *ldz, doublereal_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int dlaqr5_(logical *wantt, logical *wantz, integer *kacc22, 
	integer *n, integer *ktop, integer *kbot, integer *nshfts, doublereal_lotus 
	*sr, doublereal_lotus *si, doublereal_lotus *h__, integer *ldh, integer *iloz, 
	integer *ihiz, doublereal_lotus *z__, integer *ldz, doublereal_lotus *v, integer *
	ldv, doublereal_lotus *u, integer *ldu, integer *nv, doublereal_lotus *wv, 
	integer *ldwv, integer *nh, doublereal_lotus *wh, integer *ldwh);

/* Subroutine */ int dlaqsb_(char *uplo, integer *n, integer *kd, doublereal_lotus *
	ab, integer *ldab, doublereal_lotus *s, doublereal_lotus *scond, doublereal_lotus *amax, 
	 char *equed);

/* Subroutine */ int dlaqsp_(char *uplo, integer *n, doublereal_lotus *ap, 
	doublereal_lotus *s, doublereal_lotus *scond, doublereal_lotus *amax, char *equed);

/* Subroutine */ int dlaqsy_(char *uplo, integer *n, doublereal_lotus *a, integer *
	lda, doublereal_lotus *s, doublereal_lotus *scond, doublereal_lotus *amax, char *equed);

/* Subroutine */ int dlaqtr_(logical *ltran, logical *lreal_lotus, integer *n, 
	doublereal_lotus *t, integer *ldt, doublereal_lotus *b, doublereal_lotus *w, doublereal_lotus 
	*scale, doublereal_lotus *x, doublereal_lotus *work, integer *info);

/* Subroutine */ int dlar1v_(integer *n, integer *b1, integer *bn, doublereal_lotus 
	*lambda, doublereal_lotus *d__, doublereal_lotus *l, doublereal_lotus *ld, doublereal_lotus *
	lld, doublereal_lotus *pivmin, doublereal_lotus *gaptol, doublereal_lotus *z__, logical 
	*wantnc, integer *negcnt, doublereal_lotus *ztz, doublereal_lotus *mingma, 
	integer *r__, integer *isuppz, doublereal_lotus *nrminv, doublereal_lotus *resid, 
	doublereal_lotus *rqcorr, doublereal_lotus *work);

/* Subroutine */ int dlar2v_(integer *n, doublereal_lotus *x, doublereal_lotus *y, 
	doublereal_lotus *z__, integer *incx, doublereal_lotus *c__, doublereal_lotus *s, 
	integer *incc);

/* Subroutine */ int dlarf_(char *side, integer *m, integer *n, doublereal_lotus *v, 
	 integer *incv, doublereal_lotus *tau, doublereal_lotus *c__, integer *ldc, 
	doublereal_lotus *work);

/* Subroutine */ int dlarfb_(char *side, char *trans, char *direct, char *
	storev, integer *m, integer *n, integer *k, doublereal_lotus *v, integer *
	ldv, doublereal_lotus *t, integer *ldt, doublereal_lotus *c__, integer *ldc, 
	doublereal_lotus *work, integer *ldwork);

/* Subroutine */ int dlarfg_(integer *n, doublereal_lotus *alpha, doublereal_lotus *x, 
	integer *incx, doublereal_lotus *tau);

/* Subroutine */ int dlarfp_(integer *n, doublereal_lotus *alpha, doublereal_lotus *x, 
	integer *incx, doublereal_lotus *tau);

/* Subroutine */ int dlarft_(char *direct, char *storev, integer *n, integer *
	k, doublereal_lotus *v, integer *ldv, doublereal_lotus *tau, doublereal_lotus *t, 
	integer *ldt);

/* Subroutine */ int dlarfx_(char *side, integer *m, integer *n, doublereal_lotus *
	v, doublereal_lotus *tau, doublereal_lotus *c__, integer *ldc, doublereal_lotus *work);

/* Subroutine */ int dlargv_(integer *n, doublereal_lotus *x, integer *incx, 
	doublereal_lotus *y, integer *incy, doublereal_lotus *c__, integer *incc);

/* Subroutine */ int dlarnv_(integer *idist, integer *iseed, integer *n, 
	doublereal_lotus *x);

/* Subroutine */ int dlarra_(integer *n, doublereal_lotus *d__, doublereal_lotus *e, 
	doublereal_lotus *e2, doublereal_lotus *spltol, doublereal_lotus *tnrm, integer *nsplit, 
	 integer *isplit, integer *info);

/* Subroutine */ int dlarrb_(integer *n, doublereal_lotus *d__, doublereal_lotus *lld, 
	integer *ifirst, integer *ilast, doublereal_lotus *rtol1, doublereal_lotus *rtol2, 
	 integer *offset, doublereal_lotus *w, doublereal_lotus *wgap, doublereal_lotus *werr, 
	doublereal_lotus *work, integer *iwork, doublereal_lotus *pivmin, doublereal_lotus *
	spdiam, integer *twist, integer *info);

/* Subroutine */ int dlarrc_(char *jobt, integer *n, doublereal_lotus *vl, 
	doublereal_lotus *vu, doublereal_lotus *d__, doublereal_lotus *e, doublereal_lotus *pivmin, 
	integer *eigcnt, integer *lcnt, integer *rcnt, integer *info);

/* Subroutine */ int dlarrd_(char *range, char *order, integer *n, doublereal_lotus 
	*vl, doublereal_lotus *vu, integer *il, integer *iu, doublereal_lotus *gers, 
	doublereal_lotus *reltol, doublereal_lotus *d__, doublereal_lotus *e, doublereal_lotus *e2, 
	doublereal_lotus *pivmin, integer *nsplit, integer *isplit, integer *m, 
	doublereal_lotus *w, doublereal_lotus *werr, doublereal_lotus *wl, doublereal_lotus *wu, 
	integer *iblock, integer *indexw, doublereal_lotus *work, integer *iwork, 
	integer *info);

/* Subroutine */ int dlarre_(char *range, integer *n, doublereal_lotus *vl, 
	doublereal_lotus *vu, integer *il, integer *iu, doublereal_lotus *d__, doublereal_lotus 
	*e, doublereal_lotus *e2, doublereal_lotus *rtol1, doublereal_lotus *rtol2, doublereal_lotus *
	spltol, integer *nsplit, integer *isplit, integer *m, doublereal_lotus *w, 
	doublereal_lotus *werr, doublereal_lotus *wgap, integer *iblock, integer *indexw, 
	doublereal_lotus *gers, doublereal_lotus *pivmin, doublereal_lotus *work, integer *
	iwork, integer *info);

/* Subroutine */ int dlarrf_(integer *n, doublereal_lotus *d__, doublereal_lotus *l, 
	doublereal_lotus *ld, integer *clstrt, integer *clend, doublereal_lotus *w, 
	doublereal_lotus *wgap, doublereal_lotus *werr, doublereal_lotus *spdiam, doublereal_lotus *
	clgapl, doublereal_lotus *clgapr, doublereal_lotus *pivmin, doublereal_lotus *sigma, 
	doublereal_lotus *dplus, doublereal_lotus *lplus, doublereal_lotus *work, integer *info);

/* Subroutine */ int dlarrj_(integer *n, doublereal_lotus *d__, doublereal_lotus *e2, 
	integer *ifirst, integer *ilast, doublereal_lotus *rtol, integer *offset, 
	doublereal_lotus *w, doublereal_lotus *werr, doublereal_lotus *work, integer *iwork, 
	doublereal_lotus *pivmin, doublereal_lotus *spdiam, integer *info);

/* Subroutine */ int dlarrk_(integer *n, integer *iw, doublereal_lotus *gl, 
	doublereal_lotus *gu, doublereal_lotus *d__, doublereal_lotus *e2, doublereal_lotus *pivmin, 
	doublereal_lotus *reltol, doublereal_lotus *w, doublereal_lotus *werr, integer *info);

/* Subroutine */ int dlarrr_(integer *n, doublereal_lotus *d__, doublereal_lotus *e, 
	integer *info);

/* Subroutine */ int dlarrv_(integer *n, doublereal_lotus *vl, doublereal_lotus *vu, 
	doublereal_lotus *d__, doublereal_lotus *l, doublereal_lotus *pivmin, integer *isplit, 
	integer *m, integer *dol, integer *dou, doublereal_lotus *minrgp, 
	doublereal_lotus *rtol1, doublereal_lotus *rtol2, doublereal_lotus *w, doublereal_lotus *werr, 
	 doublereal_lotus *wgap, integer *iblock, integer *indexw, doublereal_lotus *gers, 
	 doublereal_lotus *z__, integer *ldz, integer *isuppz, doublereal_lotus *work, 
	integer *iwork, integer *info);

/* Subroutine */ int dlarscl2_(integer *m, integer *n, doublereal_lotus *d__, 
	doublereal_lotus *x, integer *ldx);

/* Subroutine */ int dlartg_(doublereal_lotus *f, doublereal_lotus *g, doublereal_lotus *cs, 
	doublereal_lotus *sn, doublereal_lotus *r__);

/* Subroutine */ int dlartv_(integer *n, doublereal_lotus *x, integer *incx, 
	doublereal_lotus *y, integer *incy, doublereal_lotus *c__, doublereal_lotus *s, integer 
	*incc);

/* Subroutine */ int dlaruv_(integer *iseed, integer *n, doublereal_lotus *x);

/* Subroutine */ int dlarz_(char *side, integer *m, integer *n, integer *l, 
	doublereal_lotus *v, integer *incv, doublereal_lotus *tau, doublereal_lotus *c__, 
	integer *ldc, doublereal_lotus *work);

/* Subroutine */ int dlarzb_(char *side, char *trans, char *direct, char *
	storev, integer *m, integer *n, integer *k, integer *l, doublereal_lotus *v, 
	 integer *ldv, doublereal_lotus *t, integer *ldt, doublereal_lotus *c__, integer *
	ldc, doublereal_lotus *work, integer *ldwork);

/* Subroutine */ int dlarzt_(char *direct, char *storev, integer *n, integer *
	k, doublereal_lotus *v, integer *ldv, doublereal_lotus *tau, doublereal_lotus *t, 
	integer *ldt);

/* Subroutine */ int dlas2_(doublereal_lotus *f, doublereal_lotus *g, doublereal_lotus *h__, 
	doublereal_lotus *ssmin, doublereal_lotus *ssmax);

/* Subroutine */ int dlascl_(char *type__, integer *kl, integer *ku, 
	doublereal_lotus *cfrom, doublereal_lotus *cto, integer *m, integer *n, 
	doublereal_lotus *a, integer *lda, integer *info);

/* Subroutine */ int dlascl2_(integer *m, integer *n, doublereal_lotus *d__, 
	doublereal_lotus *x, integer *ldx);

/* Subroutine */ int dlasd0_(integer *n, integer *sqre, doublereal_lotus *d__, 
	doublereal_lotus *e, doublereal_lotus *u, integer *ldu, doublereal_lotus *vt, integer *
	ldvt, integer *smlsiz, integer *iwork, doublereal_lotus *work, integer *
	info);

/* Subroutine */ int dlasd1_(integer *nl, integer *nr, integer *sqre, 
	doublereal_lotus *d__, doublereal_lotus *alpha, doublereal_lotus *beta, doublereal_lotus *u, 
	integer *ldu, doublereal_lotus *vt, integer *ldvt, integer *idxq, integer *
	iwork, doublereal_lotus *work, integer *info);

/* Subroutine */ int dlasd2_(integer *nl, integer *nr, integer *sqre, integer 
	*k, doublereal_lotus *d__, doublereal_lotus *z__, doublereal_lotus *alpha, doublereal_lotus *
	beta, doublereal_lotus *u, integer *ldu, doublereal_lotus *vt, integer *ldvt, 
	doublereal_lotus *dsigma, doublereal_lotus *u2, integer *ldu2, doublereal_lotus *vt2, 
	integer *ldvt2, integer *idxp, integer *idx, integer *idxc, integer *
	idxq, integer *coltyp, integer *info);

/* Subroutine */ int dlasd3_(integer *nl, integer *nr, integer *sqre, integer 
	*k, doublereal_lotus *d__, doublereal_lotus *q, integer *ldq, doublereal_lotus *dsigma, 
	doublereal_lotus *u, integer *ldu, doublereal_lotus *u2, integer *ldu2, 
	doublereal_lotus *vt, integer *ldvt, doublereal_lotus *vt2, integer *ldvt2, 
	integer *idxc, integer *ctot, doublereal_lotus *z__, integer *info);

/* Subroutine */ int dlasd4_(integer *n, integer *i__, doublereal_lotus *d__, 
	doublereal_lotus *z__, doublereal_lotus *delta, doublereal_lotus *rho, doublereal_lotus *
	sigma, doublereal_lotus *work, integer *info);

/* Subroutine */ int dlasd5_(integer *i__, doublereal_lotus *d__, doublereal_lotus *z__, 
	doublereal_lotus *delta, doublereal_lotus *rho, doublereal_lotus *dsigma, doublereal_lotus *
	work);

/* Subroutine */ int dlasd6_(integer *icompq, integer *nl, integer *nr, 
	integer *sqre, doublereal_lotus *d__, doublereal_lotus *vf, doublereal_lotus *vl, 
	doublereal_lotus *alpha, doublereal_lotus *beta, integer *idxq, integer *perm, 
	integer *givptr, integer *givcol, integer *ldgcol, doublereal_lotus *givnum, 
	 integer *ldgnum, doublereal_lotus *poles, doublereal_lotus *difl, doublereal_lotus *
	difr, doublereal_lotus *z__, integer *k, doublereal_lotus *c__, doublereal_lotus *s, 
	doublereal_lotus *work, integer *iwork, integer *info);

/* Subroutine */ int dlasd7_(integer *icompq, integer *nl, integer *nr, 
	integer *sqre, integer *k, doublereal_lotus *d__, doublereal_lotus *z__, 
	doublereal_lotus *zw, doublereal_lotus *vf, doublereal_lotus *vfw, doublereal_lotus *vl, 
	doublereal_lotus *vlw, doublereal_lotus *alpha, doublereal_lotus *beta, doublereal_lotus *
	dsigma, integer *idx, integer *idxp, integer *idxq, integer *perm, 
	integer *givptr, integer *givcol, integer *ldgcol, doublereal_lotus *givnum, 
	 integer *ldgnum, doublereal_lotus *c__, doublereal_lotus *s, integer *info);

/* Subroutine */ int dlasd8_(integer *icompq, integer *k, doublereal_lotus *d__, 
	doublereal_lotus *z__, doublereal_lotus *vf, doublereal_lotus *vl, doublereal_lotus *difl, 
	doublereal_lotus *difr, integer *lddifr, doublereal_lotus *dsigma, doublereal_lotus *
	work, integer *info);

/* Subroutine */ int dlasda_(integer *icompq, integer *smlsiz, integer *n, 
	integer *sqre, doublereal_lotus *d__, doublereal_lotus *e, doublereal_lotus *u, integer 
	*ldu, doublereal_lotus *vt, integer *k, doublereal_lotus *difl, doublereal_lotus *difr, 
	doublereal_lotus *z__, doublereal_lotus *poles, integer *givptr, integer *givcol, 
	integer *ldgcol, integer *perm, doublereal_lotus *givnum, doublereal_lotus *c__, 
	doublereal_lotus *s, doublereal_lotus *work, integer *iwork, integer *info);

/* Subroutine */ int dlasdq_(char *uplo, integer *sqre, integer *n, integer *
	ncvt, integer *nru, integer *ncc, doublereal_lotus *d__, doublereal_lotus *e, 
	doublereal_lotus *vt, integer *ldvt, doublereal_lotus *u, integer *ldu, 
	doublereal_lotus *c__, integer *ldc, doublereal_lotus *work, integer *info);

/* Subroutine */ int dlasdt_(integer *n, integer *lvl, integer *nd, integer *
	inode, integer *ndiml, integer *ndimr, integer *msub);

/* Subroutine */ int dlaset_(char *uplo, integer *m, integer *n, doublereal_lotus *
	alpha, doublereal_lotus *beta, doublereal_lotus *a, integer *lda);

/* Subroutine */ int dlasq1_(integer *n, doublereal_lotus *d__, doublereal_lotus *e, 
	doublereal_lotus *work, integer *info);

/* Subroutine */ int dlasq2_(integer *n, doublereal_lotus *z__, integer *info);

/* Subroutine */ int dlasq3_(integer *i0, integer *n0, doublereal_lotus *z__, 
	integer *pp, doublereal_lotus *dmin__, doublereal_lotus *sigma, doublereal_lotus *desig, 
	 doublereal_lotus *qmax, integer *nfail, integer *iter, integer *ndiv, 
	logical *ieee, integer *ttype, doublereal_lotus *dmin1, doublereal_lotus *dmin2, 
	doublereal_lotus *dn, doublereal_lotus *dn1, doublereal_lotus *dn2, doublereal_lotus *g, 
	doublereal_lotus *tau);

/* Subroutine */ int dlasq4_(integer *i0, integer *n0, doublereal_lotus *z__, 
	integer *pp, integer *n0in, doublereal_lotus *dmin__, doublereal_lotus *dmin1, 
	doublereal_lotus *dmin2, doublereal_lotus *dn, doublereal_lotus *dn1, doublereal_lotus *dn2, 
	doublereal_lotus *tau, integer *ttype, doublereal_lotus *g);

/* Subroutine */ int dlasq5_(integer *i0, integer *n0, doublereal_lotus *z__, 
	integer *pp, doublereal_lotus *tau, doublereal_lotus *dmin__, doublereal_lotus *dmin1, 
	doublereal_lotus *dmin2, doublereal_lotus *dn, doublereal_lotus *dnm1, doublereal_lotus *dnm2, 
	 logical *ieee);

/* Subroutine */ int dlasq6_(integer *i0, integer *n0, doublereal_lotus *z__, 
	integer *pp, doublereal_lotus *dmin__, doublereal_lotus *dmin1, doublereal_lotus *dmin2, 
	 doublereal_lotus *dn, doublereal_lotus *dnm1, doublereal_lotus *dnm2);

/* Subroutine */ int dlasr_(char *side, char *pivot, char *direct, integer *m, 
	 integer *n, doublereal_lotus *c__, doublereal_lotus *s, doublereal_lotus *a, integer *
	lda);

/* Subroutine */ int dlasrt_(char *id, integer *n, doublereal_lotus *d__, integer *
	info);

/* Subroutine */ int dlassq_(integer *n, doublereal_lotus *x, integer *incx, 
	doublereal_lotus *scale, doublereal_lotus *sumsq);

/* Subroutine */ int dlasv2_(doublereal_lotus *f, doublereal_lotus *g, doublereal_lotus *h__, 
	doublereal_lotus *ssmin, doublereal_lotus *ssmax, doublereal_lotus *snr, doublereal_lotus *
	csr, doublereal_lotus *snl, doublereal_lotus *csl);

/* Subroutine */ int dlaswp_(integer *n, doublereal_lotus *a, integer *lda, integer 
	*k1, integer *k2, integer *ipiv, integer *incx);

/* Subroutine */ int dlasy2_(logical *ltranl, logical *ltranr, integer *isgn, 
	integer *n1, integer *n2, doublereal_lotus *tl, integer *ldtl, doublereal_lotus *
	tr, integer *ldtr, doublereal_lotus *b, integer *ldb, doublereal_lotus *scale, 
	doublereal_lotus *x, integer *ldx, doublereal_lotus *xnorm, integer *info);

/* Subroutine */ int dlasyf_(char *uplo, integer *n, integer *nb, integer *kb, 
	 doublereal_lotus *a, integer *lda, integer *ipiv, doublereal_lotus *w, integer *
	ldw, integer *info);

/* Subroutine */ int dlat2s_(char *uplo, integer *n, doublereal_lotus *a, integer *
	lda, real_lotus *sa, integer *ldsa, integer *info);

/* Subroutine */ int dlatbs_(char *uplo, char *trans, char *diag, char *
	normin, integer *n, integer *kd, doublereal_lotus *ab, integer *ldab, 
	doublereal_lotus *x, doublereal_lotus *scale, doublereal_lotus *cnorm, integer *info);

/* Subroutine */ int dlatdf_(integer *ijob, integer *n, doublereal_lotus *z__, 
	integer *ldz, doublereal_lotus *rhs, doublereal_lotus *rdsum, doublereal_lotus *rdscal, 
	integer *ipiv, integer *jpiv);

/* Subroutine */ int dlatps_(char *uplo, char *trans, char *diag, char *
	normin, integer *n, doublereal_lotus *ap, doublereal_lotus *x, doublereal_lotus *scale, 
	doublereal_lotus *cnorm, integer *info);

/* Subroutine */ int dlatrd_(char *uplo, integer *n, integer *nb, doublereal_lotus *
	a, integer *lda, doublereal_lotus *e, doublereal_lotus *tau, doublereal_lotus *w, 
	integer *ldw);

/* Subroutine */ int dlatrs_(char *uplo, char *trans, char *diag, char *
	normin, integer *n, doublereal_lotus *a, integer *lda, doublereal_lotus *x, 
	doublereal_lotus *scale, doublereal_lotus *cnorm, integer *info);

/* Subroutine */ int dlatrz_(integer *m, integer *n, integer *l, doublereal_lotus *
	a, integer *lda, doublereal_lotus *tau, doublereal_lotus *work);

/* Subroutine */ int dlatzm_(char *side, integer *m, integer *n, doublereal_lotus *
	v, integer *incv, doublereal_lotus *tau, doublereal_lotus *c1, doublereal_lotus *c2, 
	integer *ldc, doublereal_lotus *work);

/* Subroutine */ int dlauu2_(char *uplo, integer *n, doublereal_lotus *a, integer *
	lda, integer *info);

/* Subroutine */ int dlauum_(char *uplo, integer *n, doublereal_lotus *a, integer *
	lda, integer *info);

/* Subroutine */ int dopgtr_(char *uplo, integer *n, doublereal_lotus *ap, 
	doublereal_lotus *tau, doublereal_lotus *q, integer *ldq, doublereal_lotus *work, 
	integer *info);

/* Subroutine */ int dopmtr_(char *side, char *uplo, char *trans, integer *m, 
	integer *n, doublereal_lotus *ap, doublereal_lotus *tau, doublereal_lotus *c__, integer 
	*ldc, doublereal_lotus *work, integer *info);

/* Subroutine */ int dorg2l_(integer *m, integer *n, integer *k, doublereal_lotus *
	a, integer *lda, doublereal_lotus *tau, doublereal_lotus *work, integer *info);

/* Subroutine */ int dorg2r_(integer *m, integer *n, integer *k, doublereal_lotus *
	a, integer *lda, doublereal_lotus *tau, doublereal_lotus *work, integer *info);

/* Subroutine */ int dorgbr_(char *vect, integer *m, integer *n, integer *k, 
	doublereal_lotus *a, integer *lda, doublereal_lotus *tau, doublereal_lotus *work, 
	integer *lwork, integer *info);

/* Subroutine */ int dorghr_(integer *n, integer *ilo, integer *ihi, 
	doublereal_lotus *a, integer *lda, doublereal_lotus *tau, doublereal_lotus *work, 
	integer *lwork, integer *info);

/* Subroutine */ int dorgl2_(integer *m, integer *n, integer *k, doublereal_lotus *
	a, integer *lda, doublereal_lotus *tau, doublereal_lotus *work, integer *info);

/* Subroutine */ int dorglq_(integer *m, integer *n, integer *k, doublereal_lotus *
	a, integer *lda, doublereal_lotus *tau, doublereal_lotus *work, integer *lwork, 
	integer *info);

/* Subroutine */ int dorgql_(integer *m, integer *n, integer *k, doublereal_lotus *
	a, integer *lda, doublereal_lotus *tau, doublereal_lotus *work, integer *lwork, 
	integer *info);

/* Subroutine */ int dorgqr_(integer *m, integer *n, integer *k, doublereal_lotus *
	a, integer *lda, doublereal_lotus *tau, doublereal_lotus *work, integer *lwork, 
	integer *info);

/* Subroutine */ int dorgr2_(integer *m, integer *n, integer *k, doublereal_lotus *
	a, integer *lda, doublereal_lotus *tau, doublereal_lotus *work, integer *info);

/* Subroutine */ int dorgrq_(integer *m, integer *n, integer *k, doublereal_lotus *
	a, integer *lda, doublereal_lotus *tau, doublereal_lotus *work, integer *lwork, 
	integer *info);

/* Subroutine */ int dorgtr_(char *uplo, integer *n, doublereal_lotus *a, integer *
	lda, doublereal_lotus *tau, doublereal_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int dorm2l_(char *side, char *trans, integer *m, integer *n, 
	integer *k, doublereal_lotus *a, integer *lda, doublereal_lotus *tau, doublereal_lotus *
	c__, integer *ldc, doublereal_lotus *work, integer *info);

/* Subroutine */ int dorm2r_(char *side, char *trans, integer *m, integer *n, 
	integer *k, doublereal_lotus *a, integer *lda, doublereal_lotus *tau, doublereal_lotus *
	c__, integer *ldc, doublereal_lotus *work, integer *info);

/* Subroutine */ int dormbr_(char *vect, char *side, char *trans, integer *m, 
	integer *n, integer *k, doublereal_lotus *a, integer *lda, doublereal_lotus *tau, 
	doublereal_lotus *c__, integer *ldc, doublereal_lotus *work, integer *lwork, 
	integer *info);

/* Subroutine */ int dormhr_(char *side, char *trans, integer *m, integer *n, 
	integer *ilo, integer *ihi, doublereal_lotus *a, integer *lda, doublereal_lotus *
	tau, doublereal_lotus *c__, integer *ldc, doublereal_lotus *work, integer *lwork, 
	integer *info);

/* Subroutine */ int dorml2_(char *side, char *trans, integer *m, integer *n, 
	integer *k, doublereal_lotus *a, integer *lda, doublereal_lotus *tau, doublereal_lotus *
	c__, integer *ldc, doublereal_lotus *work, integer *info);

/* Subroutine */ int dormlq_(char *side, char *trans, integer *m, integer *n, 
	integer *k, doublereal_lotus *a, integer *lda, doublereal_lotus *tau, doublereal_lotus *
	c__, integer *ldc, doublereal_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int dormql_(char *side, char *trans, integer *m, integer *n, 
	integer *k, doublereal_lotus *a, integer *lda, doublereal_lotus *tau, doublereal_lotus *
	c__, integer *ldc, doublereal_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int dormqr_(char *side, char *trans, integer *m, integer *n, 
	integer *k, doublereal_lotus *a, integer *lda, doublereal_lotus *tau, doublereal_lotus *
	c__, integer *ldc, doublereal_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int dormr2_(char *side, char *trans, integer *m, integer *n, 
	integer *k, doublereal_lotus *a, integer *lda, doublereal_lotus *tau, doublereal_lotus *
	c__, integer *ldc, doublereal_lotus *work, integer *info);

/* Subroutine */ int dormr3_(char *side, char *trans, integer *m, integer *n, 
	integer *k, integer *l, doublereal_lotus *a, integer *lda, doublereal_lotus *tau, 
	doublereal_lotus *c__, integer *ldc, doublereal_lotus *work, integer *info);

/* Subroutine */ int dormrq_(char *side, char *trans, integer *m, integer *n, 
	integer *k, doublereal_lotus *a, integer *lda, doublereal_lotus *tau, doublereal_lotus *
	c__, integer *ldc, doublereal_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int dormrz_(char *side, char *trans, integer *m, integer *n, 
	integer *k, integer *l, doublereal_lotus *a, integer *lda, doublereal_lotus *tau, 
	doublereal_lotus *c__, integer *ldc, doublereal_lotus *work, integer *lwork, 
	integer *info);

/* Subroutine */ int dormtr_(char *side, char *uplo, char *trans, integer *m, 
	integer *n, doublereal_lotus *a, integer *lda, doublereal_lotus *tau, doublereal_lotus *
	c__, integer *ldc, doublereal_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int dpbcon_(char *uplo, integer *n, integer *kd, doublereal_lotus *
	ab, integer *ldab, doublereal_lotus *anorm, doublereal_lotus *rcond, doublereal_lotus *
	work, integer *iwork, integer *info);

/* Subroutine */ int dpbequ_(char *uplo, integer *n, integer *kd, doublereal_lotus *
	ab, integer *ldab, doublereal_lotus *s, doublereal_lotus *scond, doublereal_lotus *amax, 
	 integer *info);

/* Subroutine */ int dpbrfs_(char *uplo, integer *n, integer *kd, integer *
	nrhs, doublereal_lotus *ab, integer *ldab, doublereal_lotus *afb, integer *ldafb, 
	doublereal_lotus *b, integer *ldb, doublereal_lotus *x, integer *ldx, doublereal_lotus *
	ferr, doublereal_lotus *berr, doublereal_lotus *work, integer *iwork, integer *
	info);

/* Subroutine */ int dpbstf_(char *uplo, integer *n, integer *kd, doublereal_lotus *
	ab, integer *ldab, integer *info);

/* Subroutine */ int dpbsv_(char *uplo, integer *n, integer *kd, integer *
	nrhs, doublereal_lotus *ab, integer *ldab, doublereal_lotus *b, integer *ldb, 
	integer *info);

/* Subroutine */ int dpbsvx_(char *fact, char *uplo, integer *n, integer *kd, 
	integer *nrhs, doublereal_lotus *ab, integer *ldab, doublereal_lotus *afb, 
	integer *ldafb, char *equed, doublereal_lotus *s, doublereal_lotus *b, integer *
	ldb, doublereal_lotus *x, integer *ldx, doublereal_lotus *rcond, doublereal_lotus *ferr, 
	 doublereal_lotus *berr, doublereal_lotus *work, integer *iwork, integer *info);

/* Subroutine */ int dpbtf2_(char *uplo, integer *n, integer *kd, doublereal_lotus *
	ab, integer *ldab, integer *info);

/* Subroutine */ int dpbtrf_(char *uplo, integer *n, integer *kd, doublereal_lotus *
	ab, integer *ldab, integer *info);

/* Subroutine */ int dpbtrs_(char *uplo, integer *n, integer *kd, integer *
	nrhs, doublereal_lotus *ab, integer *ldab, doublereal_lotus *b, integer *ldb, 
	integer *info);

/* Subroutine */ int dpftrf_(char *transr, char *uplo, integer *n, doublereal_lotus 
	*a, integer *info);

/* Subroutine */ int dpftri_(char *transr, char *uplo, integer *n, doublereal_lotus 
	*a, integer *info);

/* Subroutine */ int dpftrs_(char *transr, char *uplo, integer *n, integer *
	nrhs, doublereal_lotus *a, doublereal_lotus *b, integer *ldb, integer *info);

/* Subroutine */ int dpocon_(char *uplo, integer *n, doublereal_lotus *a, integer *
	lda, doublereal_lotus *anorm, doublereal_lotus *rcond, doublereal_lotus *work, integer *
	iwork, integer *info);

/* Subroutine */ int dpoequ_(integer *n, doublereal_lotus *a, integer *lda, 
	doublereal_lotus *s, doublereal_lotus *scond, doublereal_lotus *amax, integer *info);

/* Subroutine */ int dpoequb_(integer *n, doublereal_lotus *a, integer *lda, 
	doublereal_lotus *s, doublereal_lotus *scond, doublereal_lotus *amax, integer *info);

/* Subroutine */ int dporfs_(char *uplo, integer *n, integer *nrhs, 
	doublereal_lotus *a, integer *lda, doublereal_lotus *af, integer *ldaf, 
	doublereal_lotus *b, integer *ldb, doublereal_lotus *x, integer *ldx, doublereal_lotus *
	ferr, doublereal_lotus *berr, doublereal_lotus *work, integer *iwork, integer *
	info);

/* Subroutine */ int dporfsx_(char *uplo, char *equed, integer *n, integer *
	nrhs, doublereal_lotus *a, integer *lda, doublereal_lotus *af, integer *ldaf, 
	doublereal_lotus *s, doublereal_lotus *b, integer *ldb, doublereal_lotus *x, integer *
	ldx, doublereal_lotus *rcond, doublereal_lotus *berr, integer *n_err_bnds__, 
	doublereal_lotus *err_bnds_norm__, doublereal_lotus *err_bnds_comp__, integer *
	nparams, doublereal_lotus *params, doublereal_lotus *work, integer *iwork, 
	integer *info);

/* Subroutine */ int dposv_(char *uplo, integer *n, integer *nrhs, doublereal_lotus 
	*a, integer *lda, doublereal_lotus *b, integer *ldb, integer *info);

/* Subroutine */ int dposvx_(char *fact, char *uplo, integer *n, integer *
	nrhs, doublereal_lotus *a, integer *lda, doublereal_lotus *af, integer *ldaf, 
	char *equed, doublereal_lotus *s, doublereal_lotus *b, integer *ldb, doublereal_lotus *
	x, integer *ldx, doublereal_lotus *rcond, doublereal_lotus *ferr, doublereal_lotus *
	berr, doublereal_lotus *work, integer *iwork, integer *info);

/* Subroutine */ int dposvxx_(char *fact, char *uplo, integer *n, integer *
	nrhs, doublereal_lotus *a, integer *lda, doublereal_lotus *af, integer *ldaf, 
	char *equed, doublereal_lotus *s, doublereal_lotus *b, integer *ldb, doublereal_lotus *
	x, integer *ldx, doublereal_lotus *rcond, doublereal_lotus *rpvgrw, doublereal_lotus *
	berr, integer *n_err_bnds__, doublereal_lotus *err_bnds_norm__, doublereal_lotus *
	err_bnds_comp__, integer *nparams, doublereal_lotus *params, doublereal_lotus *
	work, integer *iwork, integer *info);

/* Subroutine */ int dpotf2_(char *uplo, integer *n, doublereal_lotus *a, integer *
	lda, integer *info);

/* Subroutine */ int dpotrf_(char *uplo, integer *n, doublereal_lotus *a, integer *
	lda, integer *info);

/* Subroutine */ int dpotri_(char *uplo, integer *n, doublereal_lotus *a, integer *
	lda, integer *info);

/* Subroutine */ int dpotrs_(char *uplo, integer *n, integer *nrhs, 
	doublereal_lotus *a, integer *lda, doublereal_lotus *b, integer *ldb, integer *
	info);

/* Subroutine */ int dppcon_(char *uplo, integer *n, doublereal_lotus *ap, 
	doublereal_lotus *anorm, doublereal_lotus *rcond, doublereal_lotus *work, integer *
	iwork, integer *info);

/* Subroutine */ int dppequ_(char *uplo, integer *n, doublereal_lotus *ap, 
	doublereal_lotus *s, doublereal_lotus *scond, doublereal_lotus *amax, integer *info);

/* Subroutine */ int dpprfs_(char *uplo, integer *n, integer *nrhs, 
	doublereal_lotus *ap, doublereal_lotus *afp, doublereal_lotus *b, integer *ldb, 
	doublereal_lotus *x, integer *ldx, doublereal_lotus *ferr, doublereal_lotus *berr, 
	doublereal_lotus *work, integer *iwork, integer *info);

/* Subroutine */ int dppsv_(char *uplo, integer *n, integer *nrhs, doublereal_lotus 
	*ap, doublereal_lotus *b, integer *ldb, integer *info);

/* Subroutine */ int dppsvx_(char *fact, char *uplo, integer *n, integer *
	nrhs, doublereal_lotus *ap, doublereal_lotus *afp, char *equed, doublereal_lotus *s, 
	doublereal_lotus *b, integer *ldb, doublereal_lotus *x, integer *ldx, doublereal_lotus *
	rcond, doublereal_lotus *ferr, doublereal_lotus *berr, doublereal_lotus *work, integer *
	iwork, integer *info);

/* Subroutine */ int dpptrf_(char *uplo, integer *n, doublereal_lotus *ap, integer *
	info);

/* Subroutine */ int dpptri_(char *uplo, integer *n, doublereal_lotus *ap, integer *
	info);

/* Subroutine */ int dpptrs_(char *uplo, integer *n, integer *nrhs, 
	doublereal_lotus *ap, doublereal_lotus *b, integer *ldb, integer *info);

/* Subroutine */ int dpstf2_(char *uplo, integer *n, doublereal_lotus *a, integer *
	lda, integer *piv, integer *rank, doublereal_lotus *tol, doublereal_lotus *work, 
	integer *info);

/* Subroutine */ int dpstrf_(char *uplo, integer *n, doublereal_lotus *a, integer *
	lda, integer *piv, integer *rank, doublereal_lotus *tol, doublereal_lotus *work, 
	integer *info);

/* Subroutine */ int dptcon_(integer *n, doublereal_lotus *d__, doublereal_lotus *e, 
	doublereal_lotus *anorm, doublereal_lotus *rcond, doublereal_lotus *work, integer *info);

/* Subroutine */ int dpteqr_(char *compz, integer *n, doublereal_lotus *d__, 
	doublereal_lotus *e, doublereal_lotus *z__, integer *ldz, doublereal_lotus *work, 
	integer *info);

/* Subroutine */ int dptrfs_(integer *n, integer *nrhs, doublereal_lotus *d__, 
	doublereal_lotus *e, doublereal_lotus *df, doublereal_lotus *ef, doublereal_lotus *b, integer 
	*ldb, doublereal_lotus *x, integer *ldx, doublereal_lotus *ferr, doublereal_lotus *berr, 
	 doublereal_lotus *work, integer *info);

/* Subroutine */ int dptsv_(integer *n, integer *nrhs, doublereal_lotus *d__, 
	doublereal_lotus *e, doublereal_lotus *b, integer *ldb, integer *info);

/* Subroutine */ int dptsvx_(char *fact, integer *n, integer *nrhs, 
	doublereal_lotus *d__, doublereal_lotus *e, doublereal_lotus *df, doublereal_lotus *ef, 
	doublereal_lotus *b, integer *ldb, doublereal_lotus *x, integer *ldx, doublereal_lotus *
	rcond, doublereal_lotus *ferr, doublereal_lotus *berr, doublereal_lotus *work, integer *
	info);

/* Subroutine */ int dpttrf_(integer *n, doublereal_lotus *d__, doublereal_lotus *e, 
	integer *info);

/* Subroutine */ int dpttrs_(integer *n, integer *nrhs, doublereal_lotus *d__, 
	doublereal_lotus *e, doublereal_lotus *b, integer *ldb, integer *info);

/* Subroutine */ int dptts2_(integer *n, integer *nrhs, doublereal_lotus *d__, 
	doublereal_lotus *e, doublereal_lotus *b, integer *ldb);

/* Subroutine */ int drscl_(integer *n, doublereal_lotus *sa, doublereal_lotus *sx, 
	integer *incx);

/* Subroutine */ int dsbev_(char *jobz, char *uplo, integer *n, integer *kd, 
	doublereal_lotus *ab, integer *ldab, doublereal_lotus *w, doublereal_lotus *z__, 
	integer *ldz, doublereal_lotus *work, integer *info);

/* Subroutine */ int dsbevd_(char *jobz, char *uplo, integer *n, integer *kd, 
	doublereal_lotus *ab, integer *ldab, doublereal_lotus *w, doublereal_lotus *z__, 
	integer *ldz, doublereal_lotus *work, integer *lwork, integer *iwork, 
	integer *liwork, integer *info);

/* Subroutine */ int dsbevx_(char *jobz, char *range, char *uplo, integer *n, 
	integer *kd, doublereal_lotus *ab, integer *ldab, doublereal_lotus *q, integer *
	ldq, doublereal_lotus *vl, doublereal_lotus *vu, integer *il, integer *iu, 
	doublereal_lotus *abstol, integer *m, doublereal_lotus *w, doublereal_lotus *z__, 
	integer *ldz, doublereal_lotus *work, integer *iwork, integer *ifail, 
	integer *info);

/* Subroutine */ int dsbgst_(char *vect, char *uplo, integer *n, integer *ka, 
	integer *kb, doublereal_lotus *ab, integer *ldab, doublereal_lotus *bb, integer *
	ldbb, doublereal_lotus *x, integer *ldx, doublereal_lotus *work, integer *info);

/* Subroutine */ int dsbgv_(char *jobz, char *uplo, integer *n, integer *ka, 
	integer *kb, doublereal_lotus *ab, integer *ldab, doublereal_lotus *bb, integer *
	ldbb, doublereal_lotus *w, doublereal_lotus *z__, integer *ldz, doublereal_lotus *work, 
	integer *info);

/* Subroutine */ int dsbgvd_(char *jobz, char *uplo, integer *n, integer *ka, 
	integer *kb, doublereal_lotus *ab, integer *ldab, doublereal_lotus *bb, integer *
	ldbb, doublereal_lotus *w, doublereal_lotus *z__, integer *ldz, doublereal_lotus *work, 
	integer *lwork, integer *iwork, integer *liwork, integer *info);

/* Subroutine */ int dsbgvx_(char *jobz, char *range, char *uplo, integer *n, 
	integer *ka, integer *kb, doublereal_lotus *ab, integer *ldab, doublereal_lotus *
	bb, integer *ldbb, doublereal_lotus *q, integer *ldq, doublereal_lotus *vl, 
	doublereal_lotus *vu, integer *il, integer *iu, doublereal_lotus *abstol, integer 
	*m, doublereal_lotus *w, doublereal_lotus *z__, integer *ldz, doublereal_lotus *work, 
	integer *iwork, integer *ifail, integer *info);

/* Subroutine */ int dsbtrd_(char *vect, char *uplo, integer *n, integer *kd, 
	doublereal_lotus *ab, integer *ldab, doublereal_lotus *d__, doublereal_lotus *e, 
	doublereal_lotus *q, integer *ldq, doublereal_lotus *work, integer *info);

/* Subroutine */ int dsfrk_(char *transr, char *uplo, char *trans, integer *n, 
	 integer *k, doublereal_lotus *alpha, doublereal_lotus *a, integer *lda, 
	doublereal_lotus *beta, doublereal_lotus *c__);

/* Subroutine */ int dsgesv_(integer *n, integer *nrhs, doublereal_lotus *a, 
	integer *lda, integer *ipiv, doublereal_lotus *b, integer *ldb, doublereal_lotus *
	x, integer *ldx, doublereal_lotus *work, real_lotus *swork, integer *iter, 
	integer *info);

/* Subroutine */ int dspcon_(char *uplo, integer *n, doublereal_lotus *ap, integer *
	ipiv, doublereal_lotus *anorm, doublereal_lotus *rcond, doublereal_lotus *work, integer 
	*iwork, integer *info);

/* Subroutine */ int dspev_(char *jobz, char *uplo, integer *n, doublereal_lotus *
	ap, doublereal_lotus *w, doublereal_lotus *z__, integer *ldz, doublereal_lotus *work, 
	integer *info);

/* Subroutine */ int dspevd_(char *jobz, char *uplo, integer *n, doublereal_lotus *
	ap, doublereal_lotus *w, doublereal_lotus *z__, integer *ldz, doublereal_lotus *work, 
	integer *lwork, integer *iwork, integer *liwork, integer *info);

/* Subroutine */ int dspevx_(char *jobz, char *range, char *uplo, integer *n, 
	doublereal_lotus *ap, doublereal_lotus *vl, doublereal_lotus *vu, integer *il, integer *
	iu, doublereal_lotus *abstol, integer *m, doublereal_lotus *w, doublereal_lotus *z__, 
	integer *ldz, doublereal_lotus *work, integer *iwork, integer *ifail, 
	integer *info);

/* Subroutine */ int dspgst_(integer *itype, char *uplo, integer *n, 
	doublereal_lotus *ap, doublereal_lotus *bp, integer *info);

/* Subroutine */ int dspgv_(integer *itype, char *jobz, char *uplo, integer *
	n, doublereal_lotus *ap, doublereal_lotus *bp, doublereal_lotus *w, doublereal_lotus *z__, 
	integer *ldz, doublereal_lotus *work, integer *info);

/* Subroutine */ int dspgvd_(integer *itype, char *jobz, char *uplo, integer *
	n, doublereal_lotus *ap, doublereal_lotus *bp, doublereal_lotus *w, doublereal_lotus *z__, 
	integer *ldz, doublereal_lotus *work, integer *lwork, integer *iwork, 
	integer *liwork, integer *info);

/* Subroutine */ int dspgvx_(integer *itype, char *jobz, char *range, char *
	uplo, integer *n, doublereal_lotus *ap, doublereal_lotus *bp, doublereal_lotus *vl, 
	doublereal_lotus *vu, integer *il, integer *iu, doublereal_lotus *abstol, integer 
	*m, doublereal_lotus *w, doublereal_lotus *z__, integer *ldz, doublereal_lotus *work, 
	integer *iwork, integer *ifail, integer *info);

/* Subroutine */ int dsposv_(char *uplo, integer *n, integer *nrhs, 
	doublereal_lotus *a, integer *lda, doublereal_lotus *b, integer *ldb, doublereal_lotus *
	x, integer *ldx, doublereal_lotus *work, real_lotus *swork, integer *iter, 
	integer *info);

/* Subroutine */ int dsprfs_(char *uplo, integer *n, integer *nrhs, 
	doublereal_lotus *ap, doublereal_lotus *afp, integer *ipiv, doublereal_lotus *b, 
	integer *ldb, doublereal_lotus *x, integer *ldx, doublereal_lotus *ferr, 
	doublereal_lotus *berr, doublereal_lotus *work, integer *iwork, integer *info);

/* Subroutine */ int dspsv_(char *uplo, integer *n, integer *nrhs, doublereal_lotus 
	*ap, integer *ipiv, doublereal_lotus *b, integer *ldb, integer *info);

/* Subroutine */ int dspsvx_(char *fact, char *uplo, integer *n, integer *
	nrhs, doublereal_lotus *ap, doublereal_lotus *afp, integer *ipiv, doublereal_lotus *b, 
	integer *ldb, doublereal_lotus *x, integer *ldx, doublereal_lotus *rcond, 
	doublereal_lotus *ferr, doublereal_lotus *berr, doublereal_lotus *work, integer *iwork, 
	integer *info);

/* Subroutine */ int dsptrd_(char *uplo, integer *n, doublereal_lotus *ap, 
	doublereal_lotus *d__, doublereal_lotus *e, doublereal_lotus *tau, integer *info);

/* Subroutine */ int dsptrf_(char *uplo, integer *n, doublereal_lotus *ap, integer *
	ipiv, integer *info);

/* Subroutine */ int dsptri_(char *uplo, integer *n, doublereal_lotus *ap, integer *
	ipiv, doublereal_lotus *work, integer *info);

/* Subroutine */ int dsptrs_(char *uplo, integer *n, integer *nrhs, 
	doublereal_lotus *ap, integer *ipiv, doublereal_lotus *b, integer *ldb, integer *
	info);

/* Subroutine */ int dstebz_(char *range, char *order, integer *n, doublereal_lotus 
	*vl, doublereal_lotus *vu, integer *il, integer *iu, doublereal_lotus *abstol, 
	doublereal_lotus *d__, doublereal_lotus *e, integer *m, integer *nsplit, 
	doublereal_lotus *w, integer *iblock, integer *isplit, doublereal_lotus *work, 
	integer *iwork, integer *info);

/* Subroutine */ int dstedc_(char *compz, integer *n, doublereal_lotus *d__, 
	doublereal_lotus *e, doublereal_lotus *z__, integer *ldz, doublereal_lotus *work, 
	integer *lwork, integer *iwork, integer *liwork, integer *info);

/* Subroutine */ int dstegr_(char *jobz, char *range, integer *n, doublereal_lotus *
	d__, doublereal_lotus *e, doublereal_lotus *vl, doublereal_lotus *vu, integer *il, 
	integer *iu, doublereal_lotus *abstol, integer *m, doublereal_lotus *w, 
	doublereal_lotus *z__, integer *ldz, integer *isuppz, doublereal_lotus *work, 
	integer *lwork, integer *iwork, integer *liwork, integer *info);

/* Subroutine */ int dstein_(integer *n, doublereal_lotus *d__, doublereal_lotus *e, 
	integer *m, doublereal_lotus *w, integer *iblock, integer *isplit, 
	doublereal_lotus *z__, integer *ldz, doublereal_lotus *work, integer *iwork, 
	integer *ifail, integer *info);

/* Subroutine */ int dstemr_(char *jobz, char *range, integer *n, doublereal_lotus *
	d__, doublereal_lotus *e, doublereal_lotus *vl, doublereal_lotus *vu, integer *il, 
	integer *iu, integer *m, doublereal_lotus *w, doublereal_lotus *z__, integer *ldz, 
	 integer *nzc, integer *isuppz, logical *tryrac, doublereal_lotus *work, 
	integer *lwork, integer *iwork, integer *liwork, integer *info);

/* Subroutine */ int dsteqr_(char *compz, integer *n, doublereal_lotus *d__, 
	doublereal_lotus *e, doublereal_lotus *z__, integer *ldz, doublereal_lotus *work, 
	integer *info);

/* Subroutine */ int dsterf_(integer *n, doublereal_lotus *d__, doublereal_lotus *e, 
	integer *info);

/* Subroutine */ int dstev_(char *jobz, integer *n, doublereal_lotus *d__, 
	doublereal_lotus *e, doublereal_lotus *z__, integer *ldz, doublereal_lotus *work, 
	integer *info);

/* Subroutine */ int dstevd_(char *jobz, integer *n, doublereal_lotus *d__, 
	doublereal_lotus *e, doublereal_lotus *z__, integer *ldz, doublereal_lotus *work, 
	integer *lwork, integer *iwork, integer *liwork, integer *info);

/* Subroutine */ int dstevr_(char *jobz, char *range, integer *n, doublereal_lotus *
	d__, doublereal_lotus *e, doublereal_lotus *vl, doublereal_lotus *vu, integer *il, 
	integer *iu, doublereal_lotus *abstol, integer *m, doublereal_lotus *w, 
	doublereal_lotus *z__, integer *ldz, integer *isuppz, doublereal_lotus *work, 
	integer *lwork, integer *iwork, integer *liwork, integer *info);

/* Subroutine */ int dstevx_(char *jobz, char *range, integer *n, doublereal_lotus *
	d__, doublereal_lotus *e, doublereal_lotus *vl, doublereal_lotus *vu, integer *il, 
	integer *iu, doublereal_lotus *abstol, integer *m, doublereal_lotus *w, 
	doublereal_lotus *z__, integer *ldz, doublereal_lotus *work, integer *iwork, 
	integer *ifail, integer *info);

/* Subroutine */ int dsycon_(char *uplo, integer *n, doublereal_lotus *a, integer *
	lda, integer *ipiv, doublereal_lotus *anorm, doublereal_lotus *rcond, doublereal_lotus *
	work, integer *iwork, integer *info);

/* Subroutine */ int dsyequb_(char *uplo, integer *n, doublereal_lotus *a, integer *
	lda, doublereal_lotus *s, doublereal_lotus *scond, doublereal_lotus *amax, doublereal_lotus *
	work, integer *info);

/* Subroutine */ int dsyev_(char *jobz, char *uplo, integer *n, doublereal_lotus *a, 
	 integer *lda, doublereal_lotus *w, doublereal_lotus *work, integer *lwork, 
	integer *info);

/* Subroutine */ int dsyevd_(char *jobz, char *uplo, integer *n, doublereal_lotus *
	a, integer *lda, doublereal_lotus *w, doublereal_lotus *work, integer *lwork, 
	integer *iwork, integer *liwork, integer *info);

/* Subroutine */ int dsyevr_(char *jobz, char *range, char *uplo, integer *n, 
	doublereal_lotus *a, integer *lda, doublereal_lotus *vl, doublereal_lotus *vu, integer *
	il, integer *iu, doublereal_lotus *abstol, integer *m, doublereal_lotus *w, 
	doublereal_lotus *z__, integer *ldz, integer *isuppz, doublereal_lotus *work, 
	integer *lwork, integer *iwork, integer *liwork, integer *info);

/* Subroutine */ int dsyevx_(char *jobz, char *range, char *uplo, integer *n, 
	doublereal_lotus *a, integer *lda, doublereal_lotus *vl, doublereal_lotus *vu, integer *
	il, integer *iu, doublereal_lotus *abstol, integer *m, doublereal_lotus *w, 
	doublereal_lotus *z__, integer *ldz, doublereal_lotus *work, integer *lwork, 
	integer *iwork, integer *ifail, integer *info);

/* Subroutine */ int dsygs2_(integer *itype, char *uplo, integer *n, 
	doublereal_lotus *a, integer *lda, doublereal_lotus *b, integer *ldb, integer *
	info);

/* Subroutine */ int dsygst_(integer *itype, char *uplo, integer *n, 
	doublereal_lotus *a, integer *lda, doublereal_lotus *b, integer *ldb, integer *
	info);

/* Subroutine */ int dsygv_(integer *itype, char *jobz, char *uplo, integer *
	n, doublereal_lotus *a, integer *lda, doublereal_lotus *b, integer *ldb, 
	doublereal_lotus *w, doublereal_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int dsygvd_(integer *itype, char *jobz, char *uplo, integer *
	n, doublereal_lotus *a, integer *lda, doublereal_lotus *b, integer *ldb, 
	doublereal_lotus *w, doublereal_lotus *work, integer *lwork, integer *iwork, 
	integer *liwork, integer *info);

/* Subroutine */ int dsygvx_(integer *itype, char *jobz, char *range, char *
	uplo, integer *n, doublereal_lotus *a, integer *lda, doublereal_lotus *b, integer 
	*ldb, doublereal_lotus *vl, doublereal_lotus *vu, integer *il, integer *iu, 
	doublereal_lotus *abstol, integer *m, doublereal_lotus *w, doublereal_lotus *z__, 
	integer *ldz, doublereal_lotus *work, integer *lwork, integer *iwork, 
	integer *ifail, integer *info);

/* Subroutine */ int dsyrfs_(char *uplo, integer *n, integer *nrhs, 
	doublereal_lotus *a, integer *lda, doublereal_lotus *af, integer *ldaf, integer *
	ipiv, doublereal_lotus *b, integer *ldb, doublereal_lotus *x, integer *ldx, 
	doublereal_lotus *ferr, doublereal_lotus *berr, doublereal_lotus *work, integer *iwork, 
	integer *info);

/* Subroutine */ int dsyrfsx_(char *uplo, char *equed, integer *n, integer *
	nrhs, doublereal_lotus *a, integer *lda, doublereal_lotus *af, integer *ldaf, 
	integer *ipiv, doublereal_lotus *s, doublereal_lotus *b, integer *ldb, doublereal_lotus 
	*x, integer *ldx, doublereal_lotus *rcond, doublereal_lotus *berr, integer *
	n_err_bnds__, doublereal_lotus *err_bnds_norm__, doublereal_lotus *
	err_bnds_comp__, integer *nparams, doublereal_lotus *params, doublereal_lotus *
	work, integer *iwork, integer *info);

/* Subroutine */ int dsysv_(char *uplo, integer *n, integer *nrhs, doublereal_lotus 
	*a, integer *lda, integer *ipiv, doublereal_lotus *b, integer *ldb, 
	doublereal_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int dsysvx_(char *fact, char *uplo, integer *n, integer *
	nrhs, doublereal_lotus *a, integer *lda, doublereal_lotus *af, integer *ldaf, 
	integer *ipiv, doublereal_lotus *b, integer *ldb, doublereal_lotus *x, integer *
	ldx, doublereal_lotus *rcond, doublereal_lotus *ferr, doublereal_lotus *berr, 
	doublereal_lotus *work, integer *lwork, integer *iwork, integer *info);

/* Subroutine */ int dsysvxx_(char *fact, char *uplo, integer *n, integer *
	nrhs, doublereal_lotus *a, integer *lda, doublereal_lotus *af, integer *ldaf, 
	integer *ipiv, char *equed, doublereal_lotus *s, doublereal_lotus *b, integer *
	ldb, doublereal_lotus *x, integer *ldx, doublereal_lotus *rcond, doublereal_lotus *
	rpvgrw, doublereal_lotus *berr, integer *n_err_bnds__, doublereal_lotus *
	err_bnds_norm__, doublereal_lotus *err_bnds_comp__, integer *nparams, 
	doublereal_lotus *params, doublereal_lotus *work, integer *iwork, integer *info);

/* Subroutine */ int dsytd2_(char *uplo, integer *n, doublereal_lotus *a, integer *
	lda, doublereal_lotus *d__, doublereal_lotus *e, doublereal_lotus *tau, integer *info);

/* Subroutine */ int dsytf2_(char *uplo, integer *n, doublereal_lotus *a, integer *
	lda, integer *ipiv, integer *info);

/* Subroutine */ int dsytrd_(char *uplo, integer *n, doublereal_lotus *a, integer *
	lda, doublereal_lotus *d__, doublereal_lotus *e, doublereal_lotus *tau, doublereal_lotus *
	work, integer *lwork, integer *info);

/* Subroutine */ int dsytrf_(char *uplo, integer *n, doublereal_lotus *a, integer *
	lda, integer *ipiv, doublereal_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int dsytri_(char *uplo, integer *n, doublereal_lotus *a, integer *
	lda, integer *ipiv, doublereal_lotus *work, integer *info);

/* Subroutine */ int dsytrs_(char *uplo, integer *n, integer *nrhs, 
	doublereal_lotus *a, integer *lda, integer *ipiv, doublereal_lotus *b, integer *
	ldb, integer *info);

/* Subroutine */ int dtbcon_(char *norm, char *uplo, char *diag, integer *n, 
	integer *kd, doublereal_lotus *ab, integer *ldab, doublereal_lotus *rcond, 
	doublereal_lotus *work, integer *iwork, integer *info);

/* Subroutine */ int dtbrfs_(char *uplo, char *trans, char *diag, integer *n, 
	integer *kd, integer *nrhs, doublereal_lotus *ab, integer *ldab, doublereal_lotus 
	*b, integer *ldb, doublereal_lotus *x, integer *ldx, doublereal_lotus *ferr, 
	doublereal_lotus *berr, doublereal_lotus *work, integer *iwork, integer *info);

/* Subroutine */ int dtbtrs_(char *uplo, char *trans, char *diag, integer *n, 
	integer *kd, integer *nrhs, doublereal_lotus *ab, integer *ldab, doublereal_lotus 
	*b, integer *ldb, integer *info);

/* Subroutine */ int dtfsm_(char *transr, char *side, char *uplo, char *trans, 
	 char *diag, integer *m, integer *n, doublereal_lotus *alpha, doublereal_lotus *a, 
	 doublereal_lotus *b, integer *ldb);

/* Subroutine */ int dtftri_(char *transr, char *uplo, char *diag, integer *n, 
	 doublereal_lotus *a, integer *info);

/* Subroutine */ int dtfttp_(char *transr, char *uplo, integer *n, doublereal_lotus 
	*arf, doublereal_lotus *ap, integer *info);

/* Subroutine */ int dtfttr_(char *transr, char *uplo, integer *n, doublereal_lotus 
	*arf, doublereal_lotus *a, integer *lda, integer *info);

/* Subroutine */ int dtgevc_(char *side, char *howmny, logical *select, 
	integer *n, doublereal_lotus *s, integer *lds, doublereal_lotus *p, integer *ldp, 
	doublereal_lotus *vl, integer *ldvl, doublereal_lotus *vr, integer *ldvr, integer 
	*mm, integer *m, doublereal_lotus *work, integer *info);

/* Subroutine */ int dtgex2_(logical *wantq, logical *wantz, integer *n, 
	doublereal_lotus *a, integer *lda, doublereal_lotus *b, integer *ldb, doublereal_lotus *
	q, integer *ldq, doublereal_lotus *z__, integer *ldz, integer *j1, integer *
	n1, integer *n2, doublereal_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int dtgexc_(logical *wantq, logical *wantz, integer *n, 
	doublereal_lotus *a, integer *lda, doublereal_lotus *b, integer *ldb, doublereal_lotus *
	q, integer *ldq, doublereal_lotus *z__, integer *ldz, integer *ifst, 
	integer *ilst, doublereal_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int dtgsen_(integer *ijob, logical *wantq, logical *wantz, 
	logical *select, integer *n, doublereal_lotus *a, integer *lda, doublereal_lotus *
	b, integer *ldb, doublereal_lotus *alphar, doublereal_lotus *alphai, doublereal_lotus *
	beta, doublereal_lotus *q, integer *ldq, doublereal_lotus *z__, integer *ldz, 
	integer *m, doublereal_lotus *pl, doublereal_lotus *pr, doublereal_lotus *dif, 
	doublereal_lotus *work, integer *lwork, integer *iwork, integer *liwork, 
	integer *info);

/* Subroutine */ int dtgsja_(char *jobu, char *jobv, char *jobq, integer *m, 
	integer *p, integer *n, integer *k, integer *l, doublereal_lotus *a, 
	integer *lda, doublereal_lotus *b, integer *ldb, doublereal_lotus *tola, 
	doublereal_lotus *tolb, doublereal_lotus *alpha, doublereal_lotus *beta, doublereal_lotus *u, 
	integer *ldu, doublereal_lotus *v, integer *ldv, doublereal_lotus *q, integer *
	ldq, doublereal_lotus *work, integer *ncycle, integer *info);

/* Subroutine */ int dtgsna_(char *job, char *howmny, logical *select, 
	integer *n, doublereal_lotus *a, integer *lda, doublereal_lotus *b, integer *ldb, 
	doublereal_lotus *vl, integer *ldvl, doublereal_lotus *vr, integer *ldvr, 
	doublereal_lotus *s, doublereal_lotus *dif, integer *mm, integer *m, doublereal_lotus *
	work, integer *lwork, integer *iwork, integer *info);

/* Subroutine */ int dtgsy2_(char *trans, integer *ijob, integer *m, integer *
	n, doublereal_lotus *a, integer *lda, doublereal_lotus *b, integer *ldb, 
	doublereal_lotus *c__, integer *ldc, doublereal_lotus *d__, integer *ldd, 
	doublereal_lotus *e, integer *lde, doublereal_lotus *f, integer *ldf, doublereal_lotus *
	scale, doublereal_lotus *rdsum, doublereal_lotus *rdscal, integer *iwork, integer 
	*pq, integer *info);

/* Subroutine */ int dtgsyl_(char *trans, integer *ijob, integer *m, integer *
	n, doublereal_lotus *a, integer *lda, doublereal_lotus *b, integer *ldb, 
	doublereal_lotus *c__, integer *ldc, doublereal_lotus *d__, integer *ldd, 
	doublereal_lotus *e, integer *lde, doublereal_lotus *f, integer *ldf, doublereal_lotus *
	scale, doublereal_lotus *dif, doublereal_lotus *work, integer *lwork, integer *
	iwork, integer *info);

/* Subroutine */ int dtpcon_(char *norm, char *uplo, char *diag, integer *n, 
	doublereal_lotus *ap, doublereal_lotus *rcond, doublereal_lotus *work, integer *iwork, 
	integer *info);

/* Subroutine */ int dtprfs_(char *uplo, char *trans, char *diag, integer *n, 
	integer *nrhs, doublereal_lotus *ap, doublereal_lotus *b, integer *ldb, 
	doublereal_lotus *x, integer *ldx, doublereal_lotus *ferr, doublereal_lotus *berr, 
	doublereal_lotus *work, integer *iwork, integer *info);

/* Subroutine */ int dtptri_(char *uplo, char *diag, integer *n, doublereal_lotus *
	ap, integer *info);

/* Subroutine */ int dtptrs_(char *uplo, char *trans, char *diag, integer *n, 
	integer *nrhs, doublereal_lotus *ap, doublereal_lotus *b, integer *ldb, integer *
	info);

/* Subroutine */ int dtpttf_(char *transr, char *uplo, integer *n, doublereal_lotus 
	*ap, doublereal_lotus *arf, integer *info);

/* Subroutine */ int dtpttr_(char *uplo, integer *n, doublereal_lotus *ap, 
	doublereal_lotus *a, integer *lda, integer *info);

/* Subroutine */ int dtrcon_(char *norm, char *uplo, char *diag, integer *n, 
	doublereal_lotus *a, integer *lda, doublereal_lotus *rcond, doublereal_lotus *work, 
	integer *iwork, integer *info);

/* Subroutine */ int dtrevc_(char *side, char *howmny, logical *select, 
	integer *n, doublereal_lotus *t, integer *ldt, doublereal_lotus *vl, integer *
	ldvl, doublereal_lotus *vr, integer *ldvr, integer *mm, integer *m, 
	doublereal_lotus *work, integer *info);

/* Subroutine */ int dtrexc_(char *compq, integer *n, doublereal_lotus *t, integer *
	ldt, doublereal_lotus *q, integer *ldq, integer *ifst, integer *ilst, 
	doublereal_lotus *work, integer *info);

/* Subroutine */ int dtrrfs_(char *uplo, char *trans, char *diag, integer *n, 
	integer *nrhs, doublereal_lotus *a, integer *lda, doublereal_lotus *b, integer *
	ldb, doublereal_lotus *x, integer *ldx, doublereal_lotus *ferr, doublereal_lotus *berr, 
	doublereal_lotus *work, integer *iwork, integer *info);

/* Subroutine */ int dtrsen_(char *job, char *compq, logical *select, integer 
	*n, doublereal_lotus *t, integer *ldt, doublereal_lotus *q, integer *ldq, 
	doublereal_lotus *wr, doublereal_lotus *wi, integer *m, doublereal_lotus *s, doublereal_lotus 
	*sep, doublereal_lotus *work, integer *lwork, integer *iwork, integer *
	liwork, integer *info);

/* Subroutine */ int dtrsna_(char *job, char *howmny, logical *select, 
	integer *n, doublereal_lotus *t, integer *ldt, doublereal_lotus *vl, integer *
	ldvl, doublereal_lotus *vr, integer *ldvr, doublereal_lotus *s, doublereal_lotus *sep, 
	integer *mm, integer *m, doublereal_lotus *work, integer *ldwork, integer *
	iwork, integer *info);

/* Subroutine */ int dtrsyl_(char *trana, char *tranb, integer *isgn, integer 
	*m, integer *n, doublereal_lotus *a, integer *lda, doublereal_lotus *b, integer *
	ldb, doublereal_lotus *c__, integer *ldc, doublereal_lotus *scale, integer *info);

/* Subroutine */ int dtrti2_(char *uplo, char *diag, integer *n, doublereal_lotus *
	a, integer *lda, integer *info);

/* Subroutine */ int dtrtri_(char *uplo, char *diag, integer *n, doublereal_lotus *
	a, integer *lda, integer *info);

/* Subroutine */ int dtrtrs_(char *uplo, char *trans, char *diag, integer *n, 
	integer *nrhs, doublereal_lotus *a, integer *lda, doublereal_lotus *b, integer *
	ldb, integer *info);

/* Subroutine */ int dtrttf_(char *transr, char *uplo, integer *n, doublereal_lotus 
	*a, integer *lda, doublereal_lotus *arf, integer *info);

/* Subroutine */ int dtrttp_(char *uplo, integer *n, doublereal_lotus *a, integer *
	lda, doublereal_lotus *ap, integer *info);

/* Subroutine */ int dtzrqf_(integer *m, integer *n, doublereal_lotus *a, integer *
	lda, doublereal_lotus *tau, integer *info);

/* Subroutine */ int dtzrzf_(integer *m, integer *n, doublereal_lotus *a, integer *
	lda, doublereal_lotus *tau, doublereal_lotus *work, integer *lwork, integer *info);

doublereal_lotus dzsum1_(integer *n, doublecomplex_lotus *cx, integer *incx);

integer icmax1_(integer *n, complex_lotus *cx, integer *incx);

integer ieeeck_(integer *ispec, real_lotus *zero, real_lotus *one);

integer ilaclc_(integer *m, integer *n, complex_lotus *a, integer *lda);

integer ilaclr_(integer *m, integer *n, complex_lotus *a, integer *lda);

integer iladiag_(char *diag);

integer iladlc_(integer *m, integer *n, doublereal_lotus *a, integer *lda);

integer iladlr_(integer *m, integer *n, doublereal_lotus *a, integer *lda);

integer ilaenv_(integer *ispec, char *name__, char *opts, integer *n1, 
	integer *n2, integer *n3, integer *n4);

integer ilaprec_(char *prec);

integer ilaslc_(integer *m, integer *n, real_lotus *a, integer *lda);

integer ilaslr_(integer *m, integer *n, real_lotus *a, integer *lda);

integer ilatrans_(char *trans);

integer ilauplo_(char *uplo);

/* Subroutine */ int ilaver_(integer *vers_major__, integer *vers_minor__, 
	integer *vers_patch__);

integer ilazlc_(integer *m, integer *n, doublecomplex_lotus *a, integer *lda);

integer ilazlr_(integer *m, integer *n, doublecomplex_lotus *a, integer *lda);

integer iparmq_(integer *ispec, char *name__, char *opts, integer *n, integer 
	*ilo, integer *ihi, integer *lwork);

integer izmax1_(integer *n, doublecomplex_lotus *cx, integer *incx);

logical lsamen_(integer *n, char *ca, char *cb);

integer smaxloc_(real_lotus *a, integer *dimm);

/* Subroutine */ int sbdsdc_(char *uplo, char *compq, integer *n, real_lotus *d__, 
	real_lotus *e, real_lotus *u, integer *ldu, real_lotus *vt, integer *ldvt, real_lotus *q, 
	integer *iq, real_lotus *work, integer *iwork, integer *info);

/* Subroutine */ int sbdsqr_(char *uplo, integer *n, integer *ncvt, integer *
	nru, integer *ncc, real_lotus *d__, real_lotus *e, real_lotus *vt, integer *ldvt, real_lotus *
	u, integer *ldu, real_lotus *c__, integer *ldc, real_lotus *work, integer *info);

doublereal_lotus scsum1_(integer *n, complex_lotus *cx, integer *incx);

/* Subroutine */ int sdisna_(char *job, integer *m, integer *n, real_lotus *d__, 
	real_lotus *sep, integer *info);

/* Subroutine */ int sgbbrd_(char *vect, integer *m, integer *n, integer *ncc, 
	 integer *kl, integer *ku, real_lotus *ab, integer *ldab, real_lotus *d__, real_lotus *
	e, real_lotus *q, integer *ldq, real_lotus *pt, integer *ldpt, real_lotus *c__, integer 
	*ldc, real_lotus *work, integer *info);

/* Subroutine */ int sgbcon_(char *norm, integer *n, integer *kl, integer *ku, 
	 real_lotus *ab, integer *ldab, integer *ipiv, real_lotus *anorm, real_lotus *rcond, 
	real_lotus *work, integer *iwork, integer *info);

/* Subroutine */ int sgbequ_(integer *m, integer *n, integer *kl, integer *ku, 
	 real_lotus *ab, integer *ldab, real_lotus *r__, real_lotus *c__, real_lotus *rowcnd, real_lotus *
	colcnd, real_lotus *amax, integer *info);

/* Subroutine */ int sgbequb_(integer *m, integer *n, integer *kl, integer *
	ku, real_lotus *ab, integer *ldab, real_lotus *r__, real_lotus *c__, real_lotus *rowcnd, real_lotus 
	*colcnd, real_lotus *amax, integer *info);

/* Subroutine */ int sgbrfs_(char *trans, integer *n, integer *kl, integer *
	ku, integer *nrhs, real_lotus *ab, integer *ldab, real_lotus *afb, integer *ldafb, 
	 integer *ipiv, real_lotus *b, integer *ldb, real_lotus *x, integer *ldx, real_lotus *
	ferr, real_lotus *berr, real_lotus *work, integer *iwork, integer *info);

/* Subroutine */ int sgbrfsx_(char *trans, char *equed, integer *n, integer *
	kl, integer *ku, integer *nrhs, real_lotus *ab, integer *ldab, real_lotus *afb, 
	integer *ldafb, integer *ipiv, real_lotus *r__, real_lotus *c__, real_lotus *b, integer 
	*ldb, real_lotus *x, integer *ldx, real_lotus *rcond, real_lotus *berr, integer *
	n_err_bnds__, real_lotus *err_bnds_norm__, real_lotus *err_bnds_comp__, integer *
	nparams, real_lotus *params, real_lotus *work, integer *iwork, integer *info);

/* Subroutine */ int sgbsv_(integer *n, integer *kl, integer *ku, integer *
	nrhs, real_lotus *ab, integer *ldab, integer *ipiv, real_lotus *b, integer *ldb, 
	integer *info);

/* Subroutine */ int sgbsvx_(char *fact, char *trans, integer *n, integer *kl, 
	 integer *ku, integer *nrhs, real_lotus *ab, integer *ldab, real_lotus *afb, 
	integer *ldafb, integer *ipiv, char *equed, real_lotus *r__, real_lotus *c__, 
	real_lotus *b, integer *ldb, real_lotus *x, integer *ldx, real_lotus *rcond, real_lotus *ferr, 
	 real_lotus *berr, real_lotus *work, integer *iwork, integer *info);

/* Subroutine */ int sgbsvxx_(char *fact, char *trans, integer *n, integer *
	kl, integer *ku, integer *nrhs, real_lotus *ab, integer *ldab, real_lotus *afb, 
	integer *ldafb, integer *ipiv, char *equed, real_lotus *r__, real_lotus *c__, 
	real_lotus *b, integer *ldb, real_lotus *x, integer *ldx, real_lotus *rcond, real_lotus *
	rpvgrw, real_lotus *berr, integer *n_err_bnds__, real_lotus *err_bnds_norm__, 
	real_lotus *err_bnds_comp__, integer *nparams, real_lotus *params, real_lotus *work, 
	integer *iwork, integer *info);

/* Subroutine */ int sgbtf2_(integer *m, integer *n, integer *kl, integer *ku, 
	 real_lotus *ab, integer *ldab, integer *ipiv, integer *info);

/* Subroutine */ int sgbtrf_(integer *m, integer *n, integer *kl, integer *ku, 
	 real_lotus *ab, integer *ldab, integer *ipiv, integer *info);

/* Subroutine */ int sgbtrs_(char *trans, integer *n, integer *kl, integer *
	ku, integer *nrhs, real_lotus *ab, integer *ldab, integer *ipiv, real_lotus *b, 
	integer *ldb, integer *info);

/* Subroutine */ int sgebak_(char *job, char *side, integer *n, integer *ilo, 
	integer *ihi, real_lotus *scale, integer *m, real_lotus *v, integer *ldv, integer 
	*info);

/* Subroutine */ int sgebal_(char *job, integer *n, real_lotus *a, integer *lda, 
	integer *ilo, integer *ihi, real_lotus *scale, integer *info);

/* Subroutine */ int sgebd2_(integer *m, integer *n, real_lotus *a, integer *lda, 
	real_lotus *d__, real_lotus *e, real_lotus *tauq, real_lotus *taup, real_lotus *work, integer *info);

/* Subroutine */ int sgebrd_(integer *m, integer *n, real_lotus *a, integer *lda, 
	real_lotus *d__, real_lotus *e, real_lotus *tauq, real_lotus *taup, real_lotus *work, integer *
	lwork, integer *info);

/* Subroutine */ int sgecon_(char *norm, integer *n, real_lotus *a, integer *lda, 
	real_lotus *anorm, real_lotus *rcond, real_lotus *work, integer *iwork, integer *info);

/* Subroutine */ int sgeequ_(integer *m, integer *n, real_lotus *a, integer *lda, 
	real_lotus *r__, real_lotus *c__, real_lotus *rowcnd, real_lotus *colcnd, real_lotus *amax, integer 
	*info);

/* Subroutine */ int sgeequb_(integer *m, integer *n, real_lotus *a, integer *lda, 
	real_lotus *r__, real_lotus *c__, real_lotus *rowcnd, real_lotus *colcnd, real_lotus *amax, integer 
	*info);

/* Subroutine */ int sgees_(char *jobvs, char *sort, L_fp select, integer *n, 
	real_lotus *a, integer *lda, integer *sdim, real_lotus *wr, real_lotus *wi, real_lotus *vs, 
	integer *ldvs, real_lotus *work, integer *lwork, logical *bwork, integer *
	info);

/* Subroutine */ int sgeesx_(char *jobvs, char *sort, L_fp select, char *
	sense, integer *n, real_lotus *a, integer *lda, integer *sdim, real_lotus *wr, 
	real_lotus *wi, real_lotus *vs, integer *ldvs, real_lotus *rconde, real_lotus *rcondv, real_lotus *
	work, integer *lwork, integer *iwork, integer *liwork, logical *bwork, 
	 integer *info);

/* Subroutine */ int sgeev_(char *jobvl, char *jobvr, integer *n, real_lotus *a, 
	integer *lda, real_lotus *wr, real_lotus *wi, real_lotus *vl, integer *ldvl, real_lotus *vr, 
	integer *ldvr, real_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int sgeevx_(char *balanc, char *jobvl, char *jobvr, char *
	sense, integer *n, real_lotus *a, integer *lda, real_lotus *wr, real_lotus *wi, real_lotus *
	vl, integer *ldvl, real_lotus *vr, integer *ldvr, integer *ilo, integer *
	ihi, real_lotus *scale, real_lotus *abnrm, real_lotus *rconde, real_lotus *rcondv, real_lotus *work, 
	 integer *lwork, integer *iwork, integer *info);

/* Subroutine */ int sgegs_(char *jobvsl, char *jobvsr, integer *n, real_lotus *a, 
	integer *lda, real_lotus *b, integer *ldb, real_lotus *alphar, real_lotus *alphai, real_lotus 
	*beta, real_lotus *vsl, integer *ldvsl, real_lotus *vsr, integer *ldvsr, real_lotus *
	work, integer *lwork, integer *info);

/* Subroutine */ int sgegv_(char *jobvl, char *jobvr, integer *n, real_lotus *a, 
	integer *lda, real_lotus *b, integer *ldb, real_lotus *alphar, real_lotus *alphai, real_lotus 
	*beta, real_lotus *vl, integer *ldvl, real_lotus *vr, integer *ldvr, real_lotus *work, 
	integer *lwork, integer *info);

/* Subroutine */ int sgehd2_(integer *n, integer *ilo, integer *ihi, real_lotus *a, 
	integer *lda, real_lotus *tau, real_lotus *work, integer *info);

/* Subroutine */ int sgehrd_(integer *n, integer *ilo, integer *ihi, real_lotus *a, 
	integer *lda, real_lotus *tau, real_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int sgejsv_(char *joba, char *jobu, char *jobv, char *jobr, 
	char *jobt, char *jobp, integer *m, integer *n, real_lotus *a, integer *lda, 
	 real_lotus *sva, real_lotus *u, integer *ldu, real_lotus *v, integer *ldv, real_lotus *work, 
	integer *lwork, integer *iwork, integer *info);

/* Subroutine */ int sgelq2_(integer *m, integer *n, real_lotus *a, integer *lda, 
	real_lotus *tau, real_lotus *work, integer *info);

/* Subroutine */ int sgelqf_(integer *m, integer *n, real_lotus *a, integer *lda, 
	real_lotus *tau, real_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int sgels_(char *trans, integer *m, integer *n, integer *
	nrhs, real_lotus *a, integer *lda, real_lotus *b, integer *ldb, real_lotus *work, 
	integer *lwork, integer *info);

/* Subroutine */ int sgelsd_(integer *m, integer *n, integer *nrhs, real_lotus *a, 
	integer *lda, real_lotus *b, integer *ldb, real_lotus *s, real_lotus *rcond, integer *
	rank, real_lotus *work, integer *lwork, integer *iwork, integer *info);

/* Subroutine */ int sgelss_(integer *m, integer *n, integer *nrhs, real_lotus *a, 
	integer *lda, real_lotus *b, integer *ldb, real_lotus *s, real_lotus *rcond, integer *
	rank, real_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int sgelsx_(integer *m, integer *n, integer *nrhs, real_lotus *a, 
	integer *lda, real_lotus *b, integer *ldb, integer *jpvt, real_lotus *rcond, 
	integer *rank, real_lotus *work, integer *info);

/* Subroutine */ int sgelsy_(integer *m, integer *n, integer *nrhs, real_lotus *a, 
	integer *lda, real_lotus *b, integer *ldb, integer *jpvt, real_lotus *rcond, 
	integer *rank, real_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int sgeql2_(integer *m, integer *n, real_lotus *a, integer *lda, 
	real_lotus *tau, real_lotus *work, integer *info);

/* Subroutine */ int sgeqlf_(integer *m, integer *n, real_lotus *a, integer *lda, 
	real_lotus *tau, real_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int sgeqp3_(integer *m, integer *n, real_lotus *a, integer *lda, 
	integer *jpvt, real_lotus *tau, real_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int sgeqpf_(integer *m, integer *n, real_lotus *a, integer *lda, 
	integer *jpvt, real_lotus *tau, real_lotus *work, integer *info);

/* Subroutine */ int sgeqr2_(integer *m, integer *n, real_lotus *a, integer *lda, 
	real_lotus *tau, real_lotus *work, integer *info);

/* Subroutine */ int sgeqrf_(integer *m, integer *n, real_lotus *a, integer *lda, 
	real_lotus *tau, real_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int sgerfs_(char *trans, integer *n, integer *nrhs, real_lotus *a, 
	integer *lda, real_lotus *af, integer *ldaf, integer *ipiv, real_lotus *b, 
	integer *ldb, real_lotus *x, integer *ldx, real_lotus *ferr, real_lotus *berr, real_lotus *
	work, integer *iwork, integer *info);

/* Subroutine */ int sgerfsx_(char *trans, char *equed, integer *n, integer *
	nrhs, real_lotus *a, integer *lda, real_lotus *af, integer *ldaf, integer *ipiv, 
	real_lotus *r__, real_lotus *c__, real_lotus *b, integer *ldb, real_lotus *x, integer *ldx, 
	real_lotus *rcond, real_lotus *berr, integer *n_err_bnds__, real_lotus *err_bnds_norm__, 
	 real_lotus *err_bnds_comp__, integer *nparams, real_lotus *params, real_lotus *work, 
	integer *iwork, integer *info);

/* Subroutine */ int sgerq2_(integer *m, integer *n, real_lotus *a, integer *lda, 
	real_lotus *tau, real_lotus *work, integer *info);

/* Subroutine */ int sgerqf_(integer *m, integer *n, real_lotus *a, integer *lda, 
	real_lotus *tau, real_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int sgesc2_(integer *n, real_lotus *a, integer *lda, real_lotus *rhs, 
	integer *ipiv, integer *jpiv, real_lotus *scale);

/* Subroutine */ int sgesdd_(char *jobz, integer *m, integer *n, real_lotus *a, 
	integer *lda, real_lotus *s, real_lotus *u, integer *ldu, real_lotus *vt, integer *ldvt, 
	 real_lotus *work, integer *lwork, integer *iwork, integer *info);

/* Subroutine */ int sgesv_(integer *n, integer *nrhs, real_lotus *a, integer *lda, 
	integer *ipiv, real_lotus *b, integer *ldb, integer *info);

/* Subroutine */ int sgesvd_(char *jobu, char *jobvt, integer *m, integer *n, 
	real_lotus *a, integer *lda, real_lotus *s, real_lotus *u, integer *ldu, real_lotus *vt, 
	integer *ldvt, real_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int sgesvj_(char *joba, char *jobu, char *jobv, integer *m, 
	integer *n, real_lotus *a, integer *lda, real_lotus *sva, integer *mv, real_lotus *v, 
	integer *ldv, real_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int sgesvx_(char *fact, char *trans, integer *n, integer *
	nrhs, real_lotus *a, integer *lda, real_lotus *af, integer *ldaf, integer *ipiv, 
	char *equed, real_lotus *r__, real_lotus *c__, real_lotus *b, integer *ldb, real_lotus *x, 
	integer *ldx, real_lotus *rcond, real_lotus *ferr, real_lotus *berr, real_lotus *work, 
	integer *iwork, integer *info);

/* Subroutine */ int sgesvxx_(char *fact, char *trans, integer *n, integer *
	nrhs, real_lotus *a, integer *lda, real_lotus *af, integer *ldaf, integer *ipiv, 
	char *equed, real_lotus *r__, real_lotus *c__, real_lotus *b, integer *ldb, real_lotus *x, 
	integer *ldx, real_lotus *rcond, real_lotus *rpvgrw, real_lotus *berr, integer *
	n_err_bnds__, real_lotus *err_bnds_norm__, real_lotus *err_bnds_comp__, integer *
	nparams, real_lotus *params, real_lotus *work, integer *iwork, integer *info);

/* Subroutine */ int sgetc2_(integer *n, real_lotus *a, integer *lda, integer *ipiv, 
	 integer *jpiv, integer *info);

/* Subroutine */ int sgetf2_(integer *m, integer *n, real_lotus *a, integer *lda, 
	integer *ipiv, integer *info);

/* Subroutine */ int sgetrf_(integer *m, integer *n, real_lotus *a, integer *lda, 
	integer *ipiv, integer *info);

/* Subroutine */ int sgetri_(integer *n, real_lotus *a, integer *lda, integer *ipiv, 
	 real_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int sgetrs_(char *trans, integer *n, integer *nrhs, real_lotus *a, 
	integer *lda, integer *ipiv, real_lotus *b, integer *ldb, integer *info);

/* Subroutine */ int sggbak_(char *job, char *side, integer *n, integer *ilo, 
	integer *ihi, real_lotus *lscale, real_lotus *rscale, integer *m, real_lotus *v, 
	integer *ldv, integer *info);

/* Subroutine */ int sggbal_(char *job, integer *n, real_lotus *a, integer *lda, 
	real_lotus *b, integer *ldb, integer *ilo, integer *ihi, real_lotus *lscale, real_lotus 
	*rscale, real_lotus *work, integer *info);

/* Subroutine */ int sgges_(char *jobvsl, char *jobvsr, char *sort, L_fp 
	selctg, integer *n, real_lotus *a, integer *lda, real_lotus *b, integer *ldb, 
	integer *sdim, real_lotus *alphar, real_lotus *alphai, real_lotus *beta, real_lotus *vsl, 
	integer *ldvsl, real_lotus *vsr, integer *ldvsr, real_lotus *work, integer *lwork, 
	 logical *bwork, integer *info);

/* Subroutine */ int sggesx_(char *jobvsl, char *jobvsr, char *sort, L_fp 
	selctg, char *sense, integer *n, real_lotus *a, integer *lda, real_lotus *b, 
	integer *ldb, integer *sdim, real_lotus *alphar, real_lotus *alphai, real_lotus *beta, 
	real_lotus *vsl, integer *ldvsl, real_lotus *vsr, integer *ldvsr, real_lotus *rconde, 
	real_lotus *rcondv, real_lotus *work, integer *lwork, integer *iwork, integer *
	liwork, logical *bwork, integer *info);

/* Subroutine */ int sggev_(char *jobvl, char *jobvr, integer *n, real_lotus *a, 
	integer *lda, real_lotus *b, integer *ldb, real_lotus *alphar, real_lotus *alphai, real_lotus 
	*beta, real_lotus *vl, integer *ldvl, real_lotus *vr, integer *ldvr, real_lotus *work, 
	integer *lwork, integer *info);

/* Subroutine */ int sggevx_(char *balanc, char *jobvl, char *jobvr, char *
	sense, integer *n, real_lotus *a, integer *lda, real_lotus *b, integer *ldb, real_lotus 
	*alphar, real_lotus *alphai, real_lotus *beta, real_lotus *vl, integer *ldvl, real_lotus *vr, 
	integer *ldvr, integer *ilo, integer *ihi, real_lotus *lscale, real_lotus *rscale, 
	 real_lotus *abnrm, real_lotus *bbnrm, real_lotus *rconde, real_lotus *rcondv, real_lotus *work, 
	integer *lwork, integer *iwork, logical *bwork, integer *info);

/* Subroutine */ int sggglm_(integer *n, integer *m, integer *p, real_lotus *a, 
	integer *lda, real_lotus *b, integer *ldb, real_lotus *d__, real_lotus *x, real_lotus *y, 
	real_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int sgghrd_(char *compq, char *compz, integer *n, integer *
	ilo, integer *ihi, real_lotus *a, integer *lda, real_lotus *b, integer *ldb, real_lotus 
	*q, integer *ldq, real_lotus *z__, integer *ldz, integer *info);

/* Subroutine */ int sgglse_(integer *m, integer *n, integer *p, real_lotus *a, 
	integer *lda, real_lotus *b, integer *ldb, real_lotus *c__, real_lotus *d__, real_lotus *x, 
	real_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int sggqrf_(integer *n, integer *m, integer *p, real_lotus *a, 
	integer *lda, real_lotus *taua, real_lotus *b, integer *ldb, real_lotus *taub, real_lotus *
	work, integer *lwork, integer *info);

/* Subroutine */ int sggrqf_(integer *m, integer *p, integer *n, real_lotus *a, 
	integer *lda, real_lotus *taua, real_lotus *b, integer *ldb, real_lotus *taub, real_lotus *
	work, integer *lwork, integer *info);

/* Subroutine */ int sggsvd_(char *jobu, char *jobv, char *jobq, integer *m, 
	integer *n, integer *p, integer *k, integer *l, real_lotus *a, integer *lda, 
	 real_lotus *b, integer *ldb, real_lotus *alpha, real_lotus *beta, real_lotus *u, integer *
	ldu, real_lotus *v, integer *ldv, real_lotus *q, integer *ldq, real_lotus *work, 
	integer *iwork, integer *info);

/* Subroutine */ int sggsvp_(char *jobu, char *jobv, char *jobq, integer *m, 
	integer *p, integer *n, real_lotus *a, integer *lda, real_lotus *b, integer *ldb, 
	real_lotus *tola, real_lotus *tolb, integer *k, integer *l, real_lotus *u, integer *ldu, 
	 real_lotus *v, integer *ldv, real_lotus *q, integer *ldq, integer *iwork, real_lotus *
	tau, real_lotus *work, integer *info);

/* Subroutine */ int sgsvj0_(char *jobv, integer *m, integer *n, real_lotus *a, 
	integer *lda, real_lotus *d__, real_lotus *sva, integer *mv, real_lotus *v, integer *
	ldv, real_lotus *eps, real_lotus *sfmin, real_lotus *tol, integer *nsweep, real_lotus *work, 
	integer *lwork, integer *info);

/* Subroutine */ int sgsvj1_(char *jobv, integer *m, integer *n, integer *n1, 
	real_lotus *a, integer *lda, real_lotus *d__, real_lotus *sva, integer *mv, real_lotus *v, 
	integer *ldv, real_lotus *eps, real_lotus *sfmin, real_lotus *tol, integer *nsweep, 
	real_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int sgtcon_(char *norm, integer *n, real_lotus *dl, real_lotus *d__, 
	real_lotus *du, real_lotus *du2, integer *ipiv, real_lotus *anorm, real_lotus *rcond, real_lotus *
	work, integer *iwork, integer *info);

/* Subroutine */ int sgtrfs_(char *trans, integer *n, integer *nrhs, real_lotus *dl, 
	 real_lotus *d__, real_lotus *du, real_lotus *dlf, real_lotus *df, real_lotus *duf, real_lotus *du2, 
	integer *ipiv, real_lotus *b, integer *ldb, real_lotus *x, integer *ldx, real_lotus *
	ferr, real_lotus *berr, real_lotus *work, integer *iwork, integer *info);

/* Subroutine */ int sgtsv_(integer *n, integer *nrhs, real_lotus *dl, real_lotus *d__, 
	real_lotus *du, real_lotus *b, integer *ldb, integer *info);

/* Subroutine */ int sgtsvx_(char *fact, char *trans, integer *n, integer *
	nrhs, real_lotus *dl, real_lotus *d__, real_lotus *du, real_lotus *dlf, real_lotus *df, real_lotus *duf, 
	real_lotus *du2, integer *ipiv, real_lotus *b, integer *ldb, real_lotus *x, integer *
	ldx, real_lotus *rcond, real_lotus *ferr, real_lotus *berr, real_lotus *work, integer *iwork, 
	integer *info);

/* Subroutine */ int sgttrf_(integer *n, real_lotus *dl, real_lotus *d__, real_lotus *du, real_lotus *
	du2, integer *ipiv, integer *info);

/* Subroutine */ int sgttrs_(char *trans, integer *n, integer *nrhs, real_lotus *dl, 
	 real_lotus *d__, real_lotus *du, real_lotus *du2, integer *ipiv, real_lotus *b, integer *ldb, 
	 integer *info);

/* Subroutine */ int sgtts2_(integer *itrans, integer *n, integer *nrhs, real_lotus 
	*dl, real_lotus *d__, real_lotus *du, real_lotus *du2, integer *ipiv, real_lotus *b, integer *
	ldb);

/* Subroutine */ int shgeqz_(char *job, char *compq, char *compz, integer *n, 
	integer *ilo, integer *ihi, real_lotus *h__, integer *ldh, real_lotus *t, integer 
	*ldt, real_lotus *alphar, real_lotus *alphai, real_lotus *beta, real_lotus *q, integer *ldq, 
	real_lotus *z__, integer *ldz, real_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int shsein_(char *side, char *eigsrc, char *initv, logical *
	select, integer *n, real_lotus *h__, integer *ldh, real_lotus *wr, real_lotus *wi, real_lotus 
	*vl, integer *ldvl, real_lotus *vr, integer *ldvr, integer *mm, integer *m, 
	real_lotus *work, integer *ifaill, integer *ifailr, integer *info);

/* Subroutine */ int shseqr_(char *job, char *compz, integer *n, integer *ilo, 
	 integer *ihi, real_lotus *h__, integer *ldh, real_lotus *wr, real_lotus *wi, real_lotus *z__, 
	 integer *ldz, real_lotus *work, integer *lwork, integer *info);

logical sisnan_(real_lotus *sin__);

/* Subroutine */ int sla_gbamv__(integer *trans, integer *m, integer *n, 
	integer *kl, integer *ku, real_lotus *alpha, real_lotus *ab, integer *ldab, real_lotus *
	x, integer *incx, real_lotus *beta, real_lotus *y, integer *incy);

doublereal_lotus sla_gbrcond__(char *trans, integer *n, integer *kl, integer *ku, 
	real_lotus *ab, integer *ldab, real_lotus *afb, integer *ldafb, integer *ipiv, 
	integer *cmode, real_lotus *c__, integer *info, real_lotus *work, integer *iwork, 
	ftnlen trans_len);

/* Subroutine */ int sla_gbrfsx_extended__(integer *prec_type__, integer *
	trans_type__, integer *n, integer *kl, integer *ku, integer *nrhs, 
	real_lotus *ab, integer *ldab, real_lotus *afb, integer *ldafb, integer *ipiv, 
	logical *colequ, real_lotus *c__, real_lotus *b, integer *ldb, real_lotus *y, integer *
	ldy, real_lotus *berr_out__, integer *n_norms__, real_lotus *errs_n__, real_lotus *
	errs_c__, real_lotus *res, real_lotus *ayb, real_lotus *dy, real_lotus *y_tail__, real_lotus *rcond,
	 integer *ithresh, real_lotus *rthresh, real_lotus *dz_ub__, logical *
	ignore_cwise__, integer *info);

doublereal_lotus sla_gbrpvgrw__(integer *n, integer *kl, integer *ku, integer *
	ncols, real_lotus *ab, integer *ldab, real_lotus *afb, integer *ldafb);

/* Subroutine */ int sla_geamv__(integer *trans, integer *m, integer *n, real_lotus 
	*alpha, real_lotus *a, integer *lda, real_lotus *x, integer *incx, real_lotus *beta, 
	real_lotus *y, integer *incy);

doublereal_lotus sla_gercond__(char *trans, integer *n, real_lotus *a, integer *lda, real_lotus 
	*af, integer *ldaf, integer *ipiv, integer *cmode, real_lotus *c__, integer 
	*info, real_lotus *work, integer *iwork, ftnlen trans_len);

/* Subroutine */ int sla_gerfsx_extended__(integer *prec_type__, integer *
	trans_type__, integer *n, integer *nrhs, real_lotus *a, integer *lda, real_lotus *
	af, integer *ldaf, integer *ipiv, logical *colequ, real_lotus *c__, real_lotus *b,
	 integer *ldb, real_lotus *y, integer *ldy, real_lotus *berr_out__, integer *
	n_norms__, real_lotus *errs_n__, real_lotus *errs_c__, real_lotus *res, real_lotus *ayb, real_lotus 
	*dy, real_lotus *y_tail__, real_lotus *rcond, integer *ithresh, real_lotus *rthresh, 
	real_lotus *dz_ub__, logical *ignore_cwise__, integer *info);

/* Subroutine */ int sla_lin_berr__(integer *n, integer *nz, integer *nrhs, 
	real_lotus *res, real_lotus *ayb, real_lotus *berr);

doublereal_lotus sla_porcond__(char *uplo, integer *n, real_lotus *a, integer *lda, real_lotus *
	af, integer *ldaf, integer *cmode, real_lotus *c__, integer *info, real_lotus *
	work, integer *iwork, ftnlen uplo_len);

/* Subroutine */ int sla_porfsx_extended__(integer *prec_type__, char *uplo, 
	integer *n, integer *nrhs, real_lotus *a, integer *lda, real_lotus *af, integer *
	ldaf, logical *colequ, real_lotus *c__, real_lotus *b, integer *ldb, real_lotus *y, 
	integer *ldy, real_lotus *berr_out__, integer *n_norms__, real_lotus *errs_n__, 
	real_lotus *errs_c__, real_lotus *res, real_lotus *ayb, real_lotus *dy, real_lotus *y_tail__, real_lotus *
	rcond, integer *ithresh, real_lotus *rthresh, real_lotus *dz_ub__, logical *
	ignore_cwise__, integer *info, ftnlen uplo_len);

doublereal_lotus sla_porpvgrw__(char *uplo, integer *ncols, real_lotus *a, integer *lda, 
	real_lotus *af, integer *ldaf, real_lotus *work, ftnlen uplo_len);

doublereal_lotus sla_rpvgrw__(integer *n, integer *ncols, real_lotus *a, integer *lda, 
	real_lotus *af, integer *ldaf);

/* Subroutine */ int sla_syamv__(integer *uplo, integer *n, real_lotus *alpha, real_lotus 
	*a, integer *lda, real_lotus *x, integer *incx, real_lotus *beta, real_lotus *y, 
	integer *incy);

doublereal_lotus sla_syrcond__(char *uplo, integer *n, real_lotus *a, integer *lda, real_lotus *
	af, integer *ldaf, integer *ipiv, integer *cmode, real_lotus *c__, integer *
	info, real_lotus *work, integer *iwork, ftnlen uplo_len);

/* Subroutine */ int sla_syrfsx_extended__(integer *prec_type__, char *uplo, 
	integer *n, integer *nrhs, real_lotus *a, integer *lda, real_lotus *af, integer *
	ldaf, integer *ipiv, logical *colequ, real_lotus *c__, real_lotus *b, integer *
	ldb, real_lotus *y, integer *ldy, real_lotus *berr_out__, integer *n_norms__, 
	real_lotus *errs_n__, real_lotus *errs_c__, real_lotus *res, real_lotus *ayb, real_lotus *dy, real_lotus *
	y_tail__, real_lotus *rcond, integer *ithresh, real_lotus *rthresh, real_lotus *dz_ub__,
	 logical *ignore_cwise__, integer *info, ftnlen uplo_len);

doublereal_lotus sla_syrpvgrw__(char *uplo, integer *n, integer *info, real_lotus *a, 
	integer *lda, real_lotus *af, integer *ldaf, integer *ipiv, real_lotus *work, 
	ftnlen uplo_len);

/* Subroutine */ int sla_wwaddw__(integer *n, real_lotus *x, real_lotus *y, real_lotus *w);

/* Subroutine */ int slabad_(real_lotus *small, real_lotus *large);

/* Subroutine */ int slabrd_(integer *m, integer *n, integer *nb, real_lotus *a, 
	integer *lda, real_lotus *d__, real_lotus *e, real_lotus *tauq, real_lotus *taup, real_lotus *x, 
	integer *ldx, real_lotus *y, integer *ldy);

/* Subroutine */ int slacn2_(integer *n, real_lotus *v, real_lotus *x, integer *isgn, 
	real_lotus *est, integer *kase, integer *isave);

/* Subroutine */ int slacon_(integer *n, real_lotus *v, real_lotus *x, integer *isgn, 
	real_lotus *est, integer *kase);

/* Subroutine */ int slacpy_(char *uplo, integer *m, integer *n, real_lotus *a, 
	integer *lda, real_lotus *b, integer *ldb);

/* Subroutine */ int sladiv_(real_lotus *a, real_lotus *b, real_lotus *c__, real_lotus *d__, real_lotus *p, 
	real_lotus *q);

/* Subroutine */ int slae2_(real_lotus *a, real_lotus *b, real_lotus *c__, real_lotus *rt1, real_lotus *rt2);

/* Subroutine */ int slaebz_(integer *ijob, integer *nitmax, integer *n, 
	integer *mmax, integer *minp, integer *nbmin, real_lotus *abstol, real_lotus *
	reltol, real_lotus *pivmin, real_lotus *d__, real_lotus *e, real_lotus *e2, integer *nval, 
	real_lotus *ab, real_lotus *c__, integer *mout, integer *nab, real_lotus *work, integer 
	*iwork, integer *info);

/* Subroutine */ int slaed0_(integer *icompq, integer *qsiz, integer *n, real_lotus 
	*d__, real_lotus *e, real_lotus *q, integer *ldq, real_lotus *qstore, integer *ldqs, 
	real_lotus *work, integer *iwork, integer *info);

/* Subroutine */ int slaed1_(integer *n, real_lotus *d__, real_lotus *q, integer *ldq, 
	integer *indxq, real_lotus *rho, integer *cutpnt, real_lotus *work, integer *
	iwork, integer *info);

/* Subroutine */ int slaed2_(integer *k, integer *n, integer *n1, real_lotus *d__, 
	real_lotus *q, integer *ldq, integer *indxq, real_lotus *rho, real_lotus *z__, real_lotus *
	dlamda, real_lotus *w, real_lotus *q2, integer *indx, integer *indxc, integer *
	indxp, integer *coltyp, integer *info);

/* Subroutine */ int slaed3_(integer *k, integer *n, integer *n1, real_lotus *d__, 
	real_lotus *q, integer *ldq, real_lotus *rho, real_lotus *dlamda, real_lotus *q2, integer *
	indx, integer *ctot, real_lotus *w, real_lotus *s, integer *info);

/* Subroutine */ int slaed4_(integer *n, integer *i__, real_lotus *d__, real_lotus *z__, 
	real_lotus *delta, real_lotus *rho, real_lotus *dlam, integer *info);

/* Subroutine */ int slaed5_(integer *i__, real_lotus *d__, real_lotus *z__, real_lotus *delta, 
	real_lotus *rho, real_lotus *dlam);

/* Subroutine */ int slaed6_(integer *kniter, logical *orgati, real_lotus *rho, 
	real_lotus *d__, real_lotus *z__, real_lotus *finit, real_lotus *tau, integer *info);

/* Subroutine */ int slaed7_(integer *icompq, integer *n, integer *qsiz, 
	integer *tlvls, integer *curlvl, integer *curpbm, real_lotus *d__, real_lotus *q, 
	integer *ldq, integer *indxq, real_lotus *rho, integer *cutpnt, real_lotus *
	qstore, integer *qptr, integer *prmptr, integer *perm, integer *
	givptr, integer *givcol, real_lotus *givnum, real_lotus *work, integer *iwork, 
	integer *info);

/* Subroutine */ int slaed8_(integer *icompq, integer *k, integer *n, integer 
	*qsiz, real_lotus *d__, real_lotus *q, integer *ldq, integer *indxq, real_lotus *rho, 
	integer *cutpnt, real_lotus *z__, real_lotus *dlamda, real_lotus *q2, integer *ldq2, 
	real_lotus *w, integer *perm, integer *givptr, integer *givcol, real_lotus *
	givnum, integer *indxp, integer *indx, integer *info);

/* Subroutine */ int slaed9_(integer *k, integer *kstart, integer *kstop, 
	integer *n, real_lotus *d__, real_lotus *q, integer *ldq, real_lotus *rho, real_lotus *dlamda, 
	 real_lotus *w, real_lotus *s, integer *lds, integer *info);

/* Subroutine */ int slaeda_(integer *n, integer *tlvls, integer *curlvl, 
	integer *curpbm, integer *prmptr, integer *perm, integer *givptr, 
	integer *givcol, real_lotus *givnum, real_lotus *q, integer *qptr, real_lotus *z__, 
	real_lotus *ztemp, integer *info);

/* Subroutine */ int slaein_(logical *rightv, logical *noinit, integer *n, 
	real_lotus *h__, integer *ldh, real_lotus *wr, real_lotus *wi, real_lotus *vr, real_lotus *vi, real_lotus 
	*b, integer *ldb, real_lotus *work, real_lotus *eps3, real_lotus *smlnum, real_lotus *bignum, 
	integer *info);

/* Subroutine */ int slaev2_(real_lotus *a, real_lotus *b, real_lotus *c__, real_lotus *rt1, real_lotus *
	rt2, real_lotus *cs1, real_lotus *sn1);

/* Subroutine */ int slaexc_(logical *wantq, integer *n, real_lotus *t, integer *
	ldt, real_lotus *q, integer *ldq, integer *j1, integer *n1, integer *n2, 
	real_lotus *work, integer *info);

/* Subroutine */ int slag2_(real_lotus *a, integer *lda, real_lotus *b, integer *ldb, 
	real_lotus *safmin, real_lotus *scale1, real_lotus *scale2, real_lotus *wr1, real_lotus *wr2, real_lotus *
	wi);

/* Subroutine */ int slag2d_(integer *m, integer *n, real_lotus *sa, integer *ldsa, 
	doublereal_lotus *a, integer *lda, integer *info);

/* Subroutine */ int slags2_(logical *upper, real_lotus *a1, real_lotus *a2, real_lotus *a3, 
	real_lotus *b1, real_lotus *b2, real_lotus *b3, real_lotus *csu, real_lotus *snu, real_lotus *csv, real_lotus *
	snv, real_lotus *csq, real_lotus *snq);

/* Subroutine */ int slagtf_(integer *n, real_lotus *a, real_lotus *lambda, real_lotus *b, real_lotus 
	*c__, real_lotus *tol, real_lotus *d__, integer *in, integer *info);

/* Subroutine */ int slagtm_(char *trans, integer *n, integer *nrhs, real_lotus *
	alpha, real_lotus *dl, real_lotus *d__, real_lotus *du, real_lotus *x, integer *ldx, real_lotus *
	beta, real_lotus *b, integer *ldb);

/* Subroutine */ int slagts_(integer *job, integer *n, real_lotus *a, real_lotus *b, real_lotus 
	*c__, real_lotus *d__, integer *in, real_lotus *y, real_lotus *tol, integer *info);

/* Subroutine */ int slagv2_(real_lotus *a, integer *lda, real_lotus *b, integer *ldb, 
	real_lotus *alphar, real_lotus *alphai, real_lotus *beta, real_lotus *csl, real_lotus *snl, real_lotus *
	csr, real_lotus *snr);

/* Subroutine */ int slahqr_(logical *wantt, logical *wantz, integer *n, 
	integer *ilo, integer *ihi, real_lotus *h__, integer *ldh, real_lotus *wr, real_lotus *
	wi, integer *iloz, integer *ihiz, real_lotus *z__, integer *ldz, integer *
	info);

/* Subroutine */ int slahr2_(integer *n, integer *k, integer *nb, real_lotus *a, 
	integer *lda, real_lotus *tau, real_lotus *t, integer *ldt, real_lotus *y, integer *ldy);

/* Subroutine */ int slahrd_(integer *n, integer *k, integer *nb, real_lotus *a, 
	integer *lda, real_lotus *tau, real_lotus *t, integer *ldt, real_lotus *y, integer *ldy);

/* Subroutine */ int slaic1_(integer *job, integer *j, real_lotus *x, real_lotus *sest, 
	real_lotus *w, real_lotus *gamma, real_lotus *sestpr, real_lotus *s, real_lotus *c__);

logical slaisnan_(real_lotus *sin1, real_lotus *sin2);

/* Subroutine */ int slaln2_(logical *ltrans, integer *na, integer *nw, real_lotus *
	smin, real_lotus *ca, real_lotus *a, integer *lda, real_lotus *d1, real_lotus *d2, real_lotus *b, 
	integer *ldb, real_lotus *wr, real_lotus *wi, real_lotus *x, integer *ldx, real_lotus *scale, 
	real_lotus *xnorm, integer *info);

/* Subroutine */ int slals0_(integer *icompq, integer *nl, integer *nr, 
	integer *sqre, integer *nrhs, real_lotus *b, integer *ldb, real_lotus *bx, 
	integer *ldbx, integer *perm, integer *givptr, integer *givcol, 
	integer *ldgcol, real_lotus *givnum, integer *ldgnum, real_lotus *poles, real_lotus *
	difl, real_lotus *difr, real_lotus *z__, integer *k, real_lotus *c__, real_lotus *s, real_lotus *
	work, integer *info);

/* Subroutine */ int slalsa_(integer *icompq, integer *smlsiz, integer *n, 
	integer *nrhs, real_lotus *b, integer *ldb, real_lotus *bx, integer *ldbx, real_lotus *
	u, integer *ldu, real_lotus *vt, integer *k, real_lotus *difl, real_lotus *difr, real_lotus *
	z__, real_lotus *poles, integer *givptr, integer *givcol, integer *ldgcol, 
	integer *perm, real_lotus *givnum, real_lotus *c__, real_lotus *s, real_lotus *work, integer *
	iwork, integer *info);

/* Subroutine */ int slalsd_(char *uplo, integer *smlsiz, integer *n, integer 
	*nrhs, real_lotus *d__, real_lotus *e, real_lotus *b, integer *ldb, real_lotus *rcond, 
	integer *rank, real_lotus *work, integer *iwork, integer *info);

/* Subroutine */ int slamrg_(integer *n1, integer *n2, real_lotus *a, integer *
	strd1, integer *strd2, integer *index);

integer slaneg_(integer *n, real_lotus *d__, real_lotus *lld, real_lotus *sigma, real_lotus *pivmin, 
	integer *r__);

doublereal_lotus slangb_(char *norm, integer *n, integer *kl, integer *ku, real_lotus *ab, 
	 integer *ldab, real_lotus *work);

doublereal_lotus slange_(char *norm, integer *m, integer *n, real_lotus *a, integer *lda, 
	real_lotus *work);

doublereal_lotus slangt_(char *norm, integer *n, real_lotus *dl, real_lotus *d__, real_lotus *du);

doublereal_lotus slanhs_(char *norm, integer *n, real_lotus *a, integer *lda, real_lotus *work);

doublereal_lotus slansb_(char *norm, char *uplo, integer *n, integer *k, real_lotus *ab, 
	integer *ldab, real_lotus *work);

doublereal_lotus slansf_(char *norm, char *transr, char *uplo, integer *n, real_lotus *a, 
	real_lotus *work);

doublereal_lotus slansp_(char *norm, char *uplo, integer *n, real_lotus *ap, real_lotus *work);

doublereal_lotus slanst_(char *norm, integer *n, real_lotus *d__, real_lotus *e);

doublereal_lotus slansy_(char *norm, char *uplo, integer *n, real_lotus *a, integer *lda, 
	real_lotus *work);

doublereal_lotus slantb_(char *norm, char *uplo, char *diag, integer *n, integer *k, 
	 real_lotus *ab, integer *ldab, real_lotus *work);

doublereal_lotus slantp_(char *norm, char *uplo, char *diag, integer *n, real_lotus *ap, 
	real_lotus *work);

doublereal_lotus slantr_(char *norm, char *uplo, char *diag, integer *m, integer *n, 
	 real_lotus *a, integer *lda, real_lotus *work);

/* Subroutine */ int slanv2_(real_lotus *a, real_lotus *b, real_lotus *c__, real_lotus *d__, real_lotus *
	rt1r, real_lotus *rt1i, real_lotus *rt2r, real_lotus *rt2i, real_lotus *cs, real_lotus *sn);

/* Subroutine */ int slapll_(integer *n, real_lotus *x, integer *incx, real_lotus *y, 
	integer *incy, real_lotus *ssmin);

/* Subroutine */ int slapmt_(logical *forwrd, integer *m, integer *n, real_lotus *x, 
	 integer *ldx, integer *k);

doublereal_lotus slapy2_(real_lotus *x, real_lotus *y);

doublereal_lotus slapy3_(real_lotus *x, real_lotus *y, real_lotus *z__);

/* Subroutine */ int slaqgb_(integer *m, integer *n, integer *kl, integer *ku, 
	 real_lotus *ab, integer *ldab, real_lotus *r__, real_lotus *c__, real_lotus *rowcnd, real_lotus *
	colcnd, real_lotus *amax, char *equed);

/* Subroutine */ int slaqge_(integer *m, integer *n, real_lotus *a, integer *lda, 
	real_lotus *r__, real_lotus *c__, real_lotus *rowcnd, real_lotus *colcnd, real_lotus *amax, char *
	equed);

/* Subroutine */ int slaqp2_(integer *m, integer *n, integer *offset, real_lotus *a, 
	 integer *lda, integer *jpvt, real_lotus *tau, real_lotus *vn1, real_lotus *vn2, real_lotus *
	work);

/* Subroutine */ int slaqps_(integer *m, integer *n, integer *offset, integer 
	*nb, integer *kb, real_lotus *a, integer *lda, integer *jpvt, real_lotus *tau, 
	real_lotus *vn1, real_lotus *vn2, real_lotus *auxv, real_lotus *f, integer *ldf);

/* Subroutine */ int slaqr0_(logical *wantt, logical *wantz, integer *n, 
	integer *ilo, integer *ihi, real_lotus *h__, integer *ldh, real_lotus *wr, real_lotus *
	wi, integer *iloz, integer *ihiz, real_lotus *z__, integer *ldz, real_lotus *work, 
	 integer *lwork, integer *info);

/* Subroutine */ int slaqr1_(integer *n, real_lotus *h__, integer *ldh, real_lotus *sr1, 
	real_lotus *si1, real_lotus *sr2, real_lotus *si2, real_lotus *v);

/* Subroutine */ int slaqr2_(logical *wantt, logical *wantz, integer *n, 
	integer *ktop, integer *kbot, integer *nw, real_lotus *h__, integer *ldh, 
	integer *iloz, integer *ihiz, real_lotus *z__, integer *ldz, integer *ns, 
	integer *nd, real_lotus *sr, real_lotus *si, real_lotus *v, integer *ldv, integer *nh, 
	real_lotus *t, integer *ldt, integer *nv, real_lotus *wv, integer *ldwv, real_lotus *
	work, integer *lwork);

/* Subroutine */ int slaqr3_(logical *wantt, logical *wantz, integer *n, 
	integer *ktop, integer *kbot, integer *nw, real_lotus *h__, integer *ldh, 
	integer *iloz, integer *ihiz, real_lotus *z__, integer *ldz, integer *ns, 
	integer *nd, real_lotus *sr, real_lotus *si, real_lotus *v, integer *ldv, integer *nh, 
	real_lotus *t, integer *ldt, integer *nv, real_lotus *wv, integer *ldwv, real_lotus *
	work, integer *lwork);

/* Subroutine */ int slaqr4_(logical *wantt, logical *wantz, integer *n, 
	integer *ilo, integer *ihi, real_lotus *h__, integer *ldh, real_lotus *wr, real_lotus *
	wi, integer *iloz, integer *ihiz, real_lotus *z__, integer *ldz, real_lotus *work, 
	 integer *lwork, integer *info);

/* Subroutine */ int slaqr5_(logical *wantt, logical *wantz, integer *kacc22, 
	integer *n, integer *ktop, integer *kbot, integer *nshfts, real_lotus *sr, 
	real_lotus *si, real_lotus *h__, integer *ldh, integer *iloz, integer *ihiz, real_lotus 
	*z__, integer *ldz, real_lotus *v, integer *ldv, real_lotus *u, integer *ldu, 
	integer *nv, real_lotus *wv, integer *ldwv, integer *nh, real_lotus *wh, integer *
	ldwh);

/* Subroutine */ int slaqsb_(char *uplo, integer *n, integer *kd, real_lotus *ab, 
	integer *ldab, real_lotus *s, real_lotus *scond, real_lotus *amax, char *equed);

/* Subroutine */ int slaqsp_(char *uplo, integer *n, real_lotus *ap, real_lotus *s, real_lotus *
	scond, real_lotus *amax, char *equed);

/* Subroutine */ int slaqsy_(char *uplo, integer *n, real_lotus *a, integer *lda, 
	real_lotus *s, real_lotus *scond, real_lotus *amax, char *equed);

/* Subroutine */ int slaqtr_(logical *ltran, logical *lreal_lotus, integer *n, real_lotus 
	*t, integer *ldt, real_lotus *b, real_lotus *w, real_lotus *scale, real_lotus *x, real_lotus *work, 
	integer *info);

/* Subroutine */ int slar1v_(integer *n, integer *b1, integer *bn, real_lotus *
	lambda, real_lotus *d__, real_lotus *l, real_lotus *ld, real_lotus *lld, real_lotus *pivmin, real_lotus *
	gaptol, real_lotus *z__, logical *wantnc, integer *negcnt, real_lotus *ztz, real_lotus *
	mingma, integer *r__, integer *isuppz, real_lotus *nrminv, real_lotus *resid, 
	real_lotus *rqcorr, real_lotus *work);

/* Subroutine */ int slar2v_(integer *n, real_lotus *x, real_lotus *y, real_lotus *z__, integer 
	*incx, real_lotus *c__, real_lotus *s, integer *incc);

/* Subroutine */ int slarf_(char *side, integer *m, integer *n, real_lotus *v, 
	integer *incv, real_lotus *tau, real_lotus *c__, integer *ldc, real_lotus *work);

/* Subroutine */ int slarfb_(char *side, char *trans, char *direct, char *
	storev, integer *m, integer *n, integer *k, real_lotus *v, integer *ldv, 
	real_lotus *t, integer *ldt, real_lotus *c__, integer *ldc, real_lotus *work, integer *
	ldwork);

/* Subroutine */ int slarfg_(integer *n, real_lotus *alpha, real_lotus *x, integer *incx, 
	real_lotus *tau);

/* Subroutine */ int slarfp_(integer *n, real_lotus *alpha, real_lotus *x, integer *incx, 
	real_lotus *tau);

/* Subroutine */ int slarft_(char *direct, char *storev, integer *n, integer *
	k, real_lotus *v, integer *ldv, real_lotus *tau, real_lotus *t, integer *ldt);

/* Subroutine */ int slarfx_(char *side, integer *m, integer *n, real_lotus *v, 
	real_lotus *tau, real_lotus *c__, integer *ldc, real_lotus *work);

/* Subroutine */ int slargv_(integer *n, real_lotus *x, integer *incx, real_lotus *y, 
	integer *incy, real_lotus *c__, integer *incc);

/* Subroutine */ int slarnv_(integer *idist, integer *iseed, integer *n, real_lotus 
	*x);

/* Subroutine */ int slarra_(integer *n, real_lotus *d__, real_lotus *e, real_lotus *e2, real_lotus *
	spltol, real_lotus *tnrm, integer *nsplit, integer *isplit, integer *info);

/* Subroutine */ int slarrb_(integer *n, real_lotus *d__, real_lotus *lld, integer *
	ifirst, integer *ilast, real_lotus *rtol1, real_lotus *rtol2, integer *offset, 
	real_lotus *w, real_lotus *wgap, real_lotus *werr, real_lotus *work, integer *iwork, real_lotus *
	pivmin, real_lotus *spdiam, integer *twist, integer *info);

/* Subroutine */ int slarrc_(char *jobt, integer *n, real_lotus *vl, real_lotus *vu, real_lotus 
	*d__, real_lotus *e, real_lotus *pivmin, integer *eigcnt, integer *lcnt, integer *
	rcnt, integer *info);

/* Subroutine */ int slarrd_(char *range, char *order, integer *n, real_lotus *vl, 
	real_lotus *vu, integer *il, integer *iu, real_lotus *gers, real_lotus *reltol, real_lotus *
	d__, real_lotus *e, real_lotus *e2, real_lotus *pivmin, integer *nsplit, integer *
	isplit, integer *m, real_lotus *w, real_lotus *werr, real_lotus *wl, real_lotus *wu, integer *
	iblock, integer *indexw, real_lotus *work, integer *iwork, integer *info);

/* Subroutine */ int slarre_(char *range, integer *n, real_lotus *vl, real_lotus *vu, 
	integer *il, integer *iu, real_lotus *d__, real_lotus *e, real_lotus *e2, real_lotus *rtol1, 
	real_lotus *rtol2, real_lotus *spltol, integer *nsplit, integer *isplit, integer *
	m, real_lotus *w, real_lotus *werr, real_lotus *wgap, integer *iblock, integer *indexw, 
	real_lotus *gers, real_lotus *pivmin, real_lotus *work, integer *iwork, integer *info);

/* Subroutine */ int slarrf_(integer *n, real_lotus *d__, real_lotus *l, real_lotus *ld, 
	integer *clstrt, integer *clend, real_lotus *w, real_lotus *wgap, real_lotus *werr, 
	real_lotus *spdiam, real_lotus *clgapl, real_lotus *clgapr, real_lotus *pivmin, real_lotus *sigma, 
	real_lotus *dplus, real_lotus *lplus, real_lotus *work, integer *info);

/* Subroutine */ int slarrj_(integer *n, real_lotus *d__, real_lotus *e2, integer *ifirst, 
	 integer *ilast, real_lotus *rtol, integer *offset, real_lotus *w, real_lotus *werr, 
	real_lotus *work, integer *iwork, real_lotus *pivmin, real_lotus *spdiam, integer *info);

/* Subroutine */ int slarrk_(integer *n, integer *iw, real_lotus *gl, real_lotus *gu, 
	real_lotus *d__, real_lotus *e2, real_lotus *pivmin, real_lotus *reltol, real_lotus *w, real_lotus *werr, 
	integer *info);

/* Subroutine */ int slarrr_(integer *n, real_lotus *d__, real_lotus *e, integer *info);

/* Subroutine */ int slarrv_(integer *n, real_lotus *vl, real_lotus *vu, real_lotus *d__, real_lotus *
	l, real_lotus *pivmin, integer *isplit, integer *m, integer *dol, integer *
	dou, real_lotus *minrgp, real_lotus *rtol1, real_lotus *rtol2, real_lotus *w, real_lotus *werr, 
	real_lotus *wgap, integer *iblock, integer *indexw, real_lotus *gers, real_lotus *z__, 
	integer *ldz, integer *isuppz, real_lotus *work, integer *iwork, integer *
	info);

/* Subroutine */ int slarscl2_(integer *m, integer *n, real_lotus *d__, real_lotus *x, 
	integer *ldx);

/* Subroutine */ int slartg_(real_lotus *f, real_lotus *g, real_lotus *cs, real_lotus *sn, real_lotus *r__);

/* Subroutine */ int slartv_(integer *n, real_lotus *x, integer *incx, real_lotus *y, 
	integer *incy, real_lotus *c__, real_lotus *s, integer *incc);

/* Subroutine */ int slaruv_(integer *iseed, integer *n, real_lotus *x);

/* Subroutine */ int slarz_(char *side, integer *m, integer *n, integer *l, 
	real_lotus *v, integer *incv, real_lotus *tau, real_lotus *c__, integer *ldc, real_lotus *
	work);

/* Subroutine */ int slarzb_(char *side, char *trans, char *direct, char *
	storev, integer *m, integer *n, integer *k, integer *l, real_lotus *v, 
	integer *ldv, real_lotus *t, integer *ldt, real_lotus *c__, integer *ldc, real_lotus *
	work, integer *ldwork);

/* Subroutine */ int slarzt_(char *direct, char *storev, integer *n, integer *
	k, real_lotus *v, integer *ldv, real_lotus *tau, real_lotus *t, integer *ldt);

/* Subroutine */ int slas2_(real_lotus *f, real_lotus *g, real_lotus *h__, real_lotus *ssmin, real_lotus *
	ssmax);

/* Subroutine */ int slascl_(char *type__, integer *kl, integer *ku, real_lotus *
	cfrom, real_lotus *cto, integer *m, integer *n, real_lotus *a, integer *lda, 
	integer *info);

/* Subroutine */ int slascl2_(integer *m, integer *n, real_lotus *d__, real_lotus *x, 
	integer *ldx);

/* Subroutine */ int slasd0_(integer *n, integer *sqre, real_lotus *d__, real_lotus *e, 
	real_lotus *u, integer *ldu, real_lotus *vt, integer *ldvt, integer *smlsiz, 
	integer *iwork, real_lotus *work, integer *info);

/* Subroutine */ int slasd1_(integer *nl, integer *nr, integer *sqre, real_lotus *
	d__, real_lotus *alpha, real_lotus *beta, real_lotus *u, integer *ldu, real_lotus *vt, 
	integer *ldvt, integer *idxq, integer *iwork, real_lotus *work, integer *
	info);

/* Subroutine */ int slasd2_(integer *nl, integer *nr, integer *sqre, integer 
	*k, real_lotus *d__, real_lotus *z__, real_lotus *alpha, real_lotus *beta, real_lotus *u, integer *
	ldu, real_lotus *vt, integer *ldvt, real_lotus *dsigma, real_lotus *u2, integer *ldu2, 
	real_lotus *vt2, integer *ldvt2, integer *idxp, integer *idx, integer *idxc, 
	 integer *idxq, integer *coltyp, integer *info);

/* Subroutine */ int slasd3_(integer *nl, integer *nr, integer *sqre, integer 
	*k, real_lotus *d__, real_lotus *q, integer *ldq, real_lotus *dsigma, real_lotus *u, integer *
	ldu, real_lotus *u2, integer *ldu2, real_lotus *vt, integer *ldvt, real_lotus *vt2, 
	integer *ldvt2, integer *idxc, integer *ctot, real_lotus *z__, integer *
	info);

/* Subroutine */ int slasd4_(integer *n, integer *i__, real_lotus *d__, real_lotus *z__, 
	real_lotus *delta, real_lotus *rho, real_lotus *sigma, real_lotus *work, integer *info);

/* Subroutine */ int slasd5_(integer *i__, real_lotus *d__, real_lotus *z__, real_lotus *delta, 
	real_lotus *rho, real_lotus *dsigma, real_lotus *work);

/* Subroutine */ int slasd6_(integer *icompq, integer *nl, integer *nr, 
	integer *sqre, real_lotus *d__, real_lotus *vf, real_lotus *vl, real_lotus *alpha, real_lotus *beta, 
	 integer *idxq, integer *perm, integer *givptr, integer *givcol, 
	integer *ldgcol, real_lotus *givnum, integer *ldgnum, real_lotus *poles, real_lotus *
	difl, real_lotus *difr, real_lotus *z__, integer *k, real_lotus *c__, real_lotus *s, real_lotus *
	work, integer *iwork, integer *info);

/* Subroutine */ int slasd7_(integer *icompq, integer *nl, integer *nr, 
	integer *sqre, integer *k, real_lotus *d__, real_lotus *z__, real_lotus *zw, real_lotus *vf, 
	real_lotus *vfw, real_lotus *vl, real_lotus *vlw, real_lotus *alpha, real_lotus *beta, real_lotus *dsigma, 
	 integer *idx, integer *idxp, integer *idxq, integer *perm, integer *
	givptr, integer *givcol, integer *ldgcol, real_lotus *givnum, integer *
	ldgnum, real_lotus *c__, real_lotus *s, integer *info);

/* Subroutine */ int slasd8_(integer *icompq, integer *k, real_lotus *d__, real_lotus *
	z__, real_lotus *vf, real_lotus *vl, real_lotus *difl, real_lotus *difr, integer *lddifr, 
	real_lotus *dsigma, real_lotus *work, integer *info);

/* Subroutine */ int slasda_(integer *icompq, integer *smlsiz, integer *n, 
	integer *sqre, real_lotus *d__, real_lotus *e, real_lotus *u, integer *ldu, real_lotus *vt, 
	integer *k, real_lotus *difl, real_lotus *difr, real_lotus *z__, real_lotus *poles, integer *
	givptr, integer *givcol, integer *ldgcol, integer *perm, real_lotus *givnum, 
	 real_lotus *c__, real_lotus *s, real_lotus *work, integer *iwork, integer *info);

/* Subroutine */ int slasdq_(char *uplo, integer *sqre, integer *n, integer *
	ncvt, integer *nru, integer *ncc, real_lotus *d__, real_lotus *e, real_lotus *vt, 
	integer *ldvt, real_lotus *u, integer *ldu, real_lotus *c__, integer *ldc, real_lotus *
	work, integer *info);

/* Subroutine */ int slasdt_(integer *n, integer *lvl, integer *nd, integer *
	inode, integer *ndiml, integer *ndimr, integer *msub);

/* Subroutine */ int slaset_(char *uplo, integer *m, integer *n, real_lotus *alpha, 
	real_lotus *beta, real_lotus *a, integer *lda);

/* Subroutine */ int slasq1_(integer *n, real_lotus *d__, real_lotus *e, real_lotus *work, 
	integer *info);

/* Subroutine */ int slasq2_(integer *n, real_lotus *z__, integer *info);

/* Subroutine */ int slasq3_(integer *i0, integer *n0, real_lotus *z__, integer *pp, 
	 real_lotus *dmin__, real_lotus *sigma, real_lotus *desig, real_lotus *qmax, integer *nfail, 
	integer *iter, integer *ndiv, logical *ieee, integer *ttype, real_lotus *
	dmin1, real_lotus *dmin2, real_lotus *dn, real_lotus *dn1, real_lotus *dn2, real_lotus *g, real_lotus *
	tau);

/* Subroutine */ int slasq4_(integer *i0, integer *n0, real_lotus *z__, integer *pp, 
	 integer *n0in, real_lotus *dmin__, real_lotus *dmin1, real_lotus *dmin2, real_lotus *dn, 
	real_lotus *dn1, real_lotus *dn2, real_lotus *tau, integer *ttype, real_lotus *g);

/* Subroutine */ int slasq5_(integer *i0, integer *n0, real_lotus *z__, integer *pp, 
	 real_lotus *tau, real_lotus *dmin__, real_lotus *dmin1, real_lotus *dmin2, real_lotus *dn, real_lotus *
	dnm1, real_lotus *dnm2, logical *ieee);

/* Subroutine */ int slasq6_(integer *i0, integer *n0, real_lotus *z__, integer *pp, 
	 real_lotus *dmin__, real_lotus *dmin1, real_lotus *dmin2, real_lotus *dn, real_lotus *dnm1, real_lotus *
	dnm2);

/* Subroutine */ int slasr_(char *side, char *pivot, char *direct, integer *m, 
	 integer *n, real_lotus *c__, real_lotus *s, real_lotus *a, integer *lda);

/* Subroutine */ int slasrt_(char *id, integer *n, real_lotus *d__, integer *info);

/* Subroutine */ int slassq_(integer *n, real_lotus *x, integer *incx, real_lotus *scale, 
	real_lotus *sumsq);

/* Subroutine */ int slasv2_(real_lotus *f, real_lotus *g, real_lotus *h__, real_lotus *ssmin, real_lotus *
	ssmax, real_lotus *snr, real_lotus *csr, real_lotus *snl, real_lotus *csl);

/* Subroutine */ int slaswp_(integer *n, real_lotus *a, integer *lda, integer *k1, 
	integer *k2, integer *ipiv, integer *incx);

/* Subroutine */ int slasy2_(logical *ltranl, logical *ltranr, integer *isgn, 
	integer *n1, integer *n2, real_lotus *tl, integer *ldtl, real_lotus *tr, integer *
	ldtr, real_lotus *b, integer *ldb, real_lotus *scale, real_lotus *x, integer *ldx, real_lotus 
	*xnorm, integer *info);

/* Subroutine */ int slasyf_(char *uplo, integer *n, integer *nb, integer *kb, 
	 real_lotus *a, integer *lda, integer *ipiv, real_lotus *w, integer *ldw, integer 
	*info);

/* Subroutine */ int slatbs_(char *uplo, char *trans, char *diag, char *
	normin, integer *n, integer *kd, real_lotus *ab, integer *ldab, real_lotus *x, 
	real_lotus *scale, real_lotus *cnorm, integer *info);

/* Subroutine */ int slatdf_(integer *ijob, integer *n, real_lotus *z__, integer *
	ldz, real_lotus *rhs, real_lotus *rdsum, real_lotus *rdscal, integer *ipiv, integer *
	jpiv);

/* Subroutine */ int slatps_(char *uplo, char *trans, char *diag, char *
	normin, integer *n, real_lotus *ap, real_lotus *x, real_lotus *scale, real_lotus *cnorm, 
	integer *info);

/* Subroutine */ int slatrd_(char *uplo, integer *n, integer *nb, real_lotus *a, 
	integer *lda, real_lotus *e, real_lotus *tau, real_lotus *w, integer *ldw);

/* Subroutine */ int slatrs_(char *uplo, char *trans, char *diag, char *
	normin, integer *n, real_lotus *a, integer *lda, real_lotus *x, real_lotus *scale, real_lotus 
	*cnorm, integer *info);

/* Subroutine */ int slatrz_(integer *m, integer *n, integer *l, real_lotus *a, 
	integer *lda, real_lotus *tau, real_lotus *work);

/* Subroutine */ int slatzm_(char *side, integer *m, integer *n, real_lotus *v, 
	integer *incv, real_lotus *tau, real_lotus *c1, real_lotus *c2, integer *ldc, real_lotus *
	work);

/* Subroutine */ int slauu2_(char *uplo, integer *n, real_lotus *a, integer *lda, 
	integer *info);

/* Subroutine */ int slauum_(char *uplo, integer *n, real_lotus *a, integer *lda, 
	integer *info);

/* Subroutine */ int sopgtr_(char *uplo, integer *n, real_lotus *ap, real_lotus *tau, 
	real_lotus *q, integer *ldq, real_lotus *work, integer *info);

/* Subroutine */ int sopmtr_(char *side, char *uplo, char *trans, integer *m, 
	integer *n, real_lotus *ap, real_lotus *tau, real_lotus *c__, integer *ldc, real_lotus *work, 
	integer *info);

/* Subroutine */ int sorg2l_(integer *m, integer *n, integer *k, real_lotus *a, 
	integer *lda, real_lotus *tau, real_lotus *work, integer *info);

/* Subroutine */ int sorg2r_(integer *m, integer *n, integer *k, real_lotus *a, 
	integer *lda, real_lotus *tau, real_lotus *work, integer *info);

/* Subroutine */ int sorgbr_(char *vect, integer *m, integer *n, integer *k, 
	real_lotus *a, integer *lda, real_lotus *tau, real_lotus *work, integer *lwork, integer 
	*info);

/* Subroutine */ int sorghr_(integer *n, integer *ilo, integer *ihi, real_lotus *a, 
	integer *lda, real_lotus *tau, real_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int sorgl2_(integer *m, integer *n, integer *k, real_lotus *a, 
	integer *lda, real_lotus *tau, real_lotus *work, integer *info);

/* Subroutine */ int sorglq_(integer *m, integer *n, integer *k, real_lotus *a, 
	integer *lda, real_lotus *tau, real_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int sorgql_(integer *m, integer *n, integer *k, real_lotus *a, 
	integer *lda, real_lotus *tau, real_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int sorgqr_(integer *m, integer *n, integer *k, real_lotus *a, 
	integer *lda, real_lotus *tau, real_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int sorgr2_(integer *m, integer *n, integer *k, real_lotus *a, 
	integer *lda, real_lotus *tau, real_lotus *work, integer *info);

/* Subroutine */ int sorgrq_(integer *m, integer *n, integer *k, real_lotus *a, 
	integer *lda, real_lotus *tau, real_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int sorgtr_(char *uplo, integer *n, real_lotus *a, integer *lda, 
	real_lotus *tau, real_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int sorm2l_(char *side, char *trans, integer *m, integer *n, 
	integer *k, real_lotus *a, integer *lda, real_lotus *tau, real_lotus *c__, integer *ldc, 
	 real_lotus *work, integer *info);

/* Subroutine */ int sorm2r_(char *side, char *trans, integer *m, integer *n, 
	integer *k, real_lotus *a, integer *lda, real_lotus *tau, real_lotus *c__, integer *ldc, 
	 real_lotus *work, integer *info);

/* Subroutine */ int sormbr_(char *vect, char *side, char *trans, integer *m, 
	integer *n, integer *k, real_lotus *a, integer *lda, real_lotus *tau, real_lotus *c__, 
	integer *ldc, real_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int sormhr_(char *side, char *trans, integer *m, integer *n, 
	integer *ilo, integer *ihi, real_lotus *a, integer *lda, real_lotus *tau, real_lotus *
	c__, integer *ldc, real_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int sorml2_(char *side, char *trans, integer *m, integer *n, 
	integer *k, real_lotus *a, integer *lda, real_lotus *tau, real_lotus *c__, integer *ldc, 
	 real_lotus *work, integer *info);

/* Subroutine */ int sormlq_(char *side, char *trans, integer *m, integer *n, 
	integer *k, real_lotus *a, integer *lda, real_lotus *tau, real_lotus *c__, integer *ldc, 
	 real_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int sormql_(char *side, char *trans, integer *m, integer *n, 
	integer *k, real_lotus *a, integer *lda, real_lotus *tau, real_lotus *c__, integer *ldc, 
	 real_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int sormqr_(char *side, char *trans, integer *m, integer *n, 
	integer *k, real_lotus *a, integer *lda, real_lotus *tau, real_lotus *c__, integer *ldc, 
	 real_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int sormr2_(char *side, char *trans, integer *m, integer *n, 
	integer *k, real_lotus *a, integer *lda, real_lotus *tau, real_lotus *c__, integer *ldc, 
	 real_lotus *work, integer *info);

/* Subroutine */ int sormr3_(char *side, char *trans, integer *m, integer *n, 
	integer *k, integer *l, real_lotus *a, integer *lda, real_lotus *tau, real_lotus *c__, 
	integer *ldc, real_lotus *work, integer *info);

/* Subroutine */ int sormrq_(char *side, char *trans, integer *m, integer *n, 
	integer *k, real_lotus *a, integer *lda, real_lotus *tau, real_lotus *c__, integer *ldc, 
	 real_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int sormrz_(char *side, char *trans, integer *m, integer *n, 
	integer *k, integer *l, real_lotus *a, integer *lda, real_lotus *tau, real_lotus *c__, 
	integer *ldc, real_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int sormtr_(char *side, char *uplo, char *trans, integer *m, 
	integer *n, real_lotus *a, integer *lda, real_lotus *tau, real_lotus *c__, integer *ldc, 
	 real_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int spbcon_(char *uplo, integer *n, integer *kd, real_lotus *ab, 
	integer *ldab, real_lotus *anorm, real_lotus *rcond, real_lotus *work, integer *iwork, 
	integer *info);

/* Subroutine */ int spbequ_(char *uplo, integer *n, integer *kd, real_lotus *ab, 
	integer *ldab, real_lotus *s, real_lotus *scond, real_lotus *amax, integer *info);

/* Subroutine */ int spbrfs_(char *uplo, integer *n, integer *kd, integer *
	nrhs, real_lotus *ab, integer *ldab, real_lotus *afb, integer *ldafb, real_lotus *b, 
	integer *ldb, real_lotus *x, integer *ldx, real_lotus *ferr, real_lotus *berr, real_lotus *
	work, integer *iwork, integer *info);

/* Subroutine */ int spbstf_(char *uplo, integer *n, integer *kd, real_lotus *ab, 
	integer *ldab, integer *info);

/* Subroutine */ int spbsv_(char *uplo, integer *n, integer *kd, integer *
	nrhs, real_lotus *ab, integer *ldab, real_lotus *b, integer *ldb, integer *info);

/* Subroutine */ int spbsvx_(char *fact, char *uplo, integer *n, integer *kd, 
	integer *nrhs, real_lotus *ab, integer *ldab, real_lotus *afb, integer *ldafb, 
	char *equed, real_lotus *s, real_lotus *b, integer *ldb, real_lotus *x, integer *ldx, 
	real_lotus *rcond, real_lotus *ferr, real_lotus *berr, real_lotus *work, integer *iwork, 
	integer *info);

/* Subroutine */ int spbtf2_(char *uplo, integer *n, integer *kd, real_lotus *ab, 
	integer *ldab, integer *info);

/* Subroutine */ int spbtrf_(char *uplo, integer *n, integer *kd, real_lotus *ab, 
	integer *ldab, integer *info);

/* Subroutine */ int spbtrs_(char *uplo, integer *n, integer *kd, integer *
	nrhs, real_lotus *ab, integer *ldab, real_lotus *b, integer *ldb, integer *info);

/* Subroutine */ int spftrf_(char *transr, char *uplo, integer *n, real_lotus *a, 
	integer *info);

/* Subroutine */ int spftri_(char *transr, char *uplo, integer *n, real_lotus *a, 
	integer *info);

/* Subroutine */ int spftrs_(char *transr, char *uplo, integer *n, integer *
	nrhs, real_lotus *a, real_lotus *b, integer *ldb, integer *info);

/* Subroutine */ int spocon_(char *uplo, integer *n, real_lotus *a, integer *lda, 
	real_lotus *anorm, real_lotus *rcond, real_lotus *work, integer *iwork, integer *info);

/* Subroutine */ int spoequ_(integer *n, real_lotus *a, integer *lda, real_lotus *s, real_lotus 
	*scond, real_lotus *amax, integer *info);

/* Subroutine */ int spoequb_(integer *n, real_lotus *a, integer *lda, real_lotus *s, 
	real_lotus *scond, real_lotus *amax, integer *info);

/* Subroutine */ int sporfs_(char *uplo, integer *n, integer *nrhs, real_lotus *a, 
	integer *lda, real_lotus *af, integer *ldaf, real_lotus *b, integer *ldb, real_lotus *x, 
	 integer *ldx, real_lotus *ferr, real_lotus *berr, real_lotus *work, integer *iwork, 
	integer *info);

/* Subroutine */ int sporfsx_(char *uplo, char *equed, integer *n, integer *
	nrhs, real_lotus *a, integer *lda, real_lotus *af, integer *ldaf, real_lotus *s, real_lotus *
	b, integer *ldb, real_lotus *x, integer *ldx, real_lotus *rcond, real_lotus *berr, 
	integer *n_err_bnds__, real_lotus *err_bnds_norm__, real_lotus *err_bnds_comp__, 
	integer *nparams, real_lotus *params, real_lotus *work, integer *iwork, integer *
	info);

/* Subroutine */ int sposv_(char *uplo, integer *n, integer *nrhs, real_lotus *a, 
	integer *lda, real_lotus *b, integer *ldb, integer *info);

/* Subroutine */ int sposvx_(char *fact, char *uplo, integer *n, integer *
	nrhs, real_lotus *a, integer *lda, real_lotus *af, integer *ldaf, char *equed, 
	real_lotus *s, real_lotus *b, integer *ldb, real_lotus *x, integer *ldx, real_lotus *rcond, 
	real_lotus *ferr, real_lotus *berr, real_lotus *work, integer *iwork, integer *info);

/* Subroutine */ int sposvxx_(char *fact, char *uplo, integer *n, integer *
	nrhs, real_lotus *a, integer *lda, real_lotus *af, integer *ldaf, char *equed, 
	real_lotus *s, real_lotus *b, integer *ldb, real_lotus *x, integer *ldx, real_lotus *rcond, 
	real_lotus *rpvgrw, real_lotus *berr, integer *n_err_bnds__, real_lotus *
	err_bnds_norm__, real_lotus *err_bnds_comp__, integer *nparams, real_lotus *
	params, real_lotus *work, integer *iwork, integer *info);

/* Subroutine */ int spotf2_(char *uplo, integer *n, real_lotus *a, integer *lda, 
	integer *info);

/* Subroutine */ int spotrf_(char *uplo, integer *n, real_lotus *a, integer *lda, 
	integer *info);

/* Subroutine */ int spotri_(char *uplo, integer *n, real_lotus *a, integer *lda, 
	integer *info);

/* Subroutine */ int spotrs_(char *uplo, integer *n, integer *nrhs, real_lotus *a, 
	integer *lda, real_lotus *b, integer *ldb, integer *info);

/* Subroutine */ int sppcon_(char *uplo, integer *n, real_lotus *ap, real_lotus *anorm, 
	real_lotus *rcond, real_lotus *work, integer *iwork, integer *info);

/* Subroutine */ int sppequ_(char *uplo, integer *n, real_lotus *ap, real_lotus *s, real_lotus *
	scond, real_lotus *amax, integer *info);

/* Subroutine */ int spprfs_(char *uplo, integer *n, integer *nrhs, real_lotus *ap, 
	real_lotus *afp, real_lotus *b, integer *ldb, real_lotus *x, integer *ldx, real_lotus *ferr, 
	real_lotus *berr, real_lotus *work, integer *iwork, integer *info);

/* Subroutine */ int sppsv_(char *uplo, integer *n, integer *nrhs, real_lotus *ap, 
	real_lotus *b, integer *ldb, integer *info);

/* Subroutine */ int sppsvx_(char *fact, char *uplo, integer *n, integer *
	nrhs, real_lotus *ap, real_lotus *afp, char *equed, real_lotus *s, real_lotus *b, integer *
	ldb, real_lotus *x, integer *ldx, real_lotus *rcond, real_lotus *ferr, real_lotus *berr, real_lotus 
	*work, integer *iwork, integer *info);

/* Subroutine */ int spptrf_(char *uplo, integer *n, real_lotus *ap, integer *info);

/* Subroutine */ int spptri_(char *uplo, integer *n, real_lotus *ap, integer *info);

/* Subroutine */ int spptrs_(char *uplo, integer *n, integer *nrhs, real_lotus *ap, 
	real_lotus *b, integer *ldb, integer *info);

/* Subroutine */ int spstf2_(char *uplo, integer *n, real_lotus *a, integer *lda, 
	integer *piv, integer *rank, real_lotus *tol, real_lotus *work, integer *info);

/* Subroutine */ int spstrf_(char *uplo, integer *n, real_lotus *a, integer *lda, 
	integer *piv, integer *rank, real_lotus *tol, real_lotus *work, integer *info);

/* Subroutine */ int sptcon_(integer *n, real_lotus *d__, real_lotus *e, real_lotus *anorm, 
	real_lotus *rcond, real_lotus *work, integer *info);

/* Subroutine */ int spteqr_(char *compz, integer *n, real_lotus *d__, real_lotus *e, 
	real_lotus *z__, integer *ldz, real_lotus *work, integer *info);

/* Subroutine */ int sptrfs_(integer *n, integer *nrhs, real_lotus *d__, real_lotus *e, 
	real_lotus *df, real_lotus *ef, real_lotus *b, integer *ldb, real_lotus *x, integer *ldx, 
	real_lotus *ferr, real_lotus *berr, real_lotus *work, integer *info);

/* Subroutine */ int sptsv_(integer *n, integer *nrhs, real_lotus *d__, real_lotus *e, 
	real_lotus *b, integer *ldb, integer *info);

/* Subroutine */ int sptsvx_(char *fact, integer *n, integer *nrhs, real_lotus *d__, 
	 real_lotus *e, real_lotus *df, real_lotus *ef, real_lotus *b, integer *ldb, real_lotus *x, integer 
	*ldx, real_lotus *rcond, real_lotus *ferr, real_lotus *berr, real_lotus *work, integer *info);

/* Subroutine */ int spttrf_(integer *n, real_lotus *d__, real_lotus *e, integer *info);

/* Subroutine */ int spttrs_(integer *n, integer *nrhs, real_lotus *d__, real_lotus *e, 
	real_lotus *b, integer *ldb, integer *info);

/* Subroutine */ int sptts2_(integer *n, integer *nrhs, real_lotus *d__, real_lotus *e, 
	real_lotus *b, integer *ldb);

/* Subroutine */ int srscl_(integer *n, real_lotus *sa, real_lotus *sx, integer *incx);

/* Subroutine */ int ssbev_(char *jobz, char *uplo, integer *n, integer *kd, 
	real_lotus *ab, integer *ldab, real_lotus *w, real_lotus *z__, integer *ldz, real_lotus *work, 
	 integer *info);

/* Subroutine */ int ssbevd_(char *jobz, char *uplo, integer *n, integer *kd, 
	real_lotus *ab, integer *ldab, real_lotus *w, real_lotus *z__, integer *ldz, real_lotus *work, 
	 integer *lwork, integer *iwork, integer *liwork, integer *info);

/* Subroutine */ int ssbevx_(char *jobz, char *range, char *uplo, integer *n, 
	integer *kd, real_lotus *ab, integer *ldab, real_lotus *q, integer *ldq, real_lotus *vl, 
	 real_lotus *vu, integer *il, integer *iu, real_lotus *abstol, integer *m, real_lotus *
	w, real_lotus *z__, integer *ldz, real_lotus *work, integer *iwork, integer *
	ifail, integer *info);

/* Subroutine */ int ssbgst_(char *vect, char *uplo, integer *n, integer *ka, 
	integer *kb, real_lotus *ab, integer *ldab, real_lotus *bb, integer *ldbb, real_lotus *
	x, integer *ldx, real_lotus *work, integer *info);

/* Subroutine */ int ssbgv_(char *jobz, char *uplo, integer *n, integer *ka, 
	integer *kb, real_lotus *ab, integer *ldab, real_lotus *bb, integer *ldbb, real_lotus *
	w, real_lotus *z__, integer *ldz, real_lotus *work, integer *info);

/* Subroutine */ int ssbgvd_(char *jobz, char *uplo, integer *n, integer *ka, 
	integer *kb, real_lotus *ab, integer *ldab, real_lotus *bb, integer *ldbb, real_lotus *
	w, real_lotus *z__, integer *ldz, real_lotus *work, integer *lwork, integer *
	iwork, integer *liwork, integer *info);

/* Subroutine */ int ssbgvx_(char *jobz, char *range, char *uplo, integer *n, 
	integer *ka, integer *kb, real_lotus *ab, integer *ldab, real_lotus *bb, integer *
	ldbb, real_lotus *q, integer *ldq, real_lotus *vl, real_lotus *vu, integer *il, integer 
	*iu, real_lotus *abstol, integer *m, real_lotus *w, real_lotus *z__, integer *ldz, real_lotus 
	*work, integer *iwork, integer *ifail, integer *info);

/* Subroutine */ int ssbtrd_(char *vect, char *uplo, integer *n, integer *kd, 
	real_lotus *ab, integer *ldab, real_lotus *d__, real_lotus *e, real_lotus *q, integer *ldq, 
	real_lotus *work, integer *info);

/* Subroutine */ int ssfrk_(char *transr, char *uplo, char *trans, integer *n, 
	 integer *k, real_lotus *alpha, real_lotus *a, integer *lda, real_lotus *beta, real_lotus *
	c__);

/* Subroutine */ int sspcon_(char *uplo, integer *n, real_lotus *ap, integer *ipiv, 
	real_lotus *anorm, real_lotus *rcond, real_lotus *work, integer *iwork, integer *info);

/* Subroutine */ int sspev_(char *jobz, char *uplo, integer *n, real_lotus *ap, 
	real_lotus *w, real_lotus *z__, integer *ldz, real_lotus *work, integer *info);

/* Subroutine */ int sspevd_(char *jobz, char *uplo, integer *n, real_lotus *ap, 
	real_lotus *w, real_lotus *z__, integer *ldz, real_lotus *work, integer *lwork, integer 
	*iwork, integer *liwork, integer *info);

/* Subroutine */ int sspevx_(char *jobz, char *range, char *uplo, integer *n, 
	real_lotus *ap, real_lotus *vl, real_lotus *vu, integer *il, integer *iu, real_lotus *abstol, 
	integer *m, real_lotus *w, real_lotus *z__, integer *ldz, real_lotus *work, integer *
	iwork, integer *ifail, integer *info);

/* Subroutine */ int sspgst_(integer *itype, char *uplo, integer *n, real_lotus *ap, 
	 real_lotus *bp, integer *info);

/* Subroutine */ int sspgv_(integer *itype, char *jobz, char *uplo, integer *
	n, real_lotus *ap, real_lotus *bp, real_lotus *w, real_lotus *z__, integer *ldz, real_lotus *work, 
	integer *info);

/* Subroutine */ int sspgvd_(integer *itype, char *jobz, char *uplo, integer *
	n, real_lotus *ap, real_lotus *bp, real_lotus *w, real_lotus *z__, integer *ldz, real_lotus *work, 
	integer *lwork, integer *iwork, integer *liwork, integer *info);

/* Subroutine */ int sspgvx_(integer *itype, char *jobz, char *range, char *
	uplo, integer *n, real_lotus *ap, real_lotus *bp, real_lotus *vl, real_lotus *vu, integer *il, 
	 integer *iu, real_lotus *abstol, integer *m, real_lotus *w, real_lotus *z__, integer *
	ldz, real_lotus *work, integer *iwork, integer *ifail, integer *info);

/* Subroutine */ int ssprfs_(char *uplo, integer *n, integer *nrhs, real_lotus *ap, 
	real_lotus *afp, integer *ipiv, real_lotus *b, integer *ldb, real_lotus *x, integer *
	ldx, real_lotus *ferr, real_lotus *berr, real_lotus *work, integer *iwork, integer *
	info);

/* Subroutine */ int sspsv_(char *uplo, integer *n, integer *nrhs, real_lotus *ap, 
	integer *ipiv, real_lotus *b, integer *ldb, integer *info);

/* Subroutine */ int sspsvx_(char *fact, char *uplo, integer *n, integer *
	nrhs, real_lotus *ap, real_lotus *afp, integer *ipiv, real_lotus *b, integer *ldb, real_lotus 
	*x, integer *ldx, real_lotus *rcond, real_lotus *ferr, real_lotus *berr, real_lotus *work, 
	integer *iwork, integer *info);

/* Subroutine */ int ssptrd_(char *uplo, integer *n, real_lotus *ap, real_lotus *d__, 
	real_lotus *e, real_lotus *tau, integer *info);

/* Subroutine */ int ssptrf_(char *uplo, integer *n, real_lotus *ap, integer *ipiv, 
	integer *info);

/* Subroutine */ int ssptri_(char *uplo, integer *n, real_lotus *ap, integer *ipiv, 
	real_lotus *work, integer *info);

/* Subroutine */ int ssptrs_(char *uplo, integer *n, integer *nrhs, real_lotus *ap, 
	integer *ipiv, real_lotus *b, integer *ldb, integer *info);

/* Subroutine */ int sstebz_(char *range, char *order, integer *n, real_lotus *vl, 
	real_lotus *vu, integer *il, integer *iu, real_lotus *abstol, real_lotus *d__, real_lotus *e, 
	integer *m, integer *nsplit, real_lotus *w, integer *iblock, integer *
	isplit, real_lotus *work, integer *iwork, integer *info);

/* Subroutine */ int sstedc_(char *compz, integer *n, real_lotus *d__, real_lotus *e, 
	real_lotus *z__, integer *ldz, real_lotus *work, integer *lwork, integer *iwork, 
	integer *liwork, integer *info);

/* Subroutine */ int sstegr_(char *jobz, char *range, integer *n, real_lotus *d__, 
	real_lotus *e, real_lotus *vl, real_lotus *vu, integer *il, integer *iu, real_lotus *abstol, 
	integer *m, real_lotus *w, real_lotus *z__, integer *ldz, integer *isuppz, real_lotus *
	work, integer *lwork, integer *iwork, integer *liwork, integer *info);

/* Subroutine */ int sstein_(integer *n, real_lotus *d__, real_lotus *e, integer *m, real_lotus 
	*w, integer *iblock, integer *isplit, real_lotus *z__, integer *ldz, real_lotus *
	work, integer *iwork, integer *ifail, integer *info);

/* Subroutine */ int sstemr_(char *jobz, char *range, integer *n, real_lotus *d__, 
	real_lotus *e, real_lotus *vl, real_lotus *vu, integer *il, integer *iu, integer *m, 
	real_lotus *w, real_lotus *z__, integer *ldz, integer *nzc, integer *isuppz, 
	logical *tryrac, real_lotus *work, integer *lwork, integer *iwork, integer *
	liwork, integer *info);

/* Subroutine */ int ssteqr_(char *compz, integer *n, real_lotus *d__, real_lotus *e, 
	real_lotus *z__, integer *ldz, real_lotus *work, integer *info);

/* Subroutine */ int ssterf_(integer *n, real_lotus *d__, real_lotus *e, integer *info);

/* Subroutine */ int sstev_(char *jobz, integer *n, real_lotus *d__, real_lotus *e, real_lotus *
	z__, integer *ldz, real_lotus *work, integer *info);

/* Subroutine */ int sstevd_(char *jobz, integer *n, real_lotus *d__, real_lotus *e, real_lotus 
	*z__, integer *ldz, real_lotus *work, integer *lwork, integer *iwork, 
	integer *liwork, integer *info);

/* Subroutine */ int sstevr_(char *jobz, char *range, integer *n, real_lotus *d__, 
	real_lotus *e, real_lotus *vl, real_lotus *vu, integer *il, integer *iu, real_lotus *abstol, 
	integer *m, real_lotus *w, real_lotus *z__, integer *ldz, integer *isuppz, real_lotus *
	work, integer *lwork, integer *iwork, integer *liwork, integer *info);

/* Subroutine */ int sstevx_(char *jobz, char *range, integer *n, real_lotus *d__, 
	real_lotus *e, real_lotus *vl, real_lotus *vu, integer *il, integer *iu, real_lotus *abstol, 
	integer *m, real_lotus *w, real_lotus *z__, integer *ldz, real_lotus *work, integer *
	iwork, integer *ifail, integer *info);

/* Subroutine */ int ssycon_(char *uplo, integer *n, real_lotus *a, integer *lda, 
	integer *ipiv, real_lotus *anorm, real_lotus *rcond, real_lotus *work, integer *iwork, 
	integer *info);

/* Subroutine */ int ssyequb_(char *uplo, integer *n, real_lotus *a, integer *lda, 
	real_lotus *s, real_lotus *scond, real_lotus *amax, real_lotus *work, integer *info);

/* Subroutine */ int ssyev_(char *jobz, char *uplo, integer *n, real_lotus *a, 
	integer *lda, real_lotus *w, real_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int ssyevd_(char *jobz, char *uplo, integer *n, real_lotus *a, 
	integer *lda, real_lotus *w, real_lotus *work, integer *lwork, integer *iwork, 
	integer *liwork, integer *info);

/* Subroutine */ int ssyevr_(char *jobz, char *range, char *uplo, integer *n, 
	real_lotus *a, integer *lda, real_lotus *vl, real_lotus *vu, integer *il, integer *iu, 
	real_lotus *abstol, integer *m, real_lotus *w, real_lotus *z__, integer *ldz, integer *
	isuppz, real_lotus *work, integer *lwork, integer *iwork, integer *liwork, 
	integer *info);

/* Subroutine */ int ssyevx_(char *jobz, char *range, char *uplo, integer *n, 
	real_lotus *a, integer *lda, real_lotus *vl, real_lotus *vu, integer *il, integer *iu, 
	real_lotus *abstol, integer *m, real_lotus *w, real_lotus *z__, integer *ldz, real_lotus *
	work, integer *lwork, integer *iwork, integer *ifail, integer *info);

/* Subroutine */ int ssygs2_(integer *itype, char *uplo, integer *n, real_lotus *a, 
	integer *lda, real_lotus *b, integer *ldb, integer *info);

/* Subroutine */ int ssygst_(integer *itype, char *uplo, integer *n, real_lotus *a, 
	integer *lda, real_lotus *b, integer *ldb, integer *info);

/* Subroutine */ int ssygv_(integer *itype, char *jobz, char *uplo, integer *
	n, real_lotus *a, integer *lda, real_lotus *b, integer *ldb, real_lotus *w, real_lotus *work, 
	integer *lwork, integer *info);

/* Subroutine */ int ssygvd_(integer *itype, char *jobz, char *uplo, integer *
	n, real_lotus *a, integer *lda, real_lotus *b, integer *ldb, real_lotus *w, real_lotus *work, 
	integer *lwork, integer *iwork, integer *liwork, integer *info);

/* Subroutine */ int ssygvx_(integer *itype, char *jobz, char *range, char *
	uplo, integer *n, real_lotus *a, integer *lda, real_lotus *b, integer *ldb, real_lotus *
	vl, real_lotus *vu, integer *il, integer *iu, real_lotus *abstol, integer *m, 
	real_lotus *w, real_lotus *z__, integer *ldz, real_lotus *work, integer *lwork, integer 
	*iwork, integer *ifail, integer *info);

/* Subroutine */ int ssyrfs_(char *uplo, integer *n, integer *nrhs, real_lotus *a, 
	integer *lda, real_lotus *af, integer *ldaf, integer *ipiv, real_lotus *b, 
	integer *ldb, real_lotus *x, integer *ldx, real_lotus *ferr, real_lotus *berr, real_lotus *
	work, integer *iwork, integer *info);

/* Subroutine */ int ssyrfsx_(char *uplo, char *equed, integer *n, integer *
	nrhs, real_lotus *a, integer *lda, real_lotus *af, integer *ldaf, integer *ipiv, 
	real_lotus *s, real_lotus *b, integer *ldb, real_lotus *x, integer *ldx, real_lotus *rcond, 
	real_lotus *berr, integer *n_err_bnds__, real_lotus *err_bnds_norm__, real_lotus *
	err_bnds_comp__, integer *nparams, real_lotus *params, real_lotus *work, integer *
	iwork, integer *info);

/* Subroutine */ int ssysv_(char *uplo, integer *n, integer *nrhs, real_lotus *a, 
	integer *lda, integer *ipiv, real_lotus *b, integer *ldb, real_lotus *work, 
	integer *lwork, integer *info);

/* Subroutine */ int ssysvx_(char *fact, char *uplo, integer *n, integer *
	nrhs, real_lotus *a, integer *lda, real_lotus *af, integer *ldaf, integer *ipiv, 
	real_lotus *b, integer *ldb, real_lotus *x, integer *ldx, real_lotus *rcond, real_lotus *ferr, 
	 real_lotus *berr, real_lotus *work, integer *lwork, integer *iwork, integer *
	info);

/* Subroutine */ int ssysvxx_(char *fact, char *uplo, integer *n, integer *
	nrhs, real_lotus *a, integer *lda, real_lotus *af, integer *ldaf, integer *ipiv, 
	char *equed, real_lotus *s, real_lotus *b, integer *ldb, real_lotus *x, integer *ldx, 
	real_lotus *rcond, real_lotus *rpvgrw, real_lotus *berr, integer *n_err_bnds__, real_lotus *
	err_bnds_norm__, real_lotus *err_bnds_comp__, integer *nparams, real_lotus *
	params, real_lotus *work, integer *iwork, integer *info);

/* Subroutine */ int ssytd2_(char *uplo, integer *n, real_lotus *a, integer *lda, 
	real_lotus *d__, real_lotus *e, real_lotus *tau, integer *info);

/* Subroutine */ int ssytf2_(char *uplo, integer *n, real_lotus *a, integer *lda, 
	integer *ipiv, integer *info);

/* Subroutine */ int ssytrd_(char *uplo, integer *n, real_lotus *a, integer *lda, 
	real_lotus *d__, real_lotus *e, real_lotus *tau, real_lotus *work, integer *lwork, integer *
	info);

/* Subroutine */ int ssytrf_(char *uplo, integer *n, real_lotus *a, integer *lda, 
	integer *ipiv, real_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int ssytri_(char *uplo, integer *n, real_lotus *a, integer *lda, 
	integer *ipiv, real_lotus *work, integer *info);

/* Subroutine */ int ssytrs_(char *uplo, integer *n, integer *nrhs, real_lotus *a, 
	integer *lda, integer *ipiv, real_lotus *b, integer *ldb, integer *info);

/* Subroutine */ int stbcon_(char *norm, char *uplo, char *diag, integer *n, 
	integer *kd, real_lotus *ab, integer *ldab, real_lotus *rcond, real_lotus *work, 
	integer *iwork, integer *info);

/* Subroutine */ int stbrfs_(char *uplo, char *trans, char *diag, integer *n, 
	integer *kd, integer *nrhs, real_lotus *ab, integer *ldab, real_lotus *b, integer 
	*ldb, real_lotus *x, integer *ldx, real_lotus *ferr, real_lotus *berr, real_lotus *work, 
	integer *iwork, integer *info);

/* Subroutine */ int stbtrs_(char *uplo, char *trans, char *diag, integer *n, 
	integer *kd, integer *nrhs, real_lotus *ab, integer *ldab, real_lotus *b, integer 
	*ldb, integer *info);

/* Subroutine */ int stfsm_(char *transr, char *side, char *uplo, char *trans, 
	 char *diag, integer *m, integer *n, real_lotus *alpha, real_lotus *a, real_lotus *b, 
	integer *ldb);

/* Subroutine */ int stftri_(char *transr, char *uplo, char *diag, integer *n, 
	 real_lotus *a, integer *info);

/* Subroutine */ int stfttp_(char *transr, char *uplo, integer *n, real_lotus *arf, 
	real_lotus *ap, integer *info);

/* Subroutine */ int stfttr_(char *transr, char *uplo, integer *n, real_lotus *arf, 
	real_lotus *a, integer *lda, integer *info);

/* Subroutine */ int stgevc_(char *side, char *howmny, logical *select, 
	integer *n, real_lotus *s, integer *lds, real_lotus *p, integer *ldp, real_lotus *vl, 
	integer *ldvl, real_lotus *vr, integer *ldvr, integer *mm, integer *m, real_lotus 
	*work, integer *info);

/* Subroutine */ int stgex2_(logical *wantq, logical *wantz, integer *n, real_lotus 
	*a, integer *lda, real_lotus *b, integer *ldb, real_lotus *q, integer *ldq, real_lotus *
	z__, integer *ldz, integer *j1, integer *n1, integer *n2, real_lotus *work, 
	integer *lwork, integer *info);

/* Subroutine */ int stgexc_(logical *wantq, logical *wantz, integer *n, real_lotus 
	*a, integer *lda, real_lotus *b, integer *ldb, real_lotus *q, integer *ldq, real_lotus *
	z__, integer *ldz, integer *ifst, integer *ilst, real_lotus *work, integer *
	lwork, integer *info);

/* Subroutine */ int stgsen_(integer *ijob, logical *wantq, logical *wantz, 
	logical *select, integer *n, real_lotus *a, integer *lda, real_lotus *b, integer *
	ldb, real_lotus *alphar, real_lotus *alphai, real_lotus *beta, real_lotus *q, integer *ldq, 
	real_lotus *z__, integer *ldz, integer *m, real_lotus *pl, real_lotus *pr, real_lotus *dif, 
	real_lotus *work, integer *lwork, integer *iwork, integer *liwork, integer *
	info);

/* Subroutine */ int stgsja_(char *jobu, char *jobv, char *jobq, integer *m, 
	integer *p, integer *n, integer *k, integer *l, real_lotus *a, integer *lda, 
	 real_lotus *b, integer *ldb, real_lotus *tola, real_lotus *tolb, real_lotus *alpha, real_lotus *
	beta, real_lotus *u, integer *ldu, real_lotus *v, integer *ldv, real_lotus *q, integer *
	ldq, real_lotus *work, integer *ncycle, integer *info);

/* Subroutine */ int stgsna_(char *job, char *howmny, logical *select, 
	integer *n, real_lotus *a, integer *lda, real_lotus *b, integer *ldb, real_lotus *vl, 
	integer *ldvl, real_lotus *vr, integer *ldvr, real_lotus *s, real_lotus *dif, integer *
	mm, integer *m, real_lotus *work, integer *lwork, integer *iwork, integer *
	info);

/* Subroutine */ int stgsy2_(char *trans, integer *ijob, integer *m, integer *
	n, real_lotus *a, integer *lda, real_lotus *b, integer *ldb, real_lotus *c__, integer *
	ldc, real_lotus *d__, integer *ldd, real_lotus *e, integer *lde, real_lotus *f, integer 
	*ldf, real_lotus *scale, real_lotus *rdsum, real_lotus *rdscal, integer *iwork, integer 
	*pq, integer *info);

/* Subroutine */ int stgsyl_(char *trans, integer *ijob, integer *m, integer *
	n, real_lotus *a, integer *lda, real_lotus *b, integer *ldb, real_lotus *c__, integer *
	ldc, real_lotus *d__, integer *ldd, real_lotus *e, integer *lde, real_lotus *f, integer 
	*ldf, real_lotus *scale, real_lotus *dif, real_lotus *work, integer *lwork, integer *
	iwork, integer *info);

/* Subroutine */ int stpcon_(char *norm, char *uplo, char *diag, integer *n, 
	real_lotus *ap, real_lotus *rcond, real_lotus *work, integer *iwork, integer *info);

/* Subroutine */ int stprfs_(char *uplo, char *trans, char *diag, integer *n, 
	integer *nrhs, real_lotus *ap, real_lotus *b, integer *ldb, real_lotus *x, integer *ldx, 
	 real_lotus *ferr, real_lotus *berr, real_lotus *work, integer *iwork, integer *info);

/* Subroutine */ int stptri_(char *uplo, char *diag, integer *n, real_lotus *ap, 
	integer *info);

/* Subroutine */ int stptrs_(char *uplo, char *trans, char *diag, integer *n, 
	integer *nrhs, real_lotus *ap, real_lotus *b, integer *ldb, integer *info);

/* Subroutine */ int stpttf_(char *transr, char *uplo, integer *n, real_lotus *ap, 
	real_lotus *arf, integer *info);

/* Subroutine */ int stpttr_(char *uplo, integer *n, real_lotus *ap, real_lotus *a, 
	integer *lda, integer *info);

/* Subroutine */ int strcon_(char *norm, char *uplo, char *diag, integer *n, 
	real_lotus *a, integer *lda, real_lotus *rcond, real_lotus *work, integer *iwork, 
	integer *info);

/* Subroutine */ int strevc_(char *side, char *howmny, logical *select, 
	integer *n, real_lotus *t, integer *ldt, real_lotus *vl, integer *ldvl, real_lotus *vr, 
	integer *ldvr, integer *mm, integer *m, real_lotus *work, integer *info);

/* Subroutine */ int strexc_(char *compq, integer *n, real_lotus *t, integer *ldt, 
	real_lotus *q, integer *ldq, integer *ifst, integer *ilst, real_lotus *work, 
	integer *info);

/* Subroutine */ int strrfs_(char *uplo, char *trans, char *diag, integer *n, 
	integer *nrhs, real_lotus *a, integer *lda, real_lotus *b, integer *ldb, real_lotus *x, 
	integer *ldx, real_lotus *ferr, real_lotus *berr, real_lotus *work, integer *iwork, 
	integer *info);

/* Subroutine */ int strsen_(char *job, char *compq, logical *select, integer 
	*n, real_lotus *t, integer *ldt, real_lotus *q, integer *ldq, real_lotus *wr, real_lotus *wi, 
	integer *m, real_lotus *s, real_lotus *sep, real_lotus *work, integer *lwork, integer *
	iwork, integer *liwork, integer *info);

/* Subroutine */ int strsna_(char *job, char *howmny, logical *select, 
	integer *n, real_lotus *t, integer *ldt, real_lotus *vl, integer *ldvl, real_lotus *vr, 
	integer *ldvr, real_lotus *s, real_lotus *sep, integer *mm, integer *m, real_lotus *
	work, integer *ldwork, integer *iwork, integer *info);

/* Subroutine */ int strsyl_(char *trana, char *tranb, integer *isgn, integer 
	*m, integer *n, real_lotus *a, integer *lda, real_lotus *b, integer *ldb, real_lotus *
	c__, integer *ldc, real_lotus *scale, integer *info);

/* Subroutine */ int strti2_(char *uplo, char *diag, integer *n, real_lotus *a, 
	integer *lda, integer *info);

/* Subroutine */ int strtri_(char *uplo, char *diag, integer *n, real_lotus *a, 
	integer *lda, integer *info);

/* Subroutine */ int strtrs_(char *uplo, char *trans, char *diag, integer *n, 
	integer *nrhs, real_lotus *a, integer *lda, real_lotus *b, integer *ldb, integer *
	info);

/* Subroutine */ int strttf_(char *transr, char *uplo, integer *n, real_lotus *a, 
	integer *lda, real_lotus *arf, integer *info);

/* Subroutine */ int strttp_(char *uplo, integer *n, real_lotus *a, integer *lda, 
	real_lotus *ap, integer *info);

/* Subroutine */ int stzrqf_(integer *m, integer *n, real_lotus *a, integer *lda, 
	real_lotus *tau, integer *info);

/* Subroutine */ int stzrzf_(integer *m, integer *n, real_lotus *a, integer *lda, 
	real_lotus *tau, real_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int xerbla_(char *srname, integer *info);

/* Subroutine */ int xerbla_array__(char *srname_array__, integer *
	srname_len__, integer *info, ftnlen srname_array_len);

/* Subroutine */ int zbdsqr_(char *uplo, integer *n, integer *ncvt, integer *
	nru, integer *ncc, doublereal_lotus *d__, doublereal_lotus *e, doublecomplex_lotus *vt, 
	integer *ldvt, doublecomplex_lotus *u, integer *ldu, doublecomplex_lotus *c__, 
	integer *ldc, doublereal_lotus *rwork, integer *info);

/* Subroutine */ int zcgesv_(integer *n, integer *nrhs, doublecomplex_lotus *a, 
	integer *lda, integer *ipiv, doublecomplex_lotus *b, integer *ldb, 
	doublecomplex_lotus *x, integer *ldx, doublecomplex_lotus *work, complex_lotus *swork, 
	doublereal_lotus *rwork, integer *iter, integer *info);

/* Subroutine */ int zcposv_(char *uplo, integer *n, integer *nrhs, 
	doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *b, integer *ldb, 
	doublecomplex_lotus *x, integer *ldx, doublecomplex_lotus *work, complex_lotus *swork, 
	doublereal_lotus *rwork, integer *iter, integer *info);

/* Subroutine */ int zdrscl_(integer *n, doublereal_lotus *sa, doublecomplex_lotus *sx, 
	integer *incx);

/* Subroutine */ int zgbbrd_(char *vect, integer *m, integer *n, integer *ncc, 
	 integer *kl, integer *ku, doublecomplex_lotus *ab, integer *ldab, 
	doublereal_lotus *d__, doublereal_lotus *e, doublecomplex_lotus *q, integer *ldq, 
	doublecomplex_lotus *pt, integer *ldpt, doublecomplex_lotus *c__, integer *ldc, 
	doublecomplex_lotus *work, doublereal_lotus *rwork, integer *info);

/* Subroutine */ int zgbcon_(char *norm, integer *n, integer *kl, integer *ku, 
	 doublecomplex_lotus *ab, integer *ldab, integer *ipiv, doublereal_lotus *anorm, 
	doublereal_lotus *rcond, doublecomplex_lotus *work, doublereal_lotus *rwork, integer *
	info);

/* Subroutine */ int zgbequ_(integer *m, integer *n, integer *kl, integer *ku, 
	 doublecomplex_lotus *ab, integer *ldab, doublereal_lotus *r__, doublereal_lotus *c__, 
	doublereal_lotus *rowcnd, doublereal_lotus *colcnd, doublereal_lotus *amax, integer *
	info);

/* Subroutine */ int zgbequb_(integer *m, integer *n, integer *kl, integer *
	ku, doublecomplex_lotus *ab, integer *ldab, doublereal_lotus *r__, doublereal_lotus *
	c__, doublereal_lotus *rowcnd, doublereal_lotus *colcnd, doublereal_lotus *amax, 
	integer *info);

/* Subroutine */ int zgbrfs_(char *trans, integer *n, integer *kl, integer *
	ku, integer *nrhs, doublecomplex_lotus *ab, integer *ldab, doublecomplex_lotus *
	afb, integer *ldafb, integer *ipiv, doublecomplex_lotus *b, integer *ldb, 
	doublecomplex_lotus *x, integer *ldx, doublereal_lotus *ferr, doublereal_lotus *berr, 
	doublecomplex_lotus *work, doublereal_lotus *rwork, integer *info);

/* Subroutine */ int zgbrfsx_(char *trans, char *equed, integer *n, integer *
	kl, integer *ku, integer *nrhs, doublecomplex_lotus *ab, integer *ldab, 
	doublecomplex_lotus *afb, integer *ldafb, integer *ipiv, doublereal_lotus *r__, 
	doublereal_lotus *c__, doublecomplex_lotus *b, integer *ldb, doublecomplex_lotus *x, 
	integer *ldx, doublereal_lotus *rcond, doublereal_lotus *berr, integer *
	n_err_bnds__, doublereal_lotus *err_bnds_norm__, doublereal_lotus *
	err_bnds_comp__, integer *nparams, doublereal_lotus *params, doublecomplex_lotus *
	work, doublereal_lotus *rwork, integer *info);

/* Subroutine */ int zgbsv_(integer *n, integer *kl, integer *ku, integer *
	nrhs, doublecomplex_lotus *ab, integer *ldab, integer *ipiv, doublecomplex_lotus *
	b, integer *ldb, integer *info);

/* Subroutine */ int zgbsvx_(char *fact, char *trans, integer *n, integer *kl, 
	 integer *ku, integer *nrhs, doublecomplex_lotus *ab, integer *ldab, 
	doublecomplex_lotus *afb, integer *ldafb, integer *ipiv, char *equed, 
	doublereal_lotus *r__, doublereal_lotus *c__, doublecomplex_lotus *b, integer *ldb, 
	doublecomplex_lotus *x, integer *ldx, doublereal_lotus *rcond, doublereal_lotus *ferr, 
	doublereal_lotus *berr, doublecomplex_lotus *work, doublereal_lotus *rwork, integer *
	info);

/* Subroutine */ int zgbsvxx_(char *fact, char *trans, integer *n, integer *
	kl, integer *ku, integer *nrhs, doublecomplex_lotus *ab, integer *ldab, 
	doublecomplex_lotus *afb, integer *ldafb, integer *ipiv, char *equed, 
	doublereal_lotus *r__, doublereal_lotus *c__, doublecomplex_lotus *b, integer *ldb, 
	doublecomplex_lotus *x, integer *ldx, doublereal_lotus *rcond, doublereal_lotus *rpvgrw, 
	 doublereal_lotus *berr, integer *n_err_bnds__, doublereal_lotus *err_bnds_norm__, 
	 doublereal_lotus *err_bnds_comp__, integer *nparams, doublereal_lotus *params, 
	doublecomplex_lotus *work, doublereal_lotus *rwork, integer *info);

/* Subroutine */ int zgbtf2_(integer *m, integer *n, integer *kl, integer *ku, 
	 doublecomplex_lotus *ab, integer *ldab, integer *ipiv, integer *info);

/* Subroutine */ int zgbtrf_(integer *m, integer *n, integer *kl, integer *ku, 
	 doublecomplex_lotus *ab, integer *ldab, integer *ipiv, integer *info);

/* Subroutine */ int zgbtrs_(char *trans, integer *n, integer *kl, integer *
	ku, integer *nrhs, doublecomplex_lotus *ab, integer *ldab, integer *ipiv, 
	doublecomplex_lotus *b, integer *ldb, integer *info);

/* Subroutine */ int zgebak_(char *job, char *side, integer *n, integer *ilo, 
	integer *ihi, doublereal_lotus *scale, integer *m, doublecomplex_lotus *v, 
	integer *ldv, integer *info);

/* Subroutine */ int zgebal_(char *job, integer *n, doublecomplex_lotus *a, integer 
	*lda, integer *ilo, integer *ihi, doublereal_lotus *scale, integer *info);

/* Subroutine */ int zgebd2_(integer *m, integer *n, doublecomplex_lotus *a, 
	integer *lda, doublereal_lotus *d__, doublereal_lotus *e, doublecomplex_lotus *tauq, 
	doublecomplex_lotus *taup, doublecomplex_lotus *work, integer *info);

/* Subroutine */ int zgebrd_(integer *m, integer *n, doublecomplex_lotus *a, 
	integer *lda, doublereal_lotus *d__, doublereal_lotus *e, doublecomplex_lotus *tauq, 
	doublecomplex_lotus *taup, doublecomplex_lotus *work, integer *lwork, integer *
	info);

/* Subroutine */ int zgecon_(char *norm, integer *n, doublecomplex_lotus *a, 
	integer *lda, doublereal_lotus *anorm, doublereal_lotus *rcond, doublecomplex_lotus *
	work, doublereal_lotus *rwork, integer *info);

/* Subroutine */ int zgeequ_(integer *m, integer *n, doublecomplex_lotus *a, 
	integer *lda, doublereal_lotus *r__, doublereal_lotus *c__, doublereal_lotus *rowcnd, 
	doublereal_lotus *colcnd, doublereal_lotus *amax, integer *info);

/* Subroutine */ int zgeequb_(integer *m, integer *n, doublecomplex_lotus *a, 
	integer *lda, doublereal_lotus *r__, doublereal_lotus *c__, doublereal_lotus *rowcnd, 
	doublereal_lotus *colcnd, doublereal_lotus *amax, integer *info);

/* Subroutine */ int zgees_(char *jobvs, char *sort, L_fp select, integer *n, 
	doublecomplex_lotus *a, integer *lda, integer *sdim, doublecomplex_lotus *w, 
	doublecomplex_lotus *vs, integer *ldvs, doublecomplex_lotus *work, integer *lwork, 
	 doublereal_lotus *rwork, logical *bwork, integer *info);

/* Subroutine */ int zgeesx_(char *jobvs, char *sort, L_fp select, char *
	sense, integer *n, doublecomplex_lotus *a, integer *lda, integer *sdim, 
	doublecomplex_lotus *w, doublecomplex_lotus *vs, integer *ldvs, doublereal_lotus *
	rconde, doublereal_lotus *rcondv, doublecomplex_lotus *work, integer *lwork, 
	doublereal_lotus *rwork, logical *bwork, integer *info);

/* Subroutine */ int zgeev_(char *jobvl, char *jobvr, integer *n, 
	doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *w, doublecomplex_lotus *vl, 
	integer *ldvl, doublecomplex_lotus *vr, integer *ldvr, doublecomplex_lotus *work, 
	integer *lwork, doublereal_lotus *rwork, integer *info);

/* Subroutine */ int zgeevx_(char *balanc, char *jobvl, char *jobvr, char *
	sense, integer *n, doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *w, 
	doublecomplex_lotus *vl, integer *ldvl, doublecomplex_lotus *vr, integer *ldvr, 
	integer *ilo, integer *ihi, doublereal_lotus *scale, doublereal_lotus *abnrm, 
	doublereal_lotus *rconde, doublereal_lotus *rcondv, doublecomplex_lotus *work, integer *
	lwork, doublereal_lotus *rwork, integer *info);

/* Subroutine */ int zgegs_(char *jobvsl, char *jobvsr, integer *n, 
	doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *b, integer *ldb, 
	doublecomplex_lotus *alpha, doublecomplex_lotus *beta, doublecomplex_lotus *vsl, 
	integer *ldvsl, doublecomplex_lotus *vsr, integer *ldvsr, doublecomplex_lotus *
	work, integer *lwork, doublereal_lotus *rwork, integer *info);

/* Subroutine */ int zgegv_(char *jobvl, char *jobvr, integer *n, 
	doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *b, integer *ldb, 
	doublecomplex_lotus *alpha, doublecomplex_lotus *beta, doublecomplex_lotus *vl, integer 
	*ldvl, doublecomplex_lotus *vr, integer *ldvr, doublecomplex_lotus *work, integer 
	*lwork, doublereal_lotus *rwork, integer *info);

/* Subroutine */ int zgehd2_(integer *n, integer *ilo, integer *ihi, 
	doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *tau, doublecomplex_lotus *
	work, integer *info);

/* Subroutine */ int zgehrd_(integer *n, integer *ilo, integer *ihi, 
	doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *tau, doublecomplex_lotus *
	work, integer *lwork, integer *info);

/* Subroutine */ int zgelq2_(integer *m, integer *n, doublecomplex_lotus *a, 
	integer *lda, doublecomplex_lotus *tau, doublecomplex_lotus *work, integer *info);

/* Subroutine */ int zgelqf_(integer *m, integer *n, doublecomplex_lotus *a, 
	integer *lda, doublecomplex_lotus *tau, doublecomplex_lotus *work, integer *lwork, 
	 integer *info);

/* Subroutine */ int zgels_(char *trans, integer *m, integer *n, integer *
	nrhs, doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *b, integer *ldb, 
	doublecomplex_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int zgelsd_(integer *m, integer *n, integer *nrhs, 
	doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *b, integer *ldb, 
	doublereal_lotus *s, doublereal_lotus *rcond, integer *rank, doublecomplex_lotus *work, 
	integer *lwork, doublereal_lotus *rwork, integer *iwork, integer *info);

/* Subroutine */ int zgelss_(integer *m, integer *n, integer *nrhs, 
	doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *b, integer *ldb, 
	doublereal_lotus *s, doublereal_lotus *rcond, integer *rank, doublecomplex_lotus *work, 
	integer *lwork, doublereal_lotus *rwork, integer *info);

/* Subroutine */ int zgelsx_(integer *m, integer *n, integer *nrhs, 
	doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *b, integer *ldb, 
	integer *jpvt, doublereal_lotus *rcond, integer *rank, doublecomplex_lotus *work, 
	doublereal_lotus *rwork, integer *info);

/* Subroutine */ int zgelsy_(integer *m, integer *n, integer *nrhs, 
	doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *b, integer *ldb, 
	integer *jpvt, doublereal_lotus *rcond, integer *rank, doublecomplex_lotus *work, 
	integer *lwork, doublereal_lotus *rwork, integer *info);

/* Subroutine */ int zgeql2_(integer *m, integer *n, doublecomplex_lotus *a, 
	integer *lda, doublecomplex_lotus *tau, doublecomplex_lotus *work, integer *info);

/* Subroutine */ int zgeqlf_(integer *m, integer *n, doublecomplex_lotus *a, 
	integer *lda, doublecomplex_lotus *tau, doublecomplex_lotus *work, integer *lwork, 
	 integer *info);

/* Subroutine */ int zgeqp3_(integer *m, integer *n, doublecomplex_lotus *a, 
	integer *lda, integer *jpvt, doublecomplex_lotus *tau, doublecomplex_lotus *work, 
	integer *lwork, doublereal_lotus *rwork, integer *info);

/* Subroutine */ int zgeqpf_(integer *m, integer *n, doublecomplex_lotus *a, 
	integer *lda, integer *jpvt, doublecomplex_lotus *tau, doublecomplex_lotus *work, 
	doublereal_lotus *rwork, integer *info);

/* Subroutine */ int zgeqr2_(integer *m, integer *n, doublecomplex_lotus *a, 
	integer *lda, doublecomplex_lotus *tau, doublecomplex_lotus *work, integer *info);

/* Subroutine */ int zgeqrf_(integer *m, integer *n, doublecomplex_lotus *a, 
	integer *lda, doublecomplex_lotus *tau, doublecomplex_lotus *work, integer *lwork, 
	 integer *info);

/* Subroutine */ int zgerfs_(char *trans, integer *n, integer *nrhs, 
	doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *af, integer *ldaf, 
	integer *ipiv, doublecomplex_lotus *b, integer *ldb, doublecomplex_lotus *x, 
	integer *ldx, doublereal_lotus *ferr, doublereal_lotus *berr, doublecomplex_lotus *work, 
	 doublereal_lotus *rwork, integer *info);

/* Subroutine */ int zgerfsx_(char *trans, char *equed, integer *n, integer *
	nrhs, doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *af, integer *
	ldaf, integer *ipiv, doublereal_lotus *r__, doublereal_lotus *c__, doublecomplex_lotus *
	b, integer *ldb, doublecomplex_lotus *x, integer *ldx, doublereal_lotus *rcond, 
	doublereal_lotus *berr, integer *n_err_bnds__, doublereal_lotus *err_bnds_norm__, 
	doublereal_lotus *err_bnds_comp__, integer *nparams, doublereal_lotus *params, 
	doublecomplex_lotus *work, doublereal_lotus *rwork, integer *info);

/* Subroutine */ int zgerq2_(integer *m, integer *n, doublecomplex_lotus *a, 
	integer *lda, doublecomplex_lotus *tau, doublecomplex_lotus *work, integer *info);

/* Subroutine */ int zgerqf_(integer *m, integer *n, doublecomplex_lotus *a, 
	integer *lda, doublecomplex_lotus *tau, doublecomplex_lotus *work, integer *lwork, 
	 integer *info);

/* Subroutine */ int zgesc2_(integer *n, doublecomplex_lotus *a, integer *lda, 
	doublecomplex_lotus *rhs, integer *ipiv, integer *jpiv, doublereal_lotus *scale);

/* Subroutine */ int zgesdd_(char *jobz, integer *m, integer *n, 
	doublecomplex_lotus *a, integer *lda, doublereal_lotus *s, doublecomplex_lotus *u, 
	integer *ldu, doublecomplex_lotus *vt, integer *ldvt, doublecomplex_lotus *work, 
	integer *lwork, doublereal_lotus *rwork, integer *iwork, integer *info);

/* Subroutine */ int zgesv_(integer *n, integer *nrhs, doublecomplex_lotus *a, 
	integer *lda, integer *ipiv, doublecomplex_lotus *b, integer *ldb, integer *
	info);

/* Subroutine */ int zgesvd_(char *jobu, char *jobvt, integer *m, integer *n, 
	doublecomplex_lotus *a, integer *lda, doublereal_lotus *s, doublecomplex_lotus *u, 
	integer *ldu, doublecomplex_lotus *vt, integer *ldvt, doublecomplex_lotus *work, 
	integer *lwork, doublereal_lotus *rwork, integer *info);

/* Subroutine */ int zgesvx_(char *fact, char *trans, integer *n, integer *
	nrhs, doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *af, integer *
	ldaf, integer *ipiv, char *equed, doublereal_lotus *r__, doublereal_lotus *c__, 
	doublecomplex_lotus *b, integer *ldb, doublecomplex_lotus *x, integer *ldx, 
	doublereal_lotus *rcond, doublereal_lotus *ferr, doublereal_lotus *berr, doublecomplex_lotus *
	work, doublereal_lotus *rwork, integer *info);

/* Subroutine */ int zgesvxx_(char *fact, char *trans, integer *n, integer *
	nrhs, doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *af, integer *
	ldaf, integer *ipiv, char *equed, doublereal_lotus *r__, doublereal_lotus *c__, 
	doublecomplex_lotus *b, integer *ldb, doublecomplex_lotus *x, integer *ldx, 
	doublereal_lotus *rcond, doublereal_lotus *rpvgrw, doublereal_lotus *berr, integer *
	n_err_bnds__, doublereal_lotus *err_bnds_norm__, doublereal_lotus *
	err_bnds_comp__, integer *nparams, doublereal_lotus *params, doublecomplex_lotus *
	work, doublereal_lotus *rwork, integer *info);

/* Subroutine */ int zgetc2_(integer *n, doublecomplex_lotus *a, integer *lda, 
	integer *ipiv, integer *jpiv, integer *info);

/* Subroutine */ int zgetf2_(integer *m, integer *n, doublecomplex_lotus *a, 
	integer *lda, integer *ipiv, integer *info);

/* Subroutine */ int zgetrf_(integer *m, integer *n, doublecomplex_lotus *a, 
	integer *lda, integer *ipiv, integer *info);

/* Subroutine */ int zgetri_(integer *n, doublecomplex_lotus *a, integer *lda, 
	integer *ipiv, doublecomplex_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int zgetrs_(char *trans, integer *n, integer *nrhs, 
	doublecomplex_lotus *a, integer *lda, integer *ipiv, doublecomplex_lotus *b, 
	integer *ldb, integer *info);

/* Subroutine */ int zggbak_(char *job, char *side, integer *n, integer *ilo, 
	integer *ihi, doublereal_lotus *lscale, doublereal_lotus *rscale, integer *m, 
	doublecomplex_lotus *v, integer *ldv, integer *info);

/* Subroutine */ int zggbal_(char *job, integer *n, doublecomplex_lotus *a, integer 
	*lda, doublecomplex_lotus *b, integer *ldb, integer *ilo, integer *ihi, 
	doublereal_lotus *lscale, doublereal_lotus *rscale, doublereal_lotus *work, integer *
	info);

/* Subroutine */ int zgges_(char *jobvsl, char *jobvsr, char *sort, L_fp 
	selctg, integer *n, doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *b, 
	integer *ldb, integer *sdim, doublecomplex_lotus *alpha, doublecomplex_lotus *
	beta, doublecomplex_lotus *vsl, integer *ldvsl, doublecomplex_lotus *vsr, integer 
	*ldvsr, doublecomplex_lotus *work, integer *lwork, doublereal_lotus *rwork, 
	logical *bwork, integer *info);

/* Subroutine */ int zggesx_(char *jobvsl, char *jobvsr, char *sort, L_fp 
	selctg, char *sense, integer *n, doublecomplex_lotus *a, integer *lda, 
	doublecomplex_lotus *b, integer *ldb, integer *sdim, doublecomplex_lotus *alpha, 
	doublecomplex_lotus *beta, doublecomplex_lotus *vsl, integer *ldvsl, 
	doublecomplex_lotus *vsr, integer *ldvsr, doublereal_lotus *rconde, doublereal_lotus *
	rcondv, doublecomplex_lotus *work, integer *lwork, doublereal_lotus *rwork, 
	integer *iwork, integer *liwork, logical *bwork, integer *info);

/* Subroutine */ int zggev_(char *jobvl, char *jobvr, integer *n, 
	doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *b, integer *ldb, 
	doublecomplex_lotus *alpha, doublecomplex_lotus *beta, doublecomplex_lotus *vl, integer 
	*ldvl, doublecomplex_lotus *vr, integer *ldvr, doublecomplex_lotus *work, integer 
	*lwork, doublereal_lotus *rwork, integer *info);

/* Subroutine */ int zggevx_(char *balanc, char *jobvl, char *jobvr, char *
	sense, integer *n, doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *b, 
	integer *ldb, doublecomplex_lotus *alpha, doublecomplex_lotus *beta, 
	doublecomplex_lotus *vl, integer *ldvl, doublecomplex_lotus *vr, integer *ldvr, 
	integer *ilo, integer *ihi, doublereal_lotus *lscale, doublereal_lotus *rscale, 
	doublereal_lotus *abnrm, doublereal_lotus *bbnrm, doublereal_lotus *rconde, doublereal_lotus *
	rcondv, doublecomplex_lotus *work, integer *lwork, doublereal_lotus *rwork, 
	integer *iwork, logical *bwork, integer *info);

/* Subroutine */ int zggglm_(integer *n, integer *m, integer *p, 
	doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *b, integer *ldb, 
	doublecomplex_lotus *d__, doublecomplex_lotus *x, doublecomplex_lotus *y, doublecomplex_lotus 
	*work, integer *lwork, integer *info);

/* Subroutine */ int zgghrd_(char *compq, char *compz, integer *n, integer *
	ilo, integer *ihi, doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *b, 
	integer *ldb, doublecomplex_lotus *q, integer *ldq, doublecomplex_lotus *z__, 
	integer *ldz, integer *info);

/* Subroutine */ int zgglse_(integer *m, integer *n, integer *p, 
	doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *b, integer *ldb, 
	doublecomplex_lotus *c__, doublecomplex_lotus *d__, doublecomplex_lotus *x, 
	doublecomplex_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int zggqrf_(integer *n, integer *m, integer *p, 
	doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *taua, doublecomplex_lotus *b, 
	 integer *ldb, doublecomplex_lotus *taub, doublecomplex_lotus *work, integer *
	lwork, integer *info);

/* Subroutine */ int zggrqf_(integer *m, integer *p, integer *n, 
	doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *taua, doublecomplex_lotus *b, 
	 integer *ldb, doublecomplex_lotus *taub, doublecomplex_lotus *work, integer *
	lwork, integer *info);

/* Subroutine */ int zggsvd_(char *jobu, char *jobv, char *jobq, integer *m, 
	integer *n, integer *p, integer *k, integer *l, doublecomplex_lotus *a, 
	integer *lda, doublecomplex_lotus *b, integer *ldb, doublereal_lotus *alpha, 
	doublereal_lotus *beta, doublecomplex_lotus *u, integer *ldu, doublecomplex_lotus *v, 
	integer *ldv, doublecomplex_lotus *q, integer *ldq, doublecomplex_lotus *work, 
	doublereal_lotus *rwork, integer *iwork, integer *info);

/* Subroutine */ int zggsvp_(char *jobu, char *jobv, char *jobq, integer *m, 
	integer *p, integer *n, doublecomplex_lotus *a, integer *lda, doublecomplex_lotus 
	*b, integer *ldb, doublereal_lotus *tola, doublereal_lotus *tolb, integer *k, 
	integer *l, doublecomplex_lotus *u, integer *ldu, doublecomplex_lotus *v, integer 
	*ldv, doublecomplex_lotus *q, integer *ldq, integer *iwork, doublereal_lotus *
	rwork, doublecomplex_lotus *tau, doublecomplex_lotus *work, integer *info);

/* Subroutine */ int zgtcon_(char *norm, integer *n, doublecomplex_lotus *dl, 
	doublecomplex_lotus *d__, doublecomplex_lotus *du, doublecomplex_lotus *du2, integer *
	ipiv, doublereal_lotus *anorm, doublereal_lotus *rcond, doublecomplex_lotus *work, 
	integer *info);

/* Subroutine */ int zgtrfs_(char *trans, integer *n, integer *nrhs, 
	doublecomplex_lotus *dl, doublecomplex_lotus *d__, doublecomplex_lotus *du, 
	doublecomplex_lotus *dlf, doublecomplex_lotus *df, doublecomplex_lotus *duf, 
	doublecomplex_lotus *du2, integer *ipiv, doublecomplex_lotus *b, integer *ldb, 
	doublecomplex_lotus *x, integer *ldx, doublereal_lotus *ferr, doublereal_lotus *berr, 
	doublecomplex_lotus *work, doublereal_lotus *rwork, integer *info);

/* Subroutine */ int zgtsv_(integer *n, integer *nrhs, doublecomplex_lotus *dl, 
	doublecomplex_lotus *d__, doublecomplex_lotus *du, doublecomplex_lotus *b, integer *ldb, 
	 integer *info);

/* Subroutine */ int zgtsvx_(char *fact, char *trans, integer *n, integer *
	nrhs, doublecomplex_lotus *dl, doublecomplex_lotus *d__, doublecomplex_lotus *du, 
	doublecomplex_lotus *dlf, doublecomplex_lotus *df, doublecomplex_lotus *duf, 
	doublecomplex_lotus *du2, integer *ipiv, doublecomplex_lotus *b, integer *ldb, 
	doublecomplex_lotus *x, integer *ldx, doublereal_lotus *rcond, doublereal_lotus *ferr, 
	doublereal_lotus *berr, doublecomplex_lotus *work, doublereal_lotus *rwork, integer *
	info);

/* Subroutine */ int zgttrf_(integer *n, doublecomplex_lotus *dl, doublecomplex_lotus *
	d__, doublecomplex_lotus *du, doublecomplex_lotus *du2, integer *ipiv, integer *
	info);

/* Subroutine */ int zgttrs_(char *trans, integer *n, integer *nrhs, 
	doublecomplex_lotus *dl, doublecomplex_lotus *d__, doublecomplex_lotus *du, 
	doublecomplex_lotus *du2, integer *ipiv, doublecomplex_lotus *b, integer *ldb, 
	integer *info);

/* Subroutine */ int zgtts2_(integer *itrans, integer *n, integer *nrhs, 
	doublecomplex_lotus *dl, doublecomplex_lotus *d__, doublecomplex_lotus *du, 
	doublecomplex_lotus *du2, integer *ipiv, doublecomplex_lotus *b, integer *ldb);

/* Subroutine */ int zhbev_(char *jobz, char *uplo, integer *n, integer *kd, 
	doublecomplex_lotus *ab, integer *ldab, doublereal_lotus *w, doublecomplex_lotus *z__, 
	integer *ldz, doublecomplex_lotus *work, doublereal_lotus *rwork, integer *info);

/* Subroutine */ int zhbevd_(char *jobz, char *uplo, integer *n, integer *kd, 
	doublecomplex_lotus *ab, integer *ldab, doublereal_lotus *w, doublecomplex_lotus *z__, 
	integer *ldz, doublecomplex_lotus *work, integer *lwork, doublereal_lotus *rwork, 
	integer *lrwork, integer *iwork, integer *liwork, integer *info);

/* Subroutine */ int zhbevx_(char *jobz, char *range, char *uplo, integer *n, 
	integer *kd, doublecomplex_lotus *ab, integer *ldab, doublecomplex_lotus *q, 
	integer *ldq, doublereal_lotus *vl, doublereal_lotus *vu, integer *il, integer *
	iu, doublereal_lotus *abstol, integer *m, doublereal_lotus *w, doublecomplex_lotus *z__, 
	 integer *ldz, doublecomplex_lotus *work, doublereal_lotus *rwork, integer *iwork, 
	 integer *ifail, integer *info);

/* Subroutine */ int zhbgst_(char *vect, char *uplo, integer *n, integer *ka, 
	integer *kb, doublecomplex_lotus *ab, integer *ldab, doublecomplex_lotus *bb, 
	integer *ldbb, doublecomplex_lotus *x, integer *ldx, doublecomplex_lotus *work, 
	doublereal_lotus *rwork, integer *info);

/* Subroutine */ int zhbgv_(char *jobz, char *uplo, integer *n, integer *ka, 
	integer *kb, doublecomplex_lotus *ab, integer *ldab, doublecomplex_lotus *bb, 
	integer *ldbb, doublereal_lotus *w, doublecomplex_lotus *z__, integer *ldz, 
	doublecomplex_lotus *work, doublereal_lotus *rwork, integer *info);

/* Subroutine */ int zhbgvd_(char *jobz, char *uplo, integer *n, integer *ka, 
	integer *kb, doublecomplex_lotus *ab, integer *ldab, doublecomplex_lotus *bb, 
	integer *ldbb, doublereal_lotus *w, doublecomplex_lotus *z__, integer *ldz, 
	doublecomplex_lotus *work, integer *lwork, doublereal_lotus *rwork, integer *
	lrwork, integer *iwork, integer *liwork, integer *info);

/* Subroutine */ int zhbgvx_(char *jobz, char *range, char *uplo, integer *n, 
	integer *ka, integer *kb, doublecomplex_lotus *ab, integer *ldab, 
	doublecomplex_lotus *bb, integer *ldbb, doublecomplex_lotus *q, integer *ldq, 
	doublereal_lotus *vl, doublereal_lotus *vu, integer *il, integer *iu, doublereal_lotus *
	abstol, integer *m, doublereal_lotus *w, doublecomplex_lotus *z__, integer *ldz, 
	doublecomplex_lotus *work, doublereal_lotus *rwork, integer *iwork, integer *
	ifail, integer *info);

/* Subroutine */ int zhbtrd_(char *vect, char *uplo, integer *n, integer *kd, 
	doublecomplex_lotus *ab, integer *ldab, doublereal_lotus *d__, doublereal_lotus *e, 
	doublecomplex_lotus *q, integer *ldq, doublecomplex_lotus *work, integer *info);

/* Subroutine */ int zhecon_(char *uplo, integer *n, doublecomplex_lotus *a, 
	integer *lda, integer *ipiv, doublereal_lotus *anorm, doublereal_lotus *rcond, 
	doublecomplex_lotus *work, integer *info);

/* Subroutine */ int zheequb_(char *uplo, integer *n, doublecomplex_lotus *a, 
	integer *lda, doublereal_lotus *s, doublereal_lotus *scond, doublereal_lotus *amax, 
	doublecomplex_lotus *work, integer *info);

/* Subroutine */ int zheev_(char *jobz, char *uplo, integer *n, doublecomplex_lotus 
	*a, integer *lda, doublereal_lotus *w, doublecomplex_lotus *work, integer *lwork, 
	doublereal_lotus *rwork, integer *info);

/* Subroutine */ int zheevd_(char *jobz, char *uplo, integer *n, 
	doublecomplex_lotus *a, integer *lda, doublereal_lotus *w, doublecomplex_lotus *work, 
	integer *lwork, doublereal_lotus *rwork, integer *lrwork, integer *iwork, 
	integer *liwork, integer *info);

/* Subroutine */ int zheevr_(char *jobz, char *range, char *uplo, integer *n, 
	doublecomplex_lotus *a, integer *lda, doublereal_lotus *vl, doublereal_lotus *vu, 
	integer *il, integer *iu, doublereal_lotus *abstol, integer *m, doublereal_lotus *
	w, doublecomplex_lotus *z__, integer *ldz, integer *isuppz, doublecomplex_lotus *
	work, integer *lwork, doublereal_lotus *rwork, integer *lrwork, integer *
	iwork, integer *liwork, integer *info);

/* Subroutine */ int zheevx_(char *jobz, char *range, char *uplo, integer *n, 
	doublecomplex_lotus *a, integer *lda, doublereal_lotus *vl, doublereal_lotus *vu, 
	integer *il, integer *iu, doublereal_lotus *abstol, integer *m, doublereal_lotus *
	w, doublecomplex_lotus *z__, integer *ldz, doublecomplex_lotus *work, integer *
	lwork, doublereal_lotus *rwork, integer *iwork, integer *ifail, integer *
	info);

/* Subroutine */ int zhegs2_(integer *itype, char *uplo, integer *n, 
	doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *b, integer *ldb, 
	integer *info);

/* Subroutine */ int zhegst_(integer *itype, char *uplo, integer *n, 
	doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *b, integer *ldb, 
	integer *info);

/* Subroutine */ int zhegv_(integer *itype, char *jobz, char *uplo, integer *
	n, doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *b, integer *ldb, 
	doublereal_lotus *w, doublecomplex_lotus *work, integer *lwork, doublereal_lotus *rwork, 
	 integer *info);

/* Subroutine */ int zhegvd_(integer *itype, char *jobz, char *uplo, integer *
	n, doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *b, integer *ldb, 
	doublereal_lotus *w, doublecomplex_lotus *work, integer *lwork, doublereal_lotus *rwork, 
	 integer *lrwork, integer *iwork, integer *liwork, integer *info);

/* Subroutine */ int zhegvx_(integer *itype, char *jobz, char *range, char *
	uplo, integer *n, doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *b, 
	integer *ldb, doublereal_lotus *vl, doublereal_lotus *vu, integer *il, integer *
	iu, doublereal_lotus *abstol, integer *m, doublereal_lotus *w, doublecomplex_lotus *z__, 
	 integer *ldz, doublecomplex_lotus *work, integer *lwork, doublereal_lotus *rwork, 
	 integer *iwork, integer *ifail, integer *info);

/* Subroutine */ int zherfs_(char *uplo, integer *n, integer *nrhs, 
	doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *af, integer *ldaf, 
	integer *ipiv, doublecomplex_lotus *b, integer *ldb, doublecomplex_lotus *x, 
	integer *ldx, doublereal_lotus *ferr, doublereal_lotus *berr, doublecomplex_lotus *work, 
	 doublereal_lotus *rwork, integer *info);

/* Subroutine */ int zherfsx_(char *uplo, char *equed, integer *n, integer *
	nrhs, doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *af, integer *
	ldaf, integer *ipiv, doublereal_lotus *s, doublecomplex_lotus *b, integer *ldb, 
	doublecomplex_lotus *x, integer *ldx, doublereal_lotus *rcond, doublereal_lotus *berr, 
	integer *n_err_bnds__, doublereal_lotus *err_bnds_norm__, doublereal_lotus *
	err_bnds_comp__, integer *nparams, doublereal_lotus *params, doublecomplex_lotus *
	work, doublereal_lotus *rwork, integer *info);

/* Subroutine */ int zhesv_(char *uplo, integer *n, integer *nrhs, 
	doublecomplex_lotus *a, integer *lda, integer *ipiv, doublecomplex_lotus *b, 
	integer *ldb, doublecomplex_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int zhesvx_(char *fact, char *uplo, integer *n, integer *
	nrhs, doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *af, integer *
	ldaf, integer *ipiv, doublecomplex_lotus *b, integer *ldb, doublecomplex_lotus *x, 
	 integer *ldx, doublereal_lotus *rcond, doublereal_lotus *ferr, doublereal_lotus *berr, 
	doublecomplex_lotus *work, integer *lwork, doublereal_lotus *rwork, integer *info);

/* Subroutine */ int zhesvxx_(char *fact, char *uplo, integer *n, integer *
	nrhs, doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *af, integer *
	ldaf, integer *ipiv, char *equed, doublereal_lotus *s, doublecomplex_lotus *b, 
	integer *ldb, doublecomplex_lotus *x, integer *ldx, doublereal_lotus *rcond, 
	doublereal_lotus *rpvgrw, doublereal_lotus *berr, integer *n_err_bnds__, 
	doublereal_lotus *err_bnds_norm__, doublereal_lotus *err_bnds_comp__, integer *
	nparams, doublereal_lotus *params, doublecomplex_lotus *work, doublereal_lotus *rwork, 
	integer *info);

/* Subroutine */ int zhetd2_(char *uplo, integer *n, doublecomplex_lotus *a, 
	integer *lda, doublereal_lotus *d__, doublereal_lotus *e, doublecomplex_lotus *tau, 
	integer *info);

/* Subroutine */ int zhetf2_(char *uplo, integer *n, doublecomplex_lotus *a, 
	integer *lda, integer *ipiv, integer *info);

/* Subroutine */ int zhetrd_(char *uplo, integer *n, doublecomplex_lotus *a, 
	integer *lda, doublereal_lotus *d__, doublereal_lotus *e, doublecomplex_lotus *tau, 
	doublecomplex_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int zhetrf_(char *uplo, integer *n, doublecomplex_lotus *a, 
	integer *lda, integer *ipiv, doublecomplex_lotus *work, integer *lwork, 
	integer *info);

/* Subroutine */ int zhetri_(char *uplo, integer *n, doublecomplex_lotus *a, 
	integer *lda, integer *ipiv, doublecomplex_lotus *work, integer *info);

/* Subroutine */ int zhetrs_(char *uplo, integer *n, integer *nrhs, 
	doublecomplex_lotus *a, integer *lda, integer *ipiv, doublecomplex_lotus *b, 
	integer *ldb, integer *info);

/* Subroutine */ int zhfrk_(char *transr, char *uplo, char *trans, integer *n, 
	 integer *k, doublereal_lotus *alpha, doublecomplex_lotus *a, integer *lda, 
	doublereal_lotus *beta, doublecomplex_lotus *c__);

/* Subroutine */ int zhgeqz_(char *job, char *compq, char *compz, integer *n, 
	integer *ilo, integer *ihi, doublecomplex_lotus *h__, integer *ldh, 
	doublecomplex_lotus *t, integer *ldt, doublecomplex_lotus *alpha, doublecomplex_lotus *
	beta, doublecomplex_lotus *q, integer *ldq, doublecomplex_lotus *z__, integer *
	ldz, doublecomplex_lotus *work, integer *lwork, doublereal_lotus *rwork, integer *
	info);

/* Subroutine */ int zhpcon_(char *uplo, integer *n, doublecomplex_lotus *ap, 
	integer *ipiv, doublereal_lotus *anorm, doublereal_lotus *rcond, doublecomplex_lotus *
	work, integer *info);

/* Subroutine */ int zhpev_(char *jobz, char *uplo, integer *n, doublecomplex_lotus 
	*ap, doublereal_lotus *w, doublecomplex_lotus *z__, integer *ldz, doublecomplex_lotus *
	work, doublereal_lotus *rwork, integer *info);

/* Subroutine */ int zhpevd_(char *jobz, char *uplo, integer *n, 
	doublecomplex_lotus *ap, doublereal_lotus *w, doublecomplex_lotus *z__, integer *ldz, 
	doublecomplex_lotus *work, integer *lwork, doublereal_lotus *rwork, integer *
	lrwork, integer *iwork, integer *liwork, integer *info);

/* Subroutine */ int zhpevx_(char *jobz, char *range, char *uplo, integer *n, 
	doublecomplex_lotus *ap, doublereal_lotus *vl, doublereal_lotus *vu, integer *il, 
	integer *iu, doublereal_lotus *abstol, integer *m, doublereal_lotus *w, 
	doublecomplex_lotus *z__, integer *ldz, doublecomplex_lotus *work, doublereal_lotus *
	rwork, integer *iwork, integer *ifail, integer *info);

/* Subroutine */ int zhpgst_(integer *itype, char *uplo, integer *n, 
	doublecomplex_lotus *ap, doublecomplex_lotus *bp, integer *info);

/* Subroutine */ int zhpgv_(integer *itype, char *jobz, char *uplo, integer *
	n, doublecomplex_lotus *ap, doublecomplex_lotus *bp, doublereal_lotus *w, doublecomplex_lotus 
	*z__, integer *ldz, doublecomplex_lotus *work, doublereal_lotus *rwork, integer *
	info);

/* Subroutine */ int zhpgvd_(integer *itype, char *jobz, char *uplo, integer *
	n, doublecomplex_lotus *ap, doublecomplex_lotus *bp, doublereal_lotus *w, doublecomplex_lotus 
	*z__, integer *ldz, doublecomplex_lotus *work, integer *lwork, doublereal_lotus *
	rwork, integer *lrwork, integer *iwork, integer *liwork, integer *
	info);

/* Subroutine */ int zhpgvx_(integer *itype, char *jobz, char *range, char *
	uplo, integer *n, doublecomplex_lotus *ap, doublecomplex_lotus *bp, doublereal_lotus *
	vl, doublereal_lotus *vu, integer *il, integer *iu, doublereal_lotus *abstol, 
	integer *m, doublereal_lotus *w, doublecomplex_lotus *z__, integer *ldz, 
	doublecomplex_lotus *work, doublereal_lotus *rwork, integer *iwork, integer *
	ifail, integer *info);

/* Subroutine */ int zhprfs_(char *uplo, integer *n, integer *nrhs, 
	doublecomplex_lotus *ap, doublecomplex_lotus *afp, integer *ipiv, doublecomplex_lotus *
	b, integer *ldb, doublecomplex_lotus *x, integer *ldx, doublereal_lotus *ferr, 
	doublereal_lotus *berr, doublecomplex_lotus *work, doublereal_lotus *rwork, integer *
	info);

/* Subroutine */ int zhpsv_(char *uplo, integer *n, integer *nrhs, 
	doublecomplex_lotus *ap, integer *ipiv, doublecomplex_lotus *b, integer *ldb, 
	integer *info);

/* Subroutine */ int zhpsvx_(char *fact, char *uplo, integer *n, integer *
	nrhs, doublecomplex_lotus *ap, doublecomplex_lotus *afp, integer *ipiv, 
	doublecomplex_lotus *b, integer *ldb, doublecomplex_lotus *x, integer *ldx, 
	doublereal_lotus *rcond, doublereal_lotus *ferr, doublereal_lotus *berr, doublecomplex_lotus *
	work, doublereal_lotus *rwork, integer *info);

/* Subroutine */ int zhptrd_(char *uplo, integer *n, doublecomplex_lotus *ap, 
	doublereal_lotus *d__, doublereal_lotus *e, doublecomplex_lotus *tau, integer *info);

/* Subroutine */ int zhptrf_(char *uplo, integer *n, doublecomplex_lotus *ap, 
	integer *ipiv, integer *info);

/* Subroutine */ int zhptri_(char *uplo, integer *n, doublecomplex_lotus *ap, 
	integer *ipiv, doublecomplex_lotus *work, integer *info);

/* Subroutine */ int zhptrs_(char *uplo, integer *n, integer *nrhs, 
	doublecomplex_lotus *ap, integer *ipiv, doublecomplex_lotus *b, integer *ldb, 
	integer *info);

/* Subroutine */ int zhsein_(char *side, char *eigsrc, char *initv, logical *
	select, integer *n, doublecomplex_lotus *h__, integer *ldh, doublecomplex_lotus *
	w, doublecomplex_lotus *vl, integer *ldvl, doublecomplex_lotus *vr, integer *ldvr, 
	 integer *mm, integer *m, doublecomplex_lotus *work, doublereal_lotus *rwork, 
	integer *ifaill, integer *ifailr, integer *info);

/* Subroutine */ int zhseqr_(char *job, char *compz, integer *n, integer *ilo, 
	 integer *ihi, doublecomplex_lotus *h__, integer *ldh, doublecomplex_lotus *w, 
	doublecomplex_lotus *z__, integer *ldz, doublecomplex_lotus *work, integer *lwork, 
	 integer *info);

/* Subroutine */ int zla_gbamv__(integer *trans, integer *m, integer *n, 
	integer *kl, integer *ku, doublereal_lotus *alpha, doublecomplex_lotus *ab, 
	integer *ldab, doublecomplex_lotus *x, integer *incx, doublereal_lotus *beta, 
	doublereal_lotus *y, integer *incy);

doublereal_lotus zla_gbrcond_c__(char *trans, integer *n, integer *kl, integer *ku, 
	doublecomplex_lotus *ab, integer *ldab, doublecomplex_lotus *afb, integer *ldafb, 
	integer *ipiv, doublereal_lotus *c__, logical *capply, integer *info, 
	doublecomplex_lotus *work, doublereal_lotus *rwork, ftnlen trans_len);

doublereal_lotus zla_gbrcond_x__(char *trans, integer *n, integer *kl, integer *ku, 
	doublecomplex_lotus *ab, integer *ldab, doublecomplex_lotus *afb, integer *ldafb, 
	integer *ipiv, doublecomplex_lotus *x, integer *info, doublecomplex_lotus *work, 
	doublereal_lotus *rwork, ftnlen trans_len);

/* Subroutine */ int zla_gbrfsx_extended__(integer *prec_type__, integer *
	trans_type__, integer *n, integer *kl, integer *ku, integer *nrhs, 
	doublecomplex_lotus *ab, integer *ldab, doublecomplex_lotus *afb, integer *ldafb, 
	integer *ipiv, logical *colequ, doublereal_lotus *c__, doublecomplex_lotus *b, 
	integer *ldb, doublecomplex_lotus *y, integer *ldy, doublereal_lotus *berr_out__, 
	integer *n_norms__, doublereal_lotus *errs_n__, doublereal_lotus *errs_c__, 
	doublecomplex_lotus *res, doublereal_lotus *ayb, doublecomplex_lotus *dy, doublecomplex_lotus 
	*y_tail__, doublereal_lotus *rcond, integer *ithresh, doublereal_lotus *rthresh, 
	doublereal_lotus *dz_ub__, logical *ignore_cwise__, integer *info);

doublereal_lotus zla_gbrpvgrw__(integer *n, integer *kl, integer *ku, integer *
	ncols, doublecomplex_lotus *ab, integer *ldab, doublecomplex_lotus *afb, integer *
	ldafb);

/* Subroutine */ int zla_geamv__(integer *trans, integer *m, integer *n, 
	doublereal_lotus *alpha, doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *x, 
	integer *incx, doublereal_lotus *beta, doublereal_lotus *y, integer *incy);

doublereal_lotus zla_gercond_c__(char *trans, integer *n, doublecomplex_lotus *a, integer 
	*lda, doublecomplex_lotus *af, integer *ldaf, integer *ipiv, doublereal_lotus *
	c__, logical *capply, integer *info, doublecomplex_lotus *work, doublereal_lotus *
	rwork, ftnlen trans_len);

doublereal_lotus zla_gercond_x__(char *trans, integer *n, doublecomplex_lotus *a, integer 
	*lda, doublecomplex_lotus *af, integer *ldaf, integer *ipiv, doublecomplex_lotus *
	x, integer *info, doublecomplex_lotus *work, doublereal_lotus *rwork, ftnlen 
	trans_len);

/* Subroutine */ int zla_gerfsx_extended__(integer *prec_type__, integer *
	trans_type__, integer *n, integer *nrhs, doublecomplex_lotus *a, integer *
	lda, doublecomplex_lotus *af, integer *ldaf, integer *ipiv, logical *colequ,
	 doublereal_lotus *c__, doublecomplex_lotus *b, integer *ldb, doublecomplex_lotus *y, 
	integer *ldy, doublereal_lotus *berr_out__, integer *n_norms__, doublereal_lotus *
	errs_n__, doublereal_lotus *errs_c__, doublecomplex_lotus *res, doublereal_lotus *ayb, 
	doublecomplex_lotus *dy, doublecomplex_lotus *y_tail__, doublereal_lotus *rcond, 
	integer *ithresh, doublereal_lotus *rthresh, doublereal_lotus *dz_ub__, logical *
	ignore_cwise__, integer *info);

/* Subroutine */ int zla_heamv__(integer *uplo, integer *n, doublereal_lotus *alpha,
	 doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *x, integer *incx, 
	doublereal_lotus *beta, doublereal_lotus *y, integer *incy);

doublereal_lotus zla_hercond_c__(char *uplo, integer *n, doublecomplex_lotus *a, integer *
	lda, doublecomplex_lotus *af, integer *ldaf, integer *ipiv, doublereal_lotus *c__,
	 logical *capply, integer *info, doublecomplex_lotus *work, doublereal_lotus *
	rwork, ftnlen uplo_len);

doublereal_lotus zla_hercond_x__(char *uplo, integer *n, doublecomplex_lotus *a, integer *
	lda, doublecomplex_lotus *af, integer *ldaf, integer *ipiv, doublecomplex_lotus *
	x, integer *info, doublecomplex_lotus *work, doublereal_lotus *rwork, ftnlen 
	uplo_len);

/* Subroutine */ int zla_herfsx_extended__(integer *prec_type__, char *uplo, 
	integer *n, integer *nrhs, doublecomplex_lotus *a, integer *lda, 
	doublecomplex_lotus *af, integer *ldaf, integer *ipiv, logical *colequ, 
	doublereal_lotus *c__, doublecomplex_lotus *b, integer *ldb, doublecomplex_lotus *y, 
	integer *ldy, doublereal_lotus *berr_out__, integer *n_norms__, doublereal_lotus *
	errs_n__, doublereal_lotus *errs_c__, doublecomplex_lotus *res, doublereal_lotus *ayb, 
	doublecomplex_lotus *dy, doublecomplex_lotus *y_tail__, doublereal_lotus *rcond, 
	integer *ithresh, doublereal_lotus *rthresh, doublereal_lotus *dz_ub__, logical *
	ignore_cwise__, integer *info, ftnlen uplo_len);

doublereal_lotus zla_herpvgrw__(char *uplo, integer *n, integer *info, 
	doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *af, integer *ldaf, 
	integer *ipiv, doublereal_lotus *work, ftnlen uplo_len);

/* Subroutine */ int zla_lin_berr__(integer *n, integer *nz, integer *nrhs, 
	doublecomplex_lotus *res, doublereal_lotus *ayb, doublereal_lotus *berr);

doublereal_lotus zla_porcond_c__(char *uplo, integer *n, doublecomplex_lotus *a, integer *
	lda, doublecomplex_lotus *af, integer *ldaf, doublereal_lotus *c__, logical *
	capply, integer *info, doublecomplex_lotus *work, doublereal_lotus *rwork, ftnlen 
	uplo_len);

doublereal_lotus zla_porcond_x__(char *uplo, integer *n, doublecomplex_lotus *a, integer *
	lda, doublecomplex_lotus *af, integer *ldaf, doublecomplex_lotus *x, integer *
	info, doublecomplex_lotus *work, doublereal_lotus *rwork, ftnlen uplo_len);

/* Subroutine */ int zla_porfsx_extended__(integer *prec_type__, char *uplo, 
	integer *n, integer *nrhs, doublecomplex_lotus *a, integer *lda, 
	doublecomplex_lotus *af, integer *ldaf, logical *colequ, doublereal_lotus *c__, 
	doublecomplex_lotus *b, integer *ldb, doublecomplex_lotus *y, integer *ldy, 
	doublereal_lotus *berr_out__, integer *n_norms__, doublereal_lotus *errs_n__, 
	doublereal_lotus *errs_c__, doublecomplex_lotus *res, doublereal_lotus *ayb, 
	doublecomplex_lotus *dy, doublecomplex_lotus *y_tail__, doublereal_lotus *rcond, 
	integer *ithresh, doublereal_lotus *rthresh, doublereal_lotus *dz_ub__, logical *
	ignore_cwise__, integer *info, ftnlen uplo_len);

doublereal_lotus zla_porpvgrw__(char *uplo, integer *ncols, doublecomplex_lotus *a, 
	integer *lda, doublecomplex_lotus *af, integer *ldaf, doublereal_lotus *work, 
	ftnlen uplo_len);

doublereal_lotus zla_rpvgrw__(integer *n, integer *ncols, doublecomplex_lotus *a, integer 
	*lda, doublecomplex_lotus *af, integer *ldaf);

/* Subroutine */ int zla_syamv__(integer *uplo, integer *n, doublereal_lotus *alpha,
	 doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *x, integer *incx, 
	doublereal_lotus *beta, doublereal_lotus *y, integer *incy);

doublereal_lotus zla_syrcond_c__(char *uplo, integer *n, doublecomplex_lotus *a, integer *
	lda, doublecomplex_lotus *af, integer *ldaf, integer *ipiv, doublereal_lotus *c__,
	 logical *capply, integer *info, doublecomplex_lotus *work, doublereal_lotus *
	rwork, ftnlen uplo_len);

doublereal_lotus zla_syrcond_x__(char *uplo, integer *n, doublecomplex_lotus *a, integer *
	lda, doublecomplex_lotus *af, integer *ldaf, integer *ipiv, doublecomplex_lotus *
	x, integer *info, doublecomplex_lotus *work, doublereal_lotus *rwork, ftnlen 
	uplo_len);

/* Subroutine */ int zla_syrfsx_extended__(integer *prec_type__, char *uplo, 
	integer *n, integer *nrhs, doublecomplex_lotus *a, integer *lda, 
	doublecomplex_lotus *af, integer *ldaf, integer *ipiv, logical *colequ, 
	doublereal_lotus *c__, doublecomplex_lotus *b, integer *ldb, doublecomplex_lotus *y, 
	integer *ldy, doublereal_lotus *berr_out__, integer *n_norms__, doublereal_lotus *
	errs_n__, doublereal_lotus *errs_c__, doublecomplex_lotus *res, doublereal_lotus *ayb, 
	doublecomplex_lotus *dy, doublecomplex_lotus *y_tail__, doublereal_lotus *rcond, 
	integer *ithresh, doublereal_lotus *rthresh, doublereal_lotus *dz_ub__, logical *
	ignore_cwise__, integer *info, ftnlen uplo_len);

doublereal_lotus zla_syrpvgrw__(char *uplo, integer *n, integer *info, 
	doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *af, integer *ldaf, 
	integer *ipiv, doublereal_lotus *work, ftnlen uplo_len);

/* Subroutine */ int zla_wwaddw__(integer *n, doublecomplex_lotus *x, doublecomplex_lotus 
	*y, doublecomplex_lotus *w);

/* Subroutine */ int zlabrd_(integer *m, integer *n, integer *nb, 
	doublecomplex_lotus *a, integer *lda, doublereal_lotus *d__, doublereal_lotus *e, 
	doublecomplex_lotus *tauq, doublecomplex_lotus *taup, doublecomplex_lotus *x, integer *
	ldx, doublecomplex_lotus *y, integer *ldy);

/* Subroutine */ int zlacgv_(integer *n, doublecomplex_lotus *x, integer *incx);

/* Subroutine */ int zlacn2_(integer *n, doublecomplex_lotus *v, doublecomplex_lotus *x, 
	doublereal_lotus *est, integer *kase, integer *isave);

/* Subroutine */ int zlacon_(integer *n, doublecomplex_lotus *v, doublecomplex_lotus *x, 
	doublereal_lotus *est, integer *kase);

/* Subroutine */ int zlacp2_(char *uplo, integer *m, integer *n, doublereal_lotus *
	a, integer *lda, doublecomplex_lotus *b, integer *ldb);

/* Subroutine */ int zlacpy_(char *uplo, integer *m, integer *n, 
	doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *b, integer *ldb);

/* Subroutine */ int zlacrm_(integer *m, integer *n, doublecomplex_lotus *a, 
	integer *lda, doublereal_lotus *b, integer *ldb, doublecomplex_lotus *c__, 
	integer *ldc, doublereal_lotus *rwork);

/* Subroutine */ int zlacrt_(integer *n, doublecomplex_lotus *cx, integer *incx, 
	doublecomplex_lotus *cy, integer *incy, doublecomplex_lotus *c__, doublecomplex_lotus *
	s);

/* Double Complex */ void zladiv_(doublecomplex_lotus * ret_val, doublecomplex_lotus *x, 
	doublecomplex_lotus *y);

/* Subroutine */ int zlaed0_(integer *qsiz, integer *n, doublereal_lotus *d__, 
	doublereal_lotus *e, doublecomplex_lotus *q, integer *ldq, doublecomplex_lotus *qstore, 
	integer *ldqs, doublereal_lotus *rwork, integer *iwork, integer *info);

/* Subroutine */ int zlaed7_(integer *n, integer *cutpnt, integer *qsiz, 
	integer *tlvls, integer *curlvl, integer *curpbm, doublereal_lotus *d__, 
	doublecomplex_lotus *q, integer *ldq, doublereal_lotus *rho, integer *indxq, 
	doublereal_lotus *qstore, integer *qptr, integer *prmptr, integer *perm, 
	integer *givptr, integer *givcol, doublereal_lotus *givnum, doublecomplex_lotus *
	work, doublereal_lotus *rwork, integer *iwork, integer *info);

/* Subroutine */ int zlaed8_(integer *k, integer *n, integer *qsiz, 
	doublecomplex_lotus *q, integer *ldq, doublereal_lotus *d__, doublereal_lotus *rho, 
	integer *cutpnt, doublereal_lotus *z__, doublereal_lotus *dlamda, doublecomplex_lotus *
	q2, integer *ldq2, doublereal_lotus *w, integer *indxp, integer *indx, 
	integer *indxq, integer *perm, integer *givptr, integer *givcol, 
	doublereal_lotus *givnum, integer *info);

/* Subroutine */ int zlaein_(logical *rightv, logical *noinit, integer *n, 
	doublecomplex_lotus *h__, integer *ldh, doublecomplex_lotus *w, doublecomplex_lotus *v, 
	doublecomplex_lotus *b, integer *ldb, doublereal_lotus *rwork, doublereal_lotus *eps3, 
	doublereal_lotus *smlnum, integer *info);

/* Subroutine */ int zlaesy_(doublecomplex_lotus *a, doublecomplex_lotus *b, 
	doublecomplex_lotus *c__, doublecomplex_lotus *rt1, doublecomplex_lotus *rt2, 
	doublecomplex_lotus *evscal, doublecomplex_lotus *cs1, doublecomplex_lotus *sn1);

/* Subroutine */ int zlaev2_(doublecomplex_lotus *a, doublecomplex_lotus *b, 
	doublecomplex_lotus *c__, doublereal_lotus *rt1, doublereal_lotus *rt2, doublereal_lotus *cs1, 
	 doublecomplex_lotus *sn1);

/* Subroutine */ int zlag2c_(integer *m, integer *n, doublecomplex_lotus *a, 
	integer *lda, complex_lotus *sa, integer *ldsa, integer *info);

/* Subroutine */ int zlags2_(logical *upper, doublereal_lotus *a1, doublecomplex_lotus *
	a2, doublereal_lotus *a3, doublereal_lotus *b1, doublecomplex_lotus *b2, doublereal_lotus *b3, 
	 doublereal_lotus *csu, doublecomplex_lotus *snu, doublereal_lotus *csv, doublecomplex_lotus *
	snv, doublereal_lotus *csq, doublecomplex_lotus *snq);

/* Subroutine */ int zlagtm_(char *trans, integer *n, integer *nrhs, 
	doublereal_lotus *alpha, doublecomplex_lotus *dl, doublecomplex_lotus *d__, 
	doublecomplex_lotus *du, doublecomplex_lotus *x, integer *ldx, doublereal_lotus *beta, 
	doublecomplex_lotus *b, integer *ldb);

/* Subroutine */ int zlahef_(char *uplo, integer *n, integer *nb, integer *kb, 
	 doublecomplex_lotus *a, integer *lda, integer *ipiv, doublecomplex_lotus *w, 
	integer *ldw, integer *info);

/* Subroutine */ int zlahqr_(logical *wantt, logical *wantz, integer *n, 
	integer *ilo, integer *ihi, doublecomplex_lotus *h__, integer *ldh, 
	doublecomplex_lotus *w, integer *iloz, integer *ihiz, doublecomplex_lotus *z__, 
	integer *ldz, integer *info);

/* Subroutine */ int zlahr2_(integer *n, integer *k, integer *nb, 
	doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *tau, doublecomplex_lotus *t, 
	integer *ldt, doublecomplex_lotus *y, integer *ldy);

/* Subroutine */ int zlahrd_(integer *n, integer *k, integer *nb, 
	doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *tau, doublecomplex_lotus *t, 
	integer *ldt, doublecomplex_lotus *y, integer *ldy);

/* Subroutine */ int zlaic1_(integer *job, integer *j, doublecomplex_lotus *x, 
	doublereal_lotus *sest, doublecomplex_lotus *w, doublecomplex_lotus *gamma, doublereal_lotus *
	sestpr, doublecomplex_lotus *s, doublecomplex_lotus *c__);

/* Subroutine */ int zlals0_(integer *icompq, integer *nl, integer *nr, 
	integer *sqre, integer *nrhs, doublecomplex_lotus *b, integer *ldb, 
	doublecomplex_lotus *bx, integer *ldbx, integer *perm, integer *givptr, 
	integer *givcol, integer *ldgcol, doublereal_lotus *givnum, integer *ldgnum, 
	 doublereal_lotus *poles, doublereal_lotus *difl, doublereal_lotus *difr, doublereal_lotus *
	z__, integer *k, doublereal_lotus *c__, doublereal_lotus *s, doublereal_lotus *rwork, 
	integer *info);

/* Subroutine */ int zlalsa_(integer *icompq, integer *smlsiz, integer *n, 
	integer *nrhs, doublecomplex_lotus *b, integer *ldb, doublecomplex_lotus *bx, 
	integer *ldbx, doublereal_lotus *u, integer *ldu, doublereal_lotus *vt, integer *
	k, doublereal_lotus *difl, doublereal_lotus *difr, doublereal_lotus *z__, doublereal_lotus *
	poles, integer *givptr, integer *givcol, integer *ldgcol, integer *
	perm, doublereal_lotus *givnum, doublereal_lotus *c__, doublereal_lotus *s, doublereal_lotus *
	rwork, integer *iwork, integer *info);

/* Subroutine */ int zlalsd_(char *uplo, integer *smlsiz, integer *n, integer 
	*nrhs, doublereal_lotus *d__, doublereal_lotus *e, doublecomplex_lotus *b, integer *ldb, 
	 doublereal_lotus *rcond, integer *rank, doublecomplex_lotus *work, doublereal_lotus *
	rwork, integer *iwork, integer *info);

doublereal_lotus zlangb_(char *norm, integer *n, integer *kl, integer *ku, 
	doublecomplex_lotus *ab, integer *ldab, doublereal_lotus *work);

doublereal_lotus zlange_(char *norm, integer *m, integer *n, doublecomplex_lotus *a, 
	integer *lda, doublereal_lotus *work);

doublereal_lotus zlangt_(char *norm, integer *n, doublecomplex_lotus *dl, doublecomplex_lotus *
	d__, doublecomplex_lotus *du);

doublereal_lotus zlanhb_(char *norm, char *uplo, integer *n, integer *k, 
	doublecomplex_lotus *ab, integer *ldab, doublereal_lotus *work);

doublereal_lotus zlanhe_(char *norm, char *uplo, integer *n, doublecomplex_lotus *a, 
	integer *lda, doublereal_lotus *work);

doublereal_lotus zlanhf_(char *norm, char *transr, char *uplo, integer *n, 
	doublecomplex_lotus *a, doublereal_lotus *work);

doublereal_lotus zlanhp_(char *norm, char *uplo, integer *n, doublecomplex_lotus *ap, 
	doublereal_lotus *work);

doublereal_lotus zlanhs_(char *norm, integer *n, doublecomplex_lotus *a, integer *lda, 
	doublereal_lotus *work);

doublereal_lotus zlanht_(char *norm, integer *n, doublereal_lotus *d__, doublecomplex_lotus *e);

doublereal_lotus zlansb_(char *norm, char *uplo, integer *n, integer *k, 
	doublecomplex_lotus *ab, integer *ldab, doublereal_lotus *work);

doublereal_lotus zlansp_(char *norm, char *uplo, integer *n, doublecomplex_lotus *ap, 
	doublereal_lotus *work);

doublereal_lotus zlansy_(char *norm, char *uplo, integer *n, doublecomplex_lotus *a, 
	integer *lda, doublereal_lotus *work);

doublereal_lotus zlantb_(char *norm, char *uplo, char *diag, integer *n, integer *k, 
	 doublecomplex_lotus *ab, integer *ldab, doublereal_lotus *work);

doublereal_lotus zlantp_(char *norm, char *uplo, char *diag, integer *n, 
	doublecomplex_lotus *ap, doublereal_lotus *work);

doublereal_lotus zlantr_(char *norm, char *uplo, char *diag, integer *m, integer *n, 
	 doublecomplex_lotus *a, integer *lda, doublereal_lotus *work);

/* Subroutine */ int zlapll_(integer *n, doublecomplex_lotus *x, integer *incx, 
	doublecomplex_lotus *y, integer *incy, doublereal_lotus *ssmin);

/* Subroutine */ int zlapmt_(logical *forwrd, integer *m, integer *n, 
	doublecomplex_lotus *x, integer *ldx, integer *k);

/* Subroutine */ int zlaqgb_(integer *m, integer *n, integer *kl, integer *ku, 
	 doublecomplex_lotus *ab, integer *ldab, doublereal_lotus *r__, doublereal_lotus *c__, 
	doublereal_lotus *rowcnd, doublereal_lotus *colcnd, doublereal_lotus *amax, char *equed);

/* Subroutine */ int zlaqge_(integer *m, integer *n, doublecomplex_lotus *a, 
	integer *lda, doublereal_lotus *r__, doublereal_lotus *c__, doublereal_lotus *rowcnd, 
	doublereal_lotus *colcnd, doublereal_lotus *amax, char *equed);

/* Subroutine */ int zlaqhb_(char *uplo, integer *n, integer *kd, 
	doublecomplex_lotus *ab, integer *ldab, doublereal_lotus *s, doublereal_lotus *scond, 
	doublereal_lotus *amax, char *equed);

/* Subroutine */ int zlaqhe_(char *uplo, integer *n, doublecomplex_lotus *a, 
	integer *lda, doublereal_lotus *s, doublereal_lotus *scond, doublereal_lotus *amax, 
	char *equed);

/* Subroutine */ int zlaqhp_(char *uplo, integer *n, doublecomplex_lotus *ap, 
	doublereal_lotus *s, doublereal_lotus *scond, doublereal_lotus *amax, char *equed);

/* Subroutine */ int zlaqp2_(integer *m, integer *n, integer *offset, 
	doublecomplex_lotus *a, integer *lda, integer *jpvt, doublecomplex_lotus *tau, 
	doublereal_lotus *vn1, doublereal_lotus *vn2, doublecomplex_lotus *work);

/* Subroutine */ int zlaqps_(integer *m, integer *n, integer *offset, integer 
	*nb, integer *kb, doublecomplex_lotus *a, integer *lda, integer *jpvt, 
	doublecomplex_lotus *tau, doublereal_lotus *vn1, doublereal_lotus *vn2, doublecomplex_lotus *
	auxv, doublecomplex_lotus *f, integer *ldf);

/* Subroutine */ int zlaqr0_(logical *wantt, logical *wantz, integer *n, 
	integer *ilo, integer *ihi, doublecomplex_lotus *h__, integer *ldh, 
	doublecomplex_lotus *w, integer *iloz, integer *ihiz, doublecomplex_lotus *z__, 
	integer *ldz, doublecomplex_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int zlaqr1_(integer *n, doublecomplex_lotus *h__, integer *ldh, 
	doublecomplex_lotus *s1, doublecomplex_lotus *s2, doublecomplex_lotus *v);

/* Subroutine */ int zlaqr2_(logical *wantt, logical *wantz, integer *n, 
	integer *ktop, integer *kbot, integer *nw, doublecomplex_lotus *h__, 
	integer *ldh, integer *iloz, integer *ihiz, doublecomplex_lotus *z__, 
	integer *ldz, integer *ns, integer *nd, doublecomplex_lotus *sh, 
	doublecomplex_lotus *v, integer *ldv, integer *nh, doublecomplex_lotus *t, 
	integer *ldt, integer *nv, doublecomplex_lotus *wv, integer *ldwv, 
	doublecomplex_lotus *work, integer *lwork);

/* Subroutine */ int zlaqr3_(logical *wantt, logical *wantz, integer *n, 
	integer *ktop, integer *kbot, integer *nw, doublecomplex_lotus *h__, 
	integer *ldh, integer *iloz, integer *ihiz, doublecomplex_lotus *z__, 
	integer *ldz, integer *ns, integer *nd, doublecomplex_lotus *sh, 
	doublecomplex_lotus *v, integer *ldv, integer *nh, doublecomplex_lotus *t, 
	integer *ldt, integer *nv, doublecomplex_lotus *wv, integer *ldwv, 
	doublecomplex_lotus *work, integer *lwork);

/* Subroutine */ int zlaqr4_(logical *wantt, logical *wantz, integer *n, 
	integer *ilo, integer *ihi, doublecomplex_lotus *h__, integer *ldh, 
	doublecomplex_lotus *w, integer *iloz, integer *ihiz, doublecomplex_lotus *z__, 
	integer *ldz, doublecomplex_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int zlaqr5_(logical *wantt, logical *wantz, integer *kacc22, 
	integer *n, integer *ktop, integer *kbot, integer *nshfts, 
	doublecomplex_lotus *s, doublecomplex_lotus *h__, integer *ldh, integer *iloz, 
	integer *ihiz, doublecomplex_lotus *z__, integer *ldz, doublecomplex_lotus *v, 
	integer *ldv, doublecomplex_lotus *u, integer *ldu, integer *nv, 
	doublecomplex_lotus *wv, integer *ldwv, integer *nh, doublecomplex_lotus *wh, 
	integer *ldwh);

/* Subroutine */ int zlaqsb_(char *uplo, integer *n, integer *kd, 
	doublecomplex_lotus *ab, integer *ldab, doublereal_lotus *s, doublereal_lotus *scond, 
	doublereal_lotus *amax, char *equed);

/* Subroutine */ int zlaqsp_(char *uplo, integer *n, doublecomplex_lotus *ap, 
	doublereal_lotus *s, doublereal_lotus *scond, doublereal_lotus *amax, char *equed);

/* Subroutine */ int zlaqsy_(char *uplo, integer *n, doublecomplex_lotus *a, 
	integer *lda, doublereal_lotus *s, doublereal_lotus *scond, doublereal_lotus *amax, 
	char *equed);

/* Subroutine */ int zlar1v_(integer *n, integer *b1, integer *bn, doublereal_lotus 
	*lambda, doublereal_lotus *d__, doublereal_lotus *l, doublereal_lotus *ld, doublereal_lotus *
	lld, doublereal_lotus *pivmin, doublereal_lotus *gaptol, doublecomplex_lotus *z__, 
	logical *wantnc, integer *negcnt, doublereal_lotus *ztz, doublereal_lotus *mingma, 
	 integer *r__, integer *isuppz, doublereal_lotus *nrminv, doublereal_lotus *resid, 
	 doublereal_lotus *rqcorr, doublereal_lotus *work);

/* Subroutine */ int zlar2v_(integer *n, doublecomplex_lotus *x, doublecomplex_lotus *y, 
	doublecomplex_lotus *z__, integer *incx, doublereal_lotus *c__, doublecomplex_lotus *s, 
	integer *incc);

/* Subroutine */ int zlarcm_(integer *m, integer *n, doublereal_lotus *a, integer *
	lda, doublecomplex_lotus *b, integer *ldb, doublecomplex_lotus *c__, integer *ldc, 
	 doublereal_lotus *rwork);

/* Subroutine */ int zlarf_(char *side, integer *m, integer *n, doublecomplex_lotus 
	*v, integer *incv, doublecomplex_lotus *tau, doublecomplex_lotus *c__, integer *
	ldc, doublecomplex_lotus *work);

/* Subroutine */ int zlarfb_(char *side, char *trans, char *direct, char *
	storev, integer *m, integer *n, integer *k, doublecomplex_lotus *v, integer 
	*ldv, doublecomplex_lotus *t, integer *ldt, doublecomplex_lotus *c__, integer *
	ldc, doublecomplex_lotus *work, integer *ldwork);

/* Subroutine */ int zlarfg_(integer *n, doublecomplex_lotus *alpha, doublecomplex_lotus *
	x, integer *incx, doublecomplex_lotus *tau);

/* Subroutine */ int zlarfp_(integer *n, doublecomplex_lotus *alpha, doublecomplex_lotus *
	x, integer *incx, doublecomplex_lotus *tau);

/* Subroutine */ int zlarft_(char *direct, char *storev, integer *n, integer *
	k, doublecomplex_lotus *v, integer *ldv, doublecomplex_lotus *tau, doublecomplex_lotus *
	t, integer *ldt);

/* Subroutine */ int zlarfx_(char *side, integer *m, integer *n, 
	doublecomplex_lotus *v, doublecomplex_lotus *tau, doublecomplex_lotus *c__, integer *
	ldc, doublecomplex_lotus *work);

/* Subroutine */ int zlargv_(integer *n, doublecomplex_lotus *x, integer *incx, 
	doublecomplex_lotus *y, integer *incy, doublereal_lotus *c__, integer *incc);

/* Subroutine */ int zlarnv_(integer *idist, integer *iseed, integer *n, 
	doublecomplex_lotus *x);

/* Subroutine */ int zlarrv_(integer *n, doublereal_lotus *vl, doublereal_lotus *vu, 
	doublereal_lotus *d__, doublereal_lotus *l, doublereal_lotus *pivmin, integer *isplit, 
	integer *m, integer *dol, integer *dou, doublereal_lotus *minrgp, 
	doublereal_lotus *rtol1, doublereal_lotus *rtol2, doublereal_lotus *w, doublereal_lotus *werr, 
	 doublereal_lotus *wgap, integer *iblock, integer *indexw, doublereal_lotus *gers, 
	 doublecomplex_lotus *z__, integer *ldz, integer *isuppz, doublereal_lotus *work, 
	integer *iwork, integer *info);

/* Subroutine */ int zlarscl2_(integer *m, integer *n, doublereal_lotus *d__, 
	doublecomplex_lotus *x, integer *ldx);

/* Subroutine */ int zlartg_(doublecomplex_lotus *f, doublecomplex_lotus *g, doublereal_lotus *
	cs, doublecomplex_lotus *sn, doublecomplex_lotus *r__);

/* Subroutine */ int zlartv_(integer *n, doublecomplex_lotus *x, integer *incx, 
	doublecomplex_lotus *y, integer *incy, doublereal_lotus *c__, doublecomplex_lotus *s, 
	integer *incc);

/* Subroutine */ int zlarz_(char *side, integer *m, integer *n, integer *l, 
	doublecomplex_lotus *v, integer *incv, doublecomplex_lotus *tau, doublecomplex_lotus *
	c__, integer *ldc, doublecomplex_lotus *work);

/* Subroutine */ int zlarzb_(char *side, char *trans, char *direct, char *
	storev, integer *m, integer *n, integer *k, integer *l, doublecomplex_lotus 
	*v, integer *ldv, doublecomplex_lotus *t, integer *ldt, doublecomplex_lotus *c__, 
	integer *ldc, doublecomplex_lotus *work, integer *ldwork);

/* Subroutine */ int zlarzt_(char *direct, char *storev, integer *n, integer *
	k, doublecomplex_lotus *v, integer *ldv, doublecomplex_lotus *tau, doublecomplex_lotus *
	t, integer *ldt);

/* Subroutine */ int zlascl_(char *type__, integer *kl, integer *ku, 
	doublereal_lotus *cfrom, doublereal_lotus *cto, integer *m, integer *n, 
	doublecomplex_lotus *a, integer *lda, integer *info);

/* Subroutine */ int zlascl2_(integer *m, integer *n, doublereal_lotus *d__, 
	doublecomplex_lotus *x, integer *ldx);

/* Subroutine */ int zlaset_(char *uplo, integer *m, integer *n, 
	doublecomplex_lotus *alpha, doublecomplex_lotus *beta, doublecomplex_lotus *a, integer *
	lda);

/* Subroutine */ int zlasr_(char *side, char *pivot, char *direct, integer *m, 
	 integer *n, doublereal_lotus *c__, doublereal_lotus *s, doublecomplex_lotus *a, 
	integer *lda);

/* Subroutine */ int zlassq_(integer *n, doublecomplex_lotus *x, integer *incx, 
	doublereal_lotus *scale, doublereal_lotus *sumsq);

/* Subroutine */ int zlaswp_(integer *n, doublecomplex_lotus *a, integer *lda, 
	integer *k1, integer *k2, integer *ipiv, integer *incx);

/* Subroutine */ int zlasyf_(char *uplo, integer *n, integer *nb, integer *kb, 
	 doublecomplex_lotus *a, integer *lda, integer *ipiv, doublecomplex_lotus *w, 
	integer *ldw, integer *info);

/* Subroutine */ int zlat2c_(char *uplo, integer *n, doublecomplex_lotus *a, 
	integer *lda, complex_lotus *sa, integer *ldsa, integer *info);

/* Subroutine */ int zlatbs_(char *uplo, char *trans, char *diag, char *
	normin, integer *n, integer *kd, doublecomplex_lotus *ab, integer *ldab, 
	doublecomplex_lotus *x, doublereal_lotus *scale, doublereal_lotus *cnorm, integer *info);

/* Subroutine */ int zlatdf_(integer *ijob, integer *n, doublecomplex_lotus *z__, 
	integer *ldz, doublecomplex_lotus *rhs, doublereal_lotus *rdsum, doublereal_lotus *
	rdscal, integer *ipiv, integer *jpiv);

/* Subroutine */ int zlatps_(char *uplo, char *trans, char *diag, char *
	normin, integer *n, doublecomplex_lotus *ap, doublecomplex_lotus *x, doublereal_lotus *
	scale, doublereal_lotus *cnorm, integer *info);

/* Subroutine */ int zlatrd_(char *uplo, integer *n, integer *nb, 
	doublecomplex_lotus *a, integer *lda, doublereal_lotus *e, doublecomplex_lotus *tau, 
	doublecomplex_lotus *w, integer *ldw);

/* Subroutine */ int zlatrs_(char *uplo, char *trans, char *diag, char *
	normin, integer *n, doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *x, 
	doublereal_lotus *scale, doublereal_lotus *cnorm, integer *info);

/* Subroutine */ int zlatrz_(integer *m, integer *n, integer *l, 
	doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *tau, doublecomplex_lotus *
	work);

/* Subroutine */ int zlatzm_(char *side, integer *m, integer *n, 
	doublecomplex_lotus *v, integer *incv, doublecomplex_lotus *tau, doublecomplex_lotus *
	c1, doublecomplex_lotus *c2, integer *ldc, doublecomplex_lotus *work);

/* Subroutine */ int zlauu2_(char *uplo, integer *n, doublecomplex_lotus *a, 
	integer *lda, integer *info);

/* Subroutine */ int zlauum_(char *uplo, integer *n, doublecomplex_lotus *a, 
	integer *lda, integer *info);

/* Subroutine */ int zpbcon_(char *uplo, integer *n, integer *kd, 
	doublecomplex_lotus *ab, integer *ldab, doublereal_lotus *anorm, doublereal_lotus *
	rcond, doublecomplex_lotus *work, doublereal_lotus *rwork, integer *info);

/* Subroutine */ int zpbequ_(char *uplo, integer *n, integer *kd, 
	doublecomplex_lotus *ab, integer *ldab, doublereal_lotus *s, doublereal_lotus *scond, 
	doublereal_lotus *amax, integer *info);

/* Subroutine */ int zpbrfs_(char *uplo, integer *n, integer *kd, integer *
	nrhs, doublecomplex_lotus *ab, integer *ldab, doublecomplex_lotus *afb, integer *
	ldafb, doublecomplex_lotus *b, integer *ldb, doublecomplex_lotus *x, integer *ldx, 
	 doublereal_lotus *ferr, doublereal_lotus *berr, doublecomplex_lotus *work, doublereal_lotus *
	rwork, integer *info);

/* Subroutine */ int zpbstf_(char *uplo, integer *n, integer *kd, 
	doublecomplex_lotus *ab, integer *ldab, integer *info);

/* Subroutine */ int zpbsv_(char *uplo, integer *n, integer *kd, integer *
	nrhs, doublecomplex_lotus *ab, integer *ldab, doublecomplex_lotus *b, integer *
	ldb, integer *info);

/* Subroutine */ int zpbsvx_(char *fact, char *uplo, integer *n, integer *kd, 
	integer *nrhs, doublecomplex_lotus *ab, integer *ldab, doublecomplex_lotus *afb, 
	integer *ldafb, char *equed, doublereal_lotus *s, doublecomplex_lotus *b, integer 
	*ldb, doublecomplex_lotus *x, integer *ldx, doublereal_lotus *rcond, doublereal_lotus *
	ferr, doublereal_lotus *berr, doublecomplex_lotus *work, doublereal_lotus *rwork, 
	integer *info);

/* Subroutine */ int zpbtf2_(char *uplo, integer *n, integer *kd, 
	doublecomplex_lotus *ab, integer *ldab, integer *info);

/* Subroutine */ int zpbtrf_(char *uplo, integer *n, integer *kd, 
	doublecomplex_lotus *ab, integer *ldab, integer *info);

/* Subroutine */ int zpbtrs_(char *uplo, integer *n, integer *kd, integer *
	nrhs, doublecomplex_lotus *ab, integer *ldab, doublecomplex_lotus *b, integer *
	ldb, integer *info);

/* Subroutine */ int zpftrf_(char *transr, char *uplo, integer *n, 
	doublecomplex_lotus *a, integer *info);

/* Subroutine */ int zpftri_(char *transr, char *uplo, integer *n, 
	doublecomplex_lotus *a, integer *info);

/* Subroutine */ int zpftrs_(char *transr, char *uplo, integer *n, integer *
	nrhs, doublecomplex_lotus *a, doublecomplex_lotus *b, integer *ldb, integer *info);

/* Subroutine */ int zpocon_(char *uplo, integer *n, doublecomplex_lotus *a, 
	integer *lda, doublereal_lotus *anorm, doublereal_lotus *rcond, doublecomplex_lotus *
	work, doublereal_lotus *rwork, integer *info);

/* Subroutine */ int zpoequ_(integer *n, doublecomplex_lotus *a, integer *lda, 
	doublereal_lotus *s, doublereal_lotus *scond, doublereal_lotus *amax, integer *info);

/* Subroutine */ int zpoequb_(integer *n, doublecomplex_lotus *a, integer *lda, 
	doublereal_lotus *s, doublereal_lotus *scond, doublereal_lotus *amax, integer *info);

/* Subroutine */ int zporfs_(char *uplo, integer *n, integer *nrhs, 
	doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *af, integer *ldaf, 
	doublecomplex_lotus *b, integer *ldb, doublecomplex_lotus *x, integer *ldx, 
	doublereal_lotus *ferr, doublereal_lotus *berr, doublecomplex_lotus *work, doublereal_lotus *
	rwork, integer *info);

/* Subroutine */ int zporfsx_(char *uplo, char *equed, integer *n, integer *
	nrhs, doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *af, integer *
	ldaf, doublereal_lotus *s, doublecomplex_lotus *b, integer *ldb, doublecomplex_lotus *x, 
	 integer *ldx, doublereal_lotus *rcond, doublereal_lotus *berr, integer *
	n_err_bnds__, doublereal_lotus *err_bnds_norm__, doublereal_lotus *
	err_bnds_comp__, integer *nparams, doublereal_lotus *params, doublecomplex_lotus *
	work, doublereal_lotus *rwork, integer *info);

/* Subroutine */ int zposv_(char *uplo, integer *n, integer *nrhs, 
	doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *b, integer *ldb, 
	integer *info);

/* Subroutine */ int zposvx_(char *fact, char *uplo, integer *n, integer *
	nrhs, doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *af, integer *
	ldaf, char *equed, doublereal_lotus *s, doublecomplex_lotus *b, integer *ldb, 
	doublecomplex_lotus *x, integer *ldx, doublereal_lotus *rcond, doublereal_lotus *ferr, 
	doublereal_lotus *berr, doublecomplex_lotus *work, doublereal_lotus *rwork, integer *
	info);

/* Subroutine */ int zposvxx_(char *fact, char *uplo, integer *n, integer *
	nrhs, doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *af, integer *
	ldaf, char *equed, doublereal_lotus *s, doublecomplex_lotus *b, integer *ldb, 
	doublecomplex_lotus *x, integer *ldx, doublereal_lotus *rcond, doublereal_lotus *rpvgrw, 
	 doublereal_lotus *berr, integer *n_err_bnds__, doublereal_lotus *err_bnds_norm__, 
	 doublereal_lotus *err_bnds_comp__, integer *nparams, doublereal_lotus *params, 
	doublecomplex_lotus *work, doublereal_lotus *rwork, integer *info);

/* Subroutine */ int zpotf2_(char *uplo, integer *n, doublecomplex_lotus *a, 
	integer *lda, integer *info);

/* Subroutine */ int zpotrf_(char *uplo, integer *n, doublecomplex_lotus *a, 
	integer *lda, integer *info);

/* Subroutine */ int zpotri_(char *uplo, integer *n, doublecomplex_lotus *a, 
	integer *lda, integer *info);

/* Subroutine */ int zpotrs_(char *uplo, integer *n, integer *nrhs, 
	doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *b, integer *ldb, 
	integer *info);

/* Subroutine */ int zppcon_(char *uplo, integer *n, doublecomplex_lotus *ap, 
	doublereal_lotus *anorm, doublereal_lotus *rcond, doublecomplex_lotus *work, doublereal_lotus 
	*rwork, integer *info);

/* Subroutine */ int zppequ_(char *uplo, integer *n, doublecomplex_lotus *ap, 
	doublereal_lotus *s, doublereal_lotus *scond, doublereal_lotus *amax, integer *info);

/* Subroutine */ int zpprfs_(char *uplo, integer *n, integer *nrhs, 
	doublecomplex_lotus *ap, doublecomplex_lotus *afp, doublecomplex_lotus *b, integer *ldb, 
	 doublecomplex_lotus *x, integer *ldx, doublereal_lotus *ferr, doublereal_lotus *berr, 
	doublecomplex_lotus *work, doublereal_lotus *rwork, integer *info);

/* Subroutine */ int zppsv_(char *uplo, integer *n, integer *nrhs, 
	doublecomplex_lotus *ap, doublecomplex_lotus *b, integer *ldb, integer *info);

/* Subroutine */ int zppsvx_(char *fact, char *uplo, integer *n, integer *
	nrhs, doublecomplex_lotus *ap, doublecomplex_lotus *afp, char *equed, doublereal_lotus *
	s, doublecomplex_lotus *b, integer *ldb, doublecomplex_lotus *x, integer *ldx, 
	doublereal_lotus *rcond, doublereal_lotus *ferr, doublereal_lotus *berr, doublecomplex_lotus *
	work, doublereal_lotus *rwork, integer *info);

/* Subroutine */ int zpptrf_(char *uplo, integer *n, doublecomplex_lotus *ap, 
	integer *info);

/* Subroutine */ int zpptri_(char *uplo, integer *n, doublecomplex_lotus *ap, 
	integer *info);

/* Subroutine */ int zpptrs_(char *uplo, integer *n, integer *nrhs, 
	doublecomplex_lotus *ap, doublecomplex_lotus *b, integer *ldb, integer *info);

/* Subroutine */ int zpstf2_(char *uplo, integer *n, doublecomplex_lotus *a, 
	integer *lda, integer *piv, integer *rank, doublereal_lotus *tol, 
	doublereal_lotus *work, integer *info);

/* Subroutine */ int zpstrf_(char *uplo, integer *n, doublecomplex_lotus *a, 
	integer *lda, integer *piv, integer *rank, doublereal_lotus *tol, 
	doublereal_lotus *work, integer *info);

/* Subroutine */ int zptcon_(integer *n, doublereal_lotus *d__, doublecomplex_lotus *e, 
	doublereal_lotus *anorm, doublereal_lotus *rcond, doublereal_lotus *rwork, integer *
	info);

/* Subroutine */ int zpteqr_(char *compz, integer *n, doublereal_lotus *d__, 
	doublereal_lotus *e, doublecomplex_lotus *z__, integer *ldz, doublereal_lotus *work, 
	integer *info);

/* Subroutine */ int zptrfs_(char *uplo, integer *n, integer *nrhs, 
	doublereal_lotus *d__, doublecomplex_lotus *e, doublereal_lotus *df, doublecomplex_lotus *ef, 
	doublecomplex_lotus *b, integer *ldb, doublecomplex_lotus *x, integer *ldx, 
	doublereal_lotus *ferr, doublereal_lotus *berr, doublecomplex_lotus *work, doublereal_lotus *
	rwork, integer *info);

/* Subroutine */ int zptsv_(integer *n, integer *nrhs, doublereal_lotus *d__, 
	doublecomplex_lotus *e, doublecomplex_lotus *b, integer *ldb, integer *info);

/* Subroutine */ int zptsvx_(char *fact, integer *n, integer *nrhs, 
	doublereal_lotus *d__, doublecomplex_lotus *e, doublereal_lotus *df, doublecomplex_lotus *ef, 
	doublecomplex_lotus *b, integer *ldb, doublecomplex_lotus *x, integer *ldx, 
	doublereal_lotus *rcond, doublereal_lotus *ferr, doublereal_lotus *berr, doublecomplex_lotus *
	work, doublereal_lotus *rwork, integer *info);

/* Subroutine */ int zpttrf_(integer *n, doublereal_lotus *d__, doublecomplex_lotus *e, 
	integer *info);

/* Subroutine */ int zpttrs_(char *uplo, integer *n, integer *nrhs, 
	doublereal_lotus *d__, doublecomplex_lotus *e, doublecomplex_lotus *b, integer *ldb, 
	integer *info);

/* Subroutine */ int zptts2_(integer *iuplo, integer *n, integer *nrhs, 
	doublereal_lotus *d__, doublecomplex_lotus *e, doublecomplex_lotus *b, integer *ldb);

/* Subroutine */ int zrot_(integer *n, doublecomplex_lotus *cx, integer *incx, 
	doublecomplex_lotus *cy, integer *incy, doublereal_lotus *c__, doublecomplex_lotus *s);

/* Subroutine */ int zspcon_(char *uplo, integer *n, doublecomplex_lotus *ap, 
	integer *ipiv, doublereal_lotus *anorm, doublereal_lotus *rcond, doublecomplex_lotus *
	work, integer *info);

/* Subroutine */ int zspmv_(char *uplo, integer *n, doublecomplex_lotus *alpha, 
	doublecomplex_lotus *ap, doublecomplex_lotus *x, integer *incx, doublecomplex_lotus *
	beta, doublecomplex_lotus *y, integer *incy);

/* Subroutine */ int zspr_(char *uplo, integer *n, doublecomplex_lotus *alpha, 
	doublecomplex_lotus *x, integer *incx, doublecomplex_lotus *ap);

/* Subroutine */ int zsprfs_(char *uplo, integer *n, integer *nrhs, 
	doublecomplex_lotus *ap, doublecomplex_lotus *afp, integer *ipiv, doublecomplex_lotus *
	b, integer *ldb, doublecomplex_lotus *x, integer *ldx, doublereal_lotus *ferr, 
	doublereal_lotus *berr, doublecomplex_lotus *work, doublereal_lotus *rwork, integer *
	info);

/* Subroutine */ int zspsv_(char *uplo, integer *n, integer *nrhs, 
	doublecomplex_lotus *ap, integer *ipiv, doublecomplex_lotus *b, integer *ldb, 
	integer *info);

/* Subroutine */ int zspsvx_(char *fact, char *uplo, integer *n, integer *
	nrhs, doublecomplex_lotus *ap, doublecomplex_lotus *afp, integer *ipiv, 
	doublecomplex_lotus *b, integer *ldb, doublecomplex_lotus *x, integer *ldx, 
	doublereal_lotus *rcond, doublereal_lotus *ferr, doublereal_lotus *berr, doublecomplex_lotus *
	work, doublereal_lotus *rwork, integer *info);

/* Subroutine */ int zsptrf_(char *uplo, integer *n, doublecomplex_lotus *ap, 
	integer *ipiv, integer *info);

/* Subroutine */ int zsptri_(char *uplo, integer *n, doublecomplex_lotus *ap, 
	integer *ipiv, doublecomplex_lotus *work, integer *info);

/* Subroutine */ int zsptrs_(char *uplo, integer *n, integer *nrhs, 
	doublecomplex_lotus *ap, integer *ipiv, doublecomplex_lotus *b, integer *ldb, 
	integer *info);

/* Subroutine */ int zstedc_(char *compz, integer *n, doublereal_lotus *d__, 
	doublereal_lotus *e, doublecomplex_lotus *z__, integer *ldz, doublecomplex_lotus *work, 
	integer *lwork, doublereal_lotus *rwork, integer *lrwork, integer *iwork, 
	integer *liwork, integer *info);

/* Subroutine */ int zstegr_(char *jobz, char *range, integer *n, doublereal_lotus *
	d__, doublereal_lotus *e, doublereal_lotus *vl, doublereal_lotus *vu, integer *il, 
	integer *iu, doublereal_lotus *abstol, integer *m, doublereal_lotus *w, 
	doublecomplex_lotus *z__, integer *ldz, integer *isuppz, doublereal_lotus *work, 
	integer *lwork, integer *iwork, integer *liwork, integer *info);

/* Subroutine */ int zstein_(integer *n, doublereal_lotus *d__, doublereal_lotus *e, 
	integer *m, doublereal_lotus *w, integer *iblock, integer *isplit, 
	doublecomplex_lotus *z__, integer *ldz, doublereal_lotus *work, integer *iwork, 
	integer *ifail, integer *info);

/* Subroutine */ int zstemr_(char *jobz, char *range, integer *n, doublereal_lotus *
	d__, doublereal_lotus *e, doublereal_lotus *vl, doublereal_lotus *vu, integer *il, 
	integer *iu, integer *m, doublereal_lotus *w, doublecomplex_lotus *z__, integer *
	ldz, integer *nzc, integer *isuppz, logical *tryrac, doublereal_lotus *work, 
	 integer *lwork, integer *iwork, integer *liwork, integer *info);

/* Subroutine */ int zsteqr_(char *compz, integer *n, doublereal_lotus *d__, 
	doublereal_lotus *e, doublecomplex_lotus *z__, integer *ldz, doublereal_lotus *work, 
	integer *info);

/* Subroutine */ int zsycon_(char *uplo, integer *n, doublecomplex_lotus *a, 
	integer *lda, integer *ipiv, doublereal_lotus *anorm, doublereal_lotus *rcond, 
	doublecomplex_lotus *work, integer *info);

/* Subroutine */ int zsyequb_(char *uplo, integer *n, doublecomplex_lotus *a, 
	integer *lda, doublereal_lotus *s, doublereal_lotus *scond, doublereal_lotus *amax, 
	doublecomplex_lotus *work, integer *info);

/* Subroutine */ int zsymv_(char *uplo, integer *n, doublecomplex_lotus *alpha, 
	doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *x, integer *incx, 
	doublecomplex_lotus *beta, doublecomplex_lotus *y, integer *incy);

/* Subroutine */ int zsyr_(char *uplo, integer *n, doublecomplex_lotus *alpha, 
	doublecomplex_lotus *x, integer *incx, doublecomplex_lotus *a, integer *lda);

/* Subroutine */ int zsyrfs_(char *uplo, integer *n, integer *nrhs, 
	doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *af, integer *ldaf, 
	integer *ipiv, doublecomplex_lotus *b, integer *ldb, doublecomplex_lotus *x, 
	integer *ldx, doublereal_lotus *ferr, doublereal_lotus *berr, doublecomplex_lotus *work, 
	 doublereal_lotus *rwork, integer *info);

/* Subroutine */ int zsyrfsx_(char *uplo, char *equed, integer *n, integer *
	nrhs, doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *af, integer *
	ldaf, integer *ipiv, doublereal_lotus *s, doublecomplex_lotus *b, integer *ldb, 
	doublecomplex_lotus *x, integer *ldx, doublereal_lotus *rcond, doublereal_lotus *berr, 
	integer *n_err_bnds__, doublereal_lotus *err_bnds_norm__, doublereal_lotus *
	err_bnds_comp__, integer *nparams, doublereal_lotus *params, doublecomplex_lotus *
	work, doublereal_lotus *rwork, integer *info);

/* Subroutine */ int zsysv_(char *uplo, integer *n, integer *nrhs, 
	doublecomplex_lotus *a, integer *lda, integer *ipiv, doublecomplex_lotus *b, 
	integer *ldb, doublecomplex_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int zsysvx_(char *fact, char *uplo, integer *n, integer *
	nrhs, doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *af, integer *
	ldaf, integer *ipiv, doublecomplex_lotus *b, integer *ldb, doublecomplex_lotus *x, 
	 integer *ldx, doublereal_lotus *rcond, doublereal_lotus *ferr, doublereal_lotus *berr, 
	doublecomplex_lotus *work, integer *lwork, doublereal_lotus *rwork, integer *info);

/* Subroutine */ int zsysvxx_(char *fact, char *uplo, integer *n, integer *
	nrhs, doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *af, integer *
	ldaf, integer *ipiv, char *equed, doublereal_lotus *s, doublecomplex_lotus *b, 
	integer *ldb, doublecomplex_lotus *x, integer *ldx, doublereal_lotus *rcond, 
	doublereal_lotus *rpvgrw, doublereal_lotus *berr, integer *n_err_bnds__, 
	doublereal_lotus *err_bnds_norm__, doublereal_lotus *err_bnds_comp__, integer *
	nparams, doublereal_lotus *params, doublecomplex_lotus *work, doublereal_lotus *rwork, 
	integer *info);

/* Subroutine */ int zsytf2_(char *uplo, integer *n, doublecomplex_lotus *a, 
	integer *lda, integer *ipiv, integer *info);

/* Subroutine */ int zsytrf_(char *uplo, integer *n, doublecomplex_lotus *a, 
	integer *lda, integer *ipiv, doublecomplex_lotus *work, integer *lwork, 
	integer *info);

/* Subroutine */ int zsytri_(char *uplo, integer *n, doublecomplex_lotus *a, 
	integer *lda, integer *ipiv, doublecomplex_lotus *work, integer *info);

/* Subroutine */ int zsytrs_(char *uplo, integer *n, integer *nrhs, 
	doublecomplex_lotus *a, integer *lda, integer *ipiv, doublecomplex_lotus *b, 
	integer *ldb, integer *info);

/* Subroutine */ int ztbcon_(char *norm, char *uplo, char *diag, integer *n, 
	integer *kd, doublecomplex_lotus *ab, integer *ldab, doublereal_lotus *rcond, 
	doublecomplex_lotus *work, doublereal_lotus *rwork, integer *info);

/* Subroutine */ int ztbrfs_(char *uplo, char *trans, char *diag, integer *n, 
	integer *kd, integer *nrhs, doublecomplex_lotus *ab, integer *ldab, 
	doublecomplex_lotus *b, integer *ldb, doublecomplex_lotus *x, integer *ldx, 
	doublereal_lotus *ferr, doublereal_lotus *berr, doublecomplex_lotus *work, doublereal_lotus *
	rwork, integer *info);

/* Subroutine */ int ztbtrs_(char *uplo, char *trans, char *diag, integer *n, 
	integer *kd, integer *nrhs, doublecomplex_lotus *ab, integer *ldab, 
	doublecomplex_lotus *b, integer *ldb, integer *info);

/* Subroutine */ int ztfsm_(char *transr, char *side, char *uplo, char *trans, 
	 char *diag, integer *m, integer *n, doublecomplex_lotus *alpha, 
	doublecomplex_lotus *a, doublecomplex_lotus *b, integer *ldb);

/* Subroutine */ int ztftri_(char *transr, char *uplo, char *diag, integer *n, 
	 doublecomplex_lotus *a, integer *info);

/* Subroutine */ int ztfttp_(char *transr, char *uplo, integer *n, 
	doublecomplex_lotus *arf, doublecomplex_lotus *ap, integer *info);

/* Subroutine */ int ztfttr_(char *transr, char *uplo, integer *n, 
	doublecomplex_lotus *arf, doublecomplex_lotus *a, integer *lda, integer *info);

/* Subroutine */ int ztgevc_(char *side, char *howmny, logical *select, 
	integer *n, doublecomplex_lotus *s, integer *lds, doublecomplex_lotus *p, integer 
	*ldp, doublecomplex_lotus *vl, integer *ldvl, doublecomplex_lotus *vr, integer *
	ldvr, integer *mm, integer *m, doublecomplex_lotus *work, doublereal_lotus *rwork, 
	 integer *info);

/* Subroutine */ int ztgex2_(logical *wantq, logical *wantz, integer *n, 
	doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *b, integer *ldb, 
	doublecomplex_lotus *q, integer *ldq, doublecomplex_lotus *z__, integer *ldz, 
	integer *j1, integer *info);

/* Subroutine */ int ztgexc_(logical *wantq, logical *wantz, integer *n, 
	doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *b, integer *ldb, 
	doublecomplex_lotus *q, integer *ldq, doublecomplex_lotus *z__, integer *ldz, 
	integer *ifst, integer *ilst, integer *info);

/* Subroutine */ int ztgsen_(integer *ijob, logical *wantq, logical *wantz, 
	logical *select, integer *n, doublecomplex_lotus *a, integer *lda, 
	doublecomplex_lotus *b, integer *ldb, doublecomplex_lotus *alpha, doublecomplex_lotus *
	beta, doublecomplex_lotus *q, integer *ldq, doublecomplex_lotus *z__, integer *
	ldz, integer *m, doublereal_lotus *pl, doublereal_lotus *pr, doublereal_lotus *dif, 
	doublecomplex_lotus *work, integer *lwork, integer *iwork, integer *liwork, 
	integer *info);

/* Subroutine */ int ztgsja_(char *jobu, char *jobv, char *jobq, integer *m, 
	integer *p, integer *n, integer *k, integer *l, doublecomplex_lotus *a, 
	integer *lda, doublecomplex_lotus *b, integer *ldb, doublereal_lotus *tola, 
	doublereal_lotus *tolb, doublereal_lotus *alpha, doublereal_lotus *beta, doublecomplex_lotus *
	u, integer *ldu, doublecomplex_lotus *v, integer *ldv, doublecomplex_lotus *q, 
	integer *ldq, doublecomplex_lotus *work, integer *ncycle, integer *info);

/* Subroutine */ int ztgsna_(char *job, char *howmny, logical *select, 
	integer *n, doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *b, integer 
	*ldb, doublecomplex_lotus *vl, integer *ldvl, doublecomplex_lotus *vr, integer *
	ldvr, doublereal_lotus *s, doublereal_lotus *dif, integer *mm, integer *m, 
	doublecomplex_lotus *work, integer *lwork, integer *iwork, integer *info);

/* Subroutine */ int ztgsy2_(char *trans, integer *ijob, integer *m, integer *
	n, doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *b, integer *ldb, 
	doublecomplex_lotus *c__, integer *ldc, doublecomplex_lotus *d__, integer *ldd, 
	doublecomplex_lotus *e, integer *lde, doublecomplex_lotus *f, integer *ldf, 
	doublereal_lotus *scale, doublereal_lotus *rdsum, doublereal_lotus *rdscal, integer *
	info);

/* Subroutine */ int ztgsyl_(char *trans, integer *ijob, integer *m, integer *
	n, doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *b, integer *ldb, 
	doublecomplex_lotus *c__, integer *ldc, doublecomplex_lotus *d__, integer *ldd, 
	doublecomplex_lotus *e, integer *lde, doublecomplex_lotus *f, integer *ldf, 
	doublereal_lotus *scale, doublereal_lotus *dif, doublecomplex_lotus *work, integer *
	lwork, integer *iwork, integer *info);

/* Subroutine */ int ztpcon_(char *norm, char *uplo, char *diag, integer *n, 
	doublecomplex_lotus *ap, doublereal_lotus *rcond, doublecomplex_lotus *work, doublereal_lotus 
	*rwork, integer *info);

/* Subroutine */ int ztprfs_(char *uplo, char *trans, char *diag, integer *n, 
	integer *nrhs, doublecomplex_lotus *ap, doublecomplex_lotus *b, integer *ldb, 
	doublecomplex_lotus *x, integer *ldx, doublereal_lotus *ferr, doublereal_lotus *berr, 
	doublecomplex_lotus *work, doublereal_lotus *rwork, integer *info);

/* Subroutine */ int ztptri_(char *uplo, char *diag, integer *n, 
	doublecomplex_lotus *ap, integer *info);

/* Subroutine */ int ztptrs_(char *uplo, char *trans, char *diag, integer *n, 
	integer *nrhs, doublecomplex_lotus *ap, doublecomplex_lotus *b, integer *ldb, 
	integer *info);

/* Subroutine */ int ztpttf_(char *transr, char *uplo, integer *n, 
	doublecomplex_lotus *ap, doublecomplex_lotus *arf, integer *info);

/* Subroutine */ int ztpttr_(char *uplo, integer *n, doublecomplex_lotus *ap, 
	doublecomplex_lotus *a, integer *lda, integer *info);

/* Subroutine */ int ztrcon_(char *norm, char *uplo, char *diag, integer *n, 
	doublecomplex_lotus *a, integer *lda, doublereal_lotus *rcond, doublecomplex_lotus *
	work, doublereal_lotus *rwork, integer *info);

/* Subroutine */ int ztrevc_(char *side, char *howmny, logical *select, 
	integer *n, doublecomplex_lotus *t, integer *ldt, doublecomplex_lotus *vl, 
	integer *ldvl, doublecomplex_lotus *vr, integer *ldvr, integer *mm, integer 
	*m, doublecomplex_lotus *work, doublereal_lotus *rwork, integer *info);

/* Subroutine */ int ztrexc_(char *compq, integer *n, doublecomplex_lotus *t, 
	integer *ldt, doublecomplex_lotus *q, integer *ldq, integer *ifst, integer *
	ilst, integer *info);

/* Subroutine */ int ztrrfs_(char *uplo, char *trans, char *diag, integer *n, 
	integer *nrhs, doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *b, 
	integer *ldb, doublecomplex_lotus *x, integer *ldx, doublereal_lotus *ferr, 
	doublereal_lotus *berr, doublecomplex_lotus *work, doublereal_lotus *rwork, integer *
	info);

/* Subroutine */ int ztrsen_(char *job, char *compq, logical *select, integer 
	*n, doublecomplex_lotus *t, integer *ldt, doublecomplex_lotus *q, integer *ldq, 
	doublecomplex_lotus *w, integer *m, doublereal_lotus *s, doublereal_lotus *sep, 
	doublecomplex_lotus *work, integer *lwork, integer *info);

/* Subroutine */ int ztrsna_(char *job, char *howmny, logical *select, 
	integer *n, doublecomplex_lotus *t, integer *ldt, doublecomplex_lotus *vl, 
	integer *ldvl, doublecomplex_lotus *vr, integer *ldvr, doublereal_lotus *s, 
	doublereal_lotus *sep, integer *mm, integer *m, doublecomplex_lotus *work, 
	integer *ldwork, doublereal_lotus *rwork, integer *info);

/* Subroutine */ int ztrsyl_(char *trana, char *tranb, integer *isgn, integer 
	*m, integer *n, doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *b, 
	integer *ldb, doublecomplex_lotus *c__, integer *ldc, doublereal_lotus *scale, 
	integer *info);

/* Subroutine */ int ztrti2_(char *uplo, char *diag, integer *n, 
	doublecomplex_lotus *a, integer *lda, integer *info);

/* Subroutine */ int ztrtri_(char *uplo, char *diag, integer *n, 
	doublecomplex_lotus *a, integer *lda, integer *info);

/* Subroutine */ int ztrtrs_(char *uplo, char *trans, char *diag, integer *n, 
	integer *nrhs, doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *b, 
	integer *ldb, integer *info);

/* Subroutine */ int ztrttf_(char *transr, char *uplo, integer *n, 
	doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *arf, integer *info);

/* Subroutine */ int ztrttp_(char *uplo, integer *n, doublecomplex_lotus *a, 
	integer *lda, doublecomplex_lotus *ap, integer *info);

/* Subroutine */ int ztzrqf_(integer *m, integer *n, doublecomplex_lotus *a, 
	integer *lda, doublecomplex_lotus *tau, integer *info);

/* Subroutine */ int ztzrzf_(integer *m, integer *n, doublecomplex_lotus *a, 
	integer *lda, doublecomplex_lotus *tau, doublecomplex_lotus *work, integer *lwork, 
	 integer *info);

/* Subroutine */ int zung2l_(integer *m, integer *n, integer *k, 
	doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *tau, doublecomplex_lotus *
	work, integer *info);

/* Subroutine */ int zung2r_(integer *m, integer *n, integer *k, 
	doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *tau, doublecomplex_lotus *
	work, integer *info);

/* Subroutine */ int zungbr_(char *vect, integer *m, integer *n, integer *k, 
	doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *tau, doublecomplex_lotus *
	work, integer *lwork, integer *info);

/* Subroutine */ int zunghr_(integer *n, integer *ilo, integer *ihi, 
	doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *tau, doublecomplex_lotus *
	work, integer *lwork, integer *info);

/* Subroutine */ int zungl2_(integer *m, integer *n, integer *k, 
	doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *tau, doublecomplex_lotus *
	work, integer *info);

/* Subroutine */ int zunglq_(integer *m, integer *n, integer *k, 
	doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *tau, doublecomplex_lotus *
	work, integer *lwork, integer *info);

/* Subroutine */ int zungql_(integer *m, integer *n, integer *k, 
	doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *tau, doublecomplex_lotus *
	work, integer *lwork, integer *info);

/* Subroutine */ int zungqr_(integer *m, integer *n, integer *k, 
	doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *tau, doublecomplex_lotus *
	work, integer *lwork, integer *info);

/* Subroutine */ int zungr2_(integer *m, integer *n, integer *k, 
	doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *tau, doublecomplex_lotus *
	work, integer *info);

/* Subroutine */ int zungrq_(integer *m, integer *n, integer *k, 
	doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *tau, doublecomplex_lotus *
	work, integer *lwork, integer *info);

/* Subroutine */ int zungtr_(char *uplo, integer *n, doublecomplex_lotus *a, 
	integer *lda, doublecomplex_lotus *tau, doublecomplex_lotus *work, integer *lwork, 
	 integer *info);

/* Subroutine */ int zunm2l_(char *side, char *trans, integer *m, integer *n, 
	integer *k, doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *tau, 
	doublecomplex_lotus *c__, integer *ldc, doublecomplex_lotus *work, integer *info);

/* Subroutine */ int zunm2r_(char *side, char *trans, integer *m, integer *n, 
	integer *k, doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *tau, 
	doublecomplex_lotus *c__, integer *ldc, doublecomplex_lotus *work, integer *info);

/* Subroutine */ int zunmbr_(char *vect, char *side, char *trans, integer *m, 
	integer *n, integer *k, doublecomplex_lotus *a, integer *lda, doublecomplex_lotus 
	*tau, doublecomplex_lotus *c__, integer *ldc, doublecomplex_lotus *work, integer *
	lwork, integer *info);

/* Subroutine */ int zunmhr_(char *side, char *trans, integer *m, integer *n, 
	integer *ilo, integer *ihi, doublecomplex_lotus *a, integer *lda, 
	doublecomplex_lotus *tau, doublecomplex_lotus *c__, integer *ldc, doublecomplex_lotus *
	work, integer *lwork, integer *info);

/* Subroutine */ int zunml2_(char *side, char *trans, integer *m, integer *n, 
	integer *k, doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *tau, 
	doublecomplex_lotus *c__, integer *ldc, doublecomplex_lotus *work, integer *info);

/* Subroutine */ int zunmlq_(char *side, char *trans, integer *m, integer *n, 
	integer *k, doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *tau, 
	doublecomplex_lotus *c__, integer *ldc, doublecomplex_lotus *work, integer *lwork, 
	 integer *info);

/* Subroutine */ int zunmql_(char *side, char *trans, integer *m, integer *n, 
	integer *k, doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *tau, 
	doublecomplex_lotus *c__, integer *ldc, doublecomplex_lotus *work, integer *lwork, 
	 integer *info);

/* Subroutine */ int zunmqr_(char *side, char *trans, integer *m, integer *n, 
	integer *k, doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *tau, 
	doublecomplex_lotus *c__, integer *ldc, doublecomplex_lotus *work, integer *lwork, 
	 integer *info);

/* Subroutine */ int zunmr2_(char *side, char *trans, integer *m, integer *n, 
	integer *k, doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *tau, 
	doublecomplex_lotus *c__, integer *ldc, doublecomplex_lotus *work, integer *info);

/* Subroutine */ int zunmr3_(char *side, char *trans, integer *m, integer *n, 
	integer *k, integer *l, doublecomplex_lotus *a, integer *lda, doublecomplex_lotus 
	*tau, doublecomplex_lotus *c__, integer *ldc, doublecomplex_lotus *work, integer *
	info);

/* Subroutine */ int zunmrq_(char *side, char *trans, integer *m, integer *n, 
	integer *k, doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *tau, 
	doublecomplex_lotus *c__, integer *ldc, doublecomplex_lotus *work, integer *lwork, 
	 integer *info);

/* Subroutine */ int zunmrz_(char *side, char *trans, integer *m, integer *n, 
	integer *k, integer *l, doublecomplex_lotus *a, integer *lda, doublecomplex_lotus 
	*tau, doublecomplex_lotus *c__, integer *ldc, doublecomplex_lotus *work, integer *
	lwork, integer *info);

/* Subroutine */ int zunmtr_(char *side, char *uplo, char *trans, integer *m, 
	integer *n, doublecomplex_lotus *a, integer *lda, doublecomplex_lotus *tau, 
	doublecomplex_lotus *c__, integer *ldc, doublecomplex_lotus *work, integer *lwork, 
	 integer *info);

/* Subroutine */ int zupgtr_(char *uplo, integer *n, doublecomplex_lotus *ap, 
	doublecomplex_lotus *tau, doublecomplex_lotus *q, integer *ldq, doublecomplex_lotus *
	work, integer *info);

/* Subroutine */ int zupmtr_(char *side, char *uplo, char *trans, integer *m, 
	integer *n, doublecomplex_lotus *ap, doublecomplex_lotus *tau, doublecomplex_lotus *c__, 
	 integer *ldc, doublecomplex_lotus *work, integer *info);

/* Subroutine */ int dlamc1_(integer *beta, integer *t, logical *rnd, logical 
	*ieee1);

doublereal_lotus dsecnd_();

/* Subroutine */ int ilaver_(integer *vers_major__, integer *vers_minor__, 
	integer *vers_patch__);

logical lsame_(char *ca, char *cb);

doublereal_lotus second_();

doublereal_lotus slamch_(char *cmach);

/* Subroutine */ int slamc1_(integer *beta, integer *t, logical *rnd, logical 
	*ieee1);

/* Subroutine */ int slamc2_(integer *beta, integer *t, logical *rnd, real_lotus *
		    eps, integer *emin, real_lotus *rmin, integer *emax, real_lotus *rmax);

doublereal_lotus slamc3_(real_lotus *a, real_lotus *b);

/* Subroutine */ int slamc4_(integer *emin, real_lotus *start, integer *base);

/* Subroutine */ int slamc5_(integer *beta, integer *p, integer *emin,
		    logical *ieee, integer *emax, real_lotus *rmax);


doublereal_lotus dlamch_(char *cmach);

/* Subroutine */ int dlamc1_(integer *beta, integer *t, logical *rnd, logical
		    *ieee1);

/* Subroutine */ int dlamc2_(integer *beta, integer *t, logical *rnd,
		    doublereal_lotus *eps, integer *emin, doublereal_lotus *rmin, integer *emax,
			    doublereal_lotus *rmax);

doublereal_lotus dlamc3_(doublereal_lotus *a, doublereal_lotus *b);

/* Subroutine */ int dlamc4_(integer *emin, doublereal_lotus *start, integer *base);

/* Subroutine */ int dlamc5_(integer *beta, integer *p, integer *emin,
		    logical *ieee, integer *emax, doublereal_lotus *rmax);

integer ilaenv_(integer *ispec, char *name__, char *opts, integer *n1, 
	integer *n2, integer *n3, integer *n4);

}


#endif
