'''
Represents the data from the Ocrat Mirror Project (stroke order GIFs, etc.)
at http://lost-theory.org/ocrat.
'''

import conversion

_cps = set(['bbb3','b9d2','c9e6','ccb8','d2c1','cbe6','c3af','bfb9','b2b1','c1cf','e4e9','d5ea','d4ec','b0e3','d7f7','bad3','d3fb','c7d6','bfca','c8bb','cefc','b3a1','bfed','cfdf','d5e4','c5c6','d5b5','bfc6','e0de','cce7','c3e7','d6bd','d5aa','bbb0','d8b3','d4de','b7b2','b0ea','c2ac','d6aa','b3fd','b9ae','b1b9','b1eb','bdd2','d1ef','d3be','c6e4','c4d6','c2cc','b3ee','edb1','d9ea','c9f2','c2c6','d3a6','d3f6','b1c0','d1ad','b7d2','cac7','d0b5','bdb2','e6f9','d2af','cfcc','bae8','d5cd','cad3','bfa1','c2bc','bdcc','d2b2','c7d8','c0a8','beb0','d0d7','d0eb','bbf9','b9e3','bded','bad1','d3bb','baf3','c6b5','b2cd','d4dd','b5d7','b2c0','c3c9','cadb','b1d9','b6f2','d1d2','b0c5','cfa7','d7e3','b0e9','b5e9','c0eb','b9ed','c1d9','d0b2','c8aa','c8c6','cded','b3d9','cbc3','c0ce','c0a4','bfc2','ccf8','bac5','c5bc','d2c6','c5c9','ccac','b0f2','bdda','b9b9','cffb','dbbb','d1e1','c3bd','c5c1','b8e1','d0a4','ceb0','b3ab','bccd','caf5','b4b5','ecea','beab','b1fa','d0aa','baba','b7b4','c7f5','bdf1','c7b0','cbab','bbb5','b0a5','bde3','c4bb','cfe8','c5d6','d9a1','b9c3','bede','d0f7','c5a4','b1ad','beed','b9cc','b5bc','b3dd','c8ca','ccd1','bbd4','d5c9','d4d9','bfe2','b6fb','ceb5','b1cc','b7fb','c5fb','b1ac','c7d7','cbae','c7dd','cef3','cbf9','c2c3','c3b4','d1ab','d6d8','bfb2','bde1','bdf7','e4c2','bea4','d1a7','b8eb','b3f4','d3d5','b5dd','bcf9','d4e2','b3d6','bcbc','d7ef','b1ea','d3e8','d4bd','d0a6','b2ed','bac4','cde0','b4c7','bcd3','cbf5','b9f3','dbcc','b2be','bbce','b1db','b9ca','d0ee','cab6','c3e2','b3c7','e6dd','c3eb','bdad','d3e1','bfa8','c9b6','b2ca','c9a8','d5d4','cdb5','d2b6','b6c3','cfe0','d7a4','bac3','d3ec','d5f9','cdf5','d2ea','c7f2','cae8','d1d6','c6ef','b4de','bbf2','cef1','bba8','b7ea','d4bf','b4b8','c4aa','cbb9','b0c4','ccf9','c0e4','d6c6','f6bf','b0d4','c0f1','c4f4','d3d1','bbcd','d7d3','b8e2','c3ab','b2a3','b8fa','c6f2','bdc6','d5bc','d2d3','b8e7','c6a1','bca8','c6d5','d4a1','b1a2','d2fd','d1b0','b1fd','b1a1','c8fd','b1b2','b1b6','b2e1','b9ad','b6b6','b0f1','b8ba','caa5','d0cf','b4f3','d6a7','bcc7','e3df','c5bf','d7b4','b1e2','c8a8','d2e5','c2f5','b2b4','b1e9','c1e8','ceb7','b0bb','b5b1','d5b9','c2b3','cdcf','d6cd','d6e9','b6bd','bee8','b9a7','bcd1','bedf','b2b8','dec3','cbe0','b7e4','b0b0','cca7','c4b9','b0b5','d9dc','c4da','d2c0','b6ab','d1f1','c4c7','c5d0','d7f9','b6ce','c7f8','bbd5','c9e7','c5d4','ceb8','d4d3','cba2','b3f0','bdac','bef5','b0b8','c4b0','b9e9','b0bd','b7ba','cea5','c3e6','bee4','bccc','d6c8','cdeb','c9ee','c0d7','b0bc','cfb5','baf6','d3d7','bfbc','c3a9','cdf2','cae2','bbf4','bea6','cdbd','b7d5','c4c6','bdc5','d6a1','ccec','c4ab','cfdc','caaf','bcfa','d5a8','bacc','d8b1','cabb','d2b0','d4d0','b7c8','c7b2','cab8','c7da','c2d8','d7f3','c4a5','babc','c1bc','cca9','cfdd','d7c8','c0e0','d7db','b4a9','c5ca','b0ba','c7d1','e5b2','f1e2','b7ae','e1af','bccb','b1ca','c1d6','ccce','c6dd','b1b5','dae3','b7e1','b1be','b7a1','b4ae','b5e3','b4cc','c5a6','cbde','b5a3','b9fd','b6b9','c3de','d3ba','d0d5','bfd7','b0d6','c7b1','d4ba','d3c7','e2bd','d7df','b5e4','cefe','b1cb','cad9','b9cb','c2ec','b7e6','ccdc','d1d7','c9d9','c0ca','c2e5','b8a7','cbbf','d7f1','b7c1','d5f1','c6d7','b6e3','c5b9','beec','c3b1','ceac','bfcb','c0c0','bdb5','d0ad','c8fc','bec5','d4b6','cdc5','b0fe','b9c5','d2cc','ebb8','bced','d2a9','cbb5','d2f8','cdb9','c9d7','d3c4','bcab','eac0','c6e1','cbe5','cdac','d5ca','d1d0','d5bd','d0a9','d3de','daa4','cfd2','ccab','b6cf','b0e1','bfcf','c8e8','b3c1','d6de','c1fd','c8af','c2e9','c4e1','b9c4','c9cf','b5ab','cbdf','cff1','bbaa','cbfe','cdd0','bee0','b1ae','d1e5','b9df','bedd','bee3','c2f2','ccbe','e7b9','d3e3','c7a9','c1be','bacd','cdb8','cfa6','d5db','b4d4','b1b4','d2a2','b9c7','c7d3','c6a5','b1f6','bbe3','c7b8','b6f4','cdf8','c2f3','d6f8','bed0','d5bf','b5ae','cbaf','d2f2','c8eb','baa2','b3e6','c5ee','cfa2','d1f6','c5e1','edb6','bbc3','b3f6','b6d9','d2cf','d7ee','b8f6','d3fe','d0ac','b6b7','b9a9','c3df','b4f8','b1bf','b7e3','bfb0','b2a5','b9c0','ecaf','e8f3','bdd7','d3cc','d5ae','c9b1','c7e9','d6c0','cfec','bde7','bcf5','bada','e5e6','d4a2','c6ec','bdf8','bedb','c6de','bfbf','bfda','c4d8','c3ba','c7c9','c4db','c0b9','beb4','b0e7','bae4','bfc3','c3c6','ccd5','d9e8','d0b6','b7ad','ceb2','d7cb','bcdd','b7b6','b5d9','d5df','c1cb','bfb4','c3fb','d0ec','b6e9','c5af','d6d1','b6c7','b8d6','bdf4','b6c8','c4a9','b4ee','b3bd','c4d0','c1a5','b1c7','bea1','eacb','ceaf','b7f0','d2a3','b7ef','d5af','d1ae','c2d2','caf6','c1e3','ccd8','cbbe','b3b9','b6dc','b6f6','d2aa','ced6','b8a8','b4e0','e4af','d0f2','d6f0','b5f6','bbe1','cbb4','c8f5','bdb9','b6d6','b1bb','d1b5','c8bd','caac','c9b5','c8b1','c3f3','bcfb','d1aa','d1b8','bead','bdf0','d7e4','b3a8','bad7','d6dc','c6ba','d3ef','c7a1','c7e7','c4cc','b5f7','d1e9','cfc5','b8f4','cece','d0c7','bfcd','c3d6','b8db','cdd1','c1ab','b6e4','b1a9','b0b6','c2df','b0a2','bcec','c9c8','bdb6','cfd3','c5f4','b6d2','c6ab','d5e3','b0dd','bee7','c9c0','bbb4','b6e8','b7c6','b8fc','c7ee','f4e9','c0c7','c1ba','c0cf','bda6','bbae','c9b3','d2b5','dce7','b8e3','beeb','b9b3','d3c3','baee','beb9','c6d3','b4e2','b6b3','cee1','b2c3','c6c2','d4be','bdf6','b7d7','d0a7','c7ef','caba','d6a3','d3ed','caab','cbe7','c1a8','c5e3','cebf','c9ab','bafb','b6a5','bbf7','e7db','bff3','c7e5','d6b8','cbc1','c9d4','cdea','cabd','d0e4','d1c7','c6da','b1a4','c8ba','b0ee','b7d4','b2ae','d2fc','b7c4','cbac','d7de','bec3','b6ed','b5a8','b7dc','b8bb','c0d5','c9c2','c6d2','b9f6','b2cb','caf8','ced4','b7b3','c3c5','d1a9','c8ed','b2f1','bfea','d1f8','bda8','d1d4','c0a3','b3ac','c8e5','c7f0','cfa5',
            'c1af','b9dc','d3c8','c0b3','b3a3','b1c6','d6a4','c1a2','d6d6','b7a2','b0d5','badb','d5e2','b3cb','d5d0','bcbb','b9d1','b9a4','c9d5','baab','c6f7','b7ac','b3c4','c2d6','bce8','d0d2','baaf','c6df','b8c5','d3d0','b3cc','b8b4','c2b5','d0a1','c3c0','c3b0','d6b3','bbef','d8a8','d0c1','cda8','d4c1','cfc3','b8ec','ebb6','bcd2','b5af','d3b9','bfcc','c1b6','c4cb','b9db','d0b9','c9bc','c6c1','b1b0','bdd6','d3e0','b8b6','caa4','d5c2','c1ed','b8ef','d3ea','c9c1','d0de','dedf','c7ea','d2db','bdcf','d3df','d4c2','cbce','b0ad','b5b9','d3c5','d1e8','d5ad','d4da','cfae','bbe4','b1a7','c8a2','c8a5','b3df','b4d9','b9f0','d7ca','bcb8','c5cb','d3dd','bac1','c2b7','d3a2','c1f8','d5fb','bebf','b6bc','bce6','b0d9','c1c2','d7c5','bfb3','d0cc','c4de','b3b4','c2c0','b1fb','cbbc','e8a1','dfe4','b9e1','c1c1','b2d5','d3fd','d2c4','d2bd','c4d1','c1d1','bac9','c0e8','bda3','c5bb','c1bf','d2d2','bbb9','b0f3','d5d5','c6eb','cfd5','c4c4','b3a4','cdbc','c6af','cfa3','d2c9','cdc2','b5cb','b2de','d6a6','b3aa','bdf5','c4ad','d6ed','e3dc','b4f7','bfb5','c3c3','cac6','e9cf','c9df','c8cc','c4c5','c7e0','ccde','c0b5','b9b6','d1b2','cdc0','d0ce','c0b2','bcf3','bab5','cfeb','cda2','cef0','bde0','bbaf','c2f7','d8b0','f4de','b3af','d6db','b4a2','bea9','b9e2','b6fa','bcd0','cec7','c1f7','ccd2','bcb0','cedd','bed5','b0f7','b5c0','b5a5','b8f0','b3cf','bfb7','d0f3','b2bf','d4a5','d6bb','c3c7','cbfd','cbc2','c5ce','f1fb','bae9','cfa4','d3fa','ceec','c8f1','d1a6','c3db','cbd8','b7f1','d7a6','cda4','d5a3','d1b6','b5d6','d3ca','b5c2','bfe4','d3f7','f6c1','d1db','cfd8','c7e3','b0da','b4c8','c9dc','b5b5','d2e2','cbd7','c8b9','b6c5','cfbf','cdaf','b9c2','c8ab','d2f9','d7aa','ccba','d9f2','cafd','d6c1','d2bc','bce9','cec5','bfd5','b9fa','f7b0','d4d6','cbad','bcc0','b0d1','e1e1','cbe9','cff2','d6da','b9fb','baec','cad2','c7d5','d9bb','c6b6','c5ac','d6d0','d0c2','b6cd','c4e4','d6ad','c6c0','bcc9','ceba','b7e7','bad0','cae5','d0ab','cbf0','b0fb','e2bb','cddf','bad5','d4bc','c9ad','b4d0','c7fa','d4ae','cfee','b0d7','c7e4','d2bb','c0f2','b8ea','f7b2','b2fb','cdbe','c5ad','cbd1','cef2','d3f9','cbf7','cdd7','bec7','cfed','c3fd','c8e2','b7bc','f3be','c8dd','b6e1','e0b6','c7ed','c2b8','c0b0','cfde','d1e0','b3fe','e2e7','c0d1','ccc6','d3b5','beaf','c8ad','c7c3','b6d4','c3f6','baf4','c6f3','cdbf','d2ce','b0b4','b2b2','d2fe','f0da','cfbd','bec0','b0c9','b6af','d1be','b9ba','d2e9','d6ec','baa1','cefb','d8ae','cab2','d2a1','f3a1','b2dd','d1ce','ccdf','bab9','b1d6','e1ea','bca2','c8c0','cea4','dae0','d4bb','d1de','b3ef','b5c7','badf','b3a5','bdd8','c3b7','cec4','c0a5','c2c9','b1ab','b8a3','cbb0','b0a8','cac0','cee8','d5c5','d0fb','decc','cadd','d6fa','c4df','b1e1','d5b0','b3fc','c7f3','d7b0','cfe5','c0ad','c1c4','bce0','d7f8','cdc3','bafe','bda1','c0b6','c6c8','bddc','cfef','b2a2','d6f1','cbb3','d6b5','b6a1','e9ad','cada','dfae','cfc4','c8db','cfb4','cdfb','b8d0','bca6','c0fb','b3f8','c2fe','d0b0','ccb7','c6d1','ccdb','b6f9','bca4','d0c6','b9e6','beaa','dcb3','d7bf','cbfb','b3c8','d6d2','bcbe','b0b7','caa3','d6c2','d1d3','b4e7','c3fc','b9b4','cdcb','c1a7','c9e0','c7d2','b1a6','c4c8','b7cf','c9ac','b0b1','ceb1','c5c0','bcfc','c5e9','d4c0','d8aa','b7bd','bbfa','b7ed','d2da','bcd6','c1e5','b8bd','c7fc','ded0','c7c7','b9b7','d4b1','bce1','cdb3','bbbb','b2e9','ceee','cccc','b0c8','c4f6','c4ee','c4ea','bfbd','c3fe','b7c2','d1fb','b3d4','b3a7','b5c4','bdbf','b9dd','d1f2','bbe8','cebd','b6ae','cee5','c1d0','daa2','b4ed','c4f1','b3a6','ccbd','d4e9','c3dc','c8ae','caa7','c5f6','bba7','b8c4','d6ba','d4ca','b2ce','d0db','c4b7','c5e4','c1b5','b0e8','b6be','bace','d7d0','c1f4','d0a2','d6dd','bbdd','b6ad','c0b4','b8f2','b4a5','bac6','d7a2','bbf0','b5cf','b6c0','ceca','b1a5','c9f9','c3d7','dbc8','d8d6','d3ee','b6d1','b7db','bad6','beae','d1dd','b8ca','b9ea','b9c9','d6ca','d9fb','d7d9','e1eb','bcee','d7dd','bdc9','bbf1','d2ae','c1ac','b1e3','d7ec','d3f4','bcc1','d1c5','c6aa','c5c4','b0c6','b0d8','cadc','c2d4','c1da','b5d4','caf4','bafa','c7bf','cfc1','d0f9','cbc8','c3e0','b6f1','d6c7','bcdf','cbcd','d4c4','c2a2','c1ec','cebe','b4b2','c9e1','d5c6','caf7','b1b1','b1d8','d2cb','b5dc','e2f9','c9a7','b4ba','c5b7','c3ce','d5c7','cfaa','cbcf','d5b4','bebb','bff1','bcca','c4b8','b0ed','b2c5','c7e6','c9a3','bfba','b7b5','c4cf','e8a7','c7f4','c9a2','c6e7','bfe7','b0cb','d2c7','d5d9','b3c6','bddd','cab9','b5b6','b8f7','caa6','bdb1','b6f8','c6f8','b2fe','c9f5','b3e2','b1e7','ccb0','cfe4','b8c8','c4c9','d8b6','b2e8','b8f1','d1d8','c8fe','b2a1','d6b0','c0ee','d2eb','b2d6','c2f4','b8c2','bbad','d4e3','ced5','c2fd','c8d5','cee4','c1a9','d0cd','c0cb','c6be','ece1','b3db','cbc7','d8e7','ddc0','bca9','eaa7','bca1','b2ab','d7a8','bec1','d1d5','d0df','b5b2','b3b7','bae0','b1f0','c6f4','bfe5','b4ef','caae','b3a9','d7ad','d6d5','cad6','b1b3','c5d2','bdc7','d2c5','c8a1','beb2','c5cc','d7a3','b5b4','cfea','c5e5','b1f5','c1f9','b0ab','c6bd','cdfa','d4c8','caca','eec4','e5e7','b8be','d7f0','bab7','c3f7','cae4','c8df','e6b0','cdf0','b6ee','d2b9','c3b5','ccbf','b7e8','c8ee','b2b0','d0af','bed9','cedb','b0a3','c7a6','c4c2','c1ae','b8b8','bbc5','d7e5','bba2','b7a8','c5e2','bbd6','bdd4','b9ec','bdd0','c5b6','b9f9','b9ab','caeb','b2dc','b6c1','c2a5','cde5','c6d4','c0c5','c9c6','b1b8','c2e6','badc','cba3','c2a7','c5d3','c2d3','d3aa','bdef','cec2','b1e6','c3a8','c6c5','b6ac','cea8','c6a4','d3e9','c3a4','bdec','c6e6','c7c5','bafd','c3f4','cce5','f5b9','b2d8','d8c3','bdaa','cec0','c0e1','c3f0','c4bf','e1dc','b0cd','bfb6','cbc0','ccfc','b1d3','bdaf','c8da','b2fd','d0b3','d0b4','b5ba','d8ce','d6c4',
            'bfdf','bbbc','bdd3','b2fa','b7b8','b0e0','ccbc','cad5','d6ce','cda6','c1c9','d1bd','d6af','c4ac','c9ce','cbd5','c9f7','c5dc','b1cf','b5c1','b2a9','b3dc','f7d4','c9f1','c6d6','b1ed','cde1','b6cc','bcba','bfc7','caf0','d3a4','eac2','d7b7','ccd3','cdf4','b0fc','c8c8','ddc2','b7fe','cfb7','b1c9','baf1','b8ae','beea','bbc6','b2cc','bbd3','bba4','c8f3','c0e6','baac','b9e7','d9a4','b8b0','c3be','b0a7','b5d2','eced','c2e7','b8b1','cde6','cab1','b8b9','d0d8','c7ac','d4d8','c9ed','cffa','bad2','bdab','b5ef','cccd','d4f5','b8d5','b1a8','c6bf','bae1','bbb7','b4fe','b3de','c1b3','cbc6','b7c3','ccfa','eeaf','c8bc','c4ce','c3e8','c6b9','c0d3','e7dd','bef8','b2ec','c8fb','b3bc','cabe','c8f4','d4b0','bbba','bfc9','b8c9','cced','d2d5','b7dd','d3f5','bfa6','d0fe','c2e8','c3f1','bba5','bfa7','baf2','b5db','d4f6','d5a5','b8a6','cbb2','c5da','becd','bbee','c0f6','d6b1','d4aa','cca5','b1c8','bfe9','c3cf','b7c9','c6cf','cede','c3ae','c9bd','c5ae','c7c8','d4ac','b4b9','b0b2','b0be','bcad','bda5','cac4','e9c5','c1f5','d1bc','caa2','d3b3','c2d7','c8c3','ccfd','cfd7','c6c6','d8e9','bfee','cdd3','b2aa','b5b0','d1b9','c9d3','bdfc','c0d6','bddb','bba9','d0f0','b5b3','b4a8','cab3','b8d2','b3b5','ccb9','b1d5','d3a5','bde4','b5fb','c8ce','caa1','c8d0','ceb9','cbe3','c9af','d0dd','d4b4','c0c3','c2f0','b2af','cfca','cab5','c0af','b7f4','d1f5','b6a7','d2a7','e7e2','e7d7','cec8','bcdc','c8e3','d6f7','c9e8','d5f6','b3e4','d2e4','b5c8','c0ef','d3d3','bfb1','ccf5','bfdb','bcc8','d0c8','b5c6','d3b0','b2b5','d2d1','bfce','d0e8','b8b5','d4c6','b7a5','dacb','c1c6','d2d0','b7ca','b7df','f7b6','f0ae','b7eb','b9ce','dcd4','baa6','cdb7','b9c1','d6b7','d0d6','b2d9','b5d0','d4fa','bbac','d7f4','d4a3','d7f6','d7e2','cae9','bfde','d8c4','bfad','c5ab','bea7','c6bb','d4f3','b8f3','b4c5','b3e7','c7ec','cad8','c5f3','b1f3','d4e0','b3f3','d4f2','b3a2','b9bb','bcb1','bbf5','d2e0','ccd6','b6c2','bde8','b4ac','b7ce','cabc','c7a7','c6e0','cfb8','c0da','d4cb','b8c7','d1c0','b1e4','beba','c8d9','c6cc','bab2','d2b3','b7f3','c5fa','c7e1','d0ca','c6fb','cef7','bdfb','b4fd','bacf','b4fc','bff7','c4cd','cef4','b4b0','cde2','b3be','b8bf','e3e3','bbb6','c1bd','c8f8','ceb4','bac0','b4bf','d2f5','d3c0','b7c5','cbbd','b4a1','bbea','b3e1','d3c2','d5d7','b3ca','c6e5','b4ca','bcc3','bfd6','bbc4','d7e6','d6f2','b7a3','d7e8','c3cb','d6b9','d8b5','d4e7','cabf','c2ed','bbd2','d1cd','f5f4','b6f3','cce6','c3e5','d7af','c7d0','b0a6','d5eb','cca4','c4d4','c7b4','c5c5','cad7','b9a8','b6d3','d2a5','b6a9','bdbb','c7b9','c1d5','c1e1','b7d1','d7dc','cdec','d1ba','c6ee','d7e9','c6ac','d7bc','b9fe','b7a6','d1af','d9dd','bcb6','d6b4','b2ee','b9b2','ceb6','cab7','cea7','cdf3','b0b3','c6b4','c5aa','c2ca','cae6','b2cf','d7da','befc','c8b0','b2c2','c1e4','c8a4','e4df','c9cb','bfd8','b5da','c7f1','d1e6','d2f3','d3cd','c3b3','ceaa','b3e9','b1da','b8e8','bbf3','b8af','b0c7','cfe9','b2b7','d3f2','c8f0','e9aa','d2d4','b4dd','d3f0','c0bc','c9fc','d1a5','c7eb','bdfe','cac1','c2eb','c2ee','cba7','beb6','bcaa','c2fb','b3f5','d5e6','b3ae','d0a3','d4f0','d1cf','bceb','d4c3','b7f2','cde4','c1b8','b1f9','c9ea','bea2','d5f3','cdc1','c8cb','d0e3','b7f9','e2e0','c9fd','d2e6','d7a1','bedc','d4ce','c8e1','d7d6','b7d8','bae2','cae7','d5d2','c4a6','d6bc','bbcb','c1ea','b1dc','cad4','b0e5','c4fe','cfa1','e2ba','c9e4','b4d2','c6e3','b3c9','bfc5','c1fa','c1a6','d6d3','cfbc','bcc6','b1a3','b5bd','c7d9','b1df','d3ce','bad8','c1b7','dbbc','b3c2','b0a1','d0d0','b5cd','cba4','b2df','c3a6','c4fd','cda3','b7c7','b4fa','ccc9','ccc0','bee5','b3bf','d3b2','d6c3','e3c9','bca3','dcde','c4d5','cbc9','b2bc','c8e7','d6fe','c0fa','c3b9','d6b2','cacf','ccf4','d2d7','b6ec','b4b4','d2f7','b4ce','b0dc','d0d4','d8b2','cea2','d1f4','b3e5','b5e7','d1f9','b5bf','d1a8','bffd','bcd9','caf3','d3af','d3ad','cffe','c0c1','bbe6','c5a3','b7b9','c8c9','cdcd','cea3','b4c4','cdbb','ccc3','b4bc','b7d6','b2d0','b5f5','d3eb','f1e7','d4b5','c9d0','c7b7','b4c0','cfcd','b5d8','c4be','b9ac','b0ef','c0f8','c8b6','cfd4','bcde','d0c4','b2c9','b8e6','baf5','bcf6','c8be','bae3','b8f8','c5d1','bac2','b6b5','c4e0','b3e0','eab0','d1ee','d3fc','d3a1','d2f4','b3eb','c4dc','cfba','cdfe','bcf2','c6fa','bcce','d3da','ced2','c3cd','cac5','c5a9','c9fa','c4a3','daa5','c9d2','c2ab','c2bd','c0db','b0ae','cfd6','dbda','b0c1','b3b3','b5a4','b5a2','d5fe','bed3','baa5','c9cd','b4d3','c6cb','cce1','ccd7','cdfc','bbd8','d3b6','bbdb','bfe0','cca8','bac7','bce4','bfac','b1c5','beca','d4f8','beb3','d2ec','c2a6','bbca','d7ed','b9d4','b5ea','cfe3','b9a6','bca5','d4b9','c5b2','d1eb','b1fe','c2b6','bacb','c6db','c6a2','bed6','d2fa','b9cd','c9cc','c1b9','b0eb','ceda','c8d3','b2f8','c4bc','b5ad','b3d8','b8c3','b6d8','bade','b6cb','d2fb','b9e5','bcdb','b8cf','e6aa','c4c3','bdbe','bdae','c4b1','cee9','b6fe','cce2','befd','b6a8','d5cf','b9b1','c4fa','b4eb','c4dd','d3c9','b7ee','c2db','d0e0','b7bf','bab6','c9f3','d3cf','c1d2','c9ba','cebb','bec8','c6e2','b2b6','b0ce','c6ae','c7ba','c4b2','d2c2','b2bd','b5a9','c5ed','d7f2','c2e3','c5b5','c2fc','b3d0','cbea','cad0','c0ed','c7f7','bfaf','b3c5','cdb6','b5c3','bce2','c7bd','d4ad','b3d1','c3bb','b6aa','ebbc','babd','cda5','c7ae','ccef','bef6','b7c0','baef','cee2','b4f4','cfc8','cff7','c8d4','c3bf','d6be','cdb4','bbe9','dbc5','c5dd','bde2','b4cb','b5f4','b3cd','d0f8','c8b7','b5ca','c8b4','c3d4','c6b1','b7e2','bbd9','d5f0','d1a1','b8d4','d1f3','b2bb','ecb3','b8a5','c3c4','dae2','d2e7','c8cf','b7e5','c5f2','d7cf','cfaf','b8f9','b9a5','c6a8','bcc4','bef9','b2e2','d5a7','d7c0','c2de','ccc7','c3d8','cff3','b2c1','b6f7','d7b3',
            'c8f2','b9d8','bec6','c7a3','cbe4','d5f7','c7d4','d4b2','d3f1','cac2','bab8','dac8','d7a5','b4d6','b1e0','d6e6','c4ef','b6e0','bac8','d4e8','c7fe','b2c6','d1da','c6b7','c0cd','bcd7','bff6','b0c2','ceeb','caa9','cecc','cddb','b2e6','b0e6','bde9','c5b0','c1aa','e5e8','cbc4','dec9','d1cc','b1e5','d0c5','cfb0','d3ae','f1c2','dbc9','cdde','d4a4','cfc2','d0dc','c3b2','c0b8','bbda','c2ef','b3b1','cbd9','d9ef','cff4','c8c5','c5ea','c5e8','c6a3','b9c8','e5c1','b1ce','bab3','b9a2','b1b7','d6ae','cacd','c3da','b5f8','b4e5','b4f2','c4bd','cbef','b8df','b1dd','d2a6','b9cf','bfe3','c0f7','b2a6','d7d4','c0ba','c0a7','b1f8','b4f5','edb2','bfaa','cbfc','c0d2','b4a6','d0d9','c0fd','d1b7','caee','c6ad','dfd0','ccf0','caec','cdf6','b4ab','d0bb','c4a7','b0a4','b9d6','c3bc','e4d6','c9db','b0aa','b2e3','d1d9','d6a2','b4e4','c3e3','cee7','b6c4','b2c4','c7bb','d5be','b4e6','c3ac','c2c1','beb5','c2fa','c4e3','bec9','d4f1','bfec','b4cf','bbfd','b4d1','ceef','d3d2','d0d1','d0cb','bbec','b0ac','b1d2','cdf9','c6f1','b4bd','c2a1','b4b6','b5fd','d3bf','d4db','cef6','c8f6','c5c2','b9d9','cfb2','b0ec','b6c9','d0c0','c1ee','cdc6','babb','d6f6','b4fb','d0ed','c2e4','d4b8','b7b1','baa3','d5f2','bcaf','d3d6','bdbc','ccca','c2c7','c4b3','c7dc','c1ce','bdf2','ccb3','cfe7','d5fd','b2a8','b2b9','c0a9','bcb4','d5dc','c1e9','c6f0','bcfe','d5b2','d6ee','cab0','cdc8','b4f0'])

URL = "http://lost-theory.org/ocrat/chargif/%s/%s.gif" # substitution 1: 'calig', 'sod', or 'bigchar'; substitution 2: EUC-CN codepoint

def _get(img_type, uni_char):
    """Returns the URL of the image of type img_type (`calig`, `sod`, or `bigchar`) for the Unicode character `uni_char`"""
    euc_cp = conversion.python_to_euc(uni_char)
    if euc_cp in _cps:
        return URL % (img_type, euc_cp)
    return None

def get_calig(uni_char):
    """Returns the URL of the caligraphy example of the Unicode character `uni_char`"""
    return _get("calig", uni_char)

def get_sod(uni_char):
    """Returns the URL of the stroke order diagram of the Unicode character `uni_char`"""
    return _get("sod", uni_char)

def get_bigchar(uni_char):
    """Returns the URL of the big character example of the Unicode character `uni_char`"""
    return _get("bigchar", uni_char)
