import datetime

from django import forms
from django.conf import settings
from django.contrib import admin
from django.contrib.admin import ModelAdmin, site
from lyrical.site_content.settings import ENABLE_BUILTIN_MEDIA, RTE_CONFIG_URI

from lyrical.site_calendar.models import SiteCalendar, SiteCalendarEvent

site.register(SiteCalendar)


class SiteCalendarEventForm(forms.ModelForm):
    repeat = forms.ChoiceField(label='Repeat', choices=SiteCalendarEvent.REPEAT_CHOICES)

    class Meta:
        model = SiteCalendarEvent
        exclude = ()

class SiteCalendarEventAdmin(ModelAdmin):
    list_display = ('title', 'calendar', 'start_date', 'repeat_human_readable', 
            'summary', 'publish_date', 'published')
    list_editable = ('published', 'start_date')
    list_filter = ('calendar', 'published', 'repeat')
    form = SiteCalendarEventForm

    def save_model(self, request, obj, form, change):
        if obj.published:
            obj.publish_date = datetime.datetime.now()
        else:
            obj.publish_date = None
        obj.save()

    if ENABLE_BUILTIN_MEDIA:
        class Media:
            css = {'all': ('site_content/css/grappelli-tinymce.css',)}
            js = (getattr(settings, 'STATIC_URL', '') + 'grappelli/tinymce/jscripts/tiny_mce/tiny_mce.js', RTE_CONFIG_URI)

site.register(SiteCalendarEvent, SiteCalendarEventAdmin)
