#coding: utf-8
'''
Модуль содержит вспомогательные функции для нумерации документов.

  Гипотетическое устройство нумерации документов. Каждый док. будет содержать 2 поля:
1. Фактический отображаемый номер, например ВХ123, 1234-Е, СЧ0001
2. Чистый номер, необходим для определения порядка следования документа: 123, 1234, 1
  Суть в том, что если фактический номер не был задан пользователем, то он генерируется по 
специальной маске (правилу) из чистого номера документа. Например для документа "Счет-фактура" и 
номера 123 можно получить номер СФ-123, а если она авансовая, то СФ-123А
'''

def get_next(query_set, num_field):
    '''
    Возвращает следующий чистый номер для множества документов заданных query_set
    @param query_set: QuerySet с фильтром
    @param num_field: название поля в объекте хранящее "чистый" номер
    '''
    assert isinstance(num_field, str)
    query = query_set.order_by('-' + num_field).only(num_field)
    try:
        obj = query[0]
    except IndexError:
        return
    return getattr(obj, num_field)
