/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Footer;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Picture;
import org.apache.poi.ss.usermodel.PrintSetup;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.util.IOUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ReportGenerator {
    static final String TOKEN_IF = "#\u0415\u0421\u041b\u0418";
    static final String TOKEN_THEN = " \u0422\u041e";
    static final String[] TOKEN_CONDITIONS = new String[]{"="};
    static final String PROP_FONT = "\u0428\u0420\u0418\u0424\u0422";
    static final String PROP_COLOR = "\u0426\u0412\u0415\u0422";
    static final HashMap<String, Short> COLOR_MAP = new HashMap();
    static final String TAG_REPEAT_START = "#\u041f\u041e\u0412\u0422\u041e\u0420\u042f\u0422\u042c\u0421\u0422\u0420\u041e\u041a\u0423";
    static final String TAG_REPEAT_END = "##\u041f\u041e\u0412\u0422\u041e\u0420\u042f\u0422\u042c\u0421\u0422\u0420\u041e\u041a\u0423";
    static final String TAG_AUTOHIGHT = "#\u0410\u0412\u0422\u041e\u0412\u042b\u0421\u041e\u0422\u0410";
    static final String TAG_MERGE = "#\u041e\u0411\u042a\u0415\u0414\u0418\u041d\u0418\u0422\u042c";
    static final String TAG_MATRIX = "#\u041c\u0410\u0422\u0420\u0418\u0426\u0410";
    static final String TAG_PICTURE = "#\u041a\u0410\u0420\u0422\u0418\u041d\u041a\u0410";
    Workbook in_book;
    CreationHelper helper;
    JSONObject root;
    Sheet in_sheet;
    Sheet out_sheet;
    CellRangeList merged_regions;
    Map<Integer, ExpandingArea> cellsToMegre = new HashMap<Integer, ExpandingArea>();
    ArrayList<CellWrap> lazyMergedCells = new ArrayList();
    Map<Cell, CellWrap> matrixCells = new HashMap<Cell, CellWrap>();
    ArrayList<Integer> unusedTagRows = new ArrayList();
    ArrayList<CellWrap> cellsWithComments = new ArrayList();
    Cell cell_repeat_tag_start = null;
    Cell cell_repeat_tag_end = null;
    static final Pattern TAG_REGEX_REPLACE = Pattern.compile("(?=[^\\@]|^)\\$.+?\\$(?=[^\\@]|$)");
    static final Pattern TAG_REGEX_NOREPLACE = Pattern.compile("[\\@].+?[\\@]");
    static final String SHEET_COPY_PREFIX = "m3_copy_";

    public static ReportGenerator createFromFiles(String encoding, String JSON_filename) throws IOException, InvalidFormatException, ParseException {
        FileInputStream fis = new FileInputStream(JSON_filename);
        InputStreamReader isr = new InputStreamReader((InputStream)fis, encoding);
        JSONParser json = new JSONParser();
        JSONObject data = (JSONObject)json.parse((Reader)isr);
        return new ReportGenerator(data);
    }

    public static ReportGenerator createFromStdin(String encoding) throws IOException, ParseException, InvalidFormatException {
        InputStreamReader isr = new InputStreamReader(System.in, encoding);
        JSONParser json = new JSONParser();
        JSONObject data = (JSONObject)json.parse((Reader)isr);
        return new ReportGenerator(data);
    }

    private ReportGenerator(JSONObject json) throws InvalidFormatException, IOException {
        Workbook book;
        String XLS_filename = (String)json.get((Object)"TEMPLATE_FILE_PATH");
        FileInputStream inp = new FileInputStream(XLS_filename);
        this.in_book = book = WorkbookFactory.create((InputStream)inp);
        this.helper = book.getCreationHelper();
        this.root = json;
        this.initializeConstants();
    }

    private void initializeConstants() {
        COLOR_MAP.put("\u041a\u0420\u0410\u0421\u041d\u042b\u0419", IndexedColors.RED.getIndex());
        COLOR_MAP.put("\u0417\u0415\u041b\u0415\u041d\u042b\u0419", IndexedColors.GREEN.getIndex());
        COLOR_MAP.put("\u0416\u0415\u041b\u0422\u042b\u0419", IndexedColors.YELLOW.getIndex());
        COLOR_MAP.put("\u0427\u0415\u0420\u041d\u042b\u0419", IndexedColors.BLACK.getIndex());
        COLOR_MAP.put("\u0421\u0418\u041d\u0418\u0419", IndexedColors.BLUE.getIndex());
    }

    private void saveSpecialCellPositions(Cell oldCell, Cell newCell) throws Exception {
        Comment comment = oldCell.getCellComment();
        if (comment != null) {
            CellWrap cw;
            String raw_text = comment.getString().getString().trim();
            String text = raw_text.toUpperCase();
            if (text.equals(TAG_REPEAT_START)) {
                this.cell_repeat_tag_start = newCell;
            } else if (text.equals(TAG_REPEAT_END)) {
                this.cell_repeat_tag_end = newCell;
            } else if (text.startsWith(TAG_MATRIX)) {
                cw = new CellWrap(newCell);
                String varName = raw_text.substring(raw_text.lastIndexOf(" ") + 1);
                cw.set("variable_name", varName);
                if (!this.matrixCells.containsKey(oldCell)) {
                    this.matrixCells.put(oldCell, cw);
                }
            } else if (text.startsWith(TAG_MERGE)) {
                CellWrap cw2;
                String num = text.substring(TAG_MERGE.length() + 1);
                Integer key = null;
                try {
                    key = Integer.parseInt(num);
                }
                catch (Exception e) {
                    throw new Exception("Number in merge tag '" + text + "' is not correct");
                }
                if (oldCell.getSheet() == newCell.getSheet()) {
                    cw2 = new CellWrap(newCell);
                    cw2.set("region_index", key);
                    this.lazyMergedCells.add(cw2);
                } else {
                    cw2 = new CellWrap(oldCell);
                    cw2.set("region_index", key);
                    this.lazyMergedCells.add(cw2);
                }
            } else if (text.startsWith("@")) {
                cw = new CellWrap(newCell);
                cw.set("text", text.substring(1));
                this.cellsWithComments.add(cw);
            }
        }
        if (oldCell.getSheet() != newCell.getSheet()) {
            for (CellWrap cw : this.lazyMergedCells) {
                if (cw.cell != oldCell) continue;
                int regionIndex = (Integer)cw.get("region_index");
                ExpandingArea values = this.cellsToMegre.get(regionIndex);
                if (values == null) {
                    values = new ExpandingArea();
                    this.cellsToMegre.put(regionIndex, values);
                }
                values.addCell(newCell);
            }
        }
    }

    private void saveUnusedTagPosition(Cell oldCell, Cell newCell) {
        String value;
        if (oldCell.getSheet() != newCell.getSheet() && newCell.getCellType() == 1 && (value = newCell.getStringCellValue()).length() > 3 && value.indexOf("%") == 0) {
            int rowNum = newCell.getRow().getRowNum();
            this.unusedTagRows.add(rowNum);
        }
    }

    private void copyCell(Cell oldCell, Cell newCell) throws Exception {
        this.saveSpecialCellPositions(oldCell, newCell);
        newCell.setCellStyle(oldCell.getCellStyle());
        switch (oldCell.getCellType()) {
            case 1: {
                newCell.setCellValue(oldCell.getStringCellValue());
                break;
            }
            case 0: {
                newCell.setCellValue(oldCell.getNumericCellValue());
                break;
            }
            case 3: {
                newCell.setCellType(3);
                break;
            }
            case 4: {
                newCell.setCellValue(oldCell.getBooleanCellValue());
                break;
            }
            case 2: {
                newCell.setCellFormula(oldCell.getCellFormula());
            }
        }
        this.saveUnusedTagPosition(oldCell, newCell);
    }

    private Range searchBeginOfRange(Row currentRow) {
        for (Cell current_cell : currentRow) {
            String cell_text;
            int pos;
            if (current_cell.getCellType() != 1 || (pos = (cell_text = current_cell.getStringCellValue()).indexOf("#")) != 0) continue;
            Range range = new Range();
            range.name = cell_text.substring(1);
            range.start_row = currentRow.getRowNum() + 1;
            range.cell_num = current_cell.getColumnIndex();
            return range;
        }
        return null;
    }

    private int searchEndOfRange(Range range, int start_row, int end_row) throws Exception {
        int row_num = start_row + 1;
        while (row_num <= end_row) {
            String cell_text;
            Cell current_cell;
            Row row = this.in_sheet.getRow(row_num);
            if (row != null && (current_cell = row.getCell(range.cell_num, Row.RETURN_BLANK_AS_NULL)) != null && current_cell.getCellType() == 1 && (cell_text = current_cell.getStringCellValue()).compareTo("##" + range.name) == 0) {
                range.end_row = row_num - 1;
                return row_num;
            }
            ++row_num;
        }
        throw new Exception("No close tag found for " + range.name);
    }

    private void copyMergedRegions(int start_orig_row, int end_orig_row, int offset) {
        for (CellRangeAddress merged_region : this.merged_regions) {
            int firstRow = merged_region.getFirstRow();
            int virtRow = start_orig_row;
            while (virtRow <= end_orig_row) {
                if (firstRow == virtRow) {
                    CellRangeAddress new_addr = merged_region.copy();
                    int h = new_addr.getLastRow() - new_addr.getFirstRow();
                    new_addr.setFirstRow(offset + new_addr.getFirstRow() - start_orig_row);
                    new_addr.setLastRow(new_addr.getFirstRow() + h);
                    this.out_sheet.addMergedRegion(new_addr);
                }
                ++virtRow;
            }
        }
    }

    private int renderRange(JSONObject obj, Range range, int write_to_row) throws Exception {
        int inserted_rows = 0;
        int start_section = range.start_row;
        int new_sector_start = write_to_row;
        int row_num = range.start_row;
        while (row_num <= range.end_row) {
            Row current_row = this.in_sheet.getRow(row_num);
            if (current_row == null) {
                ++inserted_rows;
            } else {
                Range inner_range = this.searchBeginOfRange(current_row);
                if (inner_range == null) {
                    this.copyRowWithReplace(obj, write_to_row, inserted_rows, current_row);
                    ++inserted_rows;
                } else {
                    this.copyMergedRegions(start_section, row_num, new_sector_start);
                    int end_region = this.searchEndOfRange(inner_range, row_num + 1, range.end_row);
                    JSONArray arr = (JSONArray)obj.get((Object)inner_range.name);
                    if (arr == null) {
                        throw new Exception("Cant find key " + inner_range.name + " for vertical expanding tag(#..##)");
                    }
                    int i = 0;
                    while (i < arr.size()) {
                        Object new_obj = arr.get(i);
                        int writed = this.renderRange((JSONObject)new_obj, inner_range, write_to_row + inserted_rows);
                        inserted_rows += writed;
                        ++i;
                    }
                    start_section = row_num = end_region;
                    new_sector_start = write_to_row + inserted_rows - 1;
                }
            }
            ++row_num;
        }
        this.copyMergedRegions(start_section, row_num, new_sector_start);
        return inserted_rows;
    }

    private void copyRowWithReplace(JSONObject obj, int write_to_row, int inserted_rows, Row current_row) throws Exception {
        boolean autoHeight = false;
        for (Cell current_cell : current_row) {
            Comment comm;
            Row out_row = this.out_sheet.getRow(write_to_row + inserted_rows);
            if (out_row == null) {
                out_row = this.out_sheet.createRow(write_to_row + inserted_rows);
            }
            if ((comm = current_cell.getCellComment()) != null && comm.getString().getString().toUpperCase().equals(TAG_AUTOHIGHT)) {
                autoHeight = true;
            }
            if (!autoHeight) {
                out_row.setHeight(current_row.getHeight());
            }
            Cell out_cell = out_row.getCell(current_cell.getColumnIndex(), Row.CREATE_NULL_AS_BLANK);
            this.processConditionTag(current_cell, obj);
            this.copyCell(current_cell, out_cell);
            this.processReplaceTag(out_cell, obj, "");
            this.processPictureTag(current_cell, out_cell, obj);
        }
    }

    private void processPictureTag(Cell current_cell, Cell out_cell, JSONObject obj) throws Exception {
        int pictureIdx;
        int type;
        Comment comment = current_cell.getCellComment();
        if (comment == null) {
            return;
        }
        String raw_text = comment.getString().getString().trim();
        if (!raw_text.toUpperCase().startsWith(TAG_PICTURE)) {
            return;
        }
        String key = raw_text.substring(raw_text.lastIndexOf(" ") + 1);
        String filename = (String)obj.get((Object)key);
        if (filename == null || filename.isEmpty()) {
            return;
        }
        String lowName = filename.toLowerCase();
        if (lowName.endsWith(".jpg")) {
            type = 5;
        } else if (lowName.endsWith(".jpeg")) {
            type = 5;
        } else if (lowName.endsWith(".png")) {
            type = 6;
        } else if (lowName.endsWith(".bmp")) {
            type = 7;
        } else {
            throw new Exception("Unknown image format. Supported only jpg, png, bmp");
        }
        try {
            FileInputStream is = new FileInputStream(filename);
            byte[] bytes = IOUtils.toByteArray(is);
            pictureIdx = this.in_book.addPicture(bytes, type);
            ((InputStream)is).close();
        }
        catch (IOException e) {
            throw new Exception("Could not load picture '" + filename + "' for tag '" + key + "' with error: " + e.getMessage());
        }
        Sheet sheet = out_cell.getSheet();
        Drawing drawing = sheet.createDrawingPatriarch();
        ClientAnchor anchor = this.helper.createClientAnchor();
        anchor.setCol1(out_cell.getColumnIndex());
        anchor.setRow1(out_cell.getRowIndex());
        Picture pict = drawing.createPicture(anchor, pictureIdx);
        pict.resize();
    }

    private void processConditionTag(Cell outCell, JSONObject obj) throws Exception {
        boolean has_token_if;
        Comment comm = outCell.getCellComment();
        if (comm == null) {
            return;
        }
        String comment_text = comm.getString().getString();
        boolean bl = has_token_if = comment_text.length() > 5 && comment_text.toUpperCase().startsWith(TOKEN_IF);
        if (!has_token_if) {
            return;
        }
        int token_if_index = comment_text.toUpperCase().indexOf(TOKEN_THEN);
        if (has_token_if && token_if_index < 0) {
            throw new Exception("Token #\u0415\u0421\u041b\u0418 found but token  \u0422\u041e not found.");
        }
        String condition_text = comment_text.substring(TOKEN_THEN.length() + 3, token_if_index);
        String properties_text = comment_text.substring(token_if_index + TOKEN_THEN.length());
        int condition_index = 0;
        int condition_token_len = 0;
        String[] stringArray = TOKEN_CONDITIONS;
        int n = TOKEN_CONDITIONS.length;
        int n2 = 0;
        while (n2 < n) {
            String cond = stringArray[n2];
            condition_index = condition_text.indexOf(cond);
            if (condition_index > 0) {
                condition_token_len = cond.length();
                break;
            }
            ++n2;
        }
        if (condition_index == 0) {
            throw new Exception("Condition not found!");
        }
        String operand1 = condition_text.substring(0, condition_index);
        Object value = obj.get((Object)operand1);
        if (value == null) {
            throw new Exception("Not found value for variable " + operand1);
        }
        operand1 = value.toString();
        String operand2 = condition_text.substring(condition_index + condition_token_len);
        boolean equal = false;
        try {
            int value1 = Integer.parseInt(operand1);
            int value2 = Integer.parseInt(operand2);
            if (value1 == value2) {
                equal = true;
            }
        }
        catch (Exception e) {
            try {
                boolean value1 = Boolean.parseBoolean(operand1);
                boolean value2 = Boolean.parseBoolean(operand2);
                if (value1 == value2) {
                    equal = true;
                }
            }
            catch (Exception ex) {
                try {
                    if (operand1.equals(operand2)) {
                        equal = true;
                    }
                }
                catch (Exception exc) {
                    throw new Exception("Not comparable operands " + operand1 + " and " + operand2);
                }
            }
        }
        if (equal) {
            String[] properties;
            String[] stringArray2 = properties = properties_text.split(",");
            int n3 = properties.length;
            int n4 = 0;
            while (n4 < n3) {
                String prop = stringArray2[n4];
                String[] lex = prop.replaceAll(" ", "").split(":");
                if (lex.length != 2) {
                    throw new Exception("Invalid property definition " + prop);
                }
                this.processCellProperty(outCell, lex[0], lex[1]);
                ++n4;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processCellProperty(Cell outCell, String property, String value) throws Exception {
        Workbook wb = outCell.getSheet().getWorkbook();
        CellStyle new_style = wb.createCellStyle();
        new_style.cloneStyleFrom(outCell.getCellStyle());
        Font new_font = this.clone_font(wb, wb.getFontAt(new_style.getFontIndex()));
        if (property.equals(PROP_COLOR)) {
            Short color = COLOR_MAP.get(value);
            if (color == null) {
                throw new Exception("Unknown color " + value);
            }
            new_font.setColor(color);
        } else {
            if (!property.equals(PROP_FONT)) throw new Exception("Unknown property " + property);
            if (value.equals("\u0416\u0418\u0420\u041d\u042b\u0419")) {
                new_font.setBoldweight((short)700);
            } else if (value.equals("\u041f\u041e\u0414\u0427\u0415\u0420\u041a\u041d\u0423\u0422\u042b\u0419")) {
                new_font.setUnderline((byte)1);
            } else {
                if (!value.equals("\u0417\u0410\u0427\u0415\u0420\u041a\u041d\u0423\u0422\u042b\u0419")) throw new Exception("Unknown property value " + value);
                new_font.setStrikeout(true);
            }
        }
        new_style.setFont(new_font);
        outCell.setCellStyle(new_style);
    }

    private Font clone_font(Workbook wb, Font font) {
        Font new_font = wb.createFont();
        new_font.setBoldweight(font.getBoldweight());
        new_font.setCharSet(font.getCharSet());
        new_font.setColor(font.getColor());
        new_font.setFontHeight(font.getFontHeight());
        new_font.setFontHeightInPoints(font.getFontHeightInPoints());
        new_font.setFontName(font.getFontName());
        new_font.setItalic(font.getItalic());
        new_font.setStrikeout(font.getStrikeout());
        new_font.setTypeOffset(font.getTypeOffset());
        new_font.setUnderline(font.getUnderline());
        return new_font;
    }

    private String getTypeTagFromString(String value) {
        if (value.length() >= 6 && value.substring(0, 3).equals("#m3") && value.charAt(5) == '#') {
            return value.substring(3, 5);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setCellValue(Cell outCell, Object value) throws Exception {
        String str_value = value.toString();
        if (value.getClass() == String.class) {
            String inner_type = this.getTypeTagFromString(str_value);
            if (inner_type != null) {
                str_value = str_value.substring(6);
                if (inner_type.equals("dd")) {
                    Date d = DateFormat.getDateInstance(3, Locale.GERMANY).parse(str_value);
                    outCell.setCellValue(d);
                    return;
                } else if (inner_type.equals("tt")) {
                    Date d = DateFormat.getTimeInstance(3, Locale.GERMANY).parse(str_value);
                    outCell.setCellValue(d);
                    return;
                } else {
                    if (!inner_type.equals("dt")) throw new Exception("Unknown M3 type token " + str_value);
                    Date d = DateFormat.getDateTimeInstance(3, 3).parse(str_value);
                    outCell.setCellValue(d);
                }
                return;
            } else {
                outCell.setCellValue(str_value);
            }
            return;
        } else if (value.getClass() == Long.class) {
            outCell.setCellValue(Long.parseLong(str_value));
            return;
        } else if (value.getClass() == Double.class) {
            outCell.setCellValue(Double.parseDouble(str_value));
            return;
        } else {
            if (value.getClass() != Boolean.class) return;
            outCell.setCellValue(Boolean.parseBoolean(str_value));
        }
    }

    private void processReplaceTag(Cell outCell, JSONObject obj, String token_prefix) throws Exception {
        String token;
        Object value;
        if (outCell.getCellType() != 1) {
            return;
        }
        String cell_text = outCell.getStringCellValue();
        Matcher m = TAG_REGEX_REPLACE.matcher(cell_text);
        HashMap<String, Object> keys = new HashMap<String, Object>();
        while (m.find()) {
            String token2 = m.group();
            String key = token2.substring(1, token2.length() - 1);
            if (token_prefix.length() > 0) {
                if (key.indexOf(token_prefix) != 0) continue;
                key = key.substring(token_prefix.length());
            }
            if ((value = obj.get((Object)key)) == null) {
                value = "";
            }
            keys.put(token2, value);
        }
        Matcher m2 = TAG_REGEX_NOREPLACE.matcher(cell_text);
        while (m2.find()) {
            token = m2.group();
            String key = token.substring(1, token.length() - 1);
            cell_text = cell_text.replace(token, key);
        }
        if (keys.isEmpty()) {
            outCell.setCellValue(cell_text);
            return;
        }
        if (keys.size() == 1) {
            token = keys.keySet().toArray()[0].toString();
            value = keys.get(token);
            if (cell_text.length() == token.length()) {
                this.setCellValue(outCell, value);
                return;
            }
        }
        for (Map.Entry entry : keys.entrySet()) {
            String token3 = (String)entry.getKey();
            String str_value = entry.getValue().toString();
            if (this.getTypeTagFromString(str_value) != null) {
                str_value = str_value.substring(6);
            }
            cell_text = cell_text.replace(token3, str_value);
        }
        outCell.setCellValue(cell_text);
    }

    public Sheet createShadowSheet(Sheet in_sheet) {
        Sheet out_sheet = this.in_book.createSheet(SHEET_COPY_PREFIX + in_sheet.getSheetName());
        int i = 0;
        while (i < 256) {
            int width = in_sheet.getColumnWidth(i);
            out_sheet.setColumnWidth(i, width);
            ++i;
        }
        out_sheet.setAutobreaks(in_sheet.getAutobreaks());
        out_sheet.setDisplayFormulas(in_sheet.isDisplayFormulas());
        out_sheet.setDisplayGridlines(in_sheet.isDisplayGridlines());
        out_sheet.setDisplayZeros(in_sheet.isDisplayZeros());
        out_sheet.setDisplayRowColHeadings(in_sheet.isDisplayRowColHeadings());
        out_sheet.setMargin((short)2, in_sheet.getMargin((short)2));
        out_sheet.setMargin((short)3, in_sheet.getMargin((short)3));
        out_sheet.setMargin((short)0, in_sheet.getMargin((short)0));
        out_sheet.setMargin((short)1, in_sheet.getMargin((short)1));
        PrintSetup out_print = out_sheet.getPrintSetup();
        PrintSetup in_print = in_sheet.getPrintSetup();
        out_print.setCopies(in_print.getCopies());
        out_print.setDraft(in_print.getDraft());
        out_print.setFitHeight(in_print.getFitHeight());
        out_print.setFitWidth(in_print.getFitWidth());
        out_print.setFooterMargin(in_print.getFooterMargin());
        out_print.setHeaderMargin(in_print.getHeaderMargin());
        out_print.setHResolution(in_print.getHResolution());
        out_print.setLandscape(in_print.getLandscape());
        out_print.setLeftToRight(in_print.getLeftToRight());
        out_print.setNoColor(in_print.getNoColor());
        out_print.setNoOrientation(in_print.getNoOrientation());
        out_print.setNotes(in_print.getNotes());
        out_print.setPageStart(in_print.getPageStart());
        out_print.setPaperSize(in_print.getPaperSize());
        out_print.setScale(in_print.getScale());
        out_print.setVResolution(in_print.getVResolution());
        Footer in_foot = in_sheet.getFooter();
        Footer out_foot = out_sheet.getFooter();
        out_foot.setCenter(in_foot.getCenter());
        out_foot.setLeft(in_foot.getLeft());
        out_foot.setRight(in_foot.getRight());
        return out_sheet;
    }

    private CellRangeList getMergedRegions(Sheet sheet) {
        CellRangeAddress addr;
        CellRangeList merged_cells = new CellRangeList();
        int i = 0;
        while ((addr = sheet.getMergedRegion(i)) != null) {
            merged_cells.add(addr);
            ++i;
        }
        return merged_cells;
    }

    private void horizontalShift(Sheet sheet, int start_row, int end_row, int start_col, int offset) throws Exception {
        int row_num = start_row;
        while (row_num <= end_row) {
            Row current_row = sheet.getRow(row_num);
            if (current_row != null) {
                short last_col;
                short col_num = last_col = current_row.getLastCellNum();
                while (col_num >= start_col) {
                    Cell current_cell = current_row.getCell(col_num);
                    if (current_cell != null) {
                        Cell new_cell = this.safeGetCell(sheet, row_num, col_num + offset);
                        this.copyCell(current_cell, new_cell);
                    }
                    col_num = (short)(col_num - 1);
                }
            }
            ++row_num;
        }
    }

    private Cell safeGetCell(Sheet destSheet, int row_num, int col_num) {
        Cell c;
        Row r = destSheet.getRow(row_num);
        if (r == null) {
            r = destSheet.createRow(row_num);
        }
        if ((c = r.getCell(col_num)) == null) {
            c = r.createCell(col_num);
        }
        return c;
    }

    private void copyRegion(SheetRegion sourceRegion, Sheet sourceSheet, Sheet destSheet, int row_offset, int col_offset) throws Exception {
        int col_num;
        int row_num = sourceRegion.start_row;
        while (row_num <= sourceRegion.end_row) {
            Row current_row = sourceSheet.getRow(row_num);
            if (current_row != null) {
                col_num = sourceRegion.start_col;
                while (col_num <= sourceRegion.end_col) {
                    Cell current_cell = current_row.getCell(col_num, Row.CREATE_NULL_AS_BLANK);
                    int y = row_offset + row_num - sourceRegion.start_row;
                    int x = col_offset + col_num - sourceRegion.start_col;
                    Cell destCell = this.safeGetCell(destSheet, y, x);
                    this.copyCell(current_cell, destCell);
                    ++col_num;
                }
            }
            ++row_num;
        }
        CellRangeList mregions = this.getMergedRegions(sourceSheet);
        int row_num2 = sourceRegion.start_row;
        while (row_num2 <= sourceRegion.end_row) {
            col_num = sourceRegion.start_col;
            while (col_num <= sourceRegion.end_col) {
                for (CellRangeAddress reg : mregions) {
                    if (reg.getFirstRow() != row_num2 || reg.getFirstColumn() != col_num) continue;
                    int delta_y = row_offset - sourceRegion.start_row;
                    int delta_x = col_offset - sourceRegion.start_col;
                    CellRangeAddress new_nreg = new CellRangeAddress(reg.getFirstRow() + delta_y, reg.getLastRow() + delta_y, reg.getFirstColumn() + delta_x, reg.getLastColumn() + delta_x);
                    destSheet.addMergedRegion(new_nreg);
                }
                ++col_num;
            }
            ++row_num2;
        }
    }

    private void processTagsInRegion(Sheet sheet, SheetRegion region, JSONObject obj, String token_prefix) throws Exception {
        int row_num = region.start_row;
        while (row_num <= region.end_row) {
            Row row = sheet.getRow(row_num);
            if (row != null) {
                int col_num = region.start_col;
                while (col_num <= region.end_col) {
                    Cell cell = row.getCell(col_num);
                    if (cell != null) {
                        this.processReplaceTag(cell, obj, String.valueOf(token_prefix) + '.');
                    }
                    ++col_num;
                }
            }
            ++row_num;
        }
    }

    private void grow_horizontal_regions() throws Exception {
        Cell start_cell;
        int start_scan_row = 0;
        while ((start_cell = this.Scan(this.in_sheet, start_scan_row, -1, -1, -1, "%", false, TagMatchMode.FIRST)) != null) {
            String[] strs = start_cell.getStringCellValue().split(" ");
            String tag_key = strs[0].substring(1);
            SheetRegion tag_region = new SheetRegion();
            tag_region.start_row = start_cell.getRowIndex() + 1;
            tag_region.start_col = start_cell.getColumnIndex();
            tag_region.end_col = tag_region.start_col + Integer.parseInt(strs[1]) - 1;
            String tag = start_cell.getStringCellValue();
            Cell end_cell = this.Scan(this.in_sheet, tag_region.start_row, -1, tag_region.start_col, tag_region.start_col, "%" + tag, false, TagMatchMode.STRICT);
            if (end_cell == null) {
                throw new Exception("End of region " + tag + " not found");
            }
            tag_region.end_row = end_cell.getRowIndex() - 1;
            JSONArray arr = (JSONArray)this.root.get((Object)tag_key);
            if (arr == null) {
                throw new Exception("Data not found for tag key " + tag_key);
            }
            int size = arr.size() - 1;
            int offset = size * (tag_region.end_col - tag_region.start_col + 1);
            this.horizontalShift(this.in_sheet, tag_region.start_row, tag_region.end_row, tag_region.end_col + 1, offset);
            int i = 0;
            while (i < size) {
                int col_offset = tag_region.end_col + i * (tag_region.end_col - tag_region.start_col + 1) + 1;
                this.copyRegion(tag_region, this.in_sheet, this.in_sheet, tag_region.start_row, col_offset);
                ++i;
            }
            String token_prefix = tag_key;
            int i2 = 0;
            while (i2 < size + 1) {
                JSONObject obj = (JSONObject)arr.get(i2);
                this.processTagsInRegion(this.in_sheet, tag_region, obj, token_prefix);
                tag_region = tag_region.shift(0, tag_region.end_col - tag_region.start_col + 1);
                ++i2;
            }
            start_scan_row = tag_region.end_row + 2;
        }
    }

    private Cell Scan(Sheet sheet, int start_row, int end_row, int start_col, int end_col, String token, boolean in_comments, TagMatchMode mode) {
        int srow = start_row;
        if (start_row < 0) {
            srow = sheet.getFirstRowNum();
        }
        int erow = end_row;
        if (end_row < 0) {
            erow = sheet.getLastRowNum();
        }
        int row_num = srow;
        while (row_num <= erow) {
            block10: {
                int ecol;
                Row row = sheet.getRow(row_num);
                if (row == null) break block10;
                int scol = start_col;
                if (scol < 0) {
                    scol = row.getFirstCellNum();
                }
                if ((ecol = end_col) < 0) {
                    ecol = row.getLastCellNum();
                }
                int col_num = scol;
                while (col_num <= ecol) {
                    block11: {
                        String text;
                        Cell cell;
                        block13: {
                            block12: {
                                cell = row.getCell(col_num);
                                if (cell == null) break block11;
                                text = "";
                                if (!in_comments) break block12;
                                Comment comm = cell.getCellComment();
                                if (comm == null) break block11;
                                text = comm.getString().getString();
                                break block13;
                            }
                            if (cell.getCellType() != 1) break block11;
                            text = cell.getStringCellValue();
                        }
                        if (mode == TagMatchMode.STRICT ? text.toUpperCase().equals(token.toUpperCase()) : mode == TagMatchMode.FIRST && text.startsWith(token)) {
                            return cell;
                        }
                    }
                    ++col_num;
                }
            }
            ++row_num;
        }
        return null;
    }

    public void setRepeatedArea(ArrayList<RepeatCells> repeat_cells) {
        for (RepeatCells rc : repeat_cells) {
            if (rc.start_cell == null) continue;
            Area area = new Area();
            if (rc.end_cell != null) {
                area.start_row = rc.start_cell.getRowIndex();
                area.end_row = rc.end_cell.getRowIndex();
            } else {
                area.start_row = rc.start_cell.getRowIndex();
                area.end_row = rc.start_cell.getRowIndex();
            }
            int shi = this.in_book.getSheetIndex(rc.sheet);
            this.in_book.setRepeatingRowsAndColumns(shi, area.start_col, area.end_col, area.start_row, area.end_row);
        }
    }

    private void clean_unused_tags(Sheet sheet) {
        Collections.sort(this.unusedTagRows);
        int i = this.unusedTagRows.size() - 1;
        while (i >= 0) {
            int row_num = this.unusedTagRows.get(i);
            if (row_num == sheet.getLastRowNum()) {
                sheet.createRow(row_num + 1);
            }
            sheet.shiftRows(row_num + 1, sheet.getLastRowNum(), -1);
            --i;
        }
    }

    private void imposeMatrix(Sheet outSheet, JSONObject root, Collection<CellWrap> matrixCells) throws Exception {
        this.merged_regions = this.getMergedRegions(this.out_sheet);
        for (CellWrap cw : matrixCells) {
            String key = (String)cw.get("variable_name");
            JSONArray rowArray = (JSONArray)root.get((Object)key);
            if (rowArray == null) continue;
            CellRangeAddress lastMergedRow = null;
            int rowNum = cw.cell.getRowIndex() - 1;
            for (Object row : rowArray) {
                int colNum = cw.cell.getColumnIndex();
                CellRangeAddress curRegion = null;
                while ((curRegion = this.merged_regions.isInRanges(colNum, ++rowNum)) != null & curRegion == lastMergedRow) {
                }
                lastMergedRow = curRegion;
                CellRangeAddress lastMergedCol = null;
                JSONArray currentRow = (JSONArray)row;
                for (Object value : currentRow) {
                    Cell outCell = this.safeGetCell(outSheet, rowNum, colNum);
                    this.setCellValue(outCell, value);
                    while ((curRegion = this.merged_regions.isInRanges(++colNum, rowNum)) != null & curRegion == lastMergedCol) {
                    }
                    lastMergedCol = curRegion;
                }
            }
        }
    }

    private void createCellComments(Sheet sheet) {
        if (this.cellsWithComments.isEmpty()) {
            return;
        }
        Drawing drawing = sheet.createDrawingPatriarch();
        for (CellWrap cw : this.cellsWithComments) {
            Cell cell = cw.cell;
            Row row = cell.getRow();
            String text = (String)cw.get("text");
            ClientAnchor anchor = this.helper.createClientAnchor();
            anchor.setCol1(cell.getColumnIndex());
            anchor.setCol2(cell.getColumnIndex() + 3);
            anchor.setRow1(row.getRowNum());
            anchor.setRow2(row.getRowNum() + 3);
            Comment comment = drawing.createCellComment(anchor);
            RichTextString str = this.helper.createRichTextString(text);
            comment.setString(str);
            cell.setCellComment(comment);
        }
    }

    public void generate() throws Exception {
        String active_sheet_name = this.in_book.getSheetName(this.in_book.getActiveSheetIndex());
        ArrayList<RepeatCells> repeat_cells = new ArrayList<RepeatCells>();
        ArrayList<String> orig_sheets_names = new ArrayList<String>();
        int sheet_index = 0;
        while (sheet_index < this.in_book.getNumberOfSheets()) {
            orig_sheets_names.add(this.in_book.getSheetName(sheet_index));
            ++sheet_index;
        }
        int sheet_count = this.in_book.getNumberOfSheets();
        int sheet_index2 = 0;
        while (sheet_index2 < sheet_count) {
            this.cell_repeat_tag_start = null;
            this.cell_repeat_tag_end = null;
            this.cellsToMegre.clear();
            this.lazyMergedCells.clear();
            this.matrixCells.clear();
            this.unusedTagRows.clear();
            this.cellsWithComments.clear();
            this.in_sheet = this.in_book.getSheetAt(sheet_index2);
            this.out_sheet = this.createShadowSheet(this.in_sheet);
            this.grow_horizontal_regions();
            this.merged_regions = this.getMergedRegions(this.in_sheet);
            Range range = new Range();
            range.start_row = this.in_sheet.getFirstRowNum();
            range.end_row = this.in_sheet.getLastRowNum();
            this.renderRange(this.root, range, range.start_row);
            for (Map.Entry<Integer, ExpandingArea> entry : this.cellsToMegre.entrySet()) {
                ExpandingArea area = entry.getValue();
                CellRangeAddress cra = new CellRangeAddress(area.start_row, area.end_row, area.start_col, area.end_col);
                this.out_sheet.addMergedRegion(cra);
            }
            this.imposeMatrix(this.out_sheet, this.root, this.matrixCells.values());
            repeat_cells.add(new RepeatCells(this.out_sheet, this.cell_repeat_tag_start, this.cell_repeat_tag_end));
            this.clean_unused_tags(this.out_sheet);
            this.createCellComments(this.out_sheet);
            ++sheet_index2;
        }
        for (String sh : orig_sheets_names) {
            this.in_book.removeSheetAt(this.in_book.getSheetIndex(sh));
        }
        sheet_index = 0;
        while (sheet_index < this.in_book.getNumberOfSheets()) {
            String name = this.in_book.getSheetName(sheet_index);
            name = name.substring(SHEET_COPY_PREFIX.length());
            this.in_book.setSheetName(sheet_index, name);
            ++sheet_index;
        }
        this.setRepeatedArea(repeat_cells);
        this.in_book.setActiveSheet(this.in_book.getSheetIndex(active_sheet_name));
        this.in_book.setSelectedTab(this.in_book.getSheetIndex(active_sheet_name));
        String outfile = (String)this.root.get((Object)"OUTPUT_FILE_PATH");
        FileOutputStream fileOut = new FileOutputStream(outfile);
        this.in_book.write(fileOut);
        fileOut.close();
    }
}

