#coding: utf-8

import os
import json
import codecs
import pickle
import shutil
import datetime

from django.shortcuts import render_to_response

from m3_designer.ide.codeassist import get_code_proposals
from m3_designer.ide.helpers import JsonResponse, get_files, get_classess, restores, create_py_class, \
    create_generation_func, get_methods, create_cont_func
from m3_designer.ide.helpers import create_structure_node
from m3_designer.ide.parser import Parser, ParserError, UndefinedGeneratedFunc

def workspace(request):
    '''
    Отдается основной шаблон. Точка входа.
    '''

    path_project = os.getenv('PROJECT_FOR_DESIGNER', None)
    base_name = os.path.basename(path_project)
    return render_to_response('master.html', {
        'data_url' : '/designer/fake',
        'save_url' : '/designer/save',
        'project_name': base_name,
        'preview_url':'/designer/preview'
    })

def get_project_files(request):
    '''
    Отдает файлы рабочего проекта как узлы дерева
    '''

    type = request.POST.get('type')
    if type == 'ui-file':
        ui_classes = get_classess(request.POST.get('path'))
        return JsonResponse(ui_classes)
    elif type == 'ui-class':
        ui_methods = get_methods(request.POST.get('path'), request.POST.get('class_name'))
        return JsonResponse(ui_methods)
    else:
        path_project = os.getenv('PROJECT_FOR_DESIGNER', None)
        abs_path_project = os.path.abspath(path_project)
        project_files = get_files(abs_path_project)
        base_name = os.path.basename(path_project)
        dependency = os.getenv('PROJECT_FOR_DESIGNER_DEPENDENCY', None)

        if dependency is not None:
            result = []
            result.append(create_structure_node(base_name, project_files, True, abs_path_project))
            requires = pickle.loads(dependency)

            for k,v in requires['requires_local'].iteritems():
                contrib_path = os.path.join(v,'src',k)
                contrib_path_abs = os.path.abspath(contrib_path)
                contrib_files = get_files(contrib_path_abs)
                result.append(create_structure_node(k, contrib_files, True, contrib_path_abs))

            for k,v in requires['requires'].iteritems():
                #TODO показывать для ридонли файлы из env
                pass

            return JsonResponse(result)
        else:
            return JsonResponse(project_files)

def designer(request):
    return render_to_response('designer.html', {
        'data_url' : '/designer/fake',
        'save_url' : '/designer/save',
        'code_preview_url' : '/designer/preview'
    })

def designer_preview(request):
    '''
    Вьюшка для preview
    '''
    data = request.POST.get('data')
    js = json.loads(data)
    restores(js['model'])
    
    try:
        py_code = Parser.from_designer_preview(js['model'])
    except ParserError, e:
        return JsonResponse({'success': False, 'json':repr(e)})
    
    return JsonResponse({'success': True, 'json':py_code})

def designer_fake_data(request):
    '''
    Вьюшка для показа формы (fake)
    '''

    data = {
            'title':'Test window',
            'layout':'form',
            'type':'window',
            'id':'self'
        }

    res = {'success':True, 'json':data}
    return JsonResponse(res)

def designer_data(request):
    '''
    Вьюшка для показа формы
    '''

    class_name = request.GET.get('className')
    path = request.GET.get('path')
    
    assert class_name, 'Class name is undefined'
    assert path, 'Path to source file is undefined'
    
    try:
        result = Parser(path, class_name, request.GET.get('funcName')).to_designer()
    except UndefinedGeneratedFunc, e:    
        return JsonResponse({'success': True, 'not_autogenerated': True})
    except ParserError, e:                
        return JsonResponse({'success': False, 'json': repr(e)})
        
    return JsonResponse({'success': True, 'json':result})

def designer_save(request):
    '''
    Вьюшка для сохранения формы
    '''
    class_name = request.POST.get('className')
    path = request.POST.get('path')
    data = request.POST.get('data')    

    assert class_name, 'Class name is undefined'
    assert path, 'Path to source file is undefined'

    js = json.loads(data)    
    restores(js['model'])
    
    # js['model'] -- Конфигурация для отображение в py    
    try:
        Parser(path, class_name, request.POST.get('funcName')).from_designer(js['model'])
    except ParserError, e:
        return JsonResponse({'success': False, 'json': repr(e)})
    return JsonResponse({'success': True})

def create_class(request):
    '''
    Создание нового класса
    '''    
    class_name = request.POST.get('className')
    path = request.POST.get('path')    

    assert class_name, 'Class name is undefined'
    assert path, 'Path to source file is undefined'
    
    try:
        create_py_class(path, class_name)
    except ParserError, e:
        return JsonResponse({'success': False, 'json': unicode(e)})
    
    return JsonResponse({'success': True})

def designer_file_content(request):
    '''
    Вьюшка для отдачи содержимого файла
    '''
    path = request.GET.get('path')
    assert path, 'Path to source file is undefined'
    print path
    with codecs.open( path, "r", "utf-8" ) as f:
        result = f.read()
    
    return JsonResponse({'success': True, 'data':{'content':result}})

def designer_global_template_content(request):
    '''
    Вьюшка для чтения/записи содержимого файлов templateGlobals
    '''
    path = request.GET.get('path')
    f = request.GET.get('file')
    crate_new = int(request.GET.get('crateNew')) #binnary bool

    assert path, 'Path to source is undefined'
    assert f, 'file is undefined'
    
    template_globals_path = os.path.join(os.path.dirname(path), 'templates')
    #Если нет директории создадим её
    if not os.path.exists(template_globals_path):
        os.mkdir(template_globals_path)
    path = os.path.join(template_globals_path, f)

    success = True
    error = ''
    content = ''

    if not os.path.exists(path):
        if crate_new:
            dt_str = datetime.datetime.strftime(datetime.datetime.now(), '%d.%m.%Y %H:%m')
            with codecs.open(path, "wb", "utf-8" ) as f:
                f.write("/*Created by M3 IDE, at %s*/" % dt_str)
            with codecs.open(path, "rb", "utf-8" ) as f:
                content = f.read()
        else:
            error = u'notExists'
            success = False
    else:
        with codecs.open(path, "rb", "utf-8" ) as f:
            content = f.read()

    return JsonResponse({'success': success, 'error': error,
                         'data':{
                             'content':content,
                             'dir': template_globals_path,
                             'path':path
                         }
    })

def designer_file_content_save(request):
    '''
    Вьюшка сохраняет изменения
    '''
    path = request.POST.get('path')
    content = request.POST.get('content')

    assert path, 'Path to source file is undefined'

    success = False
    error =''

    try:
        f_line = open(path, 'rb').readline()
        
        with codecs.open( path, 'w' if '\r' in f_line else 'wb') as f:
            f.write(content.encode('utf-8'))
            success = True
    except IOError as (errno, strerror):
        error =  "I/O error({0}): {1}".format(errno, strerror)

    return JsonResponse({'success': success, 'error': error})

def create_initialize(request):
    '''
    Генерирует функции для работы дизайнера
    '''
    class_name = request.POST.get('className')
    path = request.POST.get('path')

    try:
        create_generation_func(path, class_name)
    except ParserError, e:
        return JsonResponse({'success': False, 'json': unicode(e)})
    else:
        return JsonResponse({'success': True})

def designer_structure_manipulation(request):
    '''
    Производит манипуляции над структурой проекта
    path ( путь к объекту )
    action: delete, rename, new ( Действия )
    error ( Ошибка, произошедшая во время выполения )
    success ( Результат )
    Действия производятся как над файлами так и над директориями.
    '''
    #Типы
    type_file = 'file'
    type_dir = 'folder'
    #Действия
    action_delete = 'delete'
    action_rename = 'rename'
    action_new = 'new'
    #Виды ошибок
    error_type_exist = 'exist'
    error_type_internal = 'internal'
    
    success = False
    error = {}
    data = {}

    path = request.POST.get('path')
    assert path, 'Path to source file is undefined'

    action = request.POST.get('action')
    assert action, 'Аction to target is undefined'

    type = request.POST.get('type')
    assert type, 'Type is undefined'

    #Доступ на перезапись, удаление директорий с фалами или подпапками
    name = request.POST.get('name','')

    dirpath = os.path.split(path)[0] # path head & tail
    current_path = os.path.join(path if os.path.isdir(path) else dirpath, name)

    if ( action == action_new or action == action_rename) and os.path.exists(current_path):
        error = {'msg':name+u' уже существует', 'type': error_type_exist}
        return JsonResponse({'success': success, 'error': error})
    try:
        # Создание новых файлов, директорий
        if action == action_new:
            # Если файл создается в директории то проверяем именно в ней
            if os.path.isdir(path) and type == type_file:
                current_path = os.path.join(path, name)

            #Создаем новую директорию
            if type == type_dir:
                if os.path.isdir(path):
                    current_path = os.path.join(path, name)
                    os.mkdir(current_path)
                else:
                    os.mkdir(current_path)
                success = True
                data = {'path':current_path}

            #Создаем новый файл
            elif type == type_file:
                with codecs.open( current_path, "wb", "utf-8" ) as f:
                    f.write("#coding: utf-8")
                success = True
                data = {'path':current_path}

        # Удаление файлов, директорий
        elif action == action_delete:
            if os.path.isdir(path):
                #Удалается включая подпапки и файлы
                shutil.rmtree(path)
                success = True
            else:
                os.remove(path)
                success = True

        # Переименование файлов, директорий
        elif action == action_rename:
            #Хак т.к в виндах падает ошибка при попытке переименовать в сущ. файл
            if os.sys.platform =='win32':
                if os.path.isdir(current_path):
                    shutil.rmtree(current_path)
                else:
                    os.remove(current_path)
            #Файлы и Директории
            os.rename(path, current_path)
            success = True

    except OSError as (errno, strerror):
        if os.sys.platform =='win32':
            strerror = strerror.decode('cp1251')
        error =  {'msg':u"OSError error({0}): {1}".format(errno, strerror),
                'type':error_type_internal}

    return JsonResponse({'success': success, 'data': data, 'error': error})

def upload_code(request):
    '''
    Конвертация python кода в js представление
    '''    
    source = request.POST.get('data')
    
    # Пока непонятно каким образом приходит текст, приходится писать нечто ниже
    try:
        text = source.replace('\u000a','\n').replace('\\n','\n')[1:-1]        
        data = Parser('','').to_designer_preview(text)        
    except ParserError, e:
        return JsonResponse({'success': False, 'json': repr(e)})
    else:        
        return JsonResponse({'success': True, 'data': data})
    
def create_cont_func_view(request):
    '''
    Создание контейнерной функции
    '''
    class_name = request.POST.get('className')
    path = request.POST.get('path')
    
    name_func = request.POST.get('name')
    type_func = request.POST.get('type')
    
    assert name_func, 'Function name is undefined'
    assert type_func, 'Function type is undefined'
    
    try:
        create_cont_func(path, class_name, name_func, type_func)
    except ParserError, e:
        return JsonResponse({'success': False, 'json': unicode(e)})
    else:
        return JsonResponse({'success': True})

def codeassist(request):
    data = json.loads( request.REQUEST['data'])
    props = get_code_proposals(data['code'], data['offset'])
    return JsonResponse(props)
