# coding: utf-8

#------------------------------------------------------------------------------
# Metadata
#------------------------------------------------------------------------------

__author__ = 'Andrey Torsunov'
__contact__ = 'torsunov@bars-open.com'
__docformat__ = 'restructuredtext'


#------------------------------------------------------------------------------
# Exception classes
#------------------------------------------------------------------------------

class ProviderException(Exception):
    u""" Ошибка провайдера данных.

    Базовое исключение для всех ошибок провайдера данных.
    """
    pass


class ObjectDoesNotExists(ProviderException):
    u""" Запись не существует.

    Возникает если не удалось найти запись по фильтру.
    """
    pass


class MultipleObjects(ProviderException):
    u""" Множественные данные вместо единичной записи.

    Возникает если по фильтру было получено больше одной записи.
    """
    pass
