# Author: Jeff Vogelsang <jeffvogelsang@gmail.com>
#
# Copyright 2013 Jeff Vogelsang.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from distutils.core import setup

setup(name='manda',
      version='0.01',
      description='A Python Atlassian Utility Library',
      long_description='Provides a Python interface to the Atlassian API(s).',
      author='Jeff Vogelsang',
      author_email='jeffvogelsang@gmail.com',
      packages=['manda'],
      requires=['requests (>=1.2.3)'],
      # url='http://github.com/jeffvogelsang/manda',
      license='Apache v2.0',
      platforms='Posix; MacOS X; Windows',
      classifiers=['Development Status :: 4 - Beta',
                   'Intended Audience :: Developers',
                   'Intended Audience :: System Administrators',
                   'License :: OSI Approved :: Apache Software License',
                   'Operating System :: OS Independent',
                   'Topic :: System :: Logging',
                   ]
)