#!/usr/bin/python
#coding=utf-8

"""
This is a setup script for mang.

.. moduleauthor:: Yoonseop Kang <e0engoon@gmail.com>

"""
import os
import subprocess
from setuptools import setup
from setuptools.command.install import install

# Fetch version from git tags, and write to version.py.
# Also, when git is not available (PyPi package), use stored version.py.
# taken from:
# http://blogs.nopcode.org/brainstorm/2013/05/20/pragmatic-python

version_py = os.path.join(os.path.dirname(__file__), "version.py")

try:
    version_git = subprocess.check_output(["git", "describe"]).strip()
except:
    with open(version_py, 'r') as fp:
        version_git = fp.read().strip().split('=')[-1].replace('"', '')

msg = "# do not edit this file!"
with open(version_py, 'w') as fp:
    fp.write(msg + os.linesep + "__version__ = " + version_git)


class MyInstall(install):
    def run(self):
        os.system("cd mang/cudamat; rm *.so; make")
        os.system("cd ../../")
        install.run(self)

CUDAMAT_FILES = [
    "*.cu", "*.cuh", "*.so", "*.txt", "run_on_me_or_pid_quit", "Makefile"]

setup(
    name="mang",
    version=version_git,
    description="Another neural network library for python based on cudamat",

    install_requires=["numpy>=1.6.1", "msgpack-python", "msgpack_numpy"],

    packages=["mang", "mang.node", "mang.edge", "mang.cudamat"],
    package_data={"mang.cudamat": CUDAMAT_FILES, },
    cmdclass={"install": MyInstall},

    author="Yoonseop Kang",
    author_email="e0engoon@gmail.com",
    url="http://github.com/e0en/mang",
    keywords="neural network, artificial intelligence, machine learning",
    zip_safe=False)
