'''
    mania
    ~~~~~

    :copyright: 2010 by Bjoern Schulz <bjoern.schulz.92@gmail.com>
    :license: MIT, see LICENSE for more details
'''

import mania.types
import mania.scanner
import mania.parser
import mania.env
import mania.engine
import mania.builtins

def compile(src):
    return mania.parser.Parser(mania.scanner.Scanner(src)).parse()

def eval(ast, globals=None):
    if isinstance(ast, basestring):
        ast = mania.compile(ast)
    env = mania.env.Environment(None, mania.builtins.builtins).clone()
    for key, value in (globals or {}).items():
        env.define(key, mania.types.Type.to_mania(value))
    return ast.eval(env).to_native()