'''
    mania.env
    ~~~~~~~~~

    :copyright: 2010 by Bjoern Schulz <bjoern.schulz.92@gmail.com>
    :license: MIT, see LICENSE for more details
'''

class Environment(object):
    
    def __init__(self, parent=None, locals=None, engine=None):
        self.parent = parent
        self.locals = locals or {}
        self.engine = engine
    
    def lookup(self, name):
        if name in self.locals:
            return self.locals[name]
        else:
            if self.parent is not None:
                return self.parent.lookup(name)
            else:
                raise NameError("name '%s' is not defined" % name)
    
    def define(self, name, value):
        self.locals[name] = value
        return value
    
    def delete(self, name):
        if name in self.locals:
            self.locals[name]
        else:
            raise NameError("name '%s' is not defined" % name)
    
    def find(self, name):
        if name in self.locals:
            return self
        else:
            if self.parent:
                return self.parent.find(name)
            else:
                raise NameError("name '%s' is not defined" % name)
    
    def clone(self):
        return Environment(self, None, self.engine)