'''
    mania.engine
    ~~~~~~~~~~~~

    :copyright: 2010 by Bjoern Schulz <bjoern.schulz.92@gmail.com>
    :license: MIT, see LICENSE for more details
'''

from mania.env import Environment

class Engine(object):
    
    def __init__(self, builtins, sandbox=False):
        self.builtins = builtins
        self.env = Environment(None, builtins, self)
        self.sandbox = sandbox
    
    def eval(ast, globals=None):
        if isinstance(ast, basestring):
            ast = mania.compile(ast)
        env = self.env.clone()
        for key, value in (globals or {}).items():
            env.define(key, mania.types.Type.to_mania(value))
        return ast.eval(env).to_native()