import os
import logging
import subprocess
from sugarbowl import cachedproperty
from .config import Config
from .origin import Origin
from .settings import settings


class Project:
    """Project wrapper.
    """

    # Public

    def __init__(self, *, basedir=None, create=False):
        if basedir is None:
            basedir = os.getcwd()
        self.__basedir = basedir
        self.__dirpath = os.path.join(self.__basedir, settings.directory)
        if not self.__check():
            if not create:
                raise RuntimeError('Not a mario project (use mario init)')
            self.__create()
            logger.info('Initiated mario project')
        elif create:
            logger.info('Reinitiated mario project')

    def bind(self, remote):
        self.__config.set('remote', remote)
        logger.info('Bound origin to "%s"', remote)

    def make(self, *, command=None):
        self.__origin.copy(self.__basedir)
        if command:
            subprocess.check_call(
                command, shell=True, cwd=self.__basedir)
        logger.info('Made project from origin')

    def sync(self):
        remote = self.__config.get('remote')
        if remote:
            self.__origin.sync(remote)
            logger.info('Synced with "%s"', remote)
        else:
            logger.info('No remote to sync with (use mario bind)')

    # Private

    def __check(self):
        return os.path.exists(self.__dirpath)

    def __create(self):
        os.makedirs(self.__dirpath, exist_ok=True)

    @cachedproperty
    def __config(self):
        return Config(self.__dirpath)

    @cachedproperty
    def __origin(self):
        return Origin(self.__dirpath)


logger = logging.getLogger(__name__)
