from sugarbowl import Settings


class Settings(Settings):

    # Main

    command = 'run bootstrap && run update'
    directory = '.mario'

    # Logging

    logging_level = 'INFO'
    logging_format = '[%(levelname)s] %(message)s'

    @property
    def logging_config(self):
        return {
            'version': 1,
            'disable_existing_loggers': False,
            'loggers': {
                '': {
                    'handlers': ['default'],
                    'level': self.logging_level,
                    'propagate': True,
                },
            },
            'handlers': {
                'default': {
                    'level': 'DEBUG',
                    'class': 'logging.StreamHandler',
                    'formatter': 'default',
                },
            },
            'formatters': {
                'default': {
                    'format': self.logging_format
                },
            },
        }


settings = Settings()
