import os
import shutil
import unittest
from mario.origin import Origin


class OriginTest(unittest.TestCase):

    # Actions

    def setUp(self):
        self.origin = Origin(self.locate())
        self.remote = 'https://github.com/mario-hub/mario-python'

    def tearDown(self):
        shutil.rmtree(self.locate(), ignore_errors=True)

    # Helpers

    def locate(self, *paths):
        return os.path.join(
            os.path.dirname(__file__), 'fixtures', 'config', *paths)

    # Tests

    def test_copy(self):
        self.origin.sync(self.remote)
        target_path = self.locate('target')
        self.origin.copy(target_path)
        check_path = self.locate('target', 'runfile.py')
        self.assertTrue(os.path.exists(check_path))

    def test_sync(self):
        self.origin.sync(self.remote)
        check_path = self.locate('origin', 'sources', 'runfile.py')
        self.assertTrue(os.path.exists(check_path))

    def test_sync_with_wrong_remote(self):
        self.assertRaises(RuntimeError, self.origin.sync, 'wrong_remote')
