import os
import re
from functools import partial
from .directive import Directive


class ReplaceDirective(Directive):

    # Public

    def __init__(self, *, template, basedir, filepath):
        self.__target = os.path.join(basedir, filepath)
        self.__template = template

    def process(self, render):
        render(self.__template, target=self.__target)

    @classmethod
    def parse(cls, line):
        factory = None
        match = re.search(cls.__PATTERN, line)
        if match:
            factory = partial(cls, **match.groupdict())
        return factory

    # Private

    __PATTERN = '^\s*#\s*REPLACE:\s*(?P<filepath>.+?)\s*$'
