import os
import uuid
import unittest
from unittest.mock import Mock, call
from mario.project.content import Content


class ContentTest(unittest.TestCase):

    # Actions

    def setUp(self):
        self.value = str(uuid.uuid4())
        self.render = Mock(return_value=self.value)
        self.content = Content(basedir=self.locate())

    # Helpers

    def locate(self, *paths):
        return os.path.join(
            os.path.dirname(__file__), 'fixtures', 'content', *paths)

    # Tests

    def test_process(self):
        self.content.process(self.render)
        with open(self.locate('target.txt')) as file:
            self.assertEqual(
                file.read(),
                'Here some text:\n'
                '{value} # REPLACE: template inline\n'.
                format(value=self.value))
        # Check render calls
        self.render.assert_has_calls([
            call('template inline'),
            call('template line 1\ntemplate line 2\n',
                 target=self.locate('target.txt'))])
