import os
from .process import ProcessDirective
from .replace import ReplaceDirective
from ..settings import settings


class Content:

    # Public

    def __init__(self, *, basedir):
        self.__basedir = basedir
        self.__dirpath = os.path.join(basedir, settings.metadir)

    # TODO: move to private and add something like inspect?
    @property
    def directives(self):
        directives = []
        for item in sorted(os.listdir(self.__dirpath)):
            path = os.path.join(self.__dirpath, item)
            if not os.path.isfile(path):
                continue
            directives += self.__parse_file(path)
        return directives

    def process(self, render):
        for directive in self.directives:
            directive.process(render)

    # Private

    __Directives = [
        ProcessDirective,
        ReplaceDirective]

    def __parse_file(self, path):
        factories = []
        with open(path) as file:
            template = ''
            for line in file:
                factory = self.__parse_line(line)
                if not factory:
                    template += line
                    break
                factories.append(factory)
            template += file.read()
        directives = []
        for factory in factories:
            directive = factory(
                template=template,
                basedir=self.__basedir)
            directives.append(directive)
        return directives

    def __parse_line(self, line):
        for Directive in self.__Directives:
            factory = Directive.parse(line)
            if factory:
                return factory
        return None
