from abc import ABCMeta, abstractmethod


class Directive(metaclass=ABCMeta):

    # Public

    @abstractmethod
    def __init__(self, *, template, basedir, **kwargs):
        pass  # pragma: no cover

    @abstractmethod
    def process(self, render):
        pass  # pragma: no cover

    @classmethod
    @abstractmethod
    def parse(cls, line):
        pass  # pragma: no cover
