import os
import re
from functools import partial
from .directive import Directive


class ProcessDirective(Directive):

    # Public

    def __init__(self, *, template, basedir, filepath):
        self.__target = os.path.join(basedir, filepath)

    def process(self, render):
        if not os.path.isfile(self.__target):
            return
        with open(self.__target, 'r') as file:
            content = ''
            for line in file:
                match = re.search(self.__INTERNAL_PATTERN, line)
                if match:
                    old = match.group('current')
                    new = render(match.group('template'))
                    line = line.replace(old, new, 1)
                content += line
        with open(self.__target, 'w') as file:
            file.write(content)

    @classmethod
    def parse(cls, line):
        factory = None
        match = re.search(cls.__EXTERNAL_PATTERN, line)
        if match:
            factory = partial(cls, **match.groupdict())
        return factory

    # Private

    __EXTERNAL_PATTERN = (
        '^\s*#\s*PROCESS:\s*(?P<filepath>.+?)\s*$')
    __INTERNAL_PATTERN = (
        '^\s*(?P<current>.+?)\s*#\s*REPLACE:\s*(?P<template>.+?)\s*$')
