# Block: caution
# TO MAKE CHANGES USE [meta] DIRECTORY.

# Block: data_files
import os
data_files = []
if data_files:
    try:
        if os.geteuid() != 0:
            data_files.clear()
    except Exception:
        pass

# Block: long_description
from glob import iglob
long_description = 'Mario is a framework to develop projects.'
for filepath in iglob('README.*'):
    with open(filepath) as file:
        long_description = file.read()
    break     

# Block: packages
from setuptools import find_packages
packages = find_packages(os.path.dirname(__file__) or '.', exclude=['tests*'])

# Block: setup
from setuptools import setup
setup(
    author='roll',
    author_email='roll@respect31.com',
    classifiers=[],       
    description='Mario is a framework to develop projects.',
    data_files=data_files,
    download_url='https://github.com/respect31/mario/tarball/0.27.0',
    entry_points={'console_scripts': ['mario = mario:program']},
    license='MIT License',
    long_description=long_description,
    maintainer='roll',
    maintainer_email='roll@respect31.com',
    name='mario',
    include_package_data=True,
    install_requires=['sugarbowl', 'clyde', 'runfile', 'run-render', 'run-io'], 
    packages=packages,
    platforms=['Unix'],
    url='https://github.com/respect31/mario',
    tests_require=[],
    test_suite='nose.collector',
    version='0.27.0')
