import os
import json
import shutil
import unittest
from mario.project.config import Config


class ConfigTest(unittest.TestCase):

    # Actions

    def setUp(self):
        self.config = Config(basedir=self.locate())

    def tearDown(self):
        shutil.rmtree(self.locate(), ignore_errors=True)

    # Helpers

    def locate(self, *paths):
        return os.path.join(
            os.path.dirname(__file__), 'fixtures', 'config', *paths)

    # Tests

    def test_get_set(self):
        self.assertIs(self.config.get('key'), None)
        self.config.set('key', 'value')
        self.assertEqual(self.config.get('key'), 'value')

    def test_storage(self):
        self.config.set('key', 'value')
        storage_path = self.locate('.mario', 'config', 'config.json')
        with open(storage_path) as file:
            self.assertEqual(json.load(file), {'key': 'value'})

    def test_second_instance(self):
        self.config2 = Config(basedir=self.locate())
        self.config.set('key', 'value')
        self.assertEqual(self.config2.get('key'), 'value')
