import os
import json
from ..settings import settings


class Config:
    """Config wrapper.
    """

    # Public

    def __init__(self, *, basedir):
        self.__dirpath = os.path.join(
            basedir, settings.metadir, self.__CONFIG_DIR)
        self.__filepath = os.path.join(self.__dirpath, self.__CONFIG_FILE)
        if not self.__check():
            self.__create()

    def get(self, name, default=None):
        config = self.__load()
        return config.get(name, default)

    def set(self, name, value):
        config = self.__load()
        config[name] = value
        self.__save(config)

    # Private

    __CONFIG_DIR = 'config'
    __CONFIG_FILE = 'config.json'

    def __check(self):
        try:
            self.__load()
            return True
        except Exception:
            return False

    def __create(self):
        config = {}
        os.makedirs(self.__dirpath, exist_ok=True)
        self.__save(config)

    def __load(self):
        with open(self.__filepath) as file:
            return json.load(file)

    def __save(self, config):
        with open(self.__filepath, 'w') as file:
            json.dump(config, file)
