import os
import jinja2
from run import Module
from functools import partial
from sugarbowl import cachedproperty
from importlib import import_module
from run.plugins.io import DialogModule  # @UnresolvedImport
from run.plugins.render import RenderTask  # @UnresolvedImport
from .project import Project


class ProcessModule(Module):
    """Process mario project.
    """

    # Public

    meta_default = 'process'

    def process(self, filenames=False, runfile=False):
        if filenames:
            self.process_filenames()
        if runfile:
            self.process_runfile()
        self.process_directives()

    def process_directives(self):
        basedir = self.meta_top.meta_locate()
        project = Project(basedir=basedir)
        render = partial(self.process_string, context=self.meta_top)
        project.process(render)

    def process_filenames(self):
        basedir = self.meta_top.meta_locate()
        for dirpath, dirnames, filenames in os.walk(basedir, topdown=False):
            for name in dirnames + filenames:
                new_name = self.process_string(name)
                if name != new_name:
                    path = os.path.join(dirpath, name)
                    new_path = os.path.join(dirpath, new_name)
                    # TODO: pass exceptions on existent files
                    os.rename(path, new_path)

    def process_runfile(self):
        path = self.meta_top.meta_locate('runfile.py')
        self.process_string(path)

    def process_string(self, string, *, context=None, target=None):
        if context is None:
            context = self.context
        return self.render(
            string, context=context, target=target,
            loader=self.__loader, trim_blocks=True, lstrip_blocks=True)

    context = DialogModule()
    render = RenderTask(meta_hidden=True)

    # Private

    @cachedproperty
    def __loader(self):
        try:
            import_module('mario.origin')
        except ImportError:
            return None
        return jinja2.PrefixLoader({
            'mario.origin': jinja2.PackageLoader('mario.origin')})
