# mapping of entity names to utf-8 values
# lists all characters in the "XHTML 1.1 + MathML 2.0" DTD

map_utf8 = {
"CloseCurlyDoubleQuote":            "\xe2\x80\x9d",
"CloseCurlyQuote":                  "\xe2\x80\x99",
"LeftAngleBracket":                 "\xe2\x8c\xa9",
"LeftCeiling":                      "\xe2\x8c\x88",
"LeftDoubleBracket":                "\xe3\x80\x9a",
"LeftFloor":                        "\xe2\x8c\x8a",
"OpenCurlyDoubleQuote":             "\xe2\x80\x9c",
"OpenCurlyQuote":                   "\xe2\x80\x98",
"RightAngleBracket":                "\xe2\x8c\xaa",
"RightCeiling":                     "\xe2\x8c\x89",
"RightDoubleBracket":               "\xe3\x80\x9b",
"RightFloor":                       "\xe2\x8c\x8b",
"InvisibleComma":                   "\xe2\x81\xa3",
"ic":                               "\xe2\x81\xa3",
"HorizontalLine":                   "\xe2\x94\x80",
"VerticalLine":                     "\x7c",
"Assign":                           "\xe2\x89\x94",
"Because":                          "\xe2\x88\xb5",
"Therefore":                        "\xe2\x88\xb4",
"VerticalSeparator":                "\xe2\x9d\x98",
"Colon":                            "\xe2\x88\xb7",
"Colone":                           "\xe2\xa9\xb4",
"Proportion":                       "\xe2\x88\xb7",
"SuchThat":                         "\xe2\x88\x8b",
"DoubleLeftTee":                    "\xe2\xab\xa4",
"DoubleRightTee":                   "\xe2\x8a\xa8",
"DownTee":                          "\xe2\x8a\xa4",
"DownTeeArrow":                     "\xe2\x86\xa7",
"LeftDownTeeVector":                "\xe2\xa5\xa1",
"RightDownTeeVector":               "\xe2\xa5\x9d",
"DoubleLeftTee":                    "\xe2\xab\xa4",
"LeftTee":                          "\xe2\x8a\xa3",
"LeftTeeArrow":                     "\xe2\x86\xa4",
"DownLeftTeeVector":                "\xe2\xa5\x9e",
"LeftTeeVector":                    "\xe2\xa5\x9a",
"DoubleRightTee":                   "\xe2\x8a\xa8",
"RightTee":                         "\xe2\x8a\xa2",
"RightTeeArrow":                    "\xe2\x86\xa6",
"DownRightTeeVector":               "\xe2\xa5\x9f",
"RightTeeVector":                   "\xe2\xa5\x9b",
"Implies":                          "\xe2\x87\x92",
"RoundImplies":                     "\xe2\xa5\xb0",
"RoundImplies":                     "\xe2\xa5\xb0",
"Or":                               "\xe2\xa9\x94",
"And":                              "\xe2\xa9\x93",
"bNot":                             "\xe2\xab\xad",
"Not":                              "\xe2\xab\xac",
"NotCongruent":                     "\xe2\x89\xa2",
"NotDoubleVerticalBar":             "\xe2\x88\xa6",
"NotElement":                       "\xe2\x88\x89",
"NotEqual":                         "\xe2\x89\xa0",
"NotExists":                        "\xe2\x88\x84",
"NotGreater":                       "\xe2\x89\xaf",
"NotGreaterEqual":                  "\xe2\x89\xb1",
"NotGreaterLess":                   "\xe2\x89\xb9",
"NotGreaterTilde":                  "\xe2\x89\xb5",
"NotLeftTriangle":                  "\xe2\x8b\xaa",
"NotLeftTriangleEqual":             "\xe2\x8b\xac",
"NotLess":                          "\xe2\x89\xae",
"NotLessEqual":                     "\xe2\x89\xb0",
"NotLessGreater":                   "\xe2\x89\xb8",
"NotLessTilde":                     "\xe2\x89\xb4",
"NotPrecedes":                      "\xe2\x8a\x80",
"NotPrecedesEqual":                 "\xe2\xaa\xaf",
"NotPrecedesSlantEqual":            "\xe2\x8b\xa0",
"NotReverseElement":                "\xe2\x88\x8c",
"NotRightTriangle":                 "\xe2\x8b\xab",
"NotRightTriangleEqual":            "\xe2\x8b\xad",
"NotSquareSubsetEqual":             "\xe2\x8b\xa2",
"NotSquareSupersetEqual":           "\xe2\x8b\xa3",
"NotSubset":                        "\xe2\x8a\x84",
"NotSubsetEqual":                   "\xe2\x8a\x88",
"NotSucceeds":                      "\xe2\x8a\x81",
"NotSucceedsSlantEqual":            "\xe2\x8b\xa1",
"NotSuperset":                      "\xe2\x8a\x85",
"NotSupersetEqual":                 "\xe2\x8a\x89",
"NotTilde":                         "\xe2\x89\x81",
"NotTildeEqual":                    "\xe2\x89\x84",
"NotTildeFullEqual":                "\xe2\x89\x87",
"NotTildeTilde":                    "\xe2\x89\x89",
"NotVerticalBar":                   "\xe2\x88\xa4",
"NotCupCap":                        "\xe2\x89\xad",
"Exists":                           "\xe2\x88\x83",
"NotExists":                        "\xe2\x88\x84",
"ForAll":                           "\xe2\x88\x80",
"NotExists":                        "\xe2\x88\x84",
"Element":                          "\xe2\x88\x88",
"NotElement":                       "\xe2\x88\x89",
"NotReverseElement":                "\xe2\x88\x8c",
"ReverseElement":                   "\xe2\x88\x8b",
"NotElement":                       "\xe2\x88\x89",
"NotReverseElement":                "\xe2\x88\x8c",
"NotSquareSubsetEqual":             "\xe2\x8b\xa2",
"NotSquareSubsetEqual":             "\xe2\x8b\xa2",
"NotSquareSupersetEqual":           "\xe2\x8b\xa3",
"NotSquareSupersetEqual":           "\xe2\x8b\xa3",
"NotSubset":                        "\xe2\x8a\x84",
"NotSubsetEqual":                   "\xe2\x8a\x88",
"NotSubsetEqual":                   "\xe2\x8a\x88",
"NotSuperset":                      "\xe2\x8a\x85",
"NotSupersetEqual":                 "\xe2\x8a\x89",
"NotSupersetEqual":                 "\xe2\x8a\x89",
"NotReverseElement":                "\xe2\x88\x8c",
"ReverseElement":                   "\xe2\x88\x8b",
"NotSquareSubsetEqual":             "\xe2\x8b\xa2",
"SquareSubset":                     "\xe2\x8a\x8f",
"SquareSubsetEqual":                "\xe2\x8a\x91",
"NotSquareSubsetEqual":             "\xe2\x8b\xa2",
"SquareSubsetEqual":                "\xe2\x8a\x91",
"NotSquareSupersetEqual":           "\xe2\x8b\xa3",
"SquareSuperset":                   "\xe2\x8a\x90",
"SquareSupersetEqual":              "\xe2\x8a\x92",
"NotSquareSupersetEqual":           "\xe2\x8b\xa3",
"SquareSupersetEqual":              "\xe2\x8a\x92",
"Sub":                              "\xe2\x8b\x90",
"NotSquareSubsetEqual":             "\xe2\x8b\xa2",
"NotSubset":                        "\xe2\x8a\x84",
"NotSubsetEqual":                   "\xe2\x8a\x88",
"SquareSubset":                     "\xe2\x8a\x8f",
"SquareSubsetEqual":                "\xe2\x8a\x91",
"Subset":                           "\xe2\x8b\x90",
"SubsetEqual":                      "\xe2\x8a\x86",
"NotSquareSubsetEqual":             "\xe2\x8b\xa2",
"NotSubsetEqual":                   "\xe2\x8a\x88",
"SquareSubsetEqual":                "\xe2\x8a\x91",
"SubsetEqual":                      "\xe2\x8a\x86",
"NotSquareSupersetEqual":           "\xe2\x8b\xa3",
"NotSuperset":                      "\xe2\x8a\x85",
"NotSupersetEqual":                 "\xe2\x8a\x89",
"SquareSuperset":                   "\xe2\x8a\x90",
"SquareSupersetEqual":              "\xe2\x8a\x92",
"Superset":                         "\xe2\x8a\x83",
"SupersetEqual":                    "\xe2\x8a\x87",
"NotSquareSupersetEqual":           "\xe2\x8b\xa3",
"NotSupersetEqual":                 "\xe2\x8a\x89",
"SquareSupersetEqual":              "\xe2\x8a\x92",
"SupersetEqual":                    "\xe2\x8a\x87",
"DoubleLeftArrow":                  "\xe2\x87\x90",
"DoubleLeftRightArrow":             "\xe2\x87\x94",
"DoubleRightArrow":                 "\xe2\x87\x92",
"DownLeftRightVector":              "\xe2\xa5\x90",
"DownLeftTeeVector":                "\xe2\xa5\x9e",
"DownLeftVector":                   "\xe2\x86\xbd",
"DownLeftVectorBar":                "\xe2\xa5\x96",
"DownLeftVectorBar":                "\xe2\xa5\x96",
"DownRightTeeVector":               "\xe2\xa5\x9f",
"DownRightVector":                  "\xe2\x87\x81",
"DownRightVectorBar":               "\xe2\xa5\x97",
"DownRightVectorBar":               "\xe2\xa5\x97",
"DoubleLeftArrow":                  "\xe2\x87\x90",
"DoubleLongLeftArrow":              "\xe2\x9f\xb8",
"LeftArrow":                        "\xe2\x86\x90",
"LeftArrowBar":                     "\xe2\x87\xa4",
"LeftArrowRightArrow":              "\xe2\x87\x86",
"LongLeftArrow":                    "\xe2\x9f\xb5",
"LowerLeftArrow":                   "\xe2\x86\x99",
"RightArrowLeftArrow":              "\xe2\x87\x84",
"UpperLeftArrow":                   "\xe2\x86\x96",
"LeftArrowBar":                     "\xe2\x87\xa4",
"LeftArrowRightArrow":              "\xe2\x87\x86",
"DoubleLeftRightArrow":             "\xe2\x87\x94",
"DoubleLongLeftRightArrow":         "\xe2\x9f\xba",
"LeftRightArrow":                   "\xe2\x86\x94",
"LongLeftRightArrow":               "\xe2\x9f\xb7",
"DownLeftRightVector":              "\xe2\xa5\x90",
"LeftRightVector":                  "\xe2\xa5\x8e",
"LeftTeeArrow":                     "\xe2\x86\xa4",
"DownLeftTeeVector":                "\xe2\xa5\x9e",
"LeftTeeVector":                    "\xe2\xa5\x9a",
"DownLeftVector":                   "\xe2\x86\xbd",
"LeftVector":                       "\xe2\x86\xbc",
"DownLeftVectorBar":                "\xe2\xa5\x96",
"LeftVectorBar":                    "\xe2\xa5\x92",
"DownLeftVectorBar":                "\xe2\xa5\x96",
"LeftVectorBar":                    "\xe2\xa5\x92",
"LowerLeftArrow":                   "\xe2\x86\x99",
"LowerRightArrow":                  "\xe2\x86\x98",
"DoubleLeftRightArrow":             "\xe2\x87\x94",
"DoubleLongLeftRightArrow":         "\xe2\x9f\xba",
"DoubleLongRightArrow":             "\xe2\x9f\xb9",
"DoubleRightArrow":                 "\xe2\x87\x92",
"LeftArrowRightArrow":              "\xe2\x87\x86",
"LeftRightArrow":                   "\xe2\x86\x94",
"LongLeftRightArrow":               "\xe2\x9f\xb7",
"LongRightArrow":                   "\xe2\x9f\xb6",
"LowerRightArrow":                  "\xe2\x86\x98",
"RightArrow":                       "\xe2\x86\x92",
"RightArrowBar":                    "\xe2\x87\xa5",
"RightArrowLeftArrow":              "\xe2\x87\x84",
"UpperRightArrow":                  "\xe2\x86\x97",
"RightArrowBar":                    "\xe2\x87\xa5",
"RightArrowLeftArrow":              "\xe2\x87\x84",
"RightTeeArrow":                    "\xe2\x86\xa6",
"DownRightTeeVector":               "\xe2\xa5\x9f",
"RightTeeVector":                   "\xe2\xa5\x9b",
"DownRightVector":                  "\xe2\x87\x81",
"RightVector":                      "\xe2\x87\x80",
"DownLeftRightVector":              "\xe2\xa5\x90",
"DownRightVectorBar":               "\xe2\xa5\x97",
"LeftRightVector":                  "\xe2\xa5\x8e",
"RightVectorBar":                   "\xe2\xa5\x93",
"DownRightVectorBar":               "\xe2\xa5\x97",
"RightVectorBar":                   "\xe2\xa5\x93",
"UpperLeftArrow":                   "\xe2\x86\x96",
"UpperRightArrow":                  "\xe2\x86\x97",
"mumap":                            "\xe2\x8a\xb8",
"lotimes":                          "\xe2\xa8\xb4",
"lthree":                           "\xe2\x8b\x8b",
"ltimes":                           "\xe2\x8b\x89",
"olt":                              "\xe2\xa7\x80",
"otimes":                           "\xe2\x8a\x97",
"Otimes":                           "\xe2\xa8\xb7",
"otimesas":                         "\xe2\xa8\xb6",
"rotimes":                          "\xe2\xa8\xb5",
"timesb":                           "\xe2\x8a\xa0",
"timesbar":                         "\xe2\xa8\xb1",
"tritime":                          "\xe2\xa8\xbb",
"lparlt":                           "\xe2\xa6\x93",
"ltrPar":                           "\xe2\xa6\x96",
"nlt":                              "\xe2\x89\xae",
"nltri":                            "\xe2\x8b\xaa",
"nltrie":                           "\xe2\x8b\xac",
"nvlt":                             "\xe2\x89\xae",
"lltri":                            "\xe2\x97\xba",
"ultri":                            "\xe2\x97\xb8",
"ltcc":                             "\xe2\xaa\xa6",
"ltcir":                            "\xe2\xa9\xb9",
"ltdot":                            "\xe2\x8b\x96",
"ltlarr":                           "\xe2\xa5\xb6",
"ltquest":                          "\xe2\xa9\xbb",
"ltrie":                            "\xe2\x8a\xb4",
"rtriltri":                         "\xe2\xa7\x8e",
"submult":                          "\xe2\xab\x81",
"supmult":                          "\xe2\xab\x82",
"vltri":                            "\xe2\x8a\xb2",
"delta":                            "\xce\xb4",
"Delta":                            "\xce\x94",
"times":                            "\xc3\x97",
"ltri":                             "\xe2\x97\x83",
"ltrif":                            "\xe2\x97\x82",
"malt":                             "\xe2\x9c\xa0",
"hamilt":                           "\xe2\x84\x8b",
"nabla":                            "\xe2\x88\x87",
"blacktriangleleft":                "\xe2\x97\x82",
"InvisibleTimes":                   "\xe2\x81\xa2",
"leftthreetimes":                   "\xe2\x8b\x8b",
"LeftTriangle":                     "\xe2\x8a\xb2",
"LeftTriangleEqual":                "\xe2\x8a\xb4",
"lessdot":                          "\xe2\x8b\x96",
"maltese":                          "\xe2\x9c\xa0",
"multimap":                         "\xe2\x8a\xb8",
"nless":                            "\xe2\x89\xae",
"NotLeftTriangle":                  "\xe2\x8b\xaa",
"NotLeftTriangleEqual":             "\xe2\x8b\xac",
"NotLess":                          "\xe2\x89\xae",
"ntriangleleft":                    "\xe2\x8b\xaa",
"ntrianglelefteq":                  "\xe2\x8b\xac",
"triangleleft":                     "\xe2\x97\x83",
"trianglelefteq":                   "\xe2\x8a\xb4",
"vartriangleleft":                  "\xe2\x8a\xb2",
"it":                               "\xe2\x81\xa2",
"Congruent":                        "\xe2\x89\xa1",
"NotCongruent":                     "\xe2\x89\xa2",
"CupCap":                           "\xe2\x89\x8d",
"NotCupCap":                        "\xe2\x89\xad",
"DotEqual":                         "\xe2\x89\x90",
"DoubleVerticalBar":                "\xe2\x88\xa5",
"NotDoubleVerticalBar":             "\xe2\x88\xa6",
"DotEqual":                         "\xe2\x89\x90",
"EqualTilde":                       "\xe2\x89\x82",
"GreaterEqual":                     "\xe2\x89\xa5",
"GreaterEqualLess":                 "\xe2\x8b\x9b",
"GreaterFullEqual":                 "\xe2\x89\xa7",
"GreaterSlantEqual":                "\xe2\xa9\xbe",
"HumpEqual":                        "\xe2\x89\x8f",
"LeftTriangleEqual":                "\xe2\x8a\xb4",
"LessEqualGreater":                 "\xe2\x8b\x9a",
"LessFullEqual":                    "\xe2\x89\xa6",
"LessSlantEqual":                   "\xe2\xa9\xbd",
"NotEqual":                         "\xe2\x89\xa0",
"NotGreaterEqual":                  "\xe2\x89\xb1",
"NotLeftTriangleEqual":             "\xe2\x8b\xac",
"NotLessEqual":                     "\xe2\x89\xb0",
"NotPrecedesEqual":                 "\xe2\xaa\xaf",
"NotPrecedesSlantEqual":            "\xe2\x8b\xa0",
"NotRightTriangleEqual":            "\xe2\x8b\xad",
"NotSquareSubsetEqual":             "\xe2\x8b\xa2",
"NotSquareSupersetEqual":           "\xe2\x8b\xa3",
"NotSubsetEqual":                   "\xe2\x8a\x88",
"NotSucceedsSlantEqual":            "\xe2\x8b\xa1",
"NotSupersetEqual":                 "\xe2\x8a\x89",
"NotTildeEqual":                    "\xe2\x89\x84",
"NotTildeFullEqual":                "\xe2\x89\x87",
"PrecedesEqual":                    "\xe2\xaa\xaf",
"PrecedesSlantEqual":               "\xe2\x89\xbc",
"RightTriangleEqual":               "\xe2\x8a\xb5",
"SquareSubsetEqual":                "\xe2\x8a\x91",
"SquareSupersetEqual":              "\xe2\x8a\x92",
"SubsetEqual":                      "\xe2\x8a\x86",
"SucceedsEqual":                    "\xe2\x89\xbd",
"SucceedsSlantEqual":               "\xe2\x89\xbd",
"SupersetEqual":                    "\xe2\x8a\x87",
"TildeEqual":                       "\xe2\x89\x83",
"TildeFullEqual":                   "\xe2\x89\x85",
"Equal":                            "\xe2\xa9\xb5",
"EqualTilde":                       "\xe2\x89\x82",
"Equilibrium":                      "\xe2\x87\x8c",
"ReverseEquilibrium":               "\xe2\x87\x8b",
"ReverseUpEquilibrium":             "\xe2\xa5\xaf",
"UpEquilibrium":                    "\xe2\xa5\xae",
"GreaterEqual":                     "\xe2\x89\xa5",
"GreaterEqualLess":                 "\xe2\x8b\x9b",
"NotGreaterEqual":                  "\xe2\x89\xb1",
"GreaterEqualLess":                 "\xe2\x8b\x9b",
"GreaterFullEqual":                 "\xe2\x89\xa7",
"NestedGreaterGreater":             "\xe2\x89\xab",
"GreaterGreater":                   "\xe2\xaa\xa2",
"GreaterLess":                      "\xe2\x89\xb7",
"NotGreaterLess":                   "\xe2\x89\xb9",
"GreaterSlantEqual":                "\xe2\xa9\xbe",
"GreaterTilde":                     "\xe2\x89\xb3",
"NotGreaterTilde":                  "\xe2\x89\xb5",
"HumpDownHump":                     "\xe2\x89\x8e",
"HumpEqual":                        "\xe2\x89\x8f",
"LeftTriangle":                     "\xe2\x8a\xb2",
"LeftTriangleEqual":                "\xe2\x8a\xb4",
"NotLeftTriangle":                  "\xe2\x8b\xaa",
"NotLeftTriangleEqual":             "\xe2\x8b\xac",
"LeftTriangleBar":                  "\xe2\xa7\x8f",
"LeftTriangleBar":                  "\xe2\xa7\x8f",
"LeftTriangleEqual":                "\xe2\x8a\xb4",
"NotLeftTriangleEqual":             "\xe2\x8b\xac",
"angzarr":                          "\xe2\x8d\xbc",
"cirmid":                           "\xe2\xab\xaf",
"cudarrl":                          "\xe2\xa4\xb8",
"cularr":                           "\xe2\x86\xb6",
"cularrp":                          "\xe2\xa4\xbd",
"dHar":                             "\xe2\xa5\xa5",
"dharl":                            "\xe2\x87\x83",
"harr":                             "\xe2\x86\x94",
"harrcir":                          "\xe2\xa5\x88",
"harrw":                            "\xe2\x86\xad",
"lAarr":                            "\xe2\x87\x9a",
"Larr":                             "\xe2\x86\x9e",
"larrbfs":                          "\xe2\xa4\x9f",
"larrfs":                           "\xe2\xa4\x9d",
"larrhk":                           "\xe2\x86\xa9",
"larrlp":                           "\xe2\x86\xab",
"larrpl":                           "\xe2\xa4\xb9",
"larrsim":                          "\xe2\xa5\xb3",
"larrtl":                           "\xe2\x86\xa2",
"latail":                           "\xe2\xa4\x99",
"lAtail":                           "\xe2\xa4\x9b",
"lbarr":                            "\xe2\xa4\x8c",
"lBarr":                            "\xe2\xa4\x8e",
"ldca":                             "\xe2\xa4\xb6",
"ldrdhar":                          "\xe2\xa5\xa7",
"ldrushar":                         "\xe2\xa5\x8b",
"ldsh":                             "\xe2\x86\xb2",
"lfisht":                           "\xe2\xa5\xbc",
"lHar":                             "\xe2\xa5\xa2",
"lhard":                            "\xe2\x86\xbd",
"lharu":                            "\xe2\x86\xbc",
"lharul":                           "\xe2\xa5\xaa",
"llarr":                            "\xe2\x87\x87",
"llhard":                           "\xe2\xa5\xab",
"loarr":                            "\xe2\x87\xbd",
"lrarr":                            "\xe2\x87\x86",
"lrhar":                            "\xe2\x87\x8b",
"lurdshar":                         "\xe2\xa5\x8a",
"luruhar":                          "\xe2\xa5\xa6",
"midcir":                           "\xe2\xab\xb0",
"nharr":                            "\xe2\x86\xae",
"nlarr":                            "\xe2\x86\x9a",
"nvHarr":                           "\xe2\x87\x8e",
"nvlArr":                           "\xe2\x87\x8d",
"nvrArr":                           "\xe2\x87\x8f",
"olarr":                            "\xe2\x86\xba",
"orarr":                            "\xe2\x86\xbb",
"rAarr":                            "\xe2\x87\x9b",
"rarrbfs":                          "\xe2\xa4\xa0",
"rarrfs":                           "\xe2\xa4\x9e",
"rarrtl":                           "\xe2\x86\xa3",
"rAtail":                           "\xe2\xa4\x9c",
"rdldhar":                          "\xe2\xa5\xa9",
"rdsh":                             "\xe2\x86\xb3",
"rlarr":                            "\xe2\x87\x84",
"rlhar":                            "\xe2\x87\x8c",
"ruluhar":                          "\xe2\xa5\xa8",
"Uarrocir":                         "\xe2\xa5\x89",
"uHar":                             "\xe2\xa5\xa3",
"uharl":                            "\xe2\x86\xbf",
"xharr":                            "\xe2\x9f\xb7",
"xhArr":                            "\xe2\x9f\xba",
"xlarr":                            "\xe2\x9f\xb5",
"xlArr":                            "\xe2\x9f\xb8",
"Barwed":                           "\xe2\x8c\x86",
"Cap":                              "\xe2\x8b\x92",
"Cup":                              "\xe2\x8b\x93",
"Dagger":                           "\xe2\x80\xa1",
"loplus":                           "\xe2\xa8\xad",
"lotimes":                          "\xe2\xa8\xb4",
"lthree":                           "\xe2\x8b\x8b",
"ltimes":                           "\xe2\x8b\x89",
"oast":                             "\xe2\x8a\x9b",
"ocir":                             "\xe2\x8a\x9a",
"odash":                            "\xe2\x8a\x9d",
"odiv":                             "\xe2\xa8\xb8",
"odot":                             "\xe2\x8a\x99",
"odsold":                           "\xe2\xa6\xbc",
"ofcir":                            "\xe2\xa6\xbf",
"ogt":                              "\xe2\xa7\x81",
"ohbar":                            "\xe2\xa6\xb5",
"olcir":                            "\xe2\xa6\xbe",
"olt":                              "\xe2\xa7\x80",
"omid":                             "\xe2\xa6\xb6",
"ominus":                           "\xe2\x8a\x96",
"opar":                             "\xe2\xa6\xb7",
"operp":                            "\xe2\xa6\xb9",
"oplus":                            "\xe2\x8a\x95",
"osol":                             "\xe2\x8a\x98",
"otimes":                           "\xe2\x8a\x97",
"Otimes":                           "\xe2\xa8\xb7",
"otimesas":                         "\xe2\xa8\xb6",
"ovbar":                            "\xe2\x8c\xbd",
"plusacir":                         "\xe2\xa8\xa3",
"pluscir":                          "\xe2\xa8\xa2",
"roplus":                           "\xe2\xa8\xae",
"rotimes":                          "\xe2\xa8\xb5",
"sdot":                             "\xe2\x8b\x85",
"sstarf":                           "\xe2\x8b\x86",
"tridot":                           "\xe2\x97\xac",
"triminus":                         "\xe2\xa8\xba",
"triplus":                          "\xe2\xa8\xb9",
"trisb":                            "\xe2\xa7\x8d",
"tritime":                          "\xe2\xa8\xbb",
"xcirc":                            "\xe2\x97\xaf",
"xdtri":                            "\xe2\x96\xbd",
"xodot":                            "\xe2\x8a\x99",
"xoplus":                           "\xe2\x8a\x95",
"xotime":                           "\xe2\x8a\x97",
"xutri":                            "\xe2\x96\xb3",
"dlcorn":                           "\xe2\x8c\x9e",
"gtlPar":                           "\xe2\xa6\x95",
"langd":                            "\xe2\xa6\x91",
"lbrke":                            "\xe2\xa6\x8b",
"lbrksld":                          "\xe2\xa6\x8f",
"lbrkslu":                          "\xe2\xa6\x8d",
"lceil":                            "\xe2\x8c\x88",
"lfloor":                           "\xe2\x8c\x8a",
"lparlt":                           "\xe2\xa6\x93",
"ltrPar":                           "\xe2\xa6\x96",
"rangd":                            "\xe2\xa6\x92",
"ulcorn":                           "\xe2\x8c\x9c",
"lnap":                             "\xe2\xaa\x89",
"lne":                              "\xe2\x89\xa8",
"lnE":                              "\xe2\x89\xa8",
"lnsim":                            "\xe2\x8b\xa6",
"nle":                              "\xe2\x89\xb0",
"nlsim":                            "\xe2\x89\xb4",
"nlt":                              "\xe2\x89\xae",
"nltri":                            "\xe2\x8b\xaa",
"nltrie":                           "\xe2\x8b\xac",
"npar":                             "\xe2\x88\xa6",
"nrtri":                            "\xe2\x8b\xab",
"nrtrie":                           "\xe2\x8b\xad",
"ntgl":                             "\xe2\x89\xb9",
"ntlg":                             "\xe2\x89\xb8",
"nvlt":                             "\xe2\x89\xae",
"parsim":                           "\xe2\xab\xb3",
"ang":                              "\xe2\x88\xa0",
"ange":                             "\xe2\xa6\xa4",
"angmsd":                           "\xe2\x88\xa1",
"angmsdaa":                         "\xe2\xa6\xa8",
"angmsdab":                         "\xe2\xa6\xa9",
"angmsdac":                         "\xe2\xa6\xaa",
"angmsdad":                         "\xe2\xa6\xab",
"angmsdae":                         "\xe2\xa6\xac",
"angmsdaf":                         "\xe2\xa6\xad",
"angmsdag":                         "\xe2\xa6\xae",
"angmsdah":                         "\xe2\xa6\xaf",
"angrtvbd":                         "\xe2\xa6\x9d",
"bemptyv":                          "\xe2\xa6\xb0",
"cemptyv":                          "\xe2\xa6\xb2",
"cirE":                             "\xe2\xa7\x83",
"cirscir":                          "\xe2\xa7\x82",
"comp":                             "\xe2\x88\x81",
"daleth":                           "\xe2\x84\xb8",
"demptyv":                          "\xe2\xa6\xb1",
"emptyv":                           "\xe2\x88\x85",
"laemptyv":                         "\xe2\xa6\xb4",
"lltri":                            "\xe2\x97\xba",
"lrtri":                            "\xe2\x8a\xbf",
"oS":                               "\xe2\x93\x88",
"raemptyv":                         "\xe2\xa6\xb3",
"range":                            "\xe2\xa6\xa5",
"ultri":                            "\xe2\x97\xb8",
"urtri":                            "\xe2\x97\xb9",
"cire":                             "\xe2\x89\x97",
"Colone":                           "\xe2\xa9\xb4",
"ecir":                             "\xe2\x89\x96",
"el":                               "\xe2\xaa\x99",
"els":                              "\xe2\x8b\x9c",
"elsdot":                           "\xe2\xaa\x97",
"equivDD":                          "\xe2\xa9\xb8",
"esdot":                            "\xe2\x89\x90",
"gE":                               "\xe2\x89\xa7",
"gel":                              "\xe2\x8b\x9b",
"gEl":                              "\xe2\x8b\x9b",
"gesdotol":                         "\xe2\xaa\x84",
"gesles":                           "\xe2\xaa\x94",
"Gg":                               "\xe2\x8b\x99",
"gl":                               "\xe2\x89\xb7",
"gla":                              "\xe2\xaa\xa5",
"glE":                              "\xe2\xaa\x92",
"glj":                              "\xe2\xaa\xa4",
"gsiml":                            "\xe2\xaa\x90",
"gtcir":                            "\xe2\xa9\xba",
"lap":                              "\xe2\x89\xb2",
"lE":                               "\xe2\x89\xa6",
"leg":                              "\xe2\x8b\x9a",
"lEg":                              "\xe2\x8b\x9a",
"les":                              "\xe2\xa9\xbd",
"lescc":                            "\xe2\xaa\xa8",
"lesdot":                           "\xe2\xa9\xbf",
"lesdoto":                          "\xe2\xaa\x81",
"lesdotor":                         "\xe2\xaa\x83",
"lesges":                           "\xe2\xaa\x93",
"lg":                               "\xe2\x89\xb6",
"lgE":                              "\xe2\xaa\x91",
"Ll":                               "\xe2\x8b\x98",
"lsim":                             "\xe2\x89\xb2",
"lsime":                            "\xe2\xaa\x8d",
"lsimg":                            "\xe2\xaa\x8f",
"Lt":                               "\xe2\x89\xaa",
"ltcc":                             "\xe2\xaa\xa6",
"ltcir":                            "\xe2\xa9\xb9",
"ltdot":                            "\xe2\x8b\x96",
"ltlarr":                           "\xe2\xa5\xb6",
"ltquest":                          "\xe2\xa9\xbb",
"ltrie":                            "\xe2\x8a\xb4",
"prurel":                           "\xe2\x8a\xb0",
"rtrie":                            "\xe2\x8a\xb5",
"rtriltri":                         "\xe2\xa7\x8e",
"siml":                             "\xe2\xaa\x9d",
"simlE":                            "\xe2\xaa\x9f",
"smile":                            "\xe2\x8c\xa3",
"smt":                              "\xe2\xaa\xaa",
"smte":                             "\xe2\xaa\xac",
"Sub":                              "\xe2\x8b\x90",
"suplarr":                          "\xe2\xa5\xbb",
"trie":                             "\xe2\x89\x9c",
"vltri":                            "\xe2\x8a\xb2",
"vrtri":                            "\xe2\x8a\xb3",
"Vvdash":                           "\xe2\x8a\xaa",
"boxdl":                            "\xe2\x94\x90",
"boxdL":                            "\xe2\x95\x95",
"boxDl":                            "\xe2\x95\x96",
"boxDL":                            "\xe2\x95\x97",
"boxhd":                            "\xe2\x94\xac",
"boxhD":                            "\xe2\x95\xa5",
"boxHd":                            "\xe2\x95\xa4",
"boxHD":                            "\xe2\x95\xa6",
"boxhu":                            "\xe2\x94\xb4",
"boxhU":                            "\xe2\x95\xa8",
"boxHu":                            "\xe2\x95\xa7",
"boxHU":                            "\xe2\x95\xa9",
"boxul":                            "\xe2\x94\x98",
"boxuL":                            "\xe2\x95\x9b",
"boxUl":                            "\xe2\x95\x9c",
"boxUL":                            "\xe2\x95\x9d",
"boxvl":                            "\xe2\x94\xa4",
"boxvL":                            "\xe2\x95\xa1",
"boxVl":                            "\xe2\x95\xa2",
"boxVL":                            "\xe2\x95\xa3",
"circ":                             "\x5e",
"dblac":                            "\xcb\x9d",
"acirc":                            "\xc3\xa2",
"Acirc":                            "\xc3\x82",
"ecirc":                            "\xc3\xaa",
"Ecirc":                            "\xc3\x8a",
"icirc":                            "\xc3\xae",
"Icirc":                            "\xc3\x8e",
"ocirc":                            "\xc3\xb4",
"Ocirc":                            "\xc3\x94",
"oslash":                           "\xc3\xb8",
"ucirc":                            "\xc3\xbb",
"Ucirc":                            "\xc3\x9b",
"ccirc":                            "\xc4\x89",
"Ccirc":                            "\xc4\x88",
"gcirc":                            "\xc4\x9d",
"Gcirc":                            "\xc4\x9c",
"hcirc":                            "\xc4\xa5",
"Hcirc":                            "\xc4\xa4",
"jcirc":                            "\xc4\xb5",
"Jcirc":                            "\xc4\xb4",
"lmidot":                           "\xc5\x80",
"Lmidot":                           "\xc4\xbf",
"odblac":                           "\xc5\x91",
"Odblac":                           "\xc5\x90",
"scirc":                            "\xc5\x9d",
"Scirc":                            "\xc5\x9c",
"udblac":                           "\xc5\xb1",
"Udblac":                           "\xc5\xb0",
"wcirc":                            "\xc5\xb5",
"Wcirc":                            "\xc5\xb4",
"ycirc":                            "\xc5\xb7",
"Ycirc":                            "\xc5\xb6",
"ascr":                             "\xf0\x9d\x92\xb6",
"Ascr":                             "\xf0\x9d\x92\x9c",
"bscr":                             "\xf0\x9d\x92\xb7",
"Bscr":                             "\xe2\x84\xac",
"cscr":                             "\xf0\x9d\x92\xb8",
"Cscr":                             "\xf0\x9d\x92\x9e",
"dscr":                             "\xf0\x9d\x92\xb9",
"Dscr":                             "\xf0\x9d\x92\x9f",
"escr":                             "\xe2\x84\xaf",
"Escr":                             "\xe2\x84\xb0",
"fscr":                             "\xf0\x9d\x92\xbb",
"Fscr":                             "\xe2\x84\xb1",
"gscr":                             "\xe2\x84\x8a",
"Gscr":                             "\xf0\x9d\x92\xa2",
"hscr":                             "\xf0\x9d\x92\xbd",
"Hscr":                             "\xe2\x84\x8b",
"iscr":                             "\xf0\x9d\x92\xbe",
"Iscr":                             "\xe2\x84\x90",
"jscr":                             "\xf0\x9d\x92\xbf",
"Jscr":                             "\xf0\x9d\x92\xa5",
"kscr":                             "\xf0\x9d\x93\x80",
"Kscr":                             "\xf0\x9d\x92\xa6",
"lscr":                             "\xe2\x84\x93",
"Lscr":                             "\xe2\x84\x92",
"mscr":                             "\xf0\x9d\x93\x82",
"Mscr":                             "\xe2\x84\xb3",
"nscr":                             "\xf0\x9d\x93\x83",
"Nscr":                             "\xf0\x9d\x92\xa9",
"oscr":                             "\xe2\x84\xb4",
"Oscr":                             "\xf0\x9d\x92\xaa",
"pscr":                             "\xf0\x9d\x93\x85",
"Pscr":                             "\xf0\x9d\x92\xab",
"qscr":                             "\xf0\x9d\x93\x86",
"Qscr":                             "\xf0\x9d\x92\xac",
"rscr":                             "\xf0\x9d\x93\x87",
"Rscr":                             "\xe2\x84\x9b",
"sscr":                             "\xf0\x9d\x93\x88",
"Sscr":                             "\xf0\x9d\x92\xae",
"tscr":                             "\xf0\x9d\x93\x89",
"Tscr":                             "\xf0\x9d\x92\xaf",
"uscr":                             "\xf0\x9d\x93\x8a",
"Uscr":                             "\xf0\x9d\x92\xb0",
"vscr":                             "\xf0\x9d\x93\x8b",
"Vscr":                             "\xf0\x9d\x92\xb1",
"wscr":                             "\xf0\x9d\x93\x8c",
"Wscr":                             "\xf0\x9d\x92\xb2",
"xscr":                             "\xf0\x9d\x93\x8d",
"Xscr":                             "\xf0\x9d\x92\xb3",
"yscr":                             "\xf0\x9d\x93\x8e",
"Yscr":                             "\xf0\x9d\x92\xb4",
"zscr":                             "\xf0\x9d\x93\x8f",
"Zscr":                             "\xf0\x9d\x92\xb5",
"laquo":                            "\xc2\xab",
"larr":                             "\xe2\x86\x90",
"lcub":                             "\x7b",
"ldquo":                            "\xe2\x80\x9c",
"lpar":                             "\x28",
"lsqb":                             "\x5b",
"lsquo":                            "\xe2\x80\x98",
"middot":                           "\xc2\xb7",
"raquo":                            "\xc2\xbb",
"rdquo":                            "\xe2\x80\x9d",
"reg":                              "\xc2\xae",
"rsquo":                            "\xe2\x80\x99",
"bull":                             "\xe2\x80\xa2",
"cir":                              "\xe2\x97\x8b",
"Dagger":                           "\xe2\x80\xa1",
"dlcrop":                           "\xe2\x8c\x8d",
"dtri":                             "\xe2\x96\xbf",
"dtrif":                            "\xe2\x96\xbe",
"female":                           "\xe2\x99\x80",
"hybull":                           "\xe2\x81\x83",
"ldquor":                           "\xe2\x80\x9e",
"lozf":                             "\xe2\xa7\xab",
"lsquor":                           "\xe2\x80\x9a",
"ltri":                             "\xe2\x97\x83",
"ltrif":                            "\xe2\x97\x82",
"male":                             "\xe2\x99\x82",
"mldr":                             "\xe2\x80\xa6",
"nldr":                             "\xe2\x80\xa5",
"phone":                            "\xe2\x98\x8e",
"rect":                             "\xe2\x96\xad",
"rsquor":                           "\xe2\x80\x99",
"rtri":                             "\xe2\x96\xb9",
"rtrif":                            "\xe2\x96\xb8",
"sext":                             "\xe2\x9c\xb6",
"squf":                             "\xe2\x96\xaa",
"starf":                            "\xe2\x98\x85",
"telrec":                           "\xe2\x8c\x95",
"ulcrop":                           "\xe2\x8c\x8f",
"utri":                             "\xe2\x96\xb5",
"utrif":                            "\xe2\x96\xb4",
"aleph":                            "\xe2\x84\xb5",
"andv":                             "\xe2\xa9\x9a",
"angrt":                            "\xe2\x88\x9f",
"angsph":                           "\xe2\x88\xa2",
"apacir":                           "\xe2\xa9\xaf",
"Cconint":                          "\xe2\x88\xb0",
"compfn":                           "\xe2\x88\x98",
"Conint":                           "\xe2\x88\xaf",
"dwangle":                          "\xe2\xa6\xa6",
"epar":                             "\xe2\x8b\x95",
"eparsl":                           "\xe2\xa7\xa3",
"eqvparsl":                         "\xe2\xa7\xa5",
"exist":                            "\xe2\x88\x83",
"iinfin":                           "\xe2\xa7\x9c",
"Int":                              "\xe2\x88\xac",
"intlarhk":                         "\xe2\xa8\x97",
"lang":                             "\xe2\x8c\xa9",
"Lang":                             "\xe3\x80\x8a",
"lbbrk":                            "\xe3\x80\x94",
"le":                               "\xe2\x89\xa4",
"loang":                            "\xef\x95\x98",
"lobrk":                            "\xe3\x80\x9a",
"lopar":                            "\xe3\x80\x98",
"nhpar":                            "\xe2\xab\xb2",
"npolint":                          "\xe2\xa8\x94",
"olcross":                          "\xe2\xa6\xbb",
"orv":                              "\xe2\xa9\x9b",
"par":                              "\xe2\x88\xa5",
"Prime":                            "\xe2\x80\xb3",
"profalar":                         "\xe2\x8c\xae",
"profline":                         "\xe2\x8c\x92",
"profsurf":                         "\xe2\x8c\x93",
"qint":                             "\xe2\xa8\x8c",
"qprime":                           "\xe2\x81\x97",
"rang":                             "\xe2\x8c\xaa",
"Rang":                             "\xe3\x80\x8b",
"rppolint":                         "\xe2\xa8\x92",
"scpolint":                         "\xe2\xa8\x93",
"smeparsl":                         "\xe2\xa7\xa4",
"squarf":                           "\xe2\x96\xaa",
"tint":                             "\xe2\x88\xad",
"topcir":                           "\xe2\xab\xb1",
"tprime":                           "\xe2\x80\xb4",
"uwangle":                          "\xe2\xa6\xa7",
"vangrt":                           "\xe2\x8a\xbe",
"angle":                            "\xe2\x88\xa0",
"bigtriangledown":                  "\xe2\x96\xbd",
"bigtriangleup":                    "\xe2\x96\xb3",
"blacktriangle":                    "\xe2\x96\xb4",
"blacktriangledown":                "\xe2\x96\xbe",
"blacktriangleleft":                "\xe2\x97\x82",
"blacktriangleright":               "\xe2\x96\xb8",
"bullet":                           "\xe2\x80\xa2",
"Cayleys":                          "\xe2\x84\xad",
"circlearrowleft":                  "\xe2\x86\xba",
"circlearrowright":                 "\xe2\x86\xbb",
"circledast":                       "\xe2\x8a\x9b",
"circledcirc":                      "\xe2\x8a\x9a",
"circleddash":                      "\xe2\x8a\x9d",
"CircleDot":                        "\xe2\x8a\x99",
"circledR":                         "\xc2\xae",
"circledS":                         "\xe2\x93\x88",
"CircleMinus":                      "\xe2\x8a\x96",
"CirclePlus":                       "\xe2\x8a\x95",
"CircleTimes":                      "\xe2\x8a\x97",
"CloseCurlyDoubleQuote":            "\xe2\x80\x9d",
"complement":                       "\xe2\x88\x81",
"complexes":                        "\xe2\x84\x82",
"curvearrowleft":                   "\xe2\x86\xb6",
"DiacriticalDoubleAcute":           "\xcb\x9d",
"doublebarwedge":                   "\xe2\x8c\x86",
"DoubleContourIntegral":            "\xe2\x88\xaf",
"DoubleDot":                        "\xc2\xa8",
"DoubleDownArrow":                  "\xe2\x87\x93",
"DoubleLeftArrow":                  "\xe2\x87\x90",
"DoubleLeftRightArrow":             "\xe2\x87\x94",
"DoubleLeftTee":                    "\xe2\xab\xa4",
"DoubleLongLeftArrow":              "\xe2\x9f\xb8",
"DoubleLongLeftRightArrow":         "\xe2\x9f\xba",
"DoubleLongRightArrow":             "\xe2\x9f\xb9",
"DoubleRightArrow":                 "\xe2\x87\x92",
"DoubleRightTee":                   "\xe2\x8a\xa8",
"DoubleUpArrow":                    "\xe2\x87\x91",
"DoubleUpDownArrow":                "\xe2\x87\x95",
"DoubleVerticalBar":                "\xe2\x88\xa5",
"downharpoonleft":                  "\xe2\x87\x83",
"Element":                          "\xe2\x88\x88",
"eqslantless":                      "\xe2\x8b\x9c",
"exponentiale":                     "\xe2\x85\x87",
"gtreqless":                        "\xe2\x8b\x9b",
"gtreqqless":                       "\xe2\x8b\x9b",
"gtrless":                          "\xe2\x89\xb7",
"Hat":                              "\xcc\x82",
"hookleftarrow":                    "\xe2\x86\xa9",
"InvisibleComma":                   "\xe2\x81\xa3",
"InvisibleTimes":                   "\xe2\x81\xa2",
"langle":                           "\xe2\x8c\xa9",
"LeftAngleBracket":                 "\xe2\x8c\xa9",
"leftarrow":                        "\xe2\x86\x90",
"leftarrowtail":                    "\xe2\x86\xa2",
"LeftDoubleBracket":                "\xe3\x80\x9a",
"leftharpoondown":                  "\xe2\x86\xbd",
"leftharpoonup":                    "\xe2\x86\xbc",
"leftleftarrows":                   "\xe2\x87\x87",
"leftrightarrow":                   "\xe2\x86\x94",
"leftrightarrows":                  "\xe2\x87\x86",
"leftrightharpoons":                "\xe2\x87\x8b",
"leftrightsquigarrow":              "\xe2\x86\xad",
"LeftTeeArrow":                     "\xe2\x86\xa4",
"leftthreetimes":                   "\xe2\x8b\x8b",
"LeftTriangle":                     "\xe2\x8a\xb2",
"LeftTriangleEqual":                "\xe2\x8a\xb4",
"leq":                              "\xe2\x89\xa4",
"leqq":                             "\xe2\x89\xa6",
"leqslant":                         "\xe2\xa9\xbd",
"lessapprox":                       "\xe2\x89\xb2",
"lessdot":                          "\xe2\x8b\x96",
"lesseqgtr":                        "\xe2\x8b\x9a",
"lesseqqgtr":                       "\xe2\x8b\x9a",
"LessEqualGreater":                 "\xe2\x8b\x9a",
"lessgtr":                          "\xe2\x89\xb6",
"lesssim":                          "\xe2\x89\xb2",
"LessSlantEqual":                   "\xe2\xa9\xbd",
"Lleftarrow":                       "\xe2\x87\x9a",
"longleftarrow":                    "\xe2\x9f\xb5",
"Longleftarrow":                    "\xe2\x9f\xb8",
"longleftrightarrow":               "\xe2\x9f\xb7",
"Longleftrightarrow":               "\xe2\x9f\xba",
"looparrowleft":                    "\xe2\x86\xab",
"measuredangle":                    "\xe2\x88\xa1",
"nleftarrow":                       "\xe2\x86\x9a",
"nleftrightarrow":                  "\xe2\x86\xae",
"nleq":                             "\xe2\x89\xb0",
"nless":                            "\xe2\x89\xae",
"NotDoubleVerticalBar":             "\xe2\x88\xa6",
"NotElement":                       "\xe2\x88\x89",
"NotLeftTriangle":                  "\xe2\x8b\xaa",
"NotLeftTriangleEqual":             "\xe2\x8b\xac",
"NotLessEqual":                     "\xe2\x89\xb0",
"NotReverseElement":                "\xe2\x88\x8c",
"NotRightTriangle":                 "\xe2\x8b\xab",
"NotRightTriangleEqual":            "\xe2\x8b\xad",
"nparallel":                        "\xe2\x88\xa6",
"ntriangleleft":                    "\xe2\x8b\xaa",
"ntrianglelefteq":                  "\xe2\x8b\xac",
"ntriangleright":                   "\xe2\x8b\xab",
"ntrianglerighteq":                 "\xe2\x8b\xad",
"OpenCurlyDoubleQuote":             "\xe2\x80\x9c",
"parallel":                         "\xe2\x88\xa5",
"rangle":                           "\xe2\x8c\xaa",
"ReverseElement":                   "\xe2\x88\x8b",
"RightAngleBracket":                "\xe2\x8c\xaa",
"RightDoubleBracket":               "\xe3\x80\x9b",
"rightleftarrows":                  "\xe2\x87\x84",
"rightleftharpoons":                "\xe2\x87\x8c",
"RightTriangle":                    "\xe2\x8a\xb3",
"RightTriangleEqual":               "\xe2\x8a\xb5",
"SmallCircle":                      "\xe2\x88\x98",
"triangle":                         "\xe2\x96\xb5",
"triangledown":                     "\xe2\x96\xbf",
"triangleleft":                     "\xe2\x97\x83",
"trianglelefteq":                   "\xe2\x8a\xb4",
"triangleq":                        "\xe2\x89\x9c",
"triangleright":                    "\xe2\x96\xb9",
"trianglerighteq":                  "\xe2\x8a\xb5",
"TripleDot":                        "\xe2\x83\x9b",
"twoheadleftarrow":                 "\xe2\x86\x9e",
"upharpoonleft":                    "\xe2\x86\xbf",
"vartriangleleft":                  "\xe2\x8a\xb2",
"vartriangleright":                 "\xe2\x8a\xb3",
"DownLeftRightVector":              "\xe2\xa5\x90",
"DownLeftTeeVector":                "\xe2\xa5\x9e",
"DownLeftVectorBar":                "\xe2\xa5\x96",
"FilledSmallSquare":                "\xe2\x97\xbc",
"FilledVerySmallSquare":            "\xe2\x96\xaa",
"ic":                               "\xe2\x81\xa3",
"larrb":                            "\xe2\x87\xa4",
"LeftDownTeeVector":                "\xe2\xa5\xa1",
"LeftDownVectorBar":                "\xe2\xa5\x99",
"LeftRightVector":                  "\xe2\xa5\x8e",
"LeftTeeVector":                    "\xe2\xa5\x9a",
"LeftTriangleBar":                  "\xe2\xa7\x8f",
"LeftUpDownVector":                 "\xe2\xa5\x91",
"LeftUpTeeVector":                  "\xe2\xa5\xa0",
"LeftUpVectorBar":                  "\xe2\xa5\x98",
"LeftVectorBar":                    "\xe2\xa5\x92",
"mapstoleft":                       "\xe2\x86\xa4",
"rarrb":                            "\xe2\x87\xa5",
"RightTriangleBar":                 "\xe2\xa7\x90",
"RuleDelayed":                      "\xe2\xa7\xb4",
"LessEqualGreater":                 "\xe2\x8b\x9a",
"LessFullEqual":                    "\xe2\x89\xa6",
"LessGreater":                      "\xe2\x89\xb6",
"NotLessGreater":                   "\xe2\x89\xb8",
"NestedLessLess":                   "\xe2\x89\xaa",
"LessLess":                         "\xe2\xaa\xa1",
"LessSlantEqual":                   "\xe2\xa9\xbd",
"LessTilde":                        "\xe2\x89\xb2",
"NotLessTilde":                     "\xe2\x89\xb4",
"NestedGreaterGreater":             "\xe2\x89\xab",
"NestedLessLess":                   "\xe2\x89\xaa",
"NotCongruent":                     "\xe2\x89\xa2",
"NotCupCap":                        "\xe2\x89\xad",
"NotDoubleVerticalBar":             "\xe2\x88\xa6",
"NotEqual":                         "\xe2\x89\xa0",
"NotGreater":                       "\xe2\x89\xaf",
"NotGreaterEqual":                  "\xe2\x89\xb1",
"NotGreaterLess":                   "\xe2\x89\xb9",
"NotGreaterTilde":                  "\xe2\x89\xb5",
"NotGreaterEqual":                  "\xe2\x89\xb1",
"NotGreaterLess":                   "\xe2\x89\xb9",
"NotGreaterTilde":                  "\xe2\x89\xb5",
"NotLeftTriangle":                  "\xe2\x8b\xaa",
"NotLeftTriangleEqual":             "\xe2\x8b\xac",
"NotLeftTriangleEqual":             "\xe2\x8b\xac",
"NotLess":                          "\xe2\x89\xae",
"NotLessEqual":                     "\xe2\x89\xb0",
"NotLessGreater":                   "\xe2\x89\xb8",
"NotLessTilde":                     "\xe2\x89\xb4",
"NotLessEqual":                     "\xe2\x89\xb0",
"NotLessGreater":                   "\xe2\x89\xb8",
"NotLessTilde":                     "\xe2\x89\xb4",
"NotPrecedes":                      "\xe2\x8a\x80",
"NotPrecedesEqual":                 "\xe2\xaa\xaf",
"NotPrecedesSlantEqual":            "\xe2\x8b\xa0",
"NotPrecedesEqual":                 "\xe2\xaa\xaf",
"NotPrecedesSlantEqual":            "\xe2\x8b\xa0",
"NotRightTriangle":                 "\xe2\x8b\xab",
"NotRightTriangleEqual":            "\xe2\x8b\xad",
"NotRightTriangleEqual":            "\xe2\x8b\xad",
"NotSucceeds":                      "\xe2\x8a\x81",
"NotSucceedsSlantEqual":            "\xe2\x8b\xa1",
"NotSucceedsSlantEqual":            "\xe2\x8b\xa1",
"NotTilde":                         "\xe2\x89\x81",
"NotTildeEqual":                    "\xe2\x89\x84",
"NotTildeFullEqual":                "\xe2\x89\x87",
"NotTildeTilde":                    "\xe2\x89\x89",
"NotTildeEqual":                    "\xe2\x89\x84",
"NotTildeFullEqual":                "\xe2\x89\x87",
"NotTildeTilde":                    "\xe2\x89\x89",
"NotVerticalBar":                   "\xe2\x88\xa4",
"NotPrecedes":                      "\xe2\x8a\x80",
"NotPrecedesEqual":                 "\xe2\xaa\xaf",
"NotPrecedesSlantEqual":            "\xe2\x8b\xa0",
"Precedes":                         "\xe2\x89\xba",
"PrecedesEqual":                    "\xe2\xaa\xaf",
"PrecedesSlantEqual":               "\xe2\x89\xbc",
"PrecedesTilde":                    "\xe2\x89\xbe",
"NotPrecedesEqual":                 "\xe2\xaa\xaf",
"PrecedesEqual":                    "\xe2\xaa\xaf",
"NotPrecedesSlantEqual":            "\xe2\x8b\xa0",
"PrecedesSlantEqual":               "\xe2\x89\xbc",
"PrecedesTilde":                    "\xe2\x89\xbe",
"Proportion":                       "\xe2\x88\xb7",
"Proportional":                     "\xe2\x88\x9d",
"Proportional":                     "\xe2\x88\x9d",
"ReverseEquilibrium":               "\xe2\x87\x8b",
"NotRightTriangle":                 "\xe2\x8b\xab",
"NotRightTriangleEqual":            "\xe2\x8b\xad",
"RightTriangle":                    "\xe2\x8a\xb3",
"RightTriangleEqual":               "\xe2\x8a\xb5",
"RightTriangleBar":                 "\xe2\xa7\x90",
"RightTriangleBar":                 "\xe2\xa7\x90",
"NotRightTriangleEqual":            "\xe2\x8b\xad",
"RightTriangleEqual":               "\xe2\x8a\xb5",
"NotSucceeds":                      "\xe2\x8a\x81",
"NotSucceedsSlantEqual":            "\xe2\x8b\xa1",
"Succeeds":                         "\xe2\x89\xbb",
"SucceedsEqual":                    "\xe2\x89\xbd",
"SucceedsSlantEqual":               "\xe2\x89\xbd",
"SucceedsTilde":                    "\xe2\x89\xbf",
"SucceedsEqual":                    "\xe2\x89\xbd",
"NotSucceedsSlantEqual":            "\xe2\x8b\xa1",
"SucceedsSlantEqual":               "\xe2\x89\xbd",
"SucceedsTilde":                    "\xe2\x89\xbf",
"DiacriticalTilde":                 "\xcb\x9c",
"EqualTilde":                       "\xe2\x89\x82",
"GreaterTilde":                     "\xe2\x89\xb3",
"LessTilde":                        "\xe2\x89\xb2",
"NotGreaterTilde":                  "\xe2\x89\xb5",
"NotLessTilde":                     "\xe2\x89\xb4",
"NotTilde":                         "\xe2\x89\x81",
"NotTildeEqual":                    "\xe2\x89\x84",
"NotTildeFullEqual":                "\xe2\x89\x87",
"NotTildeTilde":                    "\xe2\x89\x89",
"PrecedesTilde":                    "\xe2\x89\xbe",
"SucceedsTilde":                    "\xe2\x89\xbf",
"Tilde":                            "\xe2\x88\xbc",
"TildeEqual":                       "\xe2\x89\x83",
"TildeFullEqual":                   "\xe2\x89\x85",
"TildeTilde":                       "\xe2\x89\x88",
"VerticalTilde":                    "\xe2\x89\x80",
"NotTildeEqual":                    "\xe2\x89\x84",
"TildeEqual":                       "\xe2\x89\x83",
"NotTildeFullEqual":                "\xe2\x89\x87",
"TildeFullEqual":                   "\xe2\x89\x85",
"NotTildeTilde":                    "\xe2\x89\x89",
"TildeTilde":                       "\xe2\x89\x88",
"UpTee":                            "\xe2\x8a\xa5",
"UpTeeArrow":                       "\xe2\x86\xa5",
"LeftUpTeeVector":                  "\xe2\xa5\xa0",
"RightUpTeeVector":                 "\xe2\xa5\x9c",
"DoubleVerticalBar":                "\xe2\x88\xa5",
"NotDoubleVerticalBar":             "\xe2\x88\xa6",
"NotVerticalBar":                   "\xe2\x88\xa4",
"VerticalBar":                      "\xe2\x88\xa3",
"SquareUnion":                      "\xe2\x8a\x94",
"SquareUnion":                      "\xe2\x8a\x94",
"Union":                            "\xe2\x8b\x83",
"UnionPlus":                        "\xe2\x8a\x8e",
"UnionPlus":                        "\xe2\x8a\x8e",
"Intersection":                     "\xe2\x8b\x82",
"SquareIntersection":               "\xe2\x8a\x93",
"MinusPlus":                        "\xe2\x88\x93",
"PlusMinus":                        "\xc2\xb1",
"SquareIntersection":               "\xe2\x8a\x93",
"Vee":                              "\xe2\x8b\x81",
"CircleMinus":                      "\xe2\x8a\x96",
"CirclePlus":                       "\xe2\x8a\x95",
"Sum":                              "\xe2\x88\x91",
"SquareUnion":                      "\xe2\x8a\x94",
"Union":                            "\xe2\x8b\x83",
"UnionPlus":                        "\xe2\x8a\x8e",
"UnionPlus":                        "\xe2\x8a\x8e",
"CircleMinus":                      "\xe2\x8a\x96",
"CirclePlus":                       "\xe2\x8a\x95",
"ClockwiseContourIntegral":         "\xe2\x88\xb2",
"CounterClockwiseContourIntegral":  "\xe2\x88\xb3",
"ClockwiseContourIntegral":         "\xe2\x88\xb2",
"ContourIntegral":                  "\xe2\x88\xae",
"CounterClockwiseContourIntegral":  "\xe2\x88\xb3",
"DoubleContourIntegral":            "\xe2\x88\xaf",
"CounterClockwiseContourIntegral":  "\xe2\x88\xb3",
"DoubleContourIntegral":            "\xe2\x88\xaf",
"ClockwiseContourIntegral":         "\xe2\x88\xb2",
"ContourIntegral":                  "\xe2\x88\xae",
"CounterClockwiseContourIntegral":  "\xe2\x88\xb3",
"DoubleContourIntegral":            "\xe2\x88\xaf",
"Integral":                         "\xe2\x88\xab",
"Cup":                              "\xe2\x8b\x93",
"CupCap":                           "\xe2\x89\x8d",
"NotCupCap":                        "\xe2\x89\xad",
"Cap":                              "\xe2\x8b\x92",
"CapitalDifferentialD":             "\xe2\x85\x85",
"CupCap":                           "\xe2\x89\x8d",
"NotCupCap":                        "\xe2\x89\xad",
"VerticalTilde":                    "\xe2\x89\x80",
"Wedge":                            "\xe2\x8b\x80",
"CircleTimes":                      "\xe2\x8a\x97",
"Coproduct":                        "\xe2\x88\x90",
"Product":                          "\xe2\x88\x8f",
"Intersection":                     "\xe2\x8b\x82",
"SquareIntersection":               "\xe2\x8a\x93",
"Coproduct":                        "\xe2\x88\x90",
"Star":                             "\xe2\x8b\x86",
"CircleDot":                        "\xe2\x8a\x99",
"InvisibleTimes":                   "\xe2\x81\xa2",
"CenterDot":                        "\xc2\xb7",
"CircleTimes":                      "\xe2\x8a\x97",
"Vee":                              "\xe2\x8b\x81",
"Wedge":                            "\xe2\x8b\x80",
"Diamond":                          "\xe2\x8b\x84",
"Backslash":                        "\xe2\x88\x96",
"MinusPlus":                        "\xe2\x88\x93",
"PlusMinus":                        "\xc2\xb1",
"Cross":                            "\xe2\xa8\xaf",
"CircleDot":                        "\xe2\x8a\x99",
"SmallCircle":                      "\xe2\x88\x98",
"NotSquareSubsetEqual":             "\xe2\x8b\xa2",
"NotSquareSupersetEqual":           "\xe2\x8b\xa3",
"Square":                           "\xe2\x96\xa1",
"SquareIntersection":               "\xe2\x8a\x93",
"SquareSubset":                     "\xe2\x8a\x8f",
"SquareSubsetEqual":                "\xe2\x8a\x91",
"SquareSuperset":                   "\xe2\x8a\x90",
"SquareSupersetEqual":              "\xe2\x8a\x92",
"SquareUnion":                      "\xe2\x8a\x94",
"EmptySmallSquare":                 "\xe2\x97\xbb",
"EmptyVerySmallSquare":             "\xe2\x96\xab",
"FilledSmallSquare":                "\xe2\x97\xbc",
"FilledVerySmallSquare":            "\xe2\x96\xaa",
"Delta":                            "\xce\x94",
"Del":                              "\xe2\x88\x87",
"RuleDelayed":                      "\xe2\xa7\xb4",
"PartialD":                         "\xe2\x88\x82",
"CapitalDifferentialD":             "\xe2\x85\x85",
"CapitalDifferentialD":             "\xe2\x85\x85",
"DifferentialD":                    "\xe2\x85\x86",
"Sqrt":                             "\xe2\x88\x9a",
"DoubleDownArrow":                  "\xe2\x87\x93",
"DoubleLongLeftArrow":              "\xe2\x9f\xb8",
"DoubleLongLeftRightArrow":         "\xe2\x9f\xba",
"DoubleLongRightArrow":             "\xe2\x9f\xb9",
"DoubleUpArrow":                    "\xe2\x87\x91",
"DoubleUpDownArrow":                "\xe2\x87\x95",
"DoubleDownArrow":                  "\xe2\x87\x93",
"DoubleUpDownArrow":                "\xe2\x87\x95",
"DownArrow":                        "\xe2\x86\x93",
"DownArrowUpArrow":                 "\xe2\x87\xb5",
"UpArrowDownArrow":                 "\xe2\x87\x85",
"UpDownArrow":                      "\xe2\x86\x95",
"DownArrowBar":                     "\xe2\xa4\x93",
"DownArrowBar":                     "\xe2\xa4\x93",
"DownArrowUpArrow":                 "\xe2\x87\xb5",
"DownTeeArrow":                     "\xe2\x86\xa7",
"LeftDownTeeVector":                "\xe2\xa5\xa1",
"LeftDownVector":                   "\xe2\x87\x83",
"LeftDownVectorBar":                "\xe2\xa5\x99",
"LeftDownVectorBar":                "\xe2\xa5\x99",
"LeftUpDownVector":                 "\xe2\xa5\x91",
"LeftUpTeeVector":                  "\xe2\xa5\xa0",
"LeftUpVector":                     "\xe2\x86\xbf",
"LeftUpVectorBar":                  "\xe2\xa5\x98",
"LeftUpVectorBar":                  "\xe2\xa5\x98",
"DoubleLongLeftArrow":              "\xe2\x9f\xb8",
"LongLeftArrow":                    "\xe2\x9f\xb5",
"DoubleLongLeftRightArrow":         "\xe2\x9f\xba",
"LongLeftRightArrow":               "\xe2\x9f\xb7",
"DoubleLongRightArrow":             "\xe2\x9f\xb9",
"LongRightArrow":                   "\xe2\x9f\xb6",
"ReverseUpEquilibrium":             "\xe2\xa5\xaf",
"RightDownTeeVector":               "\xe2\xa5\x9d",
"RightDownVector":                  "\xe2\x87\x82",
"RightDownVectorBar":               "\xe2\xa5\x95",
"RightDownVectorBar":               "\xe2\xa5\x95",
"RightUpDownVector":                "\xe2\xa5\x8f",
"RightUpTeeVector":                 "\xe2\xa5\x9c",
"RightUpVector":                    "\xe2\x86\xbe",
"RightUpVectorBar":                 "\xe2\xa5\x94",
"RightUpVectorBar":                 "\xe2\xa5\x94",
"DoubleUpArrow":                    "\xe2\x87\x91",
"DownArrowUpArrow":                 "\xe2\x87\xb5",
"UpArrow":                          "\xe2\x86\x91",
"UpArrowDownArrow":                 "\xe2\x87\x85",
"UpArrowBar":                       "\xe2\xa4\x92",
"UpArrowBar":                       "\xe2\xa4\x92",
"UpArrowDownArrow":                 "\xe2\x87\x85",
"DoubleUpDownArrow":                "\xe2\x87\x95",
"UpDownArrow":                      "\xe2\x86\x95",
"ReverseUpEquilibrium":             "\xe2\xa5\xaf",
"UpEquilibrium":                    "\xe2\xa5\xae",
"UpTeeArrow":                       "\xe2\x86\xa5",
"ApplyFunction":                    "\xe2\x81\xa1",
"Breve":                            "\xcb\x98",
"DownBreve":                        "\xcc\x91",
"Cedilla":                          "\xc2\xb8",
"DiacriticalGrave":                 "\x60",
"DiacriticalDot":                   "\xcb\x99",
"DiacriticalDoubleAcute":           "\xcb\x9d",
"DiacriticalAcute":                 "\xc2\xb4",
"DiacriticalTilde":                 "\xcb\x9c",
"DoubleDot":                        "\xc2\xa8",
"DownBreve":                        "\xcc\x91",
"Hacek":                            "\xcb\x87",
"Hat":                              "\xcc\x82",
"OverBar":                          "\xc2\xaf",
"OverBrace":                        "\xef\xb8\xb7",
"OverBracket":                      "\xe2\x8e\xb4",
"OverParenthesis":                  "\xef\xb8\xb5",
"TripleDot":                        "\xe2\x83\x9b",
"UnderBar":                         "\xcc\xb2",
"UnderBrace":                       "\xef\xb8\xb8",
"UnderBracket":                     "\xe2\x8e\xb5",
"UnderParenthesis":                 "\xef\xb8\xb6",

}

map = {}
for key, val in map_utf8.iteritems():
    try:
	map[key] = val.decode("utf-8")
    except: continue
