#!/usr/bin/env python
import logging
import re
from distutils.core import setup, Command
from unittest import TestLoader, TextTestRunner

from sys import version
assert version >= '2.6', 'This package requires python 2.6 at least. Sorry.'

def get_version():
    """Parse __init__.py for version info, we cannot import it"""
    version_re = re.compile(r'\s*__VERSION__\s*=\s*("|\')([\w\.\+]+)(\1)')
    with open('mediagoblin_licenses/__init__.py', 'rt') as file:
        for line in file:
            if version_re.match(line):
                return version_re.match(line).group(2)
__VERSION__ = get_version()

class TestCommand(Command):
    """runs the OLI testsuite"""
    description = """Runs the test suite. In order to execute only a single
        test, you could also issue e.g. 'python -m unittest
        test.tests.test_01_basic.TestBasicFunctions.test_01_olistartup' on the
        command line."""
    user_options = []

    def initialize_options(self):
        pass
    def finalize_options(self):
        pass

    def run(self):
        logging.basicConfig(format='%(message)s')
        suite = TestLoader().discover('./test')
        #TODO: failfast does not seem to exist in python2.6?
        TextTestRunner(verbosity=2,failfast=True).run(suite)


setup(name='mediagoblin-licenses',
      version=__VERSION__,
      description='Customize the licenses for your mediagoblin installation',
      author='Sebastian Spaeth',
      author_email='Sebastian@SSpaeth.de',
      url='https://gitorious.org/mediagoblin-licenses/mediagoblin-licenses',
      download_url='https://gitorious.org/mediagoblin-licenses/mediagoblin-licenses/archive-tarball/mediagoblin-licenses-v' + __VERSION__,
      # http://bugs.python.org/issue13943. Must not be unicode...
      packages=['mediagoblin_licenses'],
      package_data = {'mediagoblin_licenses': ['README.rst']},
      license=(b'License :: OSI Approved :: GNU Affero General Public License '
               b'v3 or later (AGPLv3+)'),
      cmdclass = { 'test': TestCommand},
     )
