# GNU MediaGoblin -- federated, autonomous media hosting
# Copyright (C) 2011, 2012 MediaGoblin contributors.  See AUTHORS.
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
from __future__ import unicode_literals
import unittest
import logging

from configobj import ConfigObj

try:
    import mediagoblin
except ImportError:
    raise ImportError("The mediagoblin_licenses plugin tests require an installed mediagoblin package")
from mediagoblin.tools import licenses
import mediagoblin_licenses



def setUpModule():
    #logging.info("Set Up test module %s" % __name__)
    TestLicenseCustomization.orig_licenses = licenses.SORTED_LICENSES

#def tearDownModule():
    #logging.info("Tear Down test module")
    # comment out next line to keep testdir after test runs. TODO: make nicer
    #OLITestLib.delete_test_dir()

#Stuff that can be used
#self.assertEqual(self.seq, range(10))
# should raise an exception for an immutable sequence
#self.assertRaises(TypeError, random.shuffle, (1,2,3))
#self.assertTrue(element in self.seq)
#self.assertFalse(element in self.seq)

class TestLicenseCustomization(unittest.TestCase):
    """While the other test files test OfflineImap as a program, these
    tests directly invoke internal helper functions to guarantee that
    they deliver results as expected"""

    #@classmethod def setUpClass(cls): #This is run before all tests in this class

    def setUp(self):
        #This is run before each test in this class
        # Reset MediaGoblin to standard licenses
        licenses.SORTED_LICENSES = TestLicenseCustomization.orig_licenses
        licenses.SUPPORTED_LICENSES = dict(((l.uri, l) for l in licenses.SORTED_LICENSES))
        # Reset Plugin to original state
        mediagoblin_licenses.CustomLicenses.SORTED_PLUGIN_LICENSES = []
        mediagoblin_licenses.CustomLicenses._setup_plugin_called = 0
        # Load configuration
        mediagoblin.mg_globals.global_config = ConfigObj('test/mediagoblin.ini')


    def test_license_replacing(self):
        """Use customized license"""
        mediagoblin_licenses.CustomLicenses.setup_plugin()
        # Do we have a single license configured now?
        self.assertEqual(len(licenses.SORTED_LICENSES), 1)

    def test_license_addition(self):
        """Add customized licenses to default licenses"""
        # Append rather replace licenses
        mediagoblin.mg_globals.global_config['plugins']['mediagoblin_licenses']['append'] = "True"
        mediagoblin_licenses.CustomLicenses.setup_plugin()

        # Do we have 9+1 licenses now?
        self.assertEqual(len(licenses.SORTED_LICENSES), 10)
        # Have MediaGoblin licenses be set properly?
        self.assertEqual(mediagoblin_licenses.CustomLicenses.SORTED_PLUGIN_LICENSES,
                         licenses.SORTED_LICENSES)
