from zope.schema.vocabulary import SimpleVocabulary, SimpleTerm
from zope.schema.interfaces import IVocabularyFactory
from zope.interface import directlyProvides
from zope.i18nmessageid import MessageFactory

_ = MessageFactory('medialog.googlefonts')


FONTS = [ "Abel",  "Abril Fatface",  "Aclonica",  "Allan",  "Allerta Stencil",  "Allerta",  "Amaranth",  "Annie Use Your Telescope",  "Anonymous Pro",  "Anton",  "Architects Daughter",  "Arimo",  "Arvo",  "Astloch",  "Bangers",  "Bentham",  "Bevan",  "Buda",  "Cabin",  "Calligraffitti",  "Candal",  "Cantarell",  "Cardo",  "Cherry Cream Soda",  "Chewy",  "Coda",  "Coming Soon",  "Copse",  "Corben",  "Cousine",  "Covered By Your Grace",  "Crafty Girls",  "Crimson Text",  "Crushed",  "Cuprum",  "Damion",  "Dancing Script",  "Dawning of a New Day",  "Droid Sans Mono",  "Droid Sans",  "Droid Serif",  "EB Garamond",  "Expletus Sans",  "Fontdiner Swanky",  "Geo",  "Goudy Bookletter 1911",  "Gruppo",  "Homemade Apple",  "IM Fell",  "Inconsolata",  "Indie Flower",  "Irish Grover",  "Josefin Sans",  "Josefin Slab",  "Just Another Hand",  "Just Me Again Down Here",  "Kenia",  "Kranky",  "Kreon",  "Kristi",  "Lato",  "League Script",  "Lekton",  "Lobster",  "Luckiest Guy",  "Maiden Orange",  "Meddon",  "MedievalSharp",  "Merriweather",  "Michroma",  "Miltonian",  "Molengo",  "Montserrat",  "Neucha",  "News Cycle",  "Nobile",  "Nova Round",  "OFL Sorts Mill Goudy TT",  "Old Standard TT",  "Orbitron",  "Oswald",  "Over the Rainbow",  "Pacifico by Vernon Adams ",  "Pacifico",  "Permanent Marker",  "Philosopher",  "PT Sans",  "PT Serif",  "Puritan",  "Quattrocento Sans",  "Quattrocento",  "Radley by Vernon Adams",  "Radley",  "Raleway",  "Reenie Beanie",  "Rock Salt",  "Schoolbell",  "Six Caps",  "Slackey",  "Smythe",  "Sniglet",  "Special Elite",  "Sue Ellen Francisco",  "Sunshiney",  "Swanky and Moo Moo",  "Syncopate",  "Tangerine",  "Terminal Dosis Light",  "The Girl Next Door",  "Tinos",  "Ubuntu",  "UnifrakturMaguntia",  "Unkempt",  "Vibur", "Vollkorn",  "VT323",  "Waiting for the Sunrise",  "Yanone Kaffeesatz",        "** ----- more fonts ----- **", "ABeeZee", "Acme", "Actor", "Adamina", "Advent Pro", "Aguafina Script", "Akronim", "Aladin", "Aldrich", "Alef", "Alegreya Sans SC", "Alegreya Sans", "Alegreya SC", "Alegreya", "Alex Brush", "Alfa Slab One", "Alice", "Alike Angular", "Alike", "Allura", "Almendra Display", "Almendra SC", "Almendra", "Amarante", "Amatic SC", "Amethysta", "Anaheim", "Andada", "Andika", "Antic Didone", "Antic Slab", "Antic", "Arapey", "Arbutus Slab", "Arbutus", "Archivo Black", "Archivo Narrow", "Arizonia", "Armata", "Artifika", "Asap", "Asset", "Asul", "Atomic Age", "Aubrey", "Audiowide", "Autour One", "Average Sans", "Average", "Averia Gruesa Libre", "Averia Libre", "Averia Sans Libre", "Averia Serif Libre", "Bad Script", "Balthazar", "Basic", "Baumans", "Belgrano", "Belleza", "BenchNine", "Berkshire Swash", "Bigelow Rules", "Bigshot One", "Bilbo Swash Caps", "Bilbo", "Bitter", "Black Ops One", "Bonbon", "Boogaloo", "Bowlby One SC", "Bowlby One", "Brawler", "Bree Serif", "Bubblegum Sans", "Bubbler One", "Buenard", "Butcherman", "Butterfly Kids", "Cabin Condensed", "Cabin Sketch", "Caesar Dressing", "Cagliostro", "Cambo", "Cantata One", "Cantora One", "Capriola", "Carme", "Carrois Gothic SC", "Carrois Gothic", "Carter One", "Caudex", "Cedarville Cursive", "Ceviche One", "Changa One", "Chango", "Chau Philomene One", "Chela One", "Chelsea Market", "Cherry Swash", "Chicle", "Chivo", "Cinzel Decorative", "Cinzel", "Clicker Script", "Coda Caption", "Codystar", "Combo", "Comfortaa", "Concert One", "Condiment", "Contrail One", "Convergence", "Cookie", "Courgette", "Coustard", "Creepster", "Crete Round", "Croissant One", "Cutive Mono", "Cutive", "Days One", "Delius Swash Caps", "Delius Unicase", "Delius", "Della Respira", "Denk One", "Devonshire", "Didact Gothic", "Diplomata SC", "Diplomata", "Domine", "Donegal One", "Doppio One", "Dorsa", "Dosis", "Dr Sugiyama", "Duru Sans", "Dynalight", "Eagle Lake", "Eater", "Economica", "Electrolize", "Elsie Swash Caps", "Elsie", "Emblema One", "Emilys Candy", "Engagement", "Englebert", "Enriqueta", "Erica One", "Esteban", "Euphoria Script", "Ewert", "Exo 2", "Exo", "Fanwood Text", "Fascinate Inline", "Fascinate", "Faster One", "Fauna One", "Federant", "Federo", "Felipa", "Fenix", "Finger Paint", "Fjalla One", "Fjord One", "Flamenco", "Flavors", "Fondamento", "Forum", "Francois One", "Freckle Face", "Fredericka the Great", "Fredoka One", "Fresca", "Frijole", "Fruktur", "Fugaz One", "Gabriela", "Gafata", "Galdeano", "Galindo", "Gentium Basic", "Gentium Book Basic", "Geostar Fill", "Geostar", "Germania One", "Gilda Display", "Give You Glory", "Glass Antiqua", "Glegoo", "Gloria Hallelujah", "Goblin One", "Gochi Hand", "Gorditas", "Graduate", "Grand Hotel", "Gravitas One", "Great Vibes", "Griffy", "Gudea", "Habibi", "Hammersmith One", "Hanalei Fill", "Hanalei", "Handlee", "Happy Monkey", "Headland One", "Henny Penny", "Herr Von Muellerhoff", "Holtwood One SC", "Homenaje", "Iceberg", "Iceland", "IM Fell Double Pica SC", "IM Fell Double Pica", "IM Fell DW Pica SC", "IM Fell DW Pica", "IM Fell English SC", "IM Fell English", "IM Fell French Canon SC", "IM Fell French Canon", "IM Fell Great Primer SC", "IM Fell Great Primer", "Imprima", "Inder", "Inika", "Istok Web", "Italiana", "Italianno", "Jacques Francois Shadow", "Jacques Francois", "Jim Nightshade", "Jockey One", "Jolly Lodger", "Joti One", "Judson", "Julee", "Julius Sans One", "Junge", "Jura", "Kameron", "Karla", "Kaushan Script", "Kavoon", "Keania One", "Kelly Slab", "Kite One", "Knewave", "Kotta One", "Krona One", "La Belle Aurore", "Lancelot", "Leckerli One", "Ledger", "Lemon", "Libre Baskerville", "Life Savers", "Lilita One", "Lily Script One", "Limelight", "Linden Hill", "Lobster Two", "Londrina Outline", "Londrina Shadow", "Londrina Sketch", "Londrina Solid", "Lora", "Love Ya Like A Sister", "Loved by the King", "Lovers Quarrel", "Lusitana", "Lustria", "Macondo Swash Caps", "Macondo", "Magra", "Mako", "Marcellus SC", "Marcellus", "Marck Script", "Margarine", "Marko One", "Marmelad", "Marvel", "Mate SC", "Mate", "Maven Pro", "McLaren", "Medula One", "Megrim", "Meie Script", "Merienda One", "Merienda", "Merriweather Sans", "Metal Mania", "Metamorphous", "Metrophobic", "Milonga", "Miltonian Tattoo", "Miniver", "Miss Fajardose", "Modern Antiqua", "Molle", "Monda", "Monofett", "Monoton", "Monsieur La Doulaise", "Montez", "Montserrat Alternates", "Montserrat Subrayada", "Mountains of Christmas", "Mouse Memoirs", "Mr Bedfort", "Mr Dafoe", "Mr De Haviland", "Mrs Saint Delafield", "Mrs Sheppards", "Muli", "Mystery Quest", "Neuton", "New Rocker", "Niconne", "Nixie One", "Norican", "Nosifer", "Nothing You Could Do", "Noticia Text", "Noto Sans", "Noto Serif", "Nova Cut", "Nova Flat", "Nova Mono", "Nova Oval", "Nova Script", "Nova Slim", "Nova Square", "Numans", "Nunito", "Offside", "Oldenburg", "Oleo Script Swash Caps", "Oleo Script", "Open Sans Condensed", "Open Sans", "Oranienbaum", "Oregano", "Orienta", "Original Surfer", "Overlock SC", "Overlock", "Ovo", "Oxygen Mono", "Paprika", "Parisienne", "Passero One", "Passion One", "Pathway Gothic One", "Patrick Hand SC", "Patrick Hand", "Patua One", "Paytone One", "Peralta", "Petit Formal Script", "Petrona", "Piedra", "Pinyon Script", "Pirata One", "Plaster", "Play", "Playball", "Playfair Display SC", "Playfair Display", "Podkova", "Poiret One", "Poller One", "Poly", "Pompiere", "Pontano Sans", "Port Lligat Sans", "Port Lligat Slab", "Prata", "Press Start 2P", "Princess Sofia", "Prociono", "Prosto One", "PT Mono", "PT Sans Caption", "PT Sans Narrow", "PT Serif Caption", "Purple Purse", "Quando", "Quantico", "Questrial", "Quicksand", "Quintessential", "Qwigley", "Racing Sans One", "Raleway Dots", "Rambla", "Rammetto One", "Ranchers", "Rancho", "Rationale", "Redressed", "Revalia", "Ribeye Marrow", "Ribeye", "Righteous", "Risque", "Roboto Condensed", "Roboto Slab", "Roboto", "Rochester", "Rokkitt", "Romanesco", "Ropa Sans", "Rosario", "Rosarivo", "Rouge Script", "Ruda", "Rufina", "Ruge Boogie", "Ruluko", "Rum Raisin", "Ruslan Display", "Russo One", "Ruthie", "Rye", "Sacramento", "Sail", "Salsa", "Sanchez", "Sancreek", "Sansita One", "Sarina", "Satisfy", "Scada", "Seaweed Script", "Sevillana", "Seymour One", "Shadows Into Light Two", "Shadows Into Light", "Shanti", "Share Tech Mono", "Share Tech", "Share", "Shojumaru", "Short Stack", "Sigmar One", "Signika Negative", "Signika", "Simonetta", "Sintony", "Sirin Stencil", "Skranji", "Smokum", "Snippet", "Snowburst One", "Sofadi One", "Sofia", "Sonsie One", "Sorts Mill Goudy", "Source Code Pro", "Source Sans Pro", "Spicy Rice", "Spinnaker", "Spirax", "Squada One", "Stalemate", "Stalinist One", "Stardos Stencil", "Stint Ultra Condensed", "Stint Ultra Expanded", "Stoke", "Strait", "Supermercado One", "Tauri", "Telex", "Tenor Sans", "Text Me One", "Tienne", "Titan One", "Titillium Web", "Trade Winds", "Trocchi", "Trochut", "Trykker", "Tulpen One", "Ubuntu Condensed", "Ubuntu Mono", "Ultra", "Uncial Antiqua", "Underdog", "Unica One", "UnifrakturCook", "Unlock", "Unna", "Vampiro One", "Varela Round", "Varela", "Vast Shadow", "Vidaloka", "Viga", "Voces", "Volkhov", "Voltaire", "Wallpoet", "Walter Turncoat", "Warnes", "Wellfleet", "Wendy One", "Wire One", "Yellowtail", "Yeseva One", "Yesteryear", "Zeyada",
         ]


def format_font(font):
    return font.replace(" ", "+")


def FontsVocabulary(context):
    terms = [SimpleTerm(value=format_font(pair),
                        token=format_font(pair),
                        title=pair) for pair in FONTS]
    return SimpleVocabulary(terms)


directlyProvides(FontsVocabulary, IVocabularyFactory)
