# Megafeed

A library for serializing complex django querysets

## Example

To enable megafeed system wide in your Django application, edit your settings.py file and add to your MIDDLEWARE_CLASSES:

    'utils.middleware.MegaMiddleware',

add megafeed to your installed apps, and add an entry to your urls.py:

    (r'^feed', 'megafeed.views.mega_feed'),

Using the following model:

    from django.db import models
    from django.contrib.auth.models import User
    
    class Blog(models.Model):
        DRAFT, PUBLISHED = range(2)
        BLOG_STATUS = ( 
            (DRAFT, 'Draft'),
            (PUBLISHED, 'Published')
            )   
        title   = models.CharField(max_length=64)
        slug    = models.SlugField()
        content = models.TextField()
        created = models.DateTimeField(auto_now=True)
        status  = models.IntegerField(choices=BLOG_STATUS)
        enable_comments = models.BooleanField(default=True)
        author = models.ForeignKey(User)
    
        def __unicode__(self): return self.title
    
        @models.permalink
        def get_absolute_url(self): 
            return ('view_blog_post', (), {
                'year': self.created.year,
                'month': self.created.month,
                'day': self.created.day,
                'slug': self.slug})
    
    import megafeed
    megafeed.register(Blog)

example megafeed url:

    /feeds.json?blog={"title":"test","order":"-created"}@

json response:

    {"response": {"blog": {"object_list": [{"blog":
    {"status": 0, "author": {"id": 1}, "created": "2010-06-16 14:49:34", "title": "test", "id": 1, "content": "test", "enable_comments": true, "slug": "test"}}],
    "type": "blog", "page_data": {"per_page": 10, "current_page": 1, "page_count": 1, "object_count": 1}, "filter_list": {"enable_comments": 1, "order": "-created", "title": "test"}}}}

Megafeed can also be accessed as [megafeed.megafeed(Model)](http://github.com/ff0000/megafeed/blob/master/megafeed/megafeed.py#L84) or [Model.megafeed()](http://github.com/ff0000/megafeed/blob/master/megafeed/megafeed.py#L61)

* For ease of inclusion in views, request.GET can be passed directly to as params to a megafeed and it will be appropriately modified with defaults.
* Model.megafeed also includes request_params which will only apply filters if they match the prefix value, e.g. blog_page=2

## MegaFeed Tag

Continuing on from the [[MegaFeed Example]]

The example megafeed url:

    /feeds.json?blog={"title":"test","order":"-created"}

becomes

    {% load megafeed_tags %}
    {% megafeed blog title "test" order "-created" as blogs %}

which can be used as

    {% for blog in blogs.object_list %}
    <a href="{{blog.get_absolute_url}}">{{blog.title}}</a>
    {% endfor %}

Note that the **blogs** variable contains object_list, page_data, and filter_list as in the [[MegaFeed Example]] JSON.

