﻿#This file was originally generated by PyScripter's unitest wizard

import unittest
from megaplanpy import Megaplan


class TestMegaplan(unittest.TestCase):

    CODE = 'cp1251'

    def setUp(self):
        account = ''
        login = ''
        password = ''
        self.my_name = '' # 'my name, is the same as in Megaplan'
        self.mplan = Megaplan(account, login, password)

    def tearDown(self):
        del self.mplan

    def PrintDict(self, D):
        tmpl1 = '{0}: {1}'
        tmpl2 = '    {0}: {1}'
        for key, value in D.iteritems():
            if isinstance(value, dict):
                print('{0}:'.format(key))
                for k, v in value.iteritems():
                    if isinstance(v, (str, unicode)):
                        print(tmpl2.format(k, v.encode(self.CODE)))
                    else:
                        print(tmpl2.format(k, v))
            else:
                if isinstance(value, (str, unicode)):
                    print(tmpl1.format(key, value.encode(self.CODE)))
                else:
                    print(tmpl1.format(key, value))

    def Tasks(self):

        def Print(tasks):
            print('********' * 10)
            for task in tasks:
                print('--------' * 10)
                self.PrintDict(task)

        tasks = self.mplan.Tasks().data['tasks']
        self.assertNotEqual(tasks, None)
        Print(tasks)

    def TaskCard(self):

        def Print(task_card):
            print('********' * 10)
            self.PrintDict(task_card)

        task_card = self.mplan.TaskCard(self.task_id).data['task']
        self.assertNotEqual(task_card, None)
        Print(task_card)

    def TaskCreate(self):
        def Print(created_task):
            print('********' * 10)
            print(' ' * 20 + 'TASK create')
            print(created_task)

        params = {
            'Model[Name]': 'New test task',
            #'Model[Deadline]': '2011-02-05 12:00',
            #'Model[DeadlineDate]': '2011-02-05',
            #'Model[DeadlineType]': 'soft',
            'Model[Responsible]': self.self_id,
            #'Model[Executors]': '0',
            #'Model[Auditors]': '0',
            #'Model[Severity]': '1',
            #'Model[SuperTask]': '0',
            #'Model[Customer]': '0',
            #'Model[IsGroup]': '0',
            'Model[Statement]': 'Create new test task from Python'
        }
        created_task = self.mplan.TaskCreate(**params).data['task']
        self.assertNotEqual(created_task, None)
        Print(created_task)
        self.task_id = created_task['Id']

    def TaskEdit(self):
        def Print(edit_task):
            print('********' * 10)
            print(' ' * 20 + 'TASK edit')
            print(edit_task)

        params = {
            'Model[Name]': 'New edit test task',
            #'Model[Deadline]': '2011-02-05 12:00',
            #'Model[DeadlineDate]': '2011-02-05',
            #'Model[DeadlineType]': 'soft',
            'Model[Responsible]': self.self_id,
            #'Model[Executors]': '0',
            #'Model[Auditors]': '0',
            #'Model[Severity]': '1',
            #'Model[SuperTask]': '0',
            #'Model[Customer]': '0',
            #'Model[Owner]': '',
            'Model[Statement]': 'Edit new test task from Python'
        }
        self.mplan.TaskEdit(self.task_id, **params)
        task_card = self.mplan.TaskCard(self.task_id).data['task']
        self.assertEqual(task_card['Name'], 'New edit test task')

    def TaskAction(self):
        def Print(task_action):
            print('********' * 10)
            print(' ' * 20 + 'TASK action')
            print(task_action.params)

        task_action = self.mplan.TaskAction(self.task_id, 'act_accept_task')
        self.assertNotEqual(task_action, None)
        Print(task_action)

    def TaskAvailableActions(self):

        def Print(actions):
            print('********' * 10)
            print(' ' * 20 + 'TASK available actions')
            print(actions.actions)
            print(actions.params)
            print('--------' * 10)

        actions = self.mplan.TaskAvailableActions(self.task_id)
        self.assertNotEqual(actions, None)
        Print(actions)

    def TaskMarkAsFavorite(self):
        def Print():
            print('********' * 10)
            print(' ' * 20 + 'TASK mark as favorite')

        self.mplan.TaskMarkAsFavorite(self.task_id, True)
        self.assertNotEqual(
            [task['Id'] for task in self.mplan.Favorites().data['Tasks']
                if task['Id'] == self.task_id],
            None)
        Print()

    def Projects(self):

        def Print(projects):
            print('********' * 10)
            for project in projects:
                print('--------' * 10)
                self.PrintDict(project)

        projects = self.mplan.Projects().data['projects']
        self.assertNotEqual(projects, None)
        Print(projects)

    def ProjectCard(self):
        pass

    def ProjectCreate(self):
        pass

    def ProjectEdit(self):
        pass

    def ProjectAction(self):
        pass

    def ProjectMarkAsFavorite(self):
        pass

    def Severities(self):

        def Print(severities):
            print('********' * 10)
            print(' ' * 20 + 'SEVERITY')
            for severity in severities:
                print('--------' * 10)
                self.PrintDict(severity)

        severities = self.mplan.Severities().data['severity']
        self.assertNotEqual(severities, None)
        Print(severities)

    def Employees(self):

        def Print(employees):
            print('********' * 10)
            print(' ' * 20 + 'EMPLOYEES')
            for employee in employees:
                print('--------' * 10)
                self.PrintDict(employee)

        employees = self.mplan.Employees().data['employees']
        self.assertNotEqual(employees, None)
        Print(employees)

    def EmployeeCard(self):

        def Print(employee_card):
            print('********' * 10)
            print(' ' * 20 + 'EMPLOYEE card')
            self.PrintDict(employee_card)

        employee_card = self.mplan.EmployeeCard(self.self_id).data['employee']
        self.assertNotEqual(employee_card, None)
        Print(employee_card)

    def EmployeeCreate(self):
        pass

    def EmployeeEdit(self):
        pass

    def Comments(self):
        """
        """
        pass

    def CommentCreate(self):
        pass

    def Departments(self):
        pass

    def Search(self):
        obj = self.mplan.Search(self.my_name)
        self.self_id = obj.data['Employees'][0]['Id']

    def test_Megaplan(self):
        self.Search()
        self.TaskCreate()
        self.TaskEdit()
        self.Tasks()
        self.TaskCard()
        self.TaskAvailableActions()
        self.TaskAction()
        self.TaskAvailableActions()
        self.TaskMarkAsFavorite()

        self.Employees()
        self.EmployeeCard()

        self.Projects()


if __name__ == '__main__':
    unittest.main()
