"""
`megrok.pagetemplate` allows you to register IPageTemplate components as
multiadapter. It adapts a view and a request. As any adapting component,
it can be registered using a name. This name allows you to register several
templates for a given view, without conflict.

   >>> import grokcore.component.testing


Let's create a page template component, as we did previously. The only change
here will be to add the 'name' directive.

   >>> from zope.pagetemplate.interfaces import IPageTemplate
   
   >>> class Template(megrok.pagetemplate.PageTemplate):
   ...     grokcore.viewlet.view(View)
   ...     grokcore.viewlet.name('first')
   ...     grokcore.view.template('test')

   >>> grokcore.component.testing.grok_component('one', Template)
   True


As it's registered, we can not query it :

   >>> from zope.publisher.browser import TestRequest
   >>> from zope.component import queryMultiAdapter
   
   >>> request = TestRequest()
   >>> view = View(Context(), request)
   >>> pt = queryMultiAdapter((view, request), IPageTemplate, name='first')
   >>> print pt
   <megrok.pagetemplate.components.ViewPageTemplate object at ...>


Querying it without a name lead to an error, if no template is registered
for u'' :

   >>> print queryMultiAdapter((view, request), IPageTemplate)
   None


Now, we can register a second template, for the same view/request couple :

   >>> class AnotherTemplate(megrok.pagetemplate.PageTemplate):
   ...     grokcore.viewlet.view(View)
   ...     grokcore.viewlet.name('second')
   ...     grokcore.view.template('test')

   >>> grokcore.component.testing.grok_component('two', AnotherTemplate)
   True


We verify we can query both :

   >>> pt1 = queryMultiAdapter((view, request), IPageTemplate, name='first')
   >>> print pt1
   <megrok.pagetemplate.components.ViewPageTemplate object at ...>

   >>> pt2 = queryMultiAdapter((view, request), IPageTemplate, name='second')
   >>> print pt2
   <megrok.pagetemplate.components.ViewPageTemplate object at ...>

"""

import grokcore.view
import grokcore.viewlet 
import grokcore.component
import megrok.pagetemplate

grokcore.view.templatedir("templates")


class Context(grokcore.view.Context):
    """A context.
    """


class View(grokcore.view.View):
    """A very simple view.
    """
    grokcore.view.context(Context)

    def render(self):
        return u"Nothing here"
