from numpy.testing import assert_allclose
import numpy as np
from menpo.transform import R2LogR2RBF, R2LogRRBF

centers = np.array([[-1.0, -1.0], [-1, 1], [1, -1], [1, 1]])
points = np.array([[-0.4, -1.5], [-0.1, 1.1], [0.1, -2], [2.3, 0.3]])


def test_rbf_r2logr2_apply():
    result = R2LogR2RBF(centers).apply(points)
    expected = np.array([[-0.30152076, 12.48353795, 1.75251346, 17.2849475],
                         [8.62603644, -0.16272977, 9.70198395, 0.24259805],
                         [1.75251346, 23.72158352, 1.07392159, 22.4001763],
                         [31.8539218, 27.67453754, 4.1164199, 1.69892823]])
    assert_allclose(result, expected)


def test_rbf_r2logr2_jacobian():
    result = R2LogR2RBF(centers).jacobian_points(points)
    expected = np.array([[[0.60684441, -0.50570368],
                          [3.46630038, -14.44291827],
                          [-5.02037904, -1.79299252],
                          [-8.69498819, -15.52676462]],
                         [[4.77449532, 11.14048909],
                          [1.44278831, 0.16030981],
                          [-5.99792966, 11.45059299],
                          [-2.63747189, 0.23977017]],
                         [[3.94458353, -3.58598503],
                          [7.31140879, -19.94020579],
                          [-2.86798832, -3.18665369],
                          [-5.91012409, -19.70041364]],
                         [[23.31191446, 9.18348145],
                          [22.65025903, -4.8046004],
                          [5.76647684, 5.76647684],
                          [4.62624468, -2.49105483]]])
    assert_allclose(result, expected)


def test_rbf_r2logr_apply():
    result = R2LogRRBF(centers).apply(points)
    expected = np.array([[-0.15076038, 6.24176898, 0.87625673, 8.64247375],
                         [4.31301822, -0.08136488, 4.85099198, 0.12129902],
                         [0.87625673, 11.86079176, 0.53696079, 11.20008815],
                         [15.9269609, 13.83726877, 2.05820995, 0.84946412]])
    assert_allclose(result, expected)


def test_rbf_r2logr_jacobian():
    result = R2LogRRBF(centers).jacobian_points(points)
    expected = np.array([[[0.30342221, -0.25285184],
                          [1.73315019, -7.22145913],
                          [-2.51018952, -0.89649626],
                          [-4.34749409, -7.76338231]],
                         [[2.38724766, 5.57024454],
                          [0.72139416, 0.08015491],
                          [-2.99896483, 5.72529649],
                          [-1.31873594, 0.11988509]],
                         [[1.97229177, -1.79299252],
                          [3.6557044, -9.9701029],
                          [-1.43399416, -1.59332685],
                          [-2.95506205, -9.85020682]],
                         [[11.65595723, 4.59174073],
                          [11.32512951, -2.4023002],
                          [2.88323842, 2.88323842],
                          [2.31312234, -1.24552741]]])
    assert_allclose(result, expected)
