# Copyright (c) 2010 by Yaco Sistemas <msaelices@yaco.es>
#
# This file is part of Merengue.
#
# Merengue is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Merengue is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with Merengue.  If not, see <http://www.gnu.org/licenses/>.

from django.shortcuts import render_to_response
from django.template import RequestContext
from plugins.core.config import PluginConfig as CoreConfig
from merengue.base.models import BaseContent


def index(request):
    """ Index page """
    # put here your staff
    core_config = CoreConfig()
    main_content_index = int(core_config.get_config()['home_initial_content'].get_value())
    content = BaseContent.objects.get(pk=main_content_index)
    return render_to_response('website/index.html',
                              {'content': content},
                              context_instance=RequestContext(request))
