#!/usr/bin/env python
"""Distutils setup file, used to install or test 'merlin'"""

def get_description():
    # Get our long description from the documentation
    f = file('merlin.txt')
    lines = []
    for line in f:
        if not line.strip():
            break     # skip to first blank line
    for line in f:
        if line.startswith('.. contents::'):
            break     # read to table of contents
        lines.append(line)
    f.close()
    return ''.join(lines)

from distutils.util import convert_path
d = {}; execfile(convert_path('merlin/command/__init__.py'), d)
SETUP_COMMANDS = d['__all__']


VERSION = "1.8"
from merlin import setup, find_packages
import sys
scripts = []

setup(
    name = 'merlin', 
    version=VERSION,
    description="A custom version of Phillip J. Eby's setuptools.",
    author = 'Leif Strand',
    author_email = 'leif@geodynamics.org',
    license="PSF or ZPL",
    #long_description = get_description(),
    url = 'http://www.geodynamics.org/cig/software/packages/cs/pythia/',
    test_suite = 'merlin.tests',
    packages = find_packages(),
    package_data = {'merlin':['*.exe', '*.cfg']},

    py_modules = ['pkg_resources', 'site'],

    zip_safe = (sys.version>="2.5"),   # <2.5 needs unzipped for -m to work

    entry_points = {

        "merlin.distutils.commands" : [
            "%(cmd)s = merlin.command.%(cmd)s:%(cmd)s" % locals()
            for cmd in SETUP_COMMANDS
        ],

        "merlin.distutils.setup_keywords": [
            "eager_resources      = merlin.dist:assert_string_list",
            "namespace_packages   = merlin.dist:check_nsp",
            "extras_require       = merlin.dist:check_extras",
            "install_requires     = merlin.dist:check_requirements",
            "tests_require        = merlin.dist:check_requirements",
            "entry_points         = merlin.dist:check_entry_points",
            "test_suite           = merlin.dist:check_test_suite",
            "zip_safe             = merlin.dist:assert_bool",
            "package_data         = merlin.dist:check_package_data",
            "exclude_package_data = merlin.dist:check_package_data",
            "include_package_data = merlin.dist:assert_bool",
            "dependency_links     = merlin.dist:assert_string_list",
            "test_loader          = merlin.dist:check_importable",
        ],

        "merlin.egg_info.writers": [
            "PKG-INFO = merlin.command.egg_info:write_pkg_info",
            "requires.txt = merlin.command.egg_info:write_requirements",
            "entry_points.txt = merlin.command.egg_info:write_entries",
            "eager_resources.txt = merlin.command.egg_info:overwrite_arg",
            "namespace_packages.txt = merlin.command.egg_info:overwrite_arg",
            "top_level.txt = merlin.command.egg_info:write_toplevel_names",
            "depends.txt = merlin.command.egg_info:warn_depends_obsolete",
            "dependency_links.txt = merlin.command.egg_info:overwrite_arg",
        ],




        "console_scripts": [
             "merlin = merlin:main",
            ],

        "merlin.file_finders":
            ["svn_cvs = merlin.command.sdist:_default_revctrl"]
        },

#     classifiers = [f.strip() for f in """
#     Development Status :: 3 - Alpha
#     Intended Audience :: Developers
#     License :: OSI Approved :: Python Software Foundation License
#     License :: OSI Approved :: Zope Public License
#     Operating System :: OS Independent
#     Programming Language :: Python
#     Topic :: Software Development :: Libraries :: Python Modules
#     Topic :: System :: Archiving :: Packaging
#     Topic :: System :: Systems Administration
#     Topic :: Utilities""".splitlines() if f.strip()],
      scripts = scripts,

    # uncomment for testing
    # setup_requires = ['merlin>=0.6a0'],
)















