FIELD_PARAMETERS = ('readonly', 'deferred', 'sortable', 'operators')

DELETE = 'DELETE'
GET = 'GET'
POST = 'POST'
PUT = 'PUT'

HTTP_METHODS = (DELETE, GET, POST, PUT)

OK = 'OK'
CREATED = 'CREATED'
ACCEPTED = 'ACCEPTED'
PARTIAL = 'PARTIAL'
BAD_REQUEST = 'BAD_REQUEST'
FORBIDDEN = 'FORBIDDEN'
NOT_FOUND = 'NOT_FOUND'
METHOD_NOT_ALLOWED = 'METHOD_NOT_ALLOWED'
INVALID = 'INVALID'
TIMEOUT = 'TIMEOUT'
CONFLICT = 'CONFLICT'
GONE = 'GONE'
SERVER_ERROR = 'SERVER_ERROR'
UNIMPLEMENTED = 'UNIMPLEMENTED'
UNAVAILABLE = 'UNAVAILABLE'

STATUS_CODES = (OK, CREATED, ACCEPTED, PARTIAL, BAD_REQUEST, FORBIDDEN, NOT_FOUND,
    METHOD_NOT_ALLOWED, INVALID, CONFLICT, TIMEOUT, GONE, SERVER_ERROR, UNIMPLEMENTED,
    UNAVAILABLE)
VALID_STATUS_CODES = (OK, CREATED, ACCEPTED, PARTIAL)

JSON = 'application/json'
URLENCODED = 'application/x-www-form-urlencoded'

__all__ = [name for name in locals().keys() if name.upper() == name and not name.startswith('_')]
