
from __future__ import print_function
#
# 2011 Oceanea Road Champs -> Alge DLINE handler
# for road and irtt
#
# problematic and deprecated.
#
# "D-Line" display terminal. Reads from the announce channel
#  and outputs formatted text to stdout
#
# connects to IRC to receive UNT4 announce msg packs
#
# Notes:
#	- does not _yet_ do live stream negotiation
#	- server, port, channel, nick config via consts
#
# TODO:
#	- config and defaults

import pygtk
pygtk.require("2.0")

import irclib
import sys
import random
import serial

from metarace import unt4
from metarace import tod


# Global Defaults
USCBSRV_HOST='localhost'
USCBSRV_PORT=6667
USCBSRV_CHANNEL='#announce'
USCBSRV_SRVNICK='uscbsrv'
USCBSRV_CLTNICK='dlan_'+str(random.randint(100,999))
SERIAL_PORT='/dev/ttyUSB3'

# Config filename
CONFIGFILE='dline_announce.ini'

# read buffer

sp = SERIAL_PORT
if len(sys.argv) > 1 and sys.argv[1] != '':
    sp = sys.argv[1]
sp = serial.Serial(sp, 2400)

def debug(msg):
    """Emit message to stderr."""
    print (str(msg), file=sys.stderr)

def nicknameinuse_cb(c, e):
    """Handle nickname collision."""
    debug('Error: Nickname in use.')
    sys.exit(1)

def channel_join_cb(c, e):
    """Register channel join."""
    tg = e.target().lower()
    debug('Joined channel: ' + repr(tg))
        
def channel_part_cb(c, e):
    """Register channel part."""
    tg = e.target().lower()
    debug('Left channel: ' + repr(tg))
        
def todstr2dline(todstr):
    """Convert a UNT4 packet to a DLINE message."""
    rt = tod.str2tod(todstr)
    ret = ''
    if rt is not None:
        ret = 'A        '+rt.rawtime(places=0, hoursep=':', minsep=':').rjust(8)
    else:
        ret = 'A'
    return ret + chr(0x0d)
    
def riderline2dline(msg):
    """Convert a standard road announce rider line to a DLINE message."""
    ret = 'B'
    sr = msg.split(chr(unt4.US))
    if len(sr) == 5:
        rts = ''
        rt = tod.str2tod(sr[4])
        if rt is not None:
            rts = rt.rawtime(places=2, hoursep=':', minsep=':')
        rank = sr[0].rjust(2)
        bib = sr[1].rjust(3)
        ret += bib + '     ' + rts.rjust(11) + ' ' + rank
    return ret + chr(0x0d)

def unt_msg_cb(c, e):
    """Handle a message packet."""
    su = irclib.nm_to_n(e.source()).lower()
    tg = e.target().lower()
    if su == USCBSRV_SRVNICK and tg == USCBSRV_CHANNEL:
        # Have a 'broadcast' packet ... append and then search
        rdbuf = unt4.decode(''.join(e.arguments()))
        idx = rdbuf.find(chr(unt4.EOT))
        if idx >= 0:
            msgtxt = rdbuf[0:idx+1]
            rdbuf = rdbuf[idx+1:]
            mpack = unt4.unt4(unt4str=msgtxt)
            if mpack.header == 'time':
                sp.write(todstr2dline(mpack.text))
            elif mpack.header == 'finish':
                sp.write(riderline2dline(mpack.text))
            elif mpack.erp:
                pass
                #sp.write(todstr2dline(''))

# run single-threaded...

ih = irclib.IRC()
ic = ih.server()
ic.add_global_handler('pubmsg', unt_msg_cb, -10)
ic.add_global_handler('pubnotice', unt_msg_cb, -10)
ic.add_global_handler('join', channel_join_cb, -10)
ic.add_global_handler('part', channel_part_cb, -10)
ic.add_global_handler('kick', channel_part_cb, -10)
ic.add_global_handler('nicknameinuse', nicknameinuse_cb, -10)
# 3: process_forever
ic.connect(USCBSRV_HOST, USCBSRV_PORT, USCBSRV_CLTNICK)
ic.join(USCBSRV_CHANNEL)
ih.process_forever()
# 4: cleanup
sys.exit()
