--
-- Metarace 1.6 combined cycling database dump schema for MySQL
--
-- Data is output to the single table 'Cycling' which uses overloaded
-- columns and a combination of Event, Type and Class ids to identify
-- the information. Please see thr accompanying document for details.
--

DROP TABLE IF EXISTS `Cycling`;
CREATE TABLE `Cycling` (
  `RowID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `SortOrder` int(11) NOT NULL DEFAULT '0',
  `TypeID` varchar(255) NOT NULL,
  `ClassID` varchar(255) DEFAULT NULL,
  `StatusID` varchar(255) DEFAULT NULL,
  `EventID` varchar(255) DEFAULT NULL,
  `Series` varchar(255) DEFAULT NULL,
  `Data0` varchar(255) DEFAULT NULL,
  `Data1` varchar(255) DEFAULT NULL,
  `Data2` varchar(255) DEFAULT NULL,
  `Data3` varchar(255) DEFAULT NULL,
  `Data4` varchar(255) DEFAULT NULL,
  `Data5` varchar(255) DEFAULT NULL,
  `Data6` varchar(255) DEFAULT NULL,
  `Data7` varchar(255) DEFAULT NULL,
  `Data8` varchar(255) DEFAULT NULL,
  `Data9` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`RowID`),
  UNIQUE KEY `RowID` (`RowID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP VIEW IF EXISTS `Timing`;
CREATE VIEW `Timing` AS 
SELECT
  `EventID`,
  `ClassID` AS `Key`,
  `Data0` AS `Value`, 
  `Data1` AS `Hint`
FROM `Cycling`
WHERE `TypeID`='Timing';

DROP VIEW IF EXISTS `Results`;
CREATE VIEW `Results` AS
SELECT
  `EventID`,
  `ClassID`,
  `Series`,
  `Data0` AS `Rank`,
  `Data1` AS `RiderNO`,
  `Data2` AS `First`,
  `Data3` AS `Last`,
  `Data4` AS `Team`,
  `Data5` AS `Cat`,
  `Data6` AS `Nation`,
  `Data7` AS `Info`
FROM `Cycling`
WHERE `TypeID`='Result';

