# -*- coding: utf-8 -*-
'''
.. highlight:: perl


############################
Acme::MetaSyntactic::dancers
############################

****
NAME
****


Acme::MetaSyntactic::dancers - The dancers theme


***********
DESCRIPTION
***********


This is the list of dancers available on my wife's web pages:
`http://www.cmi.univ-mrs.fr/~esouche/dance/ <http://www.cmi.univ-mrs.fr/~esouche/dance/>`_.

This module is a small gift to my wife Estelle Souche, who created one
of the first web pages about ballet on the world-wide web, back in 1995.

By no mean is this an exhaustive list: it is just the collected list
of dancers that appears on several pages of her site.


***********
CONTRIBUTOR
***********


Philippe "BooK" Bruhat.

Introduced in version 0.12, published on March 7, 2005.

Patched to contain valid identifiers in version 0.15,
published on March 28, 2005.


********
SEE ALSO
********


`Acme::MetaSyntactic <http://search.cpan.org/search?query=Acme%3a%3aMetaSyntactic&mode=module>`_, `Acme::MetaSyntactic::List <http://search.cpan.org/search?query=Acme%3a%3aMetaSyntactic%3a%3aList&mode=module>`_.


****************
PRIVATE MESSAGES
****************


Happy birthday!

\ ``Philippe <3 Estelle.``\ 
'''

name = 'dancers'
DATA = '''\
# names
Agnes_Letestu
Alessio_Carbone
Alexandra_Cardinale
Alexandre_Kalioujny
Alexis_Renaud
Alexis_Saramite
Alice_Renavand
Amelie_Lamoureux
Anna_Pavlova
Anne_Duquenoy
Arnaud_Dreyfus
Attilio_Labis
Aurelia_Bellet
Aurelie_Dupont
Aurore_Cordellier
Beatrice_Martel
Benedicte_Cardon
Benjamin_Pech
Bertrand_Barena
Bertrand_Belem
Brigitte_Hermetz
Bruno_Bouche
Bruno_Cauhape
Bruno_Lehaut
Carlotta_Grisi
Carole_Arbo
Carole_Maison
Caroline_Bance
Caroline_Robert
Cecile_Passemard
Cecile_Sciaux
Celine_Palacio
Celine_Talon
Charles_Jude
Christelle_Granier
Christiane_Vaussard
Christiane_Vlassi
Christian_Mesnier
Christine_Peltzer
Christophe_Duquenne
Claire_Marie_Osta
Claire_Motte
Clara_Delfino
Claude_Bessy
Claude_de_Vulpian
Claudette_Scouarnec
Clotilde_Vayer
Cyril_Atanassoff
Cyril_Fleury
Danielle_Doussard
Delphine_Baey
Delphine_Moussin
Dominique_Khalfouni
Eddy_Richoux
Eleonora_Abbagnato
Elisabeth_Maurin
Elisabeth_Platel
Emilie_Cozette
Emmanuel_Thibault
Eric_Camillo
Eric_Monin
Eric_Quillere
Erik_Bruhn
Erwann_Leroux
Eve_Grinsztajn
Fabien_Roques
Fanny_Fiat
Fanny_Gaida
Flemmimg_Flindt
Florence_Branca
Florence_Clerc
Florence_Lambert
Francoise_Legree
Frederic_David
Geraldine_Wiart
Ghislaine_Fallou
Ghislaine_Reichert
Ghislaine_Thesmar
Gilbert_Mayer
Gil_Isoart
Gilles_Porte
Gregory_Gaillard
Guillaume_Charlot
Gwenaelle_Vauthier
Herve_Courtain
Herve_Dirmann
Herve_Moreau
Isabelle_Ciaravola
Isabelle_Guerin
Jacqueline_Rayet
Jacques_Namont
Jean_Christophe_Guerri
Jean_Claude_Ciappara
Jean_Francois_Creteaux
Jean_Guillaume_Bart
Jean_Guizerix
Jean_Hugues_Tanto
Jean_Marie_Didiere
Jean_Philippe_Dury
Jean_Pierre_Bonnefous
Jean_Pierre_Franchetti
Jean_Sebastien_Colau
Jean_Yves_Lormeau
Jeremie_Belingard
Jose_Martinez
Josette_Amiel
Josyane_Consoli
Juliane_Mathis
Julie_Martel
Julien_Lestel
Julien_Meyzindi
Juliette_Gernez
Kader_Belarbi
Karin_Averty
Karine_Villagrassa
Karl_Paquette
Laetitia_Pujol
Laure_Muret
Laurence_Laffon
Laurent_Hilaire
Laurent_Novis
Laurent_Queval
Lionel_Delanoe
Lise_Marie_Jourdain
Lucie_Clement
Ludovic_Heiden
Lycette_Darsonval
Mallory_Gaudion
Manuel_Legris
Margot_Fonteyn
Maria_Tallchief
Marie_Agnes_Gillot
Marie_Claude_Maniglier
Marie_Claude_Pietragalla
Marie_Elise_Ropers
Marie_Gaelle_Communal
Marie_Isabelle_Peracchi
Marie_Solenne_Boulet
Marjorie_Tallchief
Maur_Riviere
Max_Bozzoni
Melanie_Hurel
Melissa_Hayden
Michael_Denard
Michel_Berges
Michel_Renault
Mirentchu_Battut
Miteki_Kudo
Monique_Loudieres
Muriel_Halle
Muriel_Zusperreguy
Myriam_Kamionka
Myriam_Naceri
Nanon_Thibon
Natacha_Gilles
Nathalie_Aubin
Nathalie_Jacquel
Nathalie_Quernet
Nathalie_Rique
Nathalie_Vandard
Nathalie_Ziegler
Nicolas_Le_Riche
Nicolas_Noel
Nicolas_Paul
Noella_Pontois
Noemie_Djiniadhis
Nolwenn_Daniel
Olga_Spessivtseva
Olivier_Patey
Pascal_Aubin
Pascal_Vermeeren
Patrice_Bart
Patrice_Petit
Patrick_Dupond
Peggy_Grelat
Peter_Van_Dijk
Philippe_Gerbet
Pierina_Legnani
Pierre_Darde
Pierre_Francois_Vilanoba
Pierre_Retif
Rachel_Rufer
Richard_Wilk
Romain_Schott
Sandrine_Henault
Sandrine_Marache
Sebastien_Thill
Serge_Peretti
Severine_de_Cussac
Severine_Westermann
Solange_Schwartz
Sophie_Boulineau
Stephane_Bullion
Stephane_Elizabe
Emmanuel_Hoff
Stephane_Phavorin
Stephane_Prince
Stephanie_Rodighiero
Stephanie_Romberg
Suzanne_Lorcia
Sylvie_Clavier
Sylvie_Guillem
Tamara_Karsavina
Tanaquil_LeClercq
Thierry_Mongne
Valery_Colin
Vanessa_Legassy
Vaslaw_Nijinsky
Veronique_Cabiac
Veronique_Doisneau
Vincent_Cordier
Violette_Verdy
Virgine_Rousseliere
Virginia_Gris
Wilfride_Piollet
Wilfried_Romoli
Xavier_Lootgieter
Yann_Bridard
Yann_Saiz
Youly_Alagaroff
Yvette_Chauvire\
'''

from metasyntactic.base import parse_data
from random import choice, shuffle
data = parse_data(DATA)


def default():
    try:
        if 'default' in data:
            return data['default'][0]
    except KeyError, IndexError:
        pass
    return 'en'


def all():
    acc = set()
    for category, names in data['names'].iteritems():
        if names:
            acc |= names
    return acc


def names(category=None):
    if not category:
        category = default()
    if category == ':all':
        return list(all())
    return list(data['names'][category])


def random(n=1, category=None):
    got = names(category)
    if got:
        shuffle(got)
        if n == 1:
            return choice(got)
        return got[:n]

def sections():
    return set(data['names'].keys())


