# -*- coding: utf-8 -*-
'''
.. highlight:: perl


##########################
Acme::MetaSyntactic::robin
##########################

****
NAME
****


Acme::MetaSyntactic::robin - The Robin theme


***********
DESCRIPTION
***********


Robin's exclamations, from the Batman 60's serial (this serial's a great
source of sill^Wmetasyntactical stuff).

The list of Robin's exclamations comes from this page:
`http://members.tripod.com/~AdamWest/robin.htm <http://members.tripod.com/~AdamWest/robin.htm>`_.

Robin's exclamations are also recorded here, with additional details:
`http://www.usfamily.net/web/wpattinson/otr/batman/batholy.htm <http://www.usfamily.net/web/wpattinson/otr/batman/batholy.htm>`_.


***********
CONTRIBUTOR
***********


Philippe "BooK" Bruhat.

Introduced in version 0.03, published on January 14, 2005.

Duplicates removed in version 0.15, published on March 28, 2005.


********
SEE ALSO
********


`Acme::MetaSyntactic <http://search.cpan.org/search?query=Acme%3a%3aMetaSyntactic&mode=module>`_, `Acme::MetaSyntactic::List <http://search.cpan.org/search?query=Acme%3a%3aMetaSyntactic%3a%3aList&mode=module>`_.
'''

name = 'robin'
DATA = '''\
# names
holy_uncanny_photographic_mental_processes
holy_priceless_collection_of_Etruscan_snoods
holy_contributing_to_the_delinquency_of_minors
holy_journey_to_the_center_of_the_earth
holy_agility                       holy_alphabet
holy_Alps                          holy_alter_ego
holy_anagrams                      holy_apparition
holy_armadilloes                   holy_armour_plate
holy_ashtray                       holy_asp
holy_astringent_plum_like_fruit    holy_astronomy
holy_autobon                       holy_backfire
holy_ball_and_chain                holy_bank_deposits
holy_bankruptcy                    holy_banks
holy_bargain_basements             holy_barracuda
holy_bat_logic                     holy_bat_trap
holy_Benedict_Arnold               holy_bijou
holy_Bill_of_Rights                holy_birthday_cake
holy_Blackbeard                    holy_blackout
holy_blank_cartridge               holy_blizzard
holy_bluebeard                     holy_bouncing_boiler_plated_fits
holy_bulls_eye                     holy_bunyons
holy_caffeine                      holy_camouflage
holy_Caruso                        holy_catastrophe
holy_cats                          holy_chicken_coop
holy_chillblaines                  holy_chocolate_eclair
holy_Cinderella                    holy_cinemascope
holy_cliche                        holy_cliffhangers
holy_clockwork                     holy_cold_creeps
holy_complications                 holy_conflagration
holy_corpusles                     holy_cosmos
holy_crack_up                      holy_crossfire
holy_crucial_moment                holy_cryptology
holy_crystal_ball                  holy_dart
holy_Davey_Jones                   holy_dead_end
holy_deposit_slip                  holy_detonation
holy_detonator                     holy_deviltry
holy_dilemna                       holy_disappearing_act
holy_distortion                    holy_diversionary_tactics
holy_eggshells                     holy_Einstein
holy_encore                        holy_epicure
holy_epigrams                      holy_escape_hatch
holy_explosion                     holy_false_front
holy_fate_worse_than_death         holy_felony
holy_finishing_touches             holy_fireworks
holy_firing_squad                  holy_fishbowl
holy_flight_plan                   holy_flip_flop
holy_floodgate holy_floor_covering holy_flypaper
holy_fly_trap                      holy_fog
holy_forecast                      holy_fork_in_the_road
holy_Fourth_Amendment              holy_Fourth_of_July
holy_Frankenstein                  holy_fratricide
holy_fruit_salad                   holy_fugitives
holy_funny_bone                    holy_gall
holy_gambles                       holy_gemini
holy_geography                     holy_ghost_writer
holy_giveaways                     holy_Golden_Gate
holy_graft_zepplin                 holy_grammar
holy_graveyard                     holy_greed
holy_green_card                    holy_guacamole
holy_gullibility                   holy_gunpowder
holy_haberdashery                  holy_hailstorms
holy_hairdo                        holy_hallelujah
holy_hamburger                     holy_Hamlet
holy_hamstrings                    holy_handiwork
holy_happenstance                  holy_hardest_metal_in_the_world
holy_harem                         holy_haziness
holy_headache                      holy_headlines
holy_heartbreak                    holy_heart_failure
holy_helmets                       holy_helplessness
holy_here_we_go_again              holy_hidal_burn
holy_hieroglyphics                 holy_high_wire
holy_hijack                        holy_hijackers
holy_history                       holy_hoaxes
holy_hole_in_a_donut               holy_Hollywood
holy_holocaust                     holy_homecoming
holy_homework                      holy_homicide
holy_hood_wink                     holy_hoofbeats
holy_horseshoes                    holy_hostage
holy_hot_foot                      holy_hot_spot
holy_Houdini                       holy_human_collector_s_item
holy_human_pearlS
holy_human_pressure_cookers        holy_human_surfboards
holy_hunting_horn                  holy_hurricane
holy_hutzpah                       holy_hydraulics
holy_hyperdermics                  holy_hypnotism
holy_hypotheses                    holy_iceberg
holy_icepicks                      holy_ice_skates
holy_impossibility                 holy_impregnability
holy_incantation                   holy_inquisition
holy_interplanetary_yard_stick     holy_interruptions
holy_iodine                        holy_IT_n_T
holy_Jack_in_the_Box               holy_jackpot
holy_jail_break                    holy_jawbreaker
holy_jelly_moulds                  holy_jet_set
holy_jetset                        holy_jigsaw_puzzle
holy_jitterbug                     holy_karate
holy_karats                        holy_keyhole
holy_keyring                       holy_kilowatts
holy_kindergarten                  holy_knit_one_pearl_two
holy_knockout_drops                holy_known_flying_objects
holy_Koufax                        holy_Las_Vegas
holy_levitation                    holy_living_end
holy_lodestone                     holy_looking_glass
holy_love_birds                    holy_Luthor_Burbank
holy_madness                       holy_magician
holy_mainframe                     holy_mashed_potatoes
holy_masked_potatoes               holy_masquerade
holy_matador                       holy_mechanical_armies
holy_mechanical_marvel             holy_memory_bank
holy_mermaid                       holy_mesmerism
holy_metronome                     holy_miracle
holy_miscast                       holy_missing_relatives
holy_molars                        holy_Motor_Von_Bon
holy_movie_moguls                  holy_mucelage
holy_multitudes                    holy_murder
holy_mush                          holy_naivete
holy_nerve_center                  holy_New_Year_s_Eve
holy_nick_of_time                  holy_nightmare
holy_non_sequiturs                 holy_oil_factory
holy_olee_o                        holy_olfactory
holy_one_track_batcomputer_mind    holy_ordeuvres
holy_oversight                     holy_oxygen
holy_paraffin                      holy_Parefski
holy_perfect_pitch                 holy_piano
holy_pin_cushions                  holy_polar_front
holy_polar_ice_sheet               holy_popcorn
holy_precision                     holy_pseudonym
holy_purple_cannibals              holy_puzzlers
holy_rainbow
holy_rats_in_a_trap                holy_rat_trap
holy_ravioli                       holy_razor_s_edge
holy_recompense                    holy_red_herring
holy_red_snapper                   holy_reincarnation
holy_relief                        holy_remote_control_robot
holy_resourcefulness               holy_return_from_oblivion
holy_reverse_polarity              holy_rheostat
holy_ricochet                      holy_riot_ball
holy_Rip_Van_Winkle                holy_rising_headlights
holy_rising_hemlines               holy_roadblocks
holy_Robert_Louis_Stevenson        holy_rock_garden
holy_rocking_chair                 holy_Romeo_and_Juliet
holy_rudder                        holy_safari
holy_sarcophagus                   holy_schizophrenia
holy_seditives                     holy_self_service
holy_semantics                     holy_serpentine
holy_sewer_pipe                    holy_shamrocks
holy_Sherlock_Holmes               holy_showcase
holy_show_ups                      holy_shrinkage
holy_shucks                        holy_skull_tap
holy_skyrocket                     holy_slipped_disc
holy_smoke                         holy_smokestack
holy_snowball                      holy_sonic_booms
holy_special_delivery              holy_spiderwebs
holy_split_seconds                 holy_squirrel_cage
holy_stalactites                   holy_stampede
holy_standstills                   holy_stereo
holy_stewpot                       holy_stomach_ache
holy_straightjacket                holy_stratosphere
holy_stuffing                      holy_sub_orbit
holy_sudden_incapacitation         holy_sun_dial
holy_surprise_parties              holy_switcheroo
holy_Taj_Mahal                     holy_tartars
holy_taxadermy                     holy_taxation
holy_taxidermy                     holy_tee_shot
holy_ten_toes                      holy_terminology
holy_timebomb                      holy_tintanabulation
holy_tipoff                        holy_Titanic
holy_tome                          holy_toreador
holy_trampoline                    holy_transistors
holy_trasitor_s_bill               holy_travel_agent
holy_trickery                      holy_triple_feat
holy_trolls_and_goblins            holy_tuxedo
holy_understatements               holy_underwritten_metropolis
holy_unknown_flying_objects        holy_unlikelihood
holy_unrefillable_prescriptions    holy_vacuum
holy_Venuzuela                     holy_vertebra
holy_voltage                       holy_waste_of_energy
holy_Wayne_Manor                   holy_weaponry
holy_wedding_cake                  holy_whiskers
holy_wigs                          holy_Zorro\
'''

from metasyntactic.base import parse_data
from random import choice, shuffle
data = parse_data(DATA)


def default():
    try:
        if 'default' in data:
            return data['default'][0]
    except KeyError, IndexError:
        pass
    return 'en'


def all():
    acc = set()
    for category, names in data['names'].iteritems():
        if names:
            acc |= names
    return acc


def names(category=None):
    if not category:
        category = default()
    if category == ':all':
        return list(all())
    return list(data['names'][category])


def random(n=1, category=None):
    got = names(category)
    if got:
        shuffle(got)
        if n == 1:
            return choice(got)
        return got[:n]

def sections():
    return set(data['names'].keys())


